% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb.save.raw.R
\name{xgb.save.raw}
\alias{xgb.save.raw}
\title{Save XGBoost model to R's raw vector}
\usage{
xgb.save.raw(model, raw_format = "ubj")
}
\arguments{
\item{model}{The model object.}

\item{raw_format}{The format for encoding the booster:
\itemize{
\item "json": Encode the booster into JSON text document.
\item "ubj":  Encode the booster into Universal Binary JSON.
\item "deprecated": Encode the booster into old customized binary format.
}}
}
\description{
Save XGBoost model from \code{\link[=xgboost]{xgboost()}} or \code{\link[=xgb.train]{xgb.train()}}.
Call \code{\link[=xgb.load.raw]{xgb.load.raw()}} to load the model back from raw vector.
}
\examples{
\dontshow{RhpcBLASctl::omp_set_num_threads(1)}
data(agaricus.train, package = "xgboost")
data(agaricus.test, package = "xgboost")

## Keep the number of threads to 1 for examples
nthread <- 1
data.table::setDTthreads(nthread)

train <- agaricus.train
test <- agaricus.test

bst <- xgb.train(
  data = xgb.DMatrix(train$data, label = train$label, nthread = 1),
  nrounds = 2,
  params = xgb.params(
    max_depth = 2,
    nthread = nthread,
    objective = "binary:logistic"
  )
)

raw <- xgb.save.raw(bst)
bst <- xgb.load.raw(raw)

}
