/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.movie;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import org.web3d.image.NIOBufferImage;
import org.web3d.image.NIOBufferImageType;
import org.web3d.vrml.renderer.common.input.movie.Renderer;
import org.web3d.vrml.renderer.common.input.movie.VideoStreamHandler;

public class VideoRenderer
extends Renderer
implements javax.media.renderer.VideoRenderer {
    private VideoFormat[] supportedFormats;
    private NIOBufferImage image;
    private int imageWidth;
    private int imageHeight;
    private int imageLineStride;
    private VideoStreamHandler streamHandler;
    private boolean started;
    private boolean callbacksEnabled = true;

    public VideoRenderer(VideoStreamHandler videoStreamHandler) {
        this.streamHandler = videoStreamHandler;
        this.started = false;
        int n = 0xFF0000;
        int n2 = 65280;
        int n3 = 255;
        RGBFormat rGBFormat = new RGBFormat(null, -1, int[].class, -1.0f, 32, n, n2, n3, 1, -1, 0, -1);
        this.supportedFormats = new VideoFormat[1];
        this.supportedFormats[0] = rGBFormat;
    }

    public void enableCallbacks(boolean bl) {
        this.callbacksEnabled = bl;
    }

    public String getName() {
        return "Xj3D Video Renderer";
    }

    public Component getComponent() {
        return null;
    }

    public boolean setComponent(Component component) {
        return false;
    }

    public void setBounds(Rectangle rectangle) {
    }

    public Rectangle getBounds() {
        return null;
    }

    public Format setInputFormat(Format format) {
        RGBFormat rGBFormat = (RGBFormat)format;
        Dimension dimension = rGBFormat.getSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        this.imageLineStride = rGBFormat.getLineStride();
        if (this.image == null || n != this.imageWidth || n2 != this.imageHeight) {
            this.imageWidth = n;
            this.imageHeight = n2;
            this.image = new NIOBufferImage(this.imageWidth, this.imageHeight, NIOBufferImageType.RGB);
            this.streamHandler.videoStreamFormat(this.imageWidth, this.imageHeight);
        }
        RGBFormat rGBFormat2 = new RGBFormat(dimension, rGBFormat.getMaxDataLength(), rGBFormat.getDataType(), rGBFormat.getFrameRate(), rGBFormat.getBitsPerPixel(), rGBFormat.getRedMask(), rGBFormat.getGreenMask(), rGBFormat.getBlueMask(), rGBFormat.getPixelStride(), rGBFormat.getLineStride(), 0, rGBFormat.getEndian());
        return rGBFormat2;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public int process(Buffer buffer) {
        int[] nArray = (int[])buffer.getData();
        if (nArray != null) {
            ByteBuffer byteBuffer = this.image.getBuffer();
            int n = this.imageHeight - 1;
            for (int i = 0; i < this.imageHeight; ++i) {
                int n2 = n * this.imageWidth;
                for (int j = 0; j < this.imageWidth; ++j) {
                    int n3 = nArray[n2 + j];
                    byteBuffer.put((byte)(n3 >> 16 & 0xFF));
                    byteBuffer.put((byte)(n3 >> 8 & 0xFF));
                    byteBuffer.put((byte)(n3 & 0xFF));
                }
                --n;
            }
            this.streamHandler.videoStreamFrame(this.image);
        }
        return 0;
    }

    public void stop() {
        if (this.callbacksEnabled && this.started) {
            this.started = false;
            this.streamHandler.videoStreamStop();
        }
    }

    public void start() {
        if (this.callbacksEnabled && !this.started) {
            this.started = true;
            this.streamHandler.videoStreamStart();
        }
    }
}

