/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.ResourceManager;
import org.ietf.uri.URC;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStream;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URN;
import org.ietf.uri.UnsupportedServiceException;

public final class URL
extends URI
implements Serializable {
    private String url_string = null;
    private String path = null;
    private String query = null;
    private String reference = null;
    private String host = null;
    private int port = -1;
    private String user_info = null;
    private String scheme = null;
    private int hash_code = -1;
    private String external_form = null;
    private boolean generic_url = false;

    public URL(String string, String string2, int n, String string3) throws MalformedURLException {
        this.scheme = string;
        this.host = string2;
        this.port = n == -1 ? URIUtils.getDefaultPort(this.scheme) : n;
        String[] stringArray = URIUtils.stripFile(string3);
        this.path = stringArray[0];
        this.query = stringArray[1];
        this.reference = stringArray[2];
    }

    public URL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, -1, string3);
    }

    public URL(String string) throws MalformedURLException {
        this.scheme = URIUtils.getScheme(string);
        if (this.scheme == null) {
            throw new MalformedURLException("No protocol scheme defined");
        }
        String[] stringArray = URIUtils.getHostAndPortFromUrl(string);
        if (stringArray != null) {
            this.host = stringArray[0];
            this.port = stringArray[1] == null ? 0 : Integer.parseInt(stringArray[1]);
            this.generic_url = false;
        } else {
            this.generic_url = true;
        }
        this.path = URIUtils.getPathFromUrlString(string);
        this.query = URIUtils.getQueryFromUrlString(string);
        int n = string.lastIndexOf("#");
        if (n > -1) {
            this.reference = string.substring(n + 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL(URL uRL, String string) throws MalformedURLException {
        String string2 = null;
        String string3 = null;
        int n = 0;
        string2 = URIUtils.getScheme(string);
        if (string2 == null) {
            if (uRL == null) throw new MalformedURLException("No protocol specified");
            this.scheme = uRL.scheme;
        } else {
            this.scheme = string2;
            String[] stringArray = URIUtils.getHostAndPortFromUrl(string);
            if (uRL != null) {
                if (uRL.scheme.equalsIgnoreCase(string2)) {
                    string3 = uRL.host;
                    n = uRL.port;
                } else {
                    string3 = stringArray[0];
                    n = Integer.parseInt(stringArray[1]);
                }
            } else {
                string3 = stringArray[0];
                n = stringArray[1] == null ? 0 : Integer.parseInt(stringArray[1]);
            }
        }
        this.host = string3;
        this.port = n;
    }

    public URL(java.net.URL uRL) {
        this.scheme = uRL.getProtocol();
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        String[] stringArray = URIUtils.stripFile(uRL.getFile());
        this.path = stringArray[0];
        this.query = stringArray[1];
        this.reference = uRL.getRef();
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public String getFile() {
        return this.path;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRef() {
        return this.reference;
    }

    public boolean sameFile(URL uRL) {
        if (this.scheme == null || !this.scheme.equalsIgnoreCase(uRL.scheme)) {
            return false;
        }
        if (this.host == null && uRL.host == null || this.host != null && !this.host.equalsIgnoreCase(uRL.host)) {
            return false;
        }
        if (this.port != uRL.port) {
            return false;
        }
        return this.path != null && this.path.equals(uRL.path);
    }

    public ResourceConnection getResource() throws UnsupportedServiceException, IOException {
        URIResourceStream uRIResourceStream = ResourceManager.getProtocolHandler(this.scheme);
        if (uRIResourceStream == null) {
            throw new UnsupportedServiceException(this.scheme + " is not supported");
        }
        String string = this.query != null ? this.path + '?' + this.query : this.path;
        ResourceConnection resourceConnection = uRIResourceStream.openConnection(this.host, this.port, string);
        return resourceConnection;
    }

    public ResourceConnection[] getResourceList() throws UnsupportedServiceException, IOException {
        URIResourceStream uRIResourceStream = ResourceManager.getProtocolHandler(this.scheme);
        String string = this.query != null ? this.path + '?' + this.query : this.path;
        ResourceConnection resourceConnection = uRIResourceStream.openConnection(this.host, this.port, string);
        ResourceConnection[] resourceConnectionArray = new ResourceConnection[]{resourceConnection};
        return resourceConnectionArray;
    }

    public URL getURL() throws UnsupportedServiceException, IOException {
        return this;
    }

    public URL[] getURLList() throws UnsupportedServiceException, IOException {
        URL[] uRLArray = new URL[]{this};
        return uRLArray;
    }

    public URC getURC() throws UnsupportedServiceException, IOException {
        return null;
    }

    public URC[] getURCList() throws UnsupportedServiceException, IOException {
        return null;
    }

    public URN getURN() throws UnsupportedServiceException, IOException {
        return null;
    }

    public URN[] getURNList() throws UnsupportedServiceException, IOException {
        return null;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        if (this.external_form != null) {
            return this.external_form;
        }
        StringBuffer stringBuffer = new StringBuffer(this.scheme);
        if (!this.generic_url) {
            stringBuffer.append("://");
        } else {
            stringBuffer.append(':');
        }
        if (this.user_info != null) {
            stringBuffer.append(this.user_info);
            stringBuffer.append('@');
        }
        if (this.host != null) {
            stringBuffer.append(this.host);
        }
        if (this.port > 0) {
            stringBuffer.append(':');
            stringBuffer.append(this.port);
        }
        if (this.path != null) {
            stringBuffer.append(this.path);
        }
        if (this.query != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.query);
        }
        if (this.reference != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.reference);
        }
        this.external_form = stringBuffer.toString();
        return this.external_form;
    }

    public boolean equals(Object object) {
        if (object instanceof URI) {
            return this.equals((URI)object);
        }
        return false;
    }

    public boolean equals(URI uRI) {
        if (!(uRI instanceof URL)) {
            return false;
        }
        URL uRL = (URL)uRI;
        if (!this.sameFile(uRL)) {
            return false;
        }
        if (this.query != null && !this.query.equals(uRL.query) || this.query != uRL.query) {
            return false;
        }
        return (this.reference == null || this.reference.equals(uRL.reference)) && this.reference == uRL.reference;
    }

    public synchronized int hashCode() {
        if (this.hash_code != -1) {
            return this.hash_code;
        }
        int n = 0;
        if (this.scheme != null) {
            n += this.scheme.hashCode();
        }
        if (this.host != null) {
            n += this.host.hashCode();
        }
        if (this.path != null) {
            n += this.path.hashCode();
        }
        if (this.query != null) {
            n += this.query.hashCode();
        }
        if (this.reference != null) {
            n += this.reference.hashCode();
        }
        this.hash_code = n += this.port;
        return n;
    }
}

