/* Public domain. */

#include "avlnodebunch.h"
#include "avltree.h"

void avltree_free (avltree_ref t)
{
  t->cmp = 0 ;
  avlnodebunch_free(&t->x) ;
}

int avltree_init (avltree_ref t, int (*f) (unsigned int, unsigned int))
{
  avltree_free(t) ;
  if (!avlnodebunch_new(&t->x)) return 0 ;
  t->cmp = f ;
  avltree_setroot(t, 0) ;
  return 1 ;
}
