% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{matMaxs}
\alias{matMaxs}
\title{Row or Column Maximum Values of a Matrix}
\usage{
matMaxs(x, dim = 1)
}
\arguments{
\item{x}{numeric matrix.}

\item{dim}{\code{=1}, for row maximum values; \code{=2}, for column maximum
values.}
}
\value{
Returns a numeric vector with row or column maximum values.

The function is very much the same as using \code{apply(x, 1, max)} or
\code{apply(x, 2, max)}, but faster.
}
\description{
Finds either row or column maximum values of a matrix.
}
\details{
Matrix \code{x} may contain \code{Inf} or \code{-Inf}, but not \code{NA} or
\code{NaN}.
}
\examples{

x = cbind(c(1:4,Inf), 5:1)
matMaxs(x)
matMaxs(x, 2)

}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
\keyword{algebra}
\keyword{array}
