<!--
SPDX-FileCopyrightText: 2021 Adafruit Industries

SPDX-License-Identifier: MIT
-->

Thank you for opening an issue on an Adafruit Python library repository.  To
improve the speed of resolution please review the following guidelines and
common troubleshooting steps below before creating the issue:

- **Do not use GitHub issues for troubleshooting projects and issues.**  Instead use
  the forums at http://forums.adafruit.com to ask questions and troubleshoot why
  something isn't working as expected.  In many cases the problem is a common issue
  that you will more quickly receive help from the forum community.  GitHub issues
  are meant for known defects in the code.  If you don't know if there is a defect
  in the code then start with troubleshooting on the forum first.

- **If following a tutorial or guide be sure you didn't miss a step.** Carefully
  check all of the steps and commands to run have been followed.  Consult the
  forum if you're unsure or have questions about steps in a guide/tutorial.

- **For Python/Raspberry Pi projects check these very common issues to ensure they don't apply**:

  - If you are receiving an **ImportError: No module named...** error then a
    library the code depends on is not installed.  Check the tutorial/guide or
    README to ensure you have installed the necessary libraries.  Usually the
    missing library can be installed with the `pip` tool, but check the tutorial/guide
    for the exact command.

  - **Be sure you are supplying adequate power to the board.**  Check the specs of
    your board and power in an external power supply.  In many cases just
    plugging a board into your computer is not enough to power it and other
    peripherals.

  - **Double check all soldering joints and connections.**  Flakey connections
    cause many mysterious problems.  See the [guide to excellent soldering](https://learn.adafruit.com/adafruit-guide-excellent-soldering/tools) for examples of good solder joints.

If you're sure this issue is a defect in the code and checked the steps above
please fill in the following fields to provide enough troubleshooting information.
You may delete the guideline and text above to just leave the following details:

- Platform/operating system (i.e. Raspberry Pi with Raspbian operating system,
  Windows 32-bit, Windows 64-bit, Mac OSX 64-bit, etc.):  **INSERT PLATFORM/OPERATING
  SYSTEM HERE**

- Python version (run `python -version` or `python3 -version`):  **INSERT PYTHON
  VERSION HERE**

- Error message you are receiving, including any Python exception traces:  **INSERT
  ERROR MESAGE/EXCEPTION TRACES HERE***

- List the steps to reproduce the problem below (if possible attach code or commands
  to run): **LIST REPRO STEPS BELOW**
