import sys
import os
import subprocess

class bcolors:
    HEADER = '\033[95m'
    OKBLUE = '\033[94m'
    OKGREEN = '\033[92m'
    WARNING = '\033[93m'
    FAIL = '\033[91m'
    ENDC = '\033[0m'
    BOLD = '\033[1m'
    UNDERLINE = '\033[4m'

pass_count = 0
fail_count = 0

def check_individual_results(cm, t):
    p = subprocess.Popen(cm, shell=True, stdout=subprocess.PIPE)
    x = p.communicate()
    #print(x)
    x = x[0].lstrip().decode("utf-8")
    if x == t:
        print(bcolors.OKGREEN + "PASSED" + bcolors.ENDC)
        global pass_count
        pass_count += 1
        return True
    else:
        for i,j in zip(x,t):
            print(i, j, i == j)
        print(bcolors.FAIL + "FAILED" + bcolors.ENDC)
        print("intended output:\n", t)
        print("your output:\n", x)
        global fail_count
        fail_count += 1
        return False

def print_success(res):
    if res:
        print(bcolors.OKBLUE + "PASSED" + bcolors.ENDC)
    else:
        print(bcolors.FAIL + "FAILED" + bcolors.ENDC)
    
def test_program(name):
    x = None
    t = None
    print("TESTING", name)
    if name == "pxaa2cdn":
        res = True
        print("aa2cdn ", end = '')
        cm = "./pxaa2cdn -a TEST/AA.fa -n TEST/un_aln_nuc.fa"
        t = '>Sequence1\nATG---AAA---AAG\n>Sequence2\nATG------------\n>Sequence3\nATGATGATGATGATG\n>Sequence5\nATGATGATGATGATG\n'
        if not check_individual_results(cm, t):
            res = False
        print("aa2cdn (remove last codon, all) ", end = '')
        cm = "./pxaa2cdn -r -a TEST/AA.fa -n TEST/un_aln_nuc_with-stop.fa"
        t = '>Sequence1\nATG---AAA---AAG\n>Sequence2\nATG------------\n>Sequence3\nATGATGATGATGATG\n>Sequence5\nATGATGATGATGATG\n'
        if not check_individual_results(cm, t):
            res = False
        print("aa2cdn (remove stop codon, mixed) ", end = '')
        cm = "./pxaa2cdn -s -a TEST/AA.fa -n TEST/un_aln_nuc_mixed-stop.fa"
        t = '>Sequence1\nATG---AAA---AAG\n>Sequence2\nATG------------\n>Sequence3\nATGATGATGATGATG\n>Sequence5\nATGATGATGATGATG\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxbdfit":
        res = True
        print("yule ", end = '')
        cm = "./pxbdfit -t TEST/ultra_100.tre -m yule"
        t = 'ntips: 10\nnspeciation: 8\ntreelength: 8.67581\nrootheight: 1.74148\nmodel: yule\nlikelihood: 4.15305\naic: -6.3061\naicc: -5.8061\nb: 0.922104\n'
        if not check_individual_results(cm, t):
            res = False
        print("birth-death ", end = '')
        cm = "./pxbdfit -t TEST/ultra_100.tre -m bd"
        t = 'ntips: 10\nnspeciation: 8\ntreelength: 8.67581\nrootheight: 1.74148\nmodel: bd\nlikelihood: 4.18076\naic: -4.36152\naicc: -2.64723\nb: 1.05759\nd: 0.319273\nr (b-d): 0.738315\ne (d/b): 0.301888\n'
        if not check_individual_results(cm, t):
            res = False
        print("best ", end = '')
        cm = "./pxbdfit -t TEST/ultra_100.tre"
        t = 'ntips: 10\nnspeciation: 8\ntreelength: 8.67581\nrootheight: 1.74148\nmodel: bd\nlikelihood: 4.18076\naic: -4.36152\naicc: -2.64723\nb: 1.05759\nd: 0.319273\nr (b-d): 0.738315\ne (d/b): 0.301888\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxbdsim":
        res = True
        print("taxon stop ", end = '')
        cm = "./pxbdsim -e 5 -x 1"
        t = '((taxon_1:0.3085569342610965,taxon_2:0.3085569342610965):0.6313710462719906,(taxon_3:0.9385183995956337,(taxon_4:0.5397758496988591,taxon_5:0.5397758496988591):0.3987425498967747):0.0014095809374534);\n'
        if not check_individual_results(cm, t):
            res = False
        print("time stop ", end = '')
        cm = "./pxbdsim -t 5.1 -b 1.0 -d 0.75 -x 13"
        t = '(((((((taxon_5:0.2681437034262011,taxon_6:0.2681437034262011):0.7248133092430473,taxon_7:0.9929570126692484):0.484015158328142,(taxon_9:0.1548517152534084,taxon_10:0.1548517152534084):1.3221204557439821):0.1479365605447183,taxon_2:1.6249087315421087):0.3184946310577623,(taxon_13:1.9010749464536811,(taxon_18:0.3606589757369143,taxon_16:0.3606589757369143):1.5404159707167668):0.0423284161461899):0.7845989205099899,(taxon_20:0.1465475069334055,taxon_21:0.1465475069334055):2.5814547761764555):1.9711428334481687,taxon_35:4.6991451165580296);\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxboot":
        res = True
        print("bootstrap ", end = '')
        cm = "./pxboot -s TEST/test.fa -x 1"
        t = '>TaxonA\nAAATTCCCCCTGCCCTTTTA\n>TaxonB\nGCTCCGGGGGGCCCCAAGAC\n>TaxonC\nACGCCCCCCCCTAAAAAATA\n>TaxonD\nTCCTTTTTTTAATTCGGGTG\n>TaxonE\nTTACCTTTTTCCCCCGGCCG\n'
        if not check_individual_results(cm, t):
            res = False
        print("jackknife ", end = '')
        cm = "./pxboot -s TEST/test.fa -x 13 -f 0.5"
        t = '>TaxonA\nGCTATTCATCT\n>TaxonB\nCCCCGGGGCAG\n>TaxonC\nTATCACCACAT\n>TaxonD\nACCCGATTTCT\n>TaxonE\nCCCTCCTTCCT\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxbp":
        res = True
        print("node-based ", end = '')
        cm = "./pxbp -t TEST/nat.tre"
        t = '2 trees \n7 unique clades found\nCLADE: F G 	FREQ:	1.	ICA:	1.	COUNT:	2	TREEFREQ:	1.\nCLADE: E D 	FREQ:	1.	ICA:	1.	COUNT:	2	TREEFREQ:	1.\nCLADE: F G E D 	FREQ:	0.5	ICA:	0	COUNT:	1	TREEFREQ:	0.5\nCLADE: C B 	FREQ:	0.5	ICA:	0	COUNT:	1	TREEFREQ:	0.5\nCLADE: C B A 	FREQ:	1.	ICA:	1.	COUNT:	2	TREEFREQ:	1.\nCLADE: C A 	FREQ:	0.5	ICA:	0	COUNT:	1	TREEFREQ:	0.5\nCLADE: E D C B A 	FREQ:	0.5	ICA:	0	COUNT:	1	TREEFREQ:	0.5\nTSCA: 3\n'
        if not check_individual_results(cm, t):
            res = False
        print("edge-based ", end = '')
        cm = "./pxbp -e -t TEST/nat.tre"
        t = '2 trees \n5 unique clades found\nCLADE: F G | E D C B A 	FREQ:	1.	ICA:	1.	COUNT:	2	TREEFREQ:	1.\nCLADE: E D | F G C B A 	FREQ:	1.	ICA:	1.	COUNT:	2	TREEFREQ:	1.\nCLADE: F G E D | C B A 	FREQ:	1.	ICA:	1.	COUNT:	2	TREEFREQ:	1.\nCLADE: C B | F G E D A 	FREQ:	0.5	ICA:	0	COUNT:	1	TREEFREQ:	0.5\nCLADE: C A | F G E D B 	FREQ:	0.5	ICA:	0	COUNT:	1	TREEFREQ:	0.5\nTSCA: 3\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxcat":
        cm = "./pxcat -s TEST/test.fa TEST/protein_matrices/AA_5tax_interleaved.NEX TEST/phylip_examples/spaces_int.phy"
        t = '>TaxonA\nAAATTTCCCTGTCCCTTTAAQVFTHNEVNCRWHIEKGILTHEPLDHFDAHNHHILANNVETPVIYRPLWWRTRKAMDMWFLKSSMHWDFQENFDTMAYSMHAPQQQSKHSAHYRQQVNNLRRFIQPQMGHGRKMNNKQGCRMHYFIAYASLQFNSLYHAEMLKQLWTGGLDFSGEKSMPNWAKMSGESEGWSHWVLMLMRNYYRHGKLHGCSHRKEILESEKLRRIGIMRWWKQYAFKVRDISGYRFDRGYFGCKTLLNDAGCKVNCNWPAAATTTCCCTGTCCCTTTAA\n>TaxonB\nGCTCGAGGGGCCCCAAGACCQVFYHNEVNCRWINEKGILTHEPLDHFDAHNQHILANNVETPVIYRPLWWRTRKAMDRWFYKTSVHWDFQERFDTHGYSMVAPQQQSCNRAEYRQVVNNLRRFIQPQDGHGRKMNVKQGCRMHYFIARASLEFNSGYHAEYLKQLWLGGLDFSGEKSMLNWAKMSGESEGWSHWVYMLMRNYYRHGKLHGCSHRKEALESEKLRCIGIMRWWKQYAFKVRDISGYRFDRCYLICKTLLYDDGCKANCNWPGCTCGAGGGGCCCCAAGACC\n>TaxonC\nACGCTCCCCCTTAAAAATGAQVFYATEVNFRDIGSEGFLTCEFLDHFDAHEEKLLHNYVEKPWIEEPLWWRTRKRDDMYFSYHWDFLDFQENFDMHAYSMVMPQQHSYRFGEYRQVVNNLYYFNAGPMGHRQKMNNKQGCRMHYFIAYAQAQFNSGYHAEYLKMLSTGGLDLSGESSDPNWAKMSGESEGWSHWVAMLMRNYYRHGKSHGCKMFKHAYESEKLRCIGISSSGDQYCFTVRDSSGYRFDACVLECKTSLAACGHNANCGWPACGCTCCCCCTTAAAAATGA\n>TaxonD\nTCCTTGTTCAACTCCGGTGGHWPYHNEWNQRGWGVFRYLTHEFMCHQHRLFYHICHNYDHGPTTERFKAITTWTAQDRWKSGHSVHGDFQENFCTYGMKMRFQNQHSCNRHIGRRLQNNLRFNYCYCQIKRYKGNKCQFVQLKVDIHDKSLAANLIAASMYLRHMWFGPLTPYGFAVPPNWMMVSGPSFGKSWHMQIQIRNAYVTWKYRGKGYSICQSPQNKLMWPNRYWMIEIYTFIVTDIRTALFIQISLSEYAFSCDFIPRQDMNWQTCCTTGTTCAACTCCGGTGG\n>TaxonE\nTTACTATTCCCCCCCGCCGGAWWYHNTLNCRGWGEFRYLTHEFCCHWGNAFYHICHNYDNGPTTERFLTIQTWTARDRWCCKHSVHWNFQENFSTYGLKQRFQNQHSCNRHIVRQLWNNLRFFICICQIKRGKGNKCQFCILHYFIHLPSLACRLSYAFGYLRHNWFGTLTPYGFASPPNWYMRSEPSFGNSWNMAIQIANAFRTWKYRECGYSIKQSCDSTLMWPHRYWMIAQYTFQVTDSRTYDFITSSLVVYAFLCDAQARADCIDQTTACTATTCCCCCCCGCCGG\n'
    elif name == "pxclsq":
        res = True
        print("delete proportion ", end = '')
        cm = "./pxclsq -s TEST/Alignment -p 0.6"
        t = '>Sequence1\nAAATTTCCCTTTCCCTTTAAAAAATTTCCCTTTCCCTTTAAA\n>Sequence2\nGGGGGGGGGGCCCCCCCCCCAGGGGGGGGGGCCCCCCCCCCA\n>Sequence3\nCCCCCCCCCCCCAAAAAAAAACCCCCCCCCCCCAAAAAAAAA\n>Sequence9\nAAATTTCCCTTTCCCTTTAAAAAATTTCCCTTTCCCTTTAAA\n>Sequence10\nGGGGGGGGGGCCCCCCCCCCAGGGGGGGGGGCCCCCCCCCCA\n>Sequence11\nCCCCCCCCCCCCAAAAAAAAACCCCCCCCCCCCAAAAAAAAA\n>Sequence8\nTTTTTTTTCCCCCCCGGGGGATTTTTTTTCCCCCCCGGGGGA\n'
        if not check_individual_results(cm, t):
            res = False
        print("remove empty ", end = '')
        cm = "./pxclsq -s TEST/Alignment_empty-sites -e"
        t = '>Drosophila_setosifrons\n--TATAATAATATTCTTATATAAAATATAATTATTTTTATATT-TGGTCCNNTTTCGTACTAAAATATAACAA-TTTTTT\n>Drosophila_adunca\n--T-TAATAATATTCTTATTAAAAATATAATTATTTAAATATT-TGGTCCCCTTTCGTACTAAAATATTTTAAATTTTTT\n>Drosophila_oahuensis\n--T-TAATGAAATTCTTGCTAAAAATATGATTATTTTAATATT-TGGTCCNNTTTCGTACTAAAATATTATAA-TTTTTT\n>Drosophila_picticornis\n--T-TAATAATATTCTTATTTAAAATATAATTATTTTAACATT-TGGTCCCCTTTCGTACTAAAATGTTATAAGTTTTTT\n>Drosophila_primaeva\n--TATAATAATATTCTTACCAAAAATATAATTATTTTAATATT-TGGTCCNNTTTCGTACTAAAATATTATAA-TTTTTT\n>Drosophila_nigribasis\n--T-TAATAATATTCTTATTAAAAATATAATTATTTTAGTATT-TGGTCCNNTTTCGTACTAAAATACATTAA-TTTTTT\n>Drosophila_obscuripes\nAAT-TAATAATATTCTTACTAAAAATATAATTATTTTAGTATT-TGGTCCNNTTTCGTACTAAAATACTATAA-TTTTTT\n>Drosophila_silvestris\nNNT-TAATAATATTCTTATTTAAAATATAATTATTTTAATATT-TGGTCCNNTTTCGTACTAAAATATTATAA-TTTTTT\n>Drosophila_heteroneura\n--T-TAATAATATTCTTATTTAAAATATAATTATTTTAATATT-TGGTCCNNTTTCGTACTAAAATATTATAA-TTTTTT\n>Drosophila_differens\n--T-TAATAATATTCTTATTAAAAATATAATTATCTTAATATT-TGGTCCNNTTTCGTACTAAAATATTATAA-TTTTTT\n>Drosophila_planitibia\n--T-TAATAATATTCTTATTAAAAATATAATTATTTTAATATT-TGGTCCNNTTTCGTACTAAAATATTATAA-TTTTTT\n>Drosophila_hemipeza\n--T-TAATAATATTCTTAATAAAAATATAATTATTTTAATATT-TGGTCCCCTTTCGTACTAAAATATTATAA-TTTTTT\n>Drosophila_ingens\n--T-TAATAATATTCTTATTAAAAATATAATTATTTTAATATT-TGGTCCNNTTTCGTACTAAAATATTATAA-TTTTTT\n>Drosophila_neopicta\n--T-TAATAATATTCTTATTAAAAATATAATTATTTTCATATTATGGTCCNNTTTCGTACTAAAATATAATAA-TTTTTT\n>Drosophila_substenoptera\n--T-TAATAATATTCTTATTAAAAATACAATTATTTTCATATT-TGGTCCNNTTTCGTACTAAAATATAATAA-TTTTTT\n>Drosophila_neoperkinsi\n--T-TAATAAGATTCTTACTAAAAATATAATTATTTTAGTATT-TGGTCCNNTTTCGTACTAAAATACTATAA-TTTTTT\n>Drosophila_melanocephala\n--T-TAATAATATTCTTACTAAAAATATAATTATTTTAGTATT-TGGTCCNNTTTCGTACTAAAATACTATAA-TTTTTT\n>Drosophila_hanaulae\n--TATAATAATATTCTTACTAAAAATATAATTATTTTAGTATT-TGGTCCCCTTTCGTACTAAAATACTATAAGTTTTTT\n>Drosophila_cyrtoloma\n--T-TAATAATATTCTTACTAAAAATATAATTATTTTAGTATT-TGGTCCNNTTTCGTACTAAAATACTATAA-TTTTTT\n'
        if not check_individual_results(cm, t):
            res = False
        print("min 4 chars per site ", end = '')
        cm = "./pxclsq -s TEST/Alignment_empty-sites -m 4"
        t = '>Drosophila_setosifrons\nTTAATAATATTCTTATATAAAATATAATTATTTTTATATTTGGTCCNNTTTCGTACTAAAATATAACAATTTTTT\n>Drosophila_adunca\nTTAATAATATTCTTATTAAAAATATAATTATTTAAATATTTGGTCCCCTTTCGTACTAAAATATTTTAATTTTTT\n>Drosophila_oahuensis\nTTAATGAAATTCTTGCTAAAAATATGATTATTTTAATATTTGGTCCNNTTTCGTACTAAAATATTATAATTTTTT\n>Drosophila_picticornis\nTTAATAATATTCTTATTTAAAATATAATTATTTTAACATTTGGTCCCCTTTCGTACTAAAATGTTATAATTTTTT\n>Drosophila_primaeva\nTTAATAATATTCTTACCAAAAATATAATTATTTTAATATTTGGTCCNNTTTCGTACTAAAATATTATAATTTTTT\n>Drosophila_nigribasis\nTTAATAATATTCTTATTAAAAATATAATTATTTTAGTATTTGGTCCNNTTTCGTACTAAAATACATTAATTTTTT\n>Drosophila_obscuripes\nTTAATAATATTCTTACTAAAAATATAATTATTTTAGTATTTGGTCCNNTTTCGTACTAAAATACTATAATTTTTT\n>Drosophila_silvestris\nTTAATAATATTCTTATTTAAAATATAATTATTTTAATATTTGGTCCNNTTTCGTACTAAAATATTATAATTTTTT\n>Drosophila_heteroneura\nTTAATAATATTCTTATTTAAAATATAATTATTTTAATATTTGGTCCNNTTTCGTACTAAAATATTATAATTTTTT\n>Drosophila_differens\nTTAATAATATTCTTATTAAAAATATAATTATCTTAATATTTGGTCCNNTTTCGTACTAAAATATTATAATTTTTT\n>Drosophila_planitibia\nTTAATAATATTCTTATTAAAAATATAATTATTTTAATATTTGGTCCNNTTTCGTACTAAAATATTATAATTTTTT\n>Drosophila_hemipeza\nTTAATAATATTCTTAATAAAAATATAATTATTTTAATATTTGGTCCCCTTTCGTACTAAAATATTATAATTTTTT\n>Drosophila_ingens\nTTAATAATATTCTTATTAAAAATATAATTATTTTAATATTTGGTCCNNTTTCGTACTAAAATATTATAATTTTTT\n>Drosophila_neopicta\nTTAATAATATTCTTATTAAAAATATAATTATTTTCATATTTGGTCCNNTTTCGTACTAAAATATAATAATTTTTT\n>Drosophila_substenoptera\nTTAATAATATTCTTATTAAAAATACAATTATTTTCATATTTGGTCCNNTTTCGTACTAAAATATAATAATTTTTT\n>Drosophila_neoperkinsi\nTTAATAAGATTCTTACTAAAAATATAATTATTTTAGTATTTGGTCCNNTTTCGTACTAAAATACTATAATTTTTT\n>Drosophila_melanocephala\nTTAATAATATTCTTACTAAAAATATAATTATTTTAGTATTTGGTCCNNTTTCGTACTAAAATACTATAATTTTTT\n>Drosophila_hanaulae\nTTAATAATATTCTTACTAAAAATATAATTATTTTAGTATTTGGTCCCCTTTCGTACTAAAATACTATAATTTTTT\n>Drosophila_cyrtoloma\nTTAATAATATTCTTACTAAAAATATAATTATTTTAGTATTTGGTCCNNTTTCGTACTAAAATACTATAATTTTTT\n'
        if not check_individual_results(cm, t):
            res = False
        print("info by taxon ", end = '')
        cm = "./pxclsq -s TEST/Alignment -i -t"
        t = 'Length of sequences: 82 characters\nTaxon           Missing        Prop.\n------------------------------------\nSequence1             0            0\nSequence2             0            0\nSequence3             0            0\nSequence4            42     0.512195\nSequence9            40     0.487805\nSequence10           40     0.487805\nSequence11           40     0.487805\nSequence8            40     0.487805\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxcltr":
        res = True
        print("all ", end = '')
        cm = "./pxcltr -t TEST/figtree.tre"
        t = '((((((((((Acanthisitta:59.5193727309717602,((((Vidua:22.6182549004527154,Picathartes:22.6182549004527154):4.9009303834641216,Corvus:27.5191852839168369):9.2536731454940906,Menura:36.7728584294109169):8.4420208400820016,(Dendrocolaptes:35.3961203393474904,Sapayoa:35.3961203393474904):9.8187589301454139):14.3044934614788488):10.7748334139107271,(Platycercus:40.0281091281313834,Cacatua:40.0281091281313834):30.2660970167511039):4.4587322613926119,((Daptrius:38.2572365058785309,Falco:38.2572365058785309):21.5464257679351547,Micrastur:59.8036622738136927):14.9492761324614136):1.5291784870669858,Cariama:76.2821168933420921):1.7216938014130534,(((((((Todus:60.7013555283992616,Brachypteracias:60.7013555283992616):5.7508807513454414,Galbula:66.4522362797447101):4.4488614861600126,Tockus:70.9010977659047228):2.216948125952598,Trogon:73.1180458918573066):1.5161563415550319,Leptosomus:74.6342022334123527):1.1276714400573553,((Colius:30.2733624411755677,Urocolius:30.2733624411755677):42.5451975111996461,((Phodilus:50.1106605525312929,Tyto:50.1106605525312929):12.2899256666875729,Speotyto:62.4005862192188658):10.4179737331563302):2.9433137210945119):0.8406056023289636,((Buteo:56.7517771915700493,Pandion:56.7517771915700493):15.5516984707221511,Cathartes:72.3034756622922004):4.2990036135064855):1.4013314189564596):1.0276414826621334,((Arenaria:56.3951097085813871,Larus:56.3951097085813871):13.1454394615530177,Haematopus:69.5405491701344118):9.4909030072828671):1.2181587948254702,((((((((Anhinga:59.8569106706207137,Fregata:59.8569106706207137):7.5720611901585926,(Balaeniceps:45.4587379089424104,Pelecanus:45.4587379089424104):21.9702339518369172):3.3980479603686149,Ciconia:70.8270198211479283):2.1448079148853196,((Puffinus:61.9603862624734916,Oceanites:61.9603862624734916):9.1268276876270349,Eudyptula:71.0872139501005194):1.8846137859327143):2.8157199910723989,Gavia:75.7875477271056468):0.9540458767609721,Tauraco:76.7415936038666189):0.8679843349123075,((((Grus:51.9285514272868909,Psophia:51.9285514272868909):14.0376559938998682,Heliornis:65.966207421186752):7.386107234187179,(Coccyzus:46.3876197971255806,Geococcyx:46.3876197971255806):26.9646948582483503):2.4525290405429416,(Choriotis:23.3726820748962751,Eupodotis:23.3726820748962751):52.4321616210206045):1.8047342428620539):0.9528590555748337,Opisthocomus:78.5624369943537602):1.6871739778889889):1.5969007841221128,(((((Aegotheles:71.0907918755163735,((Streptoprocne:57.3224341397834678,Hemiprocne:57.3224341397834678):5.9801764374741353,Colibri:63.3026105772576031):7.7881812982587633):2.2191066355752156,Caprimulgus:73.3098985110915891):3.1721034032586743,(Nyctibius_gr:67.1418428139748045,Steatornis:67.1418428139748045):9.3401591003754589):1.1922948731627798,(Eurypyga:44.7436010092943945,Rhynochetos:44.7436010092943945):32.9306957782186487):1.6375361940638982,(((((Geotrygon:17.955128614773546,Otidiphaps:17.955128614773546):41.4025831377661149,(Mesitornis:30.5363877534961041,Monias:30.5363877534961041):28.8213239990435603):8.8140467330380901,(Pterocles:23.248849928737279,Syrrhaptes:23.248849928737279):44.9229085568404827):3.6394441298017881,Phaethon_le:71.8112026153795568):4.7318002096549492,(Phoenicopterus:46.8102884964044321,Podiceps:46.8102884964044321):29.7327143286300597):2.7688301565424496):2.5346787747879205):12.1692101452984787,((Megapodius:57.6199055615797704,Gallus:57.6199055615797704):21.9373206132001357,((Anas:75.311728856484649,Anseranas:75.311728856484649):1.6600967378572022,Chauna:76.9718255943418512):2.585400580438062):14.4584957268834273):8.9369110714444417,((((Apteryx:67.0034573097872084,(Casuarius:32.1214384242075894,Dromaius:32.1214384242075894):34.8820188855796189):7.1368013410298374,(Tinamus:27.6367201876039204,Eudromia:27.6367201876039204):46.5035384632131326):1.9804044712445403,Rhea:76.1206631220615861):2.2978942387944272,Struthio:78.4185573608560276):24.5340756122517689);\n'
        if not check_individual_results(cm, t):
            res = False
        print("labels ", end = '')
        cm = "./pxcltr -t TEST/figtree.tre -l"
        t = '(((((((((((Acanthisitta:59.5193727309717602,((((Vidua:22.6182549004527154,Picathartes:22.6182549004527154):4.9009303834641216,Corvus:27.5191852839168369):9.2536731454940906,Menura:36.7728584294109169):8.4420208400820016,(Dendrocolaptes:35.3961203393474904,Sapayoa:35.3961203393474904):9.8187589301454139):14.3044934614788488):10.7748334139107271,(Platycercus:40.0281091281313834,Cacatua:40.0281091281313834):30.2660970167511039):4.4587322613926119,((Daptrius:38.2572365058785309,Falco:38.2572365058785309):21.5464257679351547,Micrastur:59.8036622738136927):14.9492761324614136):1.5291784870669858,Cariama:76.2821168933420921):1.7216938014130534,(((((((Todus:60.7013555283992616,Brachypteracias:60.7013555283992616):5.7508807513454414,Galbula:66.4522362797447101):4.4488614861600126,Tockus:70.9010977659047228):2.216948125952598,Trogon:73.1180458918573066):1.5161563415550319,Leptosomus:74.6342022334123527):1.1276714400573553,((Colius:30.2733624411755677,Urocolius:30.2733624411755677):42.5451975111996461,((Phodilus:50.1106605525312929,Tyto:50.1106605525312929):12.2899256666875729,Speotyto:62.4005862192188658):10.4179737331563302):2.9433137210945119):0.8406056023289636,((Buteo:56.7517771915700493,Pandion:56.7517771915700493):15.5516984707221511,Cathartes:72.3034756622922004):4.2990036135064855):1.4013314189564596):1.0276414826621334,((Arenaria:56.3951097085813871,Larus:56.3951097085813871):13.1454394615530177,Haematopus:69.5405491701344118):9.4909030072828671):1.2181587948254702,((((((((Anhinga:59.8569106706207137,Fregata:59.8569106706207137):7.5720611901585926,(Balaeniceps:45.4587379089424104,Pelecanus:45.4587379089424104):21.9702339518369172):3.3980479603686149,Ciconia:70.8270198211479283):2.1448079148853196,((Puffinus:61.9603862624734916,Oceanites:61.9603862624734916):9.1268276876270349,Eudyptula:71.0872139501005194):1.8846137859327143):2.8157199910723989,Gavia:75.7875477271056468):0.9540458767609721,Tauraco:76.7415936038666189):0.8679843349123075,((((Grus:51.9285514272868909,Psophia:51.9285514272868909):14.0376559938998682,Heliornis:65.966207421186752):7.386107234187179,(Coccyzus:46.3876197971255806,Geococcyx:46.3876197971255806):26.9646948582483503):2.4525290405429416,(Choriotis:23.3726820748962751,Eupodotis:23.3726820748962751):52.4321616210206045):1.8047342428620539):0.9528590555748337,Opisthocomus:78.5624369943537602):1.6871739778889889):1.5969007841221128,(((((Aegotheles:71.0907918755163735,((Streptoprocne:57.3224341397834678,Hemiprocne:57.3224341397834678):5.9801764374741353,Colibri:63.3026105772576031):7.7881812982587633):2.2191066355752156,Caprimulgus:73.3098985110915891):3.1721034032586743,(Nyctibius_gr:67.1418428139748045,Steatornis:67.1418428139748045):9.3401591003754589):1.1922948731627798,(Eurypyga:44.7436010092943945,Rhynochetos:44.7436010092943945):32.9306957782186487):1.6375361940638982,(((((Geotrygon:17.955128614773546,Otidiphaps:17.955128614773546):41.4025831377661149,(Mesitornis:30.5363877534961041,Monias:30.5363877534961041):28.8213239990435603):8.8140467330380901,(Pterocles:23.248849928737279,Syrrhaptes:23.248849928737279):44.9229085568404827):3.6394441298017881,Phaethon_le:71.8112026153795568):4.7318002096549492,(Phoenicopterus:46.8102884964044321,Podiceps:46.8102884964044321):29.7327143286300597):2.7688301565424496):2.5346787747879205):12.1692101452984787,((Megapodius:57.6199055615797704,Gallus:57.6199055615797704):21.9373206132001357,((Anas:75.311728856484649,Anseranas:75.311728856484649):1.6600967378572022,Chauna:76.9718255943418512):2.585400580438062):14.4584957268834273):8.9369110714444417,((((Apteryx:67.0034573097872084,(Casuarius:32.1214384242075894,Dromaius:32.1214384242075894):34.8820188855796189):7.1368013410298374,(Tinamus:27.6367201876039204,Eudromia:27.6367201876039204):46.5035384632131326):1.9804044712445403,Rhea:76.1206631220615861):2.2978942387944272,Struthio:78.4185573608560276):24.5340756122517689):100);\n'
        if not check_individual_results(cm, t):
            res = False
        print("knuckles ", end = '')
        cm = "./pxcltr -t TEST/figtree.tre -k"
        t = '(((((((((((Acanthisitta:59.5193727309717602,((((Vidua:22.6182549004527154,Picathartes:22.6182549004527154):4.9009303834641216,Corvus:27.5191852839168369):9.2536731454940906,Menura:36.7728584294109169):8.4420208400820016,(Dendrocolaptes:35.3961203393474904,Sapayoa:35.3961203393474904):9.8187589301454139):14.3044934614788488):10.7748334139107271,(Platycercus:40.0281091281313834,Cacatua:40.0281091281313834):30.2660970167511039):4.4587322613926119,((Daptrius:38.2572365058785309,Falco:38.2572365058785309):21.5464257679351547,Micrastur:59.8036622738136927):14.9492761324614136):1.5291784870669858,Cariama:76.2821168933420921):1.7216938014130534,(((((((Todus:60.7013555283992616,Brachypteracias:60.7013555283992616):5.7508807513454414,Galbula:66.4522362797447101):4.4488614861600126,Tockus:70.9010977659047228):2.216948125952598,Trogon:73.1180458918573066):1.5161563415550319,Leptosomus:74.6342022334123527):1.1276714400573553,((Colius:30.2733624411755677,Urocolius:30.2733624411755677):42.5451975111996461,((Phodilus:50.1106605525312929,Tyto:50.1106605525312929):12.2899256666875729,Speotyto:62.4005862192188658):10.4179737331563302):2.9433137210945119):0.8406056023289636,((Buteo:56.7517771915700493,Pandion:56.7517771915700493):15.5516984707221511,Cathartes:72.3034756622922004):4.2990036135064855):1.4013314189564596):1.0276414826621334,((Arenaria:56.3951097085813871,Larus:56.3951097085813871):13.1454394615530177,Haematopus:69.5405491701344118):9.4909030072828671):1.2181587948254702,((((((((Anhinga:59.8569106706207137,Fregata:59.8569106706207137):7.5720611901585926,(Balaeniceps:45.4587379089424104,Pelecanus:45.4587379089424104):21.9702339518369172):3.3980479603686149,Ciconia:70.8270198211479283):2.1448079148853196,((Puffinus:61.9603862624734916,Oceanites:61.9603862624734916):9.1268276876270349,Eudyptula:71.0872139501005194):1.8846137859327143):2.8157199910723989,Gavia:75.7875477271056468):0.9540458767609721,Tauraco:76.7415936038666189):0.8679843349123075,((((Grus:51.9285514272868909,Psophia:51.9285514272868909):14.0376559938998682,Heliornis:65.966207421186752):7.386107234187179,(Coccyzus:46.3876197971255806,Geococcyx:46.3876197971255806):26.9646948582483503):2.4525290405429416,(Choriotis:23.3726820748962751,Eupodotis:23.3726820748962751):52.4321616210206045):1.8047342428620539):0.9528590555748337,Opisthocomus:78.5624369943537602):1.6871739778889889):1.5969007841221128,(((((Aegotheles:71.0907918755163735,((Streptoprocne:57.3224341397834678,Hemiprocne:57.3224341397834678):5.9801764374741353,Colibri:63.3026105772576031):7.7881812982587633):2.2191066355752156,Caprimulgus:73.3098985110915891):3.1721034032586743,(Nyctibius_gr:67.1418428139748045,Steatornis:67.1418428139748045):9.3401591003754589):1.1922948731627798,(Eurypyga:44.7436010092943945,Rhynochetos:44.7436010092943945):32.9306957782186487):1.6375361940638982,(((((Geotrygon:17.955128614773546,Otidiphaps:17.955128614773546):41.4025831377661149,(Mesitornis:30.5363877534961041,Monias:30.5363877534961041):28.8213239990435603):8.8140467330380901,(Pterocles:23.248849928737279,Syrrhaptes:23.248849928737279):44.9229085568404827):3.6394441298017881,Phaethon_le:71.8112026153795568):4.7318002096549492,(Phoenicopterus:46.8102884964044321,Podiceps:46.8102884964044321):29.7327143286300597):2.7688301565424496):2.5346787747879205):12.1692101452984787,((Megapodius:57.6199055615797704,Gallus:57.6199055615797704):21.9373206132001357,((Anas:75.311728856484649,Anseranas:75.311728856484649):1.6600967378572022,Chauna:76.9718255943418512):2.585400580438062):14.4584957268834273):8.9369110714444417,((((Apteryx:67.0034573097872084,(Casuarius:32.1214384242075894,Dromaius:32.1214384242075894):34.8820188855796189):7.1368013410298374,(Tinamus:27.6367201876039204,Eudromia:27.6367201876039204):46.5035384632131326):1.9804044712445403,Rhea:76.1206631220615861):2.2978942387944272,Struthio:78.4185573608560276):24.5340756122517689):100);\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxcolt":
        res = True
        print("probability support ", end = '')
        cm = "./pxcolt -t TEST/collapse/prob_support.tre -l 0.7"
        t = '((TaxonC:0.25,TaxonA:0.225,TaxonB:0.155)1.0:0.4,(TaxonD:0.23,TaxonE:0.16)0.94:0.3);\n'
        if not check_individual_results(cm, t):
            res = False
        print("integer support ", end = '')
        cm = "./pxcolt -t TEST/collapse/integer_support.tre -l 0.7"
        t = '((TaxonC:0.25,TaxonA:0.225,TaxonB:0.155)100:0.4,(TaxonD:0.23,TaxonE:0.16)94:0.3);\n'
        if not check_individual_results(cm, t):
            res = False
        print("real support ", end = '')
        cm = "./pxcolt -t TEST/collapse/real_support.tre -l 0.7"
        t = '((TaxonC:0.25,TaxonA:0.225,TaxonB:0.155)99.9:0.4,(TaxonD:0.23,TaxonE:0.16)94.7:0.3);\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxcomp":
        cm = "./pxcomp -s TEST/test.fa"
        t = 'Observed character counts:\n                  A            C            G            T        Nchar\nTaxonA            5            6            1            8           20\nTaxonB            4            8            7            1           20\nTaxonC            7            7            2            4           20\nTaxonD            2            6            5            7           20\nTaxonE            2           10            3            5           20\nTotal            20           37           18           25          100\nchi-square test stat. = 18.458\ndf = 12\nprob = 0.102476\n'
    elif name == "pxconsq":
        cm = "./pxconsq -s TEST/test.fa"
        t = '>consensus\nDHNYKNBBSNNYHMMDNHVV\n'
    elif name == "pxcontrates":
        cm = "./pxcontrates -c TEST/contrates_file.txt -t TEST/contrates_tree.tre"
        t = '#nexus\nbegin trees;\ntree tree0 = ((((s1[&value=100.000000000]:0.360355,s2[&value=100.000000000]:0.360355)[&value=100.892125727]:0.896878,s3[&value=120.000000000]:1.25723)[&value=105.332899025]:0.420755,(((s4[&value=110.000000000]:0.119033,s5[&value=80.000000000]:0.119033)[&value=93.952153267]:0.0254417,s6[&value=90.000000000]:0.144475)[&value=93.504227541]:0.764764,s7[&value=100.000000000]:0.909239)[&value=98.589114242]:0.768749)[&value=102.507614350]:0.0634916,((s8[&value=100.000000000]:0.310689,s9[&value=100.000000000]:0.310689)[&value=100.154669043]:0.103151,s10[&value=100.000000000]:0.41384)[&value=100.257371380]:1.32764)[&value=102.404912715];\ntree tree1 = ((((s1[&value=19.000000000]:0.360355,s2[&value=18.000000000]:0.360355)[&value=18.086986419]:0.896878,s3[&value=17.000000000]:1.25723)[&value=16.031110631]:0.420755,(((s4[&value=16.000000000]:0.119033,s5[&value=15.000000000]:0.119033)[&value=15.080525602]:0.0254417,s6[&value=14.000000000]:0.144475)[&value=14.901211808]:0.764764,s7[&value=13.000000000]:0.909239)[&value=14.281614892]:0.768749)[&value=14.742377359]:0.0634916,((s8[&value=12.000000000]:0.310689,s9[&value=11.000000000]:0.310689)[&value=11.388982194]:0.103151,s10[&value=10.000000000]:0.41384)[&value=11.315264869]:1.32764)[&value=14.585963113];\ntree tree2 = ((((s1[&value=20.000000000]:0.360355,s2[&value=20.000000000]:0.360355)[&value=20.000000000]:0.896878,s3[&value=20.000000000]:1.25723)[&value=20.000000000]:0.420755,(((s4[&value=20.000000000]:0.119033,s5[&value=20.000000000]:0.119033)[&value=20.000000000]:0.0254417,s6[&value=20.000000000]:0.144475)[&value=20.000000000]:0.764764,s7[&value=20.000000000]:0.909239)[&value=20.000000000]:0.768749)[&value=20.000000000]:0.0634916,((s8[&value=20.000000000]:0.310689,s9[&value=20.000000000]:0.310689)[&value=20.000000000]:0.103151,s10[&value=20.000000000]:0.41384)[&value=20.000000000]:1.32764)[&value=20.000000000];\nend;\n\n'
    elif name == "pxfqfilt":
        cm = "./pxfqfilt -m 20 -s TEST/test.fastq | wc -l"
        t = "3872\n"
    elif name == "pxlog":
        res = True
        print("count trees ", end = '')
        cm = "./pxlog -t TEST/run1.trees TEST/run2.trees -i"
        t = 'TEST/run1.trees: 101 trees.\nTEST/run2.trees: 151 trees.\nCounted 252 total tree samples across 2 files.\n'
        if not check_individual_results(cm, t):
            res = False
        print("tree log ", end = '')
        cm = "./pxlog -t TEST/run1.trees TEST/run2.trees -b 75 -n 2"
        t = '#NEXUS\n\nBegin taxa;\n	Dimensions ntax=33;\n	Taxlabels\n		113_V_gryphus\n		128_C_burrovianus\n		135_C_aura\n		31_C_melambrotus\n		6_C_atratus\n		97_S_papa\n		9_G_californianus\n		Anas_clypeata\n		Anas_platyrhunchos\n		Apterodytes_patagonicus\n		Ardea_herodias\n		Asio_otus\n		Balaeniceps_rex\n		Bonasa_umbellus\n		Bucephala_abeola\n		Caracara_cheriway\n		Charadrius_alexandrinus\n		Ciconia_maguari\n		Ephippiorhynchus_senegalensis\n		Falco_femoralis\n		Falco_peregrinus\n		Falco_rusticolus\n		Fulmarus_glacialis\n		Gallus_gallus\n		Gavia_immer\n		Gyps_bengalensis\n		Larus_marinus\n		Lunda_cirrhata\n		Nyctanassa_violacea\n		Pandion\n		Pygoscelis_antarcticus\n		Sagittarius\n		Scopus_umbretta\n		;\nEnd;\n\nBegin trees;\n	Translate\n		1 113_V_gryphus,\n		2 128_C_burrovianus,\n		3 135_C_aura,\n		4 31_C_melambrotus,\n		5 6_C_atratus,\n		6 97_S_papa,\n		7 9_G_californianus,\n		8 Anas_clypeata,\n		9 Anas_platyrhunchos,\n		10 Apterodytes_patagonicus,\n		11 Ardea_herodias,\n		12 Asio_otus,\n		13 Balaeniceps_rex,\n		14 Bonasa_umbellus,\n		15 Bucephala_abeola,\n		16 Caracara_cheriway,\n		17 Charadrius_alexandrinus,\n		18 Ciconia_maguari,\n		19 Ephippiorhynchus_senegalensis,\n		20 Falco_femoralis,\n		21 Falco_peregrinus,\n		22 Falco_rusticolus,\n		23 Fulmarus_glacialis,\n		24 Gallus_gallus,\n		25 Gavia_immer,\n		26 Gyps_bengalensis,\n		27 Larus_marinus,\n		28 Lunda_cirrhata,\n		29 Nyctanassa_violacea,\n		30 Pandion,\n		31 Pygoscelis_antarcticus,\n		32 Sagittarius,\n		33 Scopus_umbretta\n		;\ntree STATE_0 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55165.13148245269,EEF_ucld_branchRates=-266.168517335019,lnP=-55165.13148245269,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.491519171407602E-4]:1.13257396578E1,9[&rate=6.367032323998896E-4]:1.13257396578E1)[&rate=7.858985904720106E-4]:4.464111684496E0,15[&rate=4.1233866807259843E-4]:1.57898513423E1)[&rate=6.875024701695477E-4]:1.092846716327E2,(14[&rate=0.0012135271601642415]:4.944525647579E1,24[&rate=5.521552390624093E-4]:4.944525647579E1)[&rate=0.0010441679181449727]:7.562926649923E1)[&rate=9.262993402486683E-4]:1.723696214156E0,(((25[&rate=7.708275361737002E-4]:7.181708005364E1,((((30[&rate=6.121845853669823E-4]:4.985660910622E1,26[&rate=7.14127096657731E-4]:4.985660910622E1)[&rate=0.0010176993850459428]:9.995868247001E0,32[&rate=3.4625317941899754E-4]:5.985247735322E1)[&rate=4.6653751154651294E-4]:7.996827625354E0,((16[&rate=3.974271783369831E-4]:3.380740319842E1,((22[&rate=8.338699316080518E-4]:3.257441736696E0,21[&rate=7.56148400880097E-4]:3.257441736696E0)[&rate=6.367032323998896E-4]:3.227919911685E0,20[&rate=9.928761850134726E-4]:6.48536164838E0)[&rate=0.001311098279928485]:2.732204155004E1)[&rate=9.928761850134726E-4]:3.371522301258E1,((((3[&rate=3.2549049638558433E-4]:1.432620961347E0,4[&rate=0.0010441679181449727]:1.432620961347E0)[&rate=5.640993501024151E-4]:3.934199057588E-1,2[&rate=6.000746086707974E-4]:1.826040867106E0)[&rate=3.8165268046827126E-4]:9.803756223352E0,5[&rate=3.4625317941899754E-4]:1.162979709046E1)[&rate=6.617539259616744E-4]:2.042858207699E0,((7[&rate=5.521552390624093E-4]:7.913622803886E0,6[&rate=9.262993402486683E-4]:7.913622803886E0)[&rate=7.14127096657731E-4]:1.743947557529E0,1[&rate=8.68642972479051E-4]:9.657570361415E0)[&rate=7.278289091363475E-4]:4.015084936742E0)[&rate=4.535850203136672E-4]:5.384997091285E1)[&rate=4.1233866807259843E-4]:3.266787675755E-1)[&rate=0.001854090422241169]:1.851111882531E0,12[&rate=9.928761850134726E-4]:6.970041686111E1)[&rate=6.745302046339041E-4]:2.116663192535E0)[&rate=7.56148400880097E-4]:1.906772436903E0,((((33[&rate=9.473390789692693E-4]:4.850834425682E1,13[&rate=2.698812133915219E-4]:4.850834425682E1)[&rate=3.0109868906779026E-4]:2.007204490211E1,(19[&rate=8.509392570586737E-4]:1.274367209727E1,18[&rate=0.0012135271601642415]:1.274367209727E1)[&rate=2.698812133915219E-4]:5.583671706166E1)[&rate=7.858985904720106E-4]:1.489063433765E0,(11[&rate=4.7921810677827465E-4]:1.213878324424E1,29[&rate=6.000746086707974E-4]:1.213878324424E1)[&rate=8.870497241331672E-4]:5.793066934846E1)[&rate=2.698812133915219E-4]:2.53817815615E0,((10[&rate=6.745302046339041E-4]:1.574844011456E1,31[&rate=8.68642972479051E-4]:1.574844011456E1)[&rate=5.521552390624093E-4]:5.393796591546E1,23[&rate=5.521552390624093E-4]:6.968640603003E1)[&rate=4.6653751154651294E-4]:2.921224718818E0)[&rate=9.694820211563088E-4]:1.116221741701E0)[&rate=0.001854090422241169]:4.19015990179E0,(17[&rate=7.708275361737002E-4]:7.160357780666E1,(27[&rate=4.535850203136672E-4]:2.985614862999E1,28[&rate=7.278289091363475E-4]:2.985614862999E1)[&rate=0.0011364778888983934]:4.174742917667E1)[&rate=0.0011031761422500594]:6.310434585674E0)[&rate=0.0016618610145439333]:4.888420679684E1);\ntree STATE_1 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55114.92162296427,EEF_ucld_branchRates=-266.168517335019,lnP=-55114.92162296427,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.432835519837599E-4]:1.100973124427E1,9[&rate=4.8626015958343563E-4]:1.100973124427E1)[&rate=3.6454536364777235E-4]:5.649648486163E0,15[&rate=9.773747081365596E-4]:1.665937973043E1)[&rate=7.041365574460978E-4]:1.088979418912E2,(14[&rate=0.00100683793147973]:5.055464428328E1,24[&rate=5.570724333007862E-4]:5.055464428328E1)[&rate=8.238640701612584E-4]:7.500267733839E1)[&rate=0.0015473551116608954]:1.90590494296E0,(((25[&rate=6.66750193656917E-4]:7.568801303577E1,(12[&rate=6.432835519837599E-4]:7.28395630592E1,((16[&rate=2.5350035197253395E-4]:3.624643042751E1,((22[&rate=0.0018819295968046754]:3.169847917002E0,21[&rate=2.809302220991419E-4]:3.169847917002E0)[&rate=5.673801276555682E-4]:5.374182723095E0,20[&rate=4.963571768224952E-4]:8.544030640097E0)[&rate=0.0010394458163883933]:2.770239978741E1)[&rate=9.773747081365596E-4]:3.514029213497E1,(((30[&rate=7.594550785275435E-4]:4.843669821979E1,26[&rate=4.963571768224952E-4]:4.843669821979E1)[&rate=9.026669316639456E-4]:1.089160199797E1,32[&rate=3.773694205585881E-4]:5.932830021776E1)[&rate=5.570724333007862E-4]:1.015625933124E1,((((3[&rate=7.449171477244499E-4]:1.581049982656E0,4[&rate=9.773747081365596E-4]:1.581049982656E0)[&rate=8.419266792272108E-4]:5.692743077229E-1,2[&rate=4.963571768224952E-4]:2.150324290379E0)[&rate=4.2374920021226984E-4]:8.280531199389E0,5[&rate=3.509469086713054E-4]:1.043085548977E1)[&rate=6.319097002157012E-4]:3.133736605239E0,((7[&rate=3.89591068401691E-4]:8.514600229056E0,6[&rate=5.88308888642596E-4]:8.514600229056E0)[&rate=8.609824782466007E-4]:1.189340788068E0,1[&rate=7.449171477244499E-4]:9.703941017125E0)[&rate=4.2374920021226984E-4]:3.860651077882E0)[&rate=7.173032727879145E-4]:5.5919967454E1)[&rate=3.89591068401691E-4]:1.902163013473E0)[&rate=9.026669316639456E-4]:1.452840496727E0)[&rate=5.88308888642596E-4]:2.848449976572E0)[&rate=6.432835519837599E-4]:6.356517176802E-1,((((11[&rate=5.570724333007862E-4]:1.440547607658E1,29[&rate=7.745510698353868E-4]:1.440547607658E1)[&rate=5.777866535606864E-4]:5.443858763138E1,(33[&rate=7.902677421602243E-4]:5.598164503662E1,13[&rate=3.203025450350539E-4]:5.598164503662E1)[&rate=8.609824782466007E-4]:1.286241867135E1)[&rate=0.0011177048600246257]:1.20168189338E0,(19[&rate=7.902677421602243E-4]:1.397235759973E1,18[&rate=6.788925687625579E-4]:1.397235759973E1)[&rate=5.064289247136427E-4]:5.607338800162E1)[&rate=2.0843238030718346E-4]:3.542968383984E0,((10[&rate=6.097700838501141E-4]:1.417768651896E1,31[&rate=8.419266792272108E-4]:1.417768651896E1)[&rate=2.5350035197253395E-4]:5.807526881403E1,23[&rate=3.89591068401691E-4]:7.225295533299E1)[&rate=6.548891178634315E-4]:1.335758652342E0)[&rate=3.0224038688422003E-4]:2.734950768121E0)[&rate=4.2374920021226984E-4]:4.723307623727E0,(17[&rate=6.66750193656917E-4]:7.3448718883E1,(27[&rate=3.0224038688422003E-4]:3.512903799491E1,28[&rate=5.064289247136427E-4]:3.512903799491E1)[&rate=6.207454408416914E-4]:3.83196808881E1)[&rate=7.902677421602243E-4]:7.598253494177E0)[&rate=0.0015473551116608954]:4.641625418744E1);\ntree STATE_2 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55129.87052347309,EEF_ucld_branchRates=-266.168517335019,lnP=-55129.87052347309,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.066097019294435E-4]:1.07568141584E1,9[&rate=8.67989763853159E-4]:1.07568141584E1)[&rate=4.6356073087012426E-4]:9.37125547926E0,15[&rate=2.2676083374627897E-4]:2.012806963766E1)[&rate=8.67989763853159E-4]:9.872108264778E1,(14[&rate=0.0013676113136323678]:4.245714471267E1,24[&rate=9.80288710297613E-4]:4.245714471267E1)[&rate=8.020875789748006E-4]:7.639200757277E1)[&rate=5.633341908903434E-4]:6.884003169277E0,((((12[&rate=6.390353822594545E-4]:7.567921348753E1,((16[&rate=5.633341908903434E-4]:3.876191691889E1,((22[&rate=3.447167184332075E-4]:3.468309035193E0,21[&rate=3.07916205099355E-4]:3.468309035193E0)[&rate=7.638194289318662E-4]:4.390084770045E0,20[&rate=4.424107250105804E-4]:7.858393805238E0)[&rate=0.0016812837993772415]:3.090352311365E1)[&rate=9.80288710297613E-4]:3.528551690521E1,(((((3[&rate=4.424107250105804E-4]:2.171815157335E0,4[&rate=2.470891429183894E-4]:2.171815157335E0)[&rate=3.2067368401077776E-4]:4.723965727751E-1,2[&rate=2.0099040236757344E-4]:2.64421173011E0)[&rate=7.460135929861184E-4]:8.783333965784E0,5[&rate=3.447167184332075E-4]:1.142754569589E1)[&rate=5.066097019294435E-4]:2.771749475436E0,((7[&rate=3.6743046800013373E-4]:9.59617105114E0,6[&rate=6.125877263206706E-4]:9.59617105114E0)[&rate=2.470891429183894E-4]:1.27801552066E0,1[&rate=3.6743046800013373E-4]:1.08741865718E1)[&rate=6.390353822594545E-4]:3.32510859953E0)[&rate=6.125877263206706E-4]:5.906595491277E1,((30[&rate=8.446845102300667E-4]:4.880507558075E1,26[&rate=6.968735921907402E-4]:4.880507558075E1)[&rate=2.470891429183894E-4]:1.504868501029E1,32[&rate=4.957080547027265E-4]:6.385376059104E1)[&rate=6.968735921907402E-4]:9.411489493062E0)[&rate=6.670261269058315E-4]:7.821837400018E-1)[&rate=0.0012063415462943848]:1.631779663423E0)[&rate=5.516302283112064E-4]:1.482976541483E0,25[&rate=5.874260512070298E-4]:7.716219002901E1)[&rate=4.957080547027265E-4]:4.90155812249E-1,((((11[&rate=8.020875789748006E-4]:1.801527753452E1,29[&rate=7.460135929861184E-4]:1.801527753452E1)[&rate=8.446845102300667E-4]:5.128338566482E1,(33[&rate=0.001053787461148689]:5.221393998245E1,13[&rate=4.424107250105804E-4]:5.221393998245E1)[&rate=5.874260512070298E-4]:1.708472321689E1)[&rate=4.424107250105804E-4]:1.226723825238E0,(19[&rate=0.001053787461148689]:1.700916822088E1,18[&rate=6.125877263206706E-4]:1.700916822088E1)[&rate=4.424107250105804E-4]:5.35162188037E1)[&rate=2.2676083374627897E-4]:5.026086317692E0,((10[&rate=0.001053787461148689]:1.856373185197E1,31[&rate=5.401255454026521E-4]:1.856373185197E1)[&rate=3.2067368401077776E-4]:5.691282458383E1,23[&rate=2.6451651703730784E-4]:7.54765564358E1)[&rate=6.670261269058315E-4]:7.491690647019E-2)[&rate=5.287999956060568E-4]:2.100872498988E0)[&rate=3.447167184332075E-4]:1.890025224509E0,(17[&rate=7.638194289318662E-4]:7.079170717013E1,(27[&rate=3.2067368401077776E-4]:3.44566390445E1,28[&rate=8.227753045637104E-4]:3.44566390445E1)[&rate=8.929037701224505E-4]:3.633506812563E1)[&rate=5.633341908903434E-4]:8.750663895632E0)[&rate=0.0016812837993772415]:4.619078438895E1);\ntree STATE_3 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55130.41961333657,EEF_ucld_branchRates=-266.168517335019,lnP=-55130.41961333657,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.265597592001004E-4]:8.894066579974E0,9[&rate=4.942008716248169E-4]:8.894066579974E0)[&rate=4.942008716248169E-4]:7.413297552034E0,15[&rate=6.10615555232763E-4]:1.630736413201E1)[&rate=8.701281634825918E-4]:1.05429721927E2,(14[&rate=0.0014487090019437137]:5.06709934125E1,24[&rate=8.146421786052459E-4]:5.06709934125E1)[&rate=8.146421786052459E-4]:7.106609264646E1)[&rate=4.751169591625182E-4]:5.833296334621E0,((((((11[&rate=8.505166446613319E-4]:1.634423124338E1,29[&rate=5.705675442978731E-4]:1.634423124338E1)[&rate=8.146421786052459E-4]:5.602972737291E1,(33[&rate=8.146421786052459E-4]:5.777494628604E1,13[&rate=4.3578784528673376E-4]:5.777494628604E1)[&rate=3.0911402456563987E-4]:1.459901233025E1)[&rate=7.82343550272916E-4]:8.155563134595E-1,(19[&rate=5.903294744818761E-4]:1.638856103265E1,18[&rate=6.315659485059258E-4]:1.638856103265E1)[&rate=3.0911402456563987E-4]:5.680095389711E1)[&rate=9.380981198301507E-4]:2.853521681698E0,((10[&rate=8.505166446613319E-4]:1.703364988461E1,31[&rate=7.672816849567449E-4]:1.703364988461E1)[&rate=3.0911402456563987E-4]:5.806754549172E1,23[&rate=5.416248355097677E-4]:7.510119537633E1)[&rate=3.265597592001004E-4]:9.418412351273E-1)[&rate=3.93015342484971E-4]:2.437479239093E0,(25[&rate=6.423383786150817E-4]:7.682180135581E1,(12[&rate=6.315659485059258E-4]:7.577173523112E1,((((((3[&rate=5.705675442978731E-4]:2.936515268322E0,4[&rate=8.505166446613319E-4]:2.936515268322E0)[&rate=2.1750220322459818E-4]:2.172176350139E-1,2[&rate=0.0010274124997002878]:3.153732903336E0)[&rate=4.0421281044251186E-4]:8.987374165034E0,5[&rate=7.389536873156429E-4]:1.214110706837E1)[&rate=4.8468639813685797E-4]:2.457582565629E0,((7[&rate=6.423383786150817E-4]:9.212323691408E0,6[&rate=7.672816849567449E-4]:9.212323691408E0)[&rate=4.0421281044251186E-4]:7.637319843259E-1,1[&rate=4.942008716248169E-4]:9.976055675733E0)[&rate=6.003985464770884E-4]:4.622633958265E0)[&rate=6.423383786150817E-4]:5.726832544213E1,((30[&rate=9.943565750886703E-4]:5.150924347901E1,26[&rate=6.879378317525299E-4]:5.150924347901E1)[&rate=5.8039128041587E-4]:1.133732447301E1,32[&rate=3.93015342484971E-4]:6.284656795201E1)[&rate=4.3578784528673376E-4]:9.020447124121E0)[&rate=4.1502840590154513E-4]:2.823845134801E0,(16[&rate=5.22614015543845E-4]:4.151054091098E1,((22[&rate=0.001161169638341848]:3.754401843862E0,21[&rate=3.41991848716285E-4]:3.754401843862E0)[&rate=5.511999195063704E-4]:3.773258461487E0,20[&rate=4.255342167536232E-4]:7.527660305349E0)[&rate=0.0012267035700506072]:3.398288060563E1)[&rate=9.943565750886703E-4]:3.318031929996E1)[&rate=6.761103258563157E-4]:1.080875020185E0)[&rate=6.003985464770884E-4]:1.050066124693E0)[&rate=5.8039128041587E-4]:1.658714494734E0)[&rate=2.6174426815780483E-4]:2.166873964637E0,(17[&rate=7.126296315507377E-4]:7.250086945452E1,(27[&rate=6.315659485059258E-4]:2.824953325732E1,28[&rate=9.648256352788107E-4]:2.824953325732E1)[&rate=7.126296315507377E-4]:4.42513361972E1)[&rate=5.131462011710763E-4]:8.146520360661E0)[&rate=0.0017433905122138903]:4.69229925784E1);\ntree STATE_4 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55126.8531958235,EEF_ucld_branchRates=-266.168517335019,lnP=-55126.8531958235,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.958942865018653E-4]:7.980119830523E0,9[&rate=9.409357824418734E-4]:7.980119830523E0)[&rate=6.610092205557259E-4]:9.223074287036E0,15[&rate=5.640136042441317E-4]:1.720319411756E1)[&rate=7.215697147735745E-4]:1.03177976948E2,(14[&rate=0.001248797926431693]:5.101128745215E1,24[&rate=6.722214893654888E-4]:5.101128745215E1)[&rate=7.497794765887603E-4]:6.936988361345E1)[&rate=7.353173396272015E-4]:8.822578757667E0,((((((11[&rate=3.9537745351246215E-4]:1.765872030356E1,29[&rate=5.382771944612292E-4]:1.765872030356E1)[&rate=5.909167208060052E-4]:5.419026786031E1,(33[&rate=7.985752942302799E-4]:6.316680123389E1,13[&rate=4.1353642275682276E-4]:6.316680123389E1)[&rate=4.724598795905389E-4]:8.682186929977E0)[&rate=3.1712040905343885E-4]:1.253812802757E0,(19[&rate=5.298892934733114E-4]:1.589259478781E1,18[&rate=3.7604225355936045E-4]:1.589259478781E1)[&rate=5.640136042441317E-4]:5.721020617881E1)[&rate=4.0457609240361424E-4]:2.081218457384E0,((10[&rate=7.497794765887603E-4]:1.945417539857E1,31[&rate=8.591706622637619E-4]:1.945417539857E1)[&rate=3.3088217628321384E-4]:5.288462770702E1,23[&rate=6.097207020583551E-4]:7.233880310559E1)[&rate=3.1712040905343885E-4]:2.845216318423E0)[&rate=5.909167208060052E-4]:3.054949333202E0,(25[&rate=6.194411577770008E-4]:7.58509417795E1,(12[&rate=7.497794765887603E-4]:7.475059929462E1,((((((2[&rate=2.829135888180607E-4]:2.001651737464E0,4[&rate=6.097207020583551E-4]:2.001651737464E0)[&rate=5.817931495393205E-4]:9.191328349034E-1,3[&rate=6.722214893654888E-4]:2.920784572367E0)[&rate=8.372491380981624E-4]:1.021254595552E1,5[&rate=4.309059958531765E-4]:1.313333052788E1)[&rate=5.298892934733114E-4]:1.191963161146E0,((7[&rate=2.587163745161979E-4]:7.672308163403E0,6[&rate=4.5604259774885127E-4]:7.672308163403E0)[&rate=3.1712040905343885E-4]:8.614395739519E-1,1[&rate=2.829135888180607E-4]:8.533747737355E0)[&rate=7.650569687331224E-4]:5.791545951675E0)[&rate=5.215741123647838E-4]:5.790429613034E1,(16[&rate=3.7604225355936045E-4]:3.726786587316E1,((22[&rate=5.382771944612292E-4]:4.601106475017E0,21[&rate=8.833351477230477E-4]:4.601106475017E0)[&rate=5.553253287454143E-4]:4.338651081466E0,20[&rate=4.1353642275682276E-4]:8.939757556483E0)[&rate=0.001248797926431693]:2.832810831667E1)[&rate=6.958942865018653E-4]:3.496172394621E1)[&rate=9.409357824418734E-4]:4.426704831428E-1,((30[&rate=4.5604259774885127E-4]:5.307649583204E1,26[&rate=7.497794765887603E-4]:5.307649583204E1)[&rate=5.05108814335137E-4]:1.197683243844E1,32[&rate=4.642723446600494E-4]:6.505332827048E1)[&rate=5.728309913069172E-4]:7.618932032031E0)[&rate=7.084523981412808E-4]:2.078338992111E0)[&rate=3.1712040905343885E-4]:1.100342484881E0)[&rate=3.8588809152273316E-4]:2.388026977709E0)[&rate=5.382771944612292E-4]:3.035731214114E0,(17[&rate=6.00219506518633E-4]:7.432933597559E1,(27[&rate=3.9537745351246215E-4]:2.231170885024E1,28[&rate=0.001248797926431693]:2.231170885024E1)[&rate=4.887745314023434E-4]:5.201762712535E1)[&rate=4.724598795905389E-4]:6.94536399574E0)[&rate=0.0010188069351768198]:4.792904985194E1);\ntree STATE_5 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55145.76743416705,EEF_ucld_branchRates=-266.168517335019,lnP=-55145.76743416705,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.284586511296035E-4]:8.988874526607E0,9[&rate=0.0010471110139599945]:8.988874526607E0)[&rate=5.908358205426717E-4]:7.928595389068E0,15[&rate=3.460062796952484E-4]:1.691746991568E1)[&rate=8.125679624771528E-4]:9.921611174144E1,(14[&rate=9.421785681549233E-4]:5.130690722185E1,24[&rate=0.0012070475179313683]:5.130690722185E1)[&rate=7.410352212910093E-4]:6.482667443527E1)[&rate=9.000792418668197E-4]:1.200611009043E1,((((((33[&rate=7.153337011779748E-4]:5.842881509979E1,13[&rate=3.627281830402541E-4]:5.842881509979E1)[&rate=6.337412372369671E-4]:1.071371659715E1,(11[&rate=5.180614876118372E-4]:2.034846120923E1,29[&rate=6.560099401022837E-4]:2.034846120923E1)[&rate=6.228379023599891E-4]:4.879407048771E1)[&rate=8.625345666663701E-4]:2.665594421781E0,(19[&rate=0.0010471110139599945]:1.51406130555E1,18[&rate=7.029600340048602E-4]:1.51406130555E1)[&rate=3.460062796952484E-4]:5.666751306321E1)[&rate=5.284586511296035E-4]:5.095848167399E0,((10[&rate=6.674139007013036E-4]:2.856364207015E1,31[&rate=5.284586511296035E-4]:2.856364207015E1)[&rate=4.8643511888398524E-4]:4.521779247635E1,23[&rate=5.388228102025428E-4]:7.378143454651E1)[&rate=6.908658097291864E-4]:3.122539739603E0)[&rate=5.908358205426717E-4]:3.079034066281E0,((12[&rate=6.790250871653466E-4]:7.763060079507E1,((((((2[&rate=4.5352658208501766E-4]:1.910014604064E0,4[&rate=8.125679624771528E-4]:1.910014604064E0)[&rate=3.2712355195446647E-4]:6.65789620126E-1,3[&rate=8.808114590305644E-4]:2.57580422419E0)[&rate=3.047968895958437E-4]:1.095785793515E1,5[&rate=3.2712355195446647E-4]:1.353366215934E1)[&rate=0.0011583937692474851]:1.783660033855E0,((7[&rate=4.6469975843316035E-4]:6.501123400863E0,1[&rate=4.054427798861477E-4]:6.501123400863E0)[&rate=4.5352658208501766E-4]:1.690132196315E0,6[&rate=7.824908990682705E-4]:8.191255597178E0)[&rate=6.120642048620072E-4]:7.126066596018E0)[&rate=4.054427798861477E-4]:5.838444479636E1,((30[&rate=9.653902776980304E-4]:5.40607752468E1,26[&rate=8.285040884213225E-4]:5.40607752468E1)[&rate=3.2712355195446647E-4]:1.426443361425E1,32[&rate=4.4208479377401443E-4]:6.832520886104E1)[&rate=6.560099401022837E-4]:5.376558128517E0)[&rate=8.808114590305644E-4]:2.444804418705E0,(16[&rate=4.1813155165534464E-4]:3.97711590757E1,((22[&rate=6.560099401022837E-4]:3.541575892245E0,21[&rate=5.595338598108015E-4]:3.541575892245E0)[&rate=7.029600340048602E-4]:4.183779224866E0,20[&rate=6.120642048620072E-4]:7.72535511711E0)[&rate=0.0015864841418225762]:3.204580395859E1)[&rate=9.000792418668197E-4]:3.637541233256E1)[&rate=0.001079881489430989]:1.484029386803E0)[&rate=0.0012070475179313683]:1.401657878161E0,25[&rate=8.625345666663701E-4]:7.903225867323E1)[&rate=3.627281830402541E-4]:9.50749679163E-1)[&rate=8.285040884213225E-4]:5.02117290093E0,(17[&rate=7.029600340048602E-4]:7.96764124044E1,(27[&rate=8.125679624771528E-4]:2.269779704707E1,28[&rate=0.0015864841418225762]:2.269779704707E1)[&rate=4.1813155165534464E-4]:5.697861535733E1)[&rate=6.228379023599891E-4]:5.327768848926E0)[&rate=0.0015864841418225762]:4.313551049422E1);\ntree STATE_6 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55144.54150481558,EEF_ucld_branchRates=-266.168517335019,lnP=-55144.54150481558,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.108844231103969E-4]:7.955882687067E0,9[&rate=7.348718044447107E-4]:7.955882687067E0)[&rate=7.494268552672629E-4]:5.657522898089E0,15[&rate=7.803986358025438E-4]:1.361340558516E1)[&rate=7.969658964307591E-4]:1.003067745303E2,(14[&rate=0.001039896461485491]:4.792907794861E1,24[&rate=8.950853810921544E-4]:4.792907794861E1)[&rate=9.18970292372757E-4]:6.599110216682E1)[&rate=4.8101491702899206E-4]:8.2444271805E0,((((((33[&rate=8.327423379615736E-4]:5.557398785595E1,13[&rate=4.3155844893080406E-4]:5.557398785595E1)[&rate=5.904913645567397E-4]:9.642669307268E0,(11[&rate=2.4625055767745364E-4]:1.858762646732E1,29[&rate=4.3155844893080406E-4]:1.858762646732E1)[&rate=6.691886824036259E-4]:4.66290306959E1)[&rate=8.143761741214832E-4]:1.783851581137E0,(19[&rate=6.691886824036259E-4]:1.183730052356E1,18[&rate=7.803986358025438E-4]:1.183730052356E1)[&rate=2.934137251783608E-4]:5.51632082208E1)[&rate=2.934137251783608E-4]:7.649717365423E0,((10[&rate=5.697810568202703E-4]:2.803638106574E1,31[&rate=7.494268552672629E-4]:2.803638106574E1)[&rate=2.934137251783608E-4]:4.503702719086E1,23[&rate=6.454655406327056E-4]:7.30734082566E1)[&rate=5.904913645567397E-4]:1.576817853175E0)[&rate=3.6606049984949906E-4]:1.858445220136E0,(((12[&rate=8.143761741214832E-4]:6.964625469802E1,((30[&rate=7.969658964307591E-4]:4.907880463414E1,26[&rate=7.969658964307591E-4]:4.907880463414E1)[&rate=5.697810568202703E-4]:1.076849126568E1,32[&rate=4.002023144112605E-4]:5.984729589982E1)[&rate=5.004601287712626E-4]:9.798958798202E0)[&rate=4.8101491702899206E-4]:2.198775843852E0,(((((3[&rate=6.454655406327056E-4]:2.285714804425E0,4[&rate=5.495819752387034E-4]:2.285714804425E0)[&rate=4.416420555522912E-4]:3.375925370235E-1,2[&rate=3.108844231103969E-4]:2.623307341449E0)[&rate=0.0011268265720498088]:9.740736549966E0,5[&rate=3.6606049984949906E-4]:1.236404389141E1)[&rate=6.691886824036259E-4]:1.159316423671E0,((7[&rate=3.6606049984949906E-4]:7.820966364996E0,1[&rate=3.2638033838140073E-4]:7.820966364996E0)[&rate=6.340234452907275E-4]:1.263130797375E0,6[&rate=5.800637825216852E-4]:9.08409716237E0)[&rate=6.571782513638765E-4]:4.439263152715E0)[&rate=4.8101491702899206E-4]:5.826423059292E1,(16[&rate=5.297620622883042E-4]:3.779962479098E1,((22[&rate=0.0013481621073408816]:2.500003858253E0,21[&rate=6.118536497275481E-4]:2.500003858253E0)[&rate=2.934137251783608E-4]:4.849467472039E0,20[&rate=5.697810568202703E-4]:7.349471330292E0)[&rate=0.0011829928119369655]:3.045015346069E1)[&rate=0.0014934952487071801]:3.398796611703E1)[&rate=3.7787319673645604E-4]:5.743963386595E-2)[&rate=0.0010800447091355203]:2.76819223881E0,25[&rate=4.21317975242315E-4]:7.461322278069E1)[&rate=4.7126432698663015E-4]:1.895448549227E0)[&rate=5.396326928710295E-4]:3.70669900166E0,(17[&rate=6.010817097299917E-4]:7.110267934528E1,(27[&rate=5.101922380876828E-4]:2.324542241963E1,28[&rate=9.732736829684972E-4]:2.324542241963E1)[&rate=7.348718044447107E-4]:4.785725692565E1)[&rate=9.732736829684972E-4]:9.112690986297E0)[&rate=0.0018151640084546265]:4.194923696436E1);\ntree STATE_7 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55139.606098843455,EEF_ucld_branchRates=-266.168517335019,lnP=-55139.606098843455,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.918336287308795E-4]:8.478416193732E0,9[&rate=6.639279206747258E-4]:8.478416193732E0)[&rate=8.568924495181643E-4]:4.322871358967E0,15[&rate=6.028420142321957E-4]:1.28012875527E1)[&rate=8.171839914685901E-4]:1.027059985315E2,(14[&rate=0.0012518434347777]:5.161156317833E1,24[&rate=9.798010383990643E-4]:5.161156317833E1)[&rate=0.0010298204045832832]:6.389572290591E1)[&rate=3.764791629315091E-4]:9.909184582795E0,((((((33[&rate=7.931902660484254E-4]:5.99810205214E1,13[&rate=5.408553980551688E-4]:5.99810205214E1)[&rate=6.819382241949344E-4]:9.599088077016E0,(11[&rate=7.194677018811897E-4]:1.149131987741E1,29[&rate=8.568924495181643E-4]:1.149131987741E1)[&rate=6.462588680966214E-4]:5.808878872102E1)[&rate=4.44793041354612E-4]:1.160336512014E0,(19[&rate=5.767280971809501E-4]:1.376113875644E1,18[&rate=6.288185299355163E-4]:1.376113875644E1)[&rate=3.764791629315091E-4]:5.6979306354E1)[&rate=7.098556240374042E-4]:2.344605743065E0,((10[&rate=5.679144468930618E-4]:2.669893117301E1,31[&rate=4.153593321641355E-4]:2.669893117301E1)[&rate=5.941739184399428E-4]:4.557846763056E1,23[&rate=5.767280971809501E-4]:7.227739880357E1)[&rate=8.430797087493373E-4]:8.076520499289E-1)[&rate=9.384002540748842E-4]:4.579936885422E0,((12[&rate=8.298661374521401E-4]:7.530725677595E1,(((30[&rate=7.392633226221438E-4]:5.2879631128E1,26[&rate=3.764791629315091E-4]:5.2879631128E1)[&rate=6.375170443662108E-4]:1.304824673362E1,32[&rate=4.153593321641355E-4]:6.592787786163E1)[&rate=5.767280971809501E-4]:7.451037254396E0,((16[&rate=4.81008847690627E-4]:2.908838755594E1,((22[&rate=7.004082768833333E-4]:3.265696793873E0,21[&rate=5.408553980551688E-4]:3.265696793873E0)[&rate=6.639279206747258E-4]:3.797931351536E0,20[&rate=7.004082768833333E-4]:7.063628145408E0)[&rate=0.0010034835900562802]:2.202475941053E1)[&rate=8.171839914685901E-4]:4.244319416695E1,((((3[&rate=7.931902660484254E-4]:1.723851408008E0,4[&rate=0.0011346632468586867]:1.723851408008E0)[&rate=6.911080090910009E-4]:8.039436890888E-1,2[&rate=9.582365680495075E-4]:2.527795097097E0)[&rate=8.430797087493373E-4]:7.776369872838E0,5[&rate=4.81008847690627E-4]:1.030416496994E1)[&rate=7.292634449016973E-4]:2.278033156915E0,((7[&rate=4.153593321641355E-4]:7.372440745986E0,1[&rate=8.568924495181643E-4]:7.372440745986E0)[&rate=8.049753592624887E-4]:8.235312315438E-1,6[&rate=4.44793041354612E-4]:8.19597197753E0)[&rate=6.911080090910009E-4]:4.38622614932E0)[&rate=4.696568764218469E-4]:5.894938359604E1)[&rate=6.639279206747258E-4]:1.847333393132E0)[&rate=0.0010939088957497528]:1.928341659926E0)[&rate=8.298661374521401E-4]:8.357023619646E-1,25[&rate=6.114954201077676E-4]:7.614295913791E1)[&rate=5.315426239923827E-4]:1.522028601009E0)[&rate=5.315426239923827E-4]:1.8972803421E0,(17[&rate=9.199994915472741E-4]:6.969147751835E1,(27[&rate=6.550578534854667E-4]:2.489346528299E1,28[&rate=0.0011851024787387632]:2.489346528299E1)[&rate=7.292634449016973E-4]:4.479801223535E1)[&rate=3.976811937377634E-4]:9.870790562674E0)[&rate=0.001565624262773543]:4.585420258601E1);\ntree STATE_8 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55121.9401125964,EEF_ucld_branchRates=-266.168517335019,lnP=-55121.9401125964,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.390036884662745E-4]:8.569827855552E0,9[&rate=7.148944740861485E-4]:8.569827855552E0)[&rate=4.111919487725629E-4]:5.336238860854E0,15[&rate=8.415160265552725E-4]:1.390606671641E1)[&rate=6.885708657971076E-4]:1.076562283553E2,(14[&rate=0.0010935024897558156]:4.44758725026E1,24[&rate=7.938532807515849E-4]:4.44758725026E1)[&rate=9.98941207085299E-4]:7.70864225691E1)[&rate=6.467921533664746E-4]:7.891283140837E0,((((((33[&rate=8.288545851635866E-4]:5.638492094622E1,13[&rate=5.816301159805759E-4]:5.638492094622E1)[&rate=7.059804355164878E-4]:1.277382900037E1,(11[&rate=7.239706214440401E-4]:1.375568193973E1,29[&rate=8.050795589021622E-4]:1.375568193973E1)[&rate=8.415160265552725E-4]:5.540306800687E1)[&rate=8.050795589021622E-4]:2.078856011333E0,(19[&rate=3.907034858927431E-4]:1.629216678805E1,18[&rate=9.750878972317062E-4]:1.629216678805E1)[&rate=4.8022185338086E-4]:5.494543916988E1)[&rate=6.800440455403049E-4]:3.74144215303E0,((10[&rate=5.478082941919665E-4]:2.556548599373E1,31[&rate=5.980270197984777E-4]:2.556548599373E1)[&rate=4.282189767326637E-4]:4.678817562986E1,23[&rate=5.564463449789085E-4]:7.235366162359E1)[&rate=7.52366084311699E-4]:2.62538648737E0)[&rate=6.6327407058424E-4]:2.349951736231E0,((12[&rate=5.816301159805759E-4]:7.44228011961E1,((((((3[&rate=8.167293393070538E-4]:2.592413994882E0,4[&rate=4.111919487725629E-4]:2.592413994882E0)[&rate=7.938532807515849E-4]:2.100055829489E-1,2[&rate=5.64946524516647E-4]:2.802419577831E0)[&rate=0.0011387832826387782]:8.071258714626E0,5[&rate=4.910415268946466E-4]:1.087367829246E1)[&rate=7.059804355164878E-4]:8.787905250732E-1,((7[&rate=3.907034858927431E-4]:7.075170396849E0,1[&rate=6.142751389141861E-4]:7.075170396849E0)[&rate=8.288545851635866E-4]:4.974720350764E-1,6[&rate=0.0010568175604813673]:7.572642431925E0)[&rate=5.478082941919665E-4]:4.179826385605E0)[&rate=7.059804355164878E-4]:5.768785235264E1,((30[&rate=8.288545851635866E-4]:4.974078530311E1,26[&rate=6.972112682849033E-4]:4.974078530311E1)[&rate=6.142751389141861E-4]:1.004351171893E1,32[&rate=3.907034858927431E-4]:5.978429702204E1)[&rate=0.0010568175604813673]:9.65602414813E0)[&rate=4.111919487725629E-4]:3.335888055971E0,(16[&rate=5.816301159805759E-4]:3.231957233018E1,((22[&rate=6.550036882246595E-4]:2.864163877644E0,21[&rate=9.98941207085299E-4]:2.864163877644E0)[&rate=4.910415268946466E-4]:5.674572573211E0,20[&rate=6.467921533664746E-4]:8.538736450855E0)[&rate=0.001287743773141506]:2.378083587933E1)[&rate=7.938532807515849E-4]:4.045663689596E1)[&rate=6.885708657971076E-4]:1.646591969959E0)[&rate=4.5646187356434854E-4]:1.041112882466E0,25[&rate=6.304939004203264E-4]:7.546391407857E1)[&rate=4.282189767326637E-4]:1.865085768624E0)[&rate=8.991923453072178E-4]:6.919867862833E0,(17[&rate=7.72497460384424E-4]:7.647165777472E1,(27[&rate=5.112222246349429E-4]:2.470082187864E1,28[&rate=9.159588426583621E-4]:2.470082187864E1)[&rate=6.467921533664746E-4]:5.177083589608E1)[&rate=6.6327407058424E-4]:7.777209935308E0)[&rate=0.001287743773141506]:4.520471050251E1);\ntree STATE_9 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55146.36925630346,EEF_ucld_branchRates=-266.168517335019,lnP=-55146.36925630346,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=9.900943521228376E-4]:8.566569890503E0,9[&rate=5.433135397518505E-4]:8.566569890503E0)[&rate=6.804273413900265E-4]:6.277086816739E0,15[&rate=8.059067146432804E-4]:1.484365670724E1)[&rate=6.609779198317763E-4]:1.065965781742E2,(14[&rate=0.001367613207454145]:4.447686965261E1,24[&rate=0.0010501998779511644]:4.447686965261E1)[&rate=7.797491117500977E-4]:7.696336522878E1)[&rate=9.011638420358655E-4]:7.722728001715E0,((((((11[&rate=6.804273413900265E-4]:1.60379217911E1,29[&rate=4.463243318232039E-4]:1.60379217911E1)[&rate=9.207092330446259E-4]:5.924781772252E1,(33[&rate=8.059067146432804E-4]:6.201301344728E1,13[&rate=5.160874072124125E-4]:6.201301344728E1)[&rate=6.804273413900265E-4]:1.327272606634E1)[&rate=3.961065471325046E-4]:1.332560350732E0,(19[&rate=5.522474308271677E-4]:1.521033395577E1,18[&rate=7.006069132855943E-4]:1.521033395577E1)[&rate=3.148656661888777E-4]:6.140796590858E1)[&rate=6.14630594543138E-4]:9.790055382911E-1,((10[&rate=6.32858818950554E-4]:2.54283375525E1,31[&rate=6.514808297429242E-4]:2.54283375525E1)[&rate=3.8071465665445E-4]:5.179574533359E1,23[&rate=4.97345945695808E-4]:7.722408288609E1)[&rate=3.422568930152044E-4]:3.73222516552E-1)[&rate=5.433135397518505E-4]:1.873574258086E0,((12[&rate=8.343827763201443E-4]:7.668684498019E1,((16[&rate=7.925707941135308E-4]:3.370850759852E1,((22[&rate=7.554393576225315E-4]:3.212377496058E0,21[&rate=3.422568930152044E-4]:3.212377496058E0)[&rate=7.797491117500977E-4]:5.168235457732E0,20[&rate=3.6318951828364396E-4]:8.38061295379E0)[&rate=0.0011310687312062126]:2.532789464473E1)[&rate=7.925707941135308E-4]:4.040566103098E1,(((((3[&rate=0.0011856466719875327]:1.974868242742E0,4[&rate=6.237029088792836E-4]:1.974868242742E0)[&rate=8.198195682898914E-4]:6.539422188376E-1,2[&rate=5.252551418746944E-4]:2.628810461579E0)[&rate=8.496832031819567E-4]:7.567091998284E0,5[&rate=4.349226341211698E-4]:1.019590245986E1)[&rate=3.422568930152044E-4]:2.141161238837E0,((7[&rate=6.904159617076632E-4]:7.887989837536E0,1[&rate=3.8071465665445E-4]:7.887989837536E0)[&rate=7.554393576225315E-4]:1.057910877061E0,6[&rate=6.609779198317763E-4]:8.945900714597E0)[&rate=6.32858818950554E-4]:3.391162984103E0)[&rate=5.522474308271677E-4]:5.901318766983E1,((30[&rate=4.97345945695808E-4]:5.275632021792E1,26[&rate=5.877712449039174E-4]:5.275632021792E1)[&rate=6.804273413900265E-4]:8.545341977115E0,32[&rate=4.463243318232039E-4]:6.130166219503E1)[&rate=6.32858818950554E-4]:1.00485891735E1)[&rate=5.160874072124125E-4]:2.763917260968E0)[&rate=0.001018280354246158]:2.572676350692E0)[&rate=3.8071465665445E-4]:1.740312684115E0,25[&rate=0.001018280354246158]:7.84271576643E1)[&rate=5.788893631092454E-4]:1.043721996425E0)[&rate=5.877712449039174E-4]:5.066679650943E0,(17[&rate=7.925707941135308E-4]:7.479240481834E1,(27[&rate=5.067941110771175E-4]:2.621071082587E1,28[&rate=0.0010871177130776118]:2.621071082587E1)[&rate=8.198195682898914E-4]:4.858169399248E1)[&rate=5.700185452462508E-4]:9.745154493328E0)[&rate=0.0012581614934330278]:4.462540357144E1);\ntree STATE_10 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55124.727454768545,EEF_ucld_branchRates=-266.168517335019,lnP=-55124.727454768545,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=7.565387345008174E-4]:8.095261951754E0,9[&rate=0.0020761272207486634]:8.095261951754E0)[&rate=8.974064807418605E-4]:5.38957803014E0,15[&rate=4.087451471246129E-4]:1.348483998189E1)[&rate=6.80232642651083E-4]:1.0179428265E2,(14[&rate=0.0012394120327276351]:4.502012081775E1,24[&rate=9.794239443454064E-4]:4.502012081775E1)[&rate=0.0011176268948102466]:7.025900181416E1)[&rate=3.3951471514524165E-4]:7.313059721239E0,((((((33[&rate=6.106957905389321E-4]:5.681548913868E1,13[&rate=5.097035470267665E-4]:5.681548913868E1)[&rate=9.163351332549776E-4]:1.098355631626E1,(11[&rate=5.436660972299875E-4]:1.823147338128E1,29[&rate=5.548423344535778E-4]:1.823147338128E1)[&rate=7.172391449965775E-4]:4.956757207366E1)[&rate=3.936459112310721E-4]:9.609414166686E-1,(19[&rate=5.548423344535778E-4]:1.425110571161E1,18[&rate=8.79329944234177E-4]:1.425110571161E1)[&rate=4.981392193141693E-4]:5.450888116E1)[&rate=5.324356355089859E-4]:2.888490683775E0,((10[&rate=3.158047300469646E-4]:2.260064059613E1,31[&rate=7.431402510746801E-4]:2.260064059613E1)[&rate=3.3951471514524165E-4]:4.797669208578E1,23[&rate=7.300498368021334E-4]:7.057733268191E1)[&rate=7.172391449965775E-4]:1.071144873473E0)[&rate=6.682961277697795E-4]:1.455913871998E0,((12[&rate=8.79329944234177E-4]:6.875987826605E1,((16[&rate=3.158047300469646E-4]:2.87051588145E1,((22[&rate=0.001193627575632314]:2.453125231709E0,21[&rate=8.79329944234177E-4]:2.453125231709E0)[&rate=9.163351332549776E-4]:3.965975967039E0,20[&rate=8.293530212295146E-4]:6.419101198748E0)[&rate=0.0013567638882743948]:2.228605761576E1)[&rate=9.163351332549776E-4]:3.933680399551E1,(((30[&rate=5.211245841099812E-4]:5.041209427267E1,26[&rate=5.211245841099812E-4]:5.041209427267E1)[&rate=8.620132716269078E-4]:5.97089199802E0,32[&rate=3.158047300469646E-4]:5.638298627069E1)[&rate=4.229794115111491E-4]:7.774723505272E0,((((2[&rate=6.80232642651083E-4]:1.161920369672E0,4[&rate=0.0010556552688857452]:1.161920369672E0)[&rate=5.211245841099812E-4]:1.180375639585E0,3[&rate=9.794239443454064E-4]:2.342296009258E0)[&rate=8.974064807418605E-4]:7.316756904331E0,5[&rate=3.158047300469646E-4]:9.659052913589E0)[&rate=5.659883612847565E-4]:1.456063425613E0,((7[&rate=8.453771952631063E-4]:5.835932601117E0,6[&rate=6.448968926035843E-4]:5.835932601117E0)[&rate=0.001193627575632314]:1.847735793811E0,1[&rate=4.087451471246129E-4]:7.683668394928E0)[&rate=6.565240926033435E-4]:3.431447944273E0)[&rate=6.682961277697795E-4]:5.304259343676E1)[&rate=5.882772070818888E-4]:3.884253034054E0)[&rate=0.0015449087128659208]:7.179154560298E-1)[&rate=7.172391449965775E-4]:1.214675986695E0,25[&rate=7.565387345008174E-4]:6.997455425274E1)[&rate=6.106957905389321E-4]:3.129837174638E0)[&rate=4.863932278589192E-4]:5.170562193253E0,(17[&rate=0.0010283902386889695]:6.714130517087E1,(27[&rate=3.158047300469646E-4]:2.080957971762E1,28[&rate=0.0015449087128659208]:2.080957971762E1)[&rate=7.172391449965775E-4]:4.633172545325E1)[&rate=4.4956812243790716E-4]:1.113364844977E1)[&rate=0.001193627575632314]:4.431722873252E1);\ntree STATE_11 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55154.515035210075,EEF_ucld_branchRates=-266.168517335019,lnP=-55154.515035210075,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.6589707023059246E-4]:9.0872619867E0,9[&rate=5.364223393560873E-4]:9.0872619867E0)[&rate=6.581161829010711E-4]:4.870364343127E0,15[&rate=6.001912022882079E-4]:1.395762632983E1)[&rate=5.572074754252509E-4]:9.739215079023E1,(14[&rate=0.0010403629654011238]:4.664559059434E1,24[&rate=6.342408212006567E-4]:4.664559059434E1)[&rate=0.0014104897940793338]:6.470418652572E1)[&rate=5.892246828062797E-4]:1.843280254803E1,((((((19[&rate=4.955808312364502E-4]:1.455327889749E1,18[&rate=8.773955810916141E-4]:1.455327889749E1)[&rate=3.6589707023059246E-4]:5.673110566261E1,(11[&rate=5.05743561467904E-4]:1.875814735984E1,29[&rate=4.854191268531925E-4]:1.875814735984E1)[&rate=0.0010403629654011238]:5.252623720025E1)[&rate=2.698819676785777E-4]:4.029933831882E-1,(33[&rate=8.994773048365594E-4]:6.072623452952E1,13[&rate=2.698819676785777E-4]:6.072623452952E1)[&rate=4.2320774406403927E-4]:1.096114341376E1)[&rate=7.681204296520909E-4]:3.612995832506E0,((10[&rate=5.784172626460162E-4]:2.047728117534E1,31[&rate=4.854191268531925E-4]:2.047728117534E1)[&rate=4.752384124334228E-4]:5.334236257538E1,23[&rate=5.892246828062797E-4]:7.381964375072E1)[&rate=2.698819676785777E-4]:1.480730025066E0)[&rate=8.186059777909805E-4]:1.417635964988E0,((12[&rate=7.378299173180694E-4]:7.401520776112E1,(((((2[&rate=4.338587624786942E-4]:1.864262413142E0,4[&rate=8.186059777909805E-4]:1.864262413142E0)[&rate=4.5473147019727786E-4]:5.674842425133E-1,3[&rate=6.113358384298133E-4]:2.431746655655E0)[&rate=7.378299173180694E-4]:9.106502639456E0,5[&rate=4.5473147019727786E-4]:1.153824929511E1)[&rate=8.186059777909805E-4]:1.060087699058E0,((7[&rate=3.089733306653309E-4]:7.544064889519E0,6[&rate=6.226786278298425E-4]:7.544064889519E0)[&rate=3.249268411399915E-4]:1.167498116914E0,1[&rate=2.698819676785777E-4]:8.711563006433E0)[&rate=7.681204296520909E-4]:3.886773987735E0)[&rate=3.6589707023059246E-4]:6.033013274983E1,(((30[&rate=8.371220950499353E-4]:5.578085235416E1,26[&rate=7.842001683872851E-4]:5.578085235416E1)[&rate=0.0011715429838948775]:6.670980003961E0,32[&rate=3.089733306653309E-4]:6.245183235812E1)[&rate=2.427479518955201E-4]:8.967948199312E0,(16[&rate=6.342408212006567E-4]:3.045805756457E1,((22[&rate=0.0011212389528720515]:2.147339326037E0,21[&rate=6.581161829010711E-4]:2.147339326037E0)[&rate=6.7048044543632E-4]:3.776378938581E0,20[&rate=4.012743933811985E-4]:5.923718264618E0)[&rate=0.0019189601608913052]:2.453433929995E1)[&rate=9.231344571198702E-4]:4.096172299286E1)[&rate=6.7048044543632E-4]:1.508689186568E0)[&rate=5.05743561467904E-4]:1.086738017119E0)[&rate=6.342408212006567E-4]:1.530584162235E0,25[&rate=7.842001683872851E-4]:7.554579192336E1)[&rate=0.0014104897940793338]:1.17221781742E0)[&rate=4.6501707945489755E-4]:2.477948035318E0,(17[&rate=0.0011715429838948775]:6.889849475946E1,(27[&rate=4.5473147019727786E-4]:2.847091508902E1,28[&rate=8.009995637084802E-4]:2.847091508902E1)[&rate=8.566698346578898E-4]:4.042757967044E1)[&rate=6.113358384298133E-4]:1.029746301663E1)[&rate=0.0014104897940793338]:5.0586621892E1);\ntree STATE_12 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55157.155388174986,EEF_ucld_branchRates=-266.168517335019,lnP=-55157.155388174986,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.549407163711136E-4]:9.237212614191E0,9[&rate=8.700229035677426E-4]:9.237212614191E0)[&rate=4.013281110871622E-4]:5.683589600134E0,15[&rate=4.4122624600277785E-4]:1.492080221433E1)[&rate=7.722657880420839E-4]:9.224454835667E1,(14[&rate=0.0011627372997929477]:4.434782796756E1,24[&rate=0.0011169430181629581]:4.434782796756E1)[&rate=0.0011627372997929477]:6.281752260343E1)[&rate=7.846505453339222E-4]:2.199724150413E1,((((((33[&rate=7.846505453339222E-4]:6.191185706921E1,13[&rate=3.6753569056112797E-4]:6.191185706921E1)[&rate=6.453719498370311E-4]:6.37308549237E0,(11[&rate=4.4122624600277785E-4]:2.169544447631E1,29[&rate=5.342612431328813E-4]:2.169544447631E1)[&rate=6.844293238555242E-4]:4.658949808526E1)[&rate=4.8539992719435175E-4]:1.448898210479E0,(19[&rate=5.248084394996597E-4]:1.075797236654E1,18[&rate=8.390289159714373E-4]:1.075797236654E1)[&rate=4.955623692927919E-4]:5.897586840552E1)[&rate=9.234872247763082E-4]:4.149530542963E0,((10[&rate=5.436132470412716E-4]:1.822802463047E1,31[&rate=6.172263883867203E-4]:1.822802463047E1)[&rate=3.6753569056112797E-4]:5.523186189473E1,23[&rate=5.987802242470426E-4]:7.34598865252E1)[&rate=6.35906765427893E-4]:4.234847898205E-1)[&rate=4.955623692927919E-4]:2.018003166238E0,(25[&rate=5.621059657824798E-4]:7.48169873301E1,((12[&rate=7.722657880420839E-4]:6.995284747091E1,(16[&rate=7.974664190715935E-4]:2.978169456473E1,((22[&rate=8.245947539194194E-4]:2.394321083169E0,21[&rate=9.04549375512589E-4]:2.394321083169E0)[&rate=6.453719498370311E-4]:6.015602641113E0,20[&rate=4.955623692927919E-4]:8.409923724282E0)[&rate=0.0014096038047440738]:2.137177084045E1)[&rate=0.0011169430181629581]:4.017115290618E1)[&rate=0.0014096038047440738]:1.661612763508E0,(((30[&rate=8.54141431297666E-4]:5.00595672351E1,26[&rate=5.712869688767864E-4]:5.00595672351E1)[&rate=8.54141431297666E-4]:9.268747231891E0,32[&rate=3.4606819816348567E-4]:5.932831446699E1)[&rate=4.013281110871622E-4]:9.92141148946E0,((((2[&rate=7.262499467059052E-4]:1.584583650241E0,4[&rate=7.154656690545067E-4]:1.584583650241E0)[&rate=3.180046976055937E-4]:5.686045510407E-1,3[&rate=6.744526087378945E-4]:2.153188201282E0)[&rate=7.154656690545067E-4]:7.543109868545E0,5[&rate=5.712869688767864E-4]:9.696298069827E0)[&rate=5.436132470412716E-4]:2.725922345153E0,((7[&rate=3.6753569056112797E-4]:7.474689952912E0,6[&rate=6.744526087378945E-4]:7.474689952912E0)[&rate=4.4122624600277785E-4]:9.362681276306E-1,1[&rate=6.744526087378945E-4]:8.410958080542E0)[&rate=5.712869688767864E-4]:4.011262334438E0)[&rate=6.844293238555242E-4]:5.682750554147E1)[&rate=9.04549375512589E-4]:2.364734277973E0)[&rate=8.390289159714373E-4]:3.20252709568E0)[&rate=8.390289159714373E-4]:1.084387151157E0)[&rate=3.180046976055937E-4]:4.668894258915E0,(17[&rate=6.945771841873951E-4]:7.106228232809E1,(27[&rate=6.744526087378945E-4]:2.221994934111E1,28[&rate=0.0010159428087795843]:2.221994934111E1)[&rate=5.436132470412716E-4]:4.884233298698E1)[&rate=9.896353561781568E-4]:9.507986412085E0)[&rate=0.0014096038047440738]:4.859232333495E1);\ntree STATE_13 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55132.68507874516,EEF_ucld_branchRates=-266.168517335019,lnP=-55132.68507874516,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.758058457353949E-4]:8.955668561954E0,9[&rate=6.631741946122945E-4]:8.955668561954E0)[&rate=4.573350758489119E-4]:5.898816585764E0,15[&rate=4.759871500750643E-4]:1.485448514772E1)[&rate=7.945340957059258E-4]:9.380501078005E1,(14[&rate=8.38589652933589E-4]:4.449291706563E1,24[&rate=9.354449400578019E-4]:4.449291706563E1)[&rate=9.608383499970157E-4]:6.416657886214E1)[&rate=0.0011757341926410616]:1.781724789846E1,(((25[&rate=6.820473462344158E-4]:7.31747700533E1,(((((((4[&rate=4.154266937654352E-4]:2.610328575045E0,2[&rate=4.759871500750643E-4]:2.610328575045E0)[&rate=0.0012731390146388081]:1.249421705328E0,3[&rate=6.103179253799095E-4]:3.859750280374E0)[&rate=8.727909142795875E-4]:8.991156234857E0,5[&rate=4.033704793154663E-4]:1.285090651523E1)[&rate=5.852348831588415E-4]:2.180385512041E0,((7[&rate=5.687594763393808E-4]:1.016825601032E1,6[&rate=4.759871500750643E-4]:1.016825601032E1)[&rate=7.945340957059258E-4]:1.934958949876E-1,1[&rate=5.935333782346822E-4]:1.036175190531E1)[&rate=4.2670378756619494E-4]:4.669540121965E0)[&rate=6.631741946122945E-4]:5.124103130833E1,((30[&rate=6.361667945953099E-4]:4.670481788035E1,26[&rate=8.084302908223347E-4]:4.670481788035E1)[&rate=5.769813236975734E-4]:8.034916971036E0,32[&rate=5.276382043475137E-4]:5.473973485139E1)[&rate=5.10891630405812E-4]:1.153258848421E1)[&rate=6.361667945953099E-4]:3.043867289032E0,(16[&rate=5.687594763393808E-4]:3.156305189163E1,((22[&rate=7.564992369646577E-4]:2.590103984927E0,21[&rate=7.226450443757622E-4]:2.590103984927E0)[&rate=9.608383499970157E-4]:3.187402419238E0,20[&rate=5.60555904900648E-4]:5.777506404165E0)[&rate=0.0011757341926410616]:2.578554548746E1)[&rate=7.335468998198809E-4]:3.7753138733E1)[&rate=5.35913626117201E-4]:3.769286160875E0,12[&rate=8.918716859079243E-4]:7.30854767855E1)[&rate=5.935333782346822E-4]:8.929326780076E-2)[&rate=4.759871500750643E-4]:9.850089175227E-1,((((11[&rate=3.3949671743888353E-4]:1.742154995075E1,29[&rate=6.018899743462611E-4]:1.742154995075E1)[&rate=9.354449400578019E-4]:5.117986570973E1,(33[&rate=7.686402084697027E-4]:5.297330864847E1,13[&rate=4.937443630127629E-4]:5.297330864847E1)[&rate=5.02379823772891E-4]:1.5628107012E1)[&rate=5.523567927143239E-4]:1.417688418508E0,(19[&rate=6.91803846308752E-4]:1.504360031851E1,18[&rate=7.945340957059258E-4]:1.504360031851E1)[&rate=4.759871500750643E-4]:5.497550376047E1)[&rate=5.10891630405812E-4]:2.601091598373E0,((10[&rate=6.820473462344158E-4]:2.499121319924E1,31[&rate=8.084302908223347E-4]:2.499121319924E1)[&rate=3.135226353074555E-4]:4.717627786596E1,23[&rate=5.523567927143239E-4]:7.21674910652E1)[&rate=7.120750945492981E-4]:4.527046121553E-1)[&rate=4.3737102392230347E-4]:1.539583293474E0)[&rate=7.226450443757622E-4]:2.307096506365E0,(17[&rate=9.126299575190982E-4]:5.866051275335E1,(27[&rate=4.3737102392230347E-4]:3.477236670925E1,28[&rate=8.727909142795875E-4]:3.477236670925E1)[&rate=0.0010621386109660028]:2.38881460441E1)[&rate=5.441477553518497E-4]:1.780636272384E1)[&rate=0.0010621386109660028]:5.000986834904E1);\ntree STATE_14 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55124.5324309916,EEF_ucld_branchRates=-266.168517335019,lnP=-55124.5324309916,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.0238974300974706E-4]:7.253261647156E0,9[&rate=7.589619695539044E-4]:7.253261647156E0)[&rate=4.12125220914992E-4]:9.12847796961E0,15[&rate=6.49488662929709E-4]:1.638173961677E1)[&rate=5.937913081567761E-4]:9.409701631642E1,(14[&rate=0.0011912096431048278]:3.975017094763E1,24[&rate=8.113152095820876E-4]:3.975017094763E1)[&rate=0.0010714071853514511]:7.072858498555E1)[&rate=0.0011912096431048278]:1.896636375338E1,(((25[&rate=5.532001622028132E-4]:7.702040980136E1,(((((30[&rate=6.867922426092057E-4]:5.322669526753E1,26[&rate=6.867922426092057E-4]:5.322669526753E1)[&rate=6.152746115961397E-4]:9.830725724288E0,32[&rate=5.054360693218599E-4]:6.305742099182E1)[&rate=3.6107510832553337E-4]:9.16676698079E0,((((4[&rate=5.833764828162061E-4]:2.545133773583E0,3[&rate=7.928743206654859E-4]:2.545133773583E0)[&rate=6.263883367892908E-4]:6.734250398319E-1,2[&rate=4.498633554042796E-4]:3.218558813415E0)[&rate=5.242584596740147E-4]:1.057147494149E1,5[&rate=2.610554530980564E-4]:1.379003375491E1)[&rate=9.557666380719462E-4]:1.481840703734E0,((7[&rate=4.591284695900369E-4]:8.082341653522E0,6[&rate=0.0010271238247065225]:8.082341653522E0)[&rate=3.498379695018622E-4]:1.062214003147E0,1[&rate=5.054360693218599E-4]:9.144555656668E0)[&rate=3.9246683832268596E-4]:6.127318801974E0)[&rate=5.242584596740147E-4]:5.695231351397E1)[&rate=3.2553373988403726E-4]:2.272653668302E0,(16[&rate=3.8231195227624335E-4]:3.955834005638E1,((22[&rate=8.745828059780699E-4]:2.3311208713E0,21[&rate=4.12125220914992E-4]:2.3311208713E0)[&rate=7.000866172578479E-4]:5.642908590651E0,20[&rate=5.054360693218599E-4]:7.974029461951E0)[&rate=7.432556040938871E-4]:3.158431059443E1)[&rate=8.309442916705051E-4]:3.493850158453E1)[&rate=9.260219058890646E-4]:1.6252466032E0,12[&rate=8.991390376618166E-4]:7.612208824411E1)[&rate=3.6107510832553337E-4]:8.983215572436E-1)[&rate=8.745828059780699E-4]:1.355851143839E0,((((11[&rate=5.532001622028132E-4]:1.843918890631E1,29[&rate=4.8684804404665983E-4]:1.843918890631E1)[&rate=5.630992831785108E-4]:4.987818528387E1,(33[&rate=9.557666380719462E-4]:6.191248818911E1,13[&rate=2.8069237175515924E-4]:6.191248818911E1)[&rate=0.0012808139267449761]:6.404886001057E0)[&rate=4.591284695900369E-4]:5.230652870352E0,(19[&rate=7.589619695539044E-4]:1.675519880094E1,18[&rate=4.0238974300974706E-4]:1.675519880094E1)[&rate=5.337957946257013E-4]:5.679282825959E1)[&rate=4.6836888147953556E-4]:1.241624356231E0,((10[&rate=4.12125220914992E-4]:2.360672107627E1,31[&rate=7.754659491959088E-4]:2.360672107627E1)[&rate=2.9732753100044225E-4]:5.044888055845E1,23[&rate=6.044167786381218E-4]:7.405560163472E1)[&rate=4.311774879701899E-4]:7.34049782038E-1)[&rate=3.2553373988403726E-4]:3.586609528442E0)[&rate=5.054360693218599E-4]:4.405361639629E0,(17[&rate=6.739561946859455E-4]:7.009305980529E1,(27[&rate=4.405536422032317E-4]:3.366976166682E1,28[&rate=0.0012808139267449761]:3.366976166682E1)[&rate=7.000866172578479E-4]:3.642329813847E1)[&rate=7.589619695539044E-4]:1.268856277953E1)[&rate=0.0012808139267449761]:4.666349710174E1);\ntree STATE_15 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55127.32527386783,EEF_ucld_branchRates=-266.168517335019,lnP=-55127.32527386783,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.118482569334975E-4]:6.321518292542E0,9[&rate=6.29726678209237E-4]:6.321518292542E0)[&rate=3.2680027085809873E-4]:8.71427131593E0,15[&rate=9.903668907412751E-4]:1.503578960847E1)[&rate=7.380959259644978E-4]:1.023627936744E2,(14[&rate=0.0014570815389533026]:4.511125849093E1,24[&rate=7.699321944751683E-4]:4.511125849093E1)[&rate=9.337868601339419E-4]:7.22873247919E1)[&rate=9.608868924009312E-4]:1.207580602174E1,(((25[&rate=6.176828843754559E-4]:7.138407651894E1,((((16[&rate=4.965370587508066E-4]:3.724325599135E1,((22[&rate=9.903668907412751E-4]:2.028826555418E0,21[&rate=4.441054909961613E-4]:2.028826555418E0)[&rate=7.230545092062196E-4]:5.008828354334E0,20[&rate=4.118482569334975E-4]:7.037654909752E0)[&rate=0.0013462024311208906]:3.02056010816E1)[&rate=8.633497447201288E-4]:2.896663049248E1,((((4[&rate=4.227342060687943E-4]:2.02696631264E0,2[&rate=3.6592529911581823E-4]:2.02696631264E0)[&rate=0.0010586265181049335]:2.904307151312E-1,3[&rate=4.546548402879399E-4]:2.317397027771E0)[&rate=5.070353433508079E-4]:9.570435488018E0,5[&rate=5.496998513929008E-4]:1.188783251579E1)[&rate=6.420339534374775E-4]:2.308240387501E0,((7[&rate=4.118482569334975E-4]:8.614176361928E0,6[&rate=8.045596740635029E-4]:8.614176361928E0)[&rate=5.070353433508079E-4]:4.767300970468E-1,1[&rate=3.5351534733626055E-4]:9.090906458975E0)[&rate=5.606220112799831E-4]:5.105166444316E0)[&rate=6.058784057544988E-4]:5.201381358054E1)[&rate=8.426842919861049E-4]:1.667961315908E0,((30[&rate=7.380959259644978E-4]:5.04377657877E1,26[&rate=5.388976984687352E-4]:5.04377657877E1)[&rate=4.546548402879399E-4]:9.016642100139E0,32[&rate=2.9602474210386353E-4]:5.945440788784E1)[&rate=6.944559650387033E-4]:8.423439911897E0)[&rate=0.0012642210870195954]:1.61318483846E0,12[&rate=0.001022724370661214]:6.94910326382E1)[&rate=0.0011991513786994866]:1.89304388074E0)[&rate=5.716821251482823E-4]:2.894091811389E0,((((33[&rate=0.0010586265181049335]:5.343781925382E1,13[&rate=5.716821251482823E-4]:5.343781925382E1)[&rate=2.568426757476306E-4]:1.415182400653E1,(11[&rate=8.426842919861049E-4]:1.81599302277E1,29[&rate=5.388976984687352E-4]:1.81599302277E1)[&rate=8.231315012729861E-4]:4.942971303264E1)[&rate=3.1208797145621144E-4]:1.854704279298E0,(19[&rate=3.778808891391027E-4]:1.496362657021E1,18[&rate=9.608868924009312E-4]:1.496362657021E1)[&rate=3.8947427028808847E-4]:5.448072096944E1)[&rate=0.0012642210870195954]:3.532769849838E0,((10[&rate=7.699321944751683E-4]:2.518060891621E1,31[&rate=5.388976984687352E-4]:2.518060891621E1)[&rate=3.405293272278505E-4]:4.713208943576E1,23[&rate=4.756140648089928E-4]:7.231269835197E1)[&rate=4.118482569334975E-4]:6.644190375151E-1)[&rate=4.8606971358347535E-4]:1.301050940842E0)[&rate=5.281979188612834E-4]:3.973045615446E0,(17[&rate=8.852861109288588E-4]:6.784665261012E1,(27[&rate=6.546307900569246E-4]:2.612596129496E1,28[&rate=0.0012642210870195954]:2.612596129496E1)[&rate=6.29726678209237E-4]:4.172069131517E1)[&rate=4.227342060687943E-4]:1.040456133565E1)[&rate=0.0014570815389533026]:5.12231753588E1);\ntree STATE_16 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55160.14298629151,EEF_ucld_branchRates=-266.168517335019,lnP=-55160.14298629151,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=7.36356383532107E-4]:7.59589354893E0,9[&rate=0.0011620402326078]:7.59589354893E0)[&rate=5.296066976212456E-4]:4.535024859767E0,15[&rate=5.942088904771761E-4]:1.21309184087E1)[&rate=7.36356383532107E-4]:1.112737502884E2,(14[&rate=9.938468527416538E-4]:4.625884361997E1,24[&rate=7.36356383532107E-4]:4.625884361997E1)[&rate=7.8514332711469E-4]:7.714582507715E1)[&rate=0.0011620402326078]:3.021929372181E0,(((25[&rate=6.055807748800204E-4]:7.600886195508E1,(((((((4[&rate=8.414718514233315E-4]:1.462174261868E0,2[&rate=4.988272486160912E-4]:1.462174261868E0)[&rate=4.379340646527872E-4]:6.486620532412E-1,3[&rate=4.0666323213377697E-4]:2.110836315109E0)[&rate=9.629465122293221E-4]:1.028669070209E1,5[&rate=3.239993441142344E-4]:1.23975270172E1)[&rate=9.347786471579876E-4]:2.223339018187E0,((7[&rate=4.684405913450021E-4]:7.114679108352E0,6[&rate=3.5000216052246763E-4]:7.114679108352E0)[&rate=4.886784285208488E-4]:1.289340975605E0,1[&rate=4.276334136752185E-4]:8.404020083957E0)[&rate=5.505742274465613E-4]:6.21684595143E0)[&rate=5.400343681870574E-4]:5.39350673863E1,((30[&rate=6.17179272099044E-4]:4.92164117078E1,26[&rate=7.213749476077792E-4]:4.92164117078E1)[&rate=5.942088904771761E-4]:1.165773257327E1,32[&rate=4.4815202371425273E-4]:6.087414428107E1)[&rate=2.93997772410455E-4]:7.681789140616E0)[&rate=3.736879211522297E-4]:1.114862637018E0,(16[&rate=3.8494833127585167E-4]:3.750682027101E1,((22[&rate=0.0013018931538154232]:3.12132718283E0,21[&rate=8.216795846220895E-4]:3.12132718283E0)[&rate=5.192742321792005E-4]:6.250751523375E0,20[&rate=4.1722094471814295E-4]:9.372078706205E0)[&rate=0.0011620402326078]:2.813474156481E1)[&rate=0.001223959887129298]:3.216397578769E1)[&rate=9.938468527416538E-4]:2.885021150128E0,12[&rate=5.400343681870574E-4]:7.255581720883E1)[&rate=3.8494833127585167E-4]:3.453044746254E0)[&rate=5.400343681870574E-4]:1.3673376839E0,((((11[&rate=5.612435381832351E-4]:1.620914494695E1,29[&rate=6.17179272099044E-4]:1.620914494695E1)[&rate=8.414718514233315E-4]:5.38250238073E1,(19[&rate=4.4815202371425273E-4]:1.721542613831E1,18[&rate=9.938468527416538E-4]:1.721542613831E1)[&rate=3.620693463415381E-4]:5.281874261594E1)[&rate=9.347786471579876E-4]:1.540847845411E0,(33[&rate=7.519321805323345E-4]:6.055285532981E1,13[&rate=6.7945039583527E-4]:6.055285532981E1)[&rate=9.088714358781018E-4]:1.102216126985E1)[&rate=3.5000216052246763E-4]:2.941065167121E0,((10[&rate=3.959212118797708E-4]:1.812565672046E1,31[&rate=7.069298325344E-4]:1.812565672046E1)[&rate=2.5572077704553574E-4]:5.436626475235E1,23[&rate=5.192742321792005E-4]:7.249192147281E1)[&rate=8.029451197239374E-4]:2.024160293975E0)[&rate=4.0666323213377697E-4]:2.860117872201E0)[&rate=5.090200806007932E-4]:5.155254799853E0,(17[&rate=9.347786471579876E-4]:6.846608139923E1,(27[&rate=5.612435381832351E-4]:2.284721914937E1,28[&rate=0.0013018931538154232]:2.284721914937E1)[&rate=6.411503311032941E-4]:4.561886224986E1)[&rate=3.096635299177424E-4]:1.406537303961E1)[&rate=0.0014071655987174226]:4.389514363046E1);\ntree STATE_17 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55143.38273308143,EEF_ucld_branchRates=-266.168517335019,lnP=-55143.38273308143,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.506555873556851E-4]:7.782559943303E0,9[&rate=4.4134343887960987E-4]:7.782559943303E0)[&rate=4.795290057618743E-4]:3.886493701882E0,15[&rate=5.295237023593705E-4]:1.166905364519E1)[&rate=9.874478348461955E-4]:9.434401092198E1,(14[&rate=0.0011380672227444576]:4.140097174971E1,24[&rate=8.371498644216759E-4]:4.140097174971E1)[&rate=8.617805661195788E-4]:6.461209281745E1)[&rate=0.0012129038251036403]:2.027672574672E1,(((25[&rate=6.595978307798603E-4]:7.578405838826E1,(((16[&rate=3.749228995664782E-4]:3.919324198424E1,((22[&rate=3.127711449059808E-4]:2.523869494099E0,21[&rate=7.366813638643875E-4]:2.523869494099E0)[&rate=0.0012129038251036403]:6.596889354711E0,20[&rate=7.198366130957052E-4]:9.120758848811E0)[&rate=0.001314217762520253]:3.007248313543E1)[&rate=0.0010295070770397566]:3.371750487466E1,(((30[&rate=8.371498644216759E-4]:5.091051873416E1,26[&rate=4.6030977385842076E-4]:5.091051873416E1)[&rate=5.399903353083351E-4]:8.338346113434E0,32[&rate=5.726652849829668E-4]:5.924886484759E1)[&rate=4.0363270993555665E-4]:1.071153093659E1,((((4[&rate=8.371498644216759E-4]:2.009648719856E0,2[&rate=4.319144420999477E-4]:2.009648719856E0)[&rate=6.884435116591824E-4]:1.02356672841E0,3[&rate=4.698798128342713E-4]:3.033215448265E0)[&rate=3.4503991728950775E-4]:9.273018170191E0,5[&rate=3.941413644910323E-4]:1.230623361846E1)[&rate=3.3463164790819617E-4]:3.007315054923E0,((7[&rate=3.127711449059808E-4]:7.405224186519E0,6[&rate=5.295237023593705E-4]:7.405224186519E0)[&rate=7.930929148350972E-4]:1.434749012153E0,1[&rate=3.749228995664782E-4]:8.839973198672E0)[&rate=7.037859961249325E-4]:6.473575474709E0)[&rate=6.077355501000912E-4]:5.46468471108E1)[&rate=3.6513857614309795E-4]:2.950351074716E0)[&rate=8.371498644216759E-4]:8.526486969747E-1,12[&rate=7.198366130957052E-4]:7.376339555587E1)[&rate=3.749228995664782E-4]:2.020662832387E0)[&rate=4.698798128342713E-4]:4.042041478786E-1,((((33[&rate=5.726652849829668E-4]:5.640319059084E1,13[&rate=2.8882627607631475E-4]:5.640319059084E1)[&rate=2.6127515959781857E-4]:1.386073688442E1,(19[&rate=4.795290057618743E-4]:1.772321736202E1,18[&rate=7.731771059123632E-4]:1.772321736202E1)[&rate=4.5080302175045246E-4]:5.254071011324E1)[&rate=9.180184465772864E-4]:2.102766722736E0,(11[&rate=4.89273163642694E-4]:1.658910594997E1,29[&rate=3.941413644910323E-4]:1.658910594997E1)[&rate=6.595978307798603E-4]:5.577758824802E1)[&rate=3.127711449059808E-4]:2.104229074197E0,((10[&rate=5.19236459853593E-4]:2.529787114429E1,31[&rate=5.091104187669138E-4]:2.529787114429E1)[&rate=2.2625527042442634E-4]:4.900331340396E1,23[&rate=4.795290057618743E-4]:7.430118454825E1)[&rate=3.749228995664782E-4]:1.697387239375E-1)[&rate=3.4503991728950775E-4]:1.717339263947E0)[&rate=6.737353930319007E-4]:3.253259998037E0,(17[&rate=7.544214387129368E-4]:6.906637409058E1,(27[&rate=5.615399158351626E-4]:2.999544425304E1,28[&rate=0.0011380672227444576]:2.999544425304E1)[&rate=6.595978307798603E-4]:3.907092983754E1)[&rate=2.8882627607631475E-4]:1.037514844359E1)[&rate=0.0011380672227444576]:4.684826777971E1);\ntree STATE_18 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55107.989193203604,EEF_ucld_branchRates=-266.168517335019,lnP=-55107.989193203604,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=8.901499101678172E-4]:6.432815542754E0,9[&rate=0.0012424526694587287]:6.432815542754E0)[&rate=6.710917671905881E-4]:6.34007728269E0,15[&rate=8.139553509342538E-4]:1.277289282544E1)[&rate=7.811239635211544E-4]:1.007816193011E2,(14[&rate=0.0013177025627507883]:4.431760162153E1,24[&rate=9.121510518604724E-4]:4.431760162153E1)[&rate=0.0011326087490347988]:6.923691050505E1)[&rate=3.193121109636076E-4]:1.298411519767E1,(((25[&rate=6.961757940263124E-4]:7.870872969651E1,((12[&rate=9.121510518604724E-4]:7.338507991885E1,(16[&rate=5.386507872486772E-4]:4.040338179798E1,((22[&rate=8.901499101678172E-4]:3.558574226266E0,21[&rate=4.0127612537553043E-4]:3.558574226266E0)[&rate=7.365257678052527E-4]:6.773835594906E0,20[&rate=6.130240660966053E-4]:1.033240982117E1)[&rate=0.0012424526694587287]:3.007097197681E1)[&rate=0.0014190139752666567]:3.298169812087E1)[&rate=3.355002141254822E-4]:2.513229787435E0,(((30[&rate=6.130240660966053E-4]:5.470721365309E1,26[&rate=5.593836233582823E-4]:5.470721365309E1)[&rate=9.121510518604724E-4]:8.565483861557E0,32[&rate=3.502799929766801E-4]:6.327269751465E1)[&rate=4.456891812553701E-4]:7.937948623335E0,((((4[&rate=0.0010898176834783474]:2.107766872221E0,3[&rate=2.519446732150179E-4]:2.107766872221E0)[&rate=3.8938227261411625E-4]:3.934031917792E-1,2[&rate=6.3557818399442E-4]:2.501170064001E0)[&rate=6.3557818399442E-4]:7.165919578443E0,5[&rate=5.181255781187556E-4]:9.667089642444E0)[&rate=3.6403353576627666E-4]:3.573475695282E0,((7[&rate=4.8741025438541667E-4]:8.850671530135E0,6[&rate=7.50855425062406E-4]:8.850671530135E0)[&rate=4.456891812553701E-4]:1.268487269741E0,1[&rate=4.239878242831944E-4]:1.011915879988E1)[&rate=4.3493912970669E-4]:3.121406537849E0)[&rate=5.593836233582823E-4]:5.797008080026E1)[&rate=5.489826400145201E-4]:4.687663568305E0)[&rate=5.698706965416856E-4]:2.810419990222E0)[&rate=5.07896573635833E-4]:1.287885151112E0,((((11[&rate=4.6674251776796395E-4]:1.672505616658E1,29[&rate=5.911712884186903E-4]:1.672505616658E1)[&rate=5.593836233582823E-4]:5.891976849923E1,(33[&rate=9.611023675350458E-4]:6.353051344182E1,13[&rate=4.6674251776796395E-4]:6.353051344182E1)[&rate=5.489826400145201E-4]:1.211431122399E1)[&rate=0.0010188706897049764]:1.11304233315E0,(19[&rate=7.811239635211544E-4]:1.9577877511E1,18[&rate=6.242035907587395E-4]:1.9577877511E1)[&rate=3.8938227261411625E-4]:5.717998948797E1)[&rate=8.139553509342538E-4]:2.310539503629E0,((10[&rate=6.130240660966053E-4]:3.325315432695E1,31[&rate=5.07896573635833E-4]:3.325315432695E1)[&rate=4.3493912970669E-4]:4.46507936094E1,23[&rate=4.7711079393141924E-4]:7.790394793635E1)[&rate=8.315263240811577E-4]:1.164458566244E0)[&rate=7.50855425062406E-4]:9.282083450276E-1)[&rate=6.710917671905881E-4]:4.151794711775E0,(17[&rate=8.499979529494374E-4]:7.483537119704E1,(27[&rate=4.1278660635779704E-4]:3.486722617287E1,28[&rate=0.0012424526694587287]:3.486722617287E1)[&rate=7.657027589676421E-4]:3.996814502417E1)[&rate=9.611023675350458E-4]:9.313038362351E0)[&rate=0.0013177025627507883]:4.239021776486E1);\ntree STATE_19 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55124.2057170475,EEF_ucld_branchRates=-266.168517335019,lnP=-55124.2057170475,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.493417010500502E-4]:7.791353937659E0,9[&rate=0.001557620367623235]:7.791353937659E0)[&rate=4.614410768772295E-4]:6.369841425831E0,15[&rate=4.614410768772295E-4]:1.416119536349E1)[&rate=8.69492073058587E-4]:8.978410078825E1,(14[&rate=0.0012449540722595464]:4.284743901432E1,24[&rate=0.0012449540722595464]:4.284743901432E1)[&rate=0.0011880782445117311]:6.109785713742E1)[&rate=7.877293121546733E-4]:1.804246022327E1,(((25[&rate=6.274991794316059E-4]:7.353898119445E1,((((16[&rate=5.343145826798609E-4]:3.404258146905E1,((22[&rate=5.853947012549252E-4]:4.493473487512E0,21[&rate=3.0383899693477026E-4]:4.493473487512E0)[&rate=3.7602845849495244E-4]:3.6116140851E0,20[&rate=9.521784746829063E-4]:8.105087572612E0)[&rate=0.0010998313561239293]:2.593749389644E1)[&rate=0.0011880782445117311]:3.162949772349E1,((30[&rate=8.183188072976597E-4]:4.732596507844E1,26[&rate=5.139131596308786E-4]:4.732596507844E1)[&rate=7.074973499036084E-4]:1.290945112786E1,32[&rate=4.3918672161076533E-4]:6.02354162063E1)[&rate=5.546593802832314E-4]:5.436662986241E0)[&rate=9.76592057479047E-4]:3.914196259611E0,12[&rate=9.76592057479047E-4]:6.958627545215E1)[&rate=4.1560395954885456E-4]:5.986178841108E-1,((((4[&rate=8.345889885042045E-4]:2.248700960113E0,3[&rate=5.75097339214739E-4]:2.248700960113E0)[&rate=4.275978487294785E-4]:1.535232386654E-1,2[&rate=6.719091981385685E-4]:2.402224198778E0)[&rate=6.383396227698032E-4]:6.409881579153E0,5[&rate=8.027223624033441E-4]:8.812105777932E0)[&rate=5.036388536750526E-4]:1.55689301517E0,((7[&rate=2.7535994841271927E-4]:6.901638922428E0,1[&rate=4.7221812779165584E-4]:6.901638922428E0)[&rate=5.036388536750526E-4]:1.222218415549E0,6[&rate=5.75097339214739E-4]:8.123857337977E0)[&rate=8.883349468360984E-4]:2.245141455124E0)[&rate=6.274991794316059E-4]:5.981589454316E1)[&rate=4.932836967294983E-4]:3.354087858187E0)[&rate=0.0010998313561239293]:6.278441597535E-1,((((11[&rate=7.877293121546733E-4]:1.602897494916E1,29[&rate=4.614410768772295E-4]:1.602897494916E1)[&rate=8.516147254041381E-4]:5.055666762737E1,(33[&rate=9.08279963924997E-4]:6.052400809282E1,13[&rate=4.7221812779165584E-4]:6.052400809282E1)[&rate=5.853947012549252E-4]:6.061634483709E0)[&rate=5.343145826798609E-4]:2.60459457382E0,(19[&rate=6.719091981385685E-4]:1.203616954534E1,18[&rate=8.345889885042045E-4]:1.203616954534E1)[&rate=3.8997457354453306E-4]:5.715406760501E1)[&rate=7.877293121546733E-4]:1.920803775918E0,((10[&rate=5.343145826798609E-4]:2.327032116691E1,31[&rate=7.199231328859089E-4]:2.327032116691E1)[&rate=6.493417010500502E-4]:4.723501333558E1,23[&rate=3.610084319417902E-4]:7.050533450249E1)[&rate=3.610084319417902E-4]:6.057064237805E-1)[&rate=5.957667485360641E-4]:3.055784427929E0)[&rate=6.605247489599863E-4]:4.127531265988E0,(17[&rate=9.08279963924997E-4]:7.0424888936E1,(27[&rate=7.593171038305255E-4]:2.589367306633E1,28[&rate=0.001032007165044626]:2.589367306633E1)[&rate=9.08279963924997E-4]:4.453121586967E1)[&rate=5.648578991723382E-4]:7.869467684191E0)[&rate=0.001878877617909416]:4.369339975483E1);\ntree STATE_20 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55155.251432595986,EEF_ucld_branchRates=-266.168517335019,lnP=-55155.251432595986,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.2889524125691884E-4]:9.966285226242E0,9[&rate=8.060698961176745E-4]:9.966285226242E0)[&rate=3.454268860857848E-4]:4.393361858234E0,15[&rate=4.73735411169531E-4]:1.435964708448E1)[&rate=0.001007646336840171]:9.984393819121E1,(14[&rate=0.0011938738313120821]:4.51937544206E1,24[&rate=8.381280558770989E-4]:4.51937544206E1)[&rate=9.336152406331877E-4]:6.900983085509E1)[&rate=7.624074498087509E-4]:1.382796919186E1,(((25[&rate=5.771496034135573E-4]:7.873049603687E1,(((((((4[&rate=4.6290452418879777E-4]:1.743144264124E0,3[&rate=6.744955273107764E-4]:1.743144264124E0)[&rate=9.122702431591241E-4]:8.668466776283E-1,2[&rate=5.463736276724504E-4]:2.609990941752E0)[&rate=0.001251132254463214]:6.847873308336E0,5[&rate=3.9109306588456654E-4]:9.457864250088E0)[&rate=7.356134729295236E-4]:2.522005867896E0,((7[&rate=8.552570328576166E-4]:7.692595680257E0,6[&rate=3.9109306588456654E-4]:7.692595680257E0)[&rate=5.979307182563579E-4]:6.338877782184E-1,1[&rate=0.0010689809086246761]:8.326483458476E0)[&rate=8.381280558770989E-4]:3.653386659508E0)[&rate=8.732434468405376E-4]:5.895308231556E1,((30[&rate=5.979307182563579E-4]:5.180116358097E1,26[&rate=5.875024515519181E-4]:5.180116358097E1)[&rate=6.980908275306392E-4]:9.905466208501E0,32[&rate=5.053155976943182E-4]:6.170662978947E1)[&rate=9.56442745242499E-4]:9.226322644068E0)[&rate=5.566025098128166E-4]:4.177885925914E0,(16[&rate=4.84391113585074E-4]:3.590865696183E1,((22[&rate=0.0015659806923635875]:4.195019440328E0,21[&rate=5.361504266841202E-4]:4.195019440328E0)[&rate=9.56442745242499E-4]:4.04617438565E0,20[&rate=4.0428665774465584E-4]:8.241193825978E0)[&rate=0.0011938738313120821]:2.766746313585E1)[&rate=0.0011938738313120821]:3.920218139763E1)[&rate=2.2871239947086185E-4]:8.947128614426E-1,12[&rate=8.060698961176745E-4]:7.60055512209E1)[&rate=8.060698961176745E-4]:2.724944815968E0)[&rate=0.0011938738313120821]:1.269036028869E0,((((11[&rate=6.630468917428986E-4]:2.071121670816E1,29[&rate=6.190809300122877E-4]:2.071121670816E1)[&rate=8.922019967338077E-4]:5.123700488417E1,(33[&rate=5.463736276724504E-4]:6.568529269011E1,13[&rate=4.73735411169531E-4]:6.568529269011E1)[&rate=7.909875163297657E-4]:6.262928902223E0)[&rate=6.298371507540307E-4]:1.797583625918E0,(19[&rate=5.463736276724504E-4]:1.184201483627E1,18[&rate=5.053155976943182E-4]:1.184201483627E1)[&rate=4.2889524125691884E-4]:6.190379038198E1)[&rate=4.949074857696984E-4]:3.146609559497E0,((10[&rate=4.518563404766492E-4]:2.964778732308E1,31[&rate=6.407377087640634E-4]:2.964778732308E1)[&rate=5.668553197494677E-4]:4.501853792215E1,23[&rate=3.9109306588456654E-4]:7.466632524523E1)[&rate=6.518011382342693E-4]:2.226089532517E0)[&rate=6.630468917428986E-4]:3.107117287984E0)[&rate=4.73735411169531E-4]:4.975424921658E0,(17[&rate=8.217598028144925E-4]:7.464515799391E1,(27[&rate=4.73735411169531E-4]:2.598745928262E1,28[&rate=9.336152406331877E-4]:2.598745928262E1)[&rate=6.630468917428986E-4]:4.86576987113E1)[&rate=0.0011938738313120821]:1.032979899348E1)[&rate=0.0015659806923635875]:4.305659748016E1);\ntree STATE_21 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55127.968391203874,EEF_ucld_branchRates=-266.168517335019,lnP=-55127.968391203874,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.6620877109873176E-4]:1.065316195241E1,9[&rate=3.9248977365750285E-4]:1.065316195241E1)[&rate=7.122217956367653E-4]:4.41636372233E0,15[&rate=7.58603921192177E-4]:1.506952567474E1)[&rate=7.757105724939267E-4]:1.008788501231E2,(14[&rate=0.00116754096628117]:4.506741360646E1,24[&rate=7.757105724939267E-4]:4.506741360646E1)[&rate=0.0010060501255807345]:7.088096219141E1)[&rate=4.206989052048068E-4]:1.327005185815E1,(((25[&rate=5.599336829808822E-4]:7.701135214282E1,((((30[&rate=8.801685844439893E-4]:5.210644779827E1,26[&rate=5.40356476094704E-4]:5.210644779827E1)[&rate=5.69967210099984E-4]:7.980022569476E0,32[&rate=3.827683671838401E-4]:6.008647036775E1)[&rate=2.8962122600787517E-4]:1.052941888583E1,(12[&rate=6.714945456435572E-4]:6.652404833493E1,(16[&rate=4.7527391130743497E-4]:2.975402765597E1,((22[&rate=5.69967210099984E-4]:3.302727637011E0,21[&rate=3.6259399025384266E-4]:3.302727637011E0)[&rate=4.0202859886808047E-4]:5.340786517118E0,20[&rate=4.2988844752163104E-4]:8.643514154128E0)[&rate=0.0010060501255807345]:2.111051350184E1)[&rate=0.0011019352536023866]:3.677002067896E1)[&rate=4.8436665379179324E-4]:4.09184091865E0)[&rate=5.69967210099984E-4]:2.561737740664E0,((((4[&rate=4.11421283203048E-4]:2.239110944747E0,2[&rate=7.269563889940388E-4]:2.239110944747E0)[&rate=3.294707391416771E-4]:3.839203595214E-1,3[&rate=7.269563889940388E-4]:2.623031304268E0)[&rate=9.358563579790692E-4]:8.134540261231E0,5[&rate=4.935025083475585E-4]:1.07575715655E1)[&rate=4.11421283203048E-4]:1.237435040997E0,((7[&rate=3.5202144694948534E-4]:7.783759944073E0,6[&rate=7.938336725998552E-4]:7.783759944073E0)[&rate=4.2988844752163104E-4]:5.455708623035E-1,1[&rate=3.410179739749763E-4]:8.329330806377E0)[&rate=8.131265081268483E-4]:3.665675800119E0)[&rate=5.119639862389427E-4]:6.118262038775E1)[&rate=6.845513403308223E-4]:3.833725148578E0)[&rate=0.001690719015487785]:1.617981398433E0,((((11[&rate=3.172245905196809E-4]:1.598081606986E1,29[&rate=5.026966251445938E-4]:1.598081606986E1)[&rate=7.122217956367653E-4]:5.849457966789E1,(33[&rate=6.348636994287061E-4]:6.342549908624E1,13[&rate=3.9248977365750285E-4]:6.342549908624E1)[&rate=5.213195817914506E-4]:1.104989665151E1)[&rate=5.801884376963406E-4]:1.082697942566E0,(19[&rate=0.0010496225259700445]:1.597140251541E1,18[&rate=5.026966251445938E-4]:1.597140251541E1)[&rate=6.588889566018876E-4]:5.958669116491E1)[&rate=6.98108376337816E-4]:1.567827527474E0,((10[&rate=6.233716583741737E-4]:2.290182891667E1,31[&rate=7.122217956367653E-4]:2.290182891667E1)[&rate=3.410179739749763E-4]:5.334632312149E1,23[&rate=5.69967210099984E-4]:7.624815203816E1)[&rate=4.6620877109873176E-4]:8.777691696271E-1)[&rate=4.0202859886808047E-4]:1.503412333469E0)[&rate=2.2941334028975973E-4]:6.193343812733E0,(17[&rate=8.337779881803569E-4]:7.778692294697E1,(27[&rate=5.119639862389427E-4]:3.200009766253E1,28[&rate=0.00116754096628117]:3.200009766253E1)[&rate=4.0202859886808047E-4]:4.578682528445E1)[&rate=8.560247103508053E-4]:7.035754407015E0)[&rate=0.001255771056668636]:4.439575030204E1);\ntree STATE_22 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55131.59860775896,EEF_ucld_branchRates=-266.168517335019,lnP=-55131.59860775896,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=8.306012800252581E-4]:7.213687636348E0,9[&rate=5.861174742267083E-4]:7.213687636348E0)[&rate=7.606574067669981E-4]:8.874903099499E0,15[&rate=9.157114070895015E-4]:1.608859073585E1)[&rate=8.306012800252581E-4]:9.495614236845E1,(14[&rate=0.001190711584254777]:4.884553192923E1,24[&rate=6.342727343788983E-4]:4.884553192923E1)[&rate=0.001060968202744154]:6.219920117507E1)[&rate=3.841891764680352E-4]:3.998606964009E0,(((25[&rate=6.59794083153021E-4]:7.151634401412E1,((((30[&rate=9.669224981676951E-4]:5.089480182972E1,26[&rate=5.406686659087487E-4]:5.089480182972E1)[&rate=0.0015224380449208466]:7.426678184291E0,32[&rate=4.529977803298421E-4]:5.832148001401E1)[&rate=3.5893224441887523E-4]:9.856239952788E0,((((4[&rate=0.0014043336010761054]:1.947678100918E0,2[&rate=9.669224981676951E-4]:1.947678100918E0)[&rate=5.518450634211008E-4]:1.704710261733E0,3[&rate=3.454853862208925E-4]:3.652388362651E0)[&rate=8.119608544227841E-4]:6.001604931763E0,5[&rate=3.71791945750637E-4]:9.653993294414E0)[&rate=7.941454243253212E-4]:2.928684272001E0,((7[&rate=5.076246849850297E-4]:7.034129667086E0,6[&rate=7.606574067669981E-4]:7.034129667086E0)[&rate=5.518450634211008E-4]:8.883568549422E-1,1[&rate=5.185769953314012E-4]:7.922486522028E0)[&rate=4.1945386011925194E-4]:4.660191044387E0)[&rate=6.219082282704042E-4]:5.559504240038E1)[&rate=2.590971985978672E-4]:1.773093243095E0,((16[&rate=4.307682850992932E-4]:3.221173663642E1,((22[&rate=4.4193785483551004E-4]:3.239986683506E0,21[&rate=2.3130458582499395E-4]:3.239986683506E0)[&rate=0.0011417543207619218]:3.021653860288E0,20[&rate=4.307682850992932E-4]:6.261640543794E0)[&rate=0.0011417543207619218]:2.595009609262E1)[&rate=0.001248006779432821]:3.411408777783E1,12[&rate=7.148010530934151E-4]:6.632582441425E1)[&rate=5.518450634211008E-4]:3.624988795645E0)[&rate=0.0014043336010761054]:1.565530804222E0)[&rate=4.1945386011925194E-4]:3.561942729801E0,((((11[&rate=8.925676498670243E-4]:1.721635169221E1,29[&rate=4.529977803298421E-4]:1.721635169221E1)[&rate=8.119608544227841E-4]:5.155764303879E1,(33[&rate=7.004730070518115E-4]:6.089475784864E1,13[&rate=4.307682850992932E-4]:6.089475784864E1)[&rate=5.185769953314012E-4]:7.879236882358E0)[&rate=8.707756408664671E-4]:7.74640690559E-1,(19[&rate=6.219082282704042E-4]:1.64795486297E1,18[&rate=6.219082282704042E-4]:1.64795486297E1)[&rate=3.1607154622755664E-4]:5.306908679186E1)[&rate=5.295854361210119E-4]:3.850465859863E0,((10[&rate=5.861174742267083E-4]:2.504509479919E1,31[&rate=9.955605926304564E-4]:2.504509479919E1)[&rate=3.71791945750637E-4]:4.723820137262E1,23[&rate=4.529977803298421E-4]:7.228329617181E1)[&rate=8.925676498670243E-4]:1.115805109616E0)[&rate=4.4193785483551004E-4]:1.679185462494E0)[&rate=6.342727343788983E-4]:1.598540437058E0,(17[&rate=7.606574067669981E-4]:6.754671067246E1,(27[&rate=8.306012800252581E-4]:2.395586593991E1,28[&rate=8.306012800252581E-4]:2.395586593991E1)[&rate=5.861174742267083E-4]:4.359084473256E1)[&rate=4.1945386011925194E-4]:9.130116508509E0)[&rate=0.001705367972151901]:3.836651288734E1);\ntree STATE_23 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55151.10687253794,EEF_ucld_branchRates=-266.168517335019,lnP=-55151.10687253794,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.733400106445564E-4]:8.011739726933E0,9[&rate=0.0012031754742512144]:8.011739726933E0)[&rate=4.4341920271890185E-4]:5.401419109279E0,15[&rate=2.912720009263897E-4]:1.341315883621E1)[&rate=8.762102824569377E-4]:1.101571143742E2,(14[&rate=7.592943619057822E-4]:5.000563904019E1,24[&rate=6.145540394226147E-4]:5.000563904019E1)[&rate=0.0012031754742512144]:7.356463417023E1)[&rate=8.385815424580827E-4]:5.314572104775E0,(((25[&rate=8.212416702824886E-4]:7.520709755847E1,(12[&rate=8.212416702824886E-4]:7.101134182073E1,(((16[&rate=6.360373908496868E-4]:3.845924306731E1,((22[&rate=7.889523919556517E-4]:2.466796280363E0,21[&rate=7.059369822834136E-4]:2.466796280363E0)[&rate=0.0010273685195108986]:4.287915904644E0,20[&rate=7.452860288838153E-4]:6.754712185007E0)[&rate=0.0010273685195108986]:3.170453088231E1)[&rate=8.967933417228087E-4]:2.816679845315E1,((((4[&rate=4.327948505180505E-4]:1.540744983411E0,2[&rate=0.0013652372604493594]:1.540744983411E0)[&rate=7.592943619057822E-4]:1.290149201999E0,3[&rate=0.001062165923898783]:2.83089418541E0)[&rate=5.434282551894182E-4]:1.013652592077E1,5[&rate=3.464199625619159E-4]:1.296742010618E1)[&rate=9.188080406094449E-4]:1.836779751744E0,((7[&rate=4.538355649916614E-4]:8.360756423443E0,6[&rate=6.470633387487818E-4]:8.360756423443E0)[&rate=5.23717030628618E-4]:9.881404052304E-1,1[&rate=4.6408436405271465E-4]:9.348896828673E0)[&rate=4.327948505180505E-4]:5.455303029254E0)[&rate=4.4341920271890185E-4]:5.182184166253E1)[&rate=4.10717893345381E-4]:2.094216823152E0,((30[&rate=6.935769023747324E-4]:4.703366864549E1,26[&rate=6.360373908496868E-4]:4.703366864549E1)[&rate=9.96299927418965E-4]:8.468512931171E0,32[&rate=5.633015390468667E-4]:5.550218157666E1)[&rate=6.360373908496868E-4]:1.321807676695E1)[&rate=8.04729749892991E-4]:2.291083477118E0)[&rate=6.470633387487818E-4]:4.19575573774E0)[&rate=3.991322067246575E-4]:8.967626264101E-1,((((33[&rate=5.937017625625744E-4]:6.108672654358E1,13[&rate=2.912720009263897E-4]:6.108672654358E1)[&rate=5.23717030628618E-4]:9.957573483943E0,(11[&rate=4.6408436405271465E-4]:1.678689256976E1,29[&rate=7.738300549397457E-4]:1.678689256976E1)[&rate=9.188080406094449E-4]:5.425740745776E1)[&rate=8.385815424580827E-4]:1.797820226269E0,(19[&rate=5.434282551894182E-4]:2.093400052822E1,18[&rate=5.335607715414979E-4]:2.093400052822E1)[&rate=4.538355649916614E-4]:5.190811972557E1)[&rate=9.425031462154423E-4]:1.281267765847E0,((10[&rate=3.8706207270168265E-4]:2.569063231015E1,31[&rate=4.6408436405271465E-4]:2.569063231015E1)[&rate=4.941477417023862E-4]:4.608403965209E1,23[&rate=3.743816099190181E-4]:7.177467196224E1)[&rate=7.317532439525805E-4]:2.348716057394E0)[&rate=5.335607715414979E-4]:1.980472165244E0)[&rate=4.327948505180505E-4]:3.688437763967E0,(17[&rate=7.889523919556517E-4]:7.015960936284E1,(27[&rate=6.25207565327436E-4]:2.366037461202E1,28[&rate=0.0012031754742512144]:2.366037461202E1)[&rate=4.4341920271890185E-4]:4.649923475081E1)[&rate=6.040580598898777E-4]:9.632688586008E0)[&rate=0.0018201260923608933]:4.909254736634E1);\ntree STATE_24 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55146.099267745405,EEF_ucld_branchRates=-266.168517335019,lnP=-55146.099267745405,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=2.7476312293384374E-4]:7.88093604643E0,9[&rate=8.234165193594261E-4]:7.88093604643E0)[&rate=5.352013119603402E-4]:8.419060470606E0,15[&rate=6.372977251980447E-4]:1.629999651704E1)[&rate=6.253467161905357E-4]:1.042091207751E2,(14[&rate=9.73885482454357E-4]:4.89855926709E1,24[&rate=9.482149789272512E-4]:4.89855926709E1)[&rate=0.001064734294280731]:7.152352462122E1)[&rate=4.132491924722523E-4]:5.70434490875E0,((((((16[&rate=3.325855168234456E-4]:3.745750177655E1,((22[&rate=0.0012445048495680379]:2.958836672565E0,21[&rate=3.622725836475443E-4]:2.958836672565E0)[&rate=9.242715992493518E-4]:6.372058155881E0,20[&rate=4.132491924722523E-4]:9.330894828446E0)[&rate=0.0013106719967786703]:2.81266069481E1)[&rate=0.0015064040769493222]:3.081073652827E1,(((((4[&rate=5.90595985930543E-4]:1.589560546844E0,2[&rate=4.699997112232875E-4]:1.589560546844E0)[&rate=5.681518494903769E-4]:4.812500207561E-1,3[&rate=7.144730001125443E-4]:2.0708105676E0)[&rate=4.36508911777722E-4]:1.029963180313E1,5[&rate=4.918226996298926E-4]:1.237044237073E1)[&rate=5.134975624546192E-4]:2.072299784407E0,((7[&rate=4.0118660237130766E-4]:7.694407531288E0,6[&rate=0.0010317001767666007]:7.694407531288E0)[&rate=7.893879944410368E-4]:1.723325791104E0,1[&rate=3.622725836475443E-4]:9.417733322392E0)[&rate=4.36508911777722E-4]:5.025008832746E0)[&rate=6.618796866868943E-4]:5.004888924425E1,((30[&rate=9.242715992493518E-4]:4.883298375917E1,26[&rate=0.0010015852326454616]:4.883298375917E1)[&rate=0.0011425217012434987]:6.548873195541E0,32[&rate=5.793141077656839E-4]:5.538185695471E1)[&rate=8.415721537341447E-4]:9.109774444683E0)[&rate=8.415721537341447E-4]:3.776606905431E0)[&rate=5.461135876863122E-4]:1.956473890156E0,12[&rate=7.893879944410368E-4]:7.022471219498E1)[&rate=0.0013106719967786703]:9.921957230517E-1,25[&rate=8.415721537341447E-4]:7.121690791803E1)[&rate=5.243356771291592E-4]:1.761640858288E0,((((11[&rate=5.352013119603402E-4]:1.499483092035E1,29[&rate=6.618796866868943E-4]:1.499483092035E1)[&rate=8.606117871277955E-4]:5.244872384198E1,(33[&rate=6.135929792866382E-4]:6.157180157286E1,13[&rate=4.4781673365169156E-4]:6.157180157286E1)[&rate=4.2500303787233875E-4]:5.871753189464E0)[&rate=4.36508911777722E-4]:1.600482693617E0,(19[&rate=8.060491788983889E-4]:1.859677580529E1,18[&rate=3.7581090577740894E-4]:1.859677580529E1)[&rate=7.579087902508236E-4]:5.044726165065E1)[&rate=6.618796866868943E-4]:1.192728606725E0,((10[&rate=7.893879944410368E-4]:2.149611147368E1,31[&rate=5.243356771291592E-4]:2.149611147368E1)[&rate=4.2500303787233875E-4]:4.829561904041E1,23[&rate=4.589683883943232E-4]:6.979173051409E1)[&rate=6.494677012290392E-4]:4.450355485773E-1)[&rate=4.589683883943232E-4]:2.741782713652E0)[&rate=6.494677012290392E-4]:2.653594109466E0,(17[&rate=0.001064734294280731]:6.690994039838E1,(27[&rate=7.144730001125443E-4]:2.796460412504E1,28[&rate=9.73885482454357E-4]:2.796460412504E1)[&rate=8.606117871277955E-4]:3.894533627334E1)[&rate=2.463815763482357E-4]:8.722202487405E0)[&rate=0.0016799319767232016]:5.058131931509E1);\ntree STATE_25 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55133.54873380309,EEF_ucld_branchRates=-266.168517335019,lnP=-55133.54873380309,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.9147285856247195E-4]:8.173183096519E0,9[&rate=8.143781828224616E-4]:8.173183096519E0)[&rate=4.156474322614012E-4]:8.735495367781E0,15[&rate=5.115583619712337E-4]:1.69086784643E1)[&rate=8.8064112061869E-4]:1.010836425687E2,(14[&rate=0.0010555537481518865]:4.972838070335E1,24[&rate=0.0010207836918755067]:4.972838070335E1)[&rate=0.0011355154828000444]:6.826394032966E1)[&rate=4.993742632883034E-4]:1.178592184822E1,((((((16[&rate=2.470870355411002E-4]:4.284381472516E1,((22[&rate=6.435980992640667E-4]:3.658796743773E0,21[&rate=4.276063177870558E-4]:3.658796743773E0)[&rate=3.4086869728733045E-4]:4.460158187041E0,20[&rate=5.747037934758157E-4]:8.118954930815E0)[&rate=0.0014553993534517848]:3.472485979435E1)[&rate=0.0017185997004242387]:3.038537724325E1,(((30[&rate=9.589879795261333E-4]:4.924259479887E1,26[&rate=4.036147393243707E-4]:4.924259479887E1)[&rate=9.589879795261333E-4]:1.198862952761E1,32[&rate=3.6669064370178326E-4]:6.123122432648E1)[&rate=6.734977004948781E-4]:1.030645103532E1,((((4[&rate=2.470870355411002E-4]:2.119115937468E0,2[&rate=6.435980992640667E-4]:2.119115937468E0)[&rate=0.0019576056538517595]:7.767462627953E-1,3[&rate=0.0010207836918755067]:2.895862200263E0)[&rate=5.87927518630544E-4]:1.067372106625E1,5[&rate=3.2737359499432497E-4]:1.356958326651E1)[&rate=6.435980992640667E-4]:1.850617275052E0,((7[&rate=4.5142435226431436E-4]:9.149432083017E0,6[&rate=8.574231350838069E-4]:9.149432083017E0)[&rate=4.872901086235675E-4]:2.254788394284E0,1[&rate=3.539438902590613E-4]:1.14042204773E1)[&rate=8.143781828224616E-4]:4.015980064259E0)[&rate=6.292102681220622E-4]:5.611747482024E1)[&rate=0.0010935679185995952]:1.691516606609E0)[&rate=6.014027757605835E-4]:1.348945149704E0,12[&rate=9.589879795261333E-4]:7.457813711812E1)[&rate=7.051372855936251E-4]:1.43428163821E0,25[&rate=5.87927518630544E-4]:7.601241875633E1)[&rate=4.993742632883034E-4]:1.069927573256E0,((((11[&rate=8.143781828224616E-4]:1.337707797553E1,29[&rate=0.0012352829368172881]:1.337707797553E1)[&rate=9.051823307353437E-4]:5.605812824541E1,(33[&rate=8.8064112061869E-4]:6.181080479531E1,13[&rate=3.6669064370178326E-4]:6.181080479531E1)[&rate=3.7918090429176914E-4]:7.624401425628E0)[&rate=4.036147393243707E-4]:1.925606415298E0,(19[&rate=6.583493221634288E-4]:2.179601353008E1,18[&rate=5.115583619712337E-4]:2.179601353008E1)[&rate=5.115583619712337E-4]:4.956479910616E1)[&rate=7.38860436057362E-4]:2.021374505021E0,((10[&rate=8.353779839440136E-4]:2.08041030607E1,31[&rate=0.0011823240764984584]:2.08041030607E1)[&rate=4.276063177870558E-4]:5.074921830633E1,23[&rate=3.7918090429176914E-4]:7.155332136702E1)[&rate=3.1333848451668196E-4]:1.828865774237E0)[&rate=3.9147285856247195E-4]:3.700159188321E0)[&rate=5.238630524555457E-4]:4.223960165094E0,(17[&rate=8.353779839440136E-4]:7.12757882786E1,(27[&rate=4.5142435226431436E-4]:3.325810315451E1,28[&rate=9.589879795261333E-4]:3.325810315451E1)[&rate=8.353779839440136E-4]:3.801768512409E1)[&rate=1.9772198890520554E-4]:1.003051821608E1)[&rate=0.0014553993534517848]:4.847193638655E1);\ntree STATE_26 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55120.6002295403,EEF_ucld_branchRates=-266.168517335019,lnP=-55120.6002295403,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.903144721201903E-4]:1.042544895684E1,9[&rate=6.261244713629012E-4]:1.042544895684E1)[&rate=5.775147548618147E-4]:5.80576926096E0,15[&rate=6.136060948901627E-4]:1.62312182178E1)[&rate=8.940757175416415E-4]:9.922099316108E1,(14[&rate=0.0010053563641445483]:4.841910493554E1,24[&rate=8.285342728524506E-4]:4.841910493554E1)[&rate=8.089936993277209E-4]:6.703310644334E1)[&rate=8.285342728524506E-4]:1.322585863414E1,((((((16[&rate=3.903144721201903E-4]:3.828884718836E1,((22[&rate=0.001039734960929364]:3.476175402261E0,21[&rate=5.10015990005466E-4]:3.476175402261E0)[&rate=0.0010779379805749114]:4.914718509595E0,20[&rate=1.748070996359765E-4]:8.390893911855E0)[&rate=0.0012978002512941788]:2.989795327651E1)[&rate=9.740797446322901E-4]:3.45753241067E1,(((30[&rate=7.903878780782313E-4]:5.116716036018E1,26[&rate=5.209603668532543E-4]:5.116716036018E1)[&rate=0.0012978002512941788]:7.725055620049E0,32[&rate=4.56110324941187E-4]:5.889221598023E1)[&rate=3.291715914107245E-4]:1.285948580928E1,((((4[&rate=4.12705961962952E-4]:2.93582931845E0,2[&rate=4.56110324941187E-4]:2.93582931845E0)[&rate=2.450865415812791E-4]:3.305101534236E-1,3[&rate=8.285342728524506E-4]:3.266339471873E0)[&rate=7.903878780782313E-4]:8.26000835845E0,5[&rate=3.903144721201903E-4]:1.152634783032E1)[&rate=7.234878637271453E-4]:4.513850456929E0,((7[&rate=3.903144721201903E-4]:8.761176488842E0,6[&rate=4.015976310636382E-4]:8.761176488842E0)[&rate=4.12705961962952E-4]:1.048561646216E0,1[&rate=4.2367926175457905E-4]:9.809738135059E0)[&rate=0.001505551372568411]:6.230460152193E0)[&rate=6.389280550313043E-4]:5.571150350225E1)[&rate=3.5488888316876325E-4]:1.112469505549E0)[&rate=7.726155329826111E-4]:2.687351308304E0,12[&rate=8.940757175416415E-4]:7.555152260336E1)[&rate=4.2367926175457905E-4]:2.852398846775E0,25[&rate=7.726155329826111E-4]:7.840392145014E1)[&rate=5.658975116679521E-4]:8.455988946389E-1,((((11[&rate=6.793396491512761E-4]:1.400549607063E1,29[&rate=6.01347317356406E-4]:1.400549607063E1)[&rate=8.709191418707708E-4]:5.35667483986E1,(33[&rate=8.709191418707708E-4]:6.047980118067E1,13[&rate=5.320024467706047E-4]:6.047980118067E1)[&rate=3.903144721201903E-4]:7.092443288557E0)[&rate=3.291715914107245E-4]:5.59379701143E0,(19[&rate=4.345517048235722E-4]:2.408516097331E1,18[&rate=2.6623725938250496E-4]:2.408516097331E1)[&rate=4.56110324941187E-4]:4.908088050734E1)[&rate=8.089936993277209E-4]:3.332912007366E0,((10[&rate=6.136060948901627E-4]:2.04138871157E1,31[&rate=4.991511534489875E-4]:2.04138871157E1)[&rate=4.991511534489875E-4]:5.410939028226E1,23[&rate=4.668472142727088E-4]:7.452327739796E1)[&rate=8.709191418707708E-4]:1.975676090056E0)[&rate=6.261244713629012E-4]:2.750566856755E0)[&rate=9.453668911413456E-4]:4.51163651019E0,(17[&rate=5.775147548618147E-4]:7.695309843141E1,(27[&rate=5.10015990005466E-4]:3.115151110414E1,28[&rate=0.0012978002512941788]:3.115151110414E1)[&rate=6.520445336261696E-4]:4.580158732727E1)[&rate=8.285342728524506E-4]:6.808058423555E0)[&rate=0.0013859456784206473]:4.491691315806E1);\ntree STATE_27 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55142.6354293579,EEF_ucld_branchRates=-266.168517335019,lnP=-55142.6354293579,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.6941559425179495E-4]:8.186378922423E0,9[&rate=6.464031407847066E-4]:8.186378922423E0)[&rate=5.061929911599962E-4]:6.296730501664E0,15[&rate=6.134607302397474E-4]:1.448310942409E1)[&rate=8.362741118485404E-4]:9.646099097155E1,(14[&rate=0.0012742924071094705]:4.454063379608E1,24[&rate=6.820639382506874E-4]:4.454063379608E1)[&rate=0.0011227117085937555]:6.640346659956E1)[&rate=9.908584346661135E-4]:8.784792558563E0,((((((16[&rate=3.4844128382660665E-4]:3.818287300225E1,((22[&rate=9.030115307697507E-4]:2.942091360127E0,21[&rate=3.3588287238860734E-4]:2.942091360127E0)[&rate=3.8233840133932416E-4]:5.02621505051E0,20[&rate=8.789961195588283E-4]:7.968306410637E0)[&rate=7.989550575156367E-4]:3.021456659161E1)[&rate=0.0010279058965115394]:3.000942010434E1,(((30[&rate=7.355017372522286E-4]:4.602515252634E1,26[&rate=5.061929911599962E-4]:4.602515252634E1)[&rate=7.656715465047379E-4]:8.121814389845E0,32[&rate=6.029603923866958E-4]:5.414696691619E1)[&rate=8.568492438141847E-4]:9.131853526697E0,((((4[&rate=7.818743213080396E-4]:2.179438360063E0,2[&rate=7.077928711158399E-4]:2.179438360063E0)[&rate=4.029366747511004E-4]:5.156948343054E-1,3[&rate=6.029603923866958E-4]:2.695133194369E0)[&rate=0.0011227117085937555]:1.086532218654E1,5[&rate=3.715296819835555E-4]:1.356045538091E1)[&rate=6.029603923866958E-4]:1.791292544782E0,((7[&rate=4.029366747511004E-4]:8.690293823264E0,6[&rate=5.628004663485998E-4]:8.690293823264E0)[&rate=7.213729655281962E-4]:2.596135941345E0,1[&rate=3.4844128382660665E-4]:1.128642976461E1)[&rate=4.321344258575211E-4]:4.065318161078E0)[&rate=7.213729655281962E-4]:4.79270725172E1)[&rate=4.8779240248801066E-4]:4.9134726637E0)[&rate=7.989550575156367E-4]:9.143684909511E-1,12[&rate=7.656715465047379E-4]:6.910666159754E1)[&rate=4.321344258575211E-4]:2.802289698461E0,25[&rate=8.170380154705676E-4]:7.1908951296E1)[&rate=4.029366747511004E-4]:9.977815272249E-1,((((11[&rate=5.154428518793253E-4]:1.670109551317E1,29[&rate=4.321344258575211E-4]:1.670109551317E1)[&rate=8.568492438141847E-4]:4.949742727488E1,(33[&rate=9.292823744853958E-4]:5.332322811681E1,13[&rate=5.531303020741833E-4]:5.332322811681E1)[&rate=4.128502606666994E-4]:1.287529467125E1)[&rate=4.22570282567127E-4]:9.554924437596E-1,(19[&rate=6.134607302397474E-4]:1.556064663713E1,18[&rate=6.029603923866958E-4]:1.556064663713E1)[&rate=3.075197153665836E-4]:5.159336859469E1)[&rate=4.6019212910736244E-4]:2.07553039564E0,((10[&rate=7.656715465047379E-4]:2.058142152333E1,31[&rate=4.6019212910736244E-4]:2.058142152333E1)[&rate=5.926633724480712E-4]:4.792719002521E1,23[&rate=4.321344258575211E-4]:6.850861154855E1)[&rate=4.128502606666994E-4]:7.209340789098E-1)[&rate=5.341186688021905E-4]:3.677187195766E0)[&rate=4.509191789110659E-4]:3.372681619596E0,(17[&rate=8.170380154705676E-4]:7.01020751622E1,(27[&rate=2.709393724228811E-4]:3.395683359181E1,28[&rate=0.0011227117085937555]:3.395683359181E1)[&rate=4.786095425861748E-4]:3.614524157039E1)[&rate=5.628004663485998E-4]:6.177339280621E0)[&rate=7.355017372522286E-4]:4.344947851139E1);\ntree STATE_28 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55140.71766048652,EEF_ucld_branchRates=-266.168517335019,lnP=-55140.71766048652,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.960708476727161E-4]:9.808773305514E0,9[&rate=4.776393701358584E-4]:9.808773305514E0)[&rate=9.654024195225677E-4]:6.086234715942E0,15[&rate=7.436879433949868E-4]:1.589500802146E1)[&rate=5.712047296161358E-4]:1.041703013508E2,(14[&rate=9.104381003403188E-4]:4.043382268289E1,24[&rate=0.0011284928430587066]:4.043382268289E1)[&rate=8.440603404013136E-4]:7.963148668938E1)[&rate=0.0010344782037690352]:9.289068958016E0,((((((16[&rate=4.4021574201124464E-4]:3.88106141339E1,((22[&rate=5.145164181001073E-4]:2.942484065917E0,21[&rate=6.43550139190971E-4]:2.942484065917E0)[&rate=5.424925061917413E-4]:5.171321547008E0,20[&rate=8.86560314005066E-4]:8.113805612924E0)[&rate=0.0011284928430587066]:3.069680852098E1)[&rate=0.0016988018208742778]:3.123193594314E1,(((30[&rate=7.898989465411502E-4]:5.022193798197E1,26[&rate=7.436879433949868E-4]:5.022193798197E1)[&rate=4.2084034026752695E-4]:1.291142411684E1,32[&rate=4.868619105324113E-4]:6.313336209881E1)[&rate=7.436879433949868E-4]:6.574238087986E0,((((4[&rate=3.9015792586891455E-4]:2.179045799886E0,2[&rate=3.7928068216263136E-4]:2.179045799886E0)[&rate=8.440603404013136E-4]:5.836284436975E-1,3[&rate=6.113729960122972E-4]:2.762674243583E0)[&rate=4.4021574201124464E-4]:1.400363808925E1,5[&rate=2.778194730735305E-4]:1.676631233283E1)[&rate=4.2084034026752695E-4]:1.432015540846E0,((7[&rate=4.496963091497279E-4]:1.279937918287E1,6[&rate=4.590777032288949E-4]:1.279937918287E1)[&rate=6.113729960122972E-4]:1.55494728886E0,1[&rate=3.679446349808012E-4]:1.435432647173E1)[&rate=4.496963091497279E-4]:3.844001401944E0)[&rate=7.436879433949868E-4]:5.150927231312E1)[&rate=5.810113354330564E-4]:3.349498902416E-1)[&rate=7.898989465411502E-4]:2.27459540359E0,12[&rate=7.737571185932862E-4]:7.231714548063E1)[&rate=6.66311938289105E-4]:3.546979811635E0,25[&rate=6.43550139190971E-4]:7.586412529227E1)[&rate=4.0066607454615174E-4]:1.198707450069E0,((((33[&rate=8.24914361987709E-4]:5.815820464637E1,13[&rate=2.978471313525928E-4]:5.815820464637E1)[&rate=4.306078997156629E-4]:1.056067700376E1,(11[&rate=6.010775181693174E-4]:1.830947634312E1,29[&rate=4.590777032288949E-4]:1.830947634312E1)[&rate=6.010775181693174E-4]:5.040940530701E1)[&rate=6.547825763610909E-4]:2.672840064703E0,(19[&rate=8.069103554496241E-4]:1.152596652684E1,18[&rate=8.645322480940321E-4]:1.152596652684E1)[&rate=3.4337566472316045E-4]:5.986575518799E1)[&rate=8.440603404013136E-4]:3.601786805055E0,((10[&rate=6.113729960122972E-4]:1.750414687301E1,31[&rate=8.24914361987709E-4]:1.750414687301E1)[&rate=4.960708476727161E-4]:5.635867098973E1,23[&rate=4.4021574201124464E-4]:7.386281786274E1)[&rate=5.237853172032244E-4]:1.130690657146E0)[&rate=4.776393701358584E-4]:2.069324222451E0)[&rate=4.2084034026752695E-4]:4.265920667554E0,(17[&rate=7.160562700414259E-4]:7.460611317771E1,(27[&rate=3.4337566472316045E-4]:2.865049184355E1,28[&rate=9.977074320712477E-4]:2.865049184355E1)[&rate=8.86560314005066E-4]:4.595562133416E1)[&rate=5.810113354330564E-4]:6.722640232182E0)[&rate=7.737571185932862E-4]:4.80256249204E1);\ntree STATE_29 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55129.794636509185,EEF_ucld_branchRates=-266.168517335019,lnP=-55129.794636509185,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=7.8172473052696E-4]:9.206867550012E0,9[&rate=7.624734298737289E-4]:9.206867550012E0)[&rate=5.217689993200701E-4]:8.67103971363E0,15[&rate=3.4454831077793883E-4]:1.787790726364E1)[&rate=7.269941253380213E-4]:9.858606018488E1,(14[&rate=0.0011575165348884752]:4.668250537025E1,24[&rate=7.624734298737289E-4]:4.668250537025E1)[&rate=7.442713356634284E-4]:6.978146207827E1)[&rate=8.72764102335958E-4]:7.895442781628E0,((((((16[&rate=4.040319474341064E-4]:4.684549211126E1,((22[&rate=5.763266839527458E-4]:4.409766790505E0,21[&rate=3.5484400275438E-4]:4.409766790505E0)[&rate=9.642640201821443E-4]:5.861710206114E0,20[&rate=3.3399735288822303E-4]:1.027147699662E1)[&rate=8.72764102335958E-4]:3.657401511465E1)[&rate=0.0010021307164639853]:2.765211265248E1,(((((4[&rate=5.649595394928279E-4]:3.286029523823E0,2[&rate=6.948117796417444E-4]:3.286029523823E0)[&rate=2.4352053091756937E-4]:2.992787939667E-1,3[&rate=8.240052781732198E-4]:3.58530831779E0)[&rate=4.3279260078539375E-4]:1.019629575887E1,5[&rate=3.649362511780711E-4]:1.378160407666E1)[&rate=5.429515672235606E-4]:3.622703952688E0,((7[&rate=3.5484400275438E-4]:1.00649232558E1,6[&rate=6.121810483599872E-4]:1.00649232558E1)[&rate=2.0019216702859413E-4]:2.038092945586E0,1[&rate=3.649362511780711E-4]:1.210301620139E1)[&rate=3.9438672271803374E-4]:5.301291827958E0)[&rate=4.136338750023068E-4]:5.503125318235E1,((30[&rate=5.322671379926243E-4]:5.120567093934E1,26[&rate=6.948117796417444E-4]:5.120567093934E1)[&rate=3.9438672271803374E-4]:1.224995558155E1,32[&rate=3.8467427909664634E-4]:6.345562652089E1)[&rate=4.040319474341064E-4]:8.979934690808E0)[&rate=4.7144618680923685E-4]:2.06204355205E0)[&rate=8.240052781732198E-4]:2.26786997734E0,12[&rate=5.012578317491164E-4]:7.676547474109E1)[&rate=8.474411144990577E-4]:9.411577515126E-1,25[&rate=5.649595394928279E-4]:7.77066324926E1)[&rate=3.231266552414985E-4]:2.318106061005E0,((((33[&rate=7.624734298737289E-4]:6.398261324415E1,13[&rate=4.6169797533613424E-4]:6.398261324415E1)[&rate=3.649362511780711E-4]:8.405866178292E0,(11[&rate=5.999096235926464E-4]:1.695515390953E1,29[&rate=4.423878106821967E-4]:1.695515390953E1)[&rate=6.948117796417444E-4]:5.543332551291E1)[&rate=5.763266839527458E-4]:8.143193337766E-1,(19[&rate=5.999096235926464E-4]:1.248234748449E1,18[&rate=8.474411144990577E-4]:1.248234748449E1)[&rate=3.9438672271803374E-4]:6.072045127173E1)[&rate=5.429515672235606E-4]:4.027216842862E0,((10[&rate=4.3279260078539375E-4]:1.784895896752E1,31[&rate=0.0010962459524725052]:1.784895896752E1)[&rate=2.7430833061618104E-4]:5.874088640241E1,23[&rate=4.3279260078539375E-4]:7.658984536994E1)[&rate=3.8467427909664634E-4]:6.401702291491E-1)[&rate=3.118537982063007E-4]:2.794722954523E0)[&rate=8.021746985097921E-4]:6.184754844097E0,(17[&rate=6.948117796417444E-4]:7.858839984041E1,(27[&rate=8.021746985097921E-4]:3.182969122478E1,28[&rate=0.0011575165348884752]:3.182969122478E1)[&rate=5.999096235926464E-4]:4.675870861563E1)[&rate=0.0010021307164639853]:7.621093557297E0)[&rate=0.0018681582614768037]:3.814991683245E1);\ntree STATE_30 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55146.84853873062,EEF_ucld_branchRates=-266.168517335019,lnP=-55146.84853873062,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.208453414419401E-4]:8.805020679128E0,9[&rate=6.608063379082266E-4]:8.805020679128E0)[&rate=4.6022622597981005E-4]:7.896216628115E0,15[&rate=5.302993935119918E-4]:1.670123730724E1)[&rate=9.014763754775282E-4]:9.001330626193E1,(14[&rate=0.0014096049586761821]:4.222758282096E1,24[&rate=0.0011149513324931566]:4.222758282096E1)[&rate=9.629377406187616E-4]:6.448696074821E1)[&rate=9.4089720753323E-4]:1.960163810223E1,((((((16[&rate=3.6376465277983305E-4]:4.187101873818E1,((22[&rate=0.0012944564794138318]:2.998705012015E0,21[&rate=6.806462754774087E-4]:2.998705012015E0)[&rate=4.814459783138822E-4]:5.204576512968E0,20[&rate=8.508652510774143E-4]:8.203281524983E0)[&rate=0.0010762842076049097]:3.36677372132E1)[&rate=9.014763754775282E-4]:2.670515886383E1,(((30[&rate=8.073296510742574E-4]:4.631897029614E1,26[&rate=7.225644832190805E-4]:4.631897029614E1)[&rate=9.4089720753323E-4]:9.66890708888E0,32[&rate=4.7100703314909817E-4]:5.598787738502E1)[&rate=3.4235929076516973E-4]:1.097685221517E1,((((4[&rate=8.668083263733282E-4]:2.391506755923E0,2[&rate=6.040717223535721E-4]:2.391506755923E0)[&rate=4.814459783138822E-4]:2.365280517723E-1,3[&rate=8.356962267739732E-4]:2.628034807695E0)[&rate=5.673421657735794E-4]:1.118510391894E1,5[&rate=4.4902728092780056E-4]:1.381313872664E1)[&rate=8.212100490524422E-4]:2.01947995506E0,((7[&rate=7.939892450285796E-4]:9.117680739874E0,6[&rate=9.4089720753323E-4]:9.117680739874E0)[&rate=5.856782742316435E-4]:3.877072528605E-1,1[&rate=5.948600720656455E-4]:9.505387992735E0)[&rate=5.015299295060334E-4]:6.327230688962E0)[&rate=6.415154945250626E-4]:5.113211091849E1)[&rate=5.015299295060334E-4]:1.611448001827E0)[&rate=5.396538957722829E-4]:2.778252409991E0,12[&rate=8.356962267739732E-4]:7.1354430012E1)[&rate=7.225644832190805E-4]:1.628992809647E0,25[&rate=7.225644832190805E-4]:7.298342282165E1)[&rate=5.948600720656455E-4]:2.523159598324E0,((((33[&rate=7.117532249660856E-4]:5.734930938824E1,13[&rate=4.916037893768911E-4]:5.734930938824E1)[&rate=4.2494913693788333E-4]:1.305991730652E1,(11[&rate=6.806462754774087E-4]:1.782092440049E1,29[&rate=8.668083263733282E-4]:1.782092440049E1)[&rate=6.90816053549248E-4]:5.258830229427E1)[&rate=5.208453414419401E-4]:2.176340139432E0,(19[&rate=0.0010428758731266183]:1.442121030615E1,18[&rate=5.112655113416944E-4]:1.442121030615E1)[&rate=5.015299295060334E-4]:5.816435652804E1)[&rate=5.673421657735794E-4]:1.941325014484E0,((10[&rate=6.806462754774087E-4]:1.605169914962E1,31[&rate=8.668083263733282E-4]:1.605169914962E1)[&rate=2.6727468137656527E-4]:5.789858055704E1,23[&rate=5.208453414419401E-4]:7.395027970666E1)[&rate=7.939892450285796E-4]:5.766121420252E-1)[&rate=5.489321513570119E-4]:9.796905712945E-1)[&rate=0.0010133939952830955]:4.213178245369E0,(17[&rate=8.836346071210225E-4]:6.731364253985E1,(27[&rate=6.226444597277582E-4]:2.806117540153E1,28[&rate=6.608063379082266E-4]:2.806117540153E1)[&rate=5.015299295060334E-4]:3.925246713833E1)[&rate=8.073296510742574E-4]:1.240611812549E1)[&rate=0.0016581039398719311]:4.659642100606E1);\ntree STATE_31 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55127.3752470363,EEF_ucld_branchRates=-266.168517335019,lnP=-55127.3752470363,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.52778970427855E-4]:6.71772245889E0,9[&rate=4.424190874599782E-4]:6.71772245889E0)[&rate=4.1171759254246624E-4]:1.272859167766E1,15[&rate=5.063180499680869E-4]:1.944631413655E1)[&rate=7.075886621723801E-4]:9.993919086305E1,(14[&rate=8.524722169145591E-4]:5.133557109333E1,24[&rate=9.390866118587179E-4]:5.133557109333E1)[&rate=6.908415774465502E-4]:6.804993390627E1)[&rate=5.896220814679888E-4]:9.639957866343E0,((((((16[&rate=3.502006242356142E-4]:3.619328248984E1,((22[&rate=9.077196632478096E-4]:2.773002026316E0,21[&rate=4.7379388491762065E-4]:2.773002026316E0)[&rate=6.300974157969632E-4]:5.196302479321E0,20[&rate=5.523432500741697E-4]:7.969304505637E0)[&rate=0.0011644003633728929]:2.82239779842E1)[&rate=0.0010121564737436764]:3.335862838427E1,(((((4[&rate=6.161945302018636E-4]:2.318290461709E0,3[&rate=3.606237703106146E-4]:2.318290461709E0)[&rate=7.434635860072854E-4]:4.252425436179E-1,2[&rate=2.9495074156152593E-4]:2.743533005327E0)[&rate=5.644652801811244E-4]:1.014875784024E1,5[&rate=3.606237703106146E-4]:1.289229084557E1)[&rate=0.0013261063540181697]:3.208657860953E0,((7[&rate=3.0661597709936934E-4]:1.109632751992E1,6[&rate=7.627841595976633E-4]:1.109632751992E1)[&rate=0.0011056359822729724]:6.615082531269E-1,1[&rate=3.0661597709936934E-4]:1.175783577305E1)[&rate=3.606237703106146E-4]:4.343112933474E0)[&rate=5.644652801811244E-4]:5.2284391939E1,((30[&rate=7.627841595976633E-4]:5.10040949884E1,26[&rate=4.6323142845214365E-4]:5.10040949884E1)[&rate=3.606237703106146E-4]:9.601396471386E0,32[&rate=3.811829285174663E-4]:6.060549145979E1)[&rate=4.0154798180535374E-4]:7.779849185739E0)[&rate=6.300974157969632E-4]:1.166570228586E0)[&rate=8.048083138496528E-4]:2.1801238989E0,12[&rate=8.278331243940449E-4]:7.173203477301E1)[&rate=2.059566932950806E-4]:3.501394306281E0,25[&rate=5.523432500741697E-4]:7.523342907929E1)[&rate=2.059566932950806E-4]:8.907691094599E-1,((((11[&rate=8.278331243940449E-4]:1.92169390943E1,29[&rate=4.6323142845214365E-4]:1.92169390943E1)[&rate=5.644652801811244E-4]:5.075546709951E1,(33[&rate=9.736488793936712E-4]:6.024303474642E1,13[&rate=3.811829285174663E-4]:6.024303474642E1)[&rate=7.250996991978289E-4]:9.729371447386E0)[&rate=3.811829285174663E-4]:1.608166805086E0,(19[&rate=8.048083138496528E-4]:1.341683573405E1,18[&rate=0.0010121564737436764]:1.341683573405E1)[&rate=4.321342435850917E-4]:5.816373726484E1)[&rate=7.831838211330526E-4]:3.415798885978E0,((10[&rate=5.174995152183044E-4]:2.161758393507E1,31[&rate=3.2888601469625254E-4]:2.161758393507E1)[&rate=4.1171759254246624E-4]:5.250951673418E1,23[&rate=4.1171759254246624E-4]:7.412710066925E1)[&rate=3.0661597709936934E-4]:8.692712156194E-1)[&rate=7.627841595976633E-4]:1.127826303879E0)[&rate=0.0016425596747470692]:3.412988799031E0,(17[&rate=9.390866118587179E-4]:6.534577303202E1,(27[&rate=3.502006242356142E-4]:2.728351608548E1,28[&rate=7.250996991978289E-4]:2.728351608548E1)[&rate=5.644652801811244E-4]:3.806225694655E1)[&rate=2.415991429580193E-4]:1.419141395576E1)[&rate=0.001449510077729178]:4.948827587816E1);\ntree STATE_32 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55133.928835337036,EEF_ucld_branchRates=-266.168517335019,lnP=-55133.928835337036,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.031560140059146E-4]:6.505818671482E0,9[&rate=0.001239038262532476]:6.505818671482E0)[&rate=5.71057443915998E-4]:9.567627223999E0,15[&rate=5.471336653016367E-4]:1.607344589548E1)[&rate=9.703622500924103E-4]:9.315091060872E1,(14[&rate=0.001125356121527823]:4.40210258119E1,24[&rate=4.6833967209726425E-4]:4.40210258119E1)[&rate=0.001039492760536983]:6.520333069231E1)[&rate=0.0014077206095905095]:1.999951241596E1,((((((16[&rate=4.4661195828691783E-4]:3.088097334835E1,((22[&rate=0.0015361896116283494]:2.895448087877E0,21[&rate=4.902908115261922E-4]:2.895448087877E0)[&rate=8.395196772162355E-4]:6.45853800669E0,20[&rate=3.582450154653724E-4]:9.353986094567E0)[&rate=9.703622500924103E-4]:2.152698725379E1)[&rate=9.703622500924103E-4]:3.953625749916E1,(((((4[&rate=3.8101967377796335E-4]:1.932742055134E0,2[&rate=6.218841462865998E-4]:1.932742055134E0)[&rate=5.239662616048965E-4]:8.908584124578E-1,3[&rate=2.262920128218332E-4]:2.823600467591E0)[&rate=7.599117400220138E-4]:9.143526619177E0,5[&rate=3.2192801373764733E-4]:1.196712708677E1)[&rate=2.646713600169429E-4]:3.714100868994E0,((7[&rate=4.357819261570697E-4]:1.026638321297E1,6[&rate=3.4649666471765333E-4]:1.026638321297E1)[&rate=7.977096304954903E-4]:1.303278430244E0,1[&rate=3.921473751746849E-4]:1.156966164322E1)[&rate=3.3442026004278417E-4]:4.111566312545E0)[&rate=6.933169212198266E-4]:5.315201464014E1,((30[&rate=5.959096270843827E-4]:5.22336379023E1,26[&rate=6.218841462865998E-4]:5.22336379023E1)[&rate=7.253152566876658E-4]:1.096041247467E1,32[&rate=3.921473751746849E-4]:6.319405037698E1)[&rate=6.781432051434982E-4]:5.639192218922E0)[&rate=6.634538609921072E-4]:1.583988251614E0)[&rate=0.002194240689533166]:2.5879719786E0,12[&rate=8.622652948599426E-4]:7.300520282612E1)[&rate=8.395196772162355E-4]:6.575384329942E-1,25[&rate=8.864714168659573E-4]:7.366274125911E1)[&rate=6.492060141041475E-4]:1.482345498202E0,(((19[&rate=8.180517493351567E-4]:1.873565426806E1,18[&rate=4.031560140059146E-4]:1.873565426806E1)[&rate=3.8101967377796335E-4]:5.363480540426E1,((11[&rate=4.5745765064940136E-4]:2.109748011497E1,29[&rate=4.140789653008104E-4]:2.109748011497E1)[&rate=6.087433812394271E-4]:4.874910233569E1,(33[&rate=7.599117400220138E-4]:6.091854468882E1,13[&rate=3.582450154653724E-4]:6.091854468882E1)[&rate=4.140789653008104E-4]:8.92803776184E0)[&rate=9.703622500924103E-4]:2.523877221657E0)[&rate=4.792777155672929E-4]:1.405194436919E0,((10[&rate=5.013975984889435E-4]:2.719239025302E1,31[&rate=8.180517493351567E-4]:2.719239025302E1)[&rate=2.262920128218332E-4]:4.562186448071E1,23[&rate=5.589906759436227E-4]:7.281425473373E1)[&rate=7.977096304954903E-4]:9.613993755061E-1)[&rate=6.087433812394271E-4]:1.369432648075E0)[&rate=3.8101967377796335E-4]:6.108445943956E0,(17[&rate=0.0011776341883834752]:6.851241453326E1,(27[&rate=4.4661195828691783E-4]:3.341560483397E1,28[&rate=9.123608653708172E-4]:3.341560483397E1)[&rate=7.783657218332745E-4]:3.509680969929E1)[&rate=5.126165633670391E-4]:1.274111816801E1)[&rate=8.180517493351567E-4]:4.797033621889E1);\ntree STATE_33 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55132.15583397838,EEF_ucld_branchRates=-266.168517335019,lnP=-55132.15583397838,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.8313811765572885E-4]:8.277732993737E0,9[&rate=7.022186034213433E-4]:8.277732993737E0)[&rate=4.632190846050816E-4]:6.165380664359E0,15[&rate=2.7993266891059666E-4]:1.44431136581E1)[&rate=8.007630689825537E-4]:9.721787666827E1,(14[&rate=0.0015874933155215184]:4.800161853749E1,24[&rate=8.961528153641692E-4]:4.800161853749E1)[&rate=0.0012148068938390194]:6.365937178888E1)[&rate=7.736384740666215E-4]:1.46465652461E1,((((((16[&rate=3.619052861810251E-4]:3.512091812871E1,((22[&rate=0.0011403325167684728]:4.214354375103E0,21[&rate=3.104784903190988E-4]:4.214354375103E0)[&rate=7.245764595646921E-4]:4.846982992789E0,20[&rate=2.901446886738343E-4]:9.061337367891E0)[&rate=8.961528153641692E-4]:2.605958076082E1)[&rate=9.762991838851309E-4]:3.985325563233E1,(((((4[&rate=3.2065235943633816E-4]:1.942604578454E0,2[&rate=2.7993266891059666E-4]:1.942604578454E0)[&rate=3.8313811765572885E-4]:7.687820043067E-1,3[&rate=5.015707665618452E-4]:2.71138658276E0)[&rate=5.582830547028909E-4]:1.194757461403E1,5[&rate=9.39029441073894E-5]:1.465896119679E1)[&rate=8.961528153641692E-4]:2.421228665418E0,((7[&rate=1.9125438991971609E-4]:1.051565087058E1,6[&rate=3.5146861296180107E-4]:1.051565087058E1)[&rate=2.2696360365283112E-4]:9.240164393847E-1,1[&rate=2.7993266891059666E-4]:1.143966730997E1)[&rate=8.299751231452357E-4]:5.640522552243E0)[&rate=7.245764595646921E-4]:5.521064003382E1,((30[&rate=7.022186034213433E-4]:5.013459796504E1,26[&rate=5.89731479018194E-4]:5.013459796504E1)[&rate=3.8313811765572885E-4]:1.204047681947E1,32[&rate=3.003174727468885E-4]:6.217507478451E1)[&rate=5.582830547028909E-4]:1.011575511153E1)[&rate=2.5926063877513173E-4]:2.683343864997E0)[&rate=0.002474226485228632]:7.004106093832E-1,12[&rate=5.737098845902199E-4]:7.567458437042E1)[&rate=4.884431399494666E-4]:2.034503309412E0,25[&rate=8.007630689825537E-4]:7.770908767983E1)[&rate=4.161637173012407E-4]:1.989250333003E0,(((19[&rate=8.961528153641692E-4]:1.61033702242E1,18[&rate=7.736384740666215E-4]:1.61033702242E1)[&rate=2.6965012724017393E-4]:5.909518430665E1,((11[&rate=3.104784903190988E-4]:2.348853455633E1,29[&rate=2.4872077802977116E-4]:2.348853455633E1)[&rate=6.237981510512977E-4]:4.983854383572E1,(33[&rate=7.483196375783033E-4]:6.310234342154E1,13[&rate=3.4112705576945984E-4]:6.310234342154E1)[&rate=5.290132196505338E-4]:1.02247349705E1)[&rate=7.245764595646921E-4]:1.871476138806E0)[&rate=3.003174727468885E-4]:1.094568854001E0,((10[&rate=4.5106759416288164E-4]:2.398080343172E1,31[&rate=5.015707665618452E-4]:2.398080343172E1)[&rate=4.161637173012407E-4]:5.034813652561E1,23[&rate=5.290132196505338E-4]:7.432893995733E1)[&rate=2.5926063877513173E-4]:1.964183427519E0)[&rate=4.5106759416288164E-4]:3.405214627984E0)[&rate=3.104784903190988E-4]:1.684941139151E0,(17[&rate=6.610466561823494E-4]:6.939391899879E1,(27[&rate=1.463547273426599E-4]:3.01977060807E1,28[&rate=6.419833039831087E-4]:3.01977060807E1)[&rate=0.0011403325167684728]:3.919621291809E1)[&rate=2.2696360365283112E-4]:1.19893601532E1)[&rate=0.0015874933155215184]:4.492427642049E1);\ntree STATE_34 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55131.00331870173,EEF_ucld_branchRates=-266.168517335019,lnP=-55131.00331870173,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.542552018188383E-4]:7.278409787561E0,9[&rate=6.564510141123168E-4]:7.278409787561E0)[&rate=5.277660281470275E-4]:6.319540216539E0,15[&rate=7.940309510950135E-4]:1.35979500041E1)[&rate=9.242081858901678E-4]:8.764980100548E1,(14[&rate=7.940309510950135E-4]:4.55657507427E1,24[&rate=0.001014004263361372]:4.55657507427E1)[&rate=0.001629098116962156]:5.568200026689E1)[&rate=0.001137871874497968]:2.464489842708E1,((((((((30[&rate=6.435093226010557E-4]:5.026911800518E1,26[&rate=5.170879886926286E-4]:5.026911800518E1)[&rate=3.6756005998326386E-4]:1.373586706862E1,32[&rate=4.43811476278961E-4]:6.400498507379E1)[&rate=4.6467301534505685E-4]:9.145052445648E0,((((4[&rate=4.227493404543816E-4]:1.906355937245E0,2[&rate=9.515531126474297E-4]:1.906355937245E0)[&rate=9.515531126474297E-4]:5.953817341287E-1,3[&rate=5.064987423281247E-4]:2.501737671374E0)[&rate=6.975460614585562E-4]:1.057478317321E1,5[&rate=3.790568126423792E-4]:1.307652084458E1)[&rate=6.975460614585562E-4]:2.536162627894E0,((7[&rate=6.697473678898233E-4]:9.452777994389E0,6[&rate=9.813163322383094E-4]:9.452777994389E0)[&rate=4.542552018188383E-4]:1.786118343869E0,1[&rate=7.762290428511893E-4]:1.123889633826E1)[&rate=3.4341993728585334E-4]:4.373787134219E0)[&rate=3.790568126423792E-4]:5.753735404696E1)[&rate=7.592146328146416E-4]:1.944266221239E0,(16[&rate=4.120754016238206E-4]:3.840261506186E1,((22[&rate=0.0013417903287754416]:2.595260197706E0,21[&rate=3.902721220681051E-4]:2.595260197706E0)[&rate=4.120754016238206E-4]:9.045093356644E0,20[&rate=1.784003484515904E-4]:1.164035355435E1)[&rate=8.323967550210683E-4]:2.676226150751E1)[&rate=0.0014545161971881073]:3.669168867882E1)[&rate=0.0010911334569830924]:2.681450063639E0,12[&rate=8.753075008086558E-4]:7.777575380432E1)[&rate=6.185671840875535E-4]:1.039461350979E0,25[&rate=6.185671840875535E-4]:7.88152151553E1)[&rate=4.43811476278961E-4]:1.773191416267E0,(((19[&rate=7.940309510950135E-4]:1.536683910295E1,18[&rate=6.834329432048742E-4]:1.536683910295E1)[&rate=4.43811476278961E-4]:6.055722619273E1,((11[&rate=3.0245045082288494E-4]:2.318822072449E1,29[&rate=4.012627500593491E-4]:2.318822072449E1)[&rate=7.272312575634321E-4]:5.160152751478E1,(33[&rate=8.988940286301705E-4]:6.189808015986E1,13[&rate=4.8551612340910413E-4]:6.189808015986E1)[&rate=5.831099664171907E-4]:1.289166807941E1)[&rate=3.0245045082288494E-4]:1.13431705641E0)[&rate=6.065117524093762E-4]:1.22548121081E0,((10[&rate=6.564510141123168E-4]:2.302496817176E1,31[&rate=8.753075008086558E-4]:2.302496817176E1)[&rate=5.494586529473409E-4]:5.141372536616E1,23[&rate=5.717195692932298E-4]:7.443869353792E1)[&rate=5.064987423281247E-4]:2.710852968573E0)[&rate=3.557112163852169E-4]:3.438860065072E0)[&rate=8.532069844328745E-4]:1.598328086157E0,(17[&rate=8.323967550210683E-4]:7.399556651321E1,(27[&rate=4.012627500593491E-4]:2.863542246202E1,28[&rate=8.753075008086558E-4]:2.863542246202E1)[&rate=5.831099664171907E-4]:4.53601440512E1)[&rate=2.479812123353225E-4]:8.191168144505E0)[&rate=0.001137871874497968]:4.370591477895E1);\ntree STATE_35 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55114.1134672862,EEF_ucld_branchRates=-266.168517335019,lnP=-55114.1134672862,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.955528338933501E-4]:7.927185116134E0,9[&rate=7.519733328436986E-4]:7.927185116134E0)[&rate=6.461522760207562E-4]:5.324892056458E0,15[&rate=4.534125669968609E-4]:1.325207717259E1)[&rate=7.226997959955858E-4]:9.951922298852E1,(14[&rate=9.296971672565506E-4]:5.276327594094E1,24[&rate=7.519733328436986E-4]:5.276327594094E1)[&rate=0.0011090867489392182]:6.000802422017E1)[&rate=3.2046664357955466E-4]:1.454468352348E1,((((((((30[&rate=6.461522760207562E-4]:4.899683065672E1,26[&rate=4.036179538448876E-4]:4.899683065672E1)[&rate=6.826504227016899E-4]:1.009070883512E1,32[&rate=3.9310734751397334E-4]:5.908753949184E1)[&rate=4.7265679824977033E-4]:7.957897172604E0,((((4[&rate=4.036179538448876E-4]:2.390393682452E0,3[&rate=6.015042745334696E-4]:2.390393682452E0)[&rate=0.0013274019851362178]:4.075436473525E-1,2[&rate=6.461522760207562E-4]:2.797937329804E0)[&rate=5.206549297434891E-4]:1.00177100356E1,5[&rate=2.8803752704152603E-4]:1.281564736541E1)[&rate=7.519733328436986E-4]:2.940241705532E0,((7[&rate=3.2046664357955466E-4]:1.261651929139E1,6[&rate=6.123133630041144E-4]:1.261651929139E1)[&rate=9.296971672565506E-4]:1.190256172828E0,1[&rate=4.918021422456336E-4]:1.380677546421E1)[&rate=7.838894061213176E-4]:1.949113606726E0)[&rate=4.138901660049568E-4]:5.128954759351E1)[&rate=1.9875597128735014E-4]:5.079992062908E0,(16[&rate=4.534125669968609E-4]:3.627673341688E1,((22[&rate=5.804630918510973E-4]:3.27427073656E0,21[&rate=0.0010233649336536229]:3.27427073656E0)[&rate=4.138901660049568E-4]:5.223968849567E0,20[&rate=7.838894061213176E-4]:8.498239586126E0)[&rate=8.805983591297407E-4]:2.777849383075E1)[&rate=0.001233954865262643]:3.584869531047E1)[&rate=8.383266320813607E-4]:1.063858719654E0,12[&rate=7.838894061213176E-4]:7.318928744701E1)[&rate=5.908940682870152E-4]:3.195858048509E0,25[&rate=8.805983591297407E-4]:7.638514549552E1)[&rate=6.701396696330817E-4]:1.413544239252E0,(((19[&rate=4.437005080379725E-4]:1.579228560064E1,18[&rate=6.701396696330817E-4]:1.579228560064E1)[&rate=4.036179538448876E-4]:5.460139143919E1,((11[&rate=4.036179538448876E-4]:2.321872483446E1,29[&rate=5.109968510682673E-4]:2.321872483446E1)[&rate=8.010477820789281E-4]:4.650537560823E1,(33[&rate=8.587430605124715E-4]:5.661503412559E1,13[&rate=4.534125669968609E-4]:5.661503412559E1)[&rate=7.370419587114917E-4]:1.310906631711E1)[&rate=3.823022381792754E-4]:6.695765971339E-1)[&rate=4.036179538448876E-4]:4.233423618679E0,((10[&rate=3.595082820994329E-4]:2.700133680796E1,31[&rate=4.7265679824977033E-4]:2.700133680796E1)[&rate=5.401728151149252E-4]:4.676908081088E1,23[&rate=5.109968510682673E-4]:7.377041761884E1)[&rate=8.383266320813607E-4]:8.566830396693E-1)[&rate=9.041431306711395E-4]:3.171589076258E0)[&rate=4.3389580233781934E-4]:2.586570867305E0,(17[&rate=8.805983591297407E-4]:6.852046175974E1,(27[&rate=6.015042745334696E-4]:2.615098140078E1,28[&rate=0.0013274019851362178]:2.615098140078E1)[&rate=5.908940682870152E-4]:4.236948035895E1)[&rate=4.63057138167151E-4]:1.186479884233E1)[&rate=0.0013274019851362178]:4.693072308252E1);\ntree STATE_36 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55127.820752460815,EEF_ucld_branchRates=-266.168517335019,lnP=-55127.820752460815,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.133019805118262E-4]:8.330568263499E0,9[&rate=8.644694995669905E-4]:8.330568263499E0)[&rate=5.85631982298124E-4]:9.141135615336E0,15[&rate=4.4443856419774686E-4]:1.747170387883E1)[&rate=6.427903054447473E-4]:1.064734688976E2,(14[&rate=0.0015142017808350632]:5.088671067334E1,24[&rate=7.861207884588626E-4]:5.088671067334E1)[&rate=0.0011284587572499578]:7.305846210308E1)[&rate=4.3452614430466275E-4]:2.967235392064E0,((((((((30[&rate=8.040537930525356E-4]:4.839003607981E1,26[&rate=8.229895614847981E-4]:4.839003607981E1)[&rate=5.85631982298124E-4]:7.213727132008E0,32[&rate=4.739041428161422E-4]:5.560376321182E1)[&rate=3.8304010323080386E-4]:1.329241269785E1,((((4[&rate=6.940631534735494E-4]:2.307807245067E0,3[&rate=3.8304010323080386E-4]:2.307807245067E0)[&rate=9.121300656556434E-4]:3.833919919439E-1,2[&rate=3.8304010323080386E-4]:2.691199237011E0)[&rate=4.935270204716802E-4]:9.503723374764E0,5[&rate=2.9428377418232415E-4]:1.219492261177E1)[&rate=4.3452614430466275E-4]:2.106487155056E0,((7[&rate=1.8823485292091878E-4]:8.949334208196E0,6[&rate=6.427903054447473E-4]:8.949334208196E0)[&rate=6.806566266513908E-4]:1.376920905395E0,1[&rate=3.8304010323080386E-4]:1.032625511359E1)[&rate=7.528076368979361E-4]:3.97515465324E0)[&rate=4.935270204716802E-4]:5.459476614284E1)[&rate=3.8304010323080386E-4]:2.316237304932E0,(16[&rate=2.3073701202225346E-4]:3.751558098296E1,((22[&rate=0.0012611068666530745]:2.289352420862E0,21[&rate=4.04158150962714E-4]:2.289352420862E0)[&rate=6.940631534735494E-4]:5.998618876754E0,20[&rate=0.001037752225658682]:8.287971297616E0)[&rate=0.0013607468032528155]:2.922760968534E1)[&rate=7.690720105326406E-4]:3.369683223164E1)[&rate=0.001037752225658682]:2.445053427119E0,12[&rate=7.690720105326406E-4]:7.365746664172E1)[&rate=3.2362058312438845E-4]:2.373653847257E0,25[&rate=6.550564783787897E-4]:7.603112048898E1)[&rate=3.937145768377775E-4]:1.176364104165E0,(((19[&rate=9.121300656556434E-4]:1.442201540411E1,18[&rate=8.430704368143749E-4]:1.442201540411E1)[&rate=4.542908722769456E-4]:5.601778247193E1,((11[&rate=3.937145768377775E-4]:1.697187672363E1,29[&rate=7.223044532959644E-4]:1.697187672363E1)[&rate=8.040537930525356E-4]:5.13606029285E1,(33[&rate=8.229895614847981E-4]:6.146774683055E1,13[&rate=3.937145768377775E-4]:6.146774683055E1)[&rate=6.077624366440952E-4]:6.864732821583E0)[&rate=5.965903589104183E-4]:2.10731822391E0)[&rate=4.542908722769456E-4]:2.629333116707E0,((10[&rate=5.965903589104183E-4]:1.965184086013E1,31[&rate=5.333622459140468E-4]:1.965184086013E1)[&rate=5.85631982298124E-4]:5.140939749139E1,23[&rate=4.04158150962714E-4]:7.106123835152E1)[&rate=3.366722671077844E-4]:2.007892641221E0)[&rate=4.8370516464959145E-4]:4.138353600397E0)[&rate=9.684581094866725E-4]:2.085047884287E0,(17[&rate=6.940631534735494E-4]:6.902731765721E1,(27[&rate=6.550564783787897E-4]:2.974849191564E1,28[&rate=9.121300656556434E-4]:2.974849191564E1)[&rate=4.542908722769456E-4]:3.927882574157E1)[&rate=8.229895614847981E-4]:1.026521482022E1)[&rate=0.0015142017808350632]:4.761987569105E1);\ntree STATE_37 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55100.41569701832,EEF_ucld_branchRates=-266.168517335019,lnP=-55100.41569701832,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.008944245009175E-4]:9.011731128748E0,9[&rate=4.7760444139708475E-4]:9.011731128748E0)[&rate=6.318912100450975E-4]:6.852797305253E0,15[&rate=7.883889047153635E-4]:1.5864528434E1)[&rate=6.772497006034407E-4]:9.544607650725E1,(14[&rate=0.0014042872210225286]:4.396093360909E1,24[&rate=0.0014042872210225286]:4.396093360909E1)[&rate=0.0010739687739907719]:6.734967133216E1)[&rate=8.625945688028441E-4]:1.66136261398E1,(((25[&rate=7.57045259065675E-4]:7.447597201015E1,(((16[&rate=2.0971469470177067E-4]:4.162210325784E1,((22[&rate=0.0012738900649748306]:3.291519265502E0,21[&rate=4.210045171071777E-4]:3.291519265502E0)[&rate=4.210045171071777E-4]:4.604277439306E0,20[&rate=5.516287929507339E-4]:7.895796704808E0)[&rate=8.625945688028441E-4]:3.372630655303E1)[&rate=0.0010739687739907719]:2.865880217384E1,(((30[&rate=7.883889047153635E-4]:4.792330372812E1,26[&rate=4.959658652683034E-4]:4.792330372812E1)[&rate=7.019559486150385E-4]:9.591020277174E0,32[&rate=4.591107021816338E-4]:5.751432400529E1)[&rate=6.772497006034407E-4]:6.117551594769E0,((((4[&rate=5.805525893150549E-4]:2.684446854834E0,3[&rate=7.57045259065675E-4]:2.684446854834E0)[&rate=2.525037919262159E-4]:1.689639671668E-1,2[&rate=3.5638774068260217E-4]:2.853410822001E0)[&rate=4.497626059181228E-4]:8.264242173314E0,5[&rate=3.1522660642978805E-4]:1.111765299531E1)[&rate=5.143388293491342E-4]:1.936719305147E0,((7[&rate=4.210045171071777E-4]:8.678776171308E0,6[&rate=9.628498444156778E-4]:8.678776171308E0)[&rate=3.904182455614432E-4]:1.170353338113E0,1[&rate=5.707892721320559E-4]:9.849129509421E0)[&rate=3.5638774068260217E-4]:3.205242791041E0)[&rate=5.904598204204804E-4]:5.05775032996E1)[&rate=7.019559486150385E-4]:6.649029831615E0)[&rate=5.707892721320559E-4]:2.589164298629E0,12[&rate=8.053050146780069E-4]:7.28700697303E1)[&rate=4.867922470162448E-4]:1.605902279844E0)[&rate=4.110712739054605E-4]:1.935402527626E0,(((19[&rate=8.232067410795184E-4]:2.11488487283E1,18[&rate=6.894051703435004E-4]:2.11488487283E1)[&rate=4.008944245009175E-4]:5.102939776355E1,((11[&rate=4.008944245009175E-4]:1.692208855192E1,29[&rate=6.539795303115497E-4]:1.692208855192E1)[&rate=8.053050146780069E-4]:5.363350944705E1,(33[&rate=5.904598204204804E-4]:5.67704460411E1,13[&rate=4.6838394932865616E-4]:5.67704460411E1)[&rate=6.428015592967512E-4]:1.378515195787E1)[&rate=9.082256075194421E-4]:1.622648492882E0)[&rate=4.497626059181228E-4]:8.371776944209E-1,((10[&rate=7.57045259065675E-4]:2.837571125358E1,31[&rate=4.3073972863332606E-4]:2.837571125358E1)[&rate=4.7760444139708475E-4]:4.341812300126E1,23[&rate=8.232067410795184E-4]:7.179383425484E1)[&rate=5.707892721320559E-4]:1.221589931438E0)[&rate=7.149440578332835E-4]:3.3959503515E0)[&rate=5.235703285594263E-4]:3.71679141492E0,(17[&rate=8.625945688028441E-4]:7.287253464141E1,(27[&rate=4.008944245009175E-4]:2.942346574355E1,28[&rate=0.0012738900649748306]:2.942346574355E1)[&rate=7.883889047153635E-4]:4.344906889786E1)[&rate=4.867922470162448E-4]:7.255631311283E0)[&rate=0.0010739687739907719]:4.779606512836E1);\ntree STATE_38 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55142.34858739371,EEF_ucld_branchRates=-266.168517335019,lnP=-55142.34858739371,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.7593390412241615E-4]:1.128453767221E1,9[&rate=5.120167544203494E-4]:1.128453767221E1)[&rate=2.4612679596302926E-4]:7.045435707993E0,15[&rate=4.7593390412241615E-4]:1.83299733802E1)[&rate=0.0010131341646191455]:9.631206797761E1,(14[&rate=0.0015436403272377297]:4.331503428449E1,24[&rate=9.679326360199737E-4]:4.331503428449E1)[&rate=6.81885692316831E-4]:7.132700707332E1)[&rate=0.0010648792922968117]:1.070241036158E1,(((25[&rate=9.679326360199737E-4]:7.144568539248E1,(12[&rate=9.472439748438469E-4]:7.144446814974E1,((16[&rate=7.058084871821155E-4]:3.534647745666E1,((22[&rate=5.463583225712241E-4]:3.439102314845E0,21[&rate=4.36544626390831E-4]:3.439102314845E0)[&rate=6.701720005658637E-4]:4.208504858606E0,20[&rate=4.501853467915935E-4]:7.647607173451E0)[&rate=0.0015436403272377297]:2.769887028321E1)[&rate=8.910756944762019E-4]:3.282809417544E1,(((30[&rate=9.276186306027548E-4]:4.774944856688E1,26[&rate=4.88232496343585E-4]:4.774944856688E1)[&rate=0.0014384415830891151]:9.175275932769E0,32[&rate=3.726398863819391E-4]:5.692472449965E1)[&rate=5.236027179390186E-4]:7.912332098384E0,((((4[&rate=8.263487552781389E-4]:2.004785910254E0,3[&rate=4.7593390412241615E-4]:2.004785910254E0)[&rate=7.69532735662572E-4]:6.185013296545E-1,2[&rate=6.585972701545557E-4]:2.623287239909E0)[&rate=7.305318540798441E-4]:8.404952747051E0,5[&rate=3.2832269930965953E-4]:1.102823998696E1)[&rate=7.83153712212516E-4]:3.396271188542E0,((7[&rate=6.81885692316831E-4]:7.51175898561E0,6[&rate=8.263487552781389E-4]:7.51175898561E0)[&rate=6.93757782321898E-4]:2.098851533011E0,1[&rate=5.799016798643577E-4]:9.610610518621E0)[&rate=4.88232496343585E-4]:4.813900656881E0)[&rate=5.236027179390186E-4]:5.041254542253E1)[&rate=5.120167544203494E-4]:3.337515034073E0)[&rate=6.245198790139762E-4]:3.26989651764E0)[&rate=9.472439748438469E-4]:1.217242741248E-3)[&rate=0.0010131341646191455]:3.24372793639E0,(((19[&rate=0.0012003649119132476]:1.526468694514E1,18[&rate=0.0010380549488153631]:1.526468694514E1)[&rate=4.36544626390831E-4]:5.402445735164E1,((11[&rate=5.910254498651832E-4]:1.558965627505E1,29[&rate=0.0012974541230855654]:1.558965627505E1)[&rate=4.501853467915935E-4]:5.172020186376E1,(33[&rate=8.263487552781389E-4]:6.126005235008E1,13[&rate=6.133150873221203E-4]:6.126005235008E1)[&rate=6.93757782321898E-4]:6.049805788738E0)[&rate=8.575132578767027E-4]:1.979286157971E0)[&rate=0.002059150678896681]:2.051719868671E0,((10[&rate=5.002418995439331E-4]:2.530851066076E1,31[&rate=5.687644294908693E-4]:2.530851066076E1)[&rate=5.350386726772109E-4]:4.599013925146E1,23[&rate=6.357896128556575E-4]:7.129864991222E1)[&rate=0.0010939666376536962]:4.221425323881E-2)[&rate=8.739622191135632E-4]:3.348549163419E0)[&rate=8.115228610530668E-4]:5.183310901283E0,(17[&rate=9.679326360199737E-4]:7.294992952097E1,(27[&rate=8.739622191135632E-4]:2.715851181257E1,28[&rate=0.0011609629998015295]:2.715851181257E1)[&rate=5.687644294908693E-4]:4.57914177084E1)[&rate=9.089311325336518E-4]:6.922794709184E0)[&rate=0.001360058806164613]:4.547172748924E1);\ntree STATE_39 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55132.34321308806,EEF_ucld_branchRates=-266.168517335019,lnP=-55132.34321308806,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.792016848731595E-4]:9.842673647933E0,9[&rate=0.0011257919442460489]:9.842673647933E0)[&rate=7.227575423510512E-4]:6.991694760296E0,15[&rate=7.542176237838972E-4]:1.683436840823E1)[&rate=8.261531106116021E-4]:1.026377856543E2,(14[&rate=0.0010399834146125]:4.910876519242E1,24[&rate=8.914622767746791E-4]:4.910876519242E1)[&rate=5.808115754240077E-4]:7.036338887014E1)[&rate=3.5607473277891844E-4]:1.031908915267E1,(((25[&rate=5.808115754240077E-4]:7.292554220203E1,((12[&rate=9.163111749771631E-4]:6.85830449535E1,((16[&rate=4.1188677271363785E-4]:3.28079798237E1,((22[&rate=7.542176237838972E-4]:2.568414592238E0,21[&rate=6.935455940794962E-4]:2.568414592238E0)[&rate=2.698482976811609E-4]:7.551684453772E0,20[&rate=7.542176237838972E-4]:1.012009904601E1)[&rate=0.0013253464711003042]:2.268788077769E1)[&rate=0.0013253464711003042]:3.394036950344E1,((30[&rate=7.884491624313214E-4]:4.927026460483E1,26[&rate=6.935455940794962E-4]:4.927026460483E1)[&rate=8.465969755576206E-4]:8.487558449255E0,32[&rate=3.9030680715321887E-4]:5.775782305409E1)[&rate=3.9030680715321887E-4]:8.99052627305E0)[&rate=4.3290097739798845E-4]:1.834695626364E0)[&rate=2.4913693642455694E-4]:1.856365554425E0,((((4[&rate=5.476201828961527E-4]:1.55550251138E0,2[&rate=4.948305179919384E-4]:1.55550251138E0)[&rate=0.001988820846835081]:8.775165247689E-1,3[&rate=3.9030680715321887E-4]:2.433019036149E0)[&rate=8.465969755576206E-4]:8.784164979891E0,5[&rate=6.038820978058286E-4]:1.121718401604E1)[&rate=6.279066583106705E-4]:2.54074296033E0,((7[&rate=4.224471612700787E-4]:9.655401407029E0,6[&rate=8.914622767746791E-4]:9.655401407029E0)[&rate=4.741900451355997E-4]:1.142001750097E0,1[&rate=3.4389249293692765E-4]:1.079740315713E1)[&rate=0.0011257919442460489]:2.960523819243E0)[&rate=5.585215794302609E-4]:5.668148353156E1)[&rate=8.068141122266289E-4]:2.486131694108E0)[&rate=4.3290097739798845E-4]:1.774379835314E0,(((19[&rate=4.741900451355997E-4]:1.328936133427E1,18[&rate=6.935455940794962E-4]:1.328936133427E1)[&rate=4.011863411182195E-4]:5.686197575716E1,((33[&rate=8.465969755576206E-4]:6.26502613837E1,13[&rate=4.011863411182195E-4]:6.26502613837E1)[&rate=2.226919614766592E-4]:5.943014079757E0,(11[&rate=5.262132704505441E-4]:1.818633926603E1,29[&rate=5.808115754240077E-4]:1.818633926603E1)[&rate=7.542176237838972E-4]:5.040693619742E1)[&rate=5.156726423139198E-4]:1.558061627975E0)[&rate=4.3290097739798845E-4]:1.514833264136E0,((10[&rate=7.078980583701457E-4]:3.040856492385E1,31[&rate=3.67814452645611E-4]:3.040856492385E1)[&rate=3.5607473277891844E-4]:4.004894035785E1,23[&rate=4.5360247192260006E-4]:7.04575052817E1)[&rate=8.914622767746791E-4]:1.208665073862E0)[&rate=3.4389249293692765E-4]:3.033751681784E0)[&rate=4.844940753298634E-4]:2.396330550121E0,(17[&rate=0.0010800051900569539]:7.112218455816E1,(27[&rate=5.695790677333439E-4]:2.852649273496E1,28[&rate=0.0010044028855206808]:2.852649273496E1)[&rate=6.661787418863078E-4]:4.259569182319E1)[&rate=8.683029239028272E-4]:5.974068029314E0)[&rate=0.0014355257562238314]:5.269499062775E1);\ntree STATE_40 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55144.55479300203,EEF_ucld_branchRates=-266.168517335019,lnP=-55144.55479300203,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.039432217924652E-4]:9.396491810929E0,9[&rate=6.087474740306766E-4]:9.396491810929E0)[&rate=2.952048641482632E-4]:1.017067187296E1,15[&rate=4.8024592124351026E-4]:1.956716368389E1)[&rate=8.810150087191867E-4]:9.287141939955E1,(14[&rate=0.0010140022869874429]:4.81949816113E1,24[&rate=0.0011381071411997016]:4.81949816113E1)[&rate=6.955218332899894E-4]:6.424360147214E1)[&rate=0.0012709979502969477]:1.360932213935E1,((((12[&rate=8.447408867687516E-4]:6.858684258418E1,((((((4[&rate=4.558702147762144E-4]:1.752816977588E0,2[&rate=9.645652670283671E-4]:1.752816977588E0)[&rate=0.0010413486866019549]:4.048374619927E-1,3[&rate=4.1711349681696055E-4]:2.15765443958E0)[&rate=6.697862050415918E-4]:1.226347080273E1,5[&rate=4.8024592124351026E-4]:1.442112524232E1)[&rate=0.0016081030737343806]:1.238258794156E0,((7[&rate=4.3041782997860445E-4]:8.611959542189E0,6[&rate=5.735720407549848E-4]:8.611959542189E0)[&rate=6.327026470944442E-4]:7.879668214448E-1,1[&rate=6.697862050415918E-4]:9.399926363634E0)[&rate=7.952546310964095E-4]:6.259457672837E0)[&rate=5.039432217924652E-4]:5.004670354465E1,((30[&rate=6.572443298341171E-4]:4.675128054603E1,26[&rate=8.111790612640112E-4]:4.675128054603E1)[&rate=9.206583783890526E-4]:9.876370676556E0,32[&rate=4.032927826023763E-4]:5.662765122258E1)[&rate=4.681644760669467E-4]:9.078436358535E0)[&rate=0.0010140022869874429]:2.115217798816E0,(16[&rate=5.15630836107543E-4]:3.287667069061E1,((22[&rate=0.0012209296385452346]:1.779964283452E0,21[&rate=4.1711349681696055E-4]:1.779964283452E0)[&rate=4.1711349681696055E-4]:6.943626078218E0,20[&rate=0.0010140022869874429]:8.72359036167E0)[&rate=0.002204751392490196]:2.415308032894E1)[&rate=8.625022924798325E-4]:3.494463468932E1)[&rate=0.0016081030737343806]:7.655372042489E-1)[&rate=3.88818351550382E-4]:2.183389596041E0,25[&rate=7.648609189438319E-4]:7.077023218022E1)[&rate=4.558702147762144E-4]:2.37656867325E0,(((19[&rate=6.448901290833521E-4]:1.438844569382E1,18[&rate=8.625022924798325E-4]:1.438844569382E1)[&rate=4.032927826023763E-4]:5.599522601485E1,((11[&rate=2.952048641482632E-4]:2.083834196275E1,29[&rate=6.327026470944442E-4]:2.083834196275E1)[&rate=9.645652670283671E-4]:4.788044665436E1,(33[&rate=0.0011381071411997016]:5.941007681432E1,13[&rate=5.61970962757621E-4]:5.941007681432E1)[&rate=8.111790612640112E-4]:9.308711802779E0)[&rate=9.645652670283671E-4]:1.664883091574E0)[&rate=9.206583783890526E-4]:1.376996615387E0,((10[&rate=4.921593858346972E-4]:2.500014685199E1,31[&rate=8.447408867687516E-4]:2.500014685199E1)[&rate=5.503983624823375E-4]:4.53196110857E1,23[&rate=6.572443298341171E-4]:7.031975793769E1)[&rate=3.1892843975205303E-4]:1.440910386371E0)[&rate=7.222882387406479E-4]:1.38613252941E0)[&rate=4.4330969163319534E-4]:4.891556480619E0,(17[&rate=7.952546310964095E-4]:6.836064350579E1,(27[&rate=5.503983624823375E-4]:3.296519522956E1,28[&rate=0.0011029279373527803]:3.296519522956E1)[&rate=8.625022924798325E-4]:3.539544827623E1)[&rate=0.0010140022869874429]:9.677713828305E0)[&rate=0.00148848390500147]:4.800954788869E1);\ntree STATE_41 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55140.96694267298,EEF_ucld_branchRates=-266.168517335019,lnP=-55140.96694267298,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.988674925122007E-4]:1.043689047176E1,9[&rate=5.058889965524765E-4]:1.043689047176E1)[&rate=2.4941543506937745E-4]:4.83045015668E0,15[&rate=9.132082699401146E-4]:1.526734062844E1)[&rate=8.318168442553656E-4]:1.035526475369E2,(14[&rate=0.00142615782472543]:4.553408589455E1,24[&rate=8.504582666961033E-4]:4.553408589455E1)[&rate=7.971679162523477E-4]:7.328590227078E1)[&rate=0.0010210387738082613]:6.397996069538E0,((((12[&rate=9.905145293690654E-4]:7.533219818484E1,(((((4[&rate=5.264642961069288E-4]:1.912853849069E0,2[&rate=0.0013234790459352378]:1.912853849069E0)[&rate=9.132082699401146E-4]:7.435696501323E-1,3[&rate=7.654182332212986E-4]:2.656423499202E0)[&rate=7.654182332212986E-4]:1.248357860229E1,5[&rate=3.869432354197096E-4]:1.51400021015E1)[&rate=4.853089407304815E-4]:1.415151625279E0,((7[&rate=4.5404954817196766E-4]:9.559288008933E0,6[&rate=8.909914235419271E-4]:9.559288008933E0)[&rate=2.985193062479921E-4]:1.256668673813E0,1[&rate=5.896166536640857E-4]:1.081595668275E1)[&rate=3.1676210513098107E-4]:5.739197044028E0)[&rate=6.343082915030767E-4]:5.518334425888E1,(((30[&rate=6.825422987726087E-4]:5.842448684577E1,26[&rate=6.1160601754234E-4]:5.842448684577E1)[&rate=7.654182332212986E-4]:6.164940330566E0,32[&rate=3.869432354197096E-4]:6.458942717634E1)[&rate=5.16167540148099E-4]:6.660923322771E0,(16[&rate=3.988674925122007E-4]:3.242386911328E1,((22[&rate=8.701342138032625E-4]:3.284312348937E0,21[&rate=4.1041034163159513E-4]:3.284312348937E0)[&rate=5.896166536640857E-4]:7.975588048879E0,20[&rate=7.504479402456898E-4]:1.125990039782E1)[&rate=0.0019348362196393116]:2.116396871546E1)[&rate=8.701342138032625E-4]:3.882648138583E1)[&rate=7.360020646330965E-4]:4.881474865434E-1)[&rate=6.700693478909562E-4]:3.593700199181E0)[&rate=7.360020646330965E-4]:1.614503148307E-1,25[&rate=5.896166536640857E-4]:7.549364849967E1)[&rate=3.7454271853246715E-4]:1.642580146972E0,(((19[&rate=8.701342138032625E-4]:1.545733146932E1,18[&rate=6.005319252345768E-4]:1.545733146932E1)[&rate=3.7454271853246715E-4]:5.642752373783E1,((11[&rate=6.005319252345768E-4]:2.22382604358E1,29[&rate=4.1041034163159513E-4]:2.22382604358E1)[&rate=7.504479402456898E-4]:4.82625558205E1,(33[&rate=0.001054843752334472]:5.952525684885E1,13[&rate=4.1041034163159513E-4]:5.952525684885E1)[&rate=4.5404954817196766E-4]:1.097555940745E1)[&rate=4.7496519138178443E-4]:1.384038950855E0)[&rate=9.905145293690654E-4]:1.421697975266E0,((10[&rate=7.220305670650937E-4]:2.063529370569E1,31[&rate=4.434207066278796E-4]:2.063529370569E1)[&rate=2.985193062479921E-4]:5.246589938567E1,23[&rate=4.6455430218954904E-4]:7.310119309136E1)[&rate=5.058889965524765E-4]:2.0536009106E-1)[&rate=7.654182332212986E-4]:3.829675464218E0)[&rate=6.228580832360526E-4]:1.185608470405E0,(17[&rate=0.0011360694639734488]:7.058571658017E1,(27[&rate=4.3263301442972047E-4]:2.712045854725E1,28[&rate=9.370046689971604E-4]:2.712045854725E1)[&rate=8.504582666961033E-4]:4.346525803292E1)[&rate=5.681897643302158E-4]:7.736120536869E0)[&rate=0.0015840400836317327]:4.689614711783E1);\ntree STATE_42 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55145.30263896374,EEF_ucld_branchRates=-266.168517335019,lnP=-55145.30263896374,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=2.920800003552209E-4]:7.703462259216E0,9[&rate=8.644366508332302E-4]:7.703462259216E0)[&rate=3.7985457365216814E-4]:8.429615571707E0,15[&rate=4.864814306679694E-4]:1.613307783092E1)[&rate=7.963041900247137E-4]:9.077159797243E1,(14[&rate=0.0011757946616699243]:4.802761296986E1,24[&rate=0.0010269986196701079]:4.802761296986E1)[&rate=9.984883635338491E-4]:5.887706283349E1)[&rate=0.0010927933973366329]:2.168697434658E1,((((12[&rate=9.478564534657445E-4]:6.721066318336E1,((16[&rate=4.864814306679694E-4]:3.362958819224E1,((22[&rate=4.972388885615076E-4]:3.10837600682E0,21[&rate=5.50408045094477E-4]:3.10837600682E0)[&rate=7.963041900247137E-4]:5.114945419446E0,20[&rate=7.809324796812648E-4]:8.223321426266E0)[&rate=0.0014716225656306364]:2.540626676597E1)[&rate=8.835517501705293E-4]:3.168671327312E1,(((30[&rate=7.963041900247137E-4]:4.688796133238E1,26[&rate=6.267592754034485E-4]:4.688796133238E1)[&rate=9.250960133045228E-4]:7.761299029876E0,32[&rate=4.1853174021812967E-4]:5.464926036226E1)[&rate=4.1853174021812967E-4]:8.3706184527E0,((((4[&rate=9.250960133045228E-4]:1.932020677131E0,2[&rate=2.1615533129271222E-4]:1.932020677131E0)[&rate=7.809324796812648E-4]:5.629215565846E-1,3[&rate=6.381637697375828E-4]:2.494942233716E0)[&rate=8.288922392354498E-4]:1.16518003219E1,5[&rate=4.061815748098438E-4]:1.414674255561E1)[&rate=8.644366508332302E-4]:2.32607714826E0,((7[&rate=4.3048225216254707E-4]:1.015774448793E1,6[&rate=9.478564534657445E-4]:1.015774448793E1)[&rate=6.381637697375828E-4]:8.519460318665E-1,1[&rate=5.50408045094477E-4]:1.10096905198E1)[&rate=3.1443142076645054E-4]:5.463129184076E0)[&rate=5.93436149303632E-4]:4.654705911108E1)[&rate=6.15515635831176E-4]:2.296422650394E0)[&rate=6.15515635831176E-4]:1.89436171801E0)[&rate=7.809324796812648E-4]:2.372639640471E0,25[&rate=7.963041900247137E-4]:6.958330282383E1)[&rate=4.061815748098438E-4]:4.06220826455E0,((((11[&rate=4.534774415688267E-4]:1.876467808031E1,29[&rate=5.185613993546539E-4]:1.876467808031E1)[&rate=6.267592754034485E-4]:4.869020828309E1,(33[&rate=9.478564534657445E-4]:5.500339939219E1,13[&rate=6.615349504165037E-4]:5.500339939219E1)[&rate=3.1443142076645054E-4]:1.245148697121E1)[&rate=0.0016322844698275763]:1.336654750797E0,(19[&rate=9.037216918371041E-4]:1.715194295217E1,18[&rate=6.381637697375828E-4]:1.715194295217E1)[&rate=4.3048225216254707E-4]:5.163959816202E1)[&rate=5.397830689284798E-4]:2.39971468124E0,((10[&rate=7.111541339738366E-4]:2.184027018874E1,31[&rate=4.534774415688267E-4]:2.184027018874E1)[&rate=4.1853174021812967E-4]:4.842136607569E1,23[&rate=4.1853174021812967E-4]:7.026163626443E1)[&rate=0.001058225055366865]:9.296195309961E-1)[&rate=7.111541339738366E-4]:2.454255292954E0)[&rate=7.809324796812648E-4]:4.008358278038E0,(17[&rate=7.517419611962864E-4]:6.740256680429E1,(27[&rate=5.291741074700119E-4]:2.661667141988E1,28[&rate=0.0014716225656306364]:2.661667141988E1)[&rate=4.864814306679694E-4]:4.078589538441E1)[&rate=0.0014716225656306364]:1.025130256213E1)[&rate=9.478564534657445E-4]:5.093778078351E1);\ntree STATE_43 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55138.548908553275,EEF_ucld_branchRates=-266.168517335019,lnP=-55138.548908553275,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.1419014849046835E-4]:1.039759783966E1,9[&rate=6.759619958816485E-4]:1.039759783966E1)[&rate=4.1581162496061406E-4]:8.179943095316E0,15[&rate=7.860691520011469E-4]:1.857754093497E1)[&rate=8.367428394828276E-4]:9.312108690729E1,(14[&rate=0.0011073784503783308]:4.283943082598E1,24[&rate=0.0011073784503783308]:4.283943082598E1)[&rate=8.56496658847231E-4]:6.885919701629E1)[&rate=0.0014000459437884432]:1.710994810625E1,((((12[&rate=7.713252958882316E-4]:7.380014879164E1,((16[&rate=5.939985148704459E-4]:4.05076197524E1,((22[&rate=6.970000490024071E-4]:4.096207031646E0,21[&rate=6.863049142318677E-4]:4.096207031646E0)[&rate=4.913621150256415E-4]:6.751091746551E0,20[&rate=7.080875572618298E-4]:1.08472987782E1)[&rate=6.759619958816485E-4]:2.966032097421E1)[&rate=0.0012004708896018903]:3.097245531099E1,(((((4[&rate=6.759619958816485E-4]:2.665395458276E0,3[&rate=4.339493665390688E-4]:2.665395458276E0)[&rate=4.42616783617283E-4]:4.322731695401E-1,2[&rate=6.467140853789835E-4]:3.097668627816E0)[&rate=5.302187050194217E-4]:1.11257888257E1,5[&rate=2.4851141585971177E-4]:1.422345745351E1)[&rate=7.196136009553508E-4]:1.404664474952E0,((7[&rate=7.080875572618298E-4]:1.088536563893E1,6[&rate=6.284275279269907E-4]:1.088536563893E1)[&rate=5.775858132059484E-4]:8.084332546282E-1,1[&rate=4.675158235592779E-4]:1.169379889356E1)[&rate=5.695288101655564E-4]:3.934323034905E0)[&rate=5.695288101655564E-4]:5.243492412393E1,((30[&rate=7.860691520011469E-4]:5.233483004036E1,26[&rate=4.991784437569117E-4]:5.233483004036E1)[&rate=6.467140853789835E-4]:8.373472929551E0,32[&rate=4.339493665390688E-4]:6.070830296991E1)[&rate=4.062215493377317E-4]:7.35474308248E0)[&rate=4.675158235592779E-4]:3.417029011006E0)[&rate=7.713252958882316E-4]:2.320073728243E0)[&rate=5.147144393905096E-4]:1.733687291754E0,25[&rate=8.782149957264873E-4]:7.553383608339E1)[&rate=3.1419014849046835E-4]:1.233248395423E0,((((33[&rate=7.860691520011469E-4]:5.69995734868E1,13[&rate=4.675158235592779E-4]:5.69995734868E1)[&rate=4.062215493377317E-4]:1.312753858307E1,(11[&rate=4.1581162496061406E-4]:1.32272923462E1,29[&rate=6.659360729879755E-4]:1.32272923462E1)[&rate=6.023821773396867E-4]:5.689981972367E1)[&rate=5.775858132059484E-4]:2.197517846045E0,(19[&rate=4.339493665390688E-4]:1.978938956257E1,18[&rate=5.857378277038243E-4]:1.978938956257E1)[&rate=3.4829290701487536E-4]:5.253524035335E1)[&rate=7.442045428766068E-4]:2.718969063263E0,((10[&rate=4.834919730499928E-4]:2.351242001546E1,31[&rate=2.898257698484427E-4]:2.351242001546E1)[&rate=4.1581162496061406E-4]:5.060892926078E1,23[&rate=4.062215493377317E-4]:7.412134927624E1)[&rate=5.147144393905096E-4]:9.222497029401E-1)[&rate=4.991784437569117E-4]:1.723485499639E0)[&rate=5.615536705447738E-4]:3.547262302409E0,(17[&rate=7.316317098152575E-4]:7.021975670511E1,(27[&rate=6.659360729879755E-4]:3.037929369254E1,28[&rate=9.023966270115289E-4]:3.037929369254E1)[&rate=7.080875572618298E-4]:3.984046301257E1)[&rate=7.860691520011469E-4]:1.009459007612E1)[&rate=8.367428394828276E-4]:4.849422916729E1);\ntree STATE_44 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55161.72593721111,EEF_ucld_branchRates=-266.168517335019,lnP=-55161.72593721111,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.075498942296498E-4]:9.499997955933E0,9[&rate=4.777560469269576E-4]:9.499997955933E0)[&rate=5.314940929565066E-4]:1.034031043582E1,15[&rate=5.492657550090859E-4]:1.984030839175E1)[&rate=7.070917474507502E-4]:9.06702569276E1,(14[&rate=0.0012423700575887862]:4.646972515889E1,24[&rate=7.997612636474515E-4]:4.646972515889E1)[&rate=0.0012423700575887862]:6.404084016046E1)[&rate=7.437375394134466E-4]:1.74070402285E1,((((((11[&rate=8.88821328046344E-4]:1.57574856806E1,29[&rate=9.608465576299054E-4]:1.57574856806E1)[&rate=7.070917474507502E-4]:5.783233421912E1,(33[&rate=9.106902406142049E-4]:5.756480516057E1,13[&rate=4.08851024340255E-4]:5.756480516057E1)[&rate=3.075498942296498E-4]:1.602501473914E1)[&rate=7.705263813180125E-4]:6.114017274561E-1,(19[&rate=5.048363747619781E-4]:1.332777837342E1,18[&rate=7.568606362520217E-4]:1.332777837342E1)[&rate=4.1956173764178906E-4]:6.087344325376E1)[&rate=4.1956173764178906E-4]:1.860083352401E0,((10[&rate=6.327021259429665E-4]:2.828940835231E1,31[&rate=7.568606362520217E-4]:2.828940835231E1)[&rate=4.685359164666626E-4]:4.602310366972E1,23[&rate=4.958828004719774E-4]:7.431251202203E1)[&rate=4.496395224965875E-4]:1.748792957545E0)[&rate=6.7366725652099E-4]:1.129565972212E0,((12[&rate=7.848007931243338E-4]:7.324052145657E1,((16[&rate=5.403694516066005E-4]:4.225543650921E1,((22[&rate=6.845077969393678E-4]:4.55103022196E0,21[&rate=3.4475669517703447E-4]:4.55103022196E0)[&rate=7.188993911109792E-4]:4.452458936007E0,20[&rate=8.88821328046344E-4]:9.003489157967E0)[&rate=7.070917474507502E-4]:3.325194735125E1)[&rate=9.902111403179484E-4]:2.899689458244E1,(((((4[&rate=6.03903107226097E-4]:2.658467615532E0,3[&rate=4.591746835097254E-4]:2.658467615532E0)[&rate=7.568606362520217E-4]:4.312814910474E-1,2[&rate=4.2988480108298234E-4]:3.08974910658E0)[&rate=4.958828004719774E-4]:1.021984137943E1,5[&rate=3.277660969959996E-4]:1.330959048601E1)[&rate=8.321251008112734E-4]:2.200936733566E0,(1[&rate=4.3989172715697524E-4]:1.112175108672E1,(6[&rate=5.945740391571921E-4]:1.050311365094E1,7[&rate=4.2988480108298234E-4]:1.050311365094E1)[&rate=3.9766055960902637E-4]:6.186374357867E-1)[&rate=4.777560469269576E-4]:4.38877613285E0)[&rate=5.314940929565066E-4]:5.483256969557E1,((30[&rate=6.133565372713593E-4]:5.143904726406E1,26[&rate=5.492657550090859E-4]:5.143904726406E1)[&rate=8.497713405707449E-4]:8.101793263892E0,32[&rate=2.8123200507937206E-4]:5.954084052795E1)[&rate=7.070917474507502E-4]:1.080225638719E1)[&rate=5.945740391571921E-4]:9.092341765113E-1)[&rate=8.497713405707449E-4]:1.988190364919E0)[&rate=8.321251008112734E-4]:1.652694864405E0,25[&rate=6.7366725652099E-4]:7.489321632097E1)[&rate=7.705263813180125E-4]:2.297654630813E0)[&rate=0.0012423700575887862]:5.556737538729E0,(17[&rate=9.106902406142049E-4]:7.03260697609E1,(27[&rate=3.9766055960902637E-4]:3.13943760786E1,28[&rate=6.327021259429665E-4]:3.13943760786E1)[&rate=7.997612636474515E-4]:3.893169368229E1)[&rate=6.03903107226097E-4]:1.242153872962E1)[&rate=0.0012423700575887862]:4.516999705734E1);\ntree STATE_45 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55126.76398413293,EEF_ucld_branchRates=-266.168517335019,lnP=-55126.76398413293,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.753680568889684E-4]:7.858405734945E0,9[&rate=8.516375335182313E-4]:7.858405734945E0)[&rate=5.478517198306347E-4]:8.554521422425E0,15[&rate=6.112264434133929E-4]:1.641292715737E1)[&rate=8.119131396873995E-4]:9.065112668216E1,(14[&rate=0.0012810625076170876]:4.170777599229E1,24[&rate=7.762560221783427E-4]:4.170777599229E1)[&rate=0.0012810625076170876]:6.535627784724E1)[&rate=8.971337723704443E-4]:1.942577600451E1,((((((11[&rate=4.770249485044845E-4]:1.989826043279E1,29[&rate=6.02295069833516E-4]:1.989826043279E1)[&rate=7.877670453876485E-4]:5.061548952531E1,(33[&rate=8.119131396873995E-4]:6.075643073145E1,13[&rate=3.9193294264194394E-4]:6.075643073145E1)[&rate=6.291184222040986E-4]:9.757319226653E0)[&rate=7.03226211741024E-4]:1.377076449703E0,(19[&rate=7.650707262133881E-4]:1.273699869083E1,18[&rate=0.0012105851690240635]:1.273699869083E1)[&rate=4.770249485044845E-4]:5.915382771698E1)[&rate=3.4206191354322257E-4]:3.398579637754E0,((10[&rate=8.246342526899382E-4]:1.977345183244E1,31[&rate=8.971337723704443E-4]:1.977345183244E1)[&rate=5.571245852143261E-4]:5.370015632853E1,23[&rate=3.4206191354322257E-4]:7.347360816097E1)[&rate=6.840816288693066E-4]:1.81579788459E0)[&rate=4.987767399429767E-4]:1.603451294238E0,((12[&rate=7.331681994384833E-4]:7.499847439311E1,((16[&rate=4.531144001203039E-4]:3.020043852391E1,((22[&rate=8.971337723704443E-4]:2.076149905965E0,21[&rate=8.246342526899382E-4]:2.076149905965E0)[&rate=9.512637010068684E-4]:5.645616854511E0,20[&rate=4.987767399429767E-4]:7.721766760476E0)[&rate=0.0012810625076170876]:2.247867176344E1)[&rate=4.770249485044845E-4]:4.348388622681E1,(((((4[&rate=7.877670453876485E-4]:1.656853159756E0,2[&rate=8.811839713007434E-4]:1.656853159756E0)[&rate=5.384439833987434E-4]:8.466007322695E-1,3[&rate=8.119131396873995E-4]:2.503453892026E0)[&rate=0.0010194802074486018]:1.220289372667E1,5[&rate=4.0994026115434E-4]:1.47063476187E1)[&rate=4.6540207857661333E-4]:2.661259554805E0,(1[&rate=4.987767399429767E-4]:1.204639149737E1,(6[&rate=9.720389841955517E-4]:9.640213110594E0,7[&rate=5.190982088454859E-4]:9.640213110594E0)[&rate=6.02295069833516E-4]:2.406178386774E0)[&rate=9.320047976716845E-4]:5.321215676133E0)[&rate=7.650707262133881E-4]:5.528566329665E1,((30[&rate=7.130250124483001E-4]:5.563579333722E1,26[&rate=5.753680568889684E-4]:5.563579333722E1)[&rate=8.660522372020216E-4]:9.973289110392E0,32[&rate=3.4206191354322257E-4]:6.560908244761E1)[&rate=6.74702108215824E-4]:7.044188022539E0)[&rate=8.516375335182313E-4]:1.031054280572E0)[&rate=5.478517198306347E-4]:1.314149642383E0)[&rate=6.65429962947757E-4]:1.151827941771E0,25[&rate=6.291184222040986E-4]:7.615030233488E1)[&rate=5.662889199190407E-4]:7.425550049205E-1)[&rate=9.320047976716845E-4]:3.036139094536E0,(17[&rate=6.65429962947757E-4]:6.633629727939E1,(27[&rate=7.650707262133881E-4]:2.739042686163E1,28[&rate=9.512637010068684E-4]:2.739042686163E1)[&rate=6.74702108215824E-4]:3.894587041776E1)[&rate=7.541794849243332E-4]:1.359269915494E1)[&rate=0.0010194802074486018]:4.65608334097E1);\ntree STATE_46 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55163.3935945383,EEF_ucld_branchRates=-266.168517335019,lnP=-55163.3935945383,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.5292014258110024E-4]:7.130621327583E0,9[&rate=5.398310647903867E-4]:7.130621327583E0)[&rate=3.851810934633781E-4]:6.893552370316E0,15[&rate=8.983637816324361E-4]:1.40241736979E1)[&rate=9.808262641340737E-4]:8.762432034037E1,(14[&rate=0.0010235593430365133]:4.207662040389E1,24[&rate=0.0013483044502161205]:4.207662040389E1)[&rate=9.282688252355821E-4]:5.957187363438E1)[&rate=8.587271569987223E-4]:1.816797971758E1,((((((11[&rate=7.916515747379436E-4]:2.172928251256E1,29[&rate=5.073876624633162E-4]:2.172928251256E1)[&rate=8.46590163237665E-4]:4.423816299637E1,(33[&rate=6.134507640268771E-4]:5.925791647362E1,13[&rate=7.251158238847533E-4]:5.925791647362E1)[&rate=6.220455464741775E-4]:6.709529035314E0)[&rate=6.987168982446417E-4]:1.749255299989E0,(19[&rate=9.445946506250665E-4]:1.141088412532E1,18[&rate=7.525768337650957E-4]:1.141088412532E1)[&rate=6.644947301137631E-4]:5.630581668361E1)[&rate=6.81511936042071E-4]:3.220727555077E0,((10[&rate=0.001193687248974803]:2.079693916843E1,31[&rate=9.282688252355821E-4]:2.079693916843E1)[&rate=6.390818124182727E-4]:4.924978873534E1,23[&rate=5.498034337926013E-4]:7.004672790377E1)[&rate=8.126367741410239E-4]:8.907004602334E-1)[&rate=5.871281474405948E-4]:2.50776107453E0,((12[&rate=7.620429738500196E-4]:6.959242779252E1,((((((4[&rate=8.126367741410239E-4]:2.085455664494E0,2[&rate=7.916515747379436E-4]:2.085455664494E0)[&rate=3.3634406799986076E-4]:8.399325698624E-1,3[&rate=5.871281474405948E-4]:2.925388234356E0)[&rate=6.475565056749473E-4]:9.03523675492E0,5[&rate=6.047804337187823E-4]:1.196062498928E1)[&rate=5.688903147893429E-4]:2.276765125325E0,(1[&rate=8.983637816324361E-4]:9.628405858725E0,(6[&rate=7.916515747379436E-4]:7.843382518316E0,7[&rate=5.073876624633162E-4]:7.843382518316E0)[&rate=7.251158238847533E-4]:1.785023340409E0)[&rate=8.845451963420485E-4]:4.608984255875E0)[&rate=4.8250870056834334E-4]:5.232035074262E1,((30[&rate=8.845451963420485E-4]:4.785737870199E1,26[&rate=6.390818124182727E-4]:4.785737870199E1)[&rate=9.282688252355821E-4]:7.742328068296E0,32[&rate=5.871281474405948E-4]:5.559970677028E1)[&rate=4.1358919677052914E-4]:1.095803408694E1)[&rate=8.46590163237665E-4]:1.076926893791E0,(16[&rate=5.187131058016917E-4]:2.736880309325E1,((22[&rate=0.001048365368438611]:2.726489911129E0,21[&rate=7.71696458904038E-4]:2.726489911129E0)[&rate=5.29493755873561E-4]:5.306784973402E0,20[&rate=5.871281474405948E-4]:8.033274884532E0)[&rate=0.0015440777223875378]:1.933552820872E1)[&rate=9.282688252355821E-4]:4.026586465776E1)[&rate=8.348928553535478E-4]:1.95776004151E0)[&rate=8.46590163237665E-4]:5.051758831679E-1,25[&rate=7.074236852227159E-4]:7.009760367569E1)[&rate=7.162185203371399E-4]:3.347585762839E0)[&rate=4.1358919677052914E-4]:4.497399052369E0,(17[&rate=6.900842002504263E-4]:6.848160962452E1,(27[&rate=5.29493755873561E-4]:2.734115266298E1,28[&rate=0.001048365368438611]:2.734115266298E1)[&rate=8.126367741410239E-4]:4.114045696153E1)[&rate=8.020016444966069E-4]:9.460978866385E0)[&rate=0.0015440777223875378]:4.187388526495E1);\ntree STATE_47 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55133.600694501525,EEF_ucld_branchRates=-266.168517335019,lnP=-55133.600694501525,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.297317294209122E-4]:6.696908609474E0,9[&rate=6.13229223596863E-4]:6.696908609474E0)[&rate=3.4865904347525613E-4]:9.524894421299E0,15[&rate=3.110242343898536E-4]:1.622180303077E1)[&rate=6.473323724414366E-4]:9.510850828169E1,(14[&rate=0.0012766318523924382]:4.71097709767E1,24[&rate=8.282020964548449E-4]:4.71097709767E1)[&rate=9.858626085533263E-4]:6.422054033576E1)[&rate=6.13229223596863E-4]:6.217004436443E0,(((((((4[&rate=9.526233140142844E-4]:1.903070674221E0,2[&rate=5.612233167458301E-4]:1.903070674221E0)[&rate=5.612233167458301E-4]:1.052656958193E0,3[&rate=4.760055041376315E-4]:2.955727632414E0)[&rate=7.258457943464438E-4]:8.948028195741E0,5[&rate=3.244348253300856E-4]:1.190375582815E1)[&rate=3.810263305912398E-4]:2.527225365696E0,(1[&rate=2.797414720436004E-4]:9.404203999474E0,(6[&rate=3.4865904347525613E-4]:8.770327448283E0,7[&rate=5.712434676241928E-4]:8.770327448283E0)[&rate=6.024066172647704E-4]:6.338765511914E-1)[&rate=5.037478006676626E-4]:5.026777194377E0)[&rate=6.845152007474311E-4]:5.798416628372E1,((12[&rate=8.282020964548449E-4]:6.721164831747E1,(16[&rate=7.258457943464438E-4]:3.102261719076E1,((22[&rate=7.902547585901267E-4]:2.807853150029E0,21[&rate=2.3495948405539735E-4]:2.807853150029E0)[&rate=7.258457943464438E-4]:5.276954592525E0,20[&rate=7.902547585901267E-4]:8.084807742554E0)[&rate=0.0017165777367884637]:2.293780944821E1)[&rate=6.977665816242626E-4]:3.618903112671E1)[&rate=7.407960993152723E-4]:3.858806262331E0,((30[&rate=6.845152007474311E-4]:5.052149642274E1,26[&rate=4.1074184225312624E-4]:5.052149642274E1)[&rate=6.356652571668981E-4]:1.313560180522E1,32[&rate=2.3495948405539735E-4]:6.365709822796E1)[&rate=6.473323724414366E-4]:7.41335635184E0)[&rate=4.575913176648086E-4]:1.34469289777E0)[&rate=2.6016954914136686E-4]:2.985562719683E0,(25[&rate=7.407960993152723E-4]:7.454948757866E1,((((33[&rate=7.902547585901267E-4]:5.739504782319E1,13[&rate=3.4865904347525613E-4]:5.739504782319E1)[&rate=4.202957715167862E-4]:1.296283071257E1,(11[&rate=4.944625665496633E-4]:1.71442280954E1,29[&rate=4.575913176648086E-4]:1.71442280954E1)[&rate=5.416257423419832E-4]:5.321365044036E1)[&rate=4.1074184225312624E-4]:7.597966803079E-1,(19[&rate=8.491435965940325E-4]:1.153068591923E1,18[&rate=7.902547585901267E-4]:1.153068591923E1)[&rate=4.202957715167862E-4]:5.958698929684E1)[&rate=5.814346286318608E-4]:1.915907746852E0,((10[&rate=4.010382669618826E-4]:2.220676028084E1,31[&rate=6.593393222089163E-4]:2.220676028084E1)[&rate=3.810263305912398E-4]:5.033960885297E1,23[&rate=4.390772099068804E-4]:7.254636913381E1)[&rate=6.593393222089163E-4]:4.872138291033E-1)[&rate=0.0011873131682265602]:1.515904615739E0)[&rate=8.086362266734E-4]:8.512226185964E-1)[&rate=8.282020964548449E-4]:4.496828142512E0,(17[&rate=8.491435965940325E-4]:6.823938679106E1,(27[&rate=4.852203911524246E-4]:2.548502793971E1,28[&rate=0.0010678934202925385]:2.548502793971E1)[&rate=5.320151502616179E-4]:4.275435885134E1)[&rate=4.1074184225312624E-4]:1.165815154871E1)[&rate=0.0017165777367884637]:3.764977740914E1);\ntree STATE_48 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55149.05309882678,EEF_ucld_branchRates=-266.168517335019,lnP=-55149.05309882678,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=7.036856012933165E-4]:8.047622462807E0,9[&rate=7.274724279311377E-4]:8.047622462807E0)[&rate=3.7510030485838757E-4]:7.206445773086E0,15[&rate=3.461185576535476E-4]:1.525406823589E1)[&rate=8.263454258946099E-4]:9.681637875805E1,(14[&rate=0.001384288181343608]:5.325579813316E1,24[&rate=6.393674170843887E-4]:5.325579813316E1)[&rate=8.43375440023308E-4]:5.881464886078E1)[&rate=6.294078235284257E-4]:1.138556029405E1,(((((((11[&rate=6.704141562730126E-4]:1.747858804207E1,29[&rate=4.527084599049553E-4]:1.747858804207E1)[&rate=7.949100218371862E-4]:5.051371236513E1,(33[&rate=8.43375440023308E-4]:6.022354781552E1,13[&rate=6.196108332609429E-4]:6.022354781552E1)[&rate=3.083853664798067E-4]:7.76875259168E0)[&rate=0.0010793651134835384]:2.755089773435E0,(19[&rate=9.753464580252881E-4]:1.13574166349E1,18[&rate=5.270442686019902E-4]:1.13574166349E1)[&rate=4.4278963098648444E-4]:5.938997354573E1)[&rate=4.719429596590307E-4]:1.506133633603E0,((10[&rate=4.624131643987955E-4]:2.176016501524E1,31[&rate=7.66310810286895E-4]:2.176016501524E1)[&rate=5.089160961351947E-4]:4.96231479406E1,23[&rate=6.923052126733147E-4]:7.138331295584E1)[&rate=9.238997945944608E-4]:8.702108584006E-1)[&rate=5.179933556066841E-4]:2.596309983257E0,25[&rate=6.704141562730126E-4]:7.484983379749E1)[&rate=6.704141562730126E-4]:1.354016901687E0,((((((4[&rate=8.807521195303425E-4]:1.713959457185E0,2[&rate=7.153964039272457E-4]:1.713959457185E0)[&rate=4.997938623898211E-4]:6.11888131647E-1,3[&rate=5.451354016549759E-4]:2.325847588832E0)[&rate=7.802975093224094E-4]:1.033076655791E1,5[&rate=4.221106101323324E-4]:1.265661414674E1)[&rate=8.807521195303425E-4]:1.489706598586E0,(1[&rate=2.8172450740630985E-4]:8.93520912582E0,(6[&rate=8.614548667353845E-4]:8.241306195753E0,7[&rate=3.461185576535476E-4]:8.241306195753E0)[&rate=0.0010054800123234953]:6.939029300674E-1)[&rate=5.54207596802661E-4]:5.211111619505E0)[&rate=7.66310810286895E-4]:5.827324940911E1,(((30[&rate=6.923052126733147E-4]:4.839495889385E1,26[&rate=7.036856012933165E-4]:4.839495889385E1)[&rate=8.263454258946099E-4]:1.224710042492E1,32[&rate=3.878624151823843E-4]:6.064205931878E1)[&rate=4.997938623898211E-4]:1.035854103192E1,(16[&rate=3.998455141642531E-4]:3.071393986184E1,((22[&rate=7.802975093224094E-4]:2.805347582305E0,21[&rate=4.527084599049553E-4]:2.805347582305E0)[&rate=5.817119199353388E-4]:3.533728830489E0,20[&rate=4.8133111610875547E-4]:6.339076412794E0)[&rate=0.0016445428389015987]:2.437486344905E1)[&rate=6.099589931808033E-4]:4.028666048886E1)[&rate=9.238997945944608E-4]:1.418969803731E0)[&rate=2.8172450740630985E-4]:1.235834245285E0,12[&rate=6.004357197927499E-4]:7.365540439972E1)[&rate=3.998455141642531E-4]:2.548446299465E0)[&rate=6.704141562730126E-4]:2.709154082965E0,(17[&rate=5.910251415819451E-4]:6.951835005877E1,(27[&rate=4.624131643987955E-4]:2.054067739991E1,28[&rate=0.001126746594118679]:2.054067739991E1)[&rate=7.802975093224094E-4]:4.897767265886E1)[&rate=4.719429596590307E-4]:9.394654723377E0)[&rate=0.0016445428389015987]:4.454300250585E1);\ntree STATE_49 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55171.10859955921,EEF_ucld_branchRates=-266.168517335019,lnP=-55171.10859955921,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=7.029834648675939E-4]:7.905655787429E0,9[&rate=6.830034347410179E-4]:7.905655787429E0)[&rate=4.894024652467166E-4]:5.333153541292E0,15[&rate=7.700617141881774E-4]:1.323880932872E1)[&rate=4.98443806859593E-4]:1.148333612364E2,(14[&rate=0.001047178509430801]:5.240629374215E1,24[&rate=9.107716371658064E-4]:5.240629374215E1)[&rate=5.160967473291032E-4]:7.566587682296E1)[&rate=6.830034347410179E-4]:1.466708868384E0,((((12[&rate=8.392093211686843E-4]:7.208315250956E1,((16[&rate=3.7737471027482066E-4]:3.179710908811E1,((22[&rate=8.095502272361342E-4]:2.682901470203E0,21[&rate=3.9220735236556917E-4]:2.682901470203E0)[&rate=5.160967473291032E-4]:4.179640512749E0,20[&rate=7.133446570940516E-4]:6.862541982952E0)[&rate=0.0015280166764625157]:2.493456710515E1)[&rate=5.842400727239504E-4]:3.867717998625E1,(((((4[&rate=8.239867864456607E-4]:1.558016477962E0,3[&rate=7.579412723624248E-4]:1.558016477962E0)[&rate=7.029834648675939E-4]:3.879476835955E-1,2[&rate=6.453943547296622E-4]:1.945964161558E0)[&rate=6.638598917456294E-4]:7.706287495968E0,5[&rate=5.247613874691316E-4]:9.652251657526E0)[&rate=6.638598917456294E-4]:2.522055880065E0,(1[&rate=4.98443806859593E-4]:7.856398140655E0,(6[&rate=8.239867864456607E-4]:7.047980200952E0,7[&rate=6.274696496580309E-4]:7.047980200952E0)[&rate=4.801755006822578E-4]:8.084179397025E-1)[&rate=4.894024652467166E-4]:4.317909396936E0)[&rate=4.801755006822578E-4]:5.614864538838E1,((30[&rate=8.909118224003037E-4]:4.561295276316E1,26[&rate=5.418772213813261E-4]:4.561295276316E1)[&rate=6.099631318655953E-4]:1.583218037892E1,32[&rate=7.958025559422418E-4]:6.144513314209E1)[&rate=6.099631318655953E-4]:6.877819783885E0)[&rate=6.013309593292333E-4]:2.151336148378E0)[&rate=7.700617141881774E-4]:1.608863435207E0)[&rate=4.98443806859593E-4]:1.973775145427E0,25[&rate=7.349460570053993E-4]:7.405692765499E1)[&rate=3.1372423703276444E-4]:1.412619337305E0,(((19[&rate=5.073324629160769E-4]:1.281026057876E1,18[&rate=8.392093211686843E-4]:1.281026057876E1)[&rate=3.4024115481442064E-4]:5.756192304526E1,((33[&rate=7.133446570940516E-4]:6.353617458716E1,13[&rate=4.404943325623336E-4]:6.353617458716E1)[&rate=7.133446570940516E-4]:5.175737992168E0,(11[&rate=6.830034347410179E-4]:1.56527749122E1,29[&rate=4.6100085363266996E-4]:1.56527749122E1)[&rate=5.503661216561566E-4]:5.305913766712E1)[&rate=3.1372423703276444E-4]:1.66027104469E0)[&rate=0.0010883376640127263]:1.735517316768E0,((10[&rate=8.392093211686843E-4]:2.231393602638E1,31[&rate=8.553354139359847E-4]:2.231393602638E1)[&rate=3.4024115481442064E-4]:4.926372679982E1,23[&rate=4.295446499087731E-4]:7.15776628262E1)[&rate=4.056122600478204E-4]:5.300381145819E-1)[&rate=5.672893661131775E-4]:3.361846051509E0)[&rate=9.826218193015558E-4]:3.978638611129E0,(17[&rate=9.107716371658064E-4]:7.202688853209E1,(27[&rate=6.733375989165151E-4]:1.970942630571E1,28[&rate=0.0011393881823691721]:1.970942630571E1)[&rate=7.029834648675939E-4]:5.231746222638E1)[&rate=9.826218193015558E-4]:7.421297071327E0)[&rate=0.0015280166764625157]:5.009069383007E1);\ntree STATE_50 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55134.90850656344,EEF_ucld_branchRates=-266.168517335019,lnP=-55134.90850656344,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.803197525194792E-4]:7.670870139057E0,9[&rate=7.225436496226685E-4]:7.670870139057E0)[&rate=0.0010434913940446146]:5.478477828768E0,15[&rate=4.829879279472217E-4]:1.314934796783E1)[&rate=7.692137150934966E-4]:9.803945529613E1,(14[&rate=9.51540214662105E-4]:4.898917536697E1,24[&rate=8.587800724997733E-4]:4.898917536697E1)[&rate=0.0010165694538464165]:6.219962789698E1)[&rate=7.692137150934966E-4]:1.457589729998E1,(((((((16[&rate=4.705269031732208E-4]:2.774064334456E1,((22[&rate=7.050145087358959E-4]:1.817443728987E0,21[&rate=7.79196700607247E-4]:1.817443728987E0)[&rate=7.40649943286784E-4]:3.579559795952E0,20[&rate=9.711709714378167E-4]:5.397003524939E0)[&rate=0.001216010265835883]:2.234363981963E1)[&rate=0.0013050175282145714]:4.061507782896E1,12[&rate=8.861076594136634E-4]:6.835572117352E1)[&rate=8.338939846309957E-4]:2.722238846159E0,((30[&rate=8.861076594136634E-4]:5.256812213146E1,26[&rate=8.221932251845324E-4]:5.256812213146E1)[&rate=7.499636492089143E-4]:1.17880019859E1,32[&rate=4.946068869755539E-4]:6.435612411736E1)[&rate=5.540983298266575E-4]:6.721835902317E0)[&rate=4.0377189890762437E-4]:2.151275468481E0,((((4[&rate=5.449921830210305E-4]:1.839615974367E0,3[&rate=5.449921830210305E-4]:1.839615974367E0)[&rate=6.219374233425796E-4]:3.828148072719E-1,2[&rate=5.803197525194792E-4]:2.222430781639E0)[&rate=5.449921830210305E-4]:7.83989340964E0,5[&rate=5.62999757278043E-4]:1.006232419128E1)[&rate=8.221932251845324E-4]:3.156253650843E0,(1[&rate=3.762330876884519E-4]:1.021712266504E1,(6[&rate=6.879365981673345E-4]:9.238221259391E0,7[&rate=5.717305161710644E-4]:9.238221259391E0)[&rate=7.40649943286784E-4]:9.789014056505E-1)[&rate=7.692137150934966E-4]:3.00145517708E0)[&rate=7.692137150934966E-4]:6.001065764604E1)[&rate=3.762330876884519E-4]:1.783492006334E0,25[&rate=8.587800724997733E-4]:7.50127274945E1)[&rate=6.219374233425796E-4]:9.319574946797E-1,(((19[&rate=8.861076594136634E-4]:1.291473496051E1,18[&rate=0.0011111486997196938]:1.291473496051E1)[&rate=4.569594466623367E-4]:5.624169919146E1,((11[&rate=6.54686096646994E-4]:1.762161214085E1,29[&rate=8.460693815712207E-4]:1.762161214085E1)[&rate=7.225436496226685E-4]:5.021712536242E1,(33[&rate=7.315161536544858E-4]:6.3476950061E1,13[&rate=3.762330876884519E-4]:6.3476950061E1)[&rate=6.629188033807829E-4]:4.361787442272E0)[&rate=7.692137150934966E-4]:1.317696648697E0)[&rate=5.540983298266575E-4]:3.617847096466E0,((10[&rate=5.803197525194792E-4]:2.111026288911E1,31[&rate=8.338939846309957E-4]:2.111026288911E1)[&rate=4.705269031732208E-4]:5.051481645551E1,23[&rate=6.54686096646994E-4]:7.162507934462E1)[&rate=5.356408773676935E-4]:1.149201903813E0)[&rate=7.692137150934966E-4]:3.170403740744E0)[&rate=6.054773409114629E-4]:6.905940729011E0,(17[&rate=9.009134248605781E-4]:7.744448815072E1,(27[&rate=0.0010165694538464165]:2.181584424899E1,28[&rate=9.334504852317562E-4]:2.181584424899E1)[&rate=5.62999757278043E-4]:5.562864390173E1)[&rate=6.795309520526933E-4]:5.40613756747E0)[&rate=0.0014930302801874373]:4.291407484575E1);\nEnd;\n'
        if not check_individual_results(cm, t):
            res = False
        print("count parameters ", end = '')
        cm = "./pxlog -p TEST/run1.p TEST/run2.p -i"
        t = 'TEST/run1.p: 501 samples of 15 variables.\nTEST/run2.p: 501 samples of 15 variables.\nCounted 1002 total samples of 15 variables across 2 files.\n'
        if not check_individual_results(cm, t):
            res = False
        print("parameter log ", end = '')
        cm = "./pxlog -p TEST/run1.p TEST/run2.p -b 400 -n 10"
        t = 'Gen	LnL	LnPr	TL{all}	r(A<->C){all}	r(A<->G){all}	r(A<->T){all}	r(C<->G){all}	r(C<->T){all}	r(G<->T){all}	pi(A){all}	pi(C){all}	pi(G){all}	pi(T){all}	alpha{all}	pinvar{all}\n0	-2.562690e+04	-4.244089e+01	9.859853e+00	1.321215e-02	5.540706e-01	3.046823e-02	1.721216e-02	3.155399e-01	6.949704e-02	3.455151e-01	4.455032e-01	5.672251e-02	1.522591e-01	7.003904e-01	4.134683e-01\n1	-2.564363e+04	-3.385540e+01	8.861788e+00	1.597314e-02	5.405184e-01	3.572953e-02	1.538118e-02	3.098454e-01	8.255241e-02	3.383438e-01	4.445997e-01	6.011694e-02	1.569396e-01	7.525231e-01	4.174325e-01\n2	-2.564411e+04	-3.448828e+01	8.944435e+00	1.458647e-02	5.459096e-01	2.872731e-02	1.085169e-02	3.024874e-01	9.743752e-02	3.548307e-01	4.371532e-01	6.174098e-02	1.462752e-01	6.344983e-01	3.924460e-01\n3	-2.561863e+04	-3.780175e+01	9.315375e+00	1.358819e-02	5.484503e-01	2.921262e-02	1.526999e-02	3.124167e-01	8.106220e-02	3.516604e-01	4.366560e-01	6.137797e-02	1.503057e-01	6.601072e-01	3.928130e-01\n4	-2.562636e+04	-4.286557e+01	9.919687e+00	1.340228e-02	5.178548e-01	2.913669e-02	1.709175e-02	3.439590e-01	7.855543e-02	3.483430e-01	4.371204e-01	6.342031e-02	1.511163e-01	6.350827e-01	3.915076e-01\n5	-2.563020e+04	-2.769145e+01	8.224110e+00	1.577641e-02	5.576311e-01	3.089381e-02	9.919816e-03	3.176634e-01	6.811549e-02	3.528687e-01	4.393390e-01	6.275730e-02	1.450349e-01	6.266213e-01	4.008911e-01\n6	-2.561552e+04	-3.923375e+01	9.477967e+00	1.276876e-02	5.317353e-01	3.275137e-02	1.339039e-02	3.257596e-01	8.359464e-02	3.600337e-01	4.377344e-01	5.838327e-02	1.438486e-01	6.915539e-01	4.030057e-01\n7	-2.563452e+04	-3.925328e+01	9.485339e+00	1.164464e-02	5.139898e-01	3.236776e-02	1.466640e-02	3.338788e-01	9.345258e-02	3.563713e-01	4.399185e-01	5.766919e-02	1.460411e-01	6.481577e-01	4.187259e-01\n8	-2.562525e+04	-4.076892e+01	9.663887e+00	1.397800e-02	5.807593e-01	2.663268e-02	9.194246e-03	2.936051e-01	7.583059e-02	3.393248e-01	4.499280e-01	5.928337e-02	1.514639e-01	6.540484e-01	4.143338e-01\n9	-2.562177e+04	-3.821525e+01	9.362094e+00	1.134616e-02	5.635330e-01	3.136786e-02	1.478972e-02	2.936829e-01	8.528038e-02	3.391811e-01	4.535238e-01	6.084279e-02	1.464523e-01	6.687203e-01	4.171037e-01\n10	-2.563252e+04	-4.060590e+01	9.644269e+00	1.503387e-02	5.605209e-01	2.763069e-02	1.204396e-02	3.098828e-01	7.488771e-02	3.392548e-01	4.471247e-01	6.110044e-02	1.525201e-01	6.555609e-01	4.037897e-01\n11	-2.562664e+04	-4.213536e+01	9.833713e+00	1.232860e-02	5.395414e-01	3.024907e-02	1.121710e-02	3.268673e-01	7.979654e-02	3.408891e-01	4.480571e-01	5.879649e-02	1.522573e-01	6.098504e-01	4.188516e-01\n12	-2.563167e+04	-4.184690e+01	9.798107e+00	1.216011e-02	5.281554e-01	3.369355e-02	1.651959e-02	3.336440e-01	7.582734e-02	3.556323e-01	4.386915e-01	6.082072e-02	1.448555e-01	6.151424e-01	4.019154e-01\n13	-2.562311e+04	-3.511591e+01	9.011525e+00	1.420429e-02	5.225837e-01	3.129710e-02	1.897640e-02	3.393098e-01	7.362878e-02	3.610598e-01	4.292158e-01	6.198637e-02	1.477380e-01	6.576091e-01	4.184340e-01\n14	-2.562354e+04	-3.439340e+01	8.932346e+00	1.674036e-02	5.381113e-01	3.123254e-02	1.201223e-02	3.389401e-01	6.296347e-02	3.512489e-01	4.361070e-01	6.418764e-02	1.484565e-01	6.490354e-01	4.195533e-01\n15	-2.561774e+04	-4.104333e+01	9.693244e+00	1.356055e-02	5.555160e-01	3.013395e-02	1.497729e-02	3.087895e-01	7.702271e-02	3.417365e-01	4.459690e-01	6.307091e-02	1.492236e-01	6.828677e-01	4.044682e-01\n16	-2.561578e+04	-3.137908e+01	8.605127e+00	1.498821e-02	5.891174e-01	2.757067e-02	1.534648e-02	2.696136e-01	8.336370e-02	3.353194e-01	4.536863e-01	5.748396e-02	1.535103e-01	6.531047e-01	3.941014e-01\n17	-2.562464e+04	-3.780516e+01	9.306694e+00	1.253358e-02	5.801869e-01	2.503249e-02	1.866501e-02	2.952402e-01	6.834180e-02	3.418183e-01	4.492637e-01	5.784761e-02	1.510704e-01	7.389666e-01	4.123348e-01\n18	-2.562077e+04	-3.148056e+01	8.613531e+00	1.481873e-02	5.562068e-01	3.218332e-02	1.196085e-02	3.135224e-01	7.130797e-02	3.564275e-01	4.384962e-01	6.157918e-02	1.434971e-01	6.756563e-01	4.081317e-01\n19	-2.563194e+04	-3.882985e+01	9.430944e+00	1.473732e-02	5.618451e-01	3.124917e-02	1.722694e-02	3.139665e-01	6.097494e-02	3.486954e-01	4.429923e-01	5.866827e-02	1.496441e-01	6.902596e-01	4.020177e-01\n20	-2.562446e+04	-3.593565e+01	9.100935e+00	1.372513e-02	5.302188e-01	3.147862e-02	1.543002e-02	3.287349e-01	8.041257e-02	3.494219e-01	4.383438e-01	5.861659e-02	1.536177e-01	6.785744e-01	4.075729e-01\n21	-2.561437e+04	-3.343121e+01	8.819019e+00	1.364716e-02	5.058547e-01	3.713427e-02	1.752883e-02	3.592584e-01	6.657668e-02	3.573228e-01	4.355069e-01	6.246680e-02	1.447035e-01	7.196523e-01	4.225202e-01\n'
        if not check_individual_results(cm, t):
            res = False
        print("summarize parameters ", end = '')
        cm = "./pxlog -s -p TEST/run1.p TEST/run2.p -b 400 -n 10"
        # expected results exclude leading spaces as these are apparently by p.communicate()
        t = 'Mean       Median     Variance          ESS          ACT            N \nLnL               -25626.1     -25624.6      62.5741      20.2263       10.877           22\nLnPr              -37.3008     -37.8052      16.3973           22           10           22\nTL{all}            9.26836      9.36209     0.210032           22           10           22\nr(A<->C){all}    0.0138525    0.0137251  1.89553e-06           22           10           22\nr(A<->G){all}     0.546469      0.54845  0.000467429      15.1785      14.4942           22\nr(A<->T){all}    0.0307352    0.0312325   7.4479e-06           22           10           22\nr(C<->G){all}    0.0145305      0.01527   7.6606e-06           22           10           22\nr(C<->T){all}     0.317573      0.31554  0.000390585      14.8186      14.8462           22\nr(G<->T){all}    0.0768401    0.0770227  7.87827e-05      9.48203      23.2018           22\npi(A){all}        0.348423     0.349422  5.96536e-05      18.4677      11.9127           22\npi(C){all}        0.442042     0.439918  3.93657e-05       12.225      17.9959           22\npi(G){all}       0.0604063    0.0608428  4.45906e-06           22           10           22\npi(T){all}        0.149129     0.149644  1.30774e-05           22           10           22\nalpha{all}         0.66809     0.660107   0.00131491      11.9136      18.4663           22\npinvar{all}       0.407974     0.408132  9.37755e-05      14.7018      14.9641           22\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxlssq":
        res = True
        print("default ", end = '')
        cm = "./pxlssq -s TEST/test.fa"
        t = 'File type: fasta\nNumber of sequences: 5\nIs aligned: true\nSequence length: 20\n--------- Nucl TABLE ----------\nNucl        Total   Proportion\n   A           20          0.2\n   C           37         0.37\n   G           18         0.18\n   T           25         0.25\n   -            0            0\n   ?            0            0\n G+C           55         0.55\n--------- Nucl TABLE ----------\n'
        if not check_individual_results(cm, t):
            res = False
        print("labels ", end = '')
        cm = "./pxlssq -s TEST/test.fa -l"
        t = 'TaxonA\nTaxonB\nTaxonC\nTaxonD\nTaxonE\n'
        if not check_individual_results(cm, t):
            res = False
        print("frequencies ", end = '')
        cm = "./pxlssq -s TEST/test.fa -f"
        # expected results exclude leading spaces as these are apparently by p.communicate()
        t = 'A            C            G            T            -            ?\n          20           37           18           25            0            0\n    0.200000     0.370000     0.180000     0.250000     0.000000     0.000000\n'
        if not check_individual_results(cm, t):
            res = False
        print("indidivual stats ", end = '')
        cm = "./pxlssq -s TEST/test.fa -i"
        t = 'taxon             A            C            G            T            -            ?        Nchar\nTaxonA         0.25          0.3         0.05          0.4            0            0           20\nTaxonB          0.2          0.4         0.35         0.05            0            0           20\nTaxonC         0.35         0.35          0.1          0.2            0            0           20\nTaxonD          0.1          0.3         0.25         0.35            0            0           20\nTaxonE          0.1          0.5         0.15         0.25            0            0           20\n'
        if not check_individual_results(cm, t):
            res = False
        print("binary data ", end = '')
        cm = "./pxlssq -s TEST/Binary_5tax.fa"
        t = 'File type: fasta\nNumber of sequences: 5\nIs aligned: true\nSequence length: 250\n--------- Binary TABLE ----------\nBinary        Total   Proportion\n   0          622       0.4976\n   1          628       0.5024\n   -            0            0\n   ?            0            0\n--------- Binary TABLE ----------\n'
        if not check_individual_results(cm, t):
            res = False
        print("morph data ", end = '')
        cm = "./pxlssq -s TEST/morph_data/morph.phy"
        t = 'File type: phylip\nNumber of sequences: 64\nIs aligned: true\nSequence length: 437\n--------- Multi TABLE ----------\nMulti        Total   Proportion\n   0        12369     0.442255\n   1         3471     0.124106\n   2          697    0.0249213\n   3           61   0.00218106\n   4            8  0.000286041\n   5            4  0.000143021\n   6            5  0.000178776\n   -            0            0\n   ?        11353     0.405928\n--------- Multi TABLE ----------\n'
        if not check_individual_results(cm, t):
            res = False
        print("fastq ", end = '')
        cm = "./pxlssq -s TEST/test.fastq"
        t = 'File type: fastq\nNumber of sequences: 1000\nIs aligned: true\nSequence length: 101\n--------- Nucl TABLE ----------\nNucl        Total   Proportion\n   A        27855     0.275792\n   C        24983     0.247356\n   G        21584     0.213703\n   T        26351     0.260901\n   -            0            0\n   ?          227   0.00224752\n G+C        46567     0.461059\n--------- Nucl TABLE ----------\n'
        if not check_individual_results(cm, t):
            res = False
        print("unaliagned ", end = '')
        cm = "./pxlssq -s TEST/unaligned.fa -a"
        t = 'false\n'
        if not check_individual_results(cm, t):
            res = False
        print("individual missing ", end = '')
        cm = "./pxlssq -s TEST/morph_data/morph.phy -m -i"
        t = 'Nchar      Missing   Proportion\nErythrosuchus               437           65     0.148741\nEuparkeria                  437           32    0.0732265\nPROTEROCHAMPSIDAE           437           57     0.130435\nScleromochlus               437          140     0.320366\nEudimorphodon               437          129     0.295195\nPeteinosaurus               437          271     0.620137\nPreondactylus               437          212     0.485126\nAustriadactylus             437          268     0.613272\nLagerpeton                  437          296     0.677346\nDromomeron                  437          367     0.839817\nMarasuchus                  437          220     0.503432\nPseudolagosuchus            437          359      0.82151\nSilesaurus                  437          123     0.281465\nSacisaurus                  437          294     0.672769\nEucoelophysis               437          379     0.867277\nLewisuchus                  437          282     0.645309\nEoraptor                    437          134     0.306636\nHerrerasaurus               437           22    0.0503432\nCoelophysis                 437           26    0.0594966\nLiliensternus               437          207     0.473684\nZupaysaurus                 437          246     0.562929\nPlateosaurus                437           10    0.0228833\nPantydraco                  437          147     0.336384\nAntetonitrus                437          334     0.764302\nEocursor                    437          305     0.697941\nHeterodontosaurus           437           74     0.169336\nPisanosaurus                437          339     0.775744\nPaleorhinus                 437           32    0.0732265\nRutiodon                    437           82     0.187643\nMystriosuchus               437           93     0.212815\nPseudopalatus               437          122     0.279176\nAetosaurus                  437          106     0.242563\nStagonolepis                437           24    0.0549199\nDesmatosuchus               437           46     0.105263\nLongosuchus                 437          103     0.235698\nOrnithosuchus               437           67     0.153318\nRiojasuchus                 437           76     0.173913\nDromicosuchus               437          167     0.382151\nHesperosuchus               437          154     0.352403\nPseudhesperosuchus          437          182     0.416476\nTerrestrisuchus             437           67     0.153318\nErpetosuchus                437          194     0.443936\nGracilisuchus               437           94     0.215103\nQianosuchus                 437          173     0.395881\nRevuletosaurus              437          218     0.498856\nArizonasaurus               437          150     0.343249\nArganasuchus                437          346     0.791762\nBatrachotomus               437           83     0.189931\nBromsgroveia                437          392     0.897025\nEffigia                     437           60       0.1373\nFasolasuchus                437          265     0.606407\nLotosaurus                  437          116     0.265446\nPoposaurus                  437          284     0.649886\nPostosuchus                 437           37    0.0846682\nPrestosuchus                437          119     0.272311\nRauisuchus                  437          239     0.546911\nSaurosuchus                 437          110     0.251716\nShuvosaurus                 437           66      0.15103\nSillosaurus                 437          368     0.842105\nStagonosuchus               437          350     0.800915\nTeratosaurus                437          232     0.530892\nTicinosuchus                437          209     0.478261\nTikisuchus                  437          320     0.732265\nYarasuchus                  437          269     0.615561\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxlstr":
        res = True
        print("newick ", end = '')
        cm = "./pxlstr -t TEST/test.tre"
        t = 'tree #: 0\nrooted: true\nbinary: true\nnterminal: 5\nninternal: 4\nbranch lengths: true\nrttipvar: 0.004634\ntreelength: 1.595\nultrametric: false\nrootheight: NA\n'
        if not check_individual_results(cm, t):
            res = False
        print("nexus (mulitple) ", end = '')
        cm = "./pxlstr -t TEST/ultra_100_nexus.tre"
        t = 'tree #: 0\nrooted: true\nbinary: true\nnterminal: 10\nninternal: 9\nbranch lengths: true\nrttipvar: 7.504e-21\ntreelength: 8.67581\nultrametric: true\nrootheight: 1.74148\ntree #: 1\nrooted: true\nbinary: true\nnterminal: 10\nninternal: 9\nbranch lengths: true\nrttipvar: 2.08278\ntreelength: 8.67581\nultrametric: false\nrootheight: NA\n'
        if not check_individual_results(cm, t):
            res = False
        print("figtree ", end = '')
        cm = "./pxlstr -t TEST/figtree.tre"
        t = 'tree #: 0\nrooted: false\nbinary: false\nnterminal: 78\nninternal: 78\nbranch lengths: true\nrttipvar: NA\ntreelength: 5019.1\nultrametric: false\nrootheight: NA\n'
        if not check_individual_results(cm, t):
            res = False
        print("polytomy ", end = '')
        cm = "./pxlstr -t TEST/binary_test.tre -b"
        t = 'false\ntrue\n'
        if not check_individual_results(cm, t):
            res = False
        print("internal linebreak ", end = '')
        cm = "./pxlstr -t TEST/linebreak.tre"
        t = 'tree #: 0\nrooted: true\nbinary: true\nnterminal: 29\nninternal: 28\nbranch lengths: true\nrttipvar: 8.9928e-07\ntreelength: 0.13572\nultrametric: false\nrootheight: NA\n'
        if not check_individual_results(cm, t):
            res = False
        print("terminal labels ", end = '')
        cm = "./pxlstr -t TEST/binary_test.tre -i"
        t = 'TaxonX\nTaxonC\nTaxonA1\nTaxonA2\nTaxonA3\nTaxonB\nTaxonW\nTaxonD\nTaxonE\nTaxonX\nTaxonW\nTaxonD\nTaxonE\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxmono":
        cm = "./pxmono -t TEST/yule_10taxa.trees -n taxon_1,taxon_2,taxon_3,taxon_4"
        t = 'true\nfalse\nfalse\nfalse\ntrue\nfalse\ntrue\nfalse\ntrue\nfalse\n'
    elif name == "pxmrca":
        cm = "./pxmrca -t TEST/mrca_test.tre -m TEST/mrca.txt"
        t = 'KIM 50 \nLEE 11 \nTHURSTON 2 \n'
    elif name == "pxmrcacut":
        cm = "./pxmrcacut -t TEST/mrca_test.tre -m TEST/mrca.txt"
        t = '((((s19:8.9192294969999999,s21:8.9192294939999996):19.9522496099999991,(((s28:1.9460922439999999,(s29:1.0875761909999999,(s30:0.892917128,s31:0.892917128):0.1946590628):0.8585160526):8.3971209000000009,s32:10.3432131500000004):11.0954325699999998,((s33:7.2263048049999998,((s34:2.6703496819999999,s35:2.6703496819999999):2.2229339779999999,s36:4.8932836599999998):2.333021145):7.1928712350000001,((s38:0.6421928454,s39:0.6421928454):0.0263742241,s40:0.6685670695):13.75060897):7.0194696820000004):7.4328333889999998):9.4218491340000003,(((s46:12.2010411199999993,s49:12.2010411199999993):6.6047551540000002,(s51:5.4152383840000002,s52:5.4152383840000002):13.3905578900000002):7.9737073949999999,s56:26.7795036700000004):11.5138245799999996):38.8094614199999981,(((((s87:3.6908438889999999,s88:3.6908438889999999):11.4507337099999997,(((s90:4.7201172930000004,(s91:3.9975684220000001,s92:3.9975684220000001):0.722548871):1.5459479199999999,(s93:2.1981845510000002,s94:2.1981845510000002):4.0678806630000004):0.4042469457,s95:6.6703121569999997):8.4712654399999998):12.3930690600000002,((s98:5.0744154459999997,s100:5.0744154459999997):14.9727031700000008,s104:20.0471186199999991):7.4875280369999997):20.7336537000000014,s126:48.268300349999997):16.5419383899999985,((((s133:19.1945240800000008,(s135:5.4586278740000003,(s136:0.5006869268,s137:0.5006869268):4.9579409449999998):13.7358962099999999):8.3350646560000001,s140:27.5295887400000012):2.2861742469999999,((s151:16.8626535299999993,((s153:3.9294314930000001,s154:3.9294314930000001):0.5895208589000001,(s155:4.4774633660000003,(s156:2.7123332000000002,s157:2.7123332000000002):1.7651301660000001):0.04148898642):12.3437011699999992):11.4377336100000004,s162:28.3003871400000016):1.515375849):2.6277221590000002,((s169:7.8409351410000001,s170:7.8409351410000001):7.5946375750000001,(s172:13.3298600599999997,(s173:6.7214149780000003,((s174:0.3080707103,s175:0.3080707103):4.1074336630000001,s177:4.4155043730000001):2.3059106030000001):6.6084450869999998):2.1057126570000002):17.0079124300000011):32.3667536000000027):12.29255092);\n((((((s283:0.4995078195,s284:0.4995078195):2.3766585789999999,s285:2.8761663990000002):13.2757500999999998,s286:16.1519164900000014):14.5552332300000007,(s288:9.1306009830000008,(s289:5.3395037639999998,s290:5.3395037639999998):3.791097218):21.5765487399999998):2.4713881350000002,((s292:0.1094902985,s293:0.1094902985):21.110084839999999,s296:21.2195751399999999):11.9589627200000006):12.9721000100000001,s307:46.1506378699999971);\n(s19:8.9192294969999999,s21:8.9192294939999996);\n'
    elif name == "pxmrcaname":
        cm = "./pxmrcaname -t TEST/mrca_test.tre -m TEST/mrca.txt"
        t = '(((((s19:8.9192294969999999,s21:8.9192294939999996)THURSTON:19.9522496099999991,(((s28:1.9460922439999999,(s29:1.0875761909999999,(s30:0.892917128,s31:0.892917128):0.1946590628):0.8585160526):8.3971209000000009,s32:10.3432131500000004):11.0954325699999998,((s33:7.2263048049999998,((s34:2.6703496819999999,s35:2.6703496819999999):2.2229339779999999,s36:4.8932836599999998):2.333021145):7.1928712350000001,((s38:0.6421928454,s39:0.6421928454):0.0263742241,s40:0.6685670695):13.75060897):7.0194696820000004):7.4328333889999998):9.4218491340000003,(((s46:12.2010411199999993,s49:12.2010411199999993):6.6047551540000002,(s51:5.4152383840000002,s52:5.4152383840000002):13.3905578900000002):7.9737073949999999,s56:26.7795036700000004):11.5138245799999996):38.8094614199999981,(((((s87:3.6908438889999999,s88:3.6908438889999999):11.4507337099999997,(((s90:4.7201172930000004,(s91:3.9975684220000001,s92:3.9975684220000001):0.722548871):1.5459479199999999,(s93:2.1981845510000002,s94:2.1981845510000002):4.0678806630000004):0.4042469457,s95:6.6703121569999997):8.4712654399999998):12.3930690600000002,((s98:5.0744154459999997,s100:5.0744154459999997):14.9727031700000008,s104:20.0471186199999991):7.4875280369999997):20.7336537000000014,s126:48.268300349999997):16.5419383899999985,((((s133:19.1945240800000008,(s135:5.4586278740000003,(s136:0.5006869268,s137:0.5006869268):4.9579409449999998):13.7358962099999999):8.3350646560000001,s140:27.5295887400000012):2.2861742469999999,((s151:16.8626535299999993,((s153:3.9294314930000001,s154:3.9294314930000001):0.5895208589000001,(s155:4.4774633660000003,(s156:2.7123332000000002,s157:2.7123332000000002):1.7651301660000001):0.04148898642):12.3437011699999992):11.4377336100000004,s162:28.3003871400000016):1.515375849):2.6277221590000002,((s169:7.8409351410000001,s170:7.8409351410000001):7.5946375750000001,(s172:13.3298600599999997,(s173:6.7214149780000003,((s174:0.3080707103,s175:0.3080707103):4.1074336630000001,s177:4.4155043730000001):2.3059106030000001):6.6084450869999998):2.1057126570000002):17.0079124300000011):32.3667536000000027):12.29255092)KIM:22.8972103300000001,((((((((s213:0.2029741842,s214:0.2029741842):12.7161028100000006,((s216:5.6164296230000001,(s218:3.7133940970000001,s219:3.7133940970000001):1.9030355269999999):3.1149687089999998,(s221:4.9410893590000002,s222:4.9410893610000004):3.7903089730000001):4.1876786619999997):2.7811719639999999,s224:15.7002489599999997):8.1136411430000006,(s228:16.4039877199999999,s229:16.4039877199999999):7.4099023769999999):20.1939318900000018,(((s235:1.164761961,s237:1.164761961):30.9289779899999999,(((s239:11.8092034100000003,(s240:1.1451934539999999,s241:1.1451934539999999):10.6640099599999996):6.4760607239999999,(s243:5.3663286640000001,s244:5.3663286640000001):12.91893548):0.5879546054,((s246:1.021385454,s247:1.021385454):2.2789929720000002,s248:3.3003784249999999):15.5728403199999992):13.2205212099999994):1.9422983140000001,((((s252:0.8909838051,s253:0.8909838051):1.4460778729999999,(s254:0.5364767172,s255:0.5364767172):1.800584961):0.5351456596,s256:2.8722073379999999):1.872321111,s257:4.7445284489999997):29.2915098100000009):9.9717837229999997):17.8392979599999997,(s266:27.9293939900000012,(s268:4.2347317469999997,s269:4.2347317469999997):23.6946622399999995):33.9177259599999985):17.5285275700000014,(((((((s283:0.4995078195,s284:0.4995078195):2.3766585789999999,s285:2.8761663990000002):13.2757500999999998,s286:16.1519164900000014):14.5552332300000007,(s288:9.1306009830000008,(s289:5.3395037639999998,s290:5.3395037639999998):3.791097218):21.5765487399999998):2.4713881350000002,((s292:0.1094902985,s293:0.1094902985):21.110084839999999,s296:21.2195751399999999):11.9589627200000006):12.9721000100000001,s307:46.1506378699999971)LEE:9.3515165059999994,(s325:1.575825061,s326:1.575825061):53.9263293200000007):23.8734931400000008):10.7713989100000003,(((s340:9.9405505230000006,s341:9.9405505230000006):21.0295773699999984,((s345:9.0691226749999991,s347:9.0691226769999993):1.9682665619999999,(s348:7.1978738189999998,s350:7.1978738189999998):3.839515418):19.9327386599999983):45.3301916799999987,(s381:4.5261479199999997,s382:4.5261479199999997):71.7741716599999933):13.8467268499999996):9.8529535619999997);\n' 
    elif name == "pxnj":
        cm = "./pxnj -s TEST/test.fa"
        t = '((((TaxonA:0.300000,TaxonC:0.300000):0.112500,TaxonB:0.437500):0.087500,TaxonD:0.250000):0.100000,TaxonE:0.100000);\n'
    elif name == "pxnw":
        cm = "./pxnw -s TEST/test.fa | grep TaxonA | grep TaxonB"
        t = 'TaxonA\tTaxonB\t40\n'
    elif name == "pxpoly":
        cm = "./pxpoly -t TEST/polytomy.tre -x 39"
        t = '((TaxonX:0.13,TaxonW:0.36)0.99:0.39,(TaxonD:0.23,TaxonE:0.16)0.94:0.3);\n'
    elif name == "pxrecode":
        res = True
        print("RY-coding ", end = '')
        cm = "./pxrecode -s TEST/test.fa -r RY"
        t = '>TaxonA\nRRRYYYYYYYRYYYYYYYRR\n>TaxonB\nRYYYRRRRRRYYYYRRRRYY\n>TaxonC\nRYRYYYYYYYYYRRRRRYRR\n>TaxonD\nYYYYYRYYYRRYYYYRRYRR\n>TaxonE\nYYRYYRYYYYYYYYYRYYRR\n'
        if not check_individual_results(cm, t):
            res = False
        print("MK-coding ", end = '')
        cm = "./pxrecode -s TEST/test.fa -r MK"
        t = '>TaxonA\nMMMKKKMMMKKKMMMKKKMM\n>TaxonB\nKMKMKMKKKKMMMMMMKMMM\n>TaxonC\nMMKMKMMMMMKKMMMMMKKM\n>TaxonD\nKMMKKKKKMMMMKMMKKKKK\n>TaxonE\nKKMMKMKKMMMMMMMKMMKK\n'
        if not check_individual_results(cm, t):
            res = False
        print("SW-coding ", end = '')
        cm = "./pxrecode -s TEST/test.fa -r SW"
        t = '>TaxonA\nWWWWWWSSSWSWSSSWWWWW\n>TaxonB\nSSWSSWSSSSSSSSWWSWSS\n>TaxonC\nWSSSWSSSSSWWWWWWWWSW\n>TaxonD\nWSSWWSWWSWWSWSSSSWSS\n>TaxonE\nWWWSWWWWSSSSSSSSSSSS\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxrevcomp":
        cm = "./pxrevcomp -s TEST/test.fa"
        t = '>TaxonA\nTTAAAGGGACAGGGAAATTT\n>TaxonB\nGGTCTTGGGGCCCCTCGAGC\n>TaxonC\nTCATTTTTAAGGGGGAGCGT\n>TaxonD\nCCACCGGAGTTGAACAAGGA\n>TaxonE\nCCGGCGGGGGGGAATAGTAA\n'
    elif name == "pxrls":
        res = True
        print("name files ", end = '')
        cm = "./pxrls -s TEST/test.fa -c TEST/oldnames.txt -n TEST/newnames.txt"
        t = '>Cinclus_mexicanus\nAAATTTCCCTGTCCCTTTAA\n>Anodorhynchus_hyacinthinus\nGCTCGAGGGGCCCCAAGACC\n>Stellula_calliope\nACGCTCCCCCTTAAAAATGA\n>Anser_anser\nTCCTTGTTCAACTCCGGTGG\n>Gallus_gallus\nTTACTATTCCCCCCCGCCGG\n'
        if not check_individual_results(cm, t):
            res = False
        print("regex ", end = '')
        cm = "./pxrls -s TEST/test.fa -p Taxon -r species_"
        t = '>species_A\nAAATTTCCCTGTCCCTTTAA\n>species_B\nGCTCGAGGGGCCCCAAGACC\n>species_C\nACGCTCCCCCTTAAAAATGA\n>species_D\nTCCTTGTTCAACTCCGGTGG\n>species_E\nTTACTATTCCCCCCCGCCGG\n'
        if not check_individual_results(cm, t):
            res = False
        return res
    elif name == "pxrlt":
        res = True
        print("name files ", end = '')
        cm = "./pxrlt -t TEST/kingdoms.tre -c TEST/kingdoms.oldnames.txt -n TEST/kingdoms.newnames.txt"
        t = '(Eubacteria:4200,(Archaea:3806.0102499999998145,((((SAR:1626.0427319999998872,Plant:1626.0276670000000649):72.3801839999999999,Excavata:1698.4229159999999865):74.7312199999999933,Amoebozoa:1773.1541360000001077):7.9375349999999996,(Animal:1295.717544000000089,Fungi:1295.7033610000000863):485.3800600000000145):2024.9200000000000728):394);\n'
        if not check_individual_results(cm, t):
            res = False
        print("regex ", end = '')
        cm = "./pxrlt -t TEST/test.tre -p Taxon -r species_"
        t = '(((species_A:0.1,species_B:0.03):0.125,species_C:0.25):0.4,(species_D:0.23,species_E:0.16):0.3);\n'
        if not check_individual_results(cm, t):
            res = False
        return res
    elif name == "pxrmk":
        cm = "./pxrmk -t TEST/knuckle_tree.tre"
        t = '(((((s4:0.1190332191,s5:0.1190332191)C:0.02544171746,s6:0.1444749366)D:0.7647640019,s7:0.9092389385)E:0.76874935,(s3:1.2572336289999999,(s1:0.3603553431,s2:0.3603553431)A:1.1968782862)B:0.5207546592)F:0.06349158892,((s8:0.3106889265,s9:0.3106889265)G:0.1031508249,s10:0.4138397514)H:1.3276401259999999);\n'
    elif name == "pxrms":
        res = True
        print("command line arg ", end = '')
        cm = "./pxrms -s TEST/test.fa -n TaxonA"
        t = '>TaxonB\nGCTCGAGGGGCCCCAAGACC\n>TaxonC\nACGCTCCCCCTTAAAAATGA\n>TaxonD\nTCCTTGTTCAACTCCGGTGG\n>TaxonE\nTTACTATTCCCCCCCGCCGG\n'
        if not check_individual_results(cm, t):
            res = False
        print("regex ", end = '')
        cm = "./pxrms -s TEST/test.fa -r .*A"
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxrmt":
        res = True
        print("command line arg ", end = '')
        cm = "./pxrmt -t TEST/test.tre -n TaxonA"
        t = '((TaxonC:0.25,TaxonB:0.155):0.4,(TaxonD:0.23,TaxonE:0.16):0.3);\n'
        if not check_individual_results(cm, t):
            res = False
        print("regex ", end = '')
        cm = "./pxrmt -t TEST/test.tre -r .*A"
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxrr":
        cm = "./pxrr -t TEST/test.tre -g TaxonA"
        t = '(TaxonA:0.05,(TaxonB:0.03,((TaxonD:0.23,TaxonE:0.16):0.7,TaxonC:0.25):0.125):0.05);\n'
    elif name == "pxs2fa":
        res = True
        print("nexus ", end = '')
        cm = "./pxs2fa -s TEST/Concat_Sequence2.NEX"
        t = '>Sequence1\nAAATTTCCCTTTCCCTTTAAA\n>Sequence2\nGGGGGGGGGGCCCCCCCCCCA\n>Sequence3\nCCCCCCCCCCCCAAAAAAAAA\n>Sequence9\nAAATTTCCCTTTCCCTTTAAA\n>Sequence10\nGGGGGGGGGGCCCCCCCCCCA\n>Sequence11\nCCCCCCCCCCCCAAAAAAAAA\n>Sequence8\nTTTTTTTTCCCCCCCGGGGGA\n'
        if not check_individual_results(cm, t):
            res = False
        print("interleaved nexus ", end = '')
        cm = "./pxs2fa -s TEST/AA_interleave.NEX"
        t = '>TaxonE\nAWWYHNTLNCRGWGEFRYLTHEFCCHWGNAFYHICHNYDNGPTTERFLTIQTWTARDRWCCKHSVHWNFQENFSTYGLKQRFQNQHSCNRHIVRQLWNNLRFFICICQIKRGKGNKCQFCILHYFIHLPSLACRLSYAFGYLRHNWFGTLTPYGFASPPNWYMRSEPSFGNSWNMAIQIANAFRTWKYRECGYSIKQSCDSTLMWPHRYWMIAQYTFQVTDSRTYDFITSSLVVYAFLCDAQARADCIDQ\n>TaxonD\nHWPYHNEWNQRGWGVFRYLTHEFMCHQHRLFYHICHNYDHGPTTERFKAITTWTAQDRWKSGHSVHGDFQENFCTYGMKMRFQNQHSCNRHIGRRLQNNLRFNYCYCQIKRYKGNKCQFVQLKVDIHDKSLAANLIAASMYLRHMWFGPLTPYGFAVPPNWMMVSGPSFGKSWHMQIQIRNAYVTWKYRGKGYSICQSPQNKLMWPNRYWMIEIYTFIVTDIRTALFIQISLSEYAFSCDFIPRQDMNWQ\n>TaxonC\nQVFYATEVNFRDIGSEGFLTCEFLDHFDAHEEKLLHNYVEKPWIEEPLWWRTRKRDDMYFSYHWDFLDFQENFDMHAYSMVMPQQHSYRFGEYRQVVNNLYYFNAGPMGHRQKMNNKQGCRMHYFIAYAQAQFNSGYHAEYLKMLSTGGLDLSGESSDPNWAKMSGESEGWSHWVAMLMRNYYRHGKSHGCKMFKHAYESEKLRCIGISSSGDQYCFTVRDSSGYRFDACVLECKTSLAACGHNANCGWP\n>TaxonB\nQVFYHNEVNCRWINEKGILTHEPLDHFDAHNQHILANNVETPVIYRPLWWRTRKAMDRWFYKTSVHWDFQERFDTHGYSMVAPQQQSCNRAEYRQVVNNLRRFIQPQDGHGRKMNVKQGCRMHYFIARASLEFNSGYHAEYLKQLWLGGLDFSGEKSMLNWAKMSGESEGWSHWVYMLMRNYYRHGKLHGCSHRKEALESEKLRCIGIMRWWKQYAFKVRDISGYRFDRCYLICKTLLYDDGCKANCNWP\n>TaxonA\nQVFTHNEVNCRWHIEKGILTHEPLDHFDAHNHHILANNVETPVIYRPLWWRTRKAMDMWFLKSSMHWDFQENFDTMAYSMHAPQQQSKHSAHYRQQVNNLRRFIQPQMGHGRKMNNKQGCRMHYFIAYASLQFNSLYHAEMLKQLWTGGLDFSGEKSMPNWAKMSGESEGWSHWVLMLMRNYYRHGKLHGCSHRKEILESEKLRRIGIMRWWKQYAFKVRDISGYRFDRGYFGCKTLLNDAGCKVNCNWP\n'
        if not check_individual_results(cm, t):
            res = False
        print("phylip ", end = '')
        cm = "./pxs2fa -s TEST/morph_data/morph.phy"
        t = '>Erythrosuchus\n0001000000000210010101000000100000000100010000?00000000000000?00?000?0010010000000000010000?001??00000??0011?000002000000000000000000000?000?00??000000?00?00001?000001000000000000?010000?0000010000?00000000?000010000001?00000000???100000000000000000000000000000000001100???010000???????0?0000?00000?00200000??0000000000000000000111111111112?00?000000?10??000000???01000?0?0000?0000?00?0000?100000?0?0????00000000?01??10??0101001000000000\n>Euparkeria\n000001001000021000000100000110010000000000000000000000000000000000000000?01000000000100000000000000000000000?0000020000000000000000000?0?0000001000000?000??00000000000000000000000000000000001000000?0000000??0000100000?0?000000000011000000000000000000000000030000001003000?001000101231120100001000000?000010022000000000001000?000211111111112?00?0000001000?000000??001000?0??00000000000?0000?1000000000???000000100?000010??0000001?00000000\n>PROTEROCHAMPSIDAE\n1000000000000001000000100000000000020000000000000010000000100???0?????00000000000000000000000001000000000000?0000020000000000000000000?0????000000?000??00?00000000000000000000?000000100000001000000?00?00000?00000000000000?111000001100000010000000000000000203000000?0?0001??01000001231120100001000000002??00?22000000000001?000000011111111112????0000001001?000000???01000?0??0000000?0?000000?1000000000????10000000?????10??00?0001001000000\n>Scleromochlus\n101012?0100000?00000110000001??00000?0??01000???00?2???????????1??????01????0000??00???2??00??02210000110000?00000200100001???00010000?0?????00?1??100??01?0000??0?00?0?0?????1?011101110000000??0000?0000?000?000000000000000?00?00000000000000000000000?10?00??????????????00??010001?0000000000000000000?0???00?0000000000000??00?000?11111?1111100??0?00?00000?000?00???00000?0??000??0?0?0100001?0000000?????0?10000??0?00??10??????001?01?00000\n>Eudimorphodon\n10001000100000010010?00000?0?0000?0?????00000???0??0??????????????????01????01000??0000200000??222000011000120110021010000000000000000?0????0??010?10100?0?2010???0???????12221?011?01??00011111?111111111111111111210111111?1000000??0100?000100000000??????00??????????????0???010000?000000000000000000??0???000000000??0000?0?01?00021111111311210010000?001??0?00?01?100010??0?0000??000?110000??00000?????021000000??01000000??00?0000?0102?000\n>Peteinosaurus\n???????????????????????????????????????????????????????????????????????????????????00??10000???22200001100012???0???01??00???00?00000??????????????10?0?00?201????0???????12221?01110101000??????1111?1?111111111112???11111?0????????0????0??????????????????????????????????????1?000?00000000000000000????????0000?????????????0??00???111?11?11?10010?00?001?0000?????1000??????00000?0?0?110?00?????????????210000????0100000???????000?0??????0\n>Preondactylus\n10?0?0????0000?11010???000?0????00????????????????????????????????????00????0100???00?????00???22200001100012???0???????00???00?00??0??????????????1?????0?201???????????????????11101110001111??1111?1111111111?11?110??110?0?00?00??0100?00010000000???????00??????????????0???01000??000000000000000000???????0000?000??0000???0100002111111131121001??00?001?00?00??1?10?010??0?0?0?0?0?0?110?00???00????????2100000???01000000??0??0000?0102??00\n>Austriadactylus\n1000?0?01?0001?11010???000?0?00?0??????????00?000000??????????????????????????????????????00???222000011000?2????????????????????????????????????????????????????????????????????11????????111111111?11?10??????????10?11??????00?00??0100?000100000000??????00??10??????????0???01?00??000000000000000000???????0000?000??000????01?00011111111?1121001??????0?????00?0??1???10??0???????????0???0????00000?????2?????0?0???????????0??0000?01???00?\n>Lagerpeton\n???????????????????????????????????????????????????????????????????????????????????00??0????01122????????????00100200000010001010110010001?1000001?10?0101020200?110?1011212221011101011110???????0????????????00000??????????????????????????????????????????????????????????????????0?00000000000000000??????????00???????????????????????????????????0000001001100???????10???????0000????????0?0???????????0????000??????????0000????0???0??20??0\n>Dromomeron\n??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????10010001?0000011111??1010??20??1100101021222????????????????????0??????????????00?????????????????????????????????????????????????????????????????????00000000000000000??????????00????????????????????????????????????????0000???????????1??????????0?????????0?0?????????????????????????????????????0???0???0???\n>Marasuchus\n?0????????0???????00?1?????????????????????????????????????00021?1??????????112000000000000?0012210000110001?10100200000012002100100000101?1111000111?1001120000?1000101101000101110101111???0????000??010?0???0000000?00??????0??????0?0?????????????????????????????0??0????????1???0?000000000000000000????00?0?00?000?????????????????1111?1?111????0000011000?00???????10????00?000???0?000?0?0????0????000????100???0??????00????0?00??0??000?0\n>Pseudolagosuchus\n???????????????????????????????????????????????????????????????????????????????????????0??0????22????????????????????????1?0?20???0000?0?1?111110??1??1001120001?200010?101000????????????????????0??????????????00?????????????????????????????????????????????????????????????????????00000000000000000??????????00????????????????????????????????????????1100???0???????2??????????0?????????0?0?????????????????????????????????????0???0??20???\n>Silesaurus\n00?001????00021000000100000?1??0000?????0?0????????0?001??00002001???010000?11200000010200000002201001110000?10000200102012002001101001122?111110010211011000001?2000?11121??????01011111100000???000?0000000??0000000000?0?0?000?000?01000000000??0??????????????????0??0?0?????040000000000000000000000000??0001?0000000?000001001000021222??11222????100001100?0000??1???2000010??000???0???1?0?0???00????000?????0010?00?????00000?00001000021000\n>Sacisaurus\n?0????????0??????00011?????????????????????0??????????????????????????100?????????????????0????22?1????????????0002000000220?2001101000121?1?1110??12110111??????2????????????????????????????0???0?0???00?????0000?0000???????0????????0?0???????????????????????????????????????4?00??000000000000000000?0?????1?00?000??00?????0100????2222211222????0?00?1100???0???????20????0??00???????11?0?0????0??????????????10????????0???????0???0?02100?\n>Eucoelophysis\n?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????2?0020???01001?22?1110100??1??????????????????????????????????0??????????000??????????0000?????0???????????????????????????????????????????????????????????????00000000000000000??????????00?????????????????????????????????????00?11?????0????????????????????????????0?0?????????????????????????????????????0???0??2????\n>Lewisuchus\n???????0??????????0011?0????????????????0?000?0?00001?0???0000?10?????00????1120000000?????0???22?1000??0000??????????????????????0001?????????1???0??????????????????????????????1???0???0???0??0000?????000????0??00000?????00??????0?0?0???????0??0??0?????0??3????0??0??1??0??1000010000000000000000000???00?0?00?0?0??00?00??01?000??1111111111????????????????0??01????0????0????????0???0?0?0????0??0?00???????????0????????????0?00??0?0???00\n>Eoraptor\n0010010001000111000011?000?100000012???10100001000000?????????????????????1??1202?00???10000???22100??1100111?0020210002022?021111021????????10?0??1?????1?0000??200????1?1222???0101?1?1?00000000000?0000?0001000010000000000?00000??01000000000000000?0????0???2??????????00???010000?000000000000000000??0????0?0000000?00000??01?000211111?1?111??11??00??10?0?0011111112?00000?000?01121??00010001000000??0?000000001??000000???00?0000?00?0?000\n>Herrerasaurus\n0000010101000110000001000001100000120101000000000010000100100021011???00001?112020001111000?0022210???110011110020210000022002211102100102?111110001211011100001?200111112122211101011101100000100000?0000000010000100000000000000000001000000000000000100000000020000000013?01??010000?0000000000000000000000???000000000000000100100002111111111111111000001100000011111212100000?00000?12111111211?000000000000000000000?0000001010000000000100000\n>Coelophysis\n0000010001000101010011000001101000122101000000000000?0010?1000?101????00000?11202010111211000022210001100011110020200102012002101102100112?11111001121101112010??2001?11??1222?1101011101101000100100?0000000011000100000000000000000001000000000000000000000000030000000013?01??0100000000000000000000001000????000000000?10000100100002111111111111111200001100100011111212100100000000112111111101111111111111111111001000000000??0000000001111111\n>Liliensternus\n00????????0???????0011?000??????????????0?000?1000000?????????????????00??0?11202010011?00000??2210?011?0011??00202001021120021012021????????111000121??11???20??2001111121222???01???????0??00?00100?0000000??0000?00000?0??0?00??0??010000?00??????????????0????????????????????10000?00000000000000000????????0?000?00???0000??01?000??1111111111?????00001100???0??11???21????0??000??12??11?1101??????1???1????????00?0?????000?????00??01111110\n>Zupaysaurus\n?000?101010???????0011?000010010001221010100000000100?????????????????00??0????????????????????22???01???????????????????????????????????????????01???0?111??20??2001111121222??????????????0000001?0???????????????0000???????00000???100000000000000000?00?000?3????????????????1000??000000000000000001??0????0?000?000?10000??01?000??1111111111???1????????????0?11????2?????0????0??1???????101?111111????????????00???????????01?00???011?111?\n>Plateosaurus\n0000110001000101001011001001100000122100000000000000000100100021011??131000111002000011100000022211001110021100020200002022002100202100111?111010000211011120001?20011111212221110100010110000000000000100000000000100100001000000000101000000000000000000000000000000000000001??040000?000000000000000000000?000100000001?000001000000101222?2111220100200000100000011111112111111111111002000000001000000000000100000111111111111111111000001011000\n>Pantydraco\n0010010101000???00?01?00000100100012010100000010000000010?????????????300?011?20200???????00???22????1110011??00202101000???????12?????1????????0??021??11?00????????????????????01000101?00000?00000?0?00000??0000000100?0???000000000000000000000000000?00?000?????????0??001??0400001000000000000000000000?0001?00000000000001?0000012122???11122????00?0??1000000111?????101?11??11?0002?00??00?1?000000000?????00011111?????1111000000??000?100?\n>Antetonitrus\n?????????????????????????????????????????????????????????????????????????????1?????0011???0????2200???110011?????????????2??021???021????????1010??0??1??1???????????????????????0100?0?1?0???????0?0?0100?000???00???????????????????0???????????????????????????????????????????????0?00000000000000000?????????000?????????????????????????????????0???00?010?0000??????1????????1???????0?00?0?0????????????????000????1?1110??1?????11111???1??0\n>Eocursor\n?????????????????????????????????????????????????????????????0?0??????00000?01?0???????2???????2210???110001???0202?0102032002001?021????????1??0??12????????????????????????????11???1??????????00?0?00????0?10000???000?0????0??????0???0???????????????????????????????????????4?000?000000000000000000?0?????0?00???????????????1111??221?12??2?1?1?211111211?1???????1??????????00???0?0??1??00???????????????????????0?????00????0?00??0?02???0\n>Heterodontosaurus\n0010110001010110000?10000000100000122??1000000100000000???100??1??????01010?0120100000?20000??22211?0011001111102021010203200200110210?????1?10?00?120?0?1?2010???????????12220?11101110?100000000000?0000?0001000010000001000000200??00000000000000000000?000000300000000?300???0400000000000000000000000??0???00000111211121112112012132322221211211112011022011?110?0001020010?0?00000?010?010?00??000000?0??000000?100000000000??00?000000002?000\n>Pisanosaurus\n0??????????????????????0??????????????????????????????????????????????000001???0??0????200????222???????????????????????????????????????????????????20??11?1000??2?01???121222???11???10??0??????00????????????00?0???00???????0??????????0???????????????????????????????????????4?00??000000000000000000?0????00?00???????2???????1111????111?1222???????????00???????????20???????0?1??????????0?????????????????00???????????????????0?????0?1?0?\n>Paleorhinus\n100002000000110000001000000000000000010000000000000000000?000010000?0001110000000000100000?10?0010020000010000010020000000000000000000?0?????00000?0001000?11010?001000?0101100?000000100001000000000?0000100000000110000001101111111122001211100000010000100000010000000000102?10200000?11?11010?011000000201000001100000?000010001100061111111111100000000?000000000000?1001000?0??000000000000?001?0100000010?00000000000?000010??1000000001020000\n>Rutiodon\n100002000000110000001000000000000000010000000000000000000?????????????011?0?0000000010000001000010020100010000000020000000000000000000?0?????00000?000?000???01010010000010110????????1????1000000000?0000100000000110000001101111111122111??1211100?10?0?00?10??121????01?011???0200000?11?11010?011000000?0????001100000?00001??01100061111111111100000000?00000??00000?1000000?0??0000?000?0001001?0000000010?00000000000?00001???10?0000001020100\n>Mystriosuchus\n100002000000110000000000000000000000000000000010000000000?000010000?0001100100000000100????1???01002010001000000002001000000000000000000000000000000?????????0?????????????????????????????1000000000?0?0010000000011000000110111111112301120020110111121220321221111101011202202020000??11?11010?011000000?01000001100000?000010001100061111111111100000000?00?????00000?????000?0??00???00???0??001?0000000??0??0????00000?00??10??1000000?0102?100\n>Pseudopalatus\n100002000000110000000000000000000000000000000000000000000?0000?0??????01???????????????????????01002010001000?????????????????????000??????????????000??00?11010?0010000010110???000001000?1000000000?0???10000??001100000011011111111?2111101201010130202112102032111122110121?2020000??11?11010?011000000?0100?001100000?000010?01100061111111111100000??0???00?0000000??000000?0????0?00?0??00?001?0000000?????00000000?0?00001???10?0000?0102010?\n>Aetosaurus\n0000121110000000001011?00000000000000110010000010000??????????????????10010????00????0?0?0??0?10101110000100??00002001000211?1000100000000000000000000?000?11010?00??00?0101100?000001000000000000000?000000000000010000000000?00010??1100000000000000000????00??????????????0???021100?311211021111302110??0???0001100000?00000??01?0012121111111220??00000?00000000000????0?100?0??0000?000?000?001?010000??????0?000000?0?00001???00?0000?01020000\n>Stagonolepis\n000012111000000000001000000000000000011000000001002000000?0000?002111110010100000000100000010010101010000100?000002000000211011001000000?00000000000001?01?11010?00100000101100?000001000000000000000?0000000000000100000000000000100011000000000000000000000000000000000010101??1311000311211021111301110010?00000110000000000000010001112111111122000000000000000000000?0000100?0?000000000?0000001?0100000??0?000000000?0?000010??0000000000000000\n>Desmatosuchus\n00001211100000001000100000000?0?00000110000000010020000000000020?21??110010100000000?0?0000?0010101010000100?10000200100021??1000100000000000001001000100101101000010000010110??000001?000?0000000000?0000000000000100000000000000100111000000000000000000000000000000000010101??1311?1112222221222322?220010?000001100000000001000000015021111111220??00000000000?000000???0?100?0??000?000??00?0001?0100000??0?00?000000?0?00001???0000000?00020000\n>Longosuchus\n00001211100???0??0101100000001000000011001000?????????????000??0?2????100101000000001000??0????0101?100001000?000020010002??0???01000?00?000?001000000??00?1101000010000010110??000001100000000??0000?000000000000010000000000000??00??10000000000000?00?0000?0??????????0???????131110132122221222322?110?10?0?000110000000000???0?0001??211111112200000000?00000000000??000010?10?00000?000?0000001?01000??????00000000??0?000010??00?0000000020000\n>Ornithosuchus\n0000010101000000010011?00001011000000100000010000020000000000???0?????0010110?0000000001001?0010100011000100?000102000000121020002000000100001000??01??001??102??????????101100?00000?100000000000000?0000000??0010100000?0?000000000011010000000000000000000000020000000000001??0100000021?11010000100002110??00000000110?0000000010000311111111110?00?000001000????0000?00??100?0?000??0000?0010001?0100010??0???0?00000?00000000??0000000?0001?000\n>Riojasuchus\n010011010000000001001100100101100000010000000000002000000?0000?001????01100?00000000000100???0?0?0?011??0100?0?0102000000121020?0?0000?0?0??010000?0101001?11020?00100000101100?000010100000000000000?00000000?001010000000?00?0000000?1010000000000000000000000020??????0???01??0100000??????0?0000100002110????00??00110?000000?010000311111111110?00?000001000000?0000?0000100?0?0000?0000?0?10001?01000100?0?00000000000?00000???00?00000000?1000\n>Dromicosuchus\n0000010011000210000001?00001100101120101010011?200?11?0???????????????010???0??00000?0?000?10010101?120?0000?1?0?02001000?????????011??0?000?0000000000000??001??????????10?1??????????????0000?00000?00??000????00?00000?0?0??00?00???1000000000000000000000000?31?0????0???0???0100??0021?11010000100000??????11?2200000?0000???01?000111111111112????????????????00100???0?000?0?0000??000??0?100??010000?0?0???????002?0?????0???00?0000?01??0000\n>Hesperosuchus\n0000010?110?0210000001?00001100101120101010011?200?110000?????????????010???00100000?0?????1???0101?1?0?0000??????????????????????011??0?000?000000?000000???????????????????????01??1????00000?00000?00??0000???0??0000000?0??00000??11000000000000000000000000?31?0????0??10???0100001021?11010000100000?0???11112200000?0000???01?000111111111112?00??????0000???00100110?1000?0?0?????0001?001001?010000?00?2?00?000020020000????00?00000010?0000\n>Pseudhesperosuchus\n00000?0011000110000011?00001100?001201010?0?111200?010000?0???????????0?????00100000?00???1??????0?1120?0001??????????????????????0????0???????00000000000????????????????????????1????????0000000000?00000000???00?00000?0?0?0000000?110000000000000000?000000003100000000010???0100?0???????0?00001000000?1??00????00000?1000?0001?000311111111112?00??????0000???001?0?????000?0?0?????000????1001?0100000??????????002?0?00??????00?0000001??000?\n>Terrestrisuchus\n00000101100???????001110000110010002?0000100100200?1100001000?????1??101000?100000000000001100201010120?000001101020010001210200010000000??0000000010000000000101001000001011100001101101000000?00000?00000000000001000000010000000000110000000000000000?000000003100000001010???010000???????0?000010000000?11?01???00??0?0000000010000??111111111?10000000000000000010011??1????1?000?00000?000?001?01?0000??0200?000?0200200??00???0?0000001020000\n>Erpetosuchus\n0000000111000110000011100001000?0002211100001101000110000?????????????00?00?0?0000001??????????01?11110?0000???????????????????????????????????????????????????????????????????????????????0000000000?0???1001??????000000?000?000000011000000000000000?0?10?000030?????????001??01000001211110100001000000?0???00?12000000000000?00?000211111?11111?0???????????????0000??0??000?0?0????0000??10?0?1?0000000?????00???002?0?0000????00?000???1???010\n>Gracilisuchus\n0010021111000?10000011?000010100000011000100110100211000??000???0?????00000?010000001000000100?1100100??0100?000002000000???????010000?0?0???0011??010??00?00010?001?0??0101100??11000110000000000000?0000000??0000000000?0?0?100010?01100000000000000000000000003100000000000???010000012?111010000100000000???00??20000000000000000000311111111112????000??00000?0000?0???00000?0??0000?00??00?000??000000???0????000002?0?????10??00?0001?010?0000\n>Qianosuchus\n0000110110000001011111000??0?0000?00????01000?00?020?0????????????????00?00?1100??00??00??00???00?110?000000??101??00100010??100020000?0???????????0????00???01??001?0?0010110???0?00?000001010000000?0000000??0000?00000?0????000000??100000020?000000?0????00??30??????????01??0100?0???311?0?0000?00000??0???00???0000?000000??00?000611111?1?111????0000???000?00?001???0?100?0??00???0???00??001?000001????????000000?0??????0??00?000???1?00100\n>Revuletosaurus\n?000???0000?0210010111?0000?011000000??00?000?0200?0??????????????????00????0000?0001??0???????01???00??0100?000002000000?????????0000?0?????0000????????????010?0010000010110?????????????000000?000?????000????0???0000?0????00000???00?00?????000000?0????000030??????????????040000?2?211?010000100000??????01?1?0000000000???00?000?12211?11222????0?0??01?????0?00????0???0?0??000??0???????00????0000???????????00??0?????1???00??00???10??000\n>Arizonasaurus\n0000110100????????11010000011??0000001000?00000?00?0?00011?000010000000000?010110101011111??11222?1?0000?????01012101000012102101200000010000000000????0????????????????????????????????????0?0?00000??0??0????00????0000?????000000??1100000??000000000000000000300000000????????100000000100000000100000?0000000?00000000000000?010000??1111111111????0000001?????01?00?????10?10??00??000?????0000?0000?0?0?0????????0000?????10??000?0???0101?000\n>Arganasuchus\n??????????????????10?1?0??????????????????????????????????????????????000??????0??0????????????????????????????????????????1??????00000000000100000000?????11??????????????????????????????????0??0????????????0000??000???????000?0????0000??????????????????????????????????????1?00?0??????????0??00??0?0?????0?????00??0??????0100????1111111111???????0?11?????01??????????000??????????????0?0????0????????????????????????????????0???0?0??0??\n>Batrachotomus\n000111010100020?001111?011100000010101010101101010?00000??100020010001010000000000101111000?012?1?1111?00100?010011000000211021002000000100000000???00000001101??????????10110???00??0?00000000000000??000000??0000?00000?0?0?000000??1100000000000000000000000002000000000100???01000001?2???010000200??0?0000000?210000100000000010000211111111111????000000100??001000?????10010??00??000??00?0000?00000000?0??????000000?????10??0001000000000000\n>Bromsgroveia\n?????????????????????????????????????????????????????????????????????????????????????1?111??112??????????????011121010110???????1??00????????000??????????????????????????????????????????????????0??????0?????00?????????????????????????????????????????????????????????????????????????????0???0??00?????????????????????????????????????????????????00?0????????0????????????????00????????????????????????0?????????????????10??????00?????????0\n>Effigia\n00100101000122011010110100011000000201101000000000?2111010?110211?1??020111110100010011211??11?2210011?010???10012010111112112311212101010110000?01?0110000000101001100001????00001011101011000?10000?0000000??0000?0002000000000?100??0000000200000000??020000002000000?0??10???0000200000000000000000000?100?002000000000000010?000000500000000000?00?000010?0000001?00?0?01000?0?0000?0000?1000000?100001???0??0?000101?0?????00000010001001200100\n>Fasolasuchus\n?0??01????0001??001111?0000????????????????????????????????????????????10??000000000101???0????10??????????????????????????1?2????0210?0?????10000?0???????1101010010000010111?????????????0000???0????000?????0000?0000????0??00??0????000000000????????????????????????????0???01?000?1?3???010000?00??0??????00???00000?00?????010000211111111111?????000?11?????01??????0??00?0????????0??0??0?0?00?0????0?????????00?0???????0??0??00?000?0??000\n>Lotosaurus\n0001110010012101100011?100001000010?0101000000?00020000???1000??01????21100000001001011110?1110220????0000000100121000101?????????00000011?0000000100010000000101001?0?0010110?????????????00000100???00?0?00????00?0002??0?0?0000?0??1000000000000000000000000002000?00?0??00???000020?000000000000000000??00??02?00000000000010?000000500000000000????0??0?0100???00000???0?010?0??000??01???0?0000?000000?0?1??????010100?????0???00?0001?002?0100\n>Poposaurus\n??0????????0????????????????????????????????????????????????????????????????000001100112110?1112211?????0000?0101210011102210220120200101000000000000?1?000??01010011000010111????????????????????0?0?0?00?000?00001?????00000????????????????????????????????????????????????????????0100000000000000000??????????00???????????????????????????????????0000001??0??0???????0????????00????0???0???0???????????1??????0??????????00??????00?0???00??0\n>Postosuchus\n000101011110011000001100011101?010000001001110110130?00001000120010??00100?00000000001100011001??01011??0100001001000000022102200200000010000000001000100001001010011000010111??00000?100000000000000?0000000000000?000000000000000000?1000000000000000000000000030000000000?01?1010000?1?????0?0000?00??0000000000??000000001000001000021111111111100000000?0100000010000000100010?000000000?000000000000000???1000000000?00000010000001000?00000000\n>Prestosuchus\n?10111011?000100000111?01111?0000?010??1010110001010?0????????????????00000?????????1111001?00111?0111000100?01002?0000002??0210020000001000000000000000000110101001000001011000000000100000000000000???00000??0000?00000?????000000??10000000000000000000????00?3000????0???0???0100?0?1?1???010000200??0?00???00?2100000000000??010000211111111111????0000001000000000????01000?0??0000?0???00?000??000000???0????000000???????100?00?000??00?00000\n>Rauisuchus\n??0??1??1????1000???1??0000????????0????0?1?10?000?????0?????????????????000000000001010001?001?1?1?1????????0100110000001?1020?????????????????????00?00001101010010000???????????????????0000?00000??000?????00?0?00?00??????00??0????0?0000000?????0?00????00??000????????0???010??001?1???010000200??0??????00?2100000??0?00???1??00??111?111111????0?000??00???0?00????0?000????000??00??00??0??00????0?0?0???????0?00??????1???0??00??????20?00\n>Saurosuchus\n0101010111100110000011100001000101000101000110000010000000000020010?00000??????????0101000??00110????????????0100110000002?10210020000?0?????00?0??00???00?11010100100000101110000000100000000000?0??????0?????000?10000??????00000000?1000000000000000000000000030000000001001?10100?0?1?31??010000100000000?00?0?210000000000000010???211111111111????0000?01?00000100????01000?0??00000?????????0000000000??0????000000???????100000000???000?0000\n>Shuvosaurus\n00100101000121?1100?10110001110000020110100000000022111010111021111??020111111000010???211??11122?0001??1000?1001201011111211231121210101011000010100110000?001010011000010110?0001011101010000000000?0000000??0000?00020?0???0000100??110000000000000010020000003000000?0?310???00002?000000000000000000000000002?00000000000010?000000500000000000????0000100000000100????01000?0??00000?0??11?0?00?000001??00????000101?0?????00??001100??01200000\n>Sillosaurus\n????????????????????????????????????????????????????????????????????????????1001?11001?211??11???????????????01?12000?10?12102101?0000?0?????00?10????????????????????????????????????????????????0????0?0?????000????????????????????????????????????????????????????????????????????00??????0?0000?0000???????????????????????????????????????????????0000?00?????0????????????????????????????0?0?????????????????????????????????????0???0??????0\n>Stagonosuchus\n???????????????????????????????????????????00??????????????????????????????001000000101000??001??????0??0100?01001?000000201021003??????????????????0?????????????????????????????????????????????000??0?0?00??00???????0?????????????????????????0??0??0????0????????????????????????0???????0?0000?0000???????0?????????????????????0?????????????????0000????????0????????????????00????0???????????????????0???????????0?????10???????0?????1???0\n>Teratosaurus\n?001020111000100000011100101?1101?????????1?10100130000001????????????000???0???000??????????01?1????????????010011000000??????????????????????????????????????????????????????????????????000000???????????????????0000???????0001000?10000000000?0000000??00000?000????0??001?10100??01?21??010000100000000???00?210000000010?1?010?0?211111111111????0?0?????????01?0??????00000??00????0????????00?000?00000???????0000??????1???00?1?????00??00?\n>Ticinosuchus\n0?????????????????1111?0??????????????????????????????????????????????00????000000001??0??11???1000000000000?01000200000010?0200020000?0???????00??000??00?11010?001000?01011?0?00000110?00???0???000?00000000000001?000000000?00??0??1?0??0???????0?????????????????????????????01?0?0?1231??010000100000?0?????0021??00??00?????0100????1111?11111000000000?1000?00???0?0001????0??0000??0000000?0????0????00??0000000??00?000010??????000?0?020?00\n>Tikisuchus\n000?????1?1???????0011?0????????0?0?????0?0???10??20?????????120??0???01?000?????????????????????????????????????????????1?1010??????????????????????????????010?00??0??010111???????????????000?0?????????????00????000??????0000?0????0000??????00??00?0?00?????????0??0????????1000????????????0??00??0???0??00?????00?00000?0?01?000??1111?1111????????00????????1?0????0?????0????0??0???????0?????0???????????????0??????????????????????02??0?\n>Yarasuchus\n0?????????1??2????1?01?0????????????????0?0??????0?0?1??????????????????????1???00000?10000?0?1?101?10??0011?0100020000001?1020???0000?0??????000??0001000?????????????????????????????????0?01?0?000?00?0?00??0000??0?00?0????00??0????0000??0????0?00?0????00???000?????????????10??001?11??010000100000???????0?21??00??00?0???????????1111?1?11?????0?00??100???01??0???????0?0??00????0???0?0?0????0??0?0??????????0?00?????????????000?0??20?00\n'
        if not check_individual_results(cm, t):
            res = False
        print("interleaved phylip ", end = '')
        cm = "./pxs2fa -s TEST/morph_data/morph_inter.phy"
        t = '>Erythrosuchus\n00010000000100101010000001000000100010000?00000000000?0?00?010010000000001000?0000??0010000000000000000000?00??00000?00?01?0000100000000?010000?0000010000?00000000?0000000001?0000000??0000000000000000000000010?0000?00?00000000000000000000?00?000010??000000??1000?0?0000?000?00?000?100000?0?0??000000001??10??01010010000000\n>Euparkeria\n0000000100010000001000001100100000000000000000000000000000000?0100000001000000000000000000000000000000?000000100000?000?0000000000000000000000000001000000?0000000??00000000?0?0000000000000000000000000000000000?0001000000010000000000000?00?00?0000000?000000?01000?0??0000000000?000?1000000000?00000000000010??0000001?000000\n>PROTEROCHAMPSIDAE\n10000000000010000001000000000000000000000000000000100??0????000000000000000000000000000000000000000000?0??000000?00??00?000000000000?000000100000001000000?00?00000?000000000000?111000000000000000000002000000?0?000000000??0?0000000000?0000????0000001?000000??1000?0??000000?0?00000?1000000000??1000000????10??00?00010010000\n>Scleromochlus\n10101?01000?00000110000001??00000??01000??00??????????1?????1????000?00?????00??001100000000100??00000?0???00?1??10??01?0???00?0?0?1?011101110000000??0000?0000?000?0000000000000?0000000000000000000?00??????????0001?0000??0?0000000000?0?0000???00?000?000?00??0000?0??000??00?010001?0000000???0?10000?000??10??????001?010000\n>Eudimorphodon\n10001001000010010?00000?0?0000?0???00000??0?????????????????1????010??000000000?0011001011101000000000?0??0??010?1100?0?0??0??????11?011?01??00011111?1111111111111111111011111?100000??00?000000000???0??????????0000?00?0??00000??0000??0?001001000?1??0?00?01?0010??0?0000??00?11000??00000?????1000000?0000000??00?0000?01?000\n>Peteinosaurus\n??????????????????????????????????????????????????????????????????????00??0000??0011001????01?0???000????????????1?0?00?0??0??????11?01110101000??????1111?1?11111111111???1111?0???????????????????????????????????00?00?????0???????????0?0?1001?00?1?0000?????00??????00000?00?110?0????????????10000???000000???????000?0????0\n>Preondactylus\n10?0?????00?11010???000?0????00?????????????????????????????0????010??00????00??0011001???????0???0?0????????????1????0?0?????????????11101110001111??1111?1111111111?11110?110?0?0000??00?00000000????0??????????000??00?????0?00??0000??00001001?00?1?00?00??1?0010??0?0?0?0?00?110?0???00???????100000??0000000??0??0000?01??00\n>Austriadactylus\n1000??01?00?11010???000?0?00?0????????00?000????????????????????????????????00??001100????????????????????????????????????????????????11????????111111111?11?10?????????10?1??????0000??00?000000000???0??????????0?0??00?????0?00??000???0?001001?????????00?0????10??0??????????0???????00000?????????0???????????0??0000?01?00?\n>Lagerpeton\n??????????????????????????????????????????????????????????????????????00??????01???????00100000001010100?1000001?1?0101000?10?101111011101011110???????0????????????0000?????????????????????????????????????????????0?00?????????????????????????0000001100??????0???????0000???????00???????????0??000????????0000????0???0?0??0\n>Dromomeron\n???????????????????????????????????????????????????????????????????????????????????????????????????10100?000001111??1010???10010101????????????????????0??????????????00???????????????????????????????????????????????00?????????????????????????????00????????????????????0????????00?????????????????????????????????0???0?0???\n>Marasuchus\n?0???????0?????00?1????????????????????????????????0001??????????110000000000?00001100110100000000000001?111100011?1001100?00010111101110101111???0????000??010?0???000000?0??????0?????0????????????????????00??????0?00??00???00????????????????0000000?00??????0????00?000????000?00????0????000??100??0?????00????0?00??0?00?0\n>Pseudolagosuchus\n????????????????????????????????????????????????????????????????????????????0??????????????????0???000?0?111110??1?1001101?00010?11????????????????????0??????????????00???????????????????????????????????????????????00?????????????????????????????00???0????????????????0????????00?????????????????????????????????0???0?0???\n>Silesaurus\n00?00????001000000100000?1??0000???0?0???????001??000000???00000?110000010000000101100010000100000100011?11111001011011001?000?1111???01011111100000???000?0000000??00000000?0?0?000000?0000000??0???????????00???00000000?000?0000?0000000000????000000?0000??1??000010??000??????1?00???00????000???001000????00000?000010001000\n>Sacisaurus\n?0???????0????00011???????????????????0?????????????????????00??????????????0???1????????0000000?0100001?1?1110??1110111???????????????????????????0???0?0???00?????0000000???????0?????0?0?????????????????????????0??00???????00??00????000??????00?00???0??????0????0??00??????11?00????0????????????10??????0???????0???0?100?\n>Eucoelophysis\n???????????????????????????????????????????????????????????????????????????????????????????????00??0001??1110100????????????????????????????0??????????000??????????0000???0???????????????????????????????????????????00??????????????????????????00??????0?????????????????????????00?????????????????????????????????0???0?????\n>Lewisuchus\n??????0????????0011?0??????????????0?000?0001?0???000010????0????11000000????0??10??000????????????001???????1???0?????????????????????1???0???0???0??0000?????000????0?0000?????00?????0?0?????0???0??0?????00?10?0001000?00???0???00?00?0?00?????????????0??01??0????0???????????0?00????0??0?00????????0???????????0?00??0???00\n>Eoraptor\n0010000010011000011?000?10000001??10100001000??????????????????1??10?00???0000??0?11001?0010000?01101??????10?0??1????1?0??00????11???0101?1?1?00000000000?0000?00010000000000000?0000??0000000000000???????????0?0000?00?0????0000?00000?0?00??11?00?0?0?00111111?00000?000?0111??0000001000000??00000000??00000???00?0000?00?000\n>Herrerasaurus\n000000101001000000100000110000011010000000000001001000101???0001?110000111000?000?1100110010000001101001?11111000111011101?0011111111101011101100000100000?00000000100000000000000000000000000000000000000000001??0000?0000???000000000000000011110000000000111111100000?00000?111111111?000000000000000000?0000010100000000000000\n>Coelophysis\n00000000100010100110000011010001101000000000?0010?100010????0000?110010111110000001000110000100000101001?1111100111101110??001?11?1?1101011101101000100100?00000000110000000000000000000000000000000000000000001??000000000???00000?100000000011110000001000111111100100000000111111110111111111111111110000000000??00000000011111\n>Liliensternus\n00???????0?????0011?000????????????0?000?1000???????????????0??0?11001001100000?001?001?0000101000101??????11100011??11????00111111???01???????0??00?00100?0000000??00000000?0??0?00?0??000?0??????????????????????000?00??????0?0???0000?0?00????000000???0??11??1????0??000??1??11?101??????1???1??????0?0????000?????00??011110\n>Zupaysaurus\n?000?01010?????0011?0000100100011010100000000???????????????0??0?????????????????0?????????????????????????????01??0?111???00111111??????????????0000001?0??????????????000???????0000??0000000000000?000??????????00??00?0????0?00?10000?0?00???1?????????0?11????????0????0??1??????01?111111??????????0??????????01?00???01111?\n>Plateosaurus\n000010001000100101100100110000011000000000000001001000101??110001110000011000000101100100000000000001001?11101000011011101?00111111111010001011000000000000010000000000000100010000000010000000000000000000000000?0000?000000000001?0000000001010000000000001111111111111111110000000001000000000000000011111111111111110000011000\n>Pantydraco\n00100010100??00?01?000001001000110100000010000010???????????00?011?000??????00????11001?0010100???1????1??????0??01??11?0?????????????01000101?00000?00000?0?00000??00000010?0???00000000000000000000?000?????0?0?000010000000?0000000000?0001????0?0?000000111???101?11??11?000?00??0?1?000000000???0001111????1111000000??00100?\n>Antetonitrus\n??????????????????????????????????????????????????????????????????1???0011??0???0?11001?????????0??01??????1010??0?1??1???????????????0100?0?1?0???????0?0?0100?000???00?????????????????????????????????????????????0?00?????0?????????????????0??00?0?0000?????1???????1??????0?00?00??????????????000???11110??1?????11111?1??0\n>Eocursor\n?????????????????????????????????????????????????????00?????0000?010????????????0?11001??0?0100000101??????1??0??1????????????????????11???1??????????00?0?00????0?10000??00?0????0???????0?????????????????????????00?00??????????????????1111?1?111111?1????????????????00???00??1??0????????????????????0????00????0?00??0????0\n>Heterodontosaurus\n0010100010110000?100000001000001??1000000100000???100?1?????1010?01000000?0000??1011001110101000001010???1?10?00?10?0?1?0?????????10?11101110?100000000000?0000?0001000000000100000000??00000000000000000000000?0?0000000?0??0011111121111101111110110011?110?00000010?0?00000?00?010?0??000000?0??0000?1000000000??00?0000000?000\n>Pisanosaurus\n0???????????????????0???????????????????????????????????????00001??0?0????00??????????????????????????????????????0??11?0???01???11???11???10??0??????00????????????00?0??0???????0???????0?????????????????????????0??00????0???????2?????111????????00??????????0???????0?1????????????????????????00?????????????????0?????1?0?\n>Paleorhinus\n1000000000000000010000000000000010000000000000000?0000000?001110000000010000?10?0000010001000000000000?0???00000?001000?10?01000?000?000000100001000000000?000010000000010000011011111110011100000000000000000001?00000000000000000?00001001000000000?0000000000?01000?0??00000000000?01?0100000010000000000000010??10000000010000\n>Rutiodon\n1000000000000000010000000000000010000000000000000???????????11?0?0000001000001000000010000000000000000?0???00000?00?000??0101000000????????1????1000000000?00001000000001000001101111111111?111100?00?00??1???1?1?000000000???00000?00001?01000000000?000??00000?00000?0??0000?00?000101?000000001000000000000001???10?00000010100\n>Mystriosuchus\n1000000000000000000000000000000000000000010000000?0000000?0011001000000100???1??0000010000001000000000000000000000??????????????????????????????1000000000?0?001000000001000001101111111011000110111120122111011000000?000000000000?00001001000000000??????00000???000?0??00???0???0??01?0000000??00????000000??10??1000000?01?100\n>Pseudopalatus\n1000000000000000000000000000000000000000000000000?00000?????1???????????????????0000010????????????00????????????00??00?10?01000000???000001000?1000000000?0???10000??0010000011011111111110101010100210201111111?0000?000000?00000?00001?01000000??0?00?0000000?00000?0????0?000??00?01?0000000???0000000?000001???10?0000?01010?\n>Aetosaurus\n0000111100000001011?000000000000110010000000????????????????0010???0????0??0??0?1100010?00001001?000000000000000000?000?10?0??00?000?000001000000000000000?0000000000000000000000?0010??0000000000000??0??????????0110?00?0??000000?00000?0?010??0000?000000000????100?0??0000?00?000?01?010000????0?00000?000001???00?0000?010000\n>Stagonolepis\n0000111100000000010000000000000011000000000000000?000000111100101000000100000100110001000000000100000000000000000001?01?10?010000000?000001000000000000000?000000000000000000000000010000000000000000000000000011?1110000000000000000000000001000000000000000000?00100?0?00000000?000001?0100000??00000000?0000010??00000000000000\n>Desmatosuchus\n00001111000001000100000000?0?00011000000000000000000000?1??100101000000?0?000?00110001010000100??0000000000001001001001010001000000??000001?000?0000000000?000000000000000000000000010010000000000000000000000011?11111220000000000000001000010??00000000?000000???100?0??000?00??00?001?0100000??00?00000?000001???0000000?000000\n>Longosuchus\n0000111100?0??01011000000010000011001000??????????000?0?????00101000000100??0???1100010?0000100?0?000?0000?00100000??00?10001000000??000001100000000??0000?0000000000000000000000000?00?000000000000?000??????0???1110122?00?00000000000??00010000000?000000000??0010?10?00000?00?000001?01000?????0000000?0000010??00?00000000000\n>Ornithosuchus\n0000001010000010011?000010110000100000010000000000000??0????010110?0000000001?000100010000000001000000000001000??0??001?1?????????00?00000?100000000000000?0000000??00100000?0?0000000000100000000000000000000000?000000010?0000010?0000000000?00?000000????0000?0?100?0?000??000?001001?0100010??0?0?0000?0000000??0000000?00?000\n>Riojasuchus\n0100101000000010011001001011000010000000000000000?000000????1100?00000000000???0?1??0100?00000010?0000?0??010000?001001?10?010000000?000010100000000000000?00000000?0010000000?00?000000010000000000000000????0???000000010???00010?00000?0000?00?000000000?0000?00100?0?0000?000?0?1001?01000100?000000000000000???00?00000001000\n>Dromicosuchus\n0000000110010000001?000011001011101010011?001?0?????????????10???0?0000?0?00?100110?0001?000100????01??000?000000000000?0?????????0?????????????0000?00000?00??000????000000?0?0??0000??00000000000000000??0??0???000?000????1?0000?0000??0?00?????????????00100???000?0?0000??00??0?10??010000?0?0?????00?0????0???00?0000?010000\n>Hesperosuchus\n000000?110?10000001?000011001011101010011?0010000???????????10???000000?0????1??110?000????????????01??000?000000?00000???????????????01??1????00000?00000?00??0000???0?000000?0??0000??00000000000000000??0??0?1?0000100???1110000?0000??0?00?00?????00???00100101000?0?0?????001?00101?010000?00?00?0000000000????00?00000010000\n>Pseudhesperosuchus\n0000000110010000011?00001100?0011010?0?1110010000?0??????????????000000?00??1????10?001????????????0???0?????0000000000????????????????1????????0000000000?00000000???000000?0?0?000000?000000000000?000000000001?0000?0001?00?0000?1000?00?00?00?????00???001?0???000?0?0?????00????101?0100000????????00?000??????00?0000001000?\n>Terrestrisuchus\n0000001100?????00111000011001000000010010000100001000???1??11000?100000000001100110?00011000100100000000?0000000010000000010100000000001101101000000?00000?00000000000000000001000000000000000000000?000000000011?0000?000?1?0?00?0?00000000001000000000000001001?1????1?000?0000?000?01?01?0000??00?000?00000??00???0?00000010000\n>Erpetosuchus\n0000001110010000011100001000?00011100001100010000???????????0?00?0?00001????????110?000?????????????????????????????????????????????????????????0000000000?0???1001?????00000?000?0000000000000000000?0000??????0?000000000??0?0000000000?0?00?0????????????0000?0?000?0?0????000??10??1?0000000???00???00?00000????00?000???1?010\n>Gracilisuchus\n0010011110010000011?0000101000001000100110001000??000??0????0000?01000010000010000??01000000000???0000?0???0011??00??00?00?01?0??000??11000110000000000000?0000000??00000000?0?0?10010?00000000000000000000000000?000000000??0?000000000000000????00??000?0000?0??0000?0??0000?0??00?00??000000???0??00000?0????10??00?0001?010000\n>Qianosuchus\n0000101100001011111000??0?0000?0???01000?0?0?0??????????????0?00?110?00??0??00??1000000?1000100??00000?0?????????0???00????01?0?000???0?00?000001010000000?0000000??00000000?0????00000?000000?000000??0??????????0000?00?0??0?000?000000?0?00????000?000?00?001???100?0??00???0??00??01?000001??????00000?0?????0??00?000???10100\n>Revuletosaurus\n?000??0000?10010111?0000?0110000??00?000?000????????????????0????0000001?????????0??01000000000????000?0???0000??????????0?01000000?????????????000000?000?????000????0??000?0????0000??0?0????000000??000????????0000?00????0?000000000??0?00?????0???????0?00??????0?0??000??0??????0????0000?????????00?0????1???00??00???1?000\n>Arizonasaurus\n000010100??????11010000011??00001000?0000000?00011?000100000000?010110101111??111000???01001000100100000000000000???0????????????????????????????0?0?00000??0??0????00???000?????00000??0000?000000000000000000????000000?0000?0000000000?0000????0000?????01?00???10?10??00??00?????000?0000?0?0?0??????000????10??000?0???01?000\n>Arganasuchus\n???????????????10?1?0???????????????????????????????????????00?????0?0?????????????????????????1???0000000010000000?????1???????????????????????????0??0????????????0000?00???????00?0??000?????????????????????????0?0?0????????0??0?????000???????0??????01????????000?????????????00????0????????????????????????????0???0??0??\n>Batrachotomus\n000110101000?001111?0111000000101010101101100000??100000000110000000010111000?0111?0010010000001000000000000000???0000001?????????0???00??0?00000000000000??000000??00000000?0?0?00000??0000000000000000000000000?0000000?0000?000100000000000????000000??001000???10010??00??00??00?000?00000000?0????00000????10??00010000000000\n>Bromsgroveia\n????????????????????????????????????????????????????????????????????????1?11??11???????01101010???1?0??????000?????????????????????????????????????????0??????0?????00?????????????????????????????????????????????????00?????????????????????????0?0??????0??????????????00??????????????????????0?????????????10??????00???????0\n>Effigia\n00100010001011010110100011000000110100000000111010?110111??00111110001001111??1101?010?10010111111111010110000?01?1100000010110000?00001011101011000?10000?0000000??0000000000000000100?000000000000?0000000000?1?0000000?0?0000000000001?0000?00?00010000001?00??1000?0?0000?000?100000?100001???00?00010?0????000000100010010100\n>Fasolasuchus\n?0??0????00??001111?0000????????????????????????????????????10??0000000101??0??????????????????1???010?0???10000?0??????10101000000?????????????0000???0????000?????0000000????0??00?0??0000000???????????????????0?00?00????0?0000?00????0000????000??????01???????00?0??????????0??00?00?0????0???????000??????0??0??00?000??000\n>Lotosaurus\n0001100100101100011?100001000010101000000?00000???1000?0????1100000000101110?111??0000010000011????00000?00000001001000000101?0?000?????????????00000100???00?0?00????00000??0?0?000?0??00000000000000000000?00?0?0000?00?0??0?0000000001?0000??????0?00???00000???010?0??000??0???0?000?000000?0?1????01000????0???00?0001?000100\n>Poposaurus\n??0???????0??????????????????????????????????????????????????????000110011110?111???000010001101001000100000000000?1?000?0101100000????????????????????0?0?0?00?000?0000????00000????????????????????????????????????0100?????????????????????????0000??0??0??????????????00???????0??0???????????1????0????????00??????00?0??0??0\n>Postosuchus\n000100111101000001100011101?0100001001110101?000010001000??0100?000000001100110011??01001000000100000000000000001001000000101100000??00000?100000000000000?00000000000000000000000000000000000000000000000000000??0000?000000000000000100000000000000?000000100000100010?00000000?00000000000000???0000000?0000010000001000?000000\n>Prestosuchus\n?1011011?0000000111?01111?0000?0??1010110010?0??????????????0000???????111001?00010001001000000?0000000000000000000000001010100000000000000100000000000000???00000??00000000?????00000??00000000000000?00?00??0???0000?00?0??0?0000000000?0000????0000000000000???1000?0??0000?0??00?00??000000???0??00000??????100?00?000??000000\n>Rauisuchus\n??0????1???000???1??0000???????????0?1?10?00???0??????????????000000000101001?0011?????0100000010?????????????????0?0000101010000???????????????0000?00000??000?????00?000?0??????00?0??0?00000????000?00?00??????00?0000????0?0000??0?00????0?????00000???0?00????000????000??0??00????00????0?0?0?????0?0?????1???0??00?????0?00\n>Saurosuchus\n010100111101000001110000100010101010001100000000000000000?0000????????010100??00???????010000001000000?0???00?0??0???00?101010000000000000100000000000?0??????0?????000?000??????00000000000000000000000000000000?0000?000000??0000000000000??????000??00000100???1000?0??00000???????0000000000??0??00000??????100000000???000000\n>Shuvosaurus\n00100010001?1100?1011000111000001101000000001110101110111??001111110010???11??1100??10010010111111111010110000101011000000101100000?0001011101010000000000?0000000??00000000?0???000100?10000000000000000000000?1?000?00000000?0000000001?0000????0001000000100???1000?0??00000???11?000?000001??00??00010?0????00??001100??010000\n>Sillosaurus\n?????????????????????????????????????????????????????????????????10111001?11??11???????01?00?1?1001000?0???00?10???????????????????????????????????????0????0?0?????000??????????????????????????????????????????????0000?????????????????????????000??????0?????????????????????????00?????????????????????????????????0???0????0\n>Stagonosuchus\n??????????????????????????????????????00????????????????????????001000010100??00????010010000001000????????????????????????????????????????????????????000??0?0?00??00?????0????????????????????0???0????????????????0?00????0????????????????????000??????0??????????????00??????????????????????0????????0????10???????0???????0\n>Teratosaurus\n?001001110000000011100101?1101???????1?10101000001??????????00???0??00?????????0???????01000000?????????????????????????????????????????????????000000??????????????????000???????00100000000000?00000?00000??0?0?000?00000??0?000000010??00???????0???????01?0????00000??00???????????00?000?00000?????000?????1???00?1?????0?00?\n>Ticinosuchus\n0??????????????1111?0???????????????????????????????????????0????0000001????11??000000001000000?000000?0?????00??00??00?10?01000?000?00000110?00???0???000?0000000000000?00000000?00?0??0????????0????????????????0?00?00?????0??0??00????000?00000000000?00???0?01????0??0000??0000000????0????00?000000?00000010??????000?0?0?00\n>Tikisuchus\n000????1?1?????0011?0????????0?0???0?0???1???????????10?0???1?000??????????????????????????????10????????????????????????0?0??0??00???????????????000?0?????????????00???00??????000?0??000?????00?0?00??????00????00???0????0???0?00000??0?00??????00??????1?0????????0????0??0???????????0?????????????0??????????????????????0?\n>Yarasuchus\n0????????1?????1?01?0??????????????0?0?????0?1???????????????????1??0000?1000?0?11??0010100000010??000?0????000??001000?????????????????????????0?01?0?000?00?0?00??0000?0?0?0????00?0??000??????0?00??0??00???????0?0000????????0??00?0???????????00?00???01??0?????0?0??00???????0?00????0??0?0????????000????????????000?0?0?00\n'
        if not check_individual_results(cm, t):
            res = False
        print("fastq ", end = '')
        cm = "./pxs2fa -s TEST/test.fastq"
        t = '>D7DHSVN1:151:D12V0ACXX:8:1101:1426:1976 1:N:0:CGATGT\nNACAACAAAAACTTTATTGAAATAGTTGCATGAAATTTCAGACGTCAAAATAGTCATCTGAAAATTTACTCTTGATCCATTTAAAGCTGTTCCTTATAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1657:1955 1:N:0:CGATGT\nNGCATTTGTCCTTATACAGACTGAAGAGACCATTGGCATGGATCAAATCATATGTTCTTGGATATGTAGAAAATCCCTCACACCAATCATGATAAATGCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:1585:1964 1:N:0:CGATGT\nNTGGAAAAAAATAGTTCTTGGGTTTACTGAAGTTGATCATATAATCTTTAGAGTTCAGCGGCAGGAGGAGCATTTGGTGTACCCTCTGAAGTGCAAGGCGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:1539:2000 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATATCGTATGCCGTCTTCTGCTTGAAAAAAACACCCAAGAGCTAGGCGACACGAGGATCTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1881:1990 1:N:0:CGATGT\nNGATATTTCTATTCGACTGGTTAGAGAACTCTTAACTTGATCAATATAGACAAATGGAGGTGCTACAACAACATCGACATCAGCCTCCAAGGTTGCATTGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2177:1964 1:N:0:CGATGT\nNTCCAGTTTTTGATACCTCAACGACATGGCCATCACAATGTTCAACCAAAGAGAATAAGAAGAAAATTACAATCACAAGATGAGCTCCGTTGAGCCCCTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2295:1951 1:N:0:CGATGT\nNAAAAGTCTGTGCCGCCCTTCAGAGCAAAACCCAATCAACCTAACAAGGTTCAAATGGTGGGTGCTGCTAATGGTTGCTACCTCCATTCTAAACTGTTTCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2642:1999 1:N:0:CGATGT\nNGTAATTTGCGCGCCTGCTGCCTTCCTTGGATGTGGTAGCCGTTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAATTCTCCGTCACCCGTCACCACCATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2987:1988 1:N:0:CGATGT\nNTTGAGTCCCACATCCCTTCCTTTGCCCACCTGAATGTATTCATGATGGGTAATGTTTCCCTGTCTTAAAGTTGAATTGAAACCTGGATATATATCTTCGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3233:1928 1:N:0:CGATGT\nNATGATTCAAAAATTGGATAGAGTTAAGGGGGAATGCCGCTGCTGATAGATCCCGCCCAGATCAAGAATAGTTGATTATATCCAGGAAAATTAAGAGTTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3186:1968 1:N:0:CGATGT\nNTCCAGCAATACATCTTTTGCAGCAACAAGAGTGAACGTTTTGTTTGCATGAGTGGCAGGCGATAACCCGATTCCAGGTAACACTTTTCCATTTCCCAAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3407:1961 1:N:0:CGATGT\nNTGTTAATCATTACTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATGATGTTATCCCATGCTAATGTATACAGAGCGTAGGCTTGCTTTGAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3354:1981 1:N:0:CGATGT\nNCAGGCCTCTTGCCCCCACACTCGACGTTACCGTTGATGGCGCTGATGGTAGGTCCGAAACCTTGGTTGACCACGCTATGAACGCTGCTCATCCAGTACCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3492:1987 1:N:0:CGATGT\nNTCGACTTTAACATCTGTGGTGATGTTCTTGTTTGTGAACTTAGTGCTCACATCAGCGAGAAAGAACTCTCCCTTCTTTATTCCATTGGAAGTGATGGCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3620:1923 1:N:0:CGATGT\nNAACAGAAAAGATAACTCTTCCCGAGGCCCCCGCCGACATCTCCGGACTCCCTAACGTTGCCGTCAACCGCCACGTCCCGGTTCAGGAATTTTAACCCGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3698:1949 1:N:0:CGATGT\nNGAAATTTTTGCCAGGACAACTAGCCGGGGCTTGGCCTATAATGCCATCAAAGAACGCCTGACTCACAACATCCCCGACCGAGACACCGCTACTCGGGGTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3907:1950 1:N:0:CGATGT\nNGTGAGACTAAAGCCATAGAGAAATATTCCTAGGCCTTAATTAGAGACCAAATCAAGGAGCTTCCATCATTTGCTTGCCTGGATTTCAGAACTACTATCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3953:1959 1:N:0:CGATGT\nNGCCAAAGCACCTGCATTTGCATTGCTTCCATGAGACTGATCACCCGAGCTTGAAACGAAAATACCCTGCTGGCGGGCTCGTTGGAGCTCCTGCTCAAGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3806:1965 1:N:0:CGATGT\nNAACATATGATAGAATACATTAGATCACATCATACCACTAAACTTATAACATTAGCATCTTATTGCACAACCAAAAGCAGCACTAATTTAGAGTTGATAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3909:1974 1:N:0:CGATGT\nNTCCACTGGCCGACGCCTGGAGCGCGCAGGTGCCGAGGCACGCTGTGACAGCGCGCGCTGACTACCACAATCGCGAGGACAGCACTCCCGGAGACTGGGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3887:1986 1:N:0:CGATGT\nNTCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTGGGGCTGCATTCCCAAACAACCCGACTCGGCGACAGCGCCTCGTGGTGCGAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3753:1998 1:N:0:CGATGT\nNCGCTGACTACCACAATCGCGAGGACAGCACTCCCGGAGACTGGGTTTCCGCTGCCCTCACAATCCACGTCAGTCCGCACCCCGAGCCGATCGGCGGACCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4218:1933 1:N:0:CGATGT\nNCATGAATTAAGTGATGTAATTAAGAAATGAATGGCACAACCACAATCGACACCCAACAACATTATCACTATATGATTAATAAAGCTATTTTCCATTCAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4054:1941 1:N:0:CGATGT\nNTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTGGGGCTGCATTCCCAAACAACCCGACTCGGCGACAGCGCCTCATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4066:1956 1:N:0:CGATGT\nNCTAGGGCGACGCTAGGGCGACGCGTGAAGACCCGGGGTAGTAAACTACCCGGACGGGACTTCCCCCTTCAAAAATTAATTTAATATCATTGTGGGCCAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4441:1928 1:N:0:CGATGT\nNGCGCGCGTGCGGCCCAGAACATCTAAGGGCATCACAGACCTGTTATTGCCTCAAACTTCCGTGGCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4424:1942 1:N:0:CGATGT\nNCGAGATTCTTTCCATCTTTTTCGATGGCATGTTTGAAAGCAGCTCCAAATCCAAGCCACACTGGAAGATGAAACCTTGTCTGAGTCCAAGCGAAAATCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4623:1935 1:N:0:CGATGT\nNTCATAAGGTGCCGGCGGCGTCCTAAAAGTAACATCCGCCGATCCCTGGTCGGCATCGTTTATGGTTGAGACTAGGACGGTATCTGATCGTCTTCGAGCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4603:1977 1:N:0:CGATGT\nNTCAAACTCTCACCATAGCCAAAAAACTAAACAATACCAATTATACAATAAGGTCTAGATTGATGATTCTGGCCCTAAAAGGGAGGAGGTGTCTTAAGTAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4758:1929 1:N:0:CGATGT\nNATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGCAAAAAATTTCATCACTGAAAATTGACTCGCCGTCTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4771:1943 1:N:0:CGATGT\nNTGTAGAAGGGGAGATATTGACACCTAAGTTGACACCGCACTTCCCAGGGAGGGGACCCGCGTAGCCATAGTTGACCCCATAAGATGGGATAGTCTGTTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4948:1974 1:N:0:CGATGT\nNGGATCTGTCGTGCTATCGCATTTATATACATGGTGTCCCGACAATGAGGTTGCAAGAGTTTATAGATTGGATGAAGCACACTTAGTTGTCTGTTTGTTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5023:1970 1:N:0:CGATGT\nNATGGCCGTTCTTAGTTGGTGGAGCGATTTGTCTGGTTAATTCCGTTAACGAACGAGACCTCAGCCTGCTAACTAGCTATGCGGAGTCACACCTTCGCAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5376:1952 1:N:0:CGATGT\nNAGCTCTTTCTGCTCTTTCAAAAAGATAGTCAAAACCCTTACTACTCAGCGGCTTCTTTATTACTCTTCTATCTTTCTGAACTTTACTGAAATTCGCTTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5460:1978 1:N:0:CGATGT\nNAGATTTTCCACAGCTTCACCTAGCCATGCAACTATGCTTCAAAAGGCTTATGACATGGCTGCAAAGCACCAATTAATGGTTTTGATACACTGCTGCCAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5685:1934 1:N:0:CGATGT\nNCCAATCAGCATAGAAATTAGGAGTGGGTGGAATTCCCCAACCATCCACTCCACCCACAACATGAATCAAAGCTGATCCATATTGCACTAATCCGCACATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:5761:1985 1:N:0:CGATGT\nNTCGCCGAGGGCACTGCTAGCAATAGAGTATAGTCTCAACTTATGGGGCTTTCCATTTTTGTCAATACCTTCAGGAATCACACCAACTGACTGCCCTTCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6067:1929 1:N:0:CGATGT\nNGGGATTCCATCATTAGTGAGGTAAATAACAACCCTGGAGCTGGATGGAAGGCTGGCATGAACCATCAGTTCTCCAATTATACAATTGGCCAATTCAAGCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6174:1980 1:N:0:CGATGT\nNTATAGCAAAGCATTAATCCTTTTTGTTGTGGCATCAATAGTTTCTTTGTCTCGTTTGGTACCAGTCTCAGTTACAAGTAGGCATTGGATAAGATCGCTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6066:1994 1:N:0:CGATGT\nNGGGAATTCGCTGATGATAGATCTCGCCCAGTGTCCCCCTCCTTCCCCCGCCGCCTTCCGACCCGCGGAAGAATCCAATTTCAACTACCGGAGACTCATGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6454:1931 1:N:0:CGATGT\nNCCTTTTTGTATCCATCAACCATCAACGGCATGGCCAGGGCACCTCTTATCGTTTTCCATCCAGTTCGTAACAAGGAAAGGAAGCCTTTCCATGTCAAAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6486:1941 1:N:0:CGATGT\nNGGGAAAAGGATTCGTTCGTCTAGCTATTGAGAAAGGCTGTCCTTTGGTTCCAGTTTTCTGCTTTGGCCAGTCGAGAGTCTACAACTGGTGGAAGCCTAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6286:1969 1:N:0:CGATGT\nNGAGAAGATCGCCAAAGAATCTGCAGCTTAAACAAAAAAACTGAGCTTGGGATGGCAATGTTGGGATGAAAATAAGGATTTCACTGAAATCGTCAGGAAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:6457:1990 1:N:0:CGATGT\nNCACAACCTTTAACGTCAGGTTTATGAAGCGATATGAATGATGAGAGTAGAGTTGATTTTGGTGGTGGAAGCGCCTCTGGAATCGTTCCAACAGTTTGCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6510:1923 1:N:0:CGATGT\nNCATCATCACTTCCACCAGAAATATAATCACCATTTTGGCCCAAGAAAGTAGCCTGCTTTATGTCAGTTCCCACATTACAGTGTCCAACATATCTCTGTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6738:1950 1:N:0:CGATGT\nNGACGATAGCAATATTTGTAGGGACTGACCTCCATCCAATCACCTCTAGACCCTCTTGTGAAAATATACTTGCAACAACTTTTCTCGCTTCCTCTGCAAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6546:1958 1:N:0:CGATGT\nNTGACACTGTCATCAGTAGGGTAAAACTAACCTGTCTCACGACGGTCTAAACCCAGCTCACGTTCCCTATTGGTGGGTGAACAATCCAACACTTGGTGAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6727:1973 1:N:0:CGATGT\nNAAAAAAATTGGATTTCGTGTAATAAGTTTGATATTCATCAATCCCTGTTAAAAAATAATCACAAAAATCTAAACATTTATCTATCCATCCATAAGGTAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:6717:1990 1:N:0:CGATGT\nNCCAAGGATCCAGCACACGCGTCATTAGCATCACCGACCGTGAAACTTAAGACGTATGTCTTCTTAGGGATGGTTCGGACCACTTGAGCGATCGCGCTCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6984:1979 1:N:0:CGATGT\nNGATTAGTCTTTCGCCCCTATACCCAAGTCAGACGAACGATTTGCACGTCAGTATCGCTTCGGGCCTCCACCAGAGTTTCCTCTGGCTTCGCCCCGCTCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6784:1985 1:N:0:CGATGT\nNTTTTTCCTTGGTGTAAAACTTCCGGTAGATTTGCTCACCTTCTTCAATAGTCAGCACACCTGGAAGGACTTTCTGCAAACCTTCTGTTTCCAGCATCTCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6839:1992 1:N:0:CGATGT\nNACAATTTTGCCAAAAAAATGAAAAAAACCCAAAGGATAATCGAAACGAACAAAAACCGAAACAAGAACTTCGCCGGAGAAGCCTCCATTGACGGAACAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7208:1925 1:N:0:CGATGT\nNACAGGTAATCGCTTGTGTAGGTGGTGCAACCATCACCATGGTGAGGAATAGGAGGCATGTTGCCTTTGTTAGCATTGTTGCGGTGGCCATTGTACTCTCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7218:1939 1:N:0:CGATGT\nNTCCAGTTCTGTACTTTTTGCTGGCGAGTAGTCCATGGGTATAAATTGGCCACGTGGTATCAACTCAGGGTCCCAACAGACAAAGTATATATCACCGTCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7051:1973 1:N:0:CGATGT\nNCCACGTCGGTGAGCTCAATCTTCTCACATGGTGCTCCGCTGCTACAAGACAAGGCAACTGCTTCTGTCCTCGTGGTTGTTCCCTTGACGTTCCTGATTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7128:1990 1:N:0:CGATGT\nNCCGATTTTTTCCAGCCCAAGCCCAGCTGTGAACGGCATTCGCCCAGCAGAAACAAGAACAACATCAGCTTCAAGCATGGTTTGCTCTCCACCATCTGCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:7438:1941 1:N:0:CGATGT\nNATCGGAAGAGCACACGTCTGAACTCCAGTAACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAGCAACAAACAAGAATGCTCTCCCCGCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:7281:1952 1:N:0:CGATGT\nNTCTTCTGATTCGATTACATTGGGGCCTGCAAACAGAAAGAATGGTTCTGCTGCTTTCAGGTGGTTGTAGAGCGCCGTTGAAGAATCCATGTTTCAGCTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7388:1963 1:N:0:CGATGT\nNCCTGCTGCCTTCCTTGGATGTGGTAGCCGTTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAATCCCATGTCAGGATTGGGTAATTTGCGCGCCTGCTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7352:1966 1:N:0:CGATGT\nNCCACACTTACCCGGAATGCCTATTGTTTATGCAAGTGATGCGTTCTTGAAACTGACTGGCTATGCCAGGCATGAGGTTCTAGGCAACAGACATAGATTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7463:1968 1:N:0:CGATGT\nNTGATTATTTGCAGAGATACTTTCAGGTGTAGACTTCAACAATGAACTGTGTGATTCCACAGCTCCATCATTCACCATGGAACCACTCCTACCACTTGCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7496:1993 1:N:0:CGATGT\nNGCACATGAAAGCATCTTGTTGATACGAAGGACATGGAATGGATGCACCCTAACACGTAGATGGAAAGCATCCTTTCCAGCAAATTTAGCCATGTACTTGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7671:1925 1:N:0:CGATGT\nNATTAATCCTTTTGTGTCCCAAATTGTCCAATTACTTTGAGGTCCCAATATGTAACACATTGTGGCACCAATGAATGCTTGTAGTATTAGAAAATTGTCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7633:1929 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAACAAGGGAGCGCGACCCTTCGTCCCGGCCATTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:7621:1970 1:N:0:CGATGT\nNTCCACATTCTCTCCGGCATGGCTGATTGGTTGGGCCATCTAATGGAATGTTCTTGCCACTTTTTCAACACTGAGAAGAAGCAGCAAGTGGTTAGAAGAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:7644:1970 1:N:0:CGATGT\nNCTTCCCGGACTCGGGGGTACTGGTGTCCTTCGTCAAGAAGTTTCTTGATCTGGCCGGAGAGGTGCCCGATCACTGCCATTGGCGGTGAGATCGGAAGAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7801:1926 1:N:0:CGATGT\nNTTCTATATCATGAGGTTGATCTCCAACGGGAACCTTAGTAATCCCAGGCAGATCAATGAGTGTTATGTTCACAACATTTGGCGAATAGATCTTCAATCGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7782:1934 1:N:0:CGATGT\nNTGAAATTAACCCATTTGAATGTTGGGTCCATGTAATTTTTGTACATTTCAAGGATTTCATTGTGGCTCACCACACCCGGGTTAGTGAAGTTCCATATGCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7759:1956 1:N:0:CGATGT\nNAGCCGAGTTTGAAAGTGTGAAAGTTATTTCACCACAAGGTGAAGTTGTAAAGCAACCCATGGTTAAGTTAAAGTCGCAATTTCCAACCTCTCCACTTAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:7902:1979 1:N:0:CGATGT\nNAAGATTTTAATTACTTTGACCATTATTTTAAGTTTAATTGAGTTTTAATTATCTTTATTATTGTTATATACTCTATCTATCTCACAAAAAATTTCTCATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:8152:1930 1:N:0:CGATGT\nNGAAGCGAATGGGGGCCGGCGATGTGCCTCGGTCGGATGCGGAACGGCCTAAATCCGGTCCGCCGATCGGCTCGGGGGGCGGACTGACGTGGATTGTGAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8046:1944 1:N:0:CGATGT\nNCGCTTTCACCGGGGAACAAAGGCTGTCCAAGTAGAAGCTCCGCCAAGACACAACCTACAGACCACATATCTATTGCATTTGTATACTCACTAGCACCGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:8344:1941 1:N:0:CGATGT\nNATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAGGAATAGCCAACGACACGTGCACTTGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8408:1968 1:N:0:CGATGT\nNGGAAGTCGAAATCCGCTAAGGAGTGTGTAACAACTCACCTGCCGAATCAACTAGCCCCGAAAATGGATGGCGCTTAAGCGCGTGACCTATACCCGGAGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:8298:1975 1:N:0:CGATGT\nNGAAAAATTGAGACCAATAAATGATGATAATGCGATTAGTACTCCATTTAATGAACTGGGTTATCATGATGTTGTGTTAAATGTTGAAAAAATGAAAGAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8512:1959 1:N:0:CGATGT\nNGGGCTTTCTTTTCTTTCTGAATATCGTTACATCAAACCCTAACCCTATACCACCACCAACCATGTCTTCTAAAGCTGGTGGAAAGGCAAAGCCTTTGAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8618:1971 1:N:0:CGATGT\nNAGCGATTATTATTACATCCAGACAAAGAACCTGAAGATCCAAAATAACAGCAACAATAGCAATAATAATATGCCTCTGATACAGAAATGCCAATATTGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:8628:1991 1:N:0:CGATGT\nNGCCGACCGGTCCGCCTTTCGGTGTGCACCGGTCGTCTTGCTCCTTCTGCCGGCGATACGCTCCTGGCCTTAGTTTGCCGGGTCGTGCTACCGGCGCTGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:8902:1941 1:N:0:CGATGT\nNCCTTCTTCTCGTACTTGCCTGATGCCTTCTCTTTCCACAACTCGAGCTGAGCAATGACTTGGTTGGTGAATGAGCAAGACATGACAAAGCTGGGGTGACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8800:1943 1:N:0:CGATGT\nNTTGAATGCTCTACATACCACCCATCCTTCTTCCTGAGGGGGTCCATTCTCATCAGATTCAAGACGATATTCATGCATAATCCAATCAGATTTTTGACCGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:8804:1994 1:N:0:CGATGT\nNGCCAAAAAAAATGCAGAATGATACAGACAAGTAGACAAGTAGTTAGTCCAACAAAATGTTCAACAAATTATACTTGATGCTGATTATACAACCAGAAAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9333:1929 1:N:0:CGATGT\nNTAGCCCCCACATCATATGGCAGTGATAAAGAATCTTCCATCCCTTTTCATCTTAGAATGTAGAGAAAGTACATGTAGATGAGCATAAGAACGACAGATGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9513:1930 1:N:0:CGATGT\nNTTCTATGCAGATGTGACATGCCGTATCATGAAGAAAAGCAGATGATCTTACATCATTTGTAGAACTAGTGATCCTTGGTTTACTTGGTGTTTTATGTTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9612:1972 1:N:0:CGATGT\nNTCTAACTTACTAGCCATAGACATAACAAGACTAAATTTCTCGTCCATAACAAGATCATCAATGGACTTACCATCACCCATGCACCAATCAAAACAGTGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9547:1985 1:N:0:CGATGT\nNGAGACTTGGGTATCAACAACTAATGACAGAGGGAGCATTTGAGTTCTATCCCATGGAGAGGGAGTTGATTCTCCACGCACTGTCCTCCATGTACCTTACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:9674:1993 1:N:0:CGATGT\nNGGCCATGGAGGCTGCGCTTGAGAGGGGATTGCCAGTAGCTCGTGCTTTCTGGTACGCGCGCAGGCCTGGGTCGATCTTTTTGACTGCTCCCCACATCCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:9828:1968 1:N:0:CGATGT\nNTTGGACCGAAGTAATGGAACCCTTCTTGGTGGTTGTGATACGCTCCTGAAGACCTCCAAGATCAGTTGCCAAGGTTGGTTGATACCCGACGGCAGAGGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9856:1989 1:N:0:CGATGT\nNGTCCTCCATGTCCTCCATGTCCATATCCACCGTGTCCATATCCACCGTGTCCATAGCCACCATGTCCATAGCCACCACTGCCTCCATAGCCACCATGTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10195:1926 1:N:0:CGATGT\nNCACAGCATACATACACTAGAATATTCATGATTCAGCTAAGATGGTGATGAGGGACGCCAGTTGACGTTAATGATAAAAGAACACTCAACCATCTTTCTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10231:1927 1:N:0:CGATGT\nNACACGGGCAACCACCCTCACCGCTCATTCCCATCTCTCCATCCACATACGAGATCTTGGGGGCAACACCGATGACAAGTGCGACGTTGGTGCTAGTTGAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10231:1955 1:N:0:CGATGT\nNCAAAGTTTAAGGCCGCGTGTTGGGCTGAGGCTAGCCAAATGAGTATGGTTAGGATCTTGACTAGGTCTTGTGGGTTGTTGAGTTTGGGCCACCAGCTAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10191:1990 1:N:0:CGATGT\nNTTTGGGGAAGCAAGGTGTAGCGAAACCTAAAGGACCACTCGAGGCACTCCGGCCTAAGTTACAGCCGACTCAGCAGCAAACACGATACAGGAAATCGCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10145:1992 1:N:0:CGATGT\nNCACAGGTAAGTGAAAAGCATATAAGACCGGTACAAGTGAGAACTTGATCATCTTTGTGGATAGGGTGCCACGCGGCAGCTTGCTTCTCTGCATAATAGTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10464:1991 1:N:0:CGATGT\nNCTCGGTGATCATTGGAAATCCTTGGGCATATTTAATGTGACGAACAGACCCAACCTGTTTACCATCACCTTCAATGATCTCAATGCTCTTAAATCTGTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10689:1925 1:N:0:CGATGT\nNTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCGTTCGTTAACGGAATTAACCAGACAAATCGCTCCACCAACTAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10534:1952 1:N:0:CGATGT\nNCTCTGGTCAGTTTCAGTCAGAGCCAGATCCTGAGTGAGCTTCATATTTGCCTCAGCTAAGGCCTCATTACGCATCTCAATCTGACCCAATTCCATCTGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10744:1959 1:N:0:CGATGT\nNTCCAGCAGTTGCCGAATCTGCTCTTCTGCTAATATTTGTTCCCAGCAAAAATCTTTCACGTAGATTAGCAGCTTCATTCAGTCCTTCCTTAGCCCACTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10668:1961 1:N:0:CGATGT\nNGATTGCTAAAGCAGATCTTGGTATAAGAATTCCCAGGTTTTACAAGAGGCTTTAAGAGATCCTCAGCCTCTTCAGCCTCAATGAAAGCACGTTTACCTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10522:1978 1:N:0:CGATGT\nNGGAGGGAAGCGAATGGGGGCCGGCGATGTGCCTCGGTCGGATGCGGAACGGCCTAAATCCGGTCCGCCGATCGGCTCGGGGTGCGGACTGACGTGGATTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:10555:1981 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGGTAAAATTCTGGATTTATAATTTATAATGAAGAGAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10697:1991 1:N:0:CGATGT\nNGGCAGTCTGCTGAGTTGGATCCTTGCCAACCAAAGCAGGGGCAATAATCTCATTAACATTCTTAACAGCCTTAAAAACACCTTTTCCCATGTAATCCGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10885:1950 1:N:0:CGATGT\nNCGATTGTTTAGCCATCACCAATTCAGCACTTGAAACCAAATCTTGATCTTAATCAAATGACCAAATGAACAAACACACCGATTGTTTAGCCATCACCAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10954:1994 1:N:0:CGATGT\nNGCTCACATAACTGCTGAACCCATTCCTTGCTGCAGTGCCTCACAAATGCTTCATCACTGGTGATTGGTTCCTGACGATACTCCATTTTTTTGGTATTTAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:11132:1937 1:N:0:CGATGT\nNGCTCATCTTAGGACACCTGCGTTATCTTTTAACAGATGTGCCGCCCCAGCCAAACTCCCCACCTGACAATGTCCTCCGCCCGGATCGGCCCGCAGAGGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:11180:1951 1:N:0:CGATGT\nNGGCTCTTGAAACCACCAAATGCAGTACCCTTCCAAACACGGCCAGTTACCAATTGGAAAGGACGAGTAGATATCTCCTGACCAGAAGCAGCAACACCTAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11174:1979 1:N:0:CGATGT\nNTTCATATTTCTTCTCAAATTCACCAGAAAGATGCCTCTTGACAAAAGTGGTTTTACCTGTACCGCCGTCACCGACAAGAACAAGCTTGAAACTAGGATAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:11399:1971 1:N:0:CGATGT\nNGCGCCATCCTACCTATTTAAAGTTTGAGAATAGGTCGAGGGCATTGCACCCCCGATGCCTCTAATCATTGGCTTTACCTGATAGAACTCGTTTAGAGCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11506:1954 1:N:0:CGATGT\nNGCATGAGCATTTTGCACACCCTCGTCCCATGTATTAGACACCACCGAGGGAGTTTCAAGAGCTTGGAAGTTTGCCCATTCCGTTTCAACTTGCGACGTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:11818:1923 1:N:0:CGATGT\nNCCCCCTCCTTGCGGTTAAGGTAACGACTTCGGGCATGGCCAGCTCCCATAGTGTGACGGGCGGTGTGTACAAGGCCCGGGAACGAATTCACCGCCGTATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:11986:1927 1:N:0:CGATGT\nNCCCCGTCCTCTGCCACTAACAATAAAAACAGTGTTCTTCGGATCATTGCAGAGGGTGTTCAAGAGCGATATGAGATCACCGCTTGGTGATTTTACAATGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:11889:1929 1:N:0:CGATGT\nNCGCGCCATCCTACCTATTTAAAGTTTGAGAATAGGTCGAGGGCATTGCACCCCCGATGCCTCTAATCATTGGCTTTACCTGATAGAACTCGTTTAGAGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:11908:1946 1:N:0:CGATGT\nNTAGAATTGAATATGAGAGTCCGATATTGTCGGCGATATCCAAGAGTCTGCATAAATGTGAACAGAAGCAAAATCGATGCCGAGGATTTGATGGTTTCTAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:11932:1983 1:N:0:CGATGT\nNCCGATGTTTTTTTACATCTCACAGCTTCGGCAGATCGCTTAGCCCCGTTCATCTTCGGCGCAAGAGCGCTCGATCAGTGAGCTATTACGCACTCTTTCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:11900:2000 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTTCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAGGACCTAAAAGGGACTGGACGACGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12165:1969 1:N:0:CGATGT\nNCTCAGGTCCAATACGTCTAAAATTGTATAAATTCAGTAACTCATCAACTGTAGGCTCCCAAGGAGCAATTTTACTTTTCTCAATTGCCCCATAAGTAAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12387:1928 1:N:0:CGATGT\nNCCAGTCCTGTATCTCTAGACTCCGCTCAACAAGTTATTGCTAACATTGTTATACGAACAGGCACATGTTGCGCAAAGGGCCCGTTTAAAGTCCCAATGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12407:1934 1:N:0:CGATGT\nNGGGGGCTCGAAGACGATCAGATACCGTCCTAGGCTCAACCATAAACGATGCCGACCAGGGATCGGCGGAGGGTACTTTTAGGACGCCGCCGGCACCTGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12364:1941 1:N:0:CGATGT\nNAAAATCCGGAGGACCGAGTGCTGATCACGCCCGGTCGTACTCATAACCGCATCAGGTCTCCAAGGTGAACAGCCTCTGGCCAATGGAACAATGTAGGCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12324:1944 1:N:0:CGATGT\nNCAACTACGAGCTTTTTAACTGCAACAACTTAAATATACGCTATTGGAGCTGGAATTACCGCGGCTGCTGGCACCAGACTTGCCCTCCAATGGATCCTCGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12432:1955 1:N:0:CGATGT\nNAGGTATTGGTTTATCATGGTGAAAAAAGACCGGTATTTTTTTTTGAACCGGGTTCGATTTCAACAAAAGATCACACTTGGGTCGCATAGTTGCAGCAATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:12300:1960 1:N:0:CGATGT\nNGGGGGCATTCGTATTTCATAGTCAGAGGTGAAATTCTTGGATTTATGAAAGACGAACAACTGCGAAAGCATTTGCCAAGGATGTTTTCATTAATCAAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12409:1966 1:N:0:CGATGT\nNTGCAGCTAGCATTGGAGATAACAGTGAGGTCTGATGTGTACTCGTGCTCGTTAACACCAACAACGAACATAGGAGCATCCTTGCTGGGAGCAGAGATGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12986:1925 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAATTTTAAAAGCCAAGTCCTCCATCTGCATCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12797:1952 1:N:0:CGATGT\nNAGATGATGTGTTGATTATGCTACTTCCTTCTTTCATGTGTGGCAGTGAGTACCTTGCCATGAAGAAGTAAGCGAAGATATTAGTTTCAAAAGTCTCTCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12954:1969 1:N:0:CGATGT\nNTACGGGTACCACCAGTAACATGTCGCCTTGTTTATGGCCCGATTTGATGTACTCGACTAGGCCCCTTAACTCCCAGTTGGGTATTGCTCGCTTGTTCATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13082:1923 1:N:0:CGATGT\nNTCAAATCTACCTTATACTTCGCAACTTCACACTATAAAAAAAAAATAATAATAATTTAAAATAAAAAAAATTAAAACTTAAAAAATAAACCTCAACTTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13153:1957 1:N:0:CGATGT\nNTTCTGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAGGACACCTGCGTTATCTTTTAACAGATGTGCCGCCCCAGCCAAACTCCCCACCTGAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13035:1969 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAATATAACAGACGTGGTGAGAAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13125:1977 1:N:0:CGATGT\nNCCAACTACTACGTAGACAAAGTTACATTGAATCCATAATACCTACTAAAGTAAGATCATCAGTCGGACACTTAGCGTGCAGTACATGTAGAAGAAGAAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:13364:1928 1:N:0:CGATGT\nNAGAGAGATTCCAGCCTTGGCATCAAAGATGCTTGACCTGTTGTCACCAATGAAGTCGGTGGACACAACATCATCCTCAGTGTAGCCCAAGATACCCTTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:13315:1990 1:N:0:CGATGT\nNCCCTGCTCTCTTTTCTAGCCTCAGCAGAGTGCATGGTAATGCATGCATTGATCAACAGATTTTCCAACTCCAGGGTTTCTATTAGGTCAGAATTCCATAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13724:1970 1:N:0:CGATGT\nNGGTGCAAACAATCATGGAAGTCATGACCTATCTCTTAAGCGAATAACACTAGATGATACATGTGACCGAAATGAGGCCACATCCACCTACCAATTTCTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13917:1935 1:N:0:CGATGT\nNTCCAAACCACCAGCATTGCCAAAACAGTAGCTACAACTACGACCCCAGCTCGCCTCGTTAACCTCAGTATCGACAACTGAGTTGCCGATACTGCTAACTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13878:1958 1:N:0:CGATGT\nNAACCATTCATCCATATCATCCACACTATTTAAGGCAGTATCAATCCCTTTCAGCACCTCTTCAACTAAAGGTTCTGTTTCCAACATAGCATGCACATTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:13779:1965 1:N:0:CGATGT\nNTTCAGACAACTTTCCATTCCCACCATCATATGGCGATGCTTGTCTTCCAACCCATCTCTTCTCTTCGTACTTTGCACGAATGAAGTTTTCAATTCCAACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13965:1981 1:N:0:CGATGT\nNCGGCGGAGAGAGGTGTTCGCGCGTCGCAGAGTGGATCAGTCGGCATGTCGCAGGGTGGATCGGTTGGCGCGTCGCAGAGTTGAGCAGTCGGCGCGTCGTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:13776:1993 1:N:0:CGATGT\nNGAACGGAATAACCAAGCAGTAAACTATACAAAATGCCTACCAAAACCAATGAATCAGGAGCTTTCTTGCATCACCGCTTCACTTGGATTCATAGCAACAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13800:1997 1:N:0:CGATGT\nNCGGGTCACTTGAGAGACACCTCAAGGCGAGATTAGCTACCCTCATAGCATGTTCTAGAGAGTATTGTCCTTCGATACGAGGATCAAGTACCCTAAAGATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:14047:1993 1:N:0:CGATGT\nNCCGCCGACATCTCCGGACTCCCTAACGTTGCCGTCAACAGCCACGTCCCGGTTCAGGAATCTTAACCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14410:1939 1:N:0:CGATGT\nNCTCGTTGAAGACCAACAATTGCAATGATCTATCCCCATCACGATGAAATTTCAAAGATTACCCGGGCCTATCGGCCAAGGCTATAGACTCGTTGAATACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14342:1950 1:N:0:CGATGT\nNGCAAACATTCTTTGCCCAATCTACAGGTCCTTGACCGTCAAATACGCCGGCTCCTTTGCCGCCTTGAAATGTCAACCCACTGAGTTGGTAAATCTTGATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:14443:1960 1:N:0:CGATGT\nNCACAACTTCCCTTTTCCCAATGGCAACCACATTCTCTCTCCTCCCATCAACCACCTACATCCGCCACACGCGCCACCGTCTCAGCCACCGTACCAAACCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:14411:1982 1:N:0:CGATGT\nNCTTTCATGAAAAAAGGCTGAGAAGTGCAAAGTCCAGTTTTTTGAAATTCATCAAGAAGTTCTTCAGAAACCCTTGTTAATGTCAATGCAGAAGGCTTTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:14373:1987 1:N:0:CGATGT\nNCCAACCCCAAATTAAAAAAAAAAAAAGAAAAAAAAGGTGAAATTACAAATTTGTCCATCCAATTCATTTTTTTTTTCATAAGAGATATAGATAGAAAAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14689:1957 1:N:0:CGATGT\nNTAGAGGAGAGAAACCTGGGTGTTATCATCTGGATTCTTCAATATAGCTTCTACTACCTGAAGCATTGGAGTAATGCCAGTTCCACCAGCAACCATGCCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14788:1930 1:N:0:CGATGT\nNGGCCCGCCCAGACTTTCAACTTCCTTATGAACAGAGCTGGGCATCGACGGGCCCACCTGGGACCGTTGTGTCAATACCATCTTTCCAAGAGGGGCCCCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:14875:1960 1:N:0:CGATGT\nNACCACCGTCCTGCTGTCTTAATCGACCAACACCCTTTGTGGGATCTAGGTTAGCGCGCAGTTGGGCACCGTAACCCGGCTTCCGGTTCATCCCGCATCGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:14941:1978 1:N:0:CGATGT\nNCCTGTGGTAACTTTTCTGACACCTCTAGCTTCAAATTCCGAAGATCTAAAGGATCGTTAGGCCACGCTTTCACGGTTCGTATTCGTACTGAAAATCAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15221:1937 1:N:0:CGATGT\nNACATTTTTAATGTCGAGGCACTTCCTTGTTGACATTTTCCCACGCAATAGATGTTGCAGGCAACATTGCATAACATAAACTGAGATCTTGGAATAACAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15119:1960 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAGAAGAAAATAAGCGACACAGCCTCATGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:15092:1970 1:N:0:CGATGT\nNCAAAGCCTTGTTATGCTCGGCCCATTTTCTGTTGAGCTCTTCAAGAAACAAAGCTCCTTGAGCAGCCTCTATGGACTTGGATATTTCCTTCAAATGAGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15224:1976 1:N:0:CGATGT\nNTGGGGTTTCATATTGAAATAATCCAAATAGTAAAAAAAAGATAAAAATGAGATAGATGGAGTAAAATTTTAAACAAAACACAGTATAAACATTAATCATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:15243:1990 1:N:0:CGATGT\nNGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGGGAGGCGGAGTGAGCAGGCCTTCCGACCCAACAAAGTATCAAGCTTGCGCATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:15082:1998 1:N:0:CGATGT\nNATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAGTAAACTTCACTGGGTATGCTCCCTTCGATAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:15381:1935 1:N:0:CGATGT\nNCCTACCTCCGGCTGACCCGTTTCCAGGGTGGGCAGGCTGTTAAACAGAAAAGATAACTCTTCCCGAGGCTCCCGCCGACATCTCCGGACTCCCTAACGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:15393:1966 1:N:0:CGATGT\nNAAAAACACAGGACTCTGCTAAGTGGTAACACGATGTATAGAGTCTGACACCTGCCCGGTGCTGGAAGGTCGGAAGGAAAAGTGTTATAAGCTTTGAATGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:15619:1933 1:N:0:CGATGT\nNGGCTAGTTAAACAAGTATATACACGGCAGATGGAACATGACCTTTCAATAGTAGGACAACATACTAGATTTCCCTCTCTCTTCTTTAATCTATGTAGTAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:15746:1943 1:N:0:CGATGT\nNTCGAAATCAAACTCCACTTAATCAAATTGAATAAAAACTGGTCTGAATTTCCAGCCCAAAAATTATCGTACCTGAAATATCCTAGACCCAACGTTGGGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15709:1964 1:N:0:CGATGT\nNTGGAATCGAGAGCTCCAAGTGGGCCATTTTTGGTAAGCAGAACTGGCGATGCGGGATGAACCGGAAGCCGGGTTACGGTGCCCAACTGCGCGCTAACCTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15574:1977 1:N:0:CGATGT\nNTGCGCCTGCTGCCTTCCTTGGATGTGGTAGCCGTTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAATTCTCCGTCACCCGTCACCACCATGGTAGGCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:15917:1981 1:N:0:CGATGT\nNACGCTTGAACCTTGCAATACCACGCTGCTCCAATCAATTTATGCATCATCAAATCATATAACCTTCTCCACGATGAACACCACTGACCATACTGTCACAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15836:1987 1:N:0:CGATGT\nNCTTGCGACCATACTCCCCCCGGAACCCAAAAACTTTGATTTCTCATAAGGTGCCGGCGGCGTCCTAAAAGTAACATCCGCCGATCCCTGGTCGGCATCGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:16205:1941 1:N:0:CGATGT\nNTGGAATTTGGTGCAATAAGGTTTAAGTTAAGCTAGGACAGGGCCTGCTGCAATAGCATCTCCTGGCAGCACCTCCACAAGCTCCTTCGGGAAAACCCTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:16409:1934 1:N:0:CGATGT\nNGGACAATTTGGATTGGCTGAGCAGGGCCACCAACTGGGCCAAGTTTAGCGCAACTGCTGGATTGGGTGTCATCCATAGAGGTCATCTGCAGCAGGGTCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:16670:1940 1:N:0:CGATGT\nNCTCAAGGTTTCCACGATGTAGTTAGCATAAAGATCCATGGAATGCTGTATTGCATTATAAGCGGTAGTTGCTGGGAGAAATTCATCAACTGCAACATCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:16932:1937 1:N:0:CGATGT\nNAGGCATTCAGCAACACATGGTACCCCTTCTCCAACATCCTTAAACATGCTGAGATCAAATCTTCATAAATTACCCATGTACTTTGTCAACCATAGATTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:16753:1989 1:N:0:CGATGT\nNGGAAAATTTCCAACCGGCAACAAAATATCAATAATGTACACAAAGATGCCTTCTTCTCTTCCGAAACAGAGGGCTAGTAACTTAATCTAACACCAGTTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17022:1938 1:N:0:CGATGT\nNTTTGAATTCACATATTGCTTTGAAGGAAGTGATCCAAATCATCAATAATGGTCCCAAATTCAAGGATGCCTCTTTAATAACAGTGCACAGATAATAAATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17015:1979 1:N:0:CGATGT\nNCGGAATCGAACCCTAATTCTCCGTCACCCGTCACCACCATGGTAGGCCTCTATCCTACCATCGAAAGTTGATAGGGCAGAAATTTGAATGATGCGTCGCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:17401:1957 1:N:0:CGATGT\nNAGAATATTGCTCAAGAAGAACGATTGCGTGGTGGCCAGAAGGACGACCGAGAGATGATGATGGCATTTAAGGTTCAATCAGACACACGGGGAAAATTAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17375:1968 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGCATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAGTTAAATAGGGCGTCGGCGGACAGTCAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:17446:1974 1:N:0:CGATGT\nNTTGACCTCCCACTGCGAGGTCGAAGAATACCTTGGGGTTCGACATTTGTACTTTTGATTTAGGAAATTAGGGTTTTGAATTTGGGATTTTGTATTTGAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17277:1978 1:N:0:CGATGT\nNTTGGGCACCGTAACCCGGCTTCCGGTTCATCCCGCATCGCCAGTTCTGCTTACCAAAAATGGCCCACTTGGAGCTCTCGATTCCGTGGCACGGCTCAACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17493:1991 1:N:0:CGATGT\nNTCCTTTAGCTTTAACTAGTTTATCACAGTGACTCCACTCTCCATGAATGGTTCCTTCCTACACAACTCAAACCCTACTCTTCTTGGTGATCAAAGAAACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:17548:1932 1:N:0:CGATGT\nNTAAGGAACCACGAGGGGGACATAATCACTTGGTTCGCTAGACCAAGTGGGGAAAAGGAGATAAACAAGGCAGAGCTCGAGGCGATCTGTATAACCATCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17834:1938 1:N:0:CGATGT\nNTTGGCTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACTAATTAGATGACGAGGCATTTGGCTACCTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17812:1949 1:N:0:CGATGT\nNCATCATTATCGGTGTCTACTTCCATTAATATCTCCTTAATGCTGTCCTCGTCAGCTATGCCGTACTCCATCATCGCTGTTTCTAGTTCATCTGTTGTATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:17854:1960 1:N:0:CGATGT\nNTGAAGTTTAACAACATCTTCTCATGAGCATAGCTACTGTTTGCATTTTAATGATAAGACTACTTGATTCCAAACTAAAACAGAGAAGCATTTAATCAAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:18152:1936 1:N:0:CGATGT\nNGCCAGCGCAAAGGCCGTGCGATCCGTCGAGTTATCATGAATCATCAGAGCAACAGGCAAAGCCCGCATCGACCTTTTATCTAATAAATGCATCCCTTCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18117:1975 1:N:0:CGATGT\nNGGCAACTCTGTGTGCTGCAAGACGTAAGTAGGATGTAGGAAAGTGTTGGAACTCAAACTGAAGTTGTTCTGGACTCTGCAAGAACTGCTGAATATCGAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:18281:1959 1:N:0:CGATGT\nNCTCGGTCCATCTTTTCAATCTGGACTTCTTTTTCTTTCAGAGTAACAGTGACATCGCCCTTGGTTGAAACCAAGCTCATAGTCTTTAACTCTCGCTCTAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18421:1961 1:N:0:CGATGT\nNTTTAACAATTTTGTAATTTTTTTGCATATCTAGATGTGCAAAAAATTATGAACATAACATTATTCTGATTTAGGTTTGGTATTGGTGTTTTCTTTACGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18617:1931 1:N:0:CGATGT\nNGAGTCAAGCTCAACAGGGTCTTCTTTCCCCGCTGATTCTGCCAAGCCCGTTCCCTTGGCTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:18982:1983 1:N:0:CGATGT\nNCAGAAATTTGAATGATGCGTCGCCAGCGCAAAGGCCGTGCGATCCGTCGAGTTATCATGAATCATCAGAGCAACAGACAAAGCCCGCATCGACCTTTTAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19076:1949 1:N:0:CGATGT\nNACTGCAACTCTGGTGGCCAAATTCAACCATGACCTCACACCTCCACAAGCAAACCAGCAACAACCTAAACTAGTAAGCGTGTTAAAAATACAACCAGAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19033:1953 1:N:0:CGATGT\nNGTGACATCAACTTTTTATTAAATGCTCCTATTCATTATAAGGCGGGTTACAAGTCTCTTGTTTCCGTCTTCCATCTGTTGCTTCGCTAGTGCACCTTAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19145:1971 1:N:0:CGATGT\nNGGACGGACTGGGAACGGCTCCTTTTGGGGCCTTCCCCGGGCGTCGAACAGTCGACTCAGAACTGGTACGGACAAGGGGAATCCGACTGTTTAATTAAAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:19003:1988 1:N:0:CGATGT\nNAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCGTTCGTTAACGGAATTAACCAGACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19450:1968 1:N:0:CGATGT\nNTCAGTTCGCCAGGTTGTCTCTTGTCTGCCCATGGATTCAGCAGCAGTTCGAAAGGTTGACCTATTCGGGAATCTCCGGGTCTATGCTTTTTTTCAACTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:19743:1963 1:N:0:CGATGT\nNTATATTCTTATTTGTGGTATTGACTTTCAACACTCACAATGGGCAGAAATATTATAACATGCCCCTCATACGAAGGCCCGATGTGAGCTGAAGATGTGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19669:1995 1:N:0:CGATGT\nNAACTTGGCACTTGGCCCTTTTTTCCACTACCATAATACACCTTGTGTTGGTCAGGAGATGAAAGGGGCAAGTACCAAGCAACAACCCATTCGAGATCCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19940:1931 1:N:0:CGATGT\nNCCGGGTAATCATTGAAATTTCATCGTGATGGGGATAGATCATTGCAACTGTTGGTCTTCAACGAGGAATTCCTAGTAAGCGCGAGTCATCAACTCGCGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19890:1976 1:N:0:CGATGT\nNTCCGGAATCGAACCCTAATTCTCCGTCACCCGTCACCACCATGGTAGGCCTCTATCCTACCATCGAAAGTTGATAGGGCAGAAATTTGAATGATGCGTCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19845:1984 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19811:1989 1:N:0:CGATGT\nNAGAAAAGCTCCAAAAGTAATTGGAGATTGAGGACATACCTTATCCGTCGGTTCATCATCACTCACAGGAAGAATCACAGGGGGGTTACGATTACCTTGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:20197:1937 1:N:0:CGATGT\nNTCCTCATAAGCCCCACCCAAGAACATCCCCAGATAATAACCACCCCCACAGCCACCATTTCCTTCTCTTCCTCTCTCCCCAATGCCATGAAGGAGCAAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:20385:1965 1:N:0:CGATGT\nNCCGGTTGGTGTTGTAAGATCTGAAGTTAGTACCAACAGCATCATAAACTGCCTCATCAGTTCCTTCTGATGCAGCCTTTTCAATAATACCGAACCTTTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:20297:1996 1:N:0:CGATGT\nNCAAACTTGTCTTTTCCAACACAACCAATGTAACTTGTTGCACCGGGTTTTTGGAGCATCCACTGGGCAACTCTGATTGTATTTTGAGTAGAACCTCCAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:20580:1968 1:N:0:CGATGT\nNAACCTCTTTACTCGTAGTCCCACCACGACTACCATAACTCCACGGTTTAGCCAATGTAGACCATGAATACGAATCCCCACCCCAAACATCCAGATCGGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:20775:1992 1:N:0:CGATGT\nNCCGGAAATTCGGTTGGCAGTTATTTTCTTTCCATTTTATCCACTTCTGCAATGACTCAGGCGAACTAAGGTTCGTGGGTCCCGGAAGACCCATTGAAATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:21189:1926 1:N:0:CGATGT\nNACTACCTCCCCATGTCAGGATTGGGTAATTTGCGCGCCTGCTGCCTTCCTTGGATGTGGTAGCCGTTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:21144:1931 1:N:0:CGATGT\nNAACTTTTCAACCAAGTCCTTTGACAACAAGTTGGCAACGACCGCGTGATTTCTACAAGAGTCGAAACCATGAACATAGATGAATTTGTACTTTGCTTTAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:21129:1969 1:N:0:CGATGT\nNAGGGAAGATACACCCATGCCATATCCATTTTTGACCAGATTTTAAAAGAGGATCCAACTTACCCAGAAGCATTGATTGGAAGAGGGACAGCGTATGCTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:21013:1990 1:N:0:CGATGT\nNTTGGCGATGCTTTCTCAAAATTTGGGGCTAATGAACAATTGTATTGCCCTCTCCCATTTATCAACAATGTCTGGGGTTCGCCGACCCAGCGGAAAGGCAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:21251:1925 1:N:0:CGATGT\nNTGGACTAGGTGGTGAAAAGGGGGTGGGGTCCACAGCTGTTTCGAGGGGTCTTTCAGACTGGTAAATATCACCACTCAAGTAATCAAACGAACCTGCATCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1467:2009 1:N:0:CGATGT\nGTCATCGTCCTCATCGCATTCCCCTTTTGTGGAACTGTTTCCTTTCATTTTTTTTTTTTTTTTTTTTTTTTTTTTTATAATTTTTAAAAAAAAAGCATCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:1400:2057 1:N:0:CGATGT\nCCCAAACTCTGAAAACAGCTCCTTCAGCTTCTCATCATCAATGCTATCATCCAAGTTTTTGATATACAGATTAGCACCCTGATTCTTATCAGCAGCTTCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:1418:2233 1:N:0:CGATGT\nGGGCAAAGTACAAGAAAGTTGGGTCACTGGCGCCATCCTTGTAATAGGCAAAGACGCAAGCACCATCATCATGCATGCTCTCACCGACGAAGATCTGAAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:1728:2015 1:N:0:CGATGT\nTTTGGTTTTTCATTGTTACCAGAGTCGGGTTCGGGTATGGCGGGGGCCTGGAGGGGGGGTGGTTTTTTTTGTTTGGTTTTGTTTTTTTGTGTTGTTGGTGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:1627:2074 1:N:0:CGATGT\nGCCTGGTCCGAAGTCAGAAGGGATATTTGAGACGGCTACGAATTTAGGGCATTCAGGTTGGTTTGGTTTTGATATCATGGTTAGACTGCCGAAGAAGTAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:1657:2079 1:N:0:CGATGT\nTCAGTATCGCTTCGGGCCTCCACCAGAGTTTCCTCTGGCTTCGCCCCGCTCAGGCATAGTTCACCATCTTTCGGGTCCCGACAGGGATGCTCTCACTCGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1724:2093 1:N:0:CGATGT\nTGGTGGATGTGAGTTGCGTGGTATGATGCCGGGGTCACGGGCTGAAGTGAATAAAAGAAGCACCAACACATGGATAGTGAAGAGAATTGCTACCACTAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1651:2104 1:N:0:CGATGT\nCTGTGGATTAGAAACCGGTGGAGTGTAACGTTCTTTACCGCCGGGTTTAGAAGAAGCATTGCCGTACCAAAGCATGCCTAAGATCGCGATAATCAAGATCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:1598:2205 1:N:0:CGATGT\nCGGGGGTTTGCTGATGAAATTGAGGGGATTTTGTGTTAAAATGGATCACCTAGGGTTTTGGAAGTTTGTTACTGTGAGGAAAAAGGAACTTGACTTGTTAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:1665:2216 1:N:0:CGATGT\nCTCCTTAGCGGATTTCGACTTCCATGACCACCGTCCTGCTGTCTTAATCGACCAACACCCTTTGTGGGATCTAGGTTAGCGCGCAGTTGGGCACCGTAACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:1737:2233 1:N:0:CGATGT\nTTCACGGATCATCTCATCGACTTCTTCATCGGTGAGCTTCTCCCCGAGGTTTGTCATCACATGACGTAGCTCAGCAGCTGAGATGAAGCCATTCTGGTCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:1520:2247 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGCCTTCTGTTTGAAAAAAACCACCGCCACTCTCTCCCCCCTCTCCCCCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:1928:2148 1:N:0:CGATGT\nGAGCAGTATAGTTAAGGTTGGCCTTAGCCCATGGAACAACACGGCAAACTGCTAGCGTTGGACCAGCAGCGACAACAGAAGTGATAACAGCCGCTTTAGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:1772:2182 1:N:0:CGATGT\nTTGTCAATAGCTGTCTTGAGCAACTCAAGACCCTCCTTGTTCTCCTGAATGTTAGGAGCAAAGCCACCCTCGTCACCTACATTGGTTGCATCTTGACCATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1894:2201 1:N:0:CGATGT\nACCAACTTCTGTTGCGATTTCGATGCTCTGCCACCTTGGAATTCATGGTCTGCTTTTCTACAATCATCCTTATAATCCACCTTGGAATTTGTTTGATTATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:1966:2247 1:N:0:CGATGT\nAGACAAAAGTGCTTGAGCAGAAGAAGAATGAGGGTGAAGAACCAAATCATAAGGAGCCCAAAGCCCATCAACAGGACAAGGTCTACCAGCATCAATCCTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2114:2022 1:N:0:CGATGT\nCCACGCTTGAGATCCTTCACAGCAACGTTCTTGACATTGAAACCAACATTGTCACCTGGAAGAGCCTCAGGAAGAGCTTCATGGTGCATCTCCACTGACTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2137:2035 1:N:0:CGATGC\nCCCCGCTATCACCGAGAATAATGACTTTCAAAAGAGTTCTCCTTCGCGAGGACATCCTCGCTGGGCTTGCAGTTGCAGAAGTAGAATTCGACCGATCCAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2051:2037 1:N:0:CGATGT\nTGAAAACTTAAACAAACCCTGCGGCTCACACTTAACTGAGACATCCTTGGCATCAGGTAACACAACTGTCAAATACAGTTTGTTGGAGCGCTGAGCCCAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2209:2090 1:N:0:CGATGT\nTCAGTCATCATGAGTTCAAACAATGGAATGCAGGTAGTCAAGTACATCTCTCAGGGGGTCGGATATGGTAGCATATGAGTTTACAGGCCCTCCATCAATAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2111:2123 1:N:0:CGATGT\nGGCAGCAACAAACCCAACCAAACGAGCGTAGAAATCCATAGCTTACAGTGAGCGTAAAAGCAAAAATGACGCAGCAACAGCCAACCTCACCTACTGCAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2227:2131 1:N:0:CGATGT\nTCGGTCAACCTTACACTTAGCACCAGTAGTAATAGCAGGAGTTGGATTCTTAGCGGTAGCATTTTTAGGAGGAGATCCACGGATCCCTTGACAGTTGACCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2050:2154 1:N:0:CGATGT\nCAGGAGTATTTAGCCTTGCAAGGTGGTCCTTGCTGATTCACACGGGATTCCACGTGCCCCATGCTACTCGGGTCAGAGCGTAAGCTAGTGATGCTTTCGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2012:2202 1:N:0:CGATGT\nGGCGTACAGGTTTGAAATTTGGGAGTTGGGCCATGCAAGAATGAATCAAAAGGAGTGAGTGGGGGAGTCATTATCAAGCACTCTTTCTTTTTTTTGTTTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2134:2227 1:N:0:CGATGT\nCGAACACGACGGGGCTCTCACCCTCTCTGGCGCCCCTTTCCAGGGGACTTGGGCCCGGTCCGCCGCAGAGGACGCTTCTCCAGACTACAATTCGAACAGCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2125:2243 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAACGATTCTCCAGACTCCAATTCGAGCAACG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2336:2003 1:N:0:CGATGT\nNTGAGGTTTTCGACGTTCTTAGCAAACTTATCCGTAGTGTCAGTGGCAAACAAGTTGGATTTGGTCAGGTCATCGTTTGTTATGGCTTCCCGCTGGCGATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2412:2046 1:N:0:CGATGT\nGATTTATTCCATGAGCTATTTAGCCAAAATGTGCATCATTTGACCAACATTATGCCTCACAAAGTTCACACTATTGATGTGCATGAGGGTGAAATGGGCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2382:2056 1:N:0:CGATGT\nCTCGTTTAGAGCTCCAGCTATCCTGAGGGAAACTTCGGAGGGAACCAGCTACTAGACGGTTCGATTAGTCTTTCGCCCCTATACCCAAGTCAGACGAACGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2467:2115 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACACACATACACGCACTCTATACCACTCTTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2262:2140 1:N:0:CGATGT\nTGCGATTTGAAGGTCTAGAAGTTAAGTACCAAAGGCAATAGCACTGATCAATGACACAGGCTACGAAACTCCGTGACTACTGTTAGAAATATAGCCTCTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2307:2170 1:N:0:CGATGT\nGTCAGTAGCTAGATATGGATAAGGGGGCATCGAATACATATGGTGAGCTACAACAATAGTTAAAGAACCTAACATAGCTAGGTTAAGCGATAATTGAGCAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2371:2189 1:N:0:CGATGT\nCTTACACGTGGCACCATCTTGTACCCCCAAGACATCGTAGAGCGACTTCGTATGAGTAATGGCCGTGGCGCTTGGTGGGGTGTCCACGGTGGATGACACGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2351:2193 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAGGAAGAGCACAGGTCTGAACTGCGGCCACCGATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2366:2209 1:N:0:CGATGT\nCGGCCCACTTGGAGCTCTCGATTCCGTGGCACGGGTCAACAAAGCAGCCGCGCCATCCTACCTAAAAGTTTGAGAATAGGTCGAGGGCATTGCACCCCCGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2402:2214 1:N:0:CGATGT\nCTTGTTCGAAAGATGTAAAGAATCAAGTAGTTGAGTAACTACGTCCTCATTGTTAAAAGGCACATCCAAATTCACCTTAACAACCATATTTTCGAAAGAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2427:2231 1:N:0:CGATGT\nATCGACTACGCCTTTCGGCCTGATCTTAGGCCCTGACTCACCCTCCGTGGACGAACCTTGCGTCGGAACCCTTAGGTTTTCGGGGCATTGGATTCTCACCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2653:2019 1:N:0:CGATGT\nCTCTGACTCTACTTCGACATTTGATCTAACACCGGCTCTGGAACTCCGAACAATCTGAACTGACTCAGCCTCTGTCACTTCATACATAGTAGAACGTTTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2530:2059 1:N:0:CGATGT\nCTAACCTTTTTGTTGTCCTTAAATACGACAATACCACTTGATGAAACACCAATCAAAACGTTTGTTTTGAACTGATCTTTGGCATCGAAAAATTCCACCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2526:2076 1:N:0:CGATGT\nCAAACAAGCAGAATATGTCATCTTTCACTGCAAACGACCTGGGGCGAAGAGGGGATTCACCGTCATGAGTAAATGCAAGCTGACCATAATCACCAACGTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2581:2077 1:N:0:CGATGT\nGTTTTGCAGTTTCTATCACTTCAGCAACATCAGCTTCTTCTGATATCATAGTTGTTAATGCAGATTTCATTTCTGTCAGCTTCACCTCAAACATCTTTTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2743:2082 1:N:0:CGATGT\nCCAAAACCACTAGCAGCAGCCATTGCTAGTGTAAACAACGCAACTGTCATAACTGAAACTTTACTGCCACCACCTTTCACCTCATCAAAACTGTCAGAAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2681:2104 1:N:0:CGATGT\nGGCGCTTTGCTGGTATGGTCGATGCATCCACCTCTCCAATGTAGTATTTCTCCATCATCTCTCTCGCTGAGTCACTGTGGCCCACATCTTCGAAATCATTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2533:2124 1:N:0:CGATGT\nGTATAGGTCACGCGCTTAAGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCAGGTGAGTTGTTACACACTCCTTAGCGGAATTCGACTTCCATGACCACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2715:2146 1:N:0:CGATGT\nCACAATCTCGAGAAGAAAAGAAACTACAAGATCCTGAGATACTGAATGGATAGACATAAACAGCAATGAGAAAGAAGCACACCATAGAAACCAGTATAATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2654:2168 1:N:0:CGATGT\nCCGACCCATCAATTCATCTTCTTCGTATACGTCGTCGTTTCCGATATCAAATTCCAAACCCGTGAATATGAATACGAATACGCAAACTTGGCAACCAGGTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2532:2242 1:N:0:CGATGT\nCTCTGATACAAGAATAGAAACAGCACTGATGGCAGAGAAAACAGCTTTATAGGCAGTCTTCAGAGCTTCATCTAGAGTTACCAAATCCATCTTTAGCAATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2687:2249 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAATGGGTATTGCGCGTACGCTTCCAACCATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2973:2014 1:N:0:CGATGT\nCTCATAAGATGTTACACAGCAGAATCCACCTTCATAAAACAAACAACAAAATTCCCTAAGTGCTCAAATTCAAAGCAGAAAACATTCAGAATATAGACTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2896:2026 1:N:0:CGATGT\nGTCACCCTTCGCTCCAAACTAGTGTATGATGGCATTGTTAATACCATTTTGTACCCCTTCATTGCTGCCATAAAGGCCATACTGATCCCCATATTCCCTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2773:2071 1:N:0:CGATGT\nTCCAAGCTTTCTTCTTTCCACCAGTGGCACGTCTTTTGTGCATGGAATCACGTGATATACCCATGTTTGGAAAAGGGAGATAAAACTTGGGTTCGTAGTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2909:2147 1:N:0:CGATGT\nCTCCGAAGAGAAATCCAGCAGCCTGGTCTTCGTTACCATCAAAAAGCTTGAGAGCTTCGATCACAGCACTCCTTTGAAACCCCAGCTCCACCCCGTTTGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2877:2172 1:N:0:CGATGT\nGGCAGACCTGTCAACCTTTCATAGTTGAGATGGCAAGTGCAACGACGGGGTGTTTGGGCTGCTGTCCGACTGTTCTTGTGGATAAATCTGCCCTGCTAATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2872:2190 1:N:0:CGATGT\nCGGTAGATCCCTCGATGACGTCAATAAGGCCATCGGTACCTTTAGCCAAGGAGCAATGATCAATCCAAATATTTGAAGATTGAAATATAGAGATGCCATCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2881:2226 1:N:0:CGATGT\nGCCGAAGGAGCCTAATGAAGATGGACTGAAAGGCATATATAGAGTGGATGTTGAAATTCCTGCAGATGACTGGGTCAATATAACGAAGTTCTATGATGTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2789:2239 1:N:0:CGATGT\nACAACTTTCGTTCTTGATTAATGAAAACATCCTTGGCAAATGCTTTCGCAGTTGTTCGTCTTTCATAAATCCAAGAATTTCACCTCTGACTATGAAATACG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2815:2240 1:N:0:CGATGT\nGGATGCAAGACATTCAGCAGCAGCTTGTAACATGTCGTCAGTAATCAAGCGAGCACCTGAAAGCAACGCTCCTAAACCAATCCCAGGAAACAGGTACATAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3184:2005 1:N:0:CGATGT\nNAATCGTTGTATGGTGAGACAGTTATCCTGAATCCGTGCTTCATATGGAGTAATATGGATATATCAGGCTCGACAACTTGTCCCTCAACAGCTTGTATGTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3120:2036 1:N:0:CGATGT\nGTGGTGCATGGCCGTTCTTAGTTGGTGGAGCGATTTGTCTGGTTAATTCCGTTAACGAACGAGACCTCAGCCTGCTAACTAGCTATGCGGAGTCACACCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3192:2068 1:N:0:CGATGT\nGGTTGAATGGGGGGCCCGCAGGCCGACGCCTTGAGCGCGCAGGTGCCGTGGCACGCTGTAACAGCGCGCGCTGCCTACCACAATCGCGAGGACAGCACTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3054:2083 1:N:0:CGATGT\nGGGAGCTTCGGCGCAAGTGAAATACCACTACTTTTAACGTTATTTTACTTACTCCGTGAGTCGGAGGCGGGGCACAGCCCCATTTTTTGGACCCAAGGCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3224:2088 1:N:0:CGATGT\nCTAAGGCCGACTTTCGTCCCTGCTCGACGGGTGGGTCTTGCAGTCAAGCTCCCTTCTGCCTTTGCACTCGAGGGCCAATCTCCGTCCGGCCCGAGGAAACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3248:2170 1:N:0:CGATGT\nGGGGCCTAACCTTGTTCTTCCACAGGTTATGGTAGGAGGCAGAATCTGCAGCCCTTTGCATGACCTCAACCACAACAAGGTGGTCGGTCAATGGCCTAATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3163:2193 1:N:0:CGATGT\nCTACGAAGCCCAAGATATAAAAGCCCAGTCCAACGTGGACGCCATGACCACCCTATAATTAATCCGATCATGACGGCGACCCATATTGGTACTGCACATAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3237:2212 1:N:0:CGATGT\nATTGGCCAGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCGGCACTCGGTCCTCCGGATTTTCAAGGGCCGCCCGGGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3086:2218 1:N:0:CGATGT\nGTGGTATTTCACTTGCGCCGAAGCTCCCACTTATGCTACACCTCTCAAGTCATTTCACAAAGTCGGACTAGAGTCAAGCTCAACAGGGTCTTCTTTCCCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3169:2238 1:N:0:CGATGT\nCTGAGAACACCCTCACCGCTTTCAAAGGTCTCAGGGTGCTGTTAAGCGACAGTGATGACATGAACCGAGCCGTGTCTAAGAAGCTACTCGAGAAACTGGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3321:2075 1:N:0:CGATGT\nTGGCAAACTATAGAACTTTCCAAACTCACCACCTCCAGGCTTGGGTAGACTGGTGAAGATTCCTTTGAAAGGATGCTCGGAAGCTATAGTAGCAATCTTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3343:2075 1:N:0:CGATGT\nGTTAATGCTTCTCCCAATATCGATGCAGCAAATCCAAGCATAGCAACACGACCAACAAAGAGCTCATTTTCCTTGGTGAATCCAATTCCTCCTGATGTTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3357:2098 1:N:0:CGATGT\nGCAATCGGTTGGACAGCTAAGGGAAGTTTCTAATAAGGTCCACAATGCAGAGCTTAAATTATTCTTGGAAGTTGAGCTTGGCGTGGATTTGCGACCTATTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3411:2115 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACAAACTCTTTAAACTTTTTTCGAAAACAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3350:2120 1:N:0:CGATGT\nGCTTCTTCGGTTTTCTCTGGAACGACTACCTCTGGGGCAGGAGGGGCTGGGGTCTCAGTCTTTTCTATCTCTGATGGTTTAGACTCAACAGGTTTTTCTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3369:2137 1:N:0:CGATGT\nCGCAAGGACCATCGCAATGCTTTGTTTTAATTAAACAGTCGGATTCCCCTTGTCCGTACCAGTTCTGAGTCGACTGTTCGACGCCCGGGGAAGGCCCCAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3348:2146 1:N:0:CGATGT\nCTCTATGCATAGCTTGGTATTGGCAGGAACAAACAGGACATCACCCACATGGAGTTTATCTGCAGAGATGCATGTTCTTATTGTTCCCATCCCTTCAGTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3442:2156 1:N:0:CGATGT\nTGGGAATACGAGTTGGAAGAGCTATTTGACGGGTGAATTCTCCCGGAGGGCAGTGCTCGGGCGTTGGATCACTTAGTTTGAATGTCCTACCATGTCTCTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3407:2165 1:N:0:CGATGT\nGGGGAAGTTGCTGCTGTTGGAAGTGTAGTCCGATCATTAACTGTGGGACAAGAGGTTTTTGGAGCCTTGCATCCAACTGCTGTAAGGGGCACTTATACGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3300:2204 1:N:0:CGATGT\nTACCCCTTCTTACCCTGAAAAACAGGGTCACCTTGCGTCCTTGAACCGATAACCATCTTTCGGCTAACCTAGCCTCCTCCGTCCCTCGGGACCAACAAGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3391:2222 1:N:0:CGATGT\nCAAGCATATGGAAATTGGCTTCAATCAATTTCATGTTGATGCCACAAATTTGATCCACCGCAGGGCTGGCCGTTTCAAAATTAAGGTTGTGTTTGGTTTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3632:2027 1:N:0:CGATGT\nAGGAAGCTGTGGTTGTGGTTCTGCCTGCAAGTGCGGCTCCGCTTGCGGAGGGTGCAAGATGTACCCAGACTTGGTAGAGGCTTCAGATAGCCCCAACGTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3642:2044 1:N:0:CGATGT\nACCTTCAGAATAATTTTTTGGTTGTGCAAACCAAAGGGAATAATGATCTTGGGTAGTACCAAGTCGGAAACCAAGTGGATTTATTTTTTGTCCCATACTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3580:2051 1:N:0:CGATGT\nGCCTTGTTAACCTAATTACATCTTTCATGATCTTTCAATTCACTGCACACGGGTCTTCTCTTTGCCAAATATTTTTGATTTCAGAGGAAACCGAATTGACG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3507:2069 1:N:0:CGATGT\nCCTTCCAGAAGTCGGGGTTTGTTGCACGTATTAGCTCTAGAATTACTACGGTTATCCGAGTAGCAAGTACCATCAAACAAACTATAACTGATTTAATAGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3642:2073 1:N:0:CGATGT\nCCGCCGTTTACCCGCGCTTGGTTGAATTTCTTCACTTTGACATTCAGAGCACTGGGCAGAAATCACATTGCGTTAACATCCGAAAGGACCATCGCAATGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3674:2098 1:N:0:CGATGT\nCGGGCAACACTCTGAAAATTTCATCAATCGGTTCAAGCATTCCAAGAGCAAGGCAGTGTTTAGTTTAAAAGAAATCATGCTCCAGTAAAATAGCTTGAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3545:2185 1:N:0:CGATGT\nAGCAGTTCCTAGCTCGAGCTATTTCACCATTTTTCATTTCAAACTTGGCATAACGTATCCATGCCCCAACTTTAGGATGGCACTGCACAAACCTCTCATAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3876:2014 1:N:0:CGATGT\nCTGTGGACATAATCTTCGGTTGTAAGAGGGAAACTGTAGTTGATGACAACTTCAACATCTGGAATATCCAATCCTCTTGCGGCCACATCAGTCGCTATCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3999:2062 1:N:0:CGATGT\nGTATAATTATTATTTTTGCACACGATGCAGACCAAGTTGTCGTGTGCACCATTTCCAACGGGCACATCCTGCATTTAAAAACGAAATTTTTTTTTTTTTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3965:2064 1:N:0:CGATGT\nAGGAAGTCCAAAACCACCAGCAGCTTCCTTTCCTTGGTCAGGCTCAATAACTACAGGGGTACCTCCAAATGGAGCATCATTTGTTTCTTTAAGCTTTTGGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3828:2105 1:N:0:CGATGT\nGTCAGTTCCAGAGCCAAAGATCGTAGTTCTCGAACGAGCAGTCGAAAAGATTCTGGAGCATTCTCGGGGTTAGGTATTATTCCCCCAATGATCGTAGTACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3956:2129 1:N:0:CGATGT\nCAGATTTCAGGCAGATTGGAGCATAAATGTTGTAGATGTCAATGTTTCCTACTTCTTGGGCTGCTTGATCGGCTGCATCCTCACACTCTTCCGAAACAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3880:2191 1:N:0:CGATGT\nGACGAAATCCAAATTATTAGTCCAGTAATAAGAGTGATCTCTCCTGCTAAGTATATTCTCCCTTGTTTTTGCCACCTCCACACCTGATTTTGGATTTGGTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3859:2214 1:N:0:CGATGT\nTTCCACTTCTTGAACTTTCCGCCGTGCTTCTTGCCAAATTTACCATGACCATGCTTGAACTTCCCGCCATGACTATGCTTGAATTTTCCTTGCTTGAATTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3990:2250 1:N:0:CGATGT\nGGGAAGACGAACACGCAAGTGGAGTCCCATTCTATGAAGTCTACTACGGTTTCTTATGCTTTGTGCGGTCCTTCCTGTTACTTCAAGCACACTAGCTGCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3921:2250 1:N:0:CGATGT\nCGTCATTTAGGGGCCTTAGCTGGTGATCCGGGCTGTTTCCCTCTCGACGATGAAGCTTATCCCCCATCGTCTCACTGGCCGACCTTGACCCCTGTTATTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4196:2020 1:N:0:CGATGT\nCGCCAATCCGCCACCACTCAATTTTCCGCCAGCCCTAACCCTAACACGCGCGTATCGGAGCGCGTCTAAGAGAAAGCGCGTTAGATATGGGAGCTGAGATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4153:2062 1:N:0:CGATGT\nTTATTTATGAGCTCTTTATATTCCCAAAGAACCTCGAAAGTGGTAAGGGACCATCACCCTTATCGATGTCGCTAATGGAATTCTTGCTTCTAGATCTGTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4102:2101 1:N:0:CGATGT\nCCGGGAGGTTGGTTGATAGTTAGGGATGATGGCGAGACCATTTCCGAGGTGGAGAAGATGGCCAAGTCACTTCACTGGAAATCGCAGTTTACTTTCTCTAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4103:2125 1:N:0:CGATGT\nCCCCCATCACGATGAAATTTCAAAGATTACCCGGGCCTGTCGGCCAAGGCTATAGACTCGTTGAATACATCAGTGTAGCGCGCGTGCGGCCCAGAACATCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4021:2132 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAGACGTATAACGGATACGTGATGTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4178:2154 1:N:0:CGATGT\nCTGATGCAGCTTTTCTCGACTTTTGCACATGCACAAGTTCAATTTTCAATTTTTGCACCAATGTAGATTTTCCACCAGTGATCATCCATAACTCGCCTAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4209:2174 1:N:0:CGATGT\nGCAAGCGAGAACAGTTTTTTCAAGATTTCGCTGAGTCGATGATTAGACTTGCTAGAATTGGTGTGCTCACAGGTACAGAAGGTGAAATTAGGAAGGTTTGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4193:2213 1:N:0:CGATGT\nCCCAAGTCAGACGAACGATTTGCACGTCAGTATCGCTTCGGGCCTCCACCAGAGTTTCCTCTGGCTTCACTCCGCTCAGGCATAGTTCACCATCTTTCCGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4150:2215 1:N:0:CGATGT\nAGACCCAAAGTCTGTGTTTAGCTGATCCCCACGAGGAGTCTTCTCCAATTGATTGATCCTCTGTTCCAATTTCTTCAAGTCTTGACTACTCAGAGTCTCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4040:2236 1:N:0:CGATGT\nCTGCTCTTCAATGCCTTCCTTCAAGGTATTTTCTGATAATGGACTTTCATGCATGGGCTCACAACCTTTCGAAACCTTTTCTGTAACTGATGAACCCGAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4459:2015 1:N:0:CGATGT\nCAGCCTTTTCTTTCCCACATAACTGTTCAACTAGTGCAACAGAATATTCCATTGCTGTACCAGGTCCACGACTCGTCACAACTTTACCATCCTGCTGGACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4254:2021 1:N:0:CGATGT\nGTCAATATTGTCTTAGAAGTTCACACTCATTTCACATCCTTGTCACAAGAGCTAGAGTAACATAGTCACCCCTCTAACTTGCCCTTCAAAGTGTACACTAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4280:2023 1:N:0:CGATGT\nTGGGAATGCAGCCCCAAGCGGGCGGTAAATTCCGTCCAAGGCTAAATACGGGCGAGAGACCGATAGCGAACAAGTACCGCGAGGGAAAGATGAAAAGGACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4311:2061 1:N:0:CGATGT\nCCCATTCGCTTCCCTCCCGACAATTTCAAGCACTCTTTGACTCTCTTTTCAAAGTCCTTTTCATCTTTCCCTCGCGGTACTTGTTCGCTATCGGTCTCTCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4255:2121 1:N:0:CGATGT\nCACCGCTCTCCGCGAATTGTAATGCAACCTTCCCGCCCATAGAGTGCCCGATAATGACATCCGGCCAATTCGAACCTTGGGATTTCACAAGCTTAGCCAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4470:2167 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAAAAACCACAAACACGCAAGCACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4530:2025 1:N:0:CGATGT\nCGCCCTCCAATGGATCCTCGTTAAGGGATTTAGATTGTACTCATTCCAATTACCAGACTCAATGAGCCCGGTATTGTTATTTATTGTCACTACCTCCCCAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4521:2063 1:N:0:CGATGT\nCGATACGCATATTTCATGAATAAATACAACGAAGATACAGTAAATGAACAGGTCCTTCGAATTCAAAACGCTTGATAAACTATGCTTTTTGTATGTACAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4542:2075 1:N:0:CGATGT\nCCGGCTACCTTAAGAGAGTCATAGTTACTCCCGCCGTTTACCCGCGCTTGGTTGAATTTCTTCACTTTGACATTCAGAGCACTGGGCAGAAATCACATTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4736:2118 1:N:0:CGATGT\nGTAGTAGCAAATATTCAAATGAGAACTTTGAAGGCCGAAGAGGGGAAAGGTTCCATGTGAACGGCACTTGCACATGGGTTAGTCGATCCTAAGAGACGGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4590:2146 1:N:0:CGATGT\nAGCGATATTCGGACTTCAAACACTCGATGAAAGAAGCATTAGAGATACCAACACGAAAAAAAAGTACGAGAAAGAAGCTTCTCGTAGATGAATCTTCGGTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4506:2153 1:N:0:CGATGT\nCTCGAAGCCAAAAAATAACAATCCTTCCACAAAAACAAAAGGTAAAATTAGAAAATCTTGTGCAAGACTTCAAATAGTTTTGTAACTTAGAAAAATCAGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4725:2205 1:N:0:CGATGT\nTTATTGGAAACAAATTGTCACTGATCTTATACAGAATCTTGATTTAGACTAACAGTTCAGTGTTAATTAACTTCAACAATCCATCCTTTCTTGTCTTCAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4612:2250 1:N:0:CGATGT\nGTTTATATTTTCACTAAGAAAATAAACAATAGTTAAGGTGCATGATATCAATATAGTTTATCTAAAGTGGAAAGATGAAAAAAGGAATAATATAAAACAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4863:2020 1:N:0:CGATGT\nCCTCCACAAGCGAAGATCCAACTGAATGTCCCTGAGCTTTGTAAAAGGTGAAAATCATTCCTCCACCGAGTAGAAGTACATCGACCTTAGCTAACAATGAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4898:2021 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAGAACCTAACCGTAGACAAGGCATGCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4775:2060 1:N:0:CGATGT\nTTTCAATCGGTAGGAGCGACGGGCGGTGTGTACAAAGGGCAGGGACGTAGTCAACGCGAGTTGATGACTCGCGCTTACTAGGAATTCCTCGTTGAAGACCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4830:2072 1:N:0:CGATGT\nCAAAGTGTTGCCACCATAAATAATGCAGGTACTTATTACAGGAACTTGATCAGCCATATCAAAGTAGGGTCTCCAAAGAAACCGGGAGCGATCGAAACTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4848:2072 1:N:0:CGATGT\nCGAAATAAGTGACAAGATATGTTACAATCATATCATACATACCCAACACAATGTTAACCAAAGTCATCTATTGATCATCTTCCAAATCTTATCACATATGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4784:2086 1:N:0:CGATGT\nTAGCCGTTGATGATGGAAATGATGCTTCCGGCTCTGGTTTCCACAAGAATACAAGATTTTGGCCTTTCTCTGTGGCGATTGAGTGCAACGGTACAAATGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4914:2086 1:N:0:CGATGT\nTGGGACCCAAAACTACTGGGATGTGTTGAGCTGCCGGAACCAATGATGAGAACACCCTGTTGTTTAAGCGAAGAGATTGCTTTGCCCATGTTGTAATGATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4839:2092 1:N:0:CGATGT\nATTCATTTCAATTGGCAGTGCAGGTGCTGTCTTGCCCCACAAATGATACACACAACAGCATGTTGCGCCGCGCTACACCAAGATTCATCAAACAAATTGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4928:2130 1:N:0:CGATGT\nGTCATTGGCCTTCGCTTGCAACTTTATTAACACATCACACAACTCCAAAAGCCATAAAAGGTCTAGAATCTAAATACATAGATACCATCCTTCACATATTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4866:2131 1:N:0:CGATGT\nCCCGAGGCAAAGAGTTTTTCGTTTCTAACGGCCCTTTGGATTCATTATCTGCGAGAAAACAGCACTTGGTGTCAGGCCATCAGAGTCTTCACTAGCGAGAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4823:2136 1:N:0:CGATGT\nTTCTGTTTAACAGCCTGCCCACCCTGGAAACGGCTCAGCCGGAGGTAGGGTCTAGCGGCTGGAAGAGCACCGCACGTCGCGTGGTGTCCGGTGCGCCCCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4827:2196 1:N:0:CGATGT\nGCCAGAACCGCAACCACAGTCACCACTACAGCACGACATTTTCTGTTTCTTAATAATATTTCACAGCTTAAAAGGTTGGATTAGATGAGATGGTTCCCCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5190:2002 1:N:0:CGATGT\nNCCACCAGCAACATTACTTGCAGCAGAAGCCTCTATCTTCTTCTCCAAGAAAAGGCTTGGATCATTATCATCATCTCCCAACAAATCAAATGGATTTGTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5062:2027 1:N:0:CGATGT\nCTTTCTAATATCCACATCACATTTCATAATGGAATTGTAGGTTGTCTCGTGGATACCGGCTGCTTCCATACCGATCAATGAAGGCTGGAAAAGAACCTCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5114:2028 1:N:0:CGATGT\nCCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATGTGCAAGTGCCGTTCACATGGAACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5167:2041 1:N:0:CGATGT\nCCACGCTTTCACGGTTCGTATTCGTACTGAAAATCAGAATCAAACGAGCTTTTACCCTTCTGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5190:2138 1:N:0:CGATGT\nCCGGTTCTACCAGGAGTCGATTTTCCGGGCTTGAATTTCGTCATATCAACAAGATCTCCGAATAGTTTATCGTCACCCTTAGGTTGCTTTTTCATAGGGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5027:2148 1:N:0:CGATGT\nGAAAGAACCATCAGTTGTCTCGGCATAAAGCTGCATCACCGGCTCAGCAACATGCTTCCAGTCAAAATTAGACAGTGGTTTGCAAGTTTCCCACTCAACAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:5209:2171 1:N:0:CGATGT\nTCAGAAACAGGAACAGGGCTAGTGTTCCCCAAATTAAACACTCTCAATTGAGCCGGTCCGTGTTTCTTCCCACCACTACCAGTACTTTTCTCTGCAGTATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5116:2230 1:N:0:CGATGT\nACCAGACTTGCCCTCCAATGGATCCTCGTTAAGGGATTTAGATTGTACTCATTCCAATTACCAGACTCAATGAGCCCGGTATTGTTATTTATTGTCACTAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5036:2244 1:N:0:CGATGT\nATTGAAATTGAATCAAACTGGACAAGACTGATTTGAACTGAGAACACGAATTATCAAAAGTATCGAGCATCAAGGATACCTGAACAGGATCGACTAATGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5343:2032 1:N:0:CGATGT\nGTAGGGTAAAACTAACCTGTCTCACGACGGTCTAATCCCAGCTCACGTTCCCTATTGGTGGGTGAACAATCCAACACTTGGTGAATTCTGCTTCCCACTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5499:2034 1:N:0:CGATGT\nGCAAAGGATTCAACCCGCCGCTCGGTAGAATTGTGATTCAGAGCGGCCCTCACGGTGCATCCACCGCGATGGCTTGGCCCACGACACGTGCCCTTGGGGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5361:2040 1:N:0:CGATGT\nGAGGACAGGAAAGCAGCAATGAATTCGGTAAACCCGAAATACATACTGAGAAACTATCTGTGTCAAACAGCCATAGATGCTGCAGAACAAGGAGAATTTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5336:2078 1:N:0:CGATGT\nCGCGTGCGGCCCAGAACATCTAAGGGCATCACAGACCTGTTATTGCCTCAAACTTCCGTGGCCTAGAAGGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5492:2085 1:N:0:CGATGT\nAAGCAGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAACAAAGGAATTACCAAGAAGACTGAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5382:2103 1:N:0:CGATGT\nCAGGGACGTAGTCAACGCGAGTTGATGACTCGCGCTTACTAGGAATTCCTCGTTGAAGACCAACAGTTGCAATGATCTATCCCCATCACGATGAAATTTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5441:2169 1:N:0:CGATGT\nTTGCAGACTCGGTAATTATTGGGGCTTGAAGGATTTGGTAGACATCAAGAATTCTCCTAGGGTACTTTGCCTTTTCTTTCTTATTTTTGGTTTTTGTTTGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5279:2184 1:N:0:CGATGT\nCTGGTAACAATAGCTGAAGTGCAGCCTCAAATACTCCATAACAAAAGATGATTTTGCATGCAATAAGTGAGGGTTTAGGCCATATGTCAATGAAACCTTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5333:2187 1:N:0:CGATGT\nGAAACCTTGTTACGACTTCTCCTTCCTCTAAATGATAAGGTTCAGTGGACTTCTCGCGACGTCGCCGGCAGCGAACCGCCCACGTCGCCGCGATCCGAACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5485:2206 1:N:0:CGATGT\nATGTCTAAATACATATAATATTATGTATACATTATTCAAAAATTAAATTCAGACAAAAGCCTCTCATGTAAAAAAGAAAACAATTTATTACTTCTCTGTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5564:2020 1:N:0:CGATGT\nGTACTAGACACATTTAGAAGCAAATACAACTGACTCTTGAACTTCCAAACAACCCCACCAAGACAACAACCATAGTTCTAAAATCCACCACGAAGGCGAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5529:2121 1:N:0:CGATGT\nCTCAAACTTCCGTGGCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCGATCGTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:5672:2144 1:N:0:CGATGT\nCATTCCTTTGTTAAAACCTTGGCTAAAACTCTCTACAAGACTGGCATATTCCCAAACGTTACTACCATGGGCAATGTTGAAAGGGGTCTCATCATCACTCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:5740:2195 1:N:0:CGATGT\nTTGCCGCTTTGAAACTTCCATTAGATTTAAGAGCCACTAGTGGCCTCCTTAAATCTACTGGAAGCTTTAAAGCCGGAAATGCTAGTGGTCCTCTTTATTCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:5506:2239 1:N:0:CGATGT\nGCGGGGTAGGTGCACCCTGACCTCTGGATGATAACACCGGCAGCGTAGTTACCTGCCCTGACACAATCGGCAATAGGCTTCCCTTGAACCAATTGAGACCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5995:2057 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAAACCAAAGAATACTAATAAAAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:5883:2057 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAGTGATATCTTGTTGGTTCGCCAGATGTTCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5786:2091 1:N:0:CGATGT\nGCAAGTTGATCGTTTGACACGTGAATTTCATATTTACATGACCCGTAACGGCCGTATCAGTATGGCTGGCGTTACAACAAAGAATGTCGAATACCCGGCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5790:2114 1:N:0:CGATGT\nACAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGCGTATCGCCGGCAGAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5967:2174 1:N:0:CGATGT\nGCCAAACAGCAAAAGCAAAACAGTAGCACCGACGGACAGCACAACATCGAAAAATTTTCATCGAAAAATTCCTGTCACTACAGCAATACCAACAACCTGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:5861:2234 1:N:0:CGATGT\nCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGCGTATCGCCGGCAGAAGGAGCAAGACGACCGGTGCACACCGAAAGGCGGAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6226:2002 1:N:0:CGATGT\nNGCCGTCTTAGAGCAAGTATCCACCGTCGTACCGCCACCACTTACACCACCGTCAACCACCTCTCTTCTTCTACACATGAAGAAGTTTCTACTTCCCAATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6169:2009 1:N:0:CGATGT\nCTGCCATGATCACACAACAAAGAGAAGCAACAGACAAAAAGTAAGGCATTCTAGAAACAAGAGGACCTGATAGAAATTCAAGAAAAGCCTACCTGTTCAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6245:2017 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACAAAAAAAAAATAACATGAAGCCTACACCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6027:2024 1:N:0:CGATGT\nCCCCTCTTCGGCCTTCAAAGTTCTCATTTGAATATTTGCTACTACCACCAAGATCTGCACCGACAGCCGCTCCGCCCAGGCTCACGCCACAGGCTTTGCGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6224:2039 1:N:0:CGATGT\nGCTGAATTGGATACATTACAACAATCTCAACTAGCATACCCACCGCAATGGAGACAATACAGAAGTTACCAATGGATGTAAGTACTTTCTGGAAGTGACCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6019:2040 1:N:0:CGATGT\nCAAACAACATCACTAACATTGACAAGGACATAATCGTCTTTTCCATCACCATTACAATCAACATTAATACCACCACTGTCACTCACAGGAGGAAGATCTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6204:2079 1:N:0:CGATGT\nTTCAGCCTTGCGACCATACTCCCCCCGGAACCCAAAAACTTTGATTTCTCATAAGGTGCCGGCGGCGTCCTAAAAGTAACATCCGCCGATCCCTGGTCGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6003:2083 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAGAAACAGAAGTAATTAAAGAGGCTACGCGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6103:2139 1:N:0:CGATGT\nCGCCATCCTACCTATTTAAAGTTTGAGAATAGGTCGAGGGCATTGCACCCCCGATGCCTCTAATCATTGGCTTTACCTGATAGAACTCGTTTAGAGCTCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:6135:2156 1:N:0:CGATGT\nGGGTGCCCTTGTGCAGGATATCCCGTTGGAGGGTACGCGTCCTTCGGGTACCCTTCTGGTGGCGGGTATCCTTGAGTTGGTGGAACACCAACGGGGGGTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6030:2174 1:N:0:CGATGT\nTGCGAGCATCATGAGAATGAGTAGACTGAATTTGGTTCAACAATTTGGAGTCTTCAGAAGTGACCGTTGTCACTAGTAGCATTTTGTTAGTAGTCACGCTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:6354:2070 1:N:0:CGATGT\nATAAGTATCGAACAAAATTGTAATCAGGACTTCTCCAGTATGTCCACCATTGTTTCCAAAGGCATGATTTAAACTGACCCCATGTTGATTGGGCATATTGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6444:2076 1:N:0:CGATGT\nCCGCCGATCCCTGGTCGGCATCGTTTATGGTTGAGACTAGGACGGTATCTGATCGTCTTCGAGCCCCCAACTTTCGTTCTTGATTAATGAAAACATCCTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6457:2115 1:N:0:CGATGT\nAGAATATCGAAAGTCGAATACTGTTTAATATGAGGTGGCACATGGCTACGTAGCGCAGCCATCTCCTTAGCCCCGAACAAGAAGGCGTTCGACACGAGGCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6315:2119 1:N:0:CGATGT\nAGATCGGAAGAGCACATGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAAACAAGTGACGATGTACAGAAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6493:2148 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCCTATGCCGTCTTCTGCTTGAAAAAAAAACAAGTAGACGAAGAGTGGCACAGATTCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6415:2216 1:N:0:CGATGT\nCGGCATTCTGGGAAGAGGCAGCCCCAGCTGATGCAGAAACCAAGCCAAGTGATGCGGAAACCAAAACAAGTGATGCAGAAACCAAGCTGGTTGAAGTGGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:6343:2230 1:N:0:CGATGT\nCCTTAAGAGAGTCATAGTTACTCCCGCCGTTTACCCGCGCTTGGTTGAATTTCTTCACTTTGACATTCAGAGCACTGGGCAGAAATCACATTGCGTTAACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:6602:2051 1:N:0:CGATGT\nGACGGGTTCGGGAATGGGACCCCCGTGCCCAGCCCTCAGAGCCAATCCTTTTCCCGAAGTTACGGATCCATTTTGCCGACTTCCCTTGCCTACATTGTTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6652:2057 1:N:0:CGATGT\nCGGCCGGGTATAGGTCACGCGCTTAAGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTTCCAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6504:2079 1:N:0:CGATGT\nCTTCTTTTTTCTTTCTTCCTTCATAACATACATTAAGGGTGGGGTACAAAAGAGTAATCAAAAGGATAATAACAACATTTAACTTAGTTAGGAAGTAACAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6743:2121 1:N:0:CGATGT\nGCCGAATCAACTAGCCCCGAAAATGGATGGCGCTTAAGCGCGTGACCTATACCCGGCCGTCGGGGCAAGTACCAGGCCCCGATGAGTAGGAGGGCGCGGCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6617:2136 1:N:0:CGATGT\nCCGATCACAAGAAAAGTACTAAAATTGACTGAGACCGAAATCAAACAGGAAAGTATGATGAAAACCAGAACTTGTGGTGTATAATTAAAAGAAAAAACATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6666:2142 1:N:0:CGATGT\nCCCATACATGGCATCATGGCGGCCTCTAGGCCCCCACAAGTTATGGCCCCATGTGATGTTATTGGCATAGCCAATAACATGATACATAGGGAAATTGCTAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6572:2145 1:N:0:CGATGT\nTGGAAGGCCAGTTTTCAAATGATGATGGGACGGAGCTGGTACGTTTAGCTTCAAGATGTTTGCAATATGAGCCCTGTGAGCGAGCAAATCCCAGGTCATTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6581:2180 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAGATCAGAAAAGTAAAGATACACGAACAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:6606:2233 1:N:0:CGATGT\nCGGTGGCGCGTGGTGGAGAAGCGCGTTAGGACCTCCTGAAGGGTTGATAAAAAGCATGTTGTGTGGGTTTTGATTATTACTATTATTACTATTATTATGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6826:2009 1:N:0:CGATGT\nCGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCAGCACTCGGTCCTCCGGATTTTCATGGGCCGCCGGGGGCGCACCGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6938:2010 1:N:0:CGATGT\nCTGAGGTCTCGTTCGTTAACGGAATTAACCAGACAAATCGCTCCACCAACTAAGAACGGCCATGCACCACCACCCATAGAATCAAGAAAGAGCTCTCAAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:6885:2038 1:N:0:CGATGT\nCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCGTTCGTTAACGGAATTAACCAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:6852:2068 1:N:0:CGATGT\nACCATTACATAATTCAAGGAATAACCAACAACAATTCAAGCAATCAAACTCCCCCTTCATCAACCAATCTAATCTAGACTTCATCCTCATCGAGCTTGTAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6806:2078 1:N:0:CGATGT\nCCAAAAGCCCACCACAAGTTCTGCTTAATAGTTTTCATTGTTAATTTGCTTAGCTCCAATGCATCAACTACTTGTGAAAGTTTATTGCCCATTAGTACAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6820:2102 1:N:0:CGATGT\nGGACGACCCCGAGACATGGAATGTTCAGTTATTTAGATCCATTGATGGTGGTGCTGCTTTTGATTTTCCCGATACTCCTGAAAAAGCGGCCGAAGCTGGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:6827:2143 1:N:0:CGATGT\nATCACGATGAAATTTCAAAGATTACCCGGGCCTGTCGGCCAAGGCTATAGACTCGTTGAATACATCAGTGTAGCGCGCGTGCGGCCCAGAACATCTAAGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:6988:2214 1:N:0:CGATGT\nCATAGCGACTTGGTATACTGGCAAGACGAGTGTATAACAATTGCTTTGACAAGCGGTTACAAGTCTCAACAGTGGGTGGCTCTTGGATGAATTCCTTGTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:6905:2222 1:N:0:CGATGT\nGCTGCGAATAGCATAACCCATTTTTTTCCTTTTCCGGGTAAAATCCAAACCCTGATTCACTAATCGCATATCCATCCTAAAATAGAAACCCCCACCAAACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7033:2023 1:N:0:CGATGT\nTCACTTCTTTCGGGGCTAACAAACCCAGCTTTAACGTTCATGATGGCAGCAGATTGCATGAGAGAAGCTGGGCCGCCGGCTGGGGTCCGGCCCAAAACGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7103:2029 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAATATACAATCGTCAGATCTGGAAGGACCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7218:2035 1:N:0:CGATGT\nCGCGTCACTAATTAGATGACGAGGCATTTGGCTACCTTAAGAGAGTCATAGTTACTCCCGCCGTTTACCCGCGCTTGGTTGAATTTCTTCACTTTGACATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7059:2090 1:N:0:CGATGT\nGTCGCTATGAACGCTTGGCTGCCACAAGCCAGTTATCCCTGTGGTAACTTTTCTGACACCTCTAGCTTCAAATTCCGAAGATCTAAAGGATCGTTAGGCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7032:2090 1:N:0:CGATGT\nCATCATAATCCATAGTGGTTTCATTTATGTCCTTTCCATCTTGAATCACGTCTCCATCGAAATCTGGATCCGTCACTTCTGGATCTTCGTTAGGGTCAGTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7104:2096 1:N:0:CGATGT\nGCGTCCTTCCCGGTCCTCTCGTACTAGGGAAAGGTCCTCTCAATGCTCTAACGCCCACACCGGATATGGACCGAACTGTCTCACGACGTTCTGAACCCAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7036:2177 1:N:0:CGATGT\nTAAAAATTCATCATAACCAACATCCACATCAACTTTACATTTTTCGTTCGGATCCATCTCGTATAAAGCGAGATGGAGAGTAGAGAAGTGAATGAAGAAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:7008:2181 1:N:0:CGATGT\nGGGAGTTTGGCTGGGGCGGCACATCTGTTAAAAGATAACGCAGGTGTCCTAAGATGAGCTCAACGAGAACAGAAATCTCGTGTAGAACAGAAGGGTAAAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:7208:2190 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAGCGAACGGCTCAAGGCGAAGCGGAAGCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:7014:2200 1:N:0:CGATGT\nCACCAAATGCGACAAATGCAAATTCTCCTCCAGGAGCCAGAAGAAGACCAGTTCTGATTGCAGATATTGTTGAAAGACCGAAAATTTTTCCAACTAAAGTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:7169:2228 1:N:0:CGATGT\nTCCGTCAATTCCTTTAAGTTTCAGCCTTGCGACCATACTCCCCCCGGAACCCAAAAACTTTGATTTCTCATAAGGTGCCGGCGGCGTCCTAAAAGTAACAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7428:2050 1:N:0:CGATGT\nAGCTTGAATCACCTCGCCTTCAATCCATTTTCGCGATCCATCAGGATTAACCTGAACATGACCAAAGAATCTAACAGGGAACACAACATCATGTCTTGCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7312:2064 1:N:0:CGATGT\nCACTAATTCAAAGACTCATTTTTACAAATCATTCGATTTTAAGTGTTAAAAAAAAGCTCATCGTCTTCTTCAACCTTGACCTGATCCAAACTCGAATCGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7407:2064 1:N:0:CGATGT\nGGGAAACTTCGGAGGGAACCAGCTACTAGACGGTTCGATTAGTCTTTCGCCCCTATACCCAAGTCAGACGAACGATTTGCACGTCAGTATCGCTTCGGGCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7273:2103 1:N:0:CGATGT\nAATTCACCAAGAAACTGTAGGAATCCTCAGCTACAAATTGATCATTTATGTTGGTGAAGTCAGAAGAAGTATTCGTGTAAGAGAAGCCTACTCCAATCGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7339:2104 1:N:0:CGATGT\nTGGTGGTGCATGGCCGTTCTTAGTTGGTGGAGCGATTTGTCTGGTTAATTCCGTTAACGAACGAGACCTCAGCCTGCTAACTAGCTATGCGGAGTCACACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7347:2122 1:N:0:CGATGT\nATGCTCATCACCTCCAAGAGGAACCACCTAACCTAATCACCTCTTCTGCGCCGCTATCTTTGTTATACCCTCTTTCTGCACCGGCATCACCCTTCTGATCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7337:2140 1:N:0:CGATGT\nCCCGGATTCTGACTTAGAGGCGTTCAGTCATAATCCAGCGCACGGTAGCTTCGCGCCGCTGGCTTTTCAACCAAGCGCGATGACCAATTGTGCGAATCAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7287:2141 1:N:0:CGATGT\nGGGGCCCGCAGGCCGACGCCTGGAGCGCGCAGGTGCCGTGGCACGCTGTAACAGCGCGCGCTGCCTACCACAATCGCGAGGACAGCACTCCCAGTGACTGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:7280:2183 1:N:0:CGATGT\nTTTGGATCTAGCTCGCCTGTTTTGGAACCAATTGTAGACATTTGTCTCAGAGATTTGGCCGTGTTGGGATAACTGGGCGGTGATTTCTTTGATCTTCTGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7447:2222 1:N:0:CGATGT\nGATCACTCCTTCACTCGAAATGAAGTCAAAACCCTATAGAACACAAATTATACCACAATCCGAGATTACATTCTCCCATTTTCCAACATACGCCAATTATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7442:2243 1:N:0:CGATGT\nCTGGACATCTCTAACAGCAGCTTGCTCCACAATGTTCCTCACAAGGAACCTCTTGATTGCCTTGTCCTTAGGGCAACATTAGGCACAATTTGAACAACGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7666:2062 1:N:0:CGATGT\nAGTCCCTTGACCAGTCTCACCTTGTGTTCCATACGAAGGTTGGTTCCCACCAGCATAGCCAGCAGTGAACCCATAGCTTTGCTGATGATTGTACCCAGATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7566:2075 1:N:0:CGATGT\nGCATTTTGCTGAGGTTGAGAATGGGATATAGAGGGAGATTAAGAAGAGGGTTAGGATAAAGAGGGTGGAATTTGAGGGTTGTTTTGGAGTTTGCATAGTGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7710:2082 1:N:0:CGATGT\nTTTGATTCCTTTGAACATTCTACTTTAGAGTCTTCCATTGATGACAATGTTGATGATCGTTTTACGACAGAAGAACGATTGGAAAAGGTGAGGTGGATAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7526:2198 1:N:0:CGATGT\nTGATAAAAACATATATACGAGCTAAGAGCTAACTTATCCAAAAAAAAAAAATATTCCCCCAACCGTCTCTTCAAGAACCCAATCAAAGATTTAAGATCGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7907:2024 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAGAATCACCCAAGCAAGCGCAGACAGGAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7910:2046 1:N:0:CGATGT\nGTCCCTGTTAATCATTACTCCGATCCACTTGTTACTTCTATCTACATGCTCCGCTCCGCCCCGCCCAAATTGCACTCCACACAGCCAGAGCAGTAAGGAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7884:2079 1:N:0:CGATGT\nTCTCATTATATCTTACAATCAACTCACAACCGAGCAAAAGCCTTACCGCTCTCACTTCCCTTGCCAAGAAATGGGTAGTCAGTATATCCCACAACAGGATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:7937:2130 1:N:0:CGATGT\nCTTGCCTACATTGTTCCATTGGCCAGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCAGCACTCGGTCCTCCGGATTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:7876:2133 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAACAACAACTAGACCATAGCCACCACCATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7991:2141 1:N:0:CGATGT\nCACCACCACTGGAATGTACCATTTTGCACAATTGTCAATAAATGTTTGGATTCTCGCCTTTCGACTCTGAGCCTCTTCTACAAGACTGACCATCCTCGCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7971:2185 1:N:0:CGATGT\nATGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCGGCACTCGGTCCTCCGGATTTTCAAGGGCCGCCGGGGGCGCACCGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:7957:2233 1:N:0:CGATGT\nGAAAAAAGCTAAGAGCTTCCCTTTTATTATTCTGAAAATTAAGTAATCAACAATAAATAGCAATGTTTCAATCGTTATTGTACCACAACTATAATGGCATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:8021:2004 1:N:0:CGATGT\nNCGAGATCTTGGGGGCAACACCGATGACAAGTGCGACGTTGGTGCTAGTTGACGCCTCTACCAAGTCTGGGTACATCTTGCACCCTCCGCAACCGGAGCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8181:2113 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGGAAAAACATCCAAGTCTCCAAGCGCATCACTACACCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8027:2118 1:N:0:CGATGT\nCCGGGCGTCGAACAGTCGACTCAGAACTGGTACGGACAAGGGGAATCCGACTGTTTAATTAAAACAAAGCATTGCGATGGTCCTTGCGGATGTTAACGCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:8133:2124 1:N:0:CGATGT\nCTCTCGGTCTATTAGGATGCCTCAGCTGCATACATCACTGCACTTCCACTTGACACCTATCGTAATGATAAACGGCTCGTCTCGCCGTGACCTTTGCATTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8130:2186 1:N:0:CGATGT\nGTTCCATCAACCTAGTATCATCTATATAAACCTCAGGCATCCATTGACTGCAAAACAAGTGAGCAAACTCAGCAGACTCATCACTTCCAGCACCTCCTATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8151:2219 1:N:0:CGATGT\nCGCCAATCATTATTTTTGTGGTGTAATCAATAAGAGAACAAGATCAGGAGAAAGAAGAAGATAAAACGCAAAAGTATATAAACAATGGCGTCCAATTCTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8205:2230 1:N:0:CGATGT\nTATAAATCTAATTCTTAAGCATCAGCATATGTGCAAAGGTTCTCGAATCCCATATACTCGTGTCCTTGGATCTTGGCAACCATCTTAGAGATGCCTACTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8113:2235 1:N:0:CGATGT\nCTATATATTTCACATATGAACGGTCTCTTCCCTGAACCTGAATGTACTTGCGGTTTAACTGTTCGAGCCAATCAATTTTCACTATGACCCTGTCATCAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:8265:2028 1:N:0:CGATGT\nCAGTTTGCACGGCAACATTAATATTCACATTGTGATACTGGCGTATACAGTCATTGGTCCATGAACTGTTGCATTCCGGAACTTTCCTAAGAGCCAGAGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:8485:2037 1:N:0:CGATGT\nGCGGAGAACTAAGACTCTGTTTGGTTTTGGGGAAAACATTTTTAATTGAAAATCAATTTCAAGTGCAAATAAAAATTAAAAATTTTCCTTTGTTTGGTTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:8475:2058 1:N:0:CGATGT\nGCAGGCAATTTCTCGGATATTACCTTTATTTTTTAAAATTAGTATCTGGCACATTGGGTGATGCGAGTGCAGCCTCTGGAGTAACGATTAGCAGGAGAAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8366:2081 1:N:0:CGATGT\nTGTTGCTCTGAGAGGGATACAAGATTGTTCCTCTTGATTTGGTTTATGCCTTCAACTGCTGCTGCTACTACGAATGCCCAACAACTTCCACATCTGCCTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8462:2162 1:N:0:CGATGT\nCTGAGGGAAACTTCGGAGGGAACCAGCTACTAGACGGTTCGATTAGTCTTTCGCCCCTATACCCAAGTCAGACGAACGATTTGCACGTCAGTATCGCTTCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8386:2173 1:N:0:CGATGT\nTCGAATTCACCAGAAAGATGCCTTTTCACAAATGTAGTTTTTCCTGTACCGCCATCACCGACAAGAACAAGCTTAAAACTCGGATAATTAACCGTTTGCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8451:2184 1:N:0:CGATGT\nGCGGCGGCGACGACGACACCGTGGTCCAAAGGCGAGAAATCTACGGCAATGGCCGTATTTACGACATATCTCATCGTTATCACCCTGATTTACCTGCATTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:8462:2214 1:N:0:CGATGT\nGTCCTACACATCTAAGGACAAATGGGGTGTGATGGTGTATTGTTAATAGTGCTGACAGGTTTTATTGTTGGAGTTGATCTATGTCCGTTGAGCTCGGCAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:8651:2005 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAGAAGCAATAGACTACCTTCAGGGAGTCATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8713:2028 1:N:0:CGATGT\nTGAAAATGATCGAAAATTAACAAGATTTTGAATTATCTAAACAATTTAACTCAAACCTATGAAGGTAAAGATTTTCACGAGGATAAACCAAAACGATCGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:8631:2087 1:N:0:CGATGT\nGCAATTACCAACAATATCTTCAATGATATGCATGTGAAGCCATATGCTTTCAGCCTGAGTCGACACAACTCCTCCTGGTCGAAGAGCTCTAGCAATAGACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:8719:2196 1:N:0:CGATGT\nCTCCGCCTTACAGCCTTGCTTCCCATTGTAATTGCCATTGTAGCACGTGTGTGGCCCAGCCCATAAGGGCCATGCGGACTTGACGTCATCCCCACCTTCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:8512:2242 1:N:0:CGATGT\nCTATAATGTTATCCCATGCTAATGTATCCAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAATTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:8971:2011 1:N:0:CGATGT\nCCAACGTTTCGTTTCCTCAGCCAACTTTTCTTTAGCCTTTTCCCAGAGTGTTTTAGCATCTCCTTTTTCAGGAAGAGAGTTGACATGAAGAAAGAACGGTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8897:2016 1:N:0:CGATGT\nTAGAGGGAAAAAAGAATGGCAAACTCCTCTTTAAGAGGTTCACCCATTCTCTTTTAGCAGAATCAGCATTTAACTTCCTTGAGACCATGGGCAAAGTACAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:8795:2075 1:N:0:CGATGT\nCTTTAAATACGCCAAGGAACATGGAAGAGAGAGGGTGTCTGCAATACACAAAGCAAATATCATGCAGAAAACTGATGGTCTTTTTCTCAAGTGCTGCAGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8970:2106 1:N:0:CGATGT\nGGCGAGAGTAACGAATAGGAACAACCTTAACATCATCAAGAACAGGACCACACATGGATCCTTGAACAGTCATGGTATAGAAGGAGCTGATGAATCCGATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8775:2126 1:N:0:CGATGT\nTTTGCGTTACTCAAGCCGACATTCTCGCTTCCGCTTCGTCTACCACGGCTCGCGCCGGTACTTCTCTCTAAGGCGGAACGCCCCCCTACCCATGTTTTTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:8881:2169 1:N:0:CGATGT\nCTAATTCTCTGTCACCCGTCACCACCATGGTAGGCCTCTATCCTACCATCGAAAGTTGATAGGGCAGAAATTTGAATGATGCATCGCCAGCGCAAAGGCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:8934:2192 1:N:0:CGATGT\nCAGCCGCTAGACCCTACCTCCGGCTGACCCGTTTCCAGGGTGGGCAGGCTGTTAAACAGAAAAGATAACTCTTCCCGAGGCCCCCGCCGACATCTCCGGAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8802:2207 1:N:0:CGATGT\nATAGAATCCCGAAGTGATGCTGGAAGTGGCACGACATCTGGTGGTACGTATCTTACAATTAGAAGGGATATCGCTACTGTCGTAAATGCCAATAGTGTACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:8937:2238 1:N:0:CGATGT\nGTAAAAGAGAATGCCTTTATTCAAAGCATGAGCATAATCATGATCAGCCGTAGTGAATGGAATCCCACAAAGTAGCATAGTAAGAAACAAGGGTGCCATAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9059:2004 1:N:0:CGATGT\nNTAAACTTTTAATTGAACACTTGGTATGCATGTTTATCATCCTACATTAATTCAAATTAACTCCCTCAAATACTAACAAAGCTAATGTTTCACAATCATTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9148:2013 1:N:0:CGATGT\nGCTTCATATGGTACACATTTATCTGGACATCTCATTCAAAGATTTATTTGCAAAAGAAAGACTACTACTAATCAAACTACAACGACTAGACAGACTAATAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9019:2072 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAATGACAATTGACCTAGTATAAGAAAACCACGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9113:2084 1:N:0:CGATGT\nTTAAAGTATTAACTAATAGAGGAGTAATATTAGACAACCCGTCTTTTCTCTTTTTTTTTTCACAAATAGGAAATTTTGAATCCAATTCAGATATCAGAAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9080:2092 1:N:0:CGATGT\nTGTCCTTTTCATCTTTCCCTCGCGGTACTTGTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTGGGGCTGCATTCCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9030:2107 1:N:0:CGATGT\nCGGGTCGAATGGGGGGCCCACTGGCCGACGCCTGGAGCGCGCAGGTGCCGAGGCACGCTGTGACAGCGCGCGCTGACTACCACAATCGCGAGGACAGCACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:9052:2137 1:N:0:CGATGT\nATAAAGTATAGGCCGCCTGAGAAAACAGCAACGAAAGATTCTATAACTAAAAATATAAAATAAAAAATGACGACGTCTACTCGAGCGACGACCTTCCTAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9064:2188 1:N:0:CGATGT\nGGAAGAACTAGAAGATTCCACCTCTGGAAAGCGCCTACACCTAATGGCTTAAGCCGCTGTTCCCATTTCCTCGCTGACCCATCATGCAAAAGGTACGCCGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:9174:2191 1:N:0:CGATGT\nGGCATAATACATGGATCATGGTCAAGCAAGTGGCGACCTCATCAACCGTAACACGCTCAGGCTGCAGCATAGATATCACACGGGGATCATAAGTAGGAAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:9080:2243 1:N:0:CGATGT\nCTCAGGTGGAATTTCTCTGACAACGCCGAGCATGGAGTCATATTCCTCATCTTTACGTGCGTATTTCTTCCTGAGAGCCTTCTCGAATTCAATCTCATCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9497:2005 1:N:0:CGATGT\nNCACTCATCACTAAGATAGCCAATGGTGAAGACAACAAATAACTACATAGCCGCTTTTGTTCACAATGATGAAGAAACAATAACATAGCAGTCAAGTTGAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9403:2025 1:N:0:CGATGT\nCATCGATCACTATACATTTCAAAACCATTCTCACATAACACAACGAAAAATCAGGAATGATACAAAAGAGAAAATGTGCATTATAGAGAGTTCAACGAACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9301:2041 1:N:0:CGATGT\nCTTTTTTCTGTAACTGCACAAAAATAGCTAATACACCAACATAATTTCTCTATGTATAAACCATATGTAGAACAAGTTTAACAAGTGACCTTCCATTGCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9358:2074 1:N:0:CGATGT\nCGCTTAAGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTTCCATGACCACCGTCCTGCTGTCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:9406:2075 1:N:0:CGATGT\nCACAACTTAGCCCTTATTTTTCAGTATCTGTTGTAGAAACCCGTATCAACCTGCACATCTTCCCCGATTTTAAGCGAAGAAAAAGCTTGTGCAGCAATAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9408:2130 1:N:0:CGATGT\nCAGTTTAGAGTGACATGACGCACCGTGCGCCCGTTGTACATTAGAATTTGCCATATAAAAAAAGAAAAAAAGGCTTGGGACACACAAAAAAGGCCAGGTAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9373:2154 1:N:0:CGATGT\nTCGACGGATCGCACGGCCTTTGCGCTGGCGACGCATCATTCAAATTTCTGCCCTATCAACTTTCGATGGTAGGATAGAGGCCTACCATGGTGGTGACGGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9439:2167 1:N:0:CGATGT\nGAACCGTCTTTATTAAAATACAACTCCTTGGCCATGGCATTGGTGTTTGTGGAGCGTGGTTTTCTGAAAGCCACATTTTGTCTTCTGGTGGAAGAAATGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9454:2181 1:N:0:CGATGT\nGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTGGGGCTGCATTCCCAAACAACCCGACTCGGCGACAGCGCCTCATGGTGCGACAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9482:2191 1:N:0:CGATGT\nCGCTGATTCTGCCAAGCCCGTTCCCTTGGCTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACTAATTAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9269:2205 1:N:0:CGATGT\nCGCCGGCAGAAGGAGCAAGACGACCGGTGCACACCGAAAGGCGGACCGGTCGGCCCACCCCAAGGTCCAACTACGAGCTTTTTAACTGCAACAACTTAAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:9310:2208 1:N:0:CGATGT\nGTCCAGTTGTCATTTCAGATTTGAGTTCTCATCGAGGTCCTTACAAGTGGTGTCGGCTGCGAACACCAGCACCCTGCCTGACGCGTCCGCTGGCCTCGTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9274:2238 1:N:0:CGATGT\nTAAGGGTAGATTGGTCATATCCCATTGAGGATTTTATTTCATTTGAGAAAAGACCGAACAAGTAGGCTGCTCCTGCTACTGACATTATCAATAGCGAGGCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9542:2010 1:N:0:CGATGT\nCCGACATCGAAGGATCAAAAAGCAACGTCGCTATGAACGCTTGGCTGCCACAAGCCAGTTATCCCTGTGGTAACTTTTCTGACACCTCTAGCTTCAAATTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9697:2022 1:N:0:CGATGT\nTGAAGATAAATTAAAGGAAAGTCAAGCTGTTGTTCGTACTTACCTTCAGAATTTCCATCTGGAAAAAAAATGAGTCTTCTGTTTCTTTTTTCAAATTCATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9543:2051 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAGAGTAATGAAAACATCCTTGGCCAATGCTTTCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9599:2055 1:N:0:CGATGT\nGCATGAATGGATTAACGAGATTCCCACTGTCCCTGTCTACTATCCAGCGAAACCACAGCCAAGGGAACGGGCTTGGCAGAATCAGCGGGGAAAGAAGACCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9539:2070 1:N:0:CGATGT\nTGGGGGAGTTACAGTTAGCTATTTTGAGTGGGTTCAGAACATCCAAGGGTTCATGTGGGATGAGGAGAGAGTGAACACAGAGCTGAAGACATATATGACTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9735:2074 1:N:0:CGATGT\nTTCCATAGATTATAGTTGAACTGTGAAGACTTGACAAAGTCATGCCGGTAGAAATAGTACTCGACTTACCGATAAATTAGGCAAAAATATCACTCCCTCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9674:2091 1:N:0:CGATGT\nGGCACGTGCCCTTGGGGGACTAATCCCCTACTGCAGGTCGGCAATCGGGCGGCGGGCACACGCGTCACTTCTGGCCCGGATTCTGACTTAGAGGCGTTCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9643:2096 1:N:0:CGATGT\nCCGGTCAGGGTCTTCACAAAGATCTGCATCCCACCCCTCAGACGAAGGACCAAGTGAAGAGTGGACTCCTTCTGAATGTTGTAATCGGCCAGGGTCCTTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9737:2103 1:N:0:CGATGT\nGATTTAATCTGCGAATTAATTTGTCATAATATTCATCATCCATAACTAAAATATTTACAAAAAAAATAAAAAGAAAAAGAATTATATTTATTTTGGGTAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9520:2118 1:N:0:CGATGT\nTAGGAGCAAAAGGAGACCAATTTGATACATCAACTTCAAAAGCACCAGCAATAATTACAACGAGGACAATGACTATCTTAGTTACAGTCATGAATGAATTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9583:2142 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAATAAAGAAGTGGCGAGCAGGACGGGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:9715:2144 1:N:0:CGATGT\nCCGCTATTTTGCCTCTTGGCTTCGAAAGCAGCCCCGTCGTTGAGCATGTCCTGAGCATCGGCTTCCATCCCTAGTTTGGATAGTGCCAGAGCCTGCAAATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9521:2161 1:N:0:CGATGT\nATCGTCTTCGAGCCCCCAACTTTCGTTCTTGATTAATGAAAACATCCTTGGCAAATGCTTTCGCAGTTGTTCGTCTTTCATAAATCCAAGAATTTCACCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9881:2029 1:N:0:CGATGT\nCTACTTTTTAATATGTTCTTCACCTCCATTCAACTACAAATCTCTATAGAACTCTTATTCCATGAATCCATAAACCGTTTATGAAGATCATCACAATAAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9898:2074 1:N:0:CGATGT\nCGGATTTGGACCGTTCCGCATCCGACCGAGGCGCATCGCCGGCCCCCATCCGCTTCCCTCCCGACAATTTCAAGCACTCTTTGACTCTCTTTTCAAAGTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9837:2076 1:N:0:CGATGT\nGCGGCACTTTCCCTCTCTTGTTTTCGCAAAAACGGTCCAACATAAACTTGCTTATCATTCAAAAGCATACCATTAAGTTTCTCTATAGCCTTCTGGGCAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9927:2116 1:N:0:CGATGT\nCCTGCTGCTAACCCGTATTGTGTTGCATTTGCCCTTCGAATAACTTCATCGAGGTCCCTGAATTTCAAGATAGATTGAACGGGGCCAAAGATCTCGTCCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:9811:2118 1:N:0:CGATGT\nTTTTTTTTTAAATAGAAAGGAAACAAGTGATATTATAAGTCCAAATAAGATTTAAAATACAGCATAATAATATAGAACTAGCACAAAATACAAGACTCGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9841:2161 1:N:0:CGATGT\nGCGGCACATCTGTTAAAAGATAACGCAGGTGTCCTAAGATGAGCTCAACGAGAACAGAAATCTCGTGTAGAACAGAAGGGTAAAAGCTCGTTTGATTCTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:9932:2188 1:N:0:CGATGT\nGCAGATGTAACAGGATCAGAGAAATCTCCTCCAGGAGGGGAAACAGCACCAACAATGGTGACACTGCCATTGCGTTCAGGACCACCAAGACACTTCACTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:9869:2218 1:N:0:CGATGT\nCCGACCCTTTTAACAAAACCCGGGTCAGCCCGTGAGTAGAACCCGGCATTGACAGCAGACCCACCACCGAGAACCCGAGCACGAGCATTGGCAACCCCATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9761:2221 1:N:0:CGATGT\nTTCCCACATTCTTAAAACCCCACCACCACCACCACGGCCGCCGCCGCCGCCGCTTTCTACATATTCATCATCATCATCATCATCTTCATTATCCAACATTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:9996:2244 1:N:0:CGATGT\nCTGAGAATTAGATAATTCCCTTGGCCTCCGTAAATTCATGGACTGAGAACGTCTAAGAGATCCATTTTGGAGCCTTTCAACCATTAAGCTAGTCACAGAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10086:2003 1:N:0:CGATGT\nNCTGATGGAACACAAGGCTGTTTTAGTTGGTCTGCATTGCTTCTGAGTGATAATTGTCTAATTCAGCATCTAACTGCTCAGCTGATACCACCTTCTCGCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10207:2005 1:N:0:CGATGT\nNTTCGCTTTCAAGCGTGAAAGTCCAAAATCACACACCTTCACAGTGTACTTTTTATCAACCAAAAGATTTGGAGACTTGAGATCGCGATGAACGATGGGTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:10080:2078 1:N:0:CGATGT\nTTCACAATGTCACTAACCTTATCAACCGTGTCTGGCTTTGCAGCACAAGAGATCTGCAAGCGAAGAGGCATCCAGAGCTTTGGGGTGCTAGTCCTCAAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10029:2185 1:N:0:CGATGT\nTTCCTCTTTTATATGCATGCCTCTCTTTGCAAATGTTCCGACATGATAATACGTTAAGTCCCAAATCGCTTGGGTTGAATTCCTTCAACAAGCATTGTCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10065:2189 1:N:0:CGATGT\nAGCATTTACGAGCGGTGATTATGGACAAAAATAAGTTACTCAGCTATATATCAAACACTATAAAATTGTTACATCTCCTACAACTTACACAAGTAAATTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10026:2209 1:N:0:CGATGT\nTCCCTTCCTTGTCCTGAATCTTAGCCTTCACATTGTCAATGGTGTCTGAGCTCTCAACCTCAAGGGTGATGGTCTTCCCAGTCAGGGTCTTCACAAAGATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10065:2216 1:N:0:CGATGT\nTTTCCGAAGATCTAAAGGATCGTTAGGCCACGCTTTCACGGTTCGTATTCGTACTGAAAATCAGAATCAAACGAGCTTTTACCCTTCTGTTCTACACGAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10157:2234 1:N:0:CGATGT\nGTCGCCAGCGCAAAGGCCGTGCGATCCGTCGAGTTATCATGAATCATCAGAGCAACAGGCAAAGCCCGCATCGACCTTTTATCTAATAAATGCATCCCTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10215:2236 1:N:0:CGATGT\nCGGGGAGGTAGTGACAATAAATAACAATACCGGGCTCATTGAGTCTGGTAATTGGAATGAGTACAATCTAAATCCCTTAACGAGGATCCATTGGAGGGCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10438:2004 1:N:0:CGATGT\nNGTGACACTGTCATCAGTAGGGTAAAACTAACCTGTCTCACGACGGTCTAATCCCAGCTCACGTTCCCTATTGGTGGGTGAACAATCCAACACTTGGTGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10485:2005 1:N:0:CGATGT\nNAGGGTTTTGAGCTTGGTTAGTTCAACTTTGAGGGTCGAACAAGGGTCTTTGACTGGTGAGAGTGAAGCTGTTAGTAAGACTGTTAAGCCTGTTGCTGAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:10408:2017 1:N:0:CGATGT\nGCCGAAAAGAACAATGCTCCGGTATAAATTGAGCCATCCGATACTTGGTCCTTGTGCATCCTTGTTCGAAAGAACACAGTCATTGCTATGAGAGCCATTAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10388:2097 1:N:0:CGATGT\nGCATAGGCTATCATCCGATCGTAGTAGACCCCGATTCTTTTGTTGGGGTTGTGGGTTTGGAGAGTGACTTGGAAGAGTGACGTCAGCTGGGTTGTACCACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10476:2103 1:N:0:CGATGT\nGGACTGAAAGATGGTTCGGGTGTCATATGCTCCTTGTGTAACAAACTTCCTCTCGAATTTGTCCAAGAACTCCAAGTATAACAGATCTTCGGAAGAAAGTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:10423:2118 1:N:0:CGATGT\nACTGAATCTCCTACCAATCAACCTCTTTGCATCAAAGACAGTGTTGATAGGGTTCATAGCGACTTGATTCTTGGCCGCATCGCCGATGAGACGTTCGGTGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10612:2008 1:N:0:CGATGT\nTCAGATCATCAATTACAATAGCTCGTTCTCCTGCTTCCACGGCACCAACATGCATCTCCATTTTATCGGTTCCATATTCCAATGTTTACTCTTCCGAAATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10664:2055 1:N:0:CGATGT\nCTCACGTTCCCTATTGGTGGGTGAACAATCCAACACTTGGTGAATTCTGCTTCACAATGATAGGAAGAGCCGACATCGAAGGATCAAAAAGCAACGTCGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10721:2059 1:N:0:CGATGT\nCCCGAGGCCCCCGCCGACATCTCCGGACTCCCTAACGTTGCCGTCAACCGCCACGTCCCGGTTCAGGAATTTTAACCCGATTCCCTTTCGATGCTCGCGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10594:2091 1:N:0:CGATGT\nCTTCCGTGGCCTAGAAGGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCGTTCGTTAACGGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10726:2093 1:N:0:CGATGT\nAGGCCATTGACTCTCATGTTTAGCAATACAGAATCAAGCATCTTCCCCCCGACGTTCTCGAAATAAATGTCAATCCCATCTGGAAAGTACCTCCTCAAGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10635:2169 1:N:0:CGATGT\nCTTGAAGAGAAGCAGAATGTAAAAACTCAAGGTACTTCAATCTCTGCTCCTCATTGCTTTCCACCAATTGATCTTCAACTCTGGAGTTAATTTCCGCCATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10631:2229 1:N:0:CGATGT\nCCAGCCAAGCTGTACCTGCTGCATGTTCAGTCGTCACAATGGCTATCATGGGACTTACTATCGCCTCCTTCTGGGGCACTGGTCGTCGCATCAGAGATCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10742:2236 1:N:0:CGATGT\nTCCCCATGTCAGGATTGGGTAATTTGCGCGCCTGCTGCCTTCCTTGGATGTGGTAGCCATTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAATTCTCCGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10719:2244 1:N:0:CGATGT\nCGCCGCTAGGAGGCATACACAGATTGACATTCCGCCGAGATACCATGGCACCTTGGATAGCAAGCCGTTGACAAGATGTTGAATGGAGCTAATGGGTGATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:10958:2023 1:N:0:CGATGT\nGCATAATACAATTGACAGCATCATCACCACTGAACTCCTCAGACCATGCAACAAGGCTAGGCATCATGTCCTGATCAAGCAACCGCCAATTCTTGAGCTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10876:2040 1:N:0:CGATGT\nCCATCCTCACAAACCACATTATCATTACCTCCATCTGATCCAAACATCGCAATTGGACTACCATCCAACTTCTTAGGCATAATCATCTCAAAACGATTCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10945:2062 1:N:0:CGATGT\nCCCGACCCCATGGTTAACTACTTGGAAGAACCCCCACTCTTTGCAGGCCTTAGCAATCTGGTCCATGGTTGACCTGACCATGTTCAGGTTGCTAGAGGACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10889:2112 1:N:0:CGATGT\nCATGCTTCAACGATATCGACGAGACAAACGAATGACCAGGACGAGAACTACCGGAATCAATACCGGCCGCATTTTTCAAGTACCAGGCAACAGAAGGGGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10841:2112 1:N:0:CGATGT\nCCCCGCTCAGGCATAGTTCACCATCTTTCGGGTCCCGACAGGTATGCTCTCACTCGAACCCTTCACTGAAGATCAAGGTCGGTCGGCGGTGCACCCACAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:10822:2116 1:N:0:CGATGT\nATGATTTTGTCTCAAGCGTACGAACTATCTCACCATTTCTTATGTCCCATAACCTCACTCCGCCGATGTCACTACAAGAACTCAATATAGTTTGATCACTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:10958:2116 1:N:0:CGATGT\nGTTCGATTCCATTGATACAAAACTCTCTACCAACCGCACCCGATCTTGCCACACTTTCCGAACCATTTCGAGGTACTTTTCGTTATTCTCCATGTCGCCGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10782:2120 1:N:0:CGATGT\nCGCCAACTTGCGTTTACTGCAACGAAGAATTTGTCGAGTTTTGGAGCGTTGTTGAGCATCAAAGTTGTAGCTACAAAATCAATGAAATAGCAGCATGCATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:10879:2146 1:N:0:CGATGT\nGGCTGCTGGCACCAGACTTGCCCTCCAATGGATCCTCGTTAAGGGATTTAGATTGTACTCATTCCAATTACCAGACTCGAAGAGCCCGGTATTGTTAGATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10759:2146 1:N:0:CGATGT\nCTGTTTGGTCCTCCGGGAACTGGAAAAACTCTTCTTGCTAAAGCACTTGCGACTGAAGCTGGAGCGAATTTCATCAACATAACCGGTTCCACGCTGACATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:10756:2207 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAACCACTACGTGAAAGCGTGCCCATCCTTGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:10769:2236 1:N:0:CGATAT\nCGCAATTCTCACCTCCGTCCTCGTTGCCGGAAACTCTCCGATTCTTCCACTTCCGGCCCCACTCCGATGACTCCCAATGGCTCAAGAGAAAAAGATTTCGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:11156:2085 1:N:0:CGATGT\nCTTCTGTTTAGGAACTGACGTGGGCCATCGTTGACCCAAAACCCAGACCATGCTTTTATGTAATTCAGTTGCAGATCTTTGGTTGTGAGGTTCAAGATTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11128:2137 1:N:0:CGATGT\nCTGGTGAAGGGTTCGCTTATGTTGGACAACTCGAGTTCTTCATCAGAGAAGCACCTGAGAAGATGAAATCAATGAGCACAGGATTTTTCCTAAGCACATTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:11032:2199 1:N:0:CGATGT\nAGCGGTTTGAATAGTCATATGAAGAGATCCAGTAATCTTAGCCCCTTTGAAAGGTTGAGAGGGTCCGAACTCAGTTCGGCACGCCATTAAACCGGGCATTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:11106:2222 1:N:0:CGATGT\nGCAGAAACACATGATCCCATACCTAGATATAACAACACCCTCTTCATAATGCTTCTTTAACTTGGAGATGTTAATAATTAGCTTTAGATATTATTTTTTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11405:2026 1:N:0:CGATGT\nGAAGTTTCCTCGATACTTCATTGCTAGATTCATTAACATGGGTTAAATAGTTCTCAAGAGCAACAAGCAAGCTTTCACAATATTGCTTGATCTCACTCCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:11478:2036 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAACAACAAAGTAGTCCCTATGTAATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:11337:2049 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAAATCTCATATAAAGACACACAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:11374:2059 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTACCTCGCATGCCGTCTTCTCCTTGTGAAAAAATCCTTCACTTCATCTTCAAGCAGAAACCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11403:2076 1:N:0:CGATGT\nCCATGTCAGTCCGCACCCCGAGCCGATCGGCGGACCGGATTTAGGCCGTTCCGCATCCGACCGAGGCACATCGCCGGCCCCCATTCGCTTCCCTCCCGACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:11319:2143 1:N:0:CGATGT\nCTGCCGCCTCCTTTGGGAGCTTCTTCCCGGCTTTTGGCTTCTTCTCCGCCGGTGCTTTCTCGGCGGCGGCGGCGGCTTTCTCGGCGGGGTTCTTTTTTTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11722:2004 1:N:0:CGATGT\nNCAGCATTCACATCTTTAGGGACAACATCACCACGGTACATCAGACAGCAAGCCATGTACTTGCCATGGCGAGGATCACACTTGGCCATCATAGAGGATGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:11614:2037 1:N:0:CGATGT\nACTTCTGAAGACAAGACTACTACTCCACTAGACACGGCATTTGGCTTATCAAAGAATCCCAGTCCTGTGTGCGACTCCTCATCTTCATCCATGACACCAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:11701:2043 1:N:0:CGATGT\nCCGGGCGTCGAACAGTCGACTCAGAACTGGTACGGACAAGGGGAATCCGACTGTTTAATTAAAACAAAGCATTGCGATGGTCCTTGCGGATGTTAACGCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:11509:2065 1:N:0:CGATGT\nGCGCGCAGTTGGGCACCGTAACCCGGCTTCCGGGTCATCCCCCCTCCCCCGGGCTCCTTTCCAAAAAAGGCCCCCGCCGCCCCCCCCGTTCCTGGGGACTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11628:2075 1:N:0:CGATGT\nCGTCACAAATCCTCCAAACAAACACAACCACTTTGAAACTTAACCAACCAACAAACCACGAATCAACTTCACCAACACAATCTCAATTACAACTCTATCAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11616:2101 1:N:0:CGATGT\nCTCGGGAATATTCCGCCATAGTTAAGGCAGTCAACCCAACTCTCATACGTGCCCCCGGCGGTTCATTCATTTGACCATAGACTAGAGCTACTTTTGATTCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:11743:2106 1:N:0:CGATGT\nCCCCGGTTCAGGAATTTTAACCCGATTCCCTTTCAATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATGTGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:11520:2106 1:N:0:CGATGT\nAGGAGAGAGAAACACTTTCGATTAATTAAAAATCAAATCAATTAATTAAAACCAGAACTCAAATCCCATTCTTTTTAATTTAATTTAATTTAATTAAATGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:11603:2193 1:N:0:CGATGT\nTCTTAGCTTTAACCTTCAAATGCTTTTCCAATATACTCACAAGTGACGGCACCGTTACAGGTTGCGTATTACCCAAGTTATATATCCTATACGGTGCGGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11509:2212 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAATACTATGCTACAATGTTTGCCGGCAGAGAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11942:2140 1:N:0:CGATGT\nCTCAAATCAACACCATGATTAGGAGAACGCGTTCAGACCGATTTGAATGATAAGATTTTCATGGTTACAACCGAATCAGGGTTATTAAAATGGCCATAACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:11958:2165 1:N:0:CGATGT\nCCCGACTGTCCCTGTTAATCATTACTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATGATGTTATCCCATGCTAATGTATACAGAGCGTAGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11924:2172 1:N:0:CGATGT\nTTGGCAATAGCTTTGAGTGACTCAAAGAAGTAGGTAGATTCCCGAATGATTGCATACCCATTGGGACGTAGGATTCGATCCATTTCCAACAGAACATACTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:11836:2197 1:N:0:CGATGT\nGTGTTGTTTGGGTGGGATGGGGAAAAAAAATGATGGGTGAATTTTTTTTTAGGGAAGATATGGAGACGAGGAAAACAAGGGCGGCGATGGAACCGGGGAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:11909:2198 1:N:0:CGATGT\nGGGCACTTCATCTTTTGCTCTAAACATCAAACCAACCCAACACCTTCACCTTCCTCCACCTATTTTTTATTTTTCCATTAAAATCCCAGTTTTTTCATCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:11913:2230 1:N:0:CGATGT\nCGGCAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTTCCATGACCACCGTCCTGCTGTCTTAATCGACCAACACCCTTTGTGGGATCTAGGTTAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:11830:2231 1:N:0:CGATGT\nCCAAGAAGTCACACATGCTCCAAACAGATATATCTCAGCTTCACTACCATGAGGCGAAGTGAGGACAACCTTAGGAAGATCTCCAAGTCCTTCAGTCAACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:11967:2238 1:N:0:CGATGT\nCTCCGTACCAGTTCTGAGTCGACTGTTCGACGCCCGGGGAAGGCCCCAAAAGGAGCCGTTCCCAGTCCGTCCCCCGGCCGGCACGCAGCAACCCGCCCTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:12221:2045 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCCTATGCCGTCTTCTGCTTGGAAAAAATATTAAACTAGTCAAATAGGACTCTCCCCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12071:2064 1:N:0:CGATGT\nGGCATAGTCCAATGAGTAGACAAAAAACAATGAAGAAGCACCAGCAGCACCACCAGAAGCCAAGTTACCAGCGAACCACACCCAGTAACCATCCTTGTCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12090:2189 1:N:0:CGATGT\nCTGATTAAGTAAGAAAAAATAACGGATATTTTTTCCAATATAAAAACAAAACTTATTAATAAAAATTATGGAAGTCGGGCGAACAAGAATGTCCATCTCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12221:2196 1:N:0:CGATGT\nCGTCACCCTCCCGGAAGATGACGTCACCATCGTTTTCGCGATTGTGGCAGCTTGCTCCGCCTTCAACCGAGCATCGCGGAAGCATTTGGAGCAAAGATTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12186:2247 1:N:0:CGATGT\nGTGCGAATCAACGGTTCCTCTCGTACTAGGTTGAATTACCATTGTGACACTGTCATCAGTAGGGTAAAACTAACCTGTCTCACGACGGTCTAAACCCAGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12449:2002 1:N:0:CGATGT\nNGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAACCCGGCCAATTAAGGCCAGGAGGCCATCGCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:12350:2078 1:N:0:CGATGT\nTGGGGGGGTGAGTAACGCGAACAATGGACGGAAGTTGACGGTACTCCCAGCATCGTACACGTTGAATGAACCTCATGACGTCAGATTGCTTCTTCCTCCAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12288:2099 1:N:0:CGATGT\nCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGCGTATCGCCGGCAGAAGGAGCAAGACGACCGGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12320:2102 1:N:0:CGATGT\nCCACGAGATAGTTCGAGTATCATATCCACAAATCCTCCACCACCTGCTTCTCTAAAAATCAATTACTTCAACTCACAGAAAAGAAATTAAGGAATCCAAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12496:2126 1:N:0:CGATGT\nCTCGATTATCTCAAAATCAGACCTGTAGAACGTTCTCAGGTTCCCCCCCGCGAGTAACACCGTCAGGTATGCCTCGAATGCCGCTTTCATCGCTTCTTTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12319:2130 1:N:0:CGATGT\nCGATCAAATTTCACAGCTATCCCTCGCATCACAACATGCTTCACCCTCCGTAGTGTTTAACAATTAAATCACCTGATGAAAATCAAGCACCTGTTTGTTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12439:2208 1:N:0:CGATGT\nCGCCGAGCTATTCTTTTCAGGTTCTTTTATTTCGCCTGTAAGGTATTCATCCTTCCCTCGCCCACATATGGACATCATGACTGATTATGACCACCGAAGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12543:2072 1:N:0:CGATGT\nCATCATTCAACAAATAAAGTGATTCTGAGTAGAAAATTAAATTCTTTTTAAAAGGACAGATATACAAAGCATCACTCACCTACATCTTTTCCTTTTCATTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12656:2084 1:N:0:CGATGT\nTTCTGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAGGACACCTGCGTTATCTTTTAACAGATGTGCCGCCCCAGCCAAACTCCCCACCTGACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12576:2091 1:N:0:CGATGT\nATCCGCTTCCATCCCTAGTTTGGAAAGTGCCAGAGCCTGCAAATAAAAGGCGATCGGCCATTCGGGTATGCAGGCACAGGGCTGCATACCCGAATGGCCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12504:2100 1:N:0:CGATGT\nTCCGGTTTTTTGTTCTTTTGACCCTCGTTTGGTTTTTATCGTGCATTCAAGGCTATGGTTTTGTAGTGCTGTGGATTTTTATCCACAAGTAATATCTTGGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:12587:2185 1:N:0:CGATGT\nAACCAGCCAAATTTGGTGCCAAGTTCTATAGAAGCTTGCTATATGTTCTCTCTAGTTTTTCAAATTATTCAAAACCACCGACACATTCAATGGATGAACCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:12502:2233 1:N:0:CGATGT\nTGTGAAACCGGCGCTAAACCATTAGATACTTCTGTAGGGAATGTCTTCATAAATCCGGCTTCTATATCGCAGAAATCTACTTGAGCGATCGATGGAATTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:12696:2247 1:N:0:CGATGT\nTGACTCTGCTGGTGGATAATCCTCTGCCAAAGGCTTTTTGACAGAAAAGTCTCTACCCTGTCTGTCCTGATTAAGAGGAACATCCCTCATGTCATTGGAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:12855:2049 1:N:0:CGATGT\nGGGGGCATCTCACCGGCAACCCACGGTGTCGAACCCATCAAGCGACGGCGGCCGGGGGCCACATTACCTGAAGAACCAGCACCACCACCACCAGCGGCGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:12826:2071 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAATCCTGTTGAGCAGTTGATCCCAAGATGCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:12846:2088 1:N:0:CGATGT\nCGTCGCGATAATTGTGCTAGTAGCTTCTCGAAATCATCCTTGTATCATTACATGCGATGGTTCCTGGTATCTCCGCTGTAGAGCCAGTCATAAACAGTGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:12947:2106 1:N:0:CGATGT\nCGCCTCTCTCTGTTCTGCATTTGAGTAGAAGAAACCTGCATTTATTTCACTTTTCTCATACTCAAGAGACACATTGCAAGTCAATATGTAACAATTTTCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:12806:2200 1:N:0:CGATGT\nCCTTCCTTGACACGGAAAGCAGGTGAGACGTGGGCAGGGATGTTAGAGTGCCTCTTCTCATATCTTTGATACTTTTTAATGTAGTGCAGATAGTTGCGGCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:12805:2220 1:N:0:CGATGT\nCATACATTACTTATGCTGAAGAATCTACAATAAAGGGTTGTTGATATAGTAATTATCTATGATAAGAACAAAGGCGCATAACGCGCAATCACAAAACATAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:12975:2239 1:N:0:CGATGT\nTTACCCTGTTAAGTGTAACCAAGATAAGTCCACCCAAATTTAACAATATCATCAACAATCAACTTATCTTGGTTACACTTAACAGGGTAAACACCCTGGTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:13150:2015 1:N:0:CGATGT\nCACCCGCATGTATCATCCACACCGATACTTATTCCCATTTTTTAACCAAACAAGGCCTTAGTCACCTCCAAGAACAATAAGTACGTGATCCATTGTGGTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13177:2059 1:N:0:CGATGT\nAGGAAGTTCAAGAGACTCTGCCACCTTCTCGAGTGCCAAACATCTAATTTCCCCAAGCTCCTGTCTACATGTGGGGCATCTGTTATGAACCCTTGTTTTAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13105:2163 1:N:0:CGATGT\nGCCGGCTTCCCTTGCCTACATTGTTCCATTGGCCAGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCAGCACTCGGTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13085:2227 1:N:0:CGATGT\nCGGCTGGTGTGGACTCTAAGGCTGGGCTTATTCATCGTACCAAGTGTTCTATTGGCTTTACTTATTCGTTTTACAAGTTTACTTCCTCGACCTAAGTTATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13313:2014 1:N:0:CGATGT\nGGCGAAGGCACTGACGTCAAGGCCGGGGATGTTGAGCGTCATGAGGATGCTCTTAACACCCGTGATAATGTTGAGTGCATTGCTAGTTAATTCCCTTGAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:13325:2028 1:N:0:CGATGT\nCCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATGTGCAAGTGCCGTTCACATGGAACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13304:2034 1:N:0:CGATGT\nCAAGTAAGACTCTCCTTTTTACCTACAACCTCGAAGAGGGTATCCTCCACGGTATAGTGGAAATTGGGTACATCCAAACGGGGCAGATCCTCTGTAAAGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:13467:2042 1:N:0:CGATGT\nCCCAGCTTTTGGCAAATTTTGAAGCTCAAGTCTCTGTCAACCATCTTACTGCTCCTCGGACCGCCACTGTTCGAAGTTATAGCTGGACCATCTAACAAAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:13267:2114 1:N:0:CGATGT\nTGATGGTCTTTCCAGTTAGAGTCTTAACGAAGATTTGCATTCCTCCCCTAAGACGGAGCACCAAGTGGAGAGTTGACTCCTTCTGGATGTTGTAGTCAGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13385:2137 1:N:0:CGATGT\nGTTAGTGTCATCTTTACCCATGAGCTTTTGATACCCAAGAGCTGAGGAATTATACAGAGGCATGCTTCGCATTGTACCATCCAAAACTGTGACACCAATAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13260:2140 1:N:0:CGATGT\nCTCATCTTGAATAGCTAGTAATCAGAGAAATGAAAGTGAGAGAGAAACCGAACCAGGGAAGTGGGAGAGGAATAGAACCTCATCTTGAATAGCTAGTAATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13418:2147 1:N:0:CGATGT\nCTTGTCAATGCTGGTTGCCAGCTCTTTCTTCGCCTTCTCCAGCCCAGCCCTCTCAAATTCATTTAACGGGCCAAGCGGGAAAATCTCTTCAGCTCCACTAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13457:2228 1:N:0:CGATGT\nACCAAGCGCGATGACCAATTGTGCGAATCAACGGTTCCTCTCGTACTAGGTTGAATTACCATTGTGACACTGTCATCAGTAGGGTAAAACTAACCTGTCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13437:2233 1:N:0:CGATGT\nGCCCAGGGTGGGGAAGAAATTCCAGATACAGTTCCCTTGGAAGATGACGAGTCCTTAGGGGGACTTCCAGGAGTATTGCCTGTGGGGCGAGGCATGTCAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13285:2243 1:N:0:CGATGT\nATGAAAAGGACTTTGAAAAGAGAGTCAAAGAGTGCTTGAAATTGTCGGGAGGGAAGCGAATGGGGGCCGGCGATGGGCCTCGGTCGGATGCGGAACGGCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13331:2247 1:N:0:CGATGT\nCGGGGTTTGTTGCACGTATTAGCTCTAGAATTACTACGGTTATCCGAGTAGCAAGTACCATCAAACAAACTATAACTGATTTAATGAGCCATTCGCAGTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13728:2069 1:N:0:CGATGT\nCTCCGGGTTATTCTTATACCCATTTGTCACATTCGGGCCACGAATACAAACCTCCCCTTTCAACCCAGGCCCAAGAACAGTCCCATTCTCATCAAAGATGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:13531:2075 1:N:0:CGATGT\nCGGTAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTTCCATGACCACCGTCCTGCTGTCTTAATCGACCAACACCCTTTGTGGGATCTAGGTTAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13581:2091 1:N:0:CGATGT\nCCGGTTCGCTCGCCGTTACTAGGGGAATCCTTGTAAGTTCCTTTTCATCTTTCCCTCGCGGTACTTGTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:13556:2115 1:N:0:CGATGT\nGCGGATTCTATAGCGTAGAAGATTCTAGAAGCTAAATCAGAAGATCTCTGCCATGCAGCGAGTCGCGGTAGGAGGCTGGATTCGCTACTATGGCTGACCAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13578:2117 1:N:0:CGATGT\nTCCCCTCGGCAAGGTGCCCCAGCTTTGATGAGACCAGTAGCAAGACCCACCGAGAAATCCGCAATGAAAGTGTCCTCAGTTTCACCACTCCGATGTGATAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13622:2141 1:N:0:CGATGT\nACCGAAGCGACAAAGGGCTGAATCTCAGTGGATCGTGGCAGCAAGGCCACTCTGCCACTTACAATACCCCGTCGCATATTTAAGTCGTCTGCAAAGGATTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13685:2151 1:N:0:CGATGT\nAGCTTGTGGTAGATGTTTCTAGGCCTAGGACGCTCCCTTCAGGGCAGTGGGCTCCTCTCTGACCTAAGGCAGGAACAGAAATGCCATCGAAGAGCAACTAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13542:2163 1:N:0:CGATGT\nGCCAATCTTCCATTTTTTATCTCCTTCACTTTGAGCTCAGCAAAGGCTTCTGGGTCGTCGGCTAGGCCCAATGGGTCGAAGCTACCACCCGGGTAAAGCGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:13715:2166 1:N:0:CGATGT\nAGCCCATGCTCGCGGATACCGAAACCCAATGCAAGTGCAGCACAAACAAGAAGTATGATCAATATTGGGTCTTGAAAAGCATTCCATACAAAGTACAGGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:13644:2172 1:N:0:CGATGT\nCACAAGCCAGTTATCCCTGTGGTAACTTTTCTGACACCTCTAGCTTCAAATTCCGAAGATCTAAAGGATCGTTAGGCCACGCTTTCACGGTTCGTATTCGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13532:2197 1:N:0:CGATGT\nCTGTAACATAGACCCATCTTTAGTGAATCGGACTCTCTCAACTTTACCCTTCTTAACAGCGCTCAAAAACTCACTATATCTCCATTGGGAACCTTCTGGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:13503:2199 1:N:0:CGATGT\nCCTTGACAAGCAGCAACATGTAACGGCGTTCGAGAATCGACATCGACGAAATTCACATTCGCTCCTAAATCAACCAGCTCTTTAATCCCTTCCAAATCGCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:13579:2207 1:N:0:CGATGT\nAGGAGCGACGGGCGGTGTGTACAAAGGGCAGGGACGTAGTCAACGCGAGTTGATGACTCGCGCTTACTAGGAATTCCTCGTTGAAGACCAACAATTGCAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13604:2219 1:N:0:CGATGT\nCACGTCCCGGTTCAGGAATTTTAACCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:13675:2228 1:N:0:CGATGT\nCCTTGGTTTAATGTCCGCGCACCTTTGAGCAGTCCAAGGAAGGGACGAGATCGATGCCTAAGTCGACACCACACTTGCTGGCGAGGGGACCGGCGTAGGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:13614:2248 1:N:0:CGATGT\nTGTACTTCCTCGGATAGCAGATAGTGCAAAGAATGACAAAAGTGCGGTGTTGCGTGCTAGATGCTGTGAATATGCACACTTAATTTTGGAGCAGTGGCCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:13871:2050 1:N:0:CGATGT\nGCCGTCGCAGCATCAACCCCCCACCGGGATCCCGCTCCGTGCCATCCCCTTCAACGTGGTGGATCACGGGAACGGGAAGCCGGATGTCGGTGATAGGAGTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:13996:2163 1:N:0:CGATGT\nGTGGTATTTCACTTGCGCCGAAGCTCCCACTTATGCTACACCTCTCAAGTCATTTCACAAAGTCGGACTAGAGTCAAGCTCAACAGGGTCTTCTTTCCCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:13949:2201 1:N:0:CGACGT\nCCCAAGTGAAGTCTCTGATTGATTGCTCTACATGTCAGAGGCACACAAAGTTGAAGACATTAAATTAAAATACAGAGATAAGGATTTCTCCTCTTTCCTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:13903:2210 1:N:0:CGATGT\nGTTGAAGGCCCTGTGGTGAAATTAGGCTCGAAATGTTTTTCTCGGTCTACCCATAAGGGTGCCATTATGAAGCACCAAAGGTTCTCAGGAGCAGGAGAGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:14157:2018 1:N:0:CGATGT\nTCCTAACCAAACTCAACGCCACATTTTTCATAGCCATCAATGCAATTTCTTTCCCCAAACACGCCCTTATACCGGCTTGGAAAACCGGATATCTATACCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14079:2034 1:N:0:CGATGT\nCGCCACCACCAGTACCTATTTTTAAGAAACCTTGCCCTCCAATTATCAAGAAACCACCAATCCCAGTTTACGAACCAAAGCCTCTCCCTCCTTTGCCAAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:14220:2084 1:N:0:CGATGT\nTCGCCATACATCAATAACATTATCAAATCCCCATAAATTTGAACACCACTTGAGCTGCGGGCTGCACACTTTCCTGCAGTCAGATCGGAAGAGCACACGTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:14161:2103 1:N:0:CGATGT\nAGGTTCCAAAAACATCTGACTCAACAAATCCGACGGCTCAGATGCAATCACAGATCTATTAGCTTGAGCCTCTAAACTCCCAACCATGATGATCAACAACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:14225:2170 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACAACACACACTTCGACAACCGCCACCCCTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14165:2207 1:N:0:CGATGT\nATAAATTCCCAAACAAATTTGATGGATTTTATATCAAAGTTGCTTTTGTTGGCTATATGCATAGGTACCCGATATGGCTGCTTCAGTTCCAATAATTTGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:14187:2212 1:N:0:CGATGT\nCGCTTTGCCAACAAGCTCTTGCCACTTGCAACAGCAGTGGGATTAGAAAATGAATCTGCATCACTATGTAGTCTAACACCACAGGATGCTGAAGCTCTCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14143:2222 1:N:0:CGATGT\nGCCACATTATTTTTTGGAAAGTTCTTCTCTGACCATTAAAGTAGTATGCATTTCACAAAAATAAATTTGGAAAGAGGAAAAAAAAAAAAAAAAAAAACACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:14058:2230 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAACGGAGAGCAAGTTGGCGAGGTGATTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:14220:2244 1:N:0:CGATGT\nAAGCATACACATAGAGCATGCAAGGGCCGGTCAAGCCGGTTTTAGATAACTTTTCTATATAACAGGGAGAAGCACCACAGTAAGGCTAGCATTATCACCAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:14287:2012 1:N:0:CGATGT\nAATAGATGCATAATTTCAAAGCTGATATACCCTGAAAATAACTGGTTTCAATTTGCTAATCAGAACATACAATAAGTTCTACTGTTGATTAACATCTCTAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14488:2032 1:N:0:CGATGT\nAGATCATCATAATTCAACATATTTACTAAATGCTCATAACTTAGTAAACATTTTGACAAACACACAATGACTTGTTCAAGTATGGAAGACAGCCATTTGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:14324:2044 1:N:0:CGATGT\nCTCGGATTCTACTTCCTCTCTAGGACAACTAAGATCCACATCTGACGGACCAGCCATAGCCGTACTAGACGACCTAAGATCAAGCTTCAAAGCCTCTGCAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:14294:2151 1:N:0:CGATGT\nCGGTGGTCGAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGTAAAAAAAAGAACCATTGACGCTTTGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:14379:2159 1:N:0:CGATGT\nGGCAGAAATTTGAATGATGCGTCGCCAGCGCAAAGGCCGTGCGATCCGTCGAGTTATCATGAATCATCAGAGCAACAGGCAAAGCCCGCATCGACCTTTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14362:2206 1:N:0:CGATGT\nGGCTTTTCTAACACTCCTCCTCCCGCTGATCCAGTTGCTGACACAGCCATTAGAAAGCCACGTTGGTTCCACAATCCTTTACAAAGAACATGTTTATCCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:14342:2223 1:N:0:CGATGT\nCACCGATGCCTTTAGCTTTTCCTCCAAAGCCTTGGCAGCCGTTACATCTGAAAAGCCCACAAAGTTATCCTCCTCCCCAAAATGAGCTTGAACAGGAGCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:14717:2007 1:N:0:CGATGT\nCATGGCAAAACCGCGACATTGCTGGAATCACAGCCTGTCATGACTGACTGCATTGCGGATGTGTCCACAGGAGCATAGACAACCATGGACTCGTAGTAGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:14517:2074 1:N:0:CGATGT\nCCACCGTCCTGCTGTCTTAATCGACCAACACCCTTTGTGGGATCTAGGCTAGCGCGCAGTTGGGCACCGTAACCCGGCTTCCGGTTCATCCCGCATCGCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14731:2074 1:N:0:CGATGT\nCTCAATCTTCACTAAGTTATGCTTCTTTTTCCCCACCTGCTCACAAAGTCCCTCCTTAAGTTCAGCAATATCTTGATCGATCAATTCTCCTCCTTCAGCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14538:2151 1:N:0:CGATGT\nATTCCTCATAACACCAATATCATAAACTGGGGTGAAATCAGGGTTAAACAACCCAAAATTCTTCTCAGCAATAGGTCCAGGCTTCTGATTCTCAACAAACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14713:2165 1:N:0:CGATGT\nGCAAAGCAAAGCAACACCAAAGTAACTACACATTGATCAAATGCACAAATTTTACAAAATTATTCGTAGCCTTCTGGCTTGTAGGCGATGAAACTGATGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:14988:2172 1:N:0:CGATGT\nGGGGGGCCCACTGGCCGACGCCTGGAGCGCGCAGGTGCCGAGGCACGCTGTGACAGCGCGCGCTGACTACCACAATCGCGAGGACAGCACTCCCGGAGACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:14947:2188 1:N:0:CGATGT\nTTCGTTAACGGAATTAACCAGACAAATCGCTCCACCAACTAAGAACGGCCATGCACTACCACCCATAGAATCAAGAAAGAGCTCTCAGTCTGTCAATCCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:14924:2194 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACACCTACCTATACCAGAACATCGATATCCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:14879:2224 1:N:0:CGATGT\nAGGGACGTAGTCAACGCGAGCTAATGACTCGCGCTTACTAGGAATTCCTCGTTGAAGACCAACAATTGCAATGATCTATCCCCATCACGATGAAATTTCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15004:2005 1:N:0:CGATGT\nNTCGAGCAGTCCACCGACAGCCGACGGGTTCGGGAATGGGACCCCCGTGCCCAGCCCTCAGAGCCAATCCTTTTCCCGAAGTTACGGATCCATTTTGCCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15080:2021 1:N:0:CGATGT\nGGATAAACTCCTCATCTTGAGGGCGTTCAAACACCACGGTGCTACTTAGCTCATTAAGCATGGCGCTAATCCCATTCTCCCTGAGCCGGTCTTTAAGGTAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15078:2061 1:N:0:CGATGT\nCGCCATCAAGAAGAATTTCTGGTTCGACGATGGGCACGAGACCATTGTCCTGTGAAATTGCAGCGTAACGAGCAAGTCCCCATGCAGCTTCCTTGACAGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:15124:2095 1:N:0:CGATGT\nGAGAAGCTCAGAAATAATGAGGTTATTATATTAATAATTAATCAGTATGAGAGAGAAGCTCAGAAATAATGAGGTTATTCCACCCCATCAATGGGATTAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15058:2138 1:N:0:CGATGT\nAGCACCAATGTCCTCAGGGCGCTTGGTCAAGTGACCGTGAACACCTTGAGCAATGTCAGGACTTTGCTGCTCAATGTAGACCAAGACCTTGCAGTTATCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:15051:2178 1:N:0:CGATGT\nTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACTAATTAGATGACGAGGCATTTGGCTACCTTAAGAGAGTCATAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:15018:2191 1:N:0:CGATGT\nGGGGCTTTGAGGATACGTGAGGTAAGGATGACGTCAGCGGACGGGATTTGAAAGGTCTTCACTGTACAGTAGGCCATTTGTGTGTTTATTTCTACTCACTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:15071:2197 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAACTTCTGGTACAACAGCACCCGACCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:15119:2245 1:N:0:CGATGT\nTAAAATTGGAGCAAAACTGAGAAATGAAAGAAATGGAGAGCAAGGGAATAGATGATTAATTTTATCAATTAATGAACAGGTGGTAATTGAGAGATAAGGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:15494:2018 1:N:0:CGATGT\nGCAGGATTGGGGTCGAGCATGCGAGTGACAAGAGAGCACGCTTCAGGGGAGAACCAAGCGGGGCAGCTGAAATCACCCTTATAGATACGACGATACATTCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:15308:2054 1:N:0:CGATGT\nCGACCTGTTATTGCCTCAAACTTCCGTGGCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15437:2087 1:N:0:CGATGT\nCCTGTTATTGCCTCAAACTTCCGTGGCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGAGTCCGCATAGCTAGTTAGCAGGCTGAGGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:15353:2100 1:N:0:CGATGT\nGCCCACTTCTTGAGCATAAACCAAACAAATAAATTAAAAAATCCAGAAAAACTTTCATTCACTCGAGATAGGATTTTCATTCGGAAATCACTTTTAATTAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15259:2220 1:N:0:CGATGT\nCTCAGAAAGAAAACTTCAAAGACTGTTTTAATTTCAGGACTCAAAACTAAAGATTCAGATTATCCTGCCCTGTCATCCATCTTATCATGTTCGATCATCAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:15732:2003 1:N:0:CGATGT\nNATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAATGAGGAATTCACCTGCGCCGCAGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15541:2026 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAACCAAAAATAGTAACCTGTGGGTAGGGGCAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:15671:2108 1:N:0:CGATGT\nCTTGGGGGACTAATCCCCTACTGCAGGTCGGCAATCGGGCGGCGGGCACACGCGTCACTTCTGGCCCGGATTCTGACTTAGAGGCGTTCAGTCATAATCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:15607:2111 1:N:0:CGATGT\nCACAATCACAAGCACCCATACACTCCTCCATTTTTGTAACAAAGCCTTTGACCTGGACAGGAATTTTCCATTCGATCGAGCGCAACTTCTGTGCAAGCTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:15572:2115 1:N:0:CGATGT\nGTCGGGGAGCTGAAACGTTATGCTATTCATTTTGACAGGACTGGTCAACCAAGTGGATCCGCTGAAGTAGTGTATGTTAAGAGAAGTGATGCATTTGCAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:15647:2138 1:N:0:CGATGT\nATGCATGCAAATTTATCAACTAAATAACAAGTTTGAAATATAATAGATTATATTGTAACAATATTTATGAATTGTCAAATAATTTCATAGGGTTATATGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:15546:2184 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAACAAAAAAATTGAGTCGCCCACAGCGCACGGGTCAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:15833:2017 1:N:0:CGATGT\nAGCAGAGCAGATGTTTCAGCAACAGCCCCCTCAACAACTCTAACCGCAGAATTGTCCAAATATTGTGCTAAATATTTAGCCATCAATGATGATGTAGCAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:15784:2055 1:N:0:CGATGT\nAGGGCCGAGTGTTCCACCAGTGTGAACCAAACCATTCTTCCAAAACACCCAAATGATGCGACTGTTCATGCTCGTTTCCTGAGAGGACATCCCCTAGTATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:15752:2130 1:N:0:CGATGT\nCGTCGATATCTTTTTCCTCATCTTCTTCCACAATAATCTGTTCAACCACCTTGGATATTAGGTCTCGATCAACCTTCCCAGATGTTGTCACTTTCAGAACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:15887:2145 1:N:0:CGATGT\nCGAAATATTAATTATAACACAAAAAAGAAGGTTACATTTGAACAGATGAACTGAGAGAGACTAACACACAACACTCTTTCACTTCTAGAGTTCCTTGGTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:15910:2186 1:N:0:CGATGT\nGGATGGTCCTAGTTGTTGGTTAGGTTGAGGTGCAGCAGCTTCGAGCAGGGCTCGGGTCCCACGAGCTGCTGGCCTAGGGGGGATGTGGGTCCCACAAGAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:15847:2230 1:N:0:CGATGT\nTCCACGTCGCTCACCTCAATCTTCTCACATGGTGCTAAGCTGCTACAAGCCAATGTCACTACTTCCACACTGCTCGATGTTCCTCTAACGTTCTTTATTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:15932:2230 1:N:0:CGATGT\nCCGCAGAGTCAAACAAAAAATAATACCAATTACGTCTCAGGTGTATACGGGGAGTACTAATATGGTTCCAATTATTCCTAGCAAAGCCTAAGATCTTAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:16089:2097 1:N:0:CGATGT\nATTCTACAACATCACTGAAAACCATATCGACATTCTCATCAGGCTCACCAACCATCTGGTGCCACATACCAGGGTAGATCTTGAGAGTCTTATCCTTGCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:16178:2104 1:N:0:CGATGT\nCAATAAGCATCTTCCAATGGCATCCTCCAAAGTTTTTCCCCCATCACTTCTGATGCACTAAACACCTCACTGGAAAGTGCATCATTGGGTGTAAACACACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:16042:2196 1:N:0:CGATGT\nCTGATGAGTATGAGGATTTACTAGGAGATTTTGAGGTTTGATGTCACGATGACAAACACCAATACAGCGATGAATGTACGACAAAGCTCTGAAAATCTGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:16029:2231 1:N:0:CGATGT\nGTGGATGAATCGGACTTCTTTGTGGCTGGCCAATCTTCATCCCATTTCGTGCTGCTCTTAGCAGCAGAGACTGAAACTGTTCCATTCATATCCTTTGATGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:16357:2009 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACATCCATGCTACTCATCTTCCTTAATAGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:16336:2095 1:N:0:CGATGT\nTTGTGTAAGACCGTCTTACTATGCAATGGTTTATAAAACAATTTTGGAAAGGAGTACTTTTGAAAATAAAGGTATTTGTGAGTCATTACACAGCGAGATTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:16253:2098 1:N:0:CGATGT\nTCCGGGACCAGTAATTGAGTTCCCTGTTTTTCATATCTGTGTGCTATGTATGTTGTGATTGCTCTTGATTCAAAGAGCTTAGAGTCTCCATCTTCAAAGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:16364:2115 1:N:0:CGATGT\nGCTTTCTCAAGGGTTTCTTCAACCGCTGATTCGATAACATCAACAGCCTTGGTTGTCTCAGTTTCTTCAGGTTTTGCTTCCACCTCTTTCTCCGGTGTTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:16436:2145 1:N:0:CGATGT\nTTGGCAAATGCTTTCGCAGTTGTTCGTCTTTCATAAATCCAAGAATTTCACCTCTGACTATGAAATACGAATGCCCCCGACTGTCCCTGTTAATCATTACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:16458:2199 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGCATGCCGTCGTCTGCTTGAAAAAATTTTCGGGCGGTGGCTACGCGGCTGCAGGTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:16584:2011 1:N:0:CGATGT\nTGAGGAAAGCCCCTGGTAAATAGCCCAAGACCAACAAGGGAAACCACTGGTACGGCAACAACCGGGGTAATCAGCCTTGTCATATTTCCCCATATTTTGCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:16714:2042 1:N:0:CGATGT\nCCCAAAAATGTTTAACTTACAAACTCTTCAAAGTGTTCCAAAACACACATGTTTGCTCTTTTTTCACTTCTCTTTATGTGATTCTTAAGCAACATTACGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:16606:2070 1:N:0:CGATGT\nGGAGATGCTACAAGTATACACGAATGGTATCTTTTCTGGATTATTTGCAAACACCGATGTTTATCTTCAATCCATTGGCATGTTTGTCGTCGAACAGTGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:16502:2087 1:N:0:CGATGT\nAGAGAAGCAAGTAATTAGGGCTGGATCCGGACCCAAACCCGTACCCGGTCAGAAAGTTACCGTTCACTGCACCGGCTTTGGGAAAGATGGGGACCTTTCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:16609:2100 1:N:0:CGATGT\nTCCGCTATGAGTGCTCGGTAAAACGACCATTTTCCTAACTCTTCCATATCGAACAATGGTGATGGTGGTGGATCTTGGTAGTCTTTTGCCATGTCTCGTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:16661:2175 1:N:0:CGATGT\nCAAACATCTTTACCATCACCATTCAAAACAATACTTTTAGCAAAAATAGAAGCTTCATTAGAAACCCTTTCAAGGTCCATTTTATATGCTTTTCCAATCAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:16633:2184 1:N:0:CGATGT\nCGCCGGGGGCGCACCGGACACCACGCGACGTGCGGTGCTCTTCCAGCCGCTAGACCCTACCTCCGGCTGACCCGTTTCCAGGGTGGGCAGGCTGTTAAACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:16573:2198 1:N:0:CGATGT\nGCGAGCTTTTACCCTTCTGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAGGACACCTGCGTTATCTTTTAACAGATGTGCCGCCCCAGCCACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:16963:2025 1:N:0:CGATGT\nGTGGTGTTTCATCTTCGGCGTTCATACAGCCTAAGATCGGTATTTCATCGCCGTCGATTGAGGTGTATATTGCTGGAATGTGTACGGATATGCCGGTTATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:16896:2035 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAACAAAAAAACTTATGTTTCATCACAGCTTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:16835:2043 1:N:0:CGATGT\nCTTACTAGGAATTCCTCGTTGAAGACCAACAGTTGCAATGATCTATCCCCATCACGATGAAATTTCAAAGATTACCCGGGCCTGTCGGCCAAGGCTATAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:16818:2056 1:N:0:CGATGT\nTTGCAGCAATCTCATTGTGAGGAAGACCAGCAGCAGAAAAGAGAGGAATTTTCTGTCCTCTGGCAATTGAATTCATGACATCTATCGTGGAAATTCCCGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:16884:2119 1:N:0:CGATGT\nACAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGCGTATCGCCGGCAGAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:16782:2140 1:N:0:CGATGT\nTTGCCGACTTCCCTTGCCTACATTGTTCCATTGGCCAGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCAGCACTCGGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:16755:2145 1:N:0:CGATGT\nCCGGTCTCGTCTGTCTGCTGCAACGGGGTCCGGAAGCTGAATAATTTGGCTTACACCACACCTGAAAGACAACTAGCTTGTGCTTGTATTAAGCAAGATAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:16777:2172 1:N:0:CGATGT\nATGTATACAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGAAGCGTATCGCCGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:16797:2177 1:N:0:CGATGT\nATTAAAATGTACAGATAATCACATATACACATACATACATCATTTGTTGCCTCCTTCCCCAATGAGATAAGAGTTGTGGGTGGGTCATGAGCGAGCAGGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:16822:2220 1:N:0:CGATGT\nCTACGAATCTAGGTTTGTCGCCCTGTCTGAGAACACTTCTGACACGCCTTGACATGCTTAAAAACTTGGTCACTTTTCTTCTAGAAGAAGCCTTGAAGGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:16884:2234 1:N:0:CGATGT\nTACCAGAGTTCAGACCAACATGACAGGCAAAAACATCCTACTATCATATTCAGACATGACAAGAACGTACAAGATTATTACATCAGCATCCGCTACTAAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:16805:2234 1:N:0:CGATGT\nCCTTTGCAACCGCTCCTCGAACAGCTTCACCCAACTTAACCGCCTTTTTCCTCATCTCGAACCCTTCATCTGACATCATCAATGTCCTCACCGCATTCTCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:16827:2238 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGCCGTCTGCCTTATAAACCAAATTACTCAAATTAGTACCCTTTTTCCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:17215:2009 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAATACAGTACACGAGAGTAAACTTTGCAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:17108:2028 1:N:0:CGATGT\nGGGAGCAGGAGTGATGCCAAATGCGGTGAACTCGTCAAGTACTGTTATCGGCAAGTGCCATTGTTTTGTATCGAGTTGTCAATAATCAGAATTGCTAATCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:17201:2040 1:N:0:CGATGT\nTTTCGCTCGATCCTGAGTGCGGAGCCTCACTTTTAGAGTCATTACCAGATGATGCCTGGGTCGAACCTTCTTTGCCGAGGGAAACCTTTCCAACTTCATGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:17003:2082 1:N:0:CGATGT\nGTATGATTAGAGACTCGACTAGTCACTATGGCAAAAGGACTAGAAGTGATGGAGATGGCATCTCTATATTTCAATCTTCAAATATTTGGATTGATCATTGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:17102:2145 1:N:0:CGATGT\nCTTGCATTAGCCACAGAGACCTTCCATATCCCTGCATGTTAAAGGCAACCATCTGAGCCCCATGCATCCACCCAATGAGAGGGTTGTAATTCGATGAGGTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17165:2174 1:N:0:CGATGT\nCCACTGTTGTTGCTGTTACATCTGATGCCGTTGAAAATGTCCTTGTTGATGATGATCTGACGGCTGCTGTTGATCCTTTAATCAGACAGGTTGCAGCTTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17098:2197 1:N:0:CGATGT\nCTGGCAGTATCTGGTCGGAAAAAGAAGCTAACTGGTCGGAGATTAACCAGTTGTTTTTGTTCTTGAGCAAACGTATTTTTGATCAATCTTGGTTCATACAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:17019:2199 1:N:0:CGATGT\nGTGTAATTAAGCAATGGGTAAAGGTCTTACGATCCACTAAAGCCCATACATACCAACAAGGCAACAACTAACTTGGTACATGCCTCAAATAGTTTTATTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17147:2221 1:N:0:CGATGT\nTAGGAGAGGAAAAACGAAAGAAAACAAAAAAGGAGAAAAAAATCGAAAAAATGCAATCTCCGAGAAATCGAACCGCGAAAAAACGCCGATCTCGAACAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17353:2012 1:N:0:CGATGT\nTGGAATTCGTCTTTGGGAACACATTGATCCAGATCTTCTTTTGGCTGTATTTCTTCCGGCTCTTCTGTTTGAAAGTTCATTCTCTATGGAAATTCACCAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17275:2089 1:N:0:CGATGT\nGCTGATCTTTTCTTTGCTTCTGTTAACCCCAAAAATAAAAAATAAAAATACATGATATGATGGCAACTCCTTGTCCTTTCTGAATTCTGCCACCTCTCATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:17336:2105 1:N:0:CGATGT\nCTTTTGGTTCCTTCCCCTTTCCTTCTTTGGCTTTCTCCTTTTCAGCCTTCTTCAACTTCTCCTTATCTTTTGCAATTTCCTTCTCAACTTGCTTGTCTGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:17408:2114 1:N:0:CGATGT\nCACACCAGCATTCAACATGCGCTTTCCCTCATCTGTAGTTGCAGCTTCATCATGGTATTCGTACTGCTCTTTCTCAGTGCCATCCGTAGCTACCCATCCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:17251:2114 1:N:0:CGATGT\nGGGCAAACGGCACGAAGGAGATAAGAAATAGATAGGGAATGTCTGATGAAAAATACATGTGCCATTGGAAGGAATCAACCAATGTTCTCTCTTACTTCGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17365:2118 1:N:0:CGATGT\nCAGTTGCACTAAACTTAGCCCAGTTGGTGGCCCTGCTCAGCCAATCCAAATTGTCCCGCAAAAATGTATCAACAGTAGTACCAGCATGCATAATTGCATTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:17457:2144 1:N:0:CGATGT\nCTCAACTTGAAACCCGATTTTCTCACCCAGTTTTACCAACTGATCCTCATTGGTTATCGCCCTAGATCCGTTCCTTGATAGAATGACAATTTTAGGCTTAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:17467:2172 1:N:0:CGATGT\nCTCTTTTCCATTACTGTCCTCTCCTGACACATTTGGCACCTTGATTTCAGGCTCTTGGACCTCATTCTTCTTGGAGTCATCTCCGGAGGACTTTTTCTTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17646:2110 1:N:0:CGATGT\nTATCACCAACCATCAACTTCAAGATACTAATTGTGTTTTACAACAACAGGGAACACAATGGATGAATCCGAAGTTACAATTAAATTGACCAGGAAAACAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17694:2180 1:N:0:CGATGT\nCCCGAAGTTACGGATCCATTTTGCCGACTTCCCTTGCCTACATTGTTCCATTGGCCAGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:17867:2050 1:N:0:CGATGT\nCCGGATTTTTCACAAGAACGTCAACAACAATATCAGCTCTATGAAGGTCAATGTGAGGAAGATGAATCCCCGAAATATCTGCAGTTGGCTTACCGAACCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17967:2191 1:N:0:CGATGT\nGTCCGAACACGACGGGGCTCTCACCCTCTCTGGCGCCCCTTTCCAGGGGACTTGGGCCCGGTCCGCCGCAGAGGACGCTTCTCCAGACTACAATTCGAACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17936:2194 1:N:0:CGATGT\nCAGGGAAGTGATGATGATGGGGCAGATGATGGTGATGTATCGGAGGAAGAAGAGGACTCGGGGGTGGAGTCCCCTGTAGTTGAAAATGGGCTCGGGTTGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17949:2234 1:N:0:CGATGT\nTTAAAGTTTGAGAATAGGTCGAGGGCATTGCACCCCCGATGCCTCTAATCATTGGCTTTACCTGATAGAACTCGTTTAGAGCTCCAGCTATCCTGAGGGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:17992:2243 1:N:0:CGATGT\nTCGCTGATGTTATCGCCTCAGCTTGCTGTGACGGCACACCTTGTGCCTCTAAGCTCTTTACAAGAGCGAGAGGATCGACAAGAAAAGCACGTTTAGGTTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18196:2037 1:N:0:CGATGT\nCTTGGTGTTATTATCTAGAATCCAATCGGAGGATCAAATGATATCCAACCGTTCAACTTGTTCTCGCTACTTGCCATTGCATACTGATACTTATCATCCAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:18027:2114 1:N:0:CGATGT\nGTTCTGTGATAAGATGCCTGTGAAGATGACCTATTCCTTTGGTTTTCCCTTGCAAAATGACGATGACCCCTTCGCATTGCAGCAGCTGCAGCTAAATGCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18140:2188 1:N:0:CGATGT\nTGTACTCGTGCTCGTTAACACCAACAACGAACATAGGAGCATCCTTGCTGGGAGCAGAGATGATAACCTTCTTGGCACCACCCTTCAAGTGAGCAGCAGCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:18151:2229 1:N:0:CGATGT\nCACTCCCGGAGACTGGGTTTCCGTTGCCCTCACAATCCACGTCAGTCCGCACCCCGAGCCGATCGGCGGACCGGATTTAGGCCGTTCCGCATCCGACCGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:18205:2249 1:N:0:CGATGT\nCGGGAGGGAAGCGAATGGGGGCCGGCGATGTGCCTCGGTCGGATGCGGAACGGCCTAAATCCGGTCCGCCGATCGGCTCGGGGTGCGGACTGACGGGGCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18377:2005 1:N:0:CGATGT\nNTTCGCTTCCCTCCCGACAATTTCAAGCACTCTTTGACTCTCTTTTCAAAGTCCTTTTCATCTTTCCCTCGCGGTACTTGTTCGCTATCGGTCTCTCGCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:18312:2015 1:N:0:CGATGT\nCCGAAGCGACAAAGGGCTGAATCTCAGTGGATCGTGGCAGCAAGGCCACTCTGCCACTTACAATACCCCGTCGCATATTTAAGTCGTCTGCAAAGGATTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18277:2040 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTATCATTAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18386:2074 1:N:0:CGATGT\nGCGGGTCGAGCCACCCTGATTCGGAAGACCTTGTCAAGGACAACTGGTTCGAACTCGGTCACTTCAGATGATGGTGGTGGTTTGGTGGGTTTAGGGGCTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:18495:2107 1:N:0:CGATGT\nCCTGTACGCAAGGGCAGGATGGCGGGTATTCAATCATGAGGAAGAAGCTCAATACCATGGACAATAAGACCCGACTTATAAGAGCTGGTATCCACACCAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18353:2150 1:N:0:CGATGT\nATGAGATTTTCAGGATTTTCGCCTGTTTCTTCTCGTCCTCGCTGAATGAGGTATCATAATCAACAAACTTCACAGCCTTTTCATATCTCCTAGATGCCCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18265:2154 1:N:0:CGATGT\nGGTCTTTATAACCATTGAACTACCCGATGCAAAAGATGTGAAGTTGAAGCTTGAACCTGAAGGCAGATTCTGCTTCTCAGCCATGAAAGATGGCAACCCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18461:2195 1:N:0:CGATGT\nCGTTGCTCTTGTTTGCGCAATGTCTCAAACTTTTCCACGGTATCAATATCAATCTTATGCTTTGTCTTTGGCTTAGGTGGCTCAAAAGGGCAGGTCAGAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18346:2203 1:N:0:CGATGT\nCCCTTCTGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAGGACACCTGCGTTATCTTTTAACAGATGTGCCGCCCCAGCCAAACTCCCCACCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:18377:2221 1:N:0:CGATGT\nAAAACAATCACAGTAAACAAAAGCACAACCCTAATAAACTGAAACAAATAAAACAACACATCCCAACCGTGCGGCGATCCTGTAACCTTAACAAAATGTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18465:2238 1:N:0:CGATGT\nGCGAGTTATCATGAATCATCAGAGCAACAGGCAAAGCCCGCATCGACCTTTTATCTAATAAATGCATCCCTTCCAGAAGTCGGGGTTTGTTGCACGTATTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18403:2245 1:N:0:CGATGT\nACGGAACTGGAATTTGTCATTCCATTGTGGGCAATTGTCGCCGTCTTGGTCGACCCGCGTCCGTAATTTTCGGGCCGGGTCGATCCATATCACGGCGTAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:18321:2246 1:N:0:CGATGT\nCCGTTATTGTTGATTGCTTTTTTTTCTATCCTTTTGTCCTTGAGTAGAAATCGTACTATCTCAGGTTGTTTAGCCGCAACAGCTAGGTGCAAAATAGTATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18516:2009 1:N:0:CGATGT\nATGATCTTACAATATATATCATTACTAACATGTTAAAATATAAAAGCCTTACTTTTATCTCTCAAATTGAGAGACATGTATTATTATTATCATAAGACTAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18576:2016 1:N:0:CGATGT\nCCAATGATCAAGTCGGGTTTGGCTTGCAATTCTGCTGAAATCTCATTTGCAACATCCTCAGTGTAAGTCTCAAGGTATGGCCAGACTTCGAACCTGGAAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:18575:2089 1:N:0:CGATGT\nCCGACACCGGAAATATATGAATCGCCGAAGGTTACTTCGAACTTGGTTAAGAAAAAGGAGACTTTGCAGATACCGCTTTTGGACATCAATTTTCCTCCAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:18722:2154 1:N:0:CGATGT\nGAGAACAACCATTCATGTGCCCTGGTCTTAGGCACAAGGAAAATTCCACAATGATACATGAATGATTTAGAGTCTGATTGAGCATCTAGAAGCACAGCCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:18607:2157 1:N:0:CGATGT\nCAGGTCTCCAAGGTGAACAGCCTCTGGCCAATGGAACAATGTAGGCAAGGGAAGTCGGCAAAATGGATCCGTAACTTCGGGAAAAGGATTGGCTCTGAGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:18645:2191 1:N:0:CGATGT\nCTAGACCCTACCTCCGGCTGAGCCGTTTCCAGGGTGGGCAGGCTGTTAAACAGAAAAGATAACTCTTCCCGAGGCCCCCGCCGACGTCTCCGGACTCCCTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18603:2230 1:N:0:CGATGT\nGGCAGCTAATGTCATCGGCGCTGGGAACTCCCTCAATGTATCAGCCTGAAGTACAATACTGGCTGACAAAGCAAAGACGGCTCCCATTAGGCATAAAGCAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:18935:2082 1:N:0:CGATGT\nTCGTGCTTTATCATCTAACGGTAATTCATCTCCCGCCATTTTTAAAATTCCGAATCTGAAGTTCAAGTTGGGGGAAAATTAGGGTTTGTTAAATGAAATTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:18852:2128 1:N:0:CGATGT\nGAGATTACTAAAGCAGAACTGTGGATGCTGAAGTCAGCTGGTGTTCAGTGTGCTGGGAGTCCTTGTTTTTGGGTGGACTCAGATGGAACCTATCAAGAAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18955:2133 1:N:0:CGATGT\nCCAAGGTCCAACTACGAGCTTTTTAACTGCAACAACTTAAATATACGCTATTGGAGCTGGAATTACCGCGGCTGCTGGCACCAGACTTGCCCTCCAATGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18895:2134 1:N:0:CGATGT\nCCAAGATCGACAACCCTAAGTGTGAGGAAGCACCTGGTTGTGGAGAATGGAAGAGGCCAATGAAGAGGAACCCAGCTTACAAGGGCAAATGGCACGCTCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18932:2147 1:N:0:CGATGT\nCGGGGGGTTTGAATGGATAATCTGGGGGGAAGTGAATAGTGACAAGAAAAACTCCCCCAGCATAAGGACTGTCAGGAGGACCCATAATAGTTGCTTGCCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:18940:2212 1:N:0:CGATGT\nGCCAGTGTGATTGAAGCTTATTGTTCGAACTGGCCACCTGAAGTCATACAAGTCATTAGCAGAAGAAGAAACCAGAACTATCAAGTTGGAGGCACATGCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19123:2066 1:N:0:CGATGT\nCGAAAGACCAGCTGCTTGAGCGCTTTACTGGATTTGTTCCAGCAGACTCAGAACCGCTGCTCGAATCAGTTGAAGTTGAAGCGTTTCTGCAGTAGTTTGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19048:2096 1:N:0:CGATGT\nCACAAATTCTCCCAGCACATATTTGTTGCCTTTGAGTTCCAGCCTGTCCCAGATTGGAGCAGTAGCAAGTACAAAATGAAGGTGTTGGTGAATAGGGTCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19200:2106 1:N:0:CGATGT\nGTGGGTCCATTGGTCCCTTGAAAGGCCTTCTTTAGGTACCCCTTTTCTAGCCCAAGGTTCTCACATAACAAGTCCAATAATTGCTCCGCTAGCTCCTCTAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19015:2178 1:N:0:CGATGT\nTTCTTATTCGGCGAGGTACTAATAACCGTAACCTTAACACCAAACGCCTTAGCAAATTTCACCGCCATATGACCCAACCCACCTAATCCAACCACACCAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19029:2191 1:N:0:CGATGT\nATAAAGAAGATCTGGCCCCGGAAAGCTCATCTCGATTAGCAAAATGGAAATCGGATACATGTTTTCCGGCATTGGCACCACCGCTTCTATGGGTGGGAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19188:2219 1:N:0:CGATGT\nGCCAACATTCACTGTGGGTGGAAACCAGGAGTTGCTGATGGTGGTGCTAATGTAAGCCCACTTGGATGCCACTCTGGAATCAAGTCCCATTATTCCCTCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:19129:2229 1:N:0:CGATGT\nCCCGTATGTGGTGAGAACAACATTACTTTGAGCTAAAAGTTCAGCACCTTTTGATCGACCTTGTCCATAATAAACACAAACAGACAAGGAACCAGGCTGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19008:2243 1:N:0:CGATGT\nGGACAGCACTCCCGGAGACTGGGTTTCCGCTGCCCTCACAATCCACGTCAGTCCGCACCCCGAGCCGATCGGCGGACCGGATTTAGGCCGTTCCGCATCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19345:2002 1:N:0:CGATGT\nNAAAGATTTGAATCTAATTCCCCAAAGCTTTCACCCTCAACATGACAACTGACGATGCTCATCTCTGGTTCTTCAAATACAACAAAGTCCAATCCCTTAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19484:2020 1:N:0:CGATGT\nCTGAATAGAATGTACCGAAAGAAAATGTAACTTACTTGTTGGAGTTGGAGATATACATTGAAAAACAGTAGCTTATTACTTTCACATCCTTGGAGGCCATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19352:2040 1:N:0:CGATGT\nTGCGCATTAAAGTATCCAGATCGGTTCCCGTTCCAGAAGAATGTCACATGTCCAAACTTGACGGTTTCACTGCAAGCAAAAGTGCGTACACCATTGTGAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19269:2085 1:N:0:CGATGT\nGCAGGAAAGATTATCAATTTGATGCAATGCCTCATTCCCATTCCTATTGATTGCGAAACAATAGGGTATGAGGGTACACAAGCATCACATAACAAATACAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19328:2116 1:N:0:CGATGT\nGTGGAGGGCAAGTCTGGTGCCAGCAGCCGCGGTAATTCCAGCTCCAATAGCGTATATTTAAGTTGTTGCAGTTAAAAAGCTCGTAGTTGGACCTTGGGGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19393:2128 1:N:0:CGATGT\nCCAGCCTTGGCAGCTCCAGTGCTGCTGGGAATGATGTTAAATGAAGCAGCCCTTCCACCTCTCCAGTCTTTCATTGATGGGCCATCAACAGTCTTTTGAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19290:2185 1:N:0:CGATGT\nCTAGCTTGCAACCTCTTTACAATCTCATATTTGTGCTCAGGGAAAACGCCCGCGAATCCATCAGCTTTTTCTATCAGATCATCGATTGGCAAAGCAGCAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19742:2005 1:N:0:CGATGT\nNCGATTTGTCTGGTTAATTCCGTTAACGAACGAGACCTCAGCCTGCTAACTAGCTATGCGGAGTCACACCTTCGCAGCTAGCTTCTTAGAGGGACTATGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:19574:2071 1:N:0:CGATGT\nACAACCAACACAAGCGCGCTAACATCCCTCAAAAAAACAAGGAAAACTATGGAGAATCATCAACCAAAGGTCTCCGAAGCTGCTGCAGCTCGTTGCTCATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19604:2085 1:N:0:CGATGT\nGGTTTTTGTTTTGAAGGGAAAATGAGTGAAACCCAGAAGTAGAAATGAAGTTAGACGAAGAAGAGCTGAGTTTTGAAGCAATGCACGTAAGGCGTTTGTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19690:2092 1:N:0:CGATGT\nGCCAGACAAGAGATCCTGGTATACGAGCATGATTGATGGAGTTGAGTGAGATTTCTCTCTCTTCGACCACTTCCTTGTTCCTCGCTGAGGAGATTTAACGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19738:2097 1:N:0:CGATGT\nTGGGTGGTCAAGGTCCCTCATCTGTGGCAGTGGGTGGTGCTGGGGGTGGTGGTGCTGGTGGGTATAGTGCTCCTTTAGGCGGGGCCTATGCTGGGTCTCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19502:2102 1:N:0:CGATGT\nTGGGTTTCATTTGCAGGTACATGGGTCGCACTTGCAGTTGTCTCCGCACTTGCATCCTCCGTCCTCTCCACTCATTCCCATCTCTTTGTTGTCCACGTACG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19531:2128 1:N:0:CGATGT\nGGAAACGTTCACGTTGTTTGCGCCGAGTTCGAGGTACGCTTTGTGGGACACTGAGTGTCAACTGCCCCAAAAGTGTGGGGAGTTGGGGCTTTGTGAGGATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19669:2166 1:N:0:CGATGT\nCCCGACTGTCCCTGTTAATCATTACTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATAATGTTATCCCATGCTAATGTATCCAGAGCGTAGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:19664:2187 1:N:0:CGATGT\nATACAATTCCATATGGTGCAACATGACCAATAACAAAGCACAACAATGAAAAGAAGGATAGATAATTTAGAGACAACAGTGCATCCAAGTAAATGATACAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19595:2241 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGAGGTATCTCGCATGCCGACTTCTGCTTGTAAACTAGGCACTAGGCATGGTAGTTGCCTCCATGCGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19893:2049 1:N:0:CGATGT\nCATGAATCATCAGAGCAACAGGCAAAGCCCGCATCGACCTTTTATCTAATAAATGCATCCCTTCCAGAAGTCGGGGTTTGTTGCACGTATTAGCTCTAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19944:2061 1:N:0:CGATGT\nCCCCGGCCGGCACGCAGCAACCCGCTCTCGCCGCGCGAGCAGCTCGAGCAGTCCACCGACAGCCGACGGGTCGGGGAAGGGGACCCCCCCCGCCAACCCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:19859:2062 1:N:0:CGATGT\nACTTTTCGGTTTACCTTCAGGTATGGCAAAGCACCGATCACATTATCATAGTCGCTCCTATTGACTTGGACCATCTTAGATAAACGCAATTTGCGCTTAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19823:2093 1:N:0:CGATGT\nCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATGTGCAAGTGCCGGTCACATGGAACCTTTCCCCGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:19896:2109 1:N:0:CGATGT\nCAGCGATCTCTTCCCCAGGTTTCTTCGAATCAAGAACTCGACATATCGTCATGGCCAGTTCATCTCGTGAAAGTTGTGAGGCAGTTCTTTGTACTATTTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19919:2123 1:N:0:CGATGT\nATAGTAATCAATGTTTAATGTCATACCCGACAATGACCACAGCTCCAGCTTTCCCCTTGAGCATACTCTTCCCATGGCGAACAACGGCTGTGAATCTTTAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19881:2132 1:N:0:CGATGT\nCCGGACACTTCACCGGACCATTCAATCGGTAGGAGCGACGGGCGGTGTGTACAAAGGGCAGGGACGTAGTCAACGCGAGTTGATGACTCACGCTTACTAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19765:2133 1:N:0:CGATGT\nCCAGTAACGGAAGTATGAATCTCGATATGATCGGTTTTCCTTTTTTGTAGACGACTTTGGCTTTTTGGAGGATCGTGGAGCTGATACTTTTTCTGGGTATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19780:2149 1:N:0:CGATGT\nCACCACTTCGCTGAGGACTCACCCCATGCAATTCGAAGTACAAAGTTGAGCCTAATCGAGTCTGAGATTTCTCATCATTGTCCTGTGTATCAGATGGAAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:19887:2173 1:N:0:CGATGT\nCCCCACCTGACAATGTCCTCCGCCCGGATCGGGCCCCCGGCGGGGGGGCAGCCGCGGAAAAAAAGGCGGGGGGCGGGCCCCCCCTCCCCCCCGACATGATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19912:2174 1:N:0:CGGTGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTACGCCAATATCTCGTATGCCGTCTTCTGCTTGAAAAGAAGGAAGGAATTTGCCAGCAAAAACCAGGGGAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19757:2182 1:N:0:CGATTT\nCGAGTCAGACGAACGATTTGCACGTCAGTATCGCTTCGGGCCTCCACCAGAGTTTCCTCTCGCTTTGCCCCGCCCCCGCATAGTGCACCCTCTTTCGGGTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:19929:2184 1:N:0:CGATGT\nGCCGTAGCGAGAAAGGTCGCTCCCTGTTGGGGCGAGTAGGTGAGGCCCCTGATGCATAAGAGAAGTGAAGGCATCCTTGGGCAAGCCAAAACCAAGGGCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:19945:2225 1:N:0:CGATGT\nCTTGGCCGACCACTCGTCGCCGGATTTCTTGCATACGAATGTGTAAACACCCATTGCCGGAGATAAAGGAGATGGGACGAGAGAGTTGTGGGTGTGAGAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:19876:2236 1:N:0:CGATGT\nCCTCTGTATGTCAAGGACTCTTTACCGAAGCCAGCAAGATGTGGTGCGAATGGCATCATCCATGAACCCACAAACCAAAATGAAGCAATCCATAATAGCAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:20218:2007 1:N:0:CGATGT\nNCACTCATCAAAACCAGTATCATCAGCATCACCAGTTTCAGCAGGCAAACGGGTACCATGACCACTATAATGAACAAAGAGATAATCACCAGGCTCAGCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20219:2030 1:N:0:CGATGT\nCGCCAATCTCCCTCATGGTGTCAAAATATTGGGTCACCAGGACCATGTCCATGATGTCCTTGGCAGTAGTGCCGGGCACATTCTCAGAGAAGTTCAGCACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:20126:2038 1:N:0:CGATGT\nCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGCGTATCGCCGGCAGAAGGAGCAAGACGACCGGTGCACCCCGAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:20224:2057 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAGACACAACATCAGCGTCAGCGATGTCACGCTCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20187:2074 1:N:0:CGATGT\nACGGGGGTGATCTAAGAATACAATAGATATGGGGAAGGCTGTTGTTGTTCTTACCAGCAGTGAAGGTGTCACTGGAACTATCTACTTCGCCCAAGAAGGCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20034:2136 1:N:0:CGATGT\nACCAAGATCTGCACCGACAGCCGCTCCGCCCAGGCTCACGCCACAGGTTTTGCGGCGACCGCCGCGCCCTCCTACTCATCGGGGCCTGGTACTTGCCCCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:20097:2206 1:N:0:CGATGT\nTCTCGCTTACAGACCAAGCCGACCCTTCAATGTAAATCTTGTATCTGTGTATGCATTGATGTGACAAATCAGACTCCTTGAATCCCTGCCGCACTTCTTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:20194:2243 1:N:0:CGATGT\nACAAAATTGTAATCAGGACTTCTCCAGTATGTCCACCATTGTTTCCAAAGGCATGATTTAAACTGACCCCATGTTGATTGGGCATATTGGGTTGGAAAATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:20400:2056 1:N:0:CGATGT\nCGAGAGAGCAGAGAGCGAAGAGAAGGGTCGTTGTCGATGAACGAAGTGAGGAAAACGGTGCCGTTTTCGACGAGGGGACGGAAAGAGAAGAGAAGAAGAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:20337:2063 1:N:0:CGATGT\nGGCCAAAGTACTTGTCTCCGACGAGGCTCGTAAGGAATTCTCTTCTCTCCGTCGCACTTTTGACGAAGTCAACCTCCAACTCTCCACCAAATTCTCTCAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20324:2103 1:N:0:CGATGT\nATTTTATAACAAGGGAGGGTTTGTTTGGATGGAGTATTATTTTACAAGAGGGAGTATCGAAAATACAAGAATGATAAGATGAAAAAAAAGGGGGTGAGGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20468:2122 1:N:0:CGATGT\nGTGGCTTACTTGCATCATCATGGCTATGAGGATAAACTTCCTTGGTATCGTGGAGAGGAATGGAACTACCTTCGAGGAGGTCTAACAACGCTTGACCGTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:20357:2123 1:N:0:CGATGT\nGTGTAGTGCTAGTAGTAGATGGAGAATTCTCCTTTTGTTTGCTCTCAAAAAAGGTTGATCCTTTCTTGCACGCTTAGCCGTCTTGTAAGTTTAGGTGTCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20336:2159 1:N:0:CGATGT\nGACCCTGTTGAGCTTGACTCTAGTCCGACTTTGTGAAATGACTTGAGAGGTGTAGCATAAGTGGGAGCTTCGGCGCAAGTGAAATACCACTACTTTTAACG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20434:2160 1:N:0:CGATGT\nTGGCATGGACATCTAAACACATCTTAACCATGAAAGTCCGCCTTGATGAACAGAGAGTTACGAAGGCGGCCTCTCTAAGCAAATTCCTGGAAAGAAGTTAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:20461:2182 1:N:0:CGATGT\nCACCGGTCCAAATTCGAAGATCCTCAATAAAATCATCAATATTTGAGTTGTTTAAAAAAGAAATGGATTCGATAACCCTGTCAAGATCCTTGGTAGAATAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20357:2188 1:N:0:CGATGT\nCGCGCGGCGAGAACGGGTTGCTGCGTGCCGGCCGGGGGACGGAATGGGAACGGCTCCTTTTGGGGCCTTCCCCGGGCGGCGAACAGCCGACACCGAACTGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20591:2043 1:N:0:CGATGT\nGGGGGATTAGGTTTCTTGTATACTGGCACGGGTGGTGGGAGCGGTTTCTTGTATACTGGCACGTGTGGGGGATTAGGTTTCTTGTATACTGGCACGGGTGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20578:2077 1:N:0:CGATGT\nCTCAGATTCAATTTGCCTTGCACTACATCTATTCTCAGGCAATGCTCGATACTTGTCAACTTCATACAAGTTGGCCACTTGCTTCTCTTTCATGGAAGCAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:20607:2118 1:N:0:CGATGT\nTTTTATATTTATATAAAAACTATTATTTATATTAGAATAAGATTATATTTTCAAATTCATGATATTCTAAGATATTCTATTCATCAGTAATGTTGATGATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:20616:2168 1:N:0:CGATGT\nCCGTCGTGTTCGGACCCTGTCGCACCATGAGGCGCTGTCGCCGAGTCGGGTTGTTTGGGAATGCCCCCAAGCGGGCGGTAAATTCCGTCCAAGGCTAAATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:20577:2231 1:N:0:CGATGT\nCCCATGTGCAAGTGCCGTTCACATGGAACCTTTCCCCTCTTCGGCCTTCAAAGTTCTCATTTGAATATTTGCTACTACCACCAAGATCTGCACCGACGGCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:20990:2014 1:N:0:CGATGT\nCCTCCTTGTGAGGATTATCTCCTTCTTTATGACCTCCAATATTGAGTTTCTCCTGTATCGTGTGAATAATGCCTGCCATTTTTGTGTTTGTTTTAATTTGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20856:2054 1:N:0:CGATGT\nTCTCAGCACAAATCTCAGCCTTGCACACAATCCTTGTCCTTGCAAGGATCTCGCCATACTCTTCATACAAAGCAGGATCAGAGTCTGTACGATTATCAATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:20967:2118 1:N:0:CGATGT\nCTCAGGCATAGTTCACCATCTTTCGGGTCCCGACAGGGATGCTCTCACTCGAACCCTTCACTGAAGATCAAGGTCGGGCGGCGGTGCACCCACAGGGGAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:20969:2158 1:N:0:CGATGT\nACCGGATTAAACCCACATGAACCAAACCGGGTTCTCCATTGAGCCAAGGACTCGTGCCTCTCGAACCGGTCCACCCCTTCACATGCCACTACATTGCAAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:20982:2239 1:N:0:CGATGT\nGTCCGTACCAGTTCTGAGTCGACTGTTCGACGCCCGGGGAAGGCCCCAAAAGGAGCCGTTCCCAGTCCGTCCCCCGGCCGGCACGCAGCAACCCGCACTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:21175:2092 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAATAAAACAAAGAAGATTGACAACAGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:21165:2213 1:N:0:CGATGT\nCCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAAACCATGTGAAAGTGCCGTTCACATGGAACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:21082:2225 1:N:0:CGATGT\nCCTATCTCATTCCTCGGGCCATTTGTTTGACCTTGTTCAGGGGATCGACTGCATCTCTGATGATTACTACACCTTCAGGGCGCAGAATTCGGTCCATTTCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:21359:2032 1:N:0:CGATGT\nGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAGGACACCTACGTTATCTTTTAACAGATGTGCGGCCCCAGCCAAACTCCCCACCTGAAAATGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:21318:2062 1:N:0:CGATGT\nGTGTTTTCCTTACATTGTCAGGAGTAAAACTATTGTTTTGCGGAGGAACACTTGTGGCTTTCCTGGCAGAAAGTCGCAATGTCATACAAGCATAGAAATCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:21283:2071 1:N:0:CGATGT\nTTCTGCTTCACAATGATAGGAAGAGCCGACATCGAAGGATCAAAAAGCAACGTCGCTATGAACGCTTGGCTGCCACAAGCCAGTTATCCCTGTGGTAACTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:21330:2113 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTTTGCTTTTAACAAAAGTGAGATATTTTATTGTACCGAGAACAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:21259:2196 1:N:0:CGATGT\nCTACCACATCAGAATGGGGTGGTGGTGGAGGTGGTGGTGGAGATGAAGGGAGAGCATCCTGAATCTGCTCCGGCTGTGTATCTGGTGGTTGACCAATTGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:21383:2211 1:N:0:CGNTGT\nCTAGGAGTATAATAACCATAACACAAACCATAATTTAAGATGTGCCACAATTTGCACAAGTTCTATGTACATTGCAATAAGAAAGAACCAATCGAAACATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:21345:2221 1:N:0:CGATGT\nTCCAGCAAGAAGCAGAAGGTATTGAACATGTCGACCAAGTAGAAATATAGCATAATATCGATCATTCAATCTTTGGACGGCTACAATATGATCTCCTCTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:21377:2241 1:N:0:CGNTGT\nAGGGAATCGGGTTAAAATTCCTGAACCGGGACGTGGCGGTTGACGGCAACGTTAGGGAGTCCGGAGATGTCGGCGGGGGGCTAGGGGAGAGTTATATTTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:1376:2265 1:N:0:CGATGT\nGGAATGTAGCATGCTCATCGGGTCCTGCACAATATTTGCAACCAACGGCTTTGCAGTCCGCGTCAAATAAGCATCGGACTATGGTTTCAGGGCATGTTATA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1418:2308 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAACAAGATAAGTGAATGCGCTTTGCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1340:2313 1:N:0:NGATGT\nCTTGAACCGATGNCCACTTAGAACATATTCCACANTGGCAGGAAGCCTCCTACTACGTTGCAAAAATGGCAAAAAGTCTTTCGTCTTCTTTGCTGATGCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:1416:2391 1:N:0:CGATGT\nCTAGGAGAAACAACTCCGGTTGAAAGGAGAAACATGGAAGGCCTGATAATCGAGCAGTATTTCGCCTCTCTGAAACTTCTATTTTGTGGTCCTAAACCTAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1465:2404 1:N:0:CGATGT\nCTTTGCAACCGCTCCTCGAACAGCTTCACCCAACTTAACCGCCTTTTTCCTCATCTCGAACCCTTCATCTGACATCATCAATGTCCTCACCGCATTCTCTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1722:2250 1:N:0:CGAGGT\nGTCGTCAGCCAACGTGAGAGTGTCAAAAACGATAAACCAACCATCAGCATGAGCCTGTCGCATTGCATTCATCAAACGCTGAATAGCAAAGCCTCTACGCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:1618:2272 1:N:0:CGATGT\nCTCATCACCAGCAGGCCATTTACACAACCTAACAATCCCACACTTTATTGAATTCCAAATTTGCCCTTCCCTCTCTTTCTTCCTAATTTCTCTCTCTTCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1610:2301 1:N:0:CGATGT\nGACTTTTTACCTTATTAGCAATGGTTTATGAAACAAATCCATTTCGATTAAGCAAAGTCTATTATACCAAAACGCAGCCTCTTCACAGGTGCTTAAGCCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:1646:2427 1:N:0:CGATGT\nCAAAAAATGGGGCTGTGCCCCGCCTCCGACTCACGGAGTAAGTAAAATAACGTTAAAAGTAGTGGTATTTCACTTGCGCCGAAGCTCCCACTTATGCTACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1624:2439 1:N:0:CGATGT\nCCACCATTGACGGATAGATTCAAGTATTTGAGCTCGGTGAGGTCTTTGAGGTCTGATGGAATGGTGAACTGACGAGTACTGGATCCAGCAGGGTCTAGTCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:1880:2270 1:N:0:CGATGT\nGCTTCTTCTACTGTTCCCCAATCAGTGCTGTAAACTAGTAAATATCCTTAAAATTAAACTGTAACTCTGATATCATCACAAATTCAAAACAGCAACGTCTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1755:2270 1:N:0:CGATGT\nCTTTGTTTTAATTAAACAGTCGGATTCCCCTTGTCCGTACCAGTTCTGAATCGACTGTTCGACGCCCGGGGAAGGCCCCAAAAGGAGCCGTTCCCAGTCCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:1877:2290 1:N:0:CGATGT\nCCTTCTTGTGATATAGTTGCCGGATTCCAACAATTTGGAGTTATACTCTGCAAAAAACCAATCATAATTCTTTGAAAGAAATTCAGAAACCGTGGATTTGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:1838:2296 1:N:0:CGATGT\nAAGCACTCTTTGACTCTCTTTTCAAAGTCCTTTTCATCTTTCCCTCGCGGTACTTGTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1926:2308 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAACGTCACTGGTTACCATCCACCACACTCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:1832:2325 1:N:0:CGATGT\nGTCATTAACAATACCTAAATCACTACTCTCTTCGTTCGATTCAAGCTCTTCCGACTCCGATTGACACCTCGCCACTTGAAGAAAGGGAGAAGCGAGAAGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1920:2377 1:N:0:CGATGT\nTTCACATTCCTCACTCTCTTCTCTCTCAGTCTTAAGCTTACATTATGGGTAAGGAAAAGGTTCACATTAACATTGTGGTCATTGGTCATGTCGACTCTGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:1952:2406 1:N:0:CGATGT\nCTCGCGGTACTTGTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTAGGGCTGCATTCCCAAACAACCCGACTCGGCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:1825:2463 1:N:0:CGATGT\nCTCTGATACAAGTCATCTACAGTCATTTTCCTTGAGTGAAGGCATTCCTACTAGGTTTCTTTTGACTTCTCTCATGTGAAACAGCAGGCATCTTTGATATC\n>D7DHSVN1:151:D12V0ACXX:8:1101:1970:2464 1:N:0:CGATGT\nCTGGAATTCACAGTTAACCTGTGAACTGGGAAACTCTTAGCAGAGTCATCCACAAGGCTGATGATACACATTTTAAGACCCAGATAAGGCTTTTGCTACAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2008:2273 1:N:0:CGATGT\nCCGATCAATATTATCAGTAGCCCTCCGAATCGCATGAGTCCGTATCTGGGTGGGGCGCATAGCAGTTTCAAGAGCAGAAAGACGGTGATCAAAAGACCCCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2231:2296 1:N:0:CGATGT\nGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAACATAAGAAAACGCAAGAACTCACGACCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2218:2416 1:N:0:CGATGT\nCTAGAGTGGGCCCAGCATATGCTGGTAGGCCCCACCCGTAATCCAAGTACTCAAGAGTACATCCACCTCTAGTTATATCCGATACTATAAAGTTTCGGGTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2109:2446 1:N:0:CGATGT\nCTTCAATTGAAAACCATGACTTCCAATCTTCTTCTTCATAGATGATCACATGTTTGAGCTTCGAAACGATCCGAGAGCCTTAACAACAGTTGCTCGTAGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2035:2476 1:N:0:CGATGT\nCCGTCACCCGTCACCACCATGGTAGGCCTCTATCCTACCATCGAAAGTTGATAGGGCAGAAATTTGAATGATGCGTCGCCAGCGCAAAGGCCGTGCGATCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2266:2251 1:N:0:CGATGT\nTACAAAACCATCCTAGATAGCTCGTCCGAATGCAGTTCCGTCACCTGCACTTCTAACCGGTAACCTGAAGTGAAGATGTGTACAAGCCAAATCCAGCAGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2330:2272 1:N:0:CGATGT\nACAGCATTCAATTGAGAGGATACATTAAATAGGCTTTATTAGTATTTGTAACCCTTTTCGAACAAGCTCTCAGAAGCTGCACTGATAGCAGGAGTTGCACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2332:2309 1:N:0:CGATGT\nGTAACAGATTGCTGATAAAGCACACCACCAGCAATAGTAAGGAGAAGACAGACCAACCCAATAGGACTAGCATGTTTATCCCAAATAAACACATTAATAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2278:2356 1:N:0:CGATGT\nCGCGGTACTTGTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTGGGGCTGCATTCCCAAACAACCCGACTCGGCGACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2290:2383 1:N:0:CGATGT\nGTGGAAACAACGCTGAAAGTTTCAACATTGAAACCTACGCTCAGAGAATGAAAGAGGATGATGAAAAGCGGCGCTTGTTCTGGGAAAAAGGACCCGATGTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2326:2404 1:N:0:CGATGT\nGTTTCTGTAGAAGTTTATCCTCTTGTAATCTTGTAGGCCTTGTGGAAGTGTGACATTTCCTGGATCATCCATCCCTGTAATTCACATTTGAATTTATTACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2416:2417 1:N:0:CGATGT\nGGGATTTCAAAATAGAAACTTCACAAACACGGTACCTACCTCCATATAGGTCGTAGTCATATATATGTTGCAGAGATTAGGACTTGCAAAATGCACGTAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2378:2439 1:N:0:CGATGT\nATACAAACATAGTTTCAAGGAGATAGGTGAGAGATCAAACTCACTCAACTCCCACCAAAGCCAACCTCTGAAACCTCCATATCCGAACGGTTTAAGTTGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2453:2476 1:N:0:CGATGT\nGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTTCCATGACCACCGTCCTGCTGTCTTAATCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2477:2484 1:N:0:CGATGT\nCTAACGTTGCCGTCAACCGCCACGTCCCAGTTCAGGAATTTTAACCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2261:2492 1:N:0:CGATGT\nGGCATCGTTTATGGTTGAGACTAGGACGGTATCTGATCGTCTTCGAGCCCCCAACTTTCGTTCTTGATTAATGAAAACATCCTTGGCAAATGCTTTCGCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2528:2373 1:N:0:CGATGT\nCGGGGGCATTCGTATTTCATAGTCAGAGGTGAAATTCTTGGATTTATGAAAGACGAACAACTGCGAAAGCATTTGCCAAGGATGTTTTCATTAATCAAGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2623:2391 1:N:0:CGATGT\nTTGGTCTCGAAAATGAAAAGATTCTATAAAGCCTGGGGAAAAACCTCCAAGTATCGGCAGCATCAATAAGACATGTCAAAACAGATGCTAATAGCAACAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2739:2393 1:N:0:CGATGT\nCCCATGTCAGGATTGGGTAATTTGCGCGCCTGCTGCCTTCCTTGGATGTGGTAGCCGTTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAATTCTCCGTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2515:2434 1:N:0:CGATGT\nTCAGAACTTGAACTTGCCGCCGATGTAAATGCGGCGCGAGCCGGTTTCGTAGCGGAACGGCAATTCGGGGAATTGCAGATAGGCCGACTGATCCGACTGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:2532:2435 1:N:0:CGATGT\nCTTGGCTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACTAATTAGATGACGAGGCATTTGGCTACCTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2563:2450 1:N:0:CGATGT\nCCCTGTTAATCATTACTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATGATGTTATCCCATGCTAATGTATACAGAGCGTAGGCTTGCTTTGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2822:2327 1:N:0:CGATGT\nTCTCCGGACTCCCTAACGTTGCCGTCAACCGCCACGTCCCGGTTCAGGAATTTTAACCCGATTCCCTTTCGATGCTCGCGCAGTCGCACTATCGGACGGGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2846:2359 1:N:0:CGATGT\nGCTGAATTGAAGGCTGTTCAACAAATGAGTGAGTAGAAGCTTACGGTGAAGCGTGGACTCAGAAGTTGTGGTGTCTTTGCTCCTTCATAATCCCACAATCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:2897:2365 1:N:0:CGATGT\nCGGGTGACGGAGAATTAGGGTTCGATTCCGGAGAGGGAGCCTGAGAAACGGCTACCACATCCAAGGAAGGCAGCAGGCGCGCAAATTACCCAATCCTGACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2997:2373 1:N:0:CGATGT\nCCGACGGCCGGGTATAGGTCACGCGCTTAAGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:2976:2376 1:N:0:CGATGT\nGTCCAGCCTCACGCGGTGCCCTCCTCTTTAGGGAACAGGTAACCCACCCCTACGAGCAAGTCACCTGAACCAACTCTCTACTTGGAGAGGGCAGGCAAGTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2825:2413 1:N:0:CGATGT\nCCCAAGTCCCCTGGAAAGGGGCGCCAGAGAGGGTGAGAGCCCCGTCGTGTTCGGACCCTGTCGCACCATGAGGCGCTGTCGCCGAGTCGGGTTGTTTGGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:2952:2414 1:N:0:CGATGT\nGGACAAGGAAACGATAACGACGAAATGAAGATACCAATGCCACATTAAATGTAAACTGAAATACAGGCCTAAATAACGACGACCTGAAAAAGAGTGTCATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3193:2270 1:N:0:CGATGT\nCGTGGCTTTGACCAGTTTATGAATCTGGTGATCGACAACACTGTAGAAGTAAGCGGCAATGATAAAACAGATATCGGCATGGTGGTAATTAGAGGAAACAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3037:2281 1:N:0:CGATGT\nCATCCGAGTAGCAAGTACCATCAAACAAACTATAACTGATTTAATGAGCCATTCGCAGTTTCACAGTCTGAATTAGTTCATACTTACACATGCATGGCTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3118:2325 1:N:0:CGATGT\nCCAAAGTACACAAACTTGAATTTACATCACCCATTTTTTTCCGATCTCCCAAACACAACACTAGAAGAACAACTCATTAAGAAACCACTTGTCGAAAAAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3233:2354 1:N:0:CGATGT\nCTAGCCAATCCATGAGTATACCATGAAGTTACAAAGGTTGTACCTGTAAACCAACCTCCTACAGCGAAATAAGCACAAGGAAAGAGCAATAGACCAGACCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3199:2358 1:N:0:CGATGT\nCCTGGTTCAGGAATTTTAACCCGATTCCCTTTCGAAGCTCGCGCGGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATGTGCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3217:2390 1:N:0:CGATGT\nTCCAGAAGAATATTTCAAAACACGAAGGAAAGCTTTTGTCCGTTGAGTCTTCTGTTTTGTGCAAATAGCGAGAACCCTAGGTTTAGCCATTTGTTTGCCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3113:2415 1:N:0:CGATGT\nCAAGACGATTCAGTTTACGCTTCGACATCACTGTGTTTGTAACATTCAACCGTGAGTACTCCCAAACATAAGGCATGTACAAGTCAAGCGCGTGAAGCAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3006:2420 1:N:0:CGATGT\nGAAAGACGCATGAGACATTCGCCTTTAGACTCATCCGAGGTTCCTTTGTTAGCTTCAGCAACTTCACGCTCAAAACCAACGATGATGTCACGGTCGCACCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3131:2427 1:N:0:CGATGT\nGTCCGTACCAGTTCTGAGTCGACTGTTCGACGGCCGGGGAAGGCCCCAAAAGGAGCCGTTCCCAGTCCGTCCCCCTGCCGGCACGCAGCAACCCCCGCCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3193:2429 1:N:0:CGATGT\nGTCGAACAGTCGACTCAGAACTGGTACGGACAAGGGGAATCCGACTGTTTAATTAAAACAAAGCATTGCGATGGTCCTTGCGGATGTTAACGCAATGTGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3246:2435 1:N:0:CGATGT\nTCATCTTGATCATCTCTACCCCTAGAACGCCTATCACGATCATCATACCTACTTCCATGCCTTCCATCATGCCTAGTCTTGTCCAAGTCCCTATCTTTGTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3191:2487 1:N:0:CGATGT\nCTTGTTGTCGGGATCATTAGGGGCAAGGAAACGATTGCCTTGGCTGTTAATGGTAGGTTGTGCACTTCCTCCAATAGCATACATTTCCCAATGTGTATAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3290:2253 1:N:0:CGATGT\nCTAGGATGTGGACTAGGGTTCGGGTAATTGGGCTGAGCATATGGACCAGGATACTGATATTCAGGCTGCAGATACGGGTATGGATGTGATTCAGGATATGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3302:2341 1:N:0:CGATGT\nTCCTGCGACTGTGTTGCTGCTCTCCATTGACCTCTTCTTTCAGAAAATATCTTGTTATGCGCAGCAGAGCCTCCATACTGATGAGCAAGGGTGTCTCCCAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3312:2355 1:N:0:CGATGT\nTAACAAGTTAGGGTTTTTCCCCAAGAAATGACCCCACCATCTCAATATTAAGATGTGGTAGTGAAATGCATCTTCTTCATCCCCATCTGAGAATGGCCGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3481:2418 1:N:0:CGATGT\nCTCCATTTCAACACAGTAACTACTTCAATTACCAAAGTAATAATCAAATCACACTTTTAATGTCTTTTTCTAGTAAGATCAGATCAAAAATACACCACCAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3387:2436 1:N:0:CGATGT\nCGGCCGGTGCCCTTGGCGGGTTTAATGCGCACGCCGATGGGGATGAACATTGTTTCTAAAGGCGGCCAAAATGTGCTGGAATTTCTCGAAAACGATTTCCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3265:2445 1:N:0:CGATGT\nCGATCGGCAAGATGTCGGTGTCGCTGCCGCCGAAAGCCGCATGGGCGGCCTTAGCCATGCCCAAAAATTCGTCGATCTCTGGTGCAGTGAAATCGTAAGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3480:2490 1:N:0:CGATGT\nCAAAAACTTTGATTTCTCATAAGGTGCCGGCGGCGTCCTAAAAGTAACATCCGCCGATCCCTGGTCGGCATCGTTTATGGTTGAGACTAGGACGGCATCTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3743:2251 1:N:0:CGATGT\nCTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATGATGTTATCCCATGCTAATGTATACAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3619:2252 1:N:0:CGATGT\nCTGAGAAGTAGTCTAGTCTGATGTGATATTGAAGCGGTTTTTTAGTTTTATTTAGTTTCTTCAGGCTTGTCATATTGCTTCTCTTAGTTTAACGCTTCAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3659:2297 1:N:0:CGATGT\nATTTGAATATCCCTGAGAGAAGGTCGAGAGGGATGAGGTGGAGTTTGTGAAGAAGCCCAAGGAGGCGTGTTTTTGTCTCCATCCGCAAGTTGCAAAGAAGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3638:2340 1:N:0:CGATGT\nGTTTATGGTTGAGACTAGGACGGTATCTGATCGTCTTCGAGCCCCCAACTTTCGTTCTTGATTAATGAAAACATCCTTGGCAAATGCTTTCGCAGTTGTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3509:2355 1:N:0:CGATGT\nCAACTTTTTATTAAATGCTCCTATTCATTATAAGGCGGGTTACAAGTCTCTTGTTTCCGTCTTCCATCTGTTGCTTCGCTAGTGCACCTTAGAACAGTCGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3587:2403 1:N:0:CGATGT\nCGGAGTTCCAACCATGTAGAATGAGTAGAAGTTGATTCCTGCACCAATGCTCGGCCTTGCAGTCCCACGAAGAACACCACAACCGGTTGTTTGTGGGCAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3750:2409 1:N:0:CGATGT\nCGCTCTTTTATTGAAATAGATAAATAAACATAAATATTTAATTAGACACATTTAGCAGGTTCCCATGACCATGCAGCACACATTTTGCTACAACATTCTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3709:2445 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAATCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAATTGTGCTTAACCTGTTATCTTGTCTTTATT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3670:2460 1:N:0:CGATGT\nAGCCAGTCAAGTCCCTCGTACAAACCTTCACCAGATGTAGCACAAGTGCTTTGGATATACCAATGGCGCTGACGAAGGGAGTGGAGACCAAGCTTATCAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3748:2479 1:N:0:CGATGT\nGTCCTTGTTAATCATTACTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATGATGTTATCCCATGCTAATGTATACAGAGCGTAGGCTTGCTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3844:2256 1:N:0:CGATGT\nCCGAGACATCTAAAGAAGTTGAATTAAGATTGACACCGGCACTTGATATGACTAGAGTGAGGGATAAGAAGGACAGAGGGACTGTAACACTCAAGGTGTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:3827:2266 1:N:0:CGATGT\nGACCCGACTCGGCGACAGGTGGCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:3883:2281 1:N:0:CGATGT\nCACCCGATTAACATCCCTATCAGATTCATCATGTGATGACGAACTCGAATCCATTGACAATATAGTTGATGGATGATAATTCTCAATAGACAAGGTTGTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3843:2338 1:N:0:CGATGT\nTTGAAAGTGTTCCCAAAGGAGATGCTATCTTCATGAAGTGGATCCTACATGACTGGAGCGACGATCATTGCCTGACATTGTTGAAGAACTGCTACAAGGCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3904:2388 1:N:0:CGATGT\nAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAAAGAACCAACAAAACAACAGGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3949:2430 1:N:0:CGATGT\nTGGTAGTAGCCGCTCTGGTTGGAAGTCCGGTGACTGGATTTGCACTAGGTCGGGATGCAACGAGCACAACTTCGCAAACAGGATGGAGTGCTTTAGATGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:3993:2446 1:N:0:CGATGT\nCTCTGCCTGTTCTCCATTAAATAAACACGACCGAGAATTACTCAAATCGGTCAAAAATCGAGTAATCGGGAACGGAACTCGAAGACGACGACGATGAAGTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:3954:2451 1:N:0:CGATGT\nCCGAGACATGGAATGTTCAGTTATTTAGATCCATTGATGGTGGTGCTGCTTTTGATTTTCCCGATACTCCTGAAAAAGCGGCCGAAGCTGGGCTTGTCAGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4202:2276 1:N:0:CGATGT\nCTGGGTACTTGACATCGAAGATGCTTCTTGACAACCCCGATGCTGCATCTTCACTGGCGTGGGATGAGGACCATGAACTGCTTGAGAAGTGTGTTTGCGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4042:2302 1:N:0:CGATGT\nATTCTCCATCTTTACAAGTTACAACACATATTGACTTATTAATGAAAACCCCATCTCACCTCTCCTCCTATTTCTGCTCAACATAACAAATCTCTTGTCTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4238:2303 1:N:0:CGATGT\nCTTTCCTTGACTCGTTCCAGAACTAAGAGTGACATTAGTAATAGGTTTGGTAGTTAGAATAGGAGTAGAATCACCATCCAAGATTCTTTGAATATAAGGAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4129:2322 1:N:0:CGATGT\nGGGGATTTGAATTTTTGGATTTTGAATTTTTGATCGTTGATGGTCTTTTTTTTTTTTTTTTTTTTGGGGAAGAAGAGAAAAAATAAAAAGGGGGAGATTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4224:2335 1:N:0:CGATGT\nTTTCCCTGCTGATTCTGCCAAGCCCGTTCCCTTGGCTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4191:2372 1:N:0:CGATGT\nCTTAGTAACCAAGTCCTTGGTTCTGTACCAGTCACCACGTTTCATAGCACCTTTAAGAAAGGGGTCATGAAGACCATACAAATTGGTGAAAATGCGATCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4017:2377 1:N:0:CGATGT\nCTACTGACCCTTTAACACTATCACCATGCTGTGACCATCCATCATTAATAAGCTTGAACGCTTCATTTCGTGACAAAAACGACGCAAAAAAGTGCTTCTTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4082:2386 1:N:0:CGATGT\nGTCGTCTGCAAAGGATTCAACCCGCCGCTCGGTAGAATTGTGATTCAGAGCGGCCCTCACGGTGCATCCACCGCGATGGCTTGGCCCACGACACGTGCCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4057:2388 1:N:0:CGATGT\nCAGTGATCCTATATCTTTTTCAAGAAAGCAAGCACGCGCAGATGAAATGGTATGGGCATCCAGGGAAGCTTTGAGTGAGAGACATTCTGAAGGAATCCATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4124:2406 1:N:0:CGATGT\nCTCCATATCGATACTAAGCTTTGTTTTTGGCTCCAGCCAAAACCAGCAGTTCAATCATAACCCAGAAATATAGATACATAGCAATATGATCAATCCAACCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4218:2452 1:N:0:CGATGT\nGCGACCAGAAAGACATTTCCGAGTACAATAAAAGTTGTTGCAACAAGTACCTTGACAGAGACTTTTTTGTTCAAAACAAAGTATGCAAATGCGATGTTCGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4317:2277 1:N:0:CGATGT\nATAAAAGAGCTCCCGCGCCGATTAGTATATAGTACAATGTGAGTGAACATAGCACACTGCCTAAACACCTAAAAAAAGAAAAAAGGAAAAAAAAAAAAAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4385:2356 1:N:0:CGATGT\nGGCATAATTCATCATTAGTAGTCCGTGCTCTCTACAAACATCAGCCAACGTCAATGTACCGGCAACATTGGTTCGGATTGTCTCTGTTTTGTGAGACTCAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4425:2415 1:N:0:CGATGT\nGGGGTCGTCAAGGCTGAACCCGGATGTGAGCAACGCAGTCTCAAACAGAAGCAGCACTAAATCCTTTACAGATTTGTCATTCTTGTCGGCATCTGCTCTCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4454:2421 1:N:0:CGATGT\nCTACAATCCAAAGGTTTACATAGCCCAAAGTCCGATAATCTCAAGTGTCCATGTTTATCAAGTAGCAAGTTATCGGGCTTAATATCTCTATGAATATAGTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4349:2434 1:N:0:CGATGT\nCGGTCTTGTTCAACGCAATGGCGACTGCAGCGACGAATGCCACCACACAAACAACTGAGACACCTATAATCACACCTTTGTTAGCCATTTTTTTTCCCTTT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4314:2435 1:N:0:CGATGT\nCACTTACAATACCCCGTCGCATATTTAAGTCGTCTGCAAAGGATTCAACCCGCCGCTCGGTAGAATTGTGATTCAGAGCGGCCCTCACGGTGCATCCACCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4391:2456 1:N:0:CGATGT\nGACGGGCGTGGCTAAGGAGCTCAGCGGAGTAGGCTGGGTTAGAGCGTTGGAAAACGATGGAAGCAGCGGCCATAGCGGCAGCAGTTTCTCCGGCAAGATCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4384:2471 1:N:0:CGATGT\nTCCGTCTTTCTTCACCTCTCGATTGGCCAAGCAGAAGAATGTCAAGTAGTTCCTTGGATCCTCTTCAATCCCCTTAGCCTGCAAAGCAGCAATAACATCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4526:2273 1:N:0:CGATGT\nAATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCTGCTTGGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4596:2310 1:N:0:CGATGT\nGCCGCGCCCTCCTACTCATCGGGGCCTGGTACTTGCCCCGACGGCCGGGTATAGGTCACGCGCTTAAGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4707:2313 1:N:0:CGATGT\nTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACTAATTAGATGACGAGGCATTTGGCTACCTTAAGAGAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4612:2332 1:N:0:CGATGT\nGATTGATTGCCGTTATGCAAATGTTGTTCAAGTGGGGGCAAATGTGTTACCTTTGTTAGCTTACGTAAGTGTCATAGAGGGTTTTTGTTTTCGCTTGTTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4691:2344 1:N:0:CGATGT\nGCTCTGGTAAAGAAGGGAAGTTTTCAACAAATACCTTCAGAAGAGGTGAACTTATGCAATAGACCTAATATTACACATATTTATAAAGGCTATAAATGACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4622:2358 1:N:0:CGATGT\nTGAAGGACTCACACCAATCATGATAAACTCCGATCAAGCCCCGGTCAAAAATCACAGAAAGAGTGTCTGCTTCATGTATCGGAACAATGTTCATGACCCAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4737:2419 1:N:0:CGATGT\nCTGAGTAGGAAAGTAACGGATGACATTAGCAGTGTTCCCTCTCCACAAGGACATCATACCTTCATCCTTAATGGTGCTTCCAAAACACTCACCAATGCCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4515:2485 1:N:0:CGATGT\nGCGGCCTTCAGGGTAGAGTAATTTGGGTTTCCAAGAATAGTAGAAGGAAGGGTGTAGAAGCTGCAGAAATCGGTAATCTCATGAGTCACTGGACTTTCAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4654:2489 1:N:0:CGATGT\nCCAAGATCTGCACCGACAGCCGCTCCGCCCAGGCTCACGCCACAGGTTTTGCGGCGACCGCCGCGCCCTCCTACTCATCGGGGCCTGGTACTTGCCCCAAC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4846:2295 1:N:0:CGATGT\nCATAACCTTGGCCAGGTTGACGGAGGCAGAAACCCGAACAACAGTACGGTGGGCCCACGTTCTCGTTACATCTTCCTCCATTCCCTATGCATGCTTCTGTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4924:2299 1:N:0:CGATGT\nCTTGTTACGACTTCTCCTTCCTCTAAGTGATAAGGTTCAGTGGACTTCTCGCGACGTCGCCGGCGGCGAACCGCCCACGTCGCCGCGATCCGAACACTTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4941:2348 1:N:0:CGATGT\nACTCGGAATTTGGCATTGGAGTGGCATGGAGGGGTTATATTAAACATAAGCGCTACCTTACACTACACCGCTTCTTGGTATCAAATCCACGTATCGGCCGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4977:2395 1:N:0:CGATGT\nCTCATTTGCACACAAAGGCGACGTAATCTCCGGGCTAGACTCAGGAGAAACCGAAGGGTAAATCTTATCACTAACCATTTTACTCACTTTAGAACAAAACC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4834:2400 1:N:0:CGATAT\nCTTGTCTTGGATTTTCGCCTTGACATTATCGATGGTATCAGAACTCTCAACTTCCAGAGTAATAGTCTTCCCAGTCAAAGTCTTAACGAAGATTTGCATTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:4752:2403 1:N:0:CGATGT\nGTAGGGCATATCCTTCGTAGATAGGAACAGTGTGACTCACACCATCACCAGAGTCAAGCACGATACCTGTTGTACGACCACTAGCATAGAGAGAAAGCACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4958:2412 1:N:0:CGATGT\nCCCAAATCAGGGCTAGGAGCTTTTATATCTCCAGGAACTTCAAATGTCACAGTTCCATCCCTTTCAACAGATGCAAGTCGGTTCAGCCACTTGATCTTCCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:4799:2439 1:N:0:CGATGT\nGTACTCTGCTGGTTTGCCAAGCCCAAATGGGTCAAACCCATAAACACCAACTAGGCTCCCATCTAACCACTCTGGAGCCTTGGCTCCTGGATACCATAATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:4989:2442 1:N:0:CGATGT\nGGTTAAGCTATTAGATATCGGAGGGTGAATGTGATGGCAAAAAGATAATAGAAAGTGCAAGTAGTTTAATGTCATTTTAATCCTTACCCTCTCAAATGTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4787:2455 1:N:0:CGATGT\nATGGCTGGAGGCTTTGGAAAACTCCAATAACTTCCCCAGTCTCAGGCTTGCTACTAGTAACACTCAAAGTGATCATCCCTTTCGACGAGGGAGTATTCTTA\n>D7DHSVN1:151:D12V0ACXX:8:1101:4915:2462 1:N:0:CGATGT\nGCATTTATCAACAAGCATCCACTCTCCATTAGGCCGTTGATCGCCTTCATAATATTTCTCACTGGACTCGGGATGAATCTCATGCTTGGATCCATCAATCG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5225:2314 1:N:0:CGATGT\nCTCCAAATCACCCATTTCAGTAAAACAAACATTTATATTCTCTTTTCAAAACGAAAAGTAGAAGCATCACAAACAAAGAACCAACACCAGCATCAATCACA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5079:2459 1:N:0:CGATGT\nTGCGGCGATGACGTGATCGTAGGGGGGGGGTCGGAGAAGCTGGGGGATCGGAGGATGGAGAGGACTAGAGATGAGAGCTCGTAGAAAACCCTAGAAGATTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5111:2465 1:N:0:CGATGT\nTGAGGAATCATGCTGGATAGAGGGCTTGGTGGATCCAAGACTAGAAGGAAGATTTAGCACGAAACAAGCTGCGCTGATGATCCAGGTAGGAATATCTTGTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5184:2480 1:N:0:CGATGT\nAGAAAATCGGGTTTTAAATATATGCAAAGATTAAATGATCTGAGTTTTAGGCCTTAATCTTGAATAGACTCGTACCTGCATTCTCAAATTCTATGGTCAAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5205:2482 1:N:0:CGATGT\nTGGTGGGTGAACAATCCAACACTTGGTGAATTCTGCTTCACAATGATAGGAAGAGCCGACATCGAAGGATCAAAAAGCAACGTCGCTATGAACGCTTGGCT\n>D7DHSVN1:151:D12V0ACXX:8:1101:5307:2255 1:N:0:CGATAT\nCTCCTTGAACACGATTCGCCAAATCAAATCTCGAACGGCTCTGATCATGACACGTGGATAACCCATCAACTCGATCAAGCAATCGGACGGTGTAGCTAGGG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5383:2265 1:N:0:CGATGT\nGCGTGATCAGCACTCGGTCCTCCGGATTTTCAAGGGCCGCCGGGGGCGCACCGGACACCACGCGACGTGCGGTGCTCTTCCAGCCGCTAGACCCTACCTCC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5333:2280 1:N:0:CGATGT\nTCCCATGCTAATGTATACAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5391:2288 1:N:0:CGATGT\nAAACAGAAAAGATAACTCTTCCCGAGGCCCCCGCCGACATCTCCGGACTCCCTAACGTTGCCGTCAACCGCCACGTCCCGGTTCAGGAATTTTAACCCAAT\n>D7DHSVN1:151:D12V0ACXX:8:1101:5436:2326 1:N:0:CGATGT\nCCGCTGAATTTTGCAGCCTAATTGTCCTTGTTGTGTTTATCATTCCGTAGTGGTACGATCCCTGTGGATTCGGCCTTGGTCCACTTGCAGTAAGATTGGTC\n>D7DHSVN1:151:D12V0ACXX:8:1101:5342:2338 1:N:0:CGATGT\nCCTTTGTGGGATCTAGGTTAGCGCGCAGTTGGGCACCGTAACTCGGCTTCCGGTTCATCCCGCATCGCCAGTTCTGCTTACCAAAAAATGGCCCACTTGGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5424:2351 1:N:0:CGATGT\nTTCTGTTGTTGCACCTGCATGTTTTGATTCCCCACAACCCATTTTCCCTAATATACTTAGAATTAATTTGATGGATGTATGAAAAGAGGGAGAAAGAATGA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5263:2387 1:N:0:CGATGT\nGCTGGCACAGCAGCGCTAGTATCTGGAGCAGATGCTGTTAATAAAGACACTGGAGAAAGACTGATAGTCGGAAGGTGGGTAGTGGATAGCATAGATCGGAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5423:2419 1:N:0:CGATGT\nGCAGAACGTTACGTCCTTTCAGATCAATGAAATAAAGAGTTTCAGGGTTAATTGAGATGAACGCTTTGATGATACTAACATGGCCTCCGCTAACAGCTTTG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5374:2435 1:N:0:CGATGT\nCACGTCCCGGTTCAGGAATTTTAACCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGGTCGACTAACCCATG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5392:2436 1:N:0:CGATGT\nCGAGAAAGTACAATTCATTTGATGTTTGAAGCAGATTTTTGACCTAAAGCTGCACATAAATACTAACTAGCTTCTGAACAAAAAGGGAAACATGAACGAAA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5319:2459 1:N:0:CGATGT\nCTTTACTAAAAAATTCTTCCTCGGAAACAAGTTGAATGTCAGGGTACTTTGACTTGAAATCTTTGCATGCTTTTATAGCTTTGAGGTAGTGGCTCTTCTCA\n>D7DHSVN1:151:D12V0ACXX:8:1101:5351:2460 1:N:0:CGATGT\nGGTTGATATCATCAGTGGGCAATCTTGCTGCTCCTTTTGAGGAATGGACTGCTGGTGGAACAGCCCTGACTGCACTGATGGATGTTGAAAGAAGACACGGT\n>D7DHSVN1:151:D12V0ACXX:8:1101:5252:2479 1:N:0:CGATGT\nTCCAATAACCTTCCTAATGTTGTTGATCATATAAATGAGAGCAGTGGCAAACTCACGATCTGCTTTCTTTGACATTTGCAGATTAATTTGCGAGCCACTAG\n>D7DHSVN1:151:D12V0ACXX:8:1101:5285:2496 1:N:0:CGATGT\nCCTATGTCCATGTTGAGTTATTGAAGCTGCAACATTTCTGTTATTATAATTAGGTGATCGATGAATCATATTTCCCCCTCCTCCACCCTTTCCGCCGCCAT\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxs2nex":
        res = True
        print("fasta ", end = '')
        cm = "./pxs2nex -s TEST/test.fa"
        t = '#NEXUS\nBEGIN DATA;\n\tDIMENSIONS NTAX=5 NCHAR=20;\n\tFORMAT DATATYPE=DNA GAP=- MISSING=?;\n\tMATRIX\n\nTaxonA\tAAATTTCCCTGTCCCTTTAA\nTaxonB\tGCTCGAGGGGCCCCAAGACC\nTaxonC\tACGCTCCCCCTTAAAAATGA\nTaxonD\tTCCTTGTTCAACTCCGGTGG\nTaxonE\tTTACTATTCCCCCCCGCCGG\n;\nend;\n'
        if not check_individual_results(cm, t):
            res = False
        print("phylip ", end = '')
        cm = "./pxs2nex -s TEST/morph_data/morph.phy"
        t = '#NEXUS\nBEGIN DATA;\n	DIMENSIONS NTAX=64 NCHAR=437;\n	FORMAT DATATYPE=STANDARD SYMBOLS="0123456" GAP=- MISSING=?;\n	MATRIX\n\nErythrosuchus	0001000000000210010101000000100000000100010000?00000000000000?00?000?0010010000000000010000?001??00000??0011?000002000000000000000000000?000?00??000000?00?00001?000001000000000000?010000?0000010000?00000000?000010000001?00000000???100000000000000000000000000000000001100???010000???????0?0000?00000?00200000??0000000000000000000111111111112?00?000000?10??000000???01000?0?0000?0000?00?0000?100000?0?0????00000000?01??10??0101001000000000\nEuparkeria	000001001000021000000100000110010000000000000000000000000000000000000000?01000000000100000000000000000000000?0000020000000000000000000?0?0000001000000?000??00000000000000000000000000000000001000000?0000000??0000100000?0?000000000011000000000000000000000000030000001003000?001000101231120100001000000?000010022000000000001000?000211111111112?00?0000001000?000000??001000?0??00000000000?0000?1000000000???000000100?000010??0000001?00000000\nPROTEROCHAMPSIDAE	1000000000000001000000100000000000020000000000000010000000100???0?????00000000000000000000000001000000000000?0000020000000000000000000?0????000000?000??00?00000000000000000000?000000100000001000000?00?00000?00000000000000?111000001100000010000000000000000203000000?0?0001??01000001231120100001000000002??00?22000000000001?000000011111111112????0000001001?000000???01000?0??0000000?0?000000?1000000000????10000000?????10??00?0001001000000\nScleromochlus	101012?0100000?00000110000001??00000?0??01000???00?2???????????1??????01????0000??00???2??00??02210000110000?00000200100001???00010000?0?????00?1??100??01?0000??0?00?0?0?????1?011101110000000??0000?0000?000?000000000000000?00?00000000000000000000000?10?00??????????????00??010001?0000000000000000000?0???00?0000000000000??00?000?11111?1111100??0?00?00000?000?00???00000?0??000??0?0?0100001?0000000?????0?10000??0?00??10??????001?01?00000\nEudimorphodon	10001000100000010010?00000?0?0000?0?????00000???0??0??????????????????01????01000??0000200000??222000011000120110021010000000000000000?0????0??010?10100?0?2010???0???????12221?011?01??00011111?111111111111111111210111111?1000000??0100?000100000000??????00??????????????0???010000?000000000000000000??0???000000000??0000?0?01?00021111111311210010000?001??0?00?01?100010??0?0000??000?110000??00000?????021000000??01000000??00?0000?0102?000\nPeteinosaurus	???????????????????????????????????????????????????????????????????????????????????00??10000???22200001100012???0???01??00???00?00000??????????????10?0?00?201????0???????12221?01110101000??????1111?1?111111111112???11111?0????????0????0??????????????????????????????????????1?000?00000000000000000????????0000?????????????0??00???111?11?11?10010?00?001?0000?????1000??????00000?0?0?110?00?????????????210000????0100000???????000?0??????0\nPreondactylus	10?0?0????0000?11010???000?0????00????????????????????????????????????00????0100???00?????00???22200001100012???0???????00???00?00??0??????????????1?????0?201???????????????????11101110001111??1111?1111111111?11?110??110?0?00?00??0100?00010000000???????00??????????????0???01000??000000000000000000???????0000?000??0000???0100002111111131121001??00?001?00?00??1?10?010??0?0?0?0?0?0?110?00???00????????2100000???01000000??0??0000?0102??00\nAustriadactylus	1000?0?01?0001?11010???000?0?00?0??????????00?000000??????????????????????????????????????00???222000011000?2????????????????????????????????????????????????????????????????????11????????111111111?11?10??????????10?11??????00?00??0100?000100000000??????00??10??????????0???01?00??000000000000000000???????0000?000??000????01?00011111111?1121001??????0?????00?0??1???10??0???????????0???0????00000?????2?????0?0???????????0??0000?01???00?\nLagerpeton	???????????????????????????????????????????????????????????????????????????????????00??0????01122????????????00100200000010001010110010001?1000001?10?0101020200?110?1011212221011101011110???????0????????????00000??????????????????????????????????????????????????????????????????0?00000000000000000??????????00???????????????????????????????????0000001001100???????10???????0000????????0?0???????????0????000??????????0000????0???0??20??0\nDromomeron	??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????10010001?0000011111??1010??20??1100101021222????????????????????0??????????????00?????????????????????????????????????????????????????????????????????00000000000000000??????????00????????????????????????????????????????0000???????????1??????????0?????????0?0?????????????????????????????????????0???0???0???\nMarasuchus	?0????????0???????00?1?????????????????????????????????????00021?1??????????112000000000000?0012210000110001?10100200000012002100100000101?1111000111?1001120000?1000101101000101110101111???0????000??010?0???0000000?00??????0??????0?0?????????????????????????????0??0????????1???0?000000000000000000????00?0?00?000?????????????????1111?1?111????0000011000?00???????10????00?000???0?000?0?0????0????000????100???0??????00????0?00??0??000?0\nPseudolagosuchus	???????????????????????????????????????????????????????????????????????????????????????0??0????22????????????????????????1?0?20???0000?0?1?111110??1??1001120001?200010?101000????????????????????0??????????????00?????????????????????????????????????????????????????????????????????00000000000000000??????????00????????????????????????????????????????1100???0???????2??????????0?????????0?0?????????????????????????????????????0???0??20???\nSilesaurus	00?001????00021000000100000?1??0000?????0?0????????0?001??00002001???010000?11200000010200000002201001110000?10000200102012002001101001122?111110010211011000001?2000?11121??????01011111100000???000?0000000??0000000000?0?0?000?000?01000000000??0??????????????????0??0?0?????040000000000000000000000000??0001?0000000?000001001000021222??11222????100001100?0000??1???2000010??000???0???1?0?0???00????000?????0010?00?????00000?00001000021000\nSacisaurus	?0????????0??????00011?????????????????????0??????????????????????????100?????????????????0????22?1????????????0002000000220?2001101000121?1?1110??12110111??????2????????????????????????????0???0?0???00?????0000?0000???????0????????0?0???????????????????????????????????????4?00??000000000000000000?0?????1?00?000??00?????0100????2222211222????0?00?1100???0???????20????0??00???????11?0?0????0??????????????10????????0???????0???0?02100?\nEucoelophysis	?????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????2?0020???01001?22?1110100??1??????????????????????????????????0??????????000??????????0000?????0???????????????????????????????????????????????????????????????00000000000000000??????????00?????????????????????????????????????00?11?????0????????????????????????????0?0?????????????????????????????????????0???0??2????\nLewisuchus	???????0??????????0011?0????????????????0?000?0?00001?0???0000?10?????00????1120000000?????0???22?1000??0000??????????????????????0001?????????1???0??????????????????????????????1???0???0???0??0000?????000????0??00000?????00??????0?0?0???????0??0??0?????0??3????0??0??1??0??1000010000000000000000000???00?0?00?0?0??00?00??01?000??1111111111????????????????0??01????0????0????????0???0?0?0????0??0?00???????????0????????????0?00??0?0???00\nEoraptor	0010010001000111000011?000?100000012???10100001000000?????????????????????1??1202?00???10000???22100??1100111?0020210002022?021111021????????10?0??1?????1?0000??200????1?1222???0101?1?1?00000000000?0000?0001000010000000000?00000??01000000000000000?0????0???2??????????00???010000?000000000000000000??0????0?0000000?00000??01?000211111?1?111??11??00??10?0?0011111112?00000?000?01121??00010001000000??0?000000001??000000???00?0000?00?0?000\nHerrerasaurus	0000010101000110000001000001100000120101000000000010000100100021011???00001?112020001111000?0022210???110011110020210000022002211102100102?111110001211011100001?200111112122211101011101100000100000?0000000010000100000000000000000001000000000000000100000000020000000013?01??010000?0000000000000000000000???000000000000000100100002111111111111111000001100000011111212100000?00000?12111111211?000000000000000000000?0000001010000000000100000\nCoelophysis	0000010001000101010011000001101000122101000000000000?0010?1000?101????00000?11202010111211000022210001100011110020200102012002101102100112?11111001121101112010??2001?11??1222?1101011101101000100100?0000000011000100000000000000000001000000000000000000000000030000000013?01??0100000000000000000000001000????000000000?10000100100002111111111111111200001100100011111212100100000000112111111101111111111111111111001000000000??0000000001111111\nLiliensternus	00????????0???????0011?000??????????????0?000?1000000?????????????????00??0?11202010011?00000??2210?011?0011??00202001021120021012021????????111000121??11???20??2001111121222???01???????0??00?00100?0000000??0000?00000?0??0?00??0??010000?00??????????????0????????????????????10000?00000000000000000????????0?000?00???0000??01?000??1111111111?????00001100???0??11???21????0??000??12??11?1101??????1???1????????00?0?????000?????00??01111110\nZupaysaurus	?000?101010???????0011?000010010001221010100000000100?????????????????00??0????????????????????22???01???????????????????????????????????????????01???0?111??20??2001111121222??????????????0000001?0???????????????0000???????00000???100000000000000000?00?000?3????????????????1000??000000000000000001??0????0?000?000?10000??01?000??1111111111???1????????????0?11????2?????0????0??1???????101?111111????????????00???????????01?00???011?111?\nPlateosaurus	0000110001000101001011001001100000122100000000000000000100100021011??131000111002000011100000022211001110021100020200002022002100202100111?111010000211011120001?20011111212221110100010110000000000000100000000000100100001000000000101000000000000000000000000000000000000001??040000?000000000000000000000?000100000001?000001000000101222?2111220100200000100000011111112111111111111002000000001000000000000100000111111111111111111000001011000\nPantydraco	0010010101000???00?01?00000100100012010100000010000000010?????????????300?011?20200???????00???22????1110011??00202101000???????12?????1????????0??021??11?00????????????????????01000101?00000?00000?0?00000??0000000100?0???000000000000000000000000000?00?000?????????0??001??0400001000000000000000000000?0001?00000000000001?0000012122???11122????00?0??1000000111?????101?11??11?0002?00??00?1?000000000?????00011111?????1111000000??000?100?\nAntetonitrus	?????????????????????????????????????????????????????????????????????????????1?????0011???0????2200???110011?????????????2??021???021????????1010??0??1??1???????????????????????0100?0?1?0???????0?0?0100?000???00???????????????????0???????????????????????????????????????????????0?00000000000000000?????????000?????????????????????????????????0???00?010?0000??????1????????1???????0?00?0?0????????????????000????1?1110??1?????11111???1??0\nEocursor	?????????????????????????????????????????????????????????????0?0??????00000?01?0???????2???????2210???110001???0202?0102032002001?021????????1??0??12????????????????????????????11???1??????????00?0?00????0?10000???000?0????0??????0???0???????????????????????????????????????4?000?000000000000000000?0?????0?00???????????????1111??221?12??2?1?1?211111211?1???????1??????????00???0?0??1??00???????????????????????0?????00????0?00??0?02???0\nHeterodontosaurus	0010110001010110000?10000000100000122??1000000100000000???100??1??????01010?0120100000?20000??22211?0011001111102021010203200200110210?????1?10?00?120?0?1?2010???????????12220?11101110?100000000000?0000?0001000010000001000000200??00000000000000000000?000000300000000?300???0400000000000000000000000??0???00000111211121112112012132322221211211112011022011?110?0001020010?0?00000?010?010?00??000000?0??000000?100000000000??00?000000002?000\nPisanosaurus	0??????????????????????0??????????????????????????????????????????????000001???0??0????200????222???????????????????????????????????????????????????20??11?1000??2?01???121222???11???10??0??????00????????????00?0???00???????0??????????0???????????????????????????????????????4?00??000000000000000000?0????00?00???????2???????1111????111?1222???????????00???????????20???????0?1??????????0?????????????????00???????????????????0?????0?1?0?\nPaleorhinus	100002000000110000001000000000000000010000000000000000000?000010000?0001110000000000100000?10?0010020000010000010020000000000000000000?0?????00000?0001000?11010?001000?0101100?000000100001000000000?0000100000000110000001101111111122001211100000010000100000010000000000102?10200000?11?11010?011000000201000001100000?000010001100061111111111100000000?000000000000?1001000?0??000000000000?001?0100000010?00000000000?000010??1000000001020000\nRutiodon	100002000000110000001000000000000000010000000000000000000?????????????011?0?0000000010000001000010020100010000000020000000000000000000?0?????00000?000?000???01010010000010110????????1????1000000000?0000100000000110000001101111111122111??1211100?10?0?00?10??121????01?011???0200000?11?11010?011000000?0????001100000?00001??01100061111111111100000000?00000??00000?1000000?0??0000?000?0001001?0000000010?00000000000?00001???10?0000001020100\nMystriosuchus	100002000000110000000000000000000000000000000010000000000?000010000?0001100100000000100????1???01002010001000000002001000000000000000000000000000000?????????0?????????????????????????????1000000000?0?0010000000011000000110111111112301120020110111121220321221111101011202202020000??11?11010?011000000?01000001100000?000010001100061111111111100000000?00?????00000?????000?0??00???00???0??001?0000000??0??0????00000?00??10??1000000?0102?100\nPseudopalatus	100002000000110000000000000000000000000000000000000000000?0000?0??????01???????????????????????01002010001000?????????????????????000??????????????000??00?11010?0010000010110???000001000?1000000000?0???10000??001100000011011111111?2111101201010130202112102032111122110121?2020000??11?11010?011000000?0100?001100000?000010?01100061111111111100000??0???00?0000000??000000?0????0?00?0??00?001?0000000?????00000000?0?00001???10?0000?0102010?\nAetosaurus	0000121110000000001011?00000000000000110010000010000??????????????????10010????00????0?0?0??0?10101110000100??00002001000211?1000100000000000000000000?000?11010?00??00?0101100?000001000000000000000?000000000000010000000000?00010??1100000000000000000????00??????????????0???021100?311211021111302110??0???0001100000?00000??01?0012121111111220??00000?00000000000????0?100?0??0000?000?000?001?010000??????0?000000?0?00001???00?0000?01020000\nStagonolepis	000012111000000000001000000000000000011000000001002000000?0000?002111110010100000000100000010010101010000100?000002000000211011001000000?00000000000001?01?11010?00100000101100?000001000000000000000?0000000000000100000000000000100011000000000000000000000000000000000010101??1311000311211021111301110010?00000110000000000000010001112111111122000000000000000000000?0000100?0?000000000?0000001?0100000??0?000000000?0?000010??0000000000000000\nDesmatosuchus	00001211100000001000100000000?0?00000110000000010020000000000020?21??110010100000000?0?0000?0010101010000100?10000200100021??1000100000000000001001000100101101000010000010110??000001?000?0000000000?0000000000000100000000000000100111000000000000000000000000000000000010101??1311?1112222221222322?220010?000001100000000001000000015021111111220??00000000000?000000???0?100?0??000?000??00?0001?0100000??0?00?000000?0?00001???0000000?00020000\nLongosuchus	00001211100???0??0101100000001000000011001000?????????????000??0?2????100101000000001000??0????0101?100001000?000020010002??0???01000?00?000?001000000??00?1101000010000010110??000001100000000??0000?000000000000010000000000000??00??10000000000000?00?0000?0??????????0???????131110132122221222322?110?10?0?000110000000000???0?0001??211111112200000000?00000000000??000010?10?00000?000?0000001?01000??????00000000??0?000010??00?0000000020000\nOrnithosuchus	0000010101000000010011?00001011000000100000010000020000000000???0?????0010110?0000000001001?0010100011000100?000102000000121020002000000100001000??01??001??102??????????101100?00000?100000000000000?0000000??0010100000?0?000000000011010000000000000000000000020000000000001??0100000021?11010000100002110??00000000110?0000000010000311111111110?00?000001000????0000?00??100?0?000??0000?0010001?0100010??0???0?00000?00000000??0000000?0001?000\nRiojasuchus	010011010000000001001100100101100000010000000000002000000?0000?001????01100?00000000000100???0?0?0?011??0100?0?0102000000121020?0?0000?0?0??010000?0101001?11020?00100000101100?000010100000000000000?00000000?001010000000?00?0000000?1010000000000000000000000020??????0???01??0100000??????0?0000100002110????00??00110?000000?010000311111111110?00?000001000000?0000?0000100?0?0000?0000?0?10001?01000100?0?00000000000?00000???00?00000000?1000\nDromicosuchus	0000010011000210000001?00001100101120101010011?200?11?0???????????????010???0??00000?0?000?10010101?120?0000?1?0?02001000?????????011??0?000?0000000000000??001??????????10?1??????????????0000?00000?00??000????00?00000?0?0??00?00???1000000000000000000000000?31?0????0???0???0100??0021?11010000100000??????11?2200000?0000???01?000111111111112????????????????00100???0?000?0?0000??000??0?100??010000?0?0???????002?0?????0???00?0000?01??0000\nHesperosuchus	0000010?110?0210000001?00001100101120101010011?200?110000?????????????010???00100000?0?????1???0101?1?0?0000??????????????????????011??0?000?000000?000000???????????????????????01??1????00000?00000?00??0000???0??0000000?0??00000??11000000000000000000000000?31?0????0??10???0100001021?11010000100000?0???11112200000?0000???01?000111111111112?00??????0000???00100110?1000?0?0?????0001?001001?010000?00?2?00?000020020000????00?00000010?0000\nPseudhesperosuchus	00000?0011000110000011?00001100?001201010?0?111200?010000?0???????????0?????00100000?00???1??????0?1120?0001??????????????????????0????0???????00000000000????????????????????????1????????0000000000?00000000???00?00000?0?0?0000000?110000000000000000?000000003100000000010???0100?0???????0?00001000000?1??00????00000?1000?0001?000311111111112?00??????0000???001?0?????000?0?0?????000????1001?0100000??????????002?0?00??????00?0000001??000?\nTerrestrisuchus	00000101100???????001110000110010002?0000100100200?1100001000?????1??101000?100000000000001100201010120?000001101020010001210200010000000??0000000010000000000101001000001011100001101101000000?00000?00000000000001000000010000000000110000000000000000?000000003100000001010???010000???????0?000010000000?11?01???00??0?0000000010000??111111111?10000000000000000010011??1????1?000?00000?000?001?01?0000??0200?000?0200200??00???0?0000001020000\nErpetosuchus	0000000111000110000011100001000?0002211100001101000110000?????????????00?00?0?0000001??????????01?11110?0000???????????????????????????????????????????????????????????????????????????????0000000000?0???1001??????000000?000?000000011000000000000000?0?10?000030?????????001??01000001211110100001000000?0???00?12000000000000?00?000211111?11111?0???????????????0000??0??000?0?0????0000??10?0?1?0000000?????00???002?0?0000????00?000???1???010\nGracilisuchus	0010021111000?10000011?000010100000011000100110100211000??000???0?????00000?010000001000000100?1100100??0100?000002000000???????010000?0?0???0011??010??00?00010?001?0??0101100??11000110000000000000?0000000??0000000000?0?0?100010?01100000000000000000000000003100000000000???010000012?111010000100000000???00??20000000000000000000311111111112????000??00000?0000?0???00000?0??0000?00??00?000??000000???0????000002?0?????10??00?0001?010?0000\nQianosuchus	0000110110000001011111000??0?0000?00????01000?00?020?0????????????????00?00?1100??00??00??00???00?110?000000??101??00100010??100020000?0???????????0????00???01??001?0?0010110???0?00?000001010000000?0000000??0000?00000?0????000000??100000020?000000?0????00??30??????????01??0100?0???311?0?0000?00000??0???00???0000?000000??00?000611111?1?111????0000???000?00?001???0?100?0??00???0???00??001?000001????????000000?0??????0??00?000???1?00100\nRevuletosaurus	?000???0000?0210010111?0000?011000000??00?000?0200?0??????????????????00????0000?0001??0???????01???00??0100?000002000000?????????0000?0?????0000????????????010?0010000010110?????????????000000?000?????000????0???0000?0????00000???00?00?????000000?0????000030??????????????040000?2?211?010000100000??????01?1?0000000000???00?000?12211?11222????0?0??01?????0?00????0???0?0??000??0???????00????0000???????????00??0?????1???00??00???10??000\nArizonasaurus	0000110100????????11010000011??0000001000?00000?00?0?00011?000010000000000?010110101011111??11222?1?0000?????01012101000012102101200000010000000000????0????????????????????????????????????0?0?00000??0??0????00????0000?????000000??1100000??000000000000000000300000000????????100000000100000000100000?0000000?00000000000000?010000??1111111111????0000001?????01?00?????10?10??00??000?????0000?0000?0?0?0????????0000?????10??000?0???0101?000\nArganasuchus	??????????????????10?1?0??????????????????????????????????????????????000??????0??0????????????????????????????????????????1??????00000000000100000000?????11??????????????????????????????????0??0????????????0000??000???????000?0????0000??????????????????????????????????????1?00?0??????????0??00??0?0?????0?????00??0??????0100????1111111111???????0?11?????01??????????000??????????????0?0????0????????????????????????????????0???0?0??0??\nBatrachotomus	000111010100020?001111?011100000010101010101101010?00000??100020010001010000000000101111000?012?1?1111?00100?010011000000211021002000000100000000???00000001101??????????10110???00??0?00000000000000??000000??0000?00000?0?0?000000??1100000000000000000000000002000000000100???01000001?2???010000200??0?0000000?210000100000000010000211111111111????000000100??001000?????10010??00??000??00?0000?00000000?0??????000000?????10??0001000000000000\nBromsgroveia	?????????????????????????????????????????????????????????????????????????????????????1?111??112??????????????011121010110???????1??00????????000??????????????????????????????????????????????????0??????0?????00?????????????????????????????????????????????????????????????????????????????0???0??00?????????????????????????????????????????????????00?0????????0????????????????00????????????????????????0?????????????????10??????00?????????0\nEffigia	00100101000122011010110100011000000201101000000000?2111010?110211?1??020111110100010011211??11?2210011?010???10012010111112112311212101010110000?01?0110000000101001100001????00001011101011000?10000?0000000??0000?0002000000000?100??0000000200000000??020000002000000?0??10???0000200000000000000000000?100?002000000000000010?000000500000000000?00?000010?0000001?00?0?01000?0?0000?0000?1000000?100001???0??0?000101?0?????00000010001001200100\nFasolasuchus	?0??01????0001??001111?0000????????????????????????????????????????????10??000000000101???0????10??????????????????????????1?2????0210?0?????10000?0???????1101010010000010111?????????????0000???0????000?????0000?0000????0??00??0????000000000????????????????????????????0???01?000?1?3???010000?00??0??????00???00000?00?????010000211111111111?????000?11?????01??????0??00?0????????0??0??0?0?00?0????0?????????00?0???????0??0??00?000?0??000\nLotosaurus	0001110010012101100011?100001000010?0101000000?00020000???1000??01????21100000001001011110?1110220????0000000100121000101?????????00000011?0000000100010000000101001?0?0010110?????????????00000100???00?0?00????00?0002??0?0?0000?0??1000000000000000000000000002000?00?0??00???000020?000000000000000000??00??02?00000000000010?000000500000000000????0??0?0100???00000???0?010?0??000??01???0?0000?000000?0?1??????010100?????0???00?0001?002?0100\nPoposaurus	??0????????0????????????????????????????????????????????????????????????????000001100112110?1112211?????0000?0101210011102210220120200101000000000000?1?000??01010011000010111????????????????????0?0?0?00?000?00001?????00000????????????????????????????????????????????????????????0100000000000000000??????????00???????????????????????????????????0000001??0??0???????0????????00????0???0???0???????????1??????0??????????00??????00?0???00??0\nPostosuchus	000101011110011000001100011101?010000001001110110130?00001000120010??00100?00000000001100011001??01011??0100001001000000022102200200000010000000001000100001001010011000010111??00000?100000000000000?0000000000000?000000000000000000?1000000000000000000000000030000000000?01?1010000?1?????0?0000?00??0000000000??000000001000001000021111111111100000000?0100000010000000100010?000000000?000000000000000???1000000000?00000010000001000?00000000\nPrestosuchus	?10111011?000100000111?01111?0000?010??1010110001010?0????????????????00000?????????1111001?00111?0111000100?01002?0000002??0210020000001000000000000000000110101001000001011000000000100000000000000???00000??0000?00000?????000000??10000000000000000000????00?3000????0???0???0100?0?1?1???010000200??0?00???00?2100000000000??010000211111111111????0000001000000000????01000?0??0000?0???00?000??000000???0????000000???????100?00?000??00?00000\nRauisuchus	??0??1??1????1000???1??0000????????0????0?1?10?000?????0?????????????????000000000001010001?001?1?1?1????????0100110000001?1020?????????????????????00?00001101010010000???????????????????0000?00000??000?????00?0?00?00??????00??0????0?0000000?????0?00????00??000????????0???010??001?1???010000200??0??????00?2100000??0?00???1??00??111?111111????0?000??00???0?00????0?000????000??00??00??0??00????0?0?0???????0?00??????1???0??00??????20?00\nSaurosuchus	0101010111100110000011100001000101000101000110000010000000000020010?00000??????????0101000??00110????????????0100110000002?10210020000?0?????00?0??00???00?11010100100000101110000000100000000000?0??????0?????000?10000??????00000000?1000000000000000000000000030000000001001?10100?0?1?31??010000100000000?00?0?210000000000000010???211111111111????0000?01?00000100????01000?0??00000?????????0000000000??0????000000???????100000000???000?0000\nShuvosaurus	00100101000121?1100?10110001110000020110100000000022111010111021111??020111111000010???211??11122?0001??1000?1001201011111211231121210101011000010100110000?001010011000010110?0001011101010000000000?0000000??0000?00020?0???0000100??110000000000000010020000003000000?0?310???00002?000000000000000000000000002?00000000000010?000000500000000000????0000100000000100????01000?0??00000?0??11?0?00?000001??00????000101?0?????00??001100??01200000\nSillosaurus	????????????????????????????????????????????????????????????????????????????1001?11001?211??11???????????????01?12000?10?12102101?0000?0?????00?10????????????????????????????????????????????????0????0?0?????000????????????????????????????????????????????????????????????????????00??????0?0000?0000???????????????????????????????????????????????0000?00?????0????????????????????????????0?0?????????????????????????????????????0???0??????0\nStagonosuchus	???????????????????????????????????????????00??????????????????????????????001000000101000??001??????0??0100?01001?000000201021003??????????????????0?????????????????????????????????????????????000??0?0?00??00???????0?????????????????????????0??0??0????0????????????????????????0???????0?0000?0000???????0?????????????????????0?????????????????0000????????0????????????????00????0???????????????????0???????????0?????10???????0?????1???0\nTeratosaurus	?001020111000100000011100101?1101?????????1?10100130000001????????????000???0???000??????????01?1????????????010011000000??????????????????????????????????????????????????????????????????000000???????????????????0000???????0001000?10000000000?0000000??00000?000????0??001?10100??01?21??010000100000000???00?210000000010?1?010?0?211111111111????0?0?????????01?0??????00000??00????0????????00?000?00000???????0000??????1???00?1?????00??00?\nTicinosuchus	0?????????????????1111?0??????????????????????????????????????????????00????000000001??0??11???1000000000000?01000200000010?0200020000?0???????00??000??00?11010?001000?01011?0?00000110?00???0???000?00000000000001?000000000?00??0??1?0??0???????0?????????????????????????????01?0?0?1231??010000100000?0?????0021??00??00?????0100????1111?11111000000000?1000?00???0?0001????0??0000??0000000?0????0????00??0000000??00?000010??????000?0?020?00\nTikisuchus	000?????1?1???????0011?0????????0?0?????0?0???10??20?????????120??0???01?000?????????????????????????????????????????????1?1010??????????????????????????????010?00??0??010111???????????????000?0?????????????00????000??????0000?0????0000??????00??00?0?00?????????0??0????????1000????????????0??00??0???0??00?????00?00000?0?01?000??1111?1111????????00????????1?0????0?????0????0??0???????0?????0???????????????0??????????????????????02??0?\nYarasuchus	0?????????1??2????1?01?0????????????????0?0??????0?0?1??????????????????????1???00000?10000?0?1?101?10??0011?0100020000001?1020???0000?0??????000??0001000?????????????????????????????????0?01?0?000?00?0?00??0000??0?00?0????00??0????0000??0????0?00?0????00???000?????????????10??001?11??010000100000???????0?21??00??00?0???????????1111?1?11?????0?00??100???01??0???????0?0??00????0???0?0?0????0??0?0??????????0?00?????????????000?0??20?00\n;\nend;\n'
        if not check_individual_results(cm, t):
            res = False
        print("interleaved phylip ", end = '')
        cm = "./pxs2nex -s TEST/morph_data/morph_inter.phy"
        t = '#NEXUS\nBEGIN DATA;\n	DIMENSIONS NTAX=64 NCHAR=322;\n	FORMAT DATATYPE=STANDARD SYMBOLS="01" GAP=- MISSING=?;\n	MATRIX\n\nErythrosuchus	00010000000100101010000001000000100010000?00000000000?0?00?010010000000001000?0000??0010000000000000000000?00??00000?00?01?0000100000000?010000?0000010000?00000000?0000000001?0000000??0000000000000000000000010?0000?00?00000000000000000000?00?000010??000000??1000?0?0000?000?00?000?100000?0?0??000000001??10??01010010000000\nEuparkeria	0000000100010000001000001100100000000000000000000000000000000?0100000001000000000000000000000000000000?000000100000?000?0000000000000000000000000001000000?0000000??00000000?0?0000000000000000000000000000000000?0001000000010000000000000?00?00?0000000?000000?01000?0??0000000000?000?1000000000?00000000000010??0000001?000000\nPROTEROCHAMPSIDAE	10000000000010000001000000000000000000000000000000100??0????000000000000000000000000000000000000000000?0??000000?00??00?000000000000?000000100000001000000?00?00000?000000000000?111000000000000000000002000000?0?000000000??0?0000000000?0000????0000001?000000??1000?0??000000?0?00000?1000000000??1000000????10??00?00010010000\nScleromochlus	10101?01000?00000110000001??00000??01000??00??????????1?????1????000?00?????00??001100000000100??00000?0???00?1??10??01?0???00?0?0?1?011101110000000??0000?0000?000?0000000000000?0000000000000000000?00??????????0001?0000??0?0000000000?0?0000???00?000?000?00??0000?0??000??00?010001?0000000???0?10000?000??10??????001?010000\nEudimorphodon	10001001000010010?00000?0?0000?0???00000??0?????????????????1????010??000000000?0011001011101000000000?0??0??010?1100?0?0??0??????11?011?01??00011111?1111111111111111111011111?100000??00?000000000???0??????????0000?00?0??00000??0000??0?001001000?1??0?00?01?0010??0?0000??00?11000??00000?????1000000?0000000??00?0000?01?000\nPeteinosaurus	??????????????????????????????????????????????????????????????????????00??0000??0011001????01?0???000????????????1?0?00?0??0??????11?01110101000??????1111?1?11111111111???1111?0???????????????????????????????????00?00?????0???????????0?0?1001?00?1?0000?????00??????00000?00?110?0????????????10000???000000???????000?0????0\nPreondactylus	10?0?????00?11010???000?0????00?????????????????????????????0????010??00????00??0011001???????0???0?0????????????1????0?0?????????????11101110001111??1111?1111111111?11110?110?0?0000??00?00000000????0??????????000??00?????0?00??0000??00001001?00?1?00?00??1?0010??0?0?0?0?00?110?0???00???????100000??0000000??0??0000?01??00\nAustriadactylus	1000??01?00?11010???000?0?00?0????????00?000????????????????????????????????00??001100????????????????????????????????????????????????11????????111111111?11?10?????????10?1??????0000??00?000000000???0??????????0?0??00?????0?00??000???0?001001?????????00?0????10??0??????????0???????00000?????????0???????????0??0000?01?00?\nLagerpeton	??????????????????????????????????????????????????????????????????????00??????01???????00100000001010100?1000001?1?0101000?10?101111011101011110???????0????????????0000?????????????????????????????????????????????0?00?????????????????????????0000001100??????0???????0000???????00???????????0??000????????0000????0???0?0??0\nDromomeron	???????????????????????????????????????????????????????????????????????????????????????????????????10100?000001111??1010???10010101????????????????????0??????????????00???????????????????????????????????????????????00?????????????????????????????00????????????????????0????????00?????????????????????????????????0???0?0???\nMarasuchus	?0???????0?????00?1????????????????????????????????0001??????????110000000000?00001100110100000000000001?111100011?1001100?00010111101110101111???0????000??010?0???000000?0??????0?????0????????????????????00??????0?00??00???00????????????????0000000?00??????0????00?000????000?00????0????000??100??0?????00????0?00??0?00?0\nPseudolagosuchus	????????????????????????????????????????????????????????????????????????????0??????????????????0???000?0?111110??1?1001101?00010?11????????????????????0??????????????00???????????????????????????????????????????????00?????????????????????????????00???0????????????????0????????00?????????????????????????????????0???0?0???\nSilesaurus	00?00????001000000100000?1??0000???0?0???????001??000000???00000?110000010000000101100010000100000100011?11111001011011001?000?1111???01011111100000???000?0000000??00000000?0?0?000000?0000000??0???????????00???00000000?000?0000?0000000000????000000?0000??1??000010??000??????1?00???00????000???001000????00000?000010001000\nSacisaurus	?0???????0????00011???????????????????0?????????????????????00??????????????0???1????????0000000?0100001?1?1110??1110111???????????????????????????0???0?0???00?????0000000???????0?????0?0?????????????????????????0??00???????00??00????000??????00?00???0??????0????0??00??????11?00????0????????????10??????0???????0???0?100?\nEucoelophysis	???????????????????????????????????????????????????????????????????????????????????????????????00??0001??1110100????????????????????????????0??????????000??????????0000???0???????????????????????????????????????????00??????????????????????????00??????0?????????????????????????00?????????????????????????????????0???0?????\nLewisuchus	??????0????????0011?0??????????????0?000?0001?0???000010????0????11000000????0??10??000????????????001???????1???0?????????????????????1???0???0???0??0000?????000????0?0000?????00?????0?0?????0???0??0?????00?10?0001000?00???0???00?00?0?00?????????????0??01??0????0???????????0?00????0??0?00????????0???????????0?00??0???00\nEoraptor	0010000010011000011?000?10000001??10100001000??????????????????1??10?00???0000??0?11001?0010000?01101??????10?0??1????1?0??00????11???0101?1?1?00000000000?0000?00010000000000000?0000??0000000000000???????????0?0000?00?0????0000?00000?0?00??11?00?0?0?00111111?00000?000?0111??0000001000000??00000000??00000???00?0000?00?000\nHerrerasaurus	000000101001000000100000110000011010000000000001001000101???0001?110000111000?000?1100110010000001101001?11111000111011101?0011111111101011101100000100000?00000000100000000000000000000000000000000000000000001??0000?0000???000000000000000011110000000000111111100000?00000?111111111?000000000000000000?0000010100000000000000\nCoelophysis	00000000100010100110000011010001101000000000?0010?100010????0000?110010111110000001000110000100000101001?1111100111101110??001?11?1?1101011101101000100100?00000000110000000000000000000000000000000000000000001??000000000???00000?100000000011110000001000111111100100000000111111110111111111111111110000000000??00000000011111\nLiliensternus	00???????0?????0011?000????????????0?000?1000???????????????0??0?11001001100000?001?001?0000101000101??????11100011??11????00111111???01???????0??00?00100?0000000??00000000?0??0?00?0??000?0??????????????????????000?00??????0?0???0000?0?00????000000???0??11??1????0??000??1??11?101??????1???1??????0?0????000?????00??011110\nZupaysaurus	?000?01010?????0011?0000100100011010100000000???????????????0??0?????????????????0?????????????????????????????01??0?111???00111111??????????????0000001?0??????????????000???????0000??0000000000000?000??????????00??00?0????0?00?10000?0?00???1?????????0?11????????0????0??1??????01?111111??????????0??????????01?00???01111?\nPlateosaurus	000010001000100101100100110000011000000000000001001000101??110001110000011000000101100100000000000001001?11101000011011101?00111111111010001011000000000000010000000000000100010000000010000000000000000000000000?0000?000000000001?0000000001010000000000001111111111111111110000000001000000000000000011111111111111110000011000\nPantydraco	00100010100??00?01?000001001000110100000010000010???????????00?011?000??????00????11001?0010100???1????1??????0??01??11?0?????????????01000101?00000?00000?0?00000??00000010?0???00000000000000000000?000?????0?0?000010000000?0000000000?0001????0?0?000000111???101?11??11?000?00??0?1?000000000???0001111????1111000000??00100?\nAntetonitrus	??????????????????????????????????????????????????????????????????1???0011??0???0?11001?????????0??01??????1010??0?1??1???????????????0100?0?1?0???????0?0?0100?000???00?????????????????????????????????????????????0?00?????0?????????????????0??00?0?0000?????1???????1??????0?00?00??????????????000???11110??1?????11111?1??0\nEocursor	?????????????????????????????????????????????????????00?????0000?010????????????0?11001??0?0100000101??????1??0??1????????????????????11???1??????????00?0?00????0?10000??00?0????0???????0?????????????????????????00?00??????????????????1111?1?111111?1????????????????00???00??1??0????????????????????0????00????0?00??0????0\nHeterodontosaurus	0010100010110000?100000001000001??1000000100000???100?1?????1010?01000000?0000??1011001110101000001010???1?10?00?10?0?1?0?????????10?11101110?100000000000?0000?0001000000000100000000??00000000000000000000000?0?0000000?0??0011111121111101111110110011?110?00000010?0?00000?00?010?0??000000?0??0000?1000000000??00?0000000?000\nPisanosaurus	0???????????????????0???????????????????????????????????????00001??0?0????00??????????????????????????????????????0??11?0???01???11???11???10??0??????00????????????00?0??0???????0???????0?????????????????????????0??00????0???????2?????111????????00??????????0???????0?1????????????????????????00?????????????????0?????1?0?\nPaleorhinus	1000000000000000010000000000000010000000000000000?0000000?001110000000010000?10?0000010001000000000000?0???00000?001000?10?01000?000?000000100001000000000?000010000000010000011011111110011100000000000000000001?00000000000000000?00001001000000000?0000000000?01000?0??00000000000?01?0100000010000000000000010??10000000010000\nRutiodon	1000000000000000010000000000000010000000000000000???????????11?0?0000001000001000000010000000000000000?0???00000?00?000??0101000000????????1????1000000000?00001000000001000001101111111111?111100?00?00??1???1?1?000000000???00000?00001?01000000000?000??00000?00000?0??0000?00?000101?000000001000000000000001???10?00000010100\nMystriosuchus	1000000000000000000000000000000000000000010000000?0000000?0011001000000100???1??0000010000001000000000000000000000??????????????????????????????1000000000?0?001000000001000001101111111011000110111120122111011000000?000000000000?00001001000000000??????00000???000?0??00???0???0??01?0000000??00????000000??10??1000000?01?100\nPseudopalatus	1000000000000000000000000000000000000000000000000?00000?????1???????????????????0000010????????????00????????????00??00?10?01000000???000001000?1000000000?0???10000??0010000011011111111110101010100210201111111?0000?000000?00000?00001?01000000??0?00?0000000?00000?0????0?000??00?01?0000000???0000000?000001???10?0000?01010?\nAetosaurus	0000111100000001011?000000000000110010000000????????????????0010???0????0??0??0?1100010?00001001?000000000000000000?000?10?0??00?000?000001000000000000000?0000000000000000000000?0010??0000000000000??0??????????0110?00?0??000000?00000?0?010??0000?000000000????100?0??0000?00?000?01?010000????0?00000?000001???00?0000?010000\nStagonolepis	0000111100000000010000000000000011000000000000000?000000111100101000000100000100110001000000000100000000000000000001?01?10?010000000?000001000000000000000?000000000000000000000000010000000000000000000000000011?1110000000000000000000000001000000000000000000?00100?0?00000000?000001?0100000??00000000?0000010??00000000000000\nDesmatosuchus	00001111000001000100000000?0?00011000000000000000000000?1??100101000000?0?000?00110001010000100??0000000000001001001001010001000000??000001?000?0000000000?000000000000000000000000010010000000000000000000000011?11111220000000000000001000010??00000000?000000???100?0??000?00??00?001?0100000??00?00000?000001???0000000?000000\nLongosuchus	0000111100?0??01011000000010000011001000??????????000?0?????00101000000100??0???1100010?0000100?0?000?0000?00100000??00?10001000000??000001100000000??0000?0000000000000000000000000?00?000000000000?000??????0???1110122?00?00000000000??00010000000?000000000??0010?10?00000?00?000001?01000?????0000000?0000010??00?00000000000\nOrnithosuchus	0000001010000010011?000010110000100000010000000000000??0????010110?0000000001?000100010000000001000000000001000??0??001?1?????????00?00000?100000000000000?0000000??00100000?0?0000000000100000000000000000000000?000000010?0000010?0000000000?00?000000????0000?0?100?0?000??000?001001?0100010??0?0?0000?0000000??0000000?00?000\nRiojasuchus	0100101000000010011001001011000010000000000000000?000000????1100?00000000000???0?1??0100?00000010?0000?0??010000?001001?10?010000000?000010100000000000000?00000000?0010000000?00?000000010000000000000000????0???000000010???00010?00000?0000?00?000000000?0000?00100?0?0000?000?0?1001?01000100?000000000000000???00?00000001000\nDromicosuchus	0000000110010000001?000011001011101010011?001?0?????????????10???0?0000?0?00?100110?0001?000100????01??000?000000000000?0?????????0?????????????0000?00000?00??000????000000?0?0??0000??00000000000000000??0??0???000?000????1?0000?0000??0?00?????????????00100???000?0?0000??00??0?10??010000?0?0?????00?0????0???00?0000?010000\nHesperosuchus	000000?110?10000001?000011001011101010011?0010000???????????10???000000?0????1??110?000????????????01??000?000000?00000???????????????01??1????00000?00000?00??0000???0?000000?0??0000??00000000000000000??0??0?1?0000100???1110000?0000??0?00?00?????00???00100101000?0?0?????001?00101?010000?00?00?0000000000????00?00000010000\nPseudhesperosuchus	0000000110010000011?00001100?0011010?0?1110010000?0??????????????000000?00??1????10?001????????????0???0?????0000000000????????????????1????????0000000000?00000000???000000?0?0?000000?000000000000?000000000001?0000?0001?00?0000?1000?00?00?00?????00???001?0???000?0?0?????00????101?0100000????????00?000??????00?0000001000?\nTerrestrisuchus	0000001100?????00111000011001000000010010000100001000???1??11000?100000000001100110?00011000100100000000?0000000010000000010100000000001101101000000?00000?00000000000000000001000000000000000000000?000000000011?0000?000?1?0?00?0?00000000001000000000000001001?1????1?000?0000?000?01?01?0000??00?000?00000??00???0?00000010000\nErpetosuchus	0000001110010000011100001000?00011100001100010000???????????0?00?0?00001????????110?000?????????????????????????????????????????????????????????0000000000?0???1001?????00000?000?0000000000000000000?0000??????0?000000000??0?0000000000?0?00?0????????????0000?0?000?0?0????000??10??1?0000000???00???00?00000????00?000???1?010\nGracilisuchus	0010011110010000011?0000101000001000100110001000??000??0????0000?01000010000010000??01000000000???0000?0???0011??00??00?00?01?0??000??11000110000000000000?0000000??00000000?0?0?10010?00000000000000000000000000?000000000??0?000000000000000????00??000?0000?0??0000?0??0000?0??00?00??000000???0??00000?0????10??00?0001?010000\nQianosuchus	0000101100001011111000??0?0000?0???01000?0?0?0??????????????0?00?110?00??0??00??1000000?1000100??00000?0?????????0???00????01?0?000???0?00?000001010000000?0000000??00000000?0????00000?000000?000000??0??????????0000?00?0??0?000?000000?0?00????000?000?00?001???100?0??00???0??00??01?000001??????00000?0?????0??00?000???10100\nRevuletosaurus	?000??0000?10010111?0000?0110000??00?000?000????????????????0????0000001?????????0??01000000000????000?0???0000??????????0?01000000?????????????000000?000?????000????0??000?0????0000??0?0????000000??000????????0000?00????0?000000000??0?00?????0???????0?00??????0?0??000??0??????0????0000?????????00?0????1???00??00???1?000\nArizonasaurus	000010100??????11010000011??00001000?0000000?00011?000100000000?010110101111??111000???01001000100100000000000000???0????????????????????????????0?0?00000??0??0????00???000?????00000??0000?000000000000000000????000000?0000?0000000000?0000????0000?????01?00???10?10??00??00?????000?0000?0?0?0??????000????10??000?0???01?000\nArganasuchus	???????????????10?1?0???????????????????????????????????????00?????0?0?????????????????????????1???0000000010000000?????1???????????????????????????0??0????????????0000?00???????00?0??000?????????????????????????0?0?0????????0??0?????000???????0??????01????????000?????????????00????0????????????????????????????0???0??0??\nBatrachotomus	000110101000?001111?0111000000101010101101100000??100000000110000000010111000?0111?0010010000001000000000000000???0000001?????????0???00??0?00000000000000??000000??00000000?0?0?00000??0000000000000000000000000?0000000?0000?000100000000000????000000??001000???10010??00??00??00?000?00000000?0????00000????10??00010000000000\nBromsgroveia	????????????????????????????????????????????????????????????????????????1?11??11???????01101010???1?0??????000?????????????????????????????????????????0??????0?????00?????????????????????????????????????????????????00?????????????????????????0?0??????0??????????????00??????????????????????0?????????????10??????00???????0\nEffigia	00100010001011010110100011000000110100000000111010?110111??00111110001001111??1101?010?10010111111111010110000?01?1100000010110000?00001011101011000?10000?0000000??0000000000000000100?000000000000?0000000000?1?0000000?0?0000000000001?0000?00?00010000001?00??1000?0?0000?000?100000?100001???00?00010?0????000000100010010100\nFasolasuchus	?0??0????00??001111?0000????????????????????????????????????10??0000000101??0??????????????????1???010?0???10000?0??????10101000000?????????????0000???0????000?????0000000????0??00?0??0000000???????????????????0?00?00????0?0000?00????0000????000??????01???????00?0??????????0??00?00?0????0???????000??????0??0??00?000??000\nLotosaurus	0001100100101100011?100001000010101000000?00000???1000?0????1100000000101110?111??0000010000011????00000?00000001001000000101?0?000?????????????00000100???00?0?00????00000??0?0?000?0??00000000000000000000?00?0?0000?00?0??0?0000000001?0000??????0?00???00000???010?0??000??0???0?000?000000?0?1????01000????0???00?0001?000100\nPoposaurus	??0???????0??????????????????????????????????????????????????????000110011110?111???000010001101001000100000000000?1?000?0101100000????????????????????0?0?0?00?000?0000????00000????????????????????????????????????0100?????????????????????????0000??0??0??????????????00???????0??0???????????1????0????????00??????00?0??0??0\nPostosuchus	000100111101000001100011101?0100001001110101?000010001000??0100?000000001100110011??01001000000100000000000000001001000000101100000??00000?100000000000000?00000000000000000000000000000000000000000000000000000??0000?000000000000000100000000000000?000000100000100010?00000000?00000000000000???0000000?0000010000001000?000000\nPrestosuchus	?1011011?0000000111?01111?0000?0??1010110010?0??????????????0000???????111001?00010001001000000?0000000000000000000000001010100000000000000100000000000000???00000??00000000?????00000??00000000000000?00?00??0???0000?00?0??0?0000000000?0000????0000000000000???1000?0??0000?0??00?00??000000???0??00000??????100?00?000??000000\nRauisuchus	??0????1???000???1??0000???????????0?1?10?00???0??????????????000000000101001?0011?????0100000010?????????????????0?0000101010000???????????????0000?00000??000?????00?000?0??????00?0??0?00000????000?00?00??????00?0000????0?0000??0?00????0?????00000???0?00????000????000??0??00????00????0?0?0?????0?0?????1???0??00?????0?00\nSaurosuchus	010100111101000001110000100010101010001100000000000000000?0000????????010100??00???????010000001000000?0???00?0??0???00?101010000000000000100000000000?0??????0?????000?000??????00000000000000000000000000000000?0000?000000??0000000000000??????000??00000100???1000?0??00000???????0000000000??0??00000??????100000000???000000\nShuvosaurus	00100010001?1100?1011000111000001101000000001110101110111??001111110010???11??1100??10010010111111111010110000101011000000101100000?0001011101010000000000?0000000??00000000?0???000100?10000000000000000000000?1?000?00000000?0000000001?0000????0001000000100???1000?0??00000???11?000?000001??00??00010?0????00??001100??010000\nSillosaurus	?????????????????????????????????????????????????????????????????10111001?11??11???????01?00?1?1001000?0???00?10???????????????????????????????????????0????0?0?????000??????????????????????????????????????????????0000?????????????????????????000??????0?????????????????????????00?????????????????????????????????0???0????0\nStagonosuchus	??????????????????????????????????????00????????????????????????001000010100??00????010010000001000????????????????????????????????????????????????????000??0?0?00??00?????0????????????????????0???0????????????????0?00????0????????????????????000??????0??????????????00??????????????????????0????????0????10???????0???????0\nTeratosaurus	?001001110000000011100101?1101???????1?10101000001??????????00???0??00?????????0???????01000000?????????????????????????????????????????????????000000??????????????????000???????00100000000000?00000?00000??0?0?000?00000??0?000000010??00???????0???????01?0????00000??00???????????00?000?00000?????000?????1???00?1?????0?00?\nTicinosuchus	0??????????????1111?0???????????????????????????????????????0????0000001????11??000000001000000?000000?0?????00??00??00?10?01000?000?00000110?00???0???000?0000000000000?00000000?00?0??0????????0????????????????0?00?00?????0??0??00????000?00000000000?00???0?01????0??0000??0000000????0????00?000000?00000010??????000?0?0?00\nTikisuchus	000????1?1?????0011?0????????0?0???0?0???1???????????10?0???1?000??????????????????????????????10????????????????????????0?0??0??00???????????????000?0?????????????00???00??????000?0??000?????00?0?00??????00????00???0????0???0?00000??0?00??????00??????1?0????????0????0??0???????????0?????????????0??????????????????????0?\nYarasuchus	0????????1?????1?01?0??????????????0?0?????0?1???????????????????1??0000?1000?0?11??0010100000010??000?0????000??001000?????????????????????????0?01?0?000?00?0?00??0000?0?0?0????00?0??000??????0?00??0??00???????0?0000????????0??00?0???????????00?00???01??0?????0?0??00???????0?00????0??0?0????????000????????????000?0?0?00\n;\nend;\n'
        if not check_individual_results(cm, t):
            res = False
        print("interleaved nexus ", end = '')
        cm = "./pxs2nex -s TEST/AA_interleave.NEX"
        t = '#NEXUS\nBEGIN DATA;\n	DIMENSIONS NTAX=5 NCHAR=250;\n	FORMAT DATATYPE=PROTEIN GAP=- MISSING=?;\n	MATRIX\n\nTaxonE	AWWYHNTLNCRGWGEFRYLTHEFCCHWGNAFYHICHNYDNGPTTERFLTIQTWTARDRWCCKHSVHWNFQENFSTYGLKQRFQNQHSCNRHIVRQLWNNLRFFICICQIKRGKGNKCQFCILHYFIHLPSLACRLSYAFGYLRHNWFGTLTPYGFASPPNWYMRSEPSFGNSWNMAIQIANAFRTWKYRECGYSIKQSCDSTLMWPHRYWMIAQYTFQVTDSRTYDFITSSLVVYAFLCDAQARADCIDQ\nTaxonD	HWPYHNEWNQRGWGVFRYLTHEFMCHQHRLFYHICHNYDHGPTTERFKAITTWTAQDRWKSGHSVHGDFQENFCTYGMKMRFQNQHSCNRHIGRRLQNNLRFNYCYCQIKRYKGNKCQFVQLKVDIHDKSLAANLIAASMYLRHMWFGPLTPYGFAVPPNWMMVSGPSFGKSWHMQIQIRNAYVTWKYRGKGYSICQSPQNKLMWPNRYWMIEIYTFIVTDIRTALFIQISLSEYAFSCDFIPRQDMNWQ\nTaxonC	QVFYATEVNFRDIGSEGFLTCEFLDHFDAHEEKLLHNYVEKPWIEEPLWWRTRKRDDMYFSYHWDFLDFQENFDMHAYSMVMPQQHSYRFGEYRQVVNNLYYFNAGPMGHRQKMNNKQGCRMHYFIAYAQAQFNSGYHAEYLKMLSTGGLDLSGESSDPNWAKMSGESEGWSHWVAMLMRNYYRHGKSHGCKMFKHAYESEKLRCIGISSSGDQYCFTVRDSSGYRFDACVLECKTSLAACGHNANCGWP\nTaxonB	QVFYHNEVNCRWINEKGILTHEPLDHFDAHNQHILANNVETPVIYRPLWWRTRKAMDRWFYKTSVHWDFQERFDTHGYSMVAPQQQSCNRAEYRQVVNNLRRFIQPQDGHGRKMNVKQGCRMHYFIARASLEFNSGYHAEYLKQLWLGGLDFSGEKSMLNWAKMSGESEGWSHWVYMLMRNYYRHGKLHGCSHRKEALESEKLRCIGIMRWWKQYAFKVRDISGYRFDRCYLICKTLLYDDGCKANCNWP\nTaxonA	QVFTHNEVNCRWHIEKGILTHEPLDHFDAHNHHILANNVETPVIYRPLWWRTRKAMDMWFLKSSMHWDFQENFDTMAYSMHAPQQQSKHSAHYRQQVNNLRRFIQPQMGHGRKMNNKQGCRMHYFIAYASLQFNSLYHAEMLKQLWTGGLDFSGEKSMPNWAKMSGESEGWSHWVLMLMRNYYRHGKLHGCSHRKEILESEKLRRIGIMRWWKQYAFKVRDISGYRFDRGYFGCKTLLNDAGCKVNCNWP\n;\nend;\n'
        if not check_individual_results(cm, t):
            res = False
        print("fastq ", end = '')
        cm = "./pxs2nex -s TEST/test.fastq"
        t = '#NEXUS\nBEGIN DATA;\n	DIMENSIONS NTAX=1000 NCHAR=101;\n	FORMAT DATATYPE=DNA GAP=- MISSING=?;\n	MATRIX\n\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1426:1976 1:N:0:CGATGT\'	NACAACAAAAACTTTATTGAAATAGTTGCATGAAATTTCAGACGTCAAAATAGTCATCTGAAAATTTACTCTTGATCCATTTAAAGCTGTTCCTTATAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1657:1955 1:N:0:CGATGT\'	NGCATTTGTCCTTATACAGACTGAAGAGACCATTGGCATGGATCAAATCATATGTTCTTGGATATGTAGAAAATCCCTCACACCAATCATGATAAATGCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1585:1964 1:N:0:CGATGT\'	NTGGAAAAAAATAGTTCTTGGGTTTACTGAAGTTGATCATATAATCTTTAGAGTTCAGCGGCAGGAGGAGCATTTGGTGTACCCTCTGAAGTGCAAGGCGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1539:2000 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATATCGTATGCCGTCTTCTGCTTGAAAAAAACACCCAAGAGCTAGGCGACACGAGGATCTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1881:1990 1:N:0:CGATGT\'	NGATATTTCTATTCGACTGGTTAGAGAACTCTTAACTTGATCAATATAGACAAATGGAGGTGCTACAACAACATCGACATCAGCCTCCAAGGTTGCATTGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2177:1964 1:N:0:CGATGT\'	NTCCAGTTTTTGATACCTCAACGACATGGCCATCACAATGTTCAACCAAAGAGAATAAGAAGAAAATTACAATCACAAGATGAGCTCCGTTGAGCCCCTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2295:1951 1:N:0:CGATGT\'	NAAAAGTCTGTGCCGCCCTTCAGAGCAAAACCCAATCAACCTAACAAGGTTCAAATGGTGGGTGCTGCTAATGGTTGCTACCTCCATTCTAAACTGTTTCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2642:1999 1:N:0:CGATGT\'	NGTAATTTGCGCGCCTGCTGCCTTCCTTGGATGTGGTAGCCGTTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAATTCTCCGTCACCCGTCACCACCATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2987:1988 1:N:0:CGATGT\'	NTTGAGTCCCACATCCCTTCCTTTGCCCACCTGAATGTATTCATGATGGGTAATGTTTCCCTGTCTTAAAGTTGAATTGAAACCTGGATATATATCTTCGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3233:1928 1:N:0:CGATGT\'	NATGATTCAAAAATTGGATAGAGTTAAGGGGGAATGCCGCTGCTGATAGATCCCGCCCAGATCAAGAATAGTTGATTATATCCAGGAAAATTAAGAGTTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3186:1968 1:N:0:CGATGT\'	NTCCAGCAATACATCTTTTGCAGCAACAAGAGTGAACGTTTTGTTTGCATGAGTGGCAGGCGATAACCCGATTCCAGGTAACACTTTTCCATTTCCCAAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3407:1961 1:N:0:CGATGT\'	NTGTTAATCATTACTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATGATGTTATCCCATGCTAATGTATACAGAGCGTAGGCTTGCTTTGAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3354:1981 1:N:0:CGATGT\'	NCAGGCCTCTTGCCCCCACACTCGACGTTACCGTTGATGGCGCTGATGGTAGGTCCGAAACCTTGGTTGACCACGCTATGAACGCTGCTCATCCAGTACCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3492:1987 1:N:0:CGATGT\'	NTCGACTTTAACATCTGTGGTGATGTTCTTGTTTGTGAACTTAGTGCTCACATCAGCGAGAAAGAACTCTCCCTTCTTTATTCCATTGGAAGTGATGGCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3620:1923 1:N:0:CGATGT\'	NAACAGAAAAGATAACTCTTCCCGAGGCCCCCGCCGACATCTCCGGACTCCCTAACGTTGCCGTCAACCGCCACGTCCCGGTTCAGGAATTTTAACCCGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3698:1949 1:N:0:CGATGT\'	NGAAATTTTTGCCAGGACAACTAGCCGGGGCTTGGCCTATAATGCCATCAAAGAACGCCTGACTCACAACATCCCCGACCGAGACACCGCTACTCGGGGTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3907:1950 1:N:0:CGATGT\'	NGTGAGACTAAAGCCATAGAGAAATATTCCTAGGCCTTAATTAGAGACCAAATCAAGGAGCTTCCATCATTTGCTTGCCTGGATTTCAGAACTACTATCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3953:1959 1:N:0:CGATGT\'	NGCCAAAGCACCTGCATTTGCATTGCTTCCATGAGACTGATCACCCGAGCTTGAAACGAAAATACCCTGCTGGCGGGCTCGTTGGAGCTCCTGCTCAAGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3806:1965 1:N:0:CGATGT\'	NAACATATGATAGAATACATTAGATCACATCATACCACTAAACTTATAACATTAGCATCTTATTGCACAACCAAAAGCAGCACTAATTTAGAGTTGATAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3909:1974 1:N:0:CGATGT\'	NTCCACTGGCCGACGCCTGGAGCGCGCAGGTGCCGAGGCACGCTGTGACAGCGCGCGCTGACTACCACAATCGCGAGGACAGCACTCCCGGAGACTGGGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3887:1986 1:N:0:CGATGT\'	NTCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTGGGGCTGCATTCCCAAACAACCCGACTCGGCGACAGCGCCTCGTGGTGCGAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3753:1998 1:N:0:CGATGT\'	NCGCTGACTACCACAATCGCGAGGACAGCACTCCCGGAGACTGGGTTTCCGCTGCCCTCACAATCCACGTCAGTCCGCACCCCGAGCCGATCGGCGGACCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4218:1933 1:N:0:CGATGT\'	NCATGAATTAAGTGATGTAATTAAGAAATGAATGGCACAACCACAATCGACACCCAACAACATTATCACTATATGATTAATAAAGCTATTTTCCATTCAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4054:1941 1:N:0:CGATGT\'	NTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTGGGGCTGCATTCCCAAACAACCCGACTCGGCGACAGCGCCTCATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4066:1956 1:N:0:CGATGT\'	NCTAGGGCGACGCTAGGGCGACGCGTGAAGACCCGGGGTAGTAAACTACCCGGACGGGACTTCCCCCTTCAAAAATTAATTTAATATCATTGTGGGCCAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4441:1928 1:N:0:CGATGT\'	NGCGCGCGTGCGGCCCAGAACATCTAAGGGCATCACAGACCTGTTATTGCCTCAAACTTCCGTGGCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4424:1942 1:N:0:CGATGT\'	NCGAGATTCTTTCCATCTTTTTCGATGGCATGTTTGAAAGCAGCTCCAAATCCAAGCCACACTGGAAGATGAAACCTTGTCTGAGTCCAAGCGAAAATCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4623:1935 1:N:0:CGATGT\'	NTCATAAGGTGCCGGCGGCGTCCTAAAAGTAACATCCGCCGATCCCTGGTCGGCATCGTTTATGGTTGAGACTAGGACGGTATCTGATCGTCTTCGAGCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4603:1977 1:N:0:CGATGT\'	NTCAAACTCTCACCATAGCCAAAAAACTAAACAATACCAATTATACAATAAGGTCTAGATTGATGATTCTGGCCCTAAAAGGGAGGAGGTGTCTTAAGTAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4758:1929 1:N:0:CGATGT\'	NATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGCAAAAAATTTCATCACTGAAAATTGACTCGCCGTCTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4771:1943 1:N:0:CGATGT\'	NTGTAGAAGGGGAGATATTGACACCTAAGTTGACACCGCACTTCCCAGGGAGGGGACCCGCGTAGCCATAGTTGACCCCATAAGATGGGATAGTCTGTTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4948:1974 1:N:0:CGATGT\'	NGGATCTGTCGTGCTATCGCATTTATATACATGGTGTCCCGACAATGAGGTTGCAAGAGTTTATAGATTGGATGAAGCACACTTAGTTGTCTGTTTGTTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5023:1970 1:N:0:CGATGT\'	NATGGCCGTTCTTAGTTGGTGGAGCGATTTGTCTGGTTAATTCCGTTAACGAACGAGACCTCAGCCTGCTAACTAGCTATGCGGAGTCACACCTTCGCAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5376:1952 1:N:0:CGATGT\'	NAGCTCTTTCTGCTCTTTCAAAAAGATAGTCAAAACCCTTACTACTCAGCGGCTTCTTTATTACTCTTCTATCTTTCTGAACTTTACTGAAATTCGCTTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5460:1978 1:N:0:CGATGT\'	NAGATTTTCCACAGCTTCACCTAGCCATGCAACTATGCTTCAAAAGGCTTATGACATGGCTGCAAAGCACCAATTAATGGTTTTGATACACTGCTGCCAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5685:1934 1:N:0:CGATGT\'	NCCAATCAGCATAGAAATTAGGAGTGGGTGGAATTCCCCAACCATCCACTCCACCCACAACATGAATCAAAGCTGATCCATATTGCACTAATCCGCACATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5761:1985 1:N:0:CGATGT\'	NTCGCCGAGGGCACTGCTAGCAATAGAGTATAGTCTCAACTTATGGGGCTTTCCATTTTTGTCAATACCTTCAGGAATCACACCAACTGACTGCCCTTCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6067:1929 1:N:0:CGATGT\'	NGGGATTCCATCATTAGTGAGGTAAATAACAACCCTGGAGCTGGATGGAAGGCTGGCATGAACCATCAGTTCTCCAATTATACAATTGGCCAATTCAAGCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6174:1980 1:N:0:CGATGT\'	NTATAGCAAAGCATTAATCCTTTTTGTTGTGGCATCAATAGTTTCTTTGTCTCGTTTGGTACCAGTCTCAGTTACAAGTAGGCATTGGATAAGATCGCTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6066:1994 1:N:0:CGATGT\'	NGGGAATTCGCTGATGATAGATCTCGCCCAGTGTCCCCCTCCTTCCCCCGCCGCCTTCCGACCCGCGGAAGAATCCAATTTCAACTACCGGAGACTCATGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6454:1931 1:N:0:CGATGT\'	NCCTTTTTGTATCCATCAACCATCAACGGCATGGCCAGGGCACCTCTTATCGTTTTCCATCCAGTTCGTAACAAGGAAAGGAAGCCTTTCCATGTCAAAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6486:1941 1:N:0:CGATGT\'	NGGGAAAAGGATTCGTTCGTCTAGCTATTGAGAAAGGCTGTCCTTTGGTTCCAGTTTTCTGCTTTGGCCAGTCGAGAGTCTACAACTGGTGGAAGCCTAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6286:1969 1:N:0:CGATGT\'	NGAGAAGATCGCCAAAGAATCTGCAGCTTAAACAAAAAAACTGAGCTTGGGATGGCAATGTTGGGATGAAAATAAGGATTTCACTGAAATCGTCAGGAAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6457:1990 1:N:0:CGATGT\'	NCACAACCTTTAACGTCAGGTTTATGAAGCGATATGAATGATGAGAGTAGAGTTGATTTTGGTGGTGGAAGCGCCTCTGGAATCGTTCCAACAGTTTGCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6510:1923 1:N:0:CGATGT\'	NCATCATCACTTCCACCAGAAATATAATCACCATTTTGGCCCAAGAAAGTAGCCTGCTTTATGTCAGTTCCCACATTACAGTGTCCAACATATCTCTGTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6738:1950 1:N:0:CGATGT\'	NGACGATAGCAATATTTGTAGGGACTGACCTCCATCCAATCACCTCTAGACCCTCTTGTGAAAATATACTTGCAACAACTTTTCTCGCTTCCTCTGCAAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6546:1958 1:N:0:CGATGT\'	NTGACACTGTCATCAGTAGGGTAAAACTAACCTGTCTCACGACGGTCTAAACCCAGCTCACGTTCCCTATTGGTGGGTGAACAATCCAACACTTGGTGAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6727:1973 1:N:0:CGATGT\'	NAAAAAAATTGGATTTCGTGTAATAAGTTTGATATTCATCAATCCCTGTTAAAAAATAATCACAAAAATCTAAACATTTATCTATCCATCCATAAGGTAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6717:1990 1:N:0:CGATGT\'	NCCAAGGATCCAGCACACGCGTCATTAGCATCACCGACCGTGAAACTTAAGACGTATGTCTTCTTAGGGATGGTTCGGACCACTTGAGCGATCGCGCTCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6984:1979 1:N:0:CGATGT\'	NGATTAGTCTTTCGCCCCTATACCCAAGTCAGACGAACGATTTGCACGTCAGTATCGCTTCGGGCCTCCACCAGAGTTTCCTCTGGCTTCGCCCCGCTCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6784:1985 1:N:0:CGATGT\'	NTTTTTCCTTGGTGTAAAACTTCCGGTAGATTTGCTCACCTTCTTCAATAGTCAGCACACCTGGAAGGACTTTCTGCAAACCTTCTGTTTCCAGCATCTCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6839:1992 1:N:0:CGATGT\'	NACAATTTTGCCAAAAAAATGAAAAAAACCCAAAGGATAATCGAAACGAACAAAAACCGAAACAAGAACTTCGCCGGAGAAGCCTCCATTGACGGAACAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7208:1925 1:N:0:CGATGT\'	NACAGGTAATCGCTTGTGTAGGTGGTGCAACCATCACCATGGTGAGGAATAGGAGGCATGTTGCCTTTGTTAGCATTGTTGCGGTGGCCATTGTACTCTCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7218:1939 1:N:0:CGATGT\'	NTCCAGTTCTGTACTTTTTGCTGGCGAGTAGTCCATGGGTATAAATTGGCCACGTGGTATCAACTCAGGGTCCCAACAGACAAAGTATATATCACCGTCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7051:1973 1:N:0:CGATGT\'	NCCACGTCGGTGAGCTCAATCTTCTCACATGGTGCTCCGCTGCTACAAGACAAGGCAACTGCTTCTGTCCTCGTGGTTGTTCCCTTGACGTTCCTGATTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7128:1990 1:N:0:CGATGT\'	NCCGATTTTTTCCAGCCCAAGCCCAGCTGTGAACGGCATTCGCCCAGCAGAAACAAGAACAACATCAGCTTCAAGCATGGTTTGCTCTCCACCATCTGCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7438:1941 1:N:0:CGATGT\'	NATCGGAAGAGCACACGTCTGAACTCCAGTAACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAGCAACAAACAAGAATGCTCTCCCCGCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7281:1952 1:N:0:CGATGT\'	NTCTTCTGATTCGATTACATTGGGGCCTGCAAACAGAAAGAATGGTTCTGCTGCTTTCAGGTGGTTGTAGAGCGCCGTTGAAGAATCCATGTTTCAGCTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7388:1963 1:N:0:CGATGT\'	NCCTGCTGCCTTCCTTGGATGTGGTAGCCGTTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAATCCCATGTCAGGATTGGGTAATTTGCGCGCCTGCTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7352:1966 1:N:0:CGATGT\'	NCCACACTTACCCGGAATGCCTATTGTTTATGCAAGTGATGCGTTCTTGAAACTGACTGGCTATGCCAGGCATGAGGTTCTAGGCAACAGACATAGATTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7463:1968 1:N:0:CGATGT\'	NTGATTATTTGCAGAGATACTTTCAGGTGTAGACTTCAACAATGAACTGTGTGATTCCACAGCTCCATCATTCACCATGGAACCACTCCTACCACTTGCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7496:1993 1:N:0:CGATGT\'	NGCACATGAAAGCATCTTGTTGATACGAAGGACATGGAATGGATGCACCCTAACACGTAGATGGAAAGCATCCTTTCCAGCAAATTTAGCCATGTACTTGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7671:1925 1:N:0:CGATGT\'	NATTAATCCTTTTGTGTCCCAAATTGTCCAATTACTTTGAGGTCCCAATATGTAACACATTGTGGCACCAATGAATGCTTGTAGTATTAGAAAATTGTCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7633:1929 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAACAAGGGAGCGCGACCCTTCGTCCCGGCCATTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7621:1970 1:N:0:CGATGT\'	NTCCACATTCTCTCCGGCATGGCTGATTGGTTGGGCCATCTAATGGAATGTTCTTGCCACTTTTTCAACACTGAGAAGAAGCAGCAAGTGGTTAGAAGAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7644:1970 1:N:0:CGATGT\'	NCTTCCCGGACTCGGGGGTACTGGTGTCCTTCGTCAAGAAGTTTCTTGATCTGGCCGGAGAGGTGCCCGATCACTGCCATTGGCGGTGAGATCGGAAGAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7801:1926 1:N:0:CGATGT\'	NTTCTATATCATGAGGTTGATCTCCAACGGGAACCTTAGTAATCCCAGGCAGATCAATGAGTGTTATGTTCACAACATTTGGCGAATAGATCTTCAATCGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7782:1934 1:N:0:CGATGT\'	NTGAAATTAACCCATTTGAATGTTGGGTCCATGTAATTTTTGTACATTTCAAGGATTTCATTGTGGCTCACCACACCCGGGTTAGTGAAGTTCCATATGCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7759:1956 1:N:0:CGATGT\'	NAGCCGAGTTTGAAAGTGTGAAAGTTATTTCACCACAAGGTGAAGTTGTAAAGCAACCCATGGTTAAGTTAAAGTCGCAATTTCCAACCTCTCCACTTAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7902:1979 1:N:0:CGATGT\'	NAAGATTTTAATTACTTTGACCATTATTTTAAGTTTAATTGAGTTTTAATTATCTTTATTATTGTTATATACTCTATCTATCTCACAAAAAATTTCTCATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8152:1930 1:N:0:CGATGT\'	NGAAGCGAATGGGGGCCGGCGATGTGCCTCGGTCGGATGCGGAACGGCCTAAATCCGGTCCGCCGATCGGCTCGGGGGGCGGACTGACGTGGATTGTGAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8046:1944 1:N:0:CGATGT\'	NCGCTTTCACCGGGGAACAAAGGCTGTCCAAGTAGAAGCTCCGCCAAGACACAACCTACAGACCACATATCTATTGCATTTGTATACTCACTAGCACCGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8344:1941 1:N:0:CGATGT\'	NATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAGGAATAGCCAACGACACGTGCACTTGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8408:1968 1:N:0:CGATGT\'	NGGAAGTCGAAATCCGCTAAGGAGTGTGTAACAACTCACCTGCCGAATCAACTAGCCCCGAAAATGGATGGCGCTTAAGCGCGTGACCTATACCCGGAGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8298:1975 1:N:0:CGATGT\'	NGAAAAATTGAGACCAATAAATGATGATAATGCGATTAGTACTCCATTTAATGAACTGGGTTATCATGATGTTGTGTTAAATGTTGAAAAAATGAAAGAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8512:1959 1:N:0:CGATGT\'	NGGGCTTTCTTTTCTTTCTGAATATCGTTACATCAAACCCTAACCCTATACCACCACCAACCATGTCTTCTAAAGCTGGTGGAAAGGCAAAGCCTTTGAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8618:1971 1:N:0:CGATGT\'	NAGCGATTATTATTACATCCAGACAAAGAACCTGAAGATCCAAAATAACAGCAACAATAGCAATAATAATATGCCTCTGATACAGAAATGCCAATATTGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8628:1991 1:N:0:CGATGT\'	NGCCGACCGGTCCGCCTTTCGGTGTGCACCGGTCGTCTTGCTCCTTCTGCCGGCGATACGCTCCTGGCCTTAGTTTGCCGGGTCGTGCTACCGGCGCTGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8902:1941 1:N:0:CGATGT\'	NCCTTCTTCTCGTACTTGCCTGATGCCTTCTCTTTCCACAACTCGAGCTGAGCAATGACTTGGTTGGTGAATGAGCAAGACATGACAAAGCTGGGGTGACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8800:1943 1:N:0:CGATGT\'	NTTGAATGCTCTACATACCACCCATCCTTCTTCCTGAGGGGGTCCATTCTCATCAGATTCAAGACGATATTCATGCATAATCCAATCAGATTTTTGACCGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8804:1994 1:N:0:CGATGT\'	NGCCAAAAAAAATGCAGAATGATACAGACAAGTAGACAAGTAGTTAGTCCAACAAAATGTTCAACAAATTATACTTGATGCTGATTATACAACCAGAAAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9333:1929 1:N:0:CGATGT\'	NTAGCCCCCACATCATATGGCAGTGATAAAGAATCTTCCATCCCTTTTCATCTTAGAATGTAGAGAAAGTACATGTAGATGAGCATAAGAACGACAGATGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9513:1930 1:N:0:CGATGT\'	NTTCTATGCAGATGTGACATGCCGTATCATGAAGAAAAGCAGATGATCTTACATCATTTGTAGAACTAGTGATCCTTGGTTTACTTGGTGTTTTATGTTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9612:1972 1:N:0:CGATGT\'	NTCTAACTTACTAGCCATAGACATAACAAGACTAAATTTCTCGTCCATAACAAGATCATCAATGGACTTACCATCACCCATGCACCAATCAAAACAGTGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9547:1985 1:N:0:CGATGT\'	NGAGACTTGGGTATCAACAACTAATGACAGAGGGAGCATTTGAGTTCTATCCCATGGAGAGGGAGTTGATTCTCCACGCACTGTCCTCCATGTACCTTACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9674:1993 1:N:0:CGATGT\'	NGGCCATGGAGGCTGCGCTTGAGAGGGGATTGCCAGTAGCTCGTGCTTTCTGGTACGCGCGCAGGCCTGGGTCGATCTTTTTGACTGCTCCCCACATCCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9828:1968 1:N:0:CGATGT\'	NTTGGACCGAAGTAATGGAACCCTTCTTGGTGGTTGTGATACGCTCCTGAAGACCTCCAAGATCAGTTGCCAAGGTTGGTTGATACCCGACGGCAGAGGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9856:1989 1:N:0:CGATGT\'	NGTCCTCCATGTCCTCCATGTCCATATCCACCGTGTCCATATCCACCGTGTCCATAGCCACCATGTCCATAGCCACCACTGCCTCCATAGCCACCATGTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10195:1926 1:N:0:CGATGT\'	NCACAGCATACATACACTAGAATATTCATGATTCAGCTAAGATGGTGATGAGGGACGCCAGTTGACGTTAATGATAAAAGAACACTCAACCATCTTTCTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10231:1927 1:N:0:CGATGT\'	NACACGGGCAACCACCCTCACCGCTCATTCCCATCTCTCCATCCACATACGAGATCTTGGGGGCAACACCGATGACAAGTGCGACGTTGGTGCTAGTTGAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10231:1955 1:N:0:CGATGT\'	NCAAAGTTTAAGGCCGCGTGTTGGGCTGAGGCTAGCCAAATGAGTATGGTTAGGATCTTGACTAGGTCTTGTGGGTTGTTGAGTTTGGGCCACCAGCTAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10191:1990 1:N:0:CGATGT\'	NTTTGGGGAAGCAAGGTGTAGCGAAACCTAAAGGACCACTCGAGGCACTCCGGCCTAAGTTACAGCCGACTCAGCAGCAAACACGATACAGGAAATCGCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10145:1992 1:N:0:CGATGT\'	NCACAGGTAAGTGAAAAGCATATAAGACCGGTACAAGTGAGAACTTGATCATCTTTGTGGATAGGGTGCCACGCGGCAGCTTGCTTCTCTGCATAATAGTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10464:1991 1:N:0:CGATGT\'	NCTCGGTGATCATTGGAAATCCTTGGGCATATTTAATGTGACGAACAGACCCAACCTGTTTACCATCACCTTCAATGATCTCAATGCTCTTAAATCTGTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10689:1925 1:N:0:CGATGT\'	NTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCGTTCGTTAACGGAATTAACCAGACAAATCGCTCCACCAACTAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10534:1952 1:N:0:CGATGT\'	NCTCTGGTCAGTTTCAGTCAGAGCCAGATCCTGAGTGAGCTTCATATTTGCCTCAGCTAAGGCCTCATTACGCATCTCAATCTGACCCAATTCCATCTGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10744:1959 1:N:0:CGATGT\'	NTCCAGCAGTTGCCGAATCTGCTCTTCTGCTAATATTTGTTCCCAGCAAAAATCTTTCACGTAGATTAGCAGCTTCATTCAGTCCTTCCTTAGCCCACTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10668:1961 1:N:0:CGATGT\'	NGATTGCTAAAGCAGATCTTGGTATAAGAATTCCCAGGTTTTACAAGAGGCTTTAAGAGATCCTCAGCCTCTTCAGCCTCAATGAAAGCACGTTTACCTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10522:1978 1:N:0:CGATGT\'	NGGAGGGAAGCGAATGGGGGCCGGCGATGTGCCTCGGTCGGATGCGGAACGGCCTAAATCCGGTCCGCCGATCGGCTCGGGGTGCGGACTGACGTGGATTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10555:1981 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGGTAAAATTCTGGATTTATAATTTATAATGAAGAGAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10697:1991 1:N:0:CGATGT\'	NGGCAGTCTGCTGAGTTGGATCCTTGCCAACCAAAGCAGGGGCAATAATCTCATTAACATTCTTAACAGCCTTAAAAACACCTTTTCCCATGTAATCCGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10885:1950 1:N:0:CGATGT\'	NCGATTGTTTAGCCATCACCAATTCAGCACTTGAAACCAAATCTTGATCTTAATCAAATGACCAAATGAACAAACACACCGATTGTTTAGCCATCACCAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10954:1994 1:N:0:CGATGT\'	NGCTCACATAACTGCTGAACCCATTCCTTGCTGCAGTGCCTCACAAATGCTTCATCACTGGTGATTGGTTCCTGACGATACTCCATTTTTTTGGTATTTAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11132:1937 1:N:0:CGATGT\'	NGCTCATCTTAGGACACCTGCGTTATCTTTTAACAGATGTGCCGCCCCAGCCAAACTCCCCACCTGACAATGTCCTCCGCCCGGATCGGCCCGCAGAGGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11180:1951 1:N:0:CGATGT\'	NGGCTCTTGAAACCACCAAATGCAGTACCCTTCCAAACACGGCCAGTTACCAATTGGAAAGGACGAGTAGATATCTCCTGACCAGAAGCAGCAACACCTAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11174:1979 1:N:0:CGATGT\'	NTTCATATTTCTTCTCAAATTCACCAGAAAGATGCCTCTTGACAAAAGTGGTTTTACCTGTACCGCCGTCACCGACAAGAACAAGCTTGAAACTAGGATAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11399:1971 1:N:0:CGATGT\'	NGCGCCATCCTACCTATTTAAAGTTTGAGAATAGGTCGAGGGCATTGCACCCCCGATGCCTCTAATCATTGGCTTTACCTGATAGAACTCGTTTAGAGCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11506:1954 1:N:0:CGATGT\'	NGCATGAGCATTTTGCACACCCTCGTCCCATGTATTAGACACCACCGAGGGAGTTTCAAGAGCTTGGAAGTTTGCCCATTCCGTTTCAACTTGCGACGTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11818:1923 1:N:0:CGATGT\'	NCCCCCTCCTTGCGGTTAAGGTAACGACTTCGGGCATGGCCAGCTCCCATAGTGTGACGGGCGGTGTGTACAAGGCCCGGGAACGAATTCACCGCCGTATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11986:1927 1:N:0:CGATGT\'	NCCCCGTCCTCTGCCACTAACAATAAAAACAGTGTTCTTCGGATCATTGCAGAGGGTGTTCAAGAGCGATATGAGATCACCGCTTGGTGATTTTACAATGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11889:1929 1:N:0:CGATGT\'	NCGCGCCATCCTACCTATTTAAAGTTTGAGAATAGGTCGAGGGCATTGCACCCCCGATGCCTCTAATCATTGGCTTTACCTGATAGAACTCGTTTAGAGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11908:1946 1:N:0:CGATGT\'	NTAGAATTGAATATGAGAGTCCGATATTGTCGGCGATATCCAAGAGTCTGCATAAATGTGAACAGAAGCAAAATCGATGCCGAGGATTTGATGGTTTCTAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11932:1983 1:N:0:CGATGT\'	NCCGATGTTTTTTTACATCTCACAGCTTCGGCAGATCGCTTAGCCCCGTTCATCTTCGGCGCAAGAGCGCTCGATCAGTGAGCTATTACGCACTCTTTCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11900:2000 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTTCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAGGACCTAAAAGGGACTGGACGACGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12165:1969 1:N:0:CGATGT\'	NCTCAGGTCCAATACGTCTAAAATTGTATAAATTCAGTAACTCATCAACTGTAGGCTCCCAAGGAGCAATTTTACTTTTCTCAATTGCCCCATAAGTAAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12387:1928 1:N:0:CGATGT\'	NCCAGTCCTGTATCTCTAGACTCCGCTCAACAAGTTATTGCTAACATTGTTATACGAACAGGCACATGTTGCGCAAAGGGCCCGTTTAAAGTCCCAATGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12407:1934 1:N:0:CGATGT\'	NGGGGGCTCGAAGACGATCAGATACCGTCCTAGGCTCAACCATAAACGATGCCGACCAGGGATCGGCGGAGGGTACTTTTAGGACGCCGCCGGCACCTGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12364:1941 1:N:0:CGATGT\'	NAAAATCCGGAGGACCGAGTGCTGATCACGCCCGGTCGTACTCATAACCGCATCAGGTCTCCAAGGTGAACAGCCTCTGGCCAATGGAACAATGTAGGCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12324:1944 1:N:0:CGATGT\'	NCAACTACGAGCTTTTTAACTGCAACAACTTAAATATACGCTATTGGAGCTGGAATTACCGCGGCTGCTGGCACCAGACTTGCCCTCCAATGGATCCTCGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12432:1955 1:N:0:CGATGT\'	NAGGTATTGGTTTATCATGGTGAAAAAAGACCGGTATTTTTTTTTGAACCGGGTTCGATTTCAACAAAAGATCACACTTGGGTCGCATAGTTGCAGCAATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12300:1960 1:N:0:CGATGT\'	NGGGGGCATTCGTATTTCATAGTCAGAGGTGAAATTCTTGGATTTATGAAAGACGAACAACTGCGAAAGCATTTGCCAAGGATGTTTTCATTAATCAAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12409:1966 1:N:0:CGATGT\'	NTGCAGCTAGCATTGGAGATAACAGTGAGGTCTGATGTGTACTCGTGCTCGTTAACACCAACAACGAACATAGGAGCATCCTTGCTGGGAGCAGAGATGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12986:1925 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAATTTTAAAAGCCAAGTCCTCCATCTGCATCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12797:1952 1:N:0:CGATGT\'	NAGATGATGTGTTGATTATGCTACTTCCTTCTTTCATGTGTGGCAGTGAGTACCTTGCCATGAAGAAGTAAGCGAAGATATTAGTTTCAAAAGTCTCTCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12954:1969 1:N:0:CGATGT\'	NTACGGGTACCACCAGTAACATGTCGCCTTGTTTATGGCCCGATTTGATGTACTCGACTAGGCCCCTTAACTCCCAGTTGGGTATTGCTCGCTTGTTCATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13082:1923 1:N:0:CGATGT\'	NTCAAATCTACCTTATACTTCGCAACTTCACACTATAAAAAAAAAATAATAATAATTTAAAATAAAAAAAATTAAAACTTAAAAAATAAACCTCAACTTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13153:1957 1:N:0:CGATGT\'	NTTCTGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAGGACACCTGCGTTATCTTTTAACAGATGTGCCGCCCCAGCCAAACTCCCCACCTGAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13035:1969 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAATATAACAGACGTGGTGAGAAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13125:1977 1:N:0:CGATGT\'	NCCAACTACTACGTAGACAAAGTTACATTGAATCCATAATACCTACTAAAGTAAGATCATCAGTCGGACACTTAGCGTGCAGTACATGTAGAAGAAGAAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13364:1928 1:N:0:CGATGT\'	NAGAGAGATTCCAGCCTTGGCATCAAAGATGCTTGACCTGTTGTCACCAATGAAGTCGGTGGACACAACATCATCCTCAGTGTAGCCCAAGATACCCTTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13315:1990 1:N:0:CGATGT\'	NCCCTGCTCTCTTTTCTAGCCTCAGCAGAGTGCATGGTAATGCATGCATTGATCAACAGATTTTCCAACTCCAGGGTTTCTATTAGGTCAGAATTCCATAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13724:1970 1:N:0:CGATGT\'	NGGTGCAAACAATCATGGAAGTCATGACCTATCTCTTAAGCGAATAACACTAGATGATACATGTGACCGAAATGAGGCCACATCCACCTACCAATTTCTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13917:1935 1:N:0:CGATGT\'	NTCCAAACCACCAGCATTGCCAAAACAGTAGCTACAACTACGACCCCAGCTCGCCTCGTTAACCTCAGTATCGACAACTGAGTTGCCGATACTGCTAACTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13878:1958 1:N:0:CGATGT\'	NAACCATTCATCCATATCATCCACACTATTTAAGGCAGTATCAATCCCTTTCAGCACCTCTTCAACTAAAGGTTCTGTTTCCAACATAGCATGCACATTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13779:1965 1:N:0:CGATGT\'	NTTCAGACAACTTTCCATTCCCACCATCATATGGCGATGCTTGTCTTCCAACCCATCTCTTCTCTTCGTACTTTGCACGAATGAAGTTTTCAATTCCAACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13965:1981 1:N:0:CGATGT\'	NCGGCGGAGAGAGGTGTTCGCGCGTCGCAGAGTGGATCAGTCGGCATGTCGCAGGGTGGATCGGTTGGCGCGTCGCAGAGTTGAGCAGTCGGCGCGTCGTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13776:1993 1:N:0:CGATGT\'	NGAACGGAATAACCAAGCAGTAAACTATACAAAATGCCTACCAAAACCAATGAATCAGGAGCTTTCTTGCATCACCGCTTCACTTGGATTCATAGCAACAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13800:1997 1:N:0:CGATGT\'	NCGGGTCACTTGAGAGACACCTCAAGGCGAGATTAGCTACCCTCATAGCATGTTCTAGAGAGTATTGTCCTTCGATACGAGGATCAAGTACCCTAAAGATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14047:1993 1:N:0:CGATGT\'	NCCGCCGACATCTCCGGACTCCCTAACGTTGCCGTCAACAGCCACGTCCCGGTTCAGGAATCTTAACCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14410:1939 1:N:0:CGATGT\'	NCTCGTTGAAGACCAACAATTGCAATGATCTATCCCCATCACGATGAAATTTCAAAGATTACCCGGGCCTATCGGCCAAGGCTATAGACTCGTTGAATACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14342:1950 1:N:0:CGATGT\'	NGCAAACATTCTTTGCCCAATCTACAGGTCCTTGACCGTCAAATACGCCGGCTCCTTTGCCGCCTTGAAATGTCAACCCACTGAGTTGGTAAATCTTGATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14443:1960 1:N:0:CGATGT\'	NCACAACTTCCCTTTTCCCAATGGCAACCACATTCTCTCTCCTCCCATCAACCACCTACATCCGCCACACGCGCCACCGTCTCAGCCACCGTACCAAACCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14411:1982 1:N:0:CGATGT\'	NCTTTCATGAAAAAAGGCTGAGAAGTGCAAAGTCCAGTTTTTTGAAATTCATCAAGAAGTTCTTCAGAAACCCTTGTTAATGTCAATGCAGAAGGCTTTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14373:1987 1:N:0:CGATGT\'	NCCAACCCCAAATTAAAAAAAAAAAAAGAAAAAAAAGGTGAAATTACAAATTTGTCCATCCAATTCATTTTTTTTTTCATAAGAGATATAGATAGAAAAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14689:1957 1:N:0:CGATGT\'	NTAGAGGAGAGAAACCTGGGTGTTATCATCTGGATTCTTCAATATAGCTTCTACTACCTGAAGCATTGGAGTAATGCCAGTTCCACCAGCAACCATGCCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14788:1930 1:N:0:CGATGT\'	NGGCCCGCCCAGACTTTCAACTTCCTTATGAACAGAGCTGGGCATCGACGGGCCCACCTGGGACCGTTGTGTCAATACCATCTTTCCAAGAGGGGCCCCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14875:1960 1:N:0:CGATGT\'	NACCACCGTCCTGCTGTCTTAATCGACCAACACCCTTTGTGGGATCTAGGTTAGCGCGCAGTTGGGCACCGTAACCCGGCTTCCGGTTCATCCCGCATCGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14941:1978 1:N:0:CGATGT\'	NCCTGTGGTAACTTTTCTGACACCTCTAGCTTCAAATTCCGAAGATCTAAAGGATCGTTAGGCCACGCTTTCACGGTTCGTATTCGTACTGAAAATCAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15221:1937 1:N:0:CGATGT\'	NACATTTTTAATGTCGAGGCACTTCCTTGTTGACATTTTCCCACGCAATAGATGTTGCAGGCAACATTGCATAACATAAACTGAGATCTTGGAATAACAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15119:1960 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAGAAGAAAATAAGCGACACAGCCTCATGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15092:1970 1:N:0:CGATGT\'	NCAAAGCCTTGTTATGCTCGGCCCATTTTCTGTTGAGCTCTTCAAGAAACAAAGCTCCTTGAGCAGCCTCTATGGACTTGGATATTTCCTTCAAATGAGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15224:1976 1:N:0:CGATGT\'	NTGGGGTTTCATATTGAAATAATCCAAATAGTAAAAAAAAGATAAAAATGAGATAGATGGAGTAAAATTTTAAACAAAACACAGTATAAACATTAATCATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15243:1990 1:N:0:CGATGT\'	NGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGGGAGGCGGAGTGAGCAGGCCTTCCGACCCAACAAAGTATCAAGCTTGCGCATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15082:1998 1:N:0:CGATGT\'	NATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAGTAAACTTCACTGGGTATGCTCCCTTCGATAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15381:1935 1:N:0:CGATGT\'	NCCTACCTCCGGCTGACCCGTTTCCAGGGTGGGCAGGCTGTTAAACAGAAAAGATAACTCTTCCCGAGGCTCCCGCCGACATCTCCGGACTCCCTAACGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15393:1966 1:N:0:CGATGT\'	NAAAAACACAGGACTCTGCTAAGTGGTAACACGATGTATAGAGTCTGACACCTGCCCGGTGCTGGAAGGTCGGAAGGAAAAGTGTTATAAGCTTTGAATGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15619:1933 1:N:0:CGATGT\'	NGGCTAGTTAAACAAGTATATACACGGCAGATGGAACATGACCTTTCAATAGTAGGACAACATACTAGATTTCCCTCTCTCTTCTTTAATCTATGTAGTAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15746:1943 1:N:0:CGATGT\'	NTCGAAATCAAACTCCACTTAATCAAATTGAATAAAAACTGGTCTGAATTTCCAGCCCAAAAATTATCGTACCTGAAATATCCTAGACCCAACGTTGGGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15709:1964 1:N:0:CGATGT\'	NTGGAATCGAGAGCTCCAAGTGGGCCATTTTTGGTAAGCAGAACTGGCGATGCGGGATGAACCGGAAGCCGGGTTACGGTGCCCAACTGCGCGCTAACCTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15574:1977 1:N:0:CGATGT\'	NTGCGCCTGCTGCCTTCCTTGGATGTGGTAGCCGTTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAATTCTCCGTCACCCGTCACCACCATGGTAGGCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15917:1981 1:N:0:CGATGT\'	NACGCTTGAACCTTGCAATACCACGCTGCTCCAATCAATTTATGCATCATCAAATCATATAACCTTCTCCACGATGAACACCACTGACCATACTGTCACAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15836:1987 1:N:0:CGATGT\'	NCTTGCGACCATACTCCCCCCGGAACCCAAAAACTTTGATTTCTCATAAGGTGCCGGCGGCGTCCTAAAAGTAACATCCGCCGATCCCTGGTCGGCATCGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16205:1941 1:N:0:CGATGT\'	NTGGAATTTGGTGCAATAAGGTTTAAGTTAAGCTAGGACAGGGCCTGCTGCAATAGCATCTCCTGGCAGCACCTCCACAAGCTCCTTCGGGAAAACCCTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16409:1934 1:N:0:CGATGT\'	NGGACAATTTGGATTGGCTGAGCAGGGCCACCAACTGGGCCAAGTTTAGCGCAACTGCTGGATTGGGTGTCATCCATAGAGGTCATCTGCAGCAGGGTCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16670:1940 1:N:0:CGATGT\'	NCTCAAGGTTTCCACGATGTAGTTAGCATAAAGATCCATGGAATGCTGTATTGCATTATAAGCGGTAGTTGCTGGGAGAAATTCATCAACTGCAACATCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16932:1937 1:N:0:CGATGT\'	NAGGCATTCAGCAACACATGGTACCCCTTCTCCAACATCCTTAAACATGCTGAGATCAAATCTTCATAAATTACCCATGTACTTTGTCAACCATAGATTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16753:1989 1:N:0:CGATGT\'	NGGAAAATTTCCAACCGGCAACAAAATATCAATAATGTACACAAAGATGCCTTCTTCTCTTCCGAAACAGAGGGCTAGTAACTTAATCTAACACCAGTTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17022:1938 1:N:0:CGATGT\'	NTTTGAATTCACATATTGCTTTGAAGGAAGTGATCCAAATCATCAATAATGGTCCCAAATTCAAGGATGCCTCTTTAATAACAGTGCACAGATAATAAATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17015:1979 1:N:0:CGATGT\'	NCGGAATCGAACCCTAATTCTCCGTCACCCGTCACCACCATGGTAGGCCTCTATCCTACCATCGAAAGTTGATAGGGCAGAAATTTGAATGATGCGTCGCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17401:1957 1:N:0:CGATGT\'	NAGAATATTGCTCAAGAAGAACGATTGCGTGGTGGCCAGAAGGACGACCGAGAGATGATGATGGCATTTAAGGTTCAATCAGACACACGGGGAAAATTAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17375:1968 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGCATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAGTTAAATAGGGCGTCGGCGGACAGTCAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17446:1974 1:N:0:CGATGT\'	NTTGACCTCCCACTGCGAGGTCGAAGAATACCTTGGGGTTCGACATTTGTACTTTTGATTTAGGAAATTAGGGTTTTGAATTTGGGATTTTGTATTTGAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17277:1978 1:N:0:CGATGT\'	NTTGGGCACCGTAACCCGGCTTCCGGTTCATCCCGCATCGCCAGTTCTGCTTACCAAAAATGGCCCACTTGGAGCTCTCGATTCCGTGGCACGGCTCAACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17493:1991 1:N:0:CGATGT\'	NTCCTTTAGCTTTAACTAGTTTATCACAGTGACTCCACTCTCCATGAATGGTTCCTTCCTACACAACTCAAACCCTACTCTTCTTGGTGATCAAAGAAACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17548:1932 1:N:0:CGATGT\'	NTAAGGAACCACGAGGGGGACATAATCACTTGGTTCGCTAGACCAAGTGGGGAAAAGGAGATAAACAAGGCAGAGCTCGAGGCGATCTGTATAACCATCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17834:1938 1:N:0:CGATGT\'	NTTGGCTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACTAATTAGATGACGAGGCATTTGGCTACCTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17812:1949 1:N:0:CGATGT\'	NCATCATTATCGGTGTCTACTTCCATTAATATCTCCTTAATGCTGTCCTCGTCAGCTATGCCGTACTCCATCATCGCTGTTTCTAGTTCATCTGTTGTATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17854:1960 1:N:0:CGATGT\'	NTGAAGTTTAACAACATCTTCTCATGAGCATAGCTACTGTTTGCATTTTAATGATAAGACTACTTGATTCCAAACTAAAACAGAGAAGCATTTAATCAAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18152:1936 1:N:0:CGATGT\'	NGCCAGCGCAAAGGCCGTGCGATCCGTCGAGTTATCATGAATCATCAGAGCAACAGGCAAAGCCCGCATCGACCTTTTATCTAATAAATGCATCCCTTCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18117:1975 1:N:0:CGATGT\'	NGGCAACTCTGTGTGCTGCAAGACGTAAGTAGGATGTAGGAAAGTGTTGGAACTCAAACTGAAGTTGTTCTGGACTCTGCAAGAACTGCTGAATATCGAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18281:1959 1:N:0:CGATGT\'	NCTCGGTCCATCTTTTCAATCTGGACTTCTTTTTCTTTCAGAGTAACAGTGACATCGCCCTTGGTTGAAACCAAGCTCATAGTCTTTAACTCTCGCTCTAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18421:1961 1:N:0:CGATGT\'	NTTTAACAATTTTGTAATTTTTTTGCATATCTAGATGTGCAAAAAATTATGAACATAACATTATTCTGATTTAGGTTTGGTATTGGTGTTTTCTTTACGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18617:1931 1:N:0:CGATGT\'	NGAGTCAAGCTCAACAGGGTCTTCTTTCCCCGCTGATTCTGCCAAGCCCGTTCCCTTGGCTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18982:1983 1:N:0:CGATGT\'	NCAGAAATTTGAATGATGCGTCGCCAGCGCAAAGGCCGTGCGATCCGTCGAGTTATCATGAATCATCAGAGCAACAGACAAAGCCCGCATCGACCTTTTAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19076:1949 1:N:0:CGATGT\'	NACTGCAACTCTGGTGGCCAAATTCAACCATGACCTCACACCTCCACAAGCAAACCAGCAACAACCTAAACTAGTAAGCGTGTTAAAAATACAACCAGAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19033:1953 1:N:0:CGATGT\'	NGTGACATCAACTTTTTATTAAATGCTCCTATTCATTATAAGGCGGGTTACAAGTCTCTTGTTTCCGTCTTCCATCTGTTGCTTCGCTAGTGCACCTTAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19145:1971 1:N:0:CGATGT\'	NGGACGGACTGGGAACGGCTCCTTTTGGGGCCTTCCCCGGGCGTCGAACAGTCGACTCAGAACTGGTACGGACAAGGGGAATCCGACTGTTTAATTAAAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19003:1988 1:N:0:CGATGT\'	NAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCGTTCGTTAACGGAATTAACCAGACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19450:1968 1:N:0:CGATGT\'	NTCAGTTCGCCAGGTTGTCTCTTGTCTGCCCATGGATTCAGCAGCAGTTCGAAAGGTTGACCTATTCGGGAATCTCCGGGTCTATGCTTTTTTTCAACTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19743:1963 1:N:0:CGATGT\'	NTATATTCTTATTTGTGGTATTGACTTTCAACACTCACAATGGGCAGAAATATTATAACATGCCCCTCATACGAAGGCCCGATGTGAGCTGAAGATGTGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19669:1995 1:N:0:CGATGT\'	NAACTTGGCACTTGGCCCTTTTTTCCACTACCATAATACACCTTGTGTTGGTCAGGAGATGAAAGGGGCAAGTACCAAGCAACAACCCATTCGAGATCCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19940:1931 1:N:0:CGATGT\'	NCCGGGTAATCATTGAAATTTCATCGTGATGGGGATAGATCATTGCAACTGTTGGTCTTCAACGAGGAATTCCTAGTAAGCGCGAGTCATCAACTCGCGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19890:1976 1:N:0:CGATGT\'	NTCCGGAATCGAACCCTAATTCTCCGTCACCCGTCACCACCATGGTAGGCCTCTATCCTACCATCGAAAGTTGATAGGGCAGAAATTTGAATGATGCGTCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19845:1984 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19811:1989 1:N:0:CGATGT\'	NAGAAAAGCTCCAAAAGTAATTGGAGATTGAGGACATACCTTATCCGTCGGTTCATCATCACTCACAGGAAGAATCACAGGGGGGTTACGATTACCTTGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20197:1937 1:N:0:CGATGT\'	NTCCTCATAAGCCCCACCCAAGAACATCCCCAGATAATAACCACCCCCACAGCCACCATTTCCTTCTCTTCCTCTCTCCCCAATGCCATGAAGGAGCAAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20385:1965 1:N:0:CGATGT\'	NCCGGTTGGTGTTGTAAGATCTGAAGTTAGTACCAACAGCATCATAAACTGCCTCATCAGTTCCTTCTGATGCAGCCTTTTCAATAATACCGAACCTTTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20297:1996 1:N:0:CGATGT\'	NCAAACTTGTCTTTTCCAACACAACCAATGTAACTTGTTGCACCGGGTTTTTGGAGCATCCACTGGGCAACTCTGATTGTATTTTGAGTAGAACCTCCAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20580:1968 1:N:0:CGATGT\'	NAACCTCTTTACTCGTAGTCCCACCACGACTACCATAACTCCACGGTTTAGCCAATGTAGACCATGAATACGAATCCCCACCCCAAACATCCAGATCGGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20775:1992 1:N:0:CGATGT\'	NCCGGAAATTCGGTTGGCAGTTATTTTCTTTCCATTTTATCCACTTCTGCAATGACTCAGGCGAACTAAGGTTCGTGGGTCCCGGAAGACCCATTGAAATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21189:1926 1:N:0:CGATGT\'	NACTACCTCCCCATGTCAGGATTGGGTAATTTGCGCGCCTGCTGCCTTCCTTGGATGTGGTAGCCGTTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21144:1931 1:N:0:CGATGT\'	NAACTTTTCAACCAAGTCCTTTGACAACAAGTTGGCAACGACCGCGTGATTTCTACAAGAGTCGAAACCATGAACATAGATGAATTTGTACTTTGCTTTAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21129:1969 1:N:0:CGATGT\'	NAGGGAAGATACACCCATGCCATATCCATTTTTGACCAGATTTTAAAAGAGGATCCAACTTACCCAGAAGCATTGATTGGAAGAGGGACAGCGTATGCTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21013:1990 1:N:0:CGATGT\'	NTTGGCGATGCTTTCTCAAAATTTGGGGCTAATGAACAATTGTATTGCCCTCTCCCATTTATCAACAATGTCTGGGGTTCGCCGACCCAGCGGAAAGGCAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21251:1925 1:N:0:CGATGT\'	NTGGACTAGGTGGTGAAAAGGGGGTGGGGTCCACAGCTGTTTCGAGGGGTCTTTCAGACTGGTAAATATCACCACTCAAGTAATCAAACGAACCTGCATCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1467:2009 1:N:0:CGATGT\'	GTCATCGTCCTCATCGCATTCCCCTTTTGTGGAACTGTTTCCTTTCATTTTTTTTTTTTTTTTTTTTTTTTTTTTTATAATTTTTAAAAAAAAAGCATCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1400:2057 1:N:0:CGATGT\'	CCCAAACTCTGAAAACAGCTCCTTCAGCTTCTCATCATCAATGCTATCATCCAAGTTTTTGATATACAGATTAGCACCCTGATTCTTATCAGCAGCTTCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1418:2233 1:N:0:CGATGT\'	GGGCAAAGTACAAGAAAGTTGGGTCACTGGCGCCATCCTTGTAATAGGCAAAGACGCAAGCACCATCATCATGCATGCTCTCACCGACGAAGATCTGAAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1728:2015 1:N:0:CGATGT\'	TTTGGTTTTTCATTGTTACCAGAGTCGGGTTCGGGTATGGCGGGGGCCTGGAGGGGGGGTGGTTTTTTTTGTTTGGTTTTGTTTTTTTGTGTTGTTGGTGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1627:2074 1:N:0:CGATGT\'	GCCTGGTCCGAAGTCAGAAGGGATATTTGAGACGGCTACGAATTTAGGGCATTCAGGTTGGTTTGGTTTTGATATCATGGTTAGACTGCCGAAGAAGTAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1657:2079 1:N:0:CGATGT\'	TCAGTATCGCTTCGGGCCTCCACCAGAGTTTCCTCTGGCTTCGCCCCGCTCAGGCATAGTTCACCATCTTTCGGGTCCCGACAGGGATGCTCTCACTCGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1724:2093 1:N:0:CGATGT\'	TGGTGGATGTGAGTTGCGTGGTATGATGCCGGGGTCACGGGCTGAAGTGAATAAAAGAAGCACCAACACATGGATAGTGAAGAGAATTGCTACCACTAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1651:2104 1:N:0:CGATGT\'	CTGTGGATTAGAAACCGGTGGAGTGTAACGTTCTTTACCGCCGGGTTTAGAAGAAGCATTGCCGTACCAAAGCATGCCTAAGATCGCGATAATCAAGATCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1598:2205 1:N:0:CGATGT\'	CGGGGGTTTGCTGATGAAATTGAGGGGATTTTGTGTTAAAATGGATCACCTAGGGTTTTGGAAGTTTGTTACTGTGAGGAAAAAGGAACTTGACTTGTTAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1665:2216 1:N:0:CGATGT\'	CTCCTTAGCGGATTTCGACTTCCATGACCACCGTCCTGCTGTCTTAATCGACCAACACCCTTTGTGGGATCTAGGTTAGCGCGCAGTTGGGCACCGTAACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1737:2233 1:N:0:CGATGT\'	TTCACGGATCATCTCATCGACTTCTTCATCGGTGAGCTTCTCCCCGAGGTTTGTCATCACATGACGTAGCTCAGCAGCTGAGATGAAGCCATTCTGGTCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1520:2247 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGCCTTCTGTTTGAAAAAAACCACCGCCACTCTCTCCCCCCTCTCCCCCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1928:2148 1:N:0:CGATGT\'	GAGCAGTATAGTTAAGGTTGGCCTTAGCCCATGGAACAACACGGCAAACTGCTAGCGTTGGACCAGCAGCGACAACAGAAGTGATAACAGCCGCTTTAGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1772:2182 1:N:0:CGATGT\'	TTGTCAATAGCTGTCTTGAGCAACTCAAGACCCTCCTTGTTCTCCTGAATGTTAGGAGCAAAGCCACCCTCGTCACCTACATTGGTTGCATCTTGACCATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1894:2201 1:N:0:CGATGT\'	ACCAACTTCTGTTGCGATTTCGATGCTCTGCCACCTTGGAATTCATGGTCTGCTTTTCTACAATCATCCTTATAATCCACCTTGGAATTTGTTTGATTATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1966:2247 1:N:0:CGATGT\'	AGACAAAAGTGCTTGAGCAGAAGAAGAATGAGGGTGAAGAACCAAATCATAAGGAGCCCAAAGCCCATCAACAGGACAAGGTCTACCAGCATCAATCCTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2114:2022 1:N:0:CGATGT\'	CCACGCTTGAGATCCTTCACAGCAACGTTCTTGACATTGAAACCAACATTGTCACCTGGAAGAGCCTCAGGAAGAGCTTCATGGTGCATCTCCACTGACTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2137:2035 1:N:0:CGATGC\'	CCCCGCTATCACCGAGAATAATGACTTTCAAAAGAGTTCTCCTTCGCGAGGACATCCTCGCTGGGCTTGCAGTTGCAGAAGTAGAATTCGACCGATCCAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2051:2037 1:N:0:CGATGT\'	TGAAAACTTAAACAAACCCTGCGGCTCACACTTAACTGAGACATCCTTGGCATCAGGTAACACAACTGTCAAATACAGTTTGTTGGAGCGCTGAGCCCAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2209:2090 1:N:0:CGATGT\'	TCAGTCATCATGAGTTCAAACAATGGAATGCAGGTAGTCAAGTACATCTCTCAGGGGGTCGGATATGGTAGCATATGAGTTTACAGGCCCTCCATCAATAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2111:2123 1:N:0:CGATGT\'	GGCAGCAACAAACCCAACCAAACGAGCGTAGAAATCCATAGCTTACAGTGAGCGTAAAAGCAAAAATGACGCAGCAACAGCCAACCTCACCTACTGCAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2227:2131 1:N:0:CGATGT\'	TCGGTCAACCTTACACTTAGCACCAGTAGTAATAGCAGGAGTTGGATTCTTAGCGGTAGCATTTTTAGGAGGAGATCCACGGATCCCTTGACAGTTGACCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2050:2154 1:N:0:CGATGT\'	CAGGAGTATTTAGCCTTGCAAGGTGGTCCTTGCTGATTCACACGGGATTCCACGTGCCCCATGCTACTCGGGTCAGAGCGTAAGCTAGTGATGCTTTCGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2012:2202 1:N:0:CGATGT\'	GGCGTACAGGTTTGAAATTTGGGAGTTGGGCCATGCAAGAATGAATCAAAAGGAGTGAGTGGGGGAGTCATTATCAAGCACTCTTTCTTTTTTTTGTTTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2134:2227 1:N:0:CGATGT\'	CGAACACGACGGGGCTCTCACCCTCTCTGGCGCCCCTTTCCAGGGGACTTGGGCCCGGTCCGCCGCAGAGGACGCTTCTCCAGACTACAATTCGAACAGCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2125:2243 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAACGATTCTCCAGACTCCAATTCGAGCAACG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2336:2003 1:N:0:CGATGT\'	NTGAGGTTTTCGACGTTCTTAGCAAACTTATCCGTAGTGTCAGTGGCAAACAAGTTGGATTTGGTCAGGTCATCGTTTGTTATGGCTTCCCGCTGGCGATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2412:2046 1:N:0:CGATGT\'	GATTTATTCCATGAGCTATTTAGCCAAAATGTGCATCATTTGACCAACATTATGCCTCACAAAGTTCACACTATTGATGTGCATGAGGGTGAAATGGGCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2382:2056 1:N:0:CGATGT\'	CTCGTTTAGAGCTCCAGCTATCCTGAGGGAAACTTCGGAGGGAACCAGCTACTAGACGGTTCGATTAGTCTTTCGCCCCTATACCCAAGTCAGACGAACGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2467:2115 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACACACATACACGCACTCTATACCACTCTTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2262:2140 1:N:0:CGATGT\'	TGCGATTTGAAGGTCTAGAAGTTAAGTACCAAAGGCAATAGCACTGATCAATGACACAGGCTACGAAACTCCGTGACTACTGTTAGAAATATAGCCTCTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2307:2170 1:N:0:CGATGT\'	GTCAGTAGCTAGATATGGATAAGGGGGCATCGAATACATATGGTGAGCTACAACAATAGTTAAAGAACCTAACATAGCTAGGTTAAGCGATAATTGAGCAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2371:2189 1:N:0:CGATGT\'	CTTACACGTGGCACCATCTTGTACCCCCAAGACATCGTAGAGCGACTTCGTATGAGTAATGGCCGTGGCGCTTGGTGGGGTGTCCACGGTGGATGACACGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2351:2193 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAGGAAGAGCACAGGTCTGAACTGCGGCCACCGATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2366:2209 1:N:0:CGATGT\'	CGGCCCACTTGGAGCTCTCGATTCCGTGGCACGGGTCAACAAAGCAGCCGCGCCATCCTACCTAAAAGTTTGAGAATAGGTCGAGGGCATTGCACCCCCGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2402:2214 1:N:0:CGATGT\'	CTTGTTCGAAAGATGTAAAGAATCAAGTAGTTGAGTAACTACGTCCTCATTGTTAAAAGGCACATCCAAATTCACCTTAACAACCATATTTTCGAAAGAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2427:2231 1:N:0:CGATGT\'	ATCGACTACGCCTTTCGGCCTGATCTTAGGCCCTGACTCACCCTCCGTGGACGAACCTTGCGTCGGAACCCTTAGGTTTTCGGGGCATTGGATTCTCACCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2653:2019 1:N:0:CGATGT\'	CTCTGACTCTACTTCGACATTTGATCTAACACCGGCTCTGGAACTCCGAACAATCTGAACTGACTCAGCCTCTGTCACTTCATACATAGTAGAACGTTTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2530:2059 1:N:0:CGATGT\'	CTAACCTTTTTGTTGTCCTTAAATACGACAATACCACTTGATGAAACACCAATCAAAACGTTTGTTTTGAACTGATCTTTGGCATCGAAAAATTCCACCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2526:2076 1:N:0:CGATGT\'	CAAACAAGCAGAATATGTCATCTTTCACTGCAAACGACCTGGGGCGAAGAGGGGATTCACCGTCATGAGTAAATGCAAGCTGACCATAATCACCAACGTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2581:2077 1:N:0:CGATGT\'	GTTTTGCAGTTTCTATCACTTCAGCAACATCAGCTTCTTCTGATATCATAGTTGTTAATGCAGATTTCATTTCTGTCAGCTTCACCTCAAACATCTTTTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2743:2082 1:N:0:CGATGT\'	CCAAAACCACTAGCAGCAGCCATTGCTAGTGTAAACAACGCAACTGTCATAACTGAAACTTTACTGCCACCACCTTTCACCTCATCAAAACTGTCAGAAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2681:2104 1:N:0:CGATGT\'	GGCGCTTTGCTGGTATGGTCGATGCATCCACCTCTCCAATGTAGTATTTCTCCATCATCTCTCTCGCTGAGTCACTGTGGCCCACATCTTCGAAATCATTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2533:2124 1:N:0:CGATGT\'	GTATAGGTCACGCGCTTAAGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCAGGTGAGTTGTTACACACTCCTTAGCGGAATTCGACTTCCATGACCACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2715:2146 1:N:0:CGATGT\'	CACAATCTCGAGAAGAAAAGAAACTACAAGATCCTGAGATACTGAATGGATAGACATAAACAGCAATGAGAAAGAAGCACACCATAGAAACCAGTATAATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2654:2168 1:N:0:CGATGT\'	CCGACCCATCAATTCATCTTCTTCGTATACGTCGTCGTTTCCGATATCAAATTCCAAACCCGTGAATATGAATACGAATACGCAAACTTGGCAACCAGGTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2532:2242 1:N:0:CGATGT\'	CTCTGATACAAGAATAGAAACAGCACTGATGGCAGAGAAAACAGCTTTATAGGCAGTCTTCAGAGCTTCATCTAGAGTTACCAAATCCATCTTTAGCAATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2687:2249 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAATGGGTATTGCGCGTACGCTTCCAACCATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2973:2014 1:N:0:CGATGT\'	CTCATAAGATGTTACACAGCAGAATCCACCTTCATAAAACAAACAACAAAATTCCCTAAGTGCTCAAATTCAAAGCAGAAAACATTCAGAATATAGACTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2896:2026 1:N:0:CGATGT\'	GTCACCCTTCGCTCCAAACTAGTGTATGATGGCATTGTTAATACCATTTTGTACCCCTTCATTGCTGCCATAAAGGCCATACTGATCCCCATATTCCCTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2773:2071 1:N:0:CGATGT\'	TCCAAGCTTTCTTCTTTCCACCAGTGGCACGTCTTTTGTGCATGGAATCACGTGATATACCCATGTTTGGAAAAGGGAGATAAAACTTGGGTTCGTAGTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2909:2147 1:N:0:CGATGT\'	CTCCGAAGAGAAATCCAGCAGCCTGGTCTTCGTTACCATCAAAAAGCTTGAGAGCTTCGATCACAGCACTCCTTTGAAACCCCAGCTCCACCCCGTTTGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2877:2172 1:N:0:CGATGT\'	GGCAGACCTGTCAACCTTTCATAGTTGAGATGGCAAGTGCAACGACGGGGTGTTTGGGCTGCTGTCCGACTGTTCTTGTGGATAAATCTGCCCTGCTAATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2872:2190 1:N:0:CGATGT\'	CGGTAGATCCCTCGATGACGTCAATAAGGCCATCGGTACCTTTAGCCAAGGAGCAATGATCAATCCAAATATTTGAAGATTGAAATATAGAGATGCCATCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2881:2226 1:N:0:CGATGT\'	GCCGAAGGAGCCTAATGAAGATGGACTGAAAGGCATATATAGAGTGGATGTTGAAATTCCTGCAGATGACTGGGTCAATATAACGAAGTTCTATGATGTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2789:2239 1:N:0:CGATGT\'	ACAACTTTCGTTCTTGATTAATGAAAACATCCTTGGCAAATGCTTTCGCAGTTGTTCGTCTTTCATAAATCCAAGAATTTCACCTCTGACTATGAAATACG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2815:2240 1:N:0:CGATGT\'	GGATGCAAGACATTCAGCAGCAGCTTGTAACATGTCGTCAGTAATCAAGCGAGCACCTGAAAGCAACGCTCCTAAACCAATCCCAGGAAACAGGTACATAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3184:2005 1:N:0:CGATGT\'	NAATCGTTGTATGGTGAGACAGTTATCCTGAATCCGTGCTTCATATGGAGTAATATGGATATATCAGGCTCGACAACTTGTCCCTCAACAGCTTGTATGTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3120:2036 1:N:0:CGATGT\'	GTGGTGCATGGCCGTTCTTAGTTGGTGGAGCGATTTGTCTGGTTAATTCCGTTAACGAACGAGACCTCAGCCTGCTAACTAGCTATGCGGAGTCACACCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3192:2068 1:N:0:CGATGT\'	GGTTGAATGGGGGGCCCGCAGGCCGACGCCTTGAGCGCGCAGGTGCCGTGGCACGCTGTAACAGCGCGCGCTGCCTACCACAATCGCGAGGACAGCACTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3054:2083 1:N:0:CGATGT\'	GGGAGCTTCGGCGCAAGTGAAATACCACTACTTTTAACGTTATTTTACTTACTCCGTGAGTCGGAGGCGGGGCACAGCCCCATTTTTTGGACCCAAGGCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3224:2088 1:N:0:CGATGT\'	CTAAGGCCGACTTTCGTCCCTGCTCGACGGGTGGGTCTTGCAGTCAAGCTCCCTTCTGCCTTTGCACTCGAGGGCCAATCTCCGTCCGGCCCGAGGAAACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3248:2170 1:N:0:CGATGT\'	GGGGCCTAACCTTGTTCTTCCACAGGTTATGGTAGGAGGCAGAATCTGCAGCCCTTTGCATGACCTCAACCACAACAAGGTGGTCGGTCAATGGCCTAATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3163:2193 1:N:0:CGATGT\'	CTACGAAGCCCAAGATATAAAAGCCCAGTCCAACGTGGACGCCATGACCACCCTATAATTAATCCGATCATGACGGCGACCCATATTGGTACTGCACATAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3237:2212 1:N:0:CGATGT\'	ATTGGCCAGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCGGCACTCGGTCCTCCGGATTTTCAAGGGCCGCCCGGGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3086:2218 1:N:0:CGATGT\'	GTGGTATTTCACTTGCGCCGAAGCTCCCACTTATGCTACACCTCTCAAGTCATTTCACAAAGTCGGACTAGAGTCAAGCTCAACAGGGTCTTCTTTCCCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3169:2238 1:N:0:CGATGT\'	CTGAGAACACCCTCACCGCTTTCAAAGGTCTCAGGGTGCTGTTAAGCGACAGTGATGACATGAACCGAGCCGTGTCTAAGAAGCTACTCGAGAAACTGGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3321:2075 1:N:0:CGATGT\'	TGGCAAACTATAGAACTTTCCAAACTCACCACCTCCAGGCTTGGGTAGACTGGTGAAGATTCCTTTGAAAGGATGCTCGGAAGCTATAGTAGCAATCTTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3343:2075 1:N:0:CGATGT\'	GTTAATGCTTCTCCCAATATCGATGCAGCAAATCCAAGCATAGCAACACGACCAACAAAGAGCTCATTTTCCTTGGTGAATCCAATTCCTCCTGATGTTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3357:2098 1:N:0:CGATGT\'	GCAATCGGTTGGACAGCTAAGGGAAGTTTCTAATAAGGTCCACAATGCAGAGCTTAAATTATTCTTGGAAGTTGAGCTTGGCGTGGATTTGCGACCTATTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3411:2115 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACAAACTCTTTAAACTTTTTTCGAAAACAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3350:2120 1:N:0:CGATGT\'	GCTTCTTCGGTTTTCTCTGGAACGACTACCTCTGGGGCAGGAGGGGCTGGGGTCTCAGTCTTTTCTATCTCTGATGGTTTAGACTCAACAGGTTTTTCTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3369:2137 1:N:0:CGATGT\'	CGCAAGGACCATCGCAATGCTTTGTTTTAATTAAACAGTCGGATTCCCCTTGTCCGTACCAGTTCTGAGTCGACTGTTCGACGCCCGGGGAAGGCCCCAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3348:2146 1:N:0:CGATGT\'	CTCTATGCATAGCTTGGTATTGGCAGGAACAAACAGGACATCACCCACATGGAGTTTATCTGCAGAGATGCATGTTCTTATTGTTCCCATCCCTTCAGTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3442:2156 1:N:0:CGATGT\'	TGGGAATACGAGTTGGAAGAGCTATTTGACGGGTGAATTCTCCCGGAGGGCAGTGCTCGGGCGTTGGATCACTTAGTTTGAATGTCCTACCATGTCTCTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3407:2165 1:N:0:CGATGT\'	GGGGAAGTTGCTGCTGTTGGAAGTGTAGTCCGATCATTAACTGTGGGACAAGAGGTTTTTGGAGCCTTGCATCCAACTGCTGTAAGGGGCACTTATACGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3300:2204 1:N:0:CGATGT\'	TACCCCTTCTTACCCTGAAAAACAGGGTCACCTTGCGTCCTTGAACCGATAACCATCTTTCGGCTAACCTAGCCTCCTCCGTCCCTCGGGACCAACAAGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3391:2222 1:N:0:CGATGT\'	CAAGCATATGGAAATTGGCTTCAATCAATTTCATGTTGATGCCACAAATTTGATCCACCGCAGGGCTGGCCGTTTCAAAATTAAGGTTGTGTTTGGTTTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3632:2027 1:N:0:CGATGT\'	AGGAAGCTGTGGTTGTGGTTCTGCCTGCAAGTGCGGCTCCGCTTGCGGAGGGTGCAAGATGTACCCAGACTTGGTAGAGGCTTCAGATAGCCCCAACGTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3642:2044 1:N:0:CGATGT\'	ACCTTCAGAATAATTTTTTGGTTGTGCAAACCAAAGGGAATAATGATCTTGGGTAGTACCAAGTCGGAAACCAAGTGGATTTATTTTTTGTCCCATACTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3580:2051 1:N:0:CGATGT\'	GCCTTGTTAACCTAATTACATCTTTCATGATCTTTCAATTCACTGCACACGGGTCTTCTCTTTGCCAAATATTTTTGATTTCAGAGGAAACCGAATTGACG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3507:2069 1:N:0:CGATGT\'	CCTTCCAGAAGTCGGGGTTTGTTGCACGTATTAGCTCTAGAATTACTACGGTTATCCGAGTAGCAAGTACCATCAAACAAACTATAACTGATTTAATAGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3642:2073 1:N:0:CGATGT\'	CCGCCGTTTACCCGCGCTTGGTTGAATTTCTTCACTTTGACATTCAGAGCACTGGGCAGAAATCACATTGCGTTAACATCCGAAAGGACCATCGCAATGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3674:2098 1:N:0:CGATGT\'	CGGGCAACACTCTGAAAATTTCATCAATCGGTTCAAGCATTCCAAGAGCAAGGCAGTGTTTAGTTTAAAAGAAATCATGCTCCAGTAAAATAGCTTGAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3545:2185 1:N:0:CGATGT\'	AGCAGTTCCTAGCTCGAGCTATTTCACCATTTTTCATTTCAAACTTGGCATAACGTATCCATGCCCCAACTTTAGGATGGCACTGCACAAACCTCTCATAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3876:2014 1:N:0:CGATGT\'	CTGTGGACATAATCTTCGGTTGTAAGAGGGAAACTGTAGTTGATGACAACTTCAACATCTGGAATATCCAATCCTCTTGCGGCCACATCAGTCGCTATCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3999:2062 1:N:0:CGATGT\'	GTATAATTATTATTTTTGCACACGATGCAGACCAAGTTGTCGTGTGCACCATTTCCAACGGGCACATCCTGCATTTAAAAACGAAATTTTTTTTTTTTTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3965:2064 1:N:0:CGATGT\'	AGGAAGTCCAAAACCACCAGCAGCTTCCTTTCCTTGGTCAGGCTCAATAACTACAGGGGTACCTCCAAATGGAGCATCATTTGTTTCTTTAAGCTTTTGGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3828:2105 1:N:0:CGATGT\'	GTCAGTTCCAGAGCCAAAGATCGTAGTTCTCGAACGAGCAGTCGAAAAGATTCTGGAGCATTCTCGGGGTTAGGTATTATTCCCCCAATGATCGTAGTACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3956:2129 1:N:0:CGATGT\'	CAGATTTCAGGCAGATTGGAGCATAAATGTTGTAGATGTCAATGTTTCCTACTTCTTGGGCTGCTTGATCGGCTGCATCCTCACACTCTTCCGAAACAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3880:2191 1:N:0:CGATGT\'	GACGAAATCCAAATTATTAGTCCAGTAATAAGAGTGATCTCTCCTGCTAAGTATATTCTCCCTTGTTTTTGCCACCTCCACACCTGATTTTGGATTTGGTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3859:2214 1:N:0:CGATGT\'	TTCCACTTCTTGAACTTTCCGCCGTGCTTCTTGCCAAATTTACCATGACCATGCTTGAACTTCCCGCCATGACTATGCTTGAATTTTCCTTGCTTGAATTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3990:2250 1:N:0:CGATGT\'	GGGAAGACGAACACGCAAGTGGAGTCCCATTCTATGAAGTCTACTACGGTTTCTTATGCTTTGTGCGGTCCTTCCTGTTACTTCAAGCACACTAGCTGCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3921:2250 1:N:0:CGATGT\'	CGTCATTTAGGGGCCTTAGCTGGTGATCCGGGCTGTTTCCCTCTCGACGATGAAGCTTATCCCCCATCGTCTCACTGGCCGACCTTGACCCCTGTTATTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4196:2020 1:N:0:CGATGT\'	CGCCAATCCGCCACCACTCAATTTTCCGCCAGCCCTAACCCTAACACGCGCGTATCGGAGCGCGTCTAAGAGAAAGCGCGTTAGATATGGGAGCTGAGATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4153:2062 1:N:0:CGATGT\'	TTATTTATGAGCTCTTTATATTCCCAAAGAACCTCGAAAGTGGTAAGGGACCATCACCCTTATCGATGTCGCTAATGGAATTCTTGCTTCTAGATCTGTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4102:2101 1:N:0:CGATGT\'	CCGGGAGGTTGGTTGATAGTTAGGGATGATGGCGAGACCATTTCCGAGGTGGAGAAGATGGCCAAGTCACTTCACTGGAAATCGCAGTTTACTTTCTCTAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4103:2125 1:N:0:CGATGT\'	CCCCCATCACGATGAAATTTCAAAGATTACCCGGGCCTGTCGGCCAAGGCTATAGACTCGTTGAATACATCAGTGTAGCGCGCGTGCGGCCCAGAACATCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4021:2132 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAGACGTATAACGGATACGTGATGTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4178:2154 1:N:0:CGATGT\'	CTGATGCAGCTTTTCTCGACTTTTGCACATGCACAAGTTCAATTTTCAATTTTTGCACCAATGTAGATTTTCCACCAGTGATCATCCATAACTCGCCTAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4209:2174 1:N:0:CGATGT\'	GCAAGCGAGAACAGTTTTTTCAAGATTTCGCTGAGTCGATGATTAGACTTGCTAGAATTGGTGTGCTCACAGGTACAGAAGGTGAAATTAGGAAGGTTTGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4193:2213 1:N:0:CGATGT\'	CCCAAGTCAGACGAACGATTTGCACGTCAGTATCGCTTCGGGCCTCCACCAGAGTTTCCTCTGGCTTCACTCCGCTCAGGCATAGTTCACCATCTTTCCGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4150:2215 1:N:0:CGATGT\'	AGACCCAAAGTCTGTGTTTAGCTGATCCCCACGAGGAGTCTTCTCCAATTGATTGATCCTCTGTTCCAATTTCTTCAAGTCTTGACTACTCAGAGTCTCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4040:2236 1:N:0:CGATGT\'	CTGCTCTTCAATGCCTTCCTTCAAGGTATTTTCTGATAATGGACTTTCATGCATGGGCTCACAACCTTTCGAAACCTTTTCTGTAACTGATGAACCCGAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4459:2015 1:N:0:CGATGT\'	CAGCCTTTTCTTTCCCACATAACTGTTCAACTAGTGCAACAGAATATTCCATTGCTGTACCAGGTCCACGACTCGTCACAACTTTACCATCCTGCTGGACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4254:2021 1:N:0:CGATGT\'	GTCAATATTGTCTTAGAAGTTCACACTCATTTCACATCCTTGTCACAAGAGCTAGAGTAACATAGTCACCCCTCTAACTTGCCCTTCAAAGTGTACACTAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4280:2023 1:N:0:CGATGT\'	TGGGAATGCAGCCCCAAGCGGGCGGTAAATTCCGTCCAAGGCTAAATACGGGCGAGAGACCGATAGCGAACAAGTACCGCGAGGGAAAGATGAAAAGGACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4311:2061 1:N:0:CGATGT\'	CCCATTCGCTTCCCTCCCGACAATTTCAAGCACTCTTTGACTCTCTTTTCAAAGTCCTTTTCATCTTTCCCTCGCGGTACTTGTTCGCTATCGGTCTCTCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4255:2121 1:N:0:CGATGT\'	CACCGCTCTCCGCGAATTGTAATGCAACCTTCCCGCCCATAGAGTGCCCGATAATGACATCCGGCCAATTCGAACCTTGGGATTTCACAAGCTTAGCCAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4470:2167 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAAAAACCACAAACACGCAAGCACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4530:2025 1:N:0:CGATGT\'	CGCCCTCCAATGGATCCTCGTTAAGGGATTTAGATTGTACTCATTCCAATTACCAGACTCAATGAGCCCGGTATTGTTATTTATTGTCACTACCTCCCCAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4521:2063 1:N:0:CGATGT\'	CGATACGCATATTTCATGAATAAATACAACGAAGATACAGTAAATGAACAGGTCCTTCGAATTCAAAACGCTTGATAAACTATGCTTTTTGTATGTACAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4542:2075 1:N:0:CGATGT\'	CCGGCTACCTTAAGAGAGTCATAGTTACTCCCGCCGTTTACCCGCGCTTGGTTGAATTTCTTCACTTTGACATTCAGAGCACTGGGCAGAAATCACATTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4736:2118 1:N:0:CGATGT\'	GTAGTAGCAAATATTCAAATGAGAACTTTGAAGGCCGAAGAGGGGAAAGGTTCCATGTGAACGGCACTTGCACATGGGTTAGTCGATCCTAAGAGACGGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4590:2146 1:N:0:CGATGT\'	AGCGATATTCGGACTTCAAACACTCGATGAAAGAAGCATTAGAGATACCAACACGAAAAAAAAGTACGAGAAAGAAGCTTCTCGTAGATGAATCTTCGGTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4506:2153 1:N:0:CGATGT\'	CTCGAAGCCAAAAAATAACAATCCTTCCACAAAAACAAAAGGTAAAATTAGAAAATCTTGTGCAAGACTTCAAATAGTTTTGTAACTTAGAAAAATCAGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4725:2205 1:N:0:CGATGT\'	TTATTGGAAACAAATTGTCACTGATCTTATACAGAATCTTGATTTAGACTAACAGTTCAGTGTTAATTAACTTCAACAATCCATCCTTTCTTGTCTTCAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4612:2250 1:N:0:CGATGT\'	GTTTATATTTTCACTAAGAAAATAAACAATAGTTAAGGTGCATGATATCAATATAGTTTATCTAAAGTGGAAAGATGAAAAAAGGAATAATATAAAACAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4863:2020 1:N:0:CGATGT\'	CCTCCACAAGCGAAGATCCAACTGAATGTCCCTGAGCTTTGTAAAAGGTGAAAATCATTCCTCCACCGAGTAGAAGTACATCGACCTTAGCTAACAATGAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4898:2021 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAGAACCTAACCGTAGACAAGGCATGCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4775:2060 1:N:0:CGATGT\'	TTTCAATCGGTAGGAGCGACGGGCGGTGTGTACAAAGGGCAGGGACGTAGTCAACGCGAGTTGATGACTCGCGCTTACTAGGAATTCCTCGTTGAAGACCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4830:2072 1:N:0:CGATGT\'	CAAAGTGTTGCCACCATAAATAATGCAGGTACTTATTACAGGAACTTGATCAGCCATATCAAAGTAGGGTCTCCAAAGAAACCGGGAGCGATCGAAACTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4848:2072 1:N:0:CGATGT\'	CGAAATAAGTGACAAGATATGTTACAATCATATCATACATACCCAACACAATGTTAACCAAAGTCATCTATTGATCATCTTCCAAATCTTATCACATATGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4784:2086 1:N:0:CGATGT\'	TAGCCGTTGATGATGGAAATGATGCTTCCGGCTCTGGTTTCCACAAGAATACAAGATTTTGGCCTTTCTCTGTGGCGATTGAGTGCAACGGTACAAATGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4914:2086 1:N:0:CGATGT\'	TGGGACCCAAAACTACTGGGATGTGTTGAGCTGCCGGAACCAATGATGAGAACACCCTGTTGTTTAAGCGAAGAGATTGCTTTGCCCATGTTGTAATGATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4839:2092 1:N:0:CGATGT\'	ATTCATTTCAATTGGCAGTGCAGGTGCTGTCTTGCCCCACAAATGATACACACAACAGCATGTTGCGCCGCGCTACACCAAGATTCATCAAACAAATTGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4928:2130 1:N:0:CGATGT\'	GTCATTGGCCTTCGCTTGCAACTTTATTAACACATCACACAACTCCAAAAGCCATAAAAGGTCTAGAATCTAAATACATAGATACCATCCTTCACATATTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4866:2131 1:N:0:CGATGT\'	CCCGAGGCAAAGAGTTTTTCGTTTCTAACGGCCCTTTGGATTCATTATCTGCGAGAAAACAGCACTTGGTGTCAGGCCATCAGAGTCTTCACTAGCGAGAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4823:2136 1:N:0:CGATGT\'	TTCTGTTTAACAGCCTGCCCACCCTGGAAACGGCTCAGCCGGAGGTAGGGTCTAGCGGCTGGAAGAGCACCGCACGTCGCGTGGTGTCCGGTGCGCCCCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4827:2196 1:N:0:CGATGT\'	GCCAGAACCGCAACCACAGTCACCACTACAGCACGACATTTTCTGTTTCTTAATAATATTTCACAGCTTAAAAGGTTGGATTAGATGAGATGGTTCCCCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5190:2002 1:N:0:CGATGT\'	NCCACCAGCAACATTACTTGCAGCAGAAGCCTCTATCTTCTTCTCCAAGAAAAGGCTTGGATCATTATCATCATCTCCCAACAAATCAAATGGATTTGTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5062:2027 1:N:0:CGATGT\'	CTTTCTAATATCCACATCACATTTCATAATGGAATTGTAGGTTGTCTCGTGGATACCGGCTGCTTCCATACCGATCAATGAAGGCTGGAAAAGAACCTCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5114:2028 1:N:0:CGATGT\'	CCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATGTGCAAGTGCCGTTCACATGGAACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5167:2041 1:N:0:CGATGT\'	CCACGCTTTCACGGTTCGTATTCGTACTGAAAATCAGAATCAAACGAGCTTTTACCCTTCTGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5190:2138 1:N:0:CGATGT\'	CCGGTTCTACCAGGAGTCGATTTTCCGGGCTTGAATTTCGTCATATCAACAAGATCTCCGAATAGTTTATCGTCACCCTTAGGTTGCTTTTTCATAGGGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5027:2148 1:N:0:CGATGT\'	GAAAGAACCATCAGTTGTCTCGGCATAAAGCTGCATCACCGGCTCAGCAACATGCTTCCAGTCAAAATTAGACAGTGGTTTGCAAGTTTCCCACTCAACAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5209:2171 1:N:0:CGATGT\'	TCAGAAACAGGAACAGGGCTAGTGTTCCCCAAATTAAACACTCTCAATTGAGCCGGTCCGTGTTTCTTCCCACCACTACCAGTACTTTTCTCTGCAGTATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5116:2230 1:N:0:CGATGT\'	ACCAGACTTGCCCTCCAATGGATCCTCGTTAAGGGATTTAGATTGTACTCATTCCAATTACCAGACTCAATGAGCCCGGTATTGTTATTTATTGTCACTAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5036:2244 1:N:0:CGATGT\'	ATTGAAATTGAATCAAACTGGACAAGACTGATTTGAACTGAGAACACGAATTATCAAAAGTATCGAGCATCAAGGATACCTGAACAGGATCGACTAATGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5343:2032 1:N:0:CGATGT\'	GTAGGGTAAAACTAACCTGTCTCACGACGGTCTAATCCCAGCTCACGTTCCCTATTGGTGGGTGAACAATCCAACACTTGGTGAATTCTGCTTCCCACTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5499:2034 1:N:0:CGATGT\'	GCAAAGGATTCAACCCGCCGCTCGGTAGAATTGTGATTCAGAGCGGCCCTCACGGTGCATCCACCGCGATGGCTTGGCCCACGACACGTGCCCTTGGGGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5361:2040 1:N:0:CGATGT\'	GAGGACAGGAAAGCAGCAATGAATTCGGTAAACCCGAAATACATACTGAGAAACTATCTGTGTCAAACAGCCATAGATGCTGCAGAACAAGGAGAATTTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5336:2078 1:N:0:CGATGT\'	CGCGTGCGGCCCAGAACATCTAAGGGCATCACAGACCTGTTATTGCCTCAAACTTCCGTGGCCTAGAAGGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5492:2085 1:N:0:CGATGT\'	AAGCAGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAACAAAGGAATTACCAAGAAGACTGAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5382:2103 1:N:0:CGATGT\'	CAGGGACGTAGTCAACGCGAGTTGATGACTCGCGCTTACTAGGAATTCCTCGTTGAAGACCAACAGTTGCAATGATCTATCCCCATCACGATGAAATTTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5441:2169 1:N:0:CGATGT\'	TTGCAGACTCGGTAATTATTGGGGCTTGAAGGATTTGGTAGACATCAAGAATTCTCCTAGGGTACTTTGCCTTTTCTTTCTTATTTTTGGTTTTTGTTTGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5279:2184 1:N:0:CGATGT\'	CTGGTAACAATAGCTGAAGTGCAGCCTCAAATACTCCATAACAAAAGATGATTTTGCATGCAATAAGTGAGGGTTTAGGCCATATGTCAATGAAACCTTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5333:2187 1:N:0:CGATGT\'	GAAACCTTGTTACGACTTCTCCTTCCTCTAAATGATAAGGTTCAGTGGACTTCTCGCGACGTCGCCGGCAGCGAACCGCCCACGTCGCCGCGATCCGAACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5485:2206 1:N:0:CGATGT\'	ATGTCTAAATACATATAATATTATGTATACATTATTCAAAAATTAAATTCAGACAAAAGCCTCTCATGTAAAAAAGAAAACAATTTATTACTTCTCTGTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5564:2020 1:N:0:CGATGT\'	GTACTAGACACATTTAGAAGCAAATACAACTGACTCTTGAACTTCCAAACAACCCCACCAAGACAACAACCATAGTTCTAAAATCCACCACGAAGGCGAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5529:2121 1:N:0:CGATGT\'	CTCAAACTTCCGTGGCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCGATCGTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5672:2144 1:N:0:CGATGT\'	CATTCCTTTGTTAAAACCTTGGCTAAAACTCTCTACAAGACTGGCATATTCCCAAACGTTACTACCATGGGCAATGTTGAAAGGGGTCTCATCATCACTCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5740:2195 1:N:0:CGATGT\'	TTGCCGCTTTGAAACTTCCATTAGATTTAAGAGCCACTAGTGGCCTCCTTAAATCTACTGGAAGCTTTAAAGCCGGAAATGCTAGTGGTCCTCTTTATTCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5506:2239 1:N:0:CGATGT\'	GCGGGGTAGGTGCACCCTGACCTCTGGATGATAACACCGGCAGCGTAGTTACCTGCCCTGACACAATCGGCAATAGGCTTCCCTTGAACCAATTGAGACCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5995:2057 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAAACCAAAGAATACTAATAAAAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5883:2057 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAGTGATATCTTGTTGGTTCGCCAGATGTTCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5786:2091 1:N:0:CGATGT\'	GCAAGTTGATCGTTTGACACGTGAATTTCATATTTACATGACCCGTAACGGCCGTATCAGTATGGCTGGCGTTACAACAAAGAATGTCGAATACCCGGCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5790:2114 1:N:0:CGATGT\'	ACAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGCGTATCGCCGGCAGAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5967:2174 1:N:0:CGATGT\'	GCCAAACAGCAAAAGCAAAACAGTAGCACCGACGGACAGCACAACATCGAAAAATTTTCATCGAAAAATTCCTGTCACTACAGCAATACCAACAACCTGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5861:2234 1:N:0:CGATGT\'	CTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGCGTATCGCCGGCAGAAGGAGCAAGACGACCGGTGCACACCGAAAGGCGGAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6226:2002 1:N:0:CGATGT\'	NGCCGTCTTAGAGCAAGTATCCACCGTCGTACCGCCACCACTTACACCACCGTCAACCACCTCTCTTCTTCTACACATGAAGAAGTTTCTACTTCCCAATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6169:2009 1:N:0:CGATGT\'	CTGCCATGATCACACAACAAAGAGAAGCAACAGACAAAAAGTAAGGCATTCTAGAAACAAGAGGACCTGATAGAAATTCAAGAAAAGCCTACCTGTTCAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6245:2017 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACAAAAAAAAAATAACATGAAGCCTACACCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6027:2024 1:N:0:CGATGT\'	CCCCTCTTCGGCCTTCAAAGTTCTCATTTGAATATTTGCTACTACCACCAAGATCTGCACCGACAGCCGCTCCGCCCAGGCTCACGCCACAGGCTTTGCGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6224:2039 1:N:0:CGATGT\'	GCTGAATTGGATACATTACAACAATCTCAACTAGCATACCCACCGCAATGGAGACAATACAGAAGTTACCAATGGATGTAAGTACTTTCTGGAAGTGACCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6019:2040 1:N:0:CGATGT\'	CAAACAACATCACTAACATTGACAAGGACATAATCGTCTTTTCCATCACCATTACAATCAACATTAATACCACCACTGTCACTCACAGGAGGAAGATCTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6204:2079 1:N:0:CGATGT\'	TTCAGCCTTGCGACCATACTCCCCCCGGAACCCAAAAACTTTGATTTCTCATAAGGTGCCGGCGGCGTCCTAAAAGTAACATCCGCCGATCCCTGGTCGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6003:2083 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAGAAACAGAAGTAATTAAAGAGGCTACGCGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6103:2139 1:N:0:CGATGT\'	CGCCATCCTACCTATTTAAAGTTTGAGAATAGGTCGAGGGCATTGCACCCCCGATGCCTCTAATCATTGGCTTTACCTGATAGAACTCGTTTAGAGCTCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6135:2156 1:N:0:CGATGT\'	GGGTGCCCTTGTGCAGGATATCCCGTTGGAGGGTACGCGTCCTTCGGGTACCCTTCTGGTGGCGGGTATCCTTGAGTTGGTGGAACACCAACGGGGGGTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6030:2174 1:N:0:CGATGT\'	TGCGAGCATCATGAGAATGAGTAGACTGAATTTGGTTCAACAATTTGGAGTCTTCAGAAGTGACCGTTGTCACTAGTAGCATTTTGTTAGTAGTCACGCTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6354:2070 1:N:0:CGATGT\'	ATAAGTATCGAACAAAATTGTAATCAGGACTTCTCCAGTATGTCCACCATTGTTTCCAAAGGCATGATTTAAACTGACCCCATGTTGATTGGGCATATTGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6444:2076 1:N:0:CGATGT\'	CCGCCGATCCCTGGTCGGCATCGTTTATGGTTGAGACTAGGACGGTATCTGATCGTCTTCGAGCCCCCAACTTTCGTTCTTGATTAATGAAAACATCCTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6457:2115 1:N:0:CGATGT\'	AGAATATCGAAAGTCGAATACTGTTTAATATGAGGTGGCACATGGCTACGTAGCGCAGCCATCTCCTTAGCCCCGAACAAGAAGGCGTTCGACACGAGGCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6315:2119 1:N:0:CGATGT\'	AGATCGGAAGAGCACATGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAAACAAGTGACGATGTACAGAAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6493:2148 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCCTATGCCGTCTTCTGCTTGAAAAAAAAACAAGTAGACGAAGAGTGGCACAGATTCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6415:2216 1:N:0:CGATGT\'	CGGCATTCTGGGAAGAGGCAGCCCCAGCTGATGCAGAAACCAAGCCAAGTGATGCGGAAACCAAAACAAGTGATGCAGAAACCAAGCTGGTTGAAGTGGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6343:2230 1:N:0:CGATGT\'	CCTTAAGAGAGTCATAGTTACTCCCGCCGTTTACCCGCGCTTGGTTGAATTTCTTCACTTTGACATTCAGAGCACTGGGCAGAAATCACATTGCGTTAACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6602:2051 1:N:0:CGATGT\'	GACGGGTTCGGGAATGGGACCCCCGTGCCCAGCCCTCAGAGCCAATCCTTTTCCCGAAGTTACGGATCCATTTTGCCGACTTCCCTTGCCTACATTGTTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6652:2057 1:N:0:CGATGT\'	CGGCCGGGTATAGGTCACGCGCTTAAGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTTCCAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6504:2079 1:N:0:CGATGT\'	CTTCTTTTTTCTTTCTTCCTTCATAACATACATTAAGGGTGGGGTACAAAAGAGTAATCAAAAGGATAATAACAACATTTAACTTAGTTAGGAAGTAACAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6743:2121 1:N:0:CGATGT\'	GCCGAATCAACTAGCCCCGAAAATGGATGGCGCTTAAGCGCGTGACCTATACCCGGCCGTCGGGGCAAGTACCAGGCCCCGATGAGTAGGAGGGCGCGGCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6617:2136 1:N:0:CGATGT\'	CCGATCACAAGAAAAGTACTAAAATTGACTGAGACCGAAATCAAACAGGAAAGTATGATGAAAACCAGAACTTGTGGTGTATAATTAAAAGAAAAAACATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6666:2142 1:N:0:CGATGT\'	CCCATACATGGCATCATGGCGGCCTCTAGGCCCCCACAAGTTATGGCCCCATGTGATGTTATTGGCATAGCCAATAACATGATACATAGGGAAATTGCTAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6572:2145 1:N:0:CGATGT\'	TGGAAGGCCAGTTTTCAAATGATGATGGGACGGAGCTGGTACGTTTAGCTTCAAGATGTTTGCAATATGAGCCCTGTGAGCGAGCAAATCCCAGGTCATTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6581:2180 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAGATCAGAAAAGTAAAGATACACGAACAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6606:2233 1:N:0:CGATGT\'	CGGTGGCGCGTGGTGGAGAAGCGCGTTAGGACCTCCTGAAGGGTTGATAAAAAGCATGTTGTGTGGGTTTTGATTATTACTATTATTACTATTATTATGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6826:2009 1:N:0:CGATGT\'	CGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCAGCACTCGGTCCTCCGGATTTTCATGGGCCGCCGGGGGCGCACCGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6938:2010 1:N:0:CGATGT\'	CTGAGGTCTCGTTCGTTAACGGAATTAACCAGACAAATCGCTCCACCAACTAAGAACGGCCATGCACCACCACCCATAGAATCAAGAAAGAGCTCTCAAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6885:2038 1:N:0:CGATGT\'	CCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCGTTCGTTAACGGAATTAACCAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6852:2068 1:N:0:CGATGT\'	ACCATTACATAATTCAAGGAATAACCAACAACAATTCAAGCAATCAAACTCCCCCTTCATCAACCAATCTAATCTAGACTTCATCCTCATCGAGCTTGTAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6806:2078 1:N:0:CGATGT\'	CCAAAAGCCCACCACAAGTTCTGCTTAATAGTTTTCATTGTTAATTTGCTTAGCTCCAATGCATCAACTACTTGTGAAAGTTTATTGCCCATTAGTACAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6820:2102 1:N:0:CGATGT\'	GGACGACCCCGAGACATGGAATGTTCAGTTATTTAGATCCATTGATGGTGGTGCTGCTTTTGATTTTCCCGATACTCCTGAAAAAGCGGCCGAAGCTGGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6827:2143 1:N:0:CGATGT\'	ATCACGATGAAATTTCAAAGATTACCCGGGCCTGTCGGCCAAGGCTATAGACTCGTTGAATACATCAGTGTAGCGCGCGTGCGGCCCAGAACATCTAAGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6988:2214 1:N:0:CGATGT\'	CATAGCGACTTGGTATACTGGCAAGACGAGTGTATAACAATTGCTTTGACAAGCGGTTACAAGTCTCAACAGTGGGTGGCTCTTGGATGAATTCCTTGTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:6905:2222 1:N:0:CGATGT\'	GCTGCGAATAGCATAACCCATTTTTTTCCTTTTCCGGGTAAAATCCAAACCCTGATTCACTAATCGCATATCCATCCTAAAATAGAAACCCCCACCAAACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7033:2023 1:N:0:CGATGT\'	TCACTTCTTTCGGGGCTAACAAACCCAGCTTTAACGTTCATGATGGCAGCAGATTGCATGAGAGAAGCTGGGCCGCCGGCTGGGGTCCGGCCCAAAACGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7103:2029 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAATATACAATCGTCAGATCTGGAAGGACCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7218:2035 1:N:0:CGATGT\'	CGCGTCACTAATTAGATGACGAGGCATTTGGCTACCTTAAGAGAGTCATAGTTACTCCCGCCGTTTACCCGCGCTTGGTTGAATTTCTTCACTTTGACATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7059:2090 1:N:0:CGATGT\'	GTCGCTATGAACGCTTGGCTGCCACAAGCCAGTTATCCCTGTGGTAACTTTTCTGACACCTCTAGCTTCAAATTCCGAAGATCTAAAGGATCGTTAGGCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7032:2090 1:N:0:CGATGT\'	CATCATAATCCATAGTGGTTTCATTTATGTCCTTTCCATCTTGAATCACGTCTCCATCGAAATCTGGATCCGTCACTTCTGGATCTTCGTTAGGGTCAGTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7104:2096 1:N:0:CGATGT\'	GCGTCCTTCCCGGTCCTCTCGTACTAGGGAAAGGTCCTCTCAATGCTCTAACGCCCACACCGGATATGGACCGAACTGTCTCACGACGTTCTGAACCCAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7036:2177 1:N:0:CGATGT\'	TAAAAATTCATCATAACCAACATCCACATCAACTTTACATTTTTCGTTCGGATCCATCTCGTATAAAGCGAGATGGAGAGTAGAGAAGTGAATGAAGAAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7008:2181 1:N:0:CGATGT\'	GGGAGTTTGGCTGGGGCGGCACATCTGTTAAAAGATAACGCAGGTGTCCTAAGATGAGCTCAACGAGAACAGAAATCTCGTGTAGAACAGAAGGGTAAAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7208:2190 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAGCGAACGGCTCAAGGCGAAGCGGAAGCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7014:2200 1:N:0:CGATGT\'	CACCAAATGCGACAAATGCAAATTCTCCTCCAGGAGCCAGAAGAAGACCAGTTCTGATTGCAGATATTGTTGAAAGACCGAAAATTTTTCCAACTAAAGTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7169:2228 1:N:0:CGATGT\'	TCCGTCAATTCCTTTAAGTTTCAGCCTTGCGACCATACTCCCCCCGGAACCCAAAAACTTTGATTTCTCATAAGGTGCCGGCGGCGTCCTAAAAGTAACAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7428:2050 1:N:0:CGATGT\'	AGCTTGAATCACCTCGCCTTCAATCCATTTTCGCGATCCATCAGGATTAACCTGAACATGACCAAAGAATCTAACAGGGAACACAACATCATGTCTTGCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7312:2064 1:N:0:CGATGT\'	CACTAATTCAAAGACTCATTTTTACAAATCATTCGATTTTAAGTGTTAAAAAAAAGCTCATCGTCTTCTTCAACCTTGACCTGATCCAAACTCGAATCGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7407:2064 1:N:0:CGATGT\'	GGGAAACTTCGGAGGGAACCAGCTACTAGACGGTTCGATTAGTCTTTCGCCCCTATACCCAAGTCAGACGAACGATTTGCACGTCAGTATCGCTTCGGGCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7273:2103 1:N:0:CGATGT\'	AATTCACCAAGAAACTGTAGGAATCCTCAGCTACAAATTGATCATTTATGTTGGTGAAGTCAGAAGAAGTATTCGTGTAAGAGAAGCCTACTCCAATCGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7339:2104 1:N:0:CGATGT\'	TGGTGGTGCATGGCCGTTCTTAGTTGGTGGAGCGATTTGTCTGGTTAATTCCGTTAACGAACGAGACCTCAGCCTGCTAACTAGCTATGCGGAGTCACACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7347:2122 1:N:0:CGATGT\'	ATGCTCATCACCTCCAAGAGGAACCACCTAACCTAATCACCTCTTCTGCGCCGCTATCTTTGTTATACCCTCTTTCTGCACCGGCATCACCCTTCTGATCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7337:2140 1:N:0:CGATGT\'	CCCGGATTCTGACTTAGAGGCGTTCAGTCATAATCCAGCGCACGGTAGCTTCGCGCCGCTGGCTTTTCAACCAAGCGCGATGACCAATTGTGCGAATCAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7287:2141 1:N:0:CGATGT\'	GGGGCCCGCAGGCCGACGCCTGGAGCGCGCAGGTGCCGTGGCACGCTGTAACAGCGCGCGCTGCCTACCACAATCGCGAGGACAGCACTCCCAGTGACTGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7280:2183 1:N:0:CGATGT\'	TTTGGATCTAGCTCGCCTGTTTTGGAACCAATTGTAGACATTTGTCTCAGAGATTTGGCCGTGTTGGGATAACTGGGCGGTGATTTCTTTGATCTTCTGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7447:2222 1:N:0:CGATGT\'	GATCACTCCTTCACTCGAAATGAAGTCAAAACCCTATAGAACACAAATTATACCACAATCCGAGATTACATTCTCCCATTTTCCAACATACGCCAATTATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7442:2243 1:N:0:CGATGT\'	CTGGACATCTCTAACAGCAGCTTGCTCCACAATGTTCCTCACAAGGAACCTCTTGATTGCCTTGTCCTTAGGGCAACATTAGGCACAATTTGAACAACGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7666:2062 1:N:0:CGATGT\'	AGTCCCTTGACCAGTCTCACCTTGTGTTCCATACGAAGGTTGGTTCCCACCAGCATAGCCAGCAGTGAACCCATAGCTTTGCTGATGATTGTACCCAGATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7566:2075 1:N:0:CGATGT\'	GCATTTTGCTGAGGTTGAGAATGGGATATAGAGGGAGATTAAGAAGAGGGTTAGGATAAAGAGGGTGGAATTTGAGGGTTGTTTTGGAGTTTGCATAGTGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7710:2082 1:N:0:CGATGT\'	TTTGATTCCTTTGAACATTCTACTTTAGAGTCTTCCATTGATGACAATGTTGATGATCGTTTTACGACAGAAGAACGATTGGAAAAGGTGAGGTGGATAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7526:2198 1:N:0:CGATGT\'	TGATAAAAACATATATACGAGCTAAGAGCTAACTTATCCAAAAAAAAAAAATATTCCCCCAACCGTCTCTTCAAGAACCCAATCAAAGATTTAAGATCGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7907:2024 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAGAATCACCCAAGCAAGCGCAGACAGGAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7910:2046 1:N:0:CGATGT\'	GTCCCTGTTAATCATTACTCCGATCCACTTGTTACTTCTATCTACATGCTCCGCTCCGCCCCGCCCAAATTGCACTCCACACAGCCAGAGCAGTAAGGAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7884:2079 1:N:0:CGATGT\'	TCTCATTATATCTTACAATCAACTCACAACCGAGCAAAAGCCTTACCGCTCTCACTTCCCTTGCCAAGAAATGGGTAGTCAGTATATCCCACAACAGGATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7937:2130 1:N:0:CGATGT\'	CTTGCCTACATTGTTCCATTGGCCAGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCAGCACTCGGTCCTCCGGATTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7876:2133 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAACAACAACTAGACCATAGCCACCACCATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7991:2141 1:N:0:CGATGT\'	CACCACCACTGGAATGTACCATTTTGCACAATTGTCAATAAATGTTTGGATTCTCGCCTTTCGACTCTGAGCCTCTTCTACAAGACTGACCATCCTCGCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7971:2185 1:N:0:CGATGT\'	ATGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCGGCACTCGGTCCTCCGGATTTTCAAGGGCCGCCGGGGGCGCACCGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:7957:2233 1:N:0:CGATGT\'	GAAAAAAGCTAAGAGCTTCCCTTTTATTATTCTGAAAATTAAGTAATCAACAATAAATAGCAATGTTTCAATCGTTATTGTACCACAACTATAATGGCATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8021:2004 1:N:0:CGATGT\'	NCGAGATCTTGGGGGCAACACCGATGACAAGTGCGACGTTGGTGCTAGTTGACGCCTCTACCAAGTCTGGGTACATCTTGCACCCTCCGCAACCGGAGCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8181:2113 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGGAAAAACATCCAAGTCTCCAAGCGCATCACTACACCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8027:2118 1:N:0:CGATGT\'	CCGGGCGTCGAACAGTCGACTCAGAACTGGTACGGACAAGGGGAATCCGACTGTTTAATTAAAACAAAGCATTGCGATGGTCCTTGCGGATGTTAACGCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8133:2124 1:N:0:CGATGT\'	CTCTCGGTCTATTAGGATGCCTCAGCTGCATACATCACTGCACTTCCACTTGACACCTATCGTAATGATAAACGGCTCGTCTCGCCGTGACCTTTGCATTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8130:2186 1:N:0:CGATGT\'	GTTCCATCAACCTAGTATCATCTATATAAACCTCAGGCATCCATTGACTGCAAAACAAGTGAGCAAACTCAGCAGACTCATCACTTCCAGCACCTCCTATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8151:2219 1:N:0:CGATGT\'	CGCCAATCATTATTTTTGTGGTGTAATCAATAAGAGAACAAGATCAGGAGAAAGAAGAAGATAAAACGCAAAAGTATATAAACAATGGCGTCCAATTCTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8205:2230 1:N:0:CGATGT\'	TATAAATCTAATTCTTAAGCATCAGCATATGTGCAAAGGTTCTCGAATCCCATATACTCGTGTCCTTGGATCTTGGCAACCATCTTAGAGATGCCTACTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8113:2235 1:N:0:CGATGT\'	CTATATATTTCACATATGAACGGTCTCTTCCCTGAACCTGAATGTACTTGCGGTTTAACTGTTCGAGCCAATCAATTTTCACTATGACCCTGTCATCAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8265:2028 1:N:0:CGATGT\'	CAGTTTGCACGGCAACATTAATATTCACATTGTGATACTGGCGTATACAGTCATTGGTCCATGAACTGTTGCATTCCGGAACTTTCCTAAGAGCCAGAGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8485:2037 1:N:0:CGATGT\'	GCGGAGAACTAAGACTCTGTTTGGTTTTGGGGAAAACATTTTTAATTGAAAATCAATTTCAAGTGCAAATAAAAATTAAAAATTTTCCTTTGTTTGGTTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8475:2058 1:N:0:CGATGT\'	GCAGGCAATTTCTCGGATATTACCTTTATTTTTTAAAATTAGTATCTGGCACATTGGGTGATGCGAGTGCAGCCTCTGGAGTAACGATTAGCAGGAGAAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8366:2081 1:N:0:CGATGT\'	TGTTGCTCTGAGAGGGATACAAGATTGTTCCTCTTGATTTGGTTTATGCCTTCAACTGCTGCTGCTACTACGAATGCCCAACAACTTCCACATCTGCCTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8462:2162 1:N:0:CGATGT\'	CTGAGGGAAACTTCGGAGGGAACCAGCTACTAGACGGTTCGATTAGTCTTTCGCCCCTATACCCAAGTCAGACGAACGATTTGCACGTCAGTATCGCTTCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8386:2173 1:N:0:CGATGT\'	TCGAATTCACCAGAAAGATGCCTTTTCACAAATGTAGTTTTTCCTGTACCGCCATCACCGACAAGAACAAGCTTAAAACTCGGATAATTAACCGTTTGCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8451:2184 1:N:0:CGATGT\'	GCGGCGGCGACGACGACACCGTGGTCCAAAGGCGAGAAATCTACGGCAATGGCCGTATTTACGACATATCTCATCGTTATCACCCTGATTTACCTGCATTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8462:2214 1:N:0:CGATGT\'	GTCCTACACATCTAAGGACAAATGGGGTGTGATGGTGTATTGTTAATAGTGCTGACAGGTTTTATTGTTGGAGTTGATCTATGTCCGTTGAGCTCGGCAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8651:2005 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAGAAGCAATAGACTACCTTCAGGGAGTCATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8713:2028 1:N:0:CGATGT\'	TGAAAATGATCGAAAATTAACAAGATTTTGAATTATCTAAACAATTTAACTCAAACCTATGAAGGTAAAGATTTTCACGAGGATAAACCAAAACGATCGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8631:2087 1:N:0:CGATGT\'	GCAATTACCAACAATATCTTCAATGATATGCATGTGAAGCCATATGCTTTCAGCCTGAGTCGACACAACTCCTCCTGGTCGAAGAGCTCTAGCAATAGACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8719:2196 1:N:0:CGATGT\'	CTCCGCCTTACAGCCTTGCTTCCCATTGTAATTGCCATTGTAGCACGTGTGTGGCCCAGCCCATAAGGGCCATGCGGACTTGACGTCATCCCCACCTTCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8512:2242 1:N:0:CGATGT\'	CTATAATGTTATCCCATGCTAATGTATCCAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAATTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8971:2011 1:N:0:CGATGT\'	CCAACGTTTCGTTTCCTCAGCCAACTTTTCTTTAGCCTTTTCCCAGAGTGTTTTAGCATCTCCTTTTTCAGGAAGAGAGTTGACATGAAGAAAGAACGGTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8897:2016 1:N:0:CGATGT\'	TAGAGGGAAAAAAGAATGGCAAACTCCTCTTTAAGAGGTTCACCCATTCTCTTTTAGCAGAATCAGCATTTAACTTCCTTGAGACCATGGGCAAAGTACAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8795:2075 1:N:0:CGATGT\'	CTTTAAATACGCCAAGGAACATGGAAGAGAGAGGGTGTCTGCAATACACAAAGCAAATATCATGCAGAAAACTGATGGTCTTTTTCTCAAGTGCTGCAGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8970:2106 1:N:0:CGATGT\'	GGCGAGAGTAACGAATAGGAACAACCTTAACATCATCAAGAACAGGACCACACATGGATCCTTGAACAGTCATGGTATAGAAGGAGCTGATGAATCCGATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8775:2126 1:N:0:CGATGT\'	TTTGCGTTACTCAAGCCGACATTCTCGCTTCCGCTTCGTCTACCACGGCTCGCGCCGGTACTTCTCTCTAAGGCGGAACGCCCCCCTACCCATGTTTTTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8881:2169 1:N:0:CGATGT\'	CTAATTCTCTGTCACCCGTCACCACCATGGTAGGCCTCTATCCTACCATCGAAAGTTGATAGGGCAGAAATTTGAATGATGCATCGCCAGCGCAAAGGCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8934:2192 1:N:0:CGATGT\'	CAGCCGCTAGACCCTACCTCCGGCTGACCCGTTTCCAGGGTGGGCAGGCTGTTAAACAGAAAAGATAACTCTTCCCGAGGCCCCCGCCGACATCTCCGGAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8802:2207 1:N:0:CGATGT\'	ATAGAATCCCGAAGTGATGCTGGAAGTGGCACGACATCTGGTGGTACGTATCTTACAATTAGAAGGGATATCGCTACTGTCGTAAATGCCAATAGTGTACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:8937:2238 1:N:0:CGATGT\'	GTAAAAGAGAATGCCTTTATTCAAAGCATGAGCATAATCATGATCAGCCGTAGTGAATGGAATCCCACAAAGTAGCATAGTAAGAAACAAGGGTGCCATAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9059:2004 1:N:0:CGATGT\'	NTAAACTTTTAATTGAACACTTGGTATGCATGTTTATCATCCTACATTAATTCAAATTAACTCCCTCAAATACTAACAAAGCTAATGTTTCACAATCATTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9148:2013 1:N:0:CGATGT\'	GCTTCATATGGTACACATTTATCTGGACATCTCATTCAAAGATTTATTTGCAAAAGAAAGACTACTACTAATCAAACTACAACGACTAGACAGACTAATAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9019:2072 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAATGACAATTGACCTAGTATAAGAAAACCACGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9113:2084 1:N:0:CGATGT\'	TTAAAGTATTAACTAATAGAGGAGTAATATTAGACAACCCGTCTTTTCTCTTTTTTTTTTCACAAATAGGAAATTTTGAATCCAATTCAGATATCAGAAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9080:2092 1:N:0:CGATGT\'	TGTCCTTTTCATCTTTCCCTCGCGGTACTTGTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTGGGGCTGCATTCCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9030:2107 1:N:0:CGATGT\'	CGGGTCGAATGGGGGGCCCACTGGCCGACGCCTGGAGCGCGCAGGTGCCGAGGCACGCTGTGACAGCGCGCGCTGACTACCACAATCGCGAGGACAGCACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9052:2137 1:N:0:CGATGT\'	ATAAAGTATAGGCCGCCTGAGAAAACAGCAACGAAAGATTCTATAACTAAAAATATAAAATAAAAAATGACGACGTCTACTCGAGCGACGACCTTCCTAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9064:2188 1:N:0:CGATGT\'	GGAAGAACTAGAAGATTCCACCTCTGGAAAGCGCCTACACCTAATGGCTTAAGCCGCTGTTCCCATTTCCTCGCTGACCCATCATGCAAAAGGTACGCCGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9174:2191 1:N:0:CGATGT\'	GGCATAATACATGGATCATGGTCAAGCAAGTGGCGACCTCATCAACCGTAACACGCTCAGGCTGCAGCATAGATATCACACGGGGATCATAAGTAGGAAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9080:2243 1:N:0:CGATGT\'	CTCAGGTGGAATTTCTCTGACAACGCCGAGCATGGAGTCATATTCCTCATCTTTACGTGCGTATTTCTTCCTGAGAGCCTTCTCGAATTCAATCTCATCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9497:2005 1:N:0:CGATGT\'	NCACTCATCACTAAGATAGCCAATGGTGAAGACAACAAATAACTACATAGCCGCTTTTGTTCACAATGATGAAGAAACAATAACATAGCAGTCAAGTTGAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9403:2025 1:N:0:CGATGT\'	CATCGATCACTATACATTTCAAAACCATTCTCACATAACACAACGAAAAATCAGGAATGATACAAAAGAGAAAATGTGCATTATAGAGAGTTCAACGAACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9301:2041 1:N:0:CGATGT\'	CTTTTTTCTGTAACTGCACAAAAATAGCTAATACACCAACATAATTTCTCTATGTATAAACCATATGTAGAACAAGTTTAACAAGTGACCTTCCATTGCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9358:2074 1:N:0:CGATGT\'	CGCTTAAGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTTCCATGACCACCGTCCTGCTGTCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9406:2075 1:N:0:CGATGT\'	CACAACTTAGCCCTTATTTTTCAGTATCTGTTGTAGAAACCCGTATCAACCTGCACATCTTCCCCGATTTTAAGCGAAGAAAAAGCTTGTGCAGCAATAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9408:2130 1:N:0:CGATGT\'	CAGTTTAGAGTGACATGACGCACCGTGCGCCCGTTGTACATTAGAATTTGCCATATAAAAAAAGAAAAAAAGGCTTGGGACACACAAAAAAGGCCAGGTAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9373:2154 1:N:0:CGATGT\'	TCGACGGATCGCACGGCCTTTGCGCTGGCGACGCATCATTCAAATTTCTGCCCTATCAACTTTCGATGGTAGGATAGAGGCCTACCATGGTGGTGACGGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9439:2167 1:N:0:CGATGT\'	GAACCGTCTTTATTAAAATACAACTCCTTGGCCATGGCATTGGTGTTTGTGGAGCGTGGTTTTCTGAAAGCCACATTTTGTCTTCTGGTGGAAGAAATGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9454:2181 1:N:0:CGATGT\'	GGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTGGGGCTGCATTCCCAAACAACCCGACTCGGCGACAGCGCCTCATGGTGCGACAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9482:2191 1:N:0:CGATGT\'	CGCTGATTCTGCCAAGCCCGTTCCCTTGGCTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACTAATTAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9269:2205 1:N:0:CGATGT\'	CGCCGGCAGAAGGAGCAAGACGACCGGTGCACACCGAAAGGCGGACCGGTCGGCCCACCCCAAGGTCCAACTACGAGCTTTTTAACTGCAACAACTTAAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9310:2208 1:N:0:CGATGT\'	GTCCAGTTGTCATTTCAGATTTGAGTTCTCATCGAGGTCCTTACAAGTGGTGTCGGCTGCGAACACCAGCACCCTGCCTGACGCGTCCGCTGGCCTCGTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9274:2238 1:N:0:CGATGT\'	TAAGGGTAGATTGGTCATATCCCATTGAGGATTTTATTTCATTTGAGAAAAGACCGAACAAGTAGGCTGCTCCTGCTACTGACATTATCAATAGCGAGGCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9542:2010 1:N:0:CGATGT\'	CCGACATCGAAGGATCAAAAAGCAACGTCGCTATGAACGCTTGGCTGCCACAAGCCAGTTATCCCTGTGGTAACTTTTCTGACACCTCTAGCTTCAAATTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9697:2022 1:N:0:CGATGT\'	TGAAGATAAATTAAAGGAAAGTCAAGCTGTTGTTCGTACTTACCTTCAGAATTTCCATCTGGAAAAAAAATGAGTCTTCTGTTTCTTTTTTCAAATTCATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9543:2051 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAGAGTAATGAAAACATCCTTGGCCAATGCTTTCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9599:2055 1:N:0:CGATGT\'	GCATGAATGGATTAACGAGATTCCCACTGTCCCTGTCTACTATCCAGCGAAACCACAGCCAAGGGAACGGGCTTGGCAGAATCAGCGGGGAAAGAAGACCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9539:2070 1:N:0:CGATGT\'	TGGGGGAGTTACAGTTAGCTATTTTGAGTGGGTTCAGAACATCCAAGGGTTCATGTGGGATGAGGAGAGAGTGAACACAGAGCTGAAGACATATATGACTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9735:2074 1:N:0:CGATGT\'	TTCCATAGATTATAGTTGAACTGTGAAGACTTGACAAAGTCATGCCGGTAGAAATAGTACTCGACTTACCGATAAATTAGGCAAAAATATCACTCCCTCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9674:2091 1:N:0:CGATGT\'	GGCACGTGCCCTTGGGGGACTAATCCCCTACTGCAGGTCGGCAATCGGGCGGCGGGCACACGCGTCACTTCTGGCCCGGATTCTGACTTAGAGGCGTTCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9643:2096 1:N:0:CGATGT\'	CCGGTCAGGGTCTTCACAAAGATCTGCATCCCACCCCTCAGACGAAGGACCAAGTGAAGAGTGGACTCCTTCTGAATGTTGTAATCGGCCAGGGTCCTTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9737:2103 1:N:0:CGATGT\'	GATTTAATCTGCGAATTAATTTGTCATAATATTCATCATCCATAACTAAAATATTTACAAAAAAAATAAAAAGAAAAAGAATTATATTTATTTTGGGTAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9520:2118 1:N:0:CGATGT\'	TAGGAGCAAAAGGAGACCAATTTGATACATCAACTTCAAAAGCACCAGCAATAATTACAACGAGGACAATGACTATCTTAGTTACAGTCATGAATGAATTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9583:2142 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAATAAAGAAGTGGCGAGCAGGACGGGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9715:2144 1:N:0:CGATGT\'	CCGCTATTTTGCCTCTTGGCTTCGAAAGCAGCCCCGTCGTTGAGCATGTCCTGAGCATCGGCTTCCATCCCTAGTTTGGATAGTGCCAGAGCCTGCAAATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9521:2161 1:N:0:CGATGT\'	ATCGTCTTCGAGCCCCCAACTTTCGTTCTTGATTAATGAAAACATCCTTGGCAAATGCTTTCGCAGTTGTTCGTCTTTCATAAATCCAAGAATTTCACCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9881:2029 1:N:0:CGATGT\'	CTACTTTTTAATATGTTCTTCACCTCCATTCAACTACAAATCTCTATAGAACTCTTATTCCATGAATCCATAAACCGTTTATGAAGATCATCACAATAAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9898:2074 1:N:0:CGATGT\'	CGGATTTGGACCGTTCCGCATCCGACCGAGGCGCATCGCCGGCCCCCATCCGCTTCCCTCCCGACAATTTCAAGCACTCTTTGACTCTCTTTTCAAAGTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9837:2076 1:N:0:CGATGT\'	GCGGCACTTTCCCTCTCTTGTTTTCGCAAAAACGGTCCAACATAAACTTGCTTATCATTCAAAAGCATACCATTAAGTTTCTCTATAGCCTTCTGGGCAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9927:2116 1:N:0:CGATGT\'	CCTGCTGCTAACCCGTATTGTGTTGCATTTGCCCTTCGAATAACTTCATCGAGGTCCCTGAATTTCAAGATAGATTGAACGGGGCCAAAGATCTCGTCCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9811:2118 1:N:0:CGATGT\'	TTTTTTTTTAAATAGAAAGGAAACAAGTGATATTATAAGTCCAAATAAGATTTAAAATACAGCATAATAATATAGAACTAGCACAAAATACAAGACTCGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9841:2161 1:N:0:CGATGT\'	GCGGCACATCTGTTAAAAGATAACGCAGGTGTCCTAAGATGAGCTCAACGAGAACAGAAATCTCGTGTAGAACAGAAGGGTAAAAGCTCGTTTGATTCTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9932:2188 1:N:0:CGATGT\'	GCAGATGTAACAGGATCAGAGAAATCTCCTCCAGGAGGGGAAACAGCACCAACAATGGTGACACTGCCATTGCGTTCAGGACCACCAAGACACTTCACTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9869:2218 1:N:0:CGATGT\'	CCGACCCTTTTAACAAAACCCGGGTCAGCCCGTGAGTAGAACCCGGCATTGACAGCAGACCCACCACCGAGAACCCGAGCACGAGCATTGGCAACCCCATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9761:2221 1:N:0:CGATGT\'	TTCCCACATTCTTAAAACCCCACCACCACCACCACGGCCGCCGCCGCCGCCGCTTTCTACATATTCATCATCATCATCATCATCTTCATTATCCAACATTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:9996:2244 1:N:0:CGATGT\'	CTGAGAATTAGATAATTCCCTTGGCCTCCGTAAATTCATGGACTGAGAACGTCTAAGAGATCCATTTTGGAGCCTTTCAACCATTAAGCTAGTCACAGAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10086:2003 1:N:0:CGATGT\'	NCTGATGGAACACAAGGCTGTTTTAGTTGGTCTGCATTGCTTCTGAGTGATAATTGTCTAATTCAGCATCTAACTGCTCAGCTGATACCACCTTCTCGCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10207:2005 1:N:0:CGATGT\'	NTTCGCTTTCAAGCGTGAAAGTCCAAAATCACACACCTTCACAGTGTACTTTTTATCAACCAAAAGATTTGGAGACTTGAGATCGCGATGAACGATGGGTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10080:2078 1:N:0:CGATGT\'	TTCACAATGTCACTAACCTTATCAACCGTGTCTGGCTTTGCAGCACAAGAGATCTGCAAGCGAAGAGGCATCCAGAGCTTTGGGGTGCTAGTCCTCAAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10029:2185 1:N:0:CGATGT\'	TTCCTCTTTTATATGCATGCCTCTCTTTGCAAATGTTCCGACATGATAATACGTTAAGTCCCAAATCGCTTGGGTTGAATTCCTTCAACAAGCATTGTCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10065:2189 1:N:0:CGATGT\'	AGCATTTACGAGCGGTGATTATGGACAAAAATAAGTTACTCAGCTATATATCAAACACTATAAAATTGTTACATCTCCTACAACTTACACAAGTAAATTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10026:2209 1:N:0:CGATGT\'	TCCCTTCCTTGTCCTGAATCTTAGCCTTCACATTGTCAATGGTGTCTGAGCTCTCAACCTCAAGGGTGATGGTCTTCCCAGTCAGGGTCTTCACAAAGATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10065:2216 1:N:0:CGATGT\'	TTTCCGAAGATCTAAAGGATCGTTAGGCCACGCTTTCACGGTTCGTATTCGTACTGAAAATCAGAATCAAACGAGCTTTTACCCTTCTGTTCTACACGAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10157:2234 1:N:0:CGATGT\'	GTCGCCAGCGCAAAGGCCGTGCGATCCGTCGAGTTATCATGAATCATCAGAGCAACAGGCAAAGCCCGCATCGACCTTTTATCTAATAAATGCATCCCTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10215:2236 1:N:0:CGATGT\'	CGGGGAGGTAGTGACAATAAATAACAATACCGGGCTCATTGAGTCTGGTAATTGGAATGAGTACAATCTAAATCCCTTAACGAGGATCCATTGGAGGGCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10438:2004 1:N:0:CGATGT\'	NGTGACACTGTCATCAGTAGGGTAAAACTAACCTGTCTCACGACGGTCTAATCCCAGCTCACGTTCCCTATTGGTGGGTGAACAATCCAACACTTGGTGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10485:2005 1:N:0:CGATGT\'	NAGGGTTTTGAGCTTGGTTAGTTCAACTTTGAGGGTCGAACAAGGGTCTTTGACTGGTGAGAGTGAAGCTGTTAGTAAGACTGTTAAGCCTGTTGCTGAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10408:2017 1:N:0:CGATGT\'	GCCGAAAAGAACAATGCTCCGGTATAAATTGAGCCATCCGATACTTGGTCCTTGTGCATCCTTGTTCGAAAGAACACAGTCATTGCTATGAGAGCCATTAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10388:2097 1:N:0:CGATGT\'	GCATAGGCTATCATCCGATCGTAGTAGACCCCGATTCTTTTGTTGGGGTTGTGGGTTTGGAGAGTGACTTGGAAGAGTGACGTCAGCTGGGTTGTACCACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10476:2103 1:N:0:CGATGT\'	GGACTGAAAGATGGTTCGGGTGTCATATGCTCCTTGTGTAACAAACTTCCTCTCGAATTTGTCCAAGAACTCCAAGTATAACAGATCTTCGGAAGAAAGTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10423:2118 1:N:0:CGATGT\'	ACTGAATCTCCTACCAATCAACCTCTTTGCATCAAAGACAGTGTTGATAGGGTTCATAGCGACTTGATTCTTGGCCGCATCGCCGATGAGACGTTCGGTGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10612:2008 1:N:0:CGATGT\'	TCAGATCATCAATTACAATAGCTCGTTCTCCTGCTTCCACGGCACCAACATGCATCTCCATTTTATCGGTTCCATATTCCAATGTTTACTCTTCCGAAATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10664:2055 1:N:0:CGATGT\'	CTCACGTTCCCTATTGGTGGGTGAACAATCCAACACTTGGTGAATTCTGCTTCACAATGATAGGAAGAGCCGACATCGAAGGATCAAAAAGCAACGTCGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10721:2059 1:N:0:CGATGT\'	CCCGAGGCCCCCGCCGACATCTCCGGACTCCCTAACGTTGCCGTCAACCGCCACGTCCCGGTTCAGGAATTTTAACCCGATTCCCTTTCGATGCTCGCGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10594:2091 1:N:0:CGATGT\'	CTTCCGTGGCCTAGAAGGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCGTTCGTTAACGGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10726:2093 1:N:0:CGATGT\'	AGGCCATTGACTCTCATGTTTAGCAATACAGAATCAAGCATCTTCCCCCCGACGTTCTCGAAATAAATGTCAATCCCATCTGGAAAGTACCTCCTCAAGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10635:2169 1:N:0:CGATGT\'	CTTGAAGAGAAGCAGAATGTAAAAACTCAAGGTACTTCAATCTCTGCTCCTCATTGCTTTCCACCAATTGATCTTCAACTCTGGAGTTAATTTCCGCCATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10631:2229 1:N:0:CGATGT\'	CCAGCCAAGCTGTACCTGCTGCATGTTCAGTCGTCACAATGGCTATCATGGGACTTACTATCGCCTCCTTCTGGGGCACTGGTCGTCGCATCAGAGATCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10742:2236 1:N:0:CGATGT\'	TCCCCATGTCAGGATTGGGTAATTTGCGCGCCTGCTGCCTTCCTTGGATGTGGTAGCCATTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAATTCTCCGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10719:2244 1:N:0:CGATGT\'	CGCCGCTAGGAGGCATACACAGATTGACATTCCGCCGAGATACCATGGCACCTTGGATAGCAAGCCGTTGACAAGATGTTGAATGGAGCTAATGGGTGATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10958:2023 1:N:0:CGATGT\'	GCATAATACAATTGACAGCATCATCACCACTGAACTCCTCAGACCATGCAACAAGGCTAGGCATCATGTCCTGATCAAGCAACCGCCAATTCTTGAGCTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10876:2040 1:N:0:CGATGT\'	CCATCCTCACAAACCACATTATCATTACCTCCATCTGATCCAAACATCGCAATTGGACTACCATCCAACTTCTTAGGCATAATCATCTCAAAACGATTCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10945:2062 1:N:0:CGATGT\'	CCCGACCCCATGGTTAACTACTTGGAAGAACCCCCACTCTTTGCAGGCCTTAGCAATCTGGTCCATGGTTGACCTGACCATGTTCAGGTTGCTAGAGGACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10889:2112 1:N:0:CGATGT\'	CATGCTTCAACGATATCGACGAGACAAACGAATGACCAGGACGAGAACTACCGGAATCAATACCGGCCGCATTTTTCAAGTACCAGGCAACAGAAGGGGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10841:2112 1:N:0:CGATGT\'	CCCCGCTCAGGCATAGTTCACCATCTTTCGGGTCCCGACAGGTATGCTCTCACTCGAACCCTTCACTGAAGATCAAGGTCGGTCGGCGGTGCACCCACAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10822:2116 1:N:0:CGATGT\'	ATGATTTTGTCTCAAGCGTACGAACTATCTCACCATTTCTTATGTCCCATAACCTCACTCCGCCGATGTCACTACAAGAACTCAATATAGTTTGATCACTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10958:2116 1:N:0:CGATGT\'	GTTCGATTCCATTGATACAAAACTCTCTACCAACCGCACCCGATCTTGCCACACTTTCCGAACCATTTCGAGGTACTTTTCGTTATTCTCCATGTCGCCGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10782:2120 1:N:0:CGATGT\'	CGCCAACTTGCGTTTACTGCAACGAAGAATTTGTCGAGTTTTGGAGCGTTGTTGAGCATCAAAGTTGTAGCTACAAAATCAATGAAATAGCAGCATGCATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10879:2146 1:N:0:CGATGT\'	GGCTGCTGGCACCAGACTTGCCCTCCAATGGATCCTCGTTAAGGGATTTAGATTGTACTCATTCCAATTACCAGACTCGAAGAGCCCGGTATTGTTAGATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10759:2146 1:N:0:CGATGT\'	CTGTTTGGTCCTCCGGGAACTGGAAAAACTCTTCTTGCTAAAGCACTTGCGACTGAAGCTGGAGCGAATTTCATCAACATAACCGGTTCCACGCTGACATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10756:2207 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAACCACTACGTGAAAGCGTGCCCATCCTTGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:10769:2236 1:N:0:CGATAT\'	CGCAATTCTCACCTCCGTCCTCGTTGCCGGAAACTCTCCGATTCTTCCACTTCCGGCCCCACTCCGATGACTCCCAATGGCTCAAGAGAAAAAGATTTCGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11156:2085 1:N:0:CGATGT\'	CTTCTGTTTAGGAACTGACGTGGGCCATCGTTGACCCAAAACCCAGACCATGCTTTTATGTAATTCAGTTGCAGATCTTTGGTTGTGAGGTTCAAGATTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11128:2137 1:N:0:CGATGT\'	CTGGTGAAGGGTTCGCTTATGTTGGACAACTCGAGTTCTTCATCAGAGAAGCACCTGAGAAGATGAAATCAATGAGCACAGGATTTTTCCTAAGCACATTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11032:2199 1:N:0:CGATGT\'	AGCGGTTTGAATAGTCATATGAAGAGATCCAGTAATCTTAGCCCCTTTGAAAGGTTGAGAGGGTCCGAACTCAGTTCGGCACGCCATTAAACCGGGCATTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11106:2222 1:N:0:CGATGT\'	GCAGAAACACATGATCCCATACCTAGATATAACAACACCCTCTTCATAATGCTTCTTTAACTTGGAGATGTTAATAATTAGCTTTAGATATTATTTTTTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11405:2026 1:N:0:CGATGT\'	GAAGTTTCCTCGATACTTCATTGCTAGATTCATTAACATGGGTTAAATAGTTCTCAAGAGCAACAAGCAAGCTTTCACAATATTGCTTGATCTCACTCCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11478:2036 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAACAACAAAGTAGTCCCTATGTAATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11337:2049 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAAATCTCATATAAAGACACACAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11374:2059 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTACCTCGCATGCCGTCTTCTCCTTGTGAAAAAATCCTTCACTTCATCTTCAAGCAGAAACCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11403:2076 1:N:0:CGATGT\'	CCATGTCAGTCCGCACCCCGAGCCGATCGGCGGACCGGATTTAGGCCGTTCCGCATCCGACCGAGGCACATCGCCGGCCCCCATTCGCTTCCCTCCCGACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11319:2143 1:N:0:CGATGT\'	CTGCCGCCTCCTTTGGGAGCTTCTTCCCGGCTTTTGGCTTCTTCTCCGCCGGTGCTTTCTCGGCGGCGGCGGCGGCTTTCTCGGCGGGGTTCTTTTTTTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11722:2004 1:N:0:CGATGT\'	NCAGCATTCACATCTTTAGGGACAACATCACCACGGTACATCAGACAGCAAGCCATGTACTTGCCATGGCGAGGATCACACTTGGCCATCATAGAGGATGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11614:2037 1:N:0:CGATGT\'	ACTTCTGAAGACAAGACTACTACTCCACTAGACACGGCATTTGGCTTATCAAAGAATCCCAGTCCTGTGTGCGACTCCTCATCTTCATCCATGACACCAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11701:2043 1:N:0:CGATGT\'	CCGGGCGTCGAACAGTCGACTCAGAACTGGTACGGACAAGGGGAATCCGACTGTTTAATTAAAACAAAGCATTGCGATGGTCCTTGCGGATGTTAACGCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11509:2065 1:N:0:CGATGT\'	GCGCGCAGTTGGGCACCGTAACCCGGCTTCCGGGTCATCCCCCCTCCCCCGGGCTCCTTTCCAAAAAAGGCCCCCGCCGCCCCCCCCGTTCCTGGGGACTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11628:2075 1:N:0:CGATGT\'	CGTCACAAATCCTCCAAACAAACACAACCACTTTGAAACTTAACCAACCAACAAACCACGAATCAACTTCACCAACACAATCTCAATTACAACTCTATCAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11616:2101 1:N:0:CGATGT\'	CTCGGGAATATTCCGCCATAGTTAAGGCAGTCAACCCAACTCTCATACGTGCCCCCGGCGGTTCATTCATTTGACCATAGACTAGAGCTACTTTTGATTCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11743:2106 1:N:0:CGATGT\'	CCCCGGTTCAGGAATTTTAACCCGATTCCCTTTCAATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATGTGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11520:2106 1:N:0:CGATGT\'	AGGAGAGAGAAACACTTTCGATTAATTAAAAATCAAATCAATTAATTAAAACCAGAACTCAAATCCCATTCTTTTTAATTTAATTTAATTTAATTAAATGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11603:2193 1:N:0:CGATGT\'	TCTTAGCTTTAACCTTCAAATGCTTTTCCAATATACTCACAAGTGACGGCACCGTTACAGGTTGCGTATTACCCAAGTTATATATCCTATACGGTGCGGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11509:2212 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAATACTATGCTACAATGTTTGCCGGCAGAGAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11942:2140 1:N:0:CGATGT\'	CTCAAATCAACACCATGATTAGGAGAACGCGTTCAGACCGATTTGAATGATAAGATTTTCATGGTTACAACCGAATCAGGGTTATTAAAATGGCCATAACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11958:2165 1:N:0:CGATGT\'	CCCGACTGTCCCTGTTAATCATTACTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATGATGTTATCCCATGCTAATGTATACAGAGCGTAGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11924:2172 1:N:0:CGATGT\'	TTGGCAATAGCTTTGAGTGACTCAAAGAAGTAGGTAGATTCCCGAATGATTGCATACCCATTGGGACGTAGGATTCGATCCATTTCCAACAGAACATACTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11836:2197 1:N:0:CGATGT\'	GTGTTGTTTGGGTGGGATGGGGAAAAAAAATGATGGGTGAATTTTTTTTTAGGGAAGATATGGAGACGAGGAAAACAAGGGCGGCGATGGAACCGGGGAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11909:2198 1:N:0:CGATGT\'	GGGCACTTCATCTTTTGCTCTAAACATCAAACCAACCCAACACCTTCACCTTCCTCCACCTATTTTTTATTTTTCCATTAAAATCCCAGTTTTTTCATCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11913:2230 1:N:0:CGATGT\'	CGGCAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTTCCATGACCACCGTCCTGCTGTCTTAATCGACCAACACCCTTTGTGGGATCTAGGTTAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11830:2231 1:N:0:CGATGT\'	CCAAGAAGTCACACATGCTCCAAACAGATATATCTCAGCTTCACTACCATGAGGCGAAGTGAGGACAACCTTAGGAAGATCTCCAAGTCCTTCAGTCAACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:11967:2238 1:N:0:CGATGT\'	CTCCGTACCAGTTCTGAGTCGACTGTTCGACGCCCGGGGAAGGCCCCAAAAGGAGCCGTTCCCAGTCCGTCCCCCGGCCGGCACGCAGCAACCCGCCCTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12221:2045 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCCTATGCCGTCTTCTGCTTGGAAAAAATATTAAACTAGTCAAATAGGACTCTCCCCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12071:2064 1:N:0:CGATGT\'	GGCATAGTCCAATGAGTAGACAAAAAACAATGAAGAAGCACCAGCAGCACCACCAGAAGCCAAGTTACCAGCGAACCACACCCAGTAACCATCCTTGTCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12090:2189 1:N:0:CGATGT\'	CTGATTAAGTAAGAAAAAATAACGGATATTTTTTCCAATATAAAAACAAAACTTATTAATAAAAATTATGGAAGTCGGGCGAACAAGAATGTCCATCTCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12221:2196 1:N:0:CGATGT\'	CGTCACCCTCCCGGAAGATGACGTCACCATCGTTTTCGCGATTGTGGCAGCTTGCTCCGCCTTCAACCGAGCATCGCGGAAGCATTTGGAGCAAAGATTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12186:2247 1:N:0:CGATGT\'	GTGCGAATCAACGGTTCCTCTCGTACTAGGTTGAATTACCATTGTGACACTGTCATCAGTAGGGTAAAACTAACCTGTCTCACGACGGTCTAAACCCAGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12449:2002 1:N:0:CGATGT\'	NGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAACCCGGCCAATTAAGGCCAGGAGGCCATCGCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12350:2078 1:N:0:CGATGT\'	TGGGGGGGTGAGTAACGCGAACAATGGACGGAAGTTGACGGTACTCCCAGCATCGTACACGTTGAATGAACCTCATGACGTCAGATTGCTTCTTCCTCCAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12288:2099 1:N:0:CGATGT\'	CTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGCGTATCGCCGGCAGAAGGAGCAAGACGACCGGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12320:2102 1:N:0:CGATGT\'	CCACGAGATAGTTCGAGTATCATATCCACAAATCCTCCACCACCTGCTTCTCTAAAAATCAATTACTTCAACTCACAGAAAAGAAATTAAGGAATCCAAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12496:2126 1:N:0:CGATGT\'	CTCGATTATCTCAAAATCAGACCTGTAGAACGTTCTCAGGTTCCCCCCCGCGAGTAACACCGTCAGGTATGCCTCGAATGCCGCTTTCATCGCTTCTTTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12319:2130 1:N:0:CGATGT\'	CGATCAAATTTCACAGCTATCCCTCGCATCACAACATGCTTCACCCTCCGTAGTGTTTAACAATTAAATCACCTGATGAAAATCAAGCACCTGTTTGTTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12439:2208 1:N:0:CGATGT\'	CGCCGAGCTATTCTTTTCAGGTTCTTTTATTTCGCCTGTAAGGTATTCATCCTTCCCTCGCCCACATATGGACATCATGACTGATTATGACCACCGAAGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12543:2072 1:N:0:CGATGT\'	CATCATTCAACAAATAAAGTGATTCTGAGTAGAAAATTAAATTCTTTTTAAAAGGACAGATATACAAAGCATCACTCACCTACATCTTTTCCTTTTCATTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12656:2084 1:N:0:CGATGT\'	TTCTGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAGGACACCTGCGTTATCTTTTAACAGATGTGCCGCCCCAGCCAAACTCCCCACCTGACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12576:2091 1:N:0:CGATGT\'	ATCCGCTTCCATCCCTAGTTTGGAAAGTGCCAGAGCCTGCAAATAAAAGGCGATCGGCCATTCGGGTATGCAGGCACAGGGCTGCATACCCGAATGGCCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12504:2100 1:N:0:CGATGT\'	TCCGGTTTTTTGTTCTTTTGACCCTCGTTTGGTTTTTATCGTGCATTCAAGGCTATGGTTTTGTAGTGCTGTGGATTTTTATCCACAAGTAATATCTTGGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12587:2185 1:N:0:CGATGT\'	AACCAGCCAAATTTGGTGCCAAGTTCTATAGAAGCTTGCTATATGTTCTCTCTAGTTTTTCAAATTATTCAAAACCACCGACACATTCAATGGATGAACCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12502:2233 1:N:0:CGATGT\'	TGTGAAACCGGCGCTAAACCATTAGATACTTCTGTAGGGAATGTCTTCATAAATCCGGCTTCTATATCGCAGAAATCTACTTGAGCGATCGATGGAATTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12696:2247 1:N:0:CGATGT\'	TGACTCTGCTGGTGGATAATCCTCTGCCAAAGGCTTTTTGACAGAAAAGTCTCTACCCTGTCTGTCCTGATTAAGAGGAACATCCCTCATGTCATTGGAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12855:2049 1:N:0:CGATGT\'	GGGGGCATCTCACCGGCAACCCACGGTGTCGAACCCATCAAGCGACGGCGGCCGGGGGCCACATTACCTGAAGAACCAGCACCACCACCACCAGCGGCGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12826:2071 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAATCCTGTTGAGCAGTTGATCCCAAGATGCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12846:2088 1:N:0:CGATGT\'	CGTCGCGATAATTGTGCTAGTAGCTTCTCGAAATCATCCTTGTATCATTACATGCGATGGTTCCTGGTATCTCCGCTGTAGAGCCAGTCATAAACAGTGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12947:2106 1:N:0:CGATGT\'	CGCCTCTCTCTGTTCTGCATTTGAGTAGAAGAAACCTGCATTTATTTCACTTTTCTCATACTCAAGAGACACATTGCAAGTCAATATGTAACAATTTTCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12806:2200 1:N:0:CGATGT\'	CCTTCCTTGACACGGAAAGCAGGTGAGACGTGGGCAGGGATGTTAGAGTGCCTCTTCTCATATCTTTGATACTTTTTAATGTAGTGCAGATAGTTGCGGCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12805:2220 1:N:0:CGATGT\'	CATACATTACTTATGCTGAAGAATCTACAATAAAGGGTTGTTGATATAGTAATTATCTATGATAAGAACAAAGGCGCATAACGCGCAATCACAAAACATAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:12975:2239 1:N:0:CGATGT\'	TTACCCTGTTAAGTGTAACCAAGATAAGTCCACCCAAATTTAACAATATCATCAACAATCAACTTATCTTGGTTACACTTAACAGGGTAAACACCCTGGTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13150:2015 1:N:0:CGATGT\'	CACCCGCATGTATCATCCACACCGATACTTATTCCCATTTTTTAACCAAACAAGGCCTTAGTCACCTCCAAGAACAATAAGTACGTGATCCATTGTGGTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13177:2059 1:N:0:CGATGT\'	AGGAAGTTCAAGAGACTCTGCCACCTTCTCGAGTGCCAAACATCTAATTTCCCCAAGCTCCTGTCTACATGTGGGGCATCTGTTATGAACCCTTGTTTTAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13105:2163 1:N:0:CGATGT\'	GCCGGCTTCCCTTGCCTACATTGTTCCATTGGCCAGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCAGCACTCGGTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13085:2227 1:N:0:CGATGT\'	CGGCTGGTGTGGACTCTAAGGCTGGGCTTATTCATCGTACCAAGTGTTCTATTGGCTTTACTTATTCGTTTTACAAGTTTACTTCCTCGACCTAAGTTATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13313:2014 1:N:0:CGATGT\'	GGCGAAGGCACTGACGTCAAGGCCGGGGATGTTGAGCGTCATGAGGATGCTCTTAACACCCGTGATAATGTTGAGTGCATTGCTAGTTAATTCCCTTGAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13325:2028 1:N:0:CGATGT\'	CCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATGTGCAAGTGCCGTTCACATGGAACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13304:2034 1:N:0:CGATGT\'	CAAGTAAGACTCTCCTTTTTACCTACAACCTCGAAGAGGGTATCCTCCACGGTATAGTGGAAATTGGGTACATCCAAACGGGGCAGATCCTCTGTAAAGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13467:2042 1:N:0:CGATGT\'	CCCAGCTTTTGGCAAATTTTGAAGCTCAAGTCTCTGTCAACCATCTTACTGCTCCTCGGACCGCCACTGTTCGAAGTTATAGCTGGACCATCTAACAAAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13267:2114 1:N:0:CGATGT\'	TGATGGTCTTTCCAGTTAGAGTCTTAACGAAGATTTGCATTCCTCCCCTAAGACGGAGCACCAAGTGGAGAGTTGACTCCTTCTGGATGTTGTAGTCAGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13385:2137 1:N:0:CGATGT\'	GTTAGTGTCATCTTTACCCATGAGCTTTTGATACCCAAGAGCTGAGGAATTATACAGAGGCATGCTTCGCATTGTACCATCCAAAACTGTGACACCAATAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13260:2140 1:N:0:CGATGT\'	CTCATCTTGAATAGCTAGTAATCAGAGAAATGAAAGTGAGAGAGAAACCGAACCAGGGAAGTGGGAGAGGAATAGAACCTCATCTTGAATAGCTAGTAATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13418:2147 1:N:0:CGATGT\'	CTTGTCAATGCTGGTTGCCAGCTCTTTCTTCGCCTTCTCCAGCCCAGCCCTCTCAAATTCATTTAACGGGCCAAGCGGGAAAATCTCTTCAGCTCCACTAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13457:2228 1:N:0:CGATGT\'	ACCAAGCGCGATGACCAATTGTGCGAATCAACGGTTCCTCTCGTACTAGGTTGAATTACCATTGTGACACTGTCATCAGTAGGGTAAAACTAACCTGTCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13437:2233 1:N:0:CGATGT\'	GCCCAGGGTGGGGAAGAAATTCCAGATACAGTTCCCTTGGAAGATGACGAGTCCTTAGGGGGACTTCCAGGAGTATTGCCTGTGGGGCGAGGCATGTCAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13285:2243 1:N:0:CGATGT\'	ATGAAAAGGACTTTGAAAAGAGAGTCAAAGAGTGCTTGAAATTGTCGGGAGGGAAGCGAATGGGGGCCGGCGATGGGCCTCGGTCGGATGCGGAACGGCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13331:2247 1:N:0:CGATGT\'	CGGGGTTTGTTGCACGTATTAGCTCTAGAATTACTACGGTTATCCGAGTAGCAAGTACCATCAAACAAACTATAACTGATTTAATGAGCCATTCGCAGTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13728:2069 1:N:0:CGATGT\'	CTCCGGGTTATTCTTATACCCATTTGTCACATTCGGGCCACGAATACAAACCTCCCCTTTCAACCCAGGCCCAAGAACAGTCCCATTCTCATCAAAGATGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13531:2075 1:N:0:CGATGT\'	CGGTAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTTCCATGACCACCGTCCTGCTGTCTTAATCGACCAACACCCTTTGTGGGATCTAGGTTAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13581:2091 1:N:0:CGATGT\'	CCGGTTCGCTCGCCGTTACTAGGGGAATCCTTGTAAGTTCCTTTTCATCTTTCCCTCGCGGTACTTGTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13556:2115 1:N:0:CGATGT\'	GCGGATTCTATAGCGTAGAAGATTCTAGAAGCTAAATCAGAAGATCTCTGCCATGCAGCGAGTCGCGGTAGGAGGCTGGATTCGCTACTATGGCTGACCAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13578:2117 1:N:0:CGATGT\'	TCCCCTCGGCAAGGTGCCCCAGCTTTGATGAGACCAGTAGCAAGACCCACCGAGAAATCCGCAATGAAAGTGTCCTCAGTTTCACCACTCCGATGTGATAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13622:2141 1:N:0:CGATGT\'	ACCGAAGCGACAAAGGGCTGAATCTCAGTGGATCGTGGCAGCAAGGCCACTCTGCCACTTACAATACCCCGTCGCATATTTAAGTCGTCTGCAAAGGATTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13685:2151 1:N:0:CGATGT\'	AGCTTGTGGTAGATGTTTCTAGGCCTAGGACGCTCCCTTCAGGGCAGTGGGCTCCTCTCTGACCTAAGGCAGGAACAGAAATGCCATCGAAGAGCAACTAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13542:2163 1:N:0:CGATGT\'	GCCAATCTTCCATTTTTTATCTCCTTCACTTTGAGCTCAGCAAAGGCTTCTGGGTCGTCGGCTAGGCCCAATGGGTCGAAGCTACCACCCGGGTAAAGCGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13715:2166 1:N:0:CGATGT\'	AGCCCATGCTCGCGGATACCGAAACCCAATGCAAGTGCAGCACAAACAAGAAGTATGATCAATATTGGGTCTTGAAAAGCATTCCATACAAAGTACAGGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13644:2172 1:N:0:CGATGT\'	CACAAGCCAGTTATCCCTGTGGTAACTTTTCTGACACCTCTAGCTTCAAATTCCGAAGATCTAAAGGATCGTTAGGCCACGCTTTCACGGTTCGTATTCGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13532:2197 1:N:0:CGATGT\'	CTGTAACATAGACCCATCTTTAGTGAATCGGACTCTCTCAACTTTACCCTTCTTAACAGCGCTCAAAAACTCACTATATCTCCATTGGGAACCTTCTGGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13503:2199 1:N:0:CGATGT\'	CCTTGACAAGCAGCAACATGTAACGGCGTTCGAGAATCGACATCGACGAAATTCACATTCGCTCCTAAATCAACCAGCTCTTTAATCCCTTCCAAATCGCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13579:2207 1:N:0:CGATGT\'	AGGAGCGACGGGCGGTGTGTACAAAGGGCAGGGACGTAGTCAACGCGAGTTGATGACTCGCGCTTACTAGGAATTCCTCGTTGAAGACCAACAATTGCAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13604:2219 1:N:0:CGATGT\'	CACGTCCCGGTTCAGGAATTTTAACCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13675:2228 1:N:0:CGATGT\'	CCTTGGTTTAATGTCCGCGCACCTTTGAGCAGTCCAAGGAAGGGACGAGATCGATGCCTAAGTCGACACCACACTTGCTGGCGAGGGGACCGGCGTAGGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13614:2248 1:N:0:CGATGT\'	TGTACTTCCTCGGATAGCAGATAGTGCAAAGAATGACAAAAGTGCGGTGTTGCGTGCTAGATGCTGTGAATATGCACACTTAATTTTGGAGCAGTGGCCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13871:2050 1:N:0:CGATGT\'	GCCGTCGCAGCATCAACCCCCCACCGGGATCCCGCTCCGTGCCATCCCCTTCAACGTGGTGGATCACGGGAACGGGAAGCCGGATGTCGGTGATAGGAGTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13996:2163 1:N:0:CGATGT\'	GTGGTATTTCACTTGCGCCGAAGCTCCCACTTATGCTACACCTCTCAAGTCATTTCACAAAGTCGGACTAGAGTCAAGCTCAACAGGGTCTTCTTTCCCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13949:2201 1:N:0:CGACGT\'	CCCAAGTGAAGTCTCTGATTGATTGCTCTACATGTCAGAGGCACACAAAGTTGAAGACATTAAATTAAAATACAGAGATAAGGATTTCTCCTCTTTCCTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:13903:2210 1:N:0:CGATGT\'	GTTGAAGGCCCTGTGGTGAAATTAGGCTCGAAATGTTTTTCTCGGTCTACCCATAAGGGTGCCATTATGAAGCACCAAAGGTTCTCAGGAGCAGGAGAGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14157:2018 1:N:0:CGATGT\'	TCCTAACCAAACTCAACGCCACATTTTTCATAGCCATCAATGCAATTTCTTTCCCCAAACACGCCCTTATACCGGCTTGGAAAACCGGATATCTATACCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14079:2034 1:N:0:CGATGT\'	CGCCACCACCAGTACCTATTTTTAAGAAACCTTGCCCTCCAATTATCAAGAAACCACCAATCCCAGTTTACGAACCAAAGCCTCTCCCTCCTTTGCCAAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14220:2084 1:N:0:CGATGT\'	TCGCCATACATCAATAACATTATCAAATCCCCATAAATTTGAACACCACTTGAGCTGCGGGCTGCACACTTTCCTGCAGTCAGATCGGAAGAGCACACGTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14161:2103 1:N:0:CGATGT\'	AGGTTCCAAAAACATCTGACTCAACAAATCCGACGGCTCAGATGCAATCACAGATCTATTAGCTTGAGCCTCTAAACTCCCAACCATGATGATCAACAACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14225:2170 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACAACACACACTTCGACAACCGCCACCCCTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14165:2207 1:N:0:CGATGT\'	ATAAATTCCCAAACAAATTTGATGGATTTTATATCAAAGTTGCTTTTGTTGGCTATATGCATAGGTACCCGATATGGCTGCTTCAGTTCCAATAATTTGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14187:2212 1:N:0:CGATGT\'	CGCTTTGCCAACAAGCTCTTGCCACTTGCAACAGCAGTGGGATTAGAAAATGAATCTGCATCACTATGTAGTCTAACACCACAGGATGCTGAAGCTCTCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14143:2222 1:N:0:CGATGT\'	GCCACATTATTTTTTGGAAAGTTCTTCTCTGACCATTAAAGTAGTATGCATTTCACAAAAATAAATTTGGAAAGAGGAAAAAAAAAAAAAAAAAAAACACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14058:2230 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAACGGAGAGCAAGTTGGCGAGGTGATTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14220:2244 1:N:0:CGATGT\'	AAGCATACACATAGAGCATGCAAGGGCCGGTCAAGCCGGTTTTAGATAACTTTTCTATATAACAGGGAGAAGCACCACAGTAAGGCTAGCATTATCACCAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14287:2012 1:N:0:CGATGT\'	AATAGATGCATAATTTCAAAGCTGATATACCCTGAAAATAACTGGTTTCAATTTGCTAATCAGAACATACAATAAGTTCTACTGTTGATTAACATCTCTAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14488:2032 1:N:0:CGATGT\'	AGATCATCATAATTCAACATATTTACTAAATGCTCATAACTTAGTAAACATTTTGACAAACACACAATGACTTGTTCAAGTATGGAAGACAGCCATTTGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14324:2044 1:N:0:CGATGT\'	CTCGGATTCTACTTCCTCTCTAGGACAACTAAGATCCACATCTGACGGACCAGCCATAGCCGTACTAGACGACCTAAGATCAAGCTTCAAAGCCTCTGCAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14294:2151 1:N:0:CGATGT\'	CGGTGGTCGAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGTAAAAAAAAGAACCATTGACGCTTTGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14379:2159 1:N:0:CGATGT\'	GGCAGAAATTTGAATGATGCGTCGCCAGCGCAAAGGCCGTGCGATCCGTCGAGTTATCATGAATCATCAGAGCAACAGGCAAAGCCCGCATCGACCTTTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14362:2206 1:N:0:CGATGT\'	GGCTTTTCTAACACTCCTCCTCCCGCTGATCCAGTTGCTGACACAGCCATTAGAAAGCCACGTTGGTTCCACAATCCTTTACAAAGAACATGTTTATCCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14342:2223 1:N:0:CGATGT\'	CACCGATGCCTTTAGCTTTTCCTCCAAAGCCTTGGCAGCCGTTACATCTGAAAAGCCCACAAAGTTATCCTCCTCCCCAAAATGAGCTTGAACAGGAGCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14717:2007 1:N:0:CGATGT\'	CATGGCAAAACCGCGACATTGCTGGAATCACAGCCTGTCATGACTGACTGCATTGCGGATGTGTCCACAGGAGCATAGACAACCATGGACTCGTAGTAGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14517:2074 1:N:0:CGATGT\'	CCACCGTCCTGCTGTCTTAATCGACCAACACCCTTTGTGGGATCTAGGCTAGCGCGCAGTTGGGCACCGTAACCCGGCTTCCGGTTCATCCCGCATCGCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14731:2074 1:N:0:CGATGT\'	CTCAATCTTCACTAAGTTATGCTTCTTTTTCCCCACCTGCTCACAAAGTCCCTCCTTAAGTTCAGCAATATCTTGATCGATCAATTCTCCTCCTTCAGCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14538:2151 1:N:0:CGATGT\'	ATTCCTCATAACACCAATATCATAAACTGGGGTGAAATCAGGGTTAAACAACCCAAAATTCTTCTCAGCAATAGGTCCAGGCTTCTGATTCTCAACAAACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14713:2165 1:N:0:CGATGT\'	GCAAAGCAAAGCAACACCAAAGTAACTACACATTGATCAAATGCACAAATTTTACAAAATTATTCGTAGCCTTCTGGCTTGTAGGCGATGAAACTGATGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14988:2172 1:N:0:CGATGT\'	GGGGGGCCCACTGGCCGACGCCTGGAGCGCGCAGGTGCCGAGGCACGCTGTGACAGCGCGCGCTGACTACCACAATCGCGAGGACAGCACTCCCGGAGACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14947:2188 1:N:0:CGATGT\'	TTCGTTAACGGAATTAACCAGACAAATCGCTCCACCAACTAAGAACGGCCATGCACTACCACCCATAGAATCAAGAAAGAGCTCTCAGTCTGTCAATCCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14924:2194 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACACCTACCTATACCAGAACATCGATATCCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:14879:2224 1:N:0:CGATGT\'	AGGGACGTAGTCAACGCGAGCTAATGACTCGCGCTTACTAGGAATTCCTCGTTGAAGACCAACAATTGCAATGATCTATCCCCATCACGATGAAATTTCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15004:2005 1:N:0:CGATGT\'	NTCGAGCAGTCCACCGACAGCCGACGGGTTCGGGAATGGGACCCCCGTGCCCAGCCCTCAGAGCCAATCCTTTTCCCGAAGTTACGGATCCATTTTGCCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15080:2021 1:N:0:CGATGT\'	GGATAAACTCCTCATCTTGAGGGCGTTCAAACACCACGGTGCTACTTAGCTCATTAAGCATGGCGCTAATCCCATTCTCCCTGAGCCGGTCTTTAAGGTAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15078:2061 1:N:0:CGATGT\'	CGCCATCAAGAAGAATTTCTGGTTCGACGATGGGCACGAGACCATTGTCCTGTGAAATTGCAGCGTAACGAGCAAGTCCCCATGCAGCTTCCTTGACAGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15124:2095 1:N:0:CGATGT\'	GAGAAGCTCAGAAATAATGAGGTTATTATATTAATAATTAATCAGTATGAGAGAGAAGCTCAGAAATAATGAGGTTATTCCACCCCATCAATGGGATTAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15058:2138 1:N:0:CGATGT\'	AGCACCAATGTCCTCAGGGCGCTTGGTCAAGTGACCGTGAACACCTTGAGCAATGTCAGGACTTTGCTGCTCAATGTAGACCAAGACCTTGCAGTTATCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15051:2178 1:N:0:CGATGT\'	TTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACTAATTAGATGACGAGGCATTTGGCTACCTTAAGAGAGTCATAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15018:2191 1:N:0:CGATGT\'	GGGGCTTTGAGGATACGTGAGGTAAGGATGACGTCAGCGGACGGGATTTGAAAGGTCTTCACTGTACAGTAGGCCATTTGTGTGTTTATTTCTACTCACTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15071:2197 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAACTTCTGGTACAACAGCACCCGACCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15119:2245 1:N:0:CGATGT\'	TAAAATTGGAGCAAAACTGAGAAATGAAAGAAATGGAGAGCAAGGGAATAGATGATTAATTTTATCAATTAATGAACAGGTGGTAATTGAGAGATAAGGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15494:2018 1:N:0:CGATGT\'	GCAGGATTGGGGTCGAGCATGCGAGTGACAAGAGAGCACGCTTCAGGGGAGAACCAAGCGGGGCAGCTGAAATCACCCTTATAGATACGACGATACATTCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15308:2054 1:N:0:CGATGT\'	CGACCTGTTATTGCCTCAAACTTCCGTGGCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15437:2087 1:N:0:CGATGT\'	CCTGTTATTGCCTCAAACTTCCGTGGCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGAGTCCGCATAGCTAGTTAGCAGGCTGAGGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15353:2100 1:N:0:CGATGT\'	GCCCACTTCTTGAGCATAAACCAAACAAATAAATTAAAAAATCCAGAAAAACTTTCATTCACTCGAGATAGGATTTTCATTCGGAAATCACTTTTAATTAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15259:2220 1:N:0:CGATGT\'	CTCAGAAAGAAAACTTCAAAGACTGTTTTAATTTCAGGACTCAAAACTAAAGATTCAGATTATCCTGCCCTGTCATCCATCTTATCATGTTCGATCATCAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15732:2003 1:N:0:CGATGT\'	NATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAATGAGGAATTCACCTGCGCCGCAGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15541:2026 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAACCAAAAATAGTAACCTGTGGGTAGGGGCAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15671:2108 1:N:0:CGATGT\'	CTTGGGGGACTAATCCCCTACTGCAGGTCGGCAATCGGGCGGCGGGCACACGCGTCACTTCTGGCCCGGATTCTGACTTAGAGGCGTTCAGTCATAATCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15607:2111 1:N:0:CGATGT\'	CACAATCACAAGCACCCATACACTCCTCCATTTTTGTAACAAAGCCTTTGACCTGGACAGGAATTTTCCATTCGATCGAGCGCAACTTCTGTGCAAGCTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15572:2115 1:N:0:CGATGT\'	GTCGGGGAGCTGAAACGTTATGCTATTCATTTTGACAGGACTGGTCAACCAAGTGGATCCGCTGAAGTAGTGTATGTTAAGAGAAGTGATGCATTTGCAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15647:2138 1:N:0:CGATGT\'	ATGCATGCAAATTTATCAACTAAATAACAAGTTTGAAATATAATAGATTATATTGTAACAATATTTATGAATTGTCAAATAATTTCATAGGGTTATATGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15546:2184 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAACAAAAAAATTGAGTCGCCCACAGCGCACGGGTCAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15833:2017 1:N:0:CGATGT\'	AGCAGAGCAGATGTTTCAGCAACAGCCCCCTCAACAACTCTAACCGCAGAATTGTCCAAATATTGTGCTAAATATTTAGCCATCAATGATGATGTAGCAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15784:2055 1:N:0:CGATGT\'	AGGGCCGAGTGTTCCACCAGTGTGAACCAAACCATTCTTCCAAAACACCCAAATGATGCGACTGTTCATGCTCGTTTCCTGAGAGGACATCCCCTAGTATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15752:2130 1:N:0:CGATGT\'	CGTCGATATCTTTTTCCTCATCTTCTTCCACAATAATCTGTTCAACCACCTTGGATATTAGGTCTCGATCAACCTTCCCAGATGTTGTCACTTTCAGAACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15887:2145 1:N:0:CGATGT\'	CGAAATATTAATTATAACACAAAAAAGAAGGTTACATTTGAACAGATGAACTGAGAGAGACTAACACACAACACTCTTTCACTTCTAGAGTTCCTTGGTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15910:2186 1:N:0:CGATGT\'	GGATGGTCCTAGTTGTTGGTTAGGTTGAGGTGCAGCAGCTTCGAGCAGGGCTCGGGTCCCACGAGCTGCTGGCCTAGGGGGGATGTGGGTCCCACAAGAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15847:2230 1:N:0:CGATGT\'	TCCACGTCGCTCACCTCAATCTTCTCACATGGTGCTAAGCTGCTACAAGCCAATGTCACTACTTCCACACTGCTCGATGTTCCTCTAACGTTCTTTATTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:15932:2230 1:N:0:CGATGT\'	CCGCAGAGTCAAACAAAAAATAATACCAATTACGTCTCAGGTGTATACGGGGAGTACTAATATGGTTCCAATTATTCCTAGCAAAGCCTAAGATCTTAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16089:2097 1:N:0:CGATGT\'	ATTCTACAACATCACTGAAAACCATATCGACATTCTCATCAGGCTCACCAACCATCTGGTGCCACATACCAGGGTAGATCTTGAGAGTCTTATCCTTGCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16178:2104 1:N:0:CGATGT\'	CAATAAGCATCTTCCAATGGCATCCTCCAAAGTTTTTCCCCCATCACTTCTGATGCACTAAACACCTCACTGGAAAGTGCATCATTGGGTGTAAACACACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16042:2196 1:N:0:CGATGT\'	CTGATGAGTATGAGGATTTACTAGGAGATTTTGAGGTTTGATGTCACGATGACAAACACCAATACAGCGATGAATGTACGACAAAGCTCTGAAAATCTGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16029:2231 1:N:0:CGATGT\'	GTGGATGAATCGGACTTCTTTGTGGCTGGCCAATCTTCATCCCATTTCGTGCTGCTCTTAGCAGCAGAGACTGAAACTGTTCCATTCATATCCTTTGATGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16357:2009 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAACATCCATGCTACTCATCTTCCTTAATAGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16336:2095 1:N:0:CGATGT\'	TTGTGTAAGACCGTCTTACTATGCAATGGTTTATAAAACAATTTTGGAAAGGAGTACTTTTGAAAATAAAGGTATTTGTGAGTCATTACACAGCGAGATTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16253:2098 1:N:0:CGATGT\'	TCCGGGACCAGTAATTGAGTTCCCTGTTTTTCATATCTGTGTGCTATGTATGTTGTGATTGCTCTTGATTCAAAGAGCTTAGAGTCTCCATCTTCAAAGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16364:2115 1:N:0:CGATGT\'	GCTTTCTCAAGGGTTTCTTCAACCGCTGATTCGATAACATCAACAGCCTTGGTTGTCTCAGTTTCTTCAGGTTTTGCTTCCACCTCTTTCTCCGGTGTTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16436:2145 1:N:0:CGATGT\'	TTGGCAAATGCTTTCGCAGTTGTTCGTCTTTCATAAATCCAAGAATTTCACCTCTGACTATGAAATACGAATGCCCCCGACTGTCCCTGTTAATCATTACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16458:2199 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGCATGCCGTCGTCTGCTTGAAAAAATTTTCGGGCGGTGGCTACGCGGCTGCAGGTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16584:2011 1:N:0:CGATGT\'	TGAGGAAAGCCCCTGGTAAATAGCCCAAGACCAACAAGGGAAACCACTGGTACGGCAACAACCGGGGTAATCAGCCTTGTCATATTTCCCCATATTTTGCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16714:2042 1:N:0:CGATGT\'	CCCAAAAATGTTTAACTTACAAACTCTTCAAAGTGTTCCAAAACACACATGTTTGCTCTTTTTTCACTTCTCTTTATGTGATTCTTAAGCAACATTACGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16606:2070 1:N:0:CGATGT\'	GGAGATGCTACAAGTATACACGAATGGTATCTTTTCTGGATTATTTGCAAACACCGATGTTTATCTTCAATCCATTGGCATGTTTGTCGTCGAACAGTGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16502:2087 1:N:0:CGATGT\'	AGAGAAGCAAGTAATTAGGGCTGGATCCGGACCCAAACCCGTACCCGGTCAGAAAGTTACCGTTCACTGCACCGGCTTTGGGAAAGATGGGGACCTTTCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16609:2100 1:N:0:CGATGT\'	TCCGCTATGAGTGCTCGGTAAAACGACCATTTTCCTAACTCTTCCATATCGAACAATGGTGATGGTGGTGGATCTTGGTAGTCTTTTGCCATGTCTCGTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16661:2175 1:N:0:CGATGT\'	CAAACATCTTTACCATCACCATTCAAAACAATACTTTTAGCAAAAATAGAAGCTTCATTAGAAACCCTTTCAAGGTCCATTTTATATGCTTTTCCAATCAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16633:2184 1:N:0:CGATGT\'	CGCCGGGGGCGCACCGGACACCACGCGACGTGCGGTGCTCTTCCAGCCGCTAGACCCTACCTCCGGCTGACCCGTTTCCAGGGTGGGCAGGCTGTTAAACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16573:2198 1:N:0:CGATGT\'	GCGAGCTTTTACCCTTCTGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAGGACACCTGCGTTATCTTTTAACAGATGTGCCGCCCCAGCCACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16963:2025 1:N:0:CGATGT\'	GTGGTGTTTCATCTTCGGCGTTCATACAGCCTAAGATCGGTATTTCATCGCCGTCGATTGAGGTGTATATTGCTGGAATGTGTACGGATATGCCGGTTATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16896:2035 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAACAAAAAAACTTATGTTTCATCACAGCTTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16835:2043 1:N:0:CGATGT\'	CTTACTAGGAATTCCTCGTTGAAGACCAACAGTTGCAATGATCTATCCCCATCACGATGAAATTTCAAAGATTACCCGGGCCTGTCGGCCAAGGCTATAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16818:2056 1:N:0:CGATGT\'	TTGCAGCAATCTCATTGTGAGGAAGACCAGCAGCAGAAAAGAGAGGAATTTTCTGTCCTCTGGCAATTGAATTCATGACATCTATCGTGGAAATTCCCGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16884:2119 1:N:0:CGATGT\'	ACAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGCGTATCGCCGGCAGAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16782:2140 1:N:0:CGATGT\'	TTGCCGACTTCCCTTGCCTACATTGTTCCATTGGCCAGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACCGGGCGTGATCAGCACTCGGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16755:2145 1:N:0:CGATGT\'	CCGGTCTCGTCTGTCTGCTGCAACGGGGTCCGGAAGCTGAATAATTTGGCTTACACCACACCTGAAAGACAACTAGCTTGTGCTTGTATTAAGCAAGATAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16777:2172 1:N:0:CGATGT\'	ATGTATACAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGAAGCGTATCGCCGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16797:2177 1:N:0:CGATGT\'	ATTAAAATGTACAGATAATCACATATACACATACATACATCATTTGTTGCCTCCTTCCCCAATGAGATAAGAGTTGTGGGTGGGTCATGAGCGAGCAGGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16822:2220 1:N:0:CGATGT\'	CTACGAATCTAGGTTTGTCGCCCTGTCTGAGAACACTTCTGACACGCCTTGACATGCTTAAAAACTTGGTCACTTTTCTTCTAGAAGAAGCCTTGAAGGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16884:2234 1:N:0:CGATGT\'	TACCAGAGTTCAGACCAACATGACAGGCAAAAACATCCTACTATCATATTCAGACATGACAAGAACGTACAAGATTATTACATCAGCATCCGCTACTAAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16805:2234 1:N:0:CGATGT\'	CCTTTGCAACCGCTCCTCGAACAGCTTCACCCAACTTAACCGCCTTTTTCCTCATCTCGAACCCTTCATCTGACATCATCAATGTCCTCACCGCATTCTCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:16827:2238 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGCCGTCTGCCTTATAAACCAAATTACTCAAATTAGTACCCTTTTTCCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17215:2009 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAATACAGTACACGAGAGTAAACTTTGCAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17108:2028 1:N:0:CGATGT\'	GGGAGCAGGAGTGATGCCAAATGCGGTGAACTCGTCAAGTACTGTTATCGGCAAGTGCCATTGTTTTGTATCGAGTTGTCAATAATCAGAATTGCTAATCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17201:2040 1:N:0:CGATGT\'	TTTCGCTCGATCCTGAGTGCGGAGCCTCACTTTTAGAGTCATTACCAGATGATGCCTGGGTCGAACCTTCTTTGCCGAGGGAAACCTTTCCAACTTCATGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17003:2082 1:N:0:CGATGT\'	GTATGATTAGAGACTCGACTAGTCACTATGGCAAAAGGACTAGAAGTGATGGAGATGGCATCTCTATATTTCAATCTTCAAATATTTGGATTGATCATTGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17102:2145 1:N:0:CGATGT\'	CTTGCATTAGCCACAGAGACCTTCCATATCCCTGCATGTTAAAGGCAACCATCTGAGCCCCATGCATCCACCCAATGAGAGGGTTGTAATTCGATGAGGTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17165:2174 1:N:0:CGATGT\'	CCACTGTTGTTGCTGTTACATCTGATGCCGTTGAAAATGTCCTTGTTGATGATGATCTGACGGCTGCTGTTGATCCTTTAATCAGACAGGTTGCAGCTTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17098:2197 1:N:0:CGATGT\'	CTGGCAGTATCTGGTCGGAAAAAGAAGCTAACTGGTCGGAGATTAACCAGTTGTTTTTGTTCTTGAGCAAACGTATTTTTGATCAATCTTGGTTCATACAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17019:2199 1:N:0:CGATGT\'	GTGTAATTAAGCAATGGGTAAAGGTCTTACGATCCACTAAAGCCCATACATACCAACAAGGCAACAACTAACTTGGTACATGCCTCAAATAGTTTTATTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17147:2221 1:N:0:CGATGT\'	TAGGAGAGGAAAAACGAAAGAAAACAAAAAAGGAGAAAAAAATCGAAAAAATGCAATCTCCGAGAAATCGAACCGCGAAAAAACGCCGATCTCGAACAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17353:2012 1:N:0:CGATGT\'	TGGAATTCGTCTTTGGGAACACATTGATCCAGATCTTCTTTTGGCTGTATTTCTTCCGGCTCTTCTGTTTGAAAGTTCATTCTCTATGGAAATTCACCAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17275:2089 1:N:0:CGATGT\'	GCTGATCTTTTCTTTGCTTCTGTTAACCCCAAAAATAAAAAATAAAAATACATGATATGATGGCAACTCCTTGTCCTTTCTGAATTCTGCCACCTCTCATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17336:2105 1:N:0:CGATGT\'	CTTTTGGTTCCTTCCCCTTTCCTTCTTTGGCTTTCTCCTTTTCAGCCTTCTTCAACTTCTCCTTATCTTTTGCAATTTCCTTCTCAACTTGCTTGTCTGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17408:2114 1:N:0:CGATGT\'	CACACCAGCATTCAACATGCGCTTTCCCTCATCTGTAGTTGCAGCTTCATCATGGTATTCGTACTGCTCTTTCTCAGTGCCATCCGTAGCTACCCATCCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17251:2114 1:N:0:CGATGT\'	GGGCAAACGGCACGAAGGAGATAAGAAATAGATAGGGAATGTCTGATGAAAAATACATGTGCCATTGGAAGGAATCAACCAATGTTCTCTCTTACTTCGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17365:2118 1:N:0:CGATGT\'	CAGTTGCACTAAACTTAGCCCAGTTGGTGGCCCTGCTCAGCCAATCCAAATTGTCCCGCAAAAATGTATCAACAGTAGTACCAGCATGCATAATTGCATTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17457:2144 1:N:0:CGATGT\'	CTCAACTTGAAACCCGATTTTCTCACCCAGTTTTACCAACTGATCCTCATTGGTTATCGCCCTAGATCCGTTCCTTGATAGAATGACAATTTTAGGCTTAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17467:2172 1:N:0:CGATGT\'	CTCTTTTCCATTACTGTCCTCTCCTGACACATTTGGCACCTTGATTTCAGGCTCTTGGACCTCATTCTTCTTGGAGTCATCTCCGGAGGACTTTTTCTTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17646:2110 1:N:0:CGATGT\'	TATCACCAACCATCAACTTCAAGATACTAATTGTGTTTTACAACAACAGGGAACACAATGGATGAATCCGAAGTTACAATTAAATTGACCAGGAAAACAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17694:2180 1:N:0:CGATGT\'	CCCGAAGTTACGGATCCATTTTGCCGACTTCCCTTGCCTACATTGTTCCATTGGCCAGAGGCTGTTCACCTTGGAGACCTGATGCGGTTATGAGTACGACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17867:2050 1:N:0:CGATGT\'	CCGGATTTTTCACAAGAACGTCAACAACAATATCAGCTCTATGAAGGTCAATGTGAGGAAGATGAATCCCCGAAATATCTGCAGTTGGCTTACCGAACCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17967:2191 1:N:0:CGATGT\'	GTCCGAACACGACGGGGCTCTCACCCTCTCTGGCGCCCCTTTCCAGGGGACTTGGGCCCGGTCCGCCGCAGAGGACGCTTCTCCAGACTACAATTCGAACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17936:2194 1:N:0:CGATGT\'	CAGGGAAGTGATGATGATGGGGCAGATGATGGTGATGTATCGGAGGAAGAAGAGGACTCGGGGGTGGAGTCCCCTGTAGTTGAAAATGGGCTCGGGTTGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17949:2234 1:N:0:CGATGT\'	TTAAAGTTTGAGAATAGGTCGAGGGCATTGCACCCCCGATGCCTCTAATCATTGGCTTTACCTGATAGAACTCGTTTAGAGCTCCAGCTATCCTGAGGGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:17992:2243 1:N:0:CGATGT\'	TCGCTGATGTTATCGCCTCAGCTTGCTGTGACGGCACACCTTGTGCCTCTAAGCTCTTTACAAGAGCGAGAGGATCGACAAGAAAAGCACGTTTAGGTTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18196:2037 1:N:0:CGATGT\'	CTTGGTGTTATTATCTAGAATCCAATCGGAGGATCAAATGATATCCAACCGTTCAACTTGTTCTCGCTACTTGCCATTGCATACTGATACTTATCATCCAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18027:2114 1:N:0:CGATGT\'	GTTCTGTGATAAGATGCCTGTGAAGATGACCTATTCCTTTGGTTTTCCCTTGCAAAATGACGATGACCCCTTCGCATTGCAGCAGCTGCAGCTAAATGCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18140:2188 1:N:0:CGATGT\'	TGTACTCGTGCTCGTTAACACCAACAACGAACATAGGAGCATCCTTGCTGGGAGCAGAGATGATAACCTTCTTGGCACCACCCTTCAAGTGAGCAGCAGCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18151:2229 1:N:0:CGATGT\'	CACTCCCGGAGACTGGGTTTCCGTTGCCCTCACAATCCACGTCAGTCCGCACCCCGAGCCGATCGGCGGACCGGATTTAGGCCGTTCCGCATCCGACCGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18205:2249 1:N:0:CGATGT\'	CGGGAGGGAAGCGAATGGGGGCCGGCGATGTGCCTCGGTCGGATGCGGAACGGCCTAAATCCGGTCCGCCGATCGGCTCGGGGTGCGGACTGACGGGGCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18377:2005 1:N:0:CGATGT\'	NTTCGCTTCCCTCCCGACAATTTCAAGCACTCTTTGACTCTCTTTTCAAAGTCCTTTTCATCTTTCCCTCGCGGTACTTGTTCGCTATCGGTCTCTCGCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18312:2015 1:N:0:CGATGT\'	CCGAAGCGACAAAGGGCTGAATCTCAGTGGATCGTGGCAGCAAGGCCACTCTGCCACTTACAATACCCCGTCGCATATTTAAGTCGTCTGCAAAGGATTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18277:2040 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTATCATTAGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18386:2074 1:N:0:CGATGT\'	GCGGGTCGAGCCACCCTGATTCGGAAGACCTTGTCAAGGACAACTGGTTCGAACTCGGTCACTTCAGATGATGGTGGTGGTTTGGTGGGTTTAGGGGCTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18495:2107 1:N:0:CGATGT\'	CCTGTACGCAAGGGCAGGATGGCGGGTATTCAATCATGAGGAAGAAGCTCAATACCATGGACAATAAGACCCGACTTATAAGAGCTGGTATCCACACCAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18353:2150 1:N:0:CGATGT\'	ATGAGATTTTCAGGATTTTCGCCTGTTTCTTCTCGTCCTCGCTGAATGAGGTATCATAATCAACAAACTTCACAGCCTTTTCATATCTCCTAGATGCCCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18265:2154 1:N:0:CGATGT\'	GGTCTTTATAACCATTGAACTACCCGATGCAAAAGATGTGAAGTTGAAGCTTGAACCTGAAGGCAGATTCTGCTTCTCAGCCATGAAAGATGGCAACCCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18461:2195 1:N:0:CGATGT\'	CGTTGCTCTTGTTTGCGCAATGTCTCAAACTTTTCCACGGTATCAATATCAATCTTATGCTTTGTCTTTGGCTTAGGTGGCTCAAAAGGGCAGGTCAGAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18346:2203 1:N:0:CGATGT\'	CCCTTCTGTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAGGACACCTGCGTTATCTTTTAACAGATGTGCCGCCCCAGCCAAACTCCCCACCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18377:2221 1:N:0:CGATGT\'	AAAACAATCACAGTAAACAAAAGCACAACCCTAATAAACTGAAACAAATAAAACAACACATCCCAACCGTGCGGCGATCCTGTAACCTTAACAAAATGTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18465:2238 1:N:0:CGATGT\'	GCGAGTTATCATGAATCATCAGAGCAACAGGCAAAGCCCGCATCGACCTTTTATCTAATAAATGCATCCCTTCCAGAAGTCGGGGTTTGTTGCACGTATTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18403:2245 1:N:0:CGATGT\'	ACGGAACTGGAATTTGTCATTCCATTGTGGGCAATTGTCGCCGTCTTGGTCGACCCGCGTCCGTAATTTTCGGGCCGGGTCGATCCATATCACGGCGTAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18321:2246 1:N:0:CGATGT\'	CCGTTATTGTTGATTGCTTTTTTTTCTATCCTTTTGTCCTTGAGTAGAAATCGTACTATCTCAGGTTGTTTAGCCGCAACAGCTAGGTGCAAAATAGTATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18516:2009 1:N:0:CGATGT\'	ATGATCTTACAATATATATCATTACTAACATGTTAAAATATAAAAGCCTTACTTTTATCTCTCAAATTGAGAGACATGTATTATTATTATCATAAGACTAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18576:2016 1:N:0:CGATGT\'	CCAATGATCAAGTCGGGTTTGGCTTGCAATTCTGCTGAAATCTCATTTGCAACATCCTCAGTGTAAGTCTCAAGGTATGGCCAGACTTCGAACCTGGAAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18575:2089 1:N:0:CGATGT\'	CCGACACCGGAAATATATGAATCGCCGAAGGTTACTTCGAACTTGGTTAAGAAAAAGGAGACTTTGCAGATACCGCTTTTGGACATCAATTTTCCTCCAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18722:2154 1:N:0:CGATGT\'	GAGAACAACCATTCATGTGCCCTGGTCTTAGGCACAAGGAAAATTCCACAATGATACATGAATGATTTAGAGTCTGATTGAGCATCTAGAAGCACAGCCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18607:2157 1:N:0:CGATGT\'	CAGGTCTCCAAGGTGAACAGCCTCTGGCCAATGGAACAATGTAGGCAAGGGAAGTCGGCAAAATGGATCCGTAACTTCGGGAAAAGGATTGGCTCTGAGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18645:2191 1:N:0:CGATGT\'	CTAGACCCTACCTCCGGCTGAGCCGTTTCCAGGGTGGGCAGGCTGTTAAACAGAAAAGATAACTCTTCCCGAGGCCCCCGCCGACGTCTCCGGACTCCCTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18603:2230 1:N:0:CGATGT\'	GGCAGCTAATGTCATCGGCGCTGGGAACTCCCTCAATGTATCAGCCTGAAGTACAATACTGGCTGACAAAGCAAAGACGGCTCCCATTAGGCATAAAGCAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18935:2082 1:N:0:CGATGT\'	TCGTGCTTTATCATCTAACGGTAATTCATCTCCCGCCATTTTTAAAATTCCGAATCTGAAGTTCAAGTTGGGGGAAAATTAGGGTTTGTTAAATGAAATTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18852:2128 1:N:0:CGATGT\'	GAGATTACTAAAGCAGAACTGTGGATGCTGAAGTCAGCTGGTGTTCAGTGTGCTGGGAGTCCTTGTTTTTGGGTGGACTCAGATGGAACCTATCAAGAAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18955:2133 1:N:0:CGATGT\'	CCAAGGTCCAACTACGAGCTTTTTAACTGCAACAACTTAAATATACGCTATTGGAGCTGGAATTACCGCGGCTGCTGGCACCAGACTTGCCCTCCAATGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18895:2134 1:N:0:CGATGT\'	CCAAGATCGACAACCCTAAGTGTGAGGAAGCACCTGGTTGTGGAGAATGGAAGAGGCCAATGAAGAGGAACCCAGCTTACAAGGGCAAATGGCACGCTCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18932:2147 1:N:0:CGATGT\'	CGGGGGGTTTGAATGGATAATCTGGGGGGAAGTGAATAGTGACAAGAAAAACTCCCCCAGCATAAGGACTGTCAGGAGGACCCATAATAGTTGCTTGCCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:18940:2212 1:N:0:CGATGT\'	GCCAGTGTGATTGAAGCTTATTGTTCGAACTGGCCACCTGAAGTCATACAAGTCATTAGCAGAAGAAGAAACCAGAACTATCAAGTTGGAGGCACATGCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19123:2066 1:N:0:CGATGT\'	CGAAAGACCAGCTGCTTGAGCGCTTTACTGGATTTGTTCCAGCAGACTCAGAACCGCTGCTCGAATCAGTTGAAGTTGAAGCGTTTCTGCAGTAGTTTGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19048:2096 1:N:0:CGATGT\'	CACAAATTCTCCCAGCACATATTTGTTGCCTTTGAGTTCCAGCCTGTCCCAGATTGGAGCAGTAGCAAGTACAAAATGAAGGTGTTGGTGAATAGGGTCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19200:2106 1:N:0:CGATGT\'	GTGGGTCCATTGGTCCCTTGAAAGGCCTTCTTTAGGTACCCCTTTTCTAGCCCAAGGTTCTCACATAACAAGTCCAATAATTGCTCCGCTAGCTCCTCTAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19015:2178 1:N:0:CGATGT\'	TTCTTATTCGGCGAGGTACTAATAACCGTAACCTTAACACCAAACGCCTTAGCAAATTTCACCGCCATATGACCCAACCCACCTAATCCAACCACACCAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19029:2191 1:N:0:CGATGT\'	ATAAAGAAGATCTGGCCCCGGAAAGCTCATCTCGATTAGCAAAATGGAAATCGGATACATGTTTTCCGGCATTGGCACCACCGCTTCTATGGGTGGGAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19188:2219 1:N:0:CGATGT\'	GCCAACATTCACTGTGGGTGGAAACCAGGAGTTGCTGATGGTGGTGCTAATGTAAGCCCACTTGGATGCCACTCTGGAATCAAGTCCCATTATTCCCTCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19129:2229 1:N:0:CGATGT\'	CCCGTATGTGGTGAGAACAACATTACTTTGAGCTAAAAGTTCAGCACCTTTTGATCGACCTTGTCCATAATAAACACAAACAGACAAGGAACCAGGCTGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19008:2243 1:N:0:CGATGT\'	GGACAGCACTCCCGGAGACTGGGTTTCCGCTGCCCTCACAATCCACGTCAGTCCGCACCCCGAGCCGATCGGCGGACCGGATTTAGGCCGTTCCGCATCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19345:2002 1:N:0:CGATGT\'	NAAAGATTTGAATCTAATTCCCCAAAGCTTTCACCCTCAACATGACAACTGACGATGCTCATCTCTGGTTCTTCAAATACAACAAAGTCCAATCCCTTAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19484:2020 1:N:0:CGATGT\'	CTGAATAGAATGTACCGAAAGAAAATGTAACTTACTTGTTGGAGTTGGAGATATACATTGAAAAACAGTAGCTTATTACTTTCACATCCTTGGAGGCCATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19352:2040 1:N:0:CGATGT\'	TGCGCATTAAAGTATCCAGATCGGTTCCCGTTCCAGAAGAATGTCACATGTCCAAACTTGACGGTTTCACTGCAAGCAAAAGTGCGTACACCATTGTGAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19269:2085 1:N:0:CGATGT\'	GCAGGAAAGATTATCAATTTGATGCAATGCCTCATTCCCATTCCTATTGATTGCGAAACAATAGGGTATGAGGGTACACAAGCATCACATAACAAATACAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19328:2116 1:N:0:CGATGT\'	GTGGAGGGCAAGTCTGGTGCCAGCAGCCGCGGTAATTCCAGCTCCAATAGCGTATATTTAAGTTGTTGCAGTTAAAAAGCTCGTAGTTGGACCTTGGGGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19393:2128 1:N:0:CGATGT\'	CCAGCCTTGGCAGCTCCAGTGCTGCTGGGAATGATGTTAAATGAAGCAGCCCTTCCACCTCTCCAGTCTTTCATTGATGGGCCATCAACAGTCTTTTGAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19290:2185 1:N:0:CGATGT\'	CTAGCTTGCAACCTCTTTACAATCTCATATTTGTGCTCAGGGAAAACGCCCGCGAATCCATCAGCTTTTTCTATCAGATCATCGATTGGCAAAGCAGCAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19742:2005 1:N:0:CGATGT\'	NCGATTTGTCTGGTTAATTCCGTTAACGAACGAGACCTCAGCCTGCTAACTAGCTATGCGGAGTCACACCTTCGCAGCTAGCTTCTTAGAGGGACTATGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19574:2071 1:N:0:CGATGT\'	ACAACCAACACAAGCGCGCTAACATCCCTCAAAAAAACAAGGAAAACTATGGAGAATCATCAACCAAAGGTCTCCGAAGCTGCTGCAGCTCGTTGCTCATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19604:2085 1:N:0:CGATGT\'	GGTTTTTGTTTTGAAGGGAAAATGAGTGAAACCCAGAAGTAGAAATGAAGTTAGACGAAGAAGAGCTGAGTTTTGAAGCAATGCACGTAAGGCGTTTGTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19690:2092 1:N:0:CGATGT\'	GCCAGACAAGAGATCCTGGTATACGAGCATGATTGATGGAGTTGAGTGAGATTTCTCTCTCTTCGACCACTTCCTTGTTCCTCGCTGAGGAGATTTAACGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19738:2097 1:N:0:CGATGT\'	TGGGTGGTCAAGGTCCCTCATCTGTGGCAGTGGGTGGTGCTGGGGGTGGTGGTGCTGGTGGGTATAGTGCTCCTTTAGGCGGGGCCTATGCTGGGTCTCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19502:2102 1:N:0:CGATGT\'	TGGGTTTCATTTGCAGGTACATGGGTCGCACTTGCAGTTGTCTCCGCACTTGCATCCTCCGTCCTCTCCACTCATTCCCATCTCTTTGTTGTCCACGTACG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19531:2128 1:N:0:CGATGT\'	GGAAACGTTCACGTTGTTTGCGCCGAGTTCGAGGTACGCTTTGTGGGACACTGAGTGTCAACTGCCCCAAAAGTGTGGGGAGTTGGGGCTTTGTGAGGATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19669:2166 1:N:0:CGATGT\'	CCCGACTGTCCCTGTTAATCATTACTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATAATGTTATCCCATGCTAATGTATCCAGAGCGTAGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19664:2187 1:N:0:CGATGT\'	ATACAATTCCATATGGTGCAACATGACCAATAACAAAGCACAACAATGAAAAGAAGGATAGATAATTTAGAGACAACAGTGCATCCAAGTAAATGATACAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19595:2241 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGAGGTATCTCGCATGCCGACTTCTGCTTGTAAACTAGGCACTAGGCATGGTAGTTGCCTCCATGCGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19893:2049 1:N:0:CGATGT\'	CATGAATCATCAGAGCAACAGGCAAAGCCCGCATCGACCTTTTATCTAATAAATGCATCCCTTCCAGAAGTCGGGGTTTGTTGCACGTATTAGCTCTAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19944:2061 1:N:0:CGATGT\'	CCCCGGCCGGCACGCAGCAACCCGCTCTCGCCGCGCGAGCAGCTCGAGCAGTCCACCGACAGCCGACGGGTCGGGGAAGGGGACCCCCCCCGCCAACCCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19859:2062 1:N:0:CGATGT\'	ACTTTTCGGTTTACCTTCAGGTATGGCAAAGCACCGATCACATTATCATAGTCGCTCCTATTGACTTGGACCATCTTAGATAAACGCAATTTGCGCTTAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19823:2093 1:N:0:CGATGT\'	CTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATGTGCAAGTGCCGGTCACATGGAACCTTTCCCCGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19896:2109 1:N:0:CGATGT\'	CAGCGATCTCTTCCCCAGGTTTCTTCGAATCAAGAACTCGACATATCGTCATGGCCAGTTCATCTCGTGAAAGTTGTGAGGCAGTTCTTTGTACTATTTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19919:2123 1:N:0:CGATGT\'	ATAGTAATCAATGTTTAATGTCATACCCGACAATGACCACAGCTCCAGCTTTCCCCTTGAGCATACTCTTCCCATGGCGAACAACGGCTGTGAATCTTTAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19881:2132 1:N:0:CGATGT\'	CCGGACACTTCACCGGACCATTCAATCGGTAGGAGCGACGGGCGGTGTGTACAAAGGGCAGGGACGTAGTCAACGCGAGTTGATGACTCACGCTTACTAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19765:2133 1:N:0:CGATGT\'	CCAGTAACGGAAGTATGAATCTCGATATGATCGGTTTTCCTTTTTTGTAGACGACTTTGGCTTTTTGGAGGATCGTGGAGCTGATACTTTTTCTGGGTATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19780:2149 1:N:0:CGATGT\'	CACCACTTCGCTGAGGACTCACCCCATGCAATTCGAAGTACAAAGTTGAGCCTAATCGAGTCTGAGATTTCTCATCATTGTCCTGTGTATCAGATGGAAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19887:2173 1:N:0:CGATGT\'	CCCCACCTGACAATGTCCTCCGCCCGGATCGGGCCCCCGGCGGGGGGGCAGCCGCGGAAAAAAAGGCGGGGGGCGGGCCCCCCCTCCCCCCCGACATGATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19912:2174 1:N:0:CGGTGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTACGCCAATATCTCGTATGCCGTCTTCTGCTTGAAAAGAAGGAAGGAATTTGCCAGCAAAAACCAGGGGAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19757:2182 1:N:0:CGATTT\'	CGAGTCAGACGAACGATTTGCACGTCAGTATCGCTTCGGGCCTCCACCAGAGTTTCCTCTCGCTTTGCCCCGCCCCCGCATAGTGCACCCTCTTTCGGGTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19929:2184 1:N:0:CGATGT\'	GCCGTAGCGAGAAAGGTCGCTCCCTGTTGGGGCGAGTAGGTGAGGCCCCTGATGCATAAGAGAAGTGAAGGCATCCTTGGGCAAGCCAAAACCAAGGGCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19945:2225 1:N:0:CGATGT\'	CTTGGCCGACCACTCGTCGCCGGATTTCTTGCATACGAATGTGTAAACACCCATTGCCGGAGATAAAGGAGATGGGACGAGAGAGTTGTGGGTGTGAGAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:19876:2236 1:N:0:CGATGT\'	CCTCTGTATGTCAAGGACTCTTTACCGAAGCCAGCAAGATGTGGTGCGAATGGCATCATCCATGAACCCACAAACCAAAATGAAGCAATCCATAATAGCAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20218:2007 1:N:0:CGATGT\'	NCACTCATCAAAACCAGTATCATCAGCATCACCAGTTTCAGCAGGCAAACGGGTACCATGACCACTATAATGAACAAAGAGATAATCACCAGGCTCAGCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20219:2030 1:N:0:CGATGT\'	CGCCAATCTCCCTCATGGTGTCAAAATATTGGGTCACCAGGACCATGTCCATGATGTCCTTGGCAGTAGTGCCGGGCACATTCTCAGAGAAGTTCAGCACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20126:2038 1:N:0:CGATGT\'	CTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGCGTATCGCCGGCAGAAGGAGCAAGACGACCGGTGCACCCCGAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20224:2057 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAGACACAACATCAGCGTCAGCGATGTCACGCTCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20187:2074 1:N:0:CGATGT\'	ACGGGGGTGATCTAAGAATACAATAGATATGGGGAAGGCTGTTGTTGTTCTTACCAGCAGTGAAGGTGTCACTGGAACTATCTACTTCGCCCAAGAAGGCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20034:2136 1:N:0:CGATGT\'	ACCAAGATCTGCACCGACAGCCGCTCCGCCCAGGCTCACGCCACAGGTTTTGCGGCGACCGCCGCGCCCTCCTACTCATCGGGGCCTGGTACTTGCCCCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20097:2206 1:N:0:CGATGT\'	TCTCGCTTACAGACCAAGCCGACCCTTCAATGTAAATCTTGTATCTGTGTATGCATTGATGTGACAAATCAGACTCCTTGAATCCCTGCCGCACTTCTTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20194:2243 1:N:0:CGATGT\'	ACAAAATTGTAATCAGGACTTCTCCAGTATGTCCACCATTGTTTCCAAAGGCATGATTTAAACTGACCCCATGTTGATTGGGCATATTGGGTTGGAAAATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20400:2056 1:N:0:CGATGT\'	CGAGAGAGCAGAGAGCGAAGAGAAGGGTCGTTGTCGATGAACGAAGTGAGGAAAACGGTGCCGTTTTCGACGAGGGGACGGAAAGAGAAGAGAAGAAGAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20337:2063 1:N:0:CGATGT\'	GGCCAAAGTACTTGTCTCCGACGAGGCTCGTAAGGAATTCTCTTCTCTCCGTCGCACTTTTGACGAAGTCAACCTCCAACTCTCCACCAAATTCTCTCAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20324:2103 1:N:0:CGATGT\'	ATTTTATAACAAGGGAGGGTTTGTTTGGATGGAGTATTATTTTACAAGAGGGAGTATCGAAAATACAAGAATGATAAGATGAAAAAAAAGGGGGTGAGGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20468:2122 1:N:0:CGATGT\'	GTGGCTTACTTGCATCATCATGGCTATGAGGATAAACTTCCTTGGTATCGTGGAGAGGAATGGAACTACCTTCGAGGAGGTCTAACAACGCTTGACCGTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20357:2123 1:N:0:CGATGT\'	GTGTAGTGCTAGTAGTAGATGGAGAATTCTCCTTTTGTTTGCTCTCAAAAAAGGTTGATCCTTTCTTGCACGCTTAGCCGTCTTGTAAGTTTAGGTGTCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20336:2159 1:N:0:CGATGT\'	GACCCTGTTGAGCTTGACTCTAGTCCGACTTTGTGAAATGACTTGAGAGGTGTAGCATAAGTGGGAGCTTCGGCGCAAGTGAAATACCACTACTTTTAACG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20434:2160 1:N:0:CGATGT\'	TGGCATGGACATCTAAACACATCTTAACCATGAAAGTCCGCCTTGATGAACAGAGAGTTACGAAGGCGGCCTCTCTAAGCAAATTCCTGGAAAGAAGTTAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20461:2182 1:N:0:CGATGT\'	CACCGGTCCAAATTCGAAGATCCTCAATAAAATCATCAATATTTGAGTTGTTTAAAAAAGAAATGGATTCGATAACCCTGTCAAGATCCTTGGTAGAATAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20357:2188 1:N:0:CGATGT\'	CGCGCGGCGAGAACGGGTTGCTGCGTGCCGGCCGGGGGACGGAATGGGAACGGCTCCTTTTGGGGCCTTCCCCGGGCGGCGAACAGCCGACACCGAACTGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20591:2043 1:N:0:CGATGT\'	GGGGGATTAGGTTTCTTGTATACTGGCACGGGTGGTGGGAGCGGTTTCTTGTATACTGGCACGTGTGGGGGATTAGGTTTCTTGTATACTGGCACGGGTGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20578:2077 1:N:0:CGATGT\'	CTCAGATTCAATTTGCCTTGCACTACATCTATTCTCAGGCAATGCTCGATACTTGTCAACTTCATACAAGTTGGCCACTTGCTTCTCTTTCATGGAAGCAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20607:2118 1:N:0:CGATGT\'	TTTTATATTTATATAAAAACTATTATTTATATTAGAATAAGATTATATTTTCAAATTCATGATATTCTAAGATATTCTATTCATCAGTAATGTTGATGATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20616:2168 1:N:0:CGATGT\'	CCGTCGTGTTCGGACCCTGTCGCACCATGAGGCGCTGTCGCCGAGTCGGGTTGTTTGGGAATGCCCCCAAGCGGGCGGTAAATTCCGTCCAAGGCTAAATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20577:2231 1:N:0:CGATGT\'	CCCATGTGCAAGTGCCGTTCACATGGAACCTTTCCCCTCTTCGGCCTTCAAAGTTCTCATTTGAATATTTGCTACTACCACCAAGATCTGCACCGACGGCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20990:2014 1:N:0:CGATGT\'	CCTCCTTGTGAGGATTATCTCCTTCTTTATGACCTCCAATATTGAGTTTCTCCTGTATCGTGTGAATAATGCCTGCCATTTTTGTGTTTGTTTTAATTTGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20856:2054 1:N:0:CGATGT\'	TCTCAGCACAAATCTCAGCCTTGCACACAATCCTTGTCCTTGCAAGGATCTCGCCATACTCTTCATACAAAGCAGGATCAGAGTCTGTACGATTATCAATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20967:2118 1:N:0:CGATGT\'	CTCAGGCATAGTTCACCATCTTTCGGGTCCCGACAGGGATGCTCTCACTCGAACCCTTCACTGAAGATCAAGGTCGGGCGGCGGTGCACCCACAGGGGAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20969:2158 1:N:0:CGATGT\'	ACCGGATTAAACCCACATGAACCAAACCGGGTTCTCCATTGAGCCAAGGACTCGTGCCTCTCGAACCGGTCCACCCCTTCACATGCCACTACATTGCAAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:20982:2239 1:N:0:CGATGT\'	GTCCGTACCAGTTCTGAGTCGACTGTTCGACGCCCGGGGAAGGCCCCAAAAGGAGCCGTTCCCAGTCCGTCCCCCGGCCGGCACGCAGCAACCCGCACTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21175:2092 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAATAAAACAAAGAAGATTGACAACAGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21165:2213 1:N:0:CGATGT\'	CCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAAACCATGTGAAAGTGCCGTTCACATGGAACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21082:2225 1:N:0:CGATGT\'	CCTATCTCATTCCTCGGGCCATTTGTTTGACCTTGTTCAGGGGATCGACTGCATCTCTGATGATTACTACACCTTCAGGGCGCAGAATTCGGTCCATTTCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21359:2032 1:N:0:CGATGT\'	GTTCTACACGAGATTTCTGTTCTCGTTGAGCTCATCTTAGGACACCTACGTTATCTTTTAACAGATGTGCGGCCCCAGCCAAACTCCCCACCTGAAAATGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21318:2062 1:N:0:CGATGT\'	GTGTTTTCCTTACATTGTCAGGAGTAAAACTATTGTTTTGCGGAGGAACACTTGTGGCTTTCCTGGCAGAAAGTCGCAATGTCATACAAGCATAGAAATCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21283:2071 1:N:0:CGATGT\'	TTCTGCTTCACAATGATAGGAAGAGCCGACATCGAAGGATCAAAAAGCAACGTCGCTATGAACGCTTGGCTGCCACAAGCCAGTTATCCCTGTGGTAACTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21330:2113 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTTTGCTTTTAACAAAAGTGAGATATTTTATTGTACCGAGAACAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21259:2196 1:N:0:CGATGT\'	CTACCACATCAGAATGGGGTGGTGGTGGAGGTGGTGGTGGAGATGAAGGGAGAGCATCCTGAATCTGCTCCGGCTGTGTATCTGGTGGTTGACCAATTGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21383:2211 1:N:0:CGNTGT\'	CTAGGAGTATAATAACCATAACACAAACCATAATTTAAGATGTGCCACAATTTGCACAAGTTCTATGTACATTGCAATAAGAAAGAACCAATCGAAACATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21345:2221 1:N:0:CGATGT\'	TCCAGCAAGAAGCAGAAGGTATTGAACATGTCGACCAAGTAGAAATATAGCATAATATCGATCATTCAATCTTTGGACGGCTACAATATGATCTCCTCTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:21377:2241 1:N:0:CGNTGT\'	AGGGAATCGGGTTAAAATTCCTGAACCGGGACGTGGCGGTTGACGGCAACGTTAGGGAGTCCGGAGATGTCGGCGGGGGGCTAGGGGAGAGTTATATTTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1376:2265 1:N:0:CGATGT\'	GGAATGTAGCATGCTCATCGGGTCCTGCACAATATTTGCAACCAACGGCTTTGCAGTCCGCGTCAAATAAGCATCGGACTATGGTTTCAGGGCATGTTATA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1418:2308 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAACAAGATAAGTGAATGCGCTTTGCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1340:2313 1:N:0:NGATGT\'	CTTGAACCGATGNCCACTTAGAACATATTCCACANTGGCAGGAAGCCTCCTACTACGTTGCAAAAATGGCAAAAAGTCTTTCGTCTTCTTTGCTGATGCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1416:2391 1:N:0:CGATGT\'	CTAGGAGAAACAACTCCGGTTGAAAGGAGAAACATGGAAGGCCTGATAATCGAGCAGTATTTCGCCTCTCTGAAACTTCTATTTTGTGGTCCTAAACCTAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1465:2404 1:N:0:CGATGT\'	CTTTGCAACCGCTCCTCGAACAGCTTCACCCAACTTAACCGCCTTTTTCCTCATCTCGAACCCTTCATCTGACATCATCAATGTCCTCACCGCATTCTCTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1722:2250 1:N:0:CGAGGT\'	GTCGTCAGCCAACGTGAGAGTGTCAAAAACGATAAACCAACCATCAGCATGAGCCTGTCGCATTGCATTCATCAAACGCTGAATAGCAAAGCCTCTACGCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1618:2272 1:N:0:CGATGT\'	CTCATCACCAGCAGGCCATTTACACAACCTAACAATCCCACACTTTATTGAATTCCAAATTTGCCCTTCCCTCTCTTTCTTCCTAATTTCTCTCTCTTCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1610:2301 1:N:0:CGATGT\'	GACTTTTTACCTTATTAGCAATGGTTTATGAAACAAATCCATTTCGATTAAGCAAAGTCTATTATACCAAAACGCAGCCTCTTCACAGGTGCTTAAGCCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1646:2427 1:N:0:CGATGT\'	CAAAAAATGGGGCTGTGCCCCGCCTCCGACTCACGGAGTAAGTAAAATAACGTTAAAAGTAGTGGTATTTCACTTGCGCCGAAGCTCCCACTTATGCTACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1624:2439 1:N:0:CGATGT\'	CCACCATTGACGGATAGATTCAAGTATTTGAGCTCGGTGAGGTCTTTGAGGTCTGATGGAATGGTGAACTGACGAGTACTGGATCCAGCAGGGTCTAGTCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1880:2270 1:N:0:CGATGT\'	GCTTCTTCTACTGTTCCCCAATCAGTGCTGTAAACTAGTAAATATCCTTAAAATTAAACTGTAACTCTGATATCATCACAAATTCAAAACAGCAACGTCTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1755:2270 1:N:0:CGATGT\'	CTTTGTTTTAATTAAACAGTCGGATTCCCCTTGTCCGTACCAGTTCTGAATCGACTGTTCGACGCCCGGGGAAGGCCCCAAAAGGAGCCGTTCCCAGTCCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1877:2290 1:N:0:CGATGT\'	CCTTCTTGTGATATAGTTGCCGGATTCCAACAATTTGGAGTTATACTCTGCAAAAAACCAATCATAATTCTTTGAAAGAAATTCAGAAACCGTGGATTTGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1838:2296 1:N:0:CGATGT\'	AAGCACTCTTTGACTCTCTTTTCAAAGTCCTTTTCATCTTTCCCTCGCGGTACTTGTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1926:2308 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAACGTCACTGGTTACCATCCACCACACTCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1832:2325 1:N:0:CGATGT\'	GTCATTAACAATACCTAAATCACTACTCTCTTCGTTCGATTCAAGCTCTTCCGACTCCGATTGACACCTCGCCACTTGAAGAAAGGGAGAAGCGAGAAGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1920:2377 1:N:0:CGATGT\'	TTCACATTCCTCACTCTCTTCTCTCTCAGTCTTAAGCTTACATTATGGGTAAGGAAAAGGTTCACATTAACATTGTGGTCATTGGTCATGTCGACTCTGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1952:2406 1:N:0:CGATGT\'	CTCGCGGTACTTGTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTAGGGCTGCATTCCCAAACAACCCGACTCGGCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1825:2463 1:N:0:CGATGT\'	CTCTGATACAAGTCATCTACAGTCATTTTCCTTGAGTGAAGGCATTCCTACTAGGTTTCTTTTGACTTCTCTCATGTGAAACAGCAGGCATCTTTGATATC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:1970:2464 1:N:0:CGATGT\'	CTGGAATTCACAGTTAACCTGTGAACTGGGAAACTCTTAGCAGAGTCATCCACAAGGCTGATGATACACATTTTAAGACCCAGATAAGGCTTTTGCTACAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2008:2273 1:N:0:CGATGT\'	CCGATCAATATTATCAGTAGCCCTCCGAATCGCATGAGTCCGTATCTGGGTGGGGCGCATAGCAGTTTCAAGAGCAGAAAGACGGTGATCAAAAGACCCCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2231:2296 1:N:0:CGATGT\'	GATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAACATAAGAAAACGCAAGAACTCACGACCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2218:2416 1:N:0:CGATGT\'	CTAGAGTGGGCCCAGCATATGCTGGTAGGCCCCACCCGTAATCCAAGTACTCAAGAGTACATCCACCTCTAGTTATATCCGATACTATAAAGTTTCGGGTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2109:2446 1:N:0:CGATGT\'	CTTCAATTGAAAACCATGACTTCCAATCTTCTTCTTCATAGATGATCACATGTTTGAGCTTCGAAACGATCCGAGAGCCTTAACAACAGTTGCTCGTAGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2035:2476 1:N:0:CGATGT\'	CCGTCACCCGTCACCACCATGGTAGGCCTCTATCCTACCATCGAAAGTTGATAGGGCAGAAATTTGAATGATGCGTCGCCAGCGCAAAGGCCGTGCGATCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2266:2251 1:N:0:CGATGT\'	TACAAAACCATCCTAGATAGCTCGTCCGAATGCAGTTCCGTCACCTGCACTTCTAACCGGTAACCTGAAGTGAAGATGTGTACAAGCCAAATCCAGCAGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2330:2272 1:N:0:CGATGT\'	ACAGCATTCAATTGAGAGGATACATTAAATAGGCTTTATTAGTATTTGTAACCCTTTTCGAACAAGCTCTCAGAAGCTGCACTGATAGCAGGAGTTGCACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2332:2309 1:N:0:CGATGT\'	GTAACAGATTGCTGATAAAGCACACCACCAGCAATAGTAAGGAGAAGACAGACCAACCCAATAGGACTAGCATGTTTATCCCAAATAAACACATTAATAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2278:2356 1:N:0:CGATGT\'	CGCGGTACTTGTTCGCTATCGGTCTCTCGCCCGTATTTAGCCTTGGACGGAATTTACCGCCCGCTTGGGGCTGCATTCCCAAACAACCCGACTCGGCGACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2290:2383 1:N:0:CGATGT\'	GTGGAAACAACGCTGAAAGTTTCAACATTGAAACCTACGCTCAGAGAATGAAAGAGGATGATGAAAAGCGGCGCTTGTTCTGGGAAAAAGGACCCGATGTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2326:2404 1:N:0:CGATGT\'	GTTTCTGTAGAAGTTTATCCTCTTGTAATCTTGTAGGCCTTGTGGAAGTGTGACATTTCCTGGATCATCCATCCCTGTAATTCACATTTGAATTTATTACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2416:2417 1:N:0:CGATGT\'	GGGATTTCAAAATAGAAACTTCACAAACACGGTACCTACCTCCATATAGGTCGTAGTCATATATATGTTGCAGAGATTAGGACTTGCAAAATGCACGTAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2378:2439 1:N:0:CGATGT\'	ATACAAACATAGTTTCAAGGAGATAGGTGAGAGATCAAACTCACTCAACTCCCACCAAAGCCAACCTCTGAAACCTCCATATCCGAACGGTTTAAGTTGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2453:2476 1:N:0:CGATGT\'	GCGCCATCCATTTTCGGGGCTAGTTGATTCGGCAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTTCCATGACCACCGTCCTGCTGTCTTAATCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2477:2484 1:N:0:CGATGT\'	CTAACGTTGCCGTCAACCGCCACGTCCCAGTTCAGGAATTTTAACCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2261:2492 1:N:0:CGATGT\'	GGCATCGTTTATGGTTGAGACTAGGACGGTATCTGATCGTCTTCGAGCCCCCAACTTTCGTTCTTGATTAATGAAAACATCCTTGGCAAATGCTTTCGCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2528:2373 1:N:0:CGATGT\'	CGGGGGCATTCGTATTTCATAGTCAGAGGTGAAATTCTTGGATTTATGAAAGACGAACAACTGCGAAAGCATTTGCCAAGGATGTTTTCATTAATCAAGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2623:2391 1:N:0:CGATGT\'	TTGGTCTCGAAAATGAAAAGATTCTATAAAGCCTGGGGAAAAACCTCCAAGTATCGGCAGCATCAATAAGACATGTCAAAACAGATGCTAATAGCAACAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2739:2393 1:N:0:CGATGT\'	CCCATGTCAGGATTGGGTAATTTGCGCGCCTGCTGCCTTCCTTGGATGTGGTAGCCGTTTCTCAGGCTCCCTCTCCGGAATCGAACCCTAATTCTCCGTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2515:2434 1:N:0:CGATGT\'	TCAGAACTTGAACTTGCCGCCGATGTAAATGCGGCGCGAGCCGGTTTCGTAGCGGAACGGCAATTCGGGGAATTGCAGATAGGCCGACTGATCCGACTGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2532:2435 1:N:0:CGATGT\'	CTTGGCTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACTAATTAGATGACGAGGCATTTGGCTACCTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2563:2450 1:N:0:CGATGT\'	CCCTGTTAATCATTACTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATGATGTTATCCCATGCTAATGTATACAGAGCGTAGGCTTGCTTTGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2822:2327 1:N:0:CGATGT\'	TCTCCGGACTCCCTAACGTTGCCGTCAACCGCCACGTCCCGGTTCAGGAATTTTAACCCGATTCCCTTTCGATGCTCGCGCAGTCGCACTATCGGACGGGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2846:2359 1:N:0:CGATGT\'	GCTGAATTGAAGGCTGTTCAACAAATGAGTGAGTAGAAGCTTACGGTGAAGCGTGGACTCAGAAGTTGTGGTGTCTTTGCTCCTTCATAATCCCACAATCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2897:2365 1:N:0:CGATGT\'	CGGGTGACGGAGAATTAGGGTTCGATTCCGGAGAGGGAGCCTGAGAAACGGCTACCACATCCAAGGAAGGCAGCAGGCGCGCAAATTACCCAATCCTGACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2997:2373 1:N:0:CGATGT\'	CCGACGGCCGGGTATAGGTCACGCGCTTAAGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCAGGTGAGTTGTTACACACTCCTTAGCGGATTTCGACTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2976:2376 1:N:0:CGATGT\'	GTCCAGCCTCACGCGGTGCCCTCCTCTTTAGGGAACAGGTAACCCACCCCTACGAGCAAGTCACCTGAACCAACTCTCTACTTGGAGAGGGCAGGCAAGTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2825:2413 1:N:0:CGATGT\'	CCCAAGTCCCCTGGAAAGGGGCGCCAGAGAGGGTGAGAGCCCCGTCGTGTTCGGACCCTGTCGCACCATGAGGCGCTGTCGCCGAGTCGGGTTGTTTGGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:2952:2414 1:N:0:CGATGT\'	GGACAAGGAAACGATAACGACGAAATGAAGATACCAATGCCACATTAAATGTAAACTGAAATACAGGCCTAAATAACGACGACCTGAAAAAGAGTGTCATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3193:2270 1:N:0:CGATGT\'	CGTGGCTTTGACCAGTTTATGAATCTGGTGATCGACAACACTGTAGAAGTAAGCGGCAATGATAAAACAGATATCGGCATGGTGGTAATTAGAGGAAACAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3037:2281 1:N:0:CGATGT\'	CATCCGAGTAGCAAGTACCATCAAACAAACTATAACTGATTTAATGAGCCATTCGCAGTTTCACAGTCTGAATTAGTTCATACTTACACATGCATGGCTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3118:2325 1:N:0:CGATGT\'	CCAAAGTACACAAACTTGAATTTACATCACCCATTTTTTTCCGATCTCCCAAACACAACACTAGAAGAACAACTCATTAAGAAACCACTTGTCGAAAAAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3233:2354 1:N:0:CGATGT\'	CTAGCCAATCCATGAGTATACCATGAAGTTACAAAGGTTGTACCTGTAAACCAACCTCCTACAGCGAAATAAGCACAAGGAAAGAGCAATAGACCAGACCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3199:2358 1:N:0:CGATGT\'	CCTGGTTCAGGAATTTTAACCCGATTCCCTTTCGAAGCTCGCGCGGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGATCGACTAACCCATGTGCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3217:2390 1:N:0:CGATGT\'	TCCAGAAGAATATTTCAAAACACGAAGGAAAGCTTTTGTCCGTTGAGTCTTCTGTTTTGTGCAAATAGCGAGAACCCTAGGTTTAGCCATTTGTTTGCCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3113:2415 1:N:0:CGATGT\'	CAAGACGATTCAGTTTACGCTTCGACATCACTGTGTTTGTAACATTCAACCGTGAGTACTCCCAAACATAAGGCATGTACAAGTCAAGCGCGTGAAGCAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3006:2420 1:N:0:CGATGT\'	GAAAGACGCATGAGACATTCGCCTTTAGACTCATCCGAGGTTCCTTTGTTAGCTTCAGCAACTTCACGCTCAAAACCAACGATGATGTCACGGTCGCACCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3131:2427 1:N:0:CGATGT\'	GTCCGTACCAGTTCTGAGTCGACTGTTCGACGGCCGGGGAAGGCCCCAAAAGGAGCCGTTCCCAGTCCGTCCCCCTGCCGGCACGCAGCAACCCCCGCCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3193:2429 1:N:0:CGATGT\'	GTCGAACAGTCGACTCAGAACTGGTACGGACAAGGGGAATCCGACTGTTTAATTAAAACAAAGCATTGCGATGGTCCTTGCGGATGTTAACGCAATGTGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3246:2435 1:N:0:CGATGT\'	TCATCTTGATCATCTCTACCCCTAGAACGCCTATCACGATCATCATACCTACTTCCATGCCTTCCATCATGCCTAGTCTTGTCCAAGTCCCTATCTTTGTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3191:2487 1:N:0:CGATGT\'	CTTGTTGTCGGGATCATTAGGGGCAAGGAAACGATTGCCTTGGCTGTTAATGGTAGGTTGTGCACTTCCTCCAATAGCATACATTTCCCAATGTGTATAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3290:2253 1:N:0:CGATGT\'	CTAGGATGTGGACTAGGGTTCGGGTAATTGGGCTGAGCATATGGACCAGGATACTGATATTCAGGCTGCAGATACGGGTATGGATGTGATTCAGGATATGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3302:2341 1:N:0:CGATGT\'	TCCTGCGACTGTGTTGCTGCTCTCCATTGACCTCTTCTTTCAGAAAATATCTTGTTATGCGCAGCAGAGCCTCCATACTGATGAGCAAGGGTGTCTCCCAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3312:2355 1:N:0:CGATGT\'	TAACAAGTTAGGGTTTTTCCCCAAGAAATGACCCCACCATCTCAATATTAAGATGTGGTAGTGAAATGCATCTTCTTCATCCCCATCTGAGAATGGCCGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3481:2418 1:N:0:CGATGT\'	CTCCATTTCAACACAGTAACTACTTCAATTACCAAAGTAATAATCAAATCACACTTTTAATGTCTTTTTCTAGTAAGATCAGATCAAAAATACACCACCAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3387:2436 1:N:0:CGATGT\'	CGGCCGGTGCCCTTGGCGGGTTTAATGCGCACGCCGATGGGGATGAACATTGTTTCTAAAGGCGGCCAAAATGTGCTGGAATTTCTCGAAAACGATTTCCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3265:2445 1:N:0:CGATGT\'	CGATCGGCAAGATGTCGGTGTCGCTGCCGCCGAAAGCCGCATGGGCGGCCTTAGCCATGCCCAAAAATTCGTCGATCTCTGGTGCAGTGAAATCGTAAGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3480:2490 1:N:0:CGATGT\'	CAAAAACTTTGATTTCTCATAAGGTGCCGGCGGCGTCCTAAAAGTAACATCCGCCGATCCCTGGTCGGCATCGTTTATGGTTGAGACTAGGACGGCATCTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3743:2251 1:N:0:CGATGT\'	CTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATGATGTTATCCCATGCTAATGTATACAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3619:2252 1:N:0:CGATGT\'	CTGAGAAGTAGTCTAGTCTGATGTGATATTGAAGCGGTTTTTTAGTTTTATTTAGTTTCTTCAGGCTTGTCATATTGCTTCTCTTAGTTTAACGCTTCAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3659:2297 1:N:0:CGATGT\'	ATTTGAATATCCCTGAGAGAAGGTCGAGAGGGATGAGGTGGAGTTTGTGAAGAAGCCCAAGGAGGCGTGTTTTTGTCTCCATCCGCAAGTTGCAAAGAAGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3638:2340 1:N:0:CGATGT\'	GTTTATGGTTGAGACTAGGACGGTATCTGATCGTCTTCGAGCCCCCAACTTTCGTTCTTGATTAATGAAAACATCCTTGGCAAATGCTTTCGCAGTTGTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3509:2355 1:N:0:CGATGT\'	CAACTTTTTATTAAATGCTCCTATTCATTATAAGGCGGGTTACAAGTCTCTTGTTTCCGTCTTCCATCTGTTGCTTCGCTAGTGCACCTTAGAACAGTCGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3587:2403 1:N:0:CGATGT\'	CGGAGTTCCAACCATGTAGAATGAGTAGAAGTTGATTCCTGCACCAATGCTCGGCCTTGCAGTCCCACGAAGAACACCACAACCGGTTGTTTGTGGGCAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3750:2409 1:N:0:CGATGT\'	CGCTCTTTTATTGAAATAGATAAATAAACATAAATATTTAATTAGACACATTTAGCAGGTTCCCATGACCATGCAGCACACATTTTGCTACAACATTCTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3709:2445 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAATCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAATTGTGCTTAACCTGTTATCTTGTCTTTATT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3670:2460 1:N:0:CGATGT\'	AGCCAGTCAAGTCCCTCGTACAAACCTTCACCAGATGTAGCACAAGTGCTTTGGATATACCAATGGCGCTGACGAAGGGAGTGGAGACCAAGCTTATCAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3748:2479 1:N:0:CGATGT\'	GTCCTTGTTAATCATTACTCCGATCCCGAAGGCCAACACAATAGGACCGGAATCCTATGATGTTATCCCATGCTAATGTATACAGAGCGTAGGCTTGCTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3844:2256 1:N:0:CGATGT\'	CCGAGACATCTAAAGAAGTTGAATTAAGATTGACACCGGCACTTGATATGACTAGAGTGAGGGATAAGAAGGACAGAGGGACTGTAACACTCAAGGTGTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3827:2266 1:N:0:CGATGT\'	GACCCGACTCGGCGACAGGTGGCCTAGAATGCCATAGTCCCTCTAAGAAGCTAGCTGCGAAGGTGTGACTCCGCATAGCTAGTTAGCAGGCTGAGGTCTCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3883:2281 1:N:0:CGATGT\'	CACCCGATTAACATCCCTATCAGATTCATCATGTGATGACGAACTCGAATCCATTGACAATATAGTTGATGGATGATAATTCTCAATAGACAAGGTTGTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3843:2338 1:N:0:CGATGT\'	TTGAAAGTGTTCCCAAAGGAGATGCTATCTTCATGAAGTGGATCCTACATGACTGGAGCGACGATCATTGCCTGACATTGTTGAAGAACTGCTACAAGGCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3904:2388 1:N:0:CGATGT\'	AGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCTCGTATGCCGTCTTCTGCTTGAAAAAAAAAAAAAAAAGAACCAACAAAACAACAGGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3949:2430 1:N:0:CGATGT\'	TGGTAGTAGCCGCTCTGGTTGGAAGTCCGGTGACTGGATTTGCACTAGGTCGGGATGCAACGAGCACAACTTCGCAAACAGGATGGAGTGCTTTAGATGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3993:2446 1:N:0:CGATGT\'	CTCTGCCTGTTCTCCATTAAATAAACACGACCGAGAATTACTCAAATCGGTCAAAAATCGAGTAATCGGGAACGGAACTCGAAGACGACGACGATGAAGTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:3954:2451 1:N:0:CGATGT\'	CCGAGACATGGAATGTTCAGTTATTTAGATCCATTGATGGTGGTGCTGCTTTTGATTTTCCCGATACTCCTGAAAAAGCGGCCGAAGCTGGGCTTGTCAGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4202:2276 1:N:0:CGATGT\'	CTGGGTACTTGACATCGAAGATGCTTCTTGACAACCCCGATGCTGCATCTTCACTGGCGTGGGATGAGGACCATGAACTGCTTGAGAAGTGTGTTTGCGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4042:2302 1:N:0:CGATGT\'	ATTCTCCATCTTTACAAGTTACAACACATATTGACTTATTAATGAAAACCCCATCTCACCTCTCCTCCTATTTCTGCTCAACATAACAAATCTCTTGTCTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4238:2303 1:N:0:CGATGT\'	CTTTCCTTGACTCGTTCCAGAACTAAGAGTGACATTAGTAATAGGTTTGGTAGTTAGAATAGGAGTAGAATCACCATCCAAGATTCTTTGAATATAAGGAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4129:2322 1:N:0:CGATGT\'	GGGGATTTGAATTTTTGGATTTTGAATTTTTGATCGTTGATGGTCTTTTTTTTTTTTTTTTTTTTGGGGAAGAAGAGAAAAAATAAAAAGGGGGAGATTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4224:2335 1:N:0:CGATGT\'	TTTCCCTGCTGATTCTGCCAAGCCCGTTCCCTTGGCTGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4191:2372 1:N:0:CGATGT\'	CTTAGTAACCAAGTCCTTGGTTCTGTACCAGTCACCACGTTTCATAGCACCTTTAAGAAAGGGGTCATGAAGACCATACAAATTGGTGAAAATGCGATCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4017:2377 1:N:0:CGATGT\'	CTACTGACCCTTTAACACTATCACCATGCTGTGACCATCCATCATTAATAAGCTTGAACGCTTCATTTCGTGACAAAAACGACGCAAAAAAGTGCTTCTTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4082:2386 1:N:0:CGATGT\'	GTCGTCTGCAAAGGATTCAACCCGCCGCTCGGTAGAATTGTGATTCAGAGCGGCCCTCACGGTGCATCCACCGCGATGGCTTGGCCCACGACACGTGCCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4057:2388 1:N:0:CGATGT\'	CAGTGATCCTATATCTTTTTCAAGAAAGCAAGCACGCGCAGATGAAATGGTATGGGCATCCAGGGAAGCTTTGAGTGAGAGACATTCTGAAGGAATCCATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4124:2406 1:N:0:CGATGT\'	CTCCATATCGATACTAAGCTTTGTTTTTGGCTCCAGCCAAAACCAGCAGTTCAATCATAACCCAGAAATATAGATACATAGCAATATGATCAATCCAACCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4218:2452 1:N:0:CGATGT\'	GCGACCAGAAAGACATTTCCGAGTACAATAAAAGTTGTTGCAACAAGTACCTTGACAGAGACTTTTTTGTTCAAAACAAAGTATGCAAATGCGATGTTCGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4317:2277 1:N:0:CGATGT\'	ATAAAAGAGCTCCCGCGCCGATTAGTATATAGTACAATGTGAGTGAACATAGCACACTGCCTAAACACCTAAAAAAAGAAAAAAGGAAAAAAAAAAAAAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4385:2356 1:N:0:CGATGT\'	GGCATAATTCATCATTAGTAGTCCGTGCTCTCTACAAACATCAGCCAACGTCAATGTACCGGCAACATTGGTTCGGATTGTCTCTGTTTTGTGAGACTCAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4425:2415 1:N:0:CGATGT\'	GGGGTCGTCAAGGCTGAACCCGGATGTGAGCAACGCAGTCTCAAACAGAAGCAGCACTAAATCCTTTACAGATTTGTCATTCTTGTCGGCATCTGCTCTCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4454:2421 1:N:0:CGATGT\'	CTACAATCCAAAGGTTTACATAGCCCAAAGTCCGATAATCTCAAGTGTCCATGTTTATCAAGTAGCAAGTTATCGGGCTTAATATCTCTATGAATATAGTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4349:2434 1:N:0:CGATGT\'	CGGTCTTGTTCAACGCAATGGCGACTGCAGCGACGAATGCCACCACACAAACAACTGAGACACCTATAATCACACCTTTGTTAGCCATTTTTTTTCCCTTT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4314:2435 1:N:0:CGATGT\'	CACTTACAATACCCCGTCGCATATTTAAGTCGTCTGCAAAGGATTCAACCCGCCGCTCGGTAGAATTGTGATTCAGAGCGGCCCTCACGGTGCATCCACCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4391:2456 1:N:0:CGATGT\'	GACGGGCGTGGCTAAGGAGCTCAGCGGAGTAGGCTGGGTTAGAGCGTTGGAAAACGATGGAAGCAGCGGCCATAGCGGCAGCAGTTTCTCCGGCAAGATCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4384:2471 1:N:0:CGATGT\'	TCCGTCTTTCTTCACCTCTCGATTGGCCAAGCAGAAGAATGTCAAGTAGTTCCTTGGATCCTCTTCAATCCCCTTAGCCTGCAAAGCAGCAATAACATCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4526:2273 1:N:0:CGATGT\'	AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCTGCTTGGATCGGAAGAGCACACGTCTGAACTCCAGTCACCGATGTATCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4596:2310 1:N:0:CGATGT\'	GCCGCGCCCTCCTACTCATCGGGGCCTGGTACTTGCCCCGACGGCCGGGTATAGGTCACGCGCTTAAGCGCCATCCATTTTCGGGGCTAGTTGATTCGGCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4707:2313 1:N:0:CGATGT\'	TGTGGTTTCGCTGGATAGTAGACAGGGACAGTGGGAATCTCGTTAATCCATTCATGCGCGTCACTAATTAGATGACGAGGCATTTGGCTACCTTAAGAGAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4612:2332 1:N:0:CGATGT\'	GATTGATTGCCGTTATGCAAATGTTGTTCAAGTGGGGGCAAATGTGTTACCTTTGTTAGCTTACGTAAGTGTCATAGAGGGTTTTTGTTTTCGCTTGTTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4691:2344 1:N:0:CGATGT\'	GCTCTGGTAAAGAAGGGAAGTTTTCAACAAATACCTTCAGAAGAGGTGAACTTATGCAATAGACCTAATATTACACATATTTATAAAGGCTATAAATGACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4622:2358 1:N:0:CGATGT\'	TGAAGGACTCACACCAATCATGATAAACTCCGATCAAGCCCCGGTCAAAAATCACAGAAAGAGTGTCTGCTTCATGTATCGGAACAATGTTCATGACCCAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4737:2419 1:N:0:CGATGT\'	CTGAGTAGGAAAGTAACGGATGACATTAGCAGTGTTCCCTCTCCACAAGGACATCATACCTTCATCCTTAATGGTGCTTCCAAAACACTCACCAATGCCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4515:2485 1:N:0:CGATGT\'	GCGGCCTTCAGGGTAGAGTAATTTGGGTTTCCAAGAATAGTAGAAGGAAGGGTGTAGAAGCTGCAGAAATCGGTAATCTCATGAGTCACTGGACTTTCAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4654:2489 1:N:0:CGATGT\'	CCAAGATCTGCACCGACAGCCGCTCCGCCCAGGCTCACGCCACAGGTTTTGCGGCGACCGCCGCGCCCTCCTACTCATCGGGGCCTGGTACTTGCCCCAAC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4846:2295 1:N:0:CGATGT\'	CATAACCTTGGCCAGGTTGACGGAGGCAGAAACCCGAACAACAGTACGGTGGGCCCACGTTCTCGTTACATCTTCCTCCATTCCCTATGCATGCTTCTGTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4924:2299 1:N:0:CGATGT\'	CTTGTTACGACTTCTCCTTCCTCTAAGTGATAAGGTTCAGTGGACTTCTCGCGACGTCGCCGGCGGCGAACCGCCCACGTCGCCGCGATCCGAACACTTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4941:2348 1:N:0:CGATGT\'	ACTCGGAATTTGGCATTGGAGTGGCATGGAGGGGTTATATTAAACATAAGCGCTACCTTACACTACACCGCTTCTTGGTATCAAATCCACGTATCGGCCGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4977:2395 1:N:0:CGATGT\'	CTCATTTGCACACAAAGGCGACGTAATCTCCGGGCTAGACTCAGGAGAAACCGAAGGGTAAATCTTATCACTAACCATTTTACTCACTTTAGAACAAAACC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4834:2400 1:N:0:CGATAT\'	CTTGTCTTGGATTTTCGCCTTGACATTATCGATGGTATCAGAACTCTCAACTTCCAGAGTAATAGTCTTCCCAGTCAAAGTCTTAACGAAGATTTGCATTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4752:2403 1:N:0:CGATGT\'	GTAGGGCATATCCTTCGTAGATAGGAACAGTGTGACTCACACCATCACCAGAGTCAAGCACGATACCTGTTGTACGACCACTAGCATAGAGAGAAAGCACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4958:2412 1:N:0:CGATGT\'	CCCAAATCAGGGCTAGGAGCTTTTATATCTCCAGGAACTTCAAATGTCACAGTTCCATCCCTTTCAACAGATGCAAGTCGGTTCAGCCACTTGATCTTCCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4799:2439 1:N:0:CGATGT\'	GTACTCTGCTGGTTTGCCAAGCCCAAATGGGTCAAACCCATAAACACCAACTAGGCTCCCATCTAACCACTCTGGAGCCTTGGCTCCTGGATACCATAATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4989:2442 1:N:0:CGATGT\'	GGTTAAGCTATTAGATATCGGAGGGTGAATGTGATGGCAAAAAGATAATAGAAAGTGCAAGTAGTTTAATGTCATTTTAATCCTTACCCTCTCAAATGTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4787:2455 1:N:0:CGATGT\'	ATGGCTGGAGGCTTTGGAAAACTCCAATAACTTCCCCAGTCTCAGGCTTGCTACTAGTAACACTCAAAGTGATCATCCCTTTCGACGAGGGAGTATTCTTA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:4915:2462 1:N:0:CGATGT\'	GCATTTATCAACAAGCATCCACTCTCCATTAGGCCGTTGATCGCCTTCATAATATTTCTCACTGGACTCGGGATGAATCTCATGCTTGGATCCATCAATCG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5225:2314 1:N:0:CGATGT\'	CTCCAAATCACCCATTTCAGTAAAACAAACATTTATATTCTCTTTTCAAAACGAAAAGTAGAAGCATCACAAACAAAGAACCAACACCAGCATCAATCACA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5079:2459 1:N:0:CGATGT\'	TGCGGCGATGACGTGATCGTAGGGGGGGGGTCGGAGAAGCTGGGGGATCGGAGGATGGAGAGGACTAGAGATGAGAGCTCGTAGAAAACCCTAGAAGATTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5111:2465 1:N:0:CGATGT\'	TGAGGAATCATGCTGGATAGAGGGCTTGGTGGATCCAAGACTAGAAGGAAGATTTAGCACGAAACAAGCTGCGCTGATGATCCAGGTAGGAATATCTTGTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5184:2480 1:N:0:CGATGT\'	AGAAAATCGGGTTTTAAATATATGCAAAGATTAAATGATCTGAGTTTTAGGCCTTAATCTTGAATAGACTCGTACCTGCATTCTCAAATTCTATGGTCAAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5205:2482 1:N:0:CGATGT\'	TGGTGGGTGAACAATCCAACACTTGGTGAATTCTGCTTCACAATGATAGGAAGAGCCGACATCGAAGGATCAAAAAGCAACGTCGCTATGAACGCTTGGCT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5307:2255 1:N:0:CGATAT\'	CTCCTTGAACACGATTCGCCAAATCAAATCTCGAACGGCTCTGATCATGACACGTGGATAACCCATCAACTCGATCAAGCAATCGGACGGTGTAGCTAGGG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5383:2265 1:N:0:CGATGT\'	GCGTGATCAGCACTCGGTCCTCCGGATTTTCAAGGGCCGCCGGGGGCGCACCGGACACCACGCGACGTGCGGTGCTCTTCCAGCCGCTAGACCCTACCTCC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5333:2280 1:N:0:CGATGT\'	TCCCATGCTAATGTATACAGAGCGTAGGCTTGCTTTGAGCACTCTAATTTCTTCAAAGTAACAGCGCCGGTAGCACGACCCGGCCAACTAAGGCCAGGAGC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5391:2288 1:N:0:CGATGT\'	AAACAGAAAAGATAACTCTTCCCGAGGCCCCCGCCGACATCTCCGGACTCCCTAACGTTGCCGTCAACCGCCACGTCCCGGTTCAGGAATTTTAACCCAAT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5436:2326 1:N:0:CGATGT\'	CCGCTGAATTTTGCAGCCTAATTGTCCTTGTTGTGTTTATCATTCCGTAGTGGTACGATCCCTGTGGATTCGGCCTTGGTCCACTTGCAGTAAGATTGGTC\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5342:2338 1:N:0:CGATGT\'	CCTTTGTGGGATCTAGGTTAGCGCGCAGTTGGGCACCGTAACTCGGCTTCCGGTTCATCCCGCATCGCCAGTTCTGCTTACCAAAAAATGGCCCACTTGGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5424:2351 1:N:0:CGATGT\'	TTCTGTTGTTGCACCTGCATGTTTTGATTCCCCACAACCCATTTTCCCTAATATACTTAGAATTAATTTGATGGATGTATGAAAAGAGGGAGAAAGAATGA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5263:2387 1:N:0:CGATGT\'	GCTGGCACAGCAGCGCTAGTATCTGGAGCAGATGCTGTTAATAAAGACACTGGAGAAAGACTGATAGTCGGAAGGTGGGTAGTGGATAGCATAGATCGGAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5423:2419 1:N:0:CGATGT\'	GCAGAACGTTACGTCCTTTCAGATCAATGAAATAAAGAGTTTCAGGGTTAATTGAGATGAACGCTTTGATGATACTAACATGGCCTCCGCTAACAGCTTTG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5374:2435 1:N:0:CGATGT\'	CACGTCCCGGTTCAGGAATTTTAACCCGATTCCCTTTCGATGCTCGCGCAGTCGCGCTATCGGACGGGCTTCCCCCGTCTCTTAGGGTCGACTAACCCATG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5392:2436 1:N:0:CGATGT\'	CGAGAAAGTACAATTCATTTGATGTTTGAAGCAGATTTTTGACCTAAAGCTGCACATAAATACTAACTAGCTTCTGAACAAAAAGGGAAACATGAACGAAA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5319:2459 1:N:0:CGATGT\'	CTTTACTAAAAAATTCTTCCTCGGAAACAAGTTGAATGTCAGGGTACTTTGACTTGAAATCTTTGCATGCTTTTATAGCTTTGAGGTAGTGGCTCTTCTCA\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5351:2460 1:N:0:CGATGT\'	GGTTGATATCATCAGTGGGCAATCTTGCTGCTCCTTTTGAGGAATGGACTGCTGGTGGAACAGCCCTGACTGCACTGATGGATGTTGAAAGAAGACACGGT\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5252:2479 1:N:0:CGATGT\'	TCCAATAACCTTCCTAATGTTGTTGATCATATAAATGAGAGCAGTGGCAAACTCACGATCTGCTTTCTTTGACATTTGCAGATTAATTTGCGAGCCACTAG\n\'D7DHSVN1:151:D12V0ACXX:8:1101:5285:2496 1:N:0:CGATGT\'	CCTATGTCCATGTTGAGTTATTGAAGCTGCAACATTTCTGTTATTATAATTAGGTGATCGATGAATCATATTTCCCCCTCCTCCACCCTTTCCGCCGCCAT\n;\nend;\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxs2phy":
        res = True
        print("fasta ", end = '')
        cm = "./pxs2phy -s TEST/test.fa"
        t = '5 20\nTaxonA\tAAATTTCCCTGTCCCTTTAA\nTaxonB\tGCTCGAGGGGCCCCAAGACC\nTaxonC\tACGCTCCCCCTTAAAAATGA\nTaxonD\tTCCTTGTTCAACTCCGGTGG\nTaxonE\tTTACTATTCCCCCCCGCCGG\n'
        if not check_individual_results(cm, t):
            res = False
        print("nexus ", end = '')
        cm = "./pxs2phy -s TEST/Concat_Sequence2.NEX"
        t = '7 21\nSequence1	AAATTTCCCTTTCCCTTTAAA\nSequence2	GGGGGGGGGGCCCCCCCCCCA\nSequence3	CCCCCCCCCCCCAAAAAAAAA\nSequence9	AAATTTCCCTTTCCCTTTAAA\nSequence10	GGGGGGGGGGCCCCCCCCCCA\nSequence11	CCCCCCCCCCCCAAAAAAAAA\nSequence8	TTTTTTTTCCCCCCCGGGGGA\n'
        if not check_individual_results(cm, t):
            res = False
        print("interleaved nexus ", end = '')
        cm = "./pxs2phy -s TEST/AA_interleave.NEX"
        t = '5 250\nTaxonE	AWWYHNTLNCRGWGEFRYLTHEFCCHWGNAFYHICHNYDNGPTTERFLTIQTWTARDRWCCKHSVHWNFQENFSTYGLKQRFQNQHSCNRHIVRQLWNNLRFFICICQIKRGKGNKCQFCILHYFIHLPSLACRLSYAFGYLRHNWFGTLTPYGFASPPNWYMRSEPSFGNSWNMAIQIANAFRTWKYRECGYSIKQSCDSTLMWPHRYWMIAQYTFQVTDSRTYDFITSSLVVYAFLCDAQARADCIDQ\nTaxonD	HWPYHNEWNQRGWGVFRYLTHEFMCHQHRLFYHICHNYDHGPTTERFKAITTWTAQDRWKSGHSVHGDFQENFCTYGMKMRFQNQHSCNRHIGRRLQNNLRFNYCYCQIKRYKGNKCQFVQLKVDIHDKSLAANLIAASMYLRHMWFGPLTPYGFAVPPNWMMVSGPSFGKSWHMQIQIRNAYVTWKYRGKGYSICQSPQNKLMWPNRYWMIEIYTFIVTDIRTALFIQISLSEYAFSCDFIPRQDMNWQ\nTaxonC	QVFYATEVNFRDIGSEGFLTCEFLDHFDAHEEKLLHNYVEKPWIEEPLWWRTRKRDDMYFSYHWDFLDFQENFDMHAYSMVMPQQHSYRFGEYRQVVNNLYYFNAGPMGHRQKMNNKQGCRMHYFIAYAQAQFNSGYHAEYLKMLSTGGLDLSGESSDPNWAKMSGESEGWSHWVAMLMRNYYRHGKSHGCKMFKHAYESEKLRCIGISSSGDQYCFTVRDSSGYRFDACVLECKTSLAACGHNANCGWP\nTaxonB	QVFYHNEVNCRWINEKGILTHEPLDHFDAHNQHILANNVETPVIYRPLWWRTRKAMDRWFYKTSVHWDFQERFDTHGYSMVAPQQQSCNRAEYRQVVNNLRRFIQPQDGHGRKMNVKQGCRMHYFIARASLEFNSGYHAEYLKQLWLGGLDFSGEKSMLNWAKMSGESEGWSHWVYMLMRNYYRHGKLHGCSHRKEALESEKLRCIGIMRWWKQYAFKVRDISGYRFDRCYLICKTLLYDDGCKANCNWP\nTaxonA	QVFTHNEVNCRWHIEKGILTHEPLDHFDAHNHHILANNVETPVIYRPLWWRTRKAMDMWFLKSSMHWDFQENFDTMAYSMHAPQQQSKHSAHYRQQVNNLRRFIQPQMGHGRKMNNKQGCRMHYFIAYASLQFNSLYHAEMLKQLWTGGLDFSGEKSMPNWAKMSGESEGWSHWVLMLMRNYYRHGKLHGCSHRKEILESEKLRRIGIMRWWKQYAFKVRDISGYRFDRGYFGCKTLLNDAGCKVNCNWP\n'
        if not check_individual_results(cm, t):
            res = False
        print("interleaved phylip ", end = '')
        cm = "./pxs2phy -s TEST/morph_data/morph_inter.phy"
        t = '64 322\nErythrosuchus	00010000000100101010000001000000100010000?00000000000?0?00?010010000000001000?0000??0010000000000000000000?00??00000?00?01?0000100000000?010000?0000010000?00000000?0000000001?0000000??0000000000000000000000010?0000?00?00000000000000000000?00?000010??000000??1000?0?0000?000?00?000?100000?0?0??000000001??10??01010010000000\nEuparkeria	0000000100010000001000001100100000000000000000000000000000000?0100000001000000000000000000000000000000?000000100000?000?0000000000000000000000000001000000?0000000??00000000?0?0000000000000000000000000000000000?0001000000010000000000000?00?00?0000000?000000?01000?0??0000000000?000?1000000000?00000000000010??0000001?000000\nPROTEROCHAMPSIDAE	10000000000010000001000000000000000000000000000000100??0????000000000000000000000000000000000000000000?0??000000?00??00?000000000000?000000100000001000000?00?00000?000000000000?111000000000000000000002000000?0?000000000??0?0000000000?0000????0000001?000000??1000?0??000000?0?00000?1000000000??1000000????10??00?00010010000\nScleromochlus	10101?01000?00000110000001??00000??01000??00??????????1?????1????000?00?????00??001100000000100??00000?0???00?1??10??01?0???00?0?0?1?011101110000000??0000?0000?000?0000000000000?0000000000000000000?00??????????0001?0000??0?0000000000?0?0000???00?000?000?00??0000?0??000??00?010001?0000000???0?10000?000??10??????001?010000\nEudimorphodon	10001001000010010?00000?0?0000?0???00000??0?????????????????1????010??000000000?0011001011101000000000?0??0??010?1100?0?0??0??????11?011?01??00011111?1111111111111111111011111?100000??00?000000000???0??????????0000?00?0??00000??0000??0?001001000?1??0?00?01?0010??0?0000??00?11000??00000?????1000000?0000000??00?0000?01?000\nPeteinosaurus	??????????????????????????????????????????????????????????????????????00??0000??0011001????01?0???000????????????1?0?00?0??0??????11?01110101000??????1111?1?11111111111???1111?0???????????????????????????????????00?00?????0???????????0?0?1001?00?1?0000?????00??????00000?00?110?0????????????10000???000000???????000?0????0\nPreondactylus	10?0?????00?11010???000?0????00?????????????????????????????0????010??00????00??0011001???????0???0?0????????????1????0?0?????????????11101110001111??1111?1111111111?11110?110?0?0000??00?00000000????0??????????000??00?????0?00??0000??00001001?00?1?00?00??1?0010??0?0?0?0?00?110?0???00???????100000??0000000??0??0000?01??00\nAustriadactylus	1000??01?00?11010???000?0?00?0????????00?000????????????????????????????????00??001100????????????????????????????????????????????????11????????111111111?11?10?????????10?1??????0000??00?000000000???0??????????0?0??00?????0?00??000???0?001001?????????00?0????10??0??????????0???????00000?????????0???????????0??0000?01?00?\nLagerpeton	??????????????????????????????????????????????????????????????????????00??????01???????00100000001010100?1000001?1?0101000?10?101111011101011110???????0????????????0000?????????????????????????????????????????????0?00?????????????????????????0000001100??????0???????0000???????00???????????0??000????????0000????0???0?0??0\nDromomeron	???????????????????????????????????????????????????????????????????????????????????????????????????10100?000001111??1010???10010101????????????????????0??????????????00???????????????????????????????????????????????00?????????????????????????????00????????????????????0????????00?????????????????????????????????0???0?0???\nMarasuchus	?0???????0?????00?1????????????????????????????????0001??????????110000000000?00001100110100000000000001?111100011?1001100?00010111101110101111???0????000??010?0???000000?0??????0?????0????????????????????00??????0?00??00???00????????????????0000000?00??????0????00?000????000?00????0????000??100??0?????00????0?00??0?00?0\nPseudolagosuchus	????????????????????????????????????????????????????????????????????????????0??????????????????0???000?0?111110??1?1001101?00010?11????????????????????0??????????????00???????????????????????????????????????????????00?????????????????????????????00???0????????????????0????????00?????????????????????????????????0???0?0???\nSilesaurus	00?00????001000000100000?1??0000???0?0???????001??000000???00000?110000010000000101100010000100000100011?11111001011011001?000?1111???01011111100000???000?0000000??00000000?0?0?000000?0000000??0???????????00???00000000?000?0000?0000000000????000000?0000??1??000010??000??????1?00???00????000???001000????00000?000010001000\nSacisaurus	?0???????0????00011???????????????????0?????????????????????00??????????????0???1????????0000000?0100001?1?1110??1110111???????????????????????????0???0?0???00?????0000000???????0?????0?0?????????????????????????0??00???????00??00????000??????00?00???0??????0????0??00??????11?00????0????????????10??????0???????0???0?100?\nEucoelophysis	???????????????????????????????????????????????????????????????????????????????????????????????00??0001??1110100????????????????????????????0??????????000??????????0000???0???????????????????????????????????????????00??????????????????????????00??????0?????????????????????????00?????????????????????????????????0???0?????\nLewisuchus	??????0????????0011?0??????????????0?000?0001?0???000010????0????11000000????0??10??000????????????001???????1???0?????????????????????1???0???0???0??0000?????000????0?0000?????00?????0?0?????0???0??0?????00?10?0001000?00???0???00?00?0?00?????????????0??01??0????0???????????0?00????0??0?00????????0???????????0?00??0???00\nEoraptor	0010000010011000011?000?10000001??10100001000??????????????????1??10?00???0000??0?11001?0010000?01101??????10?0??1????1?0??00????11???0101?1?1?00000000000?0000?00010000000000000?0000??0000000000000???????????0?0000?00?0????0000?00000?0?00??11?00?0?0?00111111?00000?000?0111??0000001000000??00000000??00000???00?0000?00?000\nHerrerasaurus	000000101001000000100000110000011010000000000001001000101???0001?110000111000?000?1100110010000001101001?11111000111011101?0011111111101011101100000100000?00000000100000000000000000000000000000000000000000001??0000?0000???000000000000000011110000000000111111100000?00000?111111111?000000000000000000?0000010100000000000000\nCoelophysis	00000000100010100110000011010001101000000000?0010?100010????0000?110010111110000001000110000100000101001?1111100111101110??001?11?1?1101011101101000100100?00000000110000000000000000000000000000000000000000001??000000000???00000?100000000011110000001000111111100100000000111111110111111111111111110000000000??00000000011111\nLiliensternus	00???????0?????0011?000????????????0?000?1000???????????????0??0?11001001100000?001?001?0000101000101??????11100011??11????00111111???01???????0??00?00100?0000000??00000000?0??0?00?0??000?0??????????????????????000?00??????0?0???0000?0?00????000000???0??11??1????0??000??1??11?101??????1???1??????0?0????000?????00??011110\nZupaysaurus	?000?01010?????0011?0000100100011010100000000???????????????0??0?????????????????0?????????????????????????????01??0?111???00111111??????????????0000001?0??????????????000???????0000??0000000000000?000??????????00??00?0????0?00?10000?0?00???1?????????0?11????????0????0??1??????01?111111??????????0??????????01?00???01111?\nPlateosaurus	000010001000100101100100110000011000000000000001001000101??110001110000011000000101100100000000000001001?11101000011011101?00111111111010001011000000000000010000000000000100010000000010000000000000000000000000?0000?000000000001?0000000001010000000000001111111111111111110000000001000000000000000011111111111111110000011000\nPantydraco	00100010100??00?01?000001001000110100000010000010???????????00?011?000??????00????11001?0010100???1????1??????0??01??11?0?????????????01000101?00000?00000?0?00000??00000010?0???00000000000000000000?000?????0?0?000010000000?0000000000?0001????0?0?000000111???101?11??11?000?00??0?1?000000000???0001111????1111000000??00100?\nAntetonitrus	??????????????????????????????????????????????????????????????????1???0011??0???0?11001?????????0??01??????1010??0?1??1???????????????0100?0?1?0???????0?0?0100?000???00?????????????????????????????????????????????0?00?????0?????????????????0??00?0?0000?????1???????1??????0?00?00??????????????000???11110??1?????11111?1??0\nEocursor	?????????????????????????????????????????????????????00?????0000?010????????????0?11001??0?0100000101??????1??0??1????????????????????11???1??????????00?0?00????0?10000??00?0????0???????0?????????????????????????00?00??????????????????1111?1?111111?1????????????????00???00??1??0????????????????????0????00????0?00??0????0\nHeterodontosaurus	0010100010110000?100000001000001??1000000100000???100?1?????1010?01000000?0000??1011001110101000001010???1?10?00?10?0?1?0?????????10?11101110?100000000000?0000?0001000000000100000000??00000000000000000000000?0?0000000?0??0011111121111101111110110011?110?00000010?0?00000?00?010?0??000000?0??0000?1000000000??00?0000000?000\nPisanosaurus	0???????????????????0???????????????????????????????????????00001??0?0????00??????????????????????????????????????0??11?0???01???11???11???10??0??????00????????????00?0??0???????0???????0?????????????????????????0??00????0???????2?????111????????00??????????0???????0?1????????????????????????00?????????????????0?????1?0?\nPaleorhinus	1000000000000000010000000000000010000000000000000?0000000?001110000000010000?10?0000010001000000000000?0???00000?001000?10?01000?000?000000100001000000000?000010000000010000011011111110011100000000000000000001?00000000000000000?00001001000000000?0000000000?01000?0??00000000000?01?0100000010000000000000010??10000000010000\nRutiodon	1000000000000000010000000000000010000000000000000???????????11?0?0000001000001000000010000000000000000?0???00000?00?000??0101000000????????1????1000000000?00001000000001000001101111111111?111100?00?00??1???1?1?000000000???00000?00001?01000000000?000??00000?00000?0??0000?00?000101?000000001000000000000001???10?00000010100\nMystriosuchus	1000000000000000000000000000000000000000010000000?0000000?0011001000000100???1??0000010000001000000000000000000000??????????????????????????????1000000000?0?001000000001000001101111111011000110111120122111011000000?000000000000?00001001000000000??????00000???000?0??00???0???0??01?0000000??00????000000??10??1000000?01?100\nPseudopalatus	1000000000000000000000000000000000000000000000000?00000?????1???????????????????0000010????????????00????????????00??00?10?01000000???000001000?1000000000?0???10000??0010000011011111111110101010100210201111111?0000?000000?00000?00001?01000000??0?00?0000000?00000?0????0?000??00?01?0000000???0000000?000001???10?0000?01010?\nAetosaurus	0000111100000001011?000000000000110010000000????????????????0010???0????0??0??0?1100010?00001001?000000000000000000?000?10?0??00?000?000001000000000000000?0000000000000000000000?0010??0000000000000??0??????????0110?00?0??000000?00000?0?010??0000?000000000????100?0??0000?00?000?01?010000????0?00000?000001???00?0000?010000\nStagonolepis	0000111100000000010000000000000011000000000000000?000000111100101000000100000100110001000000000100000000000000000001?01?10?010000000?000001000000000000000?000000000000000000000000010000000000000000000000000011?1110000000000000000000000001000000000000000000?00100?0?00000000?000001?0100000??00000000?0000010??00000000000000\nDesmatosuchus	00001111000001000100000000?0?00011000000000000000000000?1??100101000000?0?000?00110001010000100??0000000000001001001001010001000000??000001?000?0000000000?000000000000000000000000010010000000000000000000000011?11111220000000000000001000010??00000000?000000???100?0??000?00??00?001?0100000??00?00000?000001???0000000?000000\nLongosuchus	0000111100?0??01011000000010000011001000??????????000?0?????00101000000100??0???1100010?0000100?0?000?0000?00100000??00?10001000000??000001100000000??0000?0000000000000000000000000?00?000000000000?000??????0???1110122?00?00000000000??00010000000?000000000??0010?10?00000?00?000001?01000?????0000000?0000010??00?00000000000\nOrnithosuchus	0000001010000010011?000010110000100000010000000000000??0????010110?0000000001?000100010000000001000000000001000??0??001?1?????????00?00000?100000000000000?0000000??00100000?0?0000000000100000000000000000000000?000000010?0000010?0000000000?00?000000????0000?0?100?0?000??000?001001?0100010??0?0?0000?0000000??0000000?00?000\nRiojasuchus	0100101000000010011001001011000010000000000000000?000000????1100?00000000000???0?1??0100?00000010?0000?0??010000?001001?10?010000000?000010100000000000000?00000000?0010000000?00?000000010000000000000000????0???000000010???00010?00000?0000?00?000000000?0000?00100?0?0000?000?0?1001?01000100?000000000000000???00?00000001000\nDromicosuchus	0000000110010000001?000011001011101010011?001?0?????????????10???0?0000?0?00?100110?0001?000100????01??000?000000000000?0?????????0?????????????0000?00000?00??000????000000?0?0??0000??00000000000000000??0??0???000?000????1?0000?0000??0?00?????????????00100???000?0?0000??00??0?10??010000?0?0?????00?0????0???00?0000?010000\nHesperosuchus	000000?110?10000001?000011001011101010011?0010000???????????10???000000?0????1??110?000????????????01??000?000000?00000???????????????01??1????00000?00000?00??0000???0?000000?0??0000??00000000000000000??0??0?1?0000100???1110000?0000??0?00?00?????00???00100101000?0?0?????001?00101?010000?00?00?0000000000????00?00000010000\nPseudhesperosuchus	0000000110010000011?00001100?0011010?0?1110010000?0??????????????000000?00??1????10?001????????????0???0?????0000000000????????????????1????????0000000000?00000000???000000?0?0?000000?000000000000?000000000001?0000?0001?00?0000?1000?00?00?00?????00???001?0???000?0?0?????00????101?0100000????????00?000??????00?0000001000?\nTerrestrisuchus	0000001100?????00111000011001000000010010000100001000???1??11000?100000000001100110?00011000100100000000?0000000010000000010100000000001101101000000?00000?00000000000000000001000000000000000000000?000000000011?0000?000?1?0?00?0?00000000001000000000000001001?1????1?000?0000?000?01?01?0000??00?000?00000??00???0?00000010000\nErpetosuchus	0000001110010000011100001000?00011100001100010000???????????0?00?0?00001????????110?000?????????????????????????????????????????????????????????0000000000?0???1001?????00000?000?0000000000000000000?0000??????0?000000000??0?0000000000?0?00?0????????????0000?0?000?0?0????000??10??1?0000000???00???00?00000????00?000???1?010\nGracilisuchus	0010011110010000011?0000101000001000100110001000??000??0????0000?01000010000010000??01000000000???0000?0???0011??00??00?00?01?0??000??11000110000000000000?0000000??00000000?0?0?10010?00000000000000000000000000?000000000??0?000000000000000????00??000?0000?0??0000?0??0000?0??00?00??000000???0??00000?0????10??00?0001?010000\nQianosuchus	0000101100001011111000??0?0000?0???01000?0?0?0??????????????0?00?110?00??0??00??1000000?1000100??00000?0?????????0???00????01?0?000???0?00?000001010000000?0000000??00000000?0????00000?000000?000000??0??????????0000?00?0??0?000?000000?0?00????000?000?00?001???100?0??00???0??00??01?000001??????00000?0?????0??00?000???10100\nRevuletosaurus	?000??0000?10010111?0000?0110000??00?000?000????????????????0????0000001?????????0??01000000000????000?0???0000??????????0?01000000?????????????000000?000?????000????0??000?0????0000??0?0????000000??000????????0000?00????0?000000000??0?00?????0???????0?00??????0?0??000??0??????0????0000?????????00?0????1???00??00???1?000\nArizonasaurus	000010100??????11010000011??00001000?0000000?00011?000100000000?010110101111??111000???01001000100100000000000000???0????????????????????????????0?0?00000??0??0????00???000?????00000??0000?000000000000000000????000000?0000?0000000000?0000????0000?????01?00???10?10??00??00?????000?0000?0?0?0??????000????10??000?0???01?000\nArganasuchus	???????????????10?1?0???????????????????????????????????????00?????0?0?????????????????????????1???0000000010000000?????1???????????????????????????0??0????????????0000?00???????00?0??000?????????????????????????0?0?0????????0??0?????000???????0??????01????????000?????????????00????0????????????????????????????0???0??0??\nBatrachotomus	000110101000?001111?0111000000101010101101100000??100000000110000000010111000?0111?0010010000001000000000000000???0000001?????????0???00??0?00000000000000??000000??00000000?0?0?00000??0000000000000000000000000?0000000?0000?000100000000000????000000??001000???10010??00??00??00?000?00000000?0????00000????10??00010000000000\nBromsgroveia	????????????????????????????????????????????????????????????????????????1?11??11???????01101010???1?0??????000?????????????????????????????????????????0??????0?????00?????????????????????????????????????????????????00?????????????????????????0?0??????0??????????????00??????????????????????0?????????????10??????00???????0\nEffigia	00100010001011010110100011000000110100000000111010?110111??00111110001001111??1101?010?10010111111111010110000?01?1100000010110000?00001011101011000?10000?0000000??0000000000000000100?000000000000?0000000000?1?0000000?0?0000000000001?0000?00?00010000001?00??1000?0?0000?000?100000?100001???00?00010?0????000000100010010100\nFasolasuchus	?0??0????00??001111?0000????????????????????????????????????10??0000000101??0??????????????????1???010?0???10000?0??????10101000000?????????????0000???0????000?????0000000????0??00?0??0000000???????????????????0?00?00????0?0000?00????0000????000??????01???????00?0??????????0??00?00?0????0???????000??????0??0??00?000??000\nLotosaurus	0001100100101100011?100001000010101000000?00000???1000?0????1100000000101110?111??0000010000011????00000?00000001001000000101?0?000?????????????00000100???00?0?00????00000??0?0?000?0??00000000000000000000?00?0?0000?00?0??0?0000000001?0000??????0?00???00000???010?0??000??0???0?000?000000?0?1????01000????0???00?0001?000100\nPoposaurus	??0???????0??????????????????????????????????????????????????????000110011110?111???000010001101001000100000000000?1?000?0101100000????????????????????0?0?0?00?000?0000????00000????????????????????????????????????0100?????????????????????????0000??0??0??????????????00???????0??0???????????1????0????????00??????00?0??0??0\nPostosuchus	000100111101000001100011101?0100001001110101?000010001000??0100?000000001100110011??01001000000100000000000000001001000000101100000??00000?100000000000000?00000000000000000000000000000000000000000000000000000??0000?000000000000000100000000000000?000000100000100010?00000000?00000000000000???0000000?0000010000001000?000000\nPrestosuchus	?1011011?0000000111?01111?0000?0??1010110010?0??????????????0000???????111001?00010001001000000?0000000000000000000000001010100000000000000100000000000000???00000??00000000?????00000??00000000000000?00?00??0???0000?00?0??0?0000000000?0000????0000000000000???1000?0??0000?0??00?00??000000???0??00000??????100?00?000??000000\nRauisuchus	??0????1???000???1??0000???????????0?1?10?00???0??????????????000000000101001?0011?????0100000010?????????????????0?0000101010000???????????????0000?00000??000?????00?000?0??????00?0??0?00000????000?00?00??????00?0000????0?0000??0?00????0?????00000???0?00????000????000??0??00????00????0?0?0?????0?0?????1???0??00?????0?00\nSaurosuchus	010100111101000001110000100010101010001100000000000000000?0000????????010100??00???????010000001000000?0???00?0??0???00?101010000000000000100000000000?0??????0?????000?000??????00000000000000000000000000000000?0000?000000??0000000000000??????000??00000100???1000?0??00000???????0000000000??0??00000??????100000000???000000\nShuvosaurus	00100010001?1100?1011000111000001101000000001110101110111??001111110010???11??1100??10010010111111111010110000101011000000101100000?0001011101010000000000?0000000??00000000?0???000100?10000000000000000000000?1?000?00000000?0000000001?0000????0001000000100???1000?0??00000???11?000?000001??00??00010?0????00??001100??010000\nSillosaurus	?????????????????????????????????????????????????????????????????10111001?11??11???????01?00?1?1001000?0???00?10???????????????????????????????????????0????0?0?????000??????????????????????????????????????????????0000?????????????????????????000??????0?????????????????????????00?????????????????????????????????0???0????0\nStagonosuchus	??????????????????????????????????????00????????????????????????001000010100??00????010010000001000????????????????????????????????????????????????????000??0?0?00??00?????0????????????????????0???0????????????????0?00????0????????????????????000??????0??????????????00??????????????????????0????????0????10???????0???????0\nTeratosaurus	?001001110000000011100101?1101???????1?10101000001??????????00???0??00?????????0???????01000000?????????????????????????????????????????????????000000??????????????????000???????00100000000000?00000?00000??0?0?000?00000??0?000000010??00???????0???????01?0????00000??00???????????00?000?00000?????000?????1???00?1?????0?00?\nTicinosuchus	0??????????????1111?0???????????????????????????????????????0????0000001????11??000000001000000?000000?0?????00??00??00?10?01000?000?00000110?00???0???000?0000000000000?00000000?00?0??0????????0????????????????0?00?00?????0??0??00????000?00000000000?00???0?01????0??0000??0000000????0????00?000000?00000010??????000?0?0?00\nTikisuchus	000????1?1?????0011?0????????0?0???0?0???1???????????10?0???1?000??????????????????????????????10????????????????????????0?0??0??00???????????????000?0?????????????00???00??????000?0??000?????00?0?00??????00????00???0????0???0?00000??0?00??????00??????1?0????????0????0??0???????????0?????????????0??????????????????????0?\nYarasuchus	0????????1?????1?01?0??????????????0?0?????0?1???????????????????1??0000?1000?0?11??0010100000010??000?0????000??001000?????????????????????????0?01?0?000?00?0?00??0000?0?0?0????00?0??000??????0?00??0??00???????0?0000????????0??00?0???????????00?00???01??0?????0?0??00???????0?00????0??0?0????????000????????????000?0?0?00\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxseqgen":
        cm = "./pxseqgen -t TEST/test.tre -x 1 -l 10"
        t = '>TaxonE\nCTGTAACTAG\n>TaxonD\nCTGTAACTAG\n>TaxonC\nGTCTAACAGG\n>TaxonB\nGTTTGACTGG\n>TaxonA\nTTTTGACTGG\n'
    elif name == "pxssort":
        res = True
        print("sort by id ", end = '')
        cm = "./pxssort -s TEST/Codon.fa"
        t = '>Sequence1\nATGAAAAAAATATAT\n>Sequence2\nATGAAATTTAATATA\n>Sequence3\nAAATTTAAATTTAAA\n>Sequence4\nAAATTTAAATTTATA\n'
        if not check_individual_results(cm, t):
            res = False
        print("sort by id rev ", end = '')
        cm = "./pxssort -s TEST/Codon.fa -b 2"
        t = '>Sequence4\nAAATTTAAATTTATA\n>Sequence3\nAAATTTAAATTTAAA\n>Sequence2\nATGAAATTTAATATA\n>Sequence1\nATGAAAAAAATATAT\n'
        if not check_individual_results(cm, t):
            res = False
        print("sort by length (<) ", end = '')
        cm = "./pxssort -s TEST/unaligned.fa -b 3"
        t = '>Crypturellus\nGATCTAGTGCAGAGTTTGCATTCACAGATCTTATCGGGTTTTAACCAACAAAATACTTTATAACTAAACCACAGAAGTGACATGCTTACAAATGATTTANCAGAAACCAAGAGACTAGAATTTTAGCTGTTTGTCTTTTGGATGCCAAATTGAATCAGTTAAAAGCATCTCACAAAGATTAATGGGGAGTAAAATTATCTACCTCTTCCTCTGTATCCCTGTCCACAAAGAAATCCAAGAAACATACAGAGTATCTTAGCCATGCCAAAAGCAGTAGTATCTCCAGGGCTGCACTAGTGACCCCTGTGATAAACTTCAGGAAAAAGGGAAGTTGTTTGATCTTCTCTCCACACTCTCAAGCAATATGCTGTCTTTCCACAACAGGCTGAGCACACTGCATGTGAGAATTAGATGAGCCTCAGATGTCAAGATTTCTGAGGCATGGGTGGGAGATCTGAAATCTGAGCATACTGAGATCATGAGTCTATATTTAATCTTCCTGTTTTCAGGTTTTGGCTGCTGTCTACAAGGCCTTGAATGATCACCATGTCTACTTGGAAGGGACACTGCTGAAACCAAACATGGTGACAGCTGGGCATTCCTGCCCCAAGAAATACACCCCTCAGGATGTAGCAGTAGCAACTGTCACTACTCTCCTGCGTACTGTTCCTGCTGCTGTGCCTGGTGATTCCCTCTGTATTACTATATAGCCATTACTATGTATCAAACCATCACACTATCACTCTCACTGGCCTCGCTCCTAGCTCCTAAACTCACTGCTCTAGCACGTAAGGGTCAGGGGCTGTGGTGGCTGCAGCACTCAGCTTCTACCCTTTGCTATTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACTTAAATGCCATGAAT\n>Pterocnemia\nAAAAAGGCATTGTGGTGGGAATAAAGGTGAGTGTCTGTACATGTGTCTGGCTGGCACAATACTCTAAACACTATTTCCAATAAGAACTATAATATAGGGGCTGCACTCTCCCTTGTAGACCAGTATTTTGCTTGTTTCTGAAAATACCTAGAGGATCTCTGCCCCCATTCTCTGTATAGTTTTTGTACAAATATCCAGGACACATTTGTGCATTTACATATAATCCAGGACCTTTTCATCCAGCAAACGATGTACTTCCTTGTACGAATGTTACATCACACACTGAAATTAAACCTCTTCTCTCAGTACACAAACTAAAATCCTTTCTGAGTCTGACAGAACTCTTGAGCTGTTCCCTGCAGCCATCTGCATATTATCTGATCCTCTTACCCATTTCACTCCTTTCTTTCTCCTTTTCTTTAACACTTCTCAGATATGTCCCTTTAGCCTATTAAGTCCAATACTTTACCCACGGTTTGTTTGCAAAGACAGACTAGTCATAGGTCACAAGATAAGTAACAGATTGATCTCCATGTATTTTTCCTGTCTCCACAGTTGGATAAAGGCACAGCACCTCTAGGAGGAACAAATGGAGAAACTACCATACAAGGCAAGGAGAGATCTAAGTAGCCATAATTATGATTGGTAAAGTGAAAGCCATCAGATGACTAAACTCGTTCACAGCCTTAGCTGGTGTCATGTTACATTTCATGTTGAAAGCACTAAGTTCAGCTTTCCCATAAAGAACTGCTGTCAGTGAAGCACTGTTCTTTCATCTGCAGGACTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGTTGACTTTGGCAAATGGCGTGCAGTGCTGAAGATAACCAGCACAACTCCCTCTCAACTTGCTATCCAGGAGAATGCTAACACACTAGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCCTCTACTAATCTTTCCTGAGATGTTGTTACTGTTTCTTATTGTTTCCTGTGATAACAGCTAGATATTTTGAAAGATCAGTCCCTGTGAGAGGTTTCAGAGACAATGAAGAAGAAGAGCCATACAGCAAGAAGGAATACTATCAATGTTGGGRAAGACAGGAAGGACAGTTTTTCTGCCACATCTGCAAAGACTTTCCTGTTTTTCTTTCCTTAGCATGGATTGGTGCCCATTGTGGAGCCAGAAATCTTGCCTGATGGAGATCATGATCTCCAACGTTGTCAGTATGTCACAGAAAAG\n>Corvus\nCCATCCAAGGTAAGGAGAGATCTAAGGAGCCTAAGCTAAGGCCCAGCAAAAGCCATAGGGTGACTCACCTGAGACGCAGCCTTGGCTGGAGTCATGGGACTTTGCAGAGTTCTGTGCTGAAGAGCAGCTCTCAGTGAAGCACTGTTCTCCCTCTGCAGGGCTGGATGGGCTGGCTGAACGCTGTGCCCAGTACAAAAAAGATGGTGCTGACTTTGCTAAGTGGCGTGCAGTGCTGAAGATCACCAGCACAACACCCTCTCAGCTTGCCATCCAGGAGAACGCCAACACGTTGGCGCGCTATGCCAGCATCTGCCAGCAGGTACCTCCCCTCCAGCAACCTCTCCTGAGATGCTGCTGCCCCTTCTCACTGTTCCCTAGCATGTGATAACATGCTAGGTAGTTCGAAAGGAGAATCCCCGTGAGGGTTTTGGGGAAGACAAGGAGGAAGGGCAGTGCAGCATAAAGGAATGCCACTAAACTCAGGGCAAACAACAAGAACAGTTTTACTTCCATAGCTCTAAAGAATCCCCTGTCTTCCTTTTCCTAGCATGGCTTGGTGCCCATTGTGGAGCCAGAAATCCTGCCTGATGGAGACCATGATCTCCAGCGCTGTCAGTATGTCACAGAGAAGGTAAGAGATTCCTCCCTCTGTCCTCCCCCTCACAAATCAGCAGCTAAACTTTGTGCAGTTTGTGCTCACAGATCTCAAAGAAGTTTGACCAAAAATGTACTTCATAACTGCATCACAGAAATCAGCTGCTCCTAGGCAAATAGCAAACTAATAGAAAATCCACGAGTATTTTCCATGTGTTTGGATTTTTATTTCAATGGCAATATAAGCACTCTCAATCTCAAGAAGAGGTATCAGGACCAAACCCAATTACCTCAATTTCAGTACCTCAGTTGGCAAGGACAAATCCTGTAAATATGAACAATTGTATTATTGGTCATCTCAAAAGCAGTGGGGTCTCCACAACTGCAATCCCRGAGATAAATTTCATGAGAAAGCAAAATTCAACTAGATCTTGCTGCAGTACCAAAGAATAAACTGTCTTTCCACAGCAGGCTGAGGTGAAGATCTGAGCAGAGGTCTGTATTCATTCCTCCTGTTTTCAAGGTTCTGGCTGCTGTCTACAAGGCTTTGAATGATCACCACGTGTACCTGGAAGGGACACTGCTGAAACCCAACATGGTGACGGCTGGGCATTCCTGCTCCAAGAAGTACACCCCTCAGGATATAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTTCCTGGTGATTCCTGATTCACTCCTRTCTCTTCATTCCCACTCTCTCTCCCACCTCTGACATGTCTGCTCCTCTGGCACCTAAAGGTGAGGGACTGAGGTAGCTGGAACACTCTGTTTCTAAGCCTTGAAACCTCTGTCTTACAGGAATCTGCTTCCTGTCTGGAGGTCAGAGTGAAGAGGAGGCTTCTGTCAACCTGAATGCCATGAAT\n>Anas\nAAAAAGGCATTGTGGTGGGAATAAAAGTGAGTATCTGTACATGTGTGGGGTCTATACTCACTCCCAACAACAACTTTTGTTTGTTTTTTTTCGGTTTTGAAATCCCTAGAATGTCTCTGCTACCATTCTCTGCATTGCTTTTGTACAACTAAACAGTGAAACATTTGCAACCGATGCAGGACCCTTTTGTCCAACAGCACCCATATATTTACCATTCACTGCAGTTACATCCTTCCATGCAATAACCTAATTAAATCCTTTCTGCAGCTGACAGAGCTGTTGATCTACTCCCCACAGCCACCTGCATATTGCCCCCATGACCCAATTCTCTCCTGTTCCTCCCCTTTACTGGAGCCCTTCCCTTCCTTCCACTAGCAGTCTGTTCAGCCCTATACTTTACTCACAGTTAATCTGCAAAGGTAGACTAGCTCTGGGGTGCAAGGCTCAGGCTGACCTCCCTCACTCTGTAACTCTTTCTGTTTCTGCTGTCTCTTCAGCTGGATAAAGGCACATCGCCCCTAGCAGGAACAAATGGAGAAACCACCATCGAAGGTAAGGAGAGATCTAAGAAGCCTTAGCTATGACTAGTGAAAGTCATGGGGTGACTCAACAGGAGTTGCAGCCTTGGCTGGTGTCATGGTACTTTTCAGAGTTATTTCTGAAAGAGCTGTTCTCACTGAAGCTCTGTTCTTTCACATGCAGGACTGGATGGACTGTCTGAGCGCTGCGCCCAGTACAAGAAAGATGGTGTTGACTTTGGCAAGTGGCGTGCAGTGTTGAAGATCACCAGCACAACACCCTCTCAACTTGCCATCCAAGAGAATGCCAACACACTGGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCCTTCTGCAGCCTTCCTTGAGATGTTTTCGTCCCTTTTTCACTGTTCCCTCTGATAATAGACTAGGTATTGTGAACAGTGGATCTCTGTGAGGGTCTTGGGAAATGTGGAGAAAGGGCAGTGCAGAAAGAAGGCATGTCACCAGAGACAATACAGACAGCCAGGACAGTTTTTCTTTCCCACCTCCAAAAACTTCCTTGTTTTTCCTTCCTTAGAATGGCTTGGTGCCCATTGTGGAGCCAGAAGTCTTACCTGATGGAGACCACGATCTCCAGCGCTGCCAGTATGTCACAGAAAAGGTAAGATTCTTGATCTCTGCACCCTCACAAATCAGTAGTTAATCTTATGCAGGGTTTGCATTGACAGATTTCAATGAGTTTTGACCAAAAAGGTCCTTCATAACTGTATCACAGAAATGGGTCACTCATAGTCAAATAATTAGCTAGTAGCAAATGTGAGAGCAGAATCCCTGTTTTTGGATTTCCAGTCAAACTGTCAATATAAGCATTCCTGAGCTGAAAAGGATACATTGGTTATAAAGGCATTTATTCCTTGTTCAGTATGTCAGTTTGTAAGGACAAATCCAATAAAAAAGGAAAATGTCCTAGTCATCACAAAAGCATCGGTGCCTCCAGGGCTGCAACCCCTGTGACAAATTTCAAGAAATTTAGTTTGATCTTCTCCCACTTCCAAGGAATTAGCTGTCTCTCCACAGTAGGCTGAGGTAAAGCATTGAGCACAGATGTGTATTCAATCCTCCTATTCGCTCCCCCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAACGATCATCATGTCTACCTGGAGGGGACATTGCTGAAACCCAACATGGTGACAGCCGGGCATGCCTGCACCAAAAAATACACCCCTCAGGATGTAGCTGCAGCAACCGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTTCCTGGTGATTCTTGATTTGTTCCCATATATCCCTTCACACTGTCACTCCTACTGGCCTTGCTCCTCCATCTGACATGCTCATTTCTCTGGCACACAGAGGTCAGAGATGGTGGCTTGGCGGCTGGAGCGCCCCAGTTTCTAAGTCCTGAGGTCTCTTTCTTTCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTGAATGCTATGAAT\n>Eudromia\nAAAAAGGCATTGTGGTGGGAATAAAGGTGGGTATCTATACATGTCTGGCTGTCAAAATACTCTGAGCCCTGTTTCCAATGAGAACTATAACACAGGTGCCACATGCTTCTCGGCAAAACATTTTTCCATGTTTTTTAAAAAATCTAGATCTGTCCCCATTCTTTGTACAGCTTTTGAAGAAATAAGCAGGAAATATTTGTACATTTATATACGATCCAGCACCTTTTCATCCCGCACTACTTCCTTGTAACAAATGTTGCAACATTCACTGATACCAAACCTCTTCTGTCAGTACACAAATTAAAATTCTTTCAGAGGCTGACAGAACTCTTGAACTGTTCCCTTCAGCCACCTGTGTATTGCCCAATCCTCTTTTTCAGTGAACTCCTTTCTTCCCTTTTACTTCAACACATTTTAGCTATCTCCCCTTAAACTGTTCAGTCTCATACTTTACCTATAGTTGGTCTGCAAAGACAGACTAGCCATGGGTCACAGGATAAGTAACAGATTGATCTCCATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACGACCATACAAGGCAAGAAGAGATCTAAATATGATCATGATTGGTAAAATGAAAGCCCTCCCCATAAAGAACTGCTTGCAGTGAAGCACTGTTCTTTCATCTACAGGGCTGGATGGACTGGCTGAGCGCTGCGCCCAGTACAAGAAAGATGGTGCTGACTTTGGCAAGTGGCGGGCAGTGCTGAAGATCACCAGTACAACTCCATCTCAGCTCGCTATCCAGGAGAATGCTAACACACTTGCACGCTATGCCAGCATCTGCCAGCAGGTATGTACTGTCCATAAGTCTTTCTTGAGATGCTGCTAACCATTTCTCATTGTTTCCTCCAAAGAAGAGCAAGAATGAGCAGCCAGACTGCAATCAGGATACTATCAGTGTGAGCAGGTTTTTTTTCCACATCAGCAAAGATTTTTCTGTTTTTCTTTCCTTAGCATGGGTTGGTGCCCATTGTAGAACCAGAAATCTTGCCTGATGGAGACCATGATCTCCAGCGTTGTCAGTATGTGACAGAAAAGGTAAGCCACCTTACTACGCTCCTCCCACAAAATCAGTCATTTATCTAGTGTAGAGTTTGCATTCACAGGTCTTAGAAGGGTTTGACCAAAAAAATACTTCCTCACTGCAACGCAGAAATGAGACACTCACAAATGATGATTTCATAAAAAAAAAAAAAAAAAAAAAAAGACTAGCATTCTAGTTTCATGTCCTCTGGATGCCAATTGAATCTCTGTTAGAGGCATCTCAAAAGATTCATGGGAAGTAAAATTATCTACCTTTTCTCTGTACCCGTATTCATCAAATCCAAGAAATATAAAGAGTAACTTAGTCATCCCAAAAGCAGTAGTATTTCCAGGGCTGCACTAGTGCCCTCTGATAAACTTCAGGAGAAAGAGAAGTTCCGTTTGATCTTCTCTCCACAACCTCAGCAATAATTCCACAATAGGCTGAGCACACTGCAGGTGAGAATTAGATGAGTCTCAGTATGTGAAGATCTCTGAGGCATGGGTCAGAGATCTGATATCTGAGCATATTGATATCATGGGTCTATATTTAATTCCCCTGTTCTCAGGTTCTGGCTGCTGTATACAAGGCCTTGAATGATCACCATGTCTACTTGGAAGGGACACTGCTGAAACCCAACATGGTAACAGCTGGACATTCCTGCCCGAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTCCTGCGTACTGTTCCTGCTGCTGTGCCCGGTGATTACCAGTTTATTACTATGTATTGTGTACTATCTATGTATCAAACCATCACACTCTCAGTCTCATTGGCCATGCTCCTAAACTCATTGTTCTGGCACATAAGGATCAGGGGCTGTGATAGCTGCAGCACTCAGCGTCTTCCCTTTCTTATTGCAGGTATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTAAATGCCATGAAT\n>Buteo\nAAAAAGGCATTGTGGTGGGAATAAAGGTGAGTATCTGCAGATGTCTGGATGGCAGCATAATCTAAAACCCATTACCAGTGAAAATTATATATGGGGCTGCACTCTCTCCTGCCAAACACCTTTTTTCTTTTTTGTGCTTGGTTTTAAAATAACTAGAGGATCTCTGCCACCATTCTCTGCATTGCTTTTGTACAACTAACCAGGAGCACATTTGCATTTAGTGCAGGAACTTTGCATTCACCAACTCGCACCTACTCACCGTTTGCTGCAATTAAATCCCTCCATGCAGTAACCTAAATCCAGTCCTTTCTGCATCTGATAGAGCTCTCGAGCCATTCCCTATGGCCATCTACACATTGTCCCTTCCTCTTGACCAATTCACTCCTCTGCCTCCCCTTTGCTCCAACATTTCCCTCGTTTGCACCCTTAGCATGTTCAGCACCATGCTTCACTCACAGTCAGCCTGCAGCGACAGACTAGCCATGGGTAAGAAGGCTGATCTCTATCTTTCTGTAACCCTTCCTGTTTTCCTCATCTCCACAGTTGGATAAAGGCACAGCACCCCTAGCAGGAACAAATGGAGAAACCACCATCCAAGGTAAGGAGAGATCTAAGGAGCCTAAGTTATGACTGGTGGAACAAAAGCCATGGGGTGGCTACCCTGAGTCGCAGCCTGGGCTGGTGTCATGGTACTTTCAGAGCTATATCCTAAAGAACTGCTCTCAGTGAAGCACTGTTCTATCATCTGCAGGGCTGGATGGATTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGCTGACTTTGGCAAGTGGCGTGCAGTGCTGAAGATCACTAGCACAACACCCTCTCAACTTGCCATCCAAGAGAATGCCAACACATTGGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCTTTCCTGAGATGCTGTTGCCCCTTCTCACTGTTCTCTGTGATAACATGATAGGTAACTTGAAAGGCAGATCTCTGTGAGGCTTTTGGGAAAGATGAGGTAGAAGGGCAGTGCAGCAAGAACGAATACCACCAGTCAGGGTAGACAAGAACAGTTTTTCTTCCACATCCCTAGTGACTTCCCTGTTTTTCTTTCCTTAGCATGGCTTGGTGCCCATTGTGGAGCCGGAAATCTTGCCTGATGGAGACCATGATCTCCAACGCTGTCAGTATGTCACAGAAAAGGTAAGAGATTCCTGCCCCTCTCCTCCCCTTCACAGATCAGTAGCTGATCTTATTCAGTTTGTACTCACACATCTCAAGGAGTTTTGACCAAAAAGGTACTTCGTAACTGCATCACAAAAATGAGTTGCTCACAGTTAATAGTGAATGCGAGAGTAGAATCCATGCTTTTGGATTTCCACTCGAACCACCTATATAAGCATTCTCAATCTCAAAAAGATGCACAGGGACCAAACCCACTGACCACTCTTTCAGTACCTCAGCTTGCAGGGACAAGTTCAGTAAATATGAAGAGTGGTATCCTGGTCATCTCAAAAGCAGTGGTGTCTCCAGGGCTGCAACCCCTGTGATAAATTTCATGAGAAAGCAAAATTCAATTTGATCTTCTCACACTCCCAAGGAATGAGCTGTCTTTCCACAGAAGGTTGAAGTGAAGATTTGAGCAGAGATCTACATTCGCTCCTCCTGTTTTCAGGTTCTTGCTGCTGTCTACAAGGCCCTGAATGATCATCATGTCTACCTGGAAGGGACACTGCTGAAACCCAACATGGTGACAGCTGGGCACTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTTCTCCGCACCGTTCCTGCTGCCGTTCCCGGTGACTCCCAGTTCATTCCTATGTATCCATTCACACTGTCACTCTTGCTGGCCTTGCTCCTACATCTGACATGCTCACTCCTCTGGCACATAAAGGTCAGGGATTGCGGTGGCTGAAGCACTTAAGCCTCGAAACCTTTTTCTTGCAGGAATCTGCTTCCTGTCTGGAGGTCAGAGTGAAGAGGAGGCTTCTGTCAACCTGAATGCCATGAAT\n>Ciconia\nAAAAAGGCATTGTGGTGGGAATAAAAGTGAGTATCTGTACACGTGTGGCAGGCAGCATACTCCAAACCCCGTTTCCAGTGAAAATTATATATGGGGCTGCACTCTCTCCTGCCAAACACTTTTTTTTCTTTTTTTGTGCTTGATTTTAAAATCCCTAGAGGATCTCTGCCACCATTCTATGCATTGCTTTTGTACAACTAACCAGGGGCACATTTGCATTTGATGTAGGAACTTTTCATTCACCAACTCCCATCTACTCACCATTCACTGCAATTAAATCCCTCCATGCAGTAACCTAAATCCAGTCCTTTCAGCATCTGACAGAGCTCTTGAACCATTCCCTGCAGCCTTCTACACATTGCCCCTTCCTCTTACCCAGTTCACTCCTTTTCTTCCCCTTTGCTCCAGCGTTTCCCTCCTTTGCACCCTTAGTGTGTTCAGCCCCATACGTTACTCACAATCAGCCTGCAAAGACAGACTAGCCATGGGTAAGAAGATAAGGATGACACTGATCTCCATCTCTCTGTAACCGTTCCTGTTTTTCGGGTCTCCACAGCTGGATAAAGGCACAGCACCCCTAGCAGGAACAAATGGAGAAACCACCATTCAAGGTAAGGAGAGATCTAAGGAACCTAAGCTATGACTGGTGCAGCAAAAGCCAAGGGGTGACTCGCCTGAGTCACAGCCTTGGCTGGTGTCACGGTACTTTTCAGAGCTATGTCCTGAAGAACTGCTCTCAGTGAAGCACTGTTCTTTCATCTGCAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGACGGTGCTGACTTTGGCAAGTGGCGTGCAGTGCTAAAGATCACCAGCACAACACCCTCTCAACTCGCCATCCAAGAGAATGCCAACACATTGGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCCTCCAGCAACCCTTCCCGAGATGCTGTTGCCCGTTCTGACTGCTCCCTGTGATAACATGCTAGGTAACTTGAAAGGCGGATCTCTGCGAGGGTTTTGGGAAAGATGAGGAAGAAGGGCAGCGCAGCAAGAAGGAATACCAACAAAGTCAGGGTAGACAACAAGGACTGGTTTTCTTCCACGCTCTCCAAAACTTCCCTGTTTTTCTTTCCTTAGCATGGCTTGGTGCCCATTGTGGAACCAGAAATCTTGCCTGATGGAGACCATGATCTCCAGCGCTGTCAGTATGTCACAGAAAAGGTAAGAGATTCCTGCCCCCGTCCTCCCCTTCACAAATCAGTCGCTAATCTTATGCAGAGTTTGTGTTCACAGATCTCAGAGAGTTTTGACCAAAAATGTACTTCATAACTGCATCACAAAAATGAGTTGCTCATGGTCAAATAATGAATTAACAGCCAATGTGAGAGTAGAATCCATGCTTTTGGATTTCCACTCAAACTGCCAATATAAGCATTCTCAATCTCAAAAAGATGGATTGGGAGCAAAACCACTTACCCCTCTTTCAGTGCCTCAGTTTGCAGGGACAAATCCAGTAAATAGGAAGAGGGGTATCCTGGTCATCTCAAAAGCAGTGGTGTCTCCAGGGCTGCAACCCCTGGGATAAATTTCACAAGTTCAATTTGATCTTCTTACACTCCCAAGCAATAAGCTGTCTTTCCACAGCAGGTTGAGGTGAAGATTTCAGCAGAGGTCTGTATTCAATCCTTCTCTTTTCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGATCATCATGTCTACCTGGAAGGCACACTGCTGAAACCCAACATGGTGACGGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCGTAGCAACTGTCACTACTCTTCTCCGTACCGTTCCTGCTGCTGTTCCCGGTGATTCCCAATTCATTCCTATGTATCCATTCACACTGTCACTCTTGCTGGCCTTGCTCCTACATCTAACACGCTCACTCCTCTGGCACGTAAAGGTCAGGGATTGCGGTGGCTGGAGCACTCTCTGAACCTCAAAACCTCTTTCTTGCAGGAATCTGCTTCCTGTCTGGAGGTCAGAGTGAAGAGGAGGCTTCTGTCAACCTGAATGCCATGAAT\n>Nothoprocta\nAAAAAGGCATTGTGGTGGGAATAAAGGTGGGTATCTGTATTTATCTAGTTGTCATAATATTCTAAGCCCTATTTCCAATGAGAACTGTAATACAGGGGCTGCACTCTTCGCTGCAAAATATTTTTCCTTGTTTTTTAGAAAGCGTTGAGATCTCTGTCCTCATTCTCTGTACAGCTTTTGAAAAAAAATAAGCAGGACACATTTGTACATGATCCAGCACCTTTTCATCCAACACTACTTCCTTGGAGCAAATGTTGCAACATTCACTGATACCAAACCTCTCATCTCAGTACACAAATTAAAATCCTTTCAGAGGCTGACAGAACTCTTGAGCTGTTCACTTCAGTCATCTGTGTATTGCTCAGTCGTATTTCCCAGTGAACTCCTTTCTTCCCCTTCAGCACATTTCAGCTATCTCTCCTTAGCCTGTTCAGTCCCGTACTTTACTTATAGTTTGTCTGCAAAGACAGAATAGCCATGGGTCACAAGATAAGTAACAGACTGATCTCTATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCCCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAAAGATCTAAGTATGATTATGATTGACAAAGTGAAAGCCATCAGATGACCACAGCCTAAGCTGGTGTCATGATACTTCTAGGACTGTGCTGAGAACACAAAGTTGAGGCCTACCTATAAGGAACTGCTTTCAGTGAAGCACTGTTCTTTCATCTGCAGGGCTGGATGGACTAGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGGGCTGACTTTGGCAAGTGGCGGGCAGTGCTGAAGATTACCAGCACAACTCCCTCTCAGCTTGCTATCCAGGAGAATGCTAACACACTTGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCCTCCACTAGTCTTTCTTGAGATGCTGTTACTAGTTCTTAACTATTTCCTGTGATAGCAACTACATCTCCGTAAGCAGTTTAAAAAACAACAACAAAAAAGCAGCTAGACTGCAACTAGCATACTATAATTGCTGGGGGTGTCGGCAAAGATTTTTCTTTTTTTCTTTCCTTAGCATGGGTTGGTGCCCATTGTAGAACCAGAAATCTTGCCTGATGGAGACCATGATCTCCAGCGTTGTCAGTACGTGACAGAAAAGGTAAGTTACCCATGCTATGTGCCTCATCAAAAATCAGTGATTAGTGCAGAGTTTACATTCACAGATAATCAGGGGAGTTTAACCAAGAAAATACTTGGTAACTTTATCACAGAAATGAGATGCTCATATATGATGATTTATTGGAAAACAAGAGACCAGAATCTAGTCTCTTGTCTTTTACATGCCAAATTGAATATCTGTTAGAAGCATCTCACAAAGATTCATGGGGAGTAAAATTGCCTGTTCTTCTGTAACCCTGTTCACAAATCCGAGAAAGATAAAGAGTACCTTAGTCATTCCCAAAGCAGTAGTATCTCCAAGGCTGTAGTAGTGACCCCAGTGACAAACTTCATGAGAAAAAAAAGCTCAATTTCATACTCTCCATACTTTTCTCCATACCGTCAAGAAATAAGCTATTTTTCCACAATAGGCTGAGCACACTGCAGGTGAGAATTAGATGAGTCTCAGTATGGAAAATCTCCGAGGTATGAGTCAGAGATCTGAAATTTGAGCATACTGAGATCATGGGTCTATATTTAATCCTCTTGTTCTCAGGTTCTGGCTGCAGTCTACAAGGCCTTGAATGATCATCATGTCTACTTGGAAGGAACACTGCTGAAACCCAACATGGTGACAGCTGGGCATTCCTGCCCCAAGAAGTATACCCCTCAGGATGTTGCCGTAGCAACTGTCACTACTCTCCTGCGTACTGTTCCTGCGGCTGTGCCTGGTGATTCCTAATTTATTACTATGTACCCATTACTTTGTGTCAAACCATCACACTGTCACTGTCACTGGCCTTGCTCCTAAACTCATTGCTCTGGCAGATAAAAGTCAGTGGCAATGGTGGCTGCAGCACTCAGCTTCTTCCCTTCCTTACTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAACGAAGAGGAGGA\n>Tinamus\nAAAAAGGCATTGTGGTGGGAATAAAGGTGGGTATCTATATGTGTCTGGCTGTCACAATTCTCGAAGCCCTGTTTCCAATGAGAATTATAATACAGGGGCTGCACTCTTCCCTGCAAAACCTTTTTCCTTTTTTTTTTTTAATAGAGGATCTCTGTCCTCATTCTCTGTATAGCTTTTGAAGAAATAAGCAGGACAGATTTGTACATTTATATATGATCCAGAACCTTTTCATCCAGCACTACTTCCTTGCAACAAATGTTATATCATTCACTAACACCAAACCTCTTCTCTCAGTACACAAATTAAAATCCTTTCAGAGATTGGCAGAACTCTTGAGCTGTTCCCTTTGTTCCCTTCAGCCACCTGCGTACGGCCAAGTCCTCTTTCTGAGTTCACTCTTTTCTTCTCCTTTGCTTCAACACATTTTGGCTATCTCCCCTTAGCTTGTTCAGTCCCATACCTTACCTATAGTTTGTCTGCAAAGACAGACCAGCCACGAGTCACAAGATAAGTAACAGACTGATCTCCATCCATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCCCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAGAGATCTAAATGTGATTATGATTGGTAAAGTGAAAGCTACCAGATGATCTGATCGCAGCCTTAGCTGGGGCCATGATAGTTTTGGTACTGTGTTGAGAACACAAAGTTGAGCCCTACCCATAAAGATTCTTTTATCTGCAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGACGGTGCTGACTTTGGCAAGTGGCGGGCAGTGCTGAAGATTACCAGCACAACTCCGTCTCAGCTTGCTATCCAGGAGAATGCTAACACACTTGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCCTCCACTAGCCTTTATTGAGATGCTGTTACGAGTTCTCACTGTTTCCTGTGATAGCAACTATATCTCTGTAAGCAGATTAAAAAATAATAAGAAAGAGCAGCCAGACTGCAATCAGGACACTATCAGTGTTGGGTTGGGCAGTTTTGTTTCCACACCAGCAAAGATTTTTCCGTTTTCTTTCCTTAGCATGGGTTGGTGCCCATTGTAGAACCAGAAATCTTGCCTGACGGAGACCATGATCTCCAGCGTTGTCAGTATGTGACAGAAAAGGTAAGCTATCCTTGCTATGCCCCTCTTCAAAAATCACTGATTGTCTAGTGCAGAGTTTGCATTCACAAATCTTATGGGGTTTTGACCAAAAAAATACTTCGTAACTACACTGTAGAAATGAGATGTCACAAATGATGATTTAATAGAAAATAAGAGTTTTAGAAAACAAGAGAAATTTAGTCGCTTGTCATTTGGATGCCAAATCGAATCTCTGTTACAAGCATCTCACAAAGGTTAATGGGGGGTAAAAATATCTACCTCTTATTCTGTACCCATGTCCACAAATAAATCCAAGAAACATAAAGAGTATCTTAGTCATGCCAAAAGCAGTAGTATCTCCAGGGCTGCACTCGCCACCGCTGTGCTAAACTTCAAGAGAAAGGGAAGTTCAGTTTGATCTTCTCTCCGCTCCCTCAAGCAATAAGCTGTCTTTTCACAATAGGCTGAGCACACTGCATGTGAGAATTAGGTGAGTCTCAGTATGTCAAGACCTCAGAGGCATGGGTGAGGAATGTGAAATCTCAGCATACTGTGATCATGGGTCTATATTAATCCTCCTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGATCACCATGTCTACTTGGAAGGGACACTGCTGAAACCGAACATGGTGACAGCTGGGCATTCCTGTCCCAAGAAATACACACCTCAGGATGTAGCTGTAGCAACTGTCACTACTCTCCTGCGTACTGTTCCTGCTGCTGTGCCTGGTGATTCCCAATTTATTTCTATGTACCCATTACTATGTATCACACTGTCATTCTCACTGGCCTTGCTCCTGAACTCATTGCTCTAGCACATAAGGGTCAGGGGCTATGGTGGCTGCAGCACTCAGCTTCTTTTCTTCCGTATTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACTTAAATGCCATGAAT\n>Struthio\nAAAAAGGCATTGTGGTCGGAATAAAGGTGAGCGTCTGTACATGCCTAGCTGGCACAATACTCTAAACCCTATTCCCAATGAGAACTGTAATACAGGGGCTGCCCTCTCCCTTGCAAACCAGTTTTTTGTTTGTTTCTGACCCTAGAGGATCTCTGCCCCCATTGTCTGTGCGGCTTTCGTACAAATAACCAGGATACATTTGTGCATTTACATATGATCCAGGACCTTTTCATCTAGCAATACCCCTCTACTTCCTTGCAATAACTGTTGCACCATTCACTAAAATTAAAGCCTTCCTCTCAGTATACAGACTAAAAACCTTTCTGAGTCTGAGAGAGCTCTTGAGCTGTTCCCTGCAGCCACCCGCAAATTGCCCAGTCCTCTTACCTGACTCACTCCTTTCTTCCCCTTTTCTCCAAAACTCCCCCCAACACCACATCTTCCCTTAGCCTATACTTTACCTACAGTTTGTCGGCAAAGACAGACTAGCTATGGATCACAAGATAAGTAACAGACTGATCTCCATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAGAGATCTAAGTAGCCATACTTAAGATTGGTAAAGCGAAAGCCATCAGATCACTCAAGCGGTTTTGCAGCCTTGGCTGGCATCATAATACTTTTCAGGGCTACGTTGAGACCACAAAGTTCAGCCCTACTCCAAAAAAACTGCTCTCAGTGAAGCATTGTTCTTTCATCTGTAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAAAAAGACGGTGTTGACTTTGGCAAATGGCGCGCGGTGCTGAAGATCACCAGCACAACTCCCTCTCAGCTCGCCATCCAGGAGAATGCTAACACACTAGCACGCTATGCCAGCATCTGCCAGCAGGTATCTGCCCTCCACTAATCTTTCTTGAGATGTTGTTACCCTTTATCTCTGCTCCTGTGATAACAGCTAGATATCTTGAAAGACTGCTTACTGTGACGGGTTTCAAAAACGATGAGGAAGAGGGGCTGTACAGCAAGAAGGAATACTATCAATGAAGGGGATAGACAGCAATGACAGGTTTTTTTTTTTTTTTCCACATCTGCAAAGACTTTCCTGGTTTTCTTTCCTTAGCACGGATTGGTGCCCATTGTGGAACCAGAAATCTTGCCTGATGGAGACCACGATCTCCAGCGCTGTCAGTATGTCACAGAAAAGGTAAGAGATCCTCACCTCTTCAAAAATCAGTGGTTAACCTTGTGCAGAGTTTGCATTCCTAGATTTCAGGGAGTTTTGAACAAGAAAGTACTTCATGACTGTGCCACAGAAATGAGTTACTCACATATAATGATTTAATAGCAAACTTGAGACTAGAATCCATGCGTTTGGATGTCCATTCAAACTTCCGTTAGAAGCATTCTCCATCGCAGAAGGATTCACTGGGGGTAAAAGTATGTACCTCTCTTTTGGTGTCCCTGTGAACAGGGACAAATCCAATAAACATAAAGAGTAGTATCTTAGTCATTCCGATAGCAGACTGTCTCTCAGGTTGCATTACTGACCCCCGTGATAAAGGTCAAGAGAAAGGGAAGTTCAGTTTTATCTTCATTCCACAACAGACTGAGGACACTGTTGAAGAATCTGTGGGTGTGAATTAGATGGGTCTCAGCGTGTGAAGATCTGAGCATAGGTCTGCATTTCATCCTTCTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCTTTGAATGATCATCACGTCTACTTGGAAGGGACACTGCTGAAACCCAATATGGTGACGGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAAGATGTAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTCCCTGGTGATTCCCAGTTTATTACTATGTATCCATTACTATGTCTCAGTCCTTCACATTGTCACTCTCACTGGCCTTGCTCCTACGTATGATACCCTCACTCATCTGGCACACGAGGGTCAGAGACTGTGGTGGCTGCAGCACTCAGCTTCTAAGCCTTATTTTCCCCTCACTGTAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTGAATGCCATGAAC\n>Rhea\nAAAAAGGCATTGTGGTGGGAATAAAGGTGAGTGTCTGTACATGTGTCTGGCTGGCACAATACTCTAAACACTATTTCCAATAAGAACTATAATATAGGGGCTACACTCTCCCTTGTAGACCAGTATTTTGCTTGTTTCTGAAAATACCTAGAGGATCTCTGCCCCCATTCTCTGTATAGTTTTTGTACAAATATCCAGGACACATTTGCGCATTTACATAGAATCCAGGACCTTTTCATCCAGCAAAGGATGTACTTCCTTGTACAAATGTTACATCACACACTGAAATTAAACCTCTTCTCTCAGTACACAAACTAAAATCCTTTCTGAGTCTGACAGAACTCTTGAGCTGTTCCCTGCAGCCACCTGCATATTATCTGATCCTCTTACCCAGTTCACTCCTTTCTTTCTCCTTTTCTTTAACACTTCTCAGATATGTCCCTTTAGCCTATTAAGTCCAATACTTTACCCACGGTTTGTTTGCAAAGACAGACTAGTCATAGATCACAAGATAAGTAACAGATTGATCTCCATGTATTTTTCCTGTCTCCACAGTTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACTACCATACAAGGCAAGGAGAGATCTAAGTAGCCATAATTATGATTGGTAAAGTGAAAGCCATCAGATGACTAAACTCGTTCACAGGCCTTAGCTGGTGTCATGTTACATTTCATGGTGAAAGCACTAAGTTCAGCCTTCTCATAAAGAACTGCTGTCWGTGAAGCACTGTTCTTTCATCTGCAGGACTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGTTGACTTTGGCAAATGGCGTGCAGTGCTGAAGATAACCAGCACAACTCCCTCTCAACTTGCTATCCAGGAGAATGCTAACACACTAGCACGCTACGCCAGCATCTGCCAGCAGGTATCTACCCTCTATTAATCTTTCCTGAGATGCTGTTACTGTTTCTTACTGTTTTCTGTAATAACAGCTATTTTGAAAGATCAGTCCCTGTGAGAGGTTTCAGAGACMATGAAGAAGAAGAGCCATACAGYAAGGAGGAATACTATCAATGTTGGGGTAGACAGCAAGGACAGTTTTTCTGCCACATCTGCAAAGACTTTCCTGTTTTTCTTTCCTTAGCATGGATTGGTGCCCATTGTGGAGCCACAAATCTTGCCTGATGGAGATCACGATCTCCAACGTTGTCAGTATGTCACAGAAAAGGTAAGAGAACCTTTCCATATCCATCTTCACAAATCAGTGGTTAATCTTGTGCAGAGTTTGCACTCACAGATCTCAGGGACTTTTGACCAAGAAAGTTCTTCATAATTGCACTACAGAAATGAGTTAGTCACAAAAGATGATTTAATAGCAAATGTGAGACTAGGATCTTTGCTTCTTGATGTCCATTCAAACGTCTCTTAGAAGCATTCTCCATCTCAGAAATATTCACTGGGAGTAAAAGAATCTACCTCTCTTTTGGTATCCCTTTTCACAGGGACAAATCCAATAAACATGAAGAGTGGTATCCTAGTCATTCCAAAAGCAGTGGTGTCTCCAGGGTTGCATTACTGACCCCATGATGAACTTCAAGAGAAATGGAAGTTAGTTTGATCTTCTTTCTATGCTCTCAAGCAATAAGCTCTCTTTCCACAACAGGTTGAGCACACTGTTGAAGAATCTGTGGGTGAGAATTAGACGAATCTCAGTATGTGAAGATCTCAGCATGGGGTCTGTATTTAATCCTCTTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCTTTGAATGATCATCATGTCTACTTGGAAGGGACACTGCTGAAACCCAATATGGTGACGGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTCCCTGGTAATTCCCAATTTATTATTATGTATCCACTACTATGTATTCACATTGTCACTTTCACTAGCCTTGCTTCTACCTGTGATACACTCAATTCTTTGGCACATAAGGGTCAGGGAGTGTGGTGCCTGCAGCACTCAGCTTCTTCCTCTCCTTATTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTAAATGCCATGAAT\n>Apteryx\nAAAAAGGCATTGTGGTTGGAATAAAGGTGAGTGTTTGTACATGTCTGGCTGGTGCTCTAAACCCTATTTCCAAWGAGAACTATAATGTAGGGGCTGCACTCTCCCTTGCAAAACAGTTTTTTGCTTGTTTTTGAAATACCTAGAGGATCTCTGCCCCCATTCTCTGTACAGCTCCTGTACAGATAACCAAGACACATTTGTGTATTTACATATGACCTGGGACCTTTTCATCCAGCACTACTTCCTTGCAACAAATGTTGCATCATTCACTGAAATTAAACCCCTTCTCTCAGTACACAAACTAAAATCCTTTCTGAGGCTGACAGACCTCTTGAGCTGTTCCCTGCAGCCACCTGCATATTGCCTGATCCTCTTATCCAGCTCACTCCTTTTCTTCCCCTTTGCTCCAACACTTCTCCTCTATCTCCCCTTAGCCTATTCAGTCCCATACTTTACCCACAGTTTGTCTGCAAAGACAGACTAGCCATGGGTCACAAGATAAGTAACAGATTGATCTCCATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAGAGACCTAAGTAGCCATAATTATGATTGGTAAAGTGAAAGCCATCAGATGACTAAASTGGTTTGCAGCCTTAGCTGCTGTTATGATACTTTTCAGGACTATGTTGAGAACACAAAGTTCAGCCCTACCCATAAAGAACTGCTCTCAGTGAAGCACTGTTCTTTCATCTGCAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGCTGACTTTGGCAAATGGCGTGCAGTGCTGAAGATCACCAGCACAACTCCCTCTCAACTCGCTATCCAGGAGAATGCTAATGCACTAGCACGCTATGCCAGCATCTGCCAACAGGTATCTACCCTCCACTAATCTTTCTTGAGATGCTGCTATCCTTTCTCACTGTTTCCTGTGATAACAGCCAGATATCTTGAAAGACCGATCTCTGTGAGGGGTTTCAAAAACAATGAGGAAGAGGGGCCATACAGCAAGAAGGAATACTATCAATGTTGGGGTAGACAGCAAGGACAGTTTTTCTTCCACACCTGCAAAGACTTTCCTGTTTTTCTTTCCTTAGCATGGGTTGGTGCCCATTGTGGAGCCAGAAATCTTGCCTGATGGAGACCATGATCTCCAACGTTGTCAGTATGTCACAGAAAAGGTAAGAGAGATCCTTGCCATGCCCCTCTTCAAAAATCAGTGGTTAATCTTGTGCAGAGTTTGCATTCACGGATGTCAGGGAGTTTTGACCAAGAAAGTACTTCATAATTGCGCCACAGAAATGAGCTGCTCACAAATGATGATTTAACAGCAAACGTGAGACTAAGATCCGTGCTTTTGGATATCCATTCAAACCTCCGTTAGAAGCATTTTCCACCTCTGAAAGATTCACTGGGAGTAAAAGTATCTACCTCTCTTTTGGTACCCCTGTTCACAGGGACAAATCCAATAAACATAAAGAGTGGTATCTTAGTCATCCCAAAAGCAGTGGTGCCTCCAGGGTTGCATGACCGACCCCTGTGATAAACTTCAAGAGAAGGGGAAGTTCAGTTTGATCTTCTTTCCACACTCTCAAGCATTAAGCTGCCTTTCCACAACAGGCTGAGCATGCTGTTGAAGATCTGTGGGTGTGAATTAGATGGGTCTCAGTATGTGAAAATCTCAGGAAGAGTCTGTATTTAATCCTCCTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGATCATCATGTCTACTTGGAAGGGACACTGCTGAAACCCAATATGGTGACGGCTGGACACTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCAGCTGTCCCTGGTGATTCCCAATTTATTACTATGTATCCATTACCATGTATCAATCCTTCACATTGTCACTCTCACTGGCCTTGCTCCTACATACGATACACTCACTTCTCTGGCACGTAAGGGTCAGGGACTGTGGTGGCTGCAGCACTCAGCTTCTTCCCTCCTTATTGCAGGAATCTGCTTCCTGTCTGGAGGCCAAAGTGAAGAGGAGGCTTCTCTCAACCTAAATGCCATGAAT\n>Dromaius\nAAAAAGGCATTGTGGTGGGAATAAAGGTGAGTGTCTGTACATGTCTGGCTGGCACAATACTCTAAACCCTATTTCCAACGAAAACTATAACATAGGGGCTGCACTCTCCCTTGCAAACCAGTTTTTTGCTTGTTTCTGAAATACCTAGAGGATTTCCGCCCCCGTTCTTTGTATGGCTTTTGTACAAATAACCAGGACACATTTGTGCATTTACATACGATCTGGGACCTTTTCATCCAGCACTACTTCCCTGCAACAAATGCTGCATCATTCACTGAAATTAAACCTCTTCTCTCAGTACACAAACTAAAATCCTTTCTGAGGCTGACAGAACTCTTGAGCTGTTCCCTGCAACCCCCTGTGTATTGCCTGATCCTCTTACCCAGTTCACTCCTTTTCTTCCCCTTTGCTCCAACACTTCTCCCCTATCTCCCCTTAGTCTATTCAGTCCCATACTTTACCACAGTTTGTCTGCAAAGACAGACTAGCCATGGGTCACAAGATAAGTAACAGACTGACATCCATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAGAGATCTAAGTAGCCATAATTATGACTGGTAAAGTGAAAGCCATCAGATGACTAAAGGGGTTTGCAGCCTTAGCTGGTGTCATGATACTTTTCAGTACTATGTTGAGAACACCAAGTTCAGCCCTACCCATGAAGGACTGCTCTCAGTGAAGCACTGTTCTTTCATCTGCAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGTTGACTTTGGCAAATGGCGTGCGGTGCTGAAGATCACCAGCACAACTCCCTCTCAACTCGCTATCCAGGAGAATGCTAAYGCACTAGCACGCTACGCCAGCATCTGCCAGCAGGTACCTACCCTCCACTAATCTTTCTTGAGATGCTGTTACCCTTTCTCATTGTTTCCCATGATAACAGCGAGGTATCTTGAAAGACCGATCTCTGCGAGGGGTTTCAAAAACAATGAGAAAGGGGGACCATACAGCAAGACGGAATACCATCAGTGTTGAGGGAGACAGCAAAGACAGTTTTTCCTCCATACCTGCAAAGACTTTCCTGTTTTTCTTTCCTTAGCACGGGTTGGTGCCCATTGTGGAGCCAGAAATCTTGCCTGATGGAGACCATGATCTCCAACATTGTCAGTATGTCACAGAAAAGGTAAGAGATCTTTGCCATGCCCTTCTTCAAAAATCAGTGGTTAATCTTTTGCAGAGTTTGCATTCACAGATCTCAGGGAGTTTTGACCAAGAAAGTACTTCATAACTGCGCCAGAGAAATCAGCTGCTCRCAAGTGATGATTTAATAGCAAATGTGAGACTAGGATCCTTGCTTTTGGATGTCCATTCAAACCTCTGTTAGAAGCATTCTCCATCTCAGAAAGATTCACTGGGGGTAAAAGTATCTATCTCTCTTTCAGTACTCCTGTTCACAGGGACAAATCCAATAAACATAAAGAGTGGTGTATTAGTCATCGCAAAAGCAGTGGTGTCTCCAGGGTTGCATTACTGACTCCTGTGATAAACTTCAAGAGAAAGTGAAGTTCAGTTTGATCTTCTTTCCACACTCTCAAGCAATAAGCTGTCTTTCCACAATAGGCTGAGCACACTGTTGAAGAATCTGTGGGTGTGAATTAGATGGGTCTTAGTATGTGAAGATCTCAGCATGGGTCTGTATTTAATCCTCCTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGATCATCATGTCTACTTGGAAGGGACACTGCTGAAACCCAATATGGTGACGGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTCCCTGGTGATTCCCAATTTATTACTATCTATCCATTACTATGTACCAATCTTTCACATTGTCACTCTCACTGGCCTTGCTCCCACATATGATACACTCACTTCTCTGGCACATAAGGGTCAGGGACTGTGGTGAGTGCAGCACTCAGCTTCTTCCCCTCTTTATTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTAAATGCCATGAAT\n>Casuarius\nAAAAAGGCATTGTGGTGGGAATAAAGGTGAGTGTCTGTACATGTCTGGCTGGCACAATACTCTAAACCCTRTTTCCAAGGAGAACTATAATATAGGGGCTGCACTCTCCCTTGCAAACCAGTTTTTTGCTTGTTTCTGAAATACCTAGAGGATTTCTGCCCCCGTTCTTTGTACGGCTTTTGTACAAATAAGCAGGACACATTTGTGCATTTACATATGATCTGGGACCTTTTCACCCAGCACTACTTCCCTGCAACAAATGCTGCATCATTCACTGAAATTAAACCTCTTCTCTCAGTACACAAACTAAAATCCTTTCTGAGGCTGACAGAACTCTTGACCTGTTCCCTGCAACCCCCTGTGTATTGCCTGATCCTCTTACCCAGTTCATTCCTTTTCTTCCCCTTTGCTCCAACACTTCTCCCCTATCTCCCCTTAGCCTATTCAGTCCCATACTTTACCCACAGTTTGTCTGCAAAAACAGACTAGCCATGGGTCACAAGATAAGTAACAGACTGATATCCATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAGAGATCTAAGTAGCCATAATTATGACTGGTAAAGTGAAAGCCATCAGATGACTAAAGGGGTTTGCAGCCTTAGCTGGTGTCATGATACTTTTCAGTACTATGTTGAGAACACAAAGTTCAGCCCTACCCATGAAGGACTGCTCTCAGTGAAGCACTGTTCTTTCATCTGCAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGTTGACTTTGGCAAATGGCGTGCGGTGCTGAAGATCACCAGCACAACTCCCTCTCAACTCGCTATCCAGGAGAATGCTAACGCACTAGCACGCTACGCCAGCATCTGCCAGCAGGTACCTATCCTCCACTAATCTTTCTTGAGATGCTGTTACCCTTTCTCATTGTTTCCCATGGTAACAGCTAGATATCTTGAAAGACCGATCTCTGCAAGGGGTTTCAAAAACAATGAGAAAGAGGGACCATACAGCAAGAAGGAATACTATCAATGTTGAGGGAGACAGCAAAGACAGTTTTTCTTCCATACCTGCAAAGACTTTCCTGTTTTTCTTTCCTTAGCACGGGTTGGTGCCCATTGTGGAGCCAGAAATCTTGCCTGATGGAGACCATGATCTCCAACATTGTCAGTATGTCACAGAAAAGGTAAGAGATCTTTGCCATGCCCTTCTTCAAAAATCAGTGGTTAATCTTTCGCAGAGTTTGCATTCACAGATCTCAGGGAGTTTTGACCAAGAAAGTACTTCCTAACTGCACCAGAGAAATCAGTTGCTCACAAGTGATGATTTAATAGCAAATGTGAGACTAGGATCCTTGCTTTTGGATGTCCATTCAAACCTCCATTAGAAGCATTCTCCATCTCAGAAAGATTCACTGGGGGTAAAAGTATCTATCTCTCTTTCAGTACTCCTGTTCACAGGGACAAATCCAATAAACATAAAGAGTGGTATATTAGTCATCGCAAAAGCAGTGGTGTCTCCAGGGTTGCATTACTGACTCCTGTGATAAACTTCAAGAGAAAGGGAAGTTCAGTTTGATCTTCTTGCCACACTCTCAAGCAATAAGCTGTCTTTCCACAACAGGCTGAGCACACTGTTCAAGAATCTCTGGGTGTGAATTAGATGGGTCTTAGTATGTGAAGATCTTAGCATGGGTCTGTATTTAATCCTCCTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGATCATCATGTCTACTTGGAAGGGACACTGCTGAAACCCAATATGGTGACGGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTCCCAGGTGATTCCCAATTTATTACTATCTATCCATTACTATGTACCAATCTTTCACATTGTCACTCTCACTGGCCTTGCTCCCACATATGATACACTCACTTCTCTGGCACATAAGGGTCAGGGACTGTGGTGAGTGCAGCACTCAGCTTCTTCCCCTTTTTATTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTAAATGCCATGAAT\n>Smithornis\nAAAGGTGAGTATCTGTATTTGCCTGGCTGGCAGCATAATCCAAACTCCATTTTTCCAGAGAAAATTTATATGAGCCTGAAAAAACACTTTTTTGTTTGGTTTTTTTGTGCTTGGTTTTAAAATCACTAGAGGATATCTGCCACCATTTTCTGCATATTGCTTTTGGGCAACTAACCAGAGGCACATTTGCATTAAATGCAGGAACTAGCACAGATTTGGGAGTGTTGGTGGATAGGAAACTCAACATGAGCCAGCAGTGTGCCCAGGTGGCCAAGAAGGCCAATGGCATCCTGGCCTGCATCAGGAATGGTGTGCCCAGGGAGGTGGTGGAATCACCGTCCCTGGAGGTGTTTAAGAGTAGGCTGGATGAGGCACTGAGTGACATGGTTTAGATGATGGGATGGTGCTAGGTAATAGGTTGGACTTGGTGATCTCAAAGGTCTTTTCCAACCTTGTTGATTCTGTGATTCTCTGATTCTGTAACTTTTTATACACAAACTTCCACCTACTCACCATTCACTGCAAATAAGTCCCTCCATGCAGTAAATTAAATCAATTTATTTTCACAGTTGACAGAGGTCTCCAGCCACTCTTTGCAGTCATCTACACACAGCCCCTTCCTCTTACCCAGTTCACTCCTTTTCTTCCCCTTTGCCCCAACATTTCCCTCCTTTGTACCCTGAGCATGTTCAGCCCCATACTTACAATCAGCCTGCAAAGACAGACTAGACATAGATAAGAAGATAATACTGATTCCCACTCTCTGTAACCCTTCCTGTTTTTCTGTTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACCACCATCCAAGGTAAGGAGAGATCCAAGGAGCCTAAGCTACAACCTGTGCAGCAAAAGCCATAGGGTGACTAACCCGAGTCGCAGTCTTGGCTGGTGCCACGGTACTTCCCAGAGCTTTGAGCTGAAGAACTGCTCTCAGTGGAGCACTGTCCTCTCCCTGCAGGGCTGGATGGGCTGGCTGAGCGCTGTGCCCAGTACAAGAAAGACGGTGCTGACTTTGGCAAGTGGCGCGCAGTGCTCAAGATCACCAGCACAACGCCCTCTCAACTCGCCATCCAAGAGAATGCCAACACCCTGGCACGCTATGCCAGCATCTGCCAGCAGGTACCCACCCTCCAGCAACCTTTCTTGAGATGCTGCTGCTCCTTCTCACTGTTTCCTGTGATAACACACTAAAAAGGAGGATCTCCGTGAGAGTTTTGGGGAAGACAAGGAGGAAGGGCAGCACATCAAGAAGAAATATCACCAAAATCAGGGTCAATGGCAATAACAGTTTTTCTTACATAGCCCTAAAGAATTCCCTGTCTTTCTTTTCTTAGCATGGTTTGGTGCCCATCGTGGAGCCAGAAATCTTGCCTGATGGAGATCATGACCTCCAGCGCTGTCAGTATGTCACAGAAAAGGTAAGAGATTCCTCTCTCTCTCCTTCCCTTTACARATTAGCAGCTAAACTTTCTGAAGTTTGTGCTCACAGATCTCAAGGAGATTTGACCAAAAAGGTACTTCATAACTGCTTCACAAAAATGAGCTGCTCACAGGCAAATAATGAGTTAATAGCAAATGCAAGAGTACAATCCATGGTCTTGGATTTCCACTCAAACTGACAATATAAGCATTCTCAACCTCAAAAAGGTGGATCAGGAGCAAAACCAATTACTTCAATTTCAGTACCTCAGTTTGCAGTGACAAATACAGTCAATAGGAAGAGTGGTATTCTGGTCATCTTAACAGCAGTGATGTCTCCACAACGCCTCTGAGATAATTTCACACATGAAAGCAAAATTCAGTTTGATCTTGTTCCACCCCCAAAGAATAAGCTGTCTTTCCACAGGAGGCTGATGTGAATACATGACGAGAAGTCTGTATTCAATCCTCCTGTTTTCAGGTTCTGGCTGCTGTCTACAAGGCACTGAATGATCATCATGTGTACCTGGAAGGGACACTGTTGAAACCAAACATGGTGACGCCTGGACATTCCTGCTCCAGGAAGTACAGCTCTCAGGACATAGCTGTAGCCACTGTCACTACTCTCCTTCGCACCGTTCCTGCTGCTGTCCCTGGTGATTCCTGATTCCCAATTCATGGGAATTGCTGGTCCTGCTCCTGCCTCTGACATGGCTGCTCCTCTGGCATGCACAGGTCAGGGGTTGGGGTGGCTGAAGCACTCCATTTCTAAGCCTCAAATCCTTTCTTGCAGGAATCTGCTTCCTGTCTGGAGGTCAGAGCGAAGAGGAGGCTTCTGTCAACCTGAACGCCATGAAC\n>Gallus\nAAAAAGGCATGGTGGTGGGAATAAAGGTGAGTTATATCCTTCCATGCCAACAGAACTCTTGAGCCATTCCCCACAGCCAAATCCATATTGCCCTTTATATCCAATTCAATTCTGTTCTCCCCCTTTTCCTGCACTTCTTACCTTCCTTACACAAGTAGTATGTTCAGCCCCATATTTCACTCACGGACAATGTGCAAGGGTAGACCAGCTCTGGGTCACTTCTGTCATTTTTTAACCCTTTCTATTTTTGCTGTCTCTTCAGCTGGATGCAGGTACTGCACCTCTGGCAGGAACAAATGGAGAAACCACTATCCAAGGTAAGGTGAGATCTAAGAAGCCTCAGTTGTGAGTGATACATTGAAAGCCATGGTGTGACTCAACAGGAGATGAAGCCATGGCTGGTGTCATGGCACATTTCAGAGCTGTATCCTATCCTCTCAGTGAAGCACTGTTCTTTCATCTGCAGGACTTGATAAACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGCTGACTTTGGCAAGTGGCGTGCAGTGTTGAAGATCAGTAGCACAACGCCCTCTCAACTTGCCATCCAAGAGAACGCCAACACCTTGGCACGTTACGCCAGCATCTGCCAGCAGGTATCTACCCTCCAGCAAAATTTCTGGAGATTCTGTCGCCCCTTCCTTGCTGTTCCCTGTGATAACAGATGAGATATCTTGAAAGGCAGATCTCTGTGAGGATTTTGGGAAAGATGAGGATGAAGGGCAGTACAGAAGAAGAAATACCACCAAACACAATATAGACAGCAAGTAGAGTTTTTTTCTTCCACAATGATGTGTGGAAATCAGGCCCTATAGCCAGTAAGGATATAGAGCAGGTATGTGTTTATTGGTGACGCGCGTACACCCTGGTGCAAGGGGGATCGTTCCACTTAACTTGCACACCATCTGAAGAAATCGTGCTATAGATATAGGTGAAACTAATACATAATCAGTAGTTGACAAGAATTCGGATACATATTCACTAAATTTCCGAGAGCTCATTAGCATACAGTGCCTCCCCCCCTTGCACGTGCATAGTAGGTCGTGATGATGAAGGCTCGTAGTCTTCCTCGTGAAGGCTCATAGTCTTCCTCGCTGCAAACTTCTGACCCTGAAGGGGGGGCATCCCCCGAACTGGTTTCAGCTTGCACTTCAGACATCTAATCACCTCCCTGCCAAATGTTTTCGAGCTGTTCTCCGGTCCTTATCTTTATGGCCTTCATTCTCCTTGTTATTCTGGACCTAGCGCCTGTGAAAGTGCTTGGAATCCCTTGTTTTCTAATACTCTCTACATTAACTATCTCTATTTGCCCTTTATGTCTACCTTGTGAAGCTGCTTTCTCTTTTCTTGCTATGAAGCCCTTCTTTCCATACTGCAGGGACCTGATTTTGCCCTTCAACACTTACAAAGACTGCCTTGTTTTTCCTTCGTTAGAATGGCTTGGTGCCCATTGTGGAGCCAGAAGTCTTACCTGATGGTGACCATGATCTCCAACGCTGTCAGTATGTCACAGAAAAGGTAAGAGATTCCTTATTCTCTCCTCACCTTCACAAATCACTAGTTAATCTTATGCAGAGTTTATACTGCTCTCAAGGATTTTTAAACAATAAGTTCCTTCAAAACTGCACCACATGAATTCACAGTCAAATAATTAGCAAAAAGCAAACCTGCAAGTAGAATTCATGATTTTGGATTTCCATTCAAACTCTCAATATAAACATTCTTGACCTCAAAAAGATACACTGCAGATAAAGACCTTTACTCTTTATTCAGTACCTCAGTTGCAGGGAATACCCTTGCCAAAAAGAAAAGTGGTATTCTGGTATTACTAAAGTTCTCCAGGGCTCTCTTGGTCTGCACCTCCTGTAATAAATTCTAAGAGAAAGTGAAATGTGATTTGATCTTCTCACACTCCCAATGAATAAGTTGTCTTTCCACAGGAGGTTGAGGTAAAGATTTGAGCACAGATCTGTATTCACTCCTCCTTTTCAATCCTTAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGACCATCATGTCTACCTGGAAGGAACACTGCTGAAACCCAACATGGTGACAGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAGGATGTGGCTGTAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTTCCTGGTGATTCTTGATTCATTCCTATTATAACCATTCAGTTTCACTGGACTTGCTCCTACATCTGATATGCTGACTTCTCTGTCACAGTCAGTAACTGTGGCAGCTGGAGCAACCTATTTCTAAGTCTTGAGGACTCTGTCTTTCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAATTTGAATGCCATGAAT\n'
        if not check_individual_results(cm, t):
            res = False
        print("sort by length (>) ", end = '')
        cm = "./pxssort -s TEST/unaligned.fa -b 4"
        t = '>Gallus\nAAAAAGGCATGGTGGTGGGAATAAAGGTGAGTTATATCCTTCCATGCCAACAGAACTCTTGAGCCATTCCCCACAGCCAAATCCATATTGCCCTTTATATCCAATTCAATTCTGTTCTCCCCCTTTTCCTGCACTTCTTACCTTCCTTACACAAGTAGTATGTTCAGCCCCATATTTCACTCACGGACAATGTGCAAGGGTAGACCAGCTCTGGGTCACTTCTGTCATTTTTTAACCCTTTCTATTTTTGCTGTCTCTTCAGCTGGATGCAGGTACTGCACCTCTGGCAGGAACAAATGGAGAAACCACTATCCAAGGTAAGGTGAGATCTAAGAAGCCTCAGTTGTGAGTGATACATTGAAAGCCATGGTGTGACTCAACAGGAGATGAAGCCATGGCTGGTGTCATGGCACATTTCAGAGCTGTATCCTATCCTCTCAGTGAAGCACTGTTCTTTCATCTGCAGGACTTGATAAACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGCTGACTTTGGCAAGTGGCGTGCAGTGTTGAAGATCAGTAGCACAACGCCCTCTCAACTTGCCATCCAAGAGAACGCCAACACCTTGGCACGTTACGCCAGCATCTGCCAGCAGGTATCTACCCTCCAGCAAAATTTCTGGAGATTCTGTCGCCCCTTCCTTGCTGTTCCCTGTGATAACAGATGAGATATCTTGAAAGGCAGATCTCTGTGAGGATTTTGGGAAAGATGAGGATGAAGGGCAGTACAGAAGAAGAAATACCACCAAACACAATATAGACAGCAAGTAGAGTTTTTTTCTTCCACAATGATGTGTGGAAATCAGGCCCTATAGCCAGTAAGGATATAGAGCAGGTATGTGTTTATTGGTGACGCGCGTACACCCTGGTGCAAGGGGGATCGTTCCACTTAACTTGCACACCATCTGAAGAAATCGTGCTATAGATATAGGTGAAACTAATACATAATCAGTAGTTGACAAGAATTCGGATACATATTCACTAAATTTCCGAGAGCTCATTAGCATACAGTGCCTCCCCCCCTTGCACGTGCATAGTAGGTCGTGATGATGAAGGCTCGTAGTCTTCCTCGTGAAGGCTCATAGTCTTCCTCGCTGCAAACTTCTGACCCTGAAGGGGGGGCATCCCCCGAACTGGTTTCAGCTTGCACTTCAGACATCTAATCACCTCCCTGCCAAATGTTTTCGAGCTGTTCTCCGGTCCTTATCTTTATGGCCTTCATTCTCCTTGTTATTCTGGACCTAGCGCCTGTGAAAGTGCTTGGAATCCCTTGTTTTCTAATACTCTCTACATTAACTATCTCTATTTGCCCTTTATGTCTACCTTGTGAAGCTGCTTTCTCTTTTCTTGCTATGAAGCCCTTCTTTCCATACTGCAGGGACCTGATTTTGCCCTTCAACACTTACAAAGACTGCCTTGTTTTTCCTTCGTTAGAATGGCTTGGTGCCCATTGTGGAGCCAGAAGTCTTACCTGATGGTGACCATGATCTCCAACGCTGTCAGTATGTCACAGAAAAGGTAAGAGATTCCTTATTCTCTCCTCACCTTCACAAATCACTAGTTAATCTTATGCAGAGTTTATACTGCTCTCAAGGATTTTTAAACAATAAGTTCCTTCAAAACTGCACCACATGAATTCACAGTCAAATAATTAGCAAAAAGCAAACCTGCAAGTAGAATTCATGATTTTGGATTTCCATTCAAACTCTCAATATAAACATTCTTGACCTCAAAAAGATACACTGCAGATAAAGACCTTTACTCTTTATTCAGTACCTCAGTTGCAGGGAATACCCTTGCCAAAAAGAAAAGTGGTATTCTGGTATTACTAAAGTTCTCCAGGGCTCTCTTGGTCTGCACCTCCTGTAATAAATTCTAAGAGAAAGTGAAATGTGATTTGATCTTCTCACACTCCCAATGAATAAGTTGTCTTTCCACAGGAGGTTGAGGTAAAGATTTGAGCACAGATCTGTATTCACTCCTCCTTTTCAATCCTTAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGACCATCATGTCTACCTGGAAGGAACACTGCTGAAACCCAACATGGTGACAGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAGGATGTGGCTGTAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTTCCTGGTGATTCTTGATTCATTCCTATTATAACCATTCAGTTTCACTGGACTTGCTCCTACATCTGATATGCTGACTTCTCTGTCACAGTCAGTAACTGTGGCAGCTGGAGCAACCTATTTCTAAGTCTTGAGGACTCTGTCTTTCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAATTTGAATGCCATGAAT\n>Smithornis\nAAAGGTGAGTATCTGTATTTGCCTGGCTGGCAGCATAATCCAAACTCCATTTTTCCAGAGAAAATTTATATGAGCCTGAAAAAACACTTTTTTGTTTGGTTTTTTTGTGCTTGGTTTTAAAATCACTAGAGGATATCTGCCACCATTTTCTGCATATTGCTTTTGGGCAACTAACCAGAGGCACATTTGCATTAAATGCAGGAACTAGCACAGATTTGGGAGTGTTGGTGGATAGGAAACTCAACATGAGCCAGCAGTGTGCCCAGGTGGCCAAGAAGGCCAATGGCATCCTGGCCTGCATCAGGAATGGTGTGCCCAGGGAGGTGGTGGAATCACCGTCCCTGGAGGTGTTTAAGAGTAGGCTGGATGAGGCACTGAGTGACATGGTTTAGATGATGGGATGGTGCTAGGTAATAGGTTGGACTTGGTGATCTCAAAGGTCTTTTCCAACCTTGTTGATTCTGTGATTCTCTGATTCTGTAACTTTTTATACACAAACTTCCACCTACTCACCATTCACTGCAAATAAGTCCCTCCATGCAGTAAATTAAATCAATTTATTTTCACAGTTGACAGAGGTCTCCAGCCACTCTTTGCAGTCATCTACACACAGCCCCTTCCTCTTACCCAGTTCACTCCTTTTCTTCCCCTTTGCCCCAACATTTCCCTCCTTTGTACCCTGAGCATGTTCAGCCCCATACTTACAATCAGCCTGCAAAGACAGACTAGACATAGATAAGAAGATAATACTGATTCCCACTCTCTGTAACCCTTCCTGTTTTTCTGTTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACCACCATCCAAGGTAAGGAGAGATCCAAGGAGCCTAAGCTACAACCTGTGCAGCAAAAGCCATAGGGTGACTAACCCGAGTCGCAGTCTTGGCTGGTGCCACGGTACTTCCCAGAGCTTTGAGCTGAAGAACTGCTCTCAGTGGAGCACTGTCCTCTCCCTGCAGGGCTGGATGGGCTGGCTGAGCGCTGTGCCCAGTACAAGAAAGACGGTGCTGACTTTGGCAAGTGGCGCGCAGTGCTCAAGATCACCAGCACAACGCCCTCTCAACTCGCCATCCAAGAGAATGCCAACACCCTGGCACGCTATGCCAGCATCTGCCAGCAGGTACCCACCCTCCAGCAACCTTTCTTGAGATGCTGCTGCTCCTTCTCACTGTTTCCTGTGATAACACACTAAAAAGGAGGATCTCCGTGAGAGTTTTGGGGAAGACAAGGAGGAAGGGCAGCACATCAAGAAGAAATATCACCAAAATCAGGGTCAATGGCAATAACAGTTTTTCTTACATAGCCCTAAAGAATTCCCTGTCTTTCTTTTCTTAGCATGGTTTGGTGCCCATCGTGGAGCCAGAAATCTTGCCTGATGGAGATCATGACCTCCAGCGCTGTCAGTATGTCACAGAAAAGGTAAGAGATTCCTCTCTCTCTCCTTCCCTTTACARATTAGCAGCTAAACTTTCTGAAGTTTGTGCTCACAGATCTCAAGGAGATTTGACCAAAAAGGTACTTCATAACTGCTTCACAAAAATGAGCTGCTCACAGGCAAATAATGAGTTAATAGCAAATGCAAGAGTACAATCCATGGTCTTGGATTTCCACTCAAACTGACAATATAAGCATTCTCAACCTCAAAAAGGTGGATCAGGAGCAAAACCAATTACTTCAATTTCAGTACCTCAGTTTGCAGTGACAAATACAGTCAATAGGAAGAGTGGTATTCTGGTCATCTTAACAGCAGTGATGTCTCCACAACGCCTCTGAGATAATTTCACACATGAAAGCAAAATTCAGTTTGATCTTGTTCCACCCCCAAAGAATAAGCTGTCTTTCCACAGGAGGCTGATGTGAATACATGACGAGAAGTCTGTATTCAATCCTCCTGTTTTCAGGTTCTGGCTGCTGTCTACAAGGCACTGAATGATCATCATGTGTACCTGGAAGGGACACTGTTGAAACCAAACATGGTGACGCCTGGACATTCCTGCTCCAGGAAGTACAGCTCTCAGGACATAGCTGTAGCCACTGTCACTACTCTCCTTCGCACCGTTCCTGCTGCTGTCCCTGGTGATTCCTGATTCCCAATTCATGGGAATTGCTGGTCCTGCTCCTGCCTCTGACATGGCTGCTCCTCTGGCATGCACAGGTCAGGGGTTGGGGTGGCTGAAGCACTCCATTTCTAAGCCTCAAATCCTTTCTTGCAGGAATCTGCTTCCTGTCTGGAGGTCAGAGCGAAGAGGAGGCTTCTGTCAACCTGAACGCCATGAAC\n>Casuarius\nAAAAAGGCATTGTGGTGGGAATAAAGGTGAGTGTCTGTACATGTCTGGCTGGCACAATACTCTAAACCCTRTTTCCAAGGAGAACTATAATATAGGGGCTGCACTCTCCCTTGCAAACCAGTTTTTTGCTTGTTTCTGAAATACCTAGAGGATTTCTGCCCCCGTTCTTTGTACGGCTTTTGTACAAATAAGCAGGACACATTTGTGCATTTACATATGATCTGGGACCTTTTCACCCAGCACTACTTCCCTGCAACAAATGCTGCATCATTCACTGAAATTAAACCTCTTCTCTCAGTACACAAACTAAAATCCTTTCTGAGGCTGACAGAACTCTTGACCTGTTCCCTGCAACCCCCTGTGTATTGCCTGATCCTCTTACCCAGTTCATTCCTTTTCTTCCCCTTTGCTCCAACACTTCTCCCCTATCTCCCCTTAGCCTATTCAGTCCCATACTTTACCCACAGTTTGTCTGCAAAAACAGACTAGCCATGGGTCACAAGATAAGTAACAGACTGATATCCATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAGAGATCTAAGTAGCCATAATTATGACTGGTAAAGTGAAAGCCATCAGATGACTAAAGGGGTTTGCAGCCTTAGCTGGTGTCATGATACTTTTCAGTACTATGTTGAGAACACAAAGTTCAGCCCTACCCATGAAGGACTGCTCTCAGTGAAGCACTGTTCTTTCATCTGCAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGTTGACTTTGGCAAATGGCGTGCGGTGCTGAAGATCACCAGCACAACTCCCTCTCAACTCGCTATCCAGGAGAATGCTAACGCACTAGCACGCTACGCCAGCATCTGCCAGCAGGTACCTATCCTCCACTAATCTTTCTTGAGATGCTGTTACCCTTTCTCATTGTTTCCCATGGTAACAGCTAGATATCTTGAAAGACCGATCTCTGCAAGGGGTTTCAAAAACAATGAGAAAGAGGGACCATACAGCAAGAAGGAATACTATCAATGTTGAGGGAGACAGCAAAGACAGTTTTTCTTCCATACCTGCAAAGACTTTCCTGTTTTTCTTTCCTTAGCACGGGTTGGTGCCCATTGTGGAGCCAGAAATCTTGCCTGATGGAGACCATGATCTCCAACATTGTCAGTATGTCACAGAAAAGGTAAGAGATCTTTGCCATGCCCTTCTTCAAAAATCAGTGGTTAATCTTTCGCAGAGTTTGCATTCACAGATCTCAGGGAGTTTTGACCAAGAAAGTACTTCCTAACTGCACCAGAGAAATCAGTTGCTCACAAGTGATGATTTAATAGCAAATGTGAGACTAGGATCCTTGCTTTTGGATGTCCATTCAAACCTCCATTAGAAGCATTCTCCATCTCAGAAAGATTCACTGGGGGTAAAAGTATCTATCTCTCTTTCAGTACTCCTGTTCACAGGGACAAATCCAATAAACATAAAGAGTGGTATATTAGTCATCGCAAAAGCAGTGGTGTCTCCAGGGTTGCATTACTGACTCCTGTGATAAACTTCAAGAGAAAGGGAAGTTCAGTTTGATCTTCTTGCCACACTCTCAAGCAATAAGCTGTCTTTCCACAACAGGCTGAGCACACTGTTCAAGAATCTCTGGGTGTGAATTAGATGGGTCTTAGTATGTGAAGATCTTAGCATGGGTCTGTATTTAATCCTCCTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGATCATCATGTCTACTTGGAAGGGACACTGCTGAAACCCAATATGGTGACGGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTCCCAGGTGATTCCCAATTTATTACTATCTATCCATTACTATGTACCAATCTTTCACATTGTCACTCTCACTGGCCTTGCTCCCACATATGATACACTCACTTCTCTGGCACATAAGGGTCAGGGACTGTGGTGAGTGCAGCACTCAGCTTCTTCCCCTTTTTATTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTAAATGCCATGAAT\n>Dromaius\nAAAAAGGCATTGTGGTGGGAATAAAGGTGAGTGTCTGTACATGTCTGGCTGGCACAATACTCTAAACCCTATTTCCAACGAAAACTATAACATAGGGGCTGCACTCTCCCTTGCAAACCAGTTTTTTGCTTGTTTCTGAAATACCTAGAGGATTTCCGCCCCCGTTCTTTGTATGGCTTTTGTACAAATAACCAGGACACATTTGTGCATTTACATACGATCTGGGACCTTTTCATCCAGCACTACTTCCCTGCAACAAATGCTGCATCATTCACTGAAATTAAACCTCTTCTCTCAGTACACAAACTAAAATCCTTTCTGAGGCTGACAGAACTCTTGAGCTGTTCCCTGCAACCCCCTGTGTATTGCCTGATCCTCTTACCCAGTTCACTCCTTTTCTTCCCCTTTGCTCCAACACTTCTCCCCTATCTCCCCTTAGTCTATTCAGTCCCATACTTTACCACAGTTTGTCTGCAAAGACAGACTAGCCATGGGTCACAAGATAAGTAACAGACTGACATCCATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAGAGATCTAAGTAGCCATAATTATGACTGGTAAAGTGAAAGCCATCAGATGACTAAAGGGGTTTGCAGCCTTAGCTGGTGTCATGATACTTTTCAGTACTATGTTGAGAACACCAAGTTCAGCCCTACCCATGAAGGACTGCTCTCAGTGAAGCACTGTTCTTTCATCTGCAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGTTGACTTTGGCAAATGGCGTGCGGTGCTGAAGATCACCAGCACAACTCCCTCTCAACTCGCTATCCAGGAGAATGCTAAYGCACTAGCACGCTACGCCAGCATCTGCCAGCAGGTACCTACCCTCCACTAATCTTTCTTGAGATGCTGTTACCCTTTCTCATTGTTTCCCATGATAACAGCGAGGTATCTTGAAAGACCGATCTCTGCGAGGGGTTTCAAAAACAATGAGAAAGGGGGACCATACAGCAAGACGGAATACCATCAGTGTTGAGGGAGACAGCAAAGACAGTTTTTCCTCCATACCTGCAAAGACTTTCCTGTTTTTCTTTCCTTAGCACGGGTTGGTGCCCATTGTGGAGCCAGAAATCTTGCCTGATGGAGACCATGATCTCCAACATTGTCAGTATGTCACAGAAAAGGTAAGAGATCTTTGCCATGCCCTTCTTCAAAAATCAGTGGTTAATCTTTTGCAGAGTTTGCATTCACAGATCTCAGGGAGTTTTGACCAAGAAAGTACTTCATAACTGCGCCAGAGAAATCAGCTGCTCRCAAGTGATGATTTAATAGCAAATGTGAGACTAGGATCCTTGCTTTTGGATGTCCATTCAAACCTCTGTTAGAAGCATTCTCCATCTCAGAAAGATTCACTGGGGGTAAAAGTATCTATCTCTCTTTCAGTACTCCTGTTCACAGGGACAAATCCAATAAACATAAAGAGTGGTGTATTAGTCATCGCAAAAGCAGTGGTGTCTCCAGGGTTGCATTACTGACTCCTGTGATAAACTTCAAGAGAAAGTGAAGTTCAGTTTGATCTTCTTTCCACACTCTCAAGCAATAAGCTGTCTTTCCACAATAGGCTGAGCACACTGTTGAAGAATCTGTGGGTGTGAATTAGATGGGTCTTAGTATGTGAAGATCTCAGCATGGGTCTGTATTTAATCCTCCTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGATCATCATGTCTACTTGGAAGGGACACTGCTGAAACCCAATATGGTGACGGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTCCCTGGTGATTCCCAATTTATTACTATCTATCCATTACTATGTACCAATCTTTCACATTGTCACTCTCACTGGCCTTGCTCCCACATATGATACACTCACTTCTCTGGCACATAAGGGTCAGGGACTGTGGTGAGTGCAGCACTCAGCTTCTTCCCCTCTTTATTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTAAATGCCATGAAT\n>Apteryx\nAAAAAGGCATTGTGGTTGGAATAAAGGTGAGTGTTTGTACATGTCTGGCTGGTGCTCTAAACCCTATTTCCAAWGAGAACTATAATGTAGGGGCTGCACTCTCCCTTGCAAAACAGTTTTTTGCTTGTTTTTGAAATACCTAGAGGATCTCTGCCCCCATTCTCTGTACAGCTCCTGTACAGATAACCAAGACACATTTGTGTATTTACATATGACCTGGGACCTTTTCATCCAGCACTACTTCCTTGCAACAAATGTTGCATCATTCACTGAAATTAAACCCCTTCTCTCAGTACACAAACTAAAATCCTTTCTGAGGCTGACAGACCTCTTGAGCTGTTCCCTGCAGCCACCTGCATATTGCCTGATCCTCTTATCCAGCTCACTCCTTTTCTTCCCCTTTGCTCCAACACTTCTCCTCTATCTCCCCTTAGCCTATTCAGTCCCATACTTTACCCACAGTTTGTCTGCAAAGACAGACTAGCCATGGGTCACAAGATAAGTAACAGATTGATCTCCATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAGAGACCTAAGTAGCCATAATTATGATTGGTAAAGTGAAAGCCATCAGATGACTAAASTGGTTTGCAGCCTTAGCTGCTGTTATGATACTTTTCAGGACTATGTTGAGAACACAAAGTTCAGCCCTACCCATAAAGAACTGCTCTCAGTGAAGCACTGTTCTTTCATCTGCAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGCTGACTTTGGCAAATGGCGTGCAGTGCTGAAGATCACCAGCACAACTCCCTCTCAACTCGCTATCCAGGAGAATGCTAATGCACTAGCACGCTATGCCAGCATCTGCCAACAGGTATCTACCCTCCACTAATCTTTCTTGAGATGCTGCTATCCTTTCTCACTGTTTCCTGTGATAACAGCCAGATATCTTGAAAGACCGATCTCTGTGAGGGGTTTCAAAAACAATGAGGAAGAGGGGCCATACAGCAAGAAGGAATACTATCAATGTTGGGGTAGACAGCAAGGACAGTTTTTCTTCCACACCTGCAAAGACTTTCCTGTTTTTCTTTCCTTAGCATGGGTTGGTGCCCATTGTGGAGCCAGAAATCTTGCCTGATGGAGACCATGATCTCCAACGTTGTCAGTATGTCACAGAAAAGGTAAGAGAGATCCTTGCCATGCCCCTCTTCAAAAATCAGTGGTTAATCTTGTGCAGAGTTTGCATTCACGGATGTCAGGGAGTTTTGACCAAGAAAGTACTTCATAATTGCGCCACAGAAATGAGCTGCTCACAAATGATGATTTAACAGCAAACGTGAGACTAAGATCCGTGCTTTTGGATATCCATTCAAACCTCCGTTAGAAGCATTTTCCACCTCTGAAAGATTCACTGGGAGTAAAAGTATCTACCTCTCTTTTGGTACCCCTGTTCACAGGGACAAATCCAATAAACATAAAGAGTGGTATCTTAGTCATCCCAAAAGCAGTGGTGCCTCCAGGGTTGCATGACCGACCCCTGTGATAAACTTCAAGAGAAGGGGAAGTTCAGTTTGATCTTCTTTCCACACTCTCAAGCATTAAGCTGCCTTTCCACAACAGGCTGAGCATGCTGTTGAAGATCTGTGGGTGTGAATTAGATGGGTCTCAGTATGTGAAAATCTCAGGAAGAGTCTGTATTTAATCCTCCTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGATCATCATGTCTACTTGGAAGGGACACTGCTGAAACCCAATATGGTGACGGCTGGACACTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCAGCTGTCCCTGGTGATTCCCAATTTATTACTATGTATCCATTACCATGTATCAATCCTTCACATTGTCACTCTCACTGGCCTTGCTCCTACATACGATACACTCACTTCTCTGGCACGTAAGGGTCAGGGACTGTGGTGGCTGCAGCACTCAGCTTCTTCCCTCCTTATTGCAGGAATCTGCTTCCTGTCTGGAGGCCAAAGTGAAGAGGAGGCTTCTCTCAACCTAAATGCCATGAAT\n>Rhea\nAAAAAGGCATTGTGGTGGGAATAAAGGTGAGTGTCTGTACATGTGTCTGGCTGGCACAATACTCTAAACACTATTTCCAATAAGAACTATAATATAGGGGCTACACTCTCCCTTGTAGACCAGTATTTTGCTTGTTTCTGAAAATACCTAGAGGATCTCTGCCCCCATTCTCTGTATAGTTTTTGTACAAATATCCAGGACACATTTGCGCATTTACATAGAATCCAGGACCTTTTCATCCAGCAAAGGATGTACTTCCTTGTACAAATGTTACATCACACACTGAAATTAAACCTCTTCTCTCAGTACACAAACTAAAATCCTTTCTGAGTCTGACAGAACTCTTGAGCTGTTCCCTGCAGCCACCTGCATATTATCTGATCCTCTTACCCAGTTCACTCCTTTCTTTCTCCTTTTCTTTAACACTTCTCAGATATGTCCCTTTAGCCTATTAAGTCCAATACTTTACCCACGGTTTGTTTGCAAAGACAGACTAGTCATAGATCACAAGATAAGTAACAGATTGATCTCCATGTATTTTTCCTGTCTCCACAGTTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACTACCATACAAGGCAAGGAGAGATCTAAGTAGCCATAATTATGATTGGTAAAGTGAAAGCCATCAGATGACTAAACTCGTTCACAGGCCTTAGCTGGTGTCATGTTACATTTCATGGTGAAAGCACTAAGTTCAGCCTTCTCATAAAGAACTGCTGTCWGTGAAGCACTGTTCTTTCATCTGCAGGACTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGTTGACTTTGGCAAATGGCGTGCAGTGCTGAAGATAACCAGCACAACTCCCTCTCAACTTGCTATCCAGGAGAATGCTAACACACTAGCACGCTACGCCAGCATCTGCCAGCAGGTATCTACCCTCTATTAATCTTTCCTGAGATGCTGTTACTGTTTCTTACTGTTTTCTGTAATAACAGCTATTTTGAAAGATCAGTCCCTGTGAGAGGTTTCAGAGACMATGAAGAAGAAGAGCCATACAGYAAGGAGGAATACTATCAATGTTGGGGTAGACAGCAAGGACAGTTTTTCTGCCACATCTGCAAAGACTTTCCTGTTTTTCTTTCCTTAGCATGGATTGGTGCCCATTGTGGAGCCACAAATCTTGCCTGATGGAGATCACGATCTCCAACGTTGTCAGTATGTCACAGAAAAGGTAAGAGAACCTTTCCATATCCATCTTCACAAATCAGTGGTTAATCTTGTGCAGAGTTTGCACTCACAGATCTCAGGGACTTTTGACCAAGAAAGTTCTTCATAATTGCACTACAGAAATGAGTTAGTCACAAAAGATGATTTAATAGCAAATGTGAGACTAGGATCTTTGCTTCTTGATGTCCATTCAAACGTCTCTTAGAAGCATTCTCCATCTCAGAAATATTCACTGGGAGTAAAAGAATCTACCTCTCTTTTGGTATCCCTTTTCACAGGGACAAATCCAATAAACATGAAGAGTGGTATCCTAGTCATTCCAAAAGCAGTGGTGTCTCCAGGGTTGCATTACTGACCCCATGATGAACTTCAAGAGAAATGGAAGTTAGTTTGATCTTCTTTCTATGCTCTCAAGCAATAAGCTCTCTTTCCACAACAGGTTGAGCACACTGTTGAAGAATCTGTGGGTGAGAATTAGACGAATCTCAGTATGTGAAGATCTCAGCATGGGGTCTGTATTTAATCCTCTTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCTTTGAATGATCATCATGTCTACTTGGAAGGGACACTGCTGAAACCCAATATGGTGACGGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTCCCTGGTAATTCCCAATTTATTATTATGTATCCACTACTATGTATTCACATTGTCACTTTCACTAGCCTTGCTTCTACCTGTGATACACTCAATTCTTTGGCACATAAGGGTCAGGGAGTGTGGTGCCTGCAGCACTCAGCTTCTTCCTCTCCTTATTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTAAATGCCATGAAT\n>Struthio\nAAAAAGGCATTGTGGTCGGAATAAAGGTGAGCGTCTGTACATGCCTAGCTGGCACAATACTCTAAACCCTATTCCCAATGAGAACTGTAATACAGGGGCTGCCCTCTCCCTTGCAAACCAGTTTTTTGTTTGTTTCTGACCCTAGAGGATCTCTGCCCCCATTGTCTGTGCGGCTTTCGTACAAATAACCAGGATACATTTGTGCATTTACATATGATCCAGGACCTTTTCATCTAGCAATACCCCTCTACTTCCTTGCAATAACTGTTGCACCATTCACTAAAATTAAAGCCTTCCTCTCAGTATACAGACTAAAAACCTTTCTGAGTCTGAGAGAGCTCTTGAGCTGTTCCCTGCAGCCACCCGCAAATTGCCCAGTCCTCTTACCTGACTCACTCCTTTCTTCCCCTTTTCTCCAAAACTCCCCCCAACACCACATCTTCCCTTAGCCTATACTTTACCTACAGTTTGTCGGCAAAGACAGACTAGCTATGGATCACAAGATAAGTAACAGACTGATCTCCATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAGAGATCTAAGTAGCCATACTTAAGATTGGTAAAGCGAAAGCCATCAGATCACTCAAGCGGTTTTGCAGCCTTGGCTGGCATCATAATACTTTTCAGGGCTACGTTGAGACCACAAAGTTCAGCCCTACTCCAAAAAAACTGCTCTCAGTGAAGCATTGTTCTTTCATCTGTAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAAAAAGACGGTGTTGACTTTGGCAAATGGCGCGCGGTGCTGAAGATCACCAGCACAACTCCCTCTCAGCTCGCCATCCAGGAGAATGCTAACACACTAGCACGCTATGCCAGCATCTGCCAGCAGGTATCTGCCCTCCACTAATCTTTCTTGAGATGTTGTTACCCTTTATCTCTGCTCCTGTGATAACAGCTAGATATCTTGAAAGACTGCTTACTGTGACGGGTTTCAAAAACGATGAGGAAGAGGGGCTGTACAGCAAGAAGGAATACTATCAATGAAGGGGATAGACAGCAATGACAGGTTTTTTTTTTTTTTTCCACATCTGCAAAGACTTTCCTGGTTTTCTTTCCTTAGCACGGATTGGTGCCCATTGTGGAACCAGAAATCTTGCCTGATGGAGACCACGATCTCCAGCGCTGTCAGTATGTCACAGAAAAGGTAAGAGATCCTCACCTCTTCAAAAATCAGTGGTTAACCTTGTGCAGAGTTTGCATTCCTAGATTTCAGGGAGTTTTGAACAAGAAAGTACTTCATGACTGTGCCACAGAAATGAGTTACTCACATATAATGATTTAATAGCAAACTTGAGACTAGAATCCATGCGTTTGGATGTCCATTCAAACTTCCGTTAGAAGCATTCTCCATCGCAGAAGGATTCACTGGGGGTAAAAGTATGTACCTCTCTTTTGGTGTCCCTGTGAACAGGGACAAATCCAATAAACATAAAGAGTAGTATCTTAGTCATTCCGATAGCAGACTGTCTCTCAGGTTGCATTACTGACCCCCGTGATAAAGGTCAAGAGAAAGGGAAGTTCAGTTTTATCTTCATTCCACAACAGACTGAGGACACTGTTGAAGAATCTGTGGGTGTGAATTAGATGGGTCTCAGCGTGTGAAGATCTGAGCATAGGTCTGCATTTCATCCTTCTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCTTTGAATGATCATCACGTCTACTTGGAAGGGACACTGCTGAAACCCAATATGGTGACGGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAAGATGTAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTCCCTGGTGATTCCCAGTTTATTACTATGTATCCATTACTATGTCTCAGTCCTTCACATTGTCACTCTCACTGGCCTTGCTCCTACGTATGATACCCTCACTCATCTGGCACACGAGGGTCAGAGACTGTGGTGGCTGCAGCACTCAGCTTCTAAGCCTTATTTTCCCCTCACTGTAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTGAATGCCATGAAC\n>Tinamus\nAAAAAGGCATTGTGGTGGGAATAAAGGTGGGTATCTATATGTGTCTGGCTGTCACAATTCTCGAAGCCCTGTTTCCAATGAGAATTATAATACAGGGGCTGCACTCTTCCCTGCAAAACCTTTTTCCTTTTTTTTTTTTAATAGAGGATCTCTGTCCTCATTCTCTGTATAGCTTTTGAAGAAATAAGCAGGACAGATTTGTACATTTATATATGATCCAGAACCTTTTCATCCAGCACTACTTCCTTGCAACAAATGTTATATCATTCACTAACACCAAACCTCTTCTCTCAGTACACAAATTAAAATCCTTTCAGAGATTGGCAGAACTCTTGAGCTGTTCCCTTTGTTCCCTTCAGCCACCTGCGTACGGCCAAGTCCTCTTTCTGAGTTCACTCTTTTCTTCTCCTTTGCTTCAACACATTTTGGCTATCTCCCCTTAGCTTGTTCAGTCCCATACCTTACCTATAGTTTGTCTGCAAAGACAGACCAGCCACGAGTCACAAGATAAGTAACAGACTGATCTCCATCCATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCCCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAGAGATCTAAATGTGATTATGATTGGTAAAGTGAAAGCTACCAGATGATCTGATCGCAGCCTTAGCTGGGGCCATGATAGTTTTGGTACTGTGTTGAGAACACAAAGTTGAGCCCTACCCATAAAGATTCTTTTATCTGCAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGACGGTGCTGACTTTGGCAAGTGGCGGGCAGTGCTGAAGATTACCAGCACAACTCCGTCTCAGCTTGCTATCCAGGAGAATGCTAACACACTTGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCCTCCACTAGCCTTTATTGAGATGCTGTTACGAGTTCTCACTGTTTCCTGTGATAGCAACTATATCTCTGTAAGCAGATTAAAAAATAATAAGAAAGAGCAGCCAGACTGCAATCAGGACACTATCAGTGTTGGGTTGGGCAGTTTTGTTTCCACACCAGCAAAGATTTTTCCGTTTTCTTTCCTTAGCATGGGTTGGTGCCCATTGTAGAACCAGAAATCTTGCCTGACGGAGACCATGATCTCCAGCGTTGTCAGTATGTGACAGAAAAGGTAAGCTATCCTTGCTATGCCCCTCTTCAAAAATCACTGATTGTCTAGTGCAGAGTTTGCATTCACAAATCTTATGGGGTTTTGACCAAAAAAATACTTCGTAACTACACTGTAGAAATGAGATGTCACAAATGATGATTTAATAGAAAATAAGAGTTTTAGAAAACAAGAGAAATTTAGTCGCTTGTCATTTGGATGCCAAATCGAATCTCTGTTACAAGCATCTCACAAAGGTTAATGGGGGGTAAAAATATCTACCTCTTATTCTGTACCCATGTCCACAAATAAATCCAAGAAACATAAAGAGTATCTTAGTCATGCCAAAAGCAGTAGTATCTCCAGGGCTGCACTCGCCACCGCTGTGCTAAACTTCAAGAGAAAGGGAAGTTCAGTTTGATCTTCTCTCCGCTCCCTCAAGCAATAAGCTGTCTTTTCACAATAGGCTGAGCACACTGCATGTGAGAATTAGGTGAGTCTCAGTATGTCAAGACCTCAGAGGCATGGGTGAGGAATGTGAAATCTCAGCATACTGTGATCATGGGTCTATATTAATCCTCCTGTTCTCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGATCACCATGTCTACTTGGAAGGGACACTGCTGAAACCGAACATGGTGACAGCTGGGCATTCCTGTCCCAAGAAATACACACCTCAGGATGTAGCTGTAGCAACTGTCACTACTCTCCTGCGTACTGTTCCTGCTGCTGTGCCTGGTGATTCCCAATTTATTTCTATGTACCCATTACTATGTATCACACTGTCATTCTCACTGGCCTTGCTCCTGAACTCATTGCTCTAGCACATAAGGGTCAGGGGCTATGGTGGCTGCAGCACTCAGCTTCTTTTCTTCCGTATTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACTTAAATGCCATGAAT\n>Nothoprocta\nAAAAAGGCATTGTGGTGGGAATAAAGGTGGGTATCTGTATTTATCTAGTTGTCATAATATTCTAAGCCCTATTTCCAATGAGAACTGTAATACAGGGGCTGCACTCTTCGCTGCAAAATATTTTTCCTTGTTTTTTAGAAAGCGTTGAGATCTCTGTCCTCATTCTCTGTACAGCTTTTGAAAAAAAATAAGCAGGACACATTTGTACATGATCCAGCACCTTTTCATCCAACACTACTTCCTTGGAGCAAATGTTGCAACATTCACTGATACCAAACCTCTCATCTCAGTACACAAATTAAAATCCTTTCAGAGGCTGACAGAACTCTTGAGCTGTTCACTTCAGTCATCTGTGTATTGCTCAGTCGTATTTCCCAGTGAACTCCTTTCTTCCCCTTCAGCACATTTCAGCTATCTCTCCTTAGCCTGTTCAGTCCCGTACTTTACTTATAGTTTGTCTGCAAAGACAGAATAGCCATGGGTCACAAGATAAGTAACAGACTGATCTCTATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCCCTAGCAGGAACAAATGGAGAAACCACCATACAAGGCAAGGAAAGATCTAAGTATGATTATGATTGACAAAGTGAAAGCCATCAGATGACCACAGCCTAAGCTGGTGTCATGATACTTCTAGGACTGTGCTGAGAACACAAAGTTGAGGCCTACCTATAAGGAACTGCTTTCAGTGAAGCACTGTTCTTTCATCTGCAGGGCTGGATGGACTAGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGGGCTGACTTTGGCAAGTGGCGGGCAGTGCTGAAGATTACCAGCACAACTCCCTCTCAGCTTGCTATCCAGGAGAATGCTAACACACTTGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCCTCCACTAGTCTTTCTTGAGATGCTGTTACTAGTTCTTAACTATTTCCTGTGATAGCAACTACATCTCCGTAAGCAGTTTAAAAAACAACAACAAAAAAGCAGCTAGACTGCAACTAGCATACTATAATTGCTGGGGGTGTCGGCAAAGATTTTTCTTTTTTTCTTTCCTTAGCATGGGTTGGTGCCCATTGTAGAACCAGAAATCTTGCCTGATGGAGACCATGATCTCCAGCGTTGTCAGTACGTGACAGAAAAGGTAAGTTACCCATGCTATGTGCCTCATCAAAAATCAGTGATTAGTGCAGAGTTTACATTCACAGATAATCAGGGGAGTTTAACCAAGAAAATACTTGGTAACTTTATCACAGAAATGAGATGCTCATATATGATGATTTATTGGAAAACAAGAGACCAGAATCTAGTCTCTTGTCTTTTACATGCCAAATTGAATATCTGTTAGAAGCATCTCACAAAGATTCATGGGGAGTAAAATTGCCTGTTCTTCTGTAACCCTGTTCACAAATCCGAGAAAGATAAAGAGTACCTTAGTCATTCCCAAAGCAGTAGTATCTCCAAGGCTGTAGTAGTGACCCCAGTGACAAACTTCATGAGAAAAAAAAGCTCAATTTCATACTCTCCATACTTTTCTCCATACCGTCAAGAAATAAGCTATTTTTCCACAATAGGCTGAGCACACTGCAGGTGAGAATTAGATGAGTCTCAGTATGGAAAATCTCCGAGGTATGAGTCAGAGATCTGAAATTTGAGCATACTGAGATCATGGGTCTATATTTAATCCTCTTGTTCTCAGGTTCTGGCTGCAGTCTACAAGGCCTTGAATGATCATCATGTCTACTTGGAAGGAACACTGCTGAAACCCAACATGGTGACAGCTGGGCATTCCTGCCCCAAGAAGTATACCCCTCAGGATGTTGCCGTAGCAACTGTCACTACTCTCCTGCGTACTGTTCCTGCGGCTGTGCCTGGTGATTCCTAATTTATTACTATGTACCCATTACTTTGTGTCAAACCATCACACTGTCACTGTCACTGGCCTTGCTCCTAAACTCATTGCTCTGGCAGATAAAAGTCAGTGGCAATGGTGGCTGCAGCACTCAGCTTCTTCCCTTCCTTACTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAACGAAGAGGAGGA\n>Ciconia\nAAAAAGGCATTGTGGTGGGAATAAAAGTGAGTATCTGTACACGTGTGGCAGGCAGCATACTCCAAACCCCGTTTCCAGTGAAAATTATATATGGGGCTGCACTCTCTCCTGCCAAACACTTTTTTTTCTTTTTTTGTGCTTGATTTTAAAATCCCTAGAGGATCTCTGCCACCATTCTATGCATTGCTTTTGTACAACTAACCAGGGGCACATTTGCATTTGATGTAGGAACTTTTCATTCACCAACTCCCATCTACTCACCATTCACTGCAATTAAATCCCTCCATGCAGTAACCTAAATCCAGTCCTTTCAGCATCTGACAGAGCTCTTGAACCATTCCCTGCAGCCTTCTACACATTGCCCCTTCCTCTTACCCAGTTCACTCCTTTTCTTCCCCTTTGCTCCAGCGTTTCCCTCCTTTGCACCCTTAGTGTGTTCAGCCCCATACGTTACTCACAATCAGCCTGCAAAGACAGACTAGCCATGGGTAAGAAGATAAGGATGACACTGATCTCCATCTCTCTGTAACCGTTCCTGTTTTTCGGGTCTCCACAGCTGGATAAAGGCACAGCACCCCTAGCAGGAACAAATGGAGAAACCACCATTCAAGGTAAGGAGAGATCTAAGGAACCTAAGCTATGACTGGTGCAGCAAAAGCCAAGGGGTGACTCGCCTGAGTCACAGCCTTGGCTGGTGTCACGGTACTTTTCAGAGCTATGTCCTGAAGAACTGCTCTCAGTGAAGCACTGTTCTTTCATCTGCAGGGCTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGACGGTGCTGACTTTGGCAAGTGGCGTGCAGTGCTAAAGATCACCAGCACAACACCCTCTCAACTCGCCATCCAAGAGAATGCCAACACATTGGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCCTCCAGCAACCCTTCCCGAGATGCTGTTGCCCGTTCTGACTGCTCCCTGTGATAACATGCTAGGTAACTTGAAAGGCGGATCTCTGCGAGGGTTTTGGGAAAGATGAGGAAGAAGGGCAGCGCAGCAAGAAGGAATACCAACAAAGTCAGGGTAGACAACAAGGACTGGTTTTCTTCCACGCTCTCCAAAACTTCCCTGTTTTTCTTTCCTTAGCATGGCTTGGTGCCCATTGTGGAACCAGAAATCTTGCCTGATGGAGACCATGATCTCCAGCGCTGTCAGTATGTCACAGAAAAGGTAAGAGATTCCTGCCCCCGTCCTCCCCTTCACAAATCAGTCGCTAATCTTATGCAGAGTTTGTGTTCACAGATCTCAGAGAGTTTTGACCAAAAATGTACTTCATAACTGCATCACAAAAATGAGTTGCTCATGGTCAAATAATGAATTAACAGCCAATGTGAGAGTAGAATCCATGCTTTTGGATTTCCACTCAAACTGCCAATATAAGCATTCTCAATCTCAAAAAGATGGATTGGGAGCAAAACCACTTACCCCTCTTTCAGTGCCTCAGTTTGCAGGGACAAATCCAGTAAATAGGAAGAGGGGTATCCTGGTCATCTCAAAAGCAGTGGTGTCTCCAGGGCTGCAACCCCTGGGATAAATTTCACAAGTTCAATTTGATCTTCTTACACTCCCAAGCAATAAGCTGTCTTTCCACAGCAGGTTGAGGTGAAGATTTCAGCAGAGGTCTGTATTCAATCCTTCTCTTTTCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAATGATCATCATGTCTACCTGGAAGGCACACTGCTGAAACCCAACATGGTGACGGCTGGGCATTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCGTAGCAACTGTCACTACTCTTCTCCGTACCGTTCCTGCTGCTGTTCCCGGTGATTCCCAATTCATTCCTATGTATCCATTCACACTGTCACTCTTGCTGGCCTTGCTCCTACATCTAACACGCTCACTCCTCTGGCACGTAAAGGTCAGGGATTGCGGTGGCTGGAGCACTCTCTGAACCTCAAAACCTCTTTCTTGCAGGAATCTGCTTCCTGTCTGGAGGTCAGAGTGAAGAGGAGGCTTCTGTCAACCTGAATGCCATGAAT\n>Buteo\nAAAAAGGCATTGTGGTGGGAATAAAGGTGAGTATCTGCAGATGTCTGGATGGCAGCATAATCTAAAACCCATTACCAGTGAAAATTATATATGGGGCTGCACTCTCTCCTGCCAAACACCTTTTTTCTTTTTTGTGCTTGGTTTTAAAATAACTAGAGGATCTCTGCCACCATTCTCTGCATTGCTTTTGTACAACTAACCAGGAGCACATTTGCATTTAGTGCAGGAACTTTGCATTCACCAACTCGCACCTACTCACCGTTTGCTGCAATTAAATCCCTCCATGCAGTAACCTAAATCCAGTCCTTTCTGCATCTGATAGAGCTCTCGAGCCATTCCCTATGGCCATCTACACATTGTCCCTTCCTCTTGACCAATTCACTCCTCTGCCTCCCCTTTGCTCCAACATTTCCCTCGTTTGCACCCTTAGCATGTTCAGCACCATGCTTCACTCACAGTCAGCCTGCAGCGACAGACTAGCCATGGGTAAGAAGGCTGATCTCTATCTTTCTGTAACCCTTCCTGTTTTCCTCATCTCCACAGTTGGATAAAGGCACAGCACCCCTAGCAGGAACAAATGGAGAAACCACCATCCAAGGTAAGGAGAGATCTAAGGAGCCTAAGTTATGACTGGTGGAACAAAAGCCATGGGGTGGCTACCCTGAGTCGCAGCCTGGGCTGGTGTCATGGTACTTTCAGAGCTATATCCTAAAGAACTGCTCTCAGTGAAGCACTGTTCTATCATCTGCAGGGCTGGATGGATTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGCTGACTTTGGCAAGTGGCGTGCAGTGCTGAAGATCACTAGCACAACACCCTCTCAACTTGCCATCCAAGAGAATGCCAACACATTGGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCTTTCCTGAGATGCTGTTGCCCCTTCTCACTGTTCTCTGTGATAACATGATAGGTAACTTGAAAGGCAGATCTCTGTGAGGCTTTTGGGAAAGATGAGGTAGAAGGGCAGTGCAGCAAGAACGAATACCACCAGTCAGGGTAGACAAGAACAGTTTTTCTTCCACATCCCTAGTGACTTCCCTGTTTTTCTTTCCTTAGCATGGCTTGGTGCCCATTGTGGAGCCGGAAATCTTGCCTGATGGAGACCATGATCTCCAACGCTGTCAGTATGTCACAGAAAAGGTAAGAGATTCCTGCCCCTCTCCTCCCCTTCACAGATCAGTAGCTGATCTTATTCAGTTTGTACTCACACATCTCAAGGAGTTTTGACCAAAAAGGTACTTCGTAACTGCATCACAAAAATGAGTTGCTCACAGTTAATAGTGAATGCGAGAGTAGAATCCATGCTTTTGGATTTCCACTCGAACCACCTATATAAGCATTCTCAATCTCAAAAAGATGCACAGGGACCAAACCCACTGACCACTCTTTCAGTACCTCAGCTTGCAGGGACAAGTTCAGTAAATATGAAGAGTGGTATCCTGGTCATCTCAAAAGCAGTGGTGTCTCCAGGGCTGCAACCCCTGTGATAAATTTCATGAGAAAGCAAAATTCAATTTGATCTTCTCACACTCCCAAGGAATGAGCTGTCTTTCCACAGAAGGTTGAAGTGAAGATTTGAGCAGAGATCTACATTCGCTCCTCCTGTTTTCAGGTTCTTGCTGCTGTCTACAAGGCCCTGAATGATCATCATGTCTACCTGGAAGGGACACTGCTGAAACCCAACATGGTGACAGCTGGGCACTCCTGCCCCAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTTCTCCGCACCGTTCCTGCTGCCGTTCCCGGTGACTCCCAGTTCATTCCTATGTATCCATTCACACTGTCACTCTTGCTGGCCTTGCTCCTACATCTGACATGCTCACTCCTCTGGCACATAAAGGTCAGGGATTGCGGTGGCTGAAGCACTTAAGCCTCGAAACCTTTTTCTTGCAGGAATCTGCTTCCTGTCTGGAGGTCAGAGTGAAGAGGAGGCTTCTGTCAACCTGAATGCCATGAAT\n>Eudromia\nAAAAAGGCATTGTGGTGGGAATAAAGGTGGGTATCTATACATGTCTGGCTGTCAAAATACTCTGAGCCCTGTTTCCAATGAGAACTATAACACAGGTGCCACATGCTTCTCGGCAAAACATTTTTCCATGTTTTTTAAAAAATCTAGATCTGTCCCCATTCTTTGTACAGCTTTTGAAGAAATAAGCAGGAAATATTTGTACATTTATATACGATCCAGCACCTTTTCATCCCGCACTACTTCCTTGTAACAAATGTTGCAACATTCACTGATACCAAACCTCTTCTGTCAGTACACAAATTAAAATTCTTTCAGAGGCTGACAGAACTCTTGAACTGTTCCCTTCAGCCACCTGTGTATTGCCCAATCCTCTTTTTCAGTGAACTCCTTTCTTCCCTTTTACTTCAACACATTTTAGCTATCTCCCCTTAAACTGTTCAGTCTCATACTTTACCTATAGTTGGTCTGCAAAGACAGACTAGCCATGGGTCACAGGATAAGTAACAGATTGATCTCCATCTATTTTTCCTGTCTCCACAGCTGGATAAAGGCACAGCACCTCTAGCAGGAACAAATGGAGAAACGACCATACAAGGCAAGAAGAGATCTAAATATGATCATGATTGGTAAAATGAAAGCCCTCCCCATAAAGAACTGCTTGCAGTGAAGCACTGTTCTTTCATCTACAGGGCTGGATGGACTGGCTGAGCGCTGCGCCCAGTACAAGAAAGATGGTGCTGACTTTGGCAAGTGGCGGGCAGTGCTGAAGATCACCAGTACAACTCCATCTCAGCTCGCTATCCAGGAGAATGCTAACACACTTGCACGCTATGCCAGCATCTGCCAGCAGGTATGTACTGTCCATAAGTCTTTCTTGAGATGCTGCTAACCATTTCTCATTGTTTCCTCCAAAGAAGAGCAAGAATGAGCAGCCAGACTGCAATCAGGATACTATCAGTGTGAGCAGGTTTTTTTTCCACATCAGCAAAGATTTTTCTGTTTTTCTTTCCTTAGCATGGGTTGGTGCCCATTGTAGAACCAGAAATCTTGCCTGATGGAGACCATGATCTCCAGCGTTGTCAGTATGTGACAGAAAAGGTAAGCCACCTTACTACGCTCCTCCCACAAAATCAGTCATTTATCTAGTGTAGAGTTTGCATTCACAGGTCTTAGAAGGGTTTGACCAAAAAAATACTTCCTCACTGCAACGCAGAAATGAGACACTCACAAATGATGATTTCATAAAAAAAAAAAAAAAAAAAAAAAGACTAGCATTCTAGTTTCATGTCCTCTGGATGCCAATTGAATCTCTGTTAGAGGCATCTCAAAAGATTCATGGGAAGTAAAATTATCTACCTTTTCTCTGTACCCGTATTCATCAAATCCAAGAAATATAAAGAGTAACTTAGTCATCCCAAAAGCAGTAGTATTTCCAGGGCTGCACTAGTGCCCTCTGATAAACTTCAGGAGAAAGAGAAGTTCCGTTTGATCTTCTCTCCACAACCTCAGCAATAATTCCACAATAGGCTGAGCACACTGCAGGTGAGAATTAGATGAGTCTCAGTATGTGAAGATCTCTGAGGCATGGGTCAGAGATCTGATATCTGAGCATATTGATATCATGGGTCTATATTTAATTCCCCTGTTCTCAGGTTCTGGCTGCTGTATACAAGGCCTTGAATGATCACCATGTCTACTTGGAAGGGACACTGCTGAAACCCAACATGGTAACAGCTGGACATTCCTGCCCGAAGAAGTACACCCCTCAGGATGTAGCCATAGCAACTGTCACTACTCTCCTGCGTACTGTTCCTGCTGCTGTGCCCGGTGATTACCAGTTTATTACTATGTATTGTGTACTATCTATGTATCAAACCATCACACTCTCAGTCTCATTGGCCATGCTCCTAAACTCATTGTTCTGGCACATAAGGATCAGGGGCTGTGATAGCTGCAGCACTCAGCGTCTTCCCTTTCTTATTGCAGGTATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTAAATGCCATGAAT\n>Anas\nAAAAAGGCATTGTGGTGGGAATAAAAGTGAGTATCTGTACATGTGTGGGGTCTATACTCACTCCCAACAACAACTTTTGTTTGTTTTTTTTCGGTTTTGAAATCCCTAGAATGTCTCTGCTACCATTCTCTGCATTGCTTTTGTACAACTAAACAGTGAAACATTTGCAACCGATGCAGGACCCTTTTGTCCAACAGCACCCATATATTTACCATTCACTGCAGTTACATCCTTCCATGCAATAACCTAATTAAATCCTTTCTGCAGCTGACAGAGCTGTTGATCTACTCCCCACAGCCACCTGCATATTGCCCCCATGACCCAATTCTCTCCTGTTCCTCCCCTTTACTGGAGCCCTTCCCTTCCTTCCACTAGCAGTCTGTTCAGCCCTATACTTTACTCACAGTTAATCTGCAAAGGTAGACTAGCTCTGGGGTGCAAGGCTCAGGCTGACCTCCCTCACTCTGTAACTCTTTCTGTTTCTGCTGTCTCTTCAGCTGGATAAAGGCACATCGCCCCTAGCAGGAACAAATGGAGAAACCACCATCGAAGGTAAGGAGAGATCTAAGAAGCCTTAGCTATGACTAGTGAAAGTCATGGGGTGACTCAACAGGAGTTGCAGCCTTGGCTGGTGTCATGGTACTTTTCAGAGTTATTTCTGAAAGAGCTGTTCTCACTGAAGCTCTGTTCTTTCACATGCAGGACTGGATGGACTGTCTGAGCGCTGCGCCCAGTACAAGAAAGATGGTGTTGACTTTGGCAAGTGGCGTGCAGTGTTGAAGATCACCAGCACAACACCCTCTCAACTTGCCATCCAAGAGAATGCCAACACACTGGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCCTTCTGCAGCCTTCCTTGAGATGTTTTCGTCCCTTTTTCACTGTTCCCTCTGATAATAGACTAGGTATTGTGAACAGTGGATCTCTGTGAGGGTCTTGGGAAATGTGGAGAAAGGGCAGTGCAGAAAGAAGGCATGTCACCAGAGACAATACAGACAGCCAGGACAGTTTTTCTTTCCCACCTCCAAAAACTTCCTTGTTTTTCCTTCCTTAGAATGGCTTGGTGCCCATTGTGGAGCCAGAAGTCTTACCTGATGGAGACCACGATCTCCAGCGCTGCCAGTATGTCACAGAAAAGGTAAGATTCTTGATCTCTGCACCCTCACAAATCAGTAGTTAATCTTATGCAGGGTTTGCATTGACAGATTTCAATGAGTTTTGACCAAAAAGGTCCTTCATAACTGTATCACAGAAATGGGTCACTCATAGTCAAATAATTAGCTAGTAGCAAATGTGAGAGCAGAATCCCTGTTTTTGGATTTCCAGTCAAACTGTCAATATAAGCATTCCTGAGCTGAAAAGGATACATTGGTTATAAAGGCATTTATTCCTTGTTCAGTATGTCAGTTTGTAAGGACAAATCCAATAAAAAAGGAAAATGTCCTAGTCATCACAAAAGCATCGGTGCCTCCAGGGCTGCAACCCCTGTGACAAATTTCAAGAAATTTAGTTTGATCTTCTCCCACTTCCAAGGAATTAGCTGTCTCTCCACAGTAGGCTGAGGTAAAGCATTGAGCACAGATGTGTATTCAATCCTCCTATTCGCTCCCCCAGGTTCTGGCTGCTGTCTACAAGGCCTTGAACGATCATCATGTCTACCTGGAGGGGACATTGCTGAAACCCAACATGGTGACAGCCGGGCATGCCTGCACCAAAAAATACACCCCTCAGGATGTAGCTGCAGCAACCGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTTCCTGGTGATTCTTGATTTGTTCCCATATATCCCTTCACACTGTCACTCCTACTGGCCTTGCTCCTCCATCTGACATGCTCATTTCTCTGGCACACAGAGGTCAGAGATGGTGGCTTGGCGGCTGGAGCGCCCCAGTTTCTAAGTCCTGAGGTCTCTTTCTTTCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACCTGAATGCTATGAAT\n>Corvus\nCCATCCAAGGTAAGGAGAGATCTAAGGAGCCTAAGCTAAGGCCCAGCAAAAGCCATAGGGTGACTCACCTGAGACGCAGCCTTGGCTGGAGTCATGGGACTTTGCAGAGTTCTGTGCTGAAGAGCAGCTCTCAGTGAAGCACTGTTCTCCCTCTGCAGGGCTGGATGGGCTGGCTGAACGCTGTGCCCAGTACAAAAAAGATGGTGCTGACTTTGCTAAGTGGCGTGCAGTGCTGAAGATCACCAGCACAACACCCTCTCAGCTTGCCATCCAGGAGAACGCCAACACGTTGGCGCGCTATGCCAGCATCTGCCAGCAGGTACCTCCCCTCCAGCAACCTCTCCTGAGATGCTGCTGCCCCTTCTCACTGTTCCCTAGCATGTGATAACATGCTAGGTAGTTCGAAAGGAGAATCCCCGTGAGGGTTTTGGGGAAGACAAGGAGGAAGGGCAGTGCAGCATAAAGGAATGCCACTAAACTCAGGGCAAACAACAAGAACAGTTTTACTTCCATAGCTCTAAAGAATCCCCTGTCTTCCTTTTCCTAGCATGGCTTGGTGCCCATTGTGGAGCCAGAAATCCTGCCTGATGGAGACCATGATCTCCAGCGCTGTCAGTATGTCACAGAGAAGGTAAGAGATTCCTCCCTCTGTCCTCCCCCTCACAAATCAGCAGCTAAACTTTGTGCAGTTTGTGCTCACAGATCTCAAAGAAGTTTGACCAAAAATGTACTTCATAACTGCATCACAGAAATCAGCTGCTCCTAGGCAAATAGCAAACTAATAGAAAATCCACGAGTATTTTCCATGTGTTTGGATTTTTATTTCAATGGCAATATAAGCACTCTCAATCTCAAGAAGAGGTATCAGGACCAAACCCAATTACCTCAATTTCAGTACCTCAGTTGGCAAGGACAAATCCTGTAAATATGAACAATTGTATTATTGGTCATCTCAAAAGCAGTGGGGTCTCCACAACTGCAATCCCRGAGATAAATTTCATGAGAAAGCAAAATTCAACTAGATCTTGCTGCAGTACCAAAGAATAAACTGTCTTTCCACAGCAGGCTGAGGTGAAGATCTGAGCAGAGGTCTGTATTCATTCCTCCTGTTTTCAAGGTTCTGGCTGCTGTCTACAAGGCTTTGAATGATCACCACGTGTACCTGGAAGGGACACTGCTGAAACCCAACATGGTGACGGCTGGGCATTCCTGCTCCAAGAAGTACACCCCTCAGGATATAGCCATAGCAACTGTCACTACTCTCCTCCGCACTGTTCCTGCTGCTGTTCCTGGTGATTCCTGATTCACTCCTRTCTCTTCATTCCCACTCTCTCTCCCACCTCTGACATGTCTGCTCCTCTGGCACCTAAAGGTGAGGGACTGAGGTAGCTGGAACACTCTGTTTCTAAGCCTTGAAACCTCTGTCTTACAGGAATCTGCTTCCTGTCTGGAGGTCAGAGTGAAGAGGAGGCTTCTGTCAACCTGAATGCCATGAAT\n>Pterocnemia\nAAAAAGGCATTGTGGTGGGAATAAAGGTGAGTGTCTGTACATGTGTCTGGCTGGCACAATACTCTAAACACTATTTCCAATAAGAACTATAATATAGGGGCTGCACTCTCCCTTGTAGACCAGTATTTTGCTTGTTTCTGAAAATACCTAGAGGATCTCTGCCCCCATTCTCTGTATAGTTTTTGTACAAATATCCAGGACACATTTGTGCATTTACATATAATCCAGGACCTTTTCATCCAGCAAACGATGTACTTCCTTGTACGAATGTTACATCACACACTGAAATTAAACCTCTTCTCTCAGTACACAAACTAAAATCCTTTCTGAGTCTGACAGAACTCTTGAGCTGTTCCCTGCAGCCATCTGCATATTATCTGATCCTCTTACCCATTTCACTCCTTTCTTTCTCCTTTTCTTTAACACTTCTCAGATATGTCCCTTTAGCCTATTAAGTCCAATACTTTACCCACGGTTTGTTTGCAAAGACAGACTAGTCATAGGTCACAAGATAAGTAACAGATTGATCTCCATGTATTTTTCCTGTCTCCACAGTTGGATAAAGGCACAGCACCTCTAGGAGGAACAAATGGAGAAACTACCATACAAGGCAAGGAGAGATCTAAGTAGCCATAATTATGATTGGTAAAGTGAAAGCCATCAGATGACTAAACTCGTTCACAGCCTTAGCTGGTGTCATGTTACATTTCATGTTGAAAGCACTAAGTTCAGCTTTCCCATAAAGAACTGCTGTCAGTGAAGCACTGTTCTTTCATCTGCAGGACTGGATGGACTGGCTGAGCGCTGTGCCCAGTACAAGAAAGATGGTGTTGACTTTGGCAAATGGCGTGCAGTGCTGAAGATAACCAGCACAACTCCCTCTCAACTTGCTATCCAGGAGAATGCTAACACACTAGCACGCTATGCCAGCATCTGCCAGCAGGTATCTACCCTCTACTAATCTTTCCTGAGATGTTGTTACTGTTTCTTATTGTTTCCTGTGATAACAGCTAGATATTTTGAAAGATCAGTCCCTGTGAGAGGTTTCAGAGACAATGAAGAAGAAGAGCCATACAGCAAGAAGGAATACTATCAATGTTGGGRAAGACAGGAAGGACAGTTTTTCTGCCACATCTGCAAAGACTTTCCTGTTTTTCTTTCCTTAGCATGGATTGGTGCCCATTGTGGAGCCAGAAATCTTGCCTGATGGAGATCATGATCTCCAACGTTGTCAGTATGTCACAGAAAAG\n>Crypturellus\nGATCTAGTGCAGAGTTTGCATTCACAGATCTTATCGGGTTTTAACCAACAAAATACTTTATAACTAAACCACAGAAGTGACATGCTTACAAATGATTTANCAGAAACCAAGAGACTAGAATTTTAGCTGTTTGTCTTTTGGATGCCAAATTGAATCAGTTAAAAGCATCTCACAAAGATTAATGGGGAGTAAAATTATCTACCTCTTCCTCTGTATCCCTGTCCACAAAGAAATCCAAGAAACATACAGAGTATCTTAGCCATGCCAAAAGCAGTAGTATCTCCAGGGCTGCACTAGTGACCCCTGTGATAAACTTCAGGAAAAAGGGAAGTTGTTTGATCTTCTCTCCACACTCTCAAGCAATATGCTGTCTTTCCACAACAGGCTGAGCACACTGCATGTGAGAATTAGATGAGCCTCAGATGTCAAGATTTCTGAGGCATGGGTGGGAGATCTGAAATCTGAGCATACTGAGATCATGAGTCTATATTTAATCTTCCTGTTTTCAGGTTTTGGCTGCTGTCTACAAGGCCTTGAATGATCACCATGTCTACTTGGAAGGGACACTGCTGAAACCAAACATGGTGACAGCTGGGCATTCCTGCCCCAAGAAATACACCCCTCAGGATGTAGCAGTAGCAACTGTCACTACTCTCCTGCGTACTGTTCCTGCTGCTGTGCCTGGTGATTCCCTCTGTATTACTATATAGCCATTACTATGTATCAAACCATCACACTATCACTCTCACTGGCCTCGCTCCTAGCTCCTAAACTCACTGCTCTAGCACGTAAGGGTCAGGGGCTGTGGTGGCTGCAGCACTCAGCTTCTACCCTTTGCTATTGCAGGAATCTGCTTCCTGTCTGGAGGTCAAAGTGAAGAGGAGGCTTCTCTCAACTTAAATGCCATGAAT\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxsstat":
        cm = "./pxsstat -s TEST/Bollback_2002_MBE.fa"
        t = '-18.867\n'
    elif name == "pxstrec":
        cm = "./pxstrec -t TEST/test.strec.tre -d TEST/test.data.narrow -c TEST/test.conf | tail -1"
        t = '0.316161 \n'
    elif name == "pxsw":
        cm = "./pxsw -s TEST/test.fa | grep TaxonA | grep TaxonB"
        t = 'TaxonA\tTaxonB\t40\n'
    
    # do standard nvanilla nexus, and one with translation table, and one with quotes labels
    elif name == "pxt2new":
        cm = "./pxt2new -t TEST/test_nexus.tre"
        t = '(((TaxonA:0.1,TaxonB:0.03):0.125,TaxonC:0.25):0.4,(TaxonD:0.23,TaxonE:0.16):0.3);\n'
    elif name == "pxt2nex":
        cm = "./pxt2nex -t TEST/collapse.tre"
        t = '#NEXUS\nBegin trees;\ntree tree0 = [&R] (((TaxonA:0.1,TaxonB:0.03)0.43:0.125,TaxonC:0.25)1.0:0.4,(TaxonD:0.23,TaxonE:0.16)0.94:0.3);\nend;\n'
    
    elif name == "pxtgen":
        res = True
        print("unrooted ", end = '')
        cm = "./pxtgen -n 5"
        t = '(t2,t3,(t4,(t1,t5)));\n(t3,(t1,t4),(t2,t5));\n(t2,(t1,t4),(t3,t5));\n(t2,t3,(t1,(t4,t5)));\n(t2,t3,((t1,t4),t5));\n(t3,(t2,t4),(t1,t5));\n(t1,t3,(t4,(t2,t5)));\n(t1,(t2,t4),(t3,t5));\n(t1,t3,(t2,(t4,t5)));\n(t1,t3,((t2,t4),t5));\n(t2,(t3,t4),(t1,t5));\n(t1,(t3,t4),(t2,t5));\n(t1,t2,(t4,(t3,t5)));\n(t1,t2,(t3,(t4,t5)));\n(t1,t2,((t3,t4),t5));\n'
        if not check_individual_results(cm, t):
            res = False
        print("rooted ", end = '')
        cm = "./pxtgen -n 4 -r"
        t = '(t2,(t3,(t1,t4)));\n((t1,t3),(t2,t4));\n(t2,(t1,(t3,t4)));\n(t2,((t1,t3),t4));\n(t4,(t2,(t1,t3)));\n((t2,t3),(t1,t4));\n(t1,(t3,(t2,t4)));\n(t1,(t2,(t3,t4)));\n(t1,((t2,t3),t4));\n(t4,(t1,(t2,t3)));\n(t3,(t2,(t1,t4)));\n(t3,(t1,(t2,t4)));\n((t1,t2),(t3,t4));\n(t3,((t1,t2),t4));\n(t4,(t3,(t1,t2)));\n'
        if not check_individual_results(cm, t):
            res = False
        print("prefix label ", end = '')
        cm = "./pxtgen -n 3 -r -l taxon"
        t = '(taxon2,(taxon1,taxon3));\n(taxon1,(taxon2,taxon3));\n(taxon3,(taxon1,taxon2));\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxtlate":
        res = True
        print("standard ", end = '')
        cm = "./pxtlate -s TEST/trlateTest.fa"
        t = '>Dendroica_kirtlandii\nMPQLNPTP*FFIMLTS*LTFSLIIQPKLLSFVSINPPSNKPSIAPTTTP*T*P*T*\n>Cardellina_canadensis\nMPQLNPSP*FFIMLTS*LTFSLIIQPKLLSFVSTNPPSNKPPIAPSTTP*T*P*T*\n>Geothlypis_tolmiei\nMPQLNPSP*FFIMLTS*FTFSLIIQPKLLSFVSINPPSSKPRITPNTTP*A*P*T*\n>Dendroica_coronata\nMPQLNPNP*FFIMLTS*LTFSLIIQPKLLSFVSINPPSSKPPIAPTTTP*T*P*T*\n>Leiothlypis_celata\nMPQLNPSP*FFIMLTS*LTFSLIIQPKLLSFVSINPPSSKPPIAPSTTP*T*P*T*\n'
        if not check_individual_results(cm, t):
            res = False
        print("vert mtDNA ", end = '')
        cm = "./pxtlate -s TEST/trlateTest.fa -t vmt"
        t = '>Dendroica_kirtlandii\nMPQLNPTPWFFIMLTSWLTFSLIIQPKLLSFVSMNPPSNKPSIAPTTTPWTWPWT*\n>Cardellina_canadensis\nMPQLNPSPWFFIMLTSWLTFSLIIQPKLLSFVSTNPPSNKPPIAPSTTPWTWPWT*\n>Geothlypis_tolmiei\nMPQLNPSPWFFIMLTSWFTFSLIIQPKLLSFVSMNPPSSKPRITPNTTPWAWPWT*\n>Dendroica_coronata\nMPQLNPNPWFFIMLTSWLTFSLIIQPKLLSFVSMNPPSSKPPIAPTTTPWTWPWT*\n>Leiothlypis_celata\nMPQLNPSPWFFIMLTSWLTFSLIIQPKLLSFVSMNPPSSKPPIAPSTTPWTWPWT*\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxtrt":
        cm = "./pxtrt -t TEST/yule_100taxa.tre -n taxon_1,taxon_2,taxon_3,taxon_5,taxon_8,taxon_13,taxon_21,taxon_34,taxon_55,taxon_89"
        t = '((((taxon_1:0.6982661782487307,taxon_2:0.6982661782487307):1.6249815565818162,(((taxon_3:1.312206397223513,(taxon_5:0.9561412887678671,taxon_8:0.9561412887678671):0.3560651084556459):0.4159628031666056,taxon_13:1.7281692003901186):0.4425292521420627,taxon_21:2.1706984525321813):0.1525492822983656):0.645808102187384,taxon_34:2.969055837017931):2.0856420237227193,(taxon_55:3.3233579219493956,taxon_89:3.3233579219493956):1.7313399387912545);\n'
    elif name == "pxtscale":
        res = True
        print("scale ", end = '')
        cm = "./pxtscale -t TEST/test.tre -s 10"
        t = '(((TaxonA:1,TaxonB:0.3):1.25,TaxonC:2.5):4,(TaxonD:2.3000000000000003,TaxonE:1.6000000000000001):3);\n'
        if not check_individual_results(cm, t):
            res = False
        print("root height ", end = '')
        cm = "./pxtscale -t TEST/ultra_100.tre -r 65.5"
        t = '((((s1:13.553573187430807,s2:13.553573187430807):33.7331074035328058,s3:47.2866805796801017):15.8252934960289391,(((s4:4.4770404482656234,s5:4.4770404482656234):0.956905971316084,s6:5.4339464210861745):28.7640659957904852,s7:34.1980124168766579):28.9139616701158921):2.3880259130074513,((s8:11.6855353596727642,s9:11.6855353596727642):3.8796767729292201,s10:15.5652121326019852):49.9347878666457774);\n'
        if not check_individual_results(cm, t):
            res = False
        print_success(res)
        return res
    elif name == "pxupgma":
        cm = "./pxupgma -s TEST/protein_matrices/AA_5tax_interleaved.NEX"
        t = '(((TaxonB:0.068,TaxonA:0.068):0.108,TaxonC:0.176):0.171,(TaxonE:0.164,TaxonD:0.164):0.183);\n'
    elif name == "pxvcf2fa":
        cm = "./pxvcf2fa -s TEST/vcf_file"
        t = '>APC1\nCACCCCATTCTCGCATCATCCAACGCCCACGAAGCATTATGACCGGTACGCGCCCTGGTCGCCGCGGGCGTCGACCCCC\n>APC2\nCGCCCCATTCTCGCATCATCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>GPC1\nCGCCCCCTTCTCGCACCATCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCTCGGGCGCCAACCCCC\n>GPC2\nCGCCCCCTTCTCGCACCACCCAACGCCCACGAAGCATTATGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>GPC3\nCACCCCCTTCTCGCACCATCCAACGCCCACGAAGCATTATGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCGACCCCC\n>GPCREF\nCGCCCCCTTCTCGCACCATCCAACGCCCACGAAGCATTATGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCGACCCCC\n>HH1\nCACCCCCTTCTCGCATCATCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>HH2\nCACCCCCTTCTCGCATCACCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>HH3\nCACCCCCTTCTCGCATCACCCAACGCCCACGAAGTATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>HH4\nCACCCCCTTCTCGCACCATCCAACGCCCACGAAGCATTATGACCGGTACGCGTCCTGGTCGCCGCGGGCGCCAACCCCC\n>HH5\nCACCTCCTTCTCGCATCACCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>LPC1\nCGCCCCATTCTCGCACCATCCAACGCCCACGAGGTATTATGACCGGTACGCGCCCTGGTCGCCTCGGGCGCCAGCCCCC\n>LPC2\nCGCCCCATTCTCGCACCACCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>QHH1\nCACTTCCTTCTCGCTCCGTCCGACATCTACGGAGCATCGTGACTGGCACACGTCCTGATCGCTTCAGACGCTAACCCCT\n>QHH2\nTGCCCCCTTCTCACACTATCTAATGTTCACAAAGCACTAGAACCGGTACGCGCCTTGGTCACCGTGAGCGCCGACTTCC\n>QHH3\nCACCCTCCTCTCGCATCATCCAACGCCCACGAAGTATTAGGACCGGTCCGCGCCCTAGTCGCCGCGGGTGCCAACCCTC\n>QHH4\nCGTCCCCTTTTCGCACCATTCAACGCCCACGAAACATTAGGATCGGTATGTGCCCTGGCTGCCGCGGGCACCAATCCCC\n>STG1\nCGCCCCCTCCTCGCACCATCCAACGCCCATGAAGTATCATGACCGGTACGCACCCTGGTCGCCTCGGGCGCCAACCCCC\n>STG2\nCGCCCCCTCCTCGCACCATCCAACGCCCGTGAAGCATCGTGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>GNNSN\nCGCCCCCTTCCAGTACCATCCAGCGCCCACGAAGCGTTATGGCCAATACGCGCTCCGGTCGTCGCGGGCGCCGACCCCC\n'
    else:
        return
    p = subprocess.Popen(cm, shell=True, stdout=subprocess.PIPE)
    x = p.communicate()
    #print(x)
    x = x[0].lstrip().decode("utf-8")
    if x == t:
        print(bcolors.OKBLUE + "PASSED" + bcolors.ENDC)
        global pass_count
        pass_count += 1
        return True
    else:
        for i,j in zip(x,t):
            print(i, j, i == j)
        print(bcolors.FAIL + "FAILED" + bcolors.ENDC)
        print("intended output:\n", t)
        print("your output:\n", x)
        global fail_count
        fail_count += 1
        return False

# this are skipped in the testing because they are preliminary, tests will
# be added as they become more permanent.
notest = ["pxnni", "pxssplit"]
# (for now) ignore tests that fail due to random numbers
ignore = ["pxbdsim", "pxboot", "pxpoly"]
    
if __name__ == "__main__":
    dir = "." # by default test non-installed programs
    if len(sys.argv) == 2:
        dir = sys.argv[1]
        print("guess you want to test in: " + dir)
    elif len(sys.argv) > 2:
        print("python run_tests.py [program directory]")
        sys.exit(0)
    
    passed = 0
    failed = 0
    failedl = []
    skipped = 0
    ignorefailed = 0
    ignorefailedl = []
    print("=================")
    for i in sorted(os.listdir(dir)):
        if i[:2] == "px":
            if i in notest:
                print(bcolors.WARNING + "skipping " + i + bcolors.ENDC)
                skipped += 1
                print("=================")
                continue
            t = test_program(i)
            if t == True:
                passed += 1
            elif t == False:
                if i in ignore:
                    ignorefailed += 1
                    ignorefailedl.append(i)
                else:
                    failed += 1
                    failedl.append(i)
            else:
                print(bcolors.WARNING + "no test for " + i + bcolors.ENDC)
                skipped += 1
            print("=================")
    print("PASSED PROGRAMS: " + str(passed) + " (" + str(pass_count) + " tests)")
    print("FAILED PROGRAMS: " + str(failed) + " (" + str(fail_count) + " tests)")
    print("PROGRAMS WITHOUT TESTS: " + str(skipped))
    if ignorefailed > 0:
        print("The following programs had anticipated failures (random numbers):")
        print("\t",",".join(ignorefailedl))
    if failed > 0:
        print("These failed:")
        print("\t",",".join(failedl))
        sys.exit(1)
    else:
        sys.exit(0)
