/* util.c generated by valac 0.44.9, the Vala compiler
 * generated from util.vala, do not modify */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <stdarg.h>
#include <gio/gio.h>
#include <unistd.h>

#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define WIXL_TYPE_UNIX_INPUT_STREAM (wixl_unix_input_stream_get_type ())
#define WIXL_UNIX_INPUT_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIXL_TYPE_UNIX_INPUT_STREAM, WixlUnixInputStream))
#define WIXL_UNIX_INPUT_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIXL_TYPE_UNIX_INPUT_STREAM, WixlUnixInputStreamClass))
#define WIXL_IS_UNIX_INPUT_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIXL_TYPE_UNIX_INPUT_STREAM))
#define WIXL_IS_UNIX_INPUT_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIXL_TYPE_UNIX_INPUT_STREAM))
#define WIXL_UNIX_INPUT_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIXL_TYPE_UNIX_INPUT_STREAM, WixlUnixInputStreamClass))

typedef struct _WixlUnixInputStream WixlUnixInputStream;
typedef struct _WixlUnixInputStreamClass WixlUnixInputStreamClass;
typedef struct _WixlUnixInputStreamPrivate WixlUnixInputStreamPrivate;
enum  {
	WIXL_UNIX_INPUT_STREAM_0_PROPERTY,
	WIXL_UNIX_INPUT_STREAM_FD_PROPERTY,
	WIXL_UNIX_INPUT_STREAM_NUM_PROPERTIES
};
static GParamSpec* wixl_unix_input_stream_properties[WIXL_UNIX_INPUT_STREAM_NUM_PROPERTIES];

typedef enum  {
	WIXL_ERROR_FAILED,
	WIXL_ERROR_FIXME
} WixlError;
#define WIXL_ERROR wixl_error_quark ()
struct _WixlUnixInputStream {
	GInputStream parent_instance;
	WixlUnixInputStreamPrivate * priv;
};

struct _WixlUnixInputStreamClass {
	GInputStreamClass parent_class;
};

struct _WixlUnixInputStreamPrivate {
	gint _fd;
};

static gint WixlUnixInputStream_private_offset;
static gpointer wixl_unix_input_stream_parent_class = NULL;

GQuark wixl_error_quark (void);
void uuid_generate (guchar* uuid);
void uuid_unparse (guchar* uuid,
                   guchar* output);
gchar* wixl_uuid_generate (void);
gpointer wixl_enum_from_string (GType g_type,
                                GBoxedCopyFunc g_dup_func,
                                GDestroyNotify g_destroy_func,
                                const gchar* str,
                                GError** error);
static GEnumValue* _g_enum_value_dup (GEnumValue* self);
void wixl_hash_table_add (GType g_type,
                          GBoxedCopyFunc g_dup_func,
                          GDestroyNotify g_destroy_func,
                          GHashTable* h,
                          gconstpointer o);
gchar* wixl_add_braces (const gchar* str);
gchar* wixl_get_uuid (gchar* uuid,
                      GError** error);
glong wixl_now (void);
guint64 wixl_time_to_filetime (glong t);
gchar* wixl_indent (const gchar* space,
                    const gchar* text);
#define WIXL_uuid_namespace "\xde\x73\xba\x5a\xed\x96\x4a\x66\xba\x1b\xfb\xb4\x4e\x65\x9a\xd7"
gchar* wixl_uuid_from_name (const gchar* s);
gchar* wixl_generate_id (const gchar* prefix,
                         guint n,
                         ...);
gchar* wixl_random_id (const gchar* prefix);
gchar* wixl_yesno (gboolean yes);
gboolean wixl_parse_yesno (const gchar* str,
                           gboolean _default_);
gchar* wixl_unquote (const gchar* str);
gchar* wixl_remove_prefix (const gchar* prefix,
                           const gchar* str);
gint wixl_find_closing_paren (const gchar* str);
void wixl_compute_md5 (GFile* file,
                       gint* hash1,
                       gint* hash2,
                       gint* hash3,
                       gint* hash4,
                       GError** error);
GType wixl_unix_input_stream_get_type (void) G_GNUC_CONST;
WixlUnixInputStream* wixl_unix_input_stream_new (gint fd_);
WixlUnixInputStream* wixl_unix_input_stream_construct (GType object_type,
                                                       gint fd_);
void wixl_unix_input_stream_set_fd (WixlUnixInputStream* self,
                                    gint value);
static gssize wixl_unix_input_stream_real_read (GInputStream* base,
                                         guint8* buffer,
                                         gsize buffer_length1,
                                         GCancellable* cancellable,
                                         GError** error);
gint wixl_unix_input_stream_get_fd (WixlUnixInputStream* self);
static gboolean wixl_unix_input_stream_real_close (GInputStream* base,
                                            GCancellable* cancellable,
                                            GError** error);
static void wixl_unix_input_stream_finalize (GObject * obj);
static void _vala_wixl_unix_input_stream_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_wixl_unix_input_stream_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

GQuark
wixl_error_quark (void)
{
	return g_quark_from_static_string ("wixl-error-quark");
}

gchar*
wixl_uuid_generate (void)
{
	guchar* udn = NULL;
	guchar* _tmp0_;
	gint udn_length1;
	gint _udn_size_;
	guchar* id = NULL;
	guchar* _tmp1_;
	gint id_length1;
	gint _id_size_;
	gchar* _tmp2_;
	gchar* result = NULL;
	_tmp0_ = g_new0 (guchar, 50);
	udn = _tmp0_;
	udn_length1 = 50;
	_udn_size_ = udn_length1;
	_tmp1_ = g_new0 (guchar, 16);
	id = _tmp1_;
	id_length1 = 16;
	_id_size_ = id_length1;
	uuid_generate (id);
	uuid_unparse (id, udn);
	_tmp2_ = g_strdup ((const gchar*) udn);
	result = _tmp2_;
	id = (g_free (id), NULL);
	udn = (g_free (udn), NULL);
	return result;
}

static GEnumValue*
_g_enum_value_dup (GEnumValue* self)
{
	GEnumValue* dup;
	dup = g_new0 (GEnumValue, 1);
	memcpy (dup, self, sizeof (GEnumValue));
	return dup;
}

static gpointer
__g_enum_value_dup0 (gpointer self)
{
	return self ? _g_enum_value_dup (self) : NULL;
}

gpointer
wixl_enum_from_string (GType g_type,
                       GBoxedCopyFunc g_dup_func,
                       GDestroyNotify g_destroy_func,
                       const gchar* str,
                       GError** error)
{
	GEnumClass* k = NULL;
	GTypeClass* _tmp0_;
	GEnumValue* v = NULL;
	GEnumClass* _tmp1_;
	GEnumValue* _tmp2_;
	GEnumValue* _tmp3_;
	GEnumValue* _tmp5_;
	gpointer _tmp6_;
	GError* _inner_error0_ = NULL;
	gpointer result = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_type_class_ref (g_type);
	k = (GEnumClass*) _tmp0_;
	_tmp1_ = k;
	_tmp2_ = __g_enum_value_dup0 (g_enum_get_value_by_nick (_tmp1_, str));
	v = _tmp2_;
	_tmp3_ = v;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (WIXL_ERROR, WIXL_ERROR_FAILED, "Can't convert string to enum");
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (v);
		_g_type_class_unref0 (k);
		return NULL;
	}
	_tmp5_ = v;
	_tmp6_ = (((*_tmp5_).value != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) (*_tmp5_).value) : ((gpointer) (*_tmp5_).value);
	result = _tmp6_;
	_g_free0 (v);
	_g_type_class_unref0 (k);
	return result;
}

void
wixl_hash_table_add (GType g_type,
                     GBoxedCopyFunc g_dup_func,
                     GDestroyNotify g_destroy_func,
                     GHashTable* h,
                     gconstpointer o)
{
	gpointer _tmp0_;
	g_return_if_fail (h != NULL);
	_tmp0_ = ((o != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) o) : ((gpointer) o);
	g_hash_table_replace (h, _tmp0_, o);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gchar*
wixl_add_braces (const gchar* str)
{
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	if (string_get (str, (glong) 0) == '{') {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (str);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_strconcat ("{", str, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "}", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

gchar*
wixl_get_uuid (gchar* uuid,
               GError** error)
{
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (uuid != NULL, NULL);
	if (g_strcmp0 (uuid, "*") == 0) {
		gchar* _tmp0_;
		_tmp0_ = wixl_uuid_generate ();
		_g_free0 (uuid);
		uuid = _tmp0_;
	}
	_tmp1_ = wixl_add_braces (uuid);
	_g_free0 (uuid);
	uuid = _tmp1_;
	_tmp2_ = g_utf8_strup (uuid, (gssize) -1);
	_g_free0 (uuid);
	uuid = _tmp2_;
	_tmp3_ = g_strdup (uuid);
	result = _tmp3_;
	_g_free0 (uuid);
	return result;
}

glong
wixl_now (void)
{
	GTimeVal tv = {0};
	GTimeVal _tmp0_;
	glong result = 0L;
	g_get_current_time (&tv);
	g_get_current_time (&tv);
	_tmp0_ = tv;
	result = _tmp0_.tv_sec;
	return result;
}

guint64
wixl_time_to_filetime (glong t)
{
	guint64 result = 0ULL;
	result = (t + (134774ULL * 86400ULL)) * 10000000ULL;
	return result;
}

gchar*
wixl_indent (const gchar* space,
             const gchar* text)
{
	gchar* indented = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (space != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_strdup ("");
	indented = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (text, "\n", 0);
	{
		gchar** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint _l_collection_size_ = 0;
		gint l_it = 0;
		l_collection = _tmp2_;
		l_collection_length1 = _vala_array_length (_tmp1_);
		for (l_it = 0; l_it < l_collection_length1; l_it = l_it + 1) {
			gchar* _tmp3_;
			gchar* l = NULL;
			_tmp3_ = g_strdup (l_collection[l_it]);
			l = _tmp3_;
			{
				const gchar* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				const gchar* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp4_ = indented;
				_tmp5_ = strlen (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ != 0) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = indented;
					_tmp8_ = g_strconcat (_tmp7_, "\n", NULL);
					_g_free0 (indented);
					indented = _tmp8_;
				}
				_tmp9_ = l;
				_tmp10_ = strlen (_tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_ != 0) {
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = indented;
					_tmp13_ = l;
					_tmp14_ = g_strconcat (space, _tmp13_, NULL);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
					_g_free0 (indented);
					indented = _tmp16_;
					_g_free0 (_tmp15_);
				}
				_g_free0 (l);
			}
		}
		l_collection = (_vala_array_free (l_collection, l_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = indented;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gchar*
wixl_uuid_from_name (const gchar* s)
{
	GChecksum* cs = NULL;
	GChecksum* _tmp0_;
	guint8 buffer[20] = {0};
	gsize buflen = 0UL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	guint8 _tmp11_;
	guint8 _tmp12_;
	guint8 _tmp13_;
	guint8 _tmp14_;
	guint8 _tmp15_;
	guint8 _tmp16_;
	guint8 _tmp17_;
	guint8 _tmp18_;
	guint8 _tmp19_;
	guint8 _tmp20_;
	guint8 _tmp21_;
	guint8 _tmp22_;
	gchar* _tmp23_;
	gchar* result = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = g_checksum_new (G_CHECKSUM_SHA1);
	cs = _tmp0_;
	buflen = (gsize) 20;
	_tmp1_ = string_get_data (WIXL_uuid_namespace, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	g_checksum_update (cs, _tmp2_, (gsize) 16);
	_tmp3_ = string_get_data (s, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = strlen (s);
	_tmp6_ = _tmp5_;
	g_checksum_update (cs, _tmp4_, (gsize) _tmp6_);
	g_checksum_get_digest (cs, buffer, &buflen);
	_tmp7_ = buffer[0];
	_tmp8_ = buffer[1];
	_tmp9_ = buffer[2];
	_tmp10_ = buffer[3];
	_tmp11_ = buffer[4];
	_tmp12_ = buffer[5];
	_tmp13_ = buffer[6];
	_tmp14_ = buffer[7];
	_tmp15_ = buffer[8];
	_tmp16_ = buffer[9];
	_tmp17_ = buffer[10];
	_tmp18_ = buffer[11];
	_tmp19_ = buffer[12];
	_tmp20_ = buffer[13];
	_tmp21_ = buffer[14];
	_tmp22_ = buffer[15];
	_tmp23_ = g_strdup_printf ("{%02X%02X%02X%02X-%02X%02X-%02X%02X-%02X%02X-%02X%02X%02X%02X%02X%02X}", (guint) _tmp7_, (guint) _tmp8_, (guint) _tmp9_, (guint) _tmp10_, (guint) _tmp11_, (guint) _tmp12_, (guint) ((_tmp13_ & 15) | 0x50), (guint) _tmp14_, (guint) ((_tmp15_ & 0x3F) | 0x80), (guint) _tmp16_, (guint) _tmp17_, (guint) _tmp18_, (guint) _tmp19_, (guint) _tmp20_, (guint) _tmp21_, (guint) _tmp22_);
	result = _tmp23_;
	_g_checksum_free0 (cs);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len = len + _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len = len + (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
wixl_generate_id (const gchar* prefix,
                  guint n,
                  ...)
{
	va_list l = {0};
	gchar** args = NULL;
	gchar** _tmp0_;
	gint args_length1;
	gint _args_size_;
	gchar* data = NULL;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	gchar* hash = NULL;
	gchar* _tmp11_;
	gchar* str = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result = NULL;
	g_return_val_if_fail (prefix != NULL, NULL);
	va_start (l, n);
	_tmp0_ = g_new0 (gchar*, n + 1);
	args = _tmp0_;
	args_length1 = n;
	_args_size_ = args_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar* val = NULL;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				const gchar* _tmp5_;
				gchar** _tmp6_;
				gint _tmp6__length1;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = n;
					n = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				if (!(n > ((guint) 0))) {
					break;
				}
				_tmp3_ = va_arg (l, gchar*);
				_tmp4_ = g_strdup (_tmp3_);
				val = _tmp4_;
				_tmp5_ = val;
				if (_tmp5_ == NULL) {
					_g_free0 (val);
					continue;
				}
				_tmp6_ = args;
				_tmp6__length1 = args_length1;
				_tmp7_ = val;
				_tmp8_ = g_strdup (_tmp7_);
				_g_free0 (_tmp6_[i]);
				_tmp6_[i] = _tmp8_;
				i = i + 1;
				_g_free0 (val);
			}
		}
	}
	_tmp9_ = args;
	_tmp9__length1 = args_length1;
	_tmp10_ = _vala_g_strjoinv ("|", _tmp9_, (gint) _tmp9__length1);
	data = _tmp10_;
	_tmp11_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, data, (gsize) -1);
	hash = _tmp11_;
	_tmp12_ = string_slice (hash, (glong) 0, (glong) 32);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_utf8_strup (_tmp13_, (gssize) -1);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (prefix, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	str = _tmp17_;
	result = str;
	_g_free0 (hash);
	_g_free0 (data);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	va_end (l);
	return result;
}

gchar*
wixl_random_id (const gchar* prefix)
{
	guint32* data = NULL;
	guint32* _tmp0_;
	gint data_length1;
	gint _data_size_;
	gchar* hash = NULL;
	guint32* _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result = NULL;
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = g_new0 (guint32, 8);
	data = _tmp0_;
	data_length1 = 8;
	_data_size_ = data_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint32* _tmp3_;
				gint _tmp3__length1;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 8)) {
					break;
				}
				_tmp3_ = data;
				_tmp3__length1 = data_length1;
				_tmp3_[i] = g_random_int ();
			}
		}
	}
	_tmp4_ = data;
	_tmp4__length1 = data_length1;
	_tmp5_ = g_compute_checksum_for_data (G_CHECKSUM_SHA1, (guint8*) _tmp4_, (gint) ((_tmp4__length1 * sizeof (guint32)) / sizeof (guint8)));
	hash = _tmp5_;
	_tmp6_ = string_slice (hash, (glong) 0, (glong) 32);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_strup (_tmp7_, (gssize) -1);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (prefix, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	result = _tmp11_;
	_g_free0 (hash);
	data = (g_free (data), NULL);
	return result;
}

gchar*
wixl_yesno (gboolean yes)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* result = NULL;
	if (yes) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
wixl_parse_yesno (const gchar* str,
                  gboolean _default_)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	if (str == NULL) {
		result = _default_;
		return result;
	}
	if (string_get (str, (glong) 0) == 'Y') {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = string_get (str, (glong) 0) == 'y';
	}
	result = _tmp0_;
	return result;
}

gchar*
wixl_unquote (const gchar* str)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp8_;
	gchar* result = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	if (string_get (str, (glong) 0) == '\'') {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = strlen (str);
		_tmp3_ = _tmp2_;
		_tmp1_ = string_get (str, (glong) (_tmp3_ - 1)) == '\'';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (string_get (str, (glong) 0) == '"') {
			gint _tmp5_;
			gint _tmp6_;
			_tmp5_ = strlen (str);
			_tmp6_ = _tmp5_;
			_tmp4_ = string_get (str, (glong) (_tmp6_ - 1)) == '"';
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		gchar* _tmp7_;
		_tmp7_ = string_slice (str, (glong) 1, (glong) -1);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = g_strdup (str);
	result = _tmp8_;
	return result;
}

gchar*
wixl_remove_prefix (const gchar* prefix,
                    const gchar* str)
{
	gchar* _tmp5_;
	gchar* result = NULL;
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	if (g_str_has_prefix (str, prefix)) {
		gint _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = strlen (prefix);
		_tmp1_ = _tmp0_;
		_tmp2_ = strlen (str);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_slice (str, (glong) _tmp1_, (glong) _tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup (str);
	result = _tmp5_;
	return result;
}

gint
wixl_find_closing_paren (const gchar* str)
{
	gint open_count = 0;
	gint close_count = 0;
	gint result = 0;
	g_return_val_if_fail (str != NULL, 0);
	g_return_val_if_fail (string_get (str, (glong) 0) == '(', -1);
	open_count = 1;
	close_count = 0;
	{
		gint pos = 0;
		pos = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = pos;
					pos = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = strlen (str);
				_tmp3_ = _tmp2_;
				if (!(pos < _tmp3_)) {
					break;
				}
				if (string_get (str, (glong) pos) == '(') {
					gint _tmp4_;
					_tmp4_ = open_count;
					open_count = _tmp4_ + 1;
				} else {
					if (string_get (str, (glong) pos) == ')') {
						gint _tmp5_;
						_tmp5_ = close_count;
						close_count = _tmp5_ + 1;
						if (open_count == close_count) {
							result = pos;
							return result;
						}
					}
				}
			}
		}
	}
	result = -1;
	return result;
}

void
wixl_compute_md5 (GFile* file,
                  gint* hash1,
                  gint* hash2,
                  gint* hash3,
                  gint* hash4,
                  GError** error)
{
	GChecksum* checksum = NULL;
	GChecksum* _tmp0_;
	GFileInputStream* stream = NULL;
	GFileInputStream* _tmp1_;
	guint8 fbuf[4096] = {0};
	gsize size = 0UL;
	gint buffer[4] = {0};
	gsize buflen = 0UL;
	GChecksum* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	_tmp0_ = g_checksum_new (G_CHECKSUM_MD5);
	checksum = _tmp0_;
	_tmp1_ = g_file_read (file, NULL, &_inner_error0_);
	stream = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_checksum_free0 (checksum);
		return;
	}
	while (TRUE) {
		gssize _tmp2_ = 0L;
		GFileInputStream* _tmp3_;
		GChecksum* _tmp4_;
		_tmp3_ = stream;
		_tmp2_ = g_input_stream_read ((GInputStream*) _tmp3_, fbuf, (gsize) 4096, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stream);
			_g_checksum_free0 (checksum);
			return;
		}
		size = (gsize) _tmp2_;
		if (!(size > ((gsize) 0))) {
			break;
		}
		_tmp4_ = checksum;
		g_checksum_update (_tmp4_, fbuf, size);
	}
	buflen = (gsize) 16;
	_tmp5_ = checksum;
	g_checksum_get_digest (_tmp5_, (guint8*) buffer, &buflen);
	_tmp6_ = buffer[0];
	*hash1 = _tmp6_;
	_tmp7_ = buffer[1];
	*hash2 = _tmp7_;
	_tmp8_ = buffer[2];
	*hash3 = _tmp8_;
	_tmp9_ = buffer[3];
	*hash4 = _tmp9_;
	_g_object_unref0 (stream);
	_g_checksum_free0 (checksum);
}

static inline gpointer
wixl_unix_input_stream_get_instance_private (WixlUnixInputStream* self)
{
	return G_STRUCT_MEMBER_P (self, WixlUnixInputStream_private_offset);
}

WixlUnixInputStream*
wixl_unix_input_stream_construct (GType object_type,
                                  gint fd_)
{
	WixlUnixInputStream * self = NULL;
	self = (WixlUnixInputStream*) g_object_new (object_type, NULL);
	wixl_unix_input_stream_set_fd (self, fd_);
	return self;
}

WixlUnixInputStream*
wixl_unix_input_stream_new (gint fd_)
{
	return wixl_unix_input_stream_construct (WIXL_TYPE_UNIX_INPUT_STREAM, fd_);
}

static gssize
wixl_unix_input_stream_real_read (GInputStream* base,
                                  guint8* buffer,
                                  gsize buffer_length1,
                                  GCancellable* cancellable,
                                  GError** error)
{
	WixlUnixInputStream * self;
	gint _tmp0_;
	gssize result = 0L;
	self = (WixlUnixInputStream*) base;
	_tmp0_ = self->priv->_fd;
	result = read (_tmp0_, buffer, (gsize) buffer_length1);
	return result;
}

static gboolean
wixl_unix_input_stream_real_close (GInputStream* base,
                                   GCancellable* cancellable,
                                   GError** error)
{
	WixlUnixInputStream * self;
	gboolean result = FALSE;
	self = (WixlUnixInputStream*) base;
	result = TRUE;
	return result;
}

gint
wixl_unix_input_stream_get_fd (WixlUnixInputStream* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_fd;
	return result;
}

void
wixl_unix_input_stream_set_fd (WixlUnixInputStream* self,
                               gint value)
{
	g_return_if_fail (self != NULL);
	if (wixl_unix_input_stream_get_fd (self) != value) {
		self->priv->_fd = value;
		g_object_notify_by_pspec ((GObject *) self, wixl_unix_input_stream_properties[WIXL_UNIX_INPUT_STREAM_FD_PROPERTY]);
	}
}

static void
wixl_unix_input_stream_class_init (WixlUnixInputStreamClass * klass,
                                   gpointer klass_data)
{
	wixl_unix_input_stream_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WixlUnixInputStream_private_offset);
	((GInputStreamClass *) klass)->read_fn = (gssize (*) (GInputStream*, guint8*, gsize, GCancellable*, GError**)) wixl_unix_input_stream_real_read;
	((GInputStreamClass *) klass)->close_fn = (gboolean (*) (GInputStream*, GCancellable*, GError**)) wixl_unix_input_stream_real_close;
	G_OBJECT_CLASS (klass)->get_property = _vala_wixl_unix_input_stream_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_wixl_unix_input_stream_set_property;
	G_OBJECT_CLASS (klass)->finalize = wixl_unix_input_stream_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WIXL_UNIX_INPUT_STREAM_FD_PROPERTY, wixl_unix_input_stream_properties[WIXL_UNIX_INPUT_STREAM_FD_PROPERTY] = g_param_spec_int ("fd", "fd", "fd", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
wixl_unix_input_stream_instance_init (WixlUnixInputStream * self,
                                      gpointer klass)
{
	self->priv = wixl_unix_input_stream_get_instance_private (self);
}

static void
wixl_unix_input_stream_finalize (GObject * obj)
{
	WixlUnixInputStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIXL_TYPE_UNIX_INPUT_STREAM, WixlUnixInputStream);
	G_OBJECT_CLASS (wixl_unix_input_stream_parent_class)->finalize (obj);
}

GType
wixl_unix_input_stream_get_type (void)
{
	static volatile gsize wixl_unix_input_stream_type_id__volatile = 0;
	if (g_once_init_enter (&wixl_unix_input_stream_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WixlUnixInputStreamClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wixl_unix_input_stream_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WixlUnixInputStream), 0, (GInstanceInitFunc) wixl_unix_input_stream_instance_init, NULL };
		GType wixl_unix_input_stream_type_id;
		wixl_unix_input_stream_type_id = g_type_register_static (g_input_stream_get_type (), "WixlUnixInputStream", &g_define_type_info, 0);
		WixlUnixInputStream_private_offset = g_type_add_instance_private (wixl_unix_input_stream_type_id, sizeof (WixlUnixInputStreamPrivate));
		g_once_init_leave (&wixl_unix_input_stream_type_id__volatile, wixl_unix_input_stream_type_id);
	}
	return wixl_unix_input_stream_type_id__volatile;
}

static void
_vala_wixl_unix_input_stream_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	WixlUnixInputStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WIXL_TYPE_UNIX_INPUT_STREAM, WixlUnixInputStream);
	switch (property_id) {
		case WIXL_UNIX_INPUT_STREAM_FD_PROPERTY:
		g_value_set_int (value, wixl_unix_input_stream_get_fd (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_wixl_unix_input_stream_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	WixlUnixInputStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WIXL_TYPE_UNIX_INPUT_STREAM, WixlUnixInputStream);
	switch (property_id) {
		case WIXL_UNIX_INPUT_STREAM_FD_PROPERTY:
		wixl_unix_input_stream_set_fd (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

