# Runtime and cancellation

The sponsorship model for Material for MkDocs is facilitated through GitHub
Sponsors and, therefore, adheres to GitHub's policies. If you're curious about
the duration of your sponsorship and the cancellation process, you will find
everything you need to know below.

## Runtime

Sponsorships remain valid as long as monthly or yearly subscriptions are
active and only expire when you cancel the sponsorship or when your [payment
method expires].

  [payment method expires]: #automatic-cancellation

## Cancellation process

Canceling your sponsorship initiates a cancellation request through GitHub,
which is scheduled to take effect at the end of your current billing cycle. This
means you'll retain access to Insiders until the cancellation officially becomes
effective.

All transactions are processed by GitHub and as we don't receive any information
regarding your payment, we can't provide details about when your cancellation
will be in place.

### How to cancel

To downgrade or cancel your sponsorship, please follow the [step-by-step guide
from GitHub]. If you have sponsored using an organizational account, ensure that
you cancel the sponsorship under that specific account, as the
[collaborator and sponsor accounts may differ].

  [step-by-step guide from GitHub]: https://docs.github.com/en/billing/managing-billing-for-github-sponsors/downgrading-a-sponsorship#canceling-a-sponsorship
  [collaborator and sponsor accounts may differ]: access-management.md/#collaborators

### Effects of cancellation

Upon the effective date of your cancellation, GitHub will automatically remove
you as a collaborator from the private Material for MkDocs Insiders repository.
You will no longer receive updates. However, you are welcome to continue using
the latest version available to you at the time of cancellation for as long as
you like.

!!! warning "GitHub deletes private forks"

    Please note that once you lose your collaborator status, [GitHub will
    automatically delete your private fork] of the Insiders repository, so you
    may want to take steps to ensure that you have a local backup.

  [GitHub will automatically delete your private fork]: https://docs.github.com/en/account-and-profile/setting-up-and-managing-your-personal-account-on-github/managing-access-to-your-personal-repositories/removing-a-collaborator-from-a-personal-repository#deleting-forks-of-private-repositories

### Automatic cancellation

If your credit card expires, GitHub will automatically cancel your sponsorship
and remove you as a collaborator. Regularly checking your payment method is
recommended to avoid unintended cancellations. If it happens, you can
reinstate your sponsorship with a new credit card.
