# How to sponsor

Becoming a sponsor for Material for MkDocs is a straightforward process through
@squidfunk's [GitHub Sponsors profile]. By supporting
the project with a monthly contribution of __$15 a month__ or more, you can sponsor
either via an [individual] or [organizational] GitHub account.

  [GitHub Sponsors profile]: https://github.com/sponsors/squidfunk
  [individual]: access-management.md/#individuals
  [organizational]: access-management.md/#organizations

## Walkthrough

Want to become a sponsor? We will guide you through the sponsoring process below
If you have additional questions, you can find detailed information about
[payment and billing], [access management], [runtime and cancellation],
[privacy], [license] and [support] on dedicated pages.

  [payment and billing]: payment-and-billing.md
  [access management]: access-management.md
  [runtime and cancellation]: runtime-and-cancellation.md
  [privacy]: privacy.md
  [license]: license.md
  [support]: ../support.md

### Sponsoring tier

First, it's a good idea to explore [our sponsoring tiers], as each sponsoring
tier is designed to accommodate different levels of sponsors and includes
dedicated benefits.

After reviewing the sponsoring tiers, it's time to choose one. Consider what you
want to achieve and keep your requirements in mind, e.g. the number of projects
you want to build or how many accounts you need. [Switching tiers] is possible
at any time.

Choosing a tier will take you to GitHub's sponsorship confirmation page.

  [our sponsoring tiers]: sponsoring-tiers.md
  [Switching tiers]: sponsoring-tiers.md/#switching-tiers

### Sponsorship summary

#### Payment and billing

Next, GitHub will ask you to provide your billing information, which is required
to process your sponsorship payment. On this page, the _Sponsorship summary_
section displays the (possibly prorated) amount due to initiate your sponsorship.
This amount is determined by your account's [billing cycle], which can be set to
a monthly or yearly interval.

  [billing cycle]: https://docs.github.com/en/github/setting-up-and-managing-billing-and-payments-on-github/changing-the-duration-of-your-billing-cycle

Proceed to input your [payment information], specifically your credit card
details. Please make sure that the used credit card is valid and will remain
so for an extended period to help avoid any interruptions in your sponsorship.

  [payment information]: payment-and-billing.md

#### Privacy

On this page, you can also set the visibility of your sponsorship. You have the
option to keep your [sponsorship private or to make it public], which includes
listing your name or organization on the list of [our sponsors] and, for
organizations, the opportunity for [logo placement].

  [sponsorship private or to make it public]: privacy.md
  [our sponsors]: our-sponsors.md
  [logo placement]: our-sponsors.md/#premium-sponsors

#### News and updates

Note that we rarely send out emails, and when we do, it's usually to inform you
about significant updates or changes to the project, so it's best to keep this
option enabled. To stay updated on the latest developments, you can check out
our [changelog].

  [changelog]: ../changelog/index.md

#### Tax information

If you're sponsoring as an organization, it's essential to provide your country,
region and VAT number, so we can correctly attribute your sponsorship. This is
due to the fact that VAT is handled differently for individuals than for
organizations.

#### Confirmation

Before finalizing your sponsorship, take a moment to review all the details of
your sponsorship, including the selected tier, billing information, and payment
details.

Then proceed to confirm your sponsorship by clicking the _Sponsor_ button.

### Access management

After completing the sponsorship process and your payment is successfully
processed, you will be all set to [gain access] to the private Material for
MkDocs Insiders repository.

  [gain access]: access-management.md

---

__Ready to become a sponsor?__

[&nbsp; Choose a sponsoring tier <span class="mdx-sponsorship-count" data-mdx-component="sponsorship-count"></span>][sponsoring-tiers]{ .md-button .md-button--primary .mdx-sponsorship-button }

  [sponsoring-tiers]: sponsoring-tiers.md

If you still find yourself with more questions, feel free to [reach out to Kathi]
via mail at sponsors@squidfunk.com for additional support.

  [reach out to Kathi]: ../support.md/#sponsoring-support
