/*
Copyright (c) 2015 - present Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "CUDA2HIP.h"

// Map of all functions
const std::map<llvm::StringRef, hipCounter> CUDA_BLAS_FUNCTION_MAP {

  // Blas management functions
  {"cublasInit",                     {"hipblasInit",                     "rocblas_initialize",                       CONV_LIB_FUNC, API_BLAS, 4, HIP_UNSUPPORTED}},
  {"cublasShutdown",                 {"hipblasShutdown",                 "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetVersion",               {"hipblasGetVersion",               "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetError",                 {"hipblasGetError",                 "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasAlloc",                    {"hipblasAlloc",                    "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasFree",                     {"hipblasFree",                     "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasSetKernelStream",          {"hipblasSetKernelStream",          "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetAtomicsMode",           {"hipblasGetAtomicsMode",           "rocblas_get_atomics_mode",                 CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasSetAtomicsMode",           {"hipblasSetAtomicsMode",           "rocblas_set_atomics_mode",                 CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetMathMode",              {"hipblasGetMathMode",              "rocblas_get_math_mode",                    CONV_LIB_FUNC, API_BLAS, 4, HIP_UNSUPPORTED}},
  {"cublasSetMathMode",              {"hipblasSetMathMode",              "rocblas_set_math_mode",                    CONV_LIB_FUNC, API_BLAS, 4, HIP_UNSUPPORTED}},
  {"cublasMigrateComputeType",       {"hipblasMigrateComputeType",       "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetSmCountTarget",         {"hipblasGetSmCountTarget",         "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasSetSmCountTarget",         {"hipblasSetSmCountTarget",         "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetStatusName",            {"hipblasGetStatusName",            "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetStatusString",          {"hipblasGetStatusString",          "rocblas_status_to_string",                 CONV_LIB_FUNC, API_BLAS, 4, HIP_UNSUPPORTED}},

  // Blas logging
  {"cublasLogCallback",              {"hipblasLogCallback",              "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasLoggerConfigure",          {"hipblasLoggerConfigure",          "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasSetLoggerCallback",        {"hipblasSetLoggerCallback",        "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetLoggerCallback",        {"hipblasGetLoggerCallback",        "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},

  // Blas1 (v1) Routines
  {"cublasCreate",                   {"hipblasCreate",                   "rocblas_create_handle",                    CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasDestroy",                  {"hipblasDestroy",                  "rocblas_destroy_handle",                   CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasSetStream",                {"hipblasSetStream",                "rocblas_set_stream",                       CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetStream",                {"hipblasGetStream",                "rocblas_get_stream",                       CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasSetPointerMode",           {"hipblasSetPointerMode",           "rocblas_set_pointer_mode",                 CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetPointerMode",           {"hipblasGetPointerMode",           "rocblas_get_pointer_mode",                 CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasSetVector",                {"hipblasSetVector",                "rocblas_set_vector",                       CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasSetVector_64",             {"hipblasSetVector_64",             "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetVector",                {"hipblasGetVector",                "rocblas_get_vector",                       CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetVector_64",             {"hipblasGetVector_64",             "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasSetVectorAsync",           {"hipblasSetVectorAsync",           "rocblas_set_vector_async",                 CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasSetVectorAsync_64",        {"hipblasSetVectorAsync_64",        "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetVectorAsync",           {"hipblasGetVectorAsync",           "rocblas_get_vector_async",                 CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetVectorAsync_64",        {"hipblasGetVectorAsync_64",        "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasSetMatrix",                {"hipblasSetMatrix",                "rocblas_set_matrix",                       CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasSetMatrix_64",             {"hipblasSetMatrix_64",             "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetMatrix",                {"hipblasGetMatrix",                "rocblas_get_matrix",                       CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetMatrix_64",             {"hipblasGetMatrix_64",             "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasSetMatrixAsync",           {"hipblasSetMatrixAsync",           "rocblas_set_matrix_async",                 CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasSetMatrixAsync_64",        {"hipblasSetMatrixAsync_64",        "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetMatrixAsync",           {"hipblasGetMatrixAsync",           "rocblas_get_matrix_async",                 CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetMatrixAsync_64",        {"hipblasGetMatrixAsync_64",        "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasXerbla",                   {"hipblasXerbla",                   "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},

  // Blas2 (v2) Routines
  {"cublasCreate_v2",                {"hipblasCreate",                   "rocblas_create_handle",                    CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasDestroy_v2",               {"hipblasDestroy",                  "rocblas_destroy_handle",                   CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetVersion_v2",            {"hipblasGetVersion",               "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasGetProperty",              {"hipblasGetProperty",              "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},
  {"cublasSetStream_v2",             {"hipblasSetStream",                "rocblas_set_stream",                       CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetStream_v2",             {"hipblasGetStream",                "rocblas_get_stream",                       CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasSetPointerMode_v2",        {"hipblasSetPointerMode",           "rocblas_set_pointer_mode",                 CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetPointerMode_v2",        {"hipblasGetPointerMode",           "rocblas_get_pointer_mode",                 CONV_LIB_FUNC, API_BLAS, 4}},
  {"cublasGetCudartVersion",         {"hipblasGetCudartVersion",         "",                                         CONV_LIB_FUNC, API_BLAS, 4, UNSUPPORTED}},

  // NRM2
  // NRM2 functions' signatures differ from _v2 ones, hipblas and rocblas NRM2 functions have mapping to NRM2_v2 functions only
  {"cublasSnrm2",                    {"hipblasSnrm2",                    "rocblas_snrm2",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSnrm2_64",                 {"hipblasSnrm2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDnrm2",                    {"hipblasDnrm2",                    "rocblas_dnrm2",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDnrm2_64",                 {"hipblasDnrm2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasScnrm2",                   {"hipblasScnrm2_v2",                "rocblas_scnrm2",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasScnrm2_64",                {"hipblasScnrm2_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDznrm2",                   {"hipblasDznrm2_v2",                "rocblas_dznrm2",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDznrm2_64",                {"hipblasDznrm2_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasNrm2Ex",                   {"hipblasNrm2Ex_v2",                "rocblas_nrm2_ex",                          CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasNrm2Ex_64",                {"hipblasNrm2Ex_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // DOT
  // DOT functions' signatures differ from _v2 ones, hipblas and rocblas DOT functions have mapping to DOT_v2 functions only
  {"cublasSdot",                     {"hipblasSdot",                     "rocblas_sdot",                             CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSdot_64",                  {"hipblasSdot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDdot",                     {"hipblasDdot",                     "rocblas_ddot",                             CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDdot_64",                  {"hipblasDdot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCdotu",                    {"hipblasCdotu_v2",                 "rocblas_cdotu",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCdotu_64",                 {"hipblasCdotu_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCdotc",                    {"hipblasCdotc_v2",                 "rocblas_cdotc",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCdotc_64",                 {"hipblasCdotc_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZdotu",                    {"hipblasZdotu_v2",                 "rocblas_zdotu",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZdotu_64",                 {"hipblasZdotu_64",                  "",                                        CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZdotc",                    {"hipblasZdotc_v2",                 "rocblas_zdotc",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZdotc_64",                 {"hipblasZdotc_64",                  "",                                        CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // SCAL
  // SCAL functions' signatures differ from _v2 ones, hipblas and rocblas SCAL functions have mapping to SCAL_v2 functions only
  {"cublasSscal",                    {"hipblasSscal",                    "rocblas_sscal",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSscal_64",                 {"hipblasSscal_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDscal",                    {"hipblasDscal",                    "rocblas_dscal",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDscal_64",                 {"hipblasDscal_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCscal",                    {"hipblasCscal_v2",                 "rocblas_cscal",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCscal_64",                 {"hipblasCscal_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCsscal",                   {"hipblasCsscal_v2",                "rocblas_csscal",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCsscal_64",                {"hipblasCsscal_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZscal",                    {"hipblasZscal_v2",                 "rocblas_zscal",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZscal_64",                 {"hipblasZscal_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZdscal",                   {"hipblasZdscal_v2",                "rocblas_zdscal",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZdscal_64",                {"hipblasZdscal_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // AXPY
  {"cublasSaxpy",                    {"hipblasSaxpy",                    "rocblas_saxpy",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSaxpy_64",                 {"hipblasSaxpy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDaxpy",                    {"hipblasDaxpy",                    "rocblas_daxpy",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDaxpy_64",                 {"hipblasDaxpy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCaxpy",                    {"hipblasCaxpy_v2",                 "rocblas_caxpy",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCaxpy_64",                 {"hipblasCaxpy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZaxpy",                    {"hipblasZaxpy_v2",                 "rocblas_zaxpy",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZaxpy_64",                 {"hipblasZaxpy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // COPY
  {"cublasScopy",                    {"hipblasScopy",                    "rocblas_scopy",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasScopy_64",                 {"hipblasScopy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDcopy",                    {"hipblasDcopy",                    "rocblas_dcopy",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDcopy_64",                 {"hipblasDcopy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCcopy",                    {"hipblasCcopy_v2",                 "rocblas_ccopy",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCcopy_64",                 {"hipblasCcopy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZcopy",                    {"hipblasZcopy_v2",                 "rocblas_zcopy",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZcopy_64",                 {"hipblasZcopy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // SWAP
  {"cublasSswap",                    {"hipblasSswap",                    "rocblas_sswap",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSswap_64",                 {"hipblasSswap_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDswap",                    {"hipblasDswap",                    "rocblas_dswap",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDswap_64",                 {"hipblasDswap_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCswap",                    {"hipblasCswap_v2",                 "rocblas_cswap",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCswap_64",                 {"hipblasCswap_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZswap",                    {"hipblasZswap_v2",                 "rocblas_zswap",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZswap_64",                 {"hipblasZswap_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // AMAX
  {"cublasIsamax",                   {"hipblasIsamax",                   "rocblas_isamax",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasIsamax_64",                {"hipblasIsamax_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIdamax",                   {"hipblasIdamax",                   "rocblas_idamax",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasIdamax_64",                {"hipblasIdamax_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIcamax",                   {"hipblasIcamax_v2",                "rocblas_icamax",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasIcamax_64",                {"hipblasIcamax_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIzamax",                   {"hipblasIzamax_v2",                "rocblas_izamax",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasIzamax_64",                {"hipblasIzamax_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // AMIN
  {"cublasIsamin",                   {"hipblasIsamin",                   "rocblas_isamin",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasIsamin_64",                {"hipblasIsamin_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIdamin",                   {"hipblasIdamin",                   "rocblas_idamin",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasIdamin_64",                {"hipblasIdamin_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIcamin",                   {"hipblasIcamin_v2",                "rocblas_icamin",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasIcamin_64",                {"hipblasIcamin_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIzamin",                   {"hipblasIzamin_v2",                "rocblas_izamin",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasIzamin_64",                {"hipblasIzamin_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // ASUM
  {"cublasSasum",                    {"hipblasSasum",                    "rocblas_sasum",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSasum_64",                 {"hipblasSasum_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDasum",                    {"hipblasDasum",                    "rocblas_dasum",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDasum_64",                 {"hipblasDasum_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasScasum",                   {"hipblasScasum_v2",                "rocblas_scasum",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasScasum_64",                {"hipblasScasum_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDzasum",                   {"hipblasDzasum_v2",                "rocblas_dzasum",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDzasum_64",                {"hipblasDzasum_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // ROT
  {"cublasSrot",                     {"hipblasSrot",                     "rocblas_srot",                             CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSrot_64",                  {"hipblasSrot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDrot",                     {"hipblasDrot",                     "rocblas_drot",                             CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDrot_64",                  {"hipblasDrot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCrot",                     {"hipblasCrot_v2",                  "rocblas_crot",                             CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCrot_64",                  {"hipblasCrot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCsrot",                    {"hipblasCsrot_v2",                 "rocblas_csrot",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCsrot_64",                 {"hipblasCsrot_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZrot",                     {"hipblasZrot_v2",                  "rocblas_zrot",                             CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZrot_64",                  {"hipblasZrot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZdrot",                    {"hipblasZdrot_v2",                 "rocblas_zdrot",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZdrot_64",                 {"hipblasZdrot_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // ROTG
  {"cublasSrotg",                    {"hipblasSrotg",                    "rocblas_srotg",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDrotg",                    {"hipblasDrotg",                    "rocblas_drotg",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCrotg",                    {"hipblasCrotg_v2",                 "rocblas_crotg",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZrotg",                    {"hipblasZrotg_v2",                 "rocblas_zrotg",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},

  // ROTM
  {"cublasSrotm",                    {"hipblasSrotm",                    "rocblas_srotm",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSrotm_64",                 {"hipblasSrotm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDrotm",                    {"hipblasDrotm",                    "rocblas_drotm",                            CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDrotm_64",                 {"hipblasDrotm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // ROTMG
  {"cublasSrotmg",                   {"hipblasSrotmg",                   "rocblas_srotmg",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDrotmg",                   {"hipblasDrotmg",                   "rocblas_drotmg",                           CONV_LIB_FUNC, API_BLAS, 5, HIP_SUPPORTED_V2_ONLY}},

  // GEMV
  {"cublasSgemv",                    {"hipblasSgemv",                    "rocblas_sgemv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSgemv_64",                 {"hipblasSgemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDgemv",                    {"hipblasDgemv",                    "rocblas_dgemv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDgemv_64",                 {"hipblasDgemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCgemv",                    {"hipblasCgemv_v2",                 "rocblas_cgemv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCgemv_64",                 {"hipblasCgemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZgemv",                    {"hipblasZgemv_v2",                 "rocblas_zgemv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZgemv_64",                 {"hipblasZgemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // GBMV
  {"cublasSgbmv",                    {"hipblasSgbmv",                    "rocblas_sgbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSgbmv_64",                 {"hipblasSgbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDgbmv",                    {"hipblasDgbmv",                    "rocblas_dgbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDgbmv_64",                 {"hipblasDgbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCgbmv",                    {"hipblasCgbmv_v2",                 "rocblas_cgbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCgbmv_64",                 {"hipblasCgbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZgbmv",                    {"hipblasZgbmv_v2",                 "rocblas_zgbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZgbmv_64",                 {"hipblasZgbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TRMV
  {"cublasStrmv",                    {"hipblasStrmv",                    "rocblas_strmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasStrmv_64",                 {"hipblasStrmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtrmv",                    {"hipblasDtrmv",                    "rocblas_dtrmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDtrmv_64",                 {"hipblasDtrmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtrmv",                    {"hipblasCtrmv_v2",                 "rocblas_ctrmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCtrmv_64",                 {"hipblasCtrmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtrmv",                    {"hipblasZtrmv_v2",                 "rocblas_ztrmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZtrmv_64",                 {"hipblasZtrmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TBMV
  {"cublasStbmv",                    {"hipblasStbmv",                    "rocblas_stbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasStbmv_64",                 {"hipblasStbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtbmv",                    {"hipblasDtbmv",                    "rocblas_dtbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDtbmv_64",                 {"hipblasDtbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtbmv",                    {"hipblasCtbmv_v2",                 "rocblas_ctbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCtbmv_64",                 {"hipblasCtbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtbmv",                    {"hipblasZtbmv_v2",                 "rocblas_ztbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZtbmv_64",                 {"hipblasZtbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TPMV
  {"cublasStpmv",                    {"hipblasStpmv",                    "rocblas_stpmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasStpmv_64",                 {"hipblasStpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtpmv",                    {"hipblasDtpmv",                    "rocblas_dtpmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDtpmv_64",                 {"hipblasDtpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtpmv",                    {"hipblasCtpmv_v2",                 "rocblas_ctpmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCtpmv_64",                 {"hipblasCtpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtpmv",                    {"hipblasZtpmv_v2",                 "rocblas_ztpmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZtpmv_64",                 {"hipblasZtpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TRSV
  {"cublasStrsv",                    {"hipblasStrsv",                    "rocblas_strsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasStrsv_64",                 {"hipblasStrsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtrsv",                    {"hipblasDtrsv",                    "rocblas_dtrsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDtrsv_64",                 {"hipblasDtrsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtrsv",                    {"hipblasCtrsv_v2",                 "rocblas_ctrsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCtrsv_64",                 {"hipblasCtrsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtrsv",                    {"hipblasZtrsv_v2",                 "rocblas_ztrsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZtrsv_64",                 {"hipblasZtrsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TPSV
  {"cublasStpsv",                    {"hipblasStpsv",                    "rocblas_stpsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasStpsv_64",                 {"hipblasStpsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtpsv",                    {"hipblasDtpsv",                    "rocblas_dtpsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDtpsv_64",                 {"hipblasDtpsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtpsv",                    {"hipblasCtpsv_v2",                 "rocblas_ctpsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCtpsv_64",                 {"hipblasCtpsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtpsv",                    {"hipblasZtpsv_v2",                 "rocblas_ztpsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZtpsv_64",                 {"hipblasZtpsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TBSV
  {"cublasStbsv",                    {"hipblasStbsv",                    "rocblas_stbsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasStbsv_64",                 {"hipblasStbsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtbsv",                    {"hipblasDtbsv",                    "rocblas_dtbsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDtbsv_64",                 {"hipblasDtbsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtbsv",                    {"hipblasCtbsv_v2",                 "rocblas_ctbsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCtbsv_64",                 {"hipblasCtbsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtbsv",                    {"hipblasZtbsv_v2",                 "rocblas_ztbsv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZtbsv_64",                 {"hipblasZtbsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SYMV/HEMV
  {"cublasSsymv",                    {"hipblasSsymv",                    "rocblas_ssymv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSsymv_64",                 {"hipblasSsymv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDsymv",                    {"hipblasDsymv",                    "rocblas_dsymv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDsymv_64",                 {"hipblasDsymv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCsymv",                    {"hipblasCsymv_v2",                 "rocblas_csymv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCsymv_64",                 {"hipblasCsymv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZsymv",                    {"hipblasZsymv_v2",                 "rocblas_zsymv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZsymv_64",                 {"hipblasZsymv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasChemv",                    {"hipblasChemv_v2",                 "rocblas_chemv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasChemv_64",                 {"hipblasChemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZhemv",                    {"hipblasZhemv_v2",                 "rocblas_zhemv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZhemv_64",                 {"hipblasZhemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SBMV/HBMV
  {"cublasSsbmv",                    {"hipblasSsbmv",                    "rocblas_ssbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSsbmv_64",                 {"hipblasSsbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDsbmv",                    {"hipblasDsbmv",                    "rocblas_dsbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDsbmv_64",                 {"hipblasDsbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasChbmv",                    {"hipblasChbmv_v2",                 "rocblas_chbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasChbmv_64",                 {"hipblasChbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZhbmv",                    {"hipblasZhbmv_v2",                 "rocblas_zhbmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZhbmv_64",                 {"hipblasZhbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SPMV/HPMV
  {"cublasSspmv",                    {"hipblasSspmv",                    "rocblas_sspmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSspmv_64",                 {"hipblasSspmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDspmv",                    {"hipblasDspmv",                    "rocblas_dspmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDspmv_64",                 {"hipblasDspmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasChpmv",                    {"hipblasChpmv_v2",                 "rocblas_chpmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasChpmv_64",                 {"hipblasChpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZhpmv",                    {"hipblasZhpmv_v2",                 "rocblas_zhpmv",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZhpmv_64",                 {"hipblasZhpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // GER
  {"cublasSger",                     {"hipblasSger",                     "rocblas_sger",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSger_64",                  {"hipblasSger_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDger",                     {"hipblasDger",                     "rocblas_dger",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDger_64",                  {"hipblasDger_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCgeru",                    {"hipblasCgeru_v2",                 "rocblas_cgeru",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCgeru_64",                 {"hipblasCgeru_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCgerc",                    {"hipblasCgerc_v2",                 "rocblas_cgerc",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCgerc_64",                 {"hipblasCgerc_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZgeru",                    {"hipblasZgeru_v2",                 "rocblas_zgeru",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZgeru_64",                 {"hipblasZgeru_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZgerc",                    {"hipblasZgerc_v2",                 "rocblas_zgerc",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZgerc_64",                 {"hipblasZgerc_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SYR/HER
  {"cublasSsyr",                     {"hipblasSsyr",                     "rocblas_ssyr",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSsyr_64",                  {"hipblasSsyr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDsyr",                     {"hipblasDsyr",                     "rocblas_dsyr",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDsyr_64",                  {"hipblasDsyr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCsyr",                     {"hipblasCsyr_v2",                  "rocblas_csyr",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCsyr_64",                  {"hipblasCsyr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZsyr",                     {"hipblasZsyr_v2",                  "rocblas_zsyr",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZsyr_64",                  {"hipblasZsyr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCher",                     {"hipblasCher_v2",                  "rocblas_cher",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCher_64",                  {"hipblasCher_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZher",                     {"hipblasZher_v2",                  "rocblas_zher",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZher_64",                  {"hipblasZher_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SPR/HPR
  {"cublasSspr",                     {"hipblasSspr",                     "rocblas_sspr",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSspr_64",                  {"hipblasSspr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDspr",                     {"hipblasDspr",                     "rocblas_dspr",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDspr_64",                  {"hipblasDspr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasChpr",                     {"hipblasChpr_v2",                  "rocblas_chpr",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasChpr_64",                  {"hipblasChpr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZhpr",                     {"hipblasZhpr_v2",                  "rocblas_zhpr",                             CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZhpr_64",                  {"hipblasZhpr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SYR2/HER2
  {"cublasSsyr2",                    {"hipblasSsyr2",                    "rocblas_ssyr2",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSsyr2_64",                 {"hipblasSsyr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDsyr2",                    {"hipblasDsyr2",                    "rocblas_dsyr2",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDsyr2_64",                 {"hipblasDsyr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCsyr2",                    {"hipblasCsyr2_v2",                 "rocblas_csyr2",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCsyr2_64",                 {"hipblasCsyr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZsyr2",                    {"hipblasZsyr2_v2",                 "rocblas_zsyr2",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZsyr2_64",                 {"hipblasZsyr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCher2",                    {"hipblasCher2_v2",                 "rocblas_cher2",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCher2_64",                 {"hipblasCher2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZher2",                    {"hipblasZher2_v2",                 "rocblas_zher2",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZher2_64",                 {"hipblasZher2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SPR2/HPR2
  {"cublasSspr2",                    {"hipblasSspr2",                    "rocblas_sspr2",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSspr2_64",                 {"hipblasSspr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDspr2",                    {"hipblasDspr2",                    "rocblas_dspr2",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDspr2_64",                 {"hipblasDspr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasChpr2",                    {"hipblasChpr2_v2",                 "rocblas_chpr2",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasChpr2_64",                 {"hipblasChpr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZhpr2",                    {"hipblasZhpr2_v2",                 "rocblas_zhpr2",                            CONV_LIB_FUNC, API_BLAS, 6, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZhpr2_64",                 {"hipblasZhpr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // Blas3 (v1) Routines
  // GEMM
  {"cublasSgemm",                    {"hipblasSgemm",                    "rocblas_sgemm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSgemm_64",                 {"hipblasSgemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDgemm",                    {"hipblasDgemm",                    "rocblas_dgemm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDgemm_64",                 {"hipblasDgemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemm",                    {"hipblasCgemm_v2",                 "rocblas_cgemm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCgemm_64",                 {"hipblasCgemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZgemm",                    {"hipblasZgemm_v2",                 "rocblas_zgemm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZgemm_64",                 {"hipblasZgemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasHgemm",                    {"hipblasHgemm",                    "rocblas_hgemm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasHgemm_64",                 {"hipblasHgemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // BATCH GEMM
  {"cublasSgemmBatched",             {"hipblasSgemmBatched",             "rocblas_sgemm_batched",                    CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasSgemmBatched_64",          {"hipblasSgemmBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDgemmBatched",             {"hipblasDgemmBatched",             "rocblas_dgemm_batched",                    CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasDgemmBatched_64",          {"hipblasDgemmBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasHgemmBatched",             {"hipblasHgemmBatched",             "rocblas_hgemm_batched",                    CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasHgemmBatched_64",          {"hipblasHgemmBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasSgemmStridedBatched",      {"hipblasSgemmStridedBatched",      "rocblas_sgemm_strided_batched",            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasSgemmStridedBatched_64",   {"hipblasSgemmStridedBatched_64",   "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDgemmStridedBatched",      {"hipblasDgemmStridedBatched",      "rocblas_dgemm_strided_batched",            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasDgemmStridedBatched_64",   {"hipblasDgemmStridedBatched_64",   "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemmBatched",             {"hipblasCgemmBatched_v2",          "rocblas_cgemm_batched",                    CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCgemmBatched_64",          {"hipblasCgemmBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemm3mBatched",           {"hipblasCgemm3mBatched",           "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemm3mBatched_64",        {"hipblasCgemm3mBatched_64",        "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZgemmBatched",             {"hipblasZgemmBatched_v2",          "rocblas_zgemm_batched",                    CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZgemmBatched_64",          {"hipblasZgemmBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemmStridedBatched",      {"hipblasCgemmStridedBatched_v2",   "rocblas_cgemm_strided_batched",            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCgemmStridedBatched_64",   {"hipblasCgemmStridedBatched_64",   "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemm3mStridedBatched",    {"hipblasCgemm3mStridedBatched",    "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemm3mStridedBatched_64", {"hipblasCgemm3mStridedBatched_64", "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZgemmStridedBatched",      {"hipblasZgemmStridedBatched_v2",   "rocblas_zgemm_strided_batched",            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZgemmStridedBatched_64",   {"hipblasZgemmStridedBatched_64",   "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasHgemmStridedBatched",      {"hipblasHgemmStridedBatched",      "rocblas_hgemm_strided_batched",            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasHgemmStridedBatched_64",   {"hipblasHgemmStridedBatched_64",   "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // BATCH GEMV
  {"cublasSgemvBatched",             {"hipblasSgemvBatched",             "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasSgemvBatched_64",          {"hipblasSgemvBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDgemvBatched",             {"hipblasDgemvBatched",             "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDgemvBatched_64",          {"hipblasDgemvBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemvBatched",             {"hipblasCgemvBatched_v2",          "rocblas_cgemv_batched",                    CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCgemvBatched_64",          {"hipblasCgemvBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZgemvBatched",             {"hipblasZgemvBatched_v2",          "rocblas_zgemv_batched",                    CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZgemvBatched_64",          {"hipblasZgemvBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasHSHgemvBatched",           {"hipblasHSHgemvBatched",           "rocblas_hshgemv_batched",                  CONV_LIB_FUNC, API_BLAS, 7, HIP_UNSUPPORTED}},
  {"cublasHSHgemvBatched_64",        {"hipblasHSHgemvBatched_64",        "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasHSSgemvBatched",           {"hipblasHSSgemvBatched",           "rocblas_hssgemv_batched",                  CONV_LIB_FUNC, API_BLAS, 7, HIP_UNSUPPORTED}},
  {"cublasHSSgemvBatched_64",        {"hipblasHSSgemvBatched_64",        "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasTSTgemvBatched",           {"hipblasTSTgemvBatched",           "rocblas_tstgemv_batched",                  CONV_LIB_FUNC, API_BLAS, 7, HIP_UNSUPPORTED}},
  {"cublasTSTgemvBatched_64",        {"hipblasTSTgemvBatched_64",        "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasTSSgemvBatched",           {"hipblasTSSgemvBatched",           "rocblas_tssgemv_batched",                  CONV_LIB_FUNC, API_BLAS, 7, HIP_UNSUPPORTED}},
  {"cublasTSSgemvBatched_64",        {"hipblasTSSgemvBatched_64",        "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasSgemvStridedBatched",      {"hipblasSgemvStridedBatched",      "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasSgemvStridedBatched_64",   {"hipblasSgemvStridedBatched_64",   "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDgemvStridedBatched",      {"hipblasDgemvStridedBatched",      "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDgemvStridedBatched_64",   {"hipblasDgemvStridedBatched_64",   "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemvStridedBatched",      {"hipblasCgemvStridedBatched_v2",   "rocblas_cgemv_strided_batched",            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCgemvStridedBatched_64",   {"hipblasCgemvStridedBatched_64",   "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZgemvStridedBatched",      {"hipblasZgemvStridedBatched_v2",   "rocblas_zgemv_strided_batched",            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZgemvStridedBatched_64",   {"hipblasZgemvStridedBatched_64",   "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasHSHgemvStridedBatched",    {"hipblasHSHgemvStridedBatched",    "rocblas_hshgemv_strided_batched",          CONV_LIB_FUNC, API_BLAS, 7, HIP_UNSUPPORTED}},
  {"cublasHSHgemvStridedBatched_64", {"hipblasHSHgemvStridedBatched_64", "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasHSSgemvStridedBatched",    {"hipblasHSSgemvStridedBatched",    "rocblas_hssgemv_strided_batched",          CONV_LIB_FUNC, API_BLAS, 7, HIP_UNSUPPORTED}},
  {"cublasHSSgemvStridedBatched_64", {"hipblasHSSgemvStridedBatched_64", "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasTSTgemvStridedBatched",    {"hipblasTSTgemvStridedBatched",    "rocblas_tstgemv_strided_batched",          CONV_LIB_FUNC, API_BLAS, 7, HIP_UNSUPPORTED}},
  {"cublasTSTgemvStridedBatched_64", {"hipblasTSTgemvStridedBatched_64", "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasTSSgemvStridedBatched",    {"hipblasTSSgemvStridedBatched",    "rocblas_tssgemv_strided_batched",          CONV_LIB_FUNC, API_BLAS, 7, HIP_UNSUPPORTED}},
  {"cublasTSSgemvStridedBatched_64", {"hipblasTSSgemvStridedBatched_64", "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // SYRK
  {"cublasSsyrk",                    {"hipblasSsyrk",                    "rocblas_ssyrk",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSsyrk_64",                 {"hipblasSsyrk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDsyrk",                    {"hipblasDsyrk",                    "rocblas_dsyrk",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDsyrk_64",                 {"hipblasDsyrk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCsyrk",                    {"hipblasCsyrk_v2",                 "rocblas_csyrk",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCsyrk_64",                 {"hipblasCsyrk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZsyrk",                    {"hipblasZsyrk_v2",                 "rocblas_zsyrk",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZsyrk_64",                 {"hipblasZsyrk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // HERK
  {"cublasCherk",                    {"hipblasCherk_v2",                 "rocblas_cherk",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCherk_64",                 {"hipblasCherk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZherk",                    {"hipblasZherk_v2",                 "rocblas_zherk",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZherk_64",                 {"hipblasZherk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // SYR2K
  {"cublasSsyr2k",                   {"hipblasSsyr2k",                   "rocblas_ssyr2k",                           CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSsyr2k_64",                {"hipblasSsyr2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDsyr2k",                   {"hipblasDsyr2k",                   "rocblas_dsyr2k",                           CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDsyr2k_64",                {"hipblasDsyr2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCsyr2k",                   {"hipblasCsyr2k_v2",                "rocblas_csyr2k",                           CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCsyr2k_64",                {"hipblasCsyr2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZsyr2k",                   {"hipblasZsyr2k_v2",                "rocblas_zsyr2k",                           CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZsyr2k_64",                {"hipblasZsyr2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // SYRKX - eXtended SYRK
  {"cublasSsyrkx",                   {"hipblasSsyrkx",                   "rocblas_ssyrkx",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasSsyrkx_64",                {"hipblasSsyrkx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDsyrkx",                   {"hipblasDsyrkx",                   "rocblas_dsyrkx",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasDsyrkx_64",                {"hipblasDsyrkx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCsyrkx",                   {"hipblasCsyrkx_v2",                "rocblas_csyrkx",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCsyrkx_64",                {"hipblasCsyrkx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZsyrkx",                   {"hipblasZsyrkx_v2",                "rocblas_zsyrkx",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZsyrkx_64",                {"hipblasZsyrkx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // HER2K
  {"cublasCher2k",                   {"hipblasCher2k_v2",                "rocblas_cher2k",                           CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCher2k_64",                {"hipblasCher2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZher2k",                   {"hipblasZher2k_v2",                "rocblas_zher2k",                           CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZher2k_64",                {"hipblasZher2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // HERKX - eXtended HERK
  {"cublasCherkx",                   {"hipblasCherkx_v2",                "rocblas_cherkx",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCherkx_64",                {"hipblasCherkx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZherkx",                   {"hipblasZherkx_v2",                "rocblas_zherkx",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZherkx_64",                {"hipblasZherkx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // SYMM
  {"cublasSsymm",                    {"hipblasSsymm",                    "rocblas_ssymm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasSsymm_64",                 {"hipblasSsymm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDsymm",                    {"hipblasDsymm",                    "rocblas_dsymm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDsymm_64",                 {"hipblasDsymm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCsymm",                    {"hipblasCsymm_v2",                 "rocblas_csymm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCsymm_64",                 {"hipblasCsymm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZsymm",                    {"hipblasZsymm_v2",                 "rocblas_zsymm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZsymm_64",                 {"hipblasZsymm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // HEMM
  {"cublasChemm",                    {"hipblasChemm_v2",                 "rocblas_chemm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasChemm_64",                 {"hipblasChemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZhemm",                    {"hipblasZhemm_v2",                 "rocblas_zhemm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZhemm_64",                 {"hipblasZhemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // TRSM
  {"cublasStrsm",                    {"hipblasStrsm",                    "rocblas_strsm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasStrsm_64",                 {"hipblasStrsm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDtrsm",                    {"hipblasDtrsm",                    "rocblas_dtrsm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDtrsm_64",                 {"hipblasDtrsm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCtrsm",                    {"hipblasCtrsm_v2",                 "rocblas_ctrsm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCtrsm_64",                 {"hipblasCtrsm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZtrsm",                    {"hipblasZtrsm_v2",                 "rocblas_ztrsm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZtrsm_64",                 {"hipblasZtrsm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // TRMM
  {"cublasStrmm",                    {"hipblasStrmm",                    "rocblas_strmm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasStrmm_64",                 {"hipblasStrmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDtrmm",                    {"hipblasDtrmm",                    "rocblas_dtrmm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasDtrmm_64",                 {"hipblasDtrmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCtrmm",                    {"hipblasCtrmm_v2",                 "rocblas_ctrmm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasCtrmm_64",                 {"hipblasCtrmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZtrmm",                    {"hipblasZtrmm_v2",                 "rocblas_ztrmm",                            CONV_LIB_FUNC, API_BLAS, 7, HIP_SUPPORTED_V2_ONLY}},
  {"cublasZtrmm_64",                 {"hipblasZtrmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // ------------------------ CUBLAS BLAS - like extension (cublas_api.h)
  // GEAM
  {"cublasSgeam",                    {"hipblasSgeam",                    "rocblas_sgeam",                            CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasSgeam_64",                 {"hipblasSgeam_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasDgeam",                    {"hipblasDgeam",                    "rocblas_dgeam",                            CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasDgeam_64",                 {"hipblasDgeam_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCgeam",                    {"hipblasCgeam_v2",                 "rocblas_cgeam",                            CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasCgeam_64",                 {"hipblasCgeam_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasZgeam",                    {"hipblasZgeam_v2",                 "rocblas_zgeam",                            CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasZgeam_64",                 {"hipblasZgeam_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},

  // GETRF - Batched LU
  {"cublasSgetrfBatched",            {"hipblasSgetrfBatched",            "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasDgetrfBatched",            {"hipblasDgetrfBatched",            "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasCgetrfBatched",            {"hipblasCgetrfBatched_v2",         "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasZgetrfBatched",            {"hipblasZgetrfBatched_v2",         "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},

  // Batched inversion based on LU factorization from getrf
  {"cublasSgetriBatched",            {"hipblasSgetriBatched",            "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasDgetriBatched",            {"hipblasDgetriBatched",            "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasCgetriBatched",            {"hipblasCgetriBatched_v2",         "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasZgetriBatched",            {"hipblasZgetriBatched_v2",         "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},

  // Batched solver based on LU factorization from getrf
  {"cublasSgetrsBatched",            {"hipblasSgetrsBatched",            "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasDgetrsBatched",            {"hipblasDgetrsBatched",            "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasCgetrsBatched",            {"hipblasCgetrsBatched_v2",         "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasZgetrsBatched",            {"hipblasZgetrsBatched_v2",         "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},

  // TRSM - Batched Triangular Solver
  {"cublasStrsmBatched",             {"hipblasStrsmBatched",             "rocblas_strsm_batched",                    CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasStrsmBatched_64",          {"hipblasStrsmBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasDtrsmBatched",             {"hipblasDtrsmBatched",             "rocblas_dtrsm_batched",                    CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasDtrsmBatched_64",          {"hipblasDtrsmBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCtrsmBatched",             {"hipblasCtrsmBatched_v2",          "rocblas_ctrsm_batched",                    CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasCtrsmBatched_64",          {"hipblasCtrsmBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasZtrsmBatched",             {"hipblasZtrsmBatched_v2",          "rocblas_ztrsm_batched",                    CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasZtrsmBatched_64",          {"hipblasZtrsmBatched_64",          "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},

  // MATINV - Batched
  {"cublasSmatinvBatched",           {"hipblasSmatinvBatched",           "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasDmatinvBatched",           {"hipblasDmatinvBatched",           "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCmatinvBatched",           {"hipblasCmatinvBatched",           "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasZmatinvBatched",           {"hipblasZmatinvBatched",           "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},

  // Batch QR Factorization
  {"cublasSgeqrfBatched",            {"hipblasSgeqrfBatched",            "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasDgeqrfBatched",            {"hipblasDgeqrfBatched",            "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasCgeqrfBatched",            {"hipblasCgeqrfBatched_v2",         "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasZgeqrfBatched",            {"hipblasZgeqrfBatched_v2",         "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},

  // Least Square Min only m >= n and Non-transpose supported
  {"cublasSgelsBatched",             {"hipblasSgelsBatched",             "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasDgelsBatched",             {"hipblasDgelsBatched",             "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasCgelsBatched",             {"hipblasCgelsBatched_v2",          "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},
  {"cublasZgelsBatched",             {"hipblasZgelsBatched_v2",          "",                                         CONV_LIB_FUNC, API_BLAS, 8, ROC_UNSUPPORTED}},

  // DGMM
  {"cublasSdgmm",                    {"hipblasSdgmm",                    "rocblas_sdgmm",                            CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasSdgmm_64",                 {"hipblasSdgmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasDdgmm",                    {"hipblasDdgmm",                    "rocblas_ddgmm",                            CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasDdgmm_64",                 {"hipblasDdgmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCdgmm",                    {"hipblasCdgmm_v2",                 "rocblas_cdgmm",                            CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasCdgmm_64",                 {"hipblasCdgmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasZdgmm",                    {"hipblasZdgmm_v2",                 "rocblas_zdgmm",                            CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasZdgmm_64",                 {"hipblasZdgmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},

  // TPTTR - Triangular Pack format to Triangular format
  {"cublasStpttr",                   {"hipblasStpttr",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasDtpttr",                   {"hipblasDtpttr",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCtpttr",                   {"hipblasCtpttr",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasZtpttr",                   {"hipblasZtpttr",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},

  // TRTTP - Triangular format to Triangular Pack format
  {"cublasStrttp",                   {"hipblasStrttp",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasDtrttp",                   {"hipblasDtrttp",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCtrttp",                   {"hipblasCtrttp",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasZtrttp",                   {"hipblasZtrttp",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},

  // GEMV
  {"cublasSgemv_v2",                 {"hipblasSgemv",                    "rocblas_sgemv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasSgemv_v2_64",              {"hipblasSgemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDgemv_v2",                 {"hipblasDgemv",                    "rocblas_dgemv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDgemv_v2_64",              {"hipblasDgemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCgemv_v2",                 {"hipblasCgemv_v2",                 "rocblas_cgemv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCgemv_v2_64",              {"hipblasCgemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZgemv_v2",                 {"hipblasZgemv_v2",                 "rocblas_zgemv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZgemv_v2_64",              {"hipblasZgemv_64",                 "rocblas_zgemv",                            CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // GBMV
  {"cublasSgbmv_v2",                 {"hipblasSgbmv",                    "rocblas_sgbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasSgbmv_v2_64",              {"hipblasSgbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDgbmv_v2",                 {"hipblasDgbmv",                    "rocblas_dgbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDgbmv_v2_64",              {"hipblasDgbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCgbmv_v2",                 {"hipblasCgbmv_v2",                 "rocblas_cgbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCgbmv_v2_64",              {"hipblasCgbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZgbmv_v2",                 {"hipblasZgbmv_v2",                 "rocblas_zgbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZgbmv_v2_64",              {"hipblasZgbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TRMV
  {"cublasStrmv_v2",                 {"hipblasStrmv",                    "rocblas_strmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasStrmv_v2_64",              {"hipblasStrmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtrmv_v2",                 {"hipblasDtrmv",                    "rocblas_dtrmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDtrmv_v2_64",              {"hipblasDtrmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtrmv_v2",                 {"hipblasCtrmv_v2",                 "rocblas_ctrmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCtrmv_v2_64",              {"hipblasCtrmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtrmv_v2",                 {"hipblasZtrmv_v2",                 "rocblas_ztrmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZtrmv_v2_64",              {"hipblasZtrmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TBMV
  {"cublasStbmv_v2",                 {"hipblasStbmv",                    "rocblas_stbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasStbmv_v2_64",              {"hipblasStbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtbmv_v2",                 {"hipblasDtbmv",                    "rocblas_dtbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDtbmv_v2_64",              {"hipblasDtbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtbmv_v2",                 {"hipblasCtbmv_v2",                 "rocblas_ctbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCtbmv_v2_64",              {"hipblasCtbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtbmv_v2",                 {"hipblasZtbmv_v2",                 "rocblas_ztbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZtbmv_v2_64",              {"hipblasZtbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TPMV
  {"cublasStpmv_v2",                 {"hipblasStpmv",                    "rocblas_stpmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasStpmv_v2_64",              {"hipblasStpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtpmv_v2",                 {"hipblasDtpmv",                    "rocblas_dtpmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDtpmv_v2_64",              {"hipblasDtpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtpmv_v2",                 {"hipblasCtpmv_v2",                 "rocblas_ctpmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCtpmv_v2_64",              {"hipblasCtpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtpmv_v2",                 {"hipblasZtpmv_v2",                 "rocblas_ztpmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZtpmv_v2_64",              {"hipblasZtpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TRSV
  {"cublasStrsv_v2",                 {"hipblasStrsv",                    "rocblas_strsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasStrsv_v2_64",              {"hipblasStrsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtrsv_v2",                 {"hipblasDtrsv",                    "rocblas_dtrsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDtrsv_v2_64",              {"hipblasDtrsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtrsv_v2",                 {"hipblasCtrsv_v2",                 "rocblas_ctrsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCtrsv_v2_64",              {"hipblasCtrsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtrsv_v2",                 {"hipblasZtrsv_v2",                 "rocblas_ztrsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZtrsv_v2_64",              {"hipblasZtrsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TPSV
  {"cublasStpsv_v2",                 {"hipblasStpsv",                    "rocblas_stpsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasStpsv_v2_64",              {"hipblasStpsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtpsv_v2",                 {"hipblasDtpsv",                    "rocblas_dtpsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDtpsv_v2_64",              {"hipblasDtpsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtpsv_v2",                 {"hipblasCtpsv_v2",                 "rocblas_ctpsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCtpsv_v2_64",              {"hipblasCtpsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtpsv_v2",                 {"hipblasZtpsv_v2",                 "rocblas_ztpsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZtpsv_v2_64",              {"hipblasZtpsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // TBSV
  {"cublasStbsv_v2",                 {"hipblasStbsv",                    "rocblas_stbsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasStbsv_v2_64",              {"hipblasStbsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDtbsv_v2",                 {"hipblasDtbsv",                    "rocblas_dtbsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDtbsv_v2_64",              {"hipblasDtbsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCtbsv_v2",                 {"hipblasCtbsv_v2",                 "rocblas_ctbsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCtbsv_v2_64",              {"hipblasCtbsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZtbsv_v2",                 {"hipblasZtbsv_v2",                 "rocblas_ztbsv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZtbsv_v2_64",              {"hipblasZtbsv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SYMV/HEMV
  {"cublasSsymv_v2",                 {"hipblasSsymv",                    "rocblas_ssymv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasSsymv_v2_64",              {"hipblasSsymv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDsymv_v2",                 {"hipblasDsymv",                    "rocblas_dsymv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDsymv_v2_64",              {"hipblasDsymv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCsymv_v2",                 {"hipblasCsymv_v2",                 "rocblas_csymv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCsymv_v2_64",              {"hipblasCsymv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZsymv_v2",                 {"hipblasZsymv_v2",                 "rocblas_zsymv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZsymv_v2_64",              {"hipblasZsymv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasChemv_v2",                 {"hipblasChemv_v2",                 "rocblas_chemv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasChemv_v2_64",              {"hipblasChemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZhemv_v2",                 {"hipblasZhemv_v2",                 "rocblas_zhemv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZhemv_v2_64",              {"hipblasZhemv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SBMV/HBMV
  {"cublasSsbmv_v2",                 {"hipblasSsbmv",                    "rocblas_ssbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasSsbmv_v2_64",              {"hipblasSsbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDsbmv_v2",                 {"hipblasDsbmv",                    "rocblas_dsbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDsbmv_v2_64",              {"hipblasDsbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasChbmv_v2",                 {"hipblasChbmv_v2",                 "rocblas_chbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasChbmv_v2_64",              {"hipblasChbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZhbmv_v2",                 {"hipblasZhbmv_v2",                 "rocblas_zhbmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZhbmv_v2_64",              {"hipblasZhbmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SPMV/HPMV
  {"cublasSspmv_v2",                 {"hipblasSspmv",                    "rocblas_sspmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasSspmv_v2_64",              {"hipblasSspmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDspmv_v2",                 {"hipblasDspmv",                    "rocblas_dspmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDspmv_v2_64",              {"hipblasDspmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasChpmv_v2",                 {"hipblasChpmv_v2",                 "rocblas_chpmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasChpmv_v2_64",              {"hipblasChpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZhpmv_v2",                 {"hipblasZhpmv_v2",                 "rocblas_zhpmv",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZhpmv_v2_64",              {"hipblasZhpmv_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // GER
  {"cublasSger_v2",                  {"hipblasSger",                     "rocblas_sger",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasSger_v2_64",               {"hipblasSger_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDger_v2",                  {"hipblasDger",                     "rocblas_dger",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDger_v2_64",               {"hipblasDger_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCgeru_v2",                 {"hipblasCgeru_v2",                 "rocblas_cgeru",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCgeru_v2_64",              {"hipblasCgeru_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCgerc_v2",                 {"hipblasCgerc_v2",                 "rocblas_cgerc",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCgerc_v2_64",              {"hipblasCgerc_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZgeru_v2",                 {"hipblasZgeru_v2",                 "rocblas_zgeru",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZgeru_v2_64",              {"hipblasZgeru_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZgerc_v2",                 {"hipblasZgerc_v2",                 "rocblas_zgerc",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZgerc_v2_64",              {"hipblasZgerc_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SYR/HER
  {"cublasSsyr_v2",                  {"hipblasSsyr",                     "rocblas_ssyr",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasSsyr_v2_64",               {"hipblasSsyr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDsyr_v2",                  {"hipblasDsyr",                     "rocblas_dsyr",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDsyr_v2_64",               {"hipblasDsyr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCsyr_v2",                  {"hipblasCsyr_v2",                  "rocblas_csyr",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCsyr_v2_64",               {"hipblasCsyr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZsyr_v2",                  {"hipblasZsyr_v2",                  "rocblas_zsyr",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZsyr_v2_64",               {"hipblasZsyr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCher_v2",                  {"hipblasCher_v2",                  "rocblas_cher",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCher_v2_64",               {"hipblasCher_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZher_v2",                  {"hipblasZher_v2",                  "rocblas_zher",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZher_v2_64",               {"hipblasZher_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SPR/HPR
  {"cublasSspr_v2",                  {"hipblasSspr",                     "rocblas_sspr",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasSspr_v2_64",               {"hipblasSspr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDspr_v2",                  {"hipblasDspr",                     "rocblas_dspr",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDspr_v2_64",               {"hipblasDspr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasChpr_v2",                  {"hipblasChpr_v2",                  "rocblas_chpr",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasChpr_v2_64",               {"hipblasChpr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZhpr_v2",                  {"hipblasZhpr_v2",                  "rocblas_zhpr",                             CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZhpr_v2_64",               {"hipblasZhpr_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SYR2/HER2
  {"cublasSsyr2_v2",                 {"hipblasSsyr2",                    "rocblas_ssyr2",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasSsyr2_v2_64",              {"hipblasSsyr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDsyr2_v2",                 {"hipblasDsyr2",                    "rocblas_dsyr2",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDsyr2_v2_64",              {"hipblasDsyr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCsyr2_v2",                 {"hipblasCsyr2_v2",                 "rocblas_csyr2",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCsyr2_v2_64",              {"hipblasCsyr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZsyr2_v2",                 {"hipblasZsyr2_v2",                 "rocblas_zsyr2",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZsyr2_v2_64",              {"hipblasZsyr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasCher2_v2",                 {"hipblasCher2_v2",                 "rocblas_cher2",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasCher2_v2_64",              {"hipblasCher2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZher2_v2",                 {"hipblasZher2_v2",                 "rocblas_zher2",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZher2_v2_64",              {"hipblasZher2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // SPR2/HPR2
  {"cublasSspr2_v2",                 {"hipblasSspr2",                    "rocblas_sspr2",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasSspr2_v2_64",              {"hipblasSspr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasDspr2_v2",                 {"hipblasDspr2",                    "rocblas_dspr2",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasDspr2_v2_64",              {"hipblasDspr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasChpr2_v2",                 {"hipblasChpr2_v2",                 "rocblas_chpr2",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasChpr2_v2_64",              {"hipblasChpr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},
  {"cublasZhpr2_v2",                 {"hipblasZhpr2_v2",                 "rocblas_zhpr2",                            CONV_LIB_FUNC, API_BLAS, 6}},
  {"cublasZhpr2_v2_64",              {"hipblasZhpr2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 6, UNSUPPORTED}},

  // Blas3 (v2) Routines
  // GEMM
  {"cublasSgemm_v2",                 {"hipblasSgemm",                    "rocblas_sgemm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasSgemm_v2_64",              {"hipblasSgemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDgemm_v2",                 {"hipblasDgemm",                    "rocblas_dgemm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasDgemm_v2_64",              {"hipblasDgemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemm_v2",                 {"hipblasCgemm_v2",                 "rocblas_cgemm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCgemm_v2_64",              {"hipblasCgemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemm3m",                  {"hipblasCgemm3m",                  "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemm3m_64",               {"hipblasCgemm3m_64",               "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemm3mEx",                {"hipblasCgemm3mEx",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCgemm3mEx_64",             {"hipblasCgemm3mEx_64",             "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZgemm_v2",                 {"hipblasZgemm_v2",                 "rocblas_zgemm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZgemm_v2_64",              {"hipblasZgemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZgemm3m",                  {"hipblasZgemm3m",                  "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZgemm3m_64",               {"hipblasZgemm3m_64",               "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  //IO in FP16 / FP32, computation in float
  {"cublasSgemmEx",                  {"hipblasSgemmEx",                  "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasSgemmEx_64",               {"hipblasSgemmEx_64",               "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasGemmEx",                   {"hipblasGemmEx_v2",                "rocblas_gemm_ex",                          CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasGemmEx_64",                {"hipblasGemmEx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasGemmBatchedEx",            {"hipblasGemmBatchedEx_v2",         "rocblas_gemm_batched_ex",                  CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasGemmBatchedEx_64",         {"hipblasGemmBatchedEx_64",         "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasGemmStridedBatchedEx",     {"hipblasGemmStridedBatchedEx_v2",  "rocblas_gemm_strided_batched_ex",          CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasGemmStridedBatchedEx_64",  {"hipblasGemmStridedBatchedEx_64",  "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  // IO in Int8 complex/cuComplex, computation in cuComplex
  {"cublasCgemmEx",                  {"hipblasCgemmEx",                  "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCgemmEx_64",               {"hipblasCgemmEx_64",               "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasUint8gemmBias",            {"hipblasUint8gemmBias",            "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},

  // SYRK
  {"cublasSsyrk_v2",                 {"hipblasSsyrk",                    "rocblas_ssyrk",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasSsyrk_v2_64",              {"hipblasSsyrk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDsyrk_v2",                 {"hipblasDsyrk",                    "rocblas_dsyrk",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasDsyrk_v2_64",              {"hipblasDsyrk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCsyrk_v2",                 {"hipblasCsyrk_v2",                 "rocblas_csyrk",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCsyrk_v2_64",              {"hipblasCsyrk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZsyrk_v2",                 {"hipblasZsyrk_v2",                 "rocblas_zsyrk",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZsyrk_v2_64",              {"hipblasZsyrk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // IO in Int8 complex/cuComplex, computation in cuComplex
  {"cublasCsyrkEx",                  {"hipblasCsyrkEx",                  "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCsyrkEx_64",               {"hipblasCsyrkEx_64",               "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  // IO in Int8 complex/cuComplex, computation in cuComplex, Gaussian math
  {"cublasCsyrk3mEx",                {"hipblasCsyrk3mEx",                "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCsyrk3mEx_64",             {"hipblasCsyrk3mEx_64",             "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},

  // HERK
  {"cublasCherk_v2",                 {"hipblasCherk_v2",                 "rocblas_cherk",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCherk_v2_64",              {"hipblasCherk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  // IO in Int8 complex/cuComplex, computation in cuComplex
  {"cublasCherkEx",                  {"hipblasCherkEx",                  "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCherkEx_64",               {"hipblasCherkEx_64",               "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  // IO in Int8 complex/cuComplex, computation in cuComplex, Gaussian math
  {"cublasCherk3mEx",                {"hipblasCherk3mEx",                "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCherk3mEx_64",             {"hipblasCherk3mEx_64",             "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasZherk_v2",                 {"hipblasZherk_v2",                 "rocblas_zherk",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZherk_v2_64",              {"hipblasZherk_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // SYR2K
  {"cublasSsyr2k_v2",                {"hipblasSsyr2k",                   "rocblas_ssyr2k",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasSsyr2k_v2_64",             {"hipblasSsyr2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDsyr2k_v2",                {"hipblasDsyr2k",                   "rocblas_dsyr2k",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasDsyr2k_v2_64",             {"hipblasDsyr2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCsyr2k_v2",                {"hipblasCsyr2k_v2",                "rocblas_csyr2k",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCsyr2k_v2_64",             {"hipblasCsyr2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZsyr2k_v2",                {"hipblasZsyr2k_v2",                "rocblas_zsyr2k",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZsyr2k_v2_64",             {"hipblasZsyr2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // HER2K
  {"cublasCher2k_v2",                {"hipblasCher2k_v2",                "rocblas_cher2k",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCher2k_v2_64",             {"hipblasCher2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZher2k_v2",                {"hipblasZher2k_v2",                "rocblas_zher2k",                           CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZher2k_v2_64",             {"hipblasZher2k_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // SYMM
  {"cublasSsymm_v2",                 {"hipblasSsymm",                    "rocblas_ssymm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasSsymm_v2_64",              {"hipblasSsymm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDsymm_v2",                 {"hipblasDsymm",                    "rocblas_dsymm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasDsymm_v2_64",              {"hipblasDsymm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCsymm_v2",                 {"hipblasCsymm_v2",                 "rocblas_csymm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCsymm_v2_64",              {"hipblasCsymm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZsymm_v2",                 {"hipblasZsymm_v2",                 "rocblas_zsymm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZsymm_v2_64",              {"hipblasZsymm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // HEMM
  {"cublasChemm_v2",                 {"hipblasChemm_v2",                 "rocblas_chemm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasChemm_v2_64",              {"hipblasChemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZhemm_v2",                 {"hipblasZhemm_v2",                 "rocblas_zhemm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZhemm_v2_64",              {"hipblasZhemm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // TRSM
  {"cublasStrsm_v2",                 {"hipblasStrsm",                    "rocblas_strsm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasStrsm_v2_64",              {"hipblasStrsm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDtrsm_v2",                 {"hipblasDtrsm",                    "rocblas_dtrsm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasDtrsm_v2_64",              {"hipblasDtrsm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCtrsm_v2",                 {"hipblasCtrsm_v2",                 "rocblas_ctrsm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCtrsm_v2_64",              {"hipblasCtrsm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZtrsm_v2",                 {"hipblasZtrsm_v2",                 "rocblas_ztrsm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZtrsm_v2_64",              {"hipblasZtrsm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // TRMM
  {"cublasStrmm_v2",                 {"hipblasStrmm",                    "rocblas_strmm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasStrmm_v2_64",              {"hipblasStrmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasDtrmm_v2",                 {"hipblasDtrmm",                    "rocblas_dtrmm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasDtrmm_v2_64",              {"hipblasDtrmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasCtrmm_v2",                 {"hipblasCtrmm_v2",                 "rocblas_ctrmm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasCtrmm_v2_64",              {"hipblasCtrmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},
  {"cublasZtrmm_v2",                 {"hipblasZtrmm_v2",                 "rocblas_ztrmm",                            CONV_LIB_FUNC, API_BLAS, 7}},
  {"cublasZtrmm_v2_64",              {"hipblasZtrmm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 7, UNSUPPORTED}},

  // NRM2
  {"cublasSnrm2_v2",                 {"hipblasSnrm2",                    "rocblas_snrm2",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasSnrm2_v2_64",              {"hipblasSnrm2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDnrm2_v2",                 {"hipblasDnrm2",                    "rocblas_dnrm2",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDnrm2_v2_64",              {"hipblasDnrm2_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasScnrm2_v2",                {"hipblasScnrm2_v2",                "rocblas_scnrm2",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasScnrm2_v2_64",             {"hipblasScnrm2_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDznrm2_v2",                {"hipblasDznrm2_v2",                "rocblas_dznrm2",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDznrm2_v2_64",             {"hipblasDznrm2_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // DOT
  {"cublasDotEx",                    {"hipblasDotEx_v2",                 "rocblas_dot_ex",                           CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasDotEx_64",                 {"hipblasDotEx_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasDotcEx",                   {"hipblasDotcEx_v2",                "rocblas_dotc_ex",                          CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasDotcEx_64",                {"hipblasDotcEx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},

  {"cublasSdot_v2",                  {"hipblasSdot",                     "rocblas_sdot",                             CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasSdot_v2_64",               {"hipblasSdot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDdot_v2",                  {"hipblasDdot",                     "rocblas_ddot",                             CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDdot_v2_64",               {"hipblasDdot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  {"cublasCdotu_v2",                 {"hipblasCdotu_v2",                 "rocblas_cdotu",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasCdotu_v2_64",              {"hipblasCdotu_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCdotc_v2",                 {"hipblasCdotc_v2",                 "rocblas_cdotc",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasCdotc_v2_64",              {"hipblasCdotc_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZdotu_v2",                 {"hipblasZdotu_v2",                 "rocblas_zdotu",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasZdotu_v2_64",              {"hipblasZdotu_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZdotc_v2",                 {"hipblasZdotc_v2",                 "rocblas_zdotc",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasZdotc_v2_64",              {"hipblasZdotc_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // SCAL
  {"cublasScalEx",                   {"hipblasScalEx_v2",                "rocblas_scal_ex",                          CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasScalEx_64",                {"hipblasScalEx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasSscal_v2",                 {"hipblasSscal",                    "rocblas_sscal",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasSscal_v2_64",              {"hipblasSscal_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDscal_v2",                 {"hipblasDscal",                    "rocblas_dscal",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDscal_v2_64",              {"hipblasDscal_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCscal_v2",                 {"hipblasCscal_v2",                 "rocblas_cscal",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasCscal_v2_64",              {"hipblasCscal_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCsscal_v2",                {"hipblasCsscal_v2",                "rocblas_csscal",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasCsscal_v2_64",             {"hipblasCsscal_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZscal_v2",                 {"hipblasZscal_v2",                 "rocblas_zscal",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasZscal_v2_64",              {"hipblasZscal_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZdscal_v2",                {"hipblasZdscal_v2",                "rocblas_zdscal",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasZdscal_v2_64",             {"hipblasZdscal_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // AXPY
  {"cublasAxpyEx",                   {"hipblasAxpyEx_v2",                "rocblas_axpy_ex",                          CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasAxpyEx_64",                {"hipblasAxpyEx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasSaxpy_v2",                 {"hipblasSaxpy",                    "rocblas_saxpy",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasSaxpy_v2_64",              {"hipblasSaxpy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDaxpy_v2",                 {"hipblasDaxpy",                    "rocblas_daxpy",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDaxpy_v2_64",              {"hipblasDaxpy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCaxpy_v2",                 {"hipblasCaxpy_v2",                 "rocblas_caxpy",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasCaxpy_v2_64",              {"hipblasCaxpy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZaxpy_v2",                 {"hipblasZaxpy_v2",                 "rocblas_zaxpy",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasZaxpy_v2_64",              {"hipblasZaxpy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // COPY
  {"cublasCopyEx",                   {"hipblasCopyEx",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasCopyEx_64",                {"hipblasCopyEx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasScopy_v2",                 {"hipblasScopy",                    "rocblas_scopy",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasScopy_v2_64",              {"hipblasScopy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDcopy_v2",                 {"hipblasDcopy",                    "rocblas_dcopy",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDcopy_v2_64",              {"hipblasDcopy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCcopy_v2",                 {"hipblasCcopy_v2",                 "rocblas_ccopy",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasCcopy_v2_64",              {"hipblasCcopy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZcopy_v2",                 {"hipblasZcopy_v2",                 "rocblas_zcopy",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasZcopy_v2_64",              {"hipblasZcopy_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // SWAP
  {"cublasSwapEx",                   {"hipblasSwapEx",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasSwapEx_64",                {"hipblasSwapEx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasSswap_v2",                 {"hipblasSswap",                    "rocblas_sswap",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasSswap_v2_64",              {"hipblasSswap_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDswap_v2",                 {"hipblasDswap",                    "rocblas_dswap",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDswap_v2_64",              {"hipblasDswap_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCswap_v2",                 {"hipblasCswap_v2",                 "rocblas_cswap",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasCswap_v2_64",              {"hipblasCswap_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZswap_v2",                 {"hipblasZswap_v2",                 "rocblas_zswap",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasZswap_v2_64",              {"hipblasZswap_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // AMAX
  {"cublasIamaxEx",                  {"hipblasIamaxEx",                  "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasIamaxEx_64",               {"hipblasIamaxEx_64",               "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasIsamax_v2",                {"hipblasIsamax",                   "rocblas_isamax",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasIsamax_v2_64",             {"hipblasIsamax_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIdamax_v2",                {"hipblasIdamax",                   "rocblas_idamax",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasIdamax_v2_64",             {"hipblasIdamax_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIcamax_v2",                {"hipblasIcamax_v2",                "rocblas_icamax",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasIcamax_v2_64",             {"hipblasIcamax_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIzamax_v2",                {"hipblasIzamax_v2",                "rocblas_izamax",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasIzamax_v2_64",             {"hipblasIzamax_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // AMIN
  {"cublasIaminEx",                  {"hipblasIaminEx",                  "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasIaminEx_64",               {"hipblasIaminEx_64",               "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasIsamin_v2",                {"hipblasIsamin",                   "rocblas_isamin",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasIsamin_v2_64",             {"hipblasIsamin_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIdamin_v2",                {"hipblasIdamin",                   "rocblas_idamin",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasIdamin_v2_64",             {"hipblasIdamin_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIcamin_v2",                {"hipblasIcamin_v2",                "rocblas_icamin",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasIcamin_v2_64",             {"hipblasIcamin_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasIzamin_v2",                {"hipblasIzamin_v2",                "rocblas_izamin",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasIzamin_v2_64",             {"hipblasIzamin_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // ASUM
  {"cublasAsumEx",                   {"hipblasAsumEx",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasAsumEx_64",                {"hipblasAsumEx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasSasum_v2",                 {"hipblasSasum",                    "rocblas_sasum",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasSasum_v2_64",              {"hipblasSasum_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDasum_v2",                 {"hipblasDasum",                    "rocblas_dasum",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDasum_v2_64",              {"hipblasDasum_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasScasum_v2",                {"hipblasScasum_v2",                "rocblas_scasum",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasScasum_v2_64",             {"hipblasScasum_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDzasum_v2",                {"hipblasDzasum_v2",                "rocblas_dzasum",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDzasum_v2_64",             {"hipblasDzasum_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // ROT
  {"cublasRotEx",                    {"hipblasRotEx_v2",                 "rocblas_rot_ex",                           CONV_LIB_FUNC, API_BLAS, 8}},
  {"cublasRotEx_64",                 {"hipblasRotEx_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasSrot_v2",                  {"hipblasSrot",                     "rocblas_srot",                             CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasSrot_v2_64",               {"hipblasSrot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDrot_v2",                  {"hipblasDrot",                     "rocblas_drot",                             CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDrot_v2_64",               {"hipblasDrot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCrot_v2",                  {"hipblasCrot_v2",                  "rocblas_crot",                             CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasCrot_v2_64",               {"hipblasCrot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasCsrot_v2",                 {"hipblasCsrot_v2",                 "rocblas_csrot",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasCsrot_v2_64",              {"hipblasCsrot_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZrot_v2",                  {"hipblasZrot_v2",                  "rocblas_zrot",                             CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasZrot_v2_64",               {"hipblasZrot_64",                  "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasZdrot_v2",                 {"hipblasZdrot_v2",                 "rocblas_zdrot",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasZdrot_v2_64",              {"hipblasZdrot_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // ROTG
  {"cublasRotgEx",                   {"hipblasRotgEx",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasSrotg_v2",                 {"hipblasSrotg",                    "rocblas_srotg",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDrotg_v2",                 {"hipblasDrotg",                    "rocblas_drotg",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasCrotg_v2",                 {"hipblasCrotg_v2",                 "rocblas_crotg",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasZrotg_v2",                 {"hipblasZrotg_v2",                 "rocblas_zrotg",                            CONV_LIB_FUNC, API_BLAS, 5}},

  // ROTM
  {"cublasRotmEx",                   {"hipblasRotmEx",                   "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasRotmEx_64",                {"hipblasRotmEx_64",                "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasSrotm_v2",                 {"hipblasSrotm",                    "rocblas_srotm",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasSrotm_v2_64",              {"hipblasSrotm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},
  {"cublasDrotm_v2",                 {"hipblasDrotm",                    "rocblas_drotm",                            CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDrotm_v2_64",              {"hipblasDrotm_64",                 "",                                         CONV_LIB_FUNC, API_BLAS, 5, UNSUPPORTED}},

  // ROTMG
  {"cublasRotmgEx",                  {"hipblasRotmgEx",                  "",                                         CONV_LIB_FUNC, API_BLAS, 8, UNSUPPORTED}},
  {"cublasSrotmg_v2",                {"hipblasSrotmg",                   "rocblas_srotmg",                           CONV_LIB_FUNC, API_BLAS, 5}},
  {"cublasDrotmg_v2",                {"hipblasDrotmg",                   "rocblas_drotmg",                           CONV_LIB_FUNC, API_BLAS, 5}},
};

const std::map<llvm::StringRef, cudaAPIversions> CUDA_BLAS_FUNCTION_VER_MAP {
  {"cublasGetMathMode",                          {CUDA_90,  CUDA_0, CUDA_0}},
  {"cublasSetMathMode",                          {CUDA_90,  CUDA_0, CUDA_0}},
  {"cublasMigrateComputeType",                   {CUDA_110, CUDA_0, CUDA_0}},
  {"cublasLogCallback",                          {CUDA_92,  CUDA_0, CUDA_0}},
  {"cublasLoggerConfigure",                      {CUDA_92,  CUDA_0, CUDA_0}},
  {"cublasSetLoggerCallback",                    {CUDA_92,  CUDA_0, CUDA_0}},
  {"cublasGetLoggerCallback",                    {CUDA_92,  CUDA_0, CUDA_0}},
  {"cublasGetCudartVersion",                     {CUDA_101, CUDA_0, CUDA_0}},
  {"cublasNrm2Ex",                               {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasHgemm",                                {CUDA_75,  CUDA_0, CUDA_0}},
  {"cublasHgemmBatched",                         {CUDA_90,  CUDA_0, CUDA_0}},
  {"cublasSgemmStridedBatched",                  {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasDgemmStridedBatched",                  {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasCgemm3mBatched",                       {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasCgemmStridedBatched",                  {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasCgemm3mStridedBatched",                {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasZgemmStridedBatched",                  {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasHgemmStridedBatched",                  {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasCgemm3m",                              {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasCgemm3mEx",                            {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasZgemm3m",                              {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasSgemmEx",                              {CUDA_75,  CUDA_0, CUDA_0}},
  {"cublasGemmEx",                               {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasGemmBatchedEx",                        {CUDA_91,  CUDA_0, CUDA_0}},
  {"cublasGemmStridedBatchedEx",                 {CUDA_91,  CUDA_0, CUDA_0}},
  {"cublasCgemmEx",                              {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasUint8gemmBias",                        {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasCsyrkEx",                              {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasCsyrk3mEx",                            {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasCherkEx",                              {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasCherk3mEx",                            {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasDotEx",                                {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasDotcEx",                               {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasScalEx",                               {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasAxpyEx",                               {CUDA_80,  CUDA_0, CUDA_0}},
  {"cublasCopyEx",                               {CUDA_101, CUDA_0, CUDA_0}},
  {"cublasSwapEx",                               {CUDA_101, CUDA_0, CUDA_0}},
  {"cublasIamaxEx",                              {CUDA_101, CUDA_0, CUDA_0}},
  {"cublasIaminEx",                              {CUDA_101, CUDA_0, CUDA_0}},
  {"cublasAsumEx",                               {CUDA_101, CUDA_0, CUDA_0}},
  {"cublasRotEx",                                {CUDA_101, CUDA_0, CUDA_0}},
  {"cublasRotgEx",                               {CUDA_101, CUDA_0, CUDA_0}},
  {"cublasRotmEx",                               {CUDA_101, CUDA_0, CUDA_0}},
  {"cublasRotmgEx",                              {CUDA_101, CUDA_0, CUDA_0}},
  {"cublasGetSmCountTarget",                     {CUDA_113, CUDA_0, CUDA_0}},
  {"cublasSetSmCountTarget",                     {CUDA_113, CUDA_0, CUDA_0}},
  {"cublasGetStatusName",                        {CUDA_114, CUDA_0, CUDA_0}},
  {"cublasGetStatusString",                      {CUDA_114, CUDA_0, CUDA_0}},
  {"cublasSetVector_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasGetVector_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSetMatrix_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasGetMatrix_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSetVectorAsync_64",                    {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasGetVectorAsync_64",                    {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSetMatrixAsync_64",                    {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasGetMatrixAsync_64",                    {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasNrm2Ex_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSnrm2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSnrm2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDnrm2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDnrm2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasScnrm2_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasScnrm2_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDznrm2_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDznrm2_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDotEx_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDotcEx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSdot_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSdot_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDdot_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDdot_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCdotu_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCdotu_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCdotc_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCdotc_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZdotu_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZdotu_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZdotc_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZdotc_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasScalEx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSscal_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSscal_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDscal_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDscal_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCscal_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCscal_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZscal_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZscal_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsscal_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsscal_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZdscal_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZdscal_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasAxpyEx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSaxpy_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSaxpy_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDaxpy_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDaxpy_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCaxpy_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCaxpy_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZaxpy_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZaxpy_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCopyEx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasScopy_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasScopy_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDcopy_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDcopy_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCcopy_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCcopy_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZcopy_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZcopy_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSswap_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSswap_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDswap_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDswap_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCswap_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCswap_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZswap_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZswap_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSwapEx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIsamax_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIsamax_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIdamax_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIdamax_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIcamax_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIcamax_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIzamax_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIzamax_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIamaxEx_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIsamin_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIsamin_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIdamin_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIdamin_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIcamin_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIcamin_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIzamin_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIzamin_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasIaminEx_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasAsumEx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSasum_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSasum_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDasum_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDasum_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasScasum_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasScasum_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDzasum_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDzasum_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSrot_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSrot_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDrot_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDrot_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCrot_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCrot_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsrot_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsrot_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZrot_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZrot_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZdrot_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZdrot_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasRotEx_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSrotm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSrotm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDrotm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDrotm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasRotmEx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgemv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgemv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgemv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgemv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgemv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgemv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStrmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStrmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtrmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtrmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtrmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtrmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtrmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtrmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStpmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStpmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtpmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtpmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtpmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtpmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtpmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtpmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStrsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStrsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtrsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtrsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtrsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtrsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtrsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtrsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStpsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStpsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtpsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtpsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtpsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtpsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtpsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtpsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStbsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStbsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtbsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtbsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtbsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtbsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtbsv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtbsv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsymv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsymv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsymv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsymv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsymv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsymv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsymv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsymv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChemv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChemv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhemv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhemv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhbmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhbmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSspmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSspmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDspmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDspmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChpmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChpmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhpmv_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhpmv_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSger_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSger_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDger_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDger_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgeru_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgeru_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgerc_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgerc_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgeru_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgeru_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgerc_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgerc_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsyr_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsyr_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsyr_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsyr_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyr_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyr_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsyr_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsyr_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCher_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCher_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZher_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZher_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSspr_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSspr_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDspr_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDspr_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChpr_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChpr_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhpr_64",                              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhpr_v2_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsyr2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsyr2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsyr2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsyr2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyr2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyr2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsyr2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsyr2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCher2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCher2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZher2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZher2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSspr2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSspr2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDspr2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDspr2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChpr2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChpr2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhpr2_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhpr2_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgemvBatched",                         {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasSgemvBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgemvBatched",                         {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasDgemvBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemvBatched",                         {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasCgemvBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgemvBatched",                         {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasZgemvBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasHSHgemvBatched",                       {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasHSHgemvBatched_64",                    {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasHSSgemvBatched",                       {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasHSSgemvBatched_64",                    {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasTSTgemvBatched",                       {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasTSTgemvBatched_64",                    {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasTSSgemvBatched",                       {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasTSSgemvBatched_64",                    {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgemvStridedBatched",                  {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasSgemvStridedBatched_64",               {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgemvStridedBatched",                  {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasDgemvStridedBatched_64",               {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemvStridedBatched",                  {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasCgemvStridedBatched_64",               {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgemvStridedBatched",                  {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasZgemvStridedBatched_64",               {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasHSHgemvStridedBatched",                {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasHSHgemvStridedBatched_64",             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasHSSgemvStridedBatched",                {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasHSSgemvStridedBatched_64",             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasTSTgemvStridedBatched",                {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasTSTgemvStridedBatched_64",             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasTSSgemvStridedBatched",                {CUDA_116, CUDA_0, CUDA_0}},
  {"cublasTSSgemvStridedBatched_64",             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgemm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgemm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgemm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgemm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemm3m_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemm3mEx_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgemm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgemm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgemm3m_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasHgemm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgemmEx_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasGemmEx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemmEx_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsyrk_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsyrk_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsyrk_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsyrk_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyrk_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyrk_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsyrk_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsyrk_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyrkEx_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyrk3mEx_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCherk_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCherk_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZherk_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZherk_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCherkEx_64",                           {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCherk3mEx_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsyr2k_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsyr2k_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsyr2k_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsyr2k_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyr2k_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyr2k_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsyr2k_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsyr2k_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCher2k_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCher2k_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZher2k_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZher2k_v2_64",                         {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsyrkx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsyrkx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsyrkx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsyrkx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCherkx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZherkx_64",                            {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsymm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSsymm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsymm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDsymm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsymm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCsymm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsymm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZsymm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChemm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasChemm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhemm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZhemm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStrsm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStrsm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtrsm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtrsm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtrsm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtrsm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtrsm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtrsm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStrmm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStrmm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtrmm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtrmm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtrmm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtrmm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtrmm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtrmm_v2_64",                          {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasHgemmBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgemmBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgemmBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemmBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemm3mBatched_64",                    {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgemmBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasHgemmStridedBatched_64",               {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgemmStridedBatched_64",               {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgemmStridedBatched_64",               {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemmStridedBatched_64",               {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgemm3mStridedBatched_64",             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgemmStridedBatched_64",               {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasGemmBatchedEx_64",                     {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasGemmStridedBatchedEx_64",              {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSgeam_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDgeam_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCgeam_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZgeam_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasStrsmBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDtrsmBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCtrsmBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZtrsmBatched_64",                      {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasSdgmm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasDdgmm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasCdgmm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
  {"cublasZdgmm_64",                             {CUDA_120, CUDA_0, CUDA_0}},
};

const std::map<llvm::StringRef, hipAPIversions> HIP_BLAS_FUNCTION_VER_MAP {
  {"hipblasGetAtomicsMode",                      {HIP_3100, HIP_0,    HIP_0   }},
  {"hipblasSetAtomicsMode",                      {HIP_3100, HIP_0,    HIP_0   }},
  {"hipblasCreate",                              {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDestroy",                             {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasSetStream",                           {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasGetStream",                           {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasSetPointerMode",                      {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasGetPointerMode",                      {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasSetVector",                           {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasGetVector",                           {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasSetVectorAsync",                      {HIP_3070, HIP_0,    HIP_0   }},
  {"hipblasGetVectorAsync",                      {HIP_3070, HIP_0,    HIP_0   }},
  {"hipblasSetMatrix",                           {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasGetMatrix",                           {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasSetMatrixAsync",                      {HIP_3070, HIP_0,    HIP_0   }},
  {"hipblasGetMatrixAsync",                      {HIP_3070, HIP_0,    HIP_0   }},
  {"hipblasSnrm2",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDnrm2",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasScnrm2",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasDznrm2",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSdot",                                {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasDdot",                                {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasCdotu",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasCdotc",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZdotu",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZdotc",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSscal",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDscal",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasCscal",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasCsscal",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZscal",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasZdscal",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSaxpy",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDaxpy",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasCaxpy",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZaxpy",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasScopy",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDcopy",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasCcopy",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZcopy",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSswap",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasDswap",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasCswap",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZswap",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasIsamax",                              {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasIdamax",                              {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasIcamax",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasIzamax",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasIsamin",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasIdamin",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasIcamin",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasIzamin",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSasum",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDasum",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasScasum",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasDzasum",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSrot",                                {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasDrot",                                {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasCrot",                                {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasCsrot",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZrot",                                {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZdrot",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSrotg",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasDrotg",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasCrotg",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZrotg",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSrotm",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasDrotm",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSrotmg",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasDrotmg",                              {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSgemv",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDgemv",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasCgemv",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZgemv",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSgbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDgbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCgbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZgbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasStrmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDtrmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCtrmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZtrmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasStbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDtbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCtbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZtbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasStpmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDtpmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCtpmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZtpmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasStrsv",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasDtrsv",                               {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasCtrsv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZtrsv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasStpsv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDtpsv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCtpsv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZtpsv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasStbsv",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasDtbsv",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasCtbsv",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasZtbsv",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasSsymv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDsymv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCsymv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZsymv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasChemv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZhemv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSsbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDsbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasChbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZhbmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSspmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDspmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasChpmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZhpmv",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSger",                                {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDger",                                {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasCgeru",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCgerc",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZgeru",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZgerc",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSsyr",                                {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasDsyr",                                {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasCsyr",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZsyr",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCher",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZher",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSspr",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDspr",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasChpr",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZhpr",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSsyr2",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDsyr2",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCsyr2",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZsyr2",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCher2",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZher2",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSspr2",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDspr2",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasChpr2",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZhpr2",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSgemm",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDgemm",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasCgemm",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasZgemm",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasHgemm",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasSgemmBatched",                        {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDgemmBatched",                        {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasHgemmBatched",                        {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSgemmStridedBatched",                 {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDgemmStridedBatched",                 {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasCgemmBatched",                        {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZgemmBatched",                        {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasCgemmStridedBatched",                 {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasZgemmStridedBatched",                 {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasHgemmStridedBatched",                 {HIP_3000, HIP_0,    HIP_0   }},
  {"hipblasSsyrk",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDsyrk",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCsyrk",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZsyrk",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCherk",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZherk",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSsyr2k",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDsyr2k",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCsyr2k",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZsyr2k",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSsyrkx",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDsyrkx",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCsyrkx",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZsyrkx",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCher2k",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZher2k",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCherkx",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZherkx",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSsymm",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasDsymm",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasCsymm",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasZsymm",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasChemm",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasZhemm",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasStrsm",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDtrsm",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasCtrsm",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZtrsm",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasStrmm",                               {HIP_3020, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasDtrmm",                               {HIP_3020, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCtrmm",                               {HIP_3050, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZtrmm",                               {HIP_3050, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasSgeam",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasDgeam",                               {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasCgeam",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasZgeam",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasSgetrfBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDgetrfBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCgetrfBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZgetrfBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSgetriBatched",                       {HIP_3070, HIP_0,    HIP_0   }},
  {"hipblasDgetriBatched",                       {HIP_3070, HIP_0,    HIP_0   }},
  {"hipblasCgetriBatched",                       {HIP_3070, HIP_0,    HIP_0   }},
  {"hipblasZgetriBatched",                       {HIP_3070, HIP_0,    HIP_0   }},
  {"hipblasSgetrsBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDgetrsBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCgetrsBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZgetrsBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasStrsmBatched",                        {HIP_3020, HIP_0,    HIP_0   }},
  {"hipblasDtrsmBatched",                        {HIP_3020, HIP_0,    HIP_0   }},
  {"hipblasCtrsmBatched",                        {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZtrsmBatched",                        {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSgeqrfBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasDgeqrfBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasCgeqrfBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasZgeqrfBatched",                       {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSdgmm",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasDdgmm",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasCdgmm",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasZdgmm",                               {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasGemmEx",                              {HIP_1082, HIP_0,    HIP_0   }},
  {"hipblasGemmBatchedEx",                       {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasGemmStridedBatchedEx",                {HIP_3060, HIP_0,    HIP_0   }},
  {"hipblasDotEx",                               {HIP_4010, HIP_0,    HIP_0   }},
  {"hipblasDotcEx",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipblasAxpyEx",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipblasNrm2Ex",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipblasRotEx",                               {HIP_4010, HIP_0,    HIP_0   }},
  {"hipblasScalEx",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipblasIcamax_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasIzamax_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasIcamin_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasIzamin_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasScasum_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasDzasum_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCaxpy_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZaxpy_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCcopy_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZcopy_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCdotc_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCdotu_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZdotc_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZdotu_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasScnrm2_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasDznrm2_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCrot_v2",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCsrot_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZrot_v2",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZdrot_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCrotg_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZrotg_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCscal_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCsscal_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZscal_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZdscal_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCswap_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZswap_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgbmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgbmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgemv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgemv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgemvBatched_v2",                     {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgemvBatched_v2",                     {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgemvStridedBatched_v2",              {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgemvStridedBatched_v2",              {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgeru_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgerc_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgeru_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgerc_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasChbmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZhbmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasChemv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZhemv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCher_v2",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZher_v2",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCher2_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZher2_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasChpmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZhpmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasChpr_v2",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZhpr_v2",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasChpr2_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZhpr2_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCsymv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZsymv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCsyr_v2",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZsyr_v2",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCsyr2_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZsyr2_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCtbmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZtbmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCtbsv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZtbsv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCtpmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZtpmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCtpsv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZtpsv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCtrmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZtrmv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCtrsv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZtrsv_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgemm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgemm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgemmBatched_v2",                     {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgemmBatched_v2",                     {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgemmStridedBatched_v2",              {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgemmStridedBatched_v2",              {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCherk_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZherk_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCherkx_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZherkx_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCher2k_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZher2k_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCsymm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZsymm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCsyrk_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZsyrk_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCsyr2k_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZsyr2k_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCsyrkx_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZsyrkx_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgeam_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgeam_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasChemm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZhemm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCtrmm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZtrmm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCtrsm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZtrsm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCtrsmBatched_v2",                     {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZtrsmBatched_v2",                     {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCdgmm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZdgmm_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgetrfBatched_v2",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgetrfBatched_v2",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgetrsBatched_v2",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgetrsBatched_v2",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgetriBatched_v2",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgetriBatched_v2",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgelsBatched_v2",                     {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgelsBatched_v2",                     {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasCgeqrfBatched_v2",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasZgeqrfBatched_v2",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasGemmEx_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasGemmBatchedEx_v2",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasGemmStridedBatchedEx_v2",             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasAxpyEx_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasDotEx_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasDotcEx_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasNrm2Ex_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasRotEx_v2",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipblasScalEx_v2",                           {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_status_to_string",                   {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sscal",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dscal",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_cscal",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_zscal",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_csscal",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zdscal",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_scopy",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dcopy",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_ccopy",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_zcopy",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_sdot",                               {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_ddot",                               {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_hdot",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_cdotu",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_zdotu",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_cdotc",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zdotc",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sswap",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dswap",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_cswap",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_zswap",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_saxpy",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_daxpy",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_caxpy",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_zaxpy",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_sasum",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dasum",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_scasum",                             {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dzasum",                             {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_snrm2",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dnrm2",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_scnrm2",                             {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dznrm2",                             {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_isamax",                             {HIP_1064, HIP_0,    HIP_0   }},
  {"rocblas_idamax",                             {HIP_1064, HIP_0,    HIP_0   }},
  {"rocblas_icamax",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_izamax",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_isamin",                             {HIP_1064, HIP_0,    HIP_0   }},
  {"rocblas_idamin",                             {HIP_1064, HIP_0,    HIP_0   }},
  {"rocblas_icamin",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_izamin",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_srot",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_drot",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_crot",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_csrot",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zrot",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zdrot",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_srotg",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_drotg",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_crotg",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zrotg",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_srotm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_drotm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_srotmg",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_drotmg",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sgbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dgbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_cgbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zgbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sgemv",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dgemv",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_cgemv",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_zgemv",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_chbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zhbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_chemv",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_zhemv",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_cher",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zher",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_cher2",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zher2",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_chpmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zhpmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_chpr",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zhpr",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_chpr2",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zhpr2",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_strmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dtrmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ctrmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ztrmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_stpmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dtpmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ctpmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ztpmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_stbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dtbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ctbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ztbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_stbsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dtbsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ctbsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ztbsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_strsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dtrsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ctrsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ztrsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_stpsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dtpsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ctpsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ztpsv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ssymv",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dsymv",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_csymv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zsymv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sspmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dspmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ssbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dsbmv",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sger",                               {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dger",                               {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_cgeru",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zgeru",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_cgerc",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zgerc",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sspr",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dspr",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sspr2",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dspr2",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ssyr",                               {HIP_1071, HIP_0,    HIP_0   }},
  {"rocblas_dsyr",                               {HIP_1071, HIP_0,    HIP_0   }},
  {"rocblas_csyr",                               {HIP_1071, HIP_0,    HIP_0   }},
  {"rocblas_zsyr",                               {HIP_1071, HIP_0,    HIP_0   }},
  {"rocblas_ssyr2",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dsyr2",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_csyr2",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zsyr2",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_chemm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zhemm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_cherk",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zherk",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_cher2k",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zher2k",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_cherkx",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zherkx",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ssymm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dsymm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_csymm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zsymm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ssyrk",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dsyrk",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_csyrk",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zsyrk",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ssyr2k",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dsyr2k",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_csyr2k",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zsyr2k",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ssyrkx",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dsyrkx",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_csyrkx",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zsyrkx",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_strmm_outofplace",                   {HIP_5000, HIP_5060, HIP_6000}},
  {"rocblas_dtrmm_outofplace",                   {HIP_5000, HIP_5060, HIP_6000}},
  {"rocblas_ctrmm_outofplace",                   {HIP_5000, HIP_5060, HIP_6000}},
  {"rocblas_ztrmm_outofplace",                   {HIP_5000, HIP_5060, HIP_6000}},
  {"rocblas_strsm",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dtrsm",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_ctrsm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ztrsm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_strsm_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dtrsm_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ctrsm_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ztrsm_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sgemm",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dgemm",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_hgemm",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_cgemm",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_zgemm",                              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_sgemm_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_dgemm_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_hgemm_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_cgemm_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zgemm_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sgemm_strided_batched",              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_dgemm_strided_batched",              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_hgemm_strided_batched",              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_cgemm_strided_batched",              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_zgemm_strided_batched",              {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_sdgmm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_ddgmm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_cdgmm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zdgmm",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_sgeam",                              {HIP_1064, HIP_0,    HIP_0   }},
  {"rocblas_dgeam",                              {HIP_1064, HIP_0,    HIP_0   }},
  {"rocblas_cgeam",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zgeam",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_gemm_ex",                            {HIP_1082, HIP_0,    HIP_0   }},
  {"rocblas_gemm_batched_ex",                    {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_gemm_strided_batched_ex",            {HIP_1090, HIP_0,    HIP_0   }},
  {"rocblas_axpy_ex",                            {HIP_3090, HIP_0,    HIP_0   }},
  {"rocblas_dot_ex",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"rocblas_dotc_ex",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"rocblas_nrm2_ex",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"rocblas_rot_ex",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"rocblas_scal_ex",                            {HIP_4000, HIP_0,    HIP_0   }},
  {"rocblas_initialize",                         {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_create_handle",                      {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_destroy_handle",                     {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_set_stream",                         {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_get_stream",                         {HIP_1050, HIP_0,    HIP_0   }},
  {"rocblas_set_pointer_mode",                   {HIP_1060, HIP_0,    HIP_0   }},
  {"rocblas_get_pointer_mode",                   {HIP_1060, HIP_0,    HIP_0   }},
  {"rocblas_set_atomics_mode",                   {HIP_3080, HIP_0,    HIP_0   }},
  {"rocblas_get_atomics_mode",                   {HIP_3080, HIP_0,    HIP_0   }},
  {"rocblas_set_vector",                         {HIP_1060, HIP_0,    HIP_0   }},
  {"rocblas_get_vector",                         {HIP_1060, HIP_0,    HIP_0   }},
  {"rocblas_set_matrix",                         {HIP_1060, HIP_0,    HIP_0   }},
  {"rocblas_get_matrix",                         {HIP_1060, HIP_0,    HIP_0   }},
  {"rocblas_set_vector_async",                   {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_get_vector_async",                   {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_set_matrix_async",                   {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_get_matrix_async",                   {HIP_3050, HIP_0,    HIP_0   }},
  {"hipblasSgelsBatched",                        {HIP_5040, HIP_0,    HIP_0   }},
  {"hipblasDgelsBatched",                        {HIP_5040, HIP_0,    HIP_0   }},
  {"hipblasCgelsBatched",                        {HIP_5040, HIP_0,    HIP_0   }},
  {"hipblasZgelsBatched",                        {HIP_5040, HIP_0,    HIP_0   }},
  {"rocblas_get_math_mode",                      {HIP_5070, HIP_0,    HIP_0   }},
  {"rocblas_set_math_mode",                      {HIP_5070, HIP_0,    HIP_0   }},
  {"rocblas_cgemv_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zgemv_batched",                      {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_cgemv_strided_batched",              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_zgemv_strided_batched",              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocblas_strmm",                              {HIP_3050, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_dtrmm",                              {HIP_3050, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_ctrmm",                              {HIP_3050, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_ztrmm",                              {HIP_3050, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_hshgemv_batched",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_hssgemv_batched",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_tstgemv_batched",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_tssgemv_batched",                    {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_hshgemv_strided_batched",            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_hssgemv_strided_batched",            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_tstgemv_strided_batched",            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocblas_tssgemv_strided_batched",            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
};

const std::map<llvm::StringRef, hipAPIChangedVersions> HIP_BLAS_FUNCTION_CHANGED_VER_MAP {
  {"hipblasStrmm",                               {HIP_6000}},
  {"hipblasDtrmm",                               {HIP_6000}},
  {"hipblasCtrmm",                               {HIP_6000}},
  {"hipblasZtrmm",                               {HIP_6000}},
  {"rocblas_strmm",                              {HIP_6000}},
  {"rocblas_dtrmm",                              {HIP_6000}},
  {"rocblas_ctrmm",                              {HIP_6000}},
  {"rocblas_ztrmm",                              {HIP_6000}},
};

const std::map<unsigned int, llvm::StringRef> CUDA_BLAS_API_SECTION_MAP {
  {2, "CUBLAS Data types"},
  {3, "CUDA Library Data types"},
  {4, "CUBLAS Helper Function Reference"},
  {5, "CUBLAS Level-1 Function Reference"},
  {6, "CUBLAS Level-2 Function Reference"},
  {7, "CUBLAS Level-3 Function Reference"},
  {8, "BLAS-like Extension"},
};
