// generated by ../../../../tools/tube_transfer.py
// tube: 6C16
// plate current function: triode
// mu: 42.2
// kx: 2.21
// kg1: 393
// kg2: 0
// kp: 629
// kvb: 446
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_6C16[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	214.80658167695216,214.65058771171968,214.49444138769778,214.3381434491597,214.18169463470204,
	214.0250956772971,213.8683473043441,213.71145023772115,213.55440519383515,213.39721288367275,
	213.23987401284936,213.08238928165892,212.92475938512217,212.76698501303522,212.60906685001723,
	212.45100557555747,212.29280186406257,212.13445638490236,211.97596980245618,211.81734277615806,
	211.65857596054195,211.49967000528585,211.34062555525637,211.1814432505519,211.02212372654637,
	210.86266761393134,210.70307553875904,210.5433481224838,210.3834859820038,210.22348972970215,
	210.0633599734875,209.9030973168342,209.74270235882247,209.58217569417766,209.42151791330943,
	209.26072960235007,209.09981134319364,208.93876371353275,208.7775872868971,208.61628263269012,
	208.45485031622573,208.29329089876506,208.13160493755217,207.96979298585003,207.80785559297559,
	207.64579330433497,207.48360666145797,207.32129620203244,207.15886245993815,206.99630596528036,
	206.8336272444231,206.67082682002237,206.50790521105822,206.34486293286753,206.18170049717574,
	206.01841841212834,205.85501718232248,205.69149730883802,205.52785928926778,205.36410361774833,
	205.20023078499003,205.0362412783068,204.87213558164544,204.7079141756152,204.54357753751626,
	204.37912614136877,204.21456045794093,204.049880954777,203.88508809622542,203.72018234346612,
	203.5551641545375,203.39003398436384,203.22479228478198,203.0594395045672,202.89397608945998,
	202.72840248219197,202.5627191225111,202.3969264472075,202.23102489013831,202.06501488225305,
	201.89889685161762,201.73267122343955,201.56633842009154,201.3998988611356,201.2333529633469,
	201.06670114073728,200.89994380457816,200.73308136342388,200.56611422313463,200.39904278689872,
	200.23186745525504,200.0645886261153,199.897206694786,199.72972205398986,199.56213509388778,
	199.39444620209977,199.2266557637262,199.05876416136874,198.890771775151,198.72267898273887,
	198.55448615936112,198.3861936778295,198.21780190855807,198.04931121958376,197.88072197658528,
	197.71203454290267,197.54324927955673,197.3743665452673,197.20538669647274,197.03631008734834,
	196.86713706982462,196.69786799360563,196.52850320618708,196.35904305287437,196.18948787680023,
	196.01983801894227,195.8500938181404,195.6802556111141,195.51032373247972,195.34029851476689,
	195.1701802884359,194.99996938189375,194.82966612151122,194.65927083163842,194.48878383462176,
	194.31820545081922,194.14753599861652,193.97677579444306,193.80592515278695,193.63498438621096,
	193.4639538053672,193.29283371901292,193.12162443402488,192.95032625541478,192.7789394863432,
	192.60746442813502,192.43590138029327,192.2642506405137,192.09251250469904,191.92068726697264,
	191.7487752196929,191.5767766534666,191.40469185716293,191.23252111792692,191.0602647211926,
	190.88792295069672,190.71549608849162,190.54298441495854,190.37038820882012,190.1977077471538,
	190.02494330540415,189.85209515739533,189.679163575344,189.50614882987148,189.33305119001585,
	189.15987092324428,188.98660829546503,188.81326357103939,188.63983701279344,188.46632888202987,
	188.29273943853931,188.11906894061244,187.9453176450506,187.77148580717784,187.59757368085153,
	187.42358151847398,187.24950957100302,187.07535808796317,186.9011273174564,186.7268175061728,
	186.55242889940124,186.3779617410399,186.20341627360688,186.0287927382502,185.85409137475827,
	185.67931242157013,185.50445611578553,185.32952269317468,185.15451238818844,184.97942543396803,
	184.80426206235478,184.62902250389982,184.4537069878736,184.27831574227537,184.10284899384268,
	183.92730696806072,183.75168988917133,183.5759979801826,183.40023146287749,183.22439055782328,
	183.04847548438016,182.87248646071038,182.69642370378665,182.52028742940144,182.34407785217513,
	182.16779518556467,181.9914396418722,181.81501143225373,181.6385107667267,181.46193785417918,
	181.28529290237742,181.10857611797434,180.9317877065176,180.75492787245736,180.5779968191547,
	180.40099474888896,180.22392186286595,180.04677836122553,179.86956444304928,179.69228030636842,
	179.51492614817082,179.33750216440913,179.16000855000775,178.98244549887045,178.8048132038876,
	178.6271118569435,178.44934164892348,178.27150276972128,178.0935954082458,177.91561975242834,
	177.73757598922958,177.55946430464653,177.38128488371916,177.20303791053755,177.02472356824833,
	176.84634203906154,176.6678935042575,176.48937814419284,176.3107961383075,176.13214766513116,
	175.95343290228962,175.7746520265111,175.59580521363273,175.41689263860687,175.23791447550704,
	175.05887089753452,174.87976207702437,174.70058818545127,174.52134939343594,174.34204587075092,
	174.16267778632675,173.98324530825738,173.80374860380678,173.62418783941405,173.44456318069973,
	173.2648747924712,173.08512283872855,172.9053074826701,172.72542888669818,172.5454872124245,
	172.3654826206758,172.1854152714992,172.00528532416803,171.82509293718644,171.64483826829562,
	171.46452147447863,171.2841427119658,171.1037021362399,170.9231999020415,170.7426361633739,
	170.56201107350856,170.38132478498989,170.2005774496405,170.01976921856604,169.8389002421604,
	169.6579706701105,169.4769806514012,169.29593033432008,169.11481986646262,168.93364939473656,
	168.75241906536706,168.57112902390108,168.38977941521233,168.20837038350587,168.0269020723226,
	167.84537462454423,167.66378818239733,167.48214288745817,167.30043888065742,167.1186763022841,
	166.93685529199053,166.75497598879633,166.5730385310931,166.39104305664873,166.20898970261143,
	166.02687860551444,165.8447099012799,165.66248372522352,165.48020021205826,165.297859495899,
	165.11546171026626,164.93300698809068,164.75049546171684,164.56792726290743,164.38530252284752,
	164.20262137214792,164.01988394084998,163.83709035842895,163.65424075379806,163.4713352553126,
	163.2883739907737,163.1053570874319,162.92228467199158,162.73915687061415,162.5559738089223,
	162.37273561200328,162.18944240441334,162.00609431018054,161.8226914528092,161.6392339552831,
	161.45572194006945,161.2721555291221,161.08853484388558,160.90486000529842,160.72113113379652,
	160.53734834931723,160.35351177130224,160.16962151870146,159.98567770997641,159.8016804631035,
	159.61762989557758,159.4335261244154,159.24936926615885,159.06515943687836,158.88089675217634,
	158.6965813271904,158.51221327659658,158.32779271461277,158.14331975500198,157.9587945110755,
	157.77421709569597,157.58958762128114,157.40490619980625,157.22017294280798,157.03538796138704,
	156.85055136621156,156.66566326752016,156.480723775125,156.2957329984151,156.11069104635902,
	155.92559802750807,155.74045404999953,155.55525922155934,155.37001364950535,155.18471744075023,
	154.9993707018043,154.81397353877884,154.62852605738837,154.44302836295438,154.25748056040766,
	154.07188275429132,153.88623504876378,153.7005375476015,153.51479035420198,153.32899357158632,
	153.14314730240238,152.95725164892727,152.77130671307032,152.58531259637587,152.39926940002584,
	152.21317722484275,152.02703617129214,151.8408463394856,151.6546078291833,151.46832073979672,
	151.28198517039135,151.09560121968926,150.90916898607188,150.7226885675827,150.53616006192976,
	150.34958356648826,150.1629591783033,149.97628699409236,149.78956711024802,149.60279962284037,
	149.41598462761974,149.22912222001915,149.04221249515672,148.85525554783865,148.66825147256117,
	148.4812003635135,148.29410231458021,148.10695741934347,147.91976577108605,147.7325274627932,
	147.5452425871555,147.35791123657125,147.17053350314885,146.98310947870934,146.79563925478845,
	146.6081229226396,146.420560573236,146.23295229727285,146.04529818517005,145.85759832707456,
	145.66985281286247,145.48206173214177,145.2942251742544,145.10634322827875,144.918415983032,
	144.73044352707223,144.54242594870118,144.35436333596607,144.16625577666235,143.97810335833572,
	143.7899061682845,143.60166429356195,143.41337782097852,143.2250468371042,143.03667142827075,
	142.84825168057375,142.65978767987534,142.47127951180596,142.28272726176692,142.09413101493257,
	141.9054908562523,141.71680687045335,141.5280791420423,141.33930775530774,141.15049279432256,
	140.9616343429457,140.77273248482496,140.58378730339848,140.39479888189766,140.2057673033489,
	140.01669265057583,139.82757500620173,139.63841445265126,139.44921107215322,139.25996494674223,
	139.07067615826105,138.88134478836278,138.6919709185132,138.50255462999235,138.31309600389733,
	138.12359512114404,137.93405206246953,137.74446690843408,137.55483973942322,137.36517063564997,
	137.17545967715716,136.98570694381914,136.79591251534438,136.6060764712771,136.41619889099982,
	136.22627985373543,136.03631943854896,135.84631772435006,135.6562747898951,135.46619071378902,
	135.27606557448775,135.08589945030013,134.89569241939014,134.70544455977898,134.51515594934713,
	134.3248266658365,134.1344567868526,133.94404638986657,133.75359555221738,133.56310435111376,
	133.37257286363663,133.18200116674086,132.9913893372578,132.80073745189682,132.6100455872481,
	132.4193138197841,132.22854222586227,132.03773088172673,131.8468798635106,131.655989247238,
	131.46505910882647,131.27408952408868,131.08308056873477,130.89203231837467,130.7009448485198,
	130.50981823458568,130.31865255189362,130.12744787567328,129.9362042810646,129.7449218431198,
	129.55360063680592,129.3622407370067,129.17084221852485,128.97940515608406,128.78792962433138,
	128.5964156978393,128.404863451108,128.2132729585674,128.02164429457935,127.82997753344,
	127.63827274938184,127.4465300165761,127.2547494091346,127.06293100111239,126.87107486650967,
	126.67918107927414,126.48724971330331,126.29528084244656,126.1032745405075,125.9112308812463,
	125.71914993838186,125.527031785594,125.33487649652601,125.14268414478663,124.95045480395265,
	124.75818854757094,124.56588544916089,124.37354558221689,124.18116902021033,123.9887558365923,
	123.79630610479562,123.60381989823752,123.4112972903218,123.21873835444126,123.02614316398012,
	122.8335117923165,122.64084431282475,122.44814079887793,122.25540132385018,122.06262596111925,
	121.86981478406908,121.67696786609208,121.4840852805917,121.29116710098502,121.09821340070526,
	120.90522425320427,120.71219973195508,120.51913991045451,120.32604486222587,120.13291466082131,
	119.93974937982469,119.74654909285412,119.55331387356459,119.3600437956508,119.16673893284948,
	118.97339935894266,118.78002514775996,118.58661637318151,118.39317310914075,118.19969542962713,
	118.00618340868901,117.81263712043648,117.61905663904417,117.4254420387543,117.23179339387924,
	117.03811077880493,116.84439426799341,116.6506439359859,116.45685985740607,116.26304210696274,
	116.0691907594531,115.87530588976577,115.68138757288396,115.48743588388857,115.29345089796134,
	115.09943269038813,114.90538133656204,114.7112969119869,114.51717949228035,114.32302915317727,
	114.12884597053306,113.93463002032735,113.74038137866704,113.54610012179,113.35178632606858,
	113.15744006801314,112.96306142427566,112.76865047165336,112.5742072870924,112.3797319476916,
	112.18522453070618,111.99068511355163,111.79611377380756,111.60151058922159,111.40687563771328,
	111.21220899737821,111.01751074649201,110.82278096351438,110.6280197270935,110.43322711607004,
	110.23840320948142,110.04354808656632,109.84866182676906,109.65374450974389,109.45879621535973,
	109.26381702370455,109.06880701509026,108.87376627005733,108.6786948693795,108.48359289406882,
	108.2884604253805,108.09329754481803,107.89810433413815,107.70288087535616,107.50762725075104,
	107.31234354287112,107.11702983453915,106.92168620885806,106.72631274921659,106.53090953929497,
	106.3354766630707,106.14001420482457,105.94452224914669,105.7490008809426,105.55345018543959,
	105.35787024819288,105.16226115509242,104.96662299236925,104.77095584660239,104.57525980472552,
	104.37953495403414,104.1837813821928,103.98799917724213,103.79218842760639,103.59634922210098,
	103.40048164994037,103.20458580074576,103.00866176455312,102.81270963182168,102.61672949344201,
	102.4207214407448,102.22468556550955,102.02862195997342,101.83253071684067,101.6364119292917,
	101.44026569099277,101.24409209610575,101.04789123929812,100.85166321575323,100.65540812118074,
	100.45912605182737,100.26281710448781,100.06648137651607,99.87011896583685,99.67372997095741,
	99.47731449097967,99.28087262561247,99.08440447518436,98.88791014065659,98.69138972363629,
	98.49484332639038,98.2982710518594,98.1016730036719,97.90504928615937,97.70840000437117,
	97.51172526409016,97.31502517184872,97.11829983494502,96.9215493614599,96.72477386027421,
	96.52797344108649,96.33114821443125,96.1342982916977,95.93742378514911,95.7405248079425,
	95.54360147414913,95.34665389877543,95.14968219778456,94.95268648811847,94.75566688772106,
	94.55862351556121,94.36155649165737,94.1644659371021,93.96735197408798,93.77021472593384,
	93.573054317112,93.37587087327618,93.17866452129051,92.98143538925902,92.78418360655643,
	92.58690930385968,92.3896126131805,92.19229366789882,91.99495260279751,91.79758955409804,
	91.60020465949718,91.40279805820502,91.20536989098407,91.00792030018984,90.81044942981221,
	90.61295742551879,90.41544443469905,90.21791060651042,90.02035609192545,89.82278104378071,
	89.62518561682732,89.4275699677831,89.22993425538628,89.03227864045127,88.83460328592598,
	88.63690835695132,88.43919402092256,88.24146044755254,88.04370780893743,87.84593627962431,
	87.6481460366814,87.45033725977012,87.25251013122028,87.05466483610718,86.85680156233191,
	86.65892050070396,86.46102184502688,86.26310579218679,86.06517254224413,85.86722229852828,
	85.6692552677356,85.47127166003108,85.2732716891531,85.07525557252231,84.87722353135372,
	84.67917579077341,84.4811125799389,84.28303413216364,84.0849406850463,83.88683248060428,
	83.68870976541204,83.49057279074437,83.29242181272464,83.0942570924784,82.89607889629235,
	82.69788749577903,82.49968316804737,82.30146619587929,82.10323686791254,81.90499547883046,
	81.70674232955784,81.50847772746447,81.3102019865756,81.11191542779014,80.91361837910661,
	80.71531117585721,80.51699416095039,80.31866768512215,80.12033210719635,79.92198779435437,
	79.7236351224146,79.52527447612208,79.32690624944843,79.12853084590266,78.93014867885336,
	78.73176017186238,78.53336575903069,78.33496588535662,78.1365610071073,77.93815159220316,
	77.73973812061686,77.54132108478615,77.34290099004181,77.14447835505132,76.94605371227833,
	76.74762760845856,76.5492006050933,76.35077327896052,76.15234622264423,75.95392004508322,
	75.75549537213936,75.55707284718648,75.35865313172025,75.16023690599009,74.9618248696537,
	74.76341774245495,74.56501626492617,74.36662119911527,74.16823332933903,73.96985346296299,
	73.77148243120922,73.57312108999247,73.37477032078613,73.1764310315186,72.97810415750129,
	72.77979066238919,72.58149153917483,72.38320781121745,72.18494053330748,71.98669079276824,
	71.78845971059566,71.5902484426371,71.39205818081105,71.19389015436798,70.99574563119448,
	70.7976259191615,70.59953236751794,70.40146636833128,70.20342935797585,70.00542281867105,
	69.80744828006989,69.60950732089997,69.41160157065751,69.21373271135766,69.01590247933655,
	68.81811266711864,68.62036512533578,68.42266176471014,68.22500455809778,68.0273955425956,
	67.829836821712,67.63233056760345,67.43487902337756,67.23748450546402,67.0401494060547,
	66.84287619561347,66.64566742545742,66.4485257304098,66.25145383152585,66.05445453889195,
	65.85753075449905,65.66068547519036,65.46392179568424,65.26724291167176,65.07065212298964,
	64.87415283686772,64.67774857125116,64.48144295819606,64.28523974733866,64.08914280943554,
	63.89315613997479,63.69728386285563,63.501530234134464,63.30589964583533,63.11039662982131,
	62.91502586172423,62.719792164928606,62.52470051460588,62.32975604179401,62.13496403751761,
	61.940329956942534,61.74585942355865,61.551558233384014,61.35743235918227,61.16348795468556,
	60.96973135881349,60.77616909987818,60.58280789976518,60.38965467807849,60.19671655623753,
	60.004000861512665,59.81151513098551,59.61926711541879,59.427264783019965,59.23551632308139,
	59.04403014947972,58.85281490401509,58.66187945957089,58.47123292307282,58.280884638225764,
	58.0908441880061,57.901121396885266,57.71172633276113,57.522669308570805,57.33396088356012,
	57.145611864182555,56.957633304600364,56.77003650676061,56.58283302001781,56.39603464027476,
	56.20965340861375,56.0237016093886,55.83819176775092,55.65313664658129,55.46854924279927,
	55.28444278302529,55.100830718569085,54.91772671972087,54.73514466932232,54.553098655596536,
	54.371602964218454,54.19067206960888,54.01032062543845,53.83056345433025,53.65141553675327,
	53.472891999102224,53.29500810096269,53.1177792215647,52.94122084543211,52.76534854723917,
	52.59017797589058,52.41572483784589,52.24200487971395,52.06903387014834,51.89682758107941,
	51.72540176832398,51.554772151618224,51.38495439412515,51.21596408147195,51.0478167003777,
	50.88052761693637,50.71411205462396,50.54858507210265,50.383961540898284,50.220256123030204,
	50.05748324867574,49.89565709395262,49.73479155890512,49.57490024577974,49.41599643767717,
	49.258093077666345,49.101202748445985,48.945337652636475,48.79050959378396,48.6367299581541,
	48.484009697390455,48.33235931210788,48.18178883648677,48.032307823928534,47.88392533382743,
	47.73664991950762,47.590489617367545,47.44545193726779,47.30154385419103,47.15877180119577,
	47.01714166367876,46.8766587749531,46.73732791314286,46.599153299387496,46.4621385973421,
	46.326286913954554,46.19160080149256,46.05808226078877,45.925732745666515,45.794553168503384,
	45.664543906885385,45.53570481130045,45.4080352138161,45.281533937683385,45.1561993078063,
	45.032029162014084,44.90902086307185,44.7871713113647,44.6664769581888,44.546933819584034,
	44.42853749064222,44.31128316022585,44.195165626033926,44.080179309952165,43.966318273627174,
	43.853576234206,43.74194658018469,43.63142238731236,43.52199643449945,43.41366121968173,
	43.30640897559522,43.200231685419084,43.09512109824726,42.99106874435288,42.88806595021167,
	42.78610385325462,42.68517341632249,42.58526544179752,42.486370585391626,42.38847936957162,
	42.291582196605695,42.195669361217604,42.10073106283734,42.00675741743949,41.91373846896234,
	41.82166420030337,41.73052454388779,41.640309391809595,41.551008605545185,41.462612025241626,
	41.37510947858306,41.28849078923963,41.2027457849045,41.11786430492578,41.033836207540595,
	40.950651376719854,40.868299728632145,40.78677121773682,40.70605584251568,40.6261436508539,
	40.54702474508069,40.46868928668085,40.39112750068779,40.31432967976979,40.23828618802047,
	40.16298746446446,40.08842402629024,40.01458647182058,39.94146548323187,39.8690518290336,
	39.79733636631813,39.72631004279173,39.65596389859712,39.58628906793736,39.51727678051138,
	39.448918362770314,39.38120523900408,39.31412893226739,39.24768106515361,39.181853360425244,
	39.11663764150889,39.05202583286274,38.98800996022412,38.924582150744214,38.86173463301723,
	38.79945973701032,38.73774989390103,38.67659763582815,38.61599559556192,38.55593650609919,
	38.49641320018885,38.437418609792644,38.37894576548616,38.3209877958045,38.26353792653733,
	38.20658947997704,38.15013587411075,38.094170621842636,38.03868733003775,37.98367969868128,
	37.929141519932394,37.87506667716798,37.82144914400304,37.768282983290554,37.71556234610316,
	37.66328147069912,37.61143468147465,37.560016387904824,37.50902108347485,37.458443344603594,
	37.40827782956105,37.35851927738133,37.30916250677266,37.260202415025766,37.21163397692194,
	37.16345224364192,37.115652341676864,37.06822947174219,37.0211789076955,36.974495995459286,
	36.9281761519493,36.88221486400936,36.836607687353215,36.79135024551414,36.74643822880286,
	36.70186739327431,36.65763355970361,36.61373261257192,36.5701604990623,36.526913228066064,
	36.48398686920004,36.44137755183471,36.399081464133836,36.35709485210548,36.31541401866483,
	36.274035322708805,36.2329551782028,36.19217005327934,36.151676469349106,36.11147100022413,
	36.07155027125338,36.03191095847058,35.99254978775446,35.95346353400136,35.91464902031013,
	35.87610311717939,35.837822741717,35.799804856861805,35.76204647061746,35.724544635298486,
	35.687296446788054,35.650299043808054,35.61354960720063,35.57704535922169,35.540783562845846,
	35.50476152108297,35.46897657630607,35.433426109590464,35.39810754006403,35.36301832426854,
	35.32815595553171,35.293517963350254,35.259101912783194,35.22490540385589,35.190926070974335,
	35.1571615823495,35.12360963943188,35.09026797635583,35.05713435939363,35.02420658641926,
	34.99148248638153,34.95895991878649,34.92663677318916,34.89451096869412,34.86258045346511,
	34.830843204243166,34.799297225873666,34.76794055084149,34.736771238814725,34.70578737619644,
	34.6749870756845,34.64436847583931,34.613929740659295,34.583669059164045,34.55358464498484,
	34.52367473596272,34.493937593753635,34.46437150344076,34.4349747731538,34.405745733695106,
	34.37668273815791,34.347784161626166,34.31904840072721,34.290473873348304,34.26205901827863,
	34.233802294874025,34.20570218272782,34.17775718134737,34.14996580983669,34.12232660658456,
	34.09483812895832,34.06749895300317,34.0403076731468,34.01326290190929,33.986363269618344,
	33.95960742412937,33.93299403055084,33.906521770974216,33.880189344209064,33.85399546552252,
	33.82793886638368,33.80201829421228,33.77623251213205,33.750580298728224,33.72506044780961,
	33.69967176817451,33.67441308338111,33.64928323152171,33.624281065000915,33.59940545031791,
	33.57465526785234,33.55002941165405,33.52552678923648,33.50114632137366,33.47688694190075,
	33.452747597518105,33.42872724759856,33.404824863998314,33.38103943087093,33.35736994448453,
	33.33381541304225,33.31037485650574,33.28704730642163,33.26383180575111,33.240727408702334,
	33.21773318056572,33.19484819755206,33.17207154663336,33.149402325386475,33.126839641839304,
	33.10438261431958,33.082030371306395,33.05978205128395,33.03763680259806,33.01559378331481,
	32.99365216108182,32.971811112991645,32.95006982544755,32.928427494031546,32.90688332337455,
	32.885436527028766,32.86408632734213,32.84283195533487,32.82167265057815,32.80060766107459,
	32.77963624314081,32.75875766129201,32.737971188128256,32.71727610422275,32.69667169801189,
	32.67615726568709,32.65573211108845,32.635395545599984,32.615146888046745,32.59498546459346,
	32.574910608644814,32.554921660747446,32.5350179684934,32.51519888642516,32.4954637759422,
	32.47581200520905,32.456242949064794,32.436755988934024,32.417350512739134,32.39802591481415,
	32.378781595819724,32.35961696265966,32.34053142839859,32.32152441218106,32.302595339151786,
	32.283743640377224,32.26496875276828,32.24627011900434,32.22764718745838,32.209099412123244,
	32.19062625253907,32.17222717372189,32.153901646093246,32.13564914541089,32.11746915270058,
	32.09936115418894,32.081324641237266,32.06335911027639,32.04546406274248,32.027639005013945,
	32.00988344834906,31.992196908824795,31.974578907276324,31.957028969237623,31.939546624882848,
	31.9221314089686,31.904782860777125,31.887500524060247,31.87028394698424,31.853132682075397,
	31.836046286166514,31.81902432034411,31.80206634989642,31.785171944246745,31.76834067696608,
	31.751572125626286,31.7348658718175,31.718221501082745,31.701638602870307,31.68511677048682,
	31.66865560105099,31.65225469544804,31.63591365828475,31.619632097845187,31.60340962604706,
	31.587245858398667,31.57114041395645,31.55509291528326,31.539102988407077,31.523170262780337,
	31.507294371239936,31.4914749499677,31.475711638451394,31.460004079446378,31.444351918937713,
	31.42875480610282,31.413212393274655,31.397724335905433,31.382290292530783,31.366909924734475,
	31.351582897113598,31.33630887724417,31.321087535647308,31.30591854575584,31.290801583881297,
	31.275736329181488,31.260722463628323,31.245759671976376,31.23084764173148,31.215986063120152,
	31.20117462905909,31.18641303512529,31.171700979526527,31.157038163072126,31.142424289144284,
	31.127859063669664,31.11334219509137,31.098873394341393,31.084452374813285,31.07007885233529,
	31.055752545143797,31.04147317385718,31.027240461449885,31.013054133226976,30.99891391679894,
	30.98481954205686,30.970770741147863,30.956767248450923,30.942808800553017,30.928895136225456,
	30.915025996400715,30.90120112414938,30.887420264657532,30.873683165204277,30.85998957513974,
	30.846339245863167,30.832731930801454,30.81916738538783,30.80564536704086,30.79216563514376,
	30.77872795102394,30.76533207793269,30.751977781025353,30.738664827341534,30.725392985785724,
	30.712162027107997,30.69897172388511,30.685821850501718,30.67271218313192,30.659642499720952,
	30.64661257996714,30.633622205304114,30.620671158883134,30.607759225555778,30.594886191856723,
	30.582051845986808,30.569255977796264,30.556498378768154,30.543778842002045,30.53109716219785,
	30.51845313563988,30.505846560181066,30.493277235227406,30.480744961722568,30.468249542132682,
	30.455790780431393,30.443368482084917,30.430982454037476,30.418632504696774,30.406318443919673,
	30.3940400829981,30.381797234645013,30.369589712980662,30.357417333518878,30.34527991315364,
	30.333177270145722,30.32110922410954,30.309075596000117,30.29707620810028,30.285110884007835,
	30.273179448623132,30.26128172813657,30.249417550016332,30.23758674299628,30.225789137063924,
	30.214024563448636,30.202292854609848,30.190593844225514,30.178927367180684,30.16729325955615,
	30.155691358617272,30.144121502802886,30.132583531714435,30.12107728610509,30.109602607869093,
	30.098159340031195,30.086747326723042,30.075366413226888,30.064016445881972,30.052697272131713,
	30.04140874049896,30.030150700576055,30.018923003015168,30.007725499518546,29.996558042828998,
	29.985420486720468,29.97431268598868,29.963234496441864,29.952185774891703,29.94116637914424,
	29.930176167990947,29.919215001199913,29.908282739507072,29.897379244607578,29.886504379147258,
	29.875658006714154,29.864839991830124,29.854050199942595,29.843288497416413,29.832554751525667,
	29.821848830445724,29.811170603245305,29.800519939878644,29.789896711177718,29.779300788844587,
	29.768732045443805,29.758190354394895,29.747675589964953,29.73718762726124,29.726726342223976,
	29.7162916116191,29.705883313031137,29.6955013248562,29.685145526294992,29.674815797345897,
	29.664512018798185,29.654234072225222,29.643981839977823,29.633755205177568,29.62355405171036,
	29.61337826421987,29.603227728101153,29.593102329494265,29.58300195527807,29.572926493063953,
	29.562875831189665,29.552849858713266,29.542848465407147,29.53287154175192,29.522918978930683,
	29.512990668823075,29.503086503999512,29.49320637771548,29.483350183905866,29.47351781717933,
	29.46370917281276,29.453924146745784,29.444162635575346,29.43442453655025,29.42470974756593,
	29.415018167159072,29.40534969450244,29.395704229399726,29.386081672280326,29.376481924194408,
	29.36690488680777,29.357350462396923,29.347818553844153,29.33830906463271,29.328821898841824,
	29.31935696114211,29.30991415679071,29.300493391626684,29.291094572066296,29.281717605098482,
	29.27236239828028,29.263028859732284,29.253716898134286,29.24442642270192,29.235157343261598,
	29.225909570120567,29.216683014151467,29.207477586764384,29.198293199902622,29.1891297660386,
	29.179987198169606,29.170865409813814,29.161764315006206,29.152683828294546,29.14362386473538,
	29.134584339890214,29.125565169821446,29.11656627108864,29.107587560744662,29.098628956331858,
	29.08969037587835,29.080771737894274,29.071872961368122,29.06299396576309,29.054134671013465,
	29.045294997521022,29.03647486615149,29.027674198231068,29.018892915542885,29.010130940323574,
	29.001388195259885,28.99266460348523,28.983960088576413,28.975274574550216,28.966607985854218,
	28.95796024739204,28.94933128446666,28.94072102282488,28.932129388793623,28.923556308488028,
	28.915001709388697,28.906465518760246,28.89794766442719,28.88944807463901,28.880966678038728,
	28.87250340367486,28.864058180995386,28.85563093984483,28.847221610461357,28.838830123473894,
	28.830456409899263,28.82210040113941,28.81376202897856,28.805441225580473,28.79713792348567,
	28.788852055608764,28.780583555235673,28.772332356021025,28.764098391985463,28.755881597513042,
	28.7476819073486,28.73949925659518,28.73133358071152,28.7231848155094,28.715052897151267,
	28.70693776214764,28.69883934735467,28.690757589971728,28.68269242753889,28.6746437979346,
	28.666611639373286,28.658595890402935,28.6505964899028,28.642613377081048,28.634646491472473,
	28.626695772959433,28.618761161681945,28.61084259815994,28.602940023212174,28.595053377972768,
	28.58718260388906,28.579327642719466,28.571488436531215,28.563664927698355,28.555857058899534,
	28.54806477311595,28.54028801362926,28.532526724019526,28.52478084816314,28.51705033023083,
	28.509335114685673,28.501635146281,28.493950370058535,28.486280731346376,28.478626175757036,
	28.470986649185573,28.46336209780761,28.4557524680775,28.44815770672641,28.440577760760466,
	28.43301257745889,28.425462104372187,28.41792628932032,28.4104050803909,28.402898425937416,
	28.395406274577404,28.38792857519078,28.38046527691802,28.373016329158432,28.365581681568493,
	28.358161284060085,28.350755086798856,28.34336304020251,28.33598509493914,28.328621201925625,
	28.32127131232594,28.313935377549587,28.306613349249947,28.299305179322666,28.292010819904164,
	28.284730223369955,28.277463342333146,28.270210129642898,28.262970538382863,28.25574452186969,
	28.248532033651493,28.241333027506386,28.23414745744095,28.226975277688823,28.21981644270918,
	28.212670907185306,28.205538626023195,28.198419554350043,28.191313647512903,28.184220861077247,
	28.177141150825598,28.170074472756095,28.163020783081205,28.155980038226268,28.148952194828222,
	28.14193720973422,28.1349350400003,28.127945642890136,28.120968975873595,28.114004996625592,
	28.10705366302466,28.100114933151808,28.093188765289103,28.08627511791855,28.079373949720765,
	28.072485219573743,28.065608886551644,28.05874490992358,28.051893249152354,28.04505386389334,
	28.038226713993208,28.03141175948879,28.024608960605903,28.017818277758128,28.011039671545753,
	28.004273102754517,27.99751853235457,27.990775921499228,27.984045231523975,27.977326423945275,
	27.97061946045946,27.963924302941678,27.95724091344475,27.950569254198154,27.943909287606896,
	27.937260976250467,27.930624282881794,27.92399917042616,27.9173856019802,27.91078354079724,
	27.904192950339485,27.897613794198936,27.8910460361473,27.884489640122556,27.877944570227903,
	27.871410790730803,27.864888266062017,27.858376960814592,27.85187683974294,27.84538786776182,
	27.83891000994543,27.832443231526465,27.825987497895127,27.819542774598254,27.813109027338385,
	27.80668622197278,27.80027432451258,27.793873301121877,27.7874831181168,27.781103741964657,
	27.774735139283003,27.76837727683881,27.762030121547536,27.75569364047236,27.74936780082317,
	27.743052569955832,27.736747915371332,27.73045380471487,27.72417020577505,27.717897086483084,
	27.711634414911927,27.705382159275477,27.699140287927758,27.692908769362113,27.68668757221043,
	27.68047666524227,27.674276017364182,27.668085597618823,27.661905375184233,27.655735319373075,
	27.649575399631818,27.643425585539983,27.637285846809448,27.631156153283627,27.625036474936724,
	27.61892678187305,27.61282704432623,27.606737232658514,27.600657317360017,27.594587269048002,
	27.588527058466195,27.582476656484044,27.57643603409602,27.570405162420926,27.564384012701193,
	27.558372556302185,27.5523707647115,27.546378609538348,27.54039606251278,27.5344230954851,
	27.52845968042516,27.522505789421675,27.516561394681624,27.510626468529527,27.50470098340685,
	27.498784911871315,27.492878226596336,27.486980900370245,27.48109290609582,27.47521421678952,
	27.46934480558096,27.463484645712253,27.457633710537355,27.451791973521523,27.445959408240682,
	27.440135988380785,27.43432168773729,27.428516480214483,27.42272033982494,27.41693324068892,
	27.411155157033786,27.405386063193433,27.399625933607705,27.393874742821826,27.388132465485803,
	27.382399076353916,27.376674550284125,27.370958862237533,27.36525198727778,27.359553900570575,
	27.35386457738309,27.34818399308342,27.342512123140093,27.336848943121474,27.331194428695287,
	27.325548555628046,27.319911299784547,27.314282637127352,27.308662543716267,27.30305099570782,
	27.297447969354764,27.291853441005557,27.28626738710387,27.28068978418808,27.275120608890752,
	27.269559837938182,27.264007448149886,27.25846341643811,27.25292771980735,27.247400335353856,
	27.24188124026518,27.23637041181968,27.230867827386064,27.22537346442288,27.219887300478124,
	27.214409313188682,27.208939480279955,27.203477779565347,27.198024188945826,27.192578686409504,
	27.187141250031093,27.181711857971614,27.17629048847778,27.17087711988168,27.1654717306003,
	27.160074299135072,27.15468480407148,27.149303224078587,27.14392953790865,27.138563724396647,
	27.13320576245991,27.127855631097667,27.12251330939066,27.117178776500662,27.11185201167018,
	27.106532994221922,27.101221703558483,27.095918119161905,27.09062222059327,27.08533398749232,
	27.080053399577054,27.074780436643323,27.069515078564475,27.06425730529089,27.05900709684971,
	27.053764433344334,27.04852929495412,27.043301661933974,27.038081514613992,27.032868833399046,
	27.02766359876844,27.022465791275565,27.017275391547475,27.01209238028456,27.006916738260177,
	27.00174844632029,26.996587485383102,26.991433836438674,26.98628748054868,26.981148398845885,
	26.97601657253393,26.970891982886954,26.96577461124919,26.96066443903471,26.955561447727,
	26.950465618878688,26.945376934111156,26.940295375114253,26.935220923645904,26.93015356153182,
	26.925093270665162,26.920040033006206,26.914993830582045,26.909954645486184,26.904922459878314,
	26.89989725598398,26.894879016094166,26.889867722565114,26.884863357817917,26.879865904338235,
	26.874875344676,26.86989166144507,26.864914837322985,26.85994485505057,26.854981697431736,
	26.850025347333066,26.845075787683662,26.84013300147467,26.835196971759157,26.83026768165167,
	26.825345114328055,26.820429253025097,26.81552008104027,26.810617581731403,26.805721738516475,
	26.800832534873244,26.79594995433902,26.79107398051034,26.786204597042754,26.781341787634233,
	26.77648553608906,26.771635826222585,26.766792641923484,26.76195596713805,26.757125785869864,
	26.75230208217961,26.747484840184743,26.74267404405926,26.737869678033444,26.733071726393575,
	26.728280173481668,26.723495003695263,26.7187162014871,26.713943751364905,26.709177637891138,
	26.70441784568269,26.69966435941072,26.69491716380032,26.69017624363032,26.68544158373299,
	26.680713168993872,26.675990984351436,26.671275014796954,26.666565245374127,26.661861661178946,
	26.657164247359436,26.652472989115353,26.64778787169803,26.64310888041011,26.638436000605285,
	26.633769217688116,26.629108517113757,26.624453884387744,26.619805305065785,26.615162764753492,
	26.61052624910617,26.605895743828636,26.601271234674893,26.596652707448065,26.59204014800001,
	26.587433542231192,26.58283287609046,26.578238135574814,26.57364930672917,26.569066375646184,
	26.564489328466028,26.559918151376156,26.555352830611103,26.550793352452292,26.5462397032278,
	26.54169186931218,26.537149837126208,26.532613593136727,26.528083123856405,26.523558415843578,
	26.51903945570197,26.514526230080595,26.510018725673458,26.505516929219414,26.50102082750195,
	26.496530407349017,26.49204565563279,26.487566559269496,26.483093105219208,26.47862528048571,
	26.4741630721162,26.4697064672012,26.465255452874313,26.46081001631205,26.456370144733622,
	26.451935825400803,26.44750704561768,26.443083792730523,26.43866605412758,26.434253817238883,
	26.429847069536105,26.42544579853231,26.421049991781846,26.416659636880137,26.4122747214635,
	26.40789523320898,26.40352115983415,26.39915248909698,26.394789208795636,26.39043130676829,
	26.386078770892965,26.38173158908739,26.37738974930881,26.373053239553776,26.368722047858046,
	26.364396162296373,26.360075570982335,26.35576026206823,26.351450223744816,26.347145444241242,
	26.34284591182479,26.338551614800824,26.334262541512498,26.329978680340723,26.325700019703916,
	26.3214265480579,26.3171582538957,26.312895125747403,26.308637152180026,26.30438432179731,
	26.30013662323965,26.295894045183807,26.291656576342888,26.287424205466152,26.283196921338774,
	26.278974712781846,26.27475756865209,26.2705454778418,26.266338429278637,26.262136411925532,
	26.257939414780473,26.253747426876423,26.24956043728114,26.245378435097034,26.241201409461052,
	26.237029349544475,26.232862244552845,26.228700083725776,26.224542856336853,26.22039055169341,
	26.216243159136493,26.212100668040694,26.20796306781394,26.203830347897423,26.19970249776549,
	26.195579506925416,26.19146136491736,26.187348061314168,26.18323958572126,26.179135927776503,
	26.175037077150076,26.170943023544346,26.166853756693683,26.16276926636443,26.158689542354672,
	26.154614574494154,26.15054435264418,26.14647886669741,26.142418106577807,26.138362062240468,
	26.134310723671515,26.130264080887944,26.12622212393754,26.12218484289873,26.118152227880454,
	26.114124269022053,26.110100956493127,26.10608228049348,26.102068231252886,26.098058799031048,
	26.094053974117507,26.090053746831416,26.086058107521502,26.08206704656594,26.078080554372217,
	26.074098621377004,26.07012123804609,26.066148394874194,26.062180082384913,26.058216291130563,
	26.05425701169211,26.050302234679016,26.046351950729132,26.042406150508615,26.03846482471177,
	26.034527964060967,26.03059555930657,26.02666760122672,26.022744080627316,26.0188249883419,
	26.014910315231482,26.011000052184524,26.00709419011674,26.003192719971082,25.999295632717516,
	25.99540291935305,25.99151457090155,25.98763057841362,25.983750932966533,25.979875625664153,
	25.976004647636753,25.972137990040995,25.96827564405975,25.964417600902063,25.960563851803034,
	25.956714388023673,25.952869200850852,25.949028281597187,25.945191621600916,25.941359212225848,
	25.93753104486123,25.933707110921645,25.92988740184693,25.926071909102088,25.922260624177135,
	25.918453538587116,25.91465064387186,25.910851931596028,25.907057393348897,25.90326702074438,
	25.89948080542081
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	214.80658167695216,214.65058771171968,214.4944413876978,214.33814344915973,214.18169463470207,
	214.0250956772971,213.8683473043441,213.71145023772115,213.55440519383518,213.39721288367275,
	213.23987401284936,213.08238928165892,212.9247593851222,212.7669850130353,212.60906685001723,
	212.45100557555756,212.29280186406257,212.13445638490236,211.97596980245618,211.81734277615809,
	211.65857596054195,211.49967000528585,211.34062555525637,211.18144325055195,211.0221237265464,
	210.86266761393136,210.70307553875904,210.5433481224838,210.3834859820038,210.22348972970215,
	210.06335997348745,209.9030973168342,209.74270235882247,209.5821756941777,209.42151791330937,
	209.26072960235007,209.0998113431936,208.93876371353275,208.7775872868971,208.61628263269012,
	208.45485031622573,208.29329089876512,208.13160493755217,207.96979298585006,207.80785559297564,
	207.64579330433497,207.48360666145803,207.3212962020325,207.15886245993815,206.99630596528036,
	206.83362724442316,206.67082682002237,206.50790521105827,206.3448629328676,206.18170049717574,
	206.01841841212834,205.8550171823225,205.69149730883802,205.52785928926778,205.36410361774833,
	205.20023078499003,205.03624127830685,204.87213558164547,204.7079141756152,204.5435775375163,
	204.37912614136883,204.21456045794093,204.04988095477708,203.8850880962255,203.72018234346615,
	203.55516415453755,203.3900339843639,203.22479228478196,203.05943950456722,202.89397608946007,
	202.72840248219205,202.5627191225112,202.39692644720753,202.2310248901384,202.06501488225308,
	201.89889685161776,201.73267122343964,201.5663384200916,201.39989886113565,201.233352963347,
	201.0667011407373,200.89994380457821,200.733081363424,200.56611422313466,200.3990427868988,
	200.23186745525513,200.06458862611544,199.8972066947861,199.72972205398997,199.56213509388792,
	199.39444620209994,199.22665576372628,199.05876416136883,198.89077177515108,198.722678982739,
	198.55448615936132,198.38619367782962,198.21780190855824,198.0493112195839,197.88072197658542,
	197.71203454290293,197.54324927955685,197.37436654526746,197.20538669647297,197.03631008734862,
	196.86713706982485,196.6978679936058,196.52850320618722,196.35904305287463,196.18948787680048,
	196.01983801894252,195.85009381814066,195.68025561111438,195.51032373247997,195.34029851476726,
	195.1701802884362,194.9999693818941,194.8296661215116,194.65927083163885,194.48878383462213,
	194.31820545081956,194.14753599861692,193.9767757944435,193.8059251527874,193.6349843862114,
	193.46395380536765,193.2928337190134,193.12162443402545,192.9503262554153,192.77893948634372,
	192.60746442813556,192.43590138029384,192.26425064051438,192.09251250469964,191.92068726697335,
	191.74877521969358,191.57677665346736,191.4046918571637,191.23252111792772,191.06026472119342,
	190.88792295069754,190.7154960884925,190.54298441495945,190.3703882088211,190.19770774715482,
	190.02494330540517,189.8520951573964,189.67916357534517,189.5061488298727,189.33305119001702,
	189.1598709232455,188.98660829546634,188.8132635710408,188.6398370127949,188.46632888203132,
	188.29273943854088,188.11906894061403,187.94531764505228,187.77148580717957,187.59757368085332,
	187.42358151847588,187.24950957100498,187.07535808796518,186.90112731745847,186.72681750617502,
	186.55242889940354,186.3779617410423,186.20341627360938,186.02879273825275,185.85409137476094,
	185.67931242157292,185.5044561157884,185.32952269317767,185.1545123881916,184.97942543397133,
	184.80426206235816,184.62902250390337,184.45370698787727,184.27831574227918,184.10284899384666,
	183.9273069680648,183.75168988917565,183.57599798018705,183.4002314628822,183.22439055782814,
	183.04847548438522,182.87248646071558,182.69642370379208,182.52028742940712,182.34407785218096,
	182.16779518557072,181.9914396418786,181.81501143226035,181.63851076673362,181.46193785418632,
	181.28529290238487,181.1085761179821,180.93178770652563,180.75492787246577,180.5779968191634,
	180.40099474889803,180.2239218628753,180.04677836123528,179.8695644430595,179.69228030637896,
	179.51492614818187,179.3375021644206,179.16000855001965,178.98244549888284,178.80481320390044,
	178.62711185695687,178.44934164893746,178.27150276973575,178.09359540826085,177.915619752444,
	177.7375759892459,177.55946430466346,177.38128488373675,177.20303791055582,177.02472356826735,
	176.84634203908135,176.66789350427808,176.48937814421421,176.31079613832978,176.13214766515432,
	175.95343290231372,175.77465202653613,175.5958052136588,175.4168926386339,175.2379144755352,
	175.05887089756382,174.8797620770548,174.70058818548296,174.52134939346888,174.3420458707852,
	174.1626777863623,173.9832453082944,173.8037486038453,173.62418783945412,173.44456318074143,
	173.2648747925145,173.08512283877357,172.90530748271692,172.72542888674687,172.54548721247514,
	172.3654826207285,172.18541527155404,172.00528532422496,171.82509293724564,171.6448382683572,
	171.46452147454264,171.28414271203238,171.10370213630912,170.92319990211345,170.74263616344874,
	170.5620110735864,170.38132478507086,170.20057744972465,170.01976921865364,169.8389002422515,
	169.65797067020517,169.47698065149962,169.29593033442242,169.11481986656904,168.93364939484727,
	168.75241906548214,168.57112902402073,168.38977941533676,168.20837038363524,168.0269020724572,
	167.84537462468415,167.66378818254282,167.48214288760948,167.30043888081474,167.11867630244774,
	166.9368552921606,166.7549759889732,166.57303853127706,166.39104305683998,166.20898970281033,
	166.02687860572127,165.844709901495,165.6624837254472,165.48020021229084,165.29785949614077,
	165.11546171051768,164.93300698835213,164.75049546198866,164.5679272631902,164.38530252314146,
	164.2026213724536,164.01988394116785,163.8370903587594,163.6542407541417,163.47133525566997,
	163.28837399114522,163.10535708781833,162.92228467239335,162.73915687103195,162.5559738093567,
	162.37273561245507,162.18944240488304,162.00609431066894,161.82269145331705,161.6392339558112,
	161.45572194061856,161.27215552969307,161.08853484447928,160.9048600059157,160.72113113443842,
	160.53734834998468,160.35351177199627,160.16962151942317,159.98567771072683,159.8016804638838,
	159.6176298963889,159.43352612525905,159.2493692670361,159.06515943779053,158.88089675312483,
	158.69658132817662,158.51221327762207,158.3277927156791,158.14331975611074,157.95879451222837,
	157.77421709689477,157.58958762252763,157.40490620110236,157.22017294415568,157.0353879627884,
	156.85055136766863,156.66566326903526,156.48072377670042,156.2957330000532,156.11069104806228,
	155.92559802927914,155.74045405184106,155.55525922347417,155.37001365149638,155.1847174428205,
	154.99937070395697,154.8139735410171,154.6285260597158,154.4430283653744,154.25748056292394,
	154.07188275690774,153.8862350514843,153.7005375504303,153.5147903571433,153.32899357464467,
	153.1431473055824,152.95725165223382,152.77130671650843,152.58531259995075,152.39926940374298,
	152.21317722870774,152.0270361753109,151.84084634366425,151.65460783352825,151.46832074431444,
	151.2819851750888,151.09560122457353,150.90916899115052,150.72268857286335,150.53616006742044,
	150.34958357219733,150.16295918423944,149.97628700026462,149.78956711666584,149.6027996295135,
	149.41598463455827,149.2291222272336,149.04221250265815,148.85525555563837,148.66825148067116,
	148.48120037194607,148.29410232334808,148.10695742846013,147.91976578056523,147.7325274726493,
	147.5452425974036,147.35791124722695,147.17053351422828,146.9831094902293,146.79563926676659,
	146.6081229350941,146.42056058618573,146.23295231073752,146.04529819917013,145.8575983416313,
	145.66985282799803,145.4820617478792,145.29422519061754,145.10634324529258,144.91841600072223,
	144.73044354546587,144.54242596782612,144.35436335585143,144.16625579733835,143.97810337983375,
	143.78990619063723,143.60166431680335,143.41337784514394,143.22504686223039,143.03667145439576,
	142.84825170773743,142.65978770811887,142.4712795411723,142.28272729230065,142.09413104668008,
	141.9054908892619,141.71680690477513,141.52807917772842,141.33930779241243,141.15049283290213,
	140.96163438305885,140.77273252653245,140.5837873467639,140.39479892698674,140.20576735023016,
	140.01669269932046,139.82757505688377,139.63841450534778,139.4492111269442,139.25996500371087,
	139.07067621749388,138.88134484994984,138.69197098254787,138.502554696572,138.313096073123,
	138.1235951931209,137.93405213730688,137.74446698624556,137.55483982032698,137.36517071976886,
	137.17545976461892,136.9857070347566,136.79591260989548,136.60607656958555,136.41619899321486,
	136.2262799600122,136.0363195490488,135.84631783924078,135.65627490935108,135.46619083799166,
	135.27606570362556,135.08589958456918,134.89569255899423,134.70544470493004,134.51515610026547,
	134.3248268227512,134.13445695000183,133.94404655949796,133.75359572858838,133.5631045344921,
	133.37257305430066,133.18200136497995,132.99138954337275,132.80073766620052,132.6100458100656,
	132.41931405145374,132.22854246673555,132.03773113216914,131.84688012390222,131.65598951797398,
	131.46505939031758,131.27408981676203,131.0830808730345,130.89203263476242,130.70094517747566,
	130.5098185766087,130.3186529075028,130.12744824540812,129.93620466548597,129.74492224281096,
	129.55360105237327,129.36224116908065,129.17084266776078,128.9794056231635,128.78793010996287,
	128.5964162027595,128.40486397608282,128.21327350439307,128.0216448620838,127.82997812348405,
	127.63827336286042,127.44653065441965,127.25475007231057,127.06293169062658,126.87107558340772,
	126.67918182464338,126.48725048827403,126.29528164819406,126.1032753782537,125.9112317522616,
	125.71915084398702,125.52703272716234,125.33487747548519,125.14268516262113,124.95045586220577,
	124.75818964784725,124.56588659312867,124.37354677161058,124.18117025683327,123.98875712231933,
	123.79630744157603,123.60382128809798,123.41129873536933,123.21873985686653,123.02614472606079,
	122.83351341642059,122.64084600141419,122.44814255451237,122.25540314919091,122.06262785893311,
	121.86981675723271,121.67696991759625,121.48408741354595,121.29116931862217,121.09821570638643,
	120.905226650424,120.71220222434651,120.51914250179493,120.3260475564425,120.13291746199724,
	119.9397522922049,119.74655212085206,119.55331702176885,119.3600470688319,119.16674233596746,
	118.97340289715416,118.78002882642622,118.58662019787654,118.39317708565966,118.19969956399497,
	118.00618770716983,117.81264158954284,117.61906128554706,117.42544686969322,117.23179841657308,
	117.03811600086281,116.84439969732634,116.65064958081877,116.45686572628996,116.26304820878799,
	116.06919710346274,115.87531248556945,115.68139443047252,115.48744301364914,115.2934583106931,
	115.09944039731857,114.90538934936409,114.7113052427964,114.51718815371453,114.32303815835382,
	114.12885533309002,113.93463975444357,113.74039149908378,113.54611064383326,113.35179726567215,
	113.15745144174274,112.9630732493541,112.76866276598643,112.57422006929606,112.37974523712006,
	112.18523834748132,111.99069947859323,111.79612870886501,111.60152611690685,111.40689178153501,
	111.21222578177733,111.01752819687863,110.82279910630626,110.62803858975604,110.43324672715762,
	110.23842359868082,110.04356928474144,109.84868386600762,109.65376742340591,109.45882003812802,
	109.26384179163715,109.06883276567487,108.873793042268,108.67872270373562,108.48362183269624,
	108.2884905120753,108.09332882511266,107.8981368553703,107.7029146867402,107.50766240345256,
	107.31238009008409,107.11706783156635,106.92172571319472,106.7263538206372,106.53095223994356,
	106.33552105755493,106.1400603603131,105.9445702354708,105.7490507707017,105.5535020541108,
	105.35792417424517,105.16231722010501,104.96668128115502,104.77101644733581,104.57532280907596,
	104.37960045730432,104.18384948346265,103.98806997951844,103.79226203797845,103.59642575190222,
	103.40056121491656,103.20466852122966,103.00874776564636,102.81279904358347,102.61682245108561,
	102.42081808484164,102.22478604220137,102.02872642119311,101.83263932054129,101.63652483968514,
	101.44038307879755,101.24421413880465,101.04801812140609,100.85179512909582,100.65554526518359,
	100.4592686338171,100.26296534000492,100.0666354896401,99.8702791895245,99.67389654739392,
	99.47748767194416,99.28105267285788,99.08459166083207,98.88810474760697,98.69159204599536,
	98.49505366991325,98.29848973441142,98.10190035570797,97.90528565122202,97.70864573960863,
	97.51198074079478,97.31529077601658,97.11857596785774,96.9218364402895,96.72507231871175,
	96.52828372999555,96.33147080252738,96.13463366625453,95.93777245273245,95.74088729517345,
	95.5439783284972,95.3470456893831,95.15008951632437,94.95310994968402,94.75610713175284,
	94.55908120680951,94.36203232118267,94.16496062331544,93.96786626383185,93.77074939560609,
	93.57361017383391,93.37644875610673,93.17926530248825,92.9820599755941,92.78483294067401,
	92.58758436569728,92.39031442144096,92.19302328158163,91.9957111227902,91.7983781248303,
	91.60102447066019,91.4036503465384,91.20625594213323,91.00884145063623,90.81140706887989,
	90.61395299745946,90.4164794408595,90.21898660758488,90.02147471029663,89.8239439659528,
	89.62639459595455,89.42882682629761,89.2312408877291,89.03363701591067,88.836015451587,
	88.63837644076109,88.44072023487585,88.24304709100177,88.04535727203303,87.84765104688951,
	87.64992869072674,87.45219048515384,87.25443671845913,87.05666768584476,86.85888368966921,
	86.66108503969959,86.46327205337273,86.2654450560664,86.06760438138028,85.86975037142761,
	85.67188337713753,85.4740037585687,85.27611188523468,85.07820813644118,84.88029290163605,
	84.68236658077214,84.48442958468371,84.28648233547669,84.08852526693354,83.89055882493311,
	83.69258346788601,83.49459966718594,83.29660790767811,83.09860868814457,82.90060252180776,
	82.70258993685239,82.50457147696685,82.30654770190418,82.10851918806405,81.91048652909582,
	81.71245033652384,81.51441124039575,81.3163698899541,81.11832695433314,80.92028312328026,
	80.72223910790416,80.52419564145002,80.32615348010279,80.12811340381934,79.9300762171909,
	79.73204275033622,79.53401385982694,79.33599042964609,79.13797337218048,78.93996362924892,
	78.74196217316629,78.54397000784543,78.34598816993805,78.14801773001525,77.95005979378945,
	77.75211550337883,77.5541860386155,77.35627261839876,77.15837650209477,76.96049899098404,
	76.76264142975793,76.56480520806574,76.36699176211366,76.16920257631716,75.97143918500784,
	75.7737031741966,75.57599618339444,75.3783199074921,75.18067609870018,74.98306656855105,
	74.78549318996401,74.58795789937511,74.3904626989326,74.19300965876022,73.99560091928835,
	73.79823869365548,73.60092527018034,73.40366301490631,73.20645437421878,73.00930187753674,
	72.81220814007935,72.61517586570814,72.41820784984576,72.22130698247146,72.02447625119426,
	71.82771874440306,71.63103765449486,71.4344362811801,71.23791803486515,71.04148644011121,
	70.8451451391689,70.64889789558723,70.45274859789585,70.25670126335842,70.0607600417971,
	69.86492921947563,69.66921322306209,69.47361662363723,69.2781441407671,69.08280064662695,
	68.88759117017317,68.69252090135792,68.4975951953807,68.30281957697022,68.1081997446896,
	67.9137415752569,67.7194511278727,67.5253346485453,67.33139857440345,67.13764953798601,
	66.94409437149632,66.75074011100938,66.55759400061783,66.36466349650253,66.17195627091237,
	65.9794802160373,65.7872434477564,65.595254309244,65.40352137441364,65.21205345117993,
	65.02085958451714,64.82994905929228,64.63933140284949,64.44901638732206,64.25901403164644,
	64.06933460325334,63.87998861940911,63.69098684818027,63.50234030899354,63.314060272763236,
	63.12615826155751,62.93864604777449,62.75153565279996,62.56483934511694,62.37856963783958,
	62.19273928564268,62.00736128105961,61.822448850121674,61.638015447314174,61.454074749824045,
	61.27064065105721,61.08772725340438,60.90534886023703,60.723519967117106,60.54225525220699,
	60.36156956586909,60.18147791944747,60.00199547322816,59.82313752357764,59.64491948926326,
	59.46735689696437,59.29046536598632,59.114260592194874,58.93875833119287,58.76397438076668,
	58.589924562634096,58.416624703531085,58.24409061567973,58.07233807668442,57.90138280890892,
	57.7312404583913,57.56192657335847,57.39345658240644,57.225845772416754,57.059109266282654,
	56.893262000522974,56.72831870286312,56.56429386986651,56.40120174470055,56.23905629512297,
	56.077871191775024,55.91765978686814,55.7584350933499,55.60020976463424,55.44299607497856,
	55.28680590058845,55.13165070152705,54.97754150450273,54.82448888660421,54.672502960047616,
	54.521593357994355,54.37176922149338,54.22303918759436,54.075411378673074,53.928893393002234,
	53.78349229659509,53.63921461634127,53.49606633444786,53.35405288419104,53.21317914697703,
	53.07344945070378,52.934867569408425,52.797436724179136,52.66115958530369,52.526038275621396,
	52.392074375039826,52.25926892617266,52.12762244105071,51.997134908854356,51.867805804611514,
	51.73963409880343,51.61261826781716,51.486756305182396,51.36204573352837,51.23848361719615,
	51.11606657544095,50.99479079615905,50.874652050074566,50.75564570532189,50.637766742361194,
	50.52100976916547,50.405369036619675,50.290838454074816,50.1774116050015,50.06508176269082,
	49.95384190595248,49.84368473476287,49.734602685819496,49.62658794795994,49.51963247740743,
	49.41372801280781,49.308866090025596,49.20503805667003,49.1022350863248,49.00044819245781,
	48.899668241990774,48.79988596851011,48.70109198510409,48.6032767968133,48.50643081268353,
	48.41054435741305,48.31560768258768,48.22161097749927,48.12854437954544,48.036397984209216,
	47.94516185461951,47.85482603069453,47.76538053787143,47.67681539542694,47.58912062439432,
	47.50228625508368,47.41630233421239,47.331158931654386,47.246846146816814,47.163354114653174,
	47.08067301132313,46.9987930595087,46.91770453339758,46.83739776334408,46.75786314021849,
	46.679091119456004,46.60107222481599,46.52379705186275,46.44725627117859,46.371440631320304,
	46.29634096152955,46.22194817420818,46.14825326716847,46.07524732566902,46.00292152424602,
	45.93126712835006,45.86027549579764,45.78993807804722,45.72024642130844,45.651192167493434,
	45.582767055019175,45.514962919468125,45.44777169411626,45.38118541033524,45.31519619787653,
	45.24979628504463,45.18497799875105,45.120733764546344,45.05705610640534,44.993937646586545,
	44.93137110532961,44.86934930049545,44.80786514713722,44.74691165700722,44.68648193800438,
	44.626569193566795,44.56716672201376,44.50826791584104,44.44986626097356,44.391955335979056,
	44.334528811245946,44.277580448128994,44.22110409806569,44.165093701666194,44.10954328777983,
	44.05444697254053,43.99979895839374,43.94559353310705,43.89182506876679,43.838488020762604,
	43.785576926761856,43.73308640567564,43.68101115661824,43.62934595786139,43.578085665784904,
	43.52722521382501,43.47675961142184,43.426683942966854,43.37699336675176,43.32768311391963,
	43.27874848741937,43.23018486096421,43.18198767799525,43.13415245065065,43.08667475874126,
	43.03955024873321,42.992774632738104,42.946343687511444,42.900253253459525,42.85449923365545,
	42.80907759286467,42.763984356580096,42.71921561006763,42.674767497421875,42.630636220632624,
	42.58681803866219,42.543309266533804,42.50010627443133,42.45720548681026,42.41460338152033,
	42.37229648893966,42.330281391120565,42.288554720947175,42.24711316130488,42.20595344426134,
	42.16507235025961,42.124466707322874,42.084133390271056,42.04406931994915,42.004271462467315,
	41.96473682845259,41.92546247231225,41.886445491508674,41.84768302584568,41.80917225676632,
	41.77091040666176,41.73289473819154,41.69512255361485,41.65759119413273,41.6202980392412,
	41.58324050609513,41.54641604888267,41.509822158210305,41.47345636049814,41.43731621738557,
	41.40139932514693,41.36570331411731,41.330225848128016,41.294964623951934,41.25991737075835,
	41.225081849577286,41.190455852773134,41.15603720352738,41.12182375533051,41.087813391482726,
	41.05400402460333,41.02039359614902,40.98698007594027,40.95376146169644,40.92073577857887,
	40.88790107874213,40.85525544089322,40.822796969858565,40.790523796158745,40.75843407559073,
	40.72652598881754,40.694797740965285,40.66324756122726,40.6318737024752,40.60067444087738,
	40.56964807552357,40.538792928056644,40.508107342310865,40.47758968395636,40.447238340150214,
	40.4170517191785,40.38702825018165,40.35716638272833,40.32746458655586,40.297921351234514,
	40.268535185854084,40.239304618716154,40.210228197031796,40.181304486624605,40.15253207163903,
	40.123909554253906,40.09543555440102,40.06710870948867,40.038927674130115,40.01089111987684,
	39.98299773495649,39.95524622401548,39.9276353078661,39.900163723238066,39.87283022253448,
	39.84563357359201,39.81857255944535,39.791645978095715,39.764852642283486,39.73819137926471,
	39.711661030591664,39.685260451897015,39.658988512681915,39.63284409610776,39.60682609879143,
	39.580933430604205,39.555165014474106,39.529519786191656,39.503996694219,39.478594699502246,
	39.453312775287124,39.42814990693776,39.403105091758505,39.378177338818915,39.35336566878157,
	39.32866911373304,39.30408671701748,39.27961753307319,39.25526062727203,39.23101507576124,
	39.206879965308296,39.182854393148126,39.15893746683304,39.135128304085065,39.111426032650826,
	39.08782979015886,39.064338723979255,39.0409519910857,39.01766875791972,38.99448820025731,
	38.97140950307764,38.94843186043401,38.92555447532693,38.90277655957923,38.880097333713266,
	38.85751602683019,38.83503187649108,38.8126441286001,38.790352037289495,38.76815486480657,
	38.74605188140236,38.7240423652222,38.70212560219806,38.68030088594251,38.65856751764456,
	38.636924805967055,38.6153720669457,38.59390862388983,38.5725338072846,38.55124695469486,
	38.53004741067043,38.50893452665307,38.487907660884744,38.46696617831732,38.44610945052394,
	38.42533685561144,38.4046477781344,38.38404160901042,38.36351774543677,38.34307559080837,
	38.32271455463686,38.30243405247117,38.282233505819214,38.262112342070715,38.24206999442135,
	38.222105901798024,38.202219508785205,38.18241026555253,38.16267762778339,38.14302105660468,
	38.123440018517584,38.103933985329434,38.08450243408657,38.065144847008256,38.04586071142154,
	38.02664951969713,38.00751076918629,37.98844396215846,37.96944860574015,37.95052421185442,
	37.93167029716149,37.912886383000064,37.89417199532965,37.875526664673764,37.85694992606364,
	37.83844131898332,37.82000038731506,37.80162667928577,37.783319747414204,37.76507914845891,
	37.74690444336694,37.72879519722325,37.71075097920099,37.69277136251225,37.674855924359825,
	37.65700424588947,37.63921591214281,37.62149051201114,37.60382763818965,37.58622688713247,
	37.56868785900824,37.55121015765642,37.53379339054406,37.51643716872339,37.49914110678986,
	37.48190482284076,37.464727938434564,37.44761007855063,37.43055087154973,37.41354994913486,
	37.39660694631276,37.379721501355974,37.362893255765314,37.34612185423299,37.32940694460608,
	37.31274817785076,37.29614520801667,37.279597692202124,37.26310529051958,37.24666766606159,
	37.23028448486736,37.21395541588956,37.197680130961764,37.181458304766224,37.16528961480211,
	37.149173741354204,37.13311036746196,37.11709917888901,37.101139864093106,37.08523211419635,
	37.06937562295606,37.05357008673569,37.03781520447643,37.02211067766902,37.006456210325986,
	36.99085150895424,36.97529628252806,36.95979024246231,36.94433310258625,36.92892457911741,
	36.913564390635976,36.898252258059514,36.88298790461789,36.867771055811644,36.8526014394568,
	36.83747878555538,36.82240282634314,36.80737329624797,36.792389931866765,36.77745247194259,
	36.762560657342185,36.7477142310337,36.73291293806468,36.718156525540444,36.703444742602656,
	36.68877734040814,36.67415407210804,36.6595746928272,36.64503895964381,36.6305466315693,
	36.616097469528476,36.601691236339946,36.58732769669674,36.57300661714717,36.55872776607604,
	36.54449091368586,36.53029583197856,36.5161422947372,36.50203007750804,36.48795895758281,
	36.47392871398116,36.459939127433344,36.44598998036307,36.43208105687072,36.41821214271651,
	36.40438302530412,36.39059349366433,36.37684333843895,36.36313235186492,36.349460327758585,
	36.33582706150018,36.32223235001852,36.3086759917758,36.29515778675261,36.28167753643323,
	36.26823504379092,36.2548301132735,36.24146255078906,36.22813216369193,36.21483876076859,
	36.20158215222405,36.188362149668095,36.17517856610194,36.16203121590486,36.14891991482105,
	36.13584447994667,36.12280472971697,36.10980048389357,36.096831563552,36.083897791069184,
	36.07099899011129,36.058134985621514,36.045305603808174,36.032510672132815,36.01975001929851,
	36.00702347523836,35.994330871103905,35.98167203925393,35.96904681324324,35.9564550278116,
	35.94389651887281,35.93137112350387,35.9188786799343,35.90641902753562,35.89399200681077,
	35.88159745938397,35.86923522799029,35.85690515646568,35.84460708973696,35.83234087381189,
	35.82010635576941,35.807903383750016,35.795731806946144,35.78359147559276,35.77148224095796,
	35.75940395533379,35.74735647202702,35.735339645350194,35.723353330612554,35.711397384111294,
	35.69947166312278,35.68757602589384,35.67571033163328,35.66387444050332,35.65206821361127,
	35.64029151300125,35.628544201645894,35.616826143438345,35.60513720318414,35.59347724659333,
	35.58184614027256,35.57024375171734,35.55866994930435,35.54712460228376,35.53560758077178,
	35.52411875574318,35.512657999023894,35.501225183283765,35.48982018202927,35.47844286959641,
	35.46709312114365,35.45577081264489,35.44447582088259,35.43320802344084,35.421967298698654,
	35.410753525823225,35.399566584763285,35.388406356242555,35.37727272175319,35.366165563549416,
	35.35508476464105,35.34403020878733,35.33300178049055,35.321999364989935,35.31102284825555,
	35.300072116982165,35.28914705858337,35.27824756118553,35.26737351362204,35.25652480542736,
	35.24570132683141,35.234902968753765,35.22412962279807,35.21338118124644,35.20265753705394,
	35.191958583843125,35.181284215898565,35.17063432816158,35.16000881622482,35.14940757632711,
	35.13883050534816,35.128277500803456,35.11774846083915,35.107243284226996,35.09676187035936,
	35.08630411924426,35.07586993150046,35.065459208352614,35.05507185162643,35.04470776374393,
	35.034366847718765,35.024049007151476,35.013754146224905,35.00348216969961,34.993232982909326,
	34.98300649175646,34.972802602707645,34.962621222789366,34.952462259583534,34.94232562122318,
	34.932211216388225,34.92211895430117,34.91204874472291,34.9020004979486,34.89197412480351,
	34.881969536638955,34.87198664532823,34.862025363262596,34.85208560334738,34.84216727899795,
	34.83227030413588,34.82239459318507,34.812540061067935,34.802706623201615,34.79289419549421,
	34.783102694341075,34.77333203662113,34.76358213969327,34.753852921392635,34.74414430002716,
	34.73445619437389,34.7247885236756,34.715141207637224,34.70551416642245,34.69590732065026,
	34.68632059139157,34.676753900165906,34.66720716893796,34.65768032011448,34.64817327654081,
	34.638685961497785,34.62921829869848,34.619770212285026,34.61034162682547,34.60093246731068,
	34.59154265915117,34.58217212817412,34.57282080062035,34.563488603141195,34.55417546279565,
	34.544881307047326,34.53560606376159,34.52634966120259,34.517112028030425,34.50789309329826,
	34.498692786449546,34.48951103731517,34.48034777611069,34.47120293343359,34.462076440260525,
	34.45296822794469,34.443878228213045,34.434806373163696,34.42575259526326,34.41671682734428,
	34.407699002602584,34.39869905459475,34.389716917235575,34.380752524795504,34.37180581189816,
	34.3628767135179,34.3539651649773,34.34507110194473,34.33619446043197,34.32733517679175,
	34.3184931877155,34.30966843023083,34.30086084169935,34.29207035981424,34.28329692259806,
	34.274540468400374,34.26580093589554,34.25707826408052,34.24837239227257,34.239683260107114,
	34.23101080753555,34.222354974823055,34.21371570254647,34.205092931592176,34.196486603154,
	34.18789665873108,34.1793230401258,34.17076568944181,34.162224549081884,34.15369956174597,
	34.14519067042915,34.13669781841967,34.12822094929696,34.119760006929695,34.11131493547384,
	34.10288567937072,34.09447218334513,34.08607439240346,34.07769225183177,34.069325707193954,
	34.060974704329944,34.0526391893538,34.04431910865192,34.03601440888128,34.02772503696759,
	34.01945094010358,34.01119206574721,34.00294836161992,33.99471977570489,33.98650625624541,
	33.978307751743074,33.97012421095614,33.96195558289789,33.9538018168349,33.94566286228542,
	33.9375386690178,33.9294291870327,33.92133436662645,33.91325415829113,33.90518851277917,
	33.89713738108506,33.889100714443884,33.881078464329605,33.873070582453686,33.865077020763486,
	33.85709773144078,33.84913266690026,33.841181779788066,33.83324502298027,33.82532234958145,
	33.81741371292323,33.809519066562856,33.80163836428173,33.793771560084025,33.785918608195296,
	33.77807946306103,33.77025407934532,33.762442411929435,33.754644415910526,33.74686004660021,
	33.73908925952328,33.73133201041633,33.72358825522645,33.715857950109964,33.708141051431035,
	33.70043751576043,33.692747299874284,33.68507036075271,33.67740665557866,33.66975614173659,
	33.66211877681127,33.65449451858651,33.646883325043966,33.63928515436193,33.63169996491407,
	33.62412771526833,33.616568364185646,33.60902187061883,33.60148819371137,33.593967292796314,
	33.586459127395045,33.57896365721619,33.571480842154514,33.56401064228968,33.55655301788528,
	33.5491079293876,33.54167533742463,33.534255202804836,33.526847486516225,33.51945214972515,
	33.5120691537753,33.504698460186646,33.49734003065432,33.48999382704767,33.48265981140914,
	33.4753379459533,33.468028193065756,33.460730515302195,33.45344487538737,33.446171236214056,
	33.438909560842085,33.43165981249742,33.424421954571045,33.41719595061814,33.40998176435697,
	33.40277935966808,33.395588700593215,33.388409751334436,33.381242476253185,33.37408683986936,
	33.36694280686037,33.35981034206022,33.352689410458595,33.34557997720001,33.33848200758283,
	33.33139546705847,33.3243203212304,33.31725653585339,33.31020407683254,33.303162910222476,
	33.29613300222646,33.289114319195534,33.2821068276277,33.275110494167045,33.26812528560293,
	33.26115116886917,33.254188111043185,33.24723607934515,33.24029504113729,33.23336496392297,
	33.22644581534593,33.21953756318953,33.21264017537587,33.205753619965094,33.19887786515457,
	33.1920128792781,33.18515863080521,33.17831508834033,33.171482220622075,33.16465999652247,
	33.15784838504621,33.151047355329894,33.144256876641386,33.13747691837896,33.130707450070595,
	33.12394844137336,33.117199862072596,33.11046168208118,33.10373387143894,33.09701640031183,
	33.090309238991345,33.083612357893685,33.07692572755922,33.07024931865171,33.06358310195767,
	33.05692704838568,33.05028112896571,33.04364531484844,33.03701957730467,33.03040388772461,
	33.0237982176172,33.017202538609546,33.01061682244619,33.00404104098855,32.99747516621422,
	32.9909191702164,32.984373025203205,32.977836703497125,32.9713101775343,32.96479341986403,
	32.95828640314809,32.95178910016011,32.945301483785045,32.93882352701851,32.932355202966235,
	32.92589648484344,32.91944734597429,32.91300775979126,32.906577699834614,32.90015713975179,
	32.893746053296844,32.8873444143299,32.88095219681657,32.87456937482738,32.868195922537254,
	32.86183181422492,32.855477024272425,32.84913152716451,32.84279529748814,32.83646830993189,
	32.83015053928551,32.823841960439324,32.8175425483837,32.81125227820858,32.80497112510292,
	32.79869906435413,32.792436071347716,32.78618212156658,32.77993719059066,32.773701254096274,
	32.767474287855826,32.76125626773711,32.75504716970295,32.74884696981063,32.74265564421146,
	32.73647316915022,32.73029952096481,32.72413467608563,32.717978611035164,32.71183130242753,
	32.705692726967946,32.69956286145237,32.6934416827669,32.68732916788746,32.6812252938792,
	32.67513003789616,32.66904337718073,32.662965289063266,32.6568957509616,32.65083474038061,
	32.644782234911794,32.63873821223282,32.6327026501071,32.62667552638332,32.62065681899506,
	32.614646505960344,32.60864456538123,32.602650975443346,32.596665714415536,32.59068876064938,
	32.58472009257882,32.578759688719735,32.57280752766955,32.566863588106806,32.560927848790755,
	32.55500028856096,32.54908088633694,32.543169621117706,32.53726647198141,32.53137141808495,
	32.525484438663554,32.519605513030434,32.51373462057635,32.50787174076932,32.502016853154096,
	32.49616993735193,32.49033097306011,32.4844999400516,32.47867681817474,32.47286158735276,
	32.46705422758353,32.46125471893908,32.45546304156538,32.449679175681794,32.443903101580936,
	32.43813479962814,32.43237425026119,32.42662143398997,32.42087633139609,32.41513892313252,
	32.40940918992333,32.403687112563226,32.397972671917316,32.39226584892073,32.38656662457824,
	32.38087497996402,32.375190896221234,32.36951435456174,32.36384533626575,32.35818382268149,
	32.352529795224925,32.34688323537938,32.341244124695265,32.3356124447897,32.329988177346245,
	32.32437130411461,32.31876180691023,32.31315966761409,32.307564868172285,32.30197739059584,
	32.29639721696031,32.29082432940552,32.285258710135246,32.27970034141689,32.274149205581246,
	32.268605285022154,32.26306856219621,32.257539019622456,32.25201663988216,32.246501405618424,
	32.24099329953598,32.235492304400836,32.22999840304006,32.22451157834141,32.219031813253146,
	32.21355909078368,32.20809339400135,32.20263470603405,32.197183010069075,32.19173828935276,
	32.18630052719026,32.18086970694523,32.17544581203957,32.17002882595323,32.16461873222379,
	32.15921551444637,32.15381915627323,32.148429641413564,32.14304695363325,32.13767107675457,
	32.13230199465597,32.12693969127177,32.12158415059196,32.11623535666187,32.11089329358201,
	32.105557945507776,32.10022929664919,32.09490733127064,32.0895920336907,32.0842833882818,
	32.07898137947006,32.07368599173499,32.06839720960929,32.06311501767856,32.05783940058114,
	32.05257034300778,32.047307829701495,32.042051845457244,32.03680237512179,32.03155940359336,
	32.02632291582153,32.02109289680692,32.015869331600946,32.01065220530572,32.005441503073655,
	32.00023721010736,31.995039311659383,31.989847793031984,31.98466263957691,31.979483836695202,
	31.974311369836943,31.96914522450107,31.963985386235134,31.958831840635103,31.953684573345154,
	31.948543570057435,31.943408816511877,31.938280298495968,31.93315800184456,31.928041912439674,
	31.922932016210243,31.917828299131944,31.912730747227013,31.90763934656398,31.902554083257524,
	31.897474943468268,31.89240191340252,31.887334979312172,31.882274127494416,31.877219344291557,
	31.872170616090905,31.867127929324447,31.862091270468767,31.857060626044788,31.852035982617615,
	31.84701732679632,31.84200464523376,31.83699792462642,31.83199715171417,31.827002313280108,
	31.82201339615038,31.817030387194013,31.812053273322654,31.807082041490514,31.80211667869402,
	31.79715717197181,31.79220350840446,31.787255675114285,31.782313659265206,31.777377448062555,
	31.772447028752957,31.76752238862402,31.762603515004297,31.757690395263065,31.752783016810127,
	31.747881367095665,31.742985433610084,31.7380952038838,31.73321066548711,31.72833180603003,
	31.72345861316208,31.718591074572156,31.713729177988366,31.708872911177856,31.704022261946633,
	31.699177218139425,31.694337767639514,31.689503898368567,31.684675598286496,31.67985285539125,
	31.67503565771874,31.67022399334258,31.665417850374027,31.660617216961743,31.655822081291706,
	31.651032431587012,31.646248256107743,31.64146954315079,31.636696281032773,31.63192845815827,
	31.62716606291625,31.62240908374941,31.617657509136507,31.61291132759226,31.608170527667156,
	31.60343509794729,31.598705027054287,31.593980303645058,31.589260916411767,31.58454685408159,
	31.57983810541663,31.575134659213774,31.570436504304503,31.56574362955481,31.56105602386501,
	31.55637367616964,31.55169657543732,31.54702471067056,31.5423580709057,31.537696645212705,
	31.533040422695095,31.52838939248973,31.523743543766756,31.519102865729423,31.514467347613962,
	31.509836978689464,31.50521174825771,31.500591645653113,31.495976660242498,31.491366781425047,
	31.486761998632115,31.48216230132716,31.477567679005546,31.472978121194462,31.468393617452787,
	31.46381415737096,31.459239730570836,31.454670326705624,31.450105935459675,31.445546546548407,
	31.440992149718205,31.43644273474623,31.43189829144037,31.4273588096391,31.422824279211277,
	31.418294690056157,31.413770032103187,31.409250295311917,31.404735469671834,31.400225545202346,
	31.395720511952547,31.39122036000118,31.386725079456486,31.382234660456113,31.377749093166976,
	31.37326836778514,31.368792474535752,31.36432140367285,31.359855145479358,31.355393690266823,
	31.350937028375494,31.346485150174022,31.342038046059475,31.337595706457204,31.33315812182068,
	31.32872528263143,31.324297179398958,31.319873802660556,31.31545514298127,31.31104119095375,
	31.306631937198166,31.302227372362086,31.297827487120383,31.29343227217512,31.289041718255476,
	31.284655816117585,31.280274556544477,31.275897930345966,31.271525928358546,31.267158541445294,
	31.26279576049574,31.258437576425816,31.254083980177697,31.249734962719767,31.24539051504645,
	31.241050628178176,31.23671529316121,31.232384501067653,31.228058242995242,31.22373651006732,
	31.21941929343269,31.21510658426559,31.2107983737655,31.206494653157137,31.202195413690315,
	31.197900646639834,31.19361034330546,31.18932449501173,31.185043093107918,31.180766128967964,
	31.176493593990315,31.17222547959791,31.16796177723801,31.163702478382156,31.159447574526084,
	31.155197057189586,31.150950917916482,31.146709148274493,31.142471739855157,31.138238684273734,
	31.13400997316914,31.129785598203846,31.12556555106379,31.121349823458278,31.117138407119928,
	31.112931293804568,31.10872847529113,31.10452994338157,31.100335689900856,31.096145706696774,
	31.091959985639914
	}}
};
table1d_imp<2001> tubetable2_6C16[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	29779.50573099651,29662.13798276357,29545.626172947257,29429.961483696286,29315.135213105117,
	29201.138773390605,29087.96368909349,28975.60159531589,28864.044235992147,28753.283462187384,
	28643.31123042979,28534.119601072856,28425.70073668501,28318.046900468857,28211.15045471074,
	28105.003859255634,27999.599670008738,27894.930537467877,27790.98920527572,27687.76850880357,
	27585.261373755475,27483.46081479937,27382.35993422299,27281.951920610718,27182.230047544384,
	27083.187672331318,26984.818234744595,26887.115255795063,26790.072336520007,26693.683156794355,
	26597.94147415775,26502.841122669903,26408.37601177902,26314.540125212246,26221.32751988417,
	26128.732324825316,26036.74874012727,25945.371035907076,25854.593551287147,25764.410693394842,
	25674.816936378535,25585.806820436934,25497.374950871435,25409.515997144983,25322.224691966854,
	25235.4958303841,25149.32426889372,25063.704924567173,24978.632774189064,24894.102853411234,
	24810.110255921227,24726.650132621733,24643.717690827118,24561.308193469984,24479.41695832236,
	24398.03935723057,24317.17081535836,24236.806810448725,24156.94287209056,24077.574581004155,
	23998.697568331765,23920.307514945514,23842.400150760524,23764.971254064072,23688.01665085374,
	23611.53221418447,23535.51386352774,23459.95756414103,23384.85932644645,23310.215205420038,
	23236.021299988777,23162.273752440808,23088.968747840176,23016.102513455364,22943.671318192643,
	22871.67147204185,22800.099325528536,22728.95126917449,22658.223732968927,22587.913185845227,
	22518.01613516682,22448.529126221998,22379.44874172391,22310.77160132257,22242.494361117908,
	22174.613713186533,22107.126385113166,22040.029139527727,21973.318773652285,21906.99211885224,
	21841.046040196918,21775.47743602368,21710.283237512656,21645.460408262577,21581.00594387869,
	21516.91687156189,21453.190249708226,21389.823167510847,21326.81274456881,21264.156130504165,
	21201.85050458111,21139.893075333366,21078.281080195346,21017.01178513982,20956.082484320355,
	20895.49049972051,20835.233180804076,20775.30790417652,20715.712073245373,20656.443117889623,
	20597.498494131898,20538.875683816874,20480.57219429213,20422.58555809533,20364.913332646855,
	20307.553099943907,20250.502466259946,20193.759061851688,20137.320540665205,20081.1845800501,
	20025.348880475216,19969.811165250096,19914.569180249702,19859.62069364304,19804.963495625143,
	19750.595398154248,19696.514234690934,19642.717859941924,19589.204149607045,19535.971000130947,
	19483.0163284556,19430.338071779202,19377.93418731637,19325.802652063252,19273.941462563835,
	19222.34863468178,19171.022203373894,19119.960222466103,19069.160764435775,19018.621920192458,
	18968.341798864887,18918.31852759058,18868.550251305605,18819.03513254174,18769.77135122197,
	18720.757104461463,18671.99060637039,18623.47008785886,18575.193796445277,18527.159996068363,
	18479.36696689748,18431.813005151103,18384.49642291386,18337.415547957084,18290.56872356155,
	18243.95430834367,18197.57067608185,18151.41621554845,18105.489330339293,18059.788438710028,
	18014.311973412056,17969.058381531202,17924.026124327887,17879.213677081705,17834.61952893407,
	17790.24218273716,17746.080154901596,17702.13197524789,17658.396186859456,17614.871345936313,
	17571.556021652952,17528.448796015356,17485.548263723656,17442.853032030704,17400.361720609006,
	17358.07296141464,17315.985398555404,17274.097688158003,17232.408498240977,17190.916508586175,
	17149.620410611475,17108.518907247682,17067.6107128149,17026.89455290107,16986.369164242707,
	16946.033294605415,16905.885702668216,16865.92515790721,16826.150440481502,16786.560341121756,
	16747.15366101759,16707.929211708317,16668.88581497507,16630.022302733054,16591.33751692537,
	16552.83030941962,16514.499541903322,16476.34408578368,16438.362822085757,16400.55464135286,
	16362.918443548746,16325.453137960503,16288.157643102968,16251.030886623093,16214.071805207732,
	16177.2793444897,16140.652458957735,16104.190111865633,16067.891275143538,16031.754929308932,
	15995.780063381148,15959.96567479375,15924.310769310698,15888.81436094276,15853.475471862943,
	15818.293132326418,15783.266380587964,15748.394262823625,15713.675833049694,15679.110153046211,
	15644.696292279219,15610.433327823757,15576.320344289996,15542.356433746942,15508.540695650074,
	15474.872236768404,15441.35017111127,15407.973619859202,15374.74171129204,15341.653580720336,
	15308.708370416007,15275.905229545619,15243.24331410188,15210.72178683816,15178.339817202766,
	15146.096581274329,15113.991261697256,15082.023047618744,15050.191134626313,15018.494724685841,
	14986.93302607986,14955.505253347874,14924.210627225619,14893.048374587373,14862.017728385417,
	14831.11792759453,14800.348217152872,14769.707847907026,14739.196076554748,14708.812165591,
	14678.555383252226,14648.425003462988,14618.420305782445,14588.540575351612,14558.78510284054,
	14529.153184397499,14499.644121597472,14470.25722139142,14440.991796056418,14411.847163147006,
	14382.822645445221,14353.917570912896,14325.131272643614,14296.463088815815,14267.91236264497,
	14239.478442339243,14211.160681051784,14182.958436836585,14154.87107260338,14126.897956073579,
	14099.038459735977,14071.291960804285,14043.657841173217,14016.135487377222,13988.724290547805,
	13961.423646371652,13934.232955051337,13907.151621262197,13880.179054114706,13853.314667112838,
	13826.557878115533,13799.908109297794,13773.364787112247,13746.92734225077,13720.59520960727,
	13694.367828239578,13668.244641333775,13642.225096166354,13616.308644069371,13590.494740393864,
	13564.782844474628,13539.17241959579,13513.662932955496,13488.253855631418,13462.944662548294,
	13437.734832442673,13412.62384783065,13387.611194974952,13362.696363852234,13337.878848120756,
	13313.158145088773,13288.53375568313,13264.005184417552,13239.57193936225,13215.233532113145,
	13190.989477761832,13166.839294865169,13142.782505416159,13118.818634814388,13094.947211836494,
	13071.167768608897,13047.479840577264,13023.882966480163,13000.376688320359,12976.960551337046,
	12953.634103978986,12930.396897877541,12907.248487818946,12884.188431719178,12861.2162905967,
	12838.33162854669,12815.534012715845,12792.82301327622,12770.198203400176,12747.659159236217,
	12725.205459882456,12702.836687364632,12680.552426609644,12658.352265422629,12636.235794463462,
	12614.202607222389,12592.252299997306,12570.384471870631,12548.598724686573,12526.894663028053,
	12505.271894194744,12483.730028180948,12462.268677653366,12440.887457929328,12419.585986955593,
	12398.363885286763,12377.22077606428,12356.156284995432,12335.170040332538,12314.261672852985,
	12293.430815838155,12272.67710505371,12252.000178729548,12231.399677540414,12210.875244585695,
	12190.42652537087,12170.05316778726,12149.754822094445,12129.5311408998,12109.38177914153,
	12089.30639406868,12069.304645224256,12049.376194425744,12029.520705748228,12009.737845506352,
	11990.027282236031,11970.388686678154,11950.821731760416,11931.326092580506,11911.901446389058,
	11892.547472573031,11873.263852638844,11854.050270196256,11834.906410941401,11815.83196264109,
	11796.826615116484,11777.890060227744,11759.021991857566,11740.22210589595,11721.49010022478,
	11702.825674702186,11684.228531147888,11665.698373327954,11647.234906939411,11628.837839596239,
	11610.506880814248,11592.24174199648,11574.042136419535,11555.907779218567,11537.838387373657,
	11519.83367969552,11501.893376811711,11484.017201153069,11466.204876940003,11448.456130168968,
	11430.77068859937,11413.14828173936,11395.588640834138,11378.09149885196,11360.65659047141,
	11343.283652068834,11325.972421705415,11308.722639114692,11291.534045690207,11274.40638447322,
	11257.339400140108,11240.332838990687,11223.38644893574,11206.499979485725,11189.673181738142,
	11172.905808366582,11156.197613608794,11139.54835325501,11122.957784636801,11106.425666615633,
	11089.95175957196,11073.535825393494,11057.177627464713,11040.876930655715,11024.633501311537,
	11008.447107241042,10992.317517707044,10976.244503414624,10960.227836501736,10944.267290528058,
	10928.362640465235,10912.513662686382,10896.720134956124,10880.98183641993,10865.298547595507,
	10849.670050361517,10834.096127948476,10818.576564929306,10803.111147208963,10787.69966201545,
	10772.341897890134,10757.037644678518,10741.78669352085,10726.588836842699,10711.443868346056,
	10696.35158300016,10681.311777032512,10666.324247919785,10651.388794379265,10636.505216359765,
	10621.673315033007,10606.892892785025,10592.1637532075,10577.485701089312,10562.858542407972,
	10548.282084321449,10533.756135159812,10519.280504416743,10504.855002741682,10490.479441931402,
	10476.153634922275,10461.877395782089,10447.650539702085,10433.47288298924,10419.344243058371,
	10405.264438424583,10391.23328869499,10377.250614562161,10363.316237795207,10349.429981233587,
	10335.59166877869,10321.801125387023,10308.058177062378,10294.362650849473,10280.714374825382,
	10267.113178093401,10253.558890775617,10240.051344005844,10226.590369922498,10213.175801661839,
	10199.807473351108,10186.485220101227,10173.208878000554,10159.978284107936,10146.793276445613,
	10133.653693993168,10120.55937668078,10107.510165382115,10094.505901908724,10081.54642900269,
	10068.631590330786,10055.76123047788,10042.935194940792,10030.153330121595,10017.415483321833,
	10004.721502736265,9992.07123744617,9979.464537414126,9966.901253477181,9954.381237341244,
	9941.904341574913,9929.470419603587,9917.079325703666,9904.730914996497,9892.425043442681,
	9880.161567836321,9867.940345798937,9855.761235774606,9843.624097022983,9831.528789614966,
	9819.475174426374,9807.463113132417,9795.492468202427,9783.563102894273,9771.674881248786,
	9759.827668084588,9748.021328992289,9736.255730329802,9724.530739216138,9712.846223526993,
	9701.202051889006,9689.598093674575,9678.034218996892,9666.510298704365,9655.026204376009,
	9643.581808316023,9632.176983548812,9620.811603813792,9609.485543560795,9598.198677944549,
	9586.950882820227,9575.742034738187,9564.572010939204,9553.4406893496,9542.347948576407,
	9531.29366790246,9520.277727281737,9509.300007334623,9498.36038934305,9487.458755245743,
	9476.594987633698,9465.768969745395,9454.980585462346,9444.229719303963,9433.516256423785,
	9422.840082604193,9412.201084252163,9401.59914839466,9391.034162674307,9380.506015344565,
	9370.014595265573,9359.55979189959,9349.141495306498,9338.759596139535,9328.413985640866,
	9318.104555637072,9307.831198534965,9297.593807317215,9287.39227553796,9277.226497318756,
	9267.096367343847,9257.001780856346,9246.942633653704,9236.91882208362,9226.930243039737,
	9216.976793957394,9207.058372809735,9197.17487810309,9187.326208873099,9177.512264680485,
	9167.732945606882,9157.98815225073,9148.277785723378,9138.601747644447,9128.959940138166,
	9119.352265829268,9109.778627838841,9100.23892978019,9090.733075754728,9081.260970348185,
	9071.822518626392,9062.417626131219,9053.046198876713,9043.708143344878,9034.403366481798,
	9025.131775693528,9015.893278842255,9006.687784242049,8997.51520065511,8988.3754372876,
	8979.268403785898,8970.194010232224,8961.152167140972,8952.142785454593,8943.165776539776,
	8934.221052183064,8925.308524587377,8916.42810636757,8907.579710546921,8898.763250552598,
	8889.978640212148,8881.225793749123,8872.50462577933,8863.815051306798,8855.156985719506,
	8846.530344785742,8837.935044649732,8829.371001827833,8820.838133204425,8812.336356027827,
	8803.865587906053,8795.42574680322,8787.016751034953,8778.638519264447,8770.29097049848,
	8761.974024083162,8753.687599699673,8745.431617360471,8737.205997404424,8729.010660493475,
	8720.84552760769,8712.710520041339,8704.605559398638,8696.530567589401,8688.485466824579,
	8680.47017961219,8672.484628752658,8664.528737334778,8656.602428730794,8648.705626592491,
	8640.838254846185,8633.000237688508,8625.191499581912,8617.411965249617,8609.661559671642,
	8601.940208079403,8594.247835951604,8586.584369009057,8578.949733210195,8571.34385474585,
	8563.766660034784,8556.218075718203,8548.698028655328,8541.206445917842,8533.743254784958,
	8526.308382738383,8518.901757456852,8511.52330681088,8504.172958857402,8496.850641834277,
	8489.556284155029,8482.289814402815,8475.051161325131,8467.84025382781,8460.657020969516,
	8453.501391955484,8446.373296131625,8439.2726629785,8432.199422105143,8425.153503242658,
	8418.13483623782,8411.143351046787,8404.178977728108,8397.241646436481,8390.331287415564,
	8383.447830990963,8376.591207563413,8369.761347601476,8362.958181633954,8356.181640242623,
	8349.431654054573,8342.708153734335,8336.011069975848,8329.340333494665,8322.69587501912,
	8316.077625282562,8309.485515014077,8302.919474930077,8296.37943572506,8289.865328062597,
	8283.377082565687,8276.914629807226,8270.477900300266,8264.066824487756,8257.681332732169,
	8251.32135530514,8244.986822376497,8238.677664003351,8232.393810118376,8226.135190518558,
	8219.90173485303,8213.693372610893,8207.510033108769,8201.351645477695,8195.218138650092,
	8189.109441346282,8183.025482060282,8176.966189045945,8170.931490301754,8164.921313556187,
	8158.935586252175,8152.974235530965,8147.037188216002,8141.124370795976,8135.23570940763,
	8129.371129817969,8123.530557405969,8117.713917143738,8111.921133577274,8106.1521308064885,
	8100.406832464701,8094.6851616976055,8088.987041141524,8083.312392901062,8077.661138526106,
	8072.0331989879805,8066.428494655329,8060.846945268572,8055.28846991425,8049.752986998151,
	8044.240414217985,8038.750668534621,8033.283666143351,8027.839322443155,8022.417552006121,
	8017.018268545031,8011.641384880537,8006.286812906769,8000.954463556503,7995.644246764663,
	7990.356071431002,7985.089845381413,7979.845475328253,7974.622866829036,7969.421924244309,
	7964.242550693749,7959.084648011072,7953.948116697424,7948.832855873445,7943.738763229637,
	7938.665734975101,7933.613665784834,7928.582448745259,7923.571975297912,7918.582135181524,
	7913.612816371928,7908.663905020513,7903.735285390337,7898.8268397903585,7893.938448507561,
	7889.069989736772,7884.221339508594,7879.392371614738,7874.582957531142,7869.792966338494,
	7865.022264640622,7860.270716479872,7855.538183250154,7850.82452360725,7846.129593376189,
	7841.453245455771,7836.795329720298,7832.155692918229,7827.534178567799,7822.930626849128,
	7818.344874493627,7813.776754669766,7809.226096865417,7804.692726766646,7800.176466133591,
	7795.677132671616,7791.194539899951,7786.728497015539,7782.278808753862,7777.845275245228,
	7773.427691867642,7769.025849095137,7764.639532342568,7760.26852180559,7755.912592297489,
	7751.571513080566,7747.245047694228,7742.9329537782305,7738.634982892281,7734.350880330483,
	7730.080384932365,7725.823228888904,7721.579137544851,7717.347829196584,7713.129014885762,
	7708.922398189134,7704.727675004137,7700.544533330738,7696.3726530494305,7692.211705695995,
	7688.061354232165,7683.921252813684,7679.791046555211,7675.670371292543,7671.558853341875,
	7667.456109258167,7663.36174559071,7659.2753586377985,7655.196534200595,7651.1248473365695,
	7647.059862113055,7643.001131361974,7638.94819643543,7634.900586963984,7630.857820617683,
	7626.819402870791,7622.7848267713325,7618.753572716313,7614.725108233609,7610.698887771645,
	7606.674352498177,7602.650930109665,7598.6280346518915,7594.605066354277,7590.5814114785135,
	7586.556442184138,7582.529516411723,7578.499977786521,7574.467155543745,7570.430364478164,
	7566.388904919711,7562.3420627372825,7558.289109373896,7554.229301914238,7550.161883188657,
	7546.086081914909,7542.001112881392,7537.906177173837,7533.80046244878,7529.683143256676,
	7525.553381417304,7521.41032645083,7517.253116067102,7513.080876716772,7508.892724206525,
	7504.687764382034,7500.465093880858,7496.22380095899,7491.962966392782,7487.681664459654,
	7483.378963999291,7479.053929558293,7474.7056226194145,7470.3331029178535,7465.935429845559,
	7461.5116639446405,7457.060868490643,7452.582111165982,7448.074465823061,7443.537014336487,
	7438.968848543151,7434.369072268024,7429.736803433214,7425.0711762474,7420.371343471123,
	7415.636478753711,7410.865779036408,7406.05846701512,7401.213793656307,7396.331040757776,
	7391.409523545803,7386.4485932994685,7381.44763999132,7376.406094934134,7371.3234334212675,
	7366.19917734874,7361.032897805563,7355.824217618711,7350.572813838869,7345.278420151875,
	7339.9408292012495,7334.559894806658,7329.135534062934,7323.667729304583,7318.156529920603,
	7312.6020540049285,7307.004489828107,7301.364097116515,7295.6812081258595,7289.956228497007,
	7284.189637883019,7278.381990336967,7272.533914452181,7266.646113247427,7260.719363791175,
	7254.75451656041,7248.752494532235,7242.714292006462,7236.640973161023,7230.533670342538,
	7224.393582097137,7218.221970947826,7212.020160926715,7205.789534872769,7199.531531506148,
	7193.247642293278,7186.939408117216,7180.608415769618,7174.256294282358,7167.884711116514,
	7161.4953682293735,7155.08999803897,7148.670359307179,7142.2382329627535,7135.795417885708,
	7129.343726674138,7122.8849814151,7116.421009479907,7109.953639364609,7103.484696594836,
	7097.015999713957,7090.549356371925,7084.086559532037,7077.6293838103065,7071.1795819617355,
	7064.738881526261,7058.308981645609,7051.891550060286,7045.48822029584,7039.100589043997,
	7032.730213744696,7026.378610372693,7020.047251430355,7013.737564148413,7007.450928893702,
	7001.188677782363,6994.952093496107,6988.742408296526,6982.5608032341315,6976.408407544858,
	6970.286298228587,6964.195499801551,6958.136984215515,6952.1116709348835,6946.120427162961,
	6940.164068208878,6934.243357985067,6928.35900962678,6922.5116862230625,6916.702001650957,
	6910.930521502713,6905.197764096796,6899.50420156411,6893.850261000102,6888.2363256745575,
	6882.662736290872,6877.129792286346,6871.637753167083,6866.186839869062,6860.777236139935,
	6855.409089934123,6850.082514816265,6844.797591366967,6839.554368585746,6834.3528652870455,
	6829.193071484564,6824.074949760177,6818.99843661422,6813.963443793592,6808.969859595177,
	6804.017550142442,6799.106360632337,6794.236116551486,6789.406624859289,6784.617675138101,
	6779.8690407075255,6775.160479703549,6770.491736121631,6765.862540822668,6761.272612502631,
	6756.721658624966,6752.209376316458,6747.735453226516,6743.299568350341,6738.901392816193,
	6734.540590637654,6730.21681943147,6725.929731101323,6721.678972488716,6717.464185991529,
	6713.285010151052,6709.141080209022,6705.032028634417,6700.957485622051,6696.917079563166,
	6692.910437489472,6688.937185491632,6684.996949112162,6681.0893537154825,6677.2140248341,
	6673.370588493581,6669.558671518055,6665.777901805217,6662.0279086037635,6658.308322749867,
	6654.6187768984855,6650.958905733926,6647.328346166423,6643.726737512476,6640.153721660607,
	6636.60894322452,6633.09204968223,6629.602691504042,6626.14052226716,6622.705198761811,
	6619.296381084817,6615.913732724537,6612.55692063588,6609.225615307503,6605.919490820117,
	6602.638224897077,6599.381498945602,6596.148998103883,6592.940411255406,6589.755431064336,
	6586.593753991711,6583.455080308737,6580.339114105651,6577.245563296071,6574.174139616524,
	6571.1245586228915,6568.0965396823885,6565.089805962892,6562.104084418107,6559.139105771368,
	6556.194604495037,6553.270318788688,6550.365990554452,6547.481365370668,6544.6161924629005,
	6541.770224674214,6538.943218433004,6536.1349337202555,6533.345134034512,6530.573586356388,
	6527.820061112002,6525.084332135208,6522.366176629549,6519.665375128421,6516.981711456199,
	6514.314972687079,6511.664949105474,6509.031434163856,6506.414224442247,6503.813119606054,
	6501.227922365005,6498.658438430597,6496.1044764748685,6493.565848088173,6491.042367737515,
	6488.533852724762,6486.040123145175,6483.561001845648,6481.096314384381,6478.6458889886335,
	6476.209556515315,6473.787150409504,6471.378506664934,6468.983463784195,6466.601862739177,
	6464.233546932306,6461.878362156854,6459.536156560728,6457.206780606323,6454.890087034857,
	6452.585930828538,6450.294169174336,6448.014661427742,6445.747269077287,6443.491855709476,
	6441.248286973938,6439.01643054927,6436.796156109352,6434.587335290203,6432.389841656849,
	6430.203550671407,6428.028339661366,6425.864087787753,6423.710676014485,6421.567987078373,
	6419.435905458753,6417.3143173482495,6415.203110624007,6413.102174818586,6411.0114010925545,
	6408.930682208588,6406.859912496244,6404.798987838112,6402.747805634598,6400.706264780529,
	6398.674265639702,6396.651710020324,6394.638501149946,6392.634543652023,6390.639743521685,
	6388.654008102954,6386.677246065674,6384.709367383271,6382.75028331044,6380.799906361522,
	6378.858150289565,6376.924930065063,6375.0001618557735,6373.083763006269,6371.175652018061,
	6369.275748527676,6367.383973299348,6365.500248187669,6363.624496131724,6361.756641134469,
	6359.896608243954,6358.044323536727,6356.199714100438,6354.362708016877,6352.533234345628,
	6350.711223107893,6348.896605270506,6347.089312730338,6345.289278299052,6343.496435688212,
	6341.710719493687,6339.932065182284,6338.160409076493,6336.395688341435,6334.637840970535,
	6332.886805771921,6331.1425223554315,6329.404931120024,6327.673973240127,6325.949590654134,
	6324.231726050805,6322.520322858867,6320.815325233637,6319.1166780461635,6317.424326871498,
	6315.7382179777815,6314.05829831525,6312.3845155047375,6310.716817827662,6309.055154215688,
	6307.399474239968,6305.749728101681,6304.105866621634,6302.467841230399,6300.83560395993,
	6299.209107432925,6297.5883048543365,6295.973150001901,6294.363597217875,6292.759601399413,
	6291.161117991537,6289.568102976719,6287.980512868581,6286.398304702252,6284.8214360273905,
	6283.249864900274,6281.68354987543,6280.12244999883,6278.566524800069,6277.015734285295,
	6275.470038930157,6273.929399672166,6272.3937779045955,6270.863135469259,6269.337434649637,
	6267.816638165009,6266.300709163305,6264.789611215339,6263.2833083080595,6261.78176483887,
	6260.284945609221,6258.792815819662,6257.305341062661,6255.822487317478,6254.344220945328,
	6252.870508683032,6251.401317637237,6249.936615280203,6248.476369443929,6247.020548315036,
	6245.56912042971,6244.122054669018,6242.679320253779,6241.2408867394815,6239.806724012001,
	6238.376802283063,6236.951092085282,6235.529564267702,6234.112189991745,6232.698940726639,
	6231.289788244467,6229.884704617791,6228.483662213396,6227.086633689747,6225.693591992104,
	6224.304510349365,6222.919362269254,6221.538121535266,6220.160762202822,6218.787258595204,
	6217.417585300501,6216.051717167478,6214.689629302342,6213.3312970675115,6211.976696069567,
	6210.625802168659,6209.27859146694,6207.935040307216,6206.595125269786,6205.258823169609,
	6203.926111052564,6202.596966192894,6201.271366090554,6199.9492884675565,6198.630711265676,
	6197.31561264279,6196.003970971041,6194.695764833633,6193.390973022243,6192.089574534142,
	6190.791548569137,6189.496874528488,6188.205532010617,6186.917500806679,6185.632760909926,
	6184.35129249463,6183.073075926739,6181.798091757145,6180.526320720661,6179.257743733504,
	6177.99234189035,6176.730096462677,6175.470988896316,6174.215000809462,6172.962113990751,
	6171.7123103962485,6170.465572149021,6169.221881534807,6167.9812210030395,6166.743573161836,
	6165.508920777842,6164.277246773761,6163.048534227208,6161.822766367282,6160.599926574438,
	6159.379998377947,6158.162965453294,6156.948811622079,6155.737520849389,6154.529077241517,
	6153.323465045805,6152.120668647852,6150.920672569792,6149.723461469368,6148.529020138395,
	6147.337333500151,6146.148386608795,6144.962164647785,6143.778652928198,6142.597836887262,
	6141.419702086595,6140.244234211332,6139.07141906879,6137.9012425860565,6136.733690810099,
	6135.568749904955,6134.406406151625,6133.246645945565,6132.089455796713,6130.934822327379,
	6129.782732270412,6128.633172469838,6127.486129878076,6126.341591554123,6125.199544665475,
	6124.059976482791,6122.9228743819995,6121.788225841237,6120.656018440928,6119.526239862057,
	6118.398877884836,6117.273920388565,6116.151355349533,6115.031170840707,6113.913355029527,
	6112.797896179118,6111.684782644666,6110.574002874525,6109.465545407613,6108.359398873247,
	6107.255551991013,6106.15399356785,6105.054712498445,6103.957697764174,6102.862938432071,
	6101.7704236541385,6100.680142665326,6099.592084784888,6098.506239412689,6097.422596031111,
	6096.34114420264,6095.261873568526,6094.184773850006,6093.109834845061,6092.037046429906,
	6090.9663985566185,6089.897881252412,6088.831484619975,6087.7671988359825,6086.705014149463,
	6085.6449208838,6084.586909432404,6083.530970260497,6082.477093903872,6081.425270967845,
	6080.3754921263235,6079.327748121898,6078.2820297650605,6077.238327932642,6076.196633567641,
	6075.156937679486,6074.119231341689,6073.08350569287,6072.049751934417,6071.017961332175,
	6069.9881252128225,6068.960234967488,6067.934282043554,6066.9102579539685,6065.88815427013,
	6064.867962622467,6063.849674701148,6062.833282253972,6061.818777086861,6060.806151063062,
	6059.795396102101,6058.786504180083,6057.779467328861,6056.774277634817,6055.7709272392485,
	6054.769408337596,6053.769713178888,6052.771834064648,6051.775763349814,6050.781493440488,
	6049.789016795519,6048.798325920638,6047.809413382364,6046.822271787098,6045.836893794856,
	6044.853272114796,6043.871399504106,6042.891268769634,6041.912872765136,6040.936204392223,
	6039.961256599239,6038.988022381817,6038.016494780566,6037.046666883576,6036.078531822431,
	6035.112082775291,6034.147312963412,6033.1842156536695,6032.2227841557415,6031.263011822538,
	6030.304892050235,6029.348418278036,6028.393583987073,6027.440382699818,6026.488807980766,
	6025.538853435711,6024.59051271074,6023.643779491817,6022.698647506703,6021.755110521354,
	6020.813162341218,6019.872796811423,6018.9340078152245,6017.996789274107,6017.061135148469,
	6016.127039435473,6015.194496169652,6014.263499422946,6013.334043304095,6012.406121958194,
	6011.479729566176,6010.5548603442985,6009.631508546065,6008.70966845847,6007.789334403828,
	6006.870500739548,6005.953161856616,6005.037312180759,6004.122946171126,6003.210058319831,
	6002.2986431533855,6001.388695229994,6000.4802091407455,5999.5731795103175,5998.667600993085,
	5997.7634682779935,5996.860776083569,5995.9595191603885,5995.05969228971,5994.161290284709,
	5993.264307987686,5992.368740271946,5991.474582040806,5990.581828229857,5989.690473796562,
	5988.80051373608,5987.911943069007,5987.024756845391,5986.138950144358,5985.254518072763,
	5984.371455765351,5983.489758385724,5982.609421124898,5981.730439201273,5980.852807860522,
	5979.976522375045,5979.101578045072,5978.227970196808,5977.355694183095,5976.484745383196,
	5975.6151192020725,5974.746811070167,5973.879816445007,5973.014130803719,5972.149749662938,
	5971.286668550099,5970.424883021586,5969.5643886599,5968.705181071499,5967.847255886791,
	5966.990608760502,5966.135235370658,5965.281131420697,5964.428292635804,5963.576714765824,
	5962.726393582047,5961.877324880861,5961.029504480578,5960.182928202951,5959.337591969692,
	5958.493491607986,5957.650623045485,5956.808982212774,5955.9685650611955,5955.1293675643155,
	5954.291385717853,5953.454615537046,5952.619053060638,5951.784694346778,5950.951535475975,
	5950.1195725472735,5949.288801682615,5948.459219022441,5947.630820729393,5946.803602983568,
	5945.97756198991,5945.152693967645,5944.328995158439,5943.50646185735,5942.685090242411,
	5941.8648767158065,5941.045817562271,5940.2279091184555,5939.411147741981,5938.595529808483,
	5937.781051711173,5936.967709862976,5936.155500694112,5935.344420654206,5934.534466210266,
	5933.725633846654,5932.917920066484,5932.111321390405,5931.3058343566945,5930.501455520188,
	5929.698181451922,5928.896008746603,5928.094934008888,5927.294953862785,5926.496064949939,
	5925.698263927655,5924.901547470161,5924.105912268884,5923.311355030291,5922.5178724785455,
	5921.725461352728,5920.934118409207,5920.143840419779,5919.354624170631,5918.566466466624,
	5917.7793641258,5916.993313982551,5916.208312886679,5915.4243577039715,5914.641445313773,
	5913.859572616764,5913.078736515076,5912.298933937201,5911.5201618240935,5910.7424171295515,
	5909.965696824032,5909.189997890706,5908.415317328339,5907.64165214974,5906.868999380875,
	5906.097356063996,5905.326719253135,5904.557086017652,5903.788453440436,5903.020818617729,
	5902.254178660082,5901.4885306911365,5900.723871847648,5899.9601992814605,5899.197510156553,
	5898.435801648589,5897.675070949327,5896.91531526169,5896.15653180219,5895.398717800208,
	5894.641870497982,5893.885987149444,5893.131065023242,5892.377101398515,5891.624093567798,
	5890.8720388365755,5890.120934521606,5889.370777952446,5888.621566470946,5887.873297429844,
	5887.125968196186,5886.379576146789,5885.634118671225,5884.889593171199,5884.145997059423,
	5883.40332775995,5882.661582710186,5881.920759356975,5881.180855159918,5880.441867588443,
	5879.703794125756,5878.966632264356,5878.2303795075195,5877.495033371406,5876.760591381443,
	5876.027051075334,5875.294410000862,5874.562665716658,5873.83181579212,5873.101857807571,
	5872.37278935405,5871.644608032875,5870.917311454905,5870.190897243893,5869.465363031028,
	5868.740706459297,5868.01692518278,5867.294016863723,5866.571979175939,5865.8508098022485,
	5865.130506436613,5864.4110667817495,5863.692488551108,5862.974769467674,5862.257907263911,
	5861.541899682134,5860.82674447451,5860.1124394022645,5859.398982236353,5858.686370758366,
	5857.974602756805,5857.263676031966,5856.553588391658,5855.844337653883,5855.135921647492,
	5854.428338205279,5853.721585173588,5853.015660407473,5852.310561768638,5851.606287130711,
	5850.902834373892,5850.200201387446,5849.498386070689,5848.7973863309235,5848.097200083319,
	5847.397825252235,5846.699259771926,5846.001501582861,5845.304548635263,5844.608398888165,
	5843.91305030781,5843.218500868933,5842.524748555404,5841.83179135953,5841.13962727724,
	5840.44825432229,5839.757670507993,5839.067873858633,5838.378862405717,5837.690634189943,
	5837.003187259087,5836.316519668181,5835.630629481611,5834.94551477047,5834.261173613703,
	5833.57760409805,5832.894804318166,5832.2127723761305,5831.5315063812295,5830.851004450642,
	5830.171264708964,5829.492285287421,5828.814064326705,5828.13659997312,5827.459890379828,
	5826.783933709103,5826.108728129198,5825.4342718159,5824.760562952249,5824.087599727561,
	5823.415380339438,5822.743902991753,5822.073165896389,5821.403167270164,5820.733905339238,
	5820.065378334249,5819.397584494566,5818.73052206611,5818.064189299823,5817.398584456553,
	5816.733705801065,5816.0695516056085,5815.406120149113,5814.743409718164,5814.081418603791,
	5813.420145105172,5812.759587527442,5812.099744182239,5811.440613387538,5810.782193467936,
	5810.124482754328,5809.467479583351,5808.811182298644,5808.15558925,5807.5006987931065,
	5806.846509290437,5806.193019109683,5805.540226625097,5804.888130217199,5804.236728273295,
	5803.586019184219,5802.936001349864,5802.286673174047,5801.638033067625,5800.9900794464575,
	5800.342810732568,5799.696225354494,5799.05032174554,5798.405098346055,5797.760553600009,
	5797.116685959823,5796.473493882105,5795.830975827995,5795.18913026685,5794.547955671852,
	5793.90745052233,5793.267613303261,5792.628442504346,5791.989936621852,5791.352094157297,
	5790.714913617003,5790.078393512544,5789.442532362391,5788.807328688936,5788.172781019891,
	5787.538887889398,5786.905647836344,5786.273059403675,5785.641121141589,5785.009831604766,
	5784.379189351336,5783.749192947399,5783.119840962443,5782.491131970499,5781.863064552483,
	5781.235637293385,5780.608848783127,5779.982697616555,5779.357182393824,5778.732301720111,
	5778.108054205076,5777.4844384634325,5776.861453115096,5776.2390967844,5775.617368100313,
	5774.996265697293,5774.375788214433,5773.755934294842,5773.136702587593,5772.518091745184,
	5771.900100425037,5771.282727290852,5770.665971008386,5770.049830250212,5769.434303691929,
	5768.819390014631,5768.20508790463,5767.591396050273,5766.978313146267,5766.3658378921045,
	5765.753968991551,5765.1427051517685,5764.5320450849085,5763.921987507567,5763.312531141423,
	5762.703674711386,5762.095416946584,5761.487756582173,5760.880692356277,5760.274223010109,
	5759.668347292631,5759.063063953212,5758.45837174777,5757.854269436324,5757.250755782217,
	5756.647829552537,5756.045489519733,5755.443734460414,5754.842563154047,5754.241974385338,
	5753.641966942131,5753.042539617972,5752.443691208006,5751.845420512617,5751.247726336721,
	5750.650607489091,5750.054062780306,5749.458091028982,5748.862691053212,5748.267861677651,
	5747.673601731196,5747.079910043934,5746.486785452782,5745.894226796031,5745.302232918069,
	5744.710802665481,5744.119934888389,5743.529628441964,5742.939882184568,5742.350694978995,
	5741.762065688938,5741.173993185518,5740.586476339977,5739.999514031024,5739.413105138118,
	5738.827248545184,5738.241943140184,5737.65718781321,5737.072981460913,5736.489322979488,
	5735.906211271697,5735.323645243205,5734.74162380188,5734.160145861087,5733.579210336071,
	5732.9988161460515,5732.418962214455,5731.8396474672045,5731.260870832847,5730.6826312455405,
	5730.104927641872,5729.527758959891,5728.951124144445,5728.375022141181,5727.799451900961,
	5727.224412374965,5726.649902519724,5726.075921296355,5725.502467665131,5724.929540595574,
	5724.35713905549,5723.7852620169115,5723.213908456447,5722.643077353478,5722.072767688958,
	5721.5029784494345,5720.933708623054,5720.36495720061,5719.796723178758,5719.22900555383,
	5718.661803326878,5718.095115504271,5717.528941089469,5716.96327909598,5716.398128532368,
	5715.833488421466,5715.269357778991,5714.705735627805,5714.142620994867,5713.580012905841,
	5713.017910392936,5712.4563124916,5711.8952182375515,5711.334626671327,5710.7745368364485,
	5710.214947778361,5709.655858546507,5709.097268192415,5708.53917577006,5707.981580337614,
	5707.42448095567,5706.867876686559,5706.311766596883,5705.756149755885,5705.201025233205,
	5704.646392105088,5704.092249448881,5703.538596343317,5702.985431871257,5702.432755119045,
	5701.880565174388,5701.3288611274775,5700.7776420729815,5700.226907106056,5699.676655326834,
	5699.126885836087,5698.577597738381,5698.028790141447,5697.480462152889,5696.932612887848,
	5696.385241457637,5695.838346982668,5695.291928581635,5694.745985378192,5694.200516495762,
	5693.655521064095,5693.110998212473,5692.566947074283,5692.023366783591,5691.480256479285,
	5690.93761530294,5690.395442396233,5689.853736905778,5689.312497977507,5688.77172476287,
	5688.231416414834,5687.691572089287,5687.152190943563,5686.613272137281,5686.07481483439,
	5685.536818199166,5684.999281397932,5684.462203602801,5683.92558398436,5683.389421718084,
	5682.853715981188,5682.318465950956,5681.783670811361,5681.249329745734,5680.7154419403705,
	5680.182006584062,5679.649022867304,5679.116489984692,5678.584407129889,5678.052773502747,
	5677.521588301412,5676.99085073016,5676.460559993026,5675.930715295634,5675.4013158489815,
	5674.872360864254,5674.343849553685,5673.815781133553,5673.288154822823,5672.760969841059,
	5672.234225411084,5671.7079207572915,5671.182055105243,5670.656627685588,5670.131637729052,
	5669.607084468933,5669.082967137992,5668.559284977999,5668.03603722565,5667.513223123744,
	5666.990841915397,5666.4688928473815,5665.947375166337,5665.426288124064,5664.905630971935,
	5664.385402963416,5663.865603355826,5663.346231407387,5662.827286377673,5662.308767530594,
	5661.790674128295,5661.273005439093,5660.755760731177,5660.23893927374,5659.722540340604,
	5659.2065632046815,5658.691007144372,5658.175871436185,5657.661155362663,5657.146858203377,
	5656.632979244145,5656.119517771435,5655.606473072325,5655.093844437119,5654.581631158469,
	5654.069832529208,5653.558447846389,5653.047476406283,5652.536917509489,5652.026770457334,
	5651.517034552897,5651.007709100619,5650.49879340853,5649.990286785941,5649.482188542284,
	5648.974497991396,5648.467214446887,5647.960337225288,5647.453865644564,5646.947799024855,
	5646.4421366885745,5645.93687795768,5645.43202215865,5644.927568616823,5644.4235166629305,
	5643.919865628171,5643.416614843808,5642.913763643751,5642.411311364803,5641.909257343415,
	5641.407600919168,5640.906341435141,5640.405478232816,5639.905010656284,5639.404938052737,
	5638.905259769968,5638.40597515864,5637.907083567991,5637.408584352959,5636.910476868749,
	5636.4127604703535,5635.915434516596,5635.418498367189,5634.921951384253,5634.425792930463,
	5633.930022371023,5633.434639071249,5632.93964240151,5632.445031729212,5631.950806427268,
	5631.456965867988,5630.963509425082,5630.470436477006,5629.977746399695,5629.4854385732,
	5628.993512378723,5628.501967198559,5628.010802416596,5627.520017420002,5627.029611593439,
	5626.539584328395,5626.049935014651,5625.5606630433585,5625.071767808931,5624.583248705287,
	5624.095105130847,5623.607336482206,5623.11994215987,5622.632921564079,5622.146274097999,
	5621.65999916753,5621.174096176117,5620.6885645320335,5620.203403643243,5619.718612920508,
	5619.234191777086,5618.750139622892,5618.266455874888,5617.78313994907,5617.300191260982,
	5616.817609232982,5616.335393282254,5615.853542833167,5615.3720573076225,5614.890936131185,
	5614.4101787301415,5613.929784531346,5613.449752965524,5612.970083461442,5612.4907754508395,
	5612.011828369651,5611.533241649323,5611.0550147282875,5610.577147043822,5610.099638033111,
	5609.622487138956
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	29779.50573099651,29662.13798276357,29545.626172947515,29429.961483696403,29315.135213104808,
	29201.138773390576,29087.96368909349,28975.60159531589,28864.04423599215,28753.283462187384,
	28643.31123042979,28534.119601072856,28425.700736685027,28318.04690046924,28211.15045471081,
	28105.003859255474,27999.59967000875,27894.930537467877,27790.98920527572,27687.768508803554,
	27585.261373755475,27483.460814799346,27382.35993422299,27281.951920610318,27182.230047544705,
	27083.18767233132,26984.818234744693,26887.115255795055,26790.072336520218,26693.683156794355,
	26597.941474157502,26502.841122669903,26408.376011778764,26314.540125212203,26221.327519884144,
	26128.732324825523,26036.748740127605,25945.371035907036,25854.593551287147,25764.410693394842,
	25674.816936378535,25585.80682043689,25497.374950871417,25409.515997145016,25322.224691966778,
	25235.495830384094,25149.324268893684,25063.704924566915,24978.632774188743,24894.102853411438,
	24810.110255920972,24726.650132621722,24643.71769082713,24561.308193469784,24479.416958322243,
	24398.039357230427,24317.170815358397,24236.806810448717,24156.94287209035,24077.574581003966,
	23998.697568331714,23920.30751494547,23842.400150760124,23764.971254064134,23688.016650853897,
	23611.532214184583,23535.51386352769,23459.957564140954,23384.859326446665,23310.215205419714,
	23236.021299988708,23162.273752440564,23088.968747840132,23016.10251345512,22943.671318192595,
	22871.671472041828,22800.099325528587,22728.951269174224,22658.223732969043,22587.91318584502,
	22518.01613516676,22448.52912622215,22379.448741723976,22310.771601322565,22242.494361117562,
	22174.61371318654,22107.126385112773,22040.02913952744,21973.318773652038,21906.992118852297,
	21841.04604019662,21775.477436023713,21710.283237512478,21645.460408262566,21581.005943878434,
	21516.916871562036,21453.19024970832,21389.823167510614,21326.812744568786,21264.15613050407,
	21201.85050458125,21139.893075333304,21078.28108019533,21017.011785139613,20956.082484320486,
	20895.490499720552,20835.23318080424,20775.307904176443,20715.712073245417,20656.443117889492,
	20597.498494131913,20538.87568381706,20480.57219429189,20422.58555809541,20364.913332646942,
	20307.553099943623,20250.502466259808,20193.759061851393,20137.320540665063,20081.184580049783,
	20025.348880474816,19969.81116524976,19914.56918024928,19859.620693642868,19804.963495625037,
	19750.595398154004,19696.514234690738,19642.71785994155,19589.204149606947,19535.97100013072,
	19483.01632845522,19430.338071778628,19377.934187315957,19325.802652062786,19273.94146256363,
	19222.348634681402,19171.022203373457,19119.96022246595,19069.16076443561,19018.621920192014,
	18968.341798864793,18918.318527590076,18868.55025130535,18819.03513254132,18769.77135122155,
	18720.757104461092,18671.99060636997,18623.47008785827,18575.19379644487,18527.159996067712,
	18479.366966896792,18431.813005150416,18384.4964229134,18337.41554795627,18290.56872356066,
	18243.954308342814,18197.570676081177,18151.4162155477,18105.489330338394,18059.788438709296,
	18014.311973411244,17969.058381530143,17924.02612432714,17879.21367708058,17834.61952893292,
	17790.242182736114,17746.080154900566,17702.13197524691,17658.396186858397,17614.87134593507,
	17571.556021651442,17528.44879601433,17485.548263722245,17442.85303202937,17400.361720607736,
	17358.072961413473,17315.985398553654,17274.097688156216,17232.408498239314,17190.91650858449,
	17149.62041060956,17108.518907245732,17067.610712812846,17026.89455289914,16986.36916424056,
	16946.03329460322,16905.885702665953,16865.925157904698,16826.15044047907,16786.560341119213,
	16747.15366101483,16707.92921170565,16668.885814972302,16630.022302729998,16591.337516922347,
	16552.830309416247,16514.499541899837,16476.344085780365,16438.36282208228,16400.5546413492,
	16362.918443545022,16325.453137956563,16288.15764309879,16251.030886618975,16214.07180520332,
	16177.279344485087,16140.652458953064,16104.190111860906,16067.891275138485,16031.754929303714,
	15995.780063375452,15959.965674787885,15924.310769304717,15888.814360936525,15853.475471856482,
	15818.293132319708,15783.266380581157,15748.394262816379,15713.67583304225,15679.110153038588,
	15644.696292271174,15610.433327815443,15576.320344281283,15542.356433737943,15508.540695640851,
	15474.87223675876,15441.350171101369,15407.973619848788,15374.741711281225,15341.653580709022,
	15308.708370404544,15275.905229533611,15243.243314089359,15210.721786825183,15178.33981718922,
	15146.096581260268,15113.991261682764,15082.023047603876,15050.191134610786,15018.49472466961,
	14986.93302606326,14955.505253330592,14924.210627207762,14893.048374568605,14862.017728365961,
	14831.117927574438,14800.348217132041,14769.70784788536,14739.196076532287,14708.812165567635,
	14678.555383227802,14648.4250034378,14618.420305756417,14588.540575324503,14558.785102812495,
	14529.153184368328,14499.644121567135,14470.257221359769,14440.99179602379,14411.847163113132,
	14382.822645410042,14353.917570876407,14325.131272605844,14296.463088776454,14267.91236260432,
	14239.478442296979,14211.160681007972,14182.958436791116,14154.871072556141,14126.897956024579,
	14099.038459685182,14071.291960751429,14043.657841118578,14016.13548732047,13988.724290488757,
	13961.423646310575,13934.232954987814,13907.151621196364,13880.179054046563,13853.314667041828,
	13826.557878041845,13799.908109221396,13773.364787032839,13746.927342168552,13720.595209521895,
	13694.367828151002,13668.244641241761,13642.22509607093,13616.308643970293,13590.494740291026,
	13564.782844368012,13539.172419485252,13513.66293284062,13488.25385551229,13462.944662424661,
	13437.73483231441,13412.623847697554,13387.611194836933,13362.696363708812,13337.878847972072,
	13313.158144934412,13288.533755522963,13264.005184251298,13239.57193918961,13215.23353193413,
	13190.98947757612,13166.83929467247,13142.782505216133,13118.818634606829,13094.947211621164,
	13071.167768385292,13047.479840345344,13023.882966239502,13000.376688070535,12976.960551077951,
	12953.634103710176,12930.396897598386,12907.24848752936,12884.188431418599,12861.216290284709,
	12838.331628223028,12815.534012379887,12792.82301292755,12770.198203038546,12747.659158860713,
	12725.205459492989,12702.836686960474,12680.55242619009,12658.352264987285,12636.235794011694,
	12614.202606753444,12592.252299510737,12570.384471365613,12548.598724162546,12526.894662484205,
	12505.271893630477,12483.730027595448,12462.268677045537,12440.887457298664,12419.58598630107,
	12398.363884607566,12377.22077535951,12356.156284263934,12335.170039573462,12314.261672065299,
	12293.430815020607,12272.67710420527,12252.000177849095,12231.39967662674,12210.875243637618,
	12190.426524386916,12170.053166766309,12149.754821034858,12129.531139800247,12109.381778000352,
	12089.306392884399,12069.304643995121,12049.37619315028,12029.520704424685,12009.737844132691,
	11990.027280810515,11970.388685198865,11950.821730225154,11931.326090987302,11911.901444735597,
	11892.54747085711,11873.26385085819,11854.050268348376,11834.906409023577,11815.831960650728,
	11796.82661305104,11777.890058084198,11759.02198963314,11740.222103587275,11721.49009782874,
	11702.825672215782,11684.228528567592,11665.698370650112,11647.234904160343,11628.837836712033,
	11610.506877821037,11592.241738890094,11574.042133195786,11555.90777587304,11537.83838390163,
	11519.833676092181,11501.89337307218,11484.017197272084,11466.204872912345,11448.45612598913,
	11430.770684261257,11413.148277237378,11395.58863616191,11378.091494003123,11360.656585439201,
	11343.283646846252,11325.972416285267,11308.722633489611,11291.53403985244,11274.406378414662,
	11257.339393852359,11240.332832465145,11223.3864421634,11206.499972457128,11189.673174443662,
	11172.905800796323,11156.197605752046,11139.548345101111,11122.957776174315,11106.425657833017,
	11089.951750457147,11073.53581593364,11057.17761764698,11040.876920466531,11024.633490736784,
	11008.447096266278,10992.317506316875,10976.244491593383,10960.227824233096,10944.267277795045,
	10928.362627250448,10912.513648971393,10896.720120721815,10880.98182164702,10865.298532263321,
	10849.670034448916,10834.096111433628,10818.576547789045,10803.111129419842,10787.69964355281,
	10772.34187872856,10757.037624791496,10741.78667288075,10726.588815421057,10711.44384611324,
	10696.351559925435,10681.311753083979,10666.32422306439,10651.38876858259,10636.505189586025,
	10621.673287245205,10606.892863944673,10592.16372327486,10577.48567002273,10562.858510164604,
	10548.282050856658,10533.756100427281,10519.28046836845,10504.854965327533,10490.479403099733,
	10476.15359461928,10461.877353952,10447.650496286915,10433.472837928986,10419.344196290625,
	10405.264389884505,10391.233238315399,10377.25056227306,10363.31618352431,10349.4299249057,
	10335.591610315769,10321.801064708101,10308.058114083362,10294.362585482968,10280.714306980877,
	10267.113107676794,10253.55881768927,10240.051268148414,10226.590291188902,10213.175719942958,
	10199.8073885334,10186.48513206734,10173.208786628178,10159.978189270363,10146.793178011223,
	10133.653591825538,10120.559270638041,10107.510055317327,10094.505787668844,10081.546310429307,
	10068.631467259316,10055.761102737588,10042.935062354247,10030.153192504773,10017.41534048372,
	10004.721354478379,9992.071083562763,9979.464377691429,9966.901087693344,9954.381065265981,
	9941.90416296918,9929.470234219256,9917.07913328313,9904.730715272452,9892.424836137565,
	9880.161352661939,9867.940122456286,9855.761003953136,9843.62385640057,9831.528539856963,
	9819.474915185478,9807.462844048236,9795.49218890067,9783.56281298648,9771.67458033178,
	9759.827355739524,9748.021004784927,9736.255393808826,9724.530389913369,9712.845860956282,
	9701.201675545793,9689.597703034962,9678.033813517097,9666.509877819883,9655.025767500803,
	9643.581354841832,9632.176512844057,9620.811115222928,9609.485036403197,9598.198151513818,
	9586.950336382908,9575.741467532946,9564.571422175677,9553.440078207203,9542.347314203358,
	9531.2930094146,9520.277043761114,9509.299297828355,9498.359652861714,9487.457990762348,
	9476.59419408206,9465.768146018765,9454.979730411605,9444.228831736364,9433.515335100878,
	9422.839126240468,9412.200091512937,9401.59811789446,9391.033092974658,9380.50490495227,
	9370.013442630381,9359.558595412034,9349.140253295755,9338.758306871128,9328.412647313888,
	9318.10316638203,9307.829756410965,9297.592310309306,9287.390721554282,9277.224884187508,
	9267.094692810391,9257.000042579855,9246.940829204052,9236.91694893784,9226.928298578572,
	9216.974775461485,9207.056277455818,9197.17270296015,9187.323950898039,9177.50992071402,
	9167.73051236904,9157.98562633626,9148.275163596742,9138.599025635025,9128.957114435238,
	9119.349332476337,9109.77558272816,9100.235768646951,9090.729794171237,9081.25756371735,
	9071.81898217541,9062.413954904785,9053.042387730047,9043.704186936462,9034.399259265692,
	9025.127511911905,9015.888852516808,9006.683189165957,8997.510430384065,8988.370485130825,
	8979.263262796312,8970.188673197246,8961.146626571895,8952.137033576095,8943.159805278889,
	8934.214853158055,8925.3020890954,8916.421425372977,8907.572774667711,8898.7560500479,
	8889.971164967916,8881.21803326414,8872.496569150195,8863.806687212431,8855.148302405443,
	8846.521330047037,8837.925685814116,8829.36128573739,8820.828046197326,8812.325883918526,
	8803.854715965781,8795.414459738557,8787.005032966399,8778.626353703956,8770.27834032606,
	8761.960911522485,8753.67398629308,8745.417483942458,8737.191324075013,8728.995426589485,
	8720.829711673516,8712.694099798759,8704.588511714914,8696.51286844456,8688.467091277416,
	8680.451101764707,8672.464821713424,8664.508173180617,8656.581078467216,8648.683460112481,
	8640.815240887407,8632.976343789047,8625.166692033907,8617.386209051627,8609.634818478597,
	8601.912444151269,8594.219010099594,8586.554440539872,8578.918659868226,8571.311592653066,
	8563.733163628378,8556.183297685822,8548.661919867627,8541.168955358811,8533.70432947926,
	8526.26796767594,8518.859795514569,8511.479738671507,8504.127722925043,8496.80367414668,
	8489.507518292625,8482.239181394238,8474.998589548888,8467.785668910652,8460.600345680166,
	8453.442546094897,8446.312196418841,8439.20922293224,8432.133551920337,8425.08510966283,
	8418.0638224224,8411.069616433037,8404.10241788814,8397.162152928442,8390.248747629335,
	8383.362127987895,8376.502219909906,8369.668949195891,8362.862241527442,8356.08202245269,
	8349.328217371327,8342.600751519769,8335.899549955233,8329.22453753961,8322.575638923101,
	8315.952778526935,8309.355880525827,8302.784868829915,8296.239667066087,8289.720198558736,
	8283.226386310133,8276.758152979692,8270.315420863342,8263.898111871542,8257.506147506916,
	8251.139448841543,8244.797936492645,8238.481530598625,8232.190150793305,8225.923716180096,
	8219.682145305002,8213.465356128738,8207.273265998092,8201.10579161633,8194.962849012658,
	8188.844353510573,8182.750219695275,8176.680361380179,8170.634691571884,8164.613122434637,
	8158.615565253003,8152.641930393841,8146.692127266377,8140.7660642819965,8134.863648811404,
	8128.984787141547,8123.129384430547,8117.297344661011,8111.488570592076,8105.702963710108,
	8099.940424177089,8094.200850777828,8088.484140865445,8082.790190304683,8077.118893413645,
	8071.470142903591,8065.843829816689,8060.239843461671,8054.658071347645,8049.098399115267,
	8043.560710466287,8038.044887090176,8032.5508085888605,8027.0783523986875,8021.627393710236,
	8016.197805385093,8010.789457870399,8005.402219110279,8000.0359544549165,7994.690526566352,
	7989.365795321556,7984.0616177122865,7978.777847742195,7973.514336320226,7968.270931151384,
	7963.0474766235475,7957.843813691489,7952.65977975682,7947.4952085449795,7942.349929978095,
	7937.223770044614,7932.1165506647085,7927.0280895524465,7921.958200073575,7916.906691099773,
	7911.873366858463,7906.858026779399,7901.860465336337,7896.880471885285,7891.917830498074,
	7886.972319792636,7882.04371275817,7877.13177657702,7872.236272441902,7867.3569553694815,
	7862.493574009537,7857.645870450414,7852.813580020483,7847.996431086007,7843.194144844781,
	7838.406435116853,7833.633008131378,7828.8735623104885,7824.127788050026,7819.39536749761,
	7814.675974328091,7809.9692735166755,7805.274921110563,7800.592563998506,7795.921839679887,
	7791.2623760326305,7786.613791081308,7781.975692765449,7777.347678709163,7772.729335991662,
	7768.120240922175,7763.519958814817,7758.928043770411,7754.344038461729,7749.767473925138,
	7745.197869358884,7740.634731929945,7736.077556589465,7731.52582589967,7726.979009871839,
	7722.436565818423,7717.897938219885,7713.362558608172,7708.829845468504,7704.299204161799,
	7699.77002686866,7695.241692558174,7690.71356698266,7686.185002701123,7681.655339134001,
	7677.123902649342,7672.590006688213,7668.052951925286,7663.512026471923,7658.9665061226815,
	7654.415654648602,7649.85872413934,7645.29495539824,7640.723578391782,7636.143812757657,
	7631.554868373463,7626.955945989125,7622.346237926203,7617.724928846219,7613.0911965912555,
	7608.444213098835,7603.78314539389,7599.10715665966,7594.415407389769,7589.707056622718,
	7584.981263261075,7580.237187475443,7575.473992194675,7570.690844682233,7565.886918198834,
	7561.061393750424,7556.213461920871,7551.342324786591,7546.447197912317,7541.527312423449,
	7536.581917152274,7531.610280853259,7526.611694482497,7521.585473535127,7516.530960434216,
	7511.447526963701,7506.334576736805,7501.191547690909,7496.01791459952,7490.813191589801,
	7485.576934655069,7480.308744149775,7475.0082672544,7469.675200397119,7464.309291618004,
	7458.910342861874,7453.478212185492,7448.012815863592,7442.514130379291,7436.982194284182,
	7431.417109912847,7425.819044937304,7420.188233747779,7414.524978645749,7408.829650836471,
	7403.102691208977,7397.344610892807,7391.555991580675,7385.737485609505,7379.88981579146,
	7374.013774989756,7368.110225434857,7362.180097778241,7356.224389883165,7350.244165353372,
	7344.240551802251,7338.214738867171,7332.167975975881,7326.101569872566,7320.016881914093,
	7313.915325148139,7307.798361186232,7301.667496887214,7295.524280866717,7289.370299850674,
	7283.207174891086,7277.036557464019,7270.860125469586,7264.679579155157,7258.496636982921,
	7252.313031463157,7246.130504974613,7239.950805593382,7233.775682950909,7227.606884141531,
	7221.446149699095,7215.295209661454,7209.155779740516,7203.029557614221,7196.918219356189,
	7190.823416016451,7184.746770366568,7178.689873819411,7172.654283534024,7166.641519712953,
	7160.6530630990155,7154.690352676249,7148.754783578871,7142.847705209775,7136.970419569561,
	7131.124179795784,7125.3101889091395,7119.529598765151,7113.783509205637,7108.072967405744,
	7102.398967409734,7096.762449848807,7091.164301833543,7085.60535701226,7080.086395787072,
	7074.608145678161,7069.171281826765,7063.776427627886,7058.424155482063,7053.114987656971,
	7047.849397249211,7042.627809236078,7037.450601608109,7032.318106573106,7027.230611822801,
	7022.188361852603,7017.191559327317,7012.24036648347,7007.334906561655,7002.475265260802,
	6997.6614922088365,6992.893602441332,6988.171577884481,6983.495368835271,6978.86489543471,
	6974.28004912835,6969.740694112015,6965.246668756273,6960.797787008132,6956.3938397662605,
	6952.0345962275005,6947.719805201023,6943.449196390321,6939.222481638806,6935.039356140441,
	6930.8994996111605,6926.802577422985,6922.748241698526,6918.736132366071,6914.765878174418,
	6910.83709766873,6906.949400125671,6903.102386449782,6899.295650030412,6895.528777559914,
	6891.801349814439,6888.112942396348,6884.4631264412965,6880.851469288771,6877.277535118196,
	6873.740885550929,6870.2410802219765,6866.777677307803,6863.350234047501,6859.958307209646,
	6856.601453542606,6853.279230195142,6849.991195110128,6846.736907392369,6843.515927652686,
	6840.327818327879,6837.172143978405,6834.048471564739,6830.956370703148,6827.89541390176,
	6824.865176778419,6821.865238260572,6818.89518076838,6815.9545903820135,6813.043056993678,
	6810.160174445374,6807.305540650544,6804.478757716186,6801.679432025518,6798.907174337342,
	6796.161599860297,6793.442328319634,6790.748984014874,6788.081195868526,6785.438597466133,
	6782.820827088106,6780.227527735742,6777.658347148271,6775.112937814955,6772.5909569811,
	6770.092066647234,6767.615933564957,6765.162229226487,6762.730629850431,6760.320816363488,
	6757.932474377737,6755.565294164942,6753.218970627853,6750.893203267569,6748.587696149404,
	6746.302157864963,6744.036301493461,6741.789844559481,6739.562508990083,6737.354021069227,
	6735.164111391957,6732.992514815859,6730.838970412351,6728.703221416665,6726.585015176793,
	6724.4841031015885,6722.400240608605,6720.333187071375,6718.282705765275,6716.248563814971,
	6714.230532139333,6712.228385398118,6710.241901937459,6708.270863735385,6706.315056348154,
	6704.3742688555185,6702.448293807318,6700.536927169634,6698.639968271173,6696.757219750235,
	6694.888487501699,6693.033580624611,6691.192311370795,6689.364495092312,6687.5499501906215,
	6685.748498066741,6683.959963070123,6682.184172449037,6680.420956303315,6678.670147533249,
	6676.931581794124,6675.205097447511,6673.490535515059,6671.787739632817,6670.096556005407,
	6668.416833361434,6666.748422909032,6665.091178293101,6663.44495555169,6661.809613074335,
	6660.185011560158,6658.571013977206,6656.967485521781,6655.374293579518,6653.791307685658,
	6652.218399486944,6650.655442704276,6649.102313095166,6647.55888841719,6646.025048392525,
	6644.500674672692,6642.985650803384,6641.479862191136,6639.983196069642,6638.49554146653,
	6637.016789171835,6635.546831705509,6634.085563286788,6632.632879804163,6631.188678783923,
	6629.752859364257,6628.325322256421,6626.905969731143,6625.494705580647,6624.091435093189,
	6622.696065027654,6621.308503585983,6619.9286603879555,6618.556446445409,6617.191774137992,
	6615.834557187584,6614.484710635834,6613.142150819583,6611.806795347924,6610.478563079897,
	6609.157374101822,6607.843149706399,6606.535812370358,6605.235285733923,6603.941494580331,
	6602.654364812645,6601.373823445554,6600.099798568577,6598.832219338237,6597.571015957846,
	6596.316119657587,6595.067462676926,6593.824978248277,6592.588600577749,6591.35826482939,
	6590.133907108895,6588.915464446039,6587.7028747795175,6586.496076941332,6585.295010640712,
	6584.0996164502585,6582.909835789482,6581.725610911661,6580.546884888674,6579.373601598059,
	6578.2057057080065,6577.043142664607,6575.8858586789465,6574.73380071368,6573.586916470385,
	6572.445154377323,6571.308463576831,6570.1767939138,6569.050095923818,6567.928320821017,
	6566.81142048785,6565.699347462898,6564.592054930744,6563.48949671043,6562.391627246333,
	6561.2984015964485,6560.209775422753,6559.125704982081,6558.046147115058,6556.971059237435,
	6555.90039933085,6554.834125932168,6553.772198127275,6552.714575538971,6551.661218320286,
	6550.612087146108,6549.567143203028,6548.5263481833645,6547.489664274949,6546.457054155102,
	6545.428480981563,6544.403908385079,6543.3833004627395,6542.366621769447,6541.353837311089,
	6540.344912538333,6539.339813338319,6538.33850602837,6537.34095734961,6536.347134460106,
	6535.357004928037,6534.37053672581,6533.387698223904,6532.408458183912,6531.432785754128,
	6530.460650461292,6529.492022206865,6528.526871260868,6527.565168255123,6526.606884179064,
	6525.651990373639,6524.700458526773,6523.7522606665725,6522.807369157899,6521.865756696432,
	6520.927396303976,6519.99226132346,6519.060325414306,6518.131562547336,6517.205947001223,
	6516.283453355923,6515.364056490956,6514.447731578681,6513.534454080822,6512.624199744879,
	6511.716944598827,6510.812664947899,6509.911337369905,6509.012938712272,6508.117446086766,
	6507.224836866915,6506.335088683637,6505.44817942127,6504.564087215365,6503.682790446869,
	6502.804267741083,6501.928497961852,6501.055460209808,6500.185133819295,6499.317498352488,
	6498.45253360035,6497.590219574799,6496.730536509974,6495.873464855259,6495.018985275649,
	6494.167078646671,6493.317726051942,6492.470908780381,6491.6266083235605,6490.784806372683,
	6489.945484816168,6489.108625736223,6488.274211407385,6487.442224293009,6486.612647042524,
	6485.7854624899455,6484.960653650372,6484.1382037181975,6483.318096064239,6482.500314233928,
	6481.684841944298,6480.871663082281,6480.060761702447,6479.252122023765,6478.445728429432,
	6477.641565462455,6476.839617825317,6476.039870376897,6475.242308130475,6474.446916252431,
	6473.653680059631,6472.862585017469,6472.073616738118,6471.286760978699,6470.502003639488,
	6469.719330761542,6468.938728525396,6468.160183249279,6467.383681387868,6466.60920952837,
	6465.836754391234,6465.066302828482,6464.297841819536,6463.531358472644,6462.7668400212315,
	6462.004273822908,6461.243647358192,6460.48494822866,6459.728164158432,6458.97328298177,
	6458.220292657742,6457.469181257651,6456.71993696698,6455.972548083834,6455.227003016543,
	6454.483290284346,6453.741398514269,6453.001316440231,6452.263032901986,6451.526536844392,
	6450.791817314963,6450.05886346323,6449.32766453932,6448.598209893647,6447.870488973979,
	6447.144491326671,6446.4202065923055,6445.697624507467,6444.976734899672,6444.257527697875,
	6443.539992912976,6442.824120650802,6442.10990110435,6441.397324557271,6440.686381379161,
	6439.977062026833,6439.269357041759,6438.5632570499565,6437.858752761455,6437.155834967107,
	6436.454494541161,6435.754722436961,6435.05650968813,6434.359847407126,6433.664726783031,
	6432.971139083552,6432.279075650966,6431.5885279036465,6430.89948733414,6430.211945507756,
	6429.525894064109,6428.841324712373,6428.158229234784,6427.47659948274,6426.796427377655,
	6426.11770490918,6425.440424135615,6424.7645771814105,6424.090156238117,6423.417153563641,
	6422.745561479067,6422.075372371607,6421.40657869129,6420.7391729508345,6420.073147725446,
	6419.408495651952,6418.745209427915,6418.083281810839,6417.422705618151,6416.763473726434,
	6416.105579069513,6415.449014640708,6414.793773488136,6414.139848718198,6413.48723349181,
	6412.835921026048,6412.185904592692,6411.537177516678,6410.889733177629,6410.243565007116,
	6409.598666489701,6408.955031161708,6408.31265261048,6407.671524474568,6407.031640442489,
	6406.392994252563,6405.755579692444,6405.119390598331,6404.484420854518,6403.850664393269,
	6403.218115193997,6402.586767282572,6401.956614731957,6401.327651659743,6400.699872229476,
	6400.073270650098,6399.447841173724,6398.82357809727,6398.200475761347,6397.578528548956,
	6396.957730886004,6396.338077241265,6395.719562123916,6395.10218008618,6394.485925719978,
	6393.870793658305,6393.25677857488,6392.643875181718,6392.032078231749,6391.42138251601,
	6390.811782864353,6390.2032741451185,6389.5958512641855,6388.989509164678,6388.384242828107,
	6387.780047271248,6387.176917547684,6386.5748487475485,6385.973835996689,6385.373874455606,
	6384.774959320282,6384.177085821605,6383.580249224588,6382.9844448281265,6382.38966796477,
	6381.795914000981,6381.203178336048,6380.611456402213,6380.020743663228,6379.431035616134,
	6378.842327789193,6378.254615742785,6377.667895067669,6377.082161386009,6376.4974103510385,
	6375.913637646138,6375.330838983981,6374.749010108156,6374.168146791866,6373.588244836184,
	6373.009300073075,6372.431308361431,6371.854265590352,6371.278167675515,6370.7030105621425,
	6370.128790221696,6369.555502654328,6368.983143886344,6368.4117099719615,6367.841196990874,
	6367.271601051357,6366.702918285411,6366.135144852133,6365.568276937928,6365.0023107520665,
	6364.437242530711,6363.873068535184,6363.309785050534,6362.747388387432,6362.185874881005,
	6361.625240889835,6361.0654827977305,6360.5065970105525,6359.948579959757,6359.391428098116,
	6358.835137903467,6358.2797058751,6357.725128535689,6357.171402431042,6356.618524128836,
	6356.066490218237,6355.515297311413,6354.964942041728,6354.415421064577,6353.866731056853,
	6353.3188687158945,6352.771830761117,6352.225613931841,6351.680214988933,6351.135630713367,
	6350.591857906685,6350.048893390138,6349.506734005567,6348.965376614053,6348.424818097089,
	6347.885055355393,6347.346085308392,6346.807904895607,6346.270511074983,6345.733900823708,
	6345.198071137839,6344.663019030575,6344.1287415359675,6343.59523570407,6343.0624986044395,
	6342.53052732404,6341.999318966903,6341.468870656238,6340.939179531926,6340.410242750861,
	6339.882057488023,6339.3546209350725,6338.827930300161,6338.301982808764,6337.776775703874,
	6337.252306242491,6336.728571700819,6336.205569370025,6335.683296557112,6335.161750585695,
	6334.640928795289,6334.120828540841,6333.601447192517,6333.082782137513,6332.564830776925,
	6332.047590527377,6331.5310588214925,6331.015233106444,6330.500110843008,6329.985689508891,
	6329.471966595399,6328.958939608697,6328.44660606844,6327.934963509884,6327.424009481444,
	6326.913741547634,6326.4041572841725,6325.895254282378,6325.387030146919,6324.879482496401,
	6324.372608962608,6323.86640719078,6323.360874840294,6322.856009583006,6322.351809104147,
	6321.848271102334,6321.34539328768,6320.843173385747,6320.341609132344,6319.840698277629,
	6319.340438583762,6318.840827824489,6318.341863787787,6317.843544272741,6317.345867090657,
	6316.848830064902,6316.352431031043,6315.856667837141,6315.361538342276,6314.867040417071,
	6314.3731719449115,6313.87993081983,6313.387314947662,6312.89532224605,6312.403950642765,
	6311.913198077836,6311.423062502525,6310.933541878903,6310.444634179612,6309.956337388542,
	6309.4686495009155,6308.981568521154,6308.495092466593,6308.00921936374,6307.523947249775,
	6307.039274172221,6306.555198189066,6306.071717369109,6305.588829790546,6305.10653354265,
	6304.624826724296,6304.143707443398,6303.663173819866,6303.183223981538,6302.703856067141,
	6302.225068224436,6301.746858614074,6301.269225398372,6300.792166756887,6300.31568087564,
	6299.839765950531,6299.364420186487,6298.889641798209,6298.4154290080905,6297.941780050005,
	6297.468693164686,6296.996166602899,6296.524198624674,6296.052787497979,6295.581931500157,
	6295.111628917626,6294.641878044407,6294.1726771845,6293.704024648759,6293.235918758528,
	6292.768357842094,6292.30134023423,6291.83486428615,6291.368928348655,6290.903530783887,
	6290.438669961597,6289.974344261005,6289.510552067984,6289.047291776239,6288.584561789448,
	6288.122360517059,6287.6606863775305,6287.199537796035,6286.738913206886,6286.278811050819,
	6285.819229777409,6285.360167842383,6284.901623709773,6284.443595851805,6283.98608274666,
	6283.529082881065,6283.072594749069,6282.616616850416,6282.161147694088,6281.706185795241,
	6281.251729676001,6280.797777866622,6280.344328903364,6279.891381330086,6279.438933696632,
	6278.986984561814,6278.535532488713,6278.08457604897,6277.634113820637,6277.184144387992,
	6276.73466634312,6276.2856782833505,6275.837178813285,6275.389166544951,6274.9416400948285,
	6274.4945980884095,6274.04803915477,6273.6019619324425,6273.156365063994,6272.711247198682,
	6272.266606993378,6271.822443109158,6271.378754215405,6270.935538985909,6270.492796101767,
	6270.050524249784,6269.60872212191,6269.1673884170805,6268.726521840907,6268.286121102734,
	6267.846184920081,6267.406712014761,6266.967701114713,6266.529150954646,6266.09106027376,
	6265.653427816875,6265.216252336262,6264.779532587627,6264.34326733397,6263.907455342993,
	6263.472095386896,6263.037186246214,6262.6027267042045,6262.16871555125,6261.735151582412,
	6261.3020335984575,6260.869360404244,6260.437130811764,6260.005343637437,6259.573997702799,
	6259.143091834027,6258.712624864848,6258.2825956309625,6257.853002974582,6257.4238457437295,
	6256.995122791067,6256.566832972841,6256.138975152895,6255.711548196852,6255.284550978628,
	6254.857982374992,6254.431841266917,6254.006126543313,6253.580837094248,6253.155971816268,
	6252.7315296111265,6252.307509384898,6251.883910047309,6251.460730514757,6251.037969707108,
	6250.61562654844,6250.193699968122,6249.772188899518,6249.351092281526,6248.930409056554,
	6248.510138171773,6248.090278578675,6247.670829234237,6247.251789098285,6246.8331571358485,
	6246.4149323159145,6245.9971136127815,6245.579700003713,6245.162690471201,6244.746084001956,
	6244.329879585556,6243.9140762175975,6243.498672896802,6243.083668627151,6242.669062414607,
	6242.254853271841,6241.841040213619,6241.427622259842,6241.014598434326,6240.601967763585,
	6240.18972928041,6239.777882019891,6239.3664250213005,6238.955357328761,6238.544677988982,
	6238.134386053581,6237.724480577626,6237.314960619854,6236.905825242913,6236.49707351407,
	6236.088704502556,6235.680717282459,6235.2731109336655,6234.8658845347745,6234.45903717295,
	6234.05256793586,6233.646475917209,6233.240760211724,6232.835419920402,6232.430454145961,
	6232.025861995133,6231.621642578647,6231.217795010667,6230.814318408946,6230.411211893909,
	6230.008474589951,6229.606105625029,6229.204104130691,6228.802469241768,6228.401200096552,
	6228.000295836589,6227.599755605612,6227.199578553533,6226.7997638305,6226.400310592548,
	6226.001217997555,6225.602485206354,6225.204111383853,6224.806095698127,6224.408437321193,
	6224.011135425886,6223.614189189475,6223.217597795099,6222.821360424398,6222.4254762645005,
	6222.029944505816,6221.634764342394,6221.239934969658,6220.845455587154,6220.451325397311,
	6220.0575436046975,6219.664109418824,6219.271022050973,6218.878280715218,6218.485884629507,
	6218.093833014163,6217.702125091579,6217.31076008833,6216.919737234549,6216.529055760963,
	6216.138714903855,6215.748713899114,6215.359051988853,6214.96972841668,6214.580742428097,
	6214.192093272365,6213.803780201327,6213.415802469695,6213.028159334605,6212.640850057364,
	6212.253873899755,6211.867230127421,6211.4809180086195,6211.094936815517,6210.709285821006,
	6210.3239643012685,6209.93897153578,6209.554306805534,6209.169969395018,6208.7859585918895,
	6208.402273684798,6208.0189139657,6207.635878730118,6207.253167274618,6206.870778898788,
	6206.48871290557,6206.106968599905,6205.725545287911,6205.344442280156,6204.963658888854,
	6204.583194428915,6204.203048217495,6203.823219573802,6203.443707820774,6203.064512282438,
	6202.685632284963,6202.307067159389,6201.928816236055,6201.550878849487,6201.173254336231,
	6200.795942035027,6200.418941286832,6200.0422514357615,6199.665871826523,6199.289801808107,
	6198.914040730255,6198.538587945619,6198.16344281009,6197.788604680203,6197.414072914372,
	6197.039846876171,6196.665925928596,6196.2923094375965,6195.918996771973,6195.545987301577,
	6195.173280399716,6194.800875440869,6194.42877180276,6194.056968863771,6193.685466005896,
	6193.3142626113895,6192.943358067224,6192.572751760944,6192.202443081484,6191.832431421541,
	6191.462716175156,6191.09329673763,6190.724172507589,6190.355342884941,6189.9868072721,
	6189.618565073317,6189.250615694452,6188.882958544702,6188.515593033052,6188.148518572954,
	6187.781734578933,6187.4152404651995,6187.049035651874,6186.683119558245,6186.317491606319,
	6185.9521512206275,6185.587097827129,6185.222330853666,6184.857849730171,6184.493653887448,
	6184.129742759824,6183.766115783066,6183.402772394269,6183.039712032226,6182.67693413867,
	6182.314438156155,6181.952223529679,6181.590289705677,6181.228636132884,6180.867262260816,
	6180.506167542635,6180.145351431562,6179.784813383045,6179.424552854751,6179.064569305853,
	6178.704862198194,6178.345430992967,6177.986275155501,6177.627394152611,6177.268787451006,
	6176.910454521245,6176.5523948347745,6176.194607864572,6175.837093084966,6175.479849972868,
	6175.122878006789,6174.766176666649,6174.409745433322,6174.053583790924,6173.697691223083,
	6173.342067217975,6172.9867112624,6172.631622847561,6172.276801463593,6171.922246604063,
	6171.567957764242,6171.213934440043,6170.860176129017,6170.506682330394,6170.153452546493,
	6169.800486278939,6169.447783032451,6169.09534231192,6168.743163626223,6168.391246483599,
	6168.039590393483,6167.688194869539,6167.337059424095,6166.986183573392,6166.6355668330825,
	6166.2852087211195,6165.935108757477,6165.585266462241,6165.2356813602,6164.886352973626,
	6164.537280827958,6164.188464451151,6163.839903372008,6163.491597118438,6163.143545223707,
	6162.795747220432,6162.448202641849,6162.100911024163,6161.7538719047325,6161.407084823155,
	6161.060549316953,6160.714264929189,6160.368231202978,6160.022447680148,6159.676913909317,
	6159.331629435292,6158.986593807923,6158.641806575383,6158.297267289863,6157.952975503345,
	6157.608930769403,6157.265132644432,6156.921580683486,6156.578274445412,6156.235213487889,
	6155.8923973728615,6155.549825662253,6155.207497917936,6154.8654137055355,6154.523572590025,
	6154.181974138626,6153.840617919713,6153.499503503019,6153.1586304620805,6152.8179983641585,
	6152.477606784808,6152.137455298312,6151.797543482454,6151.457870913095,6151.118437168856,
	6150.779241829329,6150.440284476651,6150.1015646912365,6149.763082057929,6149.4248361615055,
	6149.086826587159,6148.749052922069,6148.41151475451,6148.074211675721,6147.737143273878,
	6147.400309142932,6147.06370887387,6146.7273420630445,6146.391208301705,6146.055307193605,
	6145.719638333525,6145.384201319518,6145.048995752283,6144.714021233563,6144.379277365173,
	6144.044763750881,6143.710479995726,6143.376425706156,6143.042600487644,6142.709003949385,
	6142.375635701854,6142.042495353485,6141.709582516423,6141.376896804262,6141.04443782929,
	6140.712205207675,6140.380198555076,6140.048417487232,6139.71686162493,6139.385530585708,
	6139.0544239897545,6138.723541458867,6138.392882615333,6138.06244708319,6137.732234486452,
	6137.402244451912,6137.072476605463,6136.742930573412,6136.4136059870825,6136.084502475484,
	6135.755619669203,6135.426957199925,6135.098514702179,6134.770291807719,6134.442288152712,
	6134.114503373674,6133.786937106447,6133.459588990723,6133.132458663772,6132.805545767328,
	6132.4788499419765,6132.152370828369,6131.826108071145,6131.500061314477,6131.174230203255,
	6130.848614381968,6130.523213498978,6130.198027202181,6129.873055140077,6129.548296963005,
	6129.223752321787,6128.899420868291,6128.575302254375,6128.251396134896,6127.927702164269,
	6127.604219997088,6127.2809492916085,6126.9578897036145,6126.635040893723,6126.312402518833,
	6125.9899742404305,6125.667755720018,6125.345746618882,6125.023946600289,6124.702355328503,
	6124.380972468154,6124.0597976846175,6123.738830645289,6123.418071017488,6123.097518469178,
	6122.77717266935,6122.457033289917,6122.1371000006375,6121.817372472809,6121.497850381528,
	6121.178533398871,6120.859421198934,6120.54051345884,6120.221809853469,6119.903310061386,
	6119.585013759766,6119.266920627509,6118.949030344164,6118.631342591248,6118.313857048699,
	6117.996573400659,6117.679491328647,6117.362610518194,6117.045930651922,6116.729451416683,
	6116.413172499744,6116.097093587587,6115.781214367382,6115.465534530119,6115.150053763331,
	6114.834771759332,6114.51968820831,6114.204802802341,6113.890115235818,6113.575625200632,
	6113.261332392236,6112.947236506025,6112.633337237926,6112.319634285221,6112.00612734513,
	6111.692816115873,6111.379700297422,6111.066779589121,6110.754053692852,6110.441522309187,
	6110.1291851410715,6109.817041890547,6109.505092263165,6109.193335962344,6108.881772693437,
	6108.570402163646,6108.259224078478,6107.948238146279,6107.6374440756945,6107.326841575117,
	6107.016430356154
	}}
};
