/*
Copyright (C) 2002-2013  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.*/

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"

void gerepilelist(stack *s, stack *g, int savb)
{
  affnode *an=(affnode *) *stack_base(s);
  int i;
  for(i=0;i<s->n;i++)
  {
    int idx=an[i].idx;
    ctxvar *v=ctxstack+idx;
    int t=vartype(*v);
    if (ctype[t]!=Vgen || ((v->flag&(1<<Cconst)) && v->val!=-1))
      continue;
    /*If i is affected or referenced*/
    if (an[i].f==AFclone)
      stack_remove_int(g,v->node);
    else if (an[i].f!=AFaccess && an[i].f!=AFhide)
    {
      int j;
      /*search the first occurence of i*/
      for(j=0;j<i;j++)
        if (an[j].idx==idx)
          break;
      /*if the variable is local and the first occurence
        is an affectation, do nothing */
      if (an[j].idx>=savb &&  an[j].f==AFassign)
        continue;

      /*else check if it is not already in the list*/
      if (stack_has_int(g,v->node))
        continue;
      stack_push_int(g,v->node);
    }
  }
  stack_int_sort(g);
  if (debug)
  {
    int i;
    fprintf(stderr,"/*");
    for(i=0;i<s->n;i++)
      fprintf(stderr,"%s%s ",varstr(ctxstack[an[i].idx]),an[i].f==AFassigncompo?"=[]":an[i].f==AFassign?"=":"");
    fprintf(stderr,"*/\n");
  }
}

void pilelistvar(int idx)
{
  ctxvar *v=ctxstack+idx;
  if (v->flag&(1<<Carg))
    return;
  if (ctype[vartype(*v)]!=Vgen)
    return;
  if (v->initval>=0)
  {
    pilelist(v->initval);
    newaff(AFassign,idx);
  }
}

void pilelist(int n)
{
  int x,y;
  int savc;
  context *bl;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;
  switch(tree[n].f)
  {
  case Fassign:
    if (tree[x].f!=Fentry)
      pilelist(x);
    pilelist(y);
    x=getlvaluerr(x);
    if (ctype[tree[x].t]==Vgen && ctype[tree[y].t]==Vgen
       && (tree[detag(y)].m&(1<<Mcopy)))
    {
      int z=newnode(Ffunction,-1,-1);
      tree[z]=tree[y];
      tree[z].f=Ffunction;
      tree[z].x=newentry("copy");
      tree[z].y=y;
      tree[z].m=tree[y].m&MODHERIT;
      tree[n].y=z;
    }
    break;
  case Frefarg:
  case Findarg:
  case Ftag:
    pilelist(x);
    break;
  case Fconst:
  case Fsmall:
  case Fnoarg:
  case Fentry:
    break;
  case Ffunction:
    pilelist(y);
    break;
  case Fdeffunc:
    {
      int funcid=tree[n].x;
      const char *name=entryname(funcid);
      int savcf=currfunc;
      userfunc *uf;
      /*get func number and context*/
      currfunc=findfunction(name);
      uf=lfunc[currfunc].user;
      savc=s_ctx.n;
      pilelist(y);
      gerepilelist(&uf->v,&uf->g,uf->savb);
      currfunc=savcf;
    }
    break;
  case Fblock:
    savc=s_ctx.n;
    bl=block+tree[n].x;
    pushctx(bl);
    pilelist(y);
    if (bl->gc&(1<<GCneeded))
    {
      gerepilelist(&bl->v,&bl->g,bl->savb);
      if (bl->egc>=0)
      {
        int vret=getvar(bl->egc);
        ctxvar *v=ctxstack+vret;
        if (ctype[vartype(*v)]==Vgen && !stack_has_int(&bl->g,vret))
          stack_push_int(&bl->g,v->node);
      }
    }
    copyctx(savc,bl);
    s_ctx.n=savc;
    break;
  default:
    if (tree[n].f>=FneedENTRY)
      die(n,"Incorrect node %s in pilelist",funcname(tree[n].f));
    pilelist(x);
    pilelist(y);
  }
}
void pileclean(int n)
{
  int x,y;
  int savc,sava,savb;
  context *bl;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;
  switch(tree[n].f)
  {
  case Fassign:
    pileclean(x);
    pileclean(y);
    break;
  case Frefarg:
  case Findarg:
  case Ftag:
    pileclean(x);
    break;
  case Fconst:
  case Fsmall:
  case Fnoarg:
  case Fentry:
    break;
  case Ffunction:
    pileclean(y);
    break;
  case Fdeffunc:
    {
      int funcid=tree[n].x;
      const char *name=entryname(funcid);
      int savcf=currfunc;
      /*get func number and context*/
      currfunc=findfunction(name);
      pileclean(y);
      currfunc=savcf;
    }
    break;
  case Fblock:
    savc=s_ctx.n;
    sava=s_aff.n;
    bl=block+tree[n].x;
    pushctx(bl);
    savb=s_ctx.n;
    pileclean(y);
    if (bl->gc&(1<<GCglobal))
    {
      userfunc *ufunc=lfunc[currfunc].user;
      stack_int_merge(&bl->g,&ufunc->g);
      if (bl->g.n!=1)
        bl->gc&=~(1<<GCupto);
    }
    if ((bl->gc&(1<<GCneeded)) && (!bl->g.n || (bl->gc&(1<<GCupto))))
    {
      if (!(bl->gc&(1<<GCglobal)))
      {
        int w=getvarbyname("st_lim");
        if (w>=savc && w<savb)
          vartype(ctxstack[w])=Gvoid;
      }
    }
    if ((bl->gc&(1<<GCreturn)) &&
                  (bl->g.n==0 ||
                  (bl->g.n==1 && (bl->gc&(1<<GCupto))) ))
      tree[n].m|=(1<<Mbrace);
    copyctx(savc,bl);
    s_ctx.n=savc;
    s_aff.n=sava;
    break;
  default:
    if (tree[n].f>=FneedENTRY)
      die(n,"Incorrect node %s in pileclean",funcname(tree[n].f));
    pileclean(x);
    pileclean(y);
  }
}
