/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocUtils/EnumConvertersXml.h"
#include "Doc/CafCoreTypesDoc/CafCoreTypesDocTypes.h"

#include "Doc/CafCoreTypesDoc/CLoggingLevelElemDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/LoggingLevelElemXml.h"

using namespace Caf;

void LoggingLevelElemXml::add(
	const SmartPtrCLoggingLevelElemDoc loggingLevelElemDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("LoggingLevelElemXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(loggingLevelElemDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string componentVal =
			EnumConvertersXml::convertLoggingComponentTypeToString(loggingLevelElemDoc->getComponent());
		CAF_CM_VALIDATE_STRING(componentVal);
		thisXml->addAttribute("component", componentVal);

		const std::string levelVal =
			EnumConvertersXml::convertLoggingLevelTypeToString(loggingLevelElemDoc->getLevel());
		CAF_CM_VALIDATE_STRING(levelVal);
		thisXml->addAttribute("level", levelVal);
	}
	CAF_CM_EXIT;
}

SmartPtrCLoggingLevelElemDoc LoggingLevelElemXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("LoggingLevelElemXml", "parse");

	SmartPtrCLoggingLevelElemDoc loggingLevelElemDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string componentStrVal =
			thisXml->findRequiredAttribute("component");
		LOGGINGCOMPONENT_TYPE componentVal = LOGGINGCOMPONENT_NONE;
		if (! componentStrVal.empty()) {
			componentVal = EnumConvertersXml::convertStringToLoggingComponentType(componentStrVal);
		}

		const std::string levelStrVal =
			thisXml->findRequiredAttribute("level");
		LOGGINGLEVEL_TYPE levelVal = LOGGINGLEVEL_NONE;
		if (! levelStrVal.empty()) {
			levelVal = EnumConvertersXml::convertStringToLoggingLevelType(levelStrVal);
		}

		loggingLevelElemDoc.CreateInstance();
		loggingLevelElemDoc->initialize(
			componentVal,
			levelVal);
	}
	CAF_CM_EXIT;

	return loggingLevelElemDoc;
}

