/* This file is part of Zanshin

   Copyright 2014-2015 Kevin Ottens <ervin@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License or (at your option) version 3 or any later version
   accepted by the membership of KDE e.V. (or its successor approved
   by the membership of KDE e.V.), which shall act as a proxy
   defined in Section 14 of version 3 of the license.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
   USA.
*/

#ifndef TESTLIB_AKONADISTORAGETESTBASE_H
#define TESTLIB_AKONADISTORAGETESTBASE_H

#include "akonadi/akonadimonitorinterface.h"
#include "akonadi/akonadistorageinterface.h"

Q_DECLARE_METATYPE(Akonadi::StorageInterface::FetchDepth)

namespace Testlib {

class AkonadiStorageTestBase : public QObject
{
    Q_OBJECT
public:
    explicit AkonadiStorageTestBase(QObject *parent = nullptr);

protected:
    virtual Akonadi::StorageInterface::Ptr createStorage() = 0;
    virtual Akonadi::MonitorInterface::Ptr createMonitor() = 0;

private slots:
    void cleanupTestCase();

    void dumpTree();
    void shouldListCollections_data();
    void shouldListCollections();
    void shouldRetrieveAllCollectionAncestors();
    void shouldListFullItemsInACollection();
    void shouldNotifyCollectionAdded();
    void shouldNotifyCollectionRemoved();
    void shouldNotifyCollectionChanged();
    void shouldNotifyItemAdded();
    void shouldNotifyItemRemoved();
    void shouldNotifyItemChanged();
    void shouldReadDefaultCollectionFromSettings();

    // This test must be run before shouldCreateItem because createItem
    // sometimes notifies an itemChanged with a delay. So this test might
    // receive this notification in addition to the itemChanged generated by updateItem.
    void shouldUpdateItem();

    // This test must be run before shouldCreateItem because createItem
    // sometimes notifies an itemChanged with a delay. So this test might
    // receive this notification in addition to the itemChanged generated by updateItem.
    void shouldUseTransaction();

    void shouldCreateItem();
    void shouldRetrieveItem();
    void shouldMoveItem();
    void shouldMoveItems();
    void shouldDeleteItem();
    void shouldDeleteItems();
    void shouldUpdateCollection();
    void shouldNotifyCollectionTimestampChanges();
    void shouldNotifyCollectionSelectionChanges();

private:
    Akonadi::Item fetchItemByRID(const QString &remoteId, const Akonadi::Collection &collection);
    Akonadi::Collection fetchCollectionByRID(const QString &remoteId);

    Akonadi::Collection calendar1();
    Akonadi::Collection calendar2();
    Akonadi::Collection emails();
};

}

#endif // TESTLIB_AKONADISTORAGETESTBASE_H
