% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entrez_link.r
\name{entrez_link}
\alias{entrez_link}
\title{Get links to datasets related to records from an NCBI database}
\usage{
entrez_link(
  dbfrom,
  web_history = NULL,
  id = NULL,
  db = NULL,
  cmd = "neighbor",
  by_id = FALSE,
  config = NULL,
  ...
)
}
\arguments{
\item{dbfrom}{character Name of database from which the Id(s) originate}

\item{web_history}{a web_history object}

\item{id}{vector with unique ID(s) for records in database \code{db}.}

\item{db}{character Name of the database to search for links (or use "all" to 
search all databases available for \code{db}. \code{entrez_db_links} allows you
to discover databases that might have linked information (see examples).}

\item{cmd}{link function to use. Allowed values include
\itemize{
  \item neighbor (default). Returns a set of IDs in \code{db} linked to the
  input IDs in \code{dbfrom}.
  \item neighbor_score. As `neighbor'', but additionally returns similarity scores.
  \item neighbor_history. As `neighbor', but returns web history objects.
  \item acheck. Returns a list of linked databases available from NCBI for a set of IDs.
  \item ncheck. Checks for the existence of links within a single database.
  \item lcheck. Checks for external (i.e. outside NCBI) links.
  \item llinks. Returns a list of external links for each ID, excluding links
  provided by libraries.
  \item llinkslib. As 'llinks' but additionally includes links provided by
  libraries.
  \item prlinks. As 'llinks' but returns only the primary external link for
  each ID.
}}

\item{by_id}{logical If FALSE (default) return a single 
\code{elink} objects containing links for all of the provided \code{id}s. 
Alternatively, if TRUE return a list of \code{elink} objects, one for each 
ID in \code{id}.}

\item{config}{vector configuration options passed to httr::GET}

\item{\dots}{character Additional terms to add to the request, see NCBI
documentation linked to in references for a complete list}
}
\value{
An elink object containing the data defined by the \code{cmd} argument
(if by_id=FALSE) or a list of such object (if by_id=TRUE).

file XMLInternalDocument xml file resulting from search, parsed with
\code{\link[XML]{xmlTreeParse}}
}
\description{
Discover records related to a set of unique identifiers from
an NCBI database. The object returned by this function depends on the value
set for the \code{cmd} argument. Printing the returned object lists the names
, and provides a brief description, of the elements included in the object.
}
\examples{
\dontrun{
 pubmed_search <- entrez_search(db = "pubmed", term ="10.1016/j.ympev.2010.07.013[doi]")
 linked_dbs <- entrez_db_links("pubmed")
 linked_dbs
 nucleotide_data <- entrez_link(dbfrom = "pubmed", id = pubmed_search$ids, db ="nuccore")
 #Sources for the full text of the paper 
 res <- entrez_link(dbfrom="pubmed", db="", cmd="llinks", id=pubmed_search$ids)
 linkout_urls(res)
}

}
\references{
\url{https://www.ncbi.nlm.nih.gov/books/NBK25499/#_chapter4_ELink_}
}
\seealso{
\code{\link[httr]{config}} for available configs

\code{entrez_db_links}
}
