% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testthat-reporter.R
\name{CleanupReporter}
\alias{CleanupReporter}
\title{testthat reporter that checks if child processes are cleaned up in tests}
\usage{
CleanupReporter(reporter = testthat::ProgressReporter)
}
\arguments{
\item{reporter}{A testthat reporter to wrap into a new \code{CleanupReporter}
class.}
}
\value{
New reporter class that behaves exactly like \code{reporter},
but it checks for, and optionally cleans up child processes, at the
specified granularity.
}
\description{
\code{CleanupReporter} takes an existing testthat \code{Reporter} object, and
wraps it, so it checks for leftover child processes, at the specified
place, see the \code{proc_unit} argument below.
}
\details{
Child processes can be reported via a failed expectation, cleaned up
silently, or cleaned up and reported (the default).

The constructor of the \code{CleanupReporter} class has options:
\itemize{
\item \code{file}: the output file, if any, this is passed to \code{reporter}.
\item \code{proc_unit}: when to perform the child process check and cleanup.
Possible values:
\itemize{
\item \code{"test"}: at the end of each \code{\link[testthat:test_that]{testthat::test_that()}} block
(the default),
\item \code{"testsuite"}: at the end of the test suite.
}
\item \code{proc_cleanup}: Logical scalar, whether to kill the leftover
processes, \code{TRUE} by default.
\item \code{proc_fail}: Whether to create an expectation, that fails if there
are any processes alive, \code{TRUE} by default.
\item \code{proc_timeout}: How long to wait for the processes to quit. This is
sometimes needed, because even if some kill signals were sent to
child processes, it might take a short time for these to take effect.
It defaults to one second.
\item \code{rconn_unit}: When to perform the R connection cleanup. Possible values
are \code{"test"} and \code{"testsuite"}, like for \code{proc_unit}.
\item \code{rconn_cleanup}: Logical scalar, whether to clean up leftover R
connections. \code{TRUE} by default.
\item \code{rconn_fail}: Whether to fail for leftover R connections. \code{TRUE} by
default.
\item \code{file_unit}: When to check for open files. Possible values are
\code{"test"} and \code{"testsuite"}, like for \code{proc_unit}.
\item \code{file_fail}: Whether to fail for leftover open files. \code{TRUE} by
default.
\item \code{conn_unit}: When to check for open network connections.
Possible values are \code{"test"} and \code{"testsuite"}, like for \code{proc_unit}.
\item \code{conn_fail}: Whether to fail for leftover network connections.
\code{TRUE} by default.
}
}
\note{
Some IDEs, like RStudio, start child processes frequently, and
sometimes crash when these are killed, only use this reporter in a
terminal session. In particular, you can always use it in the
idiomatic \code{testthat.R} file, that calls \code{test_check()} during
\verb{R CMD check}.
}
\section{Examples}{

This is how to use this reporter in \code{testthat.R}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(testthat)
library(mypackage)

if  (ps::ps_is_supported()) \{
  reporter <- ps::CleanupReporter(testthat::ProgressReporter)$new(
    proc_unit = "test", proc_cleanup = TRUE)
\} else \{
  ## ps does not support this platform
  reporter <- "progress"
\}

test_check("mypackage", reporter = reporter)
}\if{html}{\out{</div>}}
}

