% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_continuous.R
\name{.calculate_stats_as_ard}
\alias{.calculate_stats_as_ard}
\title{Calculate Continuous Statistics}
\usage{
.calculate_stats_as_ard(
  df_nested,
  variables,
  statistic,
  by,
  strata,
  data,
  new_col_name = "...ard_all_stats..."
)
}
\arguments{
\item{df_nested}{(\code{data.frame})\cr
a nested data frame}

\item{variables}{(\code{character})\cr
character vector of variables}

\item{statistic}{(named \code{list})\cr
named list of statistical functions}
}
\value{
an ARD data frame of class 'card'
}
\description{
Calculate statistics and return in an ARD format
}
\examples{
data_nested <- ADSL |>
  nest_for_ard(
    by = "ARM",
    strata = NULL,
    key = "...ard_nested_data..."
  )

cards:::.calculate_stats_as_ard(
  df_nested = data_nested,
  variables = "AGE",
  statistic = list(mean = "mean"),
  by = "ARM",
  strata = NULL,
  data = ADSL
)
}
\keyword{internal}
