#include <gtk/gtk.h>
#include <gtk/gtktreeview.h>
#include <stdio.h>
#include <string.h>

#ifdef NLS
#include <libintl.h>
#include <locale.h>

#define _(String) gettext (String)
#endif

#ifndef NLS
#define _(String) String
#endif

#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

#include "dirdialog.h"

#ifdef NLS

// if not a valid utf-8 string try to convert from current locale charset to utf-8 
//  fallback to iso8859-1 charset  
gchar* dirsel_convert_if_needed(gchar* text) {
	gint bytes_read;
	gint bytes_written;
	gchar* conv_text;
	GError*	gerror = NULL;
	static gchar* free_text = NULL;
	
	if (g_utf8_validate(text,-1,NULL))
		return text;

	conv_text = g_locale_to_utf8(text,-1,&bytes_read,&bytes_written,NULL);
	if (conv_text != NULL)
		return conv_text;

	if (free_text) 
		g_free(free_text);

	free_text =  g_convert(text,strlen(text),"UTF-8","ISO-8859-1",&bytes_read,&bytes_written,&gerror);
	if (!free_text) {
		g_print("%s\bn",gerror->message);
		// if we still cant convert return original string, will likely produce an error message
		return text;
	}

	return free_text;
}

#endif
