# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.table_algorithm import TableAlgorithm


class ComputeQuantiles(TableAlgorithm):
    r"""
    ComputeQuantiles - Extract Ntiles and extremum values of all
    columns of a table or all fields of a dataset.
    
    Superclass: TableAlgorithm
    
    ComputeQuantiles accepts any DataObject as input and produces a
    Table data as output containing the extrema and quantiles.
    
    The filter internally uses OrderStatistics to divide the dataset
    into N intervals; so to compute quartiles set the number of intervals
    to 4, for deciles set the number of intervals to 10 etc. The output
    table has the same number of columns as the input data set and has
    N+1 number of rows to store the intervals and extrema.
    
    @sa
    TableAlgorithm OrderStatistics
    
    @par Thanks: This class was written by Kitware SAS and supported by
    EDF - www.edf.fr
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkComputeQuantiles, obj, update, **traits)
    
    number_of_intervals = traits.Int(4, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the number of intervals into which the data is to be
        divided. Default is 4.
        """
    )

    def _number_of_intervals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfIntervals,
                        self.number_of_intervals)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_intervals', 'GetNumberOfIntervals'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'number_of_intervals', 'object_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ComputeQuantiles, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ComputeQuantiles properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_intervals', 'object_name']),
            title='Edit ComputeQuantiles properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ComputeQuantiles properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

