#include "sys"
#include "error/error"
#include "profiler/profiler"
#include "config/config"

int serversocket (string addr, int port, string desc, Servertype::Type type) {
    PROFILE("serversocket");
    
    // Create the server socket, set options
    int sock;
    if (type != Servertype::t_udp)
	sock = socket(PF_INET, SOCK_STREAM, 0);
    else
	sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (sock < 0)
	throw Error("Failed to create " + desc + " socket: " +
		    strerror(errno));    
    int val = 1;
    if (setsockopt (sock, SOL_SOCKET, SO_REUSEADDR, &val, sizeof(val)))
	throw Error("Failed to set socket options for " +
		    desc + ": " + strerror(errno));

    // Prepare binding
    struct sockaddr_in saddr;
    memset (&saddr, 0, sizeof(saddr));
    saddr.sin_family = AF_INET;
    saddr.sin_port = htons(port);

    // Assign interface to listen to
    if (addr[0] != '0') {
	msg ("Binding " + desc + " to specific IP address " + addr + "\n");
	if ( (saddr.sin_addr.s_addr = inet_addr (addr.c_str())) == INADDR_NONE )
	    throw Error("Cannot convert " + desc + " IP '" +
			addr + "' to network bytes");
    } else {
	msg ("Binding " + desc + " to all local IP addresses\n");
	saddr.sin_addr.s_addr = htonl (INADDR_ANY);
    }
    
    // Bind and listen
    if (bind (sock, (sockaddr*) &saddr, sizeof(saddr)) < 0)
	throw Error("Failed to bind " + desc +
		    " to IP/port: " + strerror(errno));
    if (type != Servertype::t_udp)
	if (listen (sock, 5) < 0)
	    throw Error("Failed to listen to " + desc +
			" IP/port: " + strerror(errno));

    msg ("Server for " + desc + " listening\n");

    return (sock);
}
