#include "sys"
#include "config/config"
#include "ThreadsAndMutexes/mutex/mutex"
#include "profiler/profiler"
#include "mstr/mstr"
#include "timestamp/timestamp"

void anymsg (Mstr const &s, ostream &o, string const &label) {
    Mutex::lock(&o);
    if (config.prefixtimestamp()) {
	Timestamp tm;
	o << tm.desc() << ' ';
    }
    o << pthread_self() << ' ' << label << ": " << s;
    o.flush();
    Mutex::unlock(&o);
}
