/**
 * @file  DfClassDflts.c
 * @brief DF Class IP input defaults
 *
 * This file holds the platform default values for the DF class module.
 */

#include "Df.h"
#include "Common/SilFabricInfo.h"
static const uint32_t SilDfGlblCtrlInstanceIds[] = {
  DFX_CSUMC0_INSTANCE_ID,
  DFX_CSUMC1_INSTANCE_ID,
  DFX_CSUMC2_INSTANCE_ID,
  DFX_CSUMC3_INSTANCE_ID,
  DFX_CSUMC4_INSTANCE_ID,
  DFX_CSUMC5_INSTANCE_ID,
  DFX_CSUMC6_INSTANCE_ID,
  DFX_CSUMC7_INSTANCE_ID,
  DFX_CSUMC8_INSTANCE_ID,
  DFX_CSUMC9_INSTANCE_ID,
  DFX_CSUMC10_INSTANCE_ID,
  DFX_CSUMC11_INSTANCE_ID,
  DFX_CSCMP0_INSTANCE_ID,
  DFX_CSCMP1_INSTANCE_ID,
  DFX_CSCMP2_INSTANCE_ID,
  DFX_CSCMP3_INSTANCE_ID,
  DFX_CCM0_INSTANCE_ID,
  DFX_CCM1_INSTANCE_ID,
  DFX_CCM2_INSTANCE_ID,
  DFX_CCM3_INSTANCE_ID,
  DFX_CCM4_INSTANCE_ID,
  DFX_CCM5_INSTANCE_ID,
  DFX_CCM6_INSTANCE_ID,
  DFX_CCM7_INSTANCE_ID,
  DFX_ACM0_INSTANCE_ID,
  DFX_ACM1_INSTANCE_ID,
  DFX_ACM2_INSTANCE_ID,
  DFX_ACM3_INSTANCE_ID,
  DFX_NCM0_INSTANCE_ID,
  DFX_NCM1_INSTANCE_ID,
  DFX_NCM2_INSTANCE_ID,
  DFX_NCM3_INSTANCE_ID,
  DFX_IOMS0_INSTANCE_ID,
  DFX_IOMS1_INSTANCE_ID,
  DFX_IOMS2_INSTANCE_ID,
  DFX_IOMS3_INSTANCE_ID,
  DFX_IOS0_INSTANCE_ID,
  DFX_IOS1_INSTANCE_ID,
  DFX_IOS2_INSTANCE_ID,
  DFX_IOS3_INSTANCE_ID,
  DFX_ICNG0_INSTANCE_ID,
  DFX_ICNG1_INSTANCE_ID,
  DFX_ICNG2_INSTANCE_ID,
  DFX_ICNG3_INSTANCE_ID,
  DFX_PIE_INSTANCE_ID,
  DFX_CAKE0_INSTANCE_ID,
  DFX_CAKE1_INSTANCE_ID,
  DFX_CAKE2_INSTANCE_ID,
  DFX_CAKE3_INSTANCE_ID,
  DFX_CAKE4_INSTANCE_ID,
  DFX_CAKE5_INSTANCE_ID,
  DFX_CAKE6_INSTANCE_ID,
  DFX_CAKE7_INSTANCE_ID,
  DFX_CNLI0_INSTANCE_ID,
  DFX_CNLI1_INSTANCE_ID,
  DFX_CNLI2_INSTANCE_ID,
  DFX_CNLI3_INSTANCE_ID,
  DFX_SPF0_INSTANCE_ID,
  DFX_SPF1_INSTANCE_ID,
  DFX_SPF2_INSTANCE_ID,
  DFX_SPF3_INSTANCE_ID,
  DFX_SPF4_INSTANCE_ID,
  DFX_SPF5_INSTANCE_ID,
  DFX_SPF6_INSTANCE_ID,
  DFX_SPF7_INSTANCE_ID,
  DFX_SPF8_INSTANCE_ID,
  DFX_SPF9_INSTANCE_ID,
  DFX_SPF10_INSTANCE_ID,
  DFX_SPF11_INSTANCE_ID,
  DFX_SPF12_INSTANCE_ID,
  DFX_SPF13_INSTANCE_ID,
  DFX_SPF14_INSTANCE_ID,
  DFX_SPF15_INSTANCE_ID,
  DFX_TCDX0_INSTANCE_ID,
  DFX_TCDX1_INSTANCE_ID,
  DFX_TCDX2_INSTANCE_ID,
  DFX_TCDX3_INSTANCE_ID,
  DFX_TCDX4_INSTANCE_ID,
  DFX_TCDX5_INSTANCE_ID,
  DFX_TCDX6_INSTANCE_ID,
  DFX_TCDX7_INSTANCE_ID,
  DFX_TCDX8_INSTANCE_ID,
  DFX_TCDX9_INSTANCE_ID,
  DFX_TCDX10_INSTANCE_ID,
  DFX_TCDX11_INSTANCE_ID,
  DFX_TCDX12_INSTANCE_ID,
  DFX_TCDX13_INSTANCE_ID,
  DFX_TCDX14_INSTANCE_ID,
  DFX_TCDX15_INSTANCE_ID,
  0xFFFFFFFF
};

const DFCLASS_INPUT_BLK mDfClassDflts = {
  // This is where you declare all input block vars/values you want to share with the Host.
  // This becomes part of the IP API for the Host.
  .AmdFabricWdtCfg        = 0xFF,
  .AmdFabricWdtCntSel     = 0xFF,
  .DfGlblCtrlInstanceIds = SilDfGlblCtrlInstanceIds,
  .AmdFabricImmSyncFloodOnFatalErrCtrl  = false,
  .AmdFabricNumOfScrubber = 0xFF,
  .AmdFabricNumSeqScrubsCstateExit  = 0xFF,
  .AmdFabricEccScrubRedirection     = true,
  .FabricEccScrubPoisoned = true,
  .AmdFabricDramScrubTime = 0xFF,
  .AmdFabricEccScrubRedirectionLimit = 0xFF,
  .AmdFabricPeriodicDirRinse = true,
};
