//
// BAGEL - Parallel electron correlation program.
// Filename: _r2root_7.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root7(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[7] = {1.930444130090417e-01,1.026668812009368e+00,2.567886541317060e+00,4.900371779380565e+00,8.182184659880857e+00,
    1.273422887416590e+01,1.939580186108440e+01};
  constexpr double aw[7] = {2.046602566047616e-01,2.109164435183150e-01,7.356345493138189e-02,1.031679658250106e-02,5.370071194458480e-04,
    7.932762417987521e-06,1.585163780946268e-08};
  constexpr double x[3689] = {  2.507351393371736e-02,  8.834010253015928e-04,  2.302936539378776e-05,  5.240722126289678e-07,  1.091306152881189e-08,
  2.114072699683823e-10,  3.816859319682645e-12,  6.363589451805290e-14,  9.534922406375777e-16,  1.195517073348058e-17,  9.415883463951202e-20, -8.223051893501708e-22,
  2.170994279736083e-01,  6.856752512840586e-03,  1.417608513198876e-04,  2.031445291590015e-06,  1.282580727350529e-08, -3.095779867611269e-10, -1.284127216796173e-11,
 -2.352596819167673e-13, -1.417976503515758e-15,  5.912492588566414e-17,  2.340230264507829e-18,  4.216451929908830e-20,  5.588268525043734e-01,  1.409254740045736e-02,
  1.595820843215162e-04, -7.523062069720306e-07, -5.652284001266995e-08, -5.355131689355282e-10,  1.445320505902478e-11,  4.474028291654477e-13,  3.439675107822041e-16,
 -2.066125941357798e-16, -3.458120218580276e-18,  4.876187440080804e-20,  9.791990278651921e-01,  1.723538366942834e-02,  3.997244080374800e-06, -3.411722343520977e-06,
 -1.008724287788892e-09,  1.217104788033072e-09,  1.944709625279662e-13, -5.278034123868477e-13,  1.566621940950809e-17,  2.538817314332626e-16, -7.048718650593053e-20,
 -1.300754502499373e-19,  1.397447748004328e+00,  1.431414403209020e-02, -1.486736761725789e-04, -9.061049791429134e-07,  5.284999981515684e-08, -4.185673013896770e-10,
 -1.392459536742127e-11,  3.749658600063690e-13,  3.665535204076244e-16, -1.744645590816793e-16,  2.534376043454171e-18,  4.403115847259520e-20,  1.739504648257283e+00,
  7.616175670503842e-03, -1.430498208372602e-04,  1.760484621793067e-06, -5.345961996468742e-09, -3.852177328616897e-10,  1.130657993146532e-11, -1.525877181077700e-13,
 -2.498418943012152e-16,  6.644484467652287e-17, -1.694995227762474e-18,  1.871786270388309e-20,  1.948916224911821e+00,  1.661980623140541e-03, -3.955767144894523e-05,
  8.078928050164174e-07, -1.472742410087877e-08,  2.401574168874122e-10, -3.405706616067852e-12,  3.814344272179850e-14, -2.002879361289152e-16, -5.234484033613863e-18,
  2.316683775610074e-19, -5.848914078969430e-21,  2.902007636715593e-02,  1.096116720924553e-03,  3.052335327479179e-05,  7.381567152346962e-07,  1.622117128396623e-08,
  3.282620716563028e-10,  6.094968742388168e-12,  1.016194702869419e-13,  1.431651012601387e-15,  1.365293690879878e-17, -5.679158057730209e-20, -7.503833176480805e-21,
  2.469531552854085e-01,  8.091246582194336e-03,  1.671046367979876e-04,  2.168081038185158e-06,  3.003264192898123e-09, -6.992400453972434e-10, -1.959389491639449e-11,
 -2.248861680680849e-13,  2.837157212605325e-15,  1.883290302800189e-16,  3.956115131827213e-18,  1.816426182762771e-20,  6.176705819935578e-01,  1.531704853738978e-02,
  1.448473116054029e-04, -1.719321412836370e-06, -6.277538212414967e-08, -4.474711860294294e-11,  2.586136076273079e-11,  3.191355633430585e-13, -8.728017602068783e-15,
 -2.651372760960336e-16,  1.377929760078912e-18,  1.612654201035949e-19,  1.047947251373351e+00,  1.710515165079919e-02, -3.624964615771974e-05, -3.237789427532746e-06,
  2.221817601743045e-08,  1.052644019118127e-09, -1.326917745726530e-11, -3.922285820250643e-13,  7.826067113330135e-15,  1.497940661075514e-16, -4.550467020613451e-18,
 -5.222059443136077e-20,  1.452276009771543e+00,  1.309490017576020e-02, -1.547987441114679e-04, -1.421068046399549e-07,  4.197216251241265e-08, -6.304824176514220e-10,
 -4.051693830343796e-12,  3.080310499355007e-13, -3.850779145393705e-15, -5.867007920359453e-17,  2.753428200247221e-18, -2.422374990806209e-20,  1.767811637703036e+00,
  6.554329329654701e-03, -1.226476575489125e-04,  1.626613326114709e-06, -1.067966589953513e-08, -1.642485452112319e-10,  7.198303809139039e-12, -1.336978953288727e-13,
  1.131571277888791e-15,  1.605401258174459e-17, -8.365352734107001e-19,  1.753813404079604e-20,  1.954987416241344e+00,  1.380630176782869e-03, -3.113171525838743e-05,
  6.065865703403199e-07, -1.065942040853577e-08,  1.703913914949098e-10, -2.445486648108367e-12,  3.008955165880792e-14, -2.712827970355256e-16,  2.259687335691842e-19,
  6.841972325145742e-20, -2.093767319303185e-21,  3.395597495484087e-02,  1.380703023501585e-03,  4.118374403853665e-05,  1.059231286647907e-06,  2.450823807341237e-08,
  5.142801398921863e-10,  9.647452195190970e-12,  1.539475885120260e-13,  1.760793728827870e-15, -1.172885187454492e-19, -7.924714767236307e-19, -2.991916875855540e-20,
  2.821561211281159e-01,  9.531730042662860e-03,  1.928604511255238e-04,  2.076839141593009e-06, -1.611049190703698e-08, -1.227430438285791e-09, -2.338167510496463e-11,
  4.791959548341788e-15,  1.238813598848525e-14,  3.308015905544024e-16,  2.110024998683766e-18, -1.271433829357710e-19,  6.811017604850056e-01,  1.637638818444733e-02,
  1.182754240831680e-04, -2.694799897488104e-06, -5.693780562142375e-08,  6.435104401657695e-10,  2.961105550018267e-11, -8.789017838520362e-14, -1.551817425561445e-14,
 -6.568648348747338e-17,  8.216210798542177e-18,  1.081447521840574e-19,  1.115552271381412e+00,  1.666725524709447e-02, -7.234034215123829e-05, -2.734352576045745e-06,
  3.935946891968433e-08,  6.343521690448326e-10, -2.019996221835143e-11, -9.283518344812435e-14,  9.736952885633853e-15, -4.033859717609339e-17, -4.094469495081634e-18,
  6.331491052064924e-20,  1.502182857499719e+00,  1.186012634127232e-02, -1.529005618495578e-04,  4.259511362679637e-07,  2.901105184796944e-08, -6.394012565583615e-10,
  2.667671070813336e-12,  1.697357966403519e-13, -4.300842624720876e-15,  2.392550982019803e-17,  1.312545868399262e-18, -3.377920445842093e-20,  1.792185854459785e+00,
  5.648125963515467e-03, -1.042348336218843e-04,  1.437651155680586e-06, -1.251758567779211e-08, -3.198203218356618e-11,  4.010608321984053e-12, -9.332870683075616e-14,
  1.271805891422596e-15, -4.342589033533510e-18, -2.438147179343802e-19,  9.316546807991137e-21,  1.960054153882030e+00,  1.158032875783611e-03, -2.477311146080197e-05,
  4.603786067007306e-07, -7.775247710538430e-09,  1.208514605622977e-10, -1.720390553222583e-12,  2.192225313800720e-14, -2.308227976162801e-16,  1.673795483287749e-18,
  1.463002088844045e-20, -6.174369354675558e-22,  4.022878268528723e-02,  1.768553490386032e-03,  5.663176074448322e-05,  1.547805535499770e-06,  3.749023036266810e-08,
  8.036123734209965e-10,  1.468396261133399e-11,  2.007646983336679e-13,  7.480883550946201e-16, -7.206423008590128e-17, -3.238256974287338e-18, -8.995782703142406e-20,
  3.235177573171036e-01,  1.116786009268931e-02,  2.153294241703566e-04,  1.593188230563446e-06, -4.598060223669008e-08, -1.730945555503092e-09, -1.587480182392888e-11,
  5.929618113423420e-13,  2.383476252705556e-14,  2.334132775859582e-16, -8.706833627630966e-18, -3.570050903525161e-19,  7.482746467288102e-01,  1.717897482032252e-02,
  8.101686001480603e-05, -3.466080905002661e-06, -3.745075040089402e-08,  1.268775637604673e-09,  2.033014583949944e-11, -5.533948449870618e-13, -1.141576106772353e-14,
  2.906690311357065e-16,  7.710285970988366e-18, -1.453079825548176e-19,  1.180872203409354e+00,  1.596878053748199e-02, -1.010416638452648e-04, -2.029722906802142e-06,
  4.716061375299345e-08,  1.512501768647724e-10, -1.884471139339498e-11,  1.702362787516139e-13,  6.131526800517589e-15, -1.367193968358804e-16, -6.692224521791069e-19,
  7.168879857421979e-20,  1.547219221996404e+00,  1.066431614854211e-02, -1.454110538197433e-04,  7.926516986138205e-07,  1.717232927439060e-08, -5.328080964923079e-10,
  5.679335924089070e-12,  5.331225385513259e-14, -2.822152546111423e-15,  5.013970965997959e-17,  9.058701790544204e-20, -2.151161339338455e-20,  1.813215029432126e+00,
  4.879831048781966e-03, -8.819110890564234e-05,  1.236674371692207e-06, -1.238338398718531e-08,  3.731848745887959e-11,  1.934207739835814e-12, -5.635223710886811e-14,
  1.017598167221027e-15, -8.196967266647080e-18, -3.250030174207894e-21,  1.876728003694742e-21,  1.964322143700874e+00,  9.800013866315723e-04, -1.992196121468744e-05,
  3.532619147034975e-07, -5.725458897610800e-09,  8.615189248297289e-11, -1.200372504912066e-12,  1.556909470626342e-14, -1.652605975771091e-16,  1.845843061982675e-18,
 -4.581547774209754e-21, -4.054086217076260e-22,  4.834291307830246e-02,  2.307455026274703e-03,  7.940214999687099e-05,  2.297293831374854e-06,  5.754180543277504e-08,
  1.222674680680741e-09,  2.001876796420431e-11,  1.486635925477739e-13, -5.409843378389639e-15, -3.123036795788532e-16, -9.678044137486950e-18, -2.134914101440252e-19,
  3.717342979626260e-01,  1.295173084803282e-02,  2.288433802520820e-04,  5.671117198052344e-07, -8.259756449472737e-08, -1.821953004153422e-09,  1.200372130713213e-11,
  1.390663116944155e-12,  2.199905678355997e-14, -4.408852592674195e-16, -2.416017401096473e-17, -2.299304158503832e-19,  8.180117372101635e-01,  1.765262330324002e-02,
  3.673600768762414e-05, -3.841647535636322e-06, -8.616883155601874e-09,  1.540889653124594e-09,  1.625765328535993e-12, -7.082551556272063e-13,  2.471972541230097e-15,
  4.106024684195709e-16, -2.687285003380314e-18, -2.744423508027702e-19,  1.242994623165821e+00,  1.507592792320502e-02, -1.208454350134255e-04, -1.273565987994728e-06,
  4.614403498738467e-08, -2.262504415642677e-10, -1.207725245329628e-11,  2.876525205713953e-13,  1.325558034608961e-15, -1.187167974151975e-16,  1.072000253387534e-18,
  5.649814808943869e-21,  1.587615740566968e+00,  9.542985968218969e-03, -1.345773624048015e-04,  9.899107246728209e-07,  7.954410554182163e-09, -3.871456361575947e-10,
  6.174265142761225e-12, -9.088803065602424e-15, -1.153133290826387e-15,  3.772147959522460e-17, -6.466256414733659e-19, -1.238697755952902e-20,  1.831412620403972e+00,
  4.230364970974555e-03, -7.450833508565142e-05,  1.046559638058643e-06, -1.128274760955712e-08,  6.821321725381683e-11,  7.681019797640234e-13, -2.847887994057965e-14,
  7.244543477150524e-16, -8.332628754704884e-18, -3.669126611744372e-20, -2.602283902714453e-21,  1.967948207883670e+00,  8.361464201870835e-04, -1.618029163738229e-05,
  2.740118226195491e-07, -4.258035158474469e-09,  6.203579210363851e-11, -8.289567047407244e-13,  1.127010069176357e-14, -1.069584420267210e-16,  1.245682341008978e-18,
 -2.672506355870857e-20, -5.632832387675492e-22,  5.904252807013173e-02,  3.070626809073868e-03,  1.133878829907411e-04,  3.440595280281314e-06,  8.698045435658676e-08,
  1.719951130441885e-09,  1.941566571206533e-11, -3.000023313623280e-13, -2.626960810680255e-14, -9.280363189588762e-16, -2.185707509040065e-17, -3.057186839724715e-19,
  4.272106614302809e-01,  1.478463572200604e-02,  2.266066416781789e-04, -1.015894448206729e-06, -1.126780764982708e-07, -1.008663579407151e-09,  5.702516335815676e-11,
  1.646451361210951e-12, -1.180031561660303e-14, -1.389103875704803e-15, -1.648895620735626e-17,  6.790673745290195e-19,  8.889177983750447e-01,  1.776209216801592e-02,
 -9.184806485350533e-06, -3.737273886023870e-06,  2.108443544854427e-08,  1.363238499281545e-09, -1.515098113792680e-11, -4.349444616357626e-13,  1.275246987552743e-14,
  1.041995468890009e-16, -1.099993280678386e-17, -5.570680117991695e-20,  1.301285170697045e+00,  1.406015201300271e-02, -1.318911536397069e-04, -5.844332355277666e-07,
  3.938196280472872e-08, -4.183178537853527e-10, -4.014172234576488e-12,  2.695907786083520e-13, -2.241287364957737e-15, -8.350111002147428e-17,  5.154466323014975e-19,
 -1.783825589677552e-20,  1.623712023574136e+00,  8.515509546132618e-03, -1.221646321510543e-04,  1.063141819532619e-06,  1.655757481367616e-09, -2.451336201701273e-10,
  5.566454968441955e-12, -3.013375665695156e-14, -3.630449940240134e-16,  4.281538195738670e-18, -9.250454684140003e-19,  1.446514324657544e-21,  1.847217296352051e+00,
  3.681573269639868e-03, -6.298513338461238e-05,  8.777237123737731e-07, -9.786421957137337e-09,  7.940531689257168e-11,  2.467866959975793e-13, -1.061037653577774e-14,
  3.699955775506576e-16, -1.203584832620713e-17, -1.336985185648638e-19, -5.968996307309253e-22,  1.971053214802058e+00,  7.187862464991412e-04, -1.326320162959730e-05,
  2.148288094418018e-07, -3.192561905123013e-09,  4.557374375101226e-11, -5.563039063046108e-13,  8.314073010229903e-15, -8.664812068630374e-17, -2.298805818232002e-19,
 -4.300801873436352e-20, -7.982215676368173e-24,  7.343775378119995e-02,  4.169293255729315e-03,  1.642294203864956e-04,  5.127768401847076e-06,  1.247130184905928e-07,
  1.952646988528035e-09, -7.112069470127070e-12, -1.865899928870961e-12, -7.789325259463885e-14, -1.967745148817184e-15, -2.476139841900909e-17,  4.772761448744222e-19,
  4.898531100925365e-01,  1.651709997720225e-02,  2.032135928142265e-04, -2.891485262929788e-06, -1.158587129322426e-07,  8.214939470506699e-10,  8.983822432142817e-11,
  4.169616683709213e-13, -6.396830437222794e-14, -1.192182031598265e-15,  3.030532791618525e-17,  1.185591517095012e-18,  9.595458230079182e-01,  1.751688617377563e-02,
 -5.118152805512032e-05, -3.204858323817298e-06,  4.396841868237647e-08,  9.000061405126861e-10, -2.165683139609458e-11, -5.072910593323433e-14,  8.873985919032477e-15,
 -2.893867145513445e-16, -6.537850602918132e-18,  2.314866272656490e-19,  1.355385359581613e+00,  1.298702406094462e-02, -1.354101433813075e-04, -2.410089629930525e-08,
  3.061038349863817e-08, -4.348450745392602e-10,  2.100104738797261e-12,  1.526965018361151e-13, -4.988362364535023e-15, -6.949768686503271e-17,  4.778162079051164e-19,
  2.080448994584276e-20,  1.655900428538917e+00,  7.589346696856573e-03, -1.093870947322187e-04,  1.057360110219994e-06, -1.986390395110384e-09, -1.230797477061361e-10,
  4.534774500401332e-12, -4.594852268780071e-14, -8.056389194340005e-16, -2.550083408742171e-17, -4.173235175836129e-19,  2.118334461864359e-20,  1.860998937557313e+00,
  3.217283398188680e-03, -5.333872537749318e-05,  7.340851945741060e-07, -8.158068382978793e-09,  8.266445295505305e-11,  4.318909524365195e-14, -6.677870437705957e-15,
 -1.491079972523957e-16, -1.603453406168915e-17, -1.701637527163017e-20,  5.994253594914744e-21,  1.973731335451716e+00,  6.221889679307920e-04, -1.096381076495297e-05,
  1.703874984872901e-07, -2.397437594765085e-09,  3.468349390519309e-11, -3.658445797036798e-13,  5.096490432011518e-15, -1.228594346045712e-16, -1.611083724947470e-18,
 -1.716590815115615e-20,  1.184925873465383e-21,  9.318389932001921e-02,  5.765979358230458e-03,  2.389311219878034e-04,  7.402603293316329e-06,  1.560745177797815e-07,
  8.029062634612314e-10, -1.058020242019793e-10, -5.594269024892796e-12, -1.538364430267806e-13, -1.625889140855085e-15,  7.378990906835424e-17,  4.904575000120174e-18,
  5.589112920948059e-01,  1.797451498100712e-02,  1.583149162964299e-04, -4.497236014994038e-06, -7.824785122383431e-08,  2.857373370161212e-09,  6.858951365692617e-11,
 -1.996378072309016e-12, -7.505922732856010e-14,  7.521265831419753e-16,  5.575913125468065e-17, -2.948521874133310e-19,  1.028569349701671e+00,  1.696674416812733e-02,
 -8.491656085817900e-05, -2.385645587376992e-06,  5.677597627755464e-08,  3.843889072777921e-10, -2.090192300843501e-11,  3.798746347576038e-14, -3.522881412237456e-15,
 -3.218737530638982e-16,  4.958961789640529e-18,  2.414072870235131e-19,  1.405175974350453e+00,  1.191027472403571e-02, -1.330357546778940e-04,  3.999298408510695e-07,
  2.266145204816060e-08, -3.532968634617274e-10,  3.804823652279694e-12, -4.079249168817109e-14, -6.823602605675806e-15, -2.137144853105099e-17,  2.130505146422316e-18,
  4.890522729971879e-20,  1.684587017200356e+00,  6.764311838758423e-03, -9.695289127346173e-05,  1.011297002951219e-06, -3.482766761280098e-09, -3.351081703718796e-11,
  2.738055331283864e-12, -8.758098514438377e-14, -1.765133598565818e-15, -2.000425451156259e-17,  7.527714057662737e-19,  2.984700523185634e-20,  1.873067474981805e+00,
  2.823716327182264e-03, -4.525834848145702e-05,  6.167586939707828e-07, -6.514580079361109e-09,  8.039449844002042e-11, -2.948619934891591e-13, -2.020954057172339e-14,
 -6.615805679571419e-16, -1.002889934324034e-17,  3.443361910823804e-19,  9.825928288496121e-21,  1.976056765038675e+00,  5.420548041389922e-04, -9.127857234676247e-06,
  1.371406097515636e-07, -1.782543205228713e-09,  2.711588761114191e-11, -2.871767661018350e-13,  2.225071468191954e-16, -1.782829017890050e-16, -1.006211606950469e-18,
  5.222107866668706e-20,  1.868214137491563e-21,  1.206933525311375e-01,  8.075223047731773e-03,  3.426579943992192e-04,  9.826636311972236e-06,  1.310632086702846e-07,
 -4.193003267835843e-09, -3.329716082199836e-10, -1.032251011361790e-11, -8.599003510880323e-14,  7.966320066778625e-15,  4.586311044014613e-16,  1.156172672978091e-17,
  6.329768748934866e-01,  1.900869522911892e-02,  9.894918190434334e-05, -5.226007168845168e-06, -1.041092085233755e-08,  3.600520741367870e-09, -1.409609759384335e-11,
 -3.590334189685103e-12, -1.540041280954665e-14,  2.269501942207351e-15,  1.368528349061939e-17, -1.115927009302378e-18,  1.094918702145615e+00,  1.618875138858742e-02,
 -1.079282356805185e-04, -1.442971254471371e-06,  5.942870787068125e-08, -1.260944019255894e-10, -2.277542437812452e-11, -2.031339882046341e-13, -9.284565624376182e-15,
  5.709273083371372e-17,  1.347587873095189e-17,  1.796668155366017e-19,  1.450726925925634e+00,  1.087084071465163e-02, -1.262803378547611e-04,  7.101123391279980e-07,
  1.628811385562577e-08, -3.003739725379230e-10, -3.666554958492218e-13, -2.504362981713674e-13, -5.480511757650048e-15,  1.143036580900695e-16,  4.959262735146255e-18,
  9.279364903817314e-20,  1.710168495921881e+00,  6.036251284771308e-03, -8.516479253368728e-05,  9.528268606651573e-07, -3.729326184004219e-09, -3.999244694312259e-12,
 -5.563213443348485e-13, -1.470712592288255e-13, -1.603784926161357e-15,  3.932069318579876e-17,  2.345881058270864e-18,  4.866419209710225e-20,  1.883682735354518e+00,
  2.489600550931453e-03, -3.843146538165842e-05,  5.247654323066830e-07, -5.036654415375368e-09,  6.391873287002522e-11, -1.187205211494261e-12, -4.358042570988121e-14,
 -6.586368799638343e-16,  1.385111478061112e-17,  9.074781575259959e-19,  1.794942824911576e-20,  1.978088727960355e+00,  4.751685894110020e-04, -7.636633334423183e-06,
  1.125742477568345e-07, -1.312051040980256e-09,  1.963889097080641e-11, -3.623939231361424e-13, -5.484611678998791e-15, -1.548751346318818e-16,  2.999077119001998e-18,
  1.587000097160142e-19,  3.361026783686947e-21,  1.592613658503766e-01,  1.131412595663587e-02,  4.687141317623586e-04,  1.071952743898600e-05, -5.606921358965381e-08,
 -1.554953233474810e-08, -5.870447531853465e-10, -4.102302250113565e-12,  6.252075370387976e-13,  3.241856114064916e-14,  5.319750568078181e-16, -2.170170198904908e-17,
  7.102005256490822e-01,  1.955179160572628e-02,  3.746080006438721e-05, -4.869073734248135e-06,  5.011353001155611e-08,  2.077533926634055e-09, -1.089169277206467e-10,
 -2.739125998677684e-12,  6.867157813286641e-14,  2.344217960558178e-15,  5.678792739271351e-18,  8.754986067423657e-19,  1.157859500597823e+00,  1.527183102608773e-02,
 -1.197247654727175e-04, -5.444599173834347e-07,  5.082944910276175e-08, -7.684905166824458e-10, -3.147189887509021e-11, -3.456690549828488e-13,  4.718890109248780e-15,
  7.917556002202770e-16,  2.397739799305745e-17,  2.418399633542836e-19,  1.492249404785113e+00,  9.898641026964141e-03, -1.164023623437320e-04,  9.195074183455613e-07,
  9.544075128712514e-09, -4.077380354447092e-10, -8.888081610121450e-12, -3.120425377419188e-13,  3.435846234381764e-15,  4.199242393827359e-16,  1.065146327833856e-17,
  1.203823546350071e-19,  1.733021824322654e+00,  5.399636170378113e-03, -7.409790060768704e-05,  8.903118814919332e-07, -4.298076809608242e-09, -7.049405493874997e-11,
 -5.023209806432000e-12, -1.527610506629988e-13,  2.117129493742617e-15,  1.860949803224463e-16,  5.075984558141325e-18,  5.182555439272585e-20,  1.893064294948139e+00,
  2.206052492265389e-03, -3.258184569771201e-05,  4.524088049664877e-07, -4.151353098657856e-09,  1.915550132423730e-11, -2.567385802040010e-12, -4.787276404414501e-14,
  7.208655205456431e-16,  6.964016342555942e-17,  1.904739373761796e-18,  1.799253293368206e-20,  1.979875303130888e+00,  4.191486954438785e-04, -6.400431491446257e-06,
  9.419057317715492e-08, -1.020972679810250e-09,  8.690173424815759e-12, -5.584779636744485e-13, -7.153514754073543e-15,  1.095434791266271e-16,  1.295011229314605e-17,
  3.418493986828387e-19,  3.212647010247538e-21,  2.127730426295188e-01,  1.553453898376719e-02,  5.792466557705098e-04,  6.585297322689944e-06, -5.006954124483091e-07,
 -2.760718462740232e-08, -2.359398170184834e-10,  3.516368242060235e-11,  1.690758918878199e-12,  6.420605024110886e-15, -2.504638922684841e-15, -1.053482492291737e-16,
  7.886591277751716e-01,  1.963352069955383e-02, -1.530433348940471e-05, -3.897458517003337e-06,  6.093820217166167e-08, -1.126973072812400e-09, -1.413930413309208e-10,
  9.277970530364971e-13,  1.655391661836656e-13,  3.082097277728132e-15,  2.637619852287391e-18, -3.250324472175853e-18,  1.217007475256146e+00,  1.430027598965103e-02,
 -1.220261784165421e-04,  1.022346097162243e-07,  2.734748517550373e-08, -1.589654379270041e-09, -3.337596602965123e-11,  4.529160321032137e-13,  5.057453541105297e-14,
  1.640476694959912e-15,  3.505645607983942e-18, -1.860700176644017e-18,  1.530054150552977e+00,  9.013446284520958e-03, -1.047658201496695e-04,  9.928463355726515e-07,
 -1.316882736125214e-09, -6.964391039337537e-10, -1.320362165908811e-11,  1.243518491222839e-13,  2.614276072192311e-14,  7.789345707383828e-16, -1.929832043290986e-19,
 -9.235343858235359e-19,  1.753500613192178e+00,  4.848262809797494e-03, -6.389795787095978e-05,  8.024902826970150e-07, -7.188882922893844e-09, -2.270871534129104e-10,
 -7.058061237484176e-12,  6.181543916037132e-14,  1.234910886785892e-14,  3.501035779594822e-16, -4.074952998728566e-19, -4.380368496908319e-19,  1.901399992930997e+00,
  1.965989593959452e-03, -2.755072885890182e-05,  3.853302858667112e-07, -4.467722602185088e-09, -5.308516037061548e-11, -3.101271027121328e-12,  3.001773989114596e-14,
  4.532627820519876e-15,  1.293967572939465e-16, -2.401080727526888e-19, -1.650573775163178e-19,  1.981456268541816e+00,  3.721968770288399e-04, -5.364936448873771e-06,
  7.846267571609049e-08, -9.932004997783336e-10, -6.193497752093173e-12, -6.205103062707724e-13,  6.441725440649090e-15,  8.084897036621106e-16,  2.352164505830745e-17,
 -5.419503409740298e-20, -3.007415803490711e-20,  2.844320577289428e-01,  2.030654834403370e-02,  5.921547238211008e-04, -5.711581033204775e-06, -1.000384700282185e-06,
 -1.601830426654633e-08,  1.357886944463462e-09,  6.629859677207521e-11, -6.832820856736655e-13, -1.430725989369887e-13, -2.792104862173918e-15,  1.876881211048099e-16,
  8.666718778654567e-01,  1.933776428525017e-02, -5.751203074358505e-05, -3.266300577104688e-06,  1.006519978350536e-08, -3.518046546628847e-09, -2.719797955365311e-11,
  7.505557020233716e-12,  2.079982020415276e-13, -3.588856118870149e-15, -4.192106935370377e-16, -1.307052735335446e-17,  1.272270934509919e+00,  1.333375041879429e-02,
 -1.193429880170417e-04,  2.501962410026570e-07, -1.026557623446319e-08, -2.005563122437776e-09,  9.703543789127483e-12,  2.801260177204775e-12,  8.007462858227043e-14,
 -1.177653214044938e-15, -1.690988108092387e-16, -4.713941754453051e-18,  1.564505113301113e+00,  8.221461588630749e-03, -9.348549251070616e-05,  8.463241796496082e-07,
 -1.754251903989686e-08, -8.538040765385034e-10,  5.553872828272625e-12,  1.292053375062039e-12,  3.877872169159761e-14, -6.196686553183980e-16, -7.954671748118780e-17,
 -2.032256215257588e-18,  1.771929003446203e+00,  4.373245009798536e-03, -5.513405045189724e-05,  6.434609985135116e-07, -1.300846140719092e-08, -3.207578516392580e-10,
  1.779302447030902e-12,  6.017183031226179e-13,  1.761873136488017e-14, -3.025513608074383e-16, -3.617494909292883e-17, -8.753111786748635e-19,  1.908850573027170e+00,
  1.762760229242597e-03, -2.340219970422652e-05,  3.019406416476502e-07, -6.104372990902600e-09, -9.726249809742998e-11,  3.458123983507364e-13,  2.277394866654321e-13,
  6.407154238467713e-15, -1.150848061942704e-16, -1.332428129333286e-17, -3.111155862886695e-19,  1.982864780470806e+00,  3.327593229758847e-04, -4.525125778131639e-06,
  6.089452022621713e-08, -1.233271760725074e-09, -1.531393571587288e-11,  2.623629157085844e-14,  4.182104402273229e-14,  1.144037952315389e-15, -2.103071652573780e-17,
 -2.404854342918154e-18, -5.506486248237408e-20,  3.743002342298081e-01,  2.448741108715206e-02,  4.242195151404754e-04, -2.198762411190338e-05, -8.785465835721042e-07,
  3.139107643856009e-08,  2.110985233073261e-09, -3.615301822988599e-11, -4.842691889039508e-12,  4.814183887267278e-15,  1.011908799360867e-14,  1.464458611146948e-16,
  9.428515154132000e-01,  1.871844588534954e-02, -9.795633843675790e-05, -3.621470191525446e-06, -4.691218579949944e-08, -1.152839983996788e-09,  2.290995850523928e-10,
  8.171925867324958e-12, -2.865095145695890e-13, -2.222043386714155e-14, -1.078047687490959e-16,  4.011166797559189e-17,  1.323707788466092e+00,  1.238540767781098e-02,
 -1.185255459870254e-04, -1.914347742137481e-07, -4.055914940121768e-08, -6.350295127061666e-10,  1.067618599857693e-10,  3.145395943669343e-12, -1.052642704995750e-13,
 -8.474243053077033e-15, -5.246487216451941e-17,  1.414812363777814e-17,  1.595951209066323e+00,  7.508248574616254e-03, -8.551511473399383e-05,  4.505951179252900e-07,
 -2.980821043190856e-08, -1.917123631226509e-10,  5.073562144482793e-11,  1.468917699466740e-12, -4.873773028297217e-14, -3.905100385219524e-15, -2.086889113951960e-17,
  6.353534863850383e-18,  1.788583161965106e+00,  3.959080269800322e-03, -4.884760420715568e-05,  3.929613672689430e-07, -1.738594164368130e-08, -3.345357124908196e-11,
  2.263102297597903e-11,  6.745669253995951e-13, -2.233846506918067e-14, -1.751963518307915e-15, -8.039592221491670e-18,  2.827671059492170e-18,  1.915547605734538e+00,
  1.588242648379651e-03, -2.042092417981629e-05,  1.916556068391076e-07, -7.361489416880421e-09,  2.792175413357393e-12,  8.147078340071778e-12,  2.509618948823321e-13,
 -8.305780859010889e-15, -6.385810598438833e-16, -2.612681482640852e-18,  1.028731354148336e-18,  1.984127542456503e+00,  2.991249747591000e-04, -3.921548974780588e-06,
  3.920258052588755e-08, -1.422667181188262e-09,  2.066565226597409e-12,  1.448015798731139e-12,  4.557394701632192e-14, -1.507930519021520e-15, -1.145344290943391e-16,
 -4.385573381229013e-19,  1.844889202660850e-19,  4.771109064523014e-01,  2.664949958182909e-02,  1.040242328609436e-04, -2.889853492740444e-05,  9.431241651401901e-08,
  5.533071056184222e-08, -5.030047220055740e-10, -1.155639177774380e-10,  1.457627946827857e-12,  2.475588142359530e-13, -3.608708490206549e-15, -5.375963466051952e-16,
  1.015865230088243e+00,  1.774867203006759e-02, -1.455627630755560e-04, -4.207580795900831e-06, -4.725609734955850e-09,  5.388066395299725e-09,  2.273741644361597e-10,
 -1.044798799806011e-11, -6.488719500258014e-13,  1.489987002708349e-14,  1.614969934369540e-15, -9.218105241226785e-18,  1.371322887345430e+00,  1.141703023087151e-02,
 -1.246269042070133e-04, -7.831444858094794e-07, -2.360455135872445e-08,  2.343041869235685e-09,  1.074242481602799e-10, -4.025206738919285e-12, -2.641508820611595e-13,
  4.415663171306820e-15,  5.988713507853496e-16, -6.350108244532615e-20,  1.624638980432744e+00,  6.837837754456977e-03, -8.285471801929408e-05,  1.836668125722855e-08,
 -1.956651607728970e-08,  1.223540826858546e-09,  5.151310905009610e-11, -1.844616156799401e-12, -1.230916888646677e-13,  1.871866510237490e-15,  2.670549780887000e-16,
  2.092477667668785e-19,  1.803661313634595e+00,  3.582596956794019e-03, -4.571512502234451e-05,  1.431999483567501e-07, -1.174405039504149e-08,  6.020939388328042e-10,
  2.324413013407938e-11, -8.229591992467468e-13, -5.555934507005892e-14,  8.187436385414985e-16,  1.174750523334423e-16,  9.861479432852517e-20,  1.921585683881209e+00,
  1.432154419402912e-03, -1.878684708465913e-05,  8.653185791325130e-08, -5.021035851250804e-09,  2.331856092035742e-10,  8.451535908287542e-12, -2.987473183708498e-13,
 -2.033857929777352e-14,  2.965815748277841e-16,  4.235076617637152e-17,  3.129440314795445e-20,  1.985263752219719e+00,  2.692643422403386e-04, -3.579366582455926e-06,
  1.894810007980388e-08, -9.737883372563615e-10,  4.320152126908943e-11,  1.511405085195801e-12, -5.345919614117049e-14, -3.657053633363315e-15,  5.315738902543480e-17,
  7.555696350847804e-18,  4.945286508503557e-21,  5.833129019552531e-01,  2.619529617041799e-02, -2.018925182309205e-04, -2.010978816475854e-05,  8.736401351064513e-07,
  1.602843860683000e-08, -2.147726667789740e-09,  1.332162509357005e-11,  4.276376212530026e-12, -1.132303766049795e-13, -7.024359141917184e-15,  3.752321627618865e-16,
  1.084221780968456e+00,  1.639040567839637e-02, -1.923425273819841e-04, -3.256094727609696e-06,  1.252808069143675e-07,  5.853619728986888e-09, -2.056660182448620e-10,
 -1.386979499773325e-11,  5.302734414723837e-13,  2.913618456419374e-14, -1.339312406652037e-15, -6.052298512041946e-17,  1.414933934533134e+00,  1.038022628452401e-02,
 -1.344294360369332e-04, -6.979818701221070e-07,  3.614020831743984e-08,  2.906138031455008e-09, -7.192656195271926e-11, -6.342509519993843e-12,  1.743505131142850e-13,
  1.279048196271887e-14, -3.973927954664320e-16, -2.617726633770256e-17,  1.650661400653473e+00,  6.172740872023073e-03, -8.355172705724930e-05, -5.585760469702163e-08,
  1.129328390406232e-08,  1.523073677988902e-09, -3.254047907431848e-11, -3.064852892872775e-12,  7.391123462412292e-14,  6.021812401162116e-15, -1.599749194515553e-16,
 -1.196779252801051e-17,  1.817268025183107e+00,  3.221615835963077e-03, -4.465733320493059e-05,  7.113642623714733e-08,  3.195565439159443e-09,  7.388448644925152e-10,
 -1.468285081850606e-11, -1.402158158725299e-12,  3.169443129524240e-14,  2.715460996101968e-15, -6.681613315800117e-17, -5.284253800065585e-18,  1.927018895132484e+00,
  1.285054770938847e-03, -1.805134551372469e-05,  5.059173839178243e-08,  6.943494169849788e-10,  2.824567869429229e-10, -5.406885750874990e-12, -5.159538013493501e-13,
  1.127307573571180e-14,  9.914096618193654e-16, -2.344647381122102e-17, -1.903665734257722e-18,  1.986284704479472e+00,  2.413491638634905e-04, -3.412450981094362e-06,
  1.154546299317328e-08,  7.786840824377289e-11,  5.192956861051357e-11, -9.768278106530349e-13, -9.294324552855404e-14,  1.998366364435920e-15,  1.779268272463614e-16,
 -4.130718311241896e-18, -3.392670035919646e-19,  6.836820108063554e-01,  2.386023588540863e-02, -3.569486368022735e-04, -6.023246455490414e-06,  7.685312667551888e-07,
 -2.045086343723636e-08, -6.651744183054299e-10,  6.356325871891803e-11, -9.383225509887139e-13, -9.261710347514313e-14,  4.991217976026192e-15,  1.729635573900134e-17,
  1.146515506531267e+00,  1.473611912795060e-02, -2.166532532488164e-04, -6.726000372377989e-07,  1.739702247039340e-07, -1.295157388944655e-09, -2.868257458295335e-10,
  7.547002502979444e-12,  4.574622724965199e-13, -2.590574462673715e-14, -4.131180004495922e-16,  6.503053017438465e-17,  1.454269562769317e+00,  9.284686774023148e-03,
 -1.378501084126276e-04,  2.064619077760897e-07,  6.715287744050438e-08, -4.251393503731041e-11, -1.321981453706794e-10,  2.295332597238806e-12,  2.270044558215247e-13,
 -8.922365274826985e-15, -2.897932717368616e-16,  2.357107189298273e-17,  1.674018187909611e+00,  5.506638869648914e-03, -8.233380764126146e-05,  3.037020900392273e-07,
  2.900329259361056e-08,  1.175451413199254e-10, -6.544427659170133e-11,  9.147292487619962e-13,  1.124445623476489e-13, -3.768364836566262e-15, -1.533387367549622e-16,
  1.005549567129398e-17,  1.829447861600021e+00,  2.869584933410612e-03, -4.310078869130734e-05,  2.109537158594018e-07,  1.214936270976057e-08,  9.359817614072095e-11,
 -3.053662953743318e-11,  3.768191043396319e-13,  5.202615726835964e-14, -1.600809490272489e-15, -7.257214262508851e-17,  4.281983417533416e-18,  1.931874887849363e+00,
  1.143624594059944e-03, -1.722491504146783e-05,  9.599883679616068e-08,  4.192662437032083e-09,  4.360327288124813e-11, -1.138978107714353e-11,  1.308734213396537e-13,
  1.925680286611638e-14, -5.650662165629067e-16, -2.711545419397109e-17,  1.512229710161458e-18,  1.987196498443496e+00,  2.146919270744795e-04, -3.238253224162397e-06,
  1.913156558554069e-08,  7.277381424648224e-10,  8.724172204627416e-12, -2.067028356452997e-12,  2.292607689972942e-14,  3.478664916303356e-15, -9.973425110790838e-17,
 -4.917192856164695e-18,  2.669142363652969e-19,  7.732042972260876e-01,  2.089051004665411e-02, -3.703092433513947e-04,  2.651295666172417e-06,  3.181838090314893e-07,
 -2.024340981700780e-08,  4.438493266280627e-10,  1.393005240026100e-11, -1.379529334858662e-12,  3.684322361603787e-14,  7.615520782991998e-16, -9.670391145609345e-17,
  1.202004094576939e+00,  1.301396809555041e-02, -2.098461950009294e-04,  1.620105646396381e-06,  1.012138214234947e-07, -4.845695997017097e-09, -6.489984010914586e-12,
  8.520605132400318e-12, -2.679786070624212e-13, -6.799101187119269e-15,  7.386966304905798e-16, -1.310651794038544e-17,  1.489242876589862e+00,  8.209030975467747e-03,
 -1.294262458883557e-04,  1.134136939885018e-06,  4.262750119437214e-08, -1.952342596236925e-09, -1.952192600958142e-11,  4.018666131695020e-12, -8.826032838830962e-14,
 -4.537129858996982e-15,  3.034653584090114e-16, -1.403910981675613e-18,  1.694761238849496e+00,  4.870125791581519e-03, -7.606653920493449e-05,  7.153951236056774e-07,
  1.920624432201232e-08, -8.856505806806347e-10, -1.339367001263582e-11,  1.986217202970801e-12, -3.570451628477227e-14, -2.458015688433423e-15,  1.371920222661807e-16,
  2.197408822631184e-19,  1.840257183078989e+00,  2.538121379509468e-03, -3.945401303229878e-05,  3.866665122449693e-07,  8.250393317878563e-09, -3.885966348698647e-10,
 -7.197886908387526e-12,  9.221262243914799e-13, -1.466473618159472e-14, -1.184850186056708e-15,  6.021737713004000e-17,  3.070189052270247e-19,  1.936182671750934e+00,
  1.011553689441532e-03, -1.568396940529686e-05,  1.574164789501240e-07,  2.891523562135090e-09, -1.391277413566136e-10, -2.883402133626163e-12,  3.424547368179853e-13,
 -5.059071742826280e-15, -4.478324222427417e-16,  2.161600871743274e-17,  1.534590589756582e-19,  1.988005185184645e+00,  1.898997371987341e-04, -2.940754381722664e-06,
  2.986925734370855e-08,  5.060129777360436e-10, -2.469167816011364e-11, -5.410585493374801e-13,  6.198919039753594e-14, -8.818286639332293e-16, -8.169624134949805e-17,
  3.845197069688911e-18,  3.113051525219830e-20,  8.511296753102460e-01,  1.811518561512933e-02, -3.192517040220051e-04,  5.141368309495817e-06,  3.108770882921783e-08,
 -8.623617134288832e-09,  4.210474902406013e-10, -9.001288437309596e-12, -1.657603599998740e-13,  2.103062629780238e-14, -7.750718048135151e-16,  7.114223582705697e-18,
  1.250855043150609e+00,  1.143340053490812e-02, -1.837371179083623e-04,  2.518256529011410e-06,  1.672531786278668e-08, -3.166462409000375e-09,  1.071899959332526e-10,
  2.033122042940542e-13, -1.721190447326236e-13,  6.830157619144235e-15, -1.491832321105864e-17, -1.018532742835321e-17,  1.520106821801935e+00,  7.236683565000393e-03,
 -1.130073343971654e-04,  1.509687050507998e-06,  5.998001268153076e-09, -1.465669644445077e-09,  4.343290740562776e-11,  5.197282694747091e-13, -8.739339703066290e-14,
  2.632415502327468e-15,  3.233426132775434e-17, -5.391682895408906e-18,  1.713084605086526e+00,  4.299778782812710e-03, -6.623459431937448e-05,  8.794191308565822e-07,
  1.899709411681106e-09, -7.152817074809051e-10,  1.980593809234154e-11,  3.553040946256842e-13, -4.436713849280378e-14,  1.153210022885245e-15,  2.429648425506246e-17,
 -2.707443936468960e-18,  1.849810150677043e+00,  2.242680171724151e-03, -3.428794511545585e-05,  4.545897894645360e-07,  4.594741927206935e-10, -3.280933440734740e-10,
  8.740949639054034e-12,  1.904085555070302e-13, -2.085119719814106e-14,  4.960357149129577e-16,  1.326665174489786e-17, -1.255142885420283e-18,  1.939990724986897e+00,
  8.942028808555644e-04, -1.361357332611737e-05,  1.804582846779628e-07,  5.710002109784458e-11, -1.206880425034277e-10,  3.145201237205069e-12,  7.609321567372699e-14,
 -7.790196763072222e-15,  1.757914215275521e-16,  5.323993583416202e-18, -4.642210754710682e-19,  1.988720144369993e+00,  1.679055544755595e-04, -2.550908735895440e-06,
  3.381751519195860e-08, -1.298317430029795e-12, -2.172249181107492e-11,  5.599402797528987e-13,  1.425756567373655e-14, -1.413956300237590e-15,  3.105930719447691e-17,
  9.982024940144728e-19, -8.378529566840588e-20,  9.188717425076592e-01,  1.580642866763233e-02, -2.587284078465434e-04,  4.718596053029251e-06, -6.158433744668999e-08,
 -1.633822458663207e-09,  1.713947678371147e-10, -7.197368461024407e-12,  1.583691615171133e-13,  8.060235389242707e-16, -2.278831521830868e-16,  1.018744721691810e-17,
  1.293841428617527e+00,  1.008499803782685e-02, -1.535651486581999e-04,  2.412482519744674e-06, -2.273552742954620e-08, -9.401216783120841e-10,  6.853763885143775e-11,
 -2.024275440398981e-12,  4.681838654893551e-15,  2.425764988287125e-15, -1.160734031568700e-16,  2.112386097084376e-18,  1.547360011572710e+00,  6.404866901368862e-03,
 -9.509684759533630e-05,  1.428181988668345e-06, -1.297135452615483e-08, -4.770890605152547e-10,  3.285355897320467e-11, -8.376598546980450e-13, -5.982669099771260e-15,
  1.366523470234669e-15, -5.186384746356940e-17,  4.782173458656937e-19,  1.729290318625949e+00,  3.811718307045179e-03, -5.588419263296332e-05,  8.222112865886638e-07,
 -7.503936562960411e-09, -2.405762271024247e-10,  1.640357559345690e-11, -3.854242457505035e-13, -4.972273075066907e-15,  7.244609104752622e-16, -2.452711581978295e-17,
  1.032502220633381e-19,  1.858266430632770e+00,  1.989901533131327e-03, -2.896619133183512e-05,  4.215300197123459e-07, -3.886276364547506e-09, -1.117717197422819e-10,
  7.646246690618188e-12, -1.710027300724188e-13, -2.841720688128483e-15,  3.481689268960301e-16, -1.103318203254176e-17,  1.255537871611437e-20,  1.943363250069155e+00,
  7.938168471345194e-04, -1.150802209881676e-05,  1.664633129684897e-07, -1.547358191985502e-09, -4.131213747697937e-11,  2.843068132913919e-12, -6.173776659340311e-14,
 -1.169196967545214e-15,  1.316631374045915e-16, -4.014172223575696e-18, -2.869881335216298e-21,  1.989353484560976e+00,  1.490932489193904e-04, -2.157013420452479e-06,
  3.110976332962595e-08, -2.905539140951300e-10, -7.447113437232710e-12,  5.147420945025160e-13, -1.101118516065042e-14, -2.219193955560681e-16,  2.403736316738855e-17,
 -7.187139192045427e-19, -1.197368992767842e-21,  9.782909572164408e-01,  1.394501310555903e-02, -2.085343324898788e-04,  3.636992117385298e-06, -6.654570823078140e-08,
  6.161079426022714e-10,  3.678644964805814e-11, -2.734811687627820e-12,  1.033635742693232e-13, -2.328512242116946e-15,  9.480885104517030e-18,  1.808668102970214e-18,
  1.331897732069813e+00,  8.965151906666590e-03, -1.271791752349996e-04,  1.969458595252080e-06, -2.935103803896777e-08,  9.509776444004953e-11,  2.184078675614950e-11,
 -1.175468834507504e-12,  3.268519786714935e-14, -2.450996273001881e-16, -2.434936801686087e-17,  1.385778498398092e-18,  1.571560836722152e+00,  5.708630258805282e-03,
 -7.940173702777446e-05,  1.179236403268446e-06, -1.649442029150544e-08,  4.094558060853164e-11,  1.161887491092743e-11, -5.783689475977233e-13,  1.406218387092848e-14,
 -2.453782035871775e-20, -1.560315813873435e-17,  7.025912247628052e-19,  1.743702321517212e+00,  3.401824480684667e-03, -4.683778455483153e-05,  6.812996480959933e-07,
 -9.266449995549331e-09,  2.347665147279580e-11,  6.083219255848211e-12, -2.929656226483392e-13,  6.599079526202077e-15,  3.027884149257182e-17, -8.721957877137201e-18,
  3.544609974869768e-19,  1.865792969017765e+00,  1.777234856249336e-03, -2.432701265978300e-05,  3.497437239184131e-07, -4.688945621461816e-09,  1.272395885569701e-11,
  2.908211645082734e-12, -1.377994494640128e-13,  2.961994945980932e-15,  2.234092521270921e-17, -4.309542817734481e-18,  1.655375962747998e-19,  1.946366389946924e+00,
  7.092802555762508e-04, -9.675953520814986e-06,  1.381847778714080e-07, -1.838423786794952e-09,  5.276230505601386e-12,  1.096440144490234e-12, -5.152526522023764e-14,
  1.076800096855975e-15,  1.009801988322065e-17, -1.654722170025379e-18,  6.155541177480483e-20,  1.989917588011068e+00,  1.332438715038560e-04, -1.814632917237329e-06,
  2.582967282660647e-08, -3.423826368619391e-10,  1.014425063101923e-12,  1.998483369613732e-13, -9.356201205278432e-15,  1.927340394154935e-16,  1.992084327564571e-18,
 -3.043496558244570e-19,  1.114270586845334e-20,  1.030986816464217e+00,  1.243435652127751e-02, -1.707738181985141e-04,  2.698552688371934e-06, -4.997598872718594e-08,
  8.816623735563591e-10, -4.972719324470507e-12, -6.012042551283120e-13,  3.658966384306560e-14, -1.272149523492083e-15,  2.879342822590383e-17, -2.743454957621827e-19,
  1.365862246550146e+00,  8.034551187732006e-03, -1.062341325810798e-04,  1.534323269858972e-06, -2.431359166038431e-08,  3.300443654367104e-10,  1.451481781254038e-12,
 -3.681281341373983e-13,  1.676178687068231e-14, -4.500391207083658e-16,  5.250399086900152e-18,  1.713904073731563e-19,  1.593208395099998e+00,  5.125670178773863e-03,
 -6.677117022437306e-05,  9.324047977004605e-07, -1.394745359492622e-08,  1.732779389798811e-10,  1.155442508388754e-12, -2.005551232645322e-13,  8.447527135227802e-15,
 -2.024907890453734e-16,  1.254612690237304e-18,  1.317707432538845e-19,  1.756608532488228e+00,  3.057379218579495e-03, -3.951717445009860e-05,  5.423600816682442e-07,
 -7.880422979929170e-09,  9.415313544864701e-11,  6.699670197924100e-13, -1.066899557829208e-13,  4.333436926384106e-15, -9.736445745483867e-17,  2.806047363348835e-19,
  7.863769078277521e-20,  1.872537505738783e+00,  1.598169313223850e-03, -2.056266324678654e-05,  2.794299242591052e-07, -3.993840697026959e-09,  4.679346000277815e-11,
  3.312859100290285e-13, -5.156637985116006e-14,  2.053671123724671e-15, -4.434695041166329e-17,  3.419369511813136e-20,  4.015834986364834e-20,  1.949058511449881e+00,
  6.380206074266335e-04, -8.187280711197113e-06,  1.106242385952890e-07, -1.566350076828655e-09,  1.816680647848455e-11,  1.262325388878695e-13, -1.958018451350162e-14,
  7.713482466706233e-16, -1.626378434166132e-17, -8.617779272286200e-21,  1.569761943477732e-20,  1.990423364638784e+00,  1.198763490333567e-04, -1.536244574833939e-06,
  2.069812235159340e-08, -2.917047794290045e-10,  3.367289306873086e-12,  2.306826408876096e-14, -3.582562097030395e-15,  1.403863346542780e-16, -2.924106185637024e-18,
 -3.524960856509804e-21,  2.912336652285644e-21,  1.078179449381642e+00,  1.118538062742301e-02, -1.426389321015119e-04,  2.029706061823907e-06, -3.436876100399910e-08,
  6.575634634772084e-10, -1.087711202747349e-11,  3.068271427031860e-14,  7.951484829086080e-15, -4.218395698905803e-16,  1.366867118435177e-17, -3.061370729843974e-19,
  1.396408637561535e+00,  7.252212723788038e-03, -8.993973463727207e-05,  1.197415860055559e-06, -1.794354707789927e-08,  2.884897447461825e-10, -3.448021320915430e-12,
 -4.354708512008221e-14,  5.022987810016832e-15, -2.042058024114164e-16,  5.325098032647913e-18, -7.706064661204590e-20,  1.612708594379120e+00,  4.632728179482971e-03,
 -5.680609634752634e-05,  7.370357359253931e-07, -1.052826324782839e-08,  1.579697882563000e-10, -1.660184093128575e-12, -3.046721534023315e-14,  2.785837882284099e-15,
 -1.052167918796821e-16,  2.498523508969798e-18, -2.643141966165464e-20,  1.768244158739493e+00,  2.765276383983415e-03, -3.370258670324587e-05,  4.314379605399468e-07,
 -6.010623077555280e-09,  8.701187928804194e-11, -8.609576773063362e-13, -1.767796412561470e-14,  1.498006603693722e-15, -5.460965376790313e-17,  1.229752089413378e-18,
 -1.015434450934925e-20,  1.878620978328017e+00,  1.446066293144372e-03, -1.756168959924643e-05,  2.230718336256743e-07, -3.063055970565104e-09,  4.344031583684838e-11,
 -4.168064005830796e-13, -8.894765187589291e-15,  7.290321609709167e-16, -2.605903921606640e-17,  5.681082784987782e-19, -3.860812013652198e-21,  1.951487440191933e+00,
  5.774342157533777e-04, -6.998039453364821e-06,  8.849096339916913e-08, -1.204934204491895e-09,  1.688772286052037e-11, -1.594672303818745e-13, -3.446038286331687e-15,
  2.780080199431304e-16, -9.827376926740872e-18,  2.101219538228616e-19, -1.240324060511666e-21,  1.990879757991328e+00,  1.085057358376828e-04, -1.313624783029777e-06,
  1.657350294893767e-08, -2.247254839783446e-10,  3.131143027774563e-12, -2.934826638279496e-14, -6.363393918194991e-16,  5.098100488736748e-17, -1.792268097393959e-18,
  3.794243743606837e-20, -2.064638884153612e-22,  1.120781014365215e+00,  1.013325713112359e-02, -1.211920965505745e-04,  1.571494253382018e-06, -2.365754000870498e-08,
  4.247247856897373e-10, -8.122543215438159e-12,  1.246724266156574e-13, -1.316446998578380e-16, -8.906931523296249e-17,  4.271509851037107e-18, -1.302124274454211e-19,
  1.424063106085277e+00,  6.585698463179756e-03, -7.711799539717204e-05,  9.518195629916224e-07, -1.303018463641701e-08,  2.037780868955365e-10, -3.268229343036032e-12,
  3.394679882703699e-14,  6.835081004705320e-16, -5.807161278200709e-17,  2.167502568352547e-18, -5.489818086736115e-20,  1.630382879232796e+00,  4.211018645119512e-03,
 -4.887557467420712e-05,  5.915464454058737e-07, -7.796894518760018e-09,  1.150877461413312e-10, -1.712204754689140e-12,  1.473288755082903e-14,  4.692369290467599e-16,
 -3.271164478164429e-17,  1.139238955995005e-18, -2.669963723370558e-20,  1.778796668646482e+00,  2.514854276083287e-03, -2.904882951640951e-05,  3.479762220879188e-07,
 -4.495672710474261e-09,  6.432167141658345e-11, -9.191463554034684e-13,  7.158528430289685e-15,  2.734416281160129e-16, -1.774593162958439e-17,  5.976168122128800e-19,
 -1.340919440722340e-20,  1.884140115995827e+00,  1.315509309367885e-03, -1.515210943114816e-05,  1.804229748286298e-07, -2.303975270502369e-09,  3.236322519438045e-11,
 -4.517123889898879e-13,  3.329987183868647e-15,  1.384617030172784e-16, -8.683490478449922e-18,  2.869694012432596e-19, -6.270976591582373e-21,  1.953691503057080e+00,
  5.253939402977833e-04, -6.041403411409415e-06,  7.168773973073406e-08, -9.092602634832810e-10,  1.263514177556987e-11, -1.739621938773859e-13,  1.244612766701962e-15,
  5.391813300374665e-17, -3.322271967917467e-18,  1.086210346600049e-19, -2.336442508963897e-21,  1.991293942167999e+00,  9.873563212472040e-05, -1.134383843526217e-06,
  1.343720082476782e-08, -1.698536554841095e-10,  2.347503844888320e-12, -3.210011290873849e-14,  2.264042577054006e-16,  9.986294063090261e-18, -6.102707955687246e-19,
  1.984664709763968e-20, -4.234785608685143e-22,  1.159486089901479e+00,  9.233299755465248e-03, -1.043561213750137e-04,  1.251487803136740e-06, -1.684121258623500e-08,
  2.691765552215385e-10, -4.991958420168790e-12,  9.304272089187298e-14, -1.329093978762317e-15,  4.317817904557084e-19,  8.662665631626730e-19, -3.849710365646374e-20,
  1.449239722289126e+00,  6.011181397821263e-03, -6.682542349265648e-05,  7.720272688522429e-07, -9.655589342918427e-09,  1.377812269142983e-10, -2.230311783359551e-12,
  3.509379770034844e-14, -3.210845157907011e-16, -8.114839242207707e-18,  5.836576662976302e-19, -2.034535175230257e-20,  1.646487121453621e+00,  3.846448729577625e-03,
 -4.245636189317946e-05,  4.831369799953179e-07, -5.867524514269564e-09,  7.981693392145000e-11, -1.215599011063235e-12,  1.770970540045248e-14, -1.248916067438734e-16,
 -5.593058808022372e-18,  3.335503468803436e-19, -1.088492030260466e-20,  1.788416143897483e+00,  2.298034046269251e-03, -2.526591419987618e-05,  2.852181479089621e-07,
 -3.410477517672705e-09,  4.520485762753020e-11, -6.653452368486344e-13,  9.287812921725258e-15, -5.580111199883299e-17, -3.281026777034896e-18,  1.823944687445558e-19,
 -5.764997104885841e-21,  1.889172607160065e+00,  1.202371603860466e-03, -1.318866205049705e-05,  1.481861429151983e-07, -1.755958761990893e-09,  2.291981719623703e-11,
 -3.304629166190808e-13,  4.497181400486823e-15, -2.447731114110836e-17, -1.670103297197496e-18,  8.967806476889233e-20, -2.784025649188791e-21,  1.955701539024121e+00,
  4.802742062833361e-04, -5.260796888360154e-06,  5.894855019931006e-08, -6.948525792335008e-10,  8.988104925229131e-12, -1.280145685439436e-13,  1.716261776080037e-15,
 -8.812654420322942e-18, -6.526622662018157e-19,  3.440851596683081e-20, -1.057297354311539e-21,  1.991671694935587e+00,  9.026265565774760e-05, -9.880226412499922e-07,
  1.105587657279907e-08, -1.299763877137039e-10,  1.673631285487261e-12, -2.368901614703003e-14,  3.152071621161327e-16, -1.571973449615366e-18, -1.211151824825853e-19,
  6.329725968231176e-21, -1.935086444935150e-22,  1.194838728135698e+00,  8.454312298378732e-03, -9.079623747997064e-05,  1.019388420641620e-06, -1.246885716586091e-08,
  1.760123059346996e-10, -2.947445188614282e-12,  5.491560341123950e-14, -9.831194338512633e-16,  1.320270702476688e-17, -5.792356738141435e-21, -7.419389646856209e-21,
  1.472270461654400e+00,  5.511201096588232e-03, -5.840566041394226e-05,  6.369855413173706e-07, -7.362325453851716e-09,  9.473893410044554e-11, -1.411651110783071e-12,
  2.326209938554465e-14, -3.551241054622858e-16,  2.964838484061841e-18,  7.941947497243462e-20, -5.181970395720120e-21,  1.661228227817295e+00,  3.528504264064692e-03,
 -3.717401857579775e-05,  4.006009885420161e-07, -4.525616604406359e-09,  5.602773380442307e-11, -7.920941738056638e-13,  1.231402609660353e-14, -1.741896118597723e-16,
  1.052967527190389e-18,  5.563142957204440e-20, -3.003491944750868e-21,  1.797224476414704e+00,  2.108733049119138e-03, -2.214344683856241e-05,  2.370994757550941e-07,
 -2.646355354146171e-09,  3.208621931770003e-11, -4.404028245052758e-13,  6.619136045221732e-15, -8.963585662438569e-17,  4.311798318977816e-19,  3.292930825703310e-20,
 -1.654903379695300e-21,  1.893781705495317e+00,  1.103529864218179e-03, -1.156515716624066e-05,  1.233677608884649e-07, -1.367293546635375e-09,  1.637536997529084e-11,
 -2.207730831169435e-13,  3.249710340907651e-15, -4.285755862537956e-17,  1.759176898160171e-19,  1.685545413664187e-20, -8.173385123391250e-22,  1.957542693106742e+00,
  4.408410171292670e-04, -4.614685903107589e-06,  4.911763973165706e-08, -5.421500416948193e-10,  6.446407766004067e-12, -8.598810063844658e-14,  1.249910420602820e-15,
 -1.622644618548043e-17,  6.011494632198582e-20,  6.609497584441937e-21, -3.144378829882337e-22,  1.992017730650305e+00,  8.285616059985555e-05, -8.668174518301773e-07,
  9.216006086833180e-09, -1.015155033918588e-10,  1.202684657545806e-12, -1.595560151052607e-14,  2.304394242625863e-16, -2.967761078961504e-18,  1.041125413069509e-20,
  1.228704108931650e-21, -5.792127143186593e-23,  1.227276247159939e+00,  7.773726436520535e-03, -7.965558205117867e-05,  8.446695559470644e-07, -9.548003040546615e-09,
  1.205961032118366e-10, -1.781757445562375e-12,  3.058547121196412e-14, -5.602739784269068e-16,  9.574204757769543e-18, -1.223658740028990e-19,  1.412203636076160e-22,
  1.493426535268539e+00,  5.072661620882781e-03, -5.141149974823855e-05,  5.327055287779635e-07, -5.759751717510559e-09,  6.750300829950816e-11, -9.009817641227337e-13,
  1.389058398091238e-14, -2.289052747253617e-16,  3.373509564915676e-18, -2.685866305635093e-20, -6.611196472801571e-22,  1.674776272898133e+00,  3.249188984613203e-03,
 -3.276733917349930e-05,  3.362291239304216e-07, -3.570303982966185e-09,  4.057033801985040e-11, -5.177500229212077e-13,  7.582021921442369e-15, -1.185861928609114e-16,
  1.623510628096315e-18, -9.094913388788501e-21, -4.760827242218640e-22,  1.805322176776524e+00,  1.942291770560459e-03, -1.953282792482367e-05,  1.993747321991405e-07,
 -2.096905995270831e-09,  2.343702879369795e-11, -2.917284239483966e-13,  4.145616382956987e-15, -6.285091405328916e-17,  8.240293746304223e-19, -3.513527288088671e-21,
 -2.851854116989215e-22,  1.898019663981016e+00,  1.016581518377343e-03, -1.020605096418874e-05,  1.038514933464034e-07, -1.086165147836483e-09,  1.202283197936466e-11,
 -1.474241194525978e-13,  2.056264623005947e-15, -3.057020650541466e-17,  3.902355292596039e-19, -1.352452682445269e-21, -1.469493124806515e-22,  1.959235759023831e+00,
  4.061428367685519e-04, -4.073399159971353e-06,  4.137341838962898e-08, -4.313141386660601e-10,  4.747265906870758e-12, -5.769527803450564e-14,  7.956980986969605e-16,
 -1.168902387473787e-17,  1.468348266999819e-19, -4.403996030333267e-22, -5.784370356984189e-23,  1.992335949900260e+00,  7.633808009593408e-05, -7.652389474613816e-07,
  7.765389126155208e-09, -8.082160566302223e-11,  8.870311408705974e-13, -1.073181152083107e-14,  1.471509170890464e-16, -2.148396545692659e-18,  2.676696009481233e-20,
 -7.402286797063708e-23, -1.077379125670099e-23,  1.257157416307808e+00,  7.174598383727752e-03, -7.036337229634977e-05,  7.091319506131940e-07, -7.503573903504379e-09,
  8.637036334350071e-11, -1.131043481717427e-12,  1.727257850010530e-14, -2.974009275443576e-16,  5.282524948910743e-18, -8.606561171321827e-20,  1.059214502235245e-21,
  1.512932998026452e+00,  4.685468408058103e-03, -4.553089488107891e-05,  4.502938058080296e-07, -4.598254925031750e-09,  4.982287297087762e-11, -5.980106353948578e-13,
  8.271059323602942e-15, -1.299542789330027e-16,  2.110845000251992e-18, -3.001476481854471e-20,  2.372308629421270e-22,  1.687273010006385e+00,  3.002275756360741e-03,
 -2.905056932147455e-05,  2.849854953948604e-07, -2.867959671052228e-09,  3.031387735274698e-11, -3.504510883138321e-13,  4.627090596511416e-15, -6.942627005934183e-17,
  1.077756236038612e-18, -1.429192389296335e-20,  8.050558994262239e-23,  1.812793209954717e+00,  1.795062109149482e-03, -1.732729920313285e-05,  1.692294623288735e-07,
 -1.689841204735399e-09,  1.762721013645344e-11, -1.996393467342491e-13,  2.566235681799712e-15, -3.744597025470104e-17,  5.655087270050967e-19, -7.192003575093110e-21,
  3.087322280493717e-23,  1.901930191495165e+00,  9.396396608227886e-04, -9.056743496819374e-06,  8.822201058743691e-08, -8.769450156125375e-10,  9.077396262176315e-12,
 -1.015575333711781e-13,  1.284126620119334e-15, -1.840894089088981e-17,  2.731731874795654e-19, -3.384357552269571e-21,  1.173902515201507e-23,  1.960798143679737e+00,
  3.754310119065183e-04, -3.615415806197257e-06,  3.516359528520052e-08, -3.486095037311649e-10,  3.592338911405481e-12, -3.990217413580493e-14,  4.995570449763300e-16,
 -7.084075049202143e-18,  1.039909904422715e-19, -1.268031704529844e-21,  3.773939997024404e-24,  1.992629619202492e+00,  7.056818751088663e-05, -6.792695272652908e-07,
  6.601446308331427e-09, -6.535938054875175e-11,  6.719948732955228e-13, -7.437053674267150e-15,  9.263686984607653e-17, -1.306275294293800e-18,  1.906820199031049e-20,
 -2.306193389431649e-22,  6.286472890794927e-25,  1.284781170467810e+00,  6.643811212581336e-03, -6.252149787906013e-05,  6.015662674100004e-07, -6.013334469617176e-09,
  6.410765546827996e-11, -7.562860914986512e-13,  1.022112063030907e-14, -1.586291632224650e-16,  2.692950002317460e-18, -4.602658818850094e-20,  7.159578707088597e-22,
  1.530978927842172e+00,  4.341655650243473e-03, -4.053824798353203e-05,  3.839846892191400e-07, -3.728720282214810e-09,  3.784226255777892e-11, -4.147384311791144e-13,
  5.119321414063122e-15, -7.275403852315545e-17,  1.146636082543180e-18, -1.817727641157645e-20,  2.498600031331148e-22,  1.698837918779372e+00,  2.782813730441410e-03,
 -2.588743023742839e-05,  2.435313281515219e-07, -2.336455145797271e-09,  2.323882501338986e-11, -2.468991113506323e-13,  2.924776535370366e-15, -3.979084497034608e-17,
  6.032349519732450e-19, -9.199635539346132e-21,  1.185280241290784e-22,  1.819708467475583e+00,  1.664132307099194e-03, -1.544791835244808e-05,  1.447742435556594e-07,
 -1.380017131733527e-09,  1.357963290778432e-11, -1.418741116425797e-13,  1.642063914404851e-15, -2.176425657461250e-17,  3.220646765509892e-19, -4.795779975452773e-21,
  5.940286121713107e-23,  1.905550227544361e+00,  8.711948337650562e-04, -8.076673233043409e-06,  7.552197747844069e-08, -7.171672480114848e-10,  7.013106032240325e-12,
 -7.254784958584525e-14,  8.279228004964662e-16, -1.079442317195848e-17,  1.572511912654996e-19, -2.305886969209465e-21,  2.785866296399702e-23,  1.962244566441597e+00,
  3.481058604325166e-04, -3.224704803248663e-06,  3.011292090129329e-08, -2.853251934290461e-10,  2.780044280105824e-12, -2.859201756228374e-14,  3.235610483642727e-16,
 -4.176360588654029e-18,  6.024993640748041e-20, -8.751136375543320e-22,  1.041277209175564e-23,  1.992901501524284e+00,  6.543408544914479e-05, -6.059123480004975e-07,
  5.654321918678650e-09, -5.351622023567544e-11,  5.204810245301842e-13, -5.337364952448591e-15,  6.014181321735968e-17, -7.722561827541204e-19,  1.108429296688158e-20,
 -1.601994217461509e-22,  1.891232427359285e-24,  1.310399602212018e+00,  6.170970264602510e-03, -5.584062297660459e-05,  5.147119626999190e-07, -4.892134584056266e-09,
  4.889575399718374e-11, -5.287969391136685e-13,  6.395511000719583e-15, -8.827001156332680e-17,  1.369665451846681e-18, -2.265711382730080e-20,  3.712319064530703e-22,
  1.547724761166972e+00,  4.034820950410003e-03, -3.626504207770421e-05,  3.298835538603527e-07, -3.061016060066523e-09,  2.937917722341655e-11, -2.986705139592768e-13,
  3.331003016826229e-15, -4.219258183403872e-17,  6.085916097158745e-19, -9.493583064076543e-21,  1.460014702715122e-22,  1.709572630092201e+00,  2.586801636323273e-03,
 -2.317498890906674e-05,  2.095697905850386e-07, -1.924967971205665e-09,  1.816985405834619e-11, -1.800177009684787e-13,  1.937395240995806e-15, -2.355235003220526e-17,
  3.270731735895298e-19, -4.943920021430351e-21,  7.356537710000630e-23,  1.826128328714077e+00,  1.547142270694523e-03, -1.383470621301419e-05,  1.246960485954625e-07,
 -1.139115757402040e-09,  1.065719865076903e-11, -1.041395530486809e-13,  1.098892091252523e-15, -1.304210559663895e-17,  1.769107856460122e-19, -2.620940708867018e-21,
  3.820711265407076e-23,  1.908911257710360e+00,  8.100215151177170e-04, -7.234915371362029e-06,  6.508203685843877e-08, -5.926205449298060e-10,  5.515758448214364e-12,
 -5.346453728049379e-14,  5.575404193938143e-16, -6.519302859405702e-18,  8.710143780782058e-20, -1.273450432123801e-21,  1.831869082486103e-23,  1.963587578907094e+00,
  3.236800314646076e-04, -2.889019100489010e-06,  2.595807296989425e-08, -2.359229092815673e-10,  2.189234639052642e-12, -2.112044392605172e-14,  2.187148561846674e-16,
 -2.534471476242660e-18,  3.354484615546036e-20, -4.863692783628703e-22,  6.938782059661081e-24,  1.993153953436075e+00,  6.084438627199422e-05, -5.428756167171891e-07,
  4.874906063921814e-09, -4.426418146595713e-11,  4.101278156237174e-13, -3.947290455700420e-15,  4.073196345436564e-17, -4.698213073615292e-19,  6.187870026246258e-21,
 -8.932658435818672e-23,  1.268878271524965e-24,  1.334227365519037e+00,  5.747690916780721e-03, -5.010353308828514e-05,  4.436272493743815e-07, -4.028102462891507e-09,
  3.807435356257522e-11, -3.829378901362732e-13,  4.212632088852518e-15, -5.196585725879158e-17,  7.231938343105010e-19, -1.107258460830368e-20,  1.771394373425243e-22,
  1.563307755883418e+00,  3.759744701134830e-03, -3.258208774386170e-05,  2.852477009819605e-07, -2.538269936715765e-09,  2.319564005382468e-11, -2.214682854998417e-13,
  2.269148268289046e-15, -2.579753307760642e-17,  3.329902476538326e-19, -4.813221402525038e-21,  7.357102797788912e-23,  1.719564259527337e+00,  2.410963662571174e-03,
 -2.083366965210387e-05,  1.814597754809493e-07, -1.600779608434603e-09,  1.442488702741227e-11, -1.347910285006183e-13,  1.339548812414449e-15, -1.466675646986511e-17,
  1.822827396265704e-19, -2.554163174421745e-21,  3.807785757519553e-23,  1.832104602281848e+00,  1.442155557242443e-03, -1.244108818377965e-05,  1.080492321303290e-07,
 -9.486941411381381e-10,  8.485152748350194e-12, -7.838303356186701e-14,  7.661314948518933e-16, -8.210604956064265e-18,  9.973445219622696e-20, -1.369986960988759e-21,
  2.009470742722996e-23,  1.912040314306627e+00,  7.551128928772955e-04, -6.507394378676628e-06,  5.641782934177018e-08, -4.939830648768028e-10,  4.398950987163636e-12,
 -4.036447878858511e-14,  3.906652058240811e-16, -4.132371973562321e-18,  4.947168260644883e-20, -6.707126304794655e-22,  9.731670607216914e-24,  1.964837961120183e+00,
  3.017528535497731e-04, -2.598809821008312e-06,  2.250797326881337e-08, -1.967541517076195e-10,  1.747662693246114e-12, -1.597395919830818e-14,  1.537110174162414e-16,
 -1.613241188596869e-18,  1.914156522280728e-20, -2.573795075689966e-22,  3.708779269357973e-24,  1.993388999248690e+00,  5.672392873429326e-05, -4.883711031231052e-07,
  4.227511961737292e-09, -3.692458306049748e-11,  3.275635721682736e-13, -2.988129198537332e-15,  2.866968155661998e-17, -2.996960311570446e-19,  3.539555555995733e-21,
 -4.738726655426220e-23,  6.803567840120130e-25,  1.356448713978228e+00,  5.367115931303631e-03, -4.514309033082303e-05,  3.848071598992455e-07, -3.349845319819461e-09,
  3.013271843471769e-11, -2.848824547767048e-13,  2.893974894596347e-15, -3.233351101506682e-17,  4.033850772140431e-19, -5.592730261043894e-21,  8.367030006758504e-23,
  1.577846169657417e+00,  3.512122961390723e-03, -2.938836033519872e-05,  2.480779437146099e-07, -2.122802575511469e-09,  1.855944042520683e-11, -1.679196429042759e-13,
  1.603778417393597e-15, -1.661822715906108e-17,  1.921156195799359e-19, -2.503304631598231e-21,  3.585417050392812e-23,  1.728887979248616e+00,  2.252589806090044e-03,
 -1.880084341657404e-05,  1.579913858346759e-07, -1.341844309193115e-09,  1.159238750083523e-11, -1.029915326689898e-13,  9.583492639980627e-16, -9.602035809993239e-18,
  1.069929544363834e-19, -1.349417713047612e-21,  1.886257024459988e-23,  1.837682030752441e+00,  1.347567437657334e-03, -1.123028419629492e-05,  9.413233734513121e-08,
 -7.962060408247813e-10,  6.834668743361757e-12, -6.013640751993438e-14,  5.517753513560519e-16, -5.425852724892198e-18,  5.916553470147201e-20, -7.311480603521086e-22,
  1.005754168327758e-23,  1.914960754039633e+00,  7.056337921408978e-04, -5.875060435276385e-06,  4.916876688711069e-08, -4.148763470439342e-10,  3.548003626752759e-12,
 -3.104199801129875e-14,  2.824805695451578e-16, -2.746646512989377e-18,  2.954970150741547e-20, -3.603599657893786e-22,  4.903798190960031e-24,  1.966005029969843e+00,
  2.819917685503587e-04, -2.346512794790144e-06,  1.962006872198085e-08, -1.653137132031227e-10,  1.410673940086844e-12, -1.230170226981282e-14,  1.114056414877867e-16,
 -1.076016710003437e-18,  1.148201169423271e-20, -1.388715315447325e-22,  1.876794058013971e-24,  1.993608388763959e+00,  5.301031085881155e-05, -4.409814475835267e-07,
  3.685487112201835e-09, -3.103058423831295e-11,  2.645037579191131e-13, -2.302790796709968e-15,  2.080370816092546e-17, -2.002528978962353e-19,  2.127895351126607e-21,
 -2.562533892853861e-23,  3.450544693494121e-25,  1.377222904764658e+00,  5.023574311404972e-03, -4.082823475077180e-05,  3.356849881404231e-07, -2.809551614308277e-09,
  2.416303182108157e-11, -2.164243466662783e-13,  2.054719790390747e-15, -2.109363405425137e-17,  2.381896662108523e-19, -2.976936311741395e-21,  4.070398098671349e-23,
  1.591442521993739e+00,  3.288373277116354e-03, -2.660363483885187e-05,  2.168779082278074e-07, -1.788562847310656e-09,  1.501391550000037e-11, -1.295409792898855e-13,
  1.166015736487624e-15, -1.118353438588332e-17,  1.172369175261198e-19, -1.370595835580671e-21,  1.785024673990839e-23,  1.737609039239821e+00,  2.109418454416492e-03,
 -1.702652438325099e-05,  1.382508989587343e-07, -1.132706569409570e-09,  9.411097968863746e-12, -7.994631611676562e-14,  7.037119519918692e-16, -6.552530137010187e-18,
  6.635429497748042e-20, -7.500404682830865e-22,  9.512410907415446e-24,  1.842899477355536e+00,  1.262036852184708e-03, -1.017286150853441e-05,  8.241309311181730e-08,
 -6.727876959605170e-10,  5.558957254975435e-12, -4.683304623107741e-14,  4.073399456015336e-16, -3.731847440244312e-18,  3.704997343311122e-20, -4.103298719135615e-22,
  5.115500025319232e-24,  1.917692872549380e+00,  6.608857057469764e-04, -5.322645857569093e-06,  4.306046936626636e-08, -3.507731777955545e-10,  2.888870207138153e-12,
 -2.422076844496134e-14,  2.091960290185439e-16, -1.898145034904197e-18,  1.861797323099178e-20, -2.035314024088384e-22,  2.508618483196309e-24,  1.967096883185892e+00,
  2.641185091621623e-04, -2.126060264842296e-06,  1.718571084592113e-08, -1.398185906157319e-10,  1.149321733679292e-12, -9.609066847279347e-15,  8.265617211912707e-17,
 -7.457319174926661e-19,  7.261536601101221e-21, -7.875024941460149e-23,  9.636541906148401e-25,  1.993813642992138e+00,  4.965130581039188e-05, -3.995691811988745e-07,
  3.228501392510505e-09, -2.624946161522859e-11,  2.155670856877424e-13, -1.799740804149974e-15,  1.544948315606268e-17, -1.389867260790082e-19,  1.348358112347822e-21,
 -1.456214697609232e-23,  1.775179404378400e-25, -2.005040762335538e+00,  3.074050492844921e-03, -6.764326625988071e-04,  1.502362823222477e-04, -3.367803428497359e-05,
  7.619556568191486e-06, -1.739889107206678e-06,  4.009891330944303e-07, -9.327947409200216e-08,  2.190065994809796e-08, -5.175545211278728e-09,  1.170097734387082e-09,
 -2.004609909181821e+00,  2.788216886738808e-03, -5.855999355789637e-04,  1.242378844112626e-04, -2.663886296802170e-05,  5.775831417340487e-06, -1.266995185276364e-06,
  2.813294894742733e-07, -6.326206317488518e-08,  1.441111182602603e-08, -3.318063571143863e-09,  7.350575665473946e-10, -2.004357520668786e+00,  2.622803525625632e-03,
 -5.355588412033375e-04,  1.106056818271647e-04, -2.312405117720848e-05,  4.898289814278743e-06, -1.052147482195797e-06,  2.293441698871920e-07, -5.076502234470828e-08,
  1.141540264055953e-08, -2.601949267504287e-09,  5.724080218853181e-10, -2.004192813960300e+00,  2.515661559253982e-03, -5.041409368580679e-04,  1.023063706903068e-04,
 -2.104733024784612e-05,  4.394484995732136e-06, -9.321175787778397e-07,  2.010322227605704e-07, -4.411676573950033e-08,  9.855115463470897e-09, -2.235822153309652e-09,
  4.904660090055801e-10, -2.004083444656856e+00,  2.444867792240285e-03, -4.838127379611788e-04,  9.704548139463808e-05, -1.975656917278109e-05,  4.087130664861816e-06,
 -8.601517733355718e-07,  1.843250988731937e-07, -4.024910925316289e-08,  8.958648851965341e-09, -2.027657160501080e-09,  4.442467315309884e-10, -2.004014384600022e+00,
  2.400310091691079e-03, -4.711945608498350e-04,  9.382359638744355e-05, -1.897614299121680e-05,  3.903513379005901e-06, -8.176306653330572e-07,  1.745514469599664e-07,
 -3.800625209948151e-08,  8.442651349863651e-09, -1.908566196056571e-09,  4.179222765310602e-10, -2.003978035315879e+00,  2.376902290108992e-03, -4.646204765791025e-04,
  9.215835883486377e-05, -1.857581864670985e-05,  3.809986229734787e-06, -7.961107469786562e-07,  1.696332446558950e-07, -3.688321510508680e-08,  8.185355364056530e-09,
 -1.849379600661817e-09,  4.048702755906250e-10, -2.001977743218215e+00,  1.177988117096634e-03, -2.253480987380447e-04,  4.318515270008301e-05, -8.290411404002653e-06,
  1.594307235824782e-06, -3.071251189723634e-07,  5.926509392600104e-08, -1.145552628014305e-08,  2.217866360193961e-09, -4.295328813237792e-10,  8.039098312889011e-11,
 -2.001901629971475e+00,  1.128946220619845e-03, -2.115623602002254e-04,  3.971666122428766e-05, -7.469469549233280e-06,  1.407352187885126e-06, -2.656592001815566e-07,
  5.024220063240778e-08, -9.520194358952056e-09,  1.807379196959493e-09, -3.433769093534622e-10,  6.314347523971167e-11, -2.001853041086457e+00,  1.097796331885669e-03,
 -2.029985010300218e-04,  3.760986354756138e-05, -6.981932996208312e-06,  1.298797786874262e-06, -2.421173809966317e-07,  4.523296482021223e-08, -8.469418613254154e-09,
  1.589381972887858e-09, -2.986089496848569e-10,  5.435904945611405e-11, -2.001819584569504e+00,  1.076418859622164e-03, -1.972080623501100e-04,  3.620648111908945e-05,
 -6.661975571962868e-06,  1.228602576759138e-06, -2.271159470143578e-07,  4.208691140231995e-08, -7.818860643162776e-09,  1.456306077508324e-09, -2.716551444908861e-10,
  4.913640680363327e-11, -2.001796559738196e+00,  1.061740556364249e-03, -1.932731667647948e-04,  3.526264266329067e-05, -6.448991522636256e-06,  1.182349017503068e-06,
 -2.173297626721619e-07,  4.005474902494194e-08, -7.402694606908356e-09,  1.371981609124537e-09, -2.547328128674177e-10,  4.588493136693665e-11, -2.001781675155903e+00,
  1.052266272449836e-03, -1.907510766372257e-04,  3.466189889461207e-05, -6.314363818546375e-06,  1.153310732894289e-06, -2.112269818121682e-07,  3.879577243996530e-08,
 -7.146522018131788e-09,  1.320400054741848e-09, -2.444440882904851e-10,  4.391890146991661e-11, -2.001773730527455e+00,  1.047214082434416e-03, -1.894118572577768e-04,
  3.434425081003507e-05, -6.243474648351505e-06,  1.138083030476726e-06, -2.080395325387145e-07,  3.814079974872274e-08, -7.013761263036750e-09,  1.293767779542584e-09,
 -2.391510144979537e-10,  4.291076409831293e-11, -2.000890740164312e+00,  5.258128278818213e-04, -9.497811762598884e-05,  1.716284331762332e-05, -3.102611421914818e-06,
  5.610959806069395e-07, -1.015120701301762e-07,  1.837249221023389e-08, -3.326495700864528e-09,  6.025033681874657e-10, -1.090584584292557e-10,  1.913920183511436e-11,
 -2.000874368931738e+00,  5.153848016941705e-04, -9.219363914140772e-05,  1.649826379509301e-05, -2.953552727480907e-06,  5.289585817305636e-07, -9.476987380318504e-08,
  1.698602849432455e-08, -3.045699789980769e-09,  5.463161145396844e-10, -9.793855639748462e-11,  1.703279752699670e-11, -2.000863537124522e+00,  5.085011889664358e-04,
 -9.037495220852921e-05,  1.606881686949502e-05, -2.858262693670655e-06,  5.086341359839949e-07, -9.055171664526723e-08,  1.612792037630018e-08, -2.873775395065534e-09,
  5.122829851609557e-10, -9.127493757240297e-11,  1.578307353309936e-11, -2.000855899211088e+00,  5.036549289130213e-04, -8.910379534388835e-05,  1.577084476772145e-05,
 -2.792628050690484e-06,  4.947369757437801e-07, -8.768847699714185e-08,  1.554967430032350e-08, -2.758760589124827e-09,  4.896794882168839e-10, -8.688085021610136e-11,
  1.496446759919334e-11, -2.000850555413871e+00,  5.002680393543607e-04, -8.821996805153650e-05,  1.556473255021275e-05, -2.747461018074767e-06,  4.852225943493600e-07,
 -8.573824324845679e-08,  1.515781856300511e-08, -2.681213925524814e-09,  4.745161898758236e-10, -8.394780517464064e-11,  1.442057812880499e-11, -2.000847062259090e+00,
  4.980557532531277e-04, -8.764467877583323e-05,  1.543104417469452e-05, -2.718267609325687e-06,  4.790945332025082e-07, -8.448649708396178e-08,  1.490717773323067e-08,
 -2.631783477442371e-09,  4.648836280853661e-10, -8.209084996051540e-11,  1.407731034879708e-11, -2.000845185231080e+00,  4.968675382310207e-04, -8.733635070083478e-05,
  1.535954686777372e-05, -2.702688153323274e-06,  4.758311622735747e-07, -8.382131423399073e-08,  1.477426570399658e-08, -2.605625658693855e-09,  4.597967566395506e-10,
 -8.111220752097274e-11,  1.389674541925987e-11, -2.000424048330026e+00,  2.493244135792655e-04, -4.386290240159229e-05,  7.717405434165924e-06, -1.357958685699535e-06,
  2.389697803064489e-07, -4.205721327994908e-08,  7.402509371784285e-09, -1.303040550762499e-09,  2.293852542451825e-10, -4.034793836499236e-11,  6.890633006565859e-12,
 -2.000420235173167e+00,  2.469080961935891e-04, -4.323292436594002e-05,  7.570653927671560e-06, -1.325842120892318e-06,  2.322148585755482e-07, -4.067505139425897e-08,
  7.125350843404532e-09, -1.248315082624148e-09,  2.187110244498653e-10, -3.828885411945100e-11,  6.509864513971268e-12, -2.000417670202800e+00,  2.452845342710713e-04,
 -4.281181721809078e-05,  7.473070043775364e-06, -1.304597799298617e-06,  2.277701111622585e-07, -3.977037023050923e-08,  6.944894239293943e-09, -1.212871251412761e-09,
  2.118341022018364e-10, -3.696923638183665e-11,  6.267036533338377e-12, -2.000415841035043e+00,  2.441276039993060e-04, -4.251281377906540e-05,  7.404031365627814e-06,
 -1.289622236218739e-06,  2.246482632221865e-07, -3.913725246559338e-08,  6.819063501419999e-09, -1.188245989849995e-09,  2.070734939497366e-10, -3.605900152236935e-11,
  6.100103309872832e-12, -2.000414551056989e+00,  2.433121497964875e-04, -4.230259969296909e-05,  7.355618355607203e-06, -1.279147712167592e-06,  2.224703313646651e-07,
 -3.869669822177331e-08,  6.731729071382326e-09, -1.171198308211192e-09,  2.037862267506608e-10, -3.543206824915886e-11,  5.985399375133978e-12, -2.000413703231514e+00,
  2.427764004628679e-04, -4.216473158468037e-05,  7.323922815140706e-06, -1.272302242807706e-06,  2.210494871237443e-07, -3.840979465569493e-08,  6.674953967804449e-09,
 -1.160135244269518e-09,  2.016566914027791e-10, -3.502663785480344e-11,  5.911342030938123e-12, -2.000413246150250e+00,  2.424876320771466e-04, -4.209050024851148e-05,
  7.306875590270687e-06, -1.268624424483280e-06,  2.202869421604906e-07, -3.825598352949293e-08,  6.644549060928545e-09, -1.154216952503408e-09,  2.005186908190635e-10,
 -3.481020953633951e-11,  5.871847547745323e-12, -2.000207034416530e+00,  1.214990139245612e-04, -2.110546867595405e-05,  3.666294722877165e-06, -6.368979626853473e-07,
  1.106426186248968e-07, -1.922140454408529e-08,  3.339318603408711e-09, -5.801500273854880e-10,  1.007909611806574e-10, -1.749606695411139e-11,  2.950775927503311e-12,
 -2.000206113362271e+00,  1.209168017439849e-04, -2.095541678770401e-05,  3.631746662920295e-06, -6.294255920509439e-07,  1.090894801160870e-07, -1.890736407621343e-08,
  3.277092863541231e-09, -5.680098263088968e-10,  9.845132206149740e-11, -1.705013674459362e-11,  2.869239251732988e-12, -2.000205488851183e+00,  1.205222540374231e-04,
 -2.085399096348763e-05,  3.608454592563646e-06, -6.244008312800273e-07,  1.080477931598597e-07, -1.869728577106952e-08,  3.235575170077077e-09, -5.599308580726666e-10,
  9.689841482272326e-11, -1.675492422812880e-11,  2.815392029343072e-12, -2.000205041035958e+00,  1.202394445707210e-04, -2.078141872884619e-05,  3.591818546743675e-06,
 -6.208184265683874e-07,  1.073064615946852e-07, -1.854805034175798e-08,  3.206135073210814e-09, -5.542124226035893e-10,  9.580122323057076e-11, -1.654671929512867e-11,
  2.777479014651005e-12, -2.000204723987853e+00,  1.200392727030409e-04, -2.073011749206537e-05,  3.580073612050475e-06, -6.182925243510623e-07,  1.067844319963248e-07,
 -1.844309726416985e-08,  3.185457327716072e-09, -5.502011502788740e-10,  9.503257286591376e-11, -1.640104542563595e-11,  2.750984341919544e-12, -2.000204515051472e+00,
  1.199073828653856e-04, -2.069634552828019e-05,  3.572348658172800e-06, -6.166326411499529e-07,  1.064416866989779e-07, -1.837424995796359e-08,  3.171905104485354e-09,
 -5.475744810341174e-10,  9.452968819177544e-11, -1.630582292275562e-11,  2.733679837010063e-12, -2.000204402224606e+00,  1.198361696709130e-04, -2.067812030102089e-05,
  3.568182094563709e-06, -6.157378441769784e-07,  1.062570222970567e-07, -1.833717647496492e-08,  3.164611337175949e-09, -5.461615795125435e-10,  9.425932948153302e-11,
 -1.625465729368351e-11,  2.724386331896542e-12, -2.000102309192975e+00,  5.998545789060519e-05, -1.035534929391369e-05,  1.787664564187454e-06, -3.086098713238462e-07,
  5.327655040405584e-08, -9.197395882825600e-09,  1.587801296187738e-09, -2.741129782435830e-10,  4.732108740393049e-11, -8.162421338208585e-12,  1.368375366245818e-12,
 -2.000102082803012e+00,  5.984252607604053e-05, -1.031872034555433e-05,  1.779279321067718e-06, -3.068066624356742e-07,  5.290391466155043e-08, -9.122485919267573e-09,
  1.573044311903151e-09, -2.712506364387286e-10,  4.677267415184756e-11, -8.058502179702255e-12,  1.349477750007306e-12, -2.000101928700557e+00,  5.974525939658124e-05,
 -1.029382562970604e-05,  1.773587643220749e-06, -3.055842709894908e-07,  5.265163212565746e-08, -9.071835858364124e-09,  1.563079359081778e-09, -2.693202864643569e-10,
  4.640330610809292e-11, -7.988600747472147e-12,  1.336781612779363e-12, -2.000101817898619e+00,  5.967533636108147e-05, -1.027594518381412e-05,  1.769503295696218e-06,
 -3.047078709345583e-07,  5.247091958569724e-08, -9.035587385620702e-09,  1.555954218635140e-09, -2.679412918175737e-10,  4.613967646909441e-11, -7.938754661413760e-12,
  1.327735727116131e-12, -2.000101739299919e+00,  5.962574227175425e-05, -1.026327121826020e-05,  1.766610093718429e-06, -3.040874601414139e-07,  5.234307401854322e-08,
 -9.009959821545649e-09,  1.550920010202353e-09, -2.669676023283878e-10,  4.595365101793270e-11, -7.903604228179718e-12,  1.321360587910542e-12, -2.000101687433840e+00,
  5.959301892042232e-05, -1.025491229125715e-05,  1.764702766851463e-06, -3.036786389339317e-07,  5.225886721820398e-08, -8.993087450177841e-09,  1.547607118274070e-09,
 -2.663271248585881e-10,  4.583134068951310e-11, -7.880503283997418e-12,  1.317172565059459e-12, -2.000101659402988e+00,  5.957533469566378e-05, -1.025039620234178e-05,
  1.763672571247609e-06, -3.034578841103176e-07,  5.221340966976007e-08, -8.983981673975466e-09,  1.545819683878659e-09, -2.659816561480327e-10,  4.576538533160576e-11,
 -7.868049557501261e-12,  1.314915372272620e-12, -2.000050857338796e+00,  2.980492954504586e-05, -5.129413214019065e-06,  8.827706711074940e-07, -1.519248191943152e-07,
  2.614629657036537e-08, -4.499790140376777e-09,  7.744171272159864e-10, -1.332778401630486e-10,  2.293670020236988e-11, -3.944079106710018e-12,  6.592561676433648e-13,
 -2.000050801216177e+00,  2.976951754381320e-05, -5.120363733354560e-06,  8.807049073836844e-07, -1.514818522401626e-07,  2.605501842855045e-08, -4.481493283529177e-09,
  7.708230512831194e-10, -1.325827162331450e-10,  2.280390003743907e-11, -3.918986818217950e-12,  6.547054216610988e-13, -2.000050762939745e+00,  2.974536929307771e-05,
 -5.114196599054071e-06,  8.792980108205747e-07, -1.511803618414289e-07,  2.599293309730756e-08, -4.469056203839035e-09,  7.683815965770455e-10, -1.321108238015555e-10,
  2.271380545224272e-11, -3.901974606728899e-12,  6.516219432003423e-13, -2.000050735381269e+00,  2.972798453088723e-05, -5.109758732055872e-06,  8.782860610828813e-07,
 -1.509636037118731e-07,  2.594831657949703e-08, -4.460122539297571e-09,  7.666286675681943e-10, -1.317721644837653e-10,  2.264917710252261e-11, -3.889776559263962e-12,
  6.494119661028685e-13, -2.000050715813454e+00,  2.971564135961005e-05, -5.106608847386913e-06,  8.775680348101924e-07, -1.508098529486297e-07,  2.591667939723538e-08,
 -4.453789796183329e-09,  7.653864816760951e-10, -1.315322561743666e-10,  2.260340874389404e-11, -3.881140945813073e-12,  6.478478825722667e-13, -2.000050702892363e+00,
  2.970749124871479e-05, -5.104529454715889e-06,  8.770941351857775e-07, -1.507083994277718e-07,  2.589580801143237e-08, -4.449612945764563e-09,  7.645673623689008e-10,
 -1.313740915475691e-10,  2.257324168820004e-11, -3.875450258622580e-12,  6.468173982532136e-13, -2.000050695906358e+00,  2.970308487861639e-05, -5.103405378392213e-06,
  8.768379895665712e-07, -1.506535706264617e-07,  2.588452996512170e-08, -4.447356253080874e-09,  7.641248641283233e-10, -1.312886607176671e-10,  2.255694951265336e-11,
 -3.872377333215577e-12,  6.462610156873736e-13, -2.000025354937353e+00,  1.485590870677743e-05, -2.552773644301282e-06,  4.386574889640809e-07, -7.537701662596523e-08,
  1.295246703767709e-08, -2.225697828557626e-09,  3.824547459110541e-10, -6.571942441589104e-11,  1.129268132163803e-11, -1.938847991779176e-12,  3.236087180566015e-13,
 -2.000025340965486e+00,  1.484709541588919e-05, -2.550524576399524e-06,  4.381448103213185e-07, -7.526723766121343e-08,  1.292987806674727e-08, -2.221176281062930e-09,
  3.815678387978444e-10, -6.554813407178293e-11,  1.126000383156656e-11, -1.932682438712569e-12,  3.224920237250814e-13, -2.000025331427282e+00,  1.484107923012572e-05,
 -2.548989789212253e-06,  4.377950650019402e-07, -7.519237136625719e-08,  1.291447795417765e-08, -2.218094692746658e-09,  3.809635763199393e-10, -6.543146915698364e-11,
  1.123775455190266e-11, -1.928485817793755e-12,  3.217321680385709e-13, -2.000025324555292e+00,  1.483674495200712e-05, -2.547884317387617e-06,  4.375432077580852e-07,
 -7.513847102517503e-08,  1.290339306098163e-08, -2.215877085799972e-09,  3.805288280596803e-10, -6.534755123459037e-11,  1.122175408583481e-11, -1.925468513988198e-12,
  3.211859587392073e-13, -2.000025319673506e+00,  1.483366603148665e-05, -2.547099153003378e-06,  4.373643540736258e-07, -7.510020042989226e-08,  1.289552377474374e-08,
 -2.214303036050044e-09,  3.802202949743292e-10, -6.528800578280418e-11,  1.121040250134961e-11, -1.923328221325180e-12,  3.207985692649253e-13, -2.000025316448877e+00,
  1.483163231936294e-05, -2.546580586880178e-06,  4.372462422088939e-07, -7.507492999296432e-08,  1.289032818699509e-08, -2.213263906835656e-09,  3.800166355214078e-10,
 -6.524870482455387e-11,  1.120291110549971e-11, -1.921915907082375e-12,  3.205429692362146e-13, -2.000025314705072e+00,  1.483053255043789e-05, -2.546300181059559e-06,
  4.371823795436342e-07, -7.506126728511325e-08,  1.288751933291760e-08, -2.212702167958329e-09,  3.799065475379547e-10, -6.522746216490693e-11,  1.119886218820184e-11,
 -1.921152637366619e-12,  3.204048417985376e-13, -2.000012659107795e+00,  7.416364081403304e-06, -1.273419935360490e-06,  2.186514117658514e-07, -3.754334513554729e-08,
  6.446347080014953e-09, -1.106864457867272e-09,  1.900532187515517e-10, -3.263290570112144e-11,  5.603067037088533e-12, -9.612585243252578e-13,  1.603253706325736e-13,
 -2.000012655622142e+00,  7.414165697037877e-06, -1.272859320845576e-06,  2.185237089363941e-07, -3.751601971852110e-08,  6.440728379633045e-09, -1.105740583148083e-09,
  1.898329260768287e-10, -3.259039035527770e-11,  5.594962049556349e-12, -9.597303682558672e-13,  1.600487777056867e-13, -2.000012653241439e+00,  7.412664249348864e-06,
 -1.272476494165425e-06,  2.184365184755256e-07, -3.749736599368216e-08,  6.436893384529702e-09, -1.104973615699024e-09,  1.896826156441721e-10, -3.256138589492848e-11,
  5.589433624589388e-12, -9.586881778893096e-13,  1.598601719181850e-13, -2.000012651525637e+00,  7.411582163473786e-06, -1.272200623370574e-06,  2.183736947001349e-07,
 -3.748392683875095e-08,  6.434130756288734e-09, -1.104421174894271e-09,  1.895743603633341e-10, -3.254049890376921e-11,  5.585452886211184e-12, -9.579378335840872e-13,
  1.597243959548243e-13, -2.000012650306458e+00,  7.410813289495059e-06, -1.272004619443400e-06,  2.183290624944945e-07, -3.747437995990232e-08,  6.432168404063694e-09,
 -1.104028796315413e-09,  1.894974767769436e-10, -3.252566602617632e-11,  5.582626196419158e-12, -9.574050630068263e-13,  1.596279975546584e-13, -2.000012649501004e+00,
  7.410305336848912e-06, -1.271875137528507e-06,  2.182995796941378e-07, -3.746807390509845e-08,  6.430872272186751e-09, -1.103769645014369e-09,  1.894467008809862e-10,
 -3.251587055744086e-11,  5.580759585475351e-12, -9.570532662468415e-13,  1.595643474872156e-13, -2.000012649065388e+00,  7.410030621814267e-06, -1.271805112422992e-06,
  2.182836356420840e-07, -3.746466375913441e-08,  6.430171382537111e-09, -1.103629512453192e-09,  1.894192454375037e-10, -3.251057415122698e-11,  5.579750344053776e-12,
 -9.568630628143797e-13,  1.595299353572737e-13, -2.000006324972652e+00,  3.705290536168097e-06, -6.359702781470644e-07,  1.091569472788313e-07, -1.873552871014996e-08,
  3.215737088871771e-09, -5.519441382745092e-10,  9.473483801191481e-11, -1.626012986377160e-11,  2.790794465995010e-12, -4.786042035597997e-13,  7.979611909658998e-14,
 -2.000006324102151e+00,  3.704741555797449e-06, -6.358303304348477e-07,  1.091250797110197e-07, -1.872871220802958e-08,  3.214335964341439e-09, -5.516639792101106e-10,
  9.467994303199669e-11, -1.624953917982185e-11,  2.788776209627845e-12, -4.782238057687742e-13,  7.972729077698403e-14, -2.000006323507455e+00,  3.704366518043435e-06,
 -6.357347322539217e-07,  1.091033127372751e-07, -1.872405660567749e-08,  3.213379087286385e-09, -5.514726641576273e-10,  9.464245936021348e-11, -1.624230817718417e-11,
  2.787398315481509e-12, -4.779641232816245e-13,  7.968030794887657e-14, -2.000006323078779e+00,  3.704096181695538e-06, -6.356658265633093e-07,  1.090876243145043e-07,
 -1.872070129466679e-08,  3.212689500918779e-09, -5.513347981296635e-10,  9.461544928293877e-11, -1.623709793648472e-11,  2.786405540814786e-12, -4.777770321698288e-13,
  7.964646043140122e-14, -2.000006322774142e+00,  3.703904070040195e-06, -6.356168614043124e-07,  1.090764763904846e-07, -1.871831716393842e-08,  3.212199532054387e-09,
 -5.512368447123262e-10,  9.459625947377621e-11, -1.623339637379664e-11,  2.785700262551188e-12, -4.776441258813180e-13,  7.962241664623254e-14, -2.000006322572867e+00,
  3.703777141204360e-06, -6.355845108378029e-07,  1.090691113228055e-07, -1.871674209059952e-08,  3.211875843645795e-09, -5.511721354883081e-10,  9.458358280383163e-11,
 -1.623095121224647e-11,  2.785234385981146e-12, -4.775563361196292e-13,  7.960653520562432e-14, -2.000006322464005e+00,  3.703708490798404e-06, -6.355670140859848e-07,
  1.090651280051640e-07, -1.871589024358604e-08,  3.211700786201113e-09, -5.511371399858443e-10,  9.457672722981983e-11, -1.622962888546259e-11,  2.784982447387048e-12,
 -4.775088616274840e-13,  7.959794705930328e-14, -2.000003161342134e+00,  1.851923148043743e-06, -3.178004699609594e-07,  5.453635555945180e-08, -9.358746683579479e-09,
  1.606013806306573e-09, -2.756010442474773e-10,  4.729469580578484e-11, -8.116031219533974e-12,  1.392722321582901e-12, -2.387978608047086e-13,  3.980681247706044e-14,
 -2.000003161124623e+00,  1.851785979818073e-06, -3.177655087325307e-07,  5.452839592159485e-08, -9.357044410621211e-09,  1.605663967922790e-09, -2.755311054094556e-10,
  4.728099426763752e-11, -8.113388301923899e-12,  1.392218752728662e-12, -2.387029657159595e-13,  3.978964522055093e-14, -2.000003160976009e+00,  1.851692260858465e-06,
 -3.177416227312684e-07,  5.452295800260147e-08, -9.355881486943002e-09,  1.605424982162887e-09, -2.754833298797018e-10,  4.727163506300438e-11, -8.111583058568883e-12,
  1.391874804164388e-12, -2.386381528903488e-13,  3.977792051958124e-14, -2.000003160868874e+00,  1.851624699890649e-06, -3.177244040510833e-07,  5.451903808418492e-08,
 -9.355043218060255e-09,  1.605252719177817e-09, -2.754488938356508e-10,  4.726488924723608e-11, -8.110281933416179e-12,  1.391626910971522e-12, -2.385914418126026e-13,
  3.976947066385896e-14, -2.000003160792735e+00,  1.851576685320531e-06, -3.177121672346131e-07,  5.451625236757427e-08, -9.354447508548701e-09,  1.605130304237719e-09,
 -2.754244231033065e-10,  4.726009567320989e-11, -8.109357373031680e-12,  1.391450765267895e-12, -2.385582509437270e-13,  3.976346667540323e-14, -2.000003160742426e+00,
  1.851544960521212e-06, -3.177040820795329e-07,  5.451441180387579e-08, -9.354053920013704e-09,  1.605049425138906e-09, -2.754082556053973e-10,  4.725692866456895e-11,
 -8.108746544870629e-12,  1.391334392923146e-12, -2.385363233823245e-13,  3.975950018945648e-14, -2.000003160715216e+00,  1.851527801460888e-06, -3.176997090809550e-07,
  5.451341631098741e-08, -9.353841044326843e-09,  1.605005681366572e-09, -2.753995114262979e-10,  4.725521580492062e-11, -8.108416184550199e-12,  1.391271454637444e-12,
 -2.385244642811964e-13,  3.975735500867574e-14,     0.998485528939595,     0.991945469533392,     0.979853614244271,     0.961552504997563,     0.935800153178899,
     0.900074891162616,     0.847781307936022,     0.999244400698772,      0.99598148004379,     0.989948883936702,     0.980818983872118,     0.967972890343299,
     0.950154097191345,     0.924076337303392,     0.999622587362016,     0.997992803344903,     0.994979626343981,     0.990419454487927,     0.984003244813482,
     0.975103559797805,     0.962079392581068,     0.999811387995176,     0.998996903879056,     0.997491072137843,     0.995212138059963,     0.992005667419716,
     0.987558118249237,     0.981049447806103,     0.999905717288033,     0.999498575880983,     0.998745846420297,     0.997606662299503,      0.99600382669572,
     0.993780609755638,      0.99052709742205,     0.999952864431587,     0.999749318729955,     0.999373000263768,      0.99880347831932,      0.99800215937438,
     0.996890688419677,     0.995264134329567,     0.999976433658364,     0.999874667038179,     0.999686519329387,     0.999401775810474,     0.999001140920152,
     0.998445439588561,     0.997632212616279,     0.999988217189288,      0.99993733543439,     0.999843264455885,      0.99970089705036,     0.999500585734343,
     0.999222743576094,     0.998816142552913,     0.999994108684604,     0.999968668195646,     0.999921633424721,      0.99985045080927,     0.999750296681506,
     0.999611377725671,     0.999408080322951,     0.999997054364783,     0.999984334217389,     0.999960817011428,     0.999925225975384,     0.999875149293809,
     0.999805690346265,     0.999704042421266,     0.999998527188011,      0.99999216713858,     0.999980408580465,     0.999962613130345,     0.999937574885102,
     0.999902845543868,     0.999852021775352  };
  constexpr double w[3689] = {  2.058427601107093e-01, -8.837988263641910e-02,  2.035437541773679e-02, -3.190255166322968e-03,  3.786868992215763e-04,
 -3.617119192804737e-05,  2.890813050016872e-06, -1.986359025037516e-07,  1.197198954537636e-08, -6.426980755115631e-10,  3.110611212868952e-11, -1.368662893579013e-12,
  2.065149188528279e-01, -8.169872373148625e-02,  1.738934840789347e-02, -2.541390407179316e-03,  2.837517482795243e-04, -2.569296688930459e-05,  1.959814387474717e-06,
 -1.292884296856602e-07,  7.519766990465273e-09, -3.913131865394630e-10,  1.843070117722596e-11, -7.919292043959968e-13,  2.060334733700275e-01, -6.838191733258137e-02,
  1.239576703439582e-02, -1.574724208012121e-03,  1.556428180034774e-04, -1.267196173918094e-05,  8.808244080188957e-07, -5.356471959775137e-08,  2.900705163011614e-09,
 -1.417705119404334e-10,  6.319503204419973e-12, -2.587485191894800e-13,  1.996715982633403e-01, -4.956145510675973e-02,  7.019732724358165e-03, -7.222830200951022e-04,
  5.950018686069418e-05, -4.132938796598539e-06,  2.499225171138510e-07, -1.344360380501055e-08,  6.532835767278019e-10, -2.901344900370311e-11,  1.188281862542300e-12,
 -4.515142913916762e-14,  1.790560134711170e-01, -2.883517069191411e-02,  2.914101119584732e-03, -2.258547359498798e-04,  1.457649243003959e-05, -8.179867850200958e-07,
  4.097906325261879e-08, -1.865340638835892e-09,  7.812379583475751e-11, -3.038742922121299e-12,  1.105645021065885e-13, -3.780893986498296e-15,  1.348184779854624e-01,
 -1.192794044489849e-02,  7.770167797810143e-04, -4.183285580732419e-05,  1.970840270987100e-06, -8.383950936385290e-08,  3.282686393029116e-09, -1.198229109783367e-10,
  4.114452754293780e-12, -1.338009669632343e-13,  4.142021107808229e-15, -1.224586318380814e-16,  6.435077126912379e-02, -2.838206615161852e-03,  1.023886022455084e-04,
 -3.372348917643066e-06,  1.040025484553167e-07, -3.040943282630953e-09,  8.502453372464362e-11, -2.287642961461073e-12,  5.951017201434703e-14, -1.502151548541629e-15,
  3.689468345914452e-17, -8.832066973202102e-19,  3.075725173980313e-02, -1.313358105549370e-02,  3.008287261939894e-03, -4.691732468698125e-04,  5.544406841896372e-05,
 -5.274767206408903e-06,  4.200487851711495e-07, -2.876917232318821e-08,  1.728847398416310e-09, -9.256184852334892e-11,  4.468946702804788e-12, -1.961916957001337e-13,
  3.756983528899097e-02, -1.442012547834666e-02,  2.984778038526018e-03, -4.257511075615311e-04,  4.654728804579543e-05, -4.138473067555415e-06,  3.106840128669362e-07,
 -2.021122336294767e-08,  1.161151332346907e-09, -5.976924165386208e-11,  2.788010890814578e-12, -1.187697167371106e-13,  5.256054290748600e-02, -1.619930107514722e-02,
  2.754831375203832e-03, -3.313931352238928e-04,  3.124982277694951e-05, -2.442240639441047e-06,  1.637746087970635e-07, -9.649046845006483e-09,  5.080647108431563e-10,
 -2.421884476352299e-11,  1.055761835133763e-12, -4.237512690057718e-14,  7.547068578407873e-02, -1.655147143679497e-02,  2.123231466168755e-03, -2.008992212654338e-04,
  1.538991357573842e-05, -1.002791491100112e-06,  5.728945778950232e-08, -2.928788588198777e-09,  1.359533455583966e-10, -5.793307624661926e-12,  2.285476385172900e-13,
 -8.394368263029002e-15,  9.748414358893775e-02, -1.336599904475463e-02,  1.197803272507695e-03, -8.379578913648407e-05,  4.941972787519378e-06, -2.558094566241129e-07,
  1.191086611398032e-08, -5.071246025056888e-10,  1.997575438075507e-11, -7.343132209015834e-13,  2.536016790995064e-14, -8.264493550071278e-16,  9.697769978691902e-02,
 -7.288084642699957e-03,  4.201775871022768e-04, -2.035368994717375e-05,  8.715969397574785e-07, -3.396090433353473e-08,  1.225548662050339e-09, -4.144824922958577e-11,
  1.324801072901020e-12, -4.026858149936735e-14,  1.169560996375401e-15, -3.255722704759545e-17,  5.441449882759116e-02, -2.156678110954650e-03,  7.020537491231613e-05,
 -2.102446923829820e-06,  5.933312310747447e-08, -1.595203494483554e-09,  4.116437080639984e-11, -1.025314639261088e-12,  2.475660073947391e-14, -5.814044598474556e-16,
  1.331350144041815e-17, -2.978447963150626e-19,  4.660839986325113e-03, -1.976103665013745e-03,  4.494997480932715e-04, -6.966887205062432e-05,  8.187712221466650e-06,
 -7.751438335581850e-07,  6.145847715338191e-08, -4.192862667505850e-09,  2.510794242814294e-10, -1.339998063014342e-11,  6.450924192283582e-13, -2.824590833143043e-14,
  7.303456054900953e-03, -2.693770655486658e-03,  5.379463233048321e-04, -7.440862686715582e-05,  7.923162483597744e-06, -6.885784529548340e-07,  5.068114847673410e-08,
 -3.240602082361225e-09,  1.833781144311291e-10, -9.314155403162128e-12,  4.293738347796686e-13, -1.810122371190833e-14,  1.507828386208503e-02, -4.242802073568892e-03,
  6.687233766450280e-04, -7.543634970114986e-05,  6.731476937712675e-06, -5.014346404935415e-07,  3.224057209810168e-08, -1.830271486083735e-09,  9.324920401339160e-11,
 -4.316561330698615e-12,  1.833008443276367e-13, -7.186702802694322e-15,  3.234544597965210e-02, -6.171122578444190e-03,  7.107689883897148e-04, -6.140478237146548e-05,
  4.346897380268293e-06, -2.641770654058127e-07,  1.418263095481582e-08, -6.856351694922296e-10,  3.025885894507159e-11, -1.231631423008688e-12,  4.660335070787489e-14,
 -1.647951426510986e-15,  5.830469900589819e-02, -6.769075590021384e-03,  5.375311009447974e-04, -3.390606920091286e-05,  1.824675928689139e-06, -8.696940472289785e-08,
  3.756017115917332e-09, -1.492440343271112e-10,  5.515546517261610e-12, -1.911198646525205e-13,  6.248044223789363e-15, -1.934950086650357e-16,  7.327900477689257e-02,
 -4.709464607649875e-03,  2.414665152133931e-04, -1.056662636357177e-05,  4.125655783357193e-07, -1.475846739354489e-08,  4.917174620278682e-10, -1.542708617091175e-11,
  4.593362914587012e-13, -1.305483858595966e-14,  3.557386500264006e-16, -9.320834435306927e-18,  4.677126065797689e-02, -1.681932600987803e-03,  4.976976606750346e-05,
 -1.363037638963163e-06,  3.537526851277598e-08, -8.784562575060082e-10,  2.100736945050436e-11, -4.862422238577336e-13,  1.093276166481263e-14, -2.397537889018018e-16,
  5.128191454450803e-18, -1.075696424360885e-19,  7.192538739226350e-04, -3.020781584734182e-04,  6.809506645919949e-05, -1.047043418351754e-05,  1.221976484318941e-06,
 -1.149819429211445e-07,  9.067559589913332e-09, -6.156662464262408e-10,  3.671099042148480e-11, -1.951777773429191e-12,  9.363819691020940e-14, -4.087297386670400e-15,
  1.542027898004063e-03, -5.396073629361593e-04,  1.029233580265468e-04, -1.369359961707502e-05,  1.410698528625404e-06, -1.191729886088685e-07,  8.559276023697126e-09,
 -5.357630279879474e-10,  2.975880357601619e-11, -1.487019218470719e-12,  6.756971419420386e-14, -2.812543965186312e-15,  4.915385216981748e-03, -1.239049467115072e-03,
  1.787408481035597e-04, -1.871946212402722e-05,  1.567411675238404e-06, -1.104751957180993e-07,  6.766540837891907e-09, -3.679904337934810e-10,  1.804658324565910e-11,
 -8.074161184841592e-13,  3.325679638700784e-14, -1.268764555114349e-15,  1.562589452006864e-02, -2.557349700526415e-03,  2.627340615017935e-04, -2.060880507532617e-05,
  1.341382918112711e-06, -7.567294120292739e-08,  3.800301235021323e-09, -1.729677148176315e-10,  7.226591210451534e-12, -2.798113296606677e-13,  1.011489247124064e-14,
 -3.430373734318593e-16,  3.781135995352141e-02, -3.706214078770731e-03,  2.611256185502285e-04, -1.485774774693862e-05,  7.295137113484322e-07, -3.199807995558989e-08,
  1.280557677730343e-09, -4.742452499023074e-11,  1.641790757514296e-12, -5.352886778170288e-14,  1.653197282377889e-15, -4.854793230488620e-17,  5.763487958093095e-02,
 -3.191604284919079e-03,  1.462699154486700e-04, -5.807449199272856e-06,  2.074639085519799e-07, -6.832596000985912e-09,  2.106406973775727e-10, -6.141219037722000e-12,
  1.705564199498175e-13, -4.536585617222148e-15,  1.160516631052695e-16, -2.862726439170563e-18,  4.074827856323569e-02, -1.340755895061764e-03,  3.630716027515775e-05,
 -9.142003700292774e-07,  2.192008848764272e-08, -5.048827402363666e-10,  1.122946614582768e-11, -2.425814114740674e-13,  5.086658837668858e-15, -1.047536038348558e-16,
  2.097859481282592e-18, -4.108284266498350e-20,  1.136992854510699e-04, -4.713890704236613e-05,  1.049917001150167e-05, -1.597670751599722e-06,  1.847984728218713e-07,
 -1.725454112915961e-08,  1.351563296530703e-09, -9.122696213443909e-11,  5.411355560257718e-12, -2.863682845849567e-13,  1.368189172793489e-14, -5.949968471963170e-16,
  3.603220675134038e-04, -1.176391883406807e-04,  2.116530744148716e-05, -2.681997093683251e-06,  2.651626081048745e-07, -2.162826054295984e-08,  1.507210282126092e-09,
 -9.190777972434936e-11,  4.989944078729637e-12, -2.444135003552445e-13,  1.091269072103354e-14, -4.472572404310297e-16,  1.832401098763737e-03, -4.055097344890522e-04,
  5.289878684087489e-05, -5.093965398105221e-06,  3.969550848258459e-07, -2.628212470975195e-08,  1.523556409827541e-09, -7.890962349421073e-11,  3.704975185915374e-12,
 -1.594268327829714e-13,  6.340746995556362e-15, -2.344109158544959e-16,  8.429872463629603e-03, -1.169279895295560e-03,  1.067279338827876e-04, -7.571903017833688e-06,
  4.514864804873823e-07, -2.355797095465611e-08,  1.102730208106319e-09, -4.708263333144395e-11,  1.855575178178294e-12, -6.810245067329798e-14,  2.343590436943801e-15,
 -7.596306328188646e-17,  2.626270413732846e-02, -2.171616630818599e-03,  1.361377568245348e-04, -6.999069584358571e-06,  3.138339878448143e-07, -1.267257610549968e-08,
  4.699366903874090e-10, -1.621333162550195e-11,  5.253991973291484e-13, -1.610106133204669e-14,  4.691498092699090e-16, -1.304473697485978e-17,  4.683532937126134e-02,
 -2.252624401098598e-03,  9.274059497307689e-05, -3.355595505721400e-06,  1.100841561621927e-07, -3.347997566611512e-09,  9.574365622745381e-11, -2.599331927147254e-12,
  6.745118842567331e-14, -1.681204334369339e-15,  4.041470431092435e-17, -9.394016524215829e-19,  3.590420314574350e-02, -1.088900513016161e-03,  2.714969447441882e-05,
 -6.316349855021408e-07,  1.404946305940546e-08, -3.014715268563358e-10,  6.246977895340844e-12, -1.269061354138260e-13,  2.476289517472891e-15, -4.793964085053246e-17,
  9.205323056223393e-19, -1.632477783799766e-20,  1.856977742996909e-05, -7.559874053604773e-06,  1.656427086580265e-06, -2.485900391911958e-07,  2.841880940724101e-08,
 -2.627100267043495e-09,  2.040258552338067e-10, -1.366923250915366e-11,  8.055772494563732e-13, -4.238819099374041e-14,  2.014969592011857e-15, -8.723357128391667e-17,
  9.507733825248278e-05, -2.834805361670528e-05,  4.740268166976776e-06, -5.655145299387577e-07,  5.315502098877661e-08, -4.153359520616425e-09,  2.789592953699564e-10,
 -1.647666790954281e-11,  8.700773354452005e-13, -4.159500370070548e-14,  1.817949299749829e-15, -7.312291680213342e-17,  7.820141169008539e-04, -1.488423899566615e-04,
  1.737604637208189e-05, -1.525289578494561e-06,  1.098007574788402e-07, -6.783488556419964e-09,  3.699019622115484e-10, -1.814249328164719e-11,  8.112604720715122e-13,
 -3.341012424586251e-14,  1.277217412751161e-15, -4.556043734849950e-17,  5.020635480358172e-03, -5.843886316188906e-04,  4.733079810209408e-05, -3.030684367986952e-06,
  1.651857910629796e-07, -7.952808489205771e-09,  3.461075249283705e-10, -1.382501562956537e-11,  5.125173395365373e-13, -1.777834647561497e-14,  5.806828620671164e-16,
 -1.793476354543030e-17,  1.932185088907534e-02, -1.349036036122976e-03,  7.554587306110370e-05, -3.518488052340389e-06,  1.443368628228593e-07, -5.371250521391313e-09,
  1.847197981604394e-10, -5.937989615423368e-12,  1.801052523741065e-13, -5.186739503283444e-15,  1.424613658194490e-16, -3.747313804168230e-18,  3.909010957973985e-02,
 -1.646210375888468e-03,  6.117785173221343e-05, -2.026057036607714e-06,  6.126562878152665e-08, -1.726107232823943e-09,  4.591276917366365e-11, -1.163218471554939e-12,
  2.826184665658931e-14, -6.612204346985039e-16,  1.494934526247687e-17, -3.278830320201265e-19,  3.193984284927436e-02, -8.986107027095834e-04,  2.074328584706404e-05,
 -4.479981858685998e-07,  9.271819572165557e-09, -1.866014537274412e-10,  3.587160616483649e-12, -6.935756908456539e-14,  1.272518462596708e-15, -2.208079916291902e-17,
  4.382094228759185e-19, -7.157345841033249e-21,  3.173482152494469e-06, -1.258092005818609e-06,  2.694177690143275e-07, -3.967721676033788e-08,  4.465538629091425e-09,
 -4.074350366389835e-10,  3.129331465118376e-11, -2.076781731351356e-12,  1.213939409890722e-13, -6.342174958364319e-15,  2.996029137250437e-16, -1.289938371312890e-17,
  2.888184439847943e-05, -7.660353866118072e-06,  1.171105466183073e-06, -1.298590228935247e-07,  1.148353630091771e-08, -8.520134726373500e-10,  5.473886562914375e-11,
 -3.111235361231519e-12,  1.588869231983965e-13, -7.376555381604312e-15,  3.142088838516428e-16, -1.235536994647996e-17,  3.804182121963927e-04, -6.104297683097188e-05,
  6.328640361076754e-06, -5.028317656397849e-07,  3.323341818549972e-08, -1.904756081289982e-09,  9.717633384356403e-11, -4.490303611218839e-12,  1.902903217815229e-13,
 -7.465401642976371e-15,  2.730995929975356e-16, -9.360586438483060e-18,  3.260567704000589e-03, -3.159808272670380e-04,  2.274033178539479e-05, -1.313365170784388e-06,
  6.538943288294744e-08, -2.900665960604254e-09,  1.172030154953225e-10, -4.372043330315012e-12,  1.521376196194233e-13, -4.977599827908513e-15,  1.539488344754331e-16,
 -4.519535108273052e-18,  1.491337496861682e-02, -8.811359194525784e-04,  4.428518584061470e-05, -1.874314717972581e-06,  7.053209210189388e-08, -2.421818977336180e-09,
  7.737481373198878e-11, -2.319492187899493e-12,  6.583332574868880e-14, -1.783669312019454e-15,  4.616376196826913e-17, -1.147582797321625e-18,  3.335063106797474e-02,
 -1.239657138062632e-03,  4.177499850376232e-05, -1.271595185502113e-06,  3.557224661179969e-08, -9.313198955527825e-10,  2.310969462278452e-11, -5.475500789299691e-13,
  1.247747701516197e-14, -2.748534942079837e-16,  5.848819239849376e-18, -1.209862985189450e-19,  2.864646583021934e-02, -7.519026089613759e-04,  1.614777431654982e-05,
 -3.254134771585989e-07,  6.264465608126364e-09, -1.198396911387894e-10,  2.116659852321365e-12, -3.851431597074594e-14,  7.281581960229283e-16, -9.707443845502528e-18,
  2.019829456688097e-19, -4.132129675997253e-21,  5.783831913314994e-07, -2.202875081221209e-07,  4.565629279334157e-08, -6.550013674773938e-09,  7.217010353667155e-10,
 -6.470807745334225e-11,  4.898103485247281e-12, -3.210927824386076e-13,  1.857314462202198e-14, -9.616320535495682e-16,  4.507297307983005e-17, -1.927402206668825e-18,
  1.025561159941781e-05, -2.346389680176307e-06,  3.225933155759593e-07, -3.280860914547136e-08,  2.700075330537574e-09, -1.884549486189197e-10,  1.148788634610356e-11,
 -6.238610323516736e-13,  3.061751135934052e-14, -1.372737383576676e-15,  5.670426261342794e-17, -2.170192224609638e-18,  2.090612447923478e-04, -2.775334341590266e-05,
  2.545701545962206e-06, -1.820802691801249e-07,  1.100063605631096e-08, -5.822140020551189e-10,  2.766751240699644e-11, -1.199288135835643e-12,  4.795780919849150e-14,
 -1.784874432059687e-15,  6.222789005092805e-17, -2.041289458457417e-18,  2.281009885129481e-03, -1.829025578947742e-04,  1.174415170200635e-05, -6.119008327237228e-07,
  2.785817431618395e-08, -1.137731608211414e-09,  4.265744684756496e-11, -1.485488131770186e-12,  4.842923247994618e-14, -1.492763480868913e-15,  4.365195893388731e-17,
 -1.215535666965295e-18,  1.197788742087107e-02, -6.007569936242596e-04,  2.724145814117978e-05, -1.050845871945644e-06,  3.642318674930926e-08, -1.154787367766742e-09,
  3.433437790356227e-11, -9.634185203804829e-13,  2.551455261278245e-14, -6.519207673266777e-16,  1.593834614662099e-17, -3.732003372382632e-19,  2.897577320538880e-02,
 -9.580608347190881e-04,  2.940122036565666e-05, -8.258193788578726e-07,  2.144986072604979e-08, -5.232982675571643e-10,  1.215108890309484e-11, -2.700933191497199e-13,
  5.770189168974490e-15, -1.201039073926792e-16,  2.419475491750432e-18, -4.690448108404336e-20,  2.587467433857129e-02, -6.368021914972986e-04,  1.277315201858549e-05,
 -2.419191932794641e-07,  4.300733355110945e-09, -7.962311473067357e-11,  1.321125035269027e-12, -1.957489428942104e-14,  4.841988935368342e-16, -4.849931903783580e-18,
  4.944830441971026e-20, -2.958998793148304e-21,  1.156834850474104e-07, -4.138604412325490e-08,  8.180538135213025e-09, -1.131142737936359e-09,  1.210461110244941e-10,
 -1.059987881541292e-11,  7.869603147454967e-13, -5.076315008820801e-14,  2.896690010013378e-15, -1.482530684179070e-16,  6.880156242675876e-18, -2.916950154505752e-19,
  4.291602371067502e-06, -8.182037587113673e-07,  9.978536238728556e-08, -9.188439267350622e-09,  6.965393756329236e-10, -4.531444381853953e-11,  2.599501423066238e-12,
 -1.338947687597183e-13,  6.273134864908189e-15, -2.699944035392503e-16,  1.075709711864612e-17, -3.987515110032769e-19,  1.282371319819494e-04, -1.383219512770625e-05,
  1.124346066309473e-06, -7.206383841956784e-08,  3.971806525139044e-09, -1.934713789051605e-10,  8.532818075798954e-12, -3.459545026688787e-13,  1.300520621294760e-14,
 -4.575762957093797e-16,  1.515170996651012e-17, -4.739274754486411e-19,  1.699601782606352e-03, -1.121704295763890e-04,  6.472769792313724e-06, -3.041082863991522e-07,
  1.270336766048835e-08, -4.777273863537140e-10,  1.658954980966667e-11, -5.410453365437642e-13,  1.648276825775172e-14, -4.780184775529840e-16,  1.323341449272768e-17,
 -3.481238087158753e-19,  9.942848725816076e-03, -4.248628611297849e-04,  1.748920823624523e-05, -6.158207588973118e-07,  1.978124691666677e-08, -5.801773415019115e-10,
  1.598225268311634e-11, -4.255488440871598e-13,  1.044631129143473e-14, -2.503558429408183e-16,  5.894621208818765e-18, -1.273210516103081e-19,  2.555849091511040e-02,
 -7.573599099582736e-04,  2.125030200468758e-05, -5.527455294608459e-07,  1.338061147137403e-08, -3.049733806075106e-10,  6.636563007962944e-12, -1.393350109694064e-13,
  2.787415638834609e-15, -5.445280375834028e-17,  1.062672219614084e-18, -1.909026750140572e-20,  2.351495517821373e-02, -5.451699358731369e-04,  1.023558359350721e-05,
 -1.842812450079090e-07,  2.989339088976983e-09, -5.289627878947641e-11,  9.649774780597297e-13, -6.741861069623769e-15,  3.144124799693132e-16, -5.446522334056216e-18,
 -8.318100639510369e-20, -3.511815097321233e-21,  2.648114691218541e-08, -8.564093582101813e-09,  1.580855631016185e-09, -2.074837076692104e-10,  2.132476373975642e-11,
 -1.808293810602167e-12,  1.308015421106477e-13, -8.258759906180998e-15,  4.629470158424696e-16, -2.334118656857266e-17,  1.069509138565528e-18, -4.485206019020500e-20,
  2.115309056244441e-06, -3.233590005526773e-07,  3.476140289154681e-08, -2.862355208717113e-09,  1.981702810830980e-10, -1.191866580109960e-11,  6.383646135036320e-13,
 -3.097279993280843e-14,  1.376089608323601e-15, -5.651057008806912e-17,  2.159602486181764e-18, -7.713030172239220e-20,  8.663304028925795e-05, -7.451431317111203e-06,
  5.419072363472483e-07, -3.095161320860904e-08,  1.556597361781827e-09, -6.976406133248702e-11,  2.841348191421137e-12, -1.077371293753463e-13,  3.796179844037158e-15,
 -1.257572454299167e-16,  3.952380635454769e-18, -1.172784210823193e-19,  1.335443208836394e-03, -7.213758072399885e-05,  3.785893760615682e-06, -1.599093200613390e-07,
  6.155034304333653e-09, -2.146404151308342e-10,  6.823107151776095e-12, -2.106238870003812e-13,  6.009044218381915e-15, -1.613859927157112e-16,  4.323284168980989e-18,
 -1.054297853295157e-19,  8.483004499528206e-03, -3.098922403476025e-04,  1.167331330027994e-05, -3.747725244533315e-07,  1.121334137834704e-08, -3.087476869596230e-10,
  7.662937982050299e-12, -1.989182709722433e-13,  4.623513803483657e-15, -9.557395545204630e-17,  2.435514829474653e-18, -4.498948173047066e-20,  2.283163802246726e-02,
 -6.106630092162999e-04,  1.572541154705212e-05, -3.799631473349428e-07,  8.603263204333815e-09, -1.839870673519396e-10,  3.739470647203999e-12, -7.469202855671860e-14,
  1.426724890323553e-15, -2.486543091715504e-17,  4.913216728271764e-19, -8.741739391556652e-21,  2.148509129781798e-02, -4.713901382108609e-04,  8.280217958677997e-06,
 -1.437032307825368e-07,  2.152714940927684e-09, -3.107740948936171e-11,  8.810925180790823e-13, -7.948728442791428e-16,  1.648283766697245e-17, -1.232798573910559e-17,
 -2.623447615221392e-19, -3.241480540692735e-21,  7.348029547407572e-09, -2.011993207911584e-09,  3.379147125951411e-10, -4.121111029017046e-11,  4.007919092232580e-12,
 -3.253309604855777e-13,  2.272148581913310e-14, -1.394347432134623e-15,  7.634279640800502e-17, -3.774435997318898e-18,  1.701200661679794e-19, -7.035161966267955e-21,
  1.218108739968531e-06, -1.426357049191868e-07,  1.363467359494713e-08, -9.908280037628712e-10,  6.223616970589963e-11, -3.444050094377480e-12,  1.707578985156915e-13,
 -7.762965957991774e-15,  3.251732360933601e-16, -1.265375883134416e-17,  4.619027089626023e-19, -1.580174158490875e-20,  6.362855705644268e-05, -4.264672955363360e-06,
  2.835723340985558e-07, -1.432642846116396e-08,  6.553794036163770e-10, -2.734320710427777e-11,  1.015220859903001e-12, -3.602788919119911e-14,  1.200447823068056e-15,
 -3.671490108409510e-17,  1.107350828142781e-18, -3.128723525799835e-20,  1.097309796449374e-03, -4.812893127696355e-05,  2.340356303639098e-06, -8.854670824279436e-08,
  3.115314353599581e-09, -1.042928704775241e-10,  2.938469827942261e-12, -8.524398693320813e-14,  2.450166597785680e-15, -5.463764566035607e-17,  1.487207711144578e-18,
 -3.900735608781704e-20,  7.405484656830618e-03, -2.318574655383156e-04,  8.076591531184731e-06, -2.363939372793406e-07,  6.501430382226193e-09, -1.775472981796465e-10,
  3.761680396086382e-12, -9.055252633882222e-14,  2.535210168826995e-15, -3.031080073448868e-17,  8.991158242887768e-19, -3.487587864402447e-20,  2.061468632722384e-02,
 -5.010090262526747e-04,  1.188439095994529e-05, -2.675002481980835e-07,  5.675183742835269e-09, -1.148861021742601e-10,  2.175714972228394e-12, -4.025331535865061e-14,
  8.019475590861930e-16, -1.198068687638998e-17,  1.642877139925128e-19, -6.995469520634645e-21,  1.972186648865781e-02, -4.115004379412642e-04,  6.745619416635114e-06,
 -1.130957204656103e-07,  1.739119046474751e-09, -1.062416173669456e-11,  7.845345506481553e-13, -9.436126328667485e-15, -6.111782232825098e-16, -2.074495285248665e-17,
  4.265717842438642e-20,  2.459251949111574e-20,  2.642650639987176e-09, -5.488365735925054e-10,  8.232242869653392e-11, -9.059111900487785e-12,  8.185665506952659e-13,
 -6.271718529610517e-14,  4.177481933935128e-15, -2.469296084140565e-16,  1.310789255246833e-17, -6.314203183958389e-19,  2.786402880147517e-20, -1.131626154491191e-21,
  8.088736055878337e-07, -6.827462713350928e-08,  6.006949448680725e-09, -3.805392886952874e-10,  2.139641693892569e-11, -1.098975523106270e-12,  4.983546251159617e-14,
 -2.104266643596562e-15,  8.363474862670220e-17, -3.036347925839050e-18,  1.052146830402913e-19, -3.492139545455579e-21,  5.022416520416887e-05, -2.539892439876103e-06,
  1.600352860577047e-07, -7.169408273962602e-09,  2.886381484291507e-10, -1.171414839594400e-11,  3.936687594812014e-13, -1.235519206236738e-14,  4.247555725841429e-16,
 -1.161621787345365e-17,  2.950186201171157e-19, -1.033158874015757e-20,  9.365246351809732e-04, -3.294603960467035e-05,  1.518567304244947e-06, -5.222875758878117e-08,
  1.580679075213748e-09, -5.503538195835508e-11,  1.417709064778499e-12, -2.985599720790789e-14,  1.187968159800414e-15, -2.462314319186586e-17,  9.773836339616512e-20,
 -2.570441786524716e-20,  6.591490741933581e-03, -1.770649053103175e-04,  5.760726845195264e-06, -1.565816269290359e-07,  3.691658627229327e-09, -1.093665166941722e-10,
  2.228231345400350e-12, -2.331283494226298e-14,  1.666491316851843e-15, -3.079663038534215e-17, -1.001455725881921e-18, -4.146301826935131e-20,  1.878244062963585e-02,
 -4.173881620594823e-04,  9.151639076335462e-06, -1.925777665992050e-07,  3.821752717594963e-09, -7.366186015330320e-11,  1.348743131768242e-12, -2.079408074934660e-14,
  4.206436647523800e-16, -1.071364730965943e-17, -5.077564915539183e-20,  2.627177279443750e-22,  1.817585350650860e-02, -3.625011753629197e-04,  5.551368890613082e-06,
 -8.608443707214362e-08,  1.679433164655884e-09,  2.214806897894556e-12,  1.532361419391329e-13, -3.761494801080862e-14, -9.353915832493827e-16,  1.628245027685219e-17,
  2.017378883606767e-18,  4.754782736234592e-20,  1.298213198009696e-09, -1.713371840577893e-10,  2.361319774135485e-11, -2.256356265207910e-12,  1.844210332002319e-13,
 -1.322292954973687e-14,  8.257528970665225e-16, -4.634347043343838e-17,  2.374489683365491e-18, -1.103758728852934e-19,  4.719010425407133e-21, -1.885207687811244e-22,
  6.094116501809763e-07, -3.399444690092518e-08,  2.935734367187002e-09, -1.646970581859965e-10,  7.825100152205927e-12, -3.855816093635791e-13,  1.635589675340079e-14,
 -5.950934927848416e-16,  2.330295575287992e-17, -8.395337178762564e-19,  2.347363374865057e-20, -8.023531555102921e-22,  4.217125189998396e-05, -1.540189418030473e-06,
  9.537882520862863e-08, -4.006409101367594e-09,  1.273468559898329e-10, -5.205438114806063e-12,  1.870519408179040e-13, -3.899823259686491e-15,  1.345874294558886e-16,
 -6.141954621896131e-18,  4.931136855383086e-20, -4.420007901608166e-22,  8.255785977914894e-04, -2.294731370735325e-05,  1.012618806845679e-06, -3.411240784384690e-08,
  7.711802678081960e-10, -2.758422827643198e-11,  9.757293304175931e-13, -6.950216337576753e-15,  1.865293520719433e-16, -3.268052374106469e-17, -1.034705321726944e-19,
  2.771440921461166e-20,  5.964723868525501e-03, -1.376389540275374e-04,  4.172996117426977e-06, -1.122380153561026e-07,  2.011806509073755e-09, -5.905996810993125e-11,
  2.086621741243060e-12,  2.489586894428325e-15, -3.542814441261700e-16, -7.703814497631957e-17, -2.124300920951374e-19,  1.029657637987186e-19,  1.724601153986718e-02,
 -3.524806928159336e-04,  7.164189226886783e-06, -1.416321094024137e-07,  2.631370679191877e-09, -4.712131773402056e-11,  8.959912348531468e-13, -1.353253365930413e-14,
  5.271489490281661e-17, -6.994896544245528e-18,  3.412885917954738e-19,  1.261568273453615e-20,  1.680877685384933e-02, -3.217627890905011e-04,  4.680592646803167e-06,
 -5.906527691130570e-08,  1.662269226350984e-09, -8.963604207012212e-12, -1.105880286114210e-12, -4.059804290375892e-14,  1.262295588788495e-15,  9.663428576834177e-17,
  4.640491041576994e-19, -1.537439663918851e-19,  8.702457462526138e-10, -5.537171184061972e-11,  8.086803118852360e-12, -6.680444592960947e-13,  4.553700771252440e-14,
 -3.073968620739271e-15,  1.829453152888825e-16, -9.267962666550413e-18,  4.483501777680753e-19, -2.101742690386162e-20,  8.477650261553952e-22, -3.055391202587820e-23,
  5.102670893743618e-07, -1.675616810177213e-08,  1.512679693910936e-09, -8.431457955009193e-11,  3.025464131436921e-12, -1.314818306649024e-13,  6.587494598470942e-15,
 -1.996316730966147e-16,  4.604935487317108e-18, -2.781897964774571e-19,  1.064541729510925e-20,  1.138458940313666e-23,  3.727234152449357e-05, -9.413130741106804e-07,
  5.679595568409273e-08, -2.588651025793039e-09,  6.099080003677795e-11, -1.727996867950024e-12,  1.083242652629246e-13, -2.605799145568471e-15, -2.912418766290565e-17,
 -1.868297907995533e-18,  1.960768783740944e-19,  3.183506732895440e-21,  7.476495708159097e-04, -1.630798623638311e-05,  6.630377262571741e-07, -2.498227233034328e-08,
  4.369281490268957e-10, -6.863481530509036e-12,  7.012388289958406e-13, -1.719909390190277e-14, -6.294419160348961e-16,  4.638732746785954e-19,  1.710967197837327e-18,
  1.681929547975678e-20,  5.473082250315768e-03, -1.091673779476108e-04,  2.989047977318848e-06, -8.680846651156628e-08,  1.320163602124279e-09, -1.178696631530466e-11,
  1.630449372446182e-12, -4.412980176243488e-14, -1.949132763175674e-15,  2.334343999768796e-17,  4.598570715190045e-18,  1.117763987163863e-20,  1.594087656158253e-02,
 -3.013144537169082e-04,  5.689552022744118e-06, -1.060285087458910e-07,  1.873695547824027e-09, -3.009335854842284e-11,  5.257127049999207e-13, -1.262712329111776e-14,
  1.033501539055762e-16,  8.553518362543749e-18,  1.395124367573258e-19, -2.415024760081379e-20,  1.559273298454261e-02, -2.867254842376295e-04,  4.120028363482444e-06,
 -3.561014368802424e-08,  1.161987178974316e-09, -4.162008039574533e-11, -1.218617398903751e-12,  4.335994940510086e-14,  3.137042573184010e-15, -4.239609142977419e-17,
 -6.422448255593338e-18, -1.151896671485302e-20,  7.402320404248056e-10, -1.382469077827582e-11,  2.999201799017289e-12, -2.588618203015424e-13,  1.304250792936019e-14,
 -6.917472820833126e-16,  4.576452617173478e-17, -2.372154066078757e-18,  8.445880838405464e-20, -3.291308885398192e-21,  1.917765904821949e-22, -7.827942319964317e-24,
  4.619955386013628e-07, -8.031489329150367e-09,  7.277247309153809e-10, -5.004479520734176e-11,  1.581506120570305e-12, -3.014527090242876e-14,  2.132478647419310e-15,
 -1.327593599183811e-16,  1.758284025474075e-18,  7.557207751273256e-20,  3.669005510858175e-21, -3.820932234950919e-22,  3.424004004280075e-05, -5.964519334004134e-07,
  3.083138225838639e-08, -1.774966821607745e-09,  4.591586829637618e-11, -1.151249032920187e-13,  2.328333123956418e-14, -3.095209209117458e-15,  3.685651956954449e-17,
  4.134119870553545e-18, -6.300448165127776e-21, -1.025501590683523e-20,  6.912879144994556e-04, -1.208944497824352e-05,  4.030914765248374e-07, -1.837505714073417e-08,
  4.189422654873501e-10,  2.385325345225586e-12,  2.955096190679979e-14, -2.509856866242213e-14,  3.927632265343367e-16,  4.033124064124367e-17, -5.553018116052004e-19,
 -8.558905587891497e-20,  5.078137711074382e-03, -8.906934876560591e-05,  2.071782145088109e-06, -6.597088008850548e-08,  1.346821395161162e-09,  7.403194016544490e-12,
 -1.289530899450901e-13, -6.374216389722107e-14,  1.258667264527755e-15,  1.061224726925721e-16, -2.265470619685959e-18, -2.097294969551278e-19,  1.481925753443115e-02,
 -2.604196056708908e-04,  4.579139335334974e-06, -8.028867063269105e-08,  1.372470934820665e-09, -2.107437219210830e-11,  2.603815119242394e-13, -5.345231181015122e-15,
  2.739156769131266e-16, -3.393255533310054e-18, -4.515064438828614e-19,  1.080326275006789e-20,  1.450939827514433e-02, -2.552293055835910e-04,  3.773187265598026e-06,
 -2.468415236517126e-08,  1.821213026062502e-10, -4.797116437003009e-11,  8.625602727563290e-13,  7.886705780011403e-14, -1.635537976036652e-15, -1.530951849447273e-16,
  3.378343854981157e-18,  2.933137047076995e-19,  7.172430791012836e-10,  5.339629391518097e-13,  8.309787704563786e-13, -1.192756149851321e-13,  6.068964561607258e-15,
 -1.564854267145706e-16,  6.504455780921592e-18, -6.584245930550708e-19,  3.670917373732196e-20, -7.131572715285284e-22, -9.794990351772217e-24, -7.834999539715520e-25,
  4.382724652135534e-07, -4.215111929296787e-09,  2.650237458887758e-10, -2.789689783960631e-11,  1.233940293452474e-12, -1.447879879354336e-14, -3.679942451751722e-16,
 -3.514991266127672e-17,  3.561438678783039e-18, -3.945281324392347e-20, -5.387113293334506e-21,  1.105843857090634e-22,  3.223012620647127e-05, -4.226188281974877e-07,
  1.389083721981339e-08, -1.053853994960551e-09,  4.338400694189405e-11, -3.465769314301274e-13, -2.922755661556208e-14, -3.035314383664763e-16,  9.995473022460228e-17,
 -1.695356254613128e-18, -1.588604993332726e-19,  5.305415879041632e-21,  6.481478007930775e-04, -9.629918421165176e-06,  2.239491334955862e-07, -1.145073606457331e-08,
  4.288005872778867e-10, -2.878491901294254e-12, -3.428295284867213e-13,  1.047034408032722e-15,  8.593279179084812e-16, -1.938803825678874e-17, -1.293131164417115e-18,
  5.581561566663072e-20,  4.750522557585649e-03, -7.528774799677234e-05,  1.412387705234448e-06, -4.389410199246469e-08,  1.354462356344950e-09, -9.992072491767748e-12,
 -9.753900129350687e-13,  8.267451805695257e-15,  2.190353552346189e-15, -5.908437752236711e-17, -3.056033101433196e-18,  1.581264906171600e-19,  1.384523074543303e-02,
 -2.272970505079104e-04,  3.734521985241689e-06, -6.139697261858955e-08,  1.005645876393766e-09, -1.583412107949656e-11,  1.983894854958391e-13, -5.686968999660275e-16,
  1.042896278598881e-17, -6.026619517566770e-18,  2.650193999663514e-19,  5.654004449769562e-21,  1.354696287035992e-02, -2.262416102681641e-04,  3.468122664085704e-06,
 -2.772851549151408e-08, -4.386262273359679e-10, -1.037446647346782e-11,  1.799572902386588e-12, -1.913553019281594e-14, -2.986391666498378e-15,  8.330150199063882e-17,
  4.297009348802978e-18, -2.258181477749418e-19,  7.256682081439329e-10,  2.902005557918081e-12, -1.056121294470120e-13, -4.294006457444480e-14,  3.582149412778948e-15,
 -1.152906454213762e-16,  1.544261755025439e-19,  4.520763763892260e-20,  7.257924007767885e-21, -6.878829573117515e-22,  1.869992994905491e-23,  4.928313761154852e-25,
  4.239721063327158e-07, -3.124282723305846e-09,  3.719128630301475e-11, -1.108190079658447e-11,  8.330402607548523e-13, -2.467966052151797e-14, -1.795978557451477e-16,
  3.001752831749197e-17,  2.370095168853490e-19, -8.754623756765591e-20,  2.596571012535706e-21,  8.585810906778769e-23,  3.069747420168963e-05, -3.510425591392970e-07,
  5.062769872222741e-09, -4.507081559444213e-10,  3.026194458361625e-11, -8.752116550053737e-13, -7.653964754647697e-15,  1.250436157199488e-15, -6.647503242495875e-18,
 -2.470551954962951e-18,  8.899278925005327e-20,  1.936397919791565e-21,  6.124965774103176e-04, -8.278366744596862e-06,  1.244959099893631e-07, -5.442393076741583e-09,
  3.037696117876456e-10, -8.518341613883130e-12, -7.405844451243191e-14,  1.264958505176920e-14, -1.324887417765376e-16, -2.067661997432543e-17,  8.517431964109401e-19,
  1.223983723683555e-20,  4.469124539688356e-03, -6.574973658658030e-05,  1.005463784876407e-06, -2.490279758216093e-08,  9.699346988815269e-10, -2.516058715358416e-11,
 -1.688283315400303e-13,  3.468092666337490e-14, -4.634114731376711e-16, -5.100773710245748e-17,  2.311846177029052e-18,  2.178291050834687e-20,  1.299148524161321e-02,
 -2.001168115037880e-04,  3.084670533218699e-06, -4.758795892647371e-08,  7.349054830904559e-10, -1.135190753161298e-11,  1.692013118939129e-13, -1.708662948749106e-15,
 -3.263617290671996e-17,  1.887072982007020e-18,  4.091806934700167e-20, -6.973764649146173e-21,  1.269520713783487e-02, -1.999489726952252e-04,  3.093154576850430e-06,
 -3.439310411630035e-08, -2.989629736860738e-10,  1.904453163757551e-11,  4.971247827560114e-13, -5.333251901902726e-14,  7.345251694614695e-16,  7.081204428987206e-17,
 -3.272145890186179e-18, -2.944428680205617e-20,  7.334730330712557e-10,  7.996001801400060e-13, -3.506626714188705e-13, -3.206550673500694e-15,  1.474797479096156e-15,
 -8.744806847753573e-17,  2.059586162747589e-18,  3.545794504944562e-20, -3.565543962458251e-21,  8.723703934441792e-24,  8.990862243510584e-24, -4.803378173155283e-25,
  4.114980047273293e-07, -3.169755793372981e-09, -3.211463293602135e-11, -1.664521145483133e-12,  3.593898363813434e-13, -2.016282981582652e-14,  4.520136469019693e-16,
  9.273463482808437e-18, -9.116282957807273e-19,  1.266229805364601e-20,  1.250353200721690e-21, -7.420788241883314e-23,  2.934990603902848e-05, -3.252838432853366e-07,
  1.979149522199231e-09, -1.058585824095252e-10,  1.337785577480360e-11, -7.192251074258387e-13,  1.610810523113663e-14,  3.176594509870344e-16, -3.278978477293479e-17,
  5.893684932367195e-19,  3.383358405471074e-20, -2.276044402525688e-21,  5.810608694377732e-04, -7.474044822134084e-06,  8.270796602348638e-08, -1.936240614240227e-09,
  1.397917334182169e-10, -6.975453153826380e-12,  1.555476069899283e-13,  2.890962401685812e-15, -3.120581848640099e-16,  6.299241298956905e-18,  2.692530493549806e-19,
 -2.004223654548584e-20,  4.220642419498275e-03, -5.867575236206125e-05,  7.832195605178743e-07, -1.334517384506809e-08,  4.912989640740901e-10, -2.030645956102297e-11,
  4.414151021732406e-13,  7.206467605358414e-15, -8.322750326626584e-16,  1.803946137335324e-17,  6.331427986351442e-19, -5.118627502489208e-20,  1.223701719407394e-02,
 -1.775396829139986e-04,  2.577340641054273e-06, -3.744270667800969e-08,  5.442605876877197e-10, -7.920401969670621e-12,  1.166813946404807e-13, -1.756970835013270e-15,
  1.990280795881200e-17,  5.002206978733783e-19, -4.757271609758863e-20,  1.232730209756995e-21,  1.194221376179276e-02, -1.769050125901485e-04,  2.665181898320929e-06,
 -3.591970789324926e-08,  1.007558276786971e-10,  1.718412723206892e-11, -4.572321036915968e-13, -1.264294567963486e-14,  1.216081878674339e-15, -2.628635737609446e-17,
 -8.775697915458020e-19,  7.216603856212813e-20,  7.312311898539304e-10, -1.873141775819490e-12, -2.961693343732801e-13,  9.210660806169156e-15,  2.412815261340748e-16,
 -3.711403271502690e-17,  1.794236671861180e-18, -3.795082901922209e-20, -6.891373368916407e-22,  7.853976458665381e-23, -2.086299815751850e-24, -4.137212604829849e-26,
  3.982813451745446e-07, -3.435410457353025e-09, -2.887070595191417e-11,  1.485723018077141e-12,  7.120387601555374e-14, -8.867024911983585e-15,  4.090227103959528e-16,
 -8.210458901266432e-18, -1.654846426347935e-19,  1.744412460161146e-20, -4.753501141154720e-22, -5.533904889620081e-24,  2.807626871266705e-05, -3.118424281089512e-07,
  1.590268568445366e-09,  1.531570013815249e-11,  3.070488171548288e-12, -3.196990222855346e-13,  1.441194188202757e-14, -2.891457707544962e-16, -5.497946696527999e-18,
  5.950549640161734e-19, -1.685560435094106e-20, -1.186731226259871e-22,  5.523823055545331e-04, -6.876517262663790e-06,  6.897941096304826e-08, -6.024740560908078e-10,
  3.937978709391006e-11, -3.151798851493294e-12,  1.373368047776061e-13, -2.757773781391130e-15, -4.924250158544365e-17,  5.502035624595666e-18, -1.603463176653306e-19,
 -6.883621532215225e-22,  3.997609553732788e-03, -5.294390648768911e-05,  6.587803637184815e-07, -8.134707603429829e-09,  1.947816921135016e-10, -9.617554394566621e-12,
  3.819494197981278e-13, -7.599152035062195e-15, -1.235573415643965e-16,  1.443131872912555e-17, -4.301088528390841e-19, -1.050739127065700e-21,  1.156544454125811e-02,
 -1.585812966875567e-04,  2.175500236515577e-06, -2.986497383019275e-08,  4.102752014954771e-10, -5.632059461703116e-12,  7.715753997632143e-14, -1.085004198286413e-15,
  1.748155504458077e-17, -3.072480462674953e-19,  5.671062123618515e-23,  4.664020075346355e-22,  1.127457457491771e-02, -1.572583710818996e-04,  2.253062498560111e-06,
 -3.220815152236840e-08,  3.245861426243814e-10,  5.372432910081262e-12, -4.276226972671592e-13,  9.212897259645303e-15,  1.957635432279801e-16, -2.071788286962429e-17,
  6.143392934745919e-19,  1.305762917489286e-21,  7.197350585634106e-10, -3.777846317659848e-12, -1.804287650052452e-13,  9.094045910434372e-15, -1.604297076991262e-16,
 -7.280589836018066e-18,  7.296529252568252e-19, -3.109583542984729e-20,  6.711806195250943e-22,  5.337386703080568e-24, -1.040105939015454e-24,  4.025753767427961e-26,
  3.842041252216864e-07, -3.586116550107886e-09, -8.556886288725496e-12,  1.656824852318438e-12, -2.770490386418097e-14, -1.959024375925229e-15,  1.733917679389262e-16,
 -7.037570275503347e-18,  1.421494326222598e-19,  1.509687083931103e-21, -2.296240047174719e-22,  8.366683123767230e-24,  2.685618196185494e-05, -2.979281752832211e-07,
  1.910777687843514e-09,  2.918262620435110e-11, -5.559175238296788e-13, -7.562187335346955e-14,  6.172769409865434e-15, -2.458751746881006e-16,  4.913742655103705e-18,
  5.090807803673882e-20, -7.733865383500925e-21,  2.804633484174840e-22,  5.259442239343550e-04, -6.346653167373860e-06,  6.395491024077527e-08, -3.251382473723583e-10,
  2.748978223849694e-12, -8.202516491155051e-13,  5.939850740229873e-14, -2.319537582597078e-15,  4.619636560487505e-17,  4.545551678861621e-19, -7.079195040773512e-20,
  2.576291612586627e-21,  3.795815318727465e-03, -4.802290567631801e-05,  5.749227831572593e-07, -6.134316304156385e-09,  7.617296545812268e-11, -3.084767527033566e-12,
  1.695282319028836e-13, -6.301927879871973e-15,  1.245887126253795e-16,  1.135368683893338e-18, -1.843826394923720e-19,  6.747665536874921e-21,  1.096380464519313e-02,
 -1.425071728373580e-04,  1.853089964099064e-06, -2.411040382670470e-08,  3.139766100076165e-10, -4.091177498240532e-12,  5.309343398956895e-14, -6.794199190507550e-16,
  8.882297820731600e-18, -1.510619485678936e-19,  3.904540880722866e-21, -8.394817583374776e-23,  1.067927367729632e-02, -1.406865701746806e-04,  1.899718797962109e-06,
 -2.661956867831737e-08,  3.516313252610564e-10, -1.613749846811083e-12, -1.621517152078039e-13,  7.908490165375740e-15, -1.632623213163572e-16, -1.771412371299338e-18,
  2.628935596484923e-19, -9.576701700873488e-21,  7.023579723291158e-10, -4.834575391712158e-12, -8.912791023629766e-14,  6.061445013971746e-15, -1.889518364758834e-16,
  2.176096411128655e-18,  1.486693778322570e-19, -1.166316863681392e-20,  4.559551334835235e-22, -1.031596397630022e-23,  2.254680239947149e-26,  9.379188253604800e-27,
  3.698355933470243e-07, -3.584382902659294e-09,  7.944384890509035e-12,  1.068604803517846e-12, -3.854198786135142e-14,  3.544885969022332e-16,  3.920105263681649e-17,
 -2.779898621013235e-18,  1.032062329394225e-19, -2.171583682820133e-21, -1.486135726135872e-24,  2.180196496752140e-24,  2.569694784370351e-05, -2.814653464570365e-07,
  2.178151515274749e-09,  1.422170726038571e-11, -1.051560713304568e-12,  7.769056720789851e-15,  1.461523197899297e-15, -9.853093989332895e-17,  3.589798811613971e-18,
 -7.410959692908212e-20, -8.120203102453262e-23,  7.415654332472685e-23,  5.015561061326751e-04, -5.850713587404778e-06,  5.997369586149665e-08, -3.539745946023898e-10,
 -3.788904038047214e-12, -6.552576196845918e-15,  1.482953439300054e-14, -9.382638797431894e-16,  3.367783994088145e-17, -6.894662775960923e-19, -7.495431134571696e-22,
  6.801645496311494e-22,  3.612480806790062e-03, -4.370076864937428e-05,  5.071595622881961e-07, -5.239848798719069e-09,  4.321641496194768e-11, -6.834150011902215e-13,
  4.780877644894971e-14, -2.594251259120873e-15,  9.038924498162795e-17, -1.834626395301192e-18, -1.674585986786327e-21,  1.772117217862677e-21,  1.042170590090057e-02,
 -1.287601496128865e-04,  1.591414558434275e-06, -1.967807805490043e-08,  2.435025765927598e-10, -3.017227314395820e-12,  3.740493329008412e-14, -4.590994522348692e-16,
  5.409328383277365e-18, -6.148052509127662e-20,  9.942727555666135e-22, -3.440931102085162e-23,  1.014503027554915e-02, -1.266744122129188e-04,  1.612470236951866e-06,
 -2.139863422375651e-08,  2.952805699174777e-10, -3.442927100685612e-12, -1.311960063178887e-14,  2.997620507651288e-15, -1.195949867233257e-16,  2.493527486772371e-18,
  3.601295492666574e-21, -2.520149967709820e-21,  6.819871379926960e-10, -5.303922543172348e-12, -3.270695944698486e-14,  3.494669968540276e-15, -1.290669469081588e-16,
  3.151240003290788e-18, -2.508153669811460e-20, -2.336967676411057e-21,  1.560182422962723e-22, -5.704597901019277e-24,  1.333150797130064e-25, -1.212481050935728e-27,
  3.556925830535392e-07, -3.479254546920144e-09,  1.740903874013422e-11,  5.391179924312000e-13, -2.671684974005151e-14,  6.651962097767856e-16, -3.477974161848113e-18,
 -6.174502456104391e-19,  3.750507842103861e-20, -1.300135668337431e-21,  2.828473511127256e-23, -1.832303423169081e-25,  2.460664042375111e-05, -2.636231420342705e-07,
  2.257094938313002e-09, -1.896909735478123e-13, -7.119543302176874e-13,  2.034808271170229e-14, -6.874720355670600e-17, -2.277859946876375e-17,  1.329421392095098e-18,
 -4.518893542952814e-20,  9.605888050500711e-22, -5.571544698912205e-24,  4.790845743847047e-04, -5.388866156615544e-06,  5.540082121296748e-08, -4.033359605515577e-10,
 -1.954022213485778e-12,  1.338012529878993e-13,  1.114556557740047e-16, -2.249249169236202e-16,  1.260729782163104e-17, -4.229271392325583e-19,  8.888902862321162e-21,
 -4.943064513701500e-23,  3.445409668237102e-03, -3.988398517990639e-05,  4.481260464755981e-07, -4.614969796040538e-09,  3.657620855297900e-11, -1.395410310643732e-13,
  6.264190745624741e-15, -6.709075092379619e-16,  3.432451032810147e-17, -1.128098164375110e-18,  2.348438446873872e-20, -1.286375617240180e-22,  9.930720234248397e-03,
 -1.169114378358235e-04,  1.376809349968536e-06, -1.622005985022287e-08,  1.911871995927760e-10, -2.256033765528281e-12,  2.668265890337513e-14, -3.158490965585508e-16,
  3.671379281469176e-18, -3.915625698191912e-20,  3.397793334078748e-22, -3.755898788742516e-24,  9.662612341776223e-03, -1.147266991351058e-04,  1.381767331240423e-06,
 -1.722032533920959e-08,  2.281794214315812e-10, -3.103064036707921e-12,  3.004336346510107e-14,  4.913357315253251e-16, -4.319004537918089e-17,  1.532970359624315e-18,
 -3.247651468963822e-20,  1.730905689846371e-22,  6.604701228047631e-10, -5.428439511574065e-12, -1.228448996339411e-15,  1.886899395347813e-15, -7.512760328732774e-17,
  2.172095515708274e-18, -4.490795411703095e-20,  2.667250693015570e-22,  2.998516001536888e-23, -1.786717655595928e-24,  6.173358193752040e-26, -1.460334669690364e-27,
  3.420860933373943e-07, -3.320410898371308e-09,  2.172672611729343e-11,  2.096248771736180e-13, -1.510395630088827e-14,  4.738863812273019e-16, -9.576574462078622e-18,
  2.849393126456090e-20,  8.019763334722104e-21, -4.347852012954140e-22,  1.423340877050932e-23, -3.147532058077739e-25,  2.358801264745003e-05, -2.457395772395712e-07,
  2.199189048297930e-09, -8.562060572393265e-12, -3.537782823475244e-13,  1.459605332717840e-14, -3.069108826148455e-16,  3.870459445093009e-19,  2.956153119982565e-19,
 -1.545443657101061e-20,  4.957574603876141e-22, -1.069898335576955e-23,  4.583843786989533e-04, -4.965354740160482e-06,  5.045775998001314e-08, -4.145251718307816e-10,
  4.229633798756643e-13,  9.471536397856786e-14, -2.376431525877233e-15, -3.379182003589527e-18,  2.887217163588380e-18, -1.464371667909624e-19,  4.639000200482782e-21,
 -9.886005798911994e-23,  3.292706809424463e-03, -3.651072978569681e-05,  3.961790853845511e-07, -4.048482634039179e-09,  3.427169314232551e-11, -1.219669328464674e-13,
 -2.056911456077391e-15, -5.905460842949956e-17,  8.281597161093129e-18, -3.957181716973151e-19,  1.233970749775737e-20, -2.603910018244643e-22,  9.483939870394127e-03,
 -1.066267401199461e-04,  1.199138652654757e-06, -1.349001971865858e-08,  1.518174223778809e-10, -1.709714132697087e-12,  1.928912224429229e-14, -2.185140445544041e-16,
  2.481356761099473e-18, -2.743108853845897e-20,  2.615694740174408e-22, -1.310805585116067e-24,  9.224586817879521e-03, -1.044415196067507e-04,  1.195114804931502e-06,
 -1.402433118357687e-08,  1.738212970248617e-10, -2.330510090751647e-12,  3.109850138567062e-14, -2.336344987940471e-16, -8.158719731878921e-18,  5.201326213993091e-19,
 -1.701316627423154e-20,  3.632579009774328e-22,  6.388551607783377e-10, -5.365191181524923e-12,  1.545625315238877e-14,  9.777065356572139e-16, -4.149757918139964e-17,
  1.247154858813179e-18, -3.092345866643801e-20,  5.648065626388356e-22, -2.825388336135723e-24, -3.247214392353666e-25,  1.783904922471296e-26, -5.862598075630259e-28,
  3.291630599325545e-07, -3.140001270260806e-09,  2.306621979318151e-11,  3.193696318366186e-14, -7.759164798566858e-15,  2.714757474399770e-16, -6.896767459575647e-18,
  1.206863709361312e-19, -2.324821379441460e-22, -8.848018134589357e-23,  4.405139032877273e-24, -1.371438107249497e-25,  2.263948086367191e-05, -2.286336084276682e-07,
  2.070862997055299e-09, -1.226984847889851e-11, -1.308646494609494e-13,  8.031039383164385e-15, -2.248160146711837e-16,  3.955494806123618e-18, -1.300424182394509e-21,
 -3.274648284701802e-21,  1.572905725288774e-22, -4.796425767053013e-24,  4.392991073504257e-04, -4.581350567724297e-06,  4.557678702630976e-08, -3.955978734239846e-10,
  1.776582984695857e-12,  4.320155084885460e-14, -1.759453895926216e-15,  3.290947365765467e-17,  5.162383426610672e-20, -3.187301235193296e-20,  1.491969153886443e-21,
 -4.494194562829634e-23,  3.152707963546033e-03, -3.352650628210315e-05,  3.507976423670647e-07, -3.522495140239240e-09,  3.131441343333647e-11, -1.714966279864066e-13,
 -1.580613344402521e-15,  5.332017442710738e-17,  5.346558178770278e-19, -8.961716621961909e-20,  4.018430137800864e-21, -1.194594812827653e-22,  9.075648952477335e-03,
 -9.764230256507254e-05,  1.050780635000661e-06, -1.131127203315617e-08,  1.217996921547279e-10, -1.312066574796205e-12,  1.414761620822102e-14, -1.530138902708276e-16,
  1.666856798253952e-18, -1.827062242915351e-20,  1.937718510162409e-22, -1.656613721097808e-24,  8.824939120806223e-03, -9.550978113378612e-05,  1.042095945040694e-06,
 -1.157809337341463e-08,  1.340510147707141e-10, -1.678831183038826e-12,  2.294463092882311e-14, -2.986069844987768e-16,  1.644414309836491e-18,  1.010975536687737e-19,
 -5.412350264892016e-21,  1.660962473184107e-22,  6.177022672545407e-10, -5.204239300355102e-12,  2.391149402714943e-14,  4.780604127621283e-16, -2.277929536485653e-17,
  6.776156242546695e-19, -1.739181312681217e-20,  3.847290676625294e-22, -6.389639445134087e-24,  3.083412904416061e-26,  3.030784566752443e-27, -1.574352358431297e-28,
  3.169720392577815e-07, -2.955689274144567e-09,  2.285766642896563e-11, -5.666091220204850e-14, -3.724379318187305e-15,  1.436864825273432e-16, -3.915198521227278e-18,
  8.674084447860913e-20, -1.365678210382841e-21,  2.421857492197236e-24,  8.458559066657595e-25, -3.952104400621505e-26,  2.175711139552687e-05, -2.126807669550296e-07,
  1.915513038973482e-09, -1.333534483983466e-11, -1.558569536683512e-14,  3.885530478506762e-15, -1.257145289829165e-16,  2.906518924076631e-18, -4.530555626999708e-20,
  1.285291044899063e-23,  3.152811307776962e-23, -1.419255284900965e-24,  4.216736201102397e-04, -4.235189446182254e-06,  4.102208698292935e-08, -3.622481711852959e-10,
  2.290680534574051e-12,  1.148831222800222e-14, -9.240613538440735e-16,  2.457006052233854e-17, -3.915086582003901e-19, -4.474710309389365e-22,  3.070446335537520e-22,
 -1.349242281636549e-23,  3.023958658370736e-03, -3.088095889812587e-05,  3.114154260583954e-07, -3.050451778890945e-09,  2.762672987883334e-11, -1.916730805251712e-13,
 -1.620632545056938e-16,  4.144234319509728e-17, -7.837682714825369e-19, -4.199528379865800e-21,  8.547750323252399e-22, -3.630516680589056e-23,  8.701076860062577e-03,
 -8.974775032612368e-05,  9.259282015080657e-07, -9.555314658151516e-09,  9.863550781661056e-11, -1.018466845592904e-12,  1.052095336154370e-14, -1.088416369624831e-16,
  1.131625418070665e-18, -1.190801301375344e-20,  1.269789660701796e-22, -1.309722514284508e-24,  8.458741935812097e-03, -8.769467118313323e-05,  9.150091707741893e-07,
 -9.674675219086653e-09,  1.053444155771451e-10, -1.220373024321388e-12,  1.563913964381928e-14, -2.178931667145843e-16,  2.754103073215332e-18, -1.100153264132941e-20,
 -1.036316371809622e-21,  4.961910134190178e-23,  5.972966718734425e-10, -4.995297224182798e-12,  2.784421783633916e-14,  2.025973348124956e-16, -1.264134982176204e-17,
  3.679686809161093e-19, -9.209514575490946e-21,  2.112916982959493e-22, -4.264279751621696e-24,  6.579386669232537e-26, -3.381245290226831e-28, -2.466157926276680e-29,
  3.055095191776499e-07, -2.776371715862578e-09,  2.190053858144586e-11, -9.762687236678192e-14, -1.618123577419646e-15,  7.417393636142623e-17, -2.054182439957337e-18,
  4.838469430298996e-20, -9.676617319675025e-22,  1.408144617601350e-23, -3.154721602221490e-26, -7.092742004589227e-27,  2.093602366370645e-05, -1.979960319244952e-07,
  1.756094761040843e-09, -1.310216946055701e-11,  3.772414467592293e-14,  1.687809092367984e-15, -6.338563087894908e-17,  1.614408312329487e-18, -3.292200905098295e-20,
  4.706681495183618e-22, -4.091669584486852e-25, -2.669403111332972e-25,  4.053625789329407e-04, -3.923766904659812e-06,  3.689927200972586e-08, -3.247552426788481e-10,
  2.347248713459370e-12, -3.802967906228569e-15, -4.023707480465465e-16,  1.326628108910182e-17, -2.894136876028042e-19,  4.158810936241945e-21,  1.031837239456448e-24,
 -2.607859511749069e-24,  2.905195860222957e-03, -2.852883366952673e-05,  2.773359370254974e-07, -2.638959573341684e-09,  2.383377552281755e-11, -1.844392649468279e-13,
  6.570709522605789e-16,  1.814450298942895e-17, -5.973690496859095e-19,  9.232213883419311e-21,  2.461486286885218e-23, -7.229420885786608e-24,  8.356210447439238e-03,
 -8.277361475753496e-05,  8.201030223660830e-07, -8.127349208325705e-09,  8.056393292632316e-11, -7.988064875232753e-13,  7.922288659702281e-15, -7.861233322838999e-17,
  7.818008087325996e-19, -7.836409584942062e-21,  8.006221954236095e-23, -8.380746385254633e-25,  8.121906284306630e-03, -8.081206061235019e-05,  8.082814945008325e-07,
 -8.165932776438197e-09,  8.424532422863503e-11, -9.088526643980625e-13,  1.067502048151758e-14, -1.408441587304353e-16,  1.988542173079721e-18, -2.440133404727470e-20,
  7.707394539018829e-23,  9.138220101551043e-24,  5.777721836517487e-10, -4.765767013693536e-12,  2.927066163593885e-14,  4.896240268711189e-17, -7.083916291444259e-18,
  2.045731777999549e-19, -4.874460435737743e-21,  1.088103529449331e-22, -2.282680698945362e-24,  4.265560629457960e-26, -6.213376975844095e-28,  3.564710363467401e-30,
  2.947465291599326e-07, -2.606196233847114e-09,  2.061507396249038e-11, -1.139241824091371e-13, -5.340764866866576e-16,  3.808040993147369e-17, -1.060923646846270e-18,
  2.488650809290143e-20, -5.280332187891728e-22,  9.726768148214250e-24, -1.334493907273676e-25,  4.126135219462265e-28,  2.017115856277941e-05, -1.845638202479902e-07,
  1.603373725266137e-09, -1.229776526576997e-11,  5.937863754285396e-14,  6.050716225422197e-16, -3.050099355872551e-17,  8.135068935258222e-19, -1.798982407521410e-20,
  3.340293514325606e-22, -4.485470112969095e-24,  8.331803835040796e-27,  3.902341083768847e-04, -3.643531161360429e-06,  3.322363896531703e-08, -2.882232226543063e-10,
  2.199874090116043e-12, -9.914435344874452e-15, -1.389389853100076e-16,  6.257006454070825e-18, -1.559562252862907e-19,  3.002640720831379e-21, -4.019890859770316e-23,
  3.860690921730070e-26,  2.795326130049179e-03, -2.643060751353368e-05,  2.478378971040133e-07, -2.286134850135756e-09,  2.033396491126305e-11, -1.644307935881885e-13,
  9.462068298373600e-16,  4.111197751038876e-18, -2.951900927910850e-19,  6.820081593016327e-21, -9.461235233135307e-23, -5.001887952914402e-26,  8.037649374218511e-03,
 -7.658214053901817e-05,  7.298132915919420e-07, -6.956505318341556e-09,  6.632443891350598e-11, -6.324985442782698e-13,  6.033001663509001e-15, -5.755580186463860e-17,
  5.494572762949718e-19, -5.262884474075732e-21,  5.100927043561287e-23, -5.086886665414390e-25,  7.811000570133330e-03, -7.471615588528841e-05,  7.178197265841406e-07,
 -6.950725325647237e-09,  6.834468350342347e-11, -6.935614244559763e-13,  7.497620343231542e-15, -9.015498800405775e-17,  1.223018263676365e-18, -1.734132070935796e-20,
  2.071974723457495e-22, -6.231752268935114e-25,  5.591788106672359e-10, -4.530904097842428e-12,  2.929509236692841e-14, -3.710091219061992e-17, -3.952773297973025e-18,
  1.171491680257208e-19, -2.651484729562289e-21,  5.593979079727126e-23, -1.143254933975116e-24,  2.222866733693646e-26, -3.887152692244395e-28,  5.410517287474800e-30,
  2.846427883594063e-07, -2.446839327590450e-09,  1.921793714752912e-11, -1.175536240667980e-13,  2.072824501799394e-17,  1.935894608744828e-17, -5.550018423028898e-19,
  1.262775550338283e-20, -2.652578694097151e-22,  5.177806731684138e-24, -8.903603077686354e-26,  1.168887470435955e-27,  1.945764636144593e-05, -1.723102767304375e-07,
  1.461790032523037e-09, -1.128396421704871e-11,  6.571143993070330e-14,  9.124925734485882e-17, -1.421114073016497e-17,  3.975028080332046e-19, -8.937687080933878e-21,
  1.786357358978200e-22, -3.077001271226869e-24,  3.948280736436087e-26,  3.761704807066947e-04, -3.390994386964440e-06,  2.996915870962628e-08, -2.547421300445394e-10,
  1.979900797000806e-12, -1.162145520544380e-14, -1.949416405364532e-17,  2.700621025633619e-18, -7.472260916179349e-20,  1.595119697401253e-21, -2.804312097534353e-23,
  3.573134053072448e-25,  2.693402849076248e-03, -2.455234976395862e-05,  2.222518785288023e-07, -1.985843897511925e-09,  1.727711554112856e-11, -1.412065825294906e-13,
  9.609209559737473e-16, -2.108457609956606e-18, -1.136262851885535e-19,  3.460253860565615e-21, -6.716738780289111e-23,  8.717603172375797e-25,  7.742493392612641e-03,
 -7.106041908290395e-05,  6.523089925459471e-07, -5.989161326222238e-09,  5.500142524509431e-11, -5.052204092486247e-13,  4.641687571958998e-15, -4.265050313839997e-17,
  3.919361628700899e-19, -3.604772792730989e-21,  3.331414844986819e-23, -3.131171157342269e-25,  7.523117736729735e-03, -6.928963778979012e-05,  6.405438631044441e-07,
 -5.959188873536408e-09,  5.608902185913255e-11, -5.400099837465920e-13,  5.438222626067112e-15, -5.950240509376745e-17,  7.354217015052752e-19, -1.018368258467809e-20,
  1.436916426581439e-22, -1.679922315189818e-24,  5.415197875890246e-10, -4.299241381887417e-12,  2.853782853218411e-14, -8.459227963757567e-17, -2.137857678888138e-18,
  6.881831963463078e-20, -1.495914644120428e-21,  2.958917601827384e-23, -5.709272217416744e-25,  1.083571327665973e-26, -1.970485144636236e-28,  3.250271344152000e-30,
  2.751540254524518e-07, -2.298707508930695e-09,  1.782000744162326e-11, -1.147433200126157e-13,  2.990384422679728e-16,  9.472702337999275e-18, -2.965840347285454e-19,
  6.529251363805666e-21, -1.315006001150609e-22,  2.537552329668219e-24, -4.615055469669382e-26,  7.479152098907128e-28,  1.879096159853814e-05, -1.611396782722011e-07,
  1.332700047411517e-09, -1.023324143951794e-11,  6.488264522153742e-14, -1.434018484089363e-16, -6.268868345087646e-18,  1.938606216555992e-19, -4.331403572517943e-21,
  8.703724403198908e-23, -1.605380329504752e-24,  2.597004359242902e-26,  3.630673862154239e-04, -3.162947926235724e-06,  2.709463100899059e-08, -2.249271123454900e-10,
  1.747721042629834e-12, -1.140604614762561e-14,  2.990824099548680e-17,  1.041122205583055e-18, -3.393081150749403e-20,  7.604220377293289e-22, -1.459384920888761e-23,
  2.388460565542390e-25,  2.598604917478145e-03, -2.286516248553687e-05,  1.999911476732751e-07, -1.730776219248115e-09,  1.467712625502274e-11, -1.191654228050915e-13,
  8.664301879107050e-16, -4.197924395748226e-18, -2.867352802140839e-20,  1.479782305231926e-21, -3.400957773439817e-23,  5.907905232557293e-25,  7.468253639182073e-03,
 -6.611519702652186e-05,  5.854043032498176e-07, -5.184303012525266e-09,  4.592113787208986e-11, -4.068445723247904e-13,  3.605241148756514e-15, -3.195228972362662e-17,
  2.831849237110948e-19, -2.509718573723456e-21,  2.226664072501782e-23, -1.988588040359858e-25,  7.255775499852829e-03, -6.443684911145708e-05,  5.740832658457676e-07,
 -5.141597274596458e-09,  4.647148350882223e-11, -4.271287040571406e-13,  4.053616948739083e-15, -4.086253875731207e-17,  4.556366756881239e-19, -5.776950341222421e-21,
  8.082514641731363e-23, -1.126237142142717e-24,  5.247723008575878e-10, -4.075487487688175e-12,  2.735727754125824e-14, -1.094890647020353e-16, -1.062720150832390e-18,
  4.110619445680288e-20, -8.739454981791264e-22,  1.628515824147931e-23, -2.933835694059056e-25,  5.263063809989643e-27, -9.358656576704879e-29,  1.602032238735925e-30,
  2.662357260312962e-07, -2.161561627195567e-09,  1.647694587833451e-11, -1.087752469513531e-13,  4.299797005456437e-16,  4.146131260958783e-18, -1.611488107877869e-19,
  3.483387358371056e-21, -6.658227104618851e-23,  1.227389289895211e-24, -2.206404404988130e-26,  3.770042297102109e-28,  1.816697293046213e-05, -1.509518883483495e-07,
  1.216013196440050e-09, -9.224641112824867e-12,  6.087964674454932e-14, -2.418772546239255e-16, -2.386888172529340e-18,  9.497237764508166e-20, -2.117400185073080e-21,
  4.148739704262100e-23, -7.654402652504424e-25,  1.319114553627985e-26,  3.508326627829488e-04, -2.956529041983100e-06,  2.455590762498317e-08, -1.987415504885588e-10,
  1.528599442710228e-12, -1.043939366007731e-14,  4.727817231860928e-17,  2.988663908198213e-19, -1.488625488254045e-20,  3.484648831630403e-22, -6.862917056235110e-24,
  1.213084523826919e-25,  2.510217993112954e-03, -2.134449237943234e-05,  1.805557353052503e-07, -1.513920124011257e-09,  1.249188272678213e-11, -9.984429956085825e-14,
  7.424444126218983e-16, -4.480760421636822e-18,  5.483777966015717e-21,  5.429079756287904e-22, -1.499798988098636e-23,  2.948797969140337e-25,  7.212782168018127e-03,
 -6.166890789467861e-05,  5.273470184446259e-07, -4.510245478587919e-09,  3.858199550110807e-11, -3.301084921490735e-13,  2.824994731797493e-15, -2.417977261426434e-17,
  2.069702853775510e-19, -1.771283332347375e-21,  1.515562909502952e-23, -1.298423102528019e-25,  7.006839704390752e-03, -6.007895612261208e-05,  5.165795819782741e-07,
 -4.461469843754022e-09,  3.881687482597320e-11, -3.420961898116274e-13,  3.086264941595514e-15, -2.907224624917549e-17,  2.954828764727375e-19, -3.366180790528052e-21,
  4.349521941363152e-23, -6.083304440824152e-25,  5.088994119986378e-10, -3.862118025729680e-12,  2.596520826439324e-14, -1.209172594692964e-16, -4.182324037290563e-19,
  2.469473739014226e-20, -5.253597677851180e-22,  9.324912571200980e-24, -1.571220116447165e-25,  2.629997311096451e-27, -4.428634305896244e-29,  7.421372451709810e-31,
  2.578450156208090e-07, -2.034845231981013e-09,  1.521505793427209e-11, -1.014130296304592e-13,  4.810360639701454e-16,  1.243674980225345e-18, -8.784852787835348e-20,
  1.917455344713996e-21, -3.493894317746181e-23,  6.069113612154045e-25, -1.041561862693000e-26,  1.759011524687860e-28,  1.758194338794911e-05, -1.416503901765385e-07,
  1.110994401561137e-09, -8.291597437620080e-12,  5.565024471817675e-14, -2.737143858632771e-16, -4.880447290492897e-19,  4.618515795523696e-20, -1.057950708285765e-21,
  2.004276059455654e-23, -3.577799012597194e-25,  6.149899475798168e-27,  3.393849033584587e-04, -2.769221053039556e-06,  2.231107000160088e-08, -1.758906031688472e-10,
  1.331601009042951e-12, -9.248198296664464e-15,  5.053894605733329e-17, -2.073878484137369e-20, -6.208210957325780e-21,  1.581387592313396e-22, -3.126025776579035e-24,
  5.605041136216202e-26,  2.427618461893358e-03, -1.996946255382543e-05,  1.635250381429684e-07, -1.329099045722505e-09,  1.066318689562047e-11, -8.349685935709415e-14,
  6.216817324499992e-16, -4.086551848711853e-18,  1.682264657727186e-20,  1.455883164360609e-22, -6.057228584309990e-24,  1.306814288895869e-25,  6.974215492844062e-03,
 -5.765660814951881e-05,  4.767214073237312e-07, -3.942284558540577e-09,  3.260661689410415e-11, -2.697396147511068e-13,  2.231871399321303e-15, -1.847027788174491e-17,
  1.528710833270664e-19, -1.265141755158193e-21,  1.046576737686085e-23, -8.652924496099567e-26,  6.774464332971702e-03, -5.615040696935102e-05,  4.665549038723972e-07,
 -3.891369617873065e-09,  3.265480548479856e-11, -2.768267840053023e-13,  2.388522962085756e-15, -2.126593343676350e-17,  2.001150643167198e-19, -2.060420693790905e-21,
  2.393756640055449e-23, -3.123500332195987e-25,  4.938570772887410e-10, -3.660280659355208e-12,  2.448835042467412e-14, -1.242633258803790e-16, -3.188007314914353e-20,
  1.472779348337894e-20, -3.225314787342272e-22,  5.524939253838923e-24, -8.778655111189697e-26,  1.370766570490618e-27, -2.155641993962268e-29,  3.427555719431285e-31,
  2.499415546027085e-07, -1.917860523772031e-09,  1.404477571170598e-11, -9.361580488258140e-14,  4.885980560657057e-16, -3.291156251835582e-19, -4.702396421580995e-20,
  1.081606182811075e-21, -1.903863818836459e-23,  3.117050793353463e-25, -5.028719290126435e-27,  8.111814552437712e-29,  1.703250839458510e-05, -1.331457130247502e-07,
  1.016655995348493e-09, -7.445245714450939e-12,  5.014631082392893e-14, -2.731551469012866e-16,  4.226516268294317e-19,  2.156825834066639e-20, -5.398580518552618e-22,
  9.969912312896244e-24, -1.699215760297033e-25,  2.816478455420639e-27,  3.286521219183343e-04, -2.598826678009866e-06,  2.032232474592220e-08, -1.559993375256496e-10,
  1.158622862007187e-12, -8.060176801289682e-15,  4.788527523769031e-17, -1.483112028930403e-19, -2.274030721378083e-21,  7.155361661820449e-23, -1.425779413848091e-24,
  2.521495626871451e-26,  2.350259934501507e-03, -1.872228045291044e-05,  1.485469300339260e-07, -1.171074641875246e-09,  9.133514670011673e-12, -6.988533151409610e-14,
  5.153059481438105e-16, -3.501596319032846e-18,  1.883367754029267e-20, -8.696715047475030e-24, -2.206405355019609e-24,  5.452956307890936e-26,  6.750928992319510e-03,
 -5.402358948012066e-05,  4.323751694924931e-07, -3.460993070135490e-09,  2.770827137414032e-11, -2.218673015800741e-13,  1.776878611606700e-15, -1.423321311592880e-17,
  1.140283491015942e-19, -9.135491078061799e-22,  7.316954055943748e-24, -5.855650324727593e-26,  6.557043848474095e-03, -5.259627286918608e-05,  4.228201896042644e-07,
 -3.410260632349412e-09,  2.764675518634753e-11, -2.259865054093520e-13,  1.872755429091247e-15, -1.588788202355046e-17,  1.403481017435816e-19, -1.326134921960868e-21,
  1.385416002510065e-23, -1.632698894751887e-25,  1.988770214040474e+00,  7.652513206989192e-03, -2.647951420872427e-03,  7.780680440730037e-04, -2.117238457249173e-04,
  5.520544672459690e-05, -1.403151864188135e-05,  3.511424704984338e-06, -8.708219239247312e-07,  2.149525490247956e-07, -5.282599258180908e-08,  1.229158986908982e-08,
  1.994786168849995e+00,  3.647628602651899e-03, -1.358576670998920e-03,  4.051099126836120e-04, -1.099134641127942e-04,  2.837538544407427e-05, -7.119850834220635e-06,
  1.757313134685983e-06, -4.299169286101797e-07,  1.047849088807303e-07, -2.546636328926818e-08,  5.874256127693741e-09,  1.998372047742675e+00,  1.283787653321025e-03,
 -6.264817024342945e-04,  2.011375231988414e-04, -5.618455368626487e-05,  1.468410456668880e-05, -3.701559038619049e-06,  9.144183901377236e-07, -2.235105427498219e-07,
  5.439372458050764e-08, -1.319959214287610e-08,  3.041404267429854e-09,  2.000736520734323e+00, -2.653894366813371e-04, -1.583865494208145e-04,  7.372573838449698e-05,
 -2.334097527357362e-05,  6.478634474970494e-06, -1.688962609032634e-06,  4.258488646314057e-07, -1.054693295257590e-07,  2.589678850518167e-08, -6.324051553889541e-09,
  1.463580050645036e-09,  2.002317156261722e+00, -1.296801060813562e-03,  1.481184618332304e-04, -8.420270156201533e-06, -2.462388767746634e-06,  1.327762591333812e-06,
 -4.394314306534211e-07,  1.253545757396347e-07, -3.342896985476513e-08,  8.611417922829552e-09, -2.172456424151567e-09,  5.136587187865029e-10,  2.003319560960400e+00,
 -1.949156879261993e-03,  3.398544394541853e-04, -5.928839844079108e-05,  1.034909072965846e-05, -1.807662775282529e-06,  3.159681786465549e-07, -5.527219867995947e-08,
  9.676732269522104e-09, -1.695534047878415e-09,  2.970624633498148e-10, -5.057035514989322e-11,  2.003848513422795e+00, -2.292849531814259e-03,  4.402075947919135e-04,
 -8.575269347817831e-05,  1.697866507402045e-05, -3.422608338438904e-06,  7.035156654860588e-07, -1.476417603653353e-07,  3.166465347760587e-08, -6.943261082332159e-09,
  1.552837311219331e-09, -3.372868952091747e-10,  1.998982693152918e+00,  7.466711674451472e-04, -3.093890815117558e-04,  8.978471773354089e-05, -2.281577777898941e-05,
  5.407821802465567e-06, -1.228162458289952e-06,  2.710319148756787e-07, -5.859903122352476e-08,  1.247723144521507e-08, -2.621543560273768e-09,  5.244021408011333e-10,
  2.000007428432751e+00,  8.499801965242943e-05, -1.216865492061718e-04,  4.215430555255891e-05, -1.145312559775626e-05,  2.801371578111348e-06, -6.462238445416326e-07,
  1.436394614776809e-07, -3.112551384697222e-08,  6.621532327239128e-09, -1.387167902421440e-09,  2.764028910388621e-10,  2.000665667535021e+00, -3.381652984177863e-04,
 -3.919342059748886e-06,  1.283301602312893e-05, -4.588124328433864e-06,  1.255358430451612e-06, -3.072267676555155e-07,  7.073113304388560e-08, -1.567197583576437e-08,
  3.383017470073237e-09, -7.156062091815758e-10,  1.434670159243948e-10,  2.001120741158358e+00, -6.298676837538768e-04,  7.622561917777226e-05, -6.869926909111244e-06,
 -3.190901969798903e-08,  2.416139416875342e-07, -8.753783083166638e-08,  2.401813789509546e-08, -5.879482116690658e-09,  1.352632869046570e-09, -2.988572917599268e-10,
  6.172397156625274e-11,  2.001434789577595e+00, -8.307669787164351e-04,  1.309297703757333e-04, -2.020062350418560e-05,  3.024463566235513e-06, -4.327989507924597e-07,
  5.744708630460370e-08, -6.573061091382652e-09,  4.859371563123620e-10,  4.217853275084634e-11, -3.169198901243720e-11,  9.635047812972439e-12,  2.001638183504686e+00,
 -9.607029004303160e-04,  1.660965580484421e-04, -2.871954399772215e-05,  4.966404454597695e-06, -8.589278177094812e-07,  1.485675074489241e-07, -2.570077859823594e-08,
  4.446584323996226e-09, -7.694084136750372e-10,  1.330406318573740e-10, -2.235791012549525e-11,  2.001746865093929e+00, -1.030075941406573e-03,  1.848031954459703e-04,
 -3.323485447863989e-05,  5.992128174199099e-06, -1.083255778387187e-06,  1.963827222295255e-07, -3.570731028319885e-08,  6.512537248535537e-09, -1.191579635576682e-09,
  2.185087576347354e-10, -3.891887687087516e-11,  2.000234699457915e+00, -1.084493239572891e-04, -1.583855365629684e-05,  9.136085784085827e-06, -2.762491024597536e-06,
  6.962631648543840e-07, -1.607806836687155e-07,  3.526114647715307e-08, -7.474707067220735e-09,  1.546722151241444e-09, -3.139318811935692e-10,  6.057375616901701e-11,
  2.000451235598456e+00, -2.465333052661987e-04,  2.122160676577413e-05,  2.465451560144377e-07, -7.589809528553388e-07,  2.622768947584215e-07, -6.932175418021166e-08,
  1.637160626637115e-08, -3.633026131397947e-09,  7.749021580415690e-10, -1.605935483744026e-10,  3.142679985902384e-11,  2.000594889818238e+00, -3.379504657666787e-04,
  4.552591673416620e-05, -5.528262654536676e-06,  5.303061030230346e-07, -1.439232487671496e-08, -1.155623776214050e-08,  4.550594601402251e-09, -1.250818740233480e-09,
  3.006214113145446e-10, -6.720652328695857e-11,  1.382168129011563e-11,  2.000696370056001e+00, -4.024378574471398e-04,  6.255976258866780e-05, -9.549419488369330e-06,
  1.422311377937128e-06, -2.045919741641934e-07,  2.790569002386135e-08, -3.474615092889664e-09,  3.565141222313115e-10, -1.744667266419019e-11, -4.951309765901200e-12,
  2.149955809175691e-12,  2.000767460226860e+00, -4.475682099833117e-04,  7.442598278367357e-05, -1.233786139331085e-05,  2.038065282933947e-06, -3.352997929911253e-07,
  5.490467265485878e-08, -8.941364216557462e-09,  1.446722468163630e-09, -2.322707958049863e-10,  3.692176386543411e-11, -5.670537452649518e-12,  2.000813970925579e+00,
 -4.770745893321772e-04,  8.215982887124014e-05, -1.414956025378863e-05,  2.436894752086092e-06, -4.197022134505176e-07,  7.228640972378982e-08, -1.245039726285671e-08,
  2.144474472743618e-09, -3.693682634963803e-10,  6.356968009310982e-11, -1.063466908689383e-11,  2.000838976313533e+00, -4.929314236306185e-04,  8.630807522056444e-05,
 -1.511946142911379e-05,  2.650008115031188e-06, -4.647187229677783e-07,  8.154012322079720e-08, -1.431518478358777e-08,  2.514622545195507e-09, -4.419705515083543e-10,
  7.765763696078756e-11, -1.325497650811268e-11,  2.000269915752339e+00, -1.517121071196316e-04,  1.848410674619773e-05, -1.822017891065526e-06,  7.136994950201423e-08,
  3.087318705715903e-08, -1.300202835671532e-08,  3.607332902412729e-09, -8.647896143309866e-10,  1.922696393517633e-10, -4.076439584471560e-11,  8.069853607372517e-12,
  2.000319913994504e+00, -1.834133472866099e-04,  2.677142813594002e-05, -3.757684474584352e-06,  4.961085798119062e-07, -5.869232811313469e-08,  5.371369566274542e-09,
 -8.627452671723925e-11, -1.336747505085120e-10,  4.931844567387482e-11, -1.312314980701752e-11,  2.947206128941754e-12,  2.000353588335272e+00, -2.047428463978418e-04,
  3.232122460764187e-05, -5.047831491873483e-06,  7.778665378468319e-07, -1.178274308827456e-07,  1.744534519542048e-08, -2.502152329359964e-09,  3.422967305090397e-10,
 -4.331390157338552e-11,  4.705953057103008e-12, -3.428267014481899e-13,  2.000377623438039e+00, -2.199561603517539e-04,  3.626676676547303e-05, -5.962046495808833e-06,
  9.768727624765412e-07, -1.594589223152283e-07,  2.591799359273213e-08, -4.191982017523331e-09,  6.741569525604036e-10, -1.076939075106757e-10,  1.705819369870142e-11,
 -2.615511822050924e-12,  2.000394584029580e+00, -2.306862403228346e-04,  3.904314687490626e-05, -6.603861133433782e-06,  1.116258756692879e-06, -1.885506798806571e-07,
  3.182500687858096e-08, -5.367415962363666e-09,  9.044724065752000e-10, -1.522736908615858e-10,  2.559238676841938e-11, -4.182455556075366e-12,  2.000405735891548e+00,
 -2.377390351120614e-04,  4.086513448841778e-05, -7.024376573286222e-06,  1.207438675991027e-06, -2.075510099764701e-07,  3.567690059476066e-08, -6.132702594095643e-09,
  1.054190102577850e-09, -1.812082627545946e-10,  3.112306514995437e-11, -5.196489927847311e-12,  2.000411749643379e+00, -2.415415323566761e-04,  4.184649852127080e-05,
 -7.250654627876142e-06,  1.256454555333175e-06, -2.177551892995632e-07,  3.774358049055254e-08, -6.542914148067566e-09,  1.134366166659899e-09, -1.966885732597522e-10,
  3.407928647149391e-11, -5.738036230000593e-12,  2.000169646368112e+00, -9.787239903611061e-05,  1.502462034729285e-05, -2.268178774270370e-06,  3.349217804235523e-07,
 -4.796414572827045e-08,  6.565666415860311e-09, -8.351384803843578e-10,  9.226762549831343e-11, -6.898157869029993e-12, -3.748757332036920e-13,  3.126157793943345e-13,
  2.000181671372940e+00, -1.054758162777144e-04,  1.698692106172424e-05, -2.720602666446635e-06,  4.329103958252688e-07, -6.835892983080281e-08,  1.069502019495272e-08,
 -1.654451191391115e-09,  2.523281038510841e-10, -3.778553112591302e-11,  5.519879117991746e-12, -7.665264304134400e-13,  2.000189829771215e+00, -1.106317978189008e-04,
  1.831447011244185e-05, -3.025957485887435e-06,  4.988895912662101e-07, -8.205899597881193e-08,  1.346233597586839e-08, -2.202224379431925e-09,  3.590887713188538e-10,
 -5.833905355217673e-11,  9.433290793470559e-12, -1.481383252611758e-12,  2.000195682346842e+00, -1.143292511687232e-04,  1.926493089756832e-05, -3.244218103718552e-06,
  5.459725306076130e-07, -9.181935066948397e-08,  1.543062606647459e-08, -2.591197861249728e-09,  4.347757058029298e-10, -7.288654630826636e-11,  1.219866888597831e-11,
 -1.985767032267531e-12,  2.000199827151466e+00, -1.169471454870208e-04,  1.993709904254950e-05, -3.398391642521343e-06,  5.791916594167689e-07, -9.869764879313203e-08,
  1.681609308841251e-08, -2.864674334764286e-09,  4.879271557196108e-10, -8.309072604058602e-11,  1.413617850548700e-11, -2.338773535615579e-12,  2.000202559164799e+00,
 -1.186724144754456e-04,  2.037972252870875e-05, -3.499833180819183e-06,  6.010311958925820e-07, -1.032160606794440e-07,  1.772548570442078e-08, -3.044034722711546e-09,
  5.227588043942267e-10, -8.977248057341657e-11,  1.540386654429571e-11, -2.569570426575603e-12,  2.000204034654586e+00, -1.196040904562610e-04,  2.061862980290835e-05,
 -3.554559491699135e-06,  6.128075015174412e-07, -1.056512744412647e-07,  1.821536470497901e-08, -3.140606598592420e-09,  5.415038094279605e-10, -9.336658084385828e-11,
  1.608542300506862e-11, -2.693599363239327e-12,  2.000093100167532e+00, -5.417216413358455e-05,  8.866604397858595e-06, -1.447090891546390e-06,  2.354218657364960e-07,
 -3.816265793635293e-08,  6.161204812004610e-09, -9.900993041193281e-10,  1.582602897465185e-10, -2.513962536347162e-11,  3.962155347837906e-12, -6.050563592801887e-13,
  2.000096049523469e+00, -5.603452141665369e-05,  9.344199747070246e-06, -1.556500298008468e-06,  2.589663084768116e-07, -4.303154448240022e-08,  7.140664647706128e-09,
 -1.183182981035826e-09,  1.957376732722650e-10, -3.232508163938167e-11,  5.324660804418286e-12, -8.529847633053227e-13,  2.000098057736842e+00, -5.730228367604825e-05,
  9.668933153156168e-06, -1.630803753523828e-06,  2.749371824463109e-07, -4.633033941665776e-08,  7.803487725535071e-09, -1.313692451720875e-09,  2.210394776538664e-10,
 -3.717040556999466e-11,  6.242349916438767e-12, -1.019788180760972e-12,  2.000099501973285e+00, -5.821385601924821e-05,  9.902239318102376e-06, -1.684143517529185e-06,
  2.863926445646567e-07, -4.869452106839255e-08,  8.278128221739788e-09, -1.407071845714174e-09,  2.391279825843017e-10, -4.063152498768486e-11,  6.897338694853196e-12,
 -1.138750758792960e-12,  2.000100526612770e+00, -5.886050738503273e-05,  1.006764556100404e-05, -1.721937375988478e-06,  2.945046188433247e-07, -5.036768489329732e-08,
  8.613839685798249e-09, -1.473079818067498e-09,  2.519068462646479e-10, -4.307524097940780e-11,  7.359521741892571e-12, -1.222648972657844e-12,  2.000101202826146e+00,
 -5.928723018605932e-05,  1.017675263424330e-05, -1.746857266733591e-06,  2.998511848640993e-07, -5.147001135237155e-08,  8.834925774988550e-09, -1.516532369123554e-09,
  2.603156646178541e-10, -4.468261736161168e-11,  7.663404446846356e-12, -1.277790776118719e-12,  2.000101568306422e+00, -5.951785358151463e-05,  1.023570529690414e-05,
 -1.760318621517239e-06,  3.027386013847933e-07, -5.206517523379219e-08,  8.954264019736218e-09, -1.539981432902264e-09,  2.648523361606752e-10, -4.554960371469522e-11,
  7.827272236995082e-12, -1.307518958051525e-12,  2.000048572021720e+00, -2.836305467424020e-05,  4.761070316414467e-06, -7.987164805951307e-07,  1.339071109139648e-07,
 -2.243484129529739e-08,  3.756081205452568e-09, -6.283801819402707e-10,  1.050429132974921e-10, -1.754442578504422e-11,  2.925573971060728e-12, -4.745997031455310e-13,
  2.000049302393844e+00, -2.882393572565923e-05,  4.878888851719121e-06, -8.256208863301897e-07,  1.396783250772198e-07, -2.362448185298782e-08,  3.994630668003941e-09,
 -6.752552580497174e-10,  1.141121247648202e-10, -1.927766364097880e-11,  3.253179458311238e-12, -5.340337280735217e-13,  2.000049800592264e+00, -2.913827110183294e-05,
  4.959197860073734e-06, -8.439490043811544e-07,  1.436075291310251e-07, -2.443394240252036e-08,  4.156849299476049e-09, -7.071123835330176e-10,  1.202720642784029e-10,
 -2.045420583455816e-11,  3.475430652457055e-12, -5.743321242511242e-13,  2.000050159325125e+00, -2.936459195977598e-05,  5.016996616737436e-06, -8.571344060049753e-07,
  1.464330643485168e-07, -2.501579400364135e-08,  4.273406093265397e-09, -7.299927904924547e-10,  1.246944226902679e-10, -2.129852262069228e-11,  3.634858172076957e-12,
 -6.032282383956259e-13,  2.000050414061246e+00, -2.952529241446672e-05,  5.058024980924726e-06, -8.664912863532315e-07,  1.484375826442902e-07, -2.542845455626031e-08,
  4.356045974098172e-09, -7.462104136535599e-10,  1.278280605264716e-10, -2.189661982853754e-11,  3.747760199384063e-12, -6.236859962463461e-13,  2.000050582278135e+00,
 -2.963140763088617e-05,  5.085111756176818e-06, -8.726674091032673e-07,  1.497604196142624e-07, -2.570072506519118e-08,  4.410560049053112e-09, -7.569063175906829e-10,
  1.298943465842102e-10, -2.229091806402297e-11,  3.822176254336075e-12, -6.371675616671532e-13,  2.000050673230285e+00, -2.968878091317254e-05,  5.099754947544504e-06,
 -8.760058236540093e-07,  1.504753708305820e-07, -2.584786019091097e-08,  4.440015797861948e-09, -7.626849434971131e-10,  1.310105496683713e-10, -2.250389046788727e-11,
  3.862365618305327e-12, -6.444476089815829e-13,  2.000024785706563e+00, -1.449685751000878e-05,  2.461162841667517e-06, -4.177782599021478e-07,  7.090695839391584e-08,
 -1.203283272454826e-08,  2.041650123205459e-09, -3.463598337804887e-10,  5.874954533500519e-11, -9.963251056210131e-12,  1.688055963064982e-12, -2.781930721431172e-13,
  2.000024967437609e+00, -1.461149558536677e-05,  2.490422506061257e-06, -4.244492250724918e-07,  7.233565326143536e-08, -1.232686417445084e-08,  2.100515704083993e-09,
 -3.579084367773486e-10,  6.098034788632520e-11, -1.038890220606759e-11,  1.768381501081512e-12, -2.927438958609341e-13,  2.000025091509539e+00, -1.468975677903762e-05,
  2.510391679626773e-06, -4.290006916730140e-07,  7.331013481927858e-08, -1.252735714520546e-08,  2.140642816472518e-09, -3.657784774078228e-10,  6.250012421119757e-11,
 -1.067879898566891e-11,  1.823072368642064e-12, -3.026482998624127e-13,  2.000025180904255e+00, -1.474614209855580e-05,  2.524776058515279e-06, -4.322785710762589e-07,
  7.401179283972503e-08, -1.267168864549195e-08,  2.169523662677869e-09, -3.714416392647068e-10,  6.359350554442830e-11, -1.088731785941963e-11,  1.862402661704018e-12,
 -3.097695575021807e-13,  2.000025244411633e+00, -1.478619785752374e-05,  2.534993133749419e-06, -4.346064714891487e-07,  7.451002600636262e-08, -1.277416032987998e-08,
  2.190025284602214e-09, -3.754611465036556e-10,  6.436943282923095e-11, -1.103527307638706e-11,  1.890305470417856e-12, -3.148210215908719e-13,  2.000025286362053e+00,
 -1.481265651702600e-05,  2.541741298887552e-06, -4.361438447641936e-07,  7.483903155608591e-08, -1.284182002738334e-08,  2.203560648955820e-09, -3.781145914727801e-10,
  6.488160246757261e-11, -1.113292451324478e-11,  1.908719635048167e-12, -3.181543636144592e-13,  2.000025309048225e+00, -1.482696478549416e-05,  2.545390334656402e-06,
 -4.369751196601176e-07,  7.501691739806311e-08, -1.287839979905018e-08,  2.210877995910355e-09, -3.795489791052775e-10,  6.515845150978149e-11, -1.118570587497645e-11,
  1.918672012808324e-12, -3.199558429271165e-13,  2.000012517061236e+00, -7.326777634277683e-06,  1.250576260673693e-06, -2.134482812137165e-07,  3.643009328172141e-08,
 -6.217458116220106e-09,  1.061085153410939e-09, -1.810807154540704e-10,  3.090140945963845e-11, -5.273008894357884e-12,  8.990330483189639e-13, -1.490636088365462e-13,
  2.000012562386798e+00, -7.355364771887952e-06,  1.257866964050710e-06, -2.151091832497201e-07,  3.678551899022844e-08, -6.290547872436591e-09,  1.075706156452451e-09,
 -1.839468591220126e-10,  3.145460955970054e-11, -5.378478544154391e-12,  9.189205994189872e-13, -1.526635111033902e-13,  2.000012593345331e+00, -7.374889924523125e-06,
  1.262845822650156e-06, -2.162432545349202e-07,  3.702816932728498e-08, -6.340439098536138e-09,  1.085685003530675e-09, -1.859027141161593e-10,  3.183205694601023e-11,
 -5.450429596804174e-12,  9.324858149855554e-13, -1.551186487150010e-13,  2.000012615658089e+00, -7.388961993651128e-06,  1.266433794555356e-06, -2.170604291747409e-07,
  3.720299714528791e-08, -6.376381645108980e-09,  1.092873201314690e-09, -1.873114554672616e-10,  3.210389232325267e-11, -5.502242944361620e-12,  9.422533805229592e-13,
 -1.568862869963075e-13,  2.000012631512933e+00, -7.398961072474942e-06,  1.268983085109760e-06, -2.176409972408440e-07,  3.732719572764044e-08, -6.401913520974461e-09,
  1.097978975998241e-09, -1.883120096683786e-10,  3.229694821207898e-11, -5.539037744821402e-12,  9.491892193366509e-13, -1.581413800136097e-13,  2.000012641987610e+00,
 -7.405567002759189e-06,  1.270667198937174e-06, -2.180245129394015e-07,  3.740923550120718e-08, -6.418777820643718e-09,  1.101351266528276e-09, -1.889728274129180e-10,
  3.242444576901405e-11, -5.563336442432170e-12,  9.537693025085061e-13, -1.589701413728743e-13,  2.000012647652693e+00, -7.409139704997940e-06,  1.271577994401617e-06,
 -2.182319178401178e-07,  3.745360113808991e-08, -6.427897445056780e-09,  1.103174826229533e-09, -1.893301521262727e-10,  3.249338549796371e-11, -5.576474678379714e-12,
  9.562456628196171e-13, -1.594182230853470e-13,  2.000006289493582e+00, -3.682915916289835e-06,  6.302667166461340e-07, -1.078582422092336e-07,  1.845774651332131e-08,
 -3.158641737513764e-09,  5.405282463263791e-10, -9.249808028574067e-11,  1.582861927287215e-11, -2.708565483398739e-12,  4.631064845654162e-13, -7.699211051683496e-14,
  2.000006300811607e+00, -3.690053677414956e-06,  6.320863757401942e-07, -1.082726160855211e-07,  1.854638540485445e-08, -3.176862175225564e-09,  5.441716399365347e-10,
 -9.321200661421422e-11,  1.596636055905473e-11, -2.734815876602881e-12,  4.680543370322071e-13, -7.788740105708291e-14,  2.000006308543825e+00, -3.694929958887619e-06,
  6.333294157030198e-07, -1.085556610383762e-07,  1.860692719037153e-08, -3.189306103907084e-09,  5.466597670472964e-10, -9.369952119748680e-11,  1.606041213476037e-11,
 -2.752738661070336e-12,  4.714322952162800e-13, -7.849858421373644e-14,  2.000006314117533e+00, -3.698444949865487e-06,  6.342253958735808e-07, -1.087596686456027e-07,
  1.865056105943479e-08, -3.198274267476451e-09,  5.484528321356501e-10, -9.405082962848267e-11,  1.612818322896223e-11, -2.765652678364590e-12,  4.738661109963795e-13,
 -7.893891977110934e-14,  2.000006318078499e+00, -3.700942865590677e-06,  6.348620977049731e-07, -1.089046352745309e-07,  1.868156588667821e-08, -3.204646520256589e-09,
  5.497268320396193e-10, -9.430043031097229e-11,  1.617633203730017e-11, -2.774827259758978e-12,  4.755951170427491e-13, -7.925172750330339e-14,  2.000006320695555e+00,
 -3.702593258420658e-06,  6.352827610767171e-07, -1.090004110296292e-07,  1.870204946197295e-08, -3.208856289811198e-09,  5.505684666598665e-10, -9.446531822615088e-11,
  1.620813865281928e-11, -2.780887739888639e-12,  4.767372224534936e-13, -7.945834959279141e-14,  2.000006322111020e+00, -3.703485889405270e-06,  6.355102774296029e-07,
 -1.090522106678451e-07,  1.871312768492086e-08, -3.211133042430361e-09,  5.510236373512808e-10, -9.455449108644330e-11,  1.622533968463020e-11, -2.784165198688797e-12,
  4.773548541788462e-13, -7.957008576152155e-14,  2.000003152476433e+00, -1.846332238813980e-06,  3.163754979187988e-07, -5.421193855081569e-08,  9.289367351239085e-09,
 -1.591755794678581e-09,  2.727506791007946e-10, -4.673630021079722e-11,  8.008323494549074e-12, -1.372200653606438e-12,  2.349307364533954e-13, -3.910723392606747e-14,
  2.000003155304271e+00, -1.848115552704842e-06,  3.168300362115632e-07, -5.431542576969615e-08,  9.311499942264908e-09, -1.596304420234698e-09,  2.736600495178469e-10,
 -4.691445660723551e-11,  8.042689211571126e-12, -1.378748678706609e-12,  2.361647071885325e-13, -3.933047344099423e-14,  2.000003157236399e+00, -1.849333997956484e-06,
  3.171405871569233e-07, -5.438612799604616e-08,  9.326620317307485e-09, -1.599411800406979e-09,  2.742812601865608e-10, -4.703615458812046e-11,  8.066163434522618e-12,
 -1.383221278215448e-12,  2.370075342323404e-13, -3.948294526494941e-14,  2.000003158629267e+00, -1.850212367805110e-06,  3.173644557575565e-07, -5.443709419413512e-08,
  9.337519664491239e-09, -1.601651661397547e-09,  2.747290294944029e-10, -4.712387234577845e-11,  8.083082801136149e-12, -1.386444881682800e-12,  2.376149818554545e-13,
 -3.959283305490779e-14,  2.000003159619166e+00, -1.850836615215402e-06,  3.175235537064119e-07, -5.447331395857415e-08,  9.345265278059417e-09, -1.603243387526337e-09,
  2.750472246269675e-10, -4.718620543583960e-11,  8.095105643655325e-12, -1.388735520379863e-12,  2.380466159779206e-13, -3.967091467672504e-14,  2.000003160273228e+00,
 -1.851249077335131e-06,  3.176286739665035e-07, -5.449724501878711e-08,  9.350382881079715e-09, -1.604295043159385e-09,  2.752574538918818e-10, -4.722738793760757e-11,
  8.103048846516722e-12, -1.390248870846948e-12,  2.383317789555928e-13, -3.972249938627005e-14,  2.000003160626994e+00, -1.851472167073915e-06,  3.176855302668427e-07,
 -5.451018848875194e-08,  9.353150791128223e-09, -1.604863837833898e-09,  2.753711568406878e-10, -4.724966140685602e-11,  8.107344877238287e-12, -1.391067350377375e-12,
  2.384860051155383e-13, -3.975039800501237e-14,   0.00160552325423418,   0.00165428367825506,  0.000576773588328838,  8.08438320497913e-05,   4.2046777963674e-06,
  6.20400511227248e-08,  1.23747425268827e-10,  0.000801056288836203,  0.000825506827318113,  0.000287896559917101,  4.03705267215358e-05,  2.10097745364558e-06,
  3.10280993371412e-08,  6.19781020777073e-11,  0.000400121196853484,  0.000412347946412014,  0.000143815897266702,  2.01686365240437e-05,   1.0497675611685e-06,
  1.55064202833174e-08,  3.09829424356359e-11,  0.000199961011169328,  0.000206073006795757,  7.18738108478237e-05,  1.00797605578103e-05,  5.24663515244345e-07,
  7.75030796509234e-09,  1.54867168129945e-11,  9.99558629583811e-05,  0.000103011311239981,   3.5928250510638e-05,  5.03869449315328e-06,  2.62272094876853e-07,
  3.87431506570751e-09,   7.7418071127317e-12,  4.99718017556602e-05,  5.14993637243632e-05,  1.79619470340748e-05,  2.51904522241036e-06,   1.3112058025293e-07,
  1.93693426139678e-09,  3.87047270746981e-12,  2.49843722629559e-05,  2.57481096539928e-05,  8.98042718411183e-06,  1.25944642100882e-06,  6.55563557772147e-08,
  9.68409657761815e-10,  1.93512340115314e-12,  1.24918044516537e-05,  1.28736618705235e-05,  4.49007678870775e-06,  6.29704078236867e-07,  3.27771859420352e-08,
  4.84190256070923e-10,  9.67532815803081e-13,  6.24580686491513e-06,   6.4367327080816e-06,  2.24500416613133e-06,  3.14847245511324e-07,  1.63883439447187e-08,
  2.42091459403763e-10,  4.83759106399681e-13,  3.12287959959821e-06,  3.21834179873747e-06,  1.12249352259487e-06,  1.57422423039441e-07,  8.19410958615432e-09,
  1.21044809374184e-10,   2.4187771781813e-13,  1.56143384250459e-06,  1.60916476072933e-06,  5.61244620753341e-07,  7.87109114265523e-08,  4.09703918034247e-09,
  6.05221742094995e-11,   1.2093839881487e-13  };
  int offset = -7;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 7;
    if (std::isnan(t)) {
      fill_n(rr+offset, 7, 0.5);
      fill_n(ww+offset, 7, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 7; ++r) {
        ww[offset+r] = aw[7-r-1] / t;
        rr[offset+r] = 1.0 - ax[7-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=7; ++j) {
        const int boxof = it*84+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 3612 + (it - 32) * 7 + 7 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
