#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is a part of Androguard.
#
# This file is generated automatically from the data
# provided by PScout tool [http://pscout.csl.toronto.edu/]
# using script: extract_api_permission_mappings.py
#
# Author: Yury Zhauniarovich
#
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License"

#################################################
### API version: 9 
#################################################


AOSP_PERMISSIONS_BY_METHODS = {
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handlePinMmi-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ui/EditContactActivity$QueryEntitiesTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/LaunchActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-doDoubleTap-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/os/INetworkManagementService$Stub;-startAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/LockPatternView;-addCellToPattern-(Lcom/android/internal/widget/LockPatternView$Cell;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/view/IWindowManager$Stub$Proxy;-prepareAppTransition-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/contacts/ContactsListActivity;-onResume-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/AddAccountSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/GoogleCalendarUriIntentFilter;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/soundrecorder/Recorder;-delete-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/IP2pTarget$Stub;-getMode-(I)I' : ['android.permission.NFC'],
	'Lcom/android/term/TermPreferences;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-loadDataWithBaseURL-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/EnableFdnScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-moveQueueItem-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Landroid/nfc/IP2pInitiator$Stub$Proxy;-getGeneralBytes-(I)[B' : ['android.permission.NFC'],
	'Landroid/view/IWindowSession;-addWithoutInputChannel-(Landroid/view/IWindow; Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/phone/sip/SipEditor;-saveAndRegisterProfile-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/phone/CdmaCallOptions;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/LatinKeyboardBaseView$2;-onText-(Ljava/lang/CharSequence;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/webkit/PluginFullScreenHolder;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManagerService;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/GroupMessagingListener;-loadAttachmentStarted-(J J J Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/LatinKeyboardBaseView$OnKeyboardActionListener;-onText-(Ljava/lang/CharSequence;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/providers/applications/ApplicationLauncher;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/IEmailService;-loadAttachment-(J Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/SettingsActivity;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity$21;-onResizeResult-(Lcom/google/android/mms/pdu/PduPart; Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/accounts/IAccountManager$Stub;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/CdmaVoicePrivacyCheckBoxPreference$MyHandler;-handleSetVPResponse-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/DayView;-<init>-(Lcom/android/calendar/CalendarActivity;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/webkit/WebView;-setNetworkType-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-getName-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/Details;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub;-notifyDataConnectionFailed-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/WarnOfStorageLimitsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WifiService;-reconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/Layer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothProfileState$StableState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/MessagingController$2;-run-()V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelBondProcess-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getHelpUri-()Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/BluetoothA2dpService;-onSinkPropertyChanged-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/vpn/VpnService$NotificationHelper;-enableNotification-(Landroid/app/Notification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/systemui/usb/UsbStorageActivity$8;-run-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/content/ContentService;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-access$1400-(Lcom/android/internal/policy/impl/KeyguardViewMediator; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/NotificationPlayer;-play-(Landroid/content/Context; Landroid/net/Uri; Z I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableUsbRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/PhoneUtils;-handleHeadsetHook-(Lcom/android/internal/telephony/Phone; Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ui/EditContactActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/calendar/CalendarAppWidgetService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/telephony/TelephonyManager;-getDeviceSoftwareVersion-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/InCallScreen;-onStop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-onStart-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-reRegisterNetwork-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneApp;-updatePhoneState-(Lcom/android/internal/telephony/Phone$State;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-doFling-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/AlertActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-handleConnectionOfOtherProfiles-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/vpn/L2tpIpsecPskService;-onDisconnect-()V' : ['android.permission.VIBRATE'],
	'Landroid/app/Service;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-getInterfaceRxCounter-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IThrottleManager;-getThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-onDestroy-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothNamePreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/CandidateView;-longPressFirstWord-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/server/ThrottleService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/cooliris/media/UriTexture;-load-(Lcom/cooliris/media/RenderView;)Landroid/graphics/Bitmap;' : ['android.permission.INTERNET'],
	'Lcom/android/server/WifiService;-setWifiApEnabledBlocking-(Z I Landroid/net/wifi/WifiConfiguration;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/SearchResultsActivity;-doFilter-(Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/certinstaller/CertInstaller;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/certinstaller/CertFile;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-onStop-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebView;-cancelWebCoreTouchEvent-(I I Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/CallCard;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/IContentService$Stub$Proxy;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/cooliris/media/Gallery;-updatePicasaAccountStatus-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/SearchResultsActivity;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/FrameLoader;-handleHTTPLoad-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MailboxList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ComposeMessageActivity$RecipientsMenuClickListener;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/webkit/LoadListener;-status-(I I I Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ConversationList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/Phone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-setScanMode-(I I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/SearchResultsActivity;-onStart-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/nfc/P2pDevice;-getGeneralBytes-()[B' : ['android.permission.NFC'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getNumAllowedChannels-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/util/AccountSelectionUtil;-getSelectAccountDialog-(Landroid/content/Context; I Landroid/content/DialogInterface$OnClickListener; Landroid/content/DialogInterface$OnCancelListener;)Landroid/app/Dialog;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/BrowserActivity$3;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/LanguageSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-gotoIdleAndNotifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/DevelopmentSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.SET_DEBUG_APP'],
	'Lcom/android/development/PackageBrowser;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/ChooseLockPassword;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideshowActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-addRfcommServiceRecord-(Ljava/lang/String; Landroid/os/ParcelUuid; I Landroid/os/IBinder;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-access$000-(Lcom/android/contacts/ContactsListActivity; Z)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/DataList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/NdefTagConnection;-close-()V' : ['android.permission.NFC'],
	'Lcom/android/browser/BrowserActivity;-access$700-(Lcom/android/browser/BrowserActivity; Ljava/lang/String;)Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/ConfirmRateLimitActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager;-requestLocationUpdates-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/location/ILocationListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/app/PlatLogoActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Telephony$Sms$Sent;-addMessage-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$3100-(Lcom/android/mms/ui/ComposeMessageActivity; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/ZoneList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/fuelgauge/BatteryHistoryDetail;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/PhysicalKeyboardSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/DateTimeSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/util/DraftCache;-access$000-(Lcom/android/mms/util/DraftCache;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/InCallScreen;-updateManageConferencePanelIfNecessary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/PackageSummary;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/RunningProcesses;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-disconnectInt-(Lcom/android/settings/bluetooth/CachedBluetoothDevice; Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$Profile;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/tts/TtsService$1;-playEarcon-(Ljava/lang/String; Ljava/lang/String; I [Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/AlertActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ISms$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/VibratorService;-startVibrationLocked-(Lcom/android/server/VibratorService$Vibration;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebTextView;-onSelectionChanged-(I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/SlideshowPresenter;-presentSlide-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/SlideModel;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneApp;-updateInCallScreenTouchUi-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/commands/bmgr/Bmgr;-doListRestoreSets-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/StatusBarService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/RestoreSession;-restorePackage-(Ljava/lang/String; Landroid/app/backup/RestoreObserver;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/BluetoothHandsfree$14;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/ui/EditContactActivity$AddContactTask;-onPostExecute-(Lcom/android/contacts/ui/EditContactActivity; Ljava/util/ArrayList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/BrowserActivity;-closeTab-(Lcom/android/browser/Tab;)V' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/stk/RilMessageDecoder$StateStart;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/wifi/WifiApSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/pinyin/SettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ComposeMessageActivity$PduBodyCache;-getPduBody-(Landroid/content/Context; Landroid/net/Uri;)Lcom/google/android/mms/pdu/PduBody;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-callSelection-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Landroid/service/wallpaper/WallpaperService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WifiWatchdogService$WifiWatchdogHandler;-backgroundCheckAp-(Lcom/android/server/WifiWatchdogService$AccessPoint;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupConnection-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/http/Connection;-openConnection-(Landroid/net/http/Request;)Landroid/net/http/AndroidHttpClientConnection;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/AudioPreview;-playPauseClicked-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-sendMoveMouseIfLatest-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/Camera;-initializeFirstTime-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelBondProcess-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-stopUsbRNDIS-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/mms/transaction/PushReceiver;-access$000-(Landroid/content/Context; Lcom/google/android/mms/pdu/GenericPdu; I)J' : ['android.permission.READ_SMS'],
	'Lcom/android/development/DevelopmentSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Tab$2;-onPageFinished-(Landroid/webkit/WebView; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactPhotoLoader$LoaderThread;-loadPhotosFromDatabase-()V' : ['android.permission.READ_CONTACTS'],
	'Landroid/app/NativeActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/utility/CalendarUtilities;-createMessageForEventId-(Landroid/content/Context; J I Ljava/lang/String; Lcom/android/email/provider/EmailContent$Account; Ljava/lang/String;)Lcom/android/email/provider/EmailContent$Message;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-readPairedDevices-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ConversationList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity$BluetoothTransferContentObserver;-onChange-(Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/Controller$LegacyListener;-loadAttachmentStarted-(J J J Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsListActivity;-deleteSelection-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityManagerService;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/AlertActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/SetAlarm;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/commands/bmgr/Bmgr;-doWipe-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$3;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Landroid/content/ContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/camera/VideoCamera;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/WeekSelector;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub;-getDnsForwarders-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/contacts/LegacyContactImporter;-updateDisplayNamesAndLookupKeys-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/SetAlarm;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-wakeWhenReadyTq-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/IThrottleManager$Stub;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/sip/SipEditor;-access$400-(Lcom/android/phone/sip/SipEditor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/os/INetworkManagementService;-tetherInterface-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/pim/vcard/VCardComposer;-init-(Ljava/lang/String; [Ljava/lang/String;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/ISms$Stub;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/NfcService$8;-getGeneralBytes-(I)[B' : ['android.permission.NFC'],
	'Lcom/android/server/WindowManagerService$InputMonitor;-notifyLidSwitchChanged-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/am/ActivityStack;-activityIdleInternal-(Landroid/os/IBinder; Z Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/deskclock/SettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager$Stub;-requestLocationUpdates-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/location/ILocationListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/phone/SipCallOptionHandler;-createSipPhoneIfNeeded-(Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/Phone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag;-getType-(I)Ljava/lang/String;' : ['android.permission.NFC'],
	'Landroid/speech/SpeechRecognizer;-handleCancelMessage-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference;-onClick-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/media/MediaScannerService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/LogViewer;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/LoadListener;-makeAuthResponse-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DockService;-createDialog-(Lcom/android/settings/bluetooth/DockService; Landroid/bluetooth/BluetoothDevice; I I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/app/NetInitiatedActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/RadioInfo$17;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab;-restoreState-(Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/AgendaWindowAdapter;-getEventByPosition-(I)Lcom/android/calendar/AgendaWindowAdapter$EventInfo;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/PackageManagerService;-installNewPackageLI-(Landroid/content/pm/PackageParser$Package; I I Ljava/lang/String; Lcom/android/server/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/WifiService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_MULTICAST_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/InCallScreen;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/sip/SipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/preference/VolumePreference;-cleanup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/wifi/WifiSettings;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/stk/CommandParamsFactory;-make-(Lcom/android/internal/telephony/gsm/stk/BerTlv;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/ViewContactActivity$2;-onPostExecute-(Ljava/util/ArrayList;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/content/SyncManager;-sendSyncFinishedOrCanceledMessage-(Landroid/content/SyncManager$ActiveSyncContext; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/settings/AppWidgetPickActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-pokeWakelock-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/browser/BrowserActivity$SetAsWallpaper;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.SET_WALLPAPER', 'android.permission.INTERNET'],
	'Lcom/android/phone/InCallScreen;-access$900-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothService;-addProfileState-(Ljava/lang/String;)Landroid/bluetooth/BluetoothDeviceProfileState;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/speech/RecognitionService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/RadioInfo$18;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Service;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-createAllDataConnectionList-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/setup/AccountSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/ChooseAccountActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/commands/svc/PowerCommand;-run-([Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/speech/IRecognitionService$Stub$Proxy;-startListening-(Landroid/content/Intent; Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$000-(Lcom/android/mms/transaction/SmsReceiverService; Landroid/content/Intent; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/PicasaDataSource;-loadMediaSetsIntoFeed-(Lcom/cooliris/media/MediaFeed; Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-setLocationUpdates-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService$AppDeathRecipient;-binderDied-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/ConnectivityService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/cooliris/media/BackgroundLayer;-renderOpaque-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Landroid/server/BluetoothA2dpService;-access$100-(Landroid/server/BluetoothA2dpService;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/service/wallpaper/ImageWallpaper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/ChooserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addGpsStatusListener-(Landroid/location/IGpsStatusListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calculator2/Calculator;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/INfcTag$Stub;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/app/ExternalMediaFormatActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/TestBrowserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothEventLoop;-onDeviceCreated-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/PhoneBase;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/provision/DefaultActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/Settings$Secure;-putFloat-(Landroid/content/ContentResolver; Ljava/lang/String; F)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/AccountPreferenceBase;-onAuthDescriptionsUpdated-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/media/MediaRecorder;-setVideoSource-(I)V' : ['android.permission.CAMERA'],
	'Lcom/android/settings/LocalePickerInSetupWizard;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/vpn/VpnServiceBinder;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-setNewZoomScale-(F Z Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/DeviceStorageMonitorService;-cancelNotification-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub;-detachPppd-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/AddAccountSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/providers/downloads/DownloadThread;-updateDatabaseFromHeaders-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/music/MediaPlaybackService$5;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/GetPin2Screen;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NetworkManagementService;-untetherInterface-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/applications/InstalledAppDetails;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/AudioAttachmentView;-onPlaybackError-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothPbap;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/ConnectivityManager;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/WifiService;-enforceMulticastChangePermission-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-disconnectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaScannerClient;-scanFile-(Ljava/lang/String; J J)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setSystemLocale-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/browser/TabControl;-createNewTab-(Z Ljava/lang/String; Ljava/lang/String;)Lcom/android/browser/Tab;' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupOptions;-access$000-(Lcom/android/email/activity/setup/AccountSetupOptions;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/IConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/cooliris/cache/CacheService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/RecentCallsListActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$HeadsetProfileManager;-getConnectedDevices-()Ljava/util/Set;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/quicksearchbox/SearchableItemsSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WifiService;-access$2200-(Lcom/android/server/WifiService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiStateTracker$DhcpHandler;-shouldDisableCoexistenceMode-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WifiWatchdogService$WifiWatchdogHandler;-checkAp-(Lcom/android/server/WifiWatchdogService$AccessPoint;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BrowserActivity$5;-handleMessage-(Landroid/os/Message;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/BackupManagerService$ActiveRestoreSession;-restorePackage-(Ljava/lang/String; Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$30;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/calendar/CalendarProvider2;-updateInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-connectWithoutResettingTimer-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/Tab;-createSubWindow-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/TrackBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/stk/StkService;-handleCmdResponse-(Lcom/android/internal/telephony/gsm/stk/StkResponseMessage;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-startRfcommSocketListener-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/TetherSettings;-updateState-([Ljava/lang/Object; [Ljava/lang/Object; [Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-broadcastIccStateChangedIntent-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ChooseLockGeneric;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-getCurrentHeadset-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/CombinedBookmarkHistoryActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/SyncManager$CalendarObserver$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/webkit/WebView;-zoomIn-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-requestLocationUpdatesPI-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/ILlcpServiceSocket$Stub$Proxy;-accept-(I)I' : ['android.permission.NFC'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAuthToken-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Z Landroid/os/Bundle;)V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/CdmaSubscriptionListPreference;-onDialogClosed-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$23;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/connectivity/Tethering;-access$700-(Lcom/android/server/connectivity/Tethering; Z)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/tts/TtsService;-synthesizeToFile-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/MessagingController;-loadMessageForView-(J Lcom/android/email/MessagingListener;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/PhoneApp$PhoneAppBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendMultipartTextWithPermit-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/vpn/L2tpIpsecPskService;-onConnect-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.VIBRATE'],
	'Lcom/cooliris/picasa/PicasaContentProvider;-syncAlbumPhotos-(Lcom/cooliris/picasa/PicasaContentProvider$SyncContext; Ljava/lang/String; Lcom/cooliris/picasa/AlbumEntry; Landroid/content/SyncResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.INTERNET', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/TetherSettings$TetherChangeReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleVoiceResults-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/location/LocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/bluetooth/BluetoothAdapter;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller;-updateMailboxList-(J Lcom/android/email/Controller$Result;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ui/ShowOrCreateActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/NfcService$6;-transceive-(I [B)[B' : ['android.permission.NFC'],
	'Lcom/android/browser/TitleBar;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/HTML5Audio;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-killApplicationWithUid-(Ljava/lang/String; I)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/StatusBarManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/webkit/WebTextView;-sendDomEvent-(Landroid/view/KeyEvent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Landroid/webkit/WebView;-requestLabel-(I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/SendTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-updateProgressState-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Landroid/speech/RecognitionService$RecognitionServiceBinder;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-deleteSmsOnSim-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserActivity;-removeTabFromContentView-(Lcom/android/browser/Tab;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getSinkState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothDevice;-createRfcommSocketToServiceRecord-(Ljava/util/UUID;)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/MessageList$FindMailboxTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-onAllRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity;-access$600-(Lcom/android/music/MediaPlaybackActivity;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Tab$3;-onExceededDatabaseQuota-(Ljava/lang/String; Ljava/lang/String; J J J Landroid/webkit/WebStorage$QuotaUpdater;)V' : ['android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/cooliris/media/Gallery;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiManager;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)Z' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/PlaylistBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-deactivateDefaultPDP-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/TetherSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-callSelection-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/speechrecorder/SpeechRecorderActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/ISipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/AdnRecordCache;-updateAdnByIndex-(I Lcom/android/internal/telephony/AdnRecord; I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TouchInterceptor$RemoveListener;-remove-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/PhotoAppWidgetBind;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IThrottleManager$Stub;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ui/QuickContactActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/ResolverActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/GetPin2Screen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/SimCard;-supplyPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-separateCall-(Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/IccRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/wifi/WifiApSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebView;-loadUrl-(Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserHistoryPage;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/server/BluetoothService;-removeBondInternal-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-updateWidget-(Landroid/content/Context;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/exchange/EasSyncService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I Z)Lorg/apache/http/HttpResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/PhotoAppWidgetConfigure;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/ConnectivityService;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/SyncAdapterDriver;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/CalendarView;-drawAfterScroll-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/Settings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/SettingsSafetyLegalActivity;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/voicedialer/RecognizerClient;-onMicrophoneStart-(Ljava/io/InputStream;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onToggle-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WifiService;-getWifiApConfiguration-()Landroid/net/wifi/WifiConfiguration;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-sendUSSD-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserActivity$18;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/ProcessInfo;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$SetDnsForwardersErrorState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/webkit/WebView;-scrollFocusedTextInput-(F I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothPbap;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/IPowerManager$Stub$Proxy;-acquireWakeLock-(I Landroid/os/IBinder; Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DropBoxManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_LOGS'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-fetchRuimRecords-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-addCallAndContactMenuItems-(Landroid/view/ContextMenu; Lcom/android/mms/ui/ComposeMessageActivity$MsgListMenuClickListener; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/browser/AddBookmarkPage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/CallNotifier;-onCfiChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-handleCallKey-()Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-open-([J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-createLlcpConnectionlessSocket-(I)I' : ['android.permission.NFC'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/HTML5Audio;-setDataSource-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/Context;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-getConnectedSinks-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-doFilter-(Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onSetDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-haveSomethingToCopyToSDCard-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-restartRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/music/AlbumBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MediaPlaybackActivity;-startPlayback-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/music/ScanningProgress;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothEventLoop;-onAgentAuthorize-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/Phone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneApp;-updateWakeState-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService;-createLlcpServiceSocket-(I Ljava/lang/String; I I I)Lcom/android/internal/nfc/LlcpServiceSocket;' : ['android.permission.NFC'],
	'Landroid/net/IThrottleManager$Stub;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/quicksearchbox/google/GoogleSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/SmsReceiverService;-handleSmsReceived-(Landroid/content/Intent; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SearchActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/RenderView;-draw2D-(Lcom/cooliris/media/Texture; F F)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/BluetoothHandsfree$21;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/speech/tts/ITts$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$26;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/TextToSpeechSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/AlertActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager$Stub;-getLastKnownLocation-(Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/LocalePicker;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-onActualStateChange-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/FetchUrlMimeType;-onPostExecute-(Ljava/lang/String;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/development/AppHwPref;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserActivity;-switchToTab-(I)Z' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/RadioInfo$19;-onItemSelected-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM;-access$1100-(Lcom/android/server/connectivity/Tethering$TetherInterfaceSM; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/FrameLoader;-handleCache-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/commands/monkey/Monkey;-run-([Ljava/lang/String;)I' : ['android.permission.SIGNAL_PERSISTENT_PROCESSES', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/providers/media/MediaScannerService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/DataLoader;-setupStreamAndSendStatus-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/BatteryStatsService;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager;-acquireMulticastLock-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/providers/telephony/SmsProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/wifi/WifiAPITest;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/IMediaPlaybackService;-removeTrack-(J)I' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/BrowserActivity$4;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/development/ConfigurationViewer;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/settings/SettingsHelper;-setGpsLocation-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/provider/Browser;-getVisitedHistory-(Landroid/content/ContentResolver;)[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/deskclock/AlarmAlert;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothAtPhonebook;-getPhonebookResult-(Ljava/lang/String; Z)Lcom/android/phone/BluetoothAtPhonebook$PhonebookResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/phone/Ringer;-stopRing-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/cache/CacheService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiManager$WifiLock;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/ILlcpSocket$Stub$Proxy;-receive-(I [B)I' : ['android.permission.NFC'],
	'Lcom/android/contacts/ContactsLiveFolders$PhoneContacts;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/ActivityPicker;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebSettings;-<init>-(Landroid/content/Context; Landroid/webkit/WebView;)V' : ['android.permission.INTERNET'],
	'Lcom/google/common/io/Resources;-toByteArray-(Ljava/net/URL;)[B' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-pollStateDone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/IAccountManager;-confirmCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/google/common/io/CharStreams;-toStringBuilder-(Lcom/google/common/io/InputSupplier;)Ljava/lang/StringBuilder;' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/ScoSocket;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapter$Stub;-getProperties-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.NFC'],
	'Lcom/android/systemui/statusbar/StatusBarService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/IBatteryStats$Stub;-getAwakeTimePlugged-()J' : ['android.permission.BATTERY_STATS'],
	'Lcom/android/internal/telephony/CommandsInterface;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/BadBehaviorActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/AccountShortcutPicker;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneUtils;-switchHoldingAndActive-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WifiService;-startWifi-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/LatinIME$8;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/server/BackupManagerService$RunBackupReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/HeadUpDisplay;-restorePreferences-(Landroid/hardware/Camera$Parameters;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/WebsiteSettingsActivity$SiteAdapter$2;-onReceiveValue-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/development/ShowActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ManageSimMessages;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupOutgoing;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/PlaylistBrowserActivity;-playPodcasts-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub;-enable-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/ChooseLockPattern;-saveChosenPatternAndFinish-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/ExchangeUtils;-enableEasCalendarSync-(Landroid/content/Context;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-smsContact-(Landroid/database/Cursor;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexClientSession$ClientThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-access$1500-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/media/CropImage$1;-onMediaScannerConnected-()V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/GsmUmtsAdditionalCallOptions;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothA2dp;-suspendSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/contacts/ContactsProvider2;-outputRawContactsAsVCard-(Ljava/io/OutputStream; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/music/CreatePlaylist;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/IVibratorService;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/MessageListAdapter$AvatarCache;-get-(Ljava/lang/String;)Lcom/android/mms/ui/MessageListAdapter$AvatarCache$ContactData;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/commands/bmgr/Bmgr;-doRestoreAll-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangup-(Lcom/android/internal/telephony/cdma/CdmaCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EmergencyCallbackModeExitDialog;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getBluetoothState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager;-releaseWifiLock-(Landroid/os/IBinder;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/IP2pTarget$Stub;-transceive-(I [B)[B' : ['android.permission.NFC'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/bluetooth/IBluetooth;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/SlideshowActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityManagerService;-serviceTimeout-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-listen-(Ljava/lang/String; Lcom/android/internal/telephony/IPhoneStateListener; I Z)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/TrackBrowserActivity$TrackListAdapter;-runQueryOnBackgroundThread-(Ljava/lang/CharSequence;)Landroid/database/Cursor;' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideViewInterface;-setAudio-(Landroid/net/Uri; Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/contacts/ContactsListActivity;-getUriToQuery-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/accounts/AccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-sendMessage-(J)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-ensurePaired-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/Settings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/LoadAverageService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-reportInetCondition-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-findActiveUpstreamIface-()Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/DemoThread;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetoothA2dp;-setSinkPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/media/CropImage;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/PhysicalKeyboardSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-pollState-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/webkit/WebSettings;-verifyNetworkAccess-()V' : ['android.permission.INTERNET'],
	'Landroid/nfc/ILlcpServiceSocket$Stub;-accept-(I)I' : ['android.permission.NFC'],
	'Lcom/android/inputmethod/latin/LatinIME;-addToBigramDictionary-(Ljava/lang/CharSequence; I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/accounts/ChooseAccountActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothAdapter;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowManager$Stub;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/cooliris/media/BackgroundLayer;-onSurfaceCreated-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Lcom/android/development/ConfigurationViewer;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/AccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification;-access$500-(Lcom/android/bluetooth/opp/BluetoothOppNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/development/LogViewer;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/NfcService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ConnectivityService;-handleNotificationChange-(Z I Landroid/app/Notification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-access$1000-(Lcom/android/internal/policy/impl/KeyguardViewMediator;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/bluetooth/IBluetooth;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/util/Recycler;-checkForThreadsOverLimit-(Landroid/content/Context;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/quicksearchbox/SearchActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MediaPlaybackService$3;-onAudioFocusChange-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/tts/TtsService;-access$100-(Landroid/tts/TtsService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CallManager;-acceptCall-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NotificationPlayer;-access$500-(Lcom/android/server/NotificationPlayer; Lcom/android/server/NotificationPlayer$Command;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-bailOutAfterErrorDialog-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/Browser;-truncateHistory-(Landroid/content/ContentResolver;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/util/Recycler;-anyThreadOverLimit-(Landroid/content/Context;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/os/storage/IMountService$Stub$Proxy;-mountVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/settings/UserDictionarySettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/Service;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmAlert;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$19;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHeadsetService$RfcommConnectThread;-run-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/DataList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WallpaperManagerService;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/settings/RadioInfo;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/IWallpaperManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SET_WALLPAPER_HINTS', 'android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityManagerService;-unbroadcastIntent-(Landroid/app/IApplicationThread; Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-keyguardDone-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/content/IContentService;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/phone/CdmaVoicePrivacyCheckBoxPreference$MyHandler;-handleGetVPResponse-(Landroid/os/Message;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getNeighboringCids-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$12;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/PlaylistBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/urlrenderer/UrlRendererService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/WifiSettings;-handleEvent-(Landroid/content/Intent;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/RadioInfo;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/tts/TtsService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Tab$SubWindowChromeClient;-onCloseWindow-(Landroid/webkit/WebView;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/AccountPreferenceBase;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$ErrorState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/ISyncAdapter$Stub;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothAdapter;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/WindowManagerPolicy;-interceptKeyBeforeQueueing-(J I Z I Z)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.CALL_PHONE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/certinstaller/CertFileList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-processNextBroadcast-(Z)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-updateSpnDisplay-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/IAudioService;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/SettingsLicenseActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/AppWidgetPickActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/AccountSyncSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Tab$6;-onDownloadStart-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/MediaPickerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AgendaByDayAdapter;-changeCursor-(Lcom/android/calendar/AgendaWindowAdapter$DayAdapterInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/PhoneProxy;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/SecuritySettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/OtaUtils;-access$200-(Lcom/android/phone/OtaUtils;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/Connectivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onApnChanged-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Landroid/location/Criteria; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/RingtoneManager;-getRingtone-(I)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccountSyncSettingsInAddAccount;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/settings/applications/RunningServiceDetails;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Landroid/accounts/AccountManager$3;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Lcom/android/inputmethod/latin/LatinKeyboardView;-swipeDown-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/server/BluetoothEventLoop;-onDeviceDisconnectRequested-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/wifi/WifiSettings;-onResume-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$10;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/InstrumentationList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-changeVolumeBy-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/GetPin2Screen;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NotificationManagerService;-cancelToastLocked-(I)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onBondingStateChanged-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/ChooseLockPatternTutorial;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/adapter/Parser;-parse-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/sip/SipSettings;-access$700-(Lcom/android/phone/sip/SipSettings; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-(J [B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity$GroupDelta;-buildDiff-()Landroid/content/ContentProviderOperation;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DataConnection;-access$1300-(Lcom/android/internal/telephony/DataConnection; Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/packageinstaller/UninstallerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/QueryBrowserActivity;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-makeNowPlayingCursor-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-access$1700-(Lcom/android/bluetooth/opp/BluetoothOppService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/CacheLoader;-load-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/IccLockSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WindowManagerService;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/media/AsyncPlayer$Thread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/IEmailService$Stub$Proxy;-startSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarActivity;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/BluetoothHandsfree;-userWantsAudioOn-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/tts/TtsService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/Network;-requestURL-(Ljava/lang/String; Ljava/util/Map; [B Landroid/webkit/LoadListener;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-refreshName-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-setEmptyText-()V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/RadioInfo;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/DevelopmentSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/WeekView;-init-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-updateMessageOnIccEf-(I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub;-setAnimationScales-([F)V' : ['android.permission.SET_ANIMATION_SCALE'],
	'Lcom/android/internal/telephony/RIL;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller;-sendPendingMessages-(J Lcom/android/email/Controller$Result;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManager$4;-start-()Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/WifiService;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/SyncManager$SyncHandler;-onBootCompleted-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/sip/ISipService;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.USE_SIP'],
	'Landroid/net/sip/SipAudioCall;-releaseWifiHighPerfLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-access$600-(Lcom/android/server/LocationManagerService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/SearchResultsActivity;-onResume-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityRecord;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-access$800-(Lcom/android/systemui/usb/UsbStorageActivity;)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$HeadsetProfileManager$1;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/UserDictionarySettings;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/email/GroupMessagingListener;-loadMessageForViewStarted-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ChooseLockPatternExample;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$27;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/vpn/VpnEditor;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IThrottleManager$Stub;-getHelpUri-()Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/DayActivity;-makeView-()Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/IContentService;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-read-(I)Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/nfc/ILlcpConnectionlessSocket;-sendTo-(I Landroid/nfc/LlcpPacket;)I' : ['android.permission.NFC'],
	'Lcom/android/camera/Camera;-access$6500-(Lcom/android/camera/Camera;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/wifi/WifiApSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/sip/SipEditor;-unregisterProfile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/settings/CredentialInstaller;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-<init>-(Lcom/android/music/TrackBrowserActivity; Lcom/android/music/IMediaPlaybackService; [Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MusicUtils;-togglePartyShuffle-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-attachApplicationLocked-(Landroid/app/IApplicationThread; I)Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/ExportVCardActivity;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GsmCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/CropImage;-access$100-(Landroid/content/Context; Landroid/os/Bundle; Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipAudioCallAdapter;-onCallEnded-(Lcom/android/internal/telephony/Connection$DisconnectCause;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-enforceReceiveAndSend-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/app/PlatLogoActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/data/WorkingMessage;-asyncDeleteDraftSmsMessage-(Lcom/android/mms/data/Conversation;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/InCallScreen;-onPhoneStateChanged-(Landroid/os/AsyncResult;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/pinyin/SettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Tab$3$4;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/server/BluetoothService$BondState;-isAutoPairingBlacklisted-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/AlertAdapter;-updateView-(Landroid/content/Context; Landroid/view/View; Ljava/lang/String; Ljava/lang/String; J J Z)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-startDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/CalendarView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/wifi/WifiManager;-getValidChannelCounts-()[I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/activity/MessageView;-reloadUiFromBody-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/commands/monkey/Monkey;-main-([Ljava/lang/String;)V' : ['android.permission.SIGNAL_PERSISTENT_PROCESSES', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/InCallScreen;-updateSlidingTabHint-(I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/service/IEmailServiceCallback$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-setSystemLocale-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Landroid/nfc/INfcTag;-transceive-(I [B)[B' : ['android.permission.NFC'],
	'Lcom/android/calendar/WeekView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-addPreferencesForProfiles-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/nfc/NfcService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getVoiceMailNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/term/TermPreferences;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CallFeaturesSetting;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/data/WorkingMessage;-createDraftMmsMessage-(Lcom/google/android/mms/pdu/PduPersister; Lcom/google/android/mms/pdu/SendReq; Lcom/android/mms/model/SlideshowModel;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/ConfirmLockPassword;-handleNext-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-delete-(Landroid/net/Uri; I J)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ManageSimMessages;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/applications/ApplicationsProvider$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothPbap;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/cooliris/media/Layer;-onSurfaceCreated-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-queryPhoneNumbers-(J)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getOutgoingCallerIdDisplay-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-createBondOutOfBand-(Ljava/lang/String; [B [B)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-sendMeetingResponse-(Lcom/android/exchange/MeetingResponseRequest;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-getPackageSizeInfo-(Ljava/lang/String; Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothSettings$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/InCallScreenShowActivation;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/applications/ApplicationLauncher;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/ChooseLockPassword;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/ListActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Display;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/test/mock/MockContentResolver;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Landroid/content/SyncManager;-sendCheckAlarmsMessage-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onError-(Lcom/android/internal/telephony/Connection$DisconnectCause;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-pullVcardEntry-([B Lcom/android/bluetooth/pbap/BluetoothPbapObexServer$AppParamValue; Ljavax/obex/Operation; Ljava/lang/String; Ljava/lang/String;)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-hideLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/view/ContextThemeWrapper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/IWifiManager;-reassociate-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/AlertActivity;-onStop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/media/IAudioService$Stub;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/IContentService$Stub;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/WeekActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingHandsfree;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService$2;-createLlcpConnectionlessSocket-(I)I' : ['android.permission.NFC'],
	'Landroid/widget/VideoView$6;-surfaceCreated-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPickerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/Wallpaper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/WifiAPITest$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/music/MusicPicker;-stopMediaPlayer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/Development;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/InCallScreen;-delayedCleanupAfterDisconnect-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/ShowActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService$AudioHandler;-persistVibrateSetting-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/cooliris/wallpaper/Slideshow;-onVisibilityChanged-(Z)V' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/BluetoothDevice;-setDeviceOutOfBandData-([B [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/storage/IMountService$Stub;-formatVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Lcom/android/mms/ui/Presenter;-present-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EmergencyDialer;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setCellBroadcastSmsConfig-([I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen$CheckSimPin$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/WifiService;-startScan-(Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/PointerTracker;-repeatKey-(I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/email/service/EasAuthenticatorService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-exitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/WallpaperChooser;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/CallDetailActivity;-onResume-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/vpn/VpnServiceBinder;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebIconDatabase$EventHandler;-bulkRequestIcons-(Landroid/os/Message;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phone/FdnSetting;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/BackupManager;-requestRestore-(Landroid/app/backup/RestoreObserver;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/webkit/WebView;-doTrackball-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker;-getTriState-(Landroid/content/Context;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/location/GpsLocationProvider;-addListener-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserActivity;-onLowMemory-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/PhoneUtils;-sendEmptyFlash-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager;-updateCredentials-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-setCellBroadcastConfig-([I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DockSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WifiService;-setWifiApEnabledState-(I I Lcom/android/server/WifiService$DriverAction;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadProvider;-openFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.INTERNET'],
	'Lcom/android/settings/wifi/WifiConfigInfo;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/SipCallOptionHandler;-access$200-(Lcom/android/phone/SipCallOptionHandler; Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.USE_SIP'],
	'Lcom/android/mms/transaction/Transaction;-notifyObservers-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/server/am/ActivityManagerService;-handleAppCrashLocked-(Lcom/android/server/am/ProcessRecord;)Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/cooliris/media/PhotoAppWidgetBind;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-centerKeyPressOnTextField-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/voicedialer/VoiceContact;-getVoiceContacts-(Landroid/app/Activity;)Ljava/util/List;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery;-startQuery-(I Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/internal/telephony/CallerInfoAsyncQuery;' : ['android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-getJoinSuggestionsUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/ContactsContract$Groups$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-suspendSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-refreshOnlineModePreference-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/soundrecorder/SoundRecorder;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ui/QuickContactWindow;-handleData-(Landroid/database/Cursor;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-shutdown-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-hangupWaitingOrBackground-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/Launcher;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification$NotificationUpdateThread;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/BluetoothHandsfree$2;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Landroid/webkit/WebView$InvokeListBox$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsLiveFolders$AllContacts;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/model/AudioModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/AlertActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/LoadListener;-handleEndData-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/google/common/io/Files;-getChecksum-(Ljava/io/File; Ljava/util/zip/Checksum;)J' : ['android.permission.INTERNET'],
	'Landroid/content/IContentService$Stub$Proxy;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/Settings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/PhoneUtils;-answerAndEndActive-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/calendar/EditEvent;-updateHomeTime-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupForegroundResumeBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageStatsObserver$Stub$Proxy;-onGetStatsCompleted-(Landroid/content/pm/PackageStats; Z)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Landroid/provider/Browser;-deleteFromHistory-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/IContentService;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/app/Application;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ViewContactActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/sip/SipAudioCall$1;-onCallBusy-(Landroid/net/sip/SipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab;-putInForeground-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/vpn/VpnService;-onDisconnect-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/email/activity/setup/AccountSetupIncoming;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/MonitoredActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/OtaUtils;-otaPerformActivation-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/downloads/DownloadService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-start-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-setIpForwardingEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/launcher2/WallpaperChooser;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/AdvancedSettings;-initNumChannelsPreference-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/AdnRecordLoader;-loadAllFromEF-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-goForward-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-pair-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/LatinIME;-hideWindow-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/phone/BluetoothHandsfree;-userWantsAudioOff-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/Tab$3;-onRequestFocus-(Landroid/webkit/WebView;)V' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/IAccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-powerOffRadioSafely-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/HudLayer$12;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$5;-doWork-()V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-<init>-(Landroid/os/Handler; Landroid/content/Context;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/nfc/NdefTagConnection;-makeReadOnly-()Z' : ['android.permission.NFC'],
	'Lcom/android/inputmethod/latin/LatinIME;-checkAddToDictionary-(Ljava/lang/CharSequence; I Z)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/browser/BrowserActivity;-sendNetworkType-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewCore;-sendMessageAtFrontOfQueue-(I Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/cooliris/media/RenderView;-onDrawFrame-(Ljavax/microedition/khronos/opengles/GL10;)V' : ['android.permission.WAKE_LOCK', 'android.permission.INTERNET'],
	'Landroid/provider/ContactsContract$SyncState;-newSetOperation-(Landroid/accounts/Account; [B)Landroid/content/ContentProviderOperation;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/IWifiManager;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/bluetooth/IBluetooth;-createBondOutOfBand-(Ljava/lang/String; [B [B)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnection;-start-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-load-()V' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-tetherInterface-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$A2dpProfileManager;-getSummary-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/server/BluetoothService;-readOutOfBandData-()[B' : ['android.permission.BLUETOOTH'],
	'Landroid/os/INetworkManagementService$Stub;-getIpForwardingEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/content/IContentService;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothA2dp;-getNonDisconnectedSinks-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/ZoneList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/Downloads$ById;-getDownloadUri-(J)Landroid/net/Uri;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-access$800-(Lcom/android/internal/policy/impl/KeyguardViewMediator;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-isSyncable-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/SelectCalendarsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/preference/PreferenceActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/sip/SipSettings$1;-run-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/DevelopmentSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/CalendarView;-access$300-(Lcom/android/calendar/CalendarView;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/stk/RilMessageDecoder;-start-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/ILlcpConnectionlessSocket$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Lcom/android/camera/Camera;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-handleIccFull-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-startTone-(C)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-dontAddVoiceMailNumber-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/DeleteFdnContactScreen;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Ljava/lang/String; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/applications/RunningServiceDetails;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/ChangeIccPinScreen$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/speechrecorder/SpeechRecorderActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ActivityManagerNative;-getTasks-(I I Landroid/app/IThumbnailReceiver;)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/deskclock/AlarmKlaxon;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/DockService$1;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/SlideViewInterface;-stopAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleInCallMmiCommands-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/SearchResultsActivity;-queryPhoneNumbers-(J)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/email/service/IEmailService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ChooseLockPassword;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/SyncManager;-scheduleSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/webkit/WebViewCore;-sendMessage-(I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/AudioService$AudioHandler;-access$3400-(Landroid/media/AudioService$AudioHandler; Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/service/wallpaper/ImageWallpaper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/tts/TtsService;-access$2100-(Landroid/tts/TtsService; Ljava/lang/String; J I Ljava/util/ArrayList;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/CredentialInstaller;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ChooseLockPassword;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/PowerManager$WakeLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$ActiveRestoreSession;-restoreAll-(J Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/gsm/stk/CommandParamsFactory;-processSelectItem-(Lcom/android/internal/telephony/gsm/stk/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processPostDialChar-(C)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-getOneOffSummary-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MessageView;-onDownloadAttachment-(Lcom/android/email/activity/MessageView$AttachmentInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebView;-removePackageName-(Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/location/GpsLocationProvider;-disable-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/sip/SipEditor;-access$700-(Lcom/android/phone/sip/SipEditor; Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/view/IWindowManager;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager;-getAccounts-()[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/SyncManager$2;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-enableNat-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Landroid/content/ISyncAdapter$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-performServiceRestartLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/vpn/PptpService;-onError-(I)V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/WebView;-destroy-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/preference/PreferenceActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$People;-markAsContacted-(Landroid/content/ContentResolver; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/CalendarActivity;-goToToday-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/providers/downloads/ui/DownloadList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/sip/SipSettings;-access$800-(Lcom/android/phone/sip/SipSettings;)V' : ['android.permission.USE_SIP'],
	'Landroid/os/INetworkManagementService;-enableNat-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/providers/downloads/DownloadNotification;-updateNotification-(Ljava/util/Collection;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeManual-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/music/MusicUtils;-addToCurrentPlaylist-(Landroid/content/Context; [J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-listInterfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/AllApps2D;-onItemLongClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/calendar/DeleteEventHelper;-deleteRepeatingEvent-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingHandsfree;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/cooliris/media/HudLayer$14;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-commandsParser-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipCall;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifyServiceState-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneApp;-access$1200-(Lcom/android/phone/PhoneApp;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/Ringtone;-play-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebIconDatabase;-retainIconForPageUrl-(Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/nfc/NfcService$2;-getNfcTagInterface-()Landroid/nfc/INfcTag;' : ['android.permission.NFC'],
	'Landroid/app/ListActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/downloads/DownloadThread;-notifyThroughDatabase-(I Z I I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/app/backup/RestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/RestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-sendGeneralBroadcast-(Landroid/net/NetworkInfo; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/os/IVibratorService;-vibrate-(J Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/development/BadBehaviorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/ChooseLockPattern;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothDevice;-cancelBondProcess-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity;-playSound-(I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/development/DevelopmentSettings;-writeCompatibilityOptions-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/Email;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRadioOffOrNotAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideshowEditActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/AudioAttachmentView;-startAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions$ToggleAction;-onToggle-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub;-confirmCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/exchange/SyncManager$2;-autoDiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageView;-onDelete-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendPhonebookOneVcard-(Ljavax/obex/Operation; I Z Ljava/lang/String; I)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/app/IBatteryStats;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/AirplaneModeEnabler;-setAirplaneModeInECM-(Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioService$AudioHandler$1;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/INetworkManagementEventObserver$Stub;-interfaceAdded-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setPasskey-(Ljava/lang/String; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/TwelveKeyDialer;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/EventLoader;-startBackgroundThread-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/AccountSyncSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/CredentialInstaller;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/os/BatteryStatsImpl;-writeToParcelWithoutUids-(Landroid/os/Parcel; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/MessageList;-onSendPendingMessages-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering;-configureUsbIface-(Z)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/CallCard;-updatePhotoForCallState-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-saveDraft-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/util/Log$1;-onTerribleFailure-(Ljava/lang/String; Landroid/util/Log$TerribleFailure;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/latin/LatinIMESettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/TetherSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-simulateDataConnection-(Lcom/android/internal/telephony/Phone$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/ConnectivityService;-access$1200-(Lcom/android/server/ConnectivityService; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/ContactsLiveFolders$AllContacts;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/GridLayer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/NotificationManager;-notify-(Ljava/lang/String; I Landroid/app/Notification;)V' : ['android.permission.VIBRATE'],
	'Landroid/test/TestBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/IsolatedContext$MockAccountManager;-confirmCredentials-(Landroid/accounts/Account; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/providers/downloads/DownloadService;-scanFile-(Lcom/android/providers/downloads/DownloadInfo; Z Z)Z' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/ThrottleService$MyHandler;-clearThrottleAndNotification-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY'],
	'Landroid/provider/ContactsContract$SyncState;-get-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)[B' : ['android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothHeadset;-connectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/SyncManager;-access$100-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayView;-initView-(Lcom/android/calendar/CalendarView;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/PhoneUtils;-activateSpeakerIfDocked-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.REORDER_TASKS', 'android.permission.SIGNAL_PERSISTENT_PROCESSES', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.SET_DEBUG_APP', 'android.permission.WAKE_LOCK', 'android.permission.GET_TASKS', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_PROCESS_LIMIT', 'android.permission.SET_ALWAYS_FINISH', 'android.permission.RESTART_PACKAGES', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/email/service/EasAuthenticatorService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ConnectivityService;-access$600-(Lcom/android/server/ConnectivityService; Landroid/net/NetworkInfo;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabControl;-setCurrentTab-(Lcom/android/browser/Tab; Z)Z' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity$UpdateTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/WebView$1;-onZoom-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/AttachImage;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactsListActivity;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-startUsbRNDIS-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/phone/GsmUmtsAdditionalCallOptions;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MusicPicker;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createConfirmationDialog-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiStateTracker;-handleDisconnectedState-(Landroid/net/NetworkInfo$DetailedState; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/IP2pInitiator;-send-(I [B)Z' : ['android.permission.NFC'],
	'Lcom/android/email/activity/MessageList;-doFooterClick-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/settings/DebugIntentSender;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/BackupAgentHelper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallEnded-(Lcom/android/internal/telephony/Connection$DisconnectCause;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService$Stub;-startBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/LatinIME;-onFinishInput-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/phone/BluetoothHeadsetService;-getSdpRecordsAndConnect-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/BrowserActivity;-onPageStarted-(Landroid/webkit/WebView; Ljava/lang/String; Landroid/graphics/Bitmap;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/SearchResultsActivity;-doShareVisibleContacts-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onSystemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/Downloads$ByUri;-startDownloadByUri-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Z I Z Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)J' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/mms/ui/SlideViewInterface;-setVideo-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHeadsetService;-setState-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/setup/AccountSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-setJsFlags-(Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/soundrecorder/Recorder$OnStateChangedListener;-onStateChanged-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputManager$Callbacks;-interceptKeyBeforeDispatching-(Landroid/view/InputChannel; I I I I I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/browser/Tab$3$4;-doInBackground-([Ljava/lang/Void;)[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-getContactDisplayName-(J)Ljava/lang/String;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/WindowManagerService$Session;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/settings/ApnSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/model/MediaModelFactory;-getGenericMediaModel-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Lorg/w3c/dom/smil/SMILMediaElement; Lcom/google/android/mms/pdu/PduPart; Lcom/android/mms/model/RegionModel;)Lcom/android/mms/model/MediaModel;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/quicksearchbox/google/GoogleSearch;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactsListActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/SettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/ILlcpSocket;-connectByName-(I Ljava/lang/String;)I' : ['android.permission.NFC'],
	'Lcom/cooliris/media/RootLayer;-onSurfaceCreated-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-reportFailedUnlockAttempt-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/AppWidgetPickActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/NetInitiatedActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/MessageUtils$3$1;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-access$2500-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/Application;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessageListAdapter;-notifyImageLoaded-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/InCallScreen;-onMuteClick-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-supplyIccPuk-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService$ScoClient;-incCount-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebView;-debugDump-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/EditEvent;-saveRemindersWithBackRef-(Ljava/util/ArrayList; I Ljava/util/ArrayList; Ljava/util/ArrayList; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/ContactsLiveFolders$PhoneContacts;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telephony/gsm/SmsManager;-sendMultipartTextMessage-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Lcom/android/phone/NotificationMgr;-updateNotificationsAtStartup-()V' : ['android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/os/IDropBoxManagerService$Stub$Proxy;-getNextEntry-(Ljava/lang/String; J)Landroid/os/DropBoxManager$Entry;' : ['android.permission.READ_LOGS'],
	'Lcom/cooliris/media/PhotoAppWidgetConfigure;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/IContentService$Stub;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/PackageManagerService;-deletePackageX-(Ljava/lang/String; Z Z I)Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/server/BluetoothEventLoop;-onDeviceFound-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/LatinIME;-onOptionKeyLongPressed-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/deskclock/Alarms;-deleteAlarm-(Landroid/content/Context; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-enableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/ContactsProvider2;-deleteInTransaction-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ZoneList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/google/common/io/Resources;-readLines-(Ljava/net/URL; Ljava/nio/charset/Charset; Lcom/google/common/io/LineProcessor;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/settings/AccountPreferenceBase$1$1;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/phone/PhoneInterfaceManager;-silenceRingerInternal-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/providers/downloads/SystemFacade;-postNotification-(J Landroid/app/Notification;)V' : ['android.permission.VIBRATE'],
	'Landroid/tts/TtsService;-access$1900-(Landroid/tts/TtsService; Ljava/lang/String; Ljava/lang/String; I Ljava/util/ArrayList;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-moveTaskToFront-(I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/calendar/AgendaWindowAdapter;-access$1400-(Lcom/android/calendar/AgendaWindowAdapter; Lcom/android/calendar/AgendaWindowAdapter$QuerySpec;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/CalendarPreferenceActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/SyncManager;-sendMessageRequest-(Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/TestActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-connectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/AccountSyncSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneApp;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelPairingUserInput-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/setup/AccountSetupBasics;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/EasOutboxService;-sendHttpClientPost-(Ljava/lang/String; Lorg/apache/http/HttpEntity;)Lorg/apache/http/HttpResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/RadioInfo;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapter$Stub;-getLlcpConnectionlessInterface-()Landroid/nfc/ILlcpConnectionlessSocket;' : ['android.permission.NFC'],
	'Lcom/android/email/service/MailService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-getGPRSRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-access$1300-(Lcom/android/internal/policy/impl/KeyguardViewMediator; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/development/UnderdevelopedSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-isWifiApEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/ui/ManageSimMessages$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-checkPendingNotification-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/BrowserBookmarksAdapter$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/IBluetoothHeadset;-createIncomingConnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/ImportVCardActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/IWindowManager;-reenableKeyguard-(Landroid/os/IBinder;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/email/Controller$LegacyListener;-loadAttachmentFailed-(J J J Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/sip/SipEditor;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageView$MessageViewHandler;-loadContentUri-(Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-handleSmses-(Ljava/util/ArrayList;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-handleDocked-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-changeParser-(Lcom/android/exchange/adapter/ContactsSyncAdapter$ContactOperations;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ManageSimMessages;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-getLastPdpFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-clearLock-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/LatinKeyboardBaseView;-swipeDown-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteOldMessages-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/nfc/ILlcpSocket$Stub$Proxy;-getLocalSocketMiu-(I)I' : ['android.permission.NFC'],
	'Landroid/bluetooth/IBluetoothHeadset;-startVoiceRecognition-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-getSelectedUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/DockService;-initBtSettings-(Lcom/android/settings/bluetooth/DockService; Landroid/bluetooth/BluetoothDevice; I Z)[Ljava/lang/CharSequence;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/LocationManagerService;-addProximityAlert-(D D F J Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/sip/SipSharedPreferences;-setReceivingCallsEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-removeItem-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/MasterClear;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/OtaUtils;-setSpeaker-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-deactivateDefaultPDP-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/NotificationMgr;-updateMwi-(Z)V' : ['android.permission.VIBRATE'],
	'Landroid/speech/SpeechRecognizer;-handleStartListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/ADNList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/RenderView;-drawMixed2D-(Lcom/cooliris/media/Texture; Lcom/cooliris/media/Texture; F F F F F F)V' : ['android.permission.INTERNET'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-getLlcpInterface-()Landroid/nfc/ILlcpSocket;' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/PackageBrowser;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactsListActivity$ContactItemListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/BrowserActivity;-onPageFinished-(Landroid/webkit/WebView; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/ApplicationSettings$1;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/InCallScreen;-access$1600-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$10;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/DialtactsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ActivityManagerNative;-setProcessLimit-(I)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Lcom/android/settings/fuelgauge/PowerUsageDetail;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager$Stub$Proxy;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/Email;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioManager;-startBluetoothSco-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebView;-onTrackballEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-setPostDialState-(Lcom/android/internal/telephony/Connection$PostDialState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/net/http/RequestQueue$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/cooliris/media/ReverseGeocoder;-process-(Lcom/cooliris/media/MediaSet;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/KeyguardManager;-exitKeyguardSecurely-(Landroid/app/KeyguardManager$OnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/ui/SlideshowPresenter;-present-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-changeIccPin-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Telephony$Sms;-query-(Landroid/content/ContentResolver; [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/TwelveKeyDialer;-setFormattedDigits-(Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-onRestore-(Landroid/app/backup/BackupDataInput; I Landroid/os/ParcelFileDescriptor;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/nfc/LlcpSocket;-getLocalSocketRw-()I' : ['android.permission.NFC'],
	'Landroid/webkit/HTML5VideoViewProxy;-loadPoster-(Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothHeadset;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/ConversationList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/speechrecorder/SpeechRecorderActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/model/MediaModelFactory;-getRegionMediaModel-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Lorg/w3c/dom/smil/SMILRegionMediaElement; Lcom/android/mms/model/LayoutModel; Lcom/google/android/mms/pdu/PduPart;)Lcom/android/mms/model/MediaModel;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/webkit/StreamLoader;-setupStreamAndSendStatus-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageView;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/ITelephony;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/IAlarmManager$Stub;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/nfc/NfcService$3;-connectByName-(I Ljava/lang/String;)I' : ['android.permission.NFC'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-onRestart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/DockService;-access$000-(Lcom/android/settings/bluetooth/DockService; Landroid/os/Message;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BrowserActivity;-access$500-(Lcom/android/browser/BrowserActivity; Landroid/webkit/WebView; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/ui/EditContactActivity$QueryEntitiesTask;-onPostExecute-(Ljava/lang/Object; Ljava/lang/Object;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/nfc/LlcpSocket;-getLocalSocketMiu-()I' : ['android.permission.NFC'],
	'Landroid/webkit/WebView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/ActivityGroup;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioManager;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/nfc/NfcService$EnableDisableDiscoveryTask;-doInBackground-([Ljava/lang/Boolean;)Ljava/lang/Void;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-getTriState-(Landroid/content/Context;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/IActivityManager;-setProcessForeground-(Landroid/os/IBinder; I Z)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Lcom/android/music/IMediaPlaybackService;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CdmaCallOptions;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/SyncManager;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManagerService;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-disconnectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ConversationList;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/LocationManagerService$ProximityListener;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/PackageManagerService;-<init>-(Landroid/content/Context; Z)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createDisplayPasskeyDialog-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/inputmethodservice/InputMethodService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-getMute-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$MyExecutor;-execute-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-bringDownServiceLocked-(Lcom/android/server/am/ServiceRecord; Z)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/WapPushOverSms;-dispatchWapPdu_default-([B I I Ljava/lang/String; I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-setRemoteOutOfBandData-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/SlideshowEditActivity$SlideListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$PerformRestoreTask;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/app/WallpaperManager;-setResource-(I)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MediaPlaybackService;-access$1600-(Lcom/android/music/MediaPlaybackService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-onUuidChanged-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/quicksearchbox/SearchSettings;-setShowWebSuggestions-(Landroid/content/Context; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/BrowserActivity;-access$2300-(Lcom/android/browser/BrowserActivity; Ljava/util/Set;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/IP2pTarget$Stub$Proxy;-getGeneralBytes-(I)[B' : ['android.permission.NFC'],
	'Lcom/android/phone/CallNotifier$1;-onCallForwardingIndicatorChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/CdmaCallOptions;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/WifiSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ShutdownActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen;-findIntendedAccount-(Ljava/lang/String;)Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/WeekView;-doScroll-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/InCallScreenShowActivation;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebIconDatabase;-open-(Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/os/INetworkManagementService$Stub;-disableNat-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/cooliris/media/PhotoAppWidgetConfigure;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$2;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/development/ConfigurationViewer;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSetupOptions;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/BluetoothHandsfree;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/Calendar$CalendarAlerts;-query-(Landroid/content/ContentResolver; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/HeadsetBase;-handleInput-(Ljava/lang/String;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/media/Gallery;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/Gallery;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/UsbObserver;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/PhotoAppWidgetBind;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-stopSample-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/MonthView;-doDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetooth;-getRemoteName-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/SipCallOptionHandler;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/DownloadThread;-processResponseHeaders-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState; Lorg/apache/http/HttpResponse;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/VideoView;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ui/ShowOrCreateActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EditFdnContactScreen;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/DockService;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/PhoneUtils;-hangup-(Lcom/android/internal/telephony/CallManager;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/content/SyncManager$SyncAlarmIntentReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/music/CreatePlaylist;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/LoadAverageService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-disconnectHeadset-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ConversationList;-confirmDeleteThread-(J Landroid/content/AsyncQueryHandler;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onDataStateChanged-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/preference/YesNoPreference;-onDialogClosed-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/app/backup/IBackupManager;-setBackupProvisioned-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/commands/bmgr/Bmgr;-doTransport-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onResetDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideEditorActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ContactsListActivity;-access$000-(Lcom/android/contacts/ContactsListActivity; Z)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/ContactsContract$SyncState;-set-(Landroid/content/ContentProviderClient; Landroid/accounts/Account; [B)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/nfc/ILlcpSocket$Stub$Proxy;-getLocalSocketRw-(I)I' : ['android.permission.NFC'],
	'Lcom/android/email/MessagingListener;-loadAttachmentFailed-(J J J Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/BluetoothService;-access$200-(Landroid/server/BluetoothService; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/CandidateView;-access$200-(Lcom/android/inputmethod/latin/CandidateView;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/inputmethod/latin/LatinIMEDebugSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CellBroadcastSms;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneBase;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/Camera;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$400-(Lcom/android/mms/transaction/SmsReceiverService;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/LocationManagerService;-addTestProvider-(Ljava/lang/String; Z Z Z Z Z Z Z I I)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ExportVCardActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ConversationListItem;-updateFromView-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/ShutdownActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/AccountSyncAdapter;-getSyncKey-()Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/AlertActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-createAllApnList-()V' : ['android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/email/activity/MessageView$CustomWebViewClient;-onReceivedHttpAuthRequest-(Landroid/webkit/WebView; Landroid/webkit/HttpAuthHandler; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen$CheckSimPin;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SearchActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WifiWatchdogService;-access$1600-(Lcom/android/server/WifiWatchdogService; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/phone/CdmaCallOptions;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager;-addProximityAlert-(D D F J Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/launcher2/Launcher;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/DockService;-hasOtherConnectedDevices-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/sip/SipEditor;-access$600-(Lcom/android/phone/sip/SipEditor; Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/phone/EnableIccPinScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/packageinstaller/InstallAppProgress;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ListActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/MessagingNotification;-getMmsNewMessageNotificationInfo-(Landroid/content/Context; Ljava/util/Set;)Lcom/android/mms/transaction/MessagingNotification$MmsSmsNotificationInfo;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/vpn/PptpService;-access$400-(Lcom/android/server/vpn/VpnService;)Z' : ['android.permission.VIBRATE'],
	'Landroid/media/AudioService$SettingsObserver;-<init>-(Landroid/media/AudioService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/development/AppHwConfigList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AlertService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/AccessibilityManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/IAccountManager;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendVCards-(Ljavax/obex/Operation; Ljava/lang/String; Z Ljava/lang/String; Z)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/TwelveKeyDialer;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/MonthView;-<init>-(Lcom/android/calendar/MonthActivity; Lcom/android/calendar/Navigator;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/SearchResultsActivity;-onCreateDialog-(I Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isConnected-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/cooliris/wallpaper/Slideshow$1;-run-()V' : ['android.permission.INTERNET'],
	'Lcom/android/email/activity/setup/AccountSetupBasics;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/PowerManager$WakeLock;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/PackageManagerService;-killApplication-(Ljava/lang/String; I)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/cooliris/media/BackgroundLayer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getMute-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NetworkManagementService;-getDnsForwarders-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/WifiService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-flashAndSetGenericTrue-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AppWidgetPickActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/AgendaByDayAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Lcom/google/common/io/Resources;-toString-(Ljava/net/URL; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/ui/EditContactActivity;-onRestoreInstanceState-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/calendar/CalendarProvider2;-regenerateInstancesTable-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/PhoneUtils;-setAudioMode-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/location/GpsLocationProvider;-removeListener-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/ActiveTabsPage$1;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/Gallery;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/MessageView$LoadAttachmentsTask;-onPostExecute-([Lcom/android/email/provider/EmailContent$Attachment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$8;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/SyncAdapterDriver;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserActivity;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/cooliris/media/Layer;-renderOpaque-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity;-doSaveAction-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/vpn/VpnServiceBinder$3;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/deskclock/AlarmAlertFullScreen$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/VibratorService$Vibration;-binderDied-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/BrowserFrame;-handleUrl-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/IAccountManager$Stub;-getAccountsByFeatures-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserActivity$15;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification;-updateIncomingFileConfirmNotification-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/music/TrackBrowserActivity$5;-remove-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/GlobalActions;-access$300-(Lcom/android/internal/policy/impl/GlobalActions; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setEnabled-(Z)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-processResponse-(Landroid/os/Parcel;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/certinstaller/CertFile;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-setupDefaultPDP-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/AccountsTester$ButtonClickListener;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/CalendarActivity$CalendarGestureListener;-onScroll-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/RIL;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-onConnectedInOrOut-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/EditEvent;-access$1600-(Lcom/android/calendar/EditEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/vpn/VpnServiceBinder;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/search/SearchEngine;-getSuggestions-(Landroid/content/Context; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsListActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-onHoldClick-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppIncomingFileConfirmActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ManageSimMessages;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/certinstaller/CertInstallerMain;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-setOnlineMode-(Z Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-connectSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Landroid/view/IWindowManager;-prepareAppTransition-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/drm/DrmUtils;-insert-(Landroid/content/Context; Lcom/android/mms/drm/DrmWrapper;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/nfc/IP2pInitiator$Stub$Proxy;-send-(I [B)Z' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getRemoteUuids-(Ljava/lang/String;)[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/EmergencyCallbackModeService;-showNotification-(J)V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setRemoteOutOfBandData-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/http/HttpConnection;-openHttpConnection-(Landroid/net/http/Request;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherMasterUtilState;-turnOffMobileConnection-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/google/common/io/Files;-toString-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/WebStorageSizeManager;-scheduleOutOfSpaceNotification-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/EditSlideDurationActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/Activity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallScreen;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/ChangeIccPinScreen;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$ContactOperations;-delete-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/speech/IRecognitionService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/calendar/EventInfoActivity;-updateResponse-(Landroid/content/ContentResolver; J J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mms/ui/SlideshowActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Calendar$EventDays;-query-(Landroid/content/ContentResolver; I I)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/deskclock/HandleSetAlarm;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NotificationManagerService;-enqueueNotification-(Ljava/lang/String; I Landroid/app/Notification; [I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-addProximityAlertLocked-(D D F J Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/server/BluetoothA2dpService;-isDisconnectSinkFeasible-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothDevice;-setPairingConfirmation-(Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/deviceinfo/Status;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-notifyScreenOnLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/RIL;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity$UpdateTask;-doInBackground-(Ljava/lang/Object; [Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/net/http/EventHandler;-endData-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothEventRedirector$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/ChangeIccPinScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/DeskClock;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHeadsetService;-onStart-(Landroid/content/Intent; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/CreateShortcut;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/SmsReceiverService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ThrottleService$MyHandler;-onIfaceUp-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/development/Connectivity$12;-onClick-(Landroid/view/View;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter;-<init>-(Lcom/android/email/provider/EmailContent$Mailbox; Lcom/android/exchange/EasSyncService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/BluetoothHandsfree$25;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WifiService;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-finishAnimationLw-()I' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/phone/DeleteFdnContactScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/calendar/CalendarProvider2;-access$600-(Lcom/android/providers/calendar/CalendarProvider2; J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WifiService;-reassociate-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/music/RepeatingImageButton;-access$000-(Lcom/android/music/RepeatingImageButton; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessageListItem;-bindCommonMessage-(Lcom/android/mms/ui/MessageListAdapter$AvatarCache; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/transaction/RetryScheduler;-setRetryAlarm-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/quicksearchbox/ChoiceActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IContentService;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/phone/BluetoothHandsfree$25;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ApplicationSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onEnableApn-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/exchange/EasSyncService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/WifiManager;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/app/NetInitiatedActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WifiService;-access$1900-(Lcom/android/server/WifiService; Z Z I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_MULTICAST_STATE', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/telephony/SmsProvider;-insert-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/cooliris/picasa/PicasaContentProvider$SyncContext;-login-(Ljava/lang/String;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-onSimReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHeadsetService;-adjustPriorities-()V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/DataUsage;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/LatinIMEDebugSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/content/SyncManager$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiManager$MulticastLock;-release-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setSystemLocale-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/settings/wifi/AdvancedSettings;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-selectBackupTransport-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/NfcService$6;-write-(I Landroid/nfc/NdefMessage;)I' : ['android.permission.NFC'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity;-access$1000-(Lcom/android/music/MediaPlaybackActivity; I J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity;-onCreateDialog-(I Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-onRuimReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-handleRadioNotAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-hangup-(Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/RenderView;-processKeyEvent-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/NetworkStateTracker;-setRadio-(Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/LockPatternUtils;-setLockPatternEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/cooliris/wallpaper/Slideshow$DataSource;-getBitmapForIndex-(Landroid/content/Context; I)Landroid/graphics/Bitmap;' : ['android.permission.INTERNET'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/mms/transaction/SmsReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-checkProviderState-(Z)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/BluetoothHandsfree$10;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/DTMFTwelveKeyDialer$DTMFKeyListener;-onKeyDown-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/media/MonitoredActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getCallHistorySize-(I)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityManagerService;-finishInstrumentationLocked-(Lcom/android/server/am/ProcessRecord; I Landroid/os/Bundle;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-startAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/webkit/WebView;-sendOurVisibleRect-()Landroid/graphics/Rect;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/AppHwConfigList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/GsmUmtsCallOptions;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasOutboxService;-doStatusCallback-(J J I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/InputManager$Callbacks;-notifyLidSwitchChanged-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/AlertService;-postNotification-(Landroid/content/Context; Landroid/content/SharedPreferences; Ljava/lang/String; Ljava/lang/String; I Z Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/downloads/DownloadNotification;-updateCompletedNotification-(Ljava/util/Collection;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity$4;-onTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothAdapter;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/LatinIME;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-getContactMethodType-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/phone/PhoneInterfaceManager;-answerRingingCallInternal-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-suspend-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DateTimeSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityStack;-moveTaskToBackLocked-(I Lcom/android/server/am/ActivityRecord;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/deskclock/AlarmClock;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/AliasActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/test/mock/MockApplication;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$AccountAnalyzer;-next-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/deskclock/AlarmKlaxon;-play-(Lcom/android/deskclock/Alarm;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/development/Development;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NotificationManagerService$SettingsObserver;-observe-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/MonthView;-updateEventDetails-(I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteOldMessagesInSameThreadAsMessage-(Landroid/content/Context; Landroid/net/Uri;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-getPreferred-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/os/IDropBoxManagerService;-getNextEntry-(Ljava/lang/String; J)Landroid/os/DropBoxManager$Entry;' : ['android.permission.READ_LOGS'],
	'Lcom/android/mms/ui/ConversationList$2;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/DockService;-connectIfEnabled-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/picasa/PicasaContentProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/util/Recycler;-deleteMessagesForThread-(Landroid/content/Context; J I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/nfc/ILlcpConnectionlessSocket$Stub;-getSap-(I)I' : ['android.permission.NFC'],
	'Lcom/android/settings/wifi/WifiInfo;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/SlideshowEditActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/nfc/LlcpServiceSocket;-close-()V' : ['android.permission.NFC'],
	'Lcom/android/systemui/usb/StorageNotification$1;-run-()V' : ['android.permission.VIBRATE'],
	'Ljava/net/URLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/calendar/MonthActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/sip/SipEditor;-deleteAndUnregisterProfile-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/bluetooth/BluetoothA2dp;-getSinkState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/cooliris/media/MovieView;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ImportVCardActivity$VCardReadThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/SoundSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/commands/monkey/Monkey;-signalPersistentProcesses-()V' : ['android.permission.SIGNAL_PERSISTENT_PROCESSES'],
	'Lcom/android/music/MediaPlaybackService;-prev-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NetworkManagementService;-startAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/nfc/P2pTarget;-getGeneralBytes-()[B' : ['android.permission.NFC'],
	'Lcom/android/settings/bluetooth/DockService;-applyBtSettings-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ThrottleService$MyHandler;-onResetAlarm-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE'],
	'Landroid/webkit/Network;-enablePlatformNotifications-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/WindowManagerService;-moveAppWindowsLocked-(Lcom/android/server/WindowManagerService$AppWindowToken; I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/settings/PrivacySettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/WifiWatchdogService;-access$1000-(Lcom/android/server/WifiWatchdogService; Lcom/android/server/WifiWatchdogService$AccessPoint;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$A2dpProfileManager;-getPreferred-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/SipCallOptionHandler;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-resetRadio-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-setPropertyInteger-(Ljava/lang/String; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/WarnOfStorageLimitsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/GetPin2Screen;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IThrottleManager$Stub;-getByteCount-(Ljava/lang/String; I I I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/os/IPowerManager$Stub;-acquireWakeLock-(I Landroid/os/IBinder; Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ManageSimMessages;-access$000-(Lcom/android/mms/ui/ManageSimMessages;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/Downloads$ByUri;-removeAllDownloadsByPackage-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/calendar/AlertActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiApEnabler;-updateTetherState-([Ljava/lang/Object; [Ljava/lang/Object; [Ljava/lang/Object;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/DisplaySettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/Telephony$Mms;-query-(Landroid/content/ContentResolver; [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Landroid/webkit/WebView;-access$9400-(Landroid/webkit/WebView;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/AlbumBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasOutboxService;-searchGal-(Landroid/content/Context; J Ljava/lang/String;)Lcom/android/exchange/provider/GalResult;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-acknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter;-<init>-(Lcom/android/email/provider/EmailContent$Mailbox; Lcom/android/exchange/EasSyncService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/cooliris/wallpaper/RandomDataSource;-getBitmapForIndex-(Landroid/content/Context; I)Landroid/graphics/Bitmap;' : ['android.permission.INTERNET'],
	'Landroid/server/BluetoothA2dpService;-onConnectSinkResult-(Ljava/lang/String; Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Landroid/app/backup/BackupAgentHelper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/EditEvent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-access$000-(Lcom/android/internal/telephony/gsm/GsmConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-access$400-(Lcom/android/contacts/ContactsListActivity;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$StartingState;-enter-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebView;-setSelection-(I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/Launcher;-setWallpaperDimension-()V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/deskclock/AlarmKlaxon;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-getLastPdpFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/google/GoogleSettings;-storeShowWebSuggestionsPreference-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/google/android/mms/pdu/PduPersister;-updateHeaders-(Landroid/net/Uri; Lcom/google/android/mms/pdu/SendReq;)V' : ['android.permission.READ_SMS'],
	'Landroid/net/ThrottleManager;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactOptionsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/UnderdevelopedSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/location/GpsLocationProvider;-requestSetID-(I)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/nfc/NfcService$3;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Landroid/speech/SpeechRecognizer;-startListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/browser/BrowserBookmarksAdapter;-deleteRow-(I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/DayActivity;-goTo-(Landroid/text/format/Time; Z)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/email/Controller$LegacyListener;-loadAttachmentFinished-(J J J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler$2;-run-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/EasAuthenticatorServiceAlternate;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService$ScoClient;-requestScoState-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/contacts/ContactsProvider2;-getType-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/ui/ContactsPreferences;-setSortOrder-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Lcom/android/email/activity/AccountShortcutPicker;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/sip/SipService;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/commands/pm/Pm;-run-([Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteMessagesForThread-(Landroid/content/Context; J I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/ContactsListActivity;-callSelection-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/PatternUnlockScreen$UnlockPatternListener;-onPatternDetected-(Ljava/util/List;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/CallDetailActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-setMute-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$3;-getRemoteSocketRw-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/IccFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-connectHeadset-(Landroid/bluetooth/HeadsetBase; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/soundrecorder/Recorder;-setState-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-startRunning-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/pinyin/SettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/Connectivity$9;-onClick-(Landroid/view/View;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/fuelgauge/PowerUsageDetail;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ConfirmLockPattern;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/MessageListAdapter$OnDataSetChangedListener;-onContentChanged-(Lcom/android/mms/ui/MessageListAdapter;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/SlideEditorActivity;-access$400-(Lcom/android/mms/ui/SlideEditorActivity;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$BluetoothPhoneState;-<init>-(Lcom/android/phone/BluetoothHandsfree; Lcom/android/phone/BluetoothHandsfree$1;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/InCallScreen;-onCreatePanelView-(I)Landroid/view/View;' : ['android.permission.BLUETOOTH'],
	'Landroid/service/urlrenderer/UrlRendererService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/calendar/CalendarAppWidgetProvider;-performUpdate-(Landroid/content/Context; [I [J Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-pairingAttempt-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/LocationManagerService;-_getProviderInfoLocked-(Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/os/IPowerManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleMultipartyIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/ILlcpSocket$Stub;-receive-(I [B)I' : ['android.permission.NFC'],
	'Lcom/android/music/MediaPlaybackActivity$10;-onRepeat-(Landroid/view/View; J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/ConnectivityService;-enforceChangePermission-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handlePollCalls-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/voice/VoiceInput;-<init>-(Landroid/content/Context; Lcom/android/inputmethod/voice/VoiceInput$UiListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-<init>-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/certinstaller/CertFile;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$AccountAnalyzer;-start-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/cooliris/media/RootLayer;-update-(Lcom/cooliris/media/RenderView; F)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Tab;-resume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth;-setPairingConfirmation-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MessageView$ControllerResults;-loadAttachmentCallback-(Lcom/android/email/mail/MessagingException; J J I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/util/WeakAsyncTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/certinstaller/CertInstallerMain;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/PackageManagerService$AppDirObserver;-onEvent-(I Ljava/lang/String;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/PackageManagerService;-updateExternalMediaStatusInner-(Z Z)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/calendar/DayView;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/BrowserActivity;-pauseWebViewTimers-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/backup/IRestoreSession$Stub;-getAvailableRestoreSets-(Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/statusbar/IStatusBarService;-expand-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/mms/ui/ViewInterface;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/ContentLoader;-sendData-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-sendTerminalResponse-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/WifiService;-updateTetherState-(Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/fuelgauge/BatteryHistoryDetail;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/model/EntitySet;-buildDiff-()Ljava/util/ArrayList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/WeekView;-setSelectedDay-(Landroid/text/format/Time;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/mms/data/WorkingMessage;-readDraftMmsMessage-(Landroid/content/Context; J Ljava/lang/StringBuilder;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-storeMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/widget/LockPatternUtils;-setTactileFeedbackEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/Controller$Result;-updateMailboxCallback-(Lcom/android/email/mail/MessagingException; J J I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-conference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/IP2pTarget;-transceive-(I [B)[B' : ['android.permission.NFC'],
	'Lcom/android/phone/PhoneApp;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/SIMFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-setPropertyBoolean-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/os/IHardwareService$Stub;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/development/AccountsTester;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/EditEvent;-onBackPressed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/CalendarActivity$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/LocalePicker;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/IP2pTarget$Stub$Proxy;-disconnect-(I)Z' : ['android.permission.NFC'],
	'Lcom/android/phone/FdnList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Landroid/accounts/AccountManager$1;-doWork-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/ADNList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebView$ScaleDetectorListener;-onScale-(Landroid/view/ScaleGestureDetector;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/soundrecorder/Recorder;-clear-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/SyncActivityTooManyDeletes;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/CellBroadcastSms;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/PushReceiver$ReceivePushTask;-doInBackground-([Landroid/content/Intent;)Ljava/lang/Void;' : ['android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothAdapter;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ui/ShowOrCreateActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/vpn/VpnTypeSelection;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/SyncManager$6;-onServiceChanged-(Landroid/content/SyncAdapterType; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/tts/TtsService;-speak-(Ljava/lang/String; Ljava/lang/String; I Ljava/util/ArrayList;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/WorkingMessage;-loadDraft-(Lcom/android/mms/ui/ComposeMessageActivity; Lcom/android/mms/data/Conversation;)Lcom/android/mms/data/WorkingMessage;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/media/AudioService$AudioHandler;-persistVolume-(Landroid/media/AudioService$VolumeStreamState; Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/DebugIntentSender;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiInfo;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Browser;-addSearchUrl-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/sip/SipCallBase;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-resume-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/SyncManager;-done-(Lcom/android/exchange/AbstractSyncService;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewCore;-viewSizeChanged-(I I I F I I Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/BluetoothService;-onCreatePairedDeviceResult-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MessageView;-access$2200-(Lcom/android/email/activity/MessageView; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/SlidingTab$OnTriggerListener;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/SyncManager;-stopManualSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-startQuery-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MusicUtils;-clearQueue-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/svox/pico/DownloadVoiceData;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/SyncManager;-access$700-(Landroid/content/SyncManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-removeBatch-(Lcom/android/bluetooth/opp/BluetoothOppBatch;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothService;-setPairingConfirmation-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebView;-performLongClick-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/INfcAdapter;-getLlcpInterface-()Landroid/nfc/ILlcpSocket;' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DevelopmentSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/WebView;-access$1600-(Landroid/webkit/WebView; Landroid/graphics/Canvas;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/mail/store/LocalStore;-autoDiscover-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/RadioInfo;-access$3400-(Lcom/android/settings/RadioInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/PrivacySettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/PhoneUtils;-mergeCalls-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/SetAlarm;-access$1000-(Lcom/android/deskclock/SetAlarm;)J' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/TetherSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/TransactionService$ServiceHandler;-processTransaction-(Lcom/android/mms/transaction/Transaction;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/browser/BrowserHistoryPage;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/VideoView;-release-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/FullBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ui/EditContactActivity$DeleteClickListener;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/util/HierarchicalStateMachine$HsmHandler;-access$2100-(Lcom/android/internal/util/HierarchicalStateMachine$HsmHandler;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/quicksearchbox/google/GoogleSearch;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/AccessibilityManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelope-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/BatteryInfo;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telephony/gsm/SmsManager;-getAllMessagesFromSim-()Ljava/util/ArrayList;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/email/service/IEmailService$Stub;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/sip/SipSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/SelectCalendarsAdapter;-doSaveAction-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/ApnEditor;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth;-getBondState-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/NfcService$2;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/ByteStreams;-getChecksum-(Lcom/google/common/io/InputSupplier; Ljava/util/zip/Checksum;)J' : ['android.permission.INTERNET'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/DeviceInfoSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-deleteSelection-(I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/IAccountManager;-addAccount-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/SettingsSafetyLegalActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiEnabler;-handleStateChanged-(Landroid/net/NetworkInfo$DetailedState;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/DateTimeSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/MediaPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/SoundRecorder;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/IccLockSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothHeadset;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/util/AccountSelectionUtil;-getSelectAccountDialog-(Landroid/content/Context; I)Landroid/app/Dialog;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/nfc/INfcAdapter;-getP2pInitiatorInterface-()Landroid/nfc/IP2pInitiator;' : ['android.permission.NFC'],
	'Landroid/app/ActivityManagerNative;-setDebugApp-(Ljava/lang/String; Z Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.SET_DEBUG_APP'],
	'Lcom/android/server/StatusBarManagerService;-expand-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/providers/calendar/CalendarDebug$FetchInfoTask;-doInBackground-([Ljava/lang/Void;)Ljava/util/List;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/camera/Camera;-surfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/SmsReceiverService;-replaceMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-acceptIncomingConnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/setup/AccountSetupOutgoing;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-afterTextChanged-(Landroid/text/Editable;)V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/Tab$2;-onReceivedHttpAuthRequest-(Landroid/webkit/WebView; Landroid/webkit/HttpAuthHandler; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService$3;-getRemoteSocketMiu-(I)I' : ['android.permission.NFC'],
	'Lcom/android/calendar/EditEvent;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/NfcService$7;-receive-(I)[B' : ['android.permission.NFC'],
	'Lcom/android/camera/Camera$8;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHeadsetService;-access$1500-(Lcom/android/phone/BluetoothHeadsetService; Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/deskclock/AlarmAlert;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/PermissionDetails;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/LegacyContactImporter;-importContacts-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/cooliris/media/RenderView;-<init>-(Landroid/content/Context;)V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/ui/QuickContactWindow;-show-(Landroid/net/Uri; Landroid/graphics/Rect; I [Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Lcom/cooliris/media/RootLayer;-renderOpaque-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Landroid/accounts/AccountManagerService;-checkAuthenticateAccountsPermission-(Landroid/accounts/Account;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppService$UpdateThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/test/TestListActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebViewCore;-sendMessage-(I I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/http/RequestHandle;-setupRedirect-(Ljava/lang/String; I Ljava/util/Map;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/InCallScreen;-updateScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/app/NetInitiatedActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ClassZeroActivity$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/voicedialer/VoiceContact;-redialNumber-(Landroid/app/Activity;)Ljava/lang/String;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/phone/NetworkQueryService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiConfigInfo;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/defcontainer/DefaultContainerService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-pokeWakelock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/accounts/AccountManager$GetAuthTokenByTypeAndFeaturesTask;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/camera/Camera;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/AgendaWindowAdapter$QueryHandler;-processNewCursor-(Lcom/android/calendar/AgendaWindowAdapter$QuerySpec; Landroid/database/Cursor;)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/app/RingtonePickerActivity;-stopAnyPlayingRingtone-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/SettingsSafetyLegalActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/calendar/CalendarProvider2;-modifyCalendarSubscription-(J Z)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/development/EnterURL;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-callContact-(Landroid/database/Cursor;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/SyncManager;-access$1100-(Lcom/android/exchange/SyncManager; J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/ProcessInfo;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/TabControl;-pauseCurrentTab-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/PackageManagerService;-replacePackageLI-(Landroid/content/pm/PackageParser$Package; I I Ljava/lang/String; Lcom/android/server/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/sip/ISipService;-open-(Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/SearchResultsActivity;-onRestart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Landroid/app/ExpandableListActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/NfcService$3;-send-(I [B)I' : ['android.permission.NFC'],
	'Landroid/net/IConnectivityManager$Stub;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactOptionsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$22;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/CallDetailActivity;-updateData-(Landroid/net/Uri;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetoothHeadset;-stopVoiceRecognition-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-acknowledgeProvisionImpl-(Ljava/lang/String; Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserBookmarksPage$4;-onClick-(Landroid/content/DialogInterface; I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NotificationManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE'],
	'Landroid/accounts/AccountAuthenticatorActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/AlarmKlaxon;-startAlarm-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/BackupAgentHelper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onEnableApn-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-next-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WifiService;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/browser/WebsiteSettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Calendar$Calendars;-deleteCalendarsForAccount-(Landroid/content/ContentResolver; Landroid/accounts/Account;)I' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/app/ActivityManagerNative;-handleApplicationWtf-(Landroid/os/IBinder; Ljava/lang/String; Landroid/app/ApplicationErrorReport$CrashInfo;)Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$1;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/inputmethod/voice/VoiceInput;-startListening-(Lcom/android/inputmethod/voice/FieldContext; Z)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/server/PackageManagerService;-access$2100-(Lcom/android/server/PackageManagerService; Lcom/android/server/PackageManagerService$InstallArgs; Z Lcom/android/server/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-getBatteryUsageHint-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-getSummary-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-setSuppServiceNotifications-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/NetworkQueryService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WifiService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MediaPlaybackService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/WeekView;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/http/EventHandler;-headers-(Landroid/net/http/Headers;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/SlideEditorActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/WindowManagerPolicy;-detectSafeMode-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/development/PointerLocation;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-isDuplicateMessage-(Landroid/content/Context; Lcom/google/android/mms/pdu/RetrieveConf;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$200-(Lcom/android/mms/transaction/SmsReceiverService;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/PushReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/UserDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/mms/transaction/Transaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/EventLoader$LoadEventsRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/backup/IRestoreSession;-restorePackage-(Ljava/lang/String; Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/CalendarView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/IccLockSettings;-tryChangePin-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$8;-run-()V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/WebView;-goBackOrForward-(I Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/soundrecorder/SoundRecorder;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/RIL;-setGsmBroadcastConfig-([Lcom/android/internal/telephony/gsm/SmsBroadcastConfigInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/Camera;-initializeSecondTime-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/IMediaPlaybackService;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/MessagingNotification;-access$200-(Landroid/content/Context; Landroid/content/Intent; Ljava/lang/String; I Z Ljava/lang/CharSequence; J Ljava/lang/String; I I)V' : ['android.permission.VIBRATE'],
	'Landroid/provider/Calendar$EventsEntity$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/RecentCallsListActivity;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-addWord-(Ljava/lang/String; I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-readAdnFileAndWait-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/SoundRecorder$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$BondedDevice;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-<init>-(Landroid/content/Context; Lcom/android/server/ConnectivityService$1;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$28;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onUuidChanged-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothAtPhonebook;-queryPhonebook-(Ljava/lang/String; Lcom/android/phone/BluetoothAtPhonebook$PhonebookResult;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/ui/QuickContactWindow;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebSettings;-setDefaultZoom-(Landroid/webkit/WebSettings$ZoomDensity;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$1;-pokeWakelock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/deskclock/SetAlarm$7;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager;-requestRouteToHost-(I I)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/nfc/RawTagConnection;-attemptDeadServiceRecovery-(Ljava/lang/Exception;)V' : ['android.permission.NFC'],
	'Lcom/android/phone/BluetoothHandsfree$14;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/TouchInterceptor;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AgendaActivity$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/location/ILocationManager$Stub;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/LockPatternView;-detectAndAddHit-(F F)Lcom/android/internal/widget/LockPatternView$Cell;' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE'],
	'Lcom/android/phone/EmergencyCallbackModeExitDialog;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/MessageView;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelPairingUserInput-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/downloads/DownloadInfo;-isReadyToStart-(J)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/TrackBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-processStartTimedOutLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-moveItem-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallTouchUi;-updateState-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/AccountsTester$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/BluetoothHandsfree$29;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/MediaFormat;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/ISyncAdapter;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/providers/downloads/DownloadService;-access$700-(Lcom/android/providers/downloads/DownloadService; Lcom/android/providers/downloads/DownloadInfo$Reader; Lcom/android/providers/downloads/DownloadInfo; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-access$000-(Lcom/android/server/am/ActivityManagerService; Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Landroid/content/Intent; Ljava/lang/String; Landroid/content/IIntentReceiver; I Ljava/lang/String; Landroid/os/Bundle; Ljava/lang/String; Z Z I I)I' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/AudioManager;-stopBluetoothSco-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setLine1Number-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothA2dp;-connectSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/SipCallOptionHandler;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/AddAccountSettings;-addAccount-(Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideViewInterface;-startAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ShutdownThread;-rebootOrShutdown-(Z Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/browser/BrowserActivity$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity$GreetingRunnable;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/WeekActivity;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/accounts/AccountManagerService;-confirmCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/webkit/WebView;-zoomWithPreview-(F Z)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/SystemBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/ui/MessageListAdapter$AvatarCache$ContactData;-access$400-(Lcom/android/mms/ui/MessageListAdapter$AvatarCache$ContactData; Landroid/database/Cursor; I I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/vpn/L2tpIpsecService;-onError-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifySendFailed-(Landroid/content/Context; Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SMS'],
	'Lcom/android/server/RecognitionManagerService;-systemReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/WindowManagerPolicy;-init-(Landroid/content/Context; Landroid/view/IWindowManager; Landroid/os/LocalPowerManager;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/MusicPicker;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/ApplicationSettings;-setNonMarketAppsAllowed-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/VideoCamera;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;-start-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/CallFeaturesSetting;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebTextView;-setType-(I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Settings$Bookmarks;-add-(Landroid/content/ContentResolver; Landroid/content/Intent; Ljava/lang/String; Ljava/lang/String; C I)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/vpn/L2tpService;-checkConnectivity-()Z' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/FdnList;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/model/EntityDelta;-buildAssert-(Ljava/util/ArrayList;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/os/IVibratorService$Stub$Proxy;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-cleanUpConnection-(Z Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/RenamePlaylist;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasSyncService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/telephony/TelephonyProvider;-checkPermission-()V' : ['android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-startQuery-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/voice/VoiceInput$UiListener;-onVoiceResults-(Ljava/util/List; Ljava/util/Map;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/webkit/WebTextView;-lineUpScroll-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/Welcome;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager$Stub;-clearTestProviderStatus-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/net/sip/SipAudioCall;-setSpeakerMode-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/connectivity/Tethering;-updateUsbStatus-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/IAudioService$Stub$Proxy;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/ApplicationSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/PhoneUtils;-startGetCallerInfo-(Landroid/content/Context; Lcom/android/internal/telephony/Connection; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/phone/PhoneUtils$CallerInfoToken;' : ['android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onCleanUpConnection-(Z Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor$SimStateCallback;-onSimStateChanged-(Lcom/android/internal/telephony/IccCard$State;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/webkit/WebView;-drawCoreAndCursorRing-(Landroid/graphics/Canvas; I Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/OtaUtils;-otaShowProgramFailureDialog-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/music/MediaPlaybackService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/SystemBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-getDrmMimeType-(J)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/IActivityManager;-moveTaskToFront-(I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/voicedialer/RecognizerEngine;-recognize-(Lcom/android/voicedialer/RecognizerClient; Landroid/app/Activity; Ljava/io/File; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/PowerManagerService;-releaseWakeLock-(Landroid/os/IBinder; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-connectHeadset-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/setup/AccountSettingsUtils;-commitSettings-(Landroid/content/Context; Lcom/android/email/provider/EmailContent$Account;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifyDownloadFailed-(Landroid/content/Context; J)V' : ['android.permission.VIBRATE', 'android.permission.READ_SMS'],
	'Lcom/android/development/AppPicker;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-access$1000-(Lcom/android/voicedialer/VoiceDialerActivity; I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/phone/FdnList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabControl;-removeTab-(Lcom/android/browser/Tab;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/EventLoader$LoadEventDaysRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/development/Connectivity$4;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/WallpaperManager;-setStream-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ActivityGroup;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager$Stub;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/EditPinPreference;-onDialogClosed-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onPress-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/CdmaSystemSelectListPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DebugIntentSender;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$23;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/WarnOfStorageLimitsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/vpn/PptpService;-onError-(Ljava/lang/Throwable;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/ChooseLockPattern;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CellBroadcastSms;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppManager;-enableBluetooth-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/CalendarView;-setSelectedDay-(Landroid/text/format/Time;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-startTethering-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/speech/SpeechRecognizer;-stopListening-()V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/net/http/RequestHandle;-setupAuthResponse-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-onUpdate-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; [I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$DebugThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/KeyguardViewProperties;-createKeyguardView-(Landroid/content/Context; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardWindowController;)Lcom/android/internal/policy/impl/KeyguardViewBase;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/DockObserver;-update-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageView$LoadMessageTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/os/IHardwareService$Stub$Proxy;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/email/activity/MessageList;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/email/MessagingListener;-synchronizeMailboxFinished-(J J I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIO-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-updateFromProvider-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MessageCompose;-processSourceMessage-(Lcom/android/email/provider/EmailContent$Message; Lcom/android/email/provider/EmailContent$Account;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-onResume-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/AccountPreferenceBase;-onPrepareOptionsMenu-(Landroid/view/Menu;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-trySetupData-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Landroid/app/IActivityManager;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/ViewContactActivity;-makeItemDefault-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-play-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/google/GoogleSource;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SuggestionCursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/soundrecorder/SoundRecorder;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/picasa/PicasaService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserActivity;-loadUrlDataIn-(Lcom/android/browser/Tab; Lcom/android/browser/BrowserActivity$UrlData;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/BrowserActivity;-closeDialogs-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/LauncherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/IEmailService;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/RingerVolumePreference;-onBindDialogView-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/ui/HeadUpDisplay$2;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/nfc/LlcpSocket;-getLocalSap-()I' : ['android.permission.NFC'],
	'Lcom/android/certinstaller/CertFileList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/DevelopmentSettings;-access$400-(Lcom/android/development/DevelopmentSettings;)V' : ['android.permission.SET_ALWAYS_FINISH', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManager;-addOnAccountsUpdatedListener-(Landroid/accounts/OnAccountsUpdateListener; Landroid/os/Handler; Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/SyncManager;-waitForConnectivity-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewManager$KeyguardViewHost;-dispatchDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/providers/contacts/ContactsProvider2;-openAssetFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/content/res/AssetFileDescriptor;' : ['android.permission.READ_CONTACTS'],
	'Landroid/content/pm/PackageManager;-getPackageSizeInfo-(Ljava/lang/String; Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/NetworkManagementService;-getInterfaceRxThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/AccountSyncSettingsInAddAccount;-updateAuthDescriptions-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-stopAccessPoint-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/BluetoothHandsfree;-access$4600-(Lcom/android/phone/BluetoothHandsfree;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/speechrecorder/SpeechRecorderActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity;-scanForward-(I J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothHeadset;-stopVoiceRecognition-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/Tab$3;-onCloseWindow-(Landroid/webkit/WebView;)V' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/cooliris/media/GridLayer;-update-(Lcom/cooliris/media/RenderView; F)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/IContentService;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/accounts/AccountManager$2;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-getWifiEnabledState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/service/EasAuthenticatorService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/AccountPreferenceBase;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-disconnect-(Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$Profile;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DisplaySettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.SET_ANIMATION_SCALE'],
	'Lcom/android/development/RunningProcesses;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ConversationList$6;-onKey-(Landroid/view/View; I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexClientSession;-start-(Landroid/os/Handler;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserActivity$SetAsWallpaper;-run-()V' : ['android.permission.SET_WALLPAPER', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/transaction/RetryScheduler;-getResponseStatus-(J)I' : ['android.permission.READ_SMS'],
	'Lcom/android/server/LocationManagerService;-_isProviderEnabledLocked-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/BluetoothAdapter;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/content/AbstractThreadedSyncAdapter$ISyncAdapterImpl;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/contacts/SearchResultsActivity;-smsContact-(Landroid/database/Cursor;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/quicksearchbox/google/GoogleSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/SetAlarm;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/tts/TtsService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/GsmUmtsAdditionalCallOptions;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/ClassZeroActivity;-access$200-(Lcom/android/mms/ui/ClassZeroActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/GsmUmtsCallForwardOptions;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/os/INetworkManagementService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-onRecordLoaded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppIncomingFileConfirmActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/content/ContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/development/DevelopmentSettings;-access$1900-(Lcom/android/development/DevelopmentSettings;)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-execute-(Lorg/apache/http/client/methods/HttpUriRequest;)Lorg/apache/http/HttpResponse;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnection;-start-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager$Stub;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/data/WorkingMessage;-loadFromUri-(Landroid/net/Uri;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/development/LogViewer;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/WebStorageSizeManager;-onReachedMaxAppCacheSize-(J J Landroid/webkit/WebStorage$QuotaUpdater;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/calendar/EventInfoActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/launcher2/DragController;-startDrag-(Landroid/view/View; Lcom/android/launcher2/DragSource; Ljava/lang/Object; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-refreshStats-()V' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/settings/AddAccountSettings;-onSyncStateUpdated-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Landroid/bluetooth/BluetoothSocket;-initSocketNative-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-createProfilePreference-(Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$Profile;)Landroid/preference/CheckBoxPreference;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebView;-sendViewSizeZoom-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebView$InvokeListBox$4;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IccFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/picasa/PicasaService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/Calendar$Instances;-query-(Landroid/content/ContentResolver; [Ljava/lang/String; J J Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/TwelveKeyDialer;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/ConnectivityManager;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/transaction/TransactionService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/music/MediaPlaybackActivity;-access$1100-(Lcom/android/music/MediaPlaybackActivity;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-sendPing-([B I)Lorg/apache/http/HttpResponse;' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/BackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserBackupAgent;-buildBookmarkFile-(Ljava/io/FileOutputStream;)J' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService$5;-receiveFrom-(I)Landroid/nfc/LlcpPacket;' : ['android.permission.NFC'],
	'Lcom/android/calendar/WeekView;-access$300-(Lcom/android/calendar/CalendarView;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/LauncherActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/TestActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-callOrSmsContact-(Landroid/database/Cursor; Z)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/PatternUnlockScreen$UnlockPatternListener;-onPatternCellAdded-(Ljava/util/List;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/app/ChooserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ui/QuickContactActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/TabActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothA2dpService;-<init>-(Landroid/content/Context; Landroid/server/BluetoothService;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/util/EmptyService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/TwelveKeyDialer;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-disconnect-()V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasOutboxService;-getAttachment-(Lcom/android/exchange/PartRequest;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-finishBooting-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-access$000-(Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/content/IContentService$Stub;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$People;-createPersonInMyContactsGroup-(Landroid/content/ContentResolver; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/MessagingController;-loadAttachment-(J J J J Lcom/android/email/MessagingListener;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/calendar/CalendarProvider2;-updateInTable-(Ljava/lang/String; Landroid/content/ContentValues; Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/DateTimeSettings;-setDateFormat-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/LatinIME;-onCreate-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/phone/EditFdnContactScreen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/AccountSyncSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-addPackageNames-(Ljava/util/Set;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/EditFdnContactScreen;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasOutboxService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserActivity$3;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/development/DataList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/model/MediaModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/music/MediaPlaybackActivity;-access$900-(Lcom/android/music/MediaPlaybackActivity; I J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/location/LocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/webkit/GeolocationService;-start-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth;-removeServiceRecord-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/SyncAdapterDriver;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/SystemAllowGeolocationOrigins;-start-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createConsentDialog-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-onStart-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/AccountPreferenceBase;-updateAuthDescriptions-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/policy/impl/LockScreen;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/music/CreatePlaylist;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$28;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/INfcAdapter$Stub;-createLlcpServiceSocket-(I Ljava/lang/String; I I I)I' : ['android.permission.NFC'],
	'Lcom/android/providers/media/MediaScannerService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/IEmailService$Stub;-validate-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I Z Z)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ManageAccountsSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestionsExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/NotificationPlayer;-access$700-(Lcom/android/server/NotificationPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/media/RingtoneManager;-setActualDefaultRingtoneUri-(Landroid/content/Context; I Landroid/net/Uri;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/AccountSyncSettingsInAddAccount;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/RenamePlaylist;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/stk/StkService;-handleProactiveCommand-(Lcom/android/internal/telephony/gsm/stk/CommandParams;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-setActive-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Tab$2;-shouldOverrideUrlLoading-(Landroid/webkit/WebView; Ljava/lang/String;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/TetherSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/UnderdevelopedSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/UriTexture;-writeHttpDataInDirectory-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-keyguardDoneDrawing-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/RingerVolumePreference;-onKey-(Landroid/view/View; I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManagerService;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/app/FullBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/Wallpaper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EmergencyCallbackModeService;-access$200-(Lcom/android/phone/EmergencyCallbackModeService; J)V' : ['android.permission.VIBRATE'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/wallpaper/WallpaperService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/deviceinfo/Status;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SearchResultsActivity;-getPeopleFilterUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-getUriToQuery-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/EasOutboxService;-validateAccount-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I Z Z Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToSim-(I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ProxySelector;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setAndBroadcastNetworkSetTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/content/ContentService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/DisplaySettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Telephony$Threads;-getOrCreateThreadId-(Landroid/content/Context; Ljava/util/Set;)J' : ['android.permission.READ_SMS'],
	'Lcom/android/email/service/EmailServiceProxy$2;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneFactory;-makeDefaultPhones-(Landroid/content/Context;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/IConnectivityManager$Stub;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/vpn/VpnService;-onConnect-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.VIBRATE'],
	'Landroid/content/IContentService;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/RepeatingImageButton$RepeatListener;-onRepeat-(Landroid/view/View; J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/ConfigurationViewer;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/HTML5VideoViewProxy$VideoPlayer$1;-onCustomViewHidden-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-onRestart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/SetAlarm;-onBackPressed-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/backup/IRestoreSession$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/IntentService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-cleanUpConnection-(Z Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/ActivityManagerNative;-killBackgroundProcesses-(Ljava/lang/String;)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/server/NetworkManagementService;-enableNat-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ISms$Stub;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/policy/impl/LockScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/server/BluetoothService;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/quicklaunch/BookmarkPicker;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityManagerService;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/svox/pico/EngineSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth;-readOutOfBandData-()[B' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$16;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothHeadset;-getCurrentHeadset-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CallerInfo;-markAsVoiceMail-()Lcom/android/internal/telephony/CallerInfo;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/ChooseLockGeneric;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserActivity;-loadUrl-(Landroid/webkit/WebView; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/telephony/TelephonyManager;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/BluetoothServerSocket;-<init>-(I Z Z I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery$CallerInfoAsyncQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.VIBRATE'],
	'Lcom/android/exchange/EasSyncService;-parsePingResult-(Ljava/io/InputStream; Landroid/content/ContentResolver; Ljava/util/HashMap;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallNotifier;-sendMwiChangedDelayed-(J)V' : ['android.permission.VIBRATE'],
	'Landroid/app/backup/BackupAgent;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-<init>-(Lcom/android/email/provider/EmailContent$Mailbox; Lcom/android/exchange/EasSyncService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/widget/SlidingTab;-dispatchTriggerEvent-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/LoadListener;-error-(I Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/stk/IconLoader;-loadIcon-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/VolumePanel;-onShowVolumeChanged-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/sip/SipCommandInterface;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/EditSlideDurationActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/AudioPreview;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/PackageManager;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/server/UsbObserver;-systemReady-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/quicksearchbox/ChoiceActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accessibilityservice/AccessibilityService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/MediaPlayer;-resume-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-access$1900-(Landroid/server/BluetoothService; Ljava/lang/String;)Landroid/bluetooth/BluetoothDeviceProfileState;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/google/common/io/Files;-copy-(Lcom/google/common/io/InputSupplier; Ljava/io/File; Ljava/nio/charset/Charset;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/IccRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ViewContactActivity;-setupContactCursor-(Landroid/content/ContentResolver; Landroid/net/Uri;)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/IccProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ConfirmLockPattern;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/picasa/GDataClient;-callMethod-(Lorg/apache/http/client/methods/HttpUriRequest; Lcom/cooliris/picasa/GDataClient$Operation;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/widget/RotarySelector;-dispatchTriggerEvent-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/content/SyncManager$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setPin-(Ljava/lang/String; [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/MessagingNotification;-getDownloadFailedMessageCount-(Landroid/content/Context;)I' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/EditFdnContactScreen;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/SettingsLicenseActivity$1;-onReceivedHttpAuthRequest-(Landroid/webkit/WebView; Landroid/webkit/HttpAuthHandler; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/AccountFolderList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/TimeConsumingPreferenceActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CallNotifier;-showIncomingCall-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/latin/AutoDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/webkit/WebTextView;-onScrollChanged-(I I I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/TetherSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipAudioCall;-access$700-(Landroid/net/sip/SipAudioCall; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/soundrecorder/Recorder;-restoreState-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DateTimeSettings;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/connectivity/Tethering;-<init>-(Landroid/content/Context; Landroid/os/Looper;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setPowerStateToDesired-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateTracker;-access$800-(Landroid/net/wifi/WifiStateTracker;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/ThrottleService$DataRecorder;-addData-(J J)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/ConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Ljava/lang/Appendable;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/PhoneProxy;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/provider/Settings$Secure;-putLong-(Landroid/content/ContentResolver; Ljava/lang/String; J)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/SimContacts;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ConnectivityService;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/CalendarPreferenceActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/Vibrator;-vibrate-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/settings/LocalePicker;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-update-(I J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPlaybackActivity;-scanBackward-(I J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/content/SyncManager$SyncHandler;-runStateSyncing-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/phone/EmergencyCallbackModeExitDialog;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/ContactHeaderWidget;-bindFromPhoneNumber-(Ljava/lang/String;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendMultipartSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ISyncAdapter$Stub;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-init-(Landroid/content/Context; Landroid/view/IWindowManager; Landroid/os/LocalPowerManager;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/LaunchActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ConnectivityService;-handleInetConditionHoldEnd-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService;-isTetheringStarted-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-processUnsolicited-(Landroid/os/Parcel;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/sip/SipSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/contacts/ContactsListActivity;-access$1000-(Lcom/android/contacts/ContactsListActivity; Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performHapticFeedbackLw-(Landroid/view/WindowManagerPolicy$WindowState; I Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-cancelPairingUserInput-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/ActivityManagerNative;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/phone/FdnSetting;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/AlarmClock;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/UpgradeAccounts;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-createLlcpSocket-(I I I I)I' : ['android.permission.NFC'],
	'Lcom/cooliris/media/MenuBar;-update-(Lcom/cooliris/media/RenderView; F)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DeleteEventHelper$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-requestUpdateBluetoothIndication-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/Connectivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/sip/SipSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/RetryScheduler;-update-(Lcom/android/mms/transaction/Observable;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/server/LocationManagerService$Receiver;-callStatusChangedLocked-(Ljava/lang/String; I Landroid/os/Bundle;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/InputLanguageSelection;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/os/INetworkManagementService$Stub;-stopAccessPoint-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/tts/TtsService;-access$3100-(Landroid/tts/TtsService; Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM;-<init>-(Lcom/android/server/connectivity/Tethering; Ljava/lang/String; Landroid/os/Looper; Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Contacts$Settings;-getSetting-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/DockService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-access$000-(Lcom/android/deskclock/AlarmAlertFullScreen;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/webkit/WebView;-displaySoftKeyboard-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/SyncManager;-shutdown-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-turnOnMobileConnection-()I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebView;-contentSizeChanged-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/ShutdownThread;-shutdown-(Landroid/content/Context; Z)V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isBusy-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/ContactOptionsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/Alarms;-enableSnoozeAlert-(Landroid/content/Context;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/data/Conversation$2;-run-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/app/ResolverActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsListActivity;-onStart-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/cooliris/media/PicasaDataSource;-loadMediaSets-(Lcom/cooliris/media/MediaFeed;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/EventInfoActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/BrowserBackupAgent;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/svox/pico/CheckVoiceData;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/providers/downloads/ui/DownloadList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSetupCheckSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onScreenTurnedOff-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/NotificationPlayer;-enqueueLocked-(Lcom/android/server/NotificationPlayer$Command;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/GridLayer;-startSlideshow-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-restoreMuteState-()Ljava/lang/Boolean;' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/preference/VolumePreference;-onSampleStarting-(Landroid/preference/VolumePreference$SeekBarVolumizer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService;-startUsbRNDIS-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/AgendaWindowAdapter;-queueQuery-(Lcom/android/calendar/AgendaWindowAdapter$QuerySpec;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-onConnectivityChanged-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DeviceAdminAdd;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/AccessibilitySettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/NotificationMgr;-updateCfi-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/defcontainer/DefaultContainerService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getSinkPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHeadsetService;-onDestroy-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onPollPdp-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/internal/app/PlatLogoActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SearchResultsActivity;-checkProviderState-(Z)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/EventInfoActivity;-onPause-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/app/ResolverActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/Browser;-getVisitedLike-(Landroid/content/ContentResolver; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/exchange/EasSyncService;-searchGal-(Landroid/content/Context; J Ljava/lang/String;)Lcom/android/exchange/provider/GalResult;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/TextToSpeechSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/widget/BookmarkWidgetService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/ISipService$Stub;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/development/UnderdevelopedSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/WeekSelector;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/EditEvent$QueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/Settings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/LocationManagerService;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/music/MediaPlaybackActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS'],
	'Landroid/test/mock/MockContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/deskclock/SetAlarm;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/spare_parts/SpareParts;-writeEndButtonPreference-(Ljava/lang/Object;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/applications/ApplicationsState;-requestSize-(Ljava/lang/String;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$HeadsetProfileManager;-getConnectionStatus-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/RingtonePickerActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothEventLoop;-checkPairingRequestAndGetAddress-(Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onBtClassChanged-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothHeadset;-connectHeadset-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/media/MovieView;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService;-getInterfaceRxCounter-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/sip/SipManager;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/phone/FdnSetting;-updatePINChangeState-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getAuthToken-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Z Landroid/os/Bundle;)V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/ImageButton;-update-(Lcom/cooliris/media/RenderView; F)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageCompose;-onDestroy-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-setSettingIfNotSet-(Ljava/lang/String; Landroid/net/Uri; J)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-handleFileUpdate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarActivity$CalendarGestureListener;-onFling-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/FdnSetting;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/ContentLoader;-setupStreamAndSendStatus-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/CalendarActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/DevicePolicyManagerService;-wipeDataLocked-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setNotification-(I)V' : ['android.permission.VIBRATE'],
	'Landroid/app/FullBackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneUtils;-answerAndEndHolding-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/browser/WebsiteSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/RotarySelector;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-attemptAutoPair-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/WindowManagerPolicy;-screenTurnedOn-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/EmergencyCallbackModeService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/Connection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-maybeEnableFallback-(Landroid/content/Context;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/sip/SipAudioCall;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getReportItems-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/stk/IconLoader;-readIconData-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CdmaSystemSelectListPreference$MyHandler;-handleQueryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/WeekView;-initNextView-(I)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/BluetoothHandsfree$4;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$People;-tryGetMyContactsGroupId-(Landroid/content/ContentResolver;)J' : ['android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiManager;-addNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/deskclock/Alarms;-addAlarm-(Landroid/content/Context; Lcom/android/deskclock/Alarm;)J' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangupConnectionByIndex-(Lcom/android/internal/telephony/cdma/CdmaCall; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/tts/TtsService$1;-stop-(Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/TabControl;-resumeCurrentTab-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/EmergencyDialer;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/Camera;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHeadsetService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-haveEmailContact-(Ljava/lang/String;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$HeadsetProfileManager;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/LocationManagerService$SettingsObserver;-update-(Ljava/util/Observable; Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Service;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-setProcessLimit-(I)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Landroid/media/MediaPlayer;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getIMSI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-connectHeadset-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasOutboxService;-sendHttpClientPost-(Ljava/lang/String; [B)Lorg/apache/http/HttpResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/util/DownloadManager;-markState-(Landroid/net/Uri; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/EditPinPreference$OnPinEnteredListener;-onPinEntered-(Lcom/android/settings/EditPinPreference; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StopTetheringErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppLiveFolder;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/SimCard;-getIccCardStatusDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/DayView;-dispatchPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Landroid/os/storage/IMountService$Stub;-getStorageUsers-(Ljava/lang/String;)[I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToRuim-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-enqueue-([J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SearchResultsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-dumpDomTree-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/AccountBackupRestore;-backupAccounts-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getNonDisconnectedSinks-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$18;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/app/RingtonePickerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/WallpaperManager;-clear-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebTextView;-onEditorAction-(I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onCleanUpConnection-(Z Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$15;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-getRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/nfc/P2pInitiator;-receive-()[B' : ['android.permission.NFC'],
	'Landroid/accounts/AccountManagerService;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/email/service/IEmailService$Stub$Proxy;-autoDiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiSettings;-enableNetworks-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/music/DeleteItems;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/picasa/PicasaService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Landroid/content/SyncResult;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/gsm/GsmCallTracker; Lcom/android/internal/telephony/gsm/GsmCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/LauncherApplication;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/ConnectivityManager;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/DeleteItems;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/AddBookmarkPage$SaveBookmarkRunnable;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/IccFileHandler;-updateEFTransparent-(I [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/picasa/PicasaService;-requestSync-(Landroid/content/Context; I J)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/ChooseLockPatternTutorial;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/RunningProcesses;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/UserDictionarySettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService;-setAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/launcher2/LauncherApplication;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/cache/CacheService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-<init>-(Landroid/content/Context; Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/LocalePickerInSetupWizard;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/RecentCallsListActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-createSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/ISipSessionListener;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/PhoneProxy;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneInterfaceManager;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/media/IAudioService;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onVoiceCallStarted-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$5;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/util/AccountSelectionUtil;-doImportFromSdCard-(Landroid/content/Context; Landroid/accounts/Account;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/HeadsetObserver;-update-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ZonePicker;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/ILlcpSocket;-receive-(I [B)I' : ['android.permission.NFC'],
	'Lcom/android/phone/BluetoothHandsfree$25;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothProfileState$PendingCommandState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexServerSession;-onPut-(Ljavax/obex/Operation;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-connect-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handleCallWaitingInfo-(Lcom/android/internal/telephony/cdma/CdmaCallWaitingNotification;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DeviceStorageMonitorService;-access$000-(Lcom/android/server/DeviceStorageMonitorService; Z)V' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/model/TextModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; I Lcom/android/mms/drm/DrmWrapper; Lcom/android/mms/model/RegionModel;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/InputMethodManagerService$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/commands/bmgr/Bmgr;-doList-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/TextToSpeech;-synthesizeToFile-(Ljava/lang/String; Ljava/util/HashMap; Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/WorkingMessage;-load-(Lcom/android/mms/ui/ComposeMessageActivity; Landroid/net/Uri;)Lcom/android/mms/data/WorkingMessage;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/location/LocationManager;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/content/ContentService;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Ljava/net/HttpURLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/DisplaySettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/PlaylistBrowserActivity$1;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/DevelopmentSettings;-writeXmppOptions-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/app/DisableCarModeActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/BackupManagerService;-clearBackupData-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-startDtmf-(C)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserBookmarksAdapter;-updateRow-(Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/VoiceInputOutputSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/LoadListener;-handleHeaders-(Landroid/net/http/Headers;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-doQueuedBackups-(Lcom/android/internal/backup/IBackupTransport;)I' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/BrowserPreferencesPage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker$2;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/content/ContextWrapper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/deviceinfo/Status;-setWifiStatus-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/webkit/WebViewCore;-contentSpawnScrollTo-(I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-updateConfigurationLocked-(Landroid/content/res/Configuration; Lcom/android/server/am/ActivityRecord;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/phone/EditFdnContactScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub;-getBondState-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/ChangeIccPinScreen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$22;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/TelephonyRegistry;-notifyDataConnection-(I Z Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ui/ShowOrCreateActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/MobileDataStateTracker$MobileDataStateReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/InCallScreen;-updateInCallTouchUi-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-setLocationUpdates-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/webkit/GeolocationService;-registerForLocationUpdates-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DateTimeSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/PlaylistBrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/picasa/PicasaContentProvider;-syncUsers-(Landroid/content/SyncResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/development/MediaScannerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallScreen;-access$1100-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityStack;-activityPaused-(Landroid/os/IBinder; Landroid/os/Bundle; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addTestProvider-(Ljava/lang/String; Z Z Z Z Z Z Z I I)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-startDelayedRetry-(Lcom/android/internal/telephony/DataConnection$FailCause; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WindowManagerService$WindowState;-hideLw-(Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/server/ConnectivityService;-access$1400-(Lcom/android/server/ConnectivityService; Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/vpn/VpnService;-checkConnectivity-()Z' : ['android.permission.VIBRATE'],
	'Lcom/android/server/InputMethodManagerService;-buildInputMethodListLocked-(Ljava/util/ArrayList; Ljava/util/HashMap;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/LoadListener;-endData-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/wifi/WifiApSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-switchOutDrawHistory-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/calendar/CalendarProvider2;-insertInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/EventInfoActivity;-updateView-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/SyncManager;-stopAccountSyncs-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EnableFdnScreen;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasOutboxService;-doProgressCallback-(J J I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/LocalePickerInSetupWizard;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestionProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/Activity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothService;-removeBond-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub;-setPasskey-(Ljava/lang/String; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/tts/TtsService$1;-synthesizeToFile-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/svox/pico/CheckVoiceData;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer$1;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$2;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/MccTable;-updateMccMncConfiguration-(Lcom/android/internal/telephony/PhoneBase; Ljava/lang/String;)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/providers/calendar/CalendarReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/camera/VideoCamera$6;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneBase;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onBackPressed-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/PhoneUtils;-turnOnSpeaker-(Landroid/content/Context; Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/sip/SipEditor;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/NfcAdapter;-createRawTagConnection-(Landroid/nfc/Tag; Ljava/lang/String;)Landroid/nfc/RawTagConnection;' : ['android.permission.NFC'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/TwelveKeyDialer;-initVoicemailButton-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/OtaUtils;-onClickOtaActivateNextButton-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getMmsReportRequests-()Ljava/util/List;' : ['android.permission.READ_SMS'],
	'Landroid/content/IContentService$Stub$Proxy;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/vpn/VpnService;-access$400-(Lcom/android/server/vpn/VpnService;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/OtaUtils;-otaShowActivateScreen-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/MmsMessageSender;-sendReadRec-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/ManageConferenceUtils;-separateConferenceConnection-(I Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/ReceiverRestrictedContext;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/deviceinfo/Memory;-unmount-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/server/WindowManagerService;-<init>-(Landroid/content/Context; Lcom/android/server/PowerManagerService; Z Lcom/android/server/WindowManagerService$1;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/TetherSettings;-onCreateDialog-(I)Landroid/app/Dialog;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ConnectivityService;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/DataUsage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/stk/StkService;-<init>-(Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/gsm/SIMRecords; Landroid/content/Context; Lcom/android/internal/telephony/gsm/SIMFileHandler; Lcom/android/internal/telephony/gsm/SimCard;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebIconDatabase;-close-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/InputMethodManagerService;-chooseNewDefaultIMELocked-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/SipCallOptionHandler;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/IRestoreSession;-restoreAll-(J Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/webkit/WebViewCore;-contentScrollBy-(I I Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/MonthView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/model/EntityDelta;-buildDiff-(Ljava/util/ArrayList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/google/android/mms/util/AbstractCache;-put-(Ljava/lang/Object; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/GsmUmtsAdditionalCallOptions;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/CombinedBookmarkHistoryActivity$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-createIntent-(Landroid/content/Context; J)Landroid/content/Intent;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/AgendaActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/FakePhoneActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/Email;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/cooliris/media/GridInputProcessor;-touchEnded-(I I F)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/MessagingController$8;-run-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService$8;-transceive-(I [B)[B' : ['android.permission.NFC'],
	'Lcom/android/exchange/EasOutboxService;-sleep-(J Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-removeAccount-(Landroid/accounts/Account; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/ContentLoader;-closeStreamAndSendEndData-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree;-redial-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/os/storage/IMountService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Lcom/android/mms/ui/SlideshowPresenter$5;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/ChoiceActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/telephony/TelephonyManager;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/calendar/CalendarAppWidgetProvider;-onUpdate-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/RepeatingImageButton;-doRepeat-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/server/search/SearchManagerService$MyPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/os/INetworkManagementService;-getIpForwardingEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/INetworkManagementEventObserver;-interfaceLinkStatusChanged-(Ljava/lang/String; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/AppHwPref;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/EasAuthenticatorServiceAlternate;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/RecipientsAdapter;-runQueryOnBackgroundThread-(Ljava/lang/CharSequence;)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/AgendaWindowAdapter;-refresh-(Landroid/text/format/Time; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/development/DevelopmentSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/wallpaper/Slideshow;-getRandomBitmap-()Landroid/graphics/Bitmap;' : ['android.permission.INTERNET'],
	'Lcom/android/launcher2/LauncherApplication;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM;-start-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ISms;-updateMessageOnIccEf-(I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/webkit/WebView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/AgendaActivity;-access$100-(Lcom/android/calendar/AgendaActivity;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifySignalStrength-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MailboxList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneApp;-access$1000-(Lcom/android/phone/PhoneApp; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/MediaFormat;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-setDataSource-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MailboxList;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/downloads/DownloadThread;-executeDownload-(Lcom/android/providers/downloads/DownloadThread$State; Landroid/net/http/AndroidHttpClient; Lorg/apache/http/client/methods/HttpGet;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/wifi/WifiInfo;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/LocationManagerService;-loadProviders-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PasswordUnlockScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/webkit/WebViewCore$EventHub;-sendMessage-(Landroid/os/Message;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/util/DownloadManager$4;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CdmaSubscriptionListPreference$CdmaSubscriptionButtonHandler;-handleSetCdmaSubscriptionMode-(Landroid/os/Message;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/CursorEntityIterator;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$InitialState;-chooseUpstreamType-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/AlarmClock;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendCallLogVcards-(I Ljavax/obex/Operation; I I Z)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/EditEvent;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/ConfirmLockPattern;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SearchResultsActivity;-callSelection-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/nfc/NfcService$7;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Lcom/android/settings/deviceinfo/Status;-onResume-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAccountsByType-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/email/activity/MessageView;-access$1900-(Lcom/android/email/activity/MessageView; Lcom/android/email/provider/EmailContent$Message; Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/CellBroadcastSms;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/SimContacts;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/EditSlideDurationActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/CalendarSyncAdapterService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ViewContactActivity;-considerBindData-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree$24;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mms/transaction/SimFullReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Landroid/app/ActivityManager;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/content/ISyncContext$Stub$Proxy;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Landroid/net/sip/ISipService$Stub;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/email/MessagingController$7;-run-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/applications/InstalledAppDetails;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/DevelopmentSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-getAddressFromObjectPath-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/RecentCallsListActivity;-onResume-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ZonePicker;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/content/ContentService;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-startObexSession-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/EmergencyCallbackModeExitDialog;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/downloads/DownloadThread;-handleEndOfStream-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-deactivateDataCall-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarApplication;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/CallNotifier;-access$000-(Lcom/android/phone/CallNotifier; Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/applications/RunningServiceDetails;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/InCallScreen;-internalResolveIntent-(Landroid/content/Intent;)Lcom/android/phone/InCallScreen$InCallInitStatus;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManagerService;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/app/IActivityManager;-setAlwaysFinish-(Z)V' : ['android.permission.SET_ALWAYS_FINISH', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter;-getSyncKey-()Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneProxy;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/ui/EditContactActivity$4;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/LocationManagerService;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-addPackageNames-(Ljava/util/Set;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/IActivityManager;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/cooliris/cache/CacheService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/LockPatternUtils;-getSalt-()Ljava/lang/String;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/AlarmAlert;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/DataList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/SyncManager;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Landroid/webkit/WebIconDatabase$EventHandler;-access$900-(Landroid/webkit/WebIconDatabase$EventHandler; Landroid/os/Message;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageItem;-interpretFrom-(Lcom/google/android/mms/pdu/EncodedStringValue; Landroid/net/Uri;)V' : ['android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothA2dp;-getNonDisconnectedSinks-()Ljava/util/Set;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/sip/SipEditor$3;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/email/service/MailService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-setPin-(Ljava/lang/String; [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WifiService;-enforceChangePermission-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/webkit/WebViewCore$EventHub;-sendMessageDelayed-(Landroid/os/Message; J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/HTML5Audio;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ViewContactActivity;-buildEntries-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/app/ExpandableListActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebView;-setFocusControllerInactive-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Ljava/net/URLConnection;-getInputStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/server/LocationManagerService$Receiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/LoadListener;-handleSslError-(Landroid/net/http/SslError;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-clearShortcut-(C)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-disableNat-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/google/common/io/Files;-readFirstLine-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/IBluetoothA2dp;-getConnectedSinks-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/google/common/io/Files;-toByteArray-(Ljava/io/File;)[B' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/CommandsInterface;-getNeighboringCids-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContextWrapper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/telephony/TelephonyManager;-listen-(Landroid/telephony/PhoneStateListener; I)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/downloads/Helpers;-discardPurgeableFiles-(Landroid/content/Context; J)Z' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/settings/DeviceAdminSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$HeadsetProfileManager;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/media/AsyncPlayer;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ApnSettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/development/PackageSummary;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-initSeekBar-(Landroid/widget/SeekBar;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/LatinIME;-onText-(Ljava/lang/CharSequence;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/mms/ui/ManageSimMessages;-init-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/WifiManager;-setNumAllowedChannels-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/DockObserver;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/nfc/NdefTagConnection;-transceive-([B)[B' : ['android.permission.NFC'],
	'Lcom/android/calendar/EventInfoActivity;-access$000-(Lcom/android/calendar/EventInfoActivity;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/music/TrackBrowserActivity$4;-drop-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/IVibratorService$Stub;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker$ApnChangeObserver;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/exchange/AbstractSyncService;-validate-(Ljava/lang/Class; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I Z Z Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/KeyguardManager$KeyguardLock;-disableKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/location/ILocationManager;-getProviderInfo-(Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/DataConnection$DcInactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-isUsbRNDISStarted-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/data/WorkingMessage;-discard-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onDataSetupComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity$1;-onServiceConnected-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onNVReady-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/util/DraftCache;-rebuildCache-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MusicBrowserActivity$1;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/MediaScannerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/AtCommandHandler;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/pim/vcard/VCardComposer;-createOneEntry-()Z' : ['android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiStateTracker;-checkIsBluetoothPlaying-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/CandidateView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/phone/PhoneUtils;-setMuteInternal-(Lcom/android/internal/telephony/Phone; Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRadioAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/stk/StkService;-handleRilMsg-(Lcom/android/internal/telephony/gsm/stk/RilMessage;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewCore$3;-onReceiveValue-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/VideoBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/VoiceInputOutputSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebIconDatabase;-requestIconForPageUrl-(Ljava/lang/String; Landroid/webkit/WebIconDatabase$IconListener;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onBluetoothStateChanged-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IThrottleManager;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Contacts$People;-addToMyContactsGroup-(Landroid/content/ContentResolver; J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/DockObserver;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/AccessibilitySettings$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/ContactsProvider2;-importLegacyContacts-(Lcom/android/providers/contacts/LegacyContactImporter;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/NetworkSetting;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothService;-getTrustState-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-setCallForward-(I I I Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/VideoBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/ApnSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothService;-getBondState-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/MonthActivity;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/accessibilityservice/AccessibilityService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Lcom/android/settings/deviceinfo/Status;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/SyncManager$AccountObserver;-access$500-(Lcom/android/exchange/SyncManager$AccountObserver;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/Welcome;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/applications/ManageApplications;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SearchResultsActivity;-getJoinSuggestionsUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/vpn/VpnSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/PhoneInterfaceManager;-enforceCallPermission-()V' : ['android.permission.CALL_PHONE'],
	'Lcom/android/phone/InCallScreen$14;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebViewCore$EventHub;-access$6400-(Landroid/webkit/WebViewCore$EventHub; Landroid/os/Message;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ConversationList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Tab;-activateVoiceSearchMode-(Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/vpn/VpnSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NetworkManagementService;-access$200-(Lcom/android/server/NetworkManagementService; Ljava/lang/String; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BookmarkSearch;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/FakePhoneActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/ContactsProvider2;-initialize-()Z' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/Downloads$ById;-deleteDownload-(Landroid/content/Context; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingHandsfree;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/SearchResultsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/ConnectivityService;-handleConnect-(Landroid/net/NetworkInfo;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter$EasEmailSyncParser;-parse-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Landroid/app/AliasActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmAlert;-access$000-(Lcom/android/deskclock/AlarmAlertFullScreen;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternUtils;-setVisiblePatternEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothA2dp;-getSinkState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity$QueryGroupsTask;-doInBackground-(Ljava/lang/Object; [Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Landroid/app/Application;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$1;-goToUnlockScreen-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/Settings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/spare_parts/SpareParts;-writeFontSizePreference-(Ljava/lang/Object;)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Landroid/net/IConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/webkit/WebView;-loadData-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebView$ScaleDetectorListener;-onScaleBegin-(Landroid/view/ScaleGestureDetector;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/vpn/L2tpService;-onError-(Ljava/lang/Throwable;)V' : ['android.permission.VIBRATE'],
	'Landroid/nfc/INfcAdapter$Stub;-getP2pTargetInterface-()Landroid/nfc/IP2pTarget;' : ['android.permission.NFC'],
	'Lcom/android/settings/LanguageSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-access$200-(Lcom/android/server/am/ActivityManagerService; Z)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-setNetworkPreference-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/BrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/MediaPlayer;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/os/INetworkManagementService;-getInterfaceTxCounter-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/TextToSpeechSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/AlertActivity;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager;-getWifiState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/SimCard;-supplyPuk-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingHandsfree;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Landroid/widget/VideoView;-stopPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/phone/PhoneUtils;-restoreNoiseSuppression-(Landroid/content/Context;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/WifiService;-access$400-(Lcom/android/server/WifiService; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/webkit/BrowserFrame;-didFirstLayout-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/cooliris/wallpaper/Slideshow;-drawFrame-()V' : ['android.permission.INTERNET'],
	'Landroid/media/AudioService$AudioHandler$2;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/RenderView;-draw2D-(Lcom/cooliris/media/Texture; F F F F)V' : ['android.permission.INTERNET'],
	'Lcom/android/calendar/AlertService;-doTimeChanged-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/PhoneBase;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-createBond-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/app/PlatLogoActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/WebsiteSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/AppPicker;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatchPortAddressedPdus-([[B I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-disconnectSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/downloads/DownloadProvider;-checkInsertPermissions-(Landroid/content/ContentValues;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/deviceinfo/Memory;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/os/IDropBoxManagerService$Stub;-getNextEntry-(Ljava/lang/String; J)Landroid/os/DropBoxManager$Entry;' : ['android.permission.READ_LOGS'],
	'Landroid/content/pm/PackageManager;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/location/ILocationManager;-addGpsStatusListener-(Landroid/location/IGpsStatusListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-cancelPendingUssd-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/inputmethod/voice/VoiceInput;-cancel-()V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/server/BluetoothA2dpService;-connectSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/setup/AccountSecurity;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/util/DownloadManager;-getMessage-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/speech/tts/ITts$Stub$Proxy;-playEarcon-(Ljava/lang/String; Ljava/lang/String; I [Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ui/EditContactActivity$PersistTask;-doInBackground-(Lcom/android/contacts/ui/EditContactActivity; [Lcom/android/contacts/model/EntitySet;)Ljava/lang/Integer;' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getContactNamesByNumber-(Ljava/lang/String;)Ljava/util/ArrayList;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ZoneList;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-processDtmf-(C)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-addBluetoothUsage-(J)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/spare_parts/SpareParts;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/WapPushOverSms;-dispatchWapPdu_MMS-([B I I I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-startDtmf-(C Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$10;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothEventLoop;-onDiscoverServicesResult-(Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/AlarmInitReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendMultipartSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WindowManagerService;-startFreezingDisplayLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPickerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SplitAggregateView;-<init>-(Landroid/content/Context; Landroid/net/Uri;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-updateProgressbar-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calculator2/Calculator;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-setGsmBroadcastConfig-([Lcom/android/internal/telephony/gsm/SmsBroadcastConfigInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$A2dpProfileManager;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/MessageList$LoadMessagesTask;-onPostExecute-(Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/cooliris/media/GridInputProcessor;-onSingleTapUp-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/util/HierarchicalStateMachine$HsmHandler$HaltingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/Phone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/data/WorkingMessage$1;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/wifi/WifiInfo;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/Controller$12;-run-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/data/WorkingMessage;-clearConversation-(Lcom/android/mms/data/Conversation;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/server/BluetoothA2dpService;-onBluetoothEnable-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Landroid/app/ContextImpl;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager$Stub;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/commands/bmgr/Bmgr;-doEnable-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/ContactsListActivity$ContactItemListAdapter;-runQueryOnBackgroundThread-(Ljava/lang/CharSequence;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/LocationManagerService;-access$2000-(Lcom/android/server/LocationManagerService; Landroid/location/Location; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/tts/TtsService;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-setIccLockEnabled-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getSignalStrength-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager;-setAnimationScales-([F)V' : ['android.permission.SET_ANIMATION_SCALE'],
	'Lcom/android/phone/BluetoothHandsfree;-stopVoiceRecognition-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsListActivity;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/term/Term;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteFromTable-(Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/accounts/AccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/ContextWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/ChooseAccountActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/INfcAdapter;-getP2pTargetInterface-()Landroid/nfc/IP2pTarget;' : ['android.permission.NFC'],
	'Lcom/android/mms/data/Conversation;-startQueryHaveLockedMessages-(Landroid/content/AsyncQueryHandler; J I)V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHandsfree$20;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/downloads/DownloadThread;-notifyDownloadCompleted-(I Z I I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Ljava/net/URL;-openStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/inputmethod/latin/LatinIMESettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/ISipService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/webkit/DataLoader;-sendHeaders-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/stk/IconLoader;-postIcon-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/EventInfoActivity;-isDuplicateName-(Ljava/lang/String;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/cooliris/media/GridLayer;-changeFocusToNextSlot-(F)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/SetAlarm;-onTimeSet-(Landroid/widget/TimePicker; I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-checkStorageUsersAsync-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-stopVoiceRecognition-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/TrackBrowserActivity;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/speech/tts/ITts$Stub;-playEarcon-(Ljava/lang/String; Ljava/lang/String; I [Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ImportVCardActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothHeadset;-acceptIncomingConnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/app/ShutdownThread$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-([B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-onDialerKeyDown-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/http/EventHandler;-handleSslErrorRequest-(Landroid/net/http/SslError;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/AlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/ContactsLiveFolders$PhoneContacts;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getOperator-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$7;-getMode-(I)I' : ['android.permission.NFC'],
	'Lcom/android/settings/AccountSyncSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiManager;-startScanActive-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/ContextImpl$ApplicationPackageManager;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/ILlcpConnectionlessSocket$Stub;-sendTo-(I Landroid/nfc/LlcpPacket;)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-supplyPuk-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/MessagingListener;-loadMessageForViewStarted-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserBookmarksPage;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/ConnectivityManager;-startUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/location/GpsLocationProvider;-requestRefLocation-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/ProcessInfo;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ZoneList;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WindowManagerService;-moveAppWindowsLocked-(Ljava/util/List; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Landroid/webkit/HTML5VideoViewProxy$PosterDownloader;-start-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onChanged-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/music/MusicBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$20;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/HandleSetAlarm;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/MutableContextWrapper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/SipManager;-createSipSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/SipSession$Listener;)Landroid/net/sip/SipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/SearchResultsActivity;-callOrSmsContact-(Landroid/database/Cursor; Z)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/DebugIntentSender;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/TransactionService;-endMmsConnectivity-()V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/os/storage/IMountService;-finishMediaUpdate-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/nfc/RawTagConnection;-isConnected-()Z' : ['android.permission.NFC'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/DockService;-access$100-(Lcom/android/settings/bluetooth/DockService; Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub;-setRadio-(I Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-setRadioState-(Lcom/android/internal/telephony/CommandsInterface$RadioState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupAccountType;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/launcher2/Launcher;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/UsageStats;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneUtils;-cancelMmiCode-(Lcom/android/internal/telephony/Phone;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DefaultRingtonePreference;-onSaveRingtone-(Landroid/net/Uri;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/VolumePanel;-onVolumeChanged-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-switchWaitingOrHoldingAndActive-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupBasics;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/CalendarActivity;-onRestoreInstanceState-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-adjustUserActivityLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/exchange/EasOutboxService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/SearchActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-sendEmergencyCallbackModeChange-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/FullBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker$2;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/NetworkSetting;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/EasOutboxService;-runPingLoop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getContactsSize-()I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/settings/DeviceAdminSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/app/RingtonePickerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/Controller;-updateMailbox-(J J Lcom/android/email/Controller$Result;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/server/sip/SipService;-releaseWifiLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-setAlwaysFinish-(Z)V' : ['android.permission.SET_ALWAYS_FINISH', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/AccountFolderList;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/downloads/RealSystemFacade;-getActiveNetworkType-()Ljava/lang/Integer;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/AlarmManagerService$ResultReceiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityRecord;-keyDispatchingTimedOut-()Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/defcontainer/DefaultContainerService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneApp;-access$900-(Lcom/android/phone/PhoneApp; Landroid/os/Message;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Lcom/android/contacts/util/WeakAsyncTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$29;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-pokeWakelock-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-setEmptyText-()V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/ScoSocket;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/picasa/PicasaService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/AudioAttachmentView;-access$000-(Lcom/android/mms/ui/AudioAttachmentView;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmAlert;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/DevelopmentSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-deactivateDataCall-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/SizeLimitActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/SyncManager$ActiveSyncContext;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/app/TabActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WindowManagerService$Session;-add-(Landroid/view/IWindow; Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/calendar/AlertActivity;-access$700-(Lcom/android/calendar/AlertActivity;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/location/ILocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/downloads/Helpers;-generateSaveFile-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I J Z)Ljava/lang/String;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/phone/FdnSetting;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NetworkManagementService;-notifyInterfaceAdded-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DisplaySettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commandsParser-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-explicitCallTransfer-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/DayView;-initNextView-(I)Z' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-listBonds-()[Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/CacheLoader;-setupStreamAndSendStatus-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/DayView;-getEventAccessLevel-(Landroid/content/Context; Lcom/android/calendar/Event;)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/stk/RilMessageDecoder$StateStart;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/PackageSummary;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/INfcAdapter;-getLlcpServiceInterface-()Landroid/nfc/ILlcpServiceSocket;' : ['android.permission.NFC'],
	'Lcom/android/inputmethod/pinyin/PinyinIME;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/vpn/VpnService;-waitUntilConnectedOrTimedout-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handleExitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothNamePreference;-setSummaryToName-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/QueryBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-registerForSuppServiceNotification-(Landroid/os/Handler; I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Secure;-putString-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/IActivityManager;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateOrganizations-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/DeviceStorageMonitorService;-sendNotification-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE'],
	'Landroid/location/LocationManager;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateSettings-(Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-access$600-(Lcom/android/bluetooth/opp/BluetoothOppTransfer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onDisconnectDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/providers/calendar/CalendarProvider2;-onCreate-()Z' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-connectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setUserData-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-setInterfaceThrottle-(Ljava/lang/String; I I)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/os/storage/IMountService$Stub$Proxy;-setUsbMassStorageEnabled-(Z)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/email/activity/FolderMessageList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-connect-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/PhoneApp;-initForNewRadioTechnology-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/MessageUtils;-getNotificationIndDetails-(Landroid/content/Context; Landroid/database/Cursor;)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/music/MediaPlaybackActivity$5;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/EmailServiceProxy$10;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/mms/data/Conversation;-loadFromThreadId-(J Z)Z' : ['android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager;-acquireWifiLock-(Landroid/os/IBinder; I Ljava/lang/String; Landroid/os/WorkSource;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/IEmailService$Stub;-startSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NetworkManagementService;-listTtys-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/DockSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/downloads/DownloadThread;-openResponseEntity-(Lcom/android/providers/downloads/DownloadThread$State; Lorg/apache/http/HttpResponse;)Ljava/io/InputStream;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/MusicPicker;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/vpn/L2tpIpsecPskService;-checkConnectivity-()Z' : ['android.permission.VIBRATE'],
	'Lcom/android/music/CreatePlaylist;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/spare_parts/SpareParts;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$ContactMethods;-addPostalLocation-(Landroid/content/Context; J D D)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/WebViewCore;-destroy-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-access$000-(Lcom/android/contacts/ContactsListActivity; Z)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityManagerService;-killAppAtUsersRequest-(Lcom/android/server/am/ProcessRecord; Landroid/app/Dialog;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/CallLog$Calls;-getLastOutgoingCall-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/SIMFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-turnOffMobileConnection-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/BatteryService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/IBatteryStats;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/os/storage/IMountService;-shutdown-(Landroid/os/storage/IMountShutdownObserver;)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/phone/InCallScreen;-internalAnswerCall-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/email/GroupMessagingListener;-loadMessageForViewFinished-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AlertReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$10;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-getPDPContextList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/tts/ITts$Stub$Proxy;-synthesizeToFile-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccountSyncSettings;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Landroid/webkit/WebViewCore;-sendNotifyProgressFinished-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityStack;-moveTaskToFrontLocked-(Lcom/android/server/am/TaskRecord; Lcom/android/server/am/ActivityRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePeople-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/ISipService;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/Launcher;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-goBack-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-pollState-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/mms/transaction/MessagingNotification;-updateNotification-(Landroid/content/Context; Landroid/content/Intent; Ljava/lang/String; I Z Ljava/lang/CharSequence; J Ljava/lang/String; I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilitySettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/SyncManager$AccountObserver;-onAccountChanged-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/content/IContentService$Stub$Proxy;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/os/INetworkManagementService$Stub;-getInterfaceTxThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Settings$System;-putLong-(Landroid/content/ContentResolver; Ljava/lang/String; J)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallTouchUi;-onGrabbedStateChange-(Landroid/view/View; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity$AccountDisplay;-<init>-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/browser/BookmarkSearch;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/RadioInfo;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getConnectionInfo-()Landroid/net/wifi/WifiInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/MediaFormat;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/RecentCallsListActivity;-getBetterNumberFromContacts-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/AgendaListView;-dispatchPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-getActualState-(Landroid/content/Context;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/nfc/LlcpConnectionlessSocket;-receiveFrom-()Landroid/nfc/LlcpPacket;' : ['android.permission.NFC'],
	'Lcom/android/phone/BluetoothHandsfree$2;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Landroid/os/INetworkManagementService$Stub;-getInterfaceRxCounter-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupOptions;-onDone-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/nfc/INfcTag;-connect-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/WindowManagerPolicy;-exitKeyguardSecurely-(Landroid/view/WindowManagerPolicy$OnKeyguardExitResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(J F Landroid/location/Criteria; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ContactsListActivity;-doContactDelete-(Landroid/net/Uri;)V' : ['android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ConfirmLockPattern;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/MountService;-getStorageUsers-(Ljava/lang/String;)[I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-doContactDelete-(Landroid/net/Uri;)V' : ['android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/SetAlarm;-access$500-(Lcom/android/deskclock/SetAlarm;)J' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/AgendaActivity$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BrowserBackupAgent;-onRestore-(Landroid/app/backup/BackupDataInput; I Landroid/os/ParcelFileDescriptor;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/stk/IconLoader;-loadIcons-([I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-createServerSession-(Ljavax/obex/ObexTransport;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-setShuffleMode-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/ui/ContactsPreferences;-registerChangeListener-(Lcom/android/contacts/ui/ContactsPreferences$ChangeListener;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/sip/SipService;-access$300-(Lcom/android/server/sip/SipService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/MailService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$27;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-addVoiceMailNumberPanel-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MusicUtils;-playAll-(Landroid/content/Context; [J I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-restoreAtInstall-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/cooliris/wallpaper/Slideshow;-performSetup-(I I)V' : ['android.permission.INTERNET'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePhotoByDataId-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/launcher2/LauncherApplication;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-startVoiceRecognition-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/LockPatternUtils;-setBoolean-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CallFeaturesSetting;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier; Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/calendar/WeekActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MediaPlaybackActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/ILlcpSocket;-getLocalSocketRw-(I)I' : ['android.permission.NFC'],
	'Lcom/android/phone/PhoneApp;-onCreate-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-initialize-(Landroid/os/Bundle; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/MessageListAdapter$AvatarCache$ContactData;-access$600-(Lcom/android/mms/ui/MessageListAdapter$AvatarCache$ContactData; Landroid/database/Cursor;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/util/HierarchicalStateMachine$HsmHandler$QuittingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/statusbar/IStatusBarService;-collapse-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/nfc/INfcAdapter$Stub;-createLlcpSocket-(I I I I)I' : ['android.permission.NFC'],
	'Lcom/android/server/PackageManagerService;-main-(Landroid/content/Context; Z)Landroid/content/pm/IPackageManager;' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handlePinMmi-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService;-isUsbRNDISStarted-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/AdnRecordCache;-updateAdnBySearch-(I Lcom/android/internal/telephony/AdnRecord; Lcom/android/internal/telephony/AdnRecord; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/ChooseAccountActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasSyncService;-validate-(Ljava/lang/Class; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I Z Z Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/CropImage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/AdvancedSettings;-onResume-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityManagerService;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/app/RingtonePickerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSetupBasics;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/ReverseGeocoder;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallScreen$15;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ConversationListItem;-access$000-(Lcom/android/mms/ui/ConversationListItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/TrackBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/vpn/L2tpService;-onDisconnect-()V' : ['android.permission.VIBRATE'],
	'Landroid/nfc/ILlcpSocket;-getLocalSocketMiu-(I)I' : ['android.permission.NFC'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-onCreateContextMenu-(Landroid/view/ContextMenu;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/TextToSpeechSettings;-loadEngines-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/cooliris/media/UriTexture;-createInputStreamFromRemoteUrl-(Ljava/lang/String; Lorg/apache/http/conn/ClientConnectionManager;)Ljava/io/BufferedInputStream;' : ['android.permission.INTERNET'],
	'Landroid/app/Activity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/AdvancedSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/google/common/io/CharStreams;-readFirstLine-(Lcom/google/common/io/InputSupplier;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-trySetupData-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallScreen;-requestCloseOtaFailureNotice-(J)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IccProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/MccTable;-setLocaleFromMccIfNeeded-(Lcom/android/internal/telephony/PhoneBase; I)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/phone/DataUsageListener$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/SearchResultsActivity;-setEmptyText-()V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/DeleteItems;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/ChooseLockPatternTutorial;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/os/RuntimeInit$UncaughtHandler;-uncaughtException-(Ljava/lang/Thread; Ljava/lang/Throwable;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/deskclock/AlarmKlaxon;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackService;-removeTracksInternal-(I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-dial-(Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ResolverActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmMmiCode;-cancel-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccountPreferenceBase;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/quicklaunch/BookmarkPicker;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EmergencyDialer;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/BluetoothHeadsetService;-setState-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Landroid/content/IContentService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/tts/TtsService$1;-playSilence-(Ljava/lang/String; J I [Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NotificationManagerService;-access$2100-(Lcom/android/server/NotificationManagerService; Lcom/android/server/NotificationManagerService$ToastRecord;)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Lcom/android/contacts/SearchResultsActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/svox/pico/DownloadVoiceData;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/BatteryStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/BluetoothNamePreference;-onClick-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/ActivityManagerNative;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/util/EmptyService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/ReceiverRestrictedContext;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EmergencyCallHandler;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/vpn/VpnServiceBinder;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/DataConnection$DcDefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/PrivacySettings;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/media/MediaScannerService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityManagerService;-access$400-(Lcom/android/server/am/ActivityManagerService; Ljava/lang/String; I Z Z Z)Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/TimeConsumingPreferenceActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleEctIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneApp;-updateBluetoothIndication-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/Debug;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/GridLayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/Files;-readLines-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/util/List;' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/IBluetooth$Stub;-listBonds-()[Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/vpn/VpnServiceBinder;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/INetworkManagementEventObserver$Stub;-interfaceLinkStatusChanged-(Ljava/lang/String; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/LocationManager;-getLastKnownLocation-(Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-activateCellBroadcastSms-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/HandleSetAlarm;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$24;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-startToneCdma-(C)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AddAccountSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-removeBond-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/VideoView$2;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/DevelopmentSettings$9;-onItemSelected-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Lcom/android/internal/telephony/gsm/stk/StkService;-sendMenuSelection-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiApEnabler;-<init>-(Landroid/content/Context; Landroid/preference/CheckBoxPreference;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/RadioInfo;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/soundrecorder/Recorder;-startPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-setInstallLocation-(I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/data/Conversation;-ensureThreadId-()J' : ['android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager;-reconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/activity/AccountFolderList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-crashApplication-(Lcom/android/server/am/ProcessRecord; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/music/MediaPlaybackService;-openCurrent-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/picasa/PicasaContentProvider$SyncContext;-reloadAccounts-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity$1;-onClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity;-onStart-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/MutableContextWrapper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-registerReceiver-(Landroid/app/IApplicationThread; Landroid/content/IIntentReceiver; Landroid/content/IntentFilter; Ljava/lang/String;)Landroid/content/Intent;' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/app/ListActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/AddBookmarkPage;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/SipManager;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/nfc/NfcService$3;-connect-(I I)I' : ['android.permission.NFC'],
	'Landroid/nfc/ILlcpSocket;-connect-(I I)I' : ['android.permission.NFC'],
	'Lcom/android/server/LightsService$1;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Landroid/webkit/WebTextView;-onTrackballEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/InCallScreen;-updateDialpadVisibility-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/sip/SipAudioCall;-endCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-access$300-(Lcom/android/contacts/ContactsListActivity; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/camera/ui/HeadUpDisplay$Listener;-onSharedPreferencesChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/LatinIME;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-moveQueueItem-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/util/HierarchicalStateMachine$HsmHandler;-invokeEnterMethods-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-getGPRSRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/stk/RilMessageDecoder;-access$200-(Lcom/android/internal/telephony/gsm/stk/RilMessageDecoder; Lcom/android/internal/telephony/gsm/stk/RilMessage;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-reportSmsMemoryStatus-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/MonthActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-onCreateDialog-(I Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-processMessagePart-(Lcom/android/internal/telephony/SmsMessageBase; Lcom/android/internal/telephony/SmsHeader$ConcatRef; Lcom/android/internal/telephony/SmsHeader$PortAddrs;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Landroid/app/IActivityManager;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/CombinedBookmarkHistoryActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/CalendarSyncAdapterService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/ContactsProvider2;-access$1500-(Lcom/android/providers/contacts/ContactsProvider2;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/IccRecords;-onAllRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AgendaActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/model/MediaModelFactory;-getMediaModel-(Landroid/content/Context; Lorg/w3c/dom/smil/SMILMediaElement; Lcom/android/mms/model/LayoutModel; Lcom/google/android/mms/pdu/PduBody;)Lcom/android/mms/model/MediaModel;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$LegacyListener;-loadMessageForViewStarted-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/calendar/CalendarProvider2;-doUpdateTimezoneDependentFields-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/CalendarView;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/app/ChooserActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/downloads/DownloadService;-access$300-(Lcom/android/providers/downloads/DownloadService;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/settings/MasterClear;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/EditEvent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-call-(Ljava/lang/String;)V' : ['android.permission.CALL_PHONE'],
	'Lcom/android/internal/app/NetInitiatedActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/MovieViewControl;-<init>-(Landroid/view/View; Landroid/content/Context; Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/BatteryStatsService;-setBatteryState-(I I I I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MusicPicker;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService;-bindToAgentSynchronous-(Landroid/content/pm/ApplicationInfo; I)Landroid/app/IBackupAgent;' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/WifiManager;-disconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/transaction/SendTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/exchange/EasOutboxService;-sendHttpClientPost-(Ljava/lang/String; Lorg/apache/http/HttpEntity; I)Lorg/apache/http/HttpResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EmailServiceProxy$6;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/app/IWallpaperManager$Stub$Proxy;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/mms/model/AudioModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/content/IContentService$Stub;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothHeadset;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/MovieView$1;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/AlarmManagerService;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity$2;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/MessagingController$10;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-onRestrictedStateChanged-(Landroid/os/AsyncResult;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/email/activity/setup/AccountSetupOptions;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SpecialCharSequenceMgr;-handleIMEIDisplay-(Landroid/content/Context; Ljava/lang/String; Z)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-signalPersistentProcesses-(I)V' : ['android.permission.SIGNAL_PERSISTENT_PROCESSES'],
	'Lcom/android/contacts/ViewContactActivity;-setAggregationException-(J I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/launcher2/Launcher;-showNotifications-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/server/am/ActivityManagerService;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/development/Connectivity$13;-onClick-(Landroid/view/View;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/IEmailServiceCallback$Stub$Proxy;-loadAttachmentStatus-(J J I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/SyncManager;-serviceRequest-(J I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/InputMethodService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/ContactHeaderWidget$QueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/app/ActivityManagerNative;-registerReceiver-(Landroid/app/IApplicationThread; Landroid/content/IIntentReceiver; Landroid/content/IntentFilter; Ljava/lang/String;)Landroid/content/Intent;' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/camera/VideoCamera;-startVideoRecording-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/BluetoothHandsfree$12;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-setDataOnRoamingEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ui/EditContactActivity$AddContactTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Landroid/nfc/INfcTag;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/IP2pInitiator$Stub;-getGeneralBytes-(I)[B' : ['android.permission.NFC'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageListAdapter;-onContentChanged-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/cooliris/media/CropImage;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ViewContactActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/HandleSetAlarm;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-generatePhoneNumberIcon-(Landroid/net/Uri; I I)Landroid/graphics/Bitmap;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/quicksearchbox/ChoiceActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/ProxySelector;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ReceiverRestrictedContext;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/downloads/Helpers;-locateDestinationDirectory-(Landroid/content/Context; Ljava/lang/String; I J)Ljava/io/File;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-dispatchAttributesChanged-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/DataConnection$DcDisconnectingBadDnsState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/model/EntityDelta;-buildSetAggregationMode-(Ljava/lang/Long; I)Landroid/content/ContentProviderOperation$Builder;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/ManageConferenceUtils;-endConferenceConnection-(I Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IccFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ConversationList;-createNewMessage-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/WifiService;-setNumAllowedChannelsBlocking-(I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/IccLockSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-onPress-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/util/EmptyService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/CropImage;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/SyncManager;-access$300-(Lcom/android/exchange/SyncManager; J Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/MmiCode;-cancel-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccCard;-getIccCardStatusDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/TrackBrowserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ThrottleService;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/IWifiManager;-pingSupplicant-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/cooliris/media/GridInputProcessor;-selectSlot-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/Files;-move-(Ljava/io/File; Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Lcom/android/email/activity/FolderMessageList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/ShowActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/SyncManager;-releaseMailbox-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ZoneList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/contacts/LegacyContactImporter;-insertCall-(Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/development/InstrumentationList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/AttachImage;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-dumpRenderTree-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$TetheredState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.VIBRATE'],
	'Lcom/android/settings/TextToSpeechSettings;-initDefaultLang-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/commands/svc/WifiCommand;-run-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/cooliris/media/MovieViewControl$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setDataRoamingEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothAdapter;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneBase;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SlideshowActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/mock/MockContentResolver;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dispose-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/stk/IconLoader;-readClut-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-requestStateChange-(Landroid/content/Context; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothManager;-getBluetoothState-()I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MessageCompose;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/PluginFullScreenHolder;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothPbap$Stub;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothPbap;-getClient-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/ApnSettings;-setSelectedApnKey-(Ljava/lang/String;)V' : ['android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ClassZeroActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-processMiscUsage-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MediaPlaybackActivity;-cycleRepeat-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/pim/vcard/VCardEntry;-pushIntoContentResolver-(Landroid/content/ContentResolver;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/launcher2/LauncherApplication;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/ContextThemeWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-getValidChannelCounts-()[I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/AccountSyncSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/phone/OtaUtils;-onClickOtaActivateButton-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier;)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/providers/calendar/CalendarAppWidgetService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteMatchingCalendars-(Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/media/IAudioService;-startBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/IAudioService$Stub;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onCleanUpConnection-(Z Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/pinyin/SkbContainer;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/DataConnection$DcActivatingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-updateProviderListenersLocked-(Ljava/lang/String; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/SyncManager;-checkMailboxes-()J' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Lcom/android/phone/PhoneApp;-handleServiceStateChanged-(Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/webkit/WebView;-access$10400-(Landroid/webkit/WebView; I I I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-editProperties-(Ljava/lang/String; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/browser/Tab$SubWindowClient;-onPageStarted-(Landroid/webkit/WebView; Ljava/lang/String; Landroid/graphics/Bitmap;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/ErrorConsoleView$1;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/UpgradeAccounts;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-queryCallWaiting-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/AccountFolderList$DeleteAccountTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/view/IWindowSession$Stub;-addWithoutInputChannel-(Landroid/view/IWindow; Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/inputmethod/latin/LatinIME;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/LockPatternUtils;-setPermanentlyLocked-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/WebDialog;-dismiss-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/AtParser;-process-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ConnectivityService;-reportInetCondition-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager$Stub;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/WifiService;-setNumAllowedChannels-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/LatinIME;-commitTyped-(Landroid/view/inputmethod/InputConnection;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/mms/data/WorkingMessage;-preSendSmsWorker-(Lcom/android/mms/data/Conversation; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/speech/tts/TextToSpeech;-playSilence-(J I Ljava/util/HashMap;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/sip/SipEditor;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WindowManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.SET_ANIMATION_SCALE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/app/DisableCarModeActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/data/WorkingMessage;-saveAsMms-(Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/music/TrackBrowserActivity;-getTrackCursor-(Lcom/android/music/TrackBrowserActivity$TrackListAdapter$TrackQueryHandler; Ljava/lang/String; Z)Landroid/database/Cursor;' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/net/IThrottleManager$Stub;-getPeriodStartTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/AlarmKlaxon;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity$CommandRecognizerClient$3;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/TabControl;-restoreState-(Landroid/os/Bundle;)Z' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/model/VideoModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper; Lcom/android/mms/model/RegionModel;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/nfc/ILlcpSocket$Stub;-getLocalSap-(I)I' : ['android.permission.NFC'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-setProcessForeground-(Landroid/os/IBinder; I Z)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Landroid/bluetooth/IBluetoothPbap$Stub$Proxy;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/MonthView;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/wifi/WifiManager$WifiLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-cleanup-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/SearchResultsActivity;-access$000-(Lcom/android/contacts/ContactsListActivity; Z)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Landroid/media/AudioService$2;-onServiceDisconnected-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-query-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/ScoSocket;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/pinyin/SkbContainer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/Phone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/FdnList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-setSyncKey-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPlaybackService;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePhones-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/TextToSpeechSettings;-onInit-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$HeadsetProfileManager;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/RecentCallsListActivity$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-getNumAllowedChannels-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/WeekActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/spare_parts/SpareParts;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/Connection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity$BackgroundQueryHandler;-onDeleteComplete-(I Ljava/lang/Object; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/media/MediaPlayer;-suspend-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/ActiveWallpaper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiManager;-getWifiApState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver$MyTimerTask;-access$1800-(Lcom/android/server/sip/SipService$ConnectivityReceiver$MyTimerTask;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/http/EventHandler;-certificate-(Landroid/net/http/SslCertificate;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/ActivityManagerNative;-updateConfiguration-(Landroid/content/res/Configuration;)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/settings/AccountSyncSettingsInAddAccount;-onPrepareOptionsMenu-(Landroid/view/Menu;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-handleVolumeKey-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-copyMedia-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetoothA2dp;-connectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/CellBroadcastSms;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/IP2pTarget$Stub$Proxy;-transceive-(I [B)[B' : ['android.permission.NFC'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/LoadAverageService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/Photographs;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/TetherSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-hangupWaitingOrBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ExternalMediaFormatActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getRemoteName-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/NetworkManagementService;-startTethering-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onRoamingOff-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.CALL_PHONE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/telephony/PhoneNumberUtils;-isVoiceMailNumber-(Ljava/lang/String;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/ui/EditContactActivity$AddContactTask;-onPostExecute-(Ljava/lang/Object; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/Connectivity$10;-onClick-(Landroid/view/View;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-getContactFilterUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/PointerTracker;-onDownEvent-(I I J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/server/ConnectivityService;-handleInetConditionChange-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/LoadListener;-data-([B I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/browser/BrowserActivity;-onDownloadStartNoStream-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallCard;-updateForegroundCall-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/WebView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/pinyin/SettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ChooseLockGeneric;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AlertActivity;-dismissAlarm-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/activity/setup/AccountSetupOptions;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AsyncPlayer;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-centerFitRect-(I I I I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/Application;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telephony/TelephonyManager;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter$EasCalendarSyncParser;-addEvent-(Lcom/android/exchange/adapter/CalendarSyncAdapter$CalendarOperations; Ljava/lang/String; Z)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetoothHeadset;-getCurrentHeadset-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-skipCurrentReceiverLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/gsm/stk/CommandParamsFactory;-processGetInput-(Lcom/android/internal/telephony/gsm/stk/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LoadAverageService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-sendPdu-(J [B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendSMS-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onResume-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/ChooseLockPattern;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/GsmUmtsCallForwardOptions;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/MessageView;-onClickSender-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/cooliris/media/MovieViewControl;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService;-access$000-(Lcom/android/server/InputMethodManagerService;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/IP2pTarget$Stub;-getGeneralBytes-(I)[B' : ['android.permission.NFC'],
	'Lcom/android/mms/util/AddressUtils;-getFrom-(Landroid/content/Context; Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.READ_SMS'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothHeadsetService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/AlertActivity;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/inputmethod/latin/LatinIMESettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/UserDictionarySettings;-access$100-(Lcom/android/settings/UserDictionarySettings; Ljava/lang/String;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/gsm/SimCard;-changeIccLockPassword-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/AppHwConfigList;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/SimCard;-handleIccCardStatus-(Lcom/android/internal/telephony/IccCardStatus;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer$2;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/RecognitionManagerService;-setCurRecognizer-(Landroid/content/ComponentName;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/certinstaller/CertInstaller;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Browser;-deleteHistoryTimeFrame-(Landroid/content/ContentResolver; J J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/wifi/WifiAPITest;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/SecuritySettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/SipCallOptionHandler;-access$100-(Lcom/android/phone/SipCallOptionHandler;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/speech/IRecognitionService;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/server/WindowManagerService$InputMonitor;-interceptKeyBeforeDispatching-(Landroid/view/InputChannel; I I I I I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingA2dp;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/DeviceAdminAdd;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onRegistrationFailed-(Landroid/net/sip/ISipSession; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/calendar/CalendarAppWidgetService;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-onShowHideDialpad-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/IApplicationToken;-keyDispatchingTimedOut-()Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/wifi/WifiAPITest;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/storage/IMountService;-getStorageUsers-(Ljava/lang/String;)[I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/server/LocationManagerService;-getProviderInfo-(Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-syncClirSetting-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IntentService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/EditEvent;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/server/BluetoothEventLoop;-onRequestPasskey-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/ILlcpSocket$Stub$Proxy;-getRemoteSocketRw-(I)I' : ['android.permission.NFC'],
	'Lcom/android/nfc/NfcService;-createLlcpSocket-(I I I I)Lcom/android/internal/nfc/LlcpSocket;' : ['android.permission.NFC'],
	'Landroid/os/IVibratorService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/mms/ui/ClassZeroActivity;-saveMessage-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$3400-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-getDeviceIdentity-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/music/RenamePlaylist;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothDevice;-setPin-([B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/SyncManager$ConnectivityReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/svox/pico/GetSampleText;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor;-access$300-(Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor$SimArgs;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/development/PermissionDetails;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideViewInterface;-stopVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadInfo;-startIfReady-(J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/AccountPreferenceBase;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/AlarmAlertWakeLock;-releaseCpuLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DeviceAdminSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ui/ContactsPreferences;-setDisplayOrder-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/cooliris/media/ActiveWallpaper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/backup/IBackupManager$Stub;-setBackupProvisioned-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/applications/InstalledAppDetails;-processMoveMsg-(Landroid/os/Message;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/server/NotificationManagerService;-keepProcessAliveLocked-(I)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Lcom/android/phone/BluetoothHandsfree$4;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/location/ILocationManager;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/LocationManagerService;-access$500-(Lcom/android/server/LocationManagerService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onRegistrationTimeout-(Landroid/net/sip/ISipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub;-write-(I Landroid/nfc/NdefMessage;)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub;-setInterfaceThrottle-(Ljava/lang/String; I I)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/music/MusicUtils;-playPlaylist-(Landroid/content/Context; J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendAcknowledgeInd-(Lcom/google/android/mms/pdu/RetrieveConf;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/downloads/SystemFacade;-isNetworkRoaming-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/pim/vcard/VCardComposer$HandlerForOutputStream;-onInit-(Landroid/content/Context;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/music/TouchInterceptor$1;-onFling-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothA2dpService;-getConnectedSinks-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/PushReceiver;-isDuplicateNotification-(Landroid/content/Context; Lcom/google/android/mms/pdu/NotificationInd;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/exchange/SyncManager$2;-startSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadInfo;-getMyDownloadsUri-()Landroid/net/Uri;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/soundrecorder/SoundRecorder;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/preference/PreferenceActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/AttachmentEditor;-update-(Lcom/android/mms/data/WorkingMessage;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/HeadsetBase;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmClock$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/PhoneApp;-handleQueryTTYModeResponse-(Landroid/os/Message;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/app/ActivityManagerNative;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/telephony/gsm/SmsManager;-copyMessageToSim-([B [B I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-setTestProviderLocation-(Ljava/lang/String; Landroid/location/Location;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/contacts/ContactsListActivity;-afterTextChanged-(Landroid/text/Editable;)V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/provision/DefaultActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-setFacilityLock-(Ljava/lang/String; Z Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$LegacyListener;-synchronizeMailboxStarted-(J J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/calendar/AlertService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MediaPlaybackActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/WirelessSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EmailSyncAlarmReceiver;-handleReceive-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/SettingsSafetyLegalActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/MessageView;-onViewAttachment-(Lcom/android/email/activity/MessageView$AttachmentInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/ListActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/TwelveKeyDialer;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/DownloadInfo;-checkCanUseNetwork-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-addAccount-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/RadioInfo;-onPause-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/AccountSetupAccountType;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasSyncService;-sleep-(J Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$3;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getLastKnownLocation-(Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/pm/IPackageManager$Stub;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/internal/nfc/P2pTarget;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/settings/applications/RunningServiceDetails;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ExportVCardActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub;-listInterfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/SecuritySettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/BackupManagerService$RunInitializeReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService$Stub;-startUsbRNDIS-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/vpn/VpnService;-onError-(Ljava/lang/Throwable;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/CallNotifier;-onCdmaCallWaitingReject-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/Tab;-removeSubWindow-(Landroid/view/ViewGroup;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/Transaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/media/AudioService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/LoadListener;-certificate-(Landroid/net/http/SslCertificate;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-canAddToContacts-(Lcom/android/mms/data/Contact;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-setAndBroadcastNetworkSetTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/email/activity/MessageList;-onLoadMoreMessages-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getVoiceMailAlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$30;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/media/ActiveWallpaper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/DayView;-drawAfterScroll-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/IConnectivityManager$Stub;-requestRouteToHost-(I I)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/mms/ui/ConfirmRateLimitActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/MonitoredActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-onResume-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/MonthView;-dispatchPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/SyncManager$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;-access$300-(Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/telephony/TelephonyProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/deskclock/Alarms;-saveSnoozeAlert-(Landroid/content/Context; I J)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallTouchUi;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ui/EditContactActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Ljava/lang/String; Ljava/lang/String; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Landroid/webkit/WebView;-clearHistory-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-getSinkPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/svox/pico/CheckVoiceData;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityManagerService;-forceStopPackageLocked-(Ljava/lang/String; I)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/ConfirmLockPattern;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/mock/MockContentResolver;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/ITelephony;-endCall-()Z' : ['android.permission.CALL_PHONE'],
	'Lcom/android/server/INativeDaemonConnectorCallbacks;-onEvent-(I Ljava/lang/String; [Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/PackageManagerService;-scanDirLI-(Ljava/io/File; I I J)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/os/storage/StorageManager;-disableUsbMassStorage-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/internal/telephony/gsm/SimCard;-changeIccFdnPassword-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub$Proxy;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsLiveFolders$StarredContacts;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-createLlcpServiceSocket-(I Ljava/lang/String; I I I)I' : ['android.permission.NFC'],
	'Landroid/webkit/WebView;-access$4200-(Landroid/webkit/WebView; I I Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyDataConnection-(Lcom/android/internal/telephony/Phone; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; J Z Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/PhoneUtils;-answerCall-(Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/Phone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$12;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/search/OpenSearchSearchEngine;-getSuggestions-(Landroid/content/Context; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiEnabled-(Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/activity/MessageCompose;-displayQuotedText-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/WifiService;-testAndClearWifiSavedState-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/MusicPicker;-setSelected-(Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ContactsListActivity;-getSelectedUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallEstablished-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/accounts/IAccountManager$Stub;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-getIMEISV-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EnableFdnScreen;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/PushReceiver$ReceivePushTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ConfirmRateLimitActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/ContentResolver;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/setup/AccountSecurity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accessibilityservice/AccessibilityService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ThrottleService;-getByteCount-(Ljava/lang/String; I I I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/VideoBrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Settings$System;-putFloat-(Landroid/content/ContentResolver; Ljava/lang/String; F)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/AccountSyncSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/inputmethodservice/InputMethodService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupWaitingOrBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$SettingsObserver;-observe-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/AddAccountSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/quicklaunch/BookmarkPicker;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/calendar/CalendarProvider2;-verifyAccounts-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/sip/SipEditor;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-showGlobalActionsDialog-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/WindowManagerService;-removeWindowInnerLocked-(Lcom/android/server/WindowManagerService$Session; Lcom/android/server/WindowManagerService$WindowState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Landroid/webkit/WebView;-documentHasImages-(Landroid/os/Message;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity$QueryGroupsTask;-doInBackground-(Lcom/android/contacts/ui/ContactsPreferencesActivity; [Ljava/lang/Void;)Lcom/android/contacts/ui/ContactsPreferencesActivity$AccountSet;' : ['android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/AlertActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/phone/sip/SipSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageCompose;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/EasSyncService;-acknowledgeRemoteWipe-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Contact$ContactsCache;-updateContact-(Lcom/android/mms/data/Contact;)V' : ['android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/BluetoothAdapter;-setScanMode-(I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Tab$2;-onPageStarted-(Landroid/webkit/WebView; Ljava/lang/String; Landroid/graphics/Bitmap;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-setKeyguardEnabled-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/ThrottleManager;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/PackageBrowser;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService$4;-accept-(I)I' : ['android.permission.NFC'],
	'Landroid/bluetooth/IBluetooth;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/calendar/CalendarAppWidgetService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothAtPhonebook$3;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPattern-(Ljava/util/List;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebViewCore;-sendMessage-(I I I Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$000-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/webkit/WebView;-drawContent-(Landroid/graphics/Canvas;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/INfcAdapter$Stub;-getLlcpServiceInterface-()Landroid/nfc/ILlcpServiceSocket;' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/IccCard;-access$000-(Lcom/android/internal/telephony/IccCard; Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onCreate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/PackageSummary$1;-onClick-(Landroid/view/View;)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/music/VideoBrowserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-access$1800-(Lcom/android/bluetooth/opp/BluetoothOppService; Landroid/database/Cursor; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/telephony/SmsManager;-sendMultipartTextMessage-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Lcom/android/calendar/DismissAllAlarmsService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/pinyin/SoftKeyboardView;-tryVibrate-()V' : ['android.permission.VIBRATE'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-clearBackupData-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothA2dpService;-adjustOtherSinkPriorities-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-getTrustState-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothProfileState;-start-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MusicPicker;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/SelectDialog;-dismiss-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/DayView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothEventLoop;-onRestartRequired-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsLiveFolders$StarredContacts;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/LatinKeyboardView;-onDownEvent-(Lcom/android/inputmethod/latin/PointerTracker; I I J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/email/MessagingController;-synchronizeMailboxSynchronous-(Lcom/android/email/provider/EmailContent$Account; Lcom/android/email/provider/EmailContent$Mailbox;)V' : ['android.permission.VIBRATE'],
	'Landroid/app/INotificationManager$Stub$Proxy;-enqueueNotification-(Ljava/lang/String; I Landroid/app/Notification; [I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/OtaUtils;-onClickOtaEndButton-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Boolean;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/BrowserHistoryPage;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/deviceinfo/Memory;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/mail/store/ExchangeStore;-removeSystemAccount-(Landroid/content/Context; Lcom/android/email/provider/EmailContent$Account; Landroid/accounts/AccountManagerCallback;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/SettingsSafetyLegalActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneApp;-requestWakeState-(Lcom/android/phone/PhoneApp$WakeState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$9;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/policy/StatusBarPolicy$4;-onCallStateChanged-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/WirelessSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WindowManagerService;-addWindow-(Lcom/android/server/WindowManagerService$Session; Landroid/view/IWindow; Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/app/IActivityManager;-unbroadcastIntent-(Landroid/app/IApplicationThread; Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$OppProfileManager;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/sip/SipWakeLock;-acquire-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/DeleteItems;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-getSinkState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/AlertActivity$1;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mms/ui/SlideshowPresenter;-presentRegionMedia-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/RegionMediaModel; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountAuthenticatorActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewClient;-onReceivedHttpAuthRequest-(Landroid/webkit/WebView; Landroid/webkit/HttpAuthHandler; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IThrottleManager$Stub;-getThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewCore;-sendMessageDelayed-(I Ljava/lang/Object; J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/search/SearchManagerService$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/ContactsListActivity;-getContactFilterUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-loadEFImgTransparent-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-suspendSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/CallNotifier;-onCdmaCallWaiting-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/speech/IRecognitionService$Stub;-stopListening-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/CommandsInterface;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/TwelveKeyDialer;-resolveIntent-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/development/RunningProcesses;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/LatinIMEBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityManagerService;-appDiedLocked-(Lcom/android/server/am/ProcessRecord; I Landroid/app/IApplicationThread;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getBondState-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/NetworkManagementService;-stopTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$11;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WifiService;-access$600-(Lcom/android/server/WifiService; Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity$28;-onContentChanged-(Lcom/android/mms/ui/MessageListAdapter;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/server/BluetoothA2dpService;-getSinkState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/app/INotificationManager;-enqueueNotification-(Ljava/lang/String; I Landroid/app/Notification; [I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-operationComplete-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/widget/LockPatternUtils;-passwordToHash-(Ljava/lang/String;)[B' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createView-()Landroid/view/View;' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserActivity;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/WifiManager;-getWifiApConfiguration-()Landroid/net/wifi/WifiConfiguration;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/webkit/WebView;-onResume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/vpn/L2tpService;-waitUntilConnectedOrTimedout-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/DockEventReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsLiveFolders$AllContacts;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/CallbackProxy;-onReceivedHttpAuthRequest-(Landroid/webkit/HttpAuthHandler; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/Email;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager$7;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/inputmethod/pinyin/PinyinIME;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AlertActivity$3;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-enforceReceiveAndSend-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/nfc/ILlcpSocket;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/mms/util/Recycler$SmsRecycler;-anyThreadOverLimit-(Landroid/content/Context;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHandsfree$11;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/Utils;-setTimeZone-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/nfc/NfcAdapter;-createNdefTagConnection-(Landroid/nfc/NdefTag; Ljava/lang/String;)Landroid/nfc/NdefTagConnection;' : ['android.permission.NFC'],
	'Landroid/net/Downloads$DownloadBase;-startDownloadByUri-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Z I Z Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)J' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-disconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-getPeopleFilterUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/WeekActivity;-makeView-()Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Landroid/location/ILocationManager$Stub$Proxy;-setTestProviderEnabled-(Ljava/lang/String; Z)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/calendar/EditEvent;-access$700-(Lcom/android/calendar/EditEvent;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetoothHeadset;-disconnectHeadset-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ui/EditContactActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/NoSearchActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserActivity;-retainIconsOnStartup-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor;-handleSimStateChange-(Lcom/android/internal/policy/impl/KeyguardUpdateMonitor$SimArgs;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/google/android/mms/pdu/PduPersister;-load-(Landroid/net/Uri;)Lcom/google/android/mms/pdu/GenericPdu;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/CallDetailActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/RadioInfo;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-readOutOfBandData-()[B' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$AccountAnalyzer;-<init>-(Lcom/android/internal/policy/impl/LockPatternKeyguardView; Landroid/accounts/AccountManager;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/cooliris/media/CrossFadingTexture;-bind-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/provision/DefaultActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothEventLoop;-addDevice-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/EditFdnContactScreen;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/BaseCommands;-setRadioState-(Lcom/android/internal/telephony/CommandsInterface$RadioState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/MultiInputStream;-read-()I' : ['android.permission.INTERNET'],
	'Landroid/net/IThrottleManager;-getPeriodStartTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ShutdownActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideEditorActivity;-showCurrentSlide-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/DayActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-enableKeyguard-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/webkit/DataLoader;-sendData-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/quicklaunch/BookmarkPicker;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification;-updateCompletedNotification-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/wifi/WifiAPITest;-onPreferenceClick-(Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/nfc/ILlcpServiceSocket$Stub$Proxy;-close-(I)V' : ['android.permission.NFC'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-haveSomethingToCopyToDrmProvider-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/Phone;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/calendar/CalendarProvider2;-scheduleNextAlarmLocked-(Landroid/database/sqlite/SQLiteDatabase;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-isTetheringStarted-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsListActivity;-loadContactPhoto-(Landroid/net/Uri; Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/settings/vpn/VpnSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/DemoDataSet;-add-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Landroid/content/ContentResolver;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/WeekView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/AgendaWindowAdapter;-doQuery-(Lcom/android/calendar/AgendaWindowAdapter$QuerySpec;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/cooliris/media/Gallery;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.INTERNET', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-openToReceiveCalls-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/SearchSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ConnectivityService;-access$1100-(Lcom/android/server/ConnectivityService; I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService$AudioServiceBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-createPbapNotification-(Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/BluetoothHandsfree$29;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-disable-(Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/PrivacySettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSecurity$1;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/wifi/WifiStatusTest$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/wifi/WifiManager;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/GlobalActions$3;-onPress-()V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/CreateShortcut;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/calendar/CalendarProvider2;-access$300-(Lcom/android/providers/calendar/CalendarProvider2; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/DataUsage;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/AlbumBrowserActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EnableIccPinScreen;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-finalize-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-updateServiceLocation-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/MonthActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/location/LocationManager;-addTestProvider-(Ljava/lang/String; Z Z Z Z Z Z Z I I)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getValidChannelCounts-()[I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/SearchResultsActivity;-access$1000-(Lcom/android/contacts/ContactsListActivity; Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/PowerManagerService$4;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/tts/TtsService$1;-speak-(Ljava/lang/String; Ljava/lang/String; I [Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/bluetooth/BluetoothPbap;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/GoogleCalendarUriIntentFilter;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree;-onBluetoothDisabled-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/QueryBrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/AudioPreview;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallScreen$7;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ConversationListAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/app/ActivityManager;-getRunningTasks-(I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/development/Connectivity$7;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasSyncService;-runPingLoop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ActivityPicker;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/ILlcpConnectionlessSocket$Stub$Proxy;-getSap-(I)I' : ['android.permission.NFC'],
	'Lcom/android/server/VibratorService$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/media/TimeBar;-onSurfaceCreated-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Landroid/location/LocationManager;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/settings/AccessibilitySettings;-handleEnableAccessibilityStateChange-(Landroid/preference/CheckBoxPreference;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/SlideshowAttachmentView;-setVideo-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/ScanningProgress;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ViewContactActivity$2;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/BackupManagerService;-setBackupProvisioned-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-createBondOutOfBand-(Ljava/lang/String; [B [B)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/KeyguardViewCallback;-pokeWakelock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-openCompleteTransfer-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/test/mock/MockContentResolver;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub$Proxy;-expand-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/settings/DockSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-getRemoteServiceChannel-(Ljava/lang/String; Landroid/os/ParcelUuid;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MusicBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth;-getRemoteClass-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/google/android/mms/util/PduCache;-put-(Landroid/net/Uri; Lcom/google/android/mms/util/PduCacheEntry;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/test/mock/MockContentResolver;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/BrowserActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/PhotoAppWidgetBind;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/app/TabActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ClassZeroActivity;-replaceMessage-(Landroid/telephony/SmsMessage;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/BatteryInfo;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/userdictionary/DictionaryBackupAgent;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/SipBroadcastReceiver;-takeCall-(Landroid/content/Intent;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/server/LocationManagerService$ProximityListener;-onLocationChanged-(Landroid/location/Location;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/MultiReader;-read-([C I I)I' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity$AccountDisplay;-buildDiff-(Ljava/util/ArrayList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/AppHwPref;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/SMSDispatcher;-handleStatusReport-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView;-resume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ViewContactActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/EmergencyCallHandler;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/DataUsage;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/Browser;-getAllVisitedUrls-(Landroid/content/ContentResolver;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/nfc/RawTagConnection;-<init>-(Landroid/nfc/NfcAdapter; Landroid/nfc/Tag;)V' : ['android.permission.NFC'],
	'Lcom/android/deskclock/AlarmAlert;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$15;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2600-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/webkit/WebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.INTERNET'],
	'Landroid/content/ISyncStatusObserver$Stub$Proxy;-onStatusChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/inputmethod/pinyin/SettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-getLastCallFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/BandMode;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MediaPlaybackService;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NotificationPlayer$CreationAndCompletionThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Call;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/CreateShortcut;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/DockService;-handleUndocked-(Landroid/content/Context; Lcom/android/settings/bluetooth/LocalBluetoothManager; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/downloads/DownloadProvider;-logVerboseOpenFileInfo-(Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/ZoneList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingA2dp;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/location/GpsNetInitiatedHandler;-handleNiNotification-(Lcom/android/internal/location/GpsNetInitiatedHandler$GpsNiNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/MessageUtils;-getMultimediaMessageDetails-(Landroid/content/Context; Landroid/database/Cursor; I)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/ContactsLiveFolders$StarredContacts;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/SyncManager;-stopServiceThreads-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ChooseLockPassword;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/PointerTracker;-onTouchEvent-(I I I J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/nfc/P2pInitiator;-send-([B)V' : ['android.permission.NFC'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/AddBookmarkPage;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/certinstaller/CertFile;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/google/GoogleSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/ContactsProvider2;-onCreate-()Z' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-getOutgoingServiceCenter-(J)Ljava/lang/String;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/app/IWallpaperManager;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/AccountManager$AmsTask;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/exchange/SyncManager;-runAsleep-(J J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentService;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/app/ContextImpl;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-connect-(Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$Profile;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ConversationList;-onStart-()V' : ['android.permission.READ_SMS'],
	'Landroid/server/BluetoothService;-disable-(Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/nfc/NfcService$6;-connect-(I)I' : ['android.permission.NFC'],
	'Lcom/android/calendar/CalendarView;-updateEventDetails-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-keyguardDone-(Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/provider/Calendar$CalendarAlerts;-alarmExists-(Landroid/content/ContentResolver; J J J)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/soundrecorder/SoundRecorder;-access$000-(Lcom/android/soundrecorder/SoundRecorder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IccCard;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EmergencyDialer;-keyPressed-(I)V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-processCommand-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/soundrecorder/SoundRecorder;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/tts/ITts$Stub;-playSilence-(Ljava/lang/String; J I [Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-changeIccLockPassword-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$1;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/nfc/NfcService$2;-getLlcpInterface-()Landroid/nfc/ILlcpSocket;' : ['android.permission.NFC'],
	'Landroid/content/MutableContextWrapper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/WorkingMessage;-updateDraftMmsMessage-(Landroid/net/Uri; Lcom/google/android/mms/pdu/PduPersister; Lcom/android/mms/model/SlideshowModel; Lcom/google/android/mms/pdu/SendReq;)V' : ['android.permission.READ_SMS'],
	'Landroid/view/WindowManagerPolicy;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/InCallScreen;-connectBluetoothAudio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHeadsetService;-access$1400-(Lcom/android/phone/BluetoothHeadsetService; Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/NotificationTransaction;-<init>-(Landroid/content/Context; I Lcom/android/mms/transaction/TransactionSettings; Lcom/google/android/mms/pdu/NotificationInd;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/SyncManager$2;-loadAttachment-(J Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageCompose$LoadMessageTask;-onPostExecute-([Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/SettingsLicenseActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ui/EditContactActivity$PersistTask;-doInBackground-(Ljava/lang/Object; [Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/ExportVCardActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/TabActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/ConnectivityManager;-reportInetCondition-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/MenuBar;-drawHighlight-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11; I)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/SIMFileHandler;-updateEFLinearFixed-(I I [B Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/UsageStats;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/spare_parts/SpareParts;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/InCallScreen$4;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EnableIccPinScreen;-access$300-(Lcom/android/phone/EnableIccPinScreen;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageList;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/test/TestListActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-wipe-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/BluetoothHandsfree$8;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/RingerVolumePreference;-cleanup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageUtils;-getMessageDetails-(Landroid/content/Context; Landroid/database/Cursor; I)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/nfc/NfcService$2;-getLlcpServiceInterface-()Landroid/nfc/ILlcpServiceSocket;' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/exchange/SyncManager;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/accounts/AccountManager$6;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/AccountSyncSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM;-setLastError-(I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/pim/vcard/VCardComposer;-createOneEntry-(Ljava/lang/reflect/Method;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-disconnectHeadset-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothManager;-onScanningStateChanged-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/BootReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-updateServiceLocation-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadInfo$Reader;-readRequestHeaders-(Lcom/android/providers/downloads/DownloadInfo;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen;-checkPin-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/model/SlideshowModel;-createFromMessageUri-(Landroid/content/Context; Landroid/net/Uri;)Lcom/android/mms/model/SlideshowModel;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/LanguageSettings;-onPause-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/RingerVolumePreference;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/SyncManager$2;-sendMeetingResponse-(J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ChooseLockPatternTutorial;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/ApnEditor;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-broadcastTimeoutLocked-(Z)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$InitialState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub$Proxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Landroid/os/INetworkManagementService;-getInterfaceTxThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/content/SyncManager$InitializerServiceConnection;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/app/ActivityManagerNative;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub;-getProviderInfo-(Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/MessageStatusReceiver;-updateMessageStatus-(Landroid/content/Context; Landroid/net/Uri; [B)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/WifiService;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/nfc/INfcAdapter;-getNfcTagInterface-()Landroid/nfc/INfcTag;' : ['android.permission.NFC'],
	'Lcom/android/calendar/CalendarView$3;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/location/GpsLocationProvider;-updateNetworkState-(I Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DataConnection;-tearDownData-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AgendaWindowAdapter;-formatDateString-(I)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/PhoneUtils;-getCallerInfo-(Landroid/content/Context; Lcom/android/internal/telephony/Connection;)Lcom/android/internal/telephony/CallerInfo;' : ['android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-buildAddAddressToContactMenuItem-(Landroid/view/Menu;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/google/common/io/MultiReader;-advance-()V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/DateTimeSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserPreferencesPage;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/model/EntitySet;-fromQuery-(Landroid/content/ContentResolver; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Lcom/android/contacts/model/EntitySet;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-changeIccPin2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/CalendarActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/GlobalActions;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/browser/BrowserActivity;-onNetworkToggle-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManagerService;-getAccountsByFeatures-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/settings/SettingsHelper;-setAutoRestore-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/INetworkManagementService;-attachPppd-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/webkit/StreamLoader;-sendHeaders-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/InputManager$Callbacks;-interceptKeyBeforeQueueing-(J I Z I Z)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.CALL_PHONE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/MediaFormat;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/cache/CacheService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ChooseLockPattern;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/TetherSettings;-access$000-(Lcom/android/settings/TetherSettings; [Ljava/lang/Object; [Ljava/lang/Object; [Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/content/SyncManager$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity$ErrorRunnable;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/app/TabActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/InCallScreen;-isBluetoothAvailable-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification;-updateActiveNotification-()V' : ['android.permission.VIBRATE'],
	'Landroid/content/ContentResolver;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/contacts/PhoneDisambigDialog;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/sip/SipService;-access$400-(Lcom/android/server/sip/SipService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onRestartRadio-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AgendaWindowAdapter;-buildQueryUri-(I I)Landroid/net/Uri;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/WindowManagerService;-performLayoutAndPlaceSurfacesLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/google/common/io/ByteStreams;-toByteArray-(Lcom/google/common/io/InputSupplier;)[B' : ['android.permission.INTERNET'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-getProfileSummary-(Lcom/android/settings/bluetooth/LocalBluetoothProfileManager; Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$Profile; Landroid/bluetooth/BluetoothDevice; I Z)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen;-internalHangup-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/speech/tts/ITts;-synthesizeToFile-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-getBluetoothState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/PhoneDisambigDialog;-show-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/WindowManagerService;-performLayoutAndPlaceSurfacesLockedInner-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/phone/Settings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/service/MailService$ControllerResults;-updateMailboxCallback-(Lcom/android/email/mail/MessagingException; J J I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/OutgoingCallBroadcaster$OutgoingCallReceiver;-doReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/WifiWatchdogService;-backgroundCheckDnsConnectivity-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/phone/CallNotifier;-silenceRinger-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/settings/ChooseLockGeneric;-updatePreferencesOrFinish-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/PasswordUnlockScreen;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/provider/Contacts$People;-queryGroups-(Landroid/content/ContentResolver; J)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Landroid/content/ContentResolver;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-scheduleBroadcastsLocked-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/sip/SipAudioCall;-access$1000-(Landroid/net/sip/SipAudioCall; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/AdvancedSettings;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/server/BluetoothService;-getProperty-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/AgendaAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/util/HierarchicalStateMachine$HsmHandler$HaltingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/AlarmKlaxon;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/Phone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getMmsReportItems-()Ljava/util/List;' : ['android.permission.READ_SMS'],
	'Landroid/server/BluetoothService;-restart-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager;-getAccountsByType-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/SpecialCharSequenceMgr;-showMEIDPanel-(Landroid/content/Context; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/AgendaActivity;-goToToday-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/BrowserBookmarksPage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/DockService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebView;-textFieldDrag-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/EmailServiceProxy$4;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity;-access$500-(Lcom/android/voicedialer/BluetoothVoiceDialerActivity; I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/browser/BrowserPreferencesPage;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/SyncManager;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/certinstaller/CertInstallerMain;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService;-listTtys-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/google/android/mms/pdu/PduPersister;-getPendingMessages-(J)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Landroid/nfc/ILlcpConnectionlessSocket$Stub$Proxy;-close-(I)V' : ['android.permission.NFC'],
	'Lcom/android/server/vpn/PptpService;-waitUntilConnectedOrTimedout-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/vpn/VpnSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessageUtils;-handleReadReport-(Landroid/content/Context; J I Ljava/lang/Runnable;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/email/GroupMessagingListener;-loadAttachmentFailed-(J J J Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/ConfigurationViewer;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ConfirmLockPattern$2;-onPatternDetected-(Ljava/util/List;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/svox/pico/CheckVoiceData;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-conference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-setEmptyText-()V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/vpn/PptpService;-onDisconnect-()V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/FrameLoader;-startCacheLoad-(Landroid/webkit/CacheManager$CacheResult;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccRecords;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/Wallpaper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothA2dp;-getSinkPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/PushReceiver;-findThreadId-(Landroid/content/Context; Lcom/google/android/mms/pdu/GenericPdu; I)J' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/MmsApp;-onTerminate-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/music/MediaPlaybackService;-open-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/NotificationMgr$QueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.VIBRATE', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IBackupManager;-restoreAtInstall-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/SearchResultsActivity;-handleImportRequest-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/BandMode;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/NotificationMgr;-updateInCallNotification-()V' : ['android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupBasics;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/ContactsLiveFolders$StarredContacts;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothA2dp;-isSinkConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-sendDtmf-(C Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getCurrentHeadset-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen;-onDialerOpen-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/INetworkManagementService;-stopAccessPoint-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/providers/downloads/DownloadService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/SelectDialog$3;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/policy/StatusBarPolicy;-showLowBatteryWarning-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/WallpaperManager;-suggestDesiredDimensions-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService$2;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/app/ShutdownThread;-reboot-(Landroid/content/Context; Ljava/lang/String; Z)V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/ILlcpSocket$Stub$Proxy;-connect-(I I)I' : ['android.permission.NFC'],
	'Lcom/cooliris/media/GridInputProcessor$1;-run-()V' : ['android.permission.INTERNET'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$000-(Lcom/android/mms/ui/ComposeMessageActivity;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/util/AccountSelectionUtil$AccountSelectedListener;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthTokenByFeatures-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/app/Activity; Landroid/os/Bundle; Landroid/os/Bundle; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/nfc/ILlcpConnectionlessSocket;-receiveFrom-(I)Landroid/nfc/LlcpPacket;' : ['android.permission.NFC'],
	'Lcom/android/mms/ui/SlideEditorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/settings/SettingsHelper;-restoreValue-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipAudioCall;-stopCall-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/DevelopmentSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/LatinKeyboardView;-handleSuddenJump-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/exchange/CalendarSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/CommandsInterface;-setPreferredVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-onWindowFocusChanged-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/IAudioService$Stub;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/TextToSpeechSettings;-useCurrentLocAsDefault-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/MccTable;-setTimezoneFromMccIfNeeded-(Lcom/android/internal/telephony/PhoneBase; I)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/contacts/LegacyContactImporter;-importContactsFromLegacyDb-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-setNetworkSelectionModeManual-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/RepeatingImageButton;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/RecentCallsListActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/wifi/AdvancedSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$InitialState;-turnOffMasterTetherSettings-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/content/Context;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SearchResultsActivity;-doContactDelete-(Landroid/net/Uri;)V' : ['android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/SyncManager$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-sendVcardListingXml-(I Ljavax/obex/Operation; I I Ljava/lang/String; Ljava/lang/String;)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/CalendarView;-doScroll-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/LauncherActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/CalendarActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/SmsReceiver;-beginStartingService-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifySignalStrength-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/UserBigramDictionary;-addWord-(Ljava/lang/String; I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/calendar/CalendarAppWidgetService;-getUpcomingInstancesCursor-(Landroid/content/ContentResolver; J J)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetoothHeadset;-disconnectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/TestingSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/SyncManager$7;-onStatusChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasSyncService;-sendHttpClientPost-(Ljava/lang/String; [B)Lorg/apache/http/HttpResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/Debug;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/BatteryStatsService;-getAwakeTimePlugged-()J' : ['android.permission.BATTERY_STATS'],
	'Lcom/android/internal/nfc/P2pTarget;-disconnect-()V' : ['android.permission.NFC'],
	'Lcom/android/launcher2/AllApps3D;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/server/InputMethodManagerService$MyPackageMonitor;-onSomePackagesChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/WebView;-access$6100-(Landroid/webkit/WebView; I I Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/downloads/DownloadInfo;-sendIntentIfRequested-()V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/LocationManagerService$Receiver;-incrementPendingBroadcastsLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageList$LoadMessagesTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WifiWatchdogService;-registerForSettingsChanges-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/NotificationTransaction;-notifyObservers-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setSuppServiceNotifications-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-setupData-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/svox/pico/EngineSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity$1;-onChange-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/transaction/NotificationTransaction;-sendPdu-(J [B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/LocationManagerService;-requestLocationUpdates-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/location/ILocationListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/PlaylistBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebViewCore;-sendMessage-(Landroid/os/Message;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/Utils;-formatDateRange-(Landroid/content/Context; J J I)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/ui/SlideViewInterface;-pauseAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPbap;-disconnect-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/sip/SipSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/AccountSyncSettings;-updateAccountCheckboxes-([Landroid/accounts/Account;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/quicksearchbox/SearchWidgetConfigActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/WallpaperChooser;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/SipAudioCall$1;-onError-(Landroid/net/sip/SipSession; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/MonthActivity;-makeView-()Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/nfc/P2pTarget;-transceive-([B)[B' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-getRemoteClass-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/os/storage/IMountService$Stub;-finishMediaUpdate-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/settings/wifi/WifiSettings;-access$000-(Lcom/android/settings/wifi/WifiSettings; Landroid/content/Intent;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/phone/InCallScreen;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/vpn/L2tpIpsecPskService;-access$600-(Lcom/android/server/vpn/VpnService; Ljava/lang/Throwable;)V' : ['android.permission.VIBRATE'],
	'Landroid/view/IWindowSession$Stub;-add-(Landroid/view/IWindow; Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/server/connectivity/Tethering;-enableUsbIfaces-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MailboxList;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/app/backup/IRestoreSession$Stub;-restorePackage-(Ljava/lang/String; Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/content/PackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/LocationManager;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/AppPicker;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.SET_DEBUG_APP'],
	'Lcom/android/settings/DisplaySettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/backup/IBackupManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService$SocketAcceptThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/MmsApp;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/CalendarView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/Phone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService;-pause-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-detachPppd-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/provider/Telephony$Mms;-query-(Landroid/content/ContentResolver; [Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Landroid/content/pm/IPackageManager;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/webkit/ContentLoader;-sendHeaders-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/BluetoothService;-setPropertyString-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/media/AudioService$ScoClient;-clearCount-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallCard;-updateNoCall-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-onOnlineModeCheckedStateChanged-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/GsmUmtsCallOptions;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothA2dpService;-access$300-(Landroid/server/BluetoothA2dpService; Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/SlideView;-setAudio-(Landroid/net/Uri; Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingRfcommOn-(I)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/ExternalMediaFormatActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/LocalePicker;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothDevice;-getBluetoothClass-()Landroid/bluetooth/BluetoothClass;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/wifi/WifiSettings;-updateAccessPoints-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker$1;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothA2dpService;-lookupSinksMatchingStates-([I)Ljava/util/Set;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/NotificationPlayer;-startSound-(Lcom/android/server/NotificationPlayer$Command;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/Vibrator;-vibrate-([J I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/HistoryItem$1;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/webkit/WebView;-reload-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/launcher2/WallpaperChooser;-onClick-(Landroid/view/View;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/picasa/PicasaApi;-getAlbums-(Landroid/accounts/AccountManager; Landroid/content/SyncResult; Lcom/cooliris/picasa/UserEntry; Lcom/cooliris/picasa/GDataParser$EntryHandler;)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.INTERNET', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-buildUpdate-(Landroid/content/Context; I)Landroid/widget/RemoteViews;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/fuelgauge/BatteryHistoryDetail;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker;-onActualStateChange-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/AccountManager;-blockingGetAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothManager;-stopScanning-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService$DataRecorder;-<init>-(Landroid/content/Context; Lcom/android/server/ThrottleService;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/term/Term;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SpecialCharSequenceMgr;-handleChars-(Landroid/content/Context; Ljava/lang/String; Z Landroid/widget/EditText;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/BluetoothDevice;-getServiceChannel-(Landroid/os/ParcelUuid;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/cooliris/picasa/PicasaService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/InCallScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-access$300-(Lcom/android/contacts/ContactsListActivity; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-sendLocalChanges-(Lcom/android/exchange/adapter/Serializer;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/cooliris/media/ReverseGeocoder;-computeMostGranularCommonLocation-(Lcom/cooliris/media/MediaSet;)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/NoSearchActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IntentService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityStack;-startPausingLocked-(Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/NetworkManagementService;-setAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/WifiService;-access$300-(Lcom/android/server/WifiService;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatchMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/quicksearchbox/google/GoogleSource;-queryInternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/wifi/WifiApSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/ILlcpSocket$Stub;-getRemoteSocketRw-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/util/EmptyService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/sip/SipAudioCall;-grabWifiHighPerfLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/content/IContentService;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/deskclock/Alarms;-disableAlert-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$3500-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothA2dp;-resumeSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/applications/ApplicationsState$BackgroundHandler$1;-onGetStatsCompleted-(Landroid/content/pm/PackageStats; Z)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/development/ShowActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/data/Contact;-getUri-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/ProxySelector;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-setBatteryState-(I I I I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/ui/ManageSimMessages;-access$500-(Lcom/android/mms/ui/ManageSimMessages; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/util/DraftCache$1;-run-()V' : ['android.permission.READ_SMS'],
	'Landroid/test/IsolatedContext;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/WifiStatusTest;-access$100-(Lcom/android/settings/wifi/WifiStatusTest; Landroid/net/NetworkInfo;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/view/WindowManagerPolicy;-notifyLidSwitchChanged-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/google/common/io/CharStreams;-readLines-(Lcom/google/common/io/InputSupplier; Lcom/google/common/io/LineProcessor;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Landroid/server/BluetoothService;-getAllProperties-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-notifyDefaultData-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-setAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/ui/SlideView$1;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-loadUrl-(Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-exitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub$Proxy;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/nfc/INfcTag;-write-(I Landroid/nfc/NdefMessage;)I' : ['android.permission.NFC'],
	'Landroid/os/storage/StorageManager;-enableUsbMassStorage-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/calendar/WeekView;-updateEventDetails-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-showUnbondMessage-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/SearchResultsActivity;-getContactFilterUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/SettingsLicenseActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-setBondState-(Ljava/lang/String; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ViewContactActivity;-access$100-(Lcom/android/contacts/ViewContactActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/ISipService$Stub;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/cooliris/media/LoadingLayer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Ljava/net/ServerSocket;-bind-(Ljava/net/SocketAddress;)V' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService$2;-getClient-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/cooliris/media/Photographs;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/NfcService$8;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/model/EntitySet;-beginKeepTogether-()Landroid/content/ContentProviderOperation$Builder;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/NetworkManagementService;-listTetheredInterfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$15;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Landroid/app/ActivityGroup;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessageUtils$ResizeImageResultCallback;-onResizeResult-(Lcom/google/android/mms/pdu/PduPart; Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/IMediaScannerListener$Stub;-scanCompleted-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/mms/transaction/SendTransaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/phone/EditPinPreference$OnPinEnteredListener;-onPinEntered-(Lcom/android/phone/EditPinPreference; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-disconnectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/SimCard;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-supplyPuk2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/UsbObserver;-update-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/service/wallpaper/ImageWallpaper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/AudioPreview;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/quicksearchbox/SearchActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/DataLoader;-closeStreamAndSendEndData-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/IActivityManager;-moveTaskToBack-(I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/mms/MmsApp;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneApp;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/ISms;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Landroid/net/http/Connection;-processRequests-(Landroid/net/http/Request;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/connectivity/Tethering;-access$200-(Lcom/android/server/connectivity/Tethering;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver$MyTimerTask$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/ScanningProgress;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-parseIntent-(Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AccountPreferenceBase;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$Settings;-setSetting-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothA2dpService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CallFeaturesSetting;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/nfc/LlcpSocket;-send-([B)V' : ['android.permission.NFC'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-<init>-(Landroid/content/Context; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/HeadsetObserver;-sendIntent-(I I I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager;-removeAccount-(Landroid/accounts/Account; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/app/AlertActivity;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AsyncPlayer;-access$500-(Landroid/media/AsyncPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexServerSession;-preStart-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-(J [B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-open-([J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/EditSlideDurationActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WifiWatchdogService;-requiresWatchdog-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/nfc/ILlcpServiceSocket$Stub;-close-(I)V' : ['android.permission.NFC'],
	'Lcom/android/settings/DebugIntentSender;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatchPortAddressedPdus-([[B I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GpsLocationProvider;-sendMessage-(I I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ClassZeroActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/DialtactsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/AccountSyncSettings;-onSyncStateUpdated-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/stk/IconLoader;-readId-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipManager;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/calendar/CalendarActivity;-switchViews-(Z F F)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/vpn/L2tpIpsecService;-onDisconnect-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-hangupConnectionByIndex-(Lcom/android/internal/telephony/gsm/GsmCall; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadService;-access$1000-(Lcom/android/providers/downloads/DownloadService; J)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-enqueue-([J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/SmsReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupOptions;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/net/wifi/WifiManager;-initializeMulticastFiltering-()Z' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/browser/BrowserYesNoPreference;-onDialogClosed-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/data/Conversation$3;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/content/ContentService;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/mms/transaction/PushReceiver;-access$100-(Landroid/content/Context; Lcom/google/android/mms/pdu/NotificationInd;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-isNetworkConnected-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SlideView;-stopVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EmergencyCallbackModeService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ClassZeroActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/Observer;-update-(Lcom/android/mms/transaction/Observable;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-transceive-(I [B)[B' : ['android.permission.NFC'],
	'Lcom/android/phone/EmergencyCallHandler;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebView;-invokeZoomPicker-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherMasterUtilState;-chooseUpstreamType-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingA2dp;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHeadsetService;-access$2400-(Lcom/android/phone/BluetoothHeadsetService; Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/BrowserSettings;-clearHistory-(Landroid/content/Context;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/soundrecorder/SoundRecorder;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/RecognitionManagerService$MyPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-confirmCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/PackageManagerBackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderStatus-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/settings/TextToSpeechSettings;-initDefaultSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(Ljava/lang/String; J F Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/AbstractSyncService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/RepeatingImageButton;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/MessagingListener;-synchronizeMailboxFailed-(J J Ljava/lang/Exception;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/BandMode;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherMasterUtilState;-turnOnMobileConnection-()I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-doActivityResultValidateExistingAccount-(I Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/LocationManager;-_requestLocationUpdates-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/SelectCalendarsAdapter$RefreshCalendars;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/RIL;-iccIO-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/SpeechRecognizer;-access$200-(Landroid/speech/SpeechRecognizer;)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-removeServiceRecord-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/ProxySelector;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManagerService;-addAcount-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/DeviceInfoSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WindowManagerService;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/ui/ComposeMessageActivity$11;-run-()V' : ['android.permission.READ_SMS'],
	'Landroid/os/INetworkManagementService$Stub;-untetherInterface-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/email/activity/AccountFolderList;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/InputMethodService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-supplyPin-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/voicedialer/VoiceDialerActivity$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/SlidingTab;-setGrabbedState-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/ApnEditor;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/service/wallpaper/ImageWallpaper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/SetAlarm;-saveAlarmAndEnableRevert-()J' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/IContentService$Stub;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/AccelerometerListener;-onSensorEvent-(D D D)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$Future2Task;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/svox/pico/Pico;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/AbstractThreadedSyncAdapter$ISyncAdapterImpl;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-systemReady-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-otaShowInProgressScreen-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Conversation;-get-(Landroid/content/Context; J Z)Lcom/android/mms/data/Conversation;' : ['android.permission.READ_SMS'],
	'Lcom/android/providers/downloads/DownloadService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IContentService$Stub;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$11;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothAtPhonebook$1;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneProxy;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-disconnectHeadset-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/stk/CommandParamsFactory;-processDisplayText-(Lcom/android/internal/telephony/gsm/stk/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-setRadio-(I Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/AccountSyncSettingsInAddAccount;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getIccCardStatus-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/PackageManagerBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiSettings;-forget-(I)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/sip/SipService;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/cooliris/media/RenderView;-processTouchEvent-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AppWidgetPickActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/TelephonyRegistry;-broadcastDataConnectionStateChanged-(I Z Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothA2dp;-disconnectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BackupManagerService$PerformClearTask;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/policy/StatusBarPolicy$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/contacts/RecentCallsListActivity;-resetNewCallsFlag-()V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/camera/NoSearchActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/stk/RilMessageDecoder$StateCmdParamsReady;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothA2dp;-disconnectSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupCheckSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/SyncActivityTooManyDeletes;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteEventInternal-(J Z Z)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/util/Recycler;-deleteOldMessages-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/development/SyncAdapterDriver;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub;-getTrustState-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/calendar/CalendarProvider2;-updateEventAttendeeStatus-(Landroid/database/sqlite/SQLiteDatabase; Landroid/content/ContentValues;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/wifi/AdvancedSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/util/HierarchicalStateMachine$HsmHandler;-invokeExitMethods-(Lcom/android/internal/util/HierarchicalStateMachine$HsmHandler$StateInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/provider/GalEmailAddressAdapter;-runQueryOnBackgroundThread-(Ljava/lang/CharSequence;)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth;-cancelBondProcess-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/picasa/GDataClient;-delete-(Ljava/lang/String; Lcom/cooliris/picasa/GDataClient$Operation;)V' : ['android.permission.INTERNET'],
	'Landroid/net/http/Request;-readResponse-(Landroid/net/http/AndroidHttpClientConnection;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/wifi/AdvancedSettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/LatinKeyboardBaseView;-onDownEvent-(Lcom/android/inputmethod/latin/PointerTracker; I I J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/settings/fuelgauge/PowerUsageDetail;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/CalendarView;-initView-(Lcom/android/calendar/CalendarView;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/development/Connectivity$11;-onClick-(Landroid/view/View;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ShutdownActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/OtaUtils;-otaShowProgramSuccessDialog-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManagerService;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/accounts/AccountManager$GetAuthTokenByTypeAndFeaturesTask;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothService;-isBondingFeasible-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BrowserActivity;-packageChanged-(Ljava/lang/String; Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/quicksearchbox/SearchActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/TextToSpeechSettings;-access$000-(Lcom/android/settings/TextToSpeechSettings;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ResolverActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/data/WorkingMessage;-updateDraftSmsMessage-(J Ljava/lang/String;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/quicksearchbox/SearchWidgetConfigActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/soundrecorder/SoundRecorder;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManager;-getRunningTasks-(I I Landroid/app/IThumbnailReceiver;)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-playSound-(I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/phone/BluetoothAtPhonebook$2;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager;-getAccountsByTypeAndFeatures-(Ljava/lang/String; [Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth;-createBond-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub$Proxy;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/GetPin2Screen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/AccountSyncSettingsInAddAccount;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/settings/ManageAccountsSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/MessagingNotification;-updateSendFailedNotificationForThread-(Landroid/content/Context; J)V' : ['android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary$LoadDictionaryTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-onNext-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/HapticFeedback;-vibrate-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/DockSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-getAllThreads-(Landroid/content/Context;)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Lcom/android/calendar/CalendarActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/RingtoneManager;-stopPreviousRingtone-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/BackupAgentHelper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CdmaCallOptions;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ui/ShowOrCreateActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/DevelopmentSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/cooliris/cache/CacheService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/SoundSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ui/EditContactActivity$QueryEntitiesTask;-doInBackground-(Ljava/lang/Object; [Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ConnectivityService;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity$ContactItemListAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/SipManager;-getSessionFor-(Landroid/content/Intent;)Landroid/net/sip/SipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/PhotoAppWidgetConfigure;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiManager;-isWifiEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothA2dpService;-getSinkPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-enableWifi-(Z)I' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/IBluetoothPbap$Stub;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/BackupManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StartTetheringErrorState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/LatinIME;-onKey-(I [I I I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-endFile-(Landroid/media/MediaScanner$FileCacheEntry; Z Z Z Z Z)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/policy/impl/RecentApplicationsDialog;-onStart-()V' : ['android.permission.GET_TASKS'],
	'Ljava/net/URL;-getContent-()Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/settings/BandMode;-loadBandList-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/tts/TtsService;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/stk/RilMessageDecoder;-decodeMessageParams-(Lcom/android/internal/telephony/gsm/stk/RilMessage;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset;-connectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-requestRouteToHost-(I I)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/nfc/IP2pTarget;-getMode-(I)I' : ['android.permission.NFC'],
	'Lcom/android/server/ConnectivityService;-enforceTetherChangePermission-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/server/BluetoothEventLoop;-onRequestPasskeyConfirmation-(Ljava/lang/String; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/SecurityPolicy;-policiesRequired-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppIncomingFileConfirmActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/SlideView;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService$Receiver;-decrementPendingBroadcastsLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/IContentService$Stub$Proxy;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/systemui/statusbar/StatusBarService$6;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/contacts/ImportVCardActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/PhoneDisambigDialog$PhonesAdapter;-<init>-(Landroid/content/Context; Ljava/util/List; Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-proceedAfterWildChar-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-listen-(Ljava/lang/String; Lcom/android/internal/telephony/IPhoneStateListener; I Z)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/ConnectivityManager;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/AdnRecordCache;-requestLoadAllAdnLike-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/Settings$MyHandler;-resetNetworkModeToDefault-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/util/EmptyService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/statusbar/policy/StatusBarPolicy;-access$400-(Lcom/android/systemui/statusbar/policy/StatusBarPolicy; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/AccessibilitySettings;-access$100-(Lcom/android/settings/AccessibilitySettings;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/backup/IBackupManager$Stub;-setBackupEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/EmergencyDialer;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/SyncAdapterDriver;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/phone/PhoneUtils$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/TelephonyManager;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/latin/PointerTracker;-detectAndSendKey-(I I I J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/phone/GsmUmtsCallForwardOptions;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ApnSettings;-restoreDefaultApn-()Z' : ['android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/MediaFormat;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/DevelopmentSettings;-access$1400-(Lcom/android/development/DevelopmentSettings;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/INetworkManagementService$Stub;-enableNat-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/provider/Browser;-updateVisitedHistory-(Landroid/content/ContentResolver; Ljava/lang/String; Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/LocationManagerService;-requestLocationUpdatesLocked-(Ljava/lang/String; J F Z Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ui/EditContactActivity$PersistTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/DockService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ThrottleService$DataRecorder;-getDataFile-()Ljava/io/File;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/exchange/CalendarSyncAdapterService$SyncAdapterImpl;-onPerformSync-(Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/SyncManager;-runAccountReconciler-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-updateSpnDisplay-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/SizeLimitActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/PackageSummary;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IAlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/phone/BluetoothHandsfree$18;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/INetworkManagementService;-startAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/os/storage/IMountService;-unmountVolume-(Ljava/lang/String; Z)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/calendar/EventInfoActivity;-initAttendeesCursor-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/MmsThumbnailPresenter;-presentVideoThumbnail-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/VideoModel;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SuggestionCursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipAudioCallAdapter;-onCallEnded-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSecurity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/model/VideoModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper; Lcom/android/mms/model/RegionModel;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/AudioPreview;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/Ringer;-ring-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/packageinstaller/UninstallerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ContextImpl;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/IWifiManager$Stub;-reconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-checkForDeviceRemoval-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/setup/AccountSetupIncoming;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-handleTimeout-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/Recorder;-startRecording-(I Ljava/lang/String; Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO'],
	'Lcom/android/contacts/ViewContactActivity$1;-onChange-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/app/backup/IBackupManager;-clearBackupData-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-disconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/sip/SipSettings;-retrieveSipLists-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService;-enforceAccessPermission-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsLiveFolders$PhoneContacts;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/quicksearchbox/QsbApplicationWrapper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/deviceinfo/Memory;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/cooliris/media/Photographs;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/IWindowSession$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/net/ConnectivityManager;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/Details;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/LocationManager;-setTestProviderLocation-(Ljava/lang/String; Landroid/location/Location;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/settings/ManageAccountsSettings;-updateAuthDescriptions-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-getCellBroadcastSmsConfig-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$HeadsetProfileManager;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/CalendarPreferenceActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/NativeActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ui/EditContactActivity;-access$300-(Lcom/android/contacts/ui/EditContactActivity; Landroid/accounts/Account;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/EnterURL;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/LocalePicker;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/phone/InCallMenuView;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DisplaySettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager$Stub;-setNetworkPreference-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/ContactsLiveFolders$StarredContacts;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteOldMessagesByThreadId-(Landroid/content/Context; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/test/mock/MockContentResolver;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/SlideEditorActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/IWifiManager;-setNumAllowedChannels-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-doScanFile-(Ljava/lang/String; Ljava/lang/String; J J Z)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/term/TermPreferences;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/nfc/LlcpConnectionlessSocket;-getSap-()I' : ['android.permission.NFC'],
	'Lcom/android/phone/PhoneApp;-access$1300-(Lcom/android/phone/PhoneApp; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/am/ActivityManagerService;-ensureBootCompleted-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/IAudioService$Stub$Proxy;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/InCallScreen;-onDisconnect-(Landroid/os/AsyncResult;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasOutboxService;-runAccountMailbox-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/test/RenamingDelegatingContext;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiManager;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/nfc/ILlcpSocket;-getRemoteSocketRw-(I)I' : ['android.permission.NFC'],
	'Landroid/bluetooth/IBluetoothA2dp;-resumeSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/SettingsSafetyLegalActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/DeleteFdnContactScreen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/quicksearchbox/SearchSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/WindowManagerService;-setHoldScreenLocked-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity$4;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-onActualStateChange-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-setFacilityLock-(Ljava/lang/String; Z Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Landroid/webkit/Network;-getInstance-(Landroid/content/Context;)Landroid/webkit/Network;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/NetworkManagementService;-getInterfaceThrottle-(Ljava/lang/String; Z)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/SlideViewInterface;-startVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiApEnabler;-access$100-(Lcom/android/settings/wifi/WifiApEnabler; [Ljava/lang/Object; [Ljava/lang/Object; [Ljava/lang/Object;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/server/search/SearchManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/ContentResolver;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/INotificationManager$Stub;-enqueueNotificationWithTag-(Ljava/lang/String; Ljava/lang/String; I Landroid/app/Notification; [I)V' : ['android.permission.VIBRATE'],
	'Landroid/nfc/ILlcpSocket$Stub$Proxy;-getLocalSap-(I)I' : ['android.permission.NFC'],
	'Lcom/android/providers/applications/ApplicationLauncher;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/certinstaller/CertInstallerMain;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver;-access$1300-(Lcom/android/server/sip/SipService$ConnectivityReceiver; Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/quicksearchbox/QsbApplicationWrapper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothPbap$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-processMessagePart-(Lcom/android/internal/telephony/SmsMessageBase; Lcom/android/internal/telephony/SmsHeader$ConcatRef; Lcom/android/internal/telephony/SmsHeader$PortAddrs;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/ContactsProvider2;-onLegacyContactImportFailure-()V' : ['android.permission.VIBRATE'],
	'Landroid/net/IConnectivityManager$Stub;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub;-acquireMulticastLock-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/server/HeadsetObserver;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentResolver;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/music/DeleteItems;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService$ScoClient;-binderDied-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AddAccountSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/ConnectivityManager;-getTetherableUsbRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-powerOffRadioSafely-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallCard;-updateRingingCall-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/Phone;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/term/TermPreferences;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ChooseLockPatternExample;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/commands/bmgr/Bmgr;-run-([Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/SyncManager;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mms/transaction/TransactionService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/IApplicationToken;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accounts/AccountManager$1;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/Application;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WifiService;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/music/AudioPreview;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/WifiEnabler;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BrowserBookmarksPage$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-access$1000-(Lcom/android/contacts/ContactsListActivity; Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/AgendaActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-addJavascriptInterface-(Ljava/lang/Object; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/util/Recycler$SmsRecycler;-deleteOldMessagesByThreadId-(Landroid/content/Context; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/nfc/INfcTag$Stub;-transceive-(I [B)[B' : ['android.permission.NFC'],
	'Landroid/app/Activity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/WeekActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/DriverCall; Lcom/android/internal/telephony/cdma/CdmaCallTracker; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-sendServiceArgsLocked-(Lcom/android/server/am/ServiceRecord; Z)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/activity/setup/AccountSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasSyncService;-acknowledgeProvision-(Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarView$ContextMenuHandler;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/providers/contacts/SocialProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Landroid/accounts/AccountAuthenticatorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NotificationManagerService;-updateAdbNotification-(Z)V' : ['android.permission.VIBRATE'],
	'Landroid/nfc/IP2pInitiator;-getMode-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/cdma/CdmaCallWaitingNotification; Lcom/android/internal/telephony/cdma/CdmaCallTracker; Lcom/android/internal/telephony/cdma/CdmaCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ManageSimMessages;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice$Callback;-onDeviceAttributesChanged-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MessageView;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiApEnabler$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/music/MediaPlaybackActivity$9;-onRepeat-(Landroid/view/View; J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageCompose;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$30;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/ConnectivityService;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setSystemLocale-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Landroid/net/wifi/IWifiManager$Stub;-reassociate-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-runPingTest-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/deskclock/AlarmClock$AlarmTimeAdapter$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/PowerDialog;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/nfc/NfcService$2;-createLlcpServiceSocket-(I Ljava/lang/String; I I I)I' : ['android.permission.NFC'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$SetIpForwardingEnabledErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/EventInfoActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-restartRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/DownloadThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/EasAuthenticatorService$EasAuthenticator;-addAccount-(Landroid/accounts/AccountAuthenticatorResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/phone/DeleteFdnContactScreen;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/SoundSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$4;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-parse-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/BluetoothHeadsetService;-access$1700-(Lcom/android/phone/BluetoothHeadsetService; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/UsageStats;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/IMediaPlaybackService;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-setBackupProvisioned-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioService;-checkAudioSettingsPermission-(Ljava/lang/String;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/ContactsUtils;-queryForRawContactId-(Landroid/content/ContentResolver; J)J' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/development/PointerLocation;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/Browser;-getAllBookmarks-(Landroid/content/ContentResolver;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/PhoneBase;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-selectNetworkManually-(Lcom/android/internal/telephony/gsm/NetworkInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/VibratorService$VibrateThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/UiModeManagerService;-updateConfigurationLocked-(Z)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/phone/EnableIccPinScreen;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/KeyguardViewCallback;-keyguardDoneDrawing-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/WifiWatchdogService;-hasRequiredNumberOfAps-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/cooliris/media/LoadingLayer;-onSurfaceCreated-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onDataSetupComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handleEnterEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-prev-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$26;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/provider/ExchangeProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/IBatteryStats;-getAwakeTimeBattery-()J' : ['android.permission.BATTERY_STATS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnection;-makeDataConnection-(Lcom/android/internal/telephony/gsm/GSMPhone;)Lcom/android/internal/telephony/gsm/GsmDataConnection;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/provider/EmailProvider$DatabaseHelper;-onUpgrade-(Landroid/database/sqlite/SQLiteDatabase; I I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/MmsApp;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/CalendarActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/os/IVibratorService;-cancelVibrate-(Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/SecuritySettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/Email;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/TestListActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/storage/IMountService$Stub;-shutdown-(Landroid/os/storage/IMountShutdownObserver;)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-resumeSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/vpn/L2tpIpsecPskService;-onError-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppManager;-disableBluetooth-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/IP2pInitiator$Stub$Proxy;-receive-(I)[B' : ['android.permission.NFC'],
	'Lcom/android/browser/Tab$3;-access$1200-(Lcom/android/browser/Tab$3; Z Landroid/os/Message;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/MessageUtils$4;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_SMS'],
	'Lcom/cooliris/media/PhotoAppWidgetBind;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/Wallpaper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-processCdmaWapPdu-([B I Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-setProcessForeground-(Landroid/os/IBinder; I Z)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-pollCallsWhenSafe-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/ui/DownloadList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/MessageCompose;-processSourceMessageGuarded-(Lcom/android/email/provider/EmailContent$Message; Lcom/android/email/provider/EmailContent$Account;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/OutgoingCallBroadcaster$OutgoingCallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatchMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-cancelPendingUssd-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-setDnsForwarders-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager;-getNetworkPreference-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/VibratorService;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/nfc/NfcService$3;-getLocalSocketMiu-(I)I' : ['android.permission.NFC'],
	'Lcom/android/browser/Bookmarks;-removeFromBookmarks-(Landroid/content/Context; Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/http/RequestQueue;-setProxyConfig-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/LoadListener;-handleAuthResponse-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/cooliris/picasa/PicasaContentProvider;-syncAlbumPhotos-(J Z Landroid/content/SyncResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/ViewContactActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SearchResultsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SearchResultsActivity;-access$400-(Lcom/android/contacts/ContactsListActivity;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/music/QueryBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen$CheckSimPin;-onSimLockChangedResponse-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/server/BluetoothService;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/LocationManagerService$Receiver;-access$700-(Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/service/IEmailService$Stub$Proxy;-validate-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I Z Z)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/ChoiceActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/Tab$2;-onUnhandledKeyEvent-(Landroid/webkit/WebView; Landroid/view/KeyEvent;)V' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService$2;-getProperties-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.NFC'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-stopVoiceRecognition-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BrowserPreferencesPage;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/ConnectivityService;-enforceTetherAccessPermission-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth;-startDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/IBatteryStats;-getAwakeTimePlugged-()J' : ['android.permission.BATTERY_STATS'],
	'Lcom/android/phone/PhoneApp;-dismissCallScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothDevice;-getTrustState-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/SendTransaction;-notifyObservers-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHandsfree$28;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasOutboxService;-canProvision-()Lcom/android/exchange/adapter/ProvisionParser;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccCard;-handleIccCardStatus-(Lcom/android/internal/telephony/IccCardStatus;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmKlaxon;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/Ringer$VibratorThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/email/GroupMessagingListener;-synchronizeMailboxStarted-(J J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/model/TextModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper; Lcom/android/mms/model/RegionModel;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/ThrottleService;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ui/EditContactActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallHeld-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/DayView;-setSelectedDay-(Landroid/text/format/Time;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/email/activity/MessageCompose;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WifiWatchdogService;-access$900-(Lcom/android/server/WifiWatchdogService; Lcom/android/server/WifiWatchdogService$AccessPoint;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifySendFailed-(Landroid/content/Context;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SMS'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/data/WorkingMessage;-readDraftSmsMessage-(Lcom/android/mms/data/Conversation;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHeadsetService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/AdvancedSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Conversation;-access$1000-(Landroid/content/Context;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/Settings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/widget/BookmarkWidgetService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/providers/downloads/DownloadService$1;-scanCompleted-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-doKeyguardTimeout-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-playSounds-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageListAdapter$AvatarCache$1;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/accounts/AccountManager$6;-start-()Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/sip/SipManager;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/SipRegistrationListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/app/NetInitiatedActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-acknowledgeLastIncomingGsmSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-setCdmaBroadcastActivation-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService$MyHandler;-onRebootRecovery-()V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/StreamLoader;-sendData-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/ActivityManagerNative;-signalPersistentProcesses-(I)V' : ['android.permission.SIGNAL_PERSISTENT_PROCESSES'],
	'Lcom/android/email/activity/MessageView;-messageChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/PhoneApp;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Ljava/net/URL;-openConnection-()Ljava/net/URLConnection;' : ['android.permission.INTERNET'],
	'Lcom/android/settings/PrivacySettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/NotificationMgr;-notifyMissedCall-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/WebView;-clearTextEntry-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/LatinKeyboardView;-invokeOnKey-(I)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/ContentService;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/settings/wifi/WifiApSettings;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-connectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-launchHomeFromHotKey-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/IccFileHandler;-loadEFImgTransparent-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayView;-init-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/email/activity/MessageView;-moveToNewer-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-broadcastIntentLocked-(Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Landroid/content/Intent; Ljava/lang/String; Landroid/content/IIntentReceiver; I Ljava/lang/String; Landroid/os/Bundle; Ljava/lang/String; Z Z I I)I' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/HeadsetBase;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/SmsMessageSender;-getOutgoingServiceCenter-(J)Ljava/lang/String;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/webkit/FileLoader;-closeStreamAndSendEndData-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/ActivityPicker;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/AccountManagerService;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/view/WindowManagerPolicy$WindowState;-hideLw-(Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/voicedialer/RecognizerEngine;-onRecognitionSuccess-(Lcom/android/voicedialer/RecognizerClient;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleClose-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/policy/impl/LockScreen;-updateConfiguration-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/speech/SpeechRecognizer;-access$000-(Landroid/speech/SpeechRecognizer; Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-removeTrack-(J)I' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/ContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-reRegisterNetwork-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/Layer;-update-(Lcom/cooliris/media/RenderView; F)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnection;-tearDownData-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/calendar/CalendarProvider2;-rescheduleMissedAlarms-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/BluetoothHandsfree;-expectCallStart-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/vpn/VpnService$NotificationHelper;-showDisconnect-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/email/activity/AccountFolderList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-rejectCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/vpn/VpnTypeSelection;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/ContactsContract$Groups$EntityIteratorImpl;-next-()Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/SyncManager$EasSyncStatusObserver;-onStatusChanged-(I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-scanFile-(Ljava/lang/String; J J)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipAudioCallAdapter;-onError-(Lcom/android/internal/telephony/Connection$DisconnectCause;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$8;-start-()Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/WifiService;-pingSupplicant-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/calendar/AgendaWindowAdapter;-queueQuery-(I I Landroid/text/format/Time; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/DayActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/DockService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver;-onChanged-(Ljava/lang/String; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/Gallery;-access$100-(Lcom/cooliris/media/Gallery;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/DeviceInfoSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/userdictionary/DictionaryBackupAgent;-getDictionary-()[B' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/CommandsInterface;-getIccCardStatus-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSecurity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/LocationManagerService;-access$800-(Lcom/android/server/LocationManagerService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/SearchResultsActivity;-returnPickerResult-(Landroid/database/Cursor; Ljava/lang/String; Landroid/net/Uri; I)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getVoiceMailAlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/latin/PointerTracker;-onMoveEvent-(I I J)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/email/service/EmailServiceProxy$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/app/App;-<init>-(Landroid/content/Context;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-notifyAndAcknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/applications/InstalledAppDetails;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/cooliris/media/Gallery;-access$000-(Lcom/cooliris/media/Gallery;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/UserDictionarySettings;-createCursor-()Landroid/database/Cursor;' : ['android.permission.READ_USER_DICTIONARY'],
	'Landroid/nfc/ILlcpConnectionlessSocket;-close-(I)V' : ['android.permission.NFC'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleSeparator-(I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/mms/ui/ManageSimMessages;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/am/ActivityManagerService;-setDebugApp-(Ljava/lang/String; Z Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.SET_DEBUG_APP'],
	'Lcom/android/settings/bluetooth/LocalBluetoothManager;-setBluetoothStateInt-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/picasa/GDataClient;-put-(Ljava/lang/String; [B Ljava/lang/String; Lcom/cooliris/picasa/GDataClient$Operation;)V' : ['android.permission.INTERNET'],
	'Landroid/app/ActivityManagerNative;-moveTaskBackwards-(I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/development/ProcessInfo;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/NoSearchActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/MailService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-access$300-(Lcom/android/server/am/ActivityManagerService; Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-doContactDelete-(Landroid/net/Uri;)V' : ['android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/PhoneUtils$4;-onQueryComplete-(I Ljava/lang/Object; Lcom/android/internal/telephony/CallerInfo;)V' : ['android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/PackageManagerBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager$Stub;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/EnterURL;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/ContentResolver;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/MailService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ClassZeroActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/ShutdownThread;-run-()V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/EmergencyCallbackModeService;-access$000-(Lcom/android/phone/EmergencyCallbackModeService; Landroid/os/AsyncResult;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-getLastCallFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/IEmailService$Stub$Proxy;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService$Stub;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Landroid/content/MutableContextWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/AccelerometerListener;-setOrientation-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-moveTaskToBack-(I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/mms/transaction/MessageStatusReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/svox/pico/Pico;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calculator2/Calculator;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebViewCore;-setupViewport-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onUserInteraction-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/AddAccountSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-setPreferredApn-(I)V' : ['android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/internal/telephony/Phone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BootReceiver;-access$100-(Lcom/android/server/BootReceiver; Landroid/content/Context;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/mms/ui/AudioAttachmentView$2;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/DisableCarModeActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ProxySelector$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/test/IsolatedContext;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/google/common/io/CharStreams;-copy-(Lcom/google/common/io/InputSupplier; Ljava/lang/Appendable;)J' : ['android.permission.INTERNET'],
	'Lcom/android/nfc/NfcService$3;-getLocalSap-(I)I' : ['android.permission.NFC'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/CacheLoader;-sendHeaders-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/deviceinfo/Memory;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/IP2pTarget$Stub;-disconnect-(I)Z' : ['android.permission.NFC'],
	'Lcom/android/contacts/ContactsLiveFolders$AllContacts;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/NotificationTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/IConnectivityManager;-getTetherableUsbRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/DevelopmentSettings$AnimationScaleSelectedListener;-onItemSelected-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.SET_ANIMATION_SCALE'],
	'Lcom/android/music/MediaPlaybackService;-notifyChange-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/google/common/io/CharStreams$2;-getInput-()Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/server/WallpaperManagerService$MyPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/TrackBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getTrustState-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MediaPlaybackService;-closeExternalStorageFiles-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/FdnList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/ContentService;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/provision/DefaultActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothAdapter;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/CalendarActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/AppPicker;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/MessageListAdapter$AvatarCache$ContactData;-startInitialQuery-()Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MediaPickerActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getVoiceMailAlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-simulateDataConnection-(Lcom/android/internal/telephony/Phone$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$A2dpProfileManager;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/quicklaunch/BookmarkPicker;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/userdictionary/DictionaryBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I Ljava/util/Map;)V' : ['android.permission.INTERNET'],
	'Lcom/android/music/VideoBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity;-access$300-(Lcom/android/contacts/ContactsListActivity; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcAdapter$Stub;-getP2pInitiatorInterface-()Landroid/nfc/IP2pInitiator;' : ['android.permission.NFC'],
	'Landroid/net/wifi/WifiManager;-getConnectionInfo-()Landroid/net/wifi/WifiInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/WeekView;-initView-(Lcom/android/calendar/CalendarView;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/PowerManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/downloads/Helpers;-isNetworkAvailable-(Lcom/android/providers/downloads/SystemFacade;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/util/CalendarUtils$TimeZoneUtils;-forceDBRequery-(Landroid/content/Context; Ljava/lang/Runnable;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/transaction/TransactionService;-update-(Lcom/android/mms/transaction/Observable;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/settings/UserDictionarySettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmMmiCode;-onQueryCfComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-updateRemoteDevicePropertiesCache-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/TimeConsumingPreferenceActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/PermissionDetails;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/svc/DataCommand;-run-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/MessageList;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NetworkManagementService;-isTetheringStarted-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/location/GpsLocationProvider;-access$1000-(Lcom/android/server/location/GpsLocationProvider; I Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IVibratorService$Stub$Proxy;-vibrate-(J Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/development/ProcessInfo;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-gotoIdleAndNotifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/LocationManagerService;-_getLastKnownLocationLocked-(Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-anyThreadOverLimit-(Landroid/content/Context;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker$1;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothService;-setPin-(Ljava/lang/String; [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/DevelopmentSettings;-access$700-(Lcom/android/development/DevelopmentSettings;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/setup/AccountSetupCheckSettings$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/FrameLoader;-executeLoad-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/WifiService;-acquireWifiLock-(Landroid/os/IBinder; I Ljava/lang/String; Landroid/os/WorkSource;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-disconnectConnected-(Lcom/android/settings/bluetooth/CachedBluetoothDevice; Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$Profile;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsListActivity;-onSearchTextChanged-()V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-prev-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/AlertActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/PhotoAppWidgetConfigure;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/NfcService$3;-getLocalSocketRw-(I)I' : ['android.permission.NFC'],
	'Landroid/net/wifi/WifiStateTracker$SettingsObserver;-onChange-(Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasSyncService;-sendHttpClientPost-(Ljava/lang/String; Lorg/apache/http/HttpEntity;)Lorg/apache/http/HttpResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/TransactionService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/http/Connection;-openHttpConnection-(Landroid/net/http/Request;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/WallpaperManager;-setBitmap-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-setCallWaiting-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/SipBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.USE_SIP'],
	'Landroid/content/ContentService;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mms/util/Recycler$SmsRecycler;-getAllThreads-(Landroid/content/Context;)Landroid/database/Cursor;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHandsfree$25;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-shutdown-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaMmiCode;-processCode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/Helpers;-chooseFullPath-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I J)Ljava/lang/String;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/net/wifi/IWifiManager$Stub;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/Downloads$ById;-openDownloadStream-(Landroid/content/Context; J)Ljava/io/InputStream;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/mms/ui/SlideshowEditActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/NfcService$5;-getSap-(I)I' : ['android.permission.NFC'],
	'Landroid/webkit/WebView;-stopLoading-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/test/SyncBaseInstrumentation;-cancelSyncsandDisableAutoSync-()V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/voicedialer/VoiceDialerActivity$CommandRecognizerClient$2;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/calendar/MonthView;-drawBox-(I I I I Landroid/graphics/Canvas; Landroid/graphics/Paint; Landroid/graphics/Rect; Z)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/transaction/TransactionService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/VibratorService;-access$300-(Lcom/android/server/VibratorService;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-reassociate-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/BluetoothHandsfree;-expectVoiceRecognition-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallFeaturesSetting;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-editSlideshow-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/BandMode;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/ChooseLockPassword;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.PROCESS_OUTGOING_CALLS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/IccLockSettings;-onPinEntered-(Lcom/android/settings/EditPinPreference; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService$8$1;-run-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/transaction/NotificationTransaction;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/TransactionService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree;-access$5700-(Lcom/android/phone/BluetoothHandsfree;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarApplication;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/LocationManager;-getBestProvider-(Landroid/location/Criteria; Z)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/RetryScheduler;-isConnected-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/CombinedBookmarkHistoryActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/VoiceInputOutputSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub;-getRemoteUuids-(Ljava/lang/String;)[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker$1;-onPostExecute-(Ljava/lang/Boolean;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/SelectCalendarsActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/NetworkManagementService;-detachPppd-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/ManageAccountsSettings$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-access$1200-(Lcom/android/bluetooth/pbap/BluetoothPbapService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-expand-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/soundrecorder/SoundRecorder;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/LocationManager;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserBookmarksPage;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/model/TextModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/NetworkManagementService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/SoundSettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/VideoCamera;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/Tab$SubWindowClient;-onReceivedHttpAuthRequest-(Landroid/webkit/WebView; Landroid/webkit/HttpAuthHandler; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/AgendaActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/PhysicalKeyboardSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/DataConnection$DcActiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewCore$EventHub;-sendMessageAtFrontOfQueue-(Landroid/os/Message;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-getType-(I)Ljava/lang/String;' : ['android.permission.NFC'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/SearchWidgetConfigActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$16;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/cooliris/media/PathBarLayer;-onSurfaceCreated-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IRestoreSession$Stub$Proxy;-restoreAll-(J Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/phone/Settings$MyHandler;-handleGetPreferredNetworkTypeResponse-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/WifiService;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/server/BluetoothService;-getRemoteUuids-(Ljava/lang/String;)[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Landroid/speech/RecognitionService;-access$600-(Landroid/speech/RecognitionService; Landroid/speech/IRecognitionListener;)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/sip/SipPhone;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onEnableApn-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$18;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getSmsReportItems-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/RIL;-setGsmBroadcastActivation-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/GsmUmtsCallOptions;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothEnabler;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BrowserActivity;-closeCurrentWindow-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/google/android/mms/util/PduCache;-put-(Ljava/lang/Object; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager$Stub;-getDhcpInfo-()Landroid/net/DhcpInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/VibratorService;-startNextVibrationLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NotificationPlayer;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AddBookmarkPage;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/MonthActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setPairingConfirmation-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/SyncManager;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/DeviceInfoSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SearchResultsActivity;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-handleImportRequest-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Landroid/test/RenamingDelegatingContext;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/IRecognitionService$Stub$Proxy;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/ITelephony;-supplyPin-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/CreatePlaylist;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/MessageList;-onRefresh-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/nfc/NfcService$5;-close-(I)V' : ['android.permission.NFC'],
	'Lcom/cooliris/picasa/PicasaApi;-deleteEntry-(Ljava/lang/String;)I' : ['android.permission.INTERNET'],
	'Landroid/server/BluetoothEventLoop;-onDevicePropertyChanged-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/location/GpsLocationProvider;-handleUpdateNetworkState-(I Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$SyncHandler;-runBoundToSyncAdapter-(Landroid/content/ISyncAdapter;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-setShuffleMode-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CallNotifier;-onUnknownConnectionAppeared-(Landroid/os/AsyncResult;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/AccountFolderList;-onRefresh-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/mail/Store;-autoDiscover-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-moveQueueItem-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/DayActivity;-goToToday-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/email/mail/store/ImapStore;-autoDiscover-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/PointerLocation;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ui/EditContactActivity;-compare-(Lcom/android/contacts/model/EntityDelta; Lcom/android/contacts/model/EntityDelta;)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/VoiceInputOutputSettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-sendPdu-([B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/WebView$10;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/certinstaller/CertFileList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/NdefTagConnection;-<init>-(Landroid/nfc/NfcAdapter; Landroid/nfc/NdefTag;)V' : ['android.permission.NFC'],
	'Lcom/android/development/AccountsTester;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/ActiveWallpaper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/LockScreen;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/media/AudioService;-startBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/InputMethodManagerService;-<init>-(Landroid/content/Context; Lcom/android/server/StatusBarManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioManager;-setParameters-(Ljava/lang/String;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-connectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/ApplicationSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AlertService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-notifyAndAcknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-clearSslPreferences-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-onDeviceAttributesChanged-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/provision/DefaultActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/VideoBrowserActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/ChooserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-setDateFormat-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneFactory;-makeSipPhone-(Ljava/lang/String;)Lcom/android/internal/telephony/sip/SipPhone;' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/LatinIME;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/IMediaPlaybackService;-moveQueueItem-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$SetIpForwardingDisabledErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/sip/SipSessionGroup;-processRequest-(Ljavax/sip/RequestEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPassword-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/quicksearchbox/QsbApplicationWrapper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/model/ImageModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardViewProperties;-createKeyguardView-(Landroid/content/Context; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardWindowController;)Lcom/android/internal/policy/impl/KeyguardViewBase;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/CallNotifier;-onMwiChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/InCallScreen;-access$1400-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ManageSimMessages;-deleteFromSim-(Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/server/BluetoothA2dpService;-access$000-(Landroid/server/BluetoothA2dpService;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangupWaitingOrBackground-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothAtPhonebook;-access$500-(Lcom/android/phone/BluetoothAtPhonebook; Ljava/lang/String; Z)Lcom/android/phone/BluetoothAtPhonebook$PhonebookResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/development/AppHwConfigList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppManager;-getDeviceName-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/cooliris/media/AdaptiveBackgroundTexture;-load-(Lcom/cooliris/media/RenderView;)Landroid/graphics/Bitmap;' : ['android.permission.INTERNET'],
	'Landroid/webkit/WebView;-zoomOut-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/SyncManager;-serviceRequest-(J J I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/IP2pTarget$Stub;-connect-(I)I' : ['android.permission.NFC'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-fillData-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/WorkingMessage;-access$500-(Landroid/net/Uri; Lcom/google/android/mms/pdu/PduPersister; Lcom/android/mms/model/SlideshowModel; Lcom/google/android/mms/pdu/SendReq;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/deskclock/HandleSetAlarm;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/TwelveKeyDialer;-onPause-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/Downloads$ById;-openDownload-(Landroid/content/Context; J Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/calendar/CalendarPreferenceActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/ConnectivityService;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/WifiWatchdogService;-<init>-(Landroid/content/Context; Landroid/net/wifi/WifiStateTracker;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/ui/QuickContactWindow;-getDataUri-(Landroid/net/Uri;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccount-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/media/MediaPlayer;-access$300-(Landroid/media/MediaPlayer; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ui/EditContactActivity;-doDeleteAction-()Z' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyDataConnectionFailed-(Lcom/android/internal/telephony/Phone; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/PrivilegedSmsReceiver;-onReceiveWithPrivilege-(Landroid/content/Context; Landroid/content/Intent; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService;-setBackupEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity$5;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/SpecialCharSequenceMgr;-handleChars-(Landroid/content/Context; Ljava/lang/String;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/activity/setup/AccountSettings;-saveSettings-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/pinyin/PinyinIME;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onSetDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Landroid/app/ReceiverRestrictedContext;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/GlobalActions$ToggleAction;-onPress-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/http/RequestQueue$ActivePool;-startup-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/location/ILocationManager$Stub;-requestLocationUpdatesPI-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onRadioOffOrNotAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ui/QuickContactActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserActivity;-onPause-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendPhonebookVcards-(Ljavax/obex/Operation; I I Z Ljava/lang/String;)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/cooliris/media/GridDrawManager;-drawThumbnails-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11; I)V' : ['android.permission.INTERNET'],
	'Lcom/android/server/DevicePolicyManagerService$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/ScoSocket;-onConnected-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity;-removeItem-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/MonthActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/TimeConsumingPreferenceActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/IWindowSession$Stub$Proxy;-add-(Landroid/view/IWindow; Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/phone/GsmUmtsCallOptions;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-getCDMASubscription-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-pauseTimers-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-setCellBroadcastConfig-([I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/RecognitionService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-startVoiceRecognition-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/wifi/WifiSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/nfc/LlcpConnectionlessSocket;-close-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-setRemoteOutOfBandData-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/ActivityPicker;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/CacheLoader;-closeStreamAndSendEndData-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/speech/IRecognitionService$Stub;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/app/IActivityManager;-setDebugApp-(Ljava/lang/String; Z Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.SET_DEBUG_APP'],
	'Lcom/android/email/service/EasAuthenticatorServiceAlternate;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothDevice;-createInsecureRfcommSocket-(I)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/net/IConnectivityManager$Stub;-getNetworkPreference-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-makeAppCrashingLocked-(Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/SyncManager;-scheduleLocalSync-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/net/wifi/IWifiManager$Stub;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/AttachImage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-onLocalDisconnect-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-updateMessageOnIccEf-(I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-initSocket-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/ApplicationSettings;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/cooliris/picasa/PicasaContentProvider;-syncUserAlbums-(Lcom/cooliris/picasa/PicasaContentProvider$SyncContext; Lcom/cooliris/picasa/UserEntry; Landroid/content/SyncResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.INTERNET', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/app/IBatteryStats$Stub;-getAwakeTimeBattery-()J' : ['android.permission.BATTERY_STATS'],
	'Lcom/google/common/io/Resources$1;-getInput-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-readPbrFileAndWait-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/Observable;-notifyObservers-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/google/common/io/ByteStreams;-equal-(Lcom/google/common/io/InputSupplier; Lcom/google/common/io/InputSupplier;)Z' : ['android.permission.INTERNET'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-getLlcpConnectionlessInterface-()Landroid/nfc/ILlcpConnectionlessSocket;' : ['android.permission.NFC'],
	'Landroid/net/INetworkManagementEventObserver;-interfaceAdded-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/svox/pico/EngineSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/MessageList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioManager;-setMicrophoneMute-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/mms/transaction/NotificationTransaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/contacts/SearchResultsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/sip/SipSettings$4;-run-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/voicedialer/BluetoothVoiceDialerActivity;-acquireWakeLock-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onDataSetupComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Landroid/server/BluetoothEventLoop;-onRequestPairingConsent-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-getCDMASubscription-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/sip/SipSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserActivity$6;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/app/ActivityGroup;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/Debug;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebView;-setFrame-(I I I I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onCdmaDataDetached-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/TwelveKeyDialer;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/calendar/DayView;-recalc-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/Phone;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-requestServiceBindingsLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateExtensions-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/accounts/AccountManager$BaseFutureTask;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothService$BondState;-loadBondState-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/IActivityManager;-killBackgroundProcesses-(Ljava/lang/String;)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/server/NotificationManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen;-asyncCheckPassword-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/LoadAverageService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CdmaVoicePrivacyCheckBoxPreference;-onClick-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/music/PlaylistBrowserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/LanguageSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onUserLeaveHint-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/DialtactsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/ContactsContract$Contacts;-getLookupUri-(J Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/MasterClear;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/vpn/L2tpService;-onConnect-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.VIBRATE'],
	'Lcom/google/common/io/ByteStreams;-copy-(Lcom/google/common/io/InputSupplier; Ljava/io/OutputStream;)J' : ['android.permission.INTERNET'],
	'Lcom/android/server/LocationManagerService$2;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothDevice;-getBondState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/calendar/CalendarAppWidgetService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/SetAlarm$3;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/setup/AccountSetupIncoming;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/certinstaller/CertInstaller;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/MountService;-finishMediaUpdate-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/calendar/MonthActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/sip/SipManager;-register-(Landroid/net/sip/SipProfile; I Landroid/net/sip/SipRegistrationListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/mms/model/RegionMediaModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper; Lcom/android/mms/model/RegionModel;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/widget/DateTimeView;-onAttachedToWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothAdapter;-getBondedDevices-()Ljava/util/Set;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/PhoneApp;-clearOtaState-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/setup/AccountSetupAccountType;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHeadsetService;-access$2200-(Lcom/android/phone/BluetoothHeadsetService; Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/cooliris/media/PhotoAppWidgetConfigure;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AlertReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserActivity$17;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiManager;-reconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/pm/IPackageManager$Stub;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-loadEFTransparent-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BookmarkSearch;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EmergencyCallbackModeService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/CalendarActivity;-goTo-(Landroid/text/format/Time; Z)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/SearchResultsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/CandidateView$CandidateStripGestureListener;-onLongPress-(Landroid/view/MotionEvent;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/development/DataList;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserBackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/IEmailService$Stub$Proxy;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-access$100-(Lcom/android/internal/telephony/gsm/GsmConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/AccountFolderList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/fuelgauge/BatteryHistoryDetail;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/vpn/VpnSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NetworkManagementService;-getInterfaceTxThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/PackageManagerService;-access$3800-(Lcom/android/server/PackageManagerService; Z Z)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/SearchResultsActivity;-generatePhoneNumberIcon-(Landroid/net/Uri; I I)Landroid/graphics/Bitmap;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/nfc/LlcpSocket;-getRemoteSocketRw-()I' : ['android.permission.NFC'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateGroups-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/accounts/IAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/bluetooth/BluetoothDevice;-createScoSocket-()Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/LoadListener;-checkCache-(Ljava/util/Map;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/Controller$LegacyListener;-loadMessageForViewFinished-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIMEBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/applications/ManageApplications;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/StatusBarManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/app/IWallpaperManager$Stub$Proxy;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothDevice;-removeBond-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/GlobalActions$SinglePressAction;-onPress-()V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2000-(Lcom/android/mms/ui/ComposeMessageActivity; Lcom/android/mms/data/Contact;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/widget/RotarySelector;-vibrate-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/contacts/SearchResultsActivity;-getContactDisplayName-(J)Ljava/lang/String;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/ConnectivityService;-sendInetConditionBroadcast-(Landroid/net/NetworkInfo;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/Gallery;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/browser/BrowserProvider;-update-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/accounts/AccountManager$GetAuthTokenByTypeAndFeaturesTask$1;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/launcher2/Launcher;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebViewCore;-<init>-(Landroid/content/Context; Landroid/webkit/WebView; Landroid/webkit/CallbackProxy; Ljava/util/Map;)V' : ['android.permission.INTERNET'],
	'Lcom/android/exchange/SyncManager;-access$900-(Lcom/android/exchange/SyncManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-getBasebandVersion-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getPreferredVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$6;-onServiceChanged-(Ljava/lang/Object; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/phone/ADNList;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/svox/pico/Pico;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityStack;-completeResumeLocked-(Lcom/android/server/am/ActivityRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/CommandsInterface;-getLastDataCallFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/Wallpaper$SetWallpaperThread;-run-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/certinstaller/CertInstaller;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/LocationManager;-addProximityAlert-(D D F J Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService$2;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-access$100-(Lcom/android/server/am/ActivityManagerService; Z)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-handlePollCalls-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/DisableCarModeActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/downloads/ui/DownloadList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ui/ContactsPreferencesActivity$UpdateTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/ConnectivityService;-enforceAccessPermission-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Landroid/location/Criteria; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onScreenTurnedOn-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Landroid/net/sip/SipProfile; Landroid/net/sip/SipProfile; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/BrightnessPreference;-setMode-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/WifiService;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/provider/ContactsContract$Contacts;-getLookupUri-(Landroid/content/ContentResolver; Landroid/net/Uri;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/vpn/VpnServiceBinder$2;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$4700-(Lcom/android/mms/ui/ComposeMessageActivity; I Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/OtaUtils;-otaShowHome-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AudioManager;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-updateNotificationWhenBtDisabled-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-start-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/Transaction;-process-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$UnavailableState;-enter-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/NdefTagConnection;-attemptDeadServiceRecovery-(Ljava/lang/Exception;)V' : ['android.permission.NFC'],
	'Landroid/media/MediaPlayer;-stayAwake-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/PermissionDetails;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasSyncService;-runAccountMailbox-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-createView-()Landroid/view/View;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/WeekView;-reloadEvents-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setNumAllowedChannels-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/providers/calendar/CalendarAppWidgetProvider;-timeUpdated-(Landroid/content/Context; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityGroup;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ConfirmLockPassword;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/SoundSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothService;-sendUuidIntent-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/speech/RecognitionService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService;-setInterfaceThrottle-(Ljava/lang/String; I I)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/browser/BrowserActivity$18;-onPostExecute-(Ljava/util/Set;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/WifiService;-enforceAccessPermission-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-updateShare-(Landroid/database/Cursor; I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter$2;-run-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Landroid/content/ContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/ProxySelector;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-handleApplicationWtf-(Landroid/os/IBinder; Ljava/lang/String; Landroid/app/ApplicationErrorReport$CrashInfo;)Z' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$1;-pokeWakelock-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/ContactsListActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/IBackupManager$Stub;-restoreAtInstall-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-getIccCardStatusDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/FileLoader;-sendData-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/ChooseLockGeneric;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/Utility;-getConsistentDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/os/storage/IMountService;-mountVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/phone/CallLogAsync$AddCallTask;-doInBackground-([Lcom/android/phone/CallLogAsync$AddCallArgs;)[Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-removeTrack-(J)I' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/ContentLoader;-load-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/LogViewer;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getConnectedSinks-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/LatinIMESettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity$4;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ClassZeroActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/usb/StorageNotification;-onUsbMassStorageConnectionChangedAsync-(Z)V' : ['android.permission.VIBRATE'],
	'Landroid/os/INetworkManagementService;-setIpForwardingEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/SendTransaction;-sendPdu-(J [B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/nfc/RawTagConnection;-close-()V' : ['android.permission.NFC'],
	'Lcom/svox/pico/EngineSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/io/OutputStream;)V' : ['android.permission.INTERNET'],
	'Lcom/android/server/MountService;-formatVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Lcom/android/server/LocationManagerService;-loadProvidersLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-finishDisable-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDeviceIdentity-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2700-(Lcom/android/mms/ui/ComposeMessageActivity; J)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/content/ContentService;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/development/Details;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/EditEvent;-saveReminders-(Ljava/util/ArrayList; J Ljava/util/ArrayList; Ljava/util/ArrayList; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/sip/SipSettings;-processActiveProfilesFromSipService-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-access$500-(Lcom/android/bluetooth/pbap/BluetoothPbapService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/WifiWatchdogService;-onConnected-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/test/mock/MockContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/location/ILocationManager$Stub;-setTestProviderEnabled-(Ljava/lang/String; Z)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/calendar/EditEvent;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ManageSimMessages;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/SendTransaction;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/providers/downloads/DownloadThread;-checkConnectivity-(Lcom/android/providers/downloads/DownloadThread$State;)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/cooliris/media/ImageButton;-renderBlended-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AgendaActivity;-onSaveInstanceState-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/music/MediaPlaybackActivity$8;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSetupOutgoing;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/AlertActivity;-dismissFiredAlarms-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/net/http/HttpsConnection;-openHttpConnection-(Landroid/net/http/Request;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS'],
	'Lcom/android/calendar/DeleteEventHelper;-delete-(J J J I)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/view/IWindowManager$Stub$Proxy;-setAnimationScales-([F)V' : ['android.permission.SET_ANIMATION_SCALE'],
	'Lcom/android/phone/BluetoothHandsfree$28;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GsmMmiCode;-processCode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary$LoadDictionaryTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiManager;-startScan-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/EmergencyDialer;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/adapter/FolderSyncParser;-parse-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/AlertService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/WifiSettings;-connect-(I)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/ThrottleManager;-getPeriodStartTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/os/BatteryStatsImpl;-writeToParcelLocked-(Landroid/os/Parcel; Z I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/PhoneUtils;-hangupHoldingCall-(Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/AppHwConfigList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/sip/SipSettings$3$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/DayView;-doFling-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/providers/contacts/SocialProvider;-insert-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/InstrumentationList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/DataSource;-loadMediaSets-(Lcom/cooliris/media/MediaFeed;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserPreferencesPage;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/model/ImageModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper; Lcom/android/mms/model/RegionModel;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/test/mock/MockContentResolver;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub;-notifyDataConnection-(I Z Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-changeBarringPassword-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-access$200-(Lcom/android/internal/policy/impl/KeyguardViewMediator;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/TetherSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/IContentService$Stub$Proxy;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/EditEvent;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/nfc/INfcTag;-read-(I)Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Lcom/android/phone/FakePhoneActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/development/EnterURL;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/setup/AccountSetupOutgoing;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/setup/AccountSetupAccountType;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IActivityManager;-setProcessLimit-(I)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Lcom/android/settings/ConfirmLockPassword;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ConversationListAdapter$OnContentChangedListener;-onContentChanged-(Lcom/android/mms/ui/ConversationListAdapter;)V' : ['android.permission.READ_SMS'],
	'Landroid/net/sip/ISipService$Stub;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-refreshProfiles-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-getTriState-(Landroid/content/Context;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-acknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasOutboxService;-acknowledgeRemoteWipe-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccountSyncSettings;-updateAuthDescriptions-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/development/DataList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/DockEventReceiver;-beginStartingService-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/widget/BookmarkWidgetService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-updateShortcut-(C Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-updateAfterRadioTechnologyChange-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/SyncManager;-cancelActiveSync-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-turnOffMasterTetherSettings-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/server/BluetoothEventLoop;-onRequestPinCode-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-startDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/quicksearchbox/SearchableItemsSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-sendPdu-(J [B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/CallDetailActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-createIncomingConnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calculator2/Calculator;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/tts/TtsService;-cleanUpPlayer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/calendar/AlertService;-processMessage-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/accounts/IAccountManager$Stub;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-write-(I Landroid/nfc/NdefMessage;)I' : ['android.permission.NFC'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-next-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/location/LocationProviderInterface;-updateLocation-(Landroid/location/Location;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/SyncManager$2;-validate-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I Z Z)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BatteryService;-sendIntent-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-handleShow-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/nfc/NdefTagConnection;-writeNdefMessage-(Landroid/nfc/NdefMessage;)V' : ['android.permission.NFC'],
	'Lcom/cooliris/media/MovieViewControl;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewCore$4;-invoke-(Ljava/lang/String; Z Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-call-(Ljava/lang/String;)V' : ['android.permission.CALL_PHONE'],
	'Lcom/android/systemui/usb/StorageNotification;-onStorageStateChangedAsync-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Lcom/cooliris/media/PhotoAppWidgetConfigure;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/FakePhoneActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/SyncManager;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/pm/IPackageManager;-setInstallLocation-(I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ManageSimMessages;-startQuery-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/TabControl;-setCurrentTab-(Lcom/android/browser/Tab;)Z' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setMute-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IApplicationToken$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/DataUsageListener;-access$100-(Lcom/android/phone/DataUsageListener;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/BluetoothService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/LatinIME;-swipeDown-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/webkit/WebTextView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/DownloadManager;-enqueue-(Landroid/app/DownloadManager$Request;)J' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/AccountPreferenceBase;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/DockService;-handleBtStateChange-(Landroid/content/Intent; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/PhysicalKeyboardSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/http/RequestQueue;-<init>-(Landroid/content/Context;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-access$900-(Lcom/android/bluetooth/pbap/BluetoothPbapService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/speech/tts/ITts;-stop-(Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-resumeSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/CalendarApplication;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothEventLoop;-onAgentOutOfBandDataAvailable-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/AlarmKlaxon$3;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/Debug;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/DataConnection$DcDisconnectingBadDnsState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccProvider;-deleteIccRecordFromEf-(I Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/packageinstaller/InstallAppProgress;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/contacts/ContactsProvider2;-deleteData-(J [Ljava/lang/String;)I' : ['android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/IWifiManager;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupOutgoing;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/model/VideoModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/RecentCallsListActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/development/DevelopmentSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatch-(Landroid/content/Intent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentService;-main-(Landroid/content/Context; Z)Landroid/content/IContentService;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/camera/NoSearchActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService;-next-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-handleImportRequest-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS'],
	'Lcom/cooliris/media/MediaFeed$2;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/accounts/AccountManagerService;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/webkit/WebView$InvokeListBox$3;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/util/HierarchicalStateMachine$HsmHandler;-completeConstruction-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AppWidgetPickActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/Browser;-clearSearches-(Landroid/content/ContentResolver;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/opp/TestActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/ExternalMediaFormatActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH_ADMIN', 'android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/google/common/io/ByteStreams;-getDigest-(Lcom/google/common/io/InputSupplier; Ljava/security/MessageDigest;)[B' : ['android.permission.INTERNET'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-refresh-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AccessibilitySettings;-persistEnabledAccessibilityServices-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/stk/RilMessageDecoder;-getInstance-(Landroid/os/Handler; Lcom/android/internal/telephony/gsm/SIMFileHandler;)Lcom/android/internal/telephony/gsm/stk/RilMessageDecoder;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneInterfaceManager;-enforceReadPermission-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setCallForwardingOption-(I I Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/IEmailServiceCallback$Stub$Proxy;-syncMailboxStatus-(J I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/calendar/AlertService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/GridInputProcessor;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothEventLoop;-onCreatePairedDeviceResult-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebView;-access$1700-(Landroid/webkit/WebView;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewCore;-drawContentPicture-(Landroid/graphics/Canvas; I Z Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/defcontainer/DefaultContainerService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/htmlviewer/HTMLViewerActivity$WebChrome;-onSelectionStart-(Landroid/webkit/WebView;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-handleSms-([B)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-setTrust-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebViewCore;-didFirstLayout-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/util/CalendarUtils$TimeZoneUtils;-formatDateRange-(Landroid/content/Context; J J I)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Landroid/preference/VolumePreference;-onActivityStop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/svox/pico/DownloadVoiceData;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/LatinKeyboardBaseView$UIHandler;-startKeyRepeatTimer-(J I Lcom/android/inputmethod/latin/PointerTracker;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/net/wifi/WifiStateTracker$SettingsObserver;-<init>-(Landroid/net/wifi/WifiStateTracker; Landroid/os/Handler;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/MessageListAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setTrust-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/telephony/TelephonyManager;-getNeighboringCellInfo-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onPrepareOptionsMenu-(Landroid/view/Menu;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/spare_parts/SpareParts;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/LocalePickerInSetupWizard;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/vpn/VpnTypeSelection;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-powerOffRadioSafely-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageView;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ProxySelector;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager$3;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/TestActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$16;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/RootLayer;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/RecognitionService$RecognitionServiceBinder;-startListening-(Landroid/content/Intent; Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/calendar/MonthView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-conference-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DataConnection;-onConnect-(Lcom/android/internal/telephony/DataConnection$ConnectionParams;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallNotifier;-onCustomRingQueryComplete-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/nfc/INfcTag$Stub;-read-(I)Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Lcom/android/calendar/AlertActivity$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/nfc/RawTagConnection;-<init>-(Landroid/nfc/NfcAdapter; Landroid/nfc/Tag; Ljava/lang/String;)V' : ['android.permission.NFC'],
	'Lcom/android/settings/ChooseLockPattern;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ActivityPicker;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/ContactsContract$Data;-getContactLookupUri-(Landroid/content/ContentResolver; Landroid/net/Uri;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/CallLogAsync$AddCallTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-setCallWaiting-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-getLastKnownLocation-(Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/DialtactsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Ljava/net/NetworkInterface;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/InCallScreen$9;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$21;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ConnectivityService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebView;-notifyFindDialogDismissed-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$1;-goToLockScreen-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/development/Development;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService;-access$1700-(Lcom/android/server/sip/SipService; Ljava/lang/String; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/svox/pico/DownloadVoiceData;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity$JoinContactActivity;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/provider/Calendar$Events;-query-(Landroid/content/ContentResolver; [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/app/ChooserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/TelephonyRegistry;-checkListenerPermission-(I)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/Alarms;-setAlarm-(Landroid/content/Context; Lcom/android/deskclock/Alarm;)J' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/provision/DefaultActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/SyncManager$ActiveSyncContext;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/exchange/EasOutboxService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I Z)Lorg/apache/http/HttpResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/CombinedBookmarkHistoryActivity$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phone/PhoneUtils;-placeCall-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Landroid/net/Uri;)I' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/cooliris/media/CropImage$1;-shutdown-(Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Landroid/net/sip/ISipService;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/TestingSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$20;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/SelectCalendarsAdapter;-getChildrenCursor-(Landroid/database/Cursor;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/NetworkSetting;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/TrackBrowserActivity;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WindowManagerService;-reenableKeyguard-(Landroid/os/IBinder;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/DriverCall; Lcom/android/internal/telephony/gsm/GsmCallTracker; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-setRadioState-(Lcom/android/internal/telephony/CommandsInterface$RadioState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WindowManagerService;-access$900-(Lcom/android/server/WindowManagerService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/server/ConnectivityService;-access$400-(Lcom/android/server/ConnectivityService; Landroid/net/NetworkInfo;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/sip/SipManager;-takeAudioCall-(Landroid/content/Intent; Landroid/net/sip/SipAudioCall$Listener;)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/SyncManager;-getDeviceIdInternal-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$ErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/view/WindowManagerPolicy;-screenTurnedOff-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/ui/EditContactActivity;-compare-(Ljava/lang/Object; Ljava/lang/Object;)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/DataConnection$DcActivatingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/AudioService$2;-onServiceConnected-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-onGet-(Ljavax/obex/Operation;)I' : ['android.permission.READ_CONTACTS'],
	'Landroid/net/sip/SipAudioCall$1;-onCallEnded-(Landroid/net/sip/SipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/DeviceStorageMonitorService;-<init>-(Landroid/content/Context;)V' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE'],
	'Lcom/android/development/MediaScannerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/launcher2/Launcher;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/phone/CallNotifier;-showMissedCallNotification-(Lcom/android/internal/telephony/Connection; J)V' : ['android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/BrowserActivity;-access$200-(Lcom/android/browser/BrowserActivity; Ljava/lang/String; Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ImportVCardActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CdmaSystemSelectListPreference;-onDialogClosed-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CallManager;-setAudioMode-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-doStatusCallback-(J J I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/setup/AccountSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/google/GoogleSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/MessagingListener;-loadAttachmentFinished-(J J J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/LocationManagerService;-setTestProviderLocation-(Ljava/lang/String; Landroid/location/Location;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-setBroadcastTimeoutLocked-(J)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserActivity;-access$000-(Lcom/android/browser/BrowserActivity; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/BluetoothService;-enable-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/ApnSettings;-access$400-()Landroid/net/Uri;' : ['android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$StartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/AccountsTester;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/http/EventHandler;-error-(I Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/LatinIME;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsListActivity$ContactsSearchActivity;-returnPickerResult-(Landroid/database/Cursor; Ljava/lang/String; Landroid/net/Uri; I)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/DeskClock;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/SipAudioCall;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/CalendarSyncEnabler;-enableEasCalendarSyncInternal-()Ljava/lang/String;' : ['android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneProxy;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Calendar$Calendars;-delete-(Landroid/content/ContentResolver; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/latin/LatinKeyboardBaseView$OnKeyboardActionListener;-onKey-(I [I I I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.RECORD_AUDIO', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setCallWaiting-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/cooliris/media/MenuBar;-renderBlended-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-open-([J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-hangupConnection-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-dispose-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ui/EditContactActivity$QueryEntitiesTask;-onPostExecute-(Lcom/android/contacts/ui/EditContactActivity; Lcom/android/contacts/model/EntitySet;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyDefaultData-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/cooliris/media/TimeBar;-renderBlended-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/CommandsInterface;-changeIccPin-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/LocationManagerService$2;-onSomePackagesChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/MediaFormat;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/contacts/ContactsProvider2;-deleteData-(Ljava/lang/String; [Ljava/lang/String; Z)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/development/PackageBrowser;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WindowManagerService$PolicyThread;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/quicksearchbox/SearchActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/media/MediaScannerService;-scanFile-(Ljava/lang/String; Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$BluetoothPhoneState;-handlePreciseCallStateChange-(Z Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService;-untetherInterface-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/music/QueryBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-handleSetHidden-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/transaction/TransactionService;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub$Proxy;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/webkit/WebView;-onFocusChanged-(Z I Landroid/graphics/Rect;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/quicksearchbox/google/GoogleSearch;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CallFeaturesSetting;-handleTTYChange-(Landroid/preference/Preference; Ljava/lang/Object;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/INetworkManagementService$Stub;-getInterfaceRxThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/EasOutboxService;-sendMessage-(Ljava/io/File; J)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/ByteStreams$5;-getInput-()Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/providers/downloads/DownloadInfo;-notifyPauseDueToSize-(Z)V' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/quicksearchbox/SearchableItemsSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/CalendarView;-recalc-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/RIL;-startDtmf-(C Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPuk-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-dial-(Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipCall;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/NotificationTransaction;-sendNotifyRespInd-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/TextToSpeechSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/DockService;-processMessage-(Landroid/os/Message;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebView;-clearHelpers-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/WeekView;-drawAfterScroll-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/CallNotifier;-sendCdmaCallWaitingReject-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/applications/ManageApplications;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onDisconnectDone-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Landroid/content/SyncManager$SyncHandler;-scheduleReadyPeriodicSyncs-()Ljava/lang/Long;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/providers/calendar/EmptyService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/MessageSender;-sendMessage-(J)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/music/MediaPlaybackService;-play-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NetworkManagementService;-startUsbRNDIS-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-handleWakeWhenReady-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/music/MusicUtils;-playAll-(Landroid/content/Context; Landroid/database/Cursor; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/BrightnessPreference;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/nfc/IP2pInitiator$Stub;-send-(I [B)Z' : ['android.permission.NFC'],
	'Lcom/android/settings/ApnEditor;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/cooliris/media/CropImage;-launchCropperOrFinish-(Landroid/content/Context; Lcom/cooliris/media/MediaItem;)V' : ['android.permission.INTERNET'],
	'Lcom/android/providers/downloads/Helpers;-getCacheDestination-(Landroid/content/Context; J)Ljava/io/File;' : ['android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/ConnectivityService;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccProvider;-addIccRecordToEf-(I Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$UnavailableState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/SlideView;-pauseAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/PhotoAppWidgetBind;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/deskclock/AlarmKlaxon;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/quicksearchbox/SearchWidgetConfigActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CdmaVoicePrivacyCheckBoxPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-pullVcardListing-([B Lcom/android/bluetooth/pbap/BluetoothPbapObexServer$AppParamValue; Ljavax/obex/HeaderSet; Ljavax/obex/Operation;)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/vpn/L2tpService;-access$400-(Lcom/android/server/vpn/VpnService;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-setPostDialState-(Lcom/android/internal/telephony/Connection$PostDialState;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/svox/pico/CheckVoiceData;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserBookmarksAdapter$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/BluetoothAdapter;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-updateCurrentCarrierInProvider-()Z' : ['android.permission.WRITE_APN_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setCLIR-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManagerService;-checkManageAccountsPermission-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/quicksearchbox/QsbApplicationWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/LocalePickerInSetupWizard;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/settings/ConfirmLockPassword;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/soundrecorder/Recorder;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/UserDictionary$2;-run-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/providers/settings/DatabaseHelper;-upgradeLockPatternLocation-(Landroid/database/sqlite/SQLiteDatabase;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$4;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/DockSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabControl;-recreateWebView-(Lcom/android/browser/Tab; Lcom/android/browser/BrowserActivity$UrlData;)Z' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactsLiveFolders$AllContacts;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothService;-setTrust-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/ILlcpSocket$Stub$Proxy;-send-(I [B)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendDtmf-(C Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRoamingOff-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_APN_SETTINGS'],
	'Landroid/app/Service;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Ljava/net/HttpURLConnection;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-dispatch-(Landroid/content/Intent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/ConnectSpecificProfilesActivity;-onProfileCheckedStateChanged-(Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$Profile; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/SimCard;-broadcastIccStateChangedIntent-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/calendar/EmptyService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/TextToSpeechSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/data/Contact$ContactsCache;-getContactInfo-(Ljava/lang/String;)Lcom/android/mms/data/Contact;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/phone/PhoneUtils;-turnOnNoiseSuppression-(Landroid/content/Context; Z Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/telephony/TelephonyManager;-getVoiceMailAlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/ContactsListActivity;-getJoinSuggestionsUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/wifi/WifiSettings;-saveNetworks-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/model/GoogleSource;-attemptMyContactsMembership-(Lcom/android/contacts/model/EntityDelta; Ljava/lang/String; Ljava/lang/String; Landroid/content/Context; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/BatteryStatsService;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/IMediaPlaybackService;-removeTracks-(I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onResume-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/AlarmReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/RecentCallsListActivity$RecentCallsAdapter;-onContentChanged-()V' : ['android.permission.READ_CONTACTS'],
	'Landroid/nfc/NfcAdapter;-createRawTagConnection-(Landroid/nfc/Tag;)Landroid/nfc/RawTagConnection;' : ['android.permission.NFC'],
	'Lcom/android/mms/ui/ComposeMessageActivity$6;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/Files;-readBytes-(Ljava/io/File; Lcom/google/common/io/ByteProcessor;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/phone/InCallScreen;-endInCallScreenSession-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/MonthActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageList;-access$1600-(Lcom/android/email/activity/MessageList;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/widget/BookmarkWidgetService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-screenTurnedOff-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingScoOn-()Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-reconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/NfcService$3;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/phone/EmergencyDialer;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-showConnectingError-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/telephony/SmsManager;-updateMessageOnIcc-(I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/nfc/ILlcpConnectionlessSocket$Stub$Proxy;-sendTo-(I Landroid/nfc/LlcpPacket;)I' : ['android.permission.NFC'],
	'Lcom/android/server/ConnectivityService;-handleDisconnect-(Landroid/net/NetworkInfo;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/test/mock/MockApplication;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/Connection;-proceedAfterWaitChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-switchWaitingOrHoldingAndActive-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ImportVCardActivity$VCardScanThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/ConnectivityManager;-setRadio-(I Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/connectivity/Tethering;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/TimeConsumingPreferenceActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/IAudioService$Stub$Proxy;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/GsmUmtsAdditionalCallOptions;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/EnterURL;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SearchActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-startListenerDelayed-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/http/ConnectionThread;-run-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHandsfree;-startVoiceRecognition-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/PrivacySettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/AddAccountSettings;-updateAuthDescriptions-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/LocationManagerService;-_getProvidersLocked-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ExportVCardActivity$ActualExportThread;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/cooliris/media/PopupMenu;-renderOpaque-(Lcom/cooliris/media/RenderView; Ljavax/microedition/khronos/opengles/GL11;)V' : ['android.permission.INTERNET'],
	'Landroid/app/IActivityManager;-moveTaskBackwards-(I)V' : ['android.permission.REORDER_TASKS'],