/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_GROUPASSIGNEDIDENTITYACCESS_H_
#define OPENDRIM_GROUPASSIGNEDIDENTITYACCESS_H_

#include "Simple_Identity_Management_Common.h"

#include "OpenDRIM_GroupAssignedIdentity.h"
#include "assocOpenDRIM_GroupAssignedIdentity.h"

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_load(const CMPIBroker* broker, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_unload(string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_GroupAssignedIdentity>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_GroupAssignedIdentity& instance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupAssignedIdentity& newInstance, const OpenDRIM_GroupAssignedIdentity& oldInstance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupAssignedIdentity& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupAssignedIdentity& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_associatorIdentityInfoToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& IdentityInfo_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_associatorManagedElementToIdentityInfo(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& IdentityInfo_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_referenceIdentityInfoToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& IdentityInfo_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_GroupAssignedIdentity>& OpenDRIM_GroupAssignedIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_referenceManagedElementToIdentityInfo(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& IdentityInfo_instances, vector<OpenDRIM_GroupAssignedIdentity>& OpenDRIM_GroupAssignedIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_populate(OpenDRIM_GroupAssignedIdentity& instance, string& errorMessage);

#endif /*OPENDRIM_GROUPASSIGNEDIDENTITYACCESS_H_*/
