/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_ACCOUNTASSIGNEDIDENTITY_H_
#define OPENDRIM_ACCOUNTASSIGNEDIDENTITY_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_Identity.h"
#include "CIM_IdentityAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_AccountAssignedIdentity_classnames[] = {"OpenDRIM_AccountAssignedIdentity"};
static string OpenDRIM_AccountAssignedIdentity_NAMESPACE = _NAMESPACE;
const static string IdentityInfo_role = "IdentityInfo";
const static char* IdentityInfo_classnames[] = {"OpenDRIM_AccountIdentity"};
const static string IdentityInfo_NAMESPACE = _NAMESPACE;

const static string ManagedElement_role = "ManagedElement";
const static char* ManagedElement_classnames[] = {"OpenDRIM_Account"};
const static string ManagedElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_AccountAssignedIdentity {

public:
	
	Objectpath IdentityInfo;
	bool IdentityInfo_isNULL;
	
	Objectpath ManagedElement;
	bool ManagedElement_isNULL;
	
	OpenDRIM_AccountAssignedIdentity() {
		IdentityInfo_isNULL = true;
		ManagedElement_isNULL = true;
	}
	
	~OpenDRIM_AccountAssignedIdentity() {}
	
	string getKeys() const {
		return CF_toLowCase(".IdentityInfo=\"" + CF_quoteString(IdentityInfo.toString()) + "\""".ManagedElement=\"" + CF_quoteString(ManagedElement.toString()) + "\"");
	}

	int getIdentityInfo(Objectpath& value) const {
		if (IdentityInfo_isNULL==true)
			return NOT_FOUND;
		value = IdentityInfo;
		return OK;
	}
	
	int setIdentityInfo(const Objectpath& newValue) {
		IdentityInfo = newValue;
		IdentityInfo.setNamespace(IdentityInfo_NAMESPACE);
		IdentityInfo_isNULL = false;
		return OK;
	}

	int getManagedElement(Objectpath& value) const {
		if (ManagedElement_isNULL==true)
			return NOT_FOUND;
		value = ManagedElement;
		return OK;
	}
	
	int setManagedElement(const Objectpath& newValue) {
		ManagedElement = newValue;
		ManagedElement.setNamespace(ManagedElement_NAMESPACE);
		ManagedElement_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_ACCOUNTASSIGNEDIDENTITY_H_*/
