namespace Ubuntuone.Constants {

    private const string WEBAPI_SERVER = "https://one.ubuntu.com/";
    private const string ACCOUNT_PATH = "api/account";
    private const string PAYMENT_METHOD_PATH = "music-store-up/api/1/user/retrieve-payment-method?purchase_sku=%s";
    private const string PURCHASE_WITH_DEFAULT_PAYMENT_PATH = "music-store-up/api/1/user/purchase-with-default-payment?purchase_sku=%s&authentication=%s";

    private const string LOGIN_SERVER = "https://login.ubuntu.com/";
    private const string AUTHENTICATION_PATH = "api/1.1/authentications";
    private const string AUTHENTICATE_PARAMS = "ws.op=authenticate&token_name=Purchase_Token";
    private const string FORGOTTEN_PASSWORD_PATH = "+forgot_password";

    private const string PAY_SERVER = "https://pay.ubuntu.com/";
    private const string CHANGE_PAYMENT_METHOD_PATH = "account/";

    string from_environ (string env_name, string default_value)
    {
        string env_value = Environment.get_variable (env_name);
        return env_value != null ? env_value : default_value;
    }

    string webapi_server ()
    {
        return from_environ ("U1_WEBAPI_SERVER", WEBAPI_SERVER);
    }

    string login_server ()
    {
        return from_environ ("U1_LOGIN_SERVER", LOGIN_SERVER);
    }

    string pay_server ()
    {
        return from_environ ("U1_PAY_SERVER", PAY_SERVER);
    }

    string account_uri ()
    {
        return webapi_server () + ACCOUNT_PATH;
    }

    string payment_method_uri ()
    {
        return webapi_server () + PAYMENT_METHOD_PATH;
    }

    string purchase_with_default_payment_uri ()
    {
        return webapi_server () + PURCHASE_WITH_DEFAULT_PAYMENT_PATH;
    }

    string authentication_uri ()
    {
        return login_server () + AUTHENTICATION_PATH;
    }

    string forgotten_password_url ()
    {
        return login_server () + FORGOTTEN_PASSWORD_PATH;
    }

    string change_payment_method_url ()
    {
        return pay_server () + CHANGE_PAYMENT_METHOD_PATH;
    }
}
