/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocUtils/EnumConvertersXml.h"
#include "Doc/SchemaTypesDoc/SchemaTypesDocTypes.h"
#include "Doc/CafCoreTypesDoc/CafCoreTypesDocTypes.h"

#include "Doc/SchemaTypesDoc/CClassPropertyDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/ClassPropertyXml.h"

using namespace Caf;

void ClassPropertyXml::add(
	const SmartPtrCClassPropertyDoc classPropertyDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ClassPropertyXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(classPropertyDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameVal = classPropertyDoc->getName();
		CAF_CM_VALIDATE_STRING(nameVal);
		thisXml->addAttribute("name", nameVal);

		const std::string typeVal =
			EnumConvertersXml::convertPropertyTypeToString(classPropertyDoc->getType());
		CAF_CM_VALIDATE_STRING(typeVal);
		thisXml->addAttribute("type", typeVal);

		const std::deque<std::string> valueVal =
			classPropertyDoc->getValue();
		if (! valueVal.empty()) {
			for (TConstIterator<std::deque<std::string> > valueIter(valueVal);
				valueIter; valueIter++) {
				const SmartPtrCXmlElement valueXml =
					thisXml->createAndAddElement("value");
				valueXml->setValue(*valueIter);
			}
		}

		const std::string requiredVal = classPropertyDoc->getRequired() ? "true" : "false";
		if (! requiredVal.empty()) {
			thisXml->addAttribute("required", requiredVal);
		}

		const std::string keyVal = classPropertyDoc->getKey() ? "true" : "false";
		if (! keyVal.empty()) {
			thisXml->addAttribute("key", keyVal);
		}

		const std::string listVal = classPropertyDoc->getList() ? "true" : "false";
		if (! listVal.empty()) {
			thisXml->addAttribute("list", listVal);
		}

		const std::string caseSensitiveVal = classPropertyDoc->getCaseSensitive() ? "true" : "false";
		if (! caseSensitiveVal.empty()) {
			thisXml->addAttribute("caseSensitive", caseSensitiveVal);
		}

		const std::string transientValVal = classPropertyDoc->getTransientVal() ? "true" : "false";
		if (! transientValVal.empty()) {
			thisXml->addAttribute("transient", transientValVal);
		}

		const std::string defaultValVal = classPropertyDoc->getDefaultVal();
		if (! defaultValVal.empty()) {
			thisXml->addAttribute("default", defaultValVal);
		}

		const std::string validatorVal =
			EnumConvertersXml::convertValidatorTypeToString(classPropertyDoc->getValidator());
		if (! validatorVal.empty()) {
			thisXml->addAttribute("validator", validatorVal);
		}

		const std::string upperRangeVal = classPropertyDoc->getUpperRange();
		if (! upperRangeVal.empty()) {
			thisXml->addAttribute("upperRange", upperRangeVal);
		}

		const std::string lowerRangeVal = classPropertyDoc->getLowerRange();
		if (! lowerRangeVal.empty()) {
			thisXml->addAttribute("lowerRange", lowerRangeVal);
		}

		const std::string displayNameVal = classPropertyDoc->getDisplayName();
		if (! displayNameVal.empty()) {
			thisXml->addAttribute("displayName", displayNameVal);
		}

		const std::string descriptionVal = classPropertyDoc->getDescription();
		if (! descriptionVal.empty()) {
			thisXml->addAttribute("description", descriptionVal);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCClassPropertyDoc ClassPropertyXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ClassPropertyXml", "parse");

	SmartPtrCClassPropertyDoc classPropertyDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameStrVal =
			thisXml->findRequiredAttribute("name");
		const std::string nameVal = nameStrVal;

		const std::string typeStrVal =
			thisXml->findRequiredAttribute("type");
		PROPERTY_TYPE typeVal = PROPERTY_NONE;
		if (! typeStrVal.empty()) {
			typeVal = EnumConvertersXml::convertStringToPropertyType(typeStrVal);
		}

		const CXmlElement::SmartPtrCElementCollection valueChildrenXml =
			thisXml->findOptionalChildren("value");

		std::deque<std::string> valueVal;
		if (! valueChildrenXml.IsNull() && ! valueChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> valueXmlIter(*valueChildrenXml);
				valueXmlIter; valueXmlIter++) {
				const SmartPtrCXmlElement valueXml = valueXmlIter->second;
				const std::string valueDoc = valueXml->getValue();
				valueVal.push_back(valueDoc);
			}
		}

		const std::string requiredStrVal =
			thisXml->findOptionalAttribute("required");
		bool requiredVal = false;
		if (! requiredStrVal.empty()) {
			requiredVal = (requiredStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string keyStrVal =
			thisXml->findOptionalAttribute("key");
		bool keyVal = false;
		if (! keyStrVal.empty()) {
			keyVal = (keyStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string listStrVal =
			thisXml->findOptionalAttribute("list");
		bool listVal = false;
		if (! listStrVal.empty()) {
			listVal = (listStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string caseSensitiveStrVal =
			thisXml->findOptionalAttribute("caseSensitive");
		bool caseSensitiveVal = false;
		if (! caseSensitiveStrVal.empty()) {
			caseSensitiveVal = (caseSensitiveStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string transientValStrVal =
			thisXml->findOptionalAttribute("transient");
		bool transientValVal = false;
		if (! transientValStrVal.empty()) {
			transientValVal = (transientValStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string defaultValStrVal =
			thisXml->findOptionalAttribute("default");
		const std::string defaultValVal = defaultValStrVal;

		const std::string validatorStrVal =
			thisXml->findOptionalAttribute("validator");
		VALIDATOR_TYPE validatorVal = VALIDATOR_NONE;
		if (! validatorStrVal.empty()) {
			validatorVal = EnumConvertersXml::convertStringToValidatorType(validatorStrVal);
		}

		const std::string upperRangeStrVal =
			thisXml->findOptionalAttribute("upperRange");
		const std::string upperRangeVal = upperRangeStrVal;

		const std::string lowerRangeStrVal =
			thisXml->findOptionalAttribute("lowerRange");
		const std::string lowerRangeVal = lowerRangeStrVal;

		const std::string displayNameStrVal =
			thisXml->findOptionalAttribute("displayName");
		const std::string displayNameVal = displayNameStrVal;

		const std::string descriptionStrVal =
			thisXml->findOptionalAttribute("description");
		const std::string descriptionVal = descriptionStrVal;

		classPropertyDoc.CreateInstance();
		classPropertyDoc->initialize(
			nameVal,
			typeVal,
			valueVal,
			requiredVal,
			keyVal,
			listVal,
			caseSensitiveVal,
			transientValVal,
			defaultValVal,
			validatorVal,
			upperRangeVal,
			lowerRangeVal,
			displayNameVal,
			descriptionVal);
	}
	CAF_CM_EXIT;

	return classPropertyDoc;
}

