C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=LCOODP,SSI=0
                        SUBROUTINE LCOODP
C                       *****************
C
C      --------------------------------
     * (COODP,COOSP,NP,NDIM,NPOINS,NFIC)
C      --------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             LECTURE EN DOUBLE PRECISION DES COORDONNES               *
C              DU MAILLAGE SIMAIL QUI SONT EN SIMPLE PRECISION         *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE                 !
C !  COODP    ! TR ! R  ! COORDONNES EN DOUBLE PRECISION               !
C !  COOSP    ! TR ! R  ! COORDONNES EN SIMPLE PRECISION               !
C !  NP       !  E ! D  ! NBRE DE POINTS A LIRE                        !
C !  NFIC     !  E ! D  ! NUMERO LOGIQUE DU FICHIER                    !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : LECSI2
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#ifdef HAVE_C_IO
#include "nlofes.h"
#endif
C
C***********************************************************************
C
C..Variables externes
      INTEGER NP,NDIM,NPOINS,NFIC
      DOUBLE PRECISION  COODP(NPOINS,NDIM)
      REAL    COOSP(2*NPOINS,NDIM)
C
C..Variables internes
      INTEGER LE,I,J
C
#ifdef HAVE_C_IO
      INTEGER   NBRLUS,NBRTOT,IERROR
      REAL      XE
      CHARACTER MSGIER*80
#endif /* HAVE_C_IO */
C
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      DO 1 I=1,NP
         DO 1 J=1,NDIM
         COODP(I,J) = 0.
    1 CONTINUE


C     1- LECTURE DU TABLEAU 4
C     =======================
C
C     Lecture du tableau en simple precision
C     --------------------------------------
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFIC, 4, 1, 1, NBRLUS, NBRTOT, XE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      DO I = 1, NP
         DO J = 1, NDIM
            CALL READBF (NFIC, 4, 1, 1, NBRLUS, NBRTOT,
     *                  COOSP(2*I,J), IERROR)
            IF (IERROR .NE. 0) GOTO 998
         ENDDO
      ENDDO
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFIC, 4, 0, 2, NBRLUS, NBRTOT, 0.0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ(NFIC) LE,( (COOSP(2*I,J),J=1,NDIM) , I=1,NP)
#endif
C
C     Passage en double precision
C     ---------------------------
      DO 10 I=1,NP
       DO 10 J=1,NDIM
         COODP(I,J) = DBLE(COOSP(2*I,J))
  10  CONTINUE
C
      RETURN
C
#ifdef HAVE_C_IO
 998  CONTINUE
      CALL STREBF (MSGIER, LEN(MSGIER), IERROR)
      WRITE(NFECRA,9998) MSGIER
      STOP
C
C--------
C FORMATS
C--------
C 
 9998 FORMAT(' %% ERREUR LCOODP : erreur de lecture du maillage ',
     *       ' solide',/,'    de type : ',A)
#endif /* HAVE_C_IO */
C
      END

