/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.UnknownType;
import adql.query.operand.function.geometry.GeometryFunction;

public class CircleFunction
extends GeometryFunction {
    public static final LanguageFeature FEATURE = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo", "CIRCLE", true, "Express a circular region on the sky (i.e. a cone in space).");
    private GeometryFunction.GeometryValue<GeometryFunction> centerPoint;
    private ADQLOperand coord1;
    private ADQLOperand coord2;
    private ADQLOperand radius;

    public CircleFunction(ADQLOperand coordinateSystem, ADQLOperand firstCoord, ADQLOperand secondCoord, ADQLOperand radius) throws NullPointerException, Exception {
        super(coordinateSystem);
        if (firstCoord == null || secondCoord == null || radius == null) {
            throw new NullPointerException("All parameters of a CIRCLE function must be different from NULL!");
        }
        this.coord1 = firstCoord;
        this.coord2 = secondCoord;
        this.centerPoint = null;
        this.radius = radius;
    }

    public CircleFunction(ADQLOperand coordinateSystem, GeometryFunction.GeometryValue<GeometryFunction> center, ADQLOperand radius) throws NullPointerException, Exception {
        super(coordinateSystem);
        if (center == null || radius == null) {
            throw new NullPointerException("All parameters of a CIRCLE function must be different from NULL!");
        }
        this.coord1 = null;
        this.coord2 = null;
        this.centerPoint = center;
        this.radius = radius;
    }

    public CircleFunction(CircleFunction toCopy) throws Exception {
        super(toCopy);
        this.coord1 = (ADQLOperand)toCopy.coord1.getCopy();
        this.coord2 = (ADQLOperand)toCopy.coord2.getCopy();
        this.centerPoint = (GeometryFunction.GeometryValue)toCopy.centerPoint.getCopy();
        this.radius = (ADQLOperand)toCopy.radius.getCopy();
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new CircleFunction(this);
    }

    @Override
    public String getName() {
        return "CIRCLE";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    public final GeometryFunction.GeometryValue<GeometryFunction> getCenter() {
        return this.centerPoint;
    }

    public final void setCenter(GeometryFunction.GeometryValue<GeometryFunction> newCenter) {
        this.centerPoint = newCenter;
        this.coord1 = null;
        this.coord2 = null;
        this.setPosition(null);
    }

    public final ADQLOperand getCoord1() {
        return this.coord1;
    }

    public final void setCoord1(ADQLOperand coord1) {
        this.coord1 = coord1;
        this.centerPoint = null;
        this.setPosition(null);
    }

    public final ADQLOperand getCoord2() {
        return this.coord2;
    }

    public final void setCoord2(ADQLOperand coord2) {
        this.coord2 = coord2;
        this.centerPoint = null;
        this.setPosition(null);
    }

    public final ADQLOperand getRadius() {
        return this.radius;
    }

    public final void setRadius(ADQLOperand radius) {
        this.radius = radius;
        this.setPosition(null);
    }

    @Override
    public ADQLOperand[] getParameters() {
        if (this.centerPoint == null) {
            return new ADQLOperand[]{this.coordSys, this.coord1, this.coord2, this.radius};
        }
        return new ADQLOperand[]{this.coordSys, this.centerPoint.getValue(), this.radius};
    }

    @Override
    public int getNbParameters() {
        return this.centerPoint == null ? 4 : 3;
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (this.centerPoint == null) {
            switch (index) {
                case 0: {
                    return this.coordSys;
                }
                case 1: {
                    return this.coord1;
                }
                case 2: {
                    return this.coord2;
                }
                case 3: {
                    return this.radius;
                }
            }
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
        }
        switch (index) {
            case 0: {
                return this.coordSys;
            }
            case 1: {
                return this.centerPoint.getValue();
            }
            case 2: {
                return this.radius;
            }
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        ADQLOperand replaced;
        block16: {
            block15: {
                if (replacer == null) {
                    throw new NullPointerException("Impossible to remove one parameter of a " + this.getName() + " function!");
                }
                replaced = null;
                if (this.centerPoint != null) break block15;
                switch (index) {
                    case 0: {
                        replaced = this.coordSys;
                        this.setCoordinateSystem(replacer);
                        break block16;
                    }
                    case 1: {
                        replaced = this.coord1;
                        this.setCoord1(replacer);
                        break block16;
                    }
                    case 2: {
                        replaced = this.coord2;
                        this.setCoord2(replacer);
                        break block16;
                    }
                    case 3: {
                        replaced = this.radius;
                        this.setRadius(replacer);
                        break block16;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
                    }
                }
            }
            switch (index) {
                case 0: {
                    replaced = this.coordSys;
                    this.setCoordinateSystem(replacer);
                    break;
                }
                case 1: {
                    replaced = this.centerPoint.getValue();
                    if (replacer instanceof GeometryFunction.GeometryValue) {
                        this.setCenter((GeometryFunction.GeometryValue)replacer);
                        break;
                    }
                    if (replaced instanceof UnknownType) {
                        this.centerPoint.setUnknownTypeValue((UnknownType)replaced);
                        break;
                    }
                    if (replaced instanceof GeometryFunction) {
                        this.centerPoint.setGeometry((GeometryFunction)replaced);
                        break;
                    }
                    throw new Exception("Impossible to replace a GeometryValue/GeometryFunction/UnknownType by " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                }
                case 2: {
                    replaced = this.radius;
                    this.setRadius(replacer);
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
                }
            }
        }
        return replaced;
    }
}

