/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.parser.feature.LanguageFeature;

public enum OperationType {
    SUM,
    SUB,
    MULT,
    DIV;

    private final LanguageFeature FEATURE = new LanguageFeature(null, this.name(), false);

    public final LanguageFeature getFeatureDescription() {
        return this.FEATURE;
    }

    public static String[] getOperators() {
        return new String[]{SUM.toString(), SUB.toString(), MULT.toString(), DIV.toString()};
    }

    public static OperationType getOperator(String str) throws UnsupportedOperationException {
        if (str.equalsIgnoreCase("+")) {
            return SUM;
        }
        if (str.equalsIgnoreCase("-")) {
            return SUB;
        }
        if (str.equalsIgnoreCase("*")) {
            return MULT;
        }
        if (str.equalsIgnoreCase("/")) {
            return DIV;
        }
        throw new UnsupportedOperationException("Numeric operation unknown: \"" + str + "\" !");
    }

    public String toADQL() {
        return this.toString();
    }

    public String toString() {
        switch (this) {
            case SUM: {
                return "+";
            }
            case SUB: {
                return "-";
            }
            case MULT: {
                return "*";
            }
            case DIV: {
                return "/";
            }
        }
        return "???";
    }
}

