% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{BuildNicheAssay}
\alias{BuildNicheAssay}
\title{Construct an assay for spatial niche analysis}
\usage{
BuildNicheAssay(
  object,
  fov,
  group.by,
  assay = "niche",
  cluster.name = "niches",
  neighbors.k = 20,
  niches.k = 4,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{fov}{FOV object to gather cell positions from}

\item{group.by}{Cell classifications to count in spatial neighborhood}

\item{assay}{Name for spatial neighborhoods assay}

\item{cluster.name}{Name of output clusters}

\item{neighbors.k}{Number of neighbors to consider for each cell}

\item{niches.k}{Number of niche clusters to construct}

\item{...}{Extra parameters passed to \code{\link{kmeans}}}
}
\value{
Seurat object containing a new assay
}
\description{
This function will construct a new assay where each feature is a
cell label. The values represent the sum of a particular cell label
neighboring a given cell.
}
\concept{clustering}
