% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint.R
\name{pkg_lifecycle_statuses}
\alias{pkg_lifecycle_statuses}
\alias{lint_lifecycle}
\alias{lint_tidyverse_lifecycle}
\alias{lifecycle_linter}
\title{Lint usages of functions that have a non-stable life cycle.}
\usage{
pkg_lifecycle_statuses(
  package,
  which = c("superseded", "deprecated", "questioning", "defunct", "experimental",
    "soft-deprecated", "retired")
)

lint_lifecycle(
  packages,
  path = ".",
  pattern = "(?i)[.](r|rmd|qmd|rnw|rhtml|rrst|rtex|rtxt)$",
  which = c("superseded", "deprecated", "questioning", "defunct", "experimental",
    "soft-deprecated", "retired"),
  symbol_is_undesirable = FALSE
)

lint_tidyverse_lifecycle(
  path = ".",
  pattern = "(?i)[.](r|rmd|qmd|rnw|rhtml|rrst|rtex|rtxt)$",
  which = c("superseded", "deprecated", "questioning", "defunct", "experimental",
    "soft-deprecated", "retired"),
  symbol_is_undesirable = FALSE
)

lifecycle_linter(
  packages = tidyverse::tidyverse_packages(),
  which = c("superseded", "deprecated", "questioning", "defunct", "experimental",
    "soft-deprecated", "retired"),
  symbol_is_undesirable = FALSE
)
}
\arguments{
\item{package}{The name of an installed package.}

\item{which}{Vector of lifecycle statuses to lint.}

\item{packages}{One or more installed packages to query for lifecycle statuses.}

\item{path}{The directory path to the files you want to search.}

\item{pattern}{Any files matching this pattern will be searched. The default
searches any files ending in \code{.R} or \code{.Rmd}.}

\item{symbol_is_undesirable}{Also lint symbol usages, e.g. \code{lapply(x, is_na)}?}
}
\description{
\itemize{
\item \code{lifecycle_linter()} creates a linter for lifecycle annotations which can be
included in a \code{.lintr} configuration if \code{lintr} is used directly.
\item \code{lint_lifecycle()} dynamically queries the package documentation for packages
in \code{packages} for lifecycle annotations and then searches the directory in
\code{path} for usages of those functions.
\item \code{lint_tidyverse_lifecycle()} is a convenience function to call \code{lint_lifecycle()}
for all the packages in the tidyverse.
\item \code{pkg_lifecycle_statuses()} returns a data frame of functions with lifecycle
annotations for an installed package.
}
}
\examples{
lintr::lint(
  text = "is_na(x)",
  linters = lifecycle_linter(packages = "rlang")
)
lintr::lint(
  text = "lapply(x, is_na)",
  linters = lifecycle_linter(packages = "rlang",
  symbol_is_undesirable = TRUE)
)
}
