/* Copyright (c) 2001-2020, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.dicom;

/**
 * <p>The {@link com.pixelmed.dicom.TagFromName TagFromName} class contains a selected list of
 * constant values for frequently used {@link com.pixelmed.dicom.AttributeTag AttributeTag}s.</p>
 *
 * <p>Originally it contained the entire data dictionary and was automatically generated, but
 * eventually the class exceeded the maximum size Java supports. Accordingly, it was culled
 * to only a selected list, and known uses of infrequently used tags are flagged as deprecated
 * and may be removed in future releases.</p>
 *
 * <p>In the absence of a constant in this class, the tag can be found by a
 * dictionary lookup, e.g., instead of:</p>
 *
 * <pre>
 *	TagFromName.AcquisitionDate
 * </pre>
 *
 * <p>use:</p>
 *
 * <pre>
 *	DicomDictionary.StandardDictionary.getTagFromName("AcquisitionDate")
 * </pre>
 *
 * <p>In the event of significant performance issues with the dictionary lookup, which are
 * expected to be unlikely due to efficient String pool, well-distributed String hashcodes
 * and HashMap implementations in Java, a user can
 * always define their own equivalent of this class for their own application. E.g., in
 * their own classes, include definitions of their own tags, of the form:
 *
 * <pre>
 *	static public final AttributeTag MyFavoriteTagKeyword = new AttributeTag(0xgggg,0xeeee);
 * </pre>
 *
 * @see com.pixelmed.dicom.DicomDictionary#StandardDictionary
 * @see com.pixelmed.dicom.DicomDictionary#getTagFromName(String)
 *
 * @author	dclunie
 */
public class TagFromName {

	private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/TagFromName.java,v 1.185 2020/12/27 15:30:38 dclunie Exp $";

	static public final AttributeTag AccessionNumber = new AttributeTag(0x0008,0x0050);
	/* @deprecated */ @Deprecated static public final AttributeTag AcquisitionComments = new AttributeTag(0x0018,0x4000);
	static public final AttributeTag AcquisitionContextSequence = new AttributeTag(0x0040,0x0555);
	static public final AttributeTag AcquisitionContrast = new AttributeTag(0x0008,0x9209);
	static public final AttributeTag AcquisitionDate = new AttributeTag(0x0008,0x0022);
	static public final AttributeTag AcquisitionDateTime = new AttributeTag(0x0008,0x002A);
	static public final AttributeTag AcquisitionDuration = new AttributeTag(0x0018,0x9073);
	static public final AttributeTag AcquisitionNumber = new AttributeTag(0x0020,0x0012);
	/* @deprecated */ @Deprecated static public final AttributeTag AcquisitionProtocolDescription = new AttributeTag(0x0018,0x9424);
	static public final AttributeTag AcquisitionTime = new AttributeTag(0x0008,0x0032);
	static public final AttributeTag AcquisitionTimeSynchronized = new AttributeTag(0x0018,0x1800);
	static public final AttributeTag AcquisitionType = new AttributeTag(0x0018,0x9302);
	static public final AttributeTag ActualFrameDuration = new AttributeTag(0x0018,0x1242);
	/* @deprecated */ @Deprecated static public final AttributeTag ActualHumanPerformersSequence = new AttributeTag(0x0040,0x4035);
	static public final AttributeTag AdditionalPatientHistory = new AttributeTag(0x0010,0x21B0);
	static public final AttributeTag AdmissionID = new AttributeTag(0x0038,0x0010);
	/* @deprecated */ @Deprecated static public final AttributeTag AdmittingDate = new AttributeTag(0x0038,0x0020);
	static public final AttributeTag AdmittingDiagnosesCodeSequence = new AttributeTag(0x0008,0x1084);
	static public final AttributeTag AdmittingDiagnosesDescription = new AttributeTag(0x0008,0x1080);
	/* @deprecated */ @Deprecated static public final AttributeTag AdmittingTime = new AttributeTag(0x0038,0x0021);
	static public final AttributeTag AffectedSOPClassUID = new AttributeTag(0x0000,0x0002);
	static public final AttributeTag AffectedSOPInstanceUID = new AttributeTag(0x0000,0x1000);
	static public final AttributeTag Allergies = new AttributeTag(0x0010,0x2110);
	static public final AttributeTag AlternateContentDescriptionSequence = new AttributeTag(0x0070,0x0087);
	static public final AttributeTag AlternateRepresentationSequence = new AttributeTag(0x0008,0x3001);
	static public final AttributeTag AnatomicRegionModifierSequence = new AttributeTag(0x0008,0x2220);
	static public final AttributeTag AnatomicRegionSequence = new AttributeTag(0x0008,0x2218);
	static public final AttributeTag AnatomicalOrientationType = new AttributeTag(0x0010,0x2210);
	/* @deprecated */ @Deprecated static public final AttributeTag Arbitrary = new AttributeTag(0x4000,0x0010);
	static public final AttributeTag AttributeModificationDateTime = new AttributeTag(0x0400,0x0562);
	static public final AttributeTag AuthorizationEquipmentCertificationNumber = new AttributeTag(0x0100,0x0426);
	static public final AttributeTag BarcodeValue = new AttributeTag(0x2200,0x0005);
	static public final AttributeTag BitsAllocated = new AttributeTag(0x0028,0x0100);
	static public final AttributeTag BitsStored = new AttributeTag(0x0028,0x0101);
	static public final AttributeTag BlendingSequence = new AttributeTag(0x0070,0x0402);
	static public final AttributeTag BlockData = new AttributeTag(0x300A,0x0106);
	static public final AttributeTag BluePaletteColorLookupTableData = new AttributeTag(0x0028,0x1203);
	static public final AttributeTag BluePaletteColorLookupTableDescriptor = new AttributeTag(0x0028,0x1103);
	static public final AttributeTag BodyPartExamined = new AttributeTag(0x0018,0x0015);
	static public final AttributeTag BodyPartThickness = new AttributeTag(0x0018,0x11A0);
	/* @deprecated */ @Deprecated static public final AttributeTag BranchOfService = new AttributeTag(0x0010,0x1081);
	static public final AttributeTag BreedRegistrationSequence = new AttributeTag(0x0010,0x2294);
	static public final AttributeTag BurnedInAnnotation = new AttributeTag(0x0028,0x0301);
	/* @deprecated */ @Deprecated static public final AttributeTag CassetteID = new AttributeTag(0x0018,0x1007);
	static public final AttributeTag CTAcquisitionTypeSequence = new AttributeTag(0x0018,0x9301);
	static public final AttributeTag CTExposureSequence = new AttributeTag(0x0018,0x9321);
	static public final AttributeTag CTImageFrameTypeSequence = new AttributeTag(0x0018,0x9329);
	static public final AttributeTag CTPositionSequence = new AttributeTag(0x0018,0x9326);
	static public final AttributeTag CTReconstructionSequence = new AttributeTag(0x0018,0x9314);
	static public final AttributeTag CTTableDynamicsSequence = new AttributeTag(0x0018,0x9308);
	static public final AttributeTag CTXRayDetailsSequence = new AttributeTag(0x0018,0x9325);
	static public final AttributeTag CalibrationImage = new AttributeTag(0x0050,0x0004);
	static public final AttributeTag CenterOfCircularShutter = new AttributeTag(0x0018,0x1610);
	static public final AttributeTag ChannelDefinitionSequence = new AttributeTag(0x003A,0x0200);
	static public final AttributeTag ChannelLabel = new AttributeTag(0x003A,0x0203);
	static public final AttributeTag ChannelSensitivity = new AttributeTag(0x003A,0x0210);
	static public final AttributeTag ChannelSensitivityCorrectionFactor = new AttributeTag(0x003A,0x0212);
	static public final AttributeTag ChannelSensitivityUnitsSequence = new AttributeTag(0x003A,0x0211);
	static public final AttributeTag ChannelSourceSequence = new AttributeTag(0x003A,0x0208);
	static public final AttributeTag ClinicalTrialCoordinatingCenterName = new AttributeTag(0x0012,0x0060);
	static public final AttributeTag ClinicalTrialProtocolEthicsCommitteeApprovalNumber = new AttributeTag(0x0012,0x0082);
	static public final AttributeTag ClinicalTrialProtocolEthicsCommitteeName = new AttributeTag(0x0012,0x0081);
	static public final AttributeTag ClinicalTrialProtocolID = new AttributeTag(0x0012,0x0020);
	static public final AttributeTag ClinicalTrialProtocolName = new AttributeTag(0x0012,0x0021);
	static public final AttributeTag ClinicalTrialSeriesDescription = new AttributeTag(0x0012,0x0072);
	static public final AttributeTag ClinicalTrialSeriesID = new AttributeTag(0x0012,0x0071);
	static public final AttributeTag ClinicalTrialSiteID = new AttributeTag(0x0012,0x0030);
	static public final AttributeTag ClinicalTrialSiteName = new AttributeTag(0x0012,0x0031);
	static public final AttributeTag ClinicalTrialSponsorName = new AttributeTag(0x0012,0x0010);
	static public final AttributeTag ClinicalTrialSubjectID = new AttributeTag(0x0012,0x0040);
	static public final AttributeTag ClinicalTrialSubjectReadingID = new AttributeTag(0x0012,0x0042);
	static public final AttributeTag ClinicalTrialTimePointDescription = new AttributeTag(0x0012,0x0051);
	static public final AttributeTag ClinicalTrialTimePointID = new AttributeTag(0x0012,0x0050);
	static public final AttributeTag CodeMeaning = new AttributeTag(0x0008,0x0104);
	static public final AttributeTag CodeValue = new AttributeTag(0x0008,0x0100);
	static public final AttributeTag CodingSchemeDesignator = new AttributeTag(0x0008,0x0102);
	static public final AttributeTag CodingSchemeIdentificationSequence = new AttributeTag(0x0008,0x0110);
	static public final AttributeTag CodingSchemeName = new AttributeTag(0x0008,0x0115);
	static public final AttributeTag CodingSchemeRegistry = new AttributeTag(0x0008,0x0112);
	static public final AttributeTag CodingSchemeResponsibleOrganization = new AttributeTag(0x0008,0x0116);
	static public final AttributeTag CodingSchemeUID = new AttributeTag(0x0008,0x010C);
	static public final AttributeTag CodingSchemeVersion = new AttributeTag(0x0008,0x0103);
	static public final AttributeTag ColumnPositionInTotalImagePixelMatrix = new AttributeTag(0x0048,0x021E);
	static public final AttributeTag Columns = new AttributeTag(0x0028,0x0011);
	static public final AttributeTag CommandDataSetType = new AttributeTag(0x0000,0x0800);
	static public final AttributeTag CommandField = new AttributeTag(0x0000,0x0100);
	static public final AttributeTag CommandLengthToEnd = new AttributeTag(0x0000,0x0001);
	static public final AttributeTag CommentsOnThePerformedProcedureStep = new AttributeTag(0x0040,0x0280);
	static public final AttributeTag CompensatorThicknessData = new AttributeTag(0x300A,0x00EC);
	static public final AttributeTag CompensatorTransmissionData = new AttributeTag(0x300A,0x00EB);
	static public final AttributeTag CompletionFlag = new AttributeTag(0x0040,0xA491);
	static public final AttributeTag ComplexImageComponent = new AttributeTag(0x0008,0x9208);
	static public final AttributeTag ConcatenationFrameOffsetNumber = new AttributeTag(0x0020,0x9228);
	static public final AttributeTag ConcatenationUID = new AttributeTag(0x0020,0x9161);
	static public final AttributeTag ConceptCodeSequence = new AttributeTag(0x0040,0xA168);
	static public final AttributeTag ConceptNameCodeSequence = new AttributeTag(0x0040,0xA043);
	/* @deprecated */ @Deprecated static public final AttributeTag ConfidentialityConstraintOnPatientDataDescription = new AttributeTag(0x0040,0x3001);
	static public final AttributeTag ConsentForClinicalTrialUseSequence = new AttributeTag(0x0012,0x0083);
	static public final AttributeTag ConsultingPhysicianName = new AttributeTag(0x0008,0x009C);
	static public final AttributeTag ConsultingPhysicianIdentificationSequence = new AttributeTag(0x0008,0x009d);
	static public final AttributeTag ContainerIdentifier = new AttributeTag(0x0040,0x0512);
	static public final AttributeTag ContentCreatorIdentificationCodeSequence = new AttributeTag(0x0070,0x0086);
	static public final AttributeTag ContentCreatorName = new AttributeTag(0x0070,0x0084);
	static public final AttributeTag ContentDate = new AttributeTag(0x0008,0x0023);
	static public final AttributeTag ContentDescription = new AttributeTag(0x0070,0x0081);
	static public final AttributeTag ContentLabel = new AttributeTag(0x0070,0x0080);
	static public final AttributeTag ContentQualification = new AttributeTag(0x0018,0x9004);
	static public final AttributeTag ContentSequence = new AttributeTag(0x0040,0xA730);
	static public final AttributeTag ContentTemplateSequence = new AttributeTag(0x0040,0xA504);
	static public final AttributeTag ContentTime = new AttributeTag(0x0008,0x0033);
	static public final AttributeTag ContextGroupExtensionCreatorUID = new AttributeTag(0x0008,0x010D);
	static public final AttributeTag ContextGroupIdentificationSequence = new AttributeTag(0x0008,0x0123);
	static public final AttributeTag ContinuityOfContent = new AttributeTag(0x0040,0xA050);
	static public final AttributeTag ContourData = new AttributeTag(0x3006,0x0050);
	static public final AttributeTag ContrastBolusAdministrationRouteSequence = new AttributeTag(0x0018,0x0014);
	static public final AttributeTag ContrastBolusAgent = new AttributeTag(0x0018,0x0010);
	static public final AttributeTag ContrastBolusAgentPhase = new AttributeTag(0x0018,0x9344);
	static public final AttributeTag ContrastBolusAgentSequence = new AttributeTag(0x0018,0x0012);
	static public final AttributeTag ContrastBolusIngredient = new AttributeTag(0x0018,0x1048);
	static public final AttributeTag ContrastBolusIngredientConcentration = new AttributeTag(0x0018,0x1049);
	static public final AttributeTag ContrastBolusRoute = new AttributeTag(0x0018,0x1040);
	static public final AttributeTag ContrastBolusStartTime = new AttributeTag(0x0018,0x1042);
	static public final AttributeTag ContrastBolusStopTime = new AttributeTag(0x0018,0x1043);
	static public final AttributeTag ContrastBolusTotalDose = new AttributeTag(0x0018,0x1044);
	static public final AttributeTag ContrastBolusUsageSequence = new AttributeTag(0x0018,0x9341);
	static public final AttributeTag ContrastBolusVolume = new AttributeTag(0x0018,0x1041);
	static public final AttributeTag ContrastFlowDuration = new AttributeTag(0x0018,0x1047);
	static public final AttributeTag ContrastFlowRate = new AttributeTag(0x0018,0x1046);
	static public final AttributeTag ContributingEquipmentSequence = new AttributeTag(0x0018,0xA001);
	static public final AttributeTag ContributionDescription = new AttributeTag(0x0018,0xA003);
	static public final AttributeTag ConversionSourceAttributesSequence = new AttributeTag(0x0020,0x9172);
	static public final AttributeTag ConversionType = new AttributeTag(0x0008,0x0064);
	static public final AttributeTag ConvolutionKernel = new AttributeTag(0x0018,0x1210);
	static public final AttributeTag CorrectedImage = new AttributeTag(0x0028,0x0051);
	/* @deprecated */ @Deprecated static public final AttributeTag CountryOfResidence = new AttributeTag(0x0010,0x2150);
	static public final AttributeTag CreatorVersionUID = new AttributeTag(0x0008,0x9123);
	/* @deprecated */ @Deprecated static public final AttributeTag CurrentPatientLocation = new AttributeTag(0x0038,0x0300);
	static public final AttributeTag CurrentRequestedProcedureEvidenceSequence = new AttributeTag(0x0040,0xA375);
	/* @deprecated */ @Deprecated static public final AttributeTag CurveDate = new AttributeTag(0x0008,0x0025);
	/* @deprecated */ @Deprecated static public final AttributeTag CurveTime = new AttributeTag(0x0008,0x0035);
	static public final AttributeTag DVHData = new AttributeTag(0x3004,0x0058);
	static public final AttributeTag DataPointColumns = new AttributeTag(0x0028,0x9002);
	static public final AttributeTag DataPointRows = new AttributeTag(0x0028,0x9001);
	static public final AttributeTag DataRepresentation = new AttributeTag(0x0028,0x9108);
	static public final AttributeTag DataSetTrailingPadding = new AttributeTag(0xFFFC,0xFFFC);
	static public final AttributeTag Date = new AttributeTag(0x0040,0xA121);
	static public final AttributeTag DateOfLastCalibration = new AttributeTag(0x0018,0x1200);
	static public final AttributeTag DateOfSecondaryCapture = new AttributeTag(0x0018,0x1012);
	static public final AttributeTag DateTime = new AttributeTag(0x0040,0xA120);
	static public final AttributeTag DecayCorrection = new AttributeTag(0x0054,0x1102);
	static public final AttributeTag DeidentificationMethod = new AttributeTag(0x0012,0x0063);
	static public final AttributeTag DeidentificationMethodCodeSequence = new AttributeTag(0x0012,0x0064);
	static public final AttributeTag DerivationCodeSequence = new AttributeTag(0x0008,0x9215);
	static public final AttributeTag DerivationDescription = new AttributeTag(0x0008,0x2111);
	static public final AttributeTag DerivationImageSequence = new AttributeTag(0x0008,0x9124);
	/* @deprecated */ @Deprecated static public final AttributeTag DetectorID = new AttributeTag(0x0018,0x700A);
	static public final AttributeTag DeviceSerialNumber = new AttributeTag(0x0018,0x1000);
	static public final AttributeTag DeviceUID = new AttributeTag(0x0018,0x1002);
	static public final AttributeTag DigitalImageFormatAcquired = new AttributeTag(0x0018,0x1023);
	/* @deprecated */ @Deprecated static public final AttributeTag DigitalSignatureUID = new AttributeTag(0x0400,0x0100);
	/* @deprecated */ @Deprecated static public final AttributeTag DigitalSignaturesSequence = new AttributeTag(0xFFFA,0xFFFA);
	static public final AttributeTag DigitizingDeviceTransportDirection = new AttributeTag(0x0018,0x2020);
	static public final AttributeTag DimensionDescriptionLabel = new AttributeTag(0x0020,0x9421);
	static public final AttributeTag DimensionIndexPointer = new AttributeTag(0x0020,0x9165);
	static public final AttributeTag DimensionIndexSequence = new AttributeTag(0x0020,0x9222);
	static public final AttributeTag DimensionIndexValues = new AttributeTag(0x0020,0x9157);
	static public final AttributeTag DimensionOrganizationSequence = new AttributeTag(0x0020,0x9221);
	static public final AttributeTag DimensionOrganizationType = new AttributeTag(0x0020,0x9311);
	static public final AttributeTag DimensionOrganizationUID = new AttributeTag(0x0020,0x9164);
	static public final AttributeTag DirectoryRecordSequence = new AttributeTag(0x0004,0x1220);
	static public final AttributeTag DirectoryRecordType = new AttributeTag(0x0004,0x1430);
	/* @deprecated */ @Deprecated static public final AttributeTag DischargeDiagnosisDescription = new AttributeTag(0x0038,0x0040);
	static public final AttributeTag DistanceSourceToDetector = new AttributeTag(0x0018,0x1110);
	static public final AttributeTag DistanceSourceToPatient = new AttributeTag(0x0018,0x1111);
	/* @deprecated */ @Deprecated static public final AttributeTag DistributionAddress = new AttributeTag(0x4008,0x011A);
	/* @deprecated */ @Deprecated static public final AttributeTag DistributionName = new AttributeTag(0x4008,0x0119);
	static public final AttributeTag DocumentClassCodeSequence = new AttributeTag(0x0040,0xE008);
	static public final AttributeTag DocumentTitle = new AttributeTag(0x0042,0x0010);
	/* @deprecated */ @Deprecated static public final AttributeTag DopplerCorrectionAngle = new AttributeTag(0x0018,0x6034);
	static public final AttributeTag DoseComment = new AttributeTag(0x3004,0x0006);
	static public final AttributeTag DoseSummationType = new AttributeTag(0x3004,0x000A);
	static public final AttributeTag DoubleFloatPixelData = new AttributeTag(0x7FE0,0x0009);
	static public final AttributeTag EchoNumbers = new AttributeTag(0x0018,0x0086);
	static public final AttributeTag EchoTime = new AttributeTag(0x0018,0x0081);
	static public final AttributeTag EchoTrainLength = new AttributeTag(0x0018,0x0091);
	static public final AttributeTag EncapsulatedDocument = new AttributeTag(0x0042,0x0011);
	static public final AttributeTag EncapsulatedDocumentLength = new AttributeTag(0x0042,0x0015);
	static public final AttributeTag EncryptedAttributesSequence = new AttributeTag(0x0400,0x0500);
	static public final AttributeTag EncryptedContentTransferSyntaxUID = new AttributeTag(0x0400,0x0510);
	static public final AttributeTag EndMessageID = new AttributeTag(0x0000,0x5020);
	static public final AttributeTag EquipmentFrameOfReferenceUID = new AttributeTag(0x300A,0x0675);
	static public final AttributeTag ErrorComment = new AttributeTag(0x0000,0x0902);
	static public final AttributeTag EstimatedRadiographicMagnificationFactor = new AttributeTag(0x0018,0x1114);
	static public final AttributeTag EthnicGroup = new AttributeTag(0x0010,0x2160);
	static public final AttributeTag FiducialUID = new AttributeTag(0x0070,0x031A);
	static public final AttributeTag FieldOfViewDimensionsInFloat = new AttributeTag(0x0018,0x9461);
	static public final AttributeTag FieldOfViewHorizontalFlip = new AttributeTag(0x0018,0x7034);
	static public final AttributeTag FieldOfViewOrigin = new AttributeTag(0x0018,0x7030);
	static public final AttributeTag FieldOfViewRotation = new AttributeTag(0x0018,0x7032);
	static public final AttributeTag FieldOfViewShape = new AttributeTag(0x0018,0x1147);
	static public final AttributeTag FileMetaInformationGroupLength = new AttributeTag(0x0002,0x0000);
	static public final AttributeTag FileMetaInformationVersion = new AttributeTag(0x0002,0x0001);
	static public final AttributeTag FileSetConsistencyFlag = new AttributeTag(0x0004,0x1212);
	static public final AttributeTag FileSetID = new AttributeTag(0x0004,0x1130);
	static public final AttributeTag FillerOrderNumberImagingServiceRequest = new AttributeTag(0x0040,0x2017);
	static public final AttributeTag FloatPixelData = new AttributeTag(0x7FE0,0x0008);
	static public final AttributeTag FloatingPointValue = new AttributeTag(0x0040,0xA161);
	static public final AttributeTag FrameAcquisitionDateTime = new AttributeTag(0x0018,0x9074);
	static public final AttributeTag FrameAcquisitionDuration = new AttributeTag(0x0018,0x9220);
	static public final AttributeTag FrameAcquisitionNumber = new AttributeTag(0x0020,0x9156);
	static public final AttributeTag FrameAnatomySequence = new AttributeTag(0x0020,0x9071);
	static public final AttributeTag FrameComments = new AttributeTag(0x0020,0x9158);
	static public final AttributeTag FrameContentSequence = new AttributeTag(0x0020,0x9111);
	static public final AttributeTag FrameIncrementPointer = new AttributeTag(0x0028,0x0009);
	static public final AttributeTag FrameLaterality = new AttributeTag(0x0020,0x9072);
	static public final AttributeTag FrameOfReferenceUID = new AttributeTag(0x0020,0x0052);
	static public final AttributeTag FrameReferenceDateTime = new AttributeTag(0x0018,0x9151);
	static public final AttributeTag FrameReferenceTime = new AttributeTag(0x0054,0x1300);
	static public final AttributeTag FrameTime = new AttributeTag(0x0018,0x1063);
	static public final AttributeTag FrameType = new AttributeTag(0x0008,0x9007);
	static public final AttributeTag FrameVOILUTSequence = new AttributeTag(0x0028,0x9132);
	static public final AttributeTag FunctionalGroupPointer = new AttributeTag(0x0020,0x9167);
	static public final AttributeTag GantryID = new AttributeTag(0x0018,0x1008);
	/* @deprecated */ @Deprecated static public final AttributeTag GeneratorID = new AttributeTag(0x0018,0x1005);
	static public final AttributeTag GeneticModificationsSequence = new AttributeTag(0x0010,0x0221);
	static public final AttributeTag GraphicAnnotationSequence = new AttributeTag(0x0070,0x0001);
	static public final AttributeTag GraphicData = new AttributeTag(0x0070,0x0022);
	static public final AttributeTag GraphicType = new AttributeTag(0x0070,0x0023);
	static public final AttributeTag GreenPaletteColorLookupTableData = new AttributeTag(0x0028,0x1202);
	static public final AttributeTag GreenPaletteColorLookupTableDescriptor = new AttributeTag(0x0028,0x1102);
	static public final AttributeTag GroupOfPatientsIdentificationSequence = new AttributeTag(0x0010,0x0027);
	/* @deprecated */ @Deprecated static public final AttributeTag HeartRate = new AttributeTag(0x0018,0x1088);
	/* @deprecated */ @Deprecated static public final AttributeTag HumanPerformerName = new AttributeTag(0x0040,0x4037);
	/* @deprecated */ @Deprecated static public final AttributeTag HumanPerformerOrganization = new AttributeTag(0x0040,0x4036);
	static public final AttributeTag HL7DocumentTypeCodeSequence = new AttributeTag(0x0040,0xE006);
	static public final AttributeTag HL7InstanceIdentifier = new AttributeTag(0x0040,0xE001);
	static public final AttributeTag HL7StructuredDocumentReferenceSequence = new AttributeTag(0x0040,0xA390);
	static public final AttributeTag HighBit = new AttributeTag(0x0028,0x0102);
	static public final AttributeTag HistogramData = new AttributeTag(0x0060,0x3020);
	static public final AttributeTag ICCProfile = new AttributeTag(0x0028,0x2000);
	static public final AttributeTag IconImageSequence = new AttributeTag(0x0088,0x0200);
	/* @deprecated */ @Deprecated static public final AttributeTag IdentifyingComments = new AttributeTag(0x0008,0x4000);
	static public final AttributeTag Illumination = new AttributeTag(0x2010,0x015E);
	static public final AttributeTag ImageComments = new AttributeTag(0x0020,0x4000);
	static public final AttributeTag ImageFrameOrigin = new AttributeTag(0x6000,0x0051);
	static public final AttributeTag ImageLaterality = new AttributeTag(0x0020,0x0062);
	static public final AttributeTag ImageOrientationPatient = new AttributeTag(0x0020,0x0037);
	static public final AttributeTag ImageOrientationSlide = new AttributeTag(0x0048,0x0102);
	static public final AttributeTag ImagePositionPatient = new AttributeTag(0x0020,0x0032);
	/* @deprecated */ @Deprecated static public final AttributeTag ImagePresentationComments = new AttributeTag(0x0028,0x4000);
	static public final AttributeTag ImageType = new AttributeTag(0x0008,0x0008);
	static public final AttributeTag ImagedNucleus = new AttributeTag(0x0018,0x0085);
	static public final AttributeTag ImagerPixelSpacing = new AttributeTag(0x0018,0x1164);
	/* @deprecated */ @Deprecated static public final AttributeTag ImagingServiceRequestComments = new AttributeTag(0x0040,0x2400);
	static public final AttributeTag ImplementationClassUID = new AttributeTag(0x0002,0x0012);
	static public final AttributeTag ImplementationVersionName = new AttributeTag(0x0002,0x0013);
	/* @deprecated */ @Deprecated static public final AttributeTag Impressions = new AttributeTag(0x4008,0x0300);
	static public final AttributeTag InConcatenationNumber = new AttributeTag(0x0020,0x9162);
	static public final AttributeTag InConcatenationTotalNumber = new AttributeTag(0x0020,0x9163);
	static public final AttributeTag InStackPositionNumber = new AttributeTag(0x0020,0x9057);
	static public final AttributeTag InstanceCoercionDateTime = new AttributeTag(0x0008,0x0015);
	static public final AttributeTag InstanceCreationDate = new AttributeTag(0x0008,0x0012);
	static public final AttributeTag InstanceCreationTime = new AttributeTag(0x0008,0x0013);
	static public final AttributeTag InstanceCreatorUID = new AttributeTag(0x0008,0x0014);
	static public final AttributeTag InstanceNumber = new AttributeTag(0x0020,0x0013);
	static public final AttributeTag InstanceOriginStatus = new AttributeTag(0x0400,0x0600);
	static public final AttributeTag InstitutionAddress = new AttributeTag(0x0008,0x0081);
	static public final AttributeTag InstitutionCodeSequence = new AttributeTag(0x0008,0x0082);
	static public final AttributeTag InstitutionName = new AttributeTag(0x0008,0x0080);
	static public final AttributeTag InstitutionalDepartmentName = new AttributeTag(0x0008,0x1040);
	/* @deprecated */ @Deprecated static public final AttributeTag InsurancePlanIdentification = new AttributeTag(0x0010,0x1050);
	/* @deprecated */ @Deprecated static public final AttributeTag InterpretationApproverSequence = new AttributeTag(0x4008,0x0111);
	static public final AttributeTag InterpretationAuthor = new AttributeTag(0x4008,0x010C);
	/* @deprecated */ @Deprecated static public final AttributeTag InterpretationDiagnosisDescription = new AttributeTag(0x4008,0x0115);
	/* @deprecated */ @Deprecated static public final AttributeTag InterpretationIDIssuer = new AttributeTag(0x4008,0x0202);
	/* @deprecated */ @Deprecated static public final AttributeTag InterpretationRecorder = new AttributeTag(0x4008,0x0102);
	/* @deprecated */ @Deprecated static public final AttributeTag InterpretationText = new AttributeTag(0x4008,0x010B);
	/* @deprecated */ @Deprecated static public final AttributeTag InterpretationTranscriber = new AttributeTag(0x4008,0x010A);
	static public final AttributeTag IrradiationEventUID = new AttributeTag(0x0008,0x3010);
	static public final AttributeTag IssuerOfAccessionNumberSequence = new AttributeTag(0x0008,0x0051);
	static public final AttributeTag IssuerOfAdmissionID = new AttributeTag(0x0038,0x0011);
	static public final AttributeTag IssuerOfAdmissionIDSequence = new AttributeTag(0x0038,0x0014);
	static public final AttributeTag IssuerOfPatientID = new AttributeTag(0x0010,0x0021);
	static public final AttributeTag IssuerOfPatientIDQualifiersSequence = new AttributeTag(0x0010,0x0024);
	static public final AttributeTag IssuerOfServiceEpisodeID = new AttributeTag(0x0038,0x0061);
	static public final AttributeTag IssuerOfServiceEpisodeIDSequence = new AttributeTag(0x0038,0x0064);
	static public final AttributeTag Item = new AttributeTag(0xFFFE,0xE000);
	static public final AttributeTag ItemDelimitationItem = new AttributeTag(0xFFFE,0xE00D);
	static public final AttributeTag LastMenstrualDate = new AttributeTag(0x0010,0x21D0);
	static public final AttributeTag LUTData = new AttributeTag(0x0028,0x3006);
	static public final AttributeTag LUTDescriptor = new AttributeTag(0x0028,0x3002);
	static public final AttributeTag LUTExplanation = new AttributeTag(0x0028,0x3003);
	static public final AttributeTag LUTLabel = new AttributeTag(0x0040,0x9210);
	static public final AttributeTag LanguageCodeSequence = new AttributeTag(0x0008,0x0006);
	static public final AttributeTag LargestImagePixelValue = new AttributeTag(0x0028,0x0107);
	static public final AttributeTag LargestMonochromePixelValue = new AttributeTag(0x0028,0x9099);
	static public final AttributeTag Laterality = new AttributeTag(0x0020,0x0060);
	static public final AttributeTag LengthToEnd = new AttributeTag(0x0008,0x0001);
	static public final AttributeTag LongitudinalTemporalInformationModified = new AttributeTag(0x0028,0x0303);
	static public final AttributeTag LongitudinalTemporalOffsetFromEvent = new AttributeTag(0x0012,0x0052);
	static public final AttributeTag LongitudinalTemporalEventType = new AttributeTag(0x0012,0x0053);
	static public final AttributeTag LongPrimitivePointIndexList = new AttributeTag(0x0066,0x0040);
	static public final AttributeTag LossyImageCompression = new AttributeTag(0x0028,0x2110);
	static public final AttributeTag LossyImageCompressionMethod = new AttributeTag(0x0028,0x2114);
	static public final AttributeTag LossyImageCompressionRatio = new AttributeTag(0x0028,0x2112);
	/* @deprecated */ @Deprecated static public final AttributeTag MAC = new AttributeTag(0x0400,0x0404);
	static public final AttributeTag MACCalculationTransferSyntaxUID = new AttributeTag(0x0400,0x0010);
	static public final AttributeTag MappingResourceIdentificationSequence = new AttributeTag(0x0008,0x0124);
	static public final AttributeTag MIMETypeOfEncapsulatedDocument = new AttributeTag(0x0042,0x0012);
	static public final AttributeTag MRAcquisitionType = new AttributeTag(0x0018,0x0023);
	static public final AttributeTag MRAveragesSequence = new AttributeTag(0x0018,0x9119);
	static public final AttributeTag MRDiffusionSequence = new AttributeTag(0x0018,0x9117);
	static public final AttributeTag MREchoSequence = new AttributeTag(0x0018,0x9114);
	static public final AttributeTag MRImageFrameTypeSequence = new AttributeTag(0x0018,0x9226);
	static public final AttributeTag MRModifierSequence = new AttributeTag(0x0018,0x9115);
	static public final AttributeTag MRTimingAndRelatedParametersSequence = new AttributeTag(0x0018,0x9112);
	static public final AttributeTag Manufacturer = new AttributeTag(0x0008,0x0070);
	static public final AttributeTag ManufacturerDeviceClassUID = new AttributeTag(0x0018,0x100b);
	static public final AttributeTag ManufacturerModelName = new AttributeTag(0x0008,0x1090);
	static public final AttributeTag MappingResource = new AttributeTag(0x0008,0x0105);
	static public final AttributeTag MaximumFractionalValue = new AttributeTag(0x0062,0x000e);
	static public final AttributeTag MeasuredAPDimension = new AttributeTag(0x0010,0x1023);
	static public final AttributeTag MeasuredLateralDimension = new AttributeTag(0x0010,0x1024);
	static public final AttributeTag MeasuredValueSequence = new AttributeTag(0x0040,0xA300);
	static public final AttributeTag MeasurementLaterality = new AttributeTag(0x0024,0x0113);
	static public final AttributeTag MeasurementUnitsCodeSequence = new AttributeTag(0x0040,0x08EA);
	static public final AttributeTag MeasuringUnitsSequence = new AttributeTag(0x0040,0x0295);
	static public final AttributeTag MediaStorageSOPClassUID = new AttributeTag(0x0002,0x0002);
	static public final AttributeTag MediaStorageSOPInstanceUID = new AttributeTag(0x0002,0x0003);
	static public final AttributeTag MedicalAlerts = new AttributeTag(0x0010,0x2000);
	/* @deprecated */ @Deprecated static public final AttributeTag MedicalRecordLocator = new AttributeTag(0x0010,0x1090);
	static public final AttributeTag MessageID = new AttributeTag(0x0000,0x0110);
	static public final AttributeTag MessageIDBeingRespondedTo = new AttributeTag(0x0000,0x0120);
	static public final AttributeTag MidSlabPosition = new AttributeTag(0x0018,0x9106);
	/* @deprecated */ @Deprecated static public final AttributeTag MilitaryRank = new AttributeTag(0x0010,0x1080);
	static public final AttributeTag ModalitiesInStudy = new AttributeTag(0x0008,0x0061);
	static public final AttributeTag Modality = new AttributeTag(0x0008,0x0060);
	static public final AttributeTag ModifiedAttributesSequence = new AttributeTag(0x0400,0x0550);
	/* @deprecated */ @Deprecated static public final AttributeTag ModifiedImageDescription = new AttributeTag(0x0020,0x3406);
	static public final AttributeTag ModifyingSystem = new AttributeTag(0x0400,0x0563);
	/* @deprecated */ @Deprecated static public final AttributeTag ModifyingDeviceID = new AttributeTag(0x0020,0x3401);
	/* @deprecated */ @Deprecated static public final AttributeTag ModifyingDeviceManufacturer = new AttributeTag(0x0020,0x3404);
	static public final AttributeTag MoveDestination = new AttributeTag(0x0000,0x0600);
	static public final AttributeTag MoveOriginatorApplicationEntityTitle = new AttributeTag(0x0000,0x1030);
	static public final AttributeTag MoveOriginatorMessageID = new AttributeTag(0x0000,0x1031);
	static public final AttributeTag NameOfPhysiciansReadingStudy = new AttributeTag(0x0008,0x1060);
	/* @deprecated */ @Deprecated static public final AttributeTag NamesOfIntendedRecipientsOfResults = new AttributeTag(0x0040,0x1010);
	static public final AttributeTag NominalScannedPixelSpacing = new AttributeTag(0x0018,0x2010);
	static public final AttributeTag NumberOfCompletedSuboperations = new AttributeTag(0x0000,0x1021);
	static public final AttributeTag NumberOfFailedSuboperations = new AttributeTag(0x0000,0x1022);
	static public final AttributeTag NumberOfFrames = new AttributeTag(0x0028,0x0008);
	static public final AttributeTag NumberOfFramesInOverlay = new AttributeTag(0x6000,0x0015);
	static public final AttributeTag NumberOfPatientRelatedStudies = new AttributeTag(0x0020,0x1200);
	static public final AttributeTag NumberOfRemainingSuboperations = new AttributeTag(0x0000,0x1020);
	static public final AttributeTag NumberOfSeriesRelatedInstances = new AttributeTag(0x0020,0x1209);
	static public final AttributeTag NumberOfStudyRelatedInstances = new AttributeTag(0x0020,0x1208);
	static public final AttributeTag NumberOfStudyRelatedSeries = new AttributeTag(0x0020,0x1206);
	static public final AttributeTag NumberOfWarningSuboperations = new AttributeTag(0x0000,0x1023);
	static public final AttributeTag NumberOfWaveformChannels = new AttributeTag(0x003A,0x0005);
	static public final AttributeTag NumberOfWaveformSamples = new AttributeTag(0x003A,0x0010);
	static public final AttributeTag NumericValue = new AttributeTag(0x0040,0xA30A);
	static public final AttributeTag NumericValueQualifierCodeSequence = new AttributeTag(0x0040,0xA301);
	static public final AttributeTag ObservationDateTime = new AttributeTag(0x0040,0xA032);
	static public final AttributeTag ObservationUID = new AttributeTag(0x0040,0xA171);
	static public final AttributeTag Occupation = new AttributeTag(0x0010,0x2180);
	static public final AttributeTag OffendingElement = new AttributeTag(0x0000,0x0901);
	static public final AttributeTag OffsetOfReferencedLowerLevelDirectoryEntity = new AttributeTag(0x0004,0x1420);
	static public final AttributeTag OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity = new AttributeTag(0x0004,0x1200);
	static public final AttributeTag OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity = new AttributeTag(0x0004,0x1202);
	static public final AttributeTag OffsetOfTheNextDirectoryRecord = new AttributeTag(0x0004,0x1400);
	static public final AttributeTag OperatorIdentificationSequence = new AttributeTag(0x0008,0x1072);
	static public final AttributeTag OperatorsName = new AttributeTag(0x0008,0x1070);
	static public final AttributeTag OpticalPathSequence = new AttributeTag(0x0048,0x0105);
	/* @deprecated */ @Deprecated static public final AttributeTag OrderCallbackPhoneNumber = new AttributeTag(0x0040,0x2010);
	/* @deprecated */ @Deprecated static public final AttributeTag OrderEnteredBy = new AttributeTag(0x0040,0x2008);
	/* @deprecated */ @Deprecated static public final AttributeTag OrderEntererLocation = new AttributeTag(0x0040,0x2009);
	static public final AttributeTag OrderFillerIdentifierSequence = new AttributeTag(0x0040,0x0027);
	static public final AttributeTag OrderPlacerIdentifierSequence = new AttributeTag(0x0040,0x0026);
	static public final AttributeTag OriginalAttributesSequence = new AttributeTag(0x0400,0x0561);
	static public final AttributeTag OriginalSpecializedSOPClassUID = new AttributeTag(0x0008,0x001B);
	static public final AttributeTag OtherPatientIDs = new AttributeTag(0x0010,0x1000);
	static public final AttributeTag OtherPatientIDsSequence = new AttributeTag(0x0010,0x1002);
	static public final AttributeTag OtherPatientNames = new AttributeTag(0x0010,0x1001);
	static public final AttributeTag OtherStudyNumbers = new AttributeTag(0x0020,0x1070);
	static public final AttributeTag OverlayBitPosition = new AttributeTag(0x6000,0x0102);
	static public final AttributeTag OverlayBitsAllocated = new AttributeTag(0x6000,0x0100);
	static public final AttributeTag OverlayColumns = new AttributeTag(0x6000,0x0011);
	/* @deprecated */ @Deprecated static public final AttributeTag OverlayComments = new AttributeTag(0x6000,0x4000);
	static public final AttributeTag OverlayData = new AttributeTag(0x6000,0x3000);
	/* @deprecated */ @Deprecated static public final AttributeTag OverlayDate = new AttributeTag(0x0008,0x0024);
	static public final AttributeTag OverlayDescription = new AttributeTag(0x6000,0x0022);
	static public final AttributeTag OverlayLabel = new AttributeTag(0x6000,0x1500);
	static public final AttributeTag OverlayOrigin = new AttributeTag(0x6000,0x0050);
	static public final AttributeTag OverlayRows = new AttributeTag(0x6000,0x0010);
	static public final AttributeTag OverlaySubtype = new AttributeTag(0x6000,0x0045);
	/* @deprecated */ @Deprecated static public final AttributeTag OverlayTime = new AttributeTag(0x0008,0x0034);
	static public final AttributeTag OverlayType = new AttributeTag(0x6000,0x0040);
	static public final AttributeTag PETFrameTypeSequence = new AttributeTag(0x0018,0x9751);
	static public final AttributeTag PageNumberVector = new AttributeTag(0x0018,0x2001);
	static public final AttributeTag PaletteColorLookupTableUID = new AttributeTag(0x0028,0x1199);
	static public final AttributeTag ParametricMapFrameTypeSequence = new AttributeTag(0x0040,0x9092);
	/* @deprecated */ @Deprecated static public final AttributeTag ParticipantSequence = new AttributeTag(0x0040,0xA07A);
	/* @deprecated */ @Deprecated static public final AttributeTag PatientAddress = new AttributeTag(0x0010,0x1040);
	static public final AttributeTag PatientAge = new AttributeTag(0x0010,0x1010);
	static public final AttributeTag PatientBirthDate = new AttributeTag(0x0010,0x0030);
	static public final AttributeTag PatientBirthTime = new AttributeTag(0x0010,0x0032);
	static public final AttributeTag PatientBirthDateInAlternativeCalendar = new AttributeTag(0x0010,0x0033);
	static public final AttributeTag PatientDeathDateInAlternativeCalendar = new AttributeTag(0x0010,0x0034);
	static public final AttributeTag PatientAlternativeCalendar = new AttributeTag(0x0010,0x0035);
	static public final AttributeTag PatientBodyMassIndex = new AttributeTag(0x0010,0x1022);
	static public final AttributeTag PatientBreedCodeSequence = new AttributeTag(0x0010,0x2293);
	static public final AttributeTag PatientBreedDescription = new AttributeTag(0x0010,0x2292);
	static public final AttributeTag PatientComments = new AttributeTag(0x0010,0x4000);
	static public final AttributeTag PatientID = new AttributeTag(0x0010,0x0020);
	static public final AttributeTag PatientIdentityRemoved = new AttributeTag(0x0012,0x0062);
	/* @deprecated */ @Deprecated static public final AttributeTag PatientInstitutionResidence = new AttributeTag(0x0038,0x0400);
	/* @deprecated */ @Deprecated static public final AttributeTag PatientInsurancePlanCodeSequence = new AttributeTag(0x0010,0x0050);
	/* @deprecated */ @Deprecated static public final AttributeTag PatientMotherBirthName = new AttributeTag(0x0010,0x1060);
	static public final AttributeTag PatientName = new AttributeTag(0x0010,0x0010);
	static public final AttributeTag PatientOrientation = new AttributeTag(0x0020,0x0020);
	static public final AttributeTag PatientPosition = new AttributeTag(0x0018,0x5100);
	/* @deprecated */ @Deprecated static public final AttributeTag PatientPrimaryLanguageCodeSequence = new AttributeTag(0x0010,0x0101);
	/* @deprecated */ @Deprecated static public final AttributeTag PatientPrimaryLanguageModifierCodeSequence = new AttributeTag(0x0010,0x0102);
	/* @deprecated */ @Deprecated static public final AttributeTag PatientReligiousPreference = new AttributeTag(0x0010,0x21F0);
	static public final AttributeTag PatientSex = new AttributeTag(0x0010,0x0040);
	static public final AttributeTag PatientSexNeutered = new AttributeTag(0x0010,0x2203);
	static public final AttributeTag PatientSize = new AttributeTag(0x0010,0x1020);
	static public final AttributeTag PatientSizeCodeSequence = new AttributeTag(0x0010,0x1021);
	static public final AttributeTag PatientSpeciesCodeSequence = new AttributeTag(0x0010,0x2202);
	static public final AttributeTag PatientSpeciesDescription = new AttributeTag(0x0010,0x2201);
	static public final AttributeTag PatientState = new AttributeTag(0x0038,0x0500);
	/* @deprecated */ @Deprecated static public final AttributeTag PatientTelephoneNumbers = new AttributeTag(0x0010,0x2154);
	/* @deprecated */ @Deprecated static public final AttributeTag PatientTransportArrangements = new AttributeTag(0x0040,0x1004);
	static public final AttributeTag PatientWeight = new AttributeTag(0x0010,0x1030);
	static public final AttributeTag PerFrameFunctionalGroupsSequence = new AttributeTag(0x5200,0x9230);
	/* @deprecated */ @Deprecated static public final AttributeTag PerformedLocation = new AttributeTag(0x0040,0x0243);
	static public final AttributeTag PerformedProcedureCodeSequence = new AttributeTag(0x0040,0xA372);
	static public final AttributeTag PerformedProcedureStepDescription = new AttributeTag(0x0040,0x0254);
	static public final AttributeTag PerformedProcedureStepID = new AttributeTag(0x0040,0x0253);
	static public final AttributeTag PerformedProcedureStepStartDate = new AttributeTag(0x0040,0x0244);
	static public final AttributeTag PerformedProcedureStepStartTime = new AttributeTag(0x0040,0x0245);
	static public final AttributeTag PerformedProtocolCodeSequence = new AttributeTag(0x0040,0x0260);
	/* @deprecated */ @Deprecated static public final AttributeTag PerformedStationGeographicLocationCodeSequence = new AttributeTag(0x0040,0x4030);
	/* @deprecated */ @Deprecated static public final AttributeTag PerformedStationNameCodeSequence = new AttributeTag(0x0040,0x4028);
	static public final AttributeTag PerformingPhysicianIdentificationSequence = new AttributeTag(0x0008,0x1052);
	static public final AttributeTag PerformingPhysicianName = new AttributeTag(0x0008,0x1050);
	static public final AttributeTag PersonAddress = new AttributeTag(0x0040,0x1102);
	static public final AttributeTag PersonIdentificationCodeSequence = new AttributeTag(0x0040,0x1101);
	static public final AttributeTag PersonName = new AttributeTag(0x0040,0xA123);
	static public final AttributeTag PersonTelephoneNumbers = new AttributeTag(0x0040,0x1103);
	static public final AttributeTag PhotometricInterpretation = new AttributeTag(0x0028,0x0004);
	/* @deprecated */ @Deprecated static public final AttributeTag PhysicalDeltaX = new AttributeTag(0x0018,0x602C);
	/* @deprecated */ @Deprecated static public final AttributeTag PhysicalDeltaY = new AttributeTag(0x0018,0x602E);
	/* @deprecated */ @Deprecated static public final AttributeTag PhysicalUnitsXDirection = new AttributeTag(0x0018,0x6024);
	/* @deprecated */ @Deprecated static public final AttributeTag PhysicalUnitsYDirection = new AttributeTag(0x0018,0x6026);
	/* @deprecated */ @Deprecated static public final AttributeTag PhysicianApprovingInterpretation = new AttributeTag(0x4008,0x0114);
	static public final AttributeTag PhysiciansOfRecord = new AttributeTag(0x0008,0x1048);
	static public final AttributeTag PhysiciansOfRecordIdentificationSequence = new AttributeTag(0x0008,0x1049);
	static public final AttributeTag PhysiciansReadingStudyIdentificationSequence = new AttributeTag(0x0008,0x1062);
	static public final AttributeTag PixelAspectRatio = new AttributeTag(0x0028,0x0034);
	static public final AttributeTag PixelData = new AttributeTag(0x7FE0,0x0010);
	static public final AttributeTag PixelDataProviderURL = new AttributeTag(0x0028,0x7FE0);
	static public final AttributeTag PixelMeasuresSequence = new AttributeTag(0x0028,0x9110);
	static public final AttributeTag PixelOriginInterpretation = new AttributeTag(0x0048,0x0301);
	static public final AttributeTag PixelPaddingRangeLimit = new AttributeTag(0x0028,0x0121);
	static public final AttributeTag PixelPaddingValue = new AttributeTag(0x0028,0x0120);
	static public final AttributeTag PixelPresentation = new AttributeTag(0x0008,0x9205);
	static public final AttributeTag PixelRepresentation = new AttributeTag(0x0028,0x0103);
	static public final AttributeTag PixelSpacing = new AttributeTag(0x0028,0x0030);
	static public final AttributeTag PixelSpacingCalibrationDescription = new AttributeTag(0x0028,0x0A04);
	static public final AttributeTag PixelSpacingCalibrationType = new AttributeTag(0x0028,0x0A02);
	static public final AttributeTag PixelValueTransformationSequence = new AttributeTag(0x0028,0x9145);
	static public final AttributeTag PlacerOrderNumberImagingServiceRequest = new AttributeTag(0x0040,0x2016);
	static public final AttributeTag PlanarConfiguration = new AttributeTag(0x0028,0x0006);
	static public final AttributeTag PlaneOrientationSequence = new AttributeTag(0x0020,0x9116);
	static public final AttributeTag PlanePositionSequence = new AttributeTag(0x0020,0x9113);
	static public final AttributeTag PlanePositionSlideSequence = new AttributeTag(0x0048,0x021A);
	/* @deprecated */ @Deprecated static public final AttributeTag PlateID = new AttributeTag(0x0018,0x1004);
	static public final AttributeTag PointCoordinatesData = new AttributeTag(0x0066,0x0016);
	static public final AttributeTag PositionReferenceIndicator = new AttributeTag(0x0020,0x1040);
	/* @deprecated */ @Deprecated static public final AttributeTag PreMedication = new AttributeTag(0x0040,0x0012);
	static public final AttributeTag PredecessorDocumentsSequence = new AttributeTag(0x0040,0xA360);
	static public final AttributeTag PregnancyStatus = new AttributeTag(0x0010,0x21C0);
	static public final AttributeTag PresentationCreationDate = new AttributeTag(0x0070,0x0082);
	static public final AttributeTag PresentationCreationTime = new AttributeTag(0x0070,0x0083);
	static public final AttributeTag PresentationIntentType = new AttributeTag(0x0008,0x0068);
	static public final AttributeTag PresentationLUTShape = new AttributeTag(0x2050,0x0020);
	static public final AttributeTag PrimaryAnatomicStructureSequence = new AttributeTag(0x0008,0x2228);
	static public final AttributeTag Priority = new AttributeTag(0x0000,0x0700);
	static public final AttributeTag PrivateDataElementCharacteristicsSequence = new AttributeTag(0x0008,0x0300);
	static public final AttributeTag PrivateInformationCreatorUID = new AttributeTag(0x0002,0x0100);
	static public final AttributeTag PrivateRecordUID = new AttributeTag(0x0004,0x1432);
	static public final AttributeTag ProcedureCodeSequence = new AttributeTag(0x0008,0x1032);
	/* @deprecated */ @Deprecated static public final AttributeTag ProcessingFunction = new AttributeTag(0x0018,0x5020);
	static public final AttributeTag ProtocolName = new AttributeTag(0x0018,0x1030);
	static public final AttributeTag PulseSequenceName = new AttributeTag(0x0018,0x9005);
	/* @deprecated */ @Deprecated static public final AttributeTag PulseRepetitionFrequency = new AttributeTag(0x0018,0x6032);
	static public final AttributeTag PurposeOfReferenceCodeSequence = new AttributeTag(0x0040,0xA170);
	static public final AttributeTag QualityControlImage = new AttributeTag(0x0028,0x0300);
	static public final AttributeTag QualityControlSubject = new AttributeTag(0x0010,0x0200);
	static public final AttributeTag QuantityDefinitionSequence = new AttributeTag(0x0040,0x9220);
	static public final AttributeTag QueryRetrieveLevel = new AttributeTag(0x0008,0x0052);
	static public final AttributeTag QueryRetrieveView = new AttributeTag(0x0008,0x0053);
	static public final AttributeTag ROIArea = new AttributeTag(0x6000,0x1301);
	static public final AttributeTag ROIMean = new AttributeTag(0x6000,0x1302);
	static public final AttributeTag ROIStandardDeviation = new AttributeTag(0x6000,0x1303);
	static public final AttributeTag RTPlanDate = new AttributeTag(0x300A,0x0006);
	static public final AttributeTag RTPlanLabel = new AttributeTag(0x300A,0x0002);
	static public final AttributeTag RTPlanName = new AttributeTag(0x300A,0x0003);
	static public final AttributeTag RTPlanTime = new AttributeTag(0x300A,0x0007);
	/* @deprecated */ @Deprecated static public final AttributeTag RWaveTimeVector = new AttributeTag(0x0018,0x6060);
	static public final AttributeTag RadionuclideHalfLife = new AttributeTag(0x0018,0x1075);
	static public final AttributeTag RadionuclideTotalDose = new AttributeTag(0x0018,0x1074);
	static public final AttributeTag RadiopharmaceuticalInformationSequence = new AttributeTag(0x0054,0x0016);
	static public final AttributeTag RadiopharmaceuticalStartDateTime = new AttributeTag(0x0018,0x1078);
	static public final AttributeTag RadiopharmaceuticalStartTime = new AttributeTag(0x0018,0x1072);
	static public final AttributeTag RadiusOfCircularShutter = new AttributeTag(0x0018,0x1612);
	static public final AttributeTag RationalDenominatorValue = new AttributeTag(0x0040,0xA163);
	static public final AttributeTag RationalNumeratorValue = new AttributeTag(0x0040,0xA162);
	static public final AttributeTag RealWorldValueFirstValueMapped = new AttributeTag(0x0040,0x9216);
	static public final AttributeTag RealWorldValueIntercept = new AttributeTag(0x0040,0x9224);
	static public final AttributeTag RealWorldValueLUTData = new AttributeTag(0x0040,0x9212);
	static public final AttributeTag RealWorldValueLastValueMapped = new AttributeTag(0x0040,0x9211);
	static public final AttributeTag RealWorldValueMappingSequence = new AttributeTag(0x0040,0x9096);
	static public final AttributeTag RealWorldValueSlope = new AttributeTag(0x0040,0x9225);
	static public final AttributeTag ReasonForPerformedProcedureCodeSequence = new AttributeTag(0x0040,0x1012);
	static public final AttributeTag ReasonForRequestedProcedureCodeSequence = new AttributeTag(0x0040,0x100A);
	static public final AttributeTag ReasonForStudy = new AttributeTag(0x0032,0x1030);
	static public final AttributeTag ReasonForTheAttributeModification = new AttributeTag(0x0400,0x0565);
	static public final AttributeTag ReasonForTheImagingServiceRequest = new AttributeTag(0x0040,0x2001);
	static public final AttributeTag ReasonForTheRequestedProcedure = new AttributeTag(0x0040,0x1002);
	static public final AttributeTag RecognizableVisualFeatures = new AttributeTag(0x0028,0x0302);
	static public final AttributeTag RecommendedDisplayCIELabValue = new AttributeTag(0x0062,0x000D);
	static public final AttributeTag RecommendedDisplayGrayscaleValue = new AttributeTag(0x0062,0x000C);
	static public final AttributeTag ReconstructionDiameter = new AttributeTag(0x0018,0x1100);
	static public final AttributeTag RecordInUseFlag = new AttributeTag(0x0004,0x1410);
	static public final AttributeTag RedPaletteColorLookupTableData = new AttributeTag(0x0028,0x1201);
	static public final AttributeTag RedPaletteColorLookupTableDescriptor = new AttributeTag(0x0028,0x1101);
	/* @deprecated */ @Deprecated static public final AttributeTag ReferencePixelPhysicalValueX = new AttributeTag(0x0018,0x6028);
	/* @deprecated */ @Deprecated static public final AttributeTag ReferencePixelPhysicalValueY = new AttributeTag(0x0018,0x602A);
	/* @deprecated */ @Deprecated static public final AttributeTag ReferencePixelX0 = new AttributeTag(0x0018,0x6020);
	/* @deprecated */ @Deprecated static public final AttributeTag ReferencePixelY0 = new AttributeTag(0x0018,0x6022);
	static public final AttributeTag ReferencedContentItemIdentifier = new AttributeTag(0x0040,0xDB73);
	static public final AttributeTag ReferencedDateTime = new AttributeTag(0x0040,0xA13A);
	static public final AttributeTag ReferencedDefinedProtocolSequence = new AttributeTag(0x0018,0x990c);
	/* @deprecated */ @Deprecated static public final AttributeTag ReferencedDigitalSignatureSequence = new AttributeTag(0x0400,0x0402);
	static public final AttributeTag ReferencedFileID = new AttributeTag(0x0004,0x1500);
	static public final AttributeTag ReferencedFrameNumber = new AttributeTag(0x0008,0x1160);
	static public final AttributeTag ReferencedFrameOfReferenceUID = new AttributeTag(0x3006,0x0024);
	/* @deprecated */ @Deprecated static public final AttributeTag ReferencedGeneralPurposeScheduledProcedureStepTransactionUID = new AttributeTag(0x0040,0x4023);
	static public final AttributeTag ReferencedImageEvidenceSequence = new AttributeTag(0x0008,0x9092);
	static public final AttributeTag ReferencedImageSequence = new AttributeTag(0x0008,0x1140);
	static public final AttributeTag ReferencedInstanceSequence = new AttributeTag(0x0008,0x114A);
	/* @deprecated */ @Deprecated static public final AttributeTag ReferencedPatientAliasSequence = new AttributeTag(0x0038,0x0004);
	static public final AttributeTag ReferencedPatientPhotoSequence = new AttributeTag(0x0010,0x1100);
	static public final AttributeTag ReferencedPatientSequence = new AttributeTag(0x0008,0x1120);
	static public final AttributeTag ReferencedPerformedProcedureStepSequence = new AttributeTag(0x0008,0x1111);
	static public final AttributeTag ReferencedPerformedProtocolSequence = new AttributeTag(0x0018,0x990d);
	static public final AttributeTag ReferencedRealWorldValueMappingInstanceSequence = new AttributeTag(0x0008,0x114B);
	static public final AttributeTag ReferencedRelatedGeneralSOPClassUIDInFile = new AttributeTag(0x0004,0x151A);
	static public final AttributeTag ReferencedRequestSequence = new AttributeTag(0x0040,0xA370);
	static public final AttributeTag ReferencedSOPClassUID = new AttributeTag(0x0008,0x1150);
	static public final AttributeTag ReferencedSOPClassUIDInFile = new AttributeTag(0x0004,0x1510);
	/* @deprecated */ @Deprecated static public final AttributeTag ReferencedSOPInstanceMACSequence = new AttributeTag(0x0400,0x0403);
	static public final AttributeTag ReferencedSOPInstanceUID = new AttributeTag(0x0008,0x1155);
	static public final AttributeTag ReferencedSOPInstanceUIDInFile = new AttributeTag(0x0004,0x1511);
	static public final AttributeTag ReferencedSOPSequence = new AttributeTag(0x0008,0x1199);
	static public final AttributeTag ReferencedSamplePositions = new AttributeTag(0x0040,0xA132);
	static public final AttributeTag ReferencedSegmentNumber = new AttributeTag(0x0062,0x000B);
	static public final AttributeTag ReferencedSeriesSequence = new AttributeTag(0x0008,0x1115);
	static public final AttributeTag ReferencedStudySequence = new AttributeTag(0x0008,0x1110);
	static public final AttributeTag ReferencedTimeOffsets = new AttributeTag(0x0040,0xA138);
	static public final AttributeTag ReferencedTransferSyntaxUIDInFile = new AttributeTag(0x0004,0x1512);
	static public final AttributeTag ReferencedWaveformChannels = new AttributeTag(0x0040,0xA0B0);
	/* @deprecated */ @Deprecated static public final AttributeTag ReferringPhysicianAddress = new AttributeTag(0x0008,0x0092);
	static public final AttributeTag ReferringPhysicianIdentificationSequence = new AttributeTag(0x0008,0x0096);
	static public final AttributeTag ReferringPhysicianName = new AttributeTag(0x0008,0x0090);
	/* @deprecated */ @Deprecated static public final AttributeTag ReferringPhysicianTelephoneNumbers = new AttributeTag(0x0008,0x0094);
	static public final AttributeTag ReflectedAmbientLight = new AttributeTag(0x2010,0x0160);
	/* @deprecated */ @Deprecated static public final AttributeTag RegionDataType = new AttributeTag(0x0018,0x6014);
	/* @deprecated */ @Deprecated static public final AttributeTag RegionFlags = new AttributeTag(0x0018,0x6016);
	/* @deprecated */ @Deprecated static public final AttributeTag RegionLocationMaxX1 = new AttributeTag(0x0018,0x601C);
	/* @deprecated */ @Deprecated static public final AttributeTag RegionLocationMaxY1 = new AttributeTag(0x0018,0x601E);
	/* @deprecated */ @Deprecated static public final AttributeTag RegionLocationMinX0 = new AttributeTag(0x0018,0x6018);
	/* @deprecated */ @Deprecated static public final AttributeTag RegionLocationMinY0 = new AttributeTag(0x0018,0x601A);
	/* @deprecated */ @Deprecated static public final AttributeTag RegionOfResidence = new AttributeTag(0x0010,0x2152);
	/* @deprecated */ @Deprecated static public final AttributeTag RegionSpatialFormat = new AttributeTag(0x0018,0x6012);
	/* @deprecated */ @Deprecated static public final AttributeTag RelatedFrameOfReferenceUID = new AttributeTag(0x3006,0x00C2);
	static public final AttributeTag RelatedGeneralSOPClassUID = new AttributeTag(0x0008,0x001A);
	static public final AttributeTag RelatedSeriesSequence = new AttributeTag(0x0008,0x1250);
	static public final AttributeTag RelationshipType = new AttributeTag(0x0040,0xA010);
	static public final AttributeTag RelevantInformationSequence = new AttributeTag(0x0040,0x4022);
	static public final AttributeTag RepetitionTime = new AttributeTag(0x0018,0x0080);
	static public final AttributeTag RequestAttributesSequence = new AttributeTag(0x0040,0x0275);
	static public final AttributeTag RequestedProcedureCodeSequence = new AttributeTag(0x0032,0x1064);
	/* @deprecated */ @Deprecated static public final AttributeTag RequestedProcedureComments = new AttributeTag(0x0040,0x1400);
	static public final AttributeTag RequestedProcedureDescription = new AttributeTag(0x0032,0x1060);
	static public final AttributeTag RequestedProcedureID = new AttributeTag(0x0040,0x1001);
	/* @deprecated */ @Deprecated static public final AttributeTag RequestedProcedureLocation = new AttributeTag(0x0040,0x1005);
	static public final AttributeTag RequestedSOPClassUID = new AttributeTag(0x0000,0x0003);
	static public final AttributeTag RequestedSOPInstanceUID = new AttributeTag(0x0000,0x1001);
	/* @deprecated */ @Deprecated static public final AttributeTag RequestingPhysician = new AttributeTag(0x0032,0x1032);
	/* @deprecated */ @Deprecated static public final AttributeTag RequestingPhysicianIdentificationSequence = new AttributeTag(0x0032,0x1031);
	/* @deprecated */ @Deprecated static public final AttributeTag RequestingService = new AttributeTag(0x0032,0x1033);
	static public final AttributeTag RequestingServiceCodeSequence = new AttributeTag(0x0032,0x1034);
	static public final AttributeTag RescaleIntercept = new AttributeTag(0x0028,0x1052);
	static public final AttributeTag RescaleSlope = new AttributeTag(0x0028,0x1053);
	static public final AttributeTag RescaleType = new AttributeTag(0x0028,0x1054);
	static public final AttributeTag ResonantNucleus = new AttributeTag(0x0018,0x9100);
	static public final AttributeTag ResponsibleOrganization = new AttributeTag(0x0010,0x2299);
	static public final AttributeTag ResponsiblePerson = new AttributeTag(0x0010,0x2297);
	static public final AttributeTag ResponsiblePersonRole = new AttributeTag(0x0010,0x2298);
	/* @deprecated */ @Deprecated static public final AttributeTag ResultsComments = new AttributeTag(0x4008,0x4000);
	/* @deprecated */ @Deprecated static public final AttributeTag ResultsDistributionListSequence = new AttributeTag(0x4008,0x0118);
	/* @deprecated */ @Deprecated static public final AttributeTag ResultsID = new AttributeTag(0x4008,0x0040);
	/* @deprecated */ @Deprecated static public final AttributeTag ResultsIDIssuer = new AttributeTag(0x4008,0x0042);
	static public final AttributeTag RetrieveAETitle = new AttributeTag(0x0008,0x0054);
	/* @deprecated */ @Deprecated static public final AttributeTag ReviewerName = new AttributeTag(0x300E,0x0008);
	static public final AttributeTag RotationOfScannedFilm = new AttributeTag(0x0018,0x2030);
	static public final AttributeTag RowPositionInTotalImagePixelMatrix = new AttributeTag(0x0048,0x021F);
	static public final AttributeTag Rows = new AttributeTag(0x0028,0x0010);
	static public final AttributeTag SOPAuthorizationComment = new AttributeTag(0x0100,0x0424);
	static public final AttributeTag SOPAuthorizationDateTime = new AttributeTag(0x0100,0x0420);
	static public final AttributeTag SOPClassUID = new AttributeTag(0x0008,0x0016);
	static public final AttributeTag SOPClassesInStudy = new AttributeTag(0x0008,0x0062);
	static public final AttributeTag SOPClassesSupported = new AttributeTag(0x0008,0x115A);
	static public final AttributeTag SOPInstanceStatus = new AttributeTag(0x0100,0x0410);
	static public final AttributeTag SOPInstanceUID = new AttributeTag(0x0008,0x0018);
	static public final AttributeTag SOPInstanceUIDOfConcatenationSource = new AttributeTag(0x0020,0x0242);
	static public final AttributeTag SamplesPerPixel = new AttributeTag(0x0028,0x0002);
	static public final AttributeTag SamplingFrequency = new AttributeTag(0x003A,0x001A);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledHumanPerformersSequence = new AttributeTag(0x0040,0x4034);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledPatientInstitutionResidence = new AttributeTag(0x0038,0x001E);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledPerformingPhysicianIdentificationSequence = new AttributeTag(0x0040,0x000B);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledPerformingPhysicianName = new AttributeTag(0x0040,0x0006);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledProcedureStepDescription = new AttributeTag(0x0040,0x0007);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledProcedureStepEndDate = new AttributeTag(0x0040,0x0004);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledProcedureStepEndTime = new AttributeTag(0x0040,0x0005);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledProcedureStepLocation = new AttributeTag(0x0040,0x0011);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledProcedureStepStartDate = new AttributeTag(0x0040,0x0002);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledProcedureStepStartTime = new AttributeTag(0x0040,0x0003);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledStationAETitle = new AttributeTag(0x0040,0x0001);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledStationGeographicLocationCodeSequence = new AttributeTag(0x0040,0x4027);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledStationName = new AttributeTag(0x0040,0x0010);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledStationNameCodeSequence = new AttributeTag(0x0040,0x4025);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledStudyLocation = new AttributeTag(0x0032,0x1020);
	/* @deprecated */ @Deprecated static public final AttributeTag ScheduledStudyLocationAETitle = new AttributeTag(0x0032,0x1021);
	static public final AttributeTag SecondaryCaptureDeviceID = new AttributeTag(0x0018,0x1010);
	static public final AttributeTag SecondaryCaptureDeviceManufacturer = new AttributeTag(0x0018,0x1016);
	static public final AttributeTag SecondaryCaptureDeviceManufacturerModelName = new AttributeTag(0x0018,0x1018);
	static public final AttributeTag SecondaryCaptureDeviceSoftwareVersions = new AttributeTag(0x0018,0x1019);
	static public final AttributeTag SegmentAlgorithmType = new AttributeTag(0x0062,0x0008);
	static public final AttributeTag SegmentIdentificationSequence = new AttributeTag(0x0062,0x000A);
	static public final AttributeTag SegmentLabel = new AttributeTag(0x0062,0x0005);
	static public final AttributeTag SegmentNumber = new AttributeTag(0x0062,0x0004);
	static public final AttributeTag SegmentSequence = new AttributeTag(0x0062,0x0002);
	static public final AttributeTag SegmentationFractionalType = new AttributeTag(0x0062,0x0010);
	static public final AttributeTag SegmentationType = new AttributeTag(0x0062,0x0001);
	static public final AttributeTag SegmentedPropertyCategoryCodeSequence = new AttributeTag(0x0062,0x0003);
	static public final AttributeTag SegmentedPropertyTypeCodeSequence = new AttributeTag(0x0062,0x000F);
	static public final AttributeTag SegmentedPropertyTypeModifierCodeSequence = new AttributeTag(0x0062,0x0011);
	static public final AttributeTag SequenceDelimitationItem = new AttributeTag(0xFFFE,0xE0DD);
	/* @deprecated */ @Deprecated static public final AttributeTag SequenceOfUltrasoundRegions = new AttributeTag(0x0018,0x6011);
	static public final AttributeTag SeriesDate = new AttributeTag(0x0008,0x0021);
	static public final AttributeTag SeriesDescription = new AttributeTag(0x0008,0x103E);
	static public final AttributeTag SeriesDescriptionCodeSequence = new AttributeTag(0x0008,0x103F);
	static public final AttributeTag SeriesInstanceUID = new AttributeTag(0x0020,0x000E);
	static public final AttributeTag SeriesNumber = new AttributeTag(0x0020,0x0011);
	static public final AttributeTag SeriesTime = new AttributeTag(0x0008,0x0031);
	static public final AttributeTag ServiceEpisodeDescription = new AttributeTag(0x0038,0x0062);
	static public final AttributeTag ServiceEpisodeID = new AttributeTag(0x0038,0x0060);
	static public final AttributeTag SharedFunctionalGroupsSequence = new AttributeTag(0x5200,0x9229);
	static public final AttributeTag ShutterLeftVerticalEdge = new AttributeTag(0x0018,0x1602);
	static public final AttributeTag ShutterLowerHorizontalEdge = new AttributeTag(0x0018,0x1608);
	static public final AttributeTag ShutterRightVerticalEdge = new AttributeTag(0x0018,0x1604);
	static public final AttributeTag ShutterShape = new AttributeTag(0x0018,0x1600);
	static public final AttributeTag ShutterUpperHorizontalEdge = new AttributeTag(0x0018,0x1606);
	static public final AttributeTag SlabOrientation = new AttributeTag(0x0018,0x9105);
	static public final AttributeTag SlabThickness = new AttributeTag(0x0018,0x9104);
	static public final AttributeTag SliceLocation = new AttributeTag(0x0020,0x1041);
	static public final AttributeTag SliceThickness = new AttributeTag(0x0018,0x0050);
	static public final AttributeTag SmallestImagePixelValue = new AttributeTag(0x0028,0x0106);
	static public final AttributeTag SmokingStatus = new AttributeTag(0x0010,0x21A0);
	static public final AttributeTag SoftwareVersions = new AttributeTag(0x0018,0x1020);
	static public final AttributeTag SourceApplicationEntityTitle = new AttributeTag(0x0002,0x0016);
	static public final AttributeTag SourceImageSequence = new AttributeTag(0x0008,0x2112);
	static public final AttributeTag SourceOfPreviousValues = new AttributeTag(0x0400,0x0564);
	static public final AttributeTag SourcePatientGroupIdentificationSequence = new AttributeTag(0x0010,0x0026);
	static public final AttributeTag SpacingBetweenSlices = new AttributeTag(0x0018,0x0088);
	static public final AttributeTag SpatialLocationsPreserved = new AttributeTag(0x0028,0x135A);
	static public final AttributeTag SpatialResolution = new AttributeTag(0x0018,0x1050);
	static public final AttributeTag SpecificCharacterSet = new AttributeTag(0x0008,0x0005);
	static public final AttributeTag SpecimenDescriptionSequence = new AttributeTag(0x0040,0x0560);
	static public final AttributeTag SpecimenDetailedDescription = new AttributeTag(0x0040,0x00602);
	static public final AttributeTag SpecimenIdentifier = new AttributeTag(0x0040,0x0551);
	static public final AttributeTag SpecimenShortDescription = new AttributeTag(0x0040,0x0600);
	static public final AttributeTag SpectroscopyData = new AttributeTag(0x5600,0x0020);
	/* @deprecated */ @Deprecated static public final AttributeTag SpecialNeeds = new AttributeTag(0x0038,0x0050);
	static public final AttributeTag StackID = new AttributeTag(0x0020,0x9056);
	static public final AttributeTag StationName = new AttributeTag(0x0008,0x1010);
	static public final AttributeTag Status = new AttributeTag(0x0000,0x0900);
	/* @deprecated */ @Deprecated static public final AttributeTag StorageMediaFileSetID = new AttributeTag(0x0088,0x0130);
	/* @deprecated */ @Deprecated static public final AttributeTag StorageMediaFileSetUID = new AttributeTag(0x0088,0x0140);
	static public final AttributeTag StrainAdditionalInformation = new AttributeTag(0x0010,0x0218);
	static public final AttributeTag StrainCodeSequence = new AttributeTag(0x0010,0x0219);
	static public final AttributeTag StrainDescription = new AttributeTag(0x0010,0x0212);
	static public final AttributeTag StrainNomenclature = new AttributeTag(0x0010,0x0213);
	static public final AttributeTag StrainStockSequence = new AttributeTag(0x0010,0x0216);
	static public final AttributeTag StructureSetDate = new AttributeTag(0x3006,0x0008);
	static public final AttributeTag StructureSetLabel = new AttributeTag(0x3006,0x0002);
	static public final AttributeTag StructureSetTime = new AttributeTag(0x3006,0x0009);
	/* @deprecated */ @Deprecated static public final AttributeTag StudyComments = new AttributeTag(0x0032,0x4000);
	static public final AttributeTag StudyDate = new AttributeTag(0x0008,0x0020);
	static public final AttributeTag StudyDescription = new AttributeTag(0x0008,0x1030);
	static public final AttributeTag StudyID = new AttributeTag(0x0020,0x0010);
	static public final AttributeTag StudyIDIssuer = new AttributeTag(0x0032,0x0012);
	static public final AttributeTag StudyInstanceUID = new AttributeTag(0x0020,0x000D);
	static public final AttributeTag StudyTime = new AttributeTag(0x0008,0x0030);
	static public final AttributeTag SynchronizationFrameOfReferenceUID = new AttributeTag(0x0020,0x0200);
	static public final AttributeTag SynchronizationTrigger = new AttributeTag(0x0018,0x106A);
	static public final AttributeTag TableHeight = new AttributeTag(0x0018,0x1130);
	static public final AttributeTag TableOfYBreakPoints = new AttributeTag(0x0018,0x6054);
	static public final AttributeTag TablePosition = new AttributeTag(0x0018,0x9327);
	/* @deprecated */ @Deprecated static public final AttributeTag TemplateExtensionCreatorUID = new AttributeTag(0x0040,0xDB0D);
	/* @deprecated */ @Deprecated static public final AttributeTag TemplateExtensionOrganizationUID = new AttributeTag(0x0040,0xDB0C);
	static public final AttributeTag TemplateIdentifier = new AttributeTag(0x0040,0xDB00);
	static public final AttributeTag TemporalPositionIndex = new AttributeTag(0x0020,0x9128);
	static public final AttributeTag TemporalRangeType = new AttributeTag(0x0040,0xA130);
	/* @deprecated */ @Deprecated static public final AttributeTag TextComments = new AttributeTag(0x4000,0x4000);
	/* @deprecated */ @Deprecated static public final AttributeTag TextString = new AttributeTag(0x2030,0x0020);
	static public final AttributeTag TextValue = new AttributeTag(0x0040,0xA160);
	static public final AttributeTag Time = new AttributeTag(0x0040,0xA122);
	static public final AttributeTag TimeOfLastCalibration = new AttributeTag(0x0018,0x1201);
	static public final AttributeTag TimeOfSecondaryCapture = new AttributeTag(0x0018,0x1014);
	static public final AttributeTag TimezoneOffsetFromUTC = new AttributeTag(0x0008,0x0201);
	static public final AttributeTag TomoAngle = new AttributeTag(0x0018,0x1470);
	/* @deprecated */ @Deprecated static public final AttributeTag TopicAuthor = new AttributeTag(0x0088,0x0910);
	/* @deprecated */ @Deprecated static public final AttributeTag TopicKeywords = new AttributeTag(0x0088,0x0912);
	/* @deprecated */ @Deprecated static public final AttributeTag TopicSubject = new AttributeTag(0x0088,0x0906);
	/* @deprecated */ @Deprecated static public final AttributeTag TopicTitle = new AttributeTag(0x0088,0x0904);
	static public final AttributeTag TotalPixelMatrixColumns = new AttributeTag(0x0048,0x0006);
	static public final AttributeTag TotalPixelMatrixOriginSequence = new AttributeTag(0x0048,0x0008);
	static public final AttributeTag TotalPixelMatrixRows = new AttributeTag(0x0048,0x0007);
	static public final AttributeTag TrackingID = new AttributeTag(0x0062,0x0020);
	static public final AttributeTag TrackingUID = new AttributeTag(0x0062,0x0021);
	/* @deprecated */ @Deprecated static public final AttributeTag TransducerData = new AttributeTag(0x0018,0x5010);
	/* @deprecated */ @Deprecated static public final AttributeTag TransducerFrequency = new AttributeTag(0x0018,0x6030);
	/* @deprecated */ @Deprecated static public final AttributeTag TransducerType = new AttributeTag(0x0018,0x6031);
	static public final AttributeTag TransferSyntaxUID = new AttributeTag(0x0002,0x0010);
	static public final AttributeTag TreatmentDate = new AttributeTag(0x3008,0x0250);
	static public final AttributeTag TreatmentTime = new AttributeTag(0x3008,0x0251);
	static public final AttributeTag TriggerTime = new AttributeTag(0x0018,0x1060);
	static public final AttributeTag TypeOfPatientID = new AttributeTag(0x0010,0x0022);
	static public final AttributeTag UDISequence = new AttributeTag(0x0018,0x100a);
	static public final AttributeTag UID = new AttributeTag(0x0040,0xA124);
	/* @deprecated */ @Deprecated static public final AttributeTag UltrasoundColorDataPresent = new AttributeTag(0x0028,0x0014);
	static public final AttributeTag UnassignedPerFrameConvertedAttributesSequence = new AttributeTag(0x0020,0x9171);
	static public final AttributeTag UnassignedSharedConvertedAttributesSequence = new AttributeTag(0x0020,0x9170);
	static public final AttributeTag Units = new AttributeTag(0x0054,0x1001);
	static public final AttributeTag VOILUTFunction = new AttributeTag(0x0028,0x1056);
	static public final AttributeTag VOILUTSequence = new AttributeTag(0x0028,0x3010);
	static public final AttributeTag ValueType = new AttributeTag(0x0040,0xA040);
	static public final AttributeTag VerificationDateTime = new AttributeTag(0x0040,0xA030);
	static public final AttributeTag VerificationFlag = new AttributeTag(0x0040,0xA493);
	/* @deprecated */ @Deprecated static public final AttributeTag VerifyingObserverIdentificationCodeSequence = new AttributeTag(0x0040,0xA088);
	/* @deprecated */ @Deprecated static public final AttributeTag VerifyingObserverName = new AttributeTag(0x0040,0xA075);
	/* @deprecated */ @Deprecated static public final AttributeTag VerifyingObserverSequence = new AttributeTag(0x0040,0xA073);
	/* @deprecated */ @Deprecated static public final AttributeTag VerifyingOrganization = new AttributeTag(0x0040,0xA027);
	static public final AttributeTag VerticesOfThePolygonalShutter = new AttributeTag(0x0018,0x1620);
	static public final AttributeTag VideoImageFormatAcquired = new AttributeTag(0x0018,0x1022);
	static public final AttributeTag ViewCodeSequence = new AttributeTag(0x0054,0x0220);
	static public final AttributeTag ViewModifierCodeSequence = new AttributeTag(0x0054,0x0222);
	static public final AttributeTag ViewPosition = new AttributeTag(0x0018,0x5101);
	/* @deprecated */ @Deprecated static public final AttributeTag VisitComments = new AttributeTag(0x0038,0x4000);
	static public final AttributeTag VolumeBasedCalculationTechnique = new AttributeTag(0x0008,0x9207);
	static public final AttributeTag VolumeLocalizationSequence = new AttributeTag(0x0018,0x9126);
	static public final AttributeTag VolumetricProperties = new AttributeTag(0x0008,0x9206);
	static public final AttributeTag WaveformBitsAllocated = new AttributeTag(0x5400,0x1004);
	static public final AttributeTag WaveformBitsStored = new AttributeTag(0x003A,0x021A);
	static public final AttributeTag WaveformChannelNumber = new AttributeTag(0x003A,0x0202);
	static public final AttributeTag WaveformData = new AttributeTag(0x5400,0x1010);
	static public final AttributeTag WaveformSequence = new AttributeTag(0x5400,0x0100);
	static public final AttributeTag WholeSlideMicroscopyImageFrameTypeSequence = new AttributeTag(0x0040,0x0710);
	static public final AttributeTag WindowCenter = new AttributeTag(0x0028,0x1050);
	static public final AttributeTag WindowCenterWidthExplanation = new AttributeTag(0x0028,0x1055);
	static public final AttributeTag WindowWidth = new AttributeTag(0x0028,0x1051);
	static public final AttributeTag XOffsetInSlideCoordinateSystem = new AttributeTag(0x0040,0x072A);
	static public final AttributeTag XRay3DAcquisitionSequence = new AttributeTag(0x0018,0x9507);
	static public final AttributeTag XRay3DFrameTypeSequence = new AttributeTag(0x0018,0x9504);
	static public final AttributeTag YOffsetInSlideCoordinateSystem = new AttributeTag(0x0040,0x073A);
	static public final AttributeTag ZOffsetInSlideCoordinateSystem = new AttributeTag(0x0040,0x074A);
}
