# Scan-Configs

This directory contains scan configurations, similar to the ones provided by GVMD.

In the examples we asumme that a skeleton scan configuration is created prior to executing the commands.

As an example create a skeleton.json file with the following entry:
```json
{
  "target": {
    "hosts": [
      "127.0.0.1"
    ],
    "ports": [
    ]
  },
  "vts": [
  ]
}
```

This is used by the examples to generate a scan targeting the localhost.

To transform a scan configuration to a scan JSON file, use the following command:


```bash
cat skeleton.json | scannerctl scan-config -i -p PATH_TO_FEED -l PATH_TO_THE_PORTLIST PATH_OF_THE_CONFIGURATION > output.json
```

It is also possible to combine multiple configurations by including multiple configuration files in the command.

```bash
cat skeleton.json | scannerctl scan-config \
    -l openvas-default-portlist.xml \
    -p /var/lib/openvas/plugins \
    discovery.xml adapted-full-and-fast.xml > dff.json
```



## Adapted Full and Fast

```bash
cat skeleton.json | scannerctl scan-config \
    -l openvas-default-portlist.xml \
    -p /var/lib/openvas/plugins \
    adapted-full-and-fast.xml > ff.json
```

To configuration "adapted-full-and-fast.xml" is an adapted version of the "Full and fast" scan configuration provided by GVMD.

It contains the families:

- `Port scanners`
- `AIX Local Security Checks`
- `Amazon Linux Local Security Checks`
- `Brute force attacks`
- `Buffer overflow`
- `CISCO`
- `CentOS Local Security Checks`
- `Citrix Xenserver Local Security Checks`
- `Compliance`
- `Credentials`
- `Databases`
- `Debian Local Security Checks`
- `Default Accounts`
- `Denial of Service`
- `F5 Local Security Checks`
- `FTP`
- `Fedora Local Security Checks`
- `Finger abuses`
- `Firewalls`
- `FortiOS Local Security Checks`
- `FreeBSD Local Security Checks`
- `Gain a shell remotely`
- `General`
- `Gentoo Local Security Checks`
- `Huawei`
- `Huawei EulerOS Local Security Checks`
- `HP-UX Local Security Checks`
- `IT-Grundschutz`
- `IT-Grundschutz-10`
- `IT-Grundschutz-11`
- `IT-Grundschutz-12`
- `IT-Grundschutz-13`
- `IT-Grundschutz-15`
- `JunOS Local Security Checks`
- `Mac OS X Local Security Checks`
- `Mageia Linux Local Security Checks`
- `Malware`
- `Mandrake Local Security Checks`
- `Netware`
- `Nmap NSE`
- `Nmap NSE net`
- `Oracle Linux Local Security Checks`
- `PCI-DSS`
- `PCI-DSS 2.0`
- `Palo Alto PAN-OS Local Security Checks`
- `Peer-To-Peer File Sharing`
- `Policy`
- `Privilege escalation`
- `Product detection`
- `RPC`
- `Red Hat Local Security Checks`
- `Remote file access`
- `SMTP problems`
- `SNMP`
- `SSL and TLS`
- `Service detection`
- `Settings`
- `Slackware Local Security Checks`
- `Solaris Local Security Checks`
- `SuSE Local Security Checks`
- `Ubuntu Local Security Checks`
- `Useless services`
- `VMware Local Security Checks`
- `Web Servers`
- `Web application abuses`
- `Windows`
- `Windows : Microsoft Bulletins`

As well as the OIDs:

- `1.3.6.1.4.1.25623.1.0.810003`
- `1.3.6.1.4.1.25623.1.0.810002`

## Discovery 

```bash
cat skeleton.json | scannerctl scan-config \
    -l openvas-default-portlist.xml \
    -p /var/lib/openvas/plugins \
    discovery.xml > discovery.json
```

To configuration "discovery.xml" is an adapted version of the "Discovery" scan configuration provided by GVMD.

It contains the families:
- `Product detection`

As well as the OIDs:

- `1.3.6.1.4.1.25623.1.0.803575`
- `1.3.6.1.4.1.25623.1.0.803574`
- `1.3.6.1.4.1.25623.1.0.803537`
- `1.3.6.1.4.1.25623.1.0.801805`
- `1.3.6.1.4.1.25623.1.0.803570`
- `1.3.6.1.4.1.25623.1.0.801803`
- `1.3.6.1.4.1.25623.1.0.803533`
- `1.3.6.1.4.1.25623.1.0.801801`
- `1.3.6.1.4.1.25623.1.0.801800`
- `1.3.6.1.4.1.25623.1.0.801685`
- `1.3.6.1.4.1.25623.1.0.801649`
- `1.3.6.1.4.1.25623.1.0.801299`
- `1.3.6.1.4.1.25623.1.0.801298`
- `1.3.6.1.4.1.25623.1.0.803528`
- `1.3.6.1.4.1.25623.1.0.801291`
- `1.3.6.1.4.1.25623.1.0.801604`
- `1.3.6.1.4.1.25623.1.0.801253`
- `1.3.6.1.4.1.25623.1.0.803569`
- `1.3.6.1.4.1.25623.1.0.803568`
- `1.3.6.1.4.1.25623.1.0.803567`
- `1.3.6.1.4.1.25623.1.0.803566`
- `1.3.6.1.4.1.25623.1.0.803529`
- `1.3.6.1.4.1.25623.1.0.803564`
- `1.3.6.1.4.1.25623.1.0.803563`
- `1.3.6.1.4.1.25623.1.0.803525`
- `1.3.6.1.4.1.25623.1.0.803524`
- `1.3.6.1.4.1.25623.1.0.803523`
- `1.3.6.1.4.1.25623.1.0.803520`
- `1.3.6.1.4.1.25623.1.0.801634`
- `1.3.6.1.4.1.25623.1.0.810010`
- `1.3.6.1.4.1.25623.1.0.801632`
- `1.3.6.1.4.1.25623.1.0.803551`
- `1.3.6.1.4.1.25623.1.0.11882`
- `1.3.6.1.4.1.25623.1.0.802726`
- `1.3.6.1.4.1.25623.1.0.102016`
- `1.3.6.1.4.1.25623.1.0.10400`
- `1.3.6.1.4.1.25623.1.0.103621`
- `1.3.6.1.4.1.25623.1.0.13751`
- `1.3.6.1.4.1.25623.1.0.19585`
- `1.3.6.1.4.1.25623.1.0.10946`
- `1.3.6.1.4.1.25623.1.0.11125`
- `1.3.6.1.4.1.25623.1.0.11427`
- `1.3.6.1.4.1.25623.1.0.11431`
- `1.3.6.1.4.1.25623.1.0.51662`
- `1.3.6.1.4.1.25623.1.0.103999`
- `1.3.6.1.4.1.25623.1.0.103996`
- `1.3.6.1.4.1.25623.1.0.50282`
- `1.3.6.1.4.1.25623.1.0.11040`
- `1.3.6.1.4.1.25623.1.0.103978`
- `1.3.6.1.4.1.25623.1.0.11033`
- `1.3.6.1.4.1.25623.1.0.90022`
- `1.3.6.1.4.1.25623.1.0.900239`
- `1.3.6.1.4.1.25623.1.0.103585`
- `1.3.6.1.4.1.25623.1.0.10919`
- `1.3.6.1.4.1.25623.1.0.10921`
- `1.3.6.1.4.1.25623.1.0.10758`
- `1.3.6.1.4.1.25623.1.0.10920`
- `1.3.6.1.4.1.25623.1.0.108477`
- `1.3.6.1.4.1.25623.1.0.10990`
- `1.3.6.1.4.1.25623.1.0.80064`
- `1.3.6.1.4.1.25623.1.0.80063`
- `1.3.6.1.4.1.25623.1.0.80062`
- `1.3.6.1.4.1.25623.1.0.14378`
- `1.3.6.1.4.1.25623.1.0.14377`
- `1.3.6.1.4.1.25623.1.0.100083`
- `1.3.6.1.4.1.25623.1.0.80059`
- `1.3.6.1.4.1.25623.1.0.11762`
- `1.3.6.1.4.1.25623.1.0.108204`
- `1.3.6.1.4.1.25623.1.0.108203`
- `1.3.6.1.4.1.25623.1.0.108199`
- `1.3.6.1.4.1.25623.1.0.108198`
- `1.3.6.1.4.1.25623.1.0.800984`
- `1.3.6.1.4.1.25623.1.0.80045`
- `1.3.6.1.4.1.25623.1.0.11913`
- `1.3.6.1.4.1.25623.1.0.11908`
- `1.3.6.1.4.1.25623.1.0.11907`
- `1.3.6.1.4.1.25623.1.0.11906`
- `1.3.6.1.4.1.25623.1.0.11822`
- `1.3.6.1.4.1.25623.1.0.20160`
- `1.3.6.1.4.1.25623.1.0.80100`
- `1.3.6.1.4.1.25623.1.0.901121`
- `1.3.6.1.4.1.25623.1.0.103190`
- `1.3.6.1.4.1.25623.1.0.20301`
- `1.3.6.1.4.1.25623.1.0.80005`
- `1.3.6.1.4.1.25623.1.0.80004`
- `1.3.6.1.4.1.25623.1.0.80003`
- `1.3.6.1.4.1.25623.1.0.103098`
- `1.3.6.1.4.1.25623.1.0.103326`
- `1.3.6.1.4.1.25623.1.0.103086`
- `1.3.6.1.4.1.25623.1.0.10761`
- `1.3.6.1.4.1.25623.1.0.15766`
- `1.3.6.1.4.1.25623.1.0.15765`
- `1.3.6.1.4.1.25623.1.0.17244`
- `1.3.6.1.4.1.25623.1.0.802244`
- `1.3.6.1.4.1.25623.1.0.103156`
- `1.3.6.1.4.1.25623.1.0.103070`
- `1.3.6.1.4.1.25623.1.0.100950`
- `1.3.6.1.4.1.25623.1.0.100074`
- `1.3.6.1.4.1.25623.1.0.100069`
- `1.3.6.1.4.1.25623.1.0.100062`
- `1.3.6.1.4.1.25623.1.0.10006`
- `1.3.6.1.4.1.25623.1.0.100034`
- `1.3.6.1.4.1.25623.1.0.14259`
- `1.3.6.1.4.1.25623.1.0.100315`
- `1.3.6.1.4.1.25623.1.0.104098`
- `1.3.6.1.4.1.25623.1.0.104021`
- `1.3.6.1.4.1.25623.1.0.104143`
- `1.3.6.1.4.1.25623.1.0.104124`
- `1.3.6.1.4.1.25623.1.0.104125`
- `1.3.6.1.4.1.25623.1.0.104001`
- `1.3.6.1.4.1.25623.1.0.104109`
- `1.3.6.1.4.1.25623.1.0.104104`
- `1.3.6.1.4.1.25623.1.0.104121`
- `1.3.6.1.4.1.25623.1.0.104120`
- `1.3.6.1.4.1.25623.1.0.104093`
- `1.3.6.1.4.1.25623.1.0.104076`
- `1.3.6.1.4.1.25623.1.0.104091`
- `1.3.6.1.4.1.25623.1.0.104075`
- `1.3.6.1.4.1.25623.1.0.104074`
- `1.3.6.1.4.1.25623.1.0.104057`
- `1.3.6.1.4.1.25623.1.0.104053`
- `1.3.6.1.4.1.25623.1.0.104018`
- `1.3.6.1.4.1.25623.1.0.104158`
- `1.3.6.1.4.1.25623.1.0.801698`
- `1.3.6.1.4.1.25623.1.0.803540`
- `1.3.6.1.4.1.25623.1.0.801696`
- `1.3.6.1.4.1.25623.1.0.801695`
- `1.3.6.1.4.1.25623.1.0.801693`
- `1.3.6.1.4.1.25623.1.0.801691`
- `1.3.6.1.4.1.25623.1.0.801619`
- `1.3.6.1.4.1.25623.1.0.801651`
- `1.3.6.1.4.1.25623.1.0.801650`
- `1.3.6.1.4.1.25623.1.0.801611`
- `1.3.6.1.4.1.25623.1.0.801261`
- `1.3.6.1.4.1.25623.1.0.801610`
- `1.3.6.1.4.1.25623.1.0.103147`
- `1.3.6.1.4.1.25623.1.0.103223`
- `1.3.6.1.4.1.25623.1.0.10666`
- `1.3.6.1.4.1.25623.1.0.15588`
- `1.3.6.1.4.1.25623.1.0.100795`
- `1.3.6.1.4.1.25623.1.0.103125`
- `1.3.6.1.4.1.25623.1.0.103124`
- `1.3.6.1.4.1.25623.1.0.103123`
- `1.3.6.1.4.1.25623.1.0.100780`
- `1.3.6.1.4.1.25623.1.0.9000001`
- `1.3.6.1.4.1.25623.1.0.14788`
- `1.3.6.1.4.1.25623.1.0.100770`
- `1.3.6.1.4.1.25623.1.0.103106`
- `1.3.6.1.4.1.25623.1.0.14773`
- `1.3.6.1.4.1.25623.1.0.10622`
- `1.3.6.1.4.1.25623.1.0.10462`
- `1.3.6.1.4.1.25623.1.0.100838`
- `1.3.6.1.4.1.25623.1.0.104157`
- `1.3.6.1.4.1.25623.1.0.104137`
- `1.3.6.1.4.1.25623.1.0.104135`
- `1.3.6.1.4.1.25623.1.0.104010`
- `1.3.6.1.4.1.25623.1.0.104088`
- `1.3.6.1.4.1.25623.1.0.104089`
- `1.3.6.1.4.1.25623.1.0.104130`
- `1.3.6.1.4.1.25623.1.0.104114`
- `1.3.6.1.4.1.25623.1.0.104069`
- `1.3.6.1.4.1.25623.1.0.104085`
- `1.3.6.1.4.1.25623.1.0.104111`
- `1.3.6.1.4.1.25623.1.0.104110`
- `1.3.6.1.4.1.25623.1.0.104068`
- `1.3.6.1.4.1.25623.1.0.104067`
- `1.3.6.1.4.1.25623.1.0.104066`
- `1.3.6.1.4.1.25623.1.0.104063`
- `1.3.6.1.4.1.25623.1.0.104048`
- `1.3.6.1.4.1.25623.1.0.104029`
- `1.3.6.1.4.1.25623.1.0.104167`
- `1.3.6.1.4.1.25623.1.0.104165`
- `1.3.6.1.4.1.25623.1.0.104026`
- `1.3.6.1.4.1.25623.1.0.104149`
- `1.3.6.1.4.1.25623.1.0.104163`
- `1.3.6.1.4.1.25623.1.0.104147`
- `1.3.6.1.4.1.25623.1.0.803519`
- `1.3.6.1.4.1.25623.1.0.801822`
- `1.3.6.1.4.1.25623.1.0.801821`
- `1.3.6.1.4.1.25623.1.0.803516`
- `1.3.6.1.4.1.25623.1.0.803550`
- `1.3.6.1.4.1.25623.1.0.803512`
- `1.3.6.1.4.1.25623.1.0.803510`
- `1.3.6.1.4.1.25623.1.0.801666`
- `1.3.6.1.4.1.25623.1.0.801237`
- `1.3.6.1.4.1.25623.1.0.801621`
- `1.3.6.1.4.1.25623.1.0.803544`
- `1.3.6.1.4.1.25623.1.0.803549`
- `1.3.6.1.4.1.25623.1.0.803547`
- `1.3.6.1.4.1.25623.1.0.803507`
- `1.3.6.1.4.1.25623.1.0.803508`
- `1.3.6.1.4.1.25623.1.0.803543`
- `1.3.6.1.4.1.25623.1.0.801811`
- `1.3.6.1.4.1.25623.1.0.100755`
- `1.3.6.1.4.1.25623.1.0.10379`
- `1.3.6.1.4.1.25623.1.0.11154`
- `1.3.6.1.4.1.25623.1.0.11153`
- `1.3.6.1.4.1.25623.1.0.14674`
- `1.3.6.1.4.1.25623.1.0.801234`
- `1.3.6.1.4.1.25623.1.0.100669`
- `1.3.6.1.4.1.25623.1.0.14664`
- `1.3.6.1.4.1.25623.1.0.100819`
- `1.3.6.1.4.1.25623.1.0.100651`
- `1.3.6.1.4.1.25623.1.0.11134`
- `1.3.6.1.4.1.25623.1.0.100489`
- `1.3.6.1.4.1.25623.1.0.102048`
- `1.3.6.1.4.1.25623.1.0.11128`
- `1.3.6.1.4.1.25623.1.0.10342`
- `1.3.6.1.4.1.25623.1.0.11121`
- `1.3.6.1.4.1.25623.1.0.11120`
- `1.3.6.1.4.1.25623.1.0.103997`
- `1.3.6.1.4.1.25623.1.0.100558`
- `1.3.6.1.4.1.25623.1.0.100479`
- `1.3.6.1.4.1.25623.1.0.11032`
- `1.3.6.1.4.1.25623.1.0.10175`
- `1.3.6.1.4.1.25623.1.0.10330`
- `1.3.6.1.4.1.25623.1.0.102017`
- `1.3.6.1.4.1.25623.1.0.10159`
- `1.3.6.1.4.1.25623.1.0.902447`
- `1.3.6.1.4.1.25623.1.0.66286`
- `1.3.6.1.4.1.25623.1.0.102001`
- `1.3.6.1.4.1.25623.1.0.102003`
- `1.3.6.1.4.1.25623.1.0.17975`
- `1.3.6.1.4.1.25623.1.0.102005`
- `1.3.6.1.4.1.25623.1.0.100288`
- `1.3.6.1.4.1.25623.1.0.100280`
- `1.3.6.1.4.1.25623.1.0.19608`
- `1.3.6.1.4.1.25623.1.0.100518`
- `1.3.6.1.4.1.25623.1.0.19289`
- `1.3.6.1.4.1.25623.1.0.100517`
- `1.3.6.1.4.1.25623.1.0.20834`
- `1.3.6.1.4.1.25623.1.0.100187`
- `1.3.6.1.4.1.25623.1.0.100259`
- `1.3.6.1.4.1.25623.1.0.100331`
- `1.3.6.1.4.1.25623.1.0.100254`
- `1.3.6.1.4.1.25623.1.0.100329`
- `1.3.6.1.4.1.25623.1.0.18393`
- `1.3.6.1.4.1.25623.1.0.100082`
- `1.3.6.1.4.1.25623.1.0.11987`
- `1.3.6.1.4.1.25623.1.0.11986`
- `1.3.6.1.4.1.25623.1.0.101013`
- `1.3.6.1.4.1.25623.1.0.100300`
- `1.3.6.1.4.1.25623.1.0.18534`
- `1.3.6.1.4.1.25623.1.0.18533`
- `1.3.6.1.4.1.25623.1.0.18532`
- `1.3.6.1.4.1.25623.1.0.80095`
- `1.3.6.1.4.1.25623.1.0.80092`
- `1.3.6.1.4.1.25623.1.0.11963`
- `1.3.6.1.4.1.25623.1.0.17583`
- `1.3.6.1.4.1.25623.1.0.103652`
- `1.3.6.1.4.1.25623.1.0.20377`
- `1.3.6.1.4.1.25623.1.0.11945`
- `1.3.6.1.4.1.25623.1.0.80079`
- `1.3.6.1.4.1.25623.1.0.11865`
- `1.3.6.1.4.1.25623.1.0.11929`
- `1.3.6.1.4.1.25623.1.0.10401`
- `1.3.6.1.4.1.25623.1.0.902425`
- `1.3.6.1.4.1.25623.1.0.902798`
- `1.3.6.1.4.1.25623.1.0.900012`
- `1.3.6.1.4.1.25623.1.0.10394`
- `1.3.6.1.4.1.25623.1.0.12231`
- `1.3.6.1.4.1.25623.1.0.10942`
- `1.3.6.1.4.1.25623.1.0.108478`
- `1.3.6.1.4.1.25623.1.0.108102`
- `1.3.6.1.4.1.25623.1.0.108479`
- `1.3.6.1.4.1.25623.1.0.10386`
- `1.3.6.1.4.1.25623.1.0.19689`
- `1.3.6.1.4.1.25623.1.0.10661`
- `1.3.6.1.4.1.25623.1.0.11239`
- `1.3.6.1.4.1.25623.1.0.11111`
- `1.3.6.1.4.1.25623.1.0.900602`
- `1.3.6.1.4.1.25623.1.0.103416`
- `1.3.6.1.4.1.25623.1.0.10265`
- `1.3.6.1.4.1.25623.1.0.14644`
- `1.3.6.1.4.1.25623.1.0.91984`
- `1.3.6.1.4.1.25623.1.0.902816`
- `1.3.6.1.4.1.25623.1.0.900234`
- `1.3.6.1.4.1.25623.1.0.80066`
- `1.3.6.1.4.1.25623.1.0.18528`
- `1.3.6.1.4.1.25623.1.0.18373`
- `1.3.6.1.4.1.25623.1.0.18356`
- `1.3.6.1.4.1.25623.1.0.17585`
- `1.3.6.1.4.1.25623.1.0.15901`
- `1.3.6.1.4.1.25623.1.0.15615`
- `1.3.6.1.4.1.25623.1.0.15614`
- `1.3.6.1.4.1.25623.1.0.11414`
- `1.3.6.1.4.1.25623.1.0.11156`
- `1.3.6.1.4.1.25623.1.0.11140`
- `1.3.6.1.4.1.25623.1.0.11011`
- `1.3.6.1.4.1.25623.1.0.10794`
- `1.3.6.1.4.1.25623.1.0.10793`
- `1.3.6.1.4.1.25623.1.0.10762`
- `1.3.6.1.4.1.25623.1.0.10746`
- `1.3.6.1.4.1.25623.1.0.10742`
- `1.3.6.1.4.1.25623.1.0.10674`
- `1.3.6.1.4.1.25623.1.0.10441`
- `1.3.6.1.4.1.25623.1.0.103441`
- `1.3.6.1.4.1.25623.1.0.103141`
- `1.3.6.1.4.1.25623.1.0.103140`
- `1.3.6.1.4.1.25623.1.0.103118`
- `1.3.6.1.4.1.25623.1.0.10281`
- `1.3.6.1.4.1.25623.1.0.10263`
- `1.3.6.1.4.1.25623.1.0.10185`
- `1.3.6.1.4.1.25623.1.0.10150`
- `1.3.6.1.4.1.25623.1.0.10107`
