/*
 * SPDX-FileCopyrightText: 2020 UBports foundation
 * SPDX-License-Identifier: LGPL-3.0-only
 *
 * Author: Marius Gripsgard <marius@ubports.com>
 */

#pragma once

#include <QtCore/QList>
#include <QtCore/QObject>

#include <memory>

#include <qfeedbackplugininterfaces.h>

class QDBusPendingCallWatcher;
class ComLomiriHfdVibratorInterface;
namespace hfd
{
class Feedback : public QObject, public QFeedbackHapticsInterface
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.qt-project.Qt.QtFeedbackPlugin" FILE "feedback.json")

    Q_INTERFACES(QFeedbackHapticsInterface)

public:
    Feedback();
    virtual ~Feedback();

    // From QFeedbackHapticsInterface
    virtual PluginPriority pluginPriority() override;

    QList<QFeedbackActuator*> actuators() override;

    QFeedbackEffect::State effectState(const QFeedbackHapticsEffect *) override;
    void setEffectState (const QFeedbackHapticsEffect* effect, QFeedbackEffect::State state) override;

    bool isActuatorCapabilitySupported(const QFeedbackActuator &, QFeedbackActuator::Capability) override;
    void setActuatorProperty(const QFeedbackActuator &, ActuatorProperty, const QVariant &) override;
    QVariant actuatorProperty(const QFeedbackActuator &, ActuatorProperty) override;

    void updateEffectProperty(const QFeedbackHapticsEffect* effect, EffectProperty property) override;

private:
    std::shared_ptr<ComLomiriHfdVibratorInterface> m_interface;
    QList<QFeedbackActuator*> actuatorList;

    void hapticsVibrateReply(QDBusPendingCallWatcher *watcher, int period, int repeat);
    void vibrate(int period, int repeat);
    void startVibration(const QFeedbackHapticsEffect *effect);

    bool enabled;
    QFeedbackEffect::State state;
};
}
