// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file inheritanceCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__INHERITANCECDRAUX_IPP
#define FAST_DDS_GENERATED__INHERITANCECDRAUX_IPP

#include "inheritanceCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerStructureHelperChild& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.field1(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.field2(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.var_child_longlong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.var_child_ulonglong(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerStructureHelperChild& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.field1()
        << eprosima::fastcdr::MemberId(1) << data.field2()
        << eprosima::fastcdr::MemberId(2) << data.var_child_longlong()
        << eprosima::fastcdr::MemberId(3) << data.var_child_ulonglong()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        InnerStructureHelperChild& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.field1();
                                            break;

                                        case 1:
                                                dcdr >> data.field2();
                                            break;

                                        case 2:
                                                dcdr >> data.var_child_longlong();
                                            break;

                                        case 3:
                                                dcdr >> data.var_child_ulonglong();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const InnerStructureHelperChild& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const InnerStructureHelper& data);
    serialize_key(scdr, static_cast<const InnerStructureHelper&>(data));
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerStructureHelperChildChild& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.field1(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.field2(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.var_child_longlong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.var_child_ulonglong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.var_child_childlonglong2(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                data.var_childchild_ulonglong2(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerStructureHelperChildChild& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.field1()
        << eprosima::fastcdr::MemberId(1) << data.field2()
        << eprosima::fastcdr::MemberId(2) << data.var_child_longlong()
        << eprosima::fastcdr::MemberId(3) << data.var_child_ulonglong()
        << eprosima::fastcdr::MemberId(4) << data.var_child_childlonglong2()
        << eprosima::fastcdr::MemberId(5) << data.var_childchild_ulonglong2()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        InnerStructureHelperChildChild& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.field1();
                                            break;

                                        case 1:
                                                dcdr >> data.field2();
                                            break;

                                        case 2:
                                                dcdr >> data.var_child_longlong();
                                            break;

                                        case 3:
                                                dcdr >> data.var_child_ulonglong();
                                            break;

                                        case 4:
                                                dcdr >> data.var_child_childlonglong2();
                                            break;

                                        case 5:
                                                dcdr >> data.var_childchild_ulonglong2();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const InnerStructureHelperChildChild& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const InnerStructureHelperChild& data);
    serialize_key(scdr, static_cast<const InnerStructureHelperChild&>(data));
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerStructureHelperEmptyChild& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.field1(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.field2(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerStructureHelperEmptyChild& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.field1()
        << eprosima::fastcdr::MemberId(1) << data.field2()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        InnerStructureHelperEmptyChild& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.field1();
                                            break;

                                        case 1:
                                                dcdr >> data.field2();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const InnerStructureHelperEmptyChild& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const InnerStructureHelper& data);
    serialize_key(scdr, static_cast<const InnerStructureHelper&>(data));
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerStructureHelperEmptyChildChild& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.field1(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.field2(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.var_char(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerStructureHelperEmptyChildChild& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.field1()
        << eprosima::fastcdr::MemberId(1) << data.field2()
        << eprosima::fastcdr::MemberId(2) << data.var_char()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        InnerStructureHelperEmptyChildChild& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.field1();
                                            break;

                                        case 1:
                                                dcdr >> data.field2();
                                            break;

                                        case 2:
                                                dcdr >> data.var_char();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const InnerStructureHelperEmptyChildChild& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const InnerStructureHelperEmptyChild& data);
    serialize_key(scdr, static_cast<const InnerStructureHelperEmptyChild&>(data));
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerEmptyStructureHelperChild& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.var_child_longlong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.var_child_ulonglong(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerEmptyStructureHelperChild& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.var_child_longlong()
        << eprosima::fastcdr::MemberId(1) << data.var_child_ulonglong()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        InnerEmptyStructureHelperChild& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.var_child_longlong();
                                            break;

                                        case 1:
                                                dcdr >> data.var_child_ulonglong();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const InnerEmptyStructureHelperChild& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const InnerEmptyStructureHelper& data);
    serialize_key(scdr, static_cast<const InnerEmptyStructureHelper&>(data));
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const StructAliasInheritanceStruct& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.field1(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.field2(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.new_member(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const StructAliasInheritanceStruct& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.field1()
        << eprosima::fastcdr::MemberId(1) << data.field2()
        << eprosima::fastcdr::MemberId(2) << data.new_member()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        StructAliasInheritanceStruct& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.field1();
                                            break;

                                        case 1:
                                                dcdr >> data.field2();
                                            break;

                                        case 2:
                                                dcdr >> data.new_member();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructAliasInheritanceStruct& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const inner_structure_helper_alias& data);
    serialize_key(scdr, static_cast<const inner_structure_helper_alias&>(data));
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const StructuresInheritanceStruct& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.var_InnerStructureHelperChild(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.var_InnerStructureHelperChildChild(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.var_InnerStructureHelperEmptyChild(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.var_InnerStructureHelperEmptyChildChild(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.var_InnerEmptyStructureHelperChild(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                data.var_StructAliasInheritanceStruct(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const StructuresInheritanceStruct& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.var_InnerStructureHelperChild()
        << eprosima::fastcdr::MemberId(1) << data.var_InnerStructureHelperChildChild()
        << eprosima::fastcdr::MemberId(2) << data.var_InnerStructureHelperEmptyChild()
        << eprosima::fastcdr::MemberId(3) << data.var_InnerStructureHelperEmptyChildChild()
        << eprosima::fastcdr::MemberId(4) << data.var_InnerEmptyStructureHelperChild()
        << eprosima::fastcdr::MemberId(5) << data.var_StructAliasInheritanceStruct()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        StructuresInheritanceStruct& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.var_InnerStructureHelperChild();
                                            break;

                                        case 1:
                                                dcdr >> data.var_InnerStructureHelperChildChild();
                                            break;

                                        case 2:
                                                dcdr >> data.var_InnerStructureHelperEmptyChild();
                                            break;

                                        case 3:
                                                dcdr >> data.var_InnerStructureHelperEmptyChildChild();
                                            break;

                                        case 4:
                                                dcdr >> data.var_InnerEmptyStructureHelperChild();
                                            break;

                                        case 5:
                                                dcdr >> data.var_StructAliasInheritanceStruct();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructuresInheritanceStruct& data)
{
            extern void serialize_key(
                    Cdr& scdr,
                    const InnerStructureHelperChild& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const InnerStructureHelperChildChild& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const InnerStructureHelperEmptyChild& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const InnerStructureHelperEmptyChildChild& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const InnerEmptyStructureHelperChild& data);

            extern void serialize_key(
                    Cdr& scdr,
                    const StructAliasInheritanceStruct& data);


    static_cast<void>(scdr);
    static_cast<void>(data);
                        serialize_key(scdr, data.var_InnerStructureHelperChild());

                        serialize_key(scdr, data.var_InnerStructureHelperChildChild());

                        serialize_key(scdr, data.var_InnerStructureHelperEmptyChild());

                        serialize_key(scdr, data.var_InnerStructureHelperEmptyChildChild());

                        serialize_key(scdr, data.var_InnerEmptyStructureHelperChild());

                        serialize_key(scdr, data.var_StructAliasInheritanceStruct());

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerBitsetHelperChild&,
        size_t& current_alignment)
{
    return calculator.calculate_serialized_size(std::bitset<50>{}, current_alignment);
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerBitsetHelperChild& data)
{
    std::bitset<50> bitset;

        bitset <<= 17;
        bitset |= (data.child_w & 0x1FFFF);

        bitset <<= 12;
        bitset |= (data.d & 0xFFF);

        bitset <<= 3;

        bitset <<= 10;
        bitset |= (data.c & 0x3FF);

        bitset <<= 4;

        bitset <<= 1;
        bitset |= (data.b & 0x1);

        bitset <<= 3;
        bitset |= (data.a & 0x7);


    scdr << bitset;
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& dcdr,
        InnerBitsetHelperChild& data)
{
    std::bitset<50> bitset;
    dcdr >> bitset;

        data.a = static_cast<uint8_t>(bitset.to_ullong() & 0x7);
        bitset >>= 3;

        data.b = static_cast<bool>(bitset.to_ullong() & 0x1);
        bitset >>= 1;

        bitset >>= 4;

        data.c = static_cast<uint16_t>(bitset.to_ullong() & 0x3FF);
        bitset >>= 10;

        bitset >>= 3;

        data.d = static_cast<int16_t>(bitset.to_ullong() & 0xFFF);
        bitset >>= 12;

        data.child_w = static_cast<uint32_t>(bitset.to_ullong() & 0x1FFFF);
        bitset >>= 17;

}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerBitsetHelperChildChild&,
        size_t& current_alignment)
{
    return calculator.calculate_serialized_size(std::bitset<64>{}, current_alignment);
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerBitsetHelperChildChild& data)
{
    std::bitset<64> bitset;

        bitset <<= 14;
        bitset |= (data.childchild_z & 0x3FFF);

        bitset <<= 17;
        bitset |= (data.child_w & 0x1FFFF);

        bitset <<= 12;
        bitset |= (data.d & 0xFFF);

        bitset <<= 3;

        bitset <<= 10;
        bitset |= (data.c & 0x3FF);

        bitset <<= 4;

        bitset <<= 1;
        bitset |= (data.b & 0x1);

        bitset <<= 3;
        bitset |= (data.a & 0x7);


    scdr << bitset;
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& dcdr,
        InnerBitsetHelperChildChild& data)
{
    std::bitset<64> bitset;
    dcdr >> bitset;

        data.a = static_cast<uint8_t>(bitset.to_ullong() & 0x7);
        bitset >>= 3;

        data.b = static_cast<bool>(bitset.to_ullong() & 0x1);
        bitset >>= 1;

        bitset >>= 4;

        data.c = static_cast<uint16_t>(bitset.to_ullong() & 0x3FF);
        bitset >>= 10;

        bitset >>= 3;

        data.d = static_cast<int16_t>(bitset.to_ullong() & 0xFFF);
        bitset >>= 12;

        data.child_w = static_cast<uint32_t>(bitset.to_ullong() & 0x1FFFF);
        bitset >>= 17;

        data.childchild_z = static_cast<uint16_t>(bitset.to_ullong() & 0x3FFF);
        bitset >>= 14;

}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const BitsetAliasInheritanceBitset&,
        size_t& current_alignment)
{
    return calculator.calculate_serialized_size(std::bitset<43>{}, current_alignment);
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const BitsetAliasInheritanceBitset& data)
{
    std::bitset<43> bitset;

        bitset <<= 10;
        bitset |= (data.new_bitfield & 0x3FF);

        bitset <<= 12;
        bitset |= (data.d & 0xFFF);

        bitset <<= 3;

        bitset <<= 10;
        bitset |= (data.c & 0x3FF);

        bitset <<= 4;

        bitset <<= 1;
        bitset |= (data.b & 0x1);

        bitset <<= 3;
        bitset |= (data.a & 0x7);


    scdr << bitset;
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& dcdr,
        BitsetAliasInheritanceBitset& data)
{
    std::bitset<43> bitset;
    dcdr >> bitset;

        data.a = static_cast<uint8_t>(bitset.to_ullong() & 0x7);
        bitset >>= 3;

        data.b = static_cast<bool>(bitset.to_ullong() & 0x1);
        bitset >>= 1;

        bitset >>= 4;

        data.c = static_cast<uint16_t>(bitset.to_ullong() & 0x3FF);
        bitset >>= 10;

        bitset >>= 3;

        data.d = static_cast<int16_t>(bitset.to_ullong() & 0xFFF);
        bitset >>= 12;

        data.new_bitfield = static_cast<uint16_t>(bitset.to_ullong() & 0x3FF);
        bitset >>= 10;

}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const BitsetsChildInheritanceStruct& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.var_InnerBitsetHelperChild(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.var_InnerBitsetHelperChildChild(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.var_BitsetAliasInheritanceBitset(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const BitsetsChildInheritanceStruct& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.var_InnerBitsetHelperChild()
        << eprosima::fastcdr::MemberId(1) << data.var_InnerBitsetHelperChildChild()
        << eprosima::fastcdr::MemberId(2) << data.var_BitsetAliasInheritanceBitset()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        BitsetsChildInheritanceStruct& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.var_InnerBitsetHelperChild();
                                            break;

                                        case 1:
                                                dcdr >> data.var_InnerBitsetHelperChildChild();
                                            break;

                                        case 2:
                                                dcdr >> data.var_BitsetAliasInheritanceBitset();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const BitsetsChildInheritanceStruct& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.var_InnerBitsetHelperChild();

                        scdr << data.var_InnerBitsetHelperChildChild();

                        scdr << data.var_BitsetAliasInheritanceBitset();

}



} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__INHERITANCECDRAUX_IPP

