/*******************************************************************\

Module: Unit test utilities

Author: Diffblue Ltd.

\*******************************************************************/

/// \file
/// Utility for loading and parsing a specified java class file, returning
/// the symbol table generated by this.

#ifndef CPROVER_JAVA_TESTING_UTILS_LOAD_JAVA_CLASS_H
#define CPROVER_JAVA_TESTING_UTILS_LOAD_JAVA_CLASS_H

#include <util/symbol_table.h>

#include <goto-programs/goto_model.h>

#include <memory>

class cmdlinet;
class languaget;

symbol_tablet load_java_class(
  const std::string &java_class_name,
  const std::string &class_path,
  const std::string &main = "");

symbol_tablet load_java_class(
  const std::string &java_class_name,
  const std::string &class_path,
  const std::string &main,
  std::unique_ptr<languaget> &&java_lang);

symbol_tablet load_java_class(
  const std::string &java_class_name,
  const std::string &class_path,
  const std::string &main,
  std::unique_ptr<languaget> &&java_lang,
  const cmdlinet &command_line);

goto_modelt load_goto_model_from_java_class(
  const std::string &java_class_name,
  const std::string &class_path,
  const std::string &main,
  std::unique_ptr<languaget> &&java_lang,
  const cmdlinet &command_line);

symbol_tablet load_java_class_lazy(
  const std::string &java_class_name,
  const std::string &class_path,
  const std::string &main);

/// Overload of load_goto_model_from_java_class with configurable command-line
/// options.
goto_modelt load_goto_model_from_java_class(
  const std::string &java_class_name,
  const std::string &class_path,
  const std::vector<std::string> &command_line_flags,
  const std::unordered_map<std::string, std::string> &command_line_options,
  const std::string &main = "");

goto_modelt load_goto_model_from_java_class(
  const std::string &java_class_name,
  const std::string &class_path,
  const std::string &main = "");

#endif // CPROVER_JAVA_TESTING_UTILS_LOAD_JAVA_CLASS_H
