/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_LogEntry.h"
#include "OpenDRIM_LogEntryAccess.h"

#include <iostream>

// TO REMOVE
CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_LogEntryProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query);

#define ToString(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value; os << endl
#define ToStringInt(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << (long) instance.value; os << endl
#define ToStringRef(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value.toString(); os << endl
#define ToStringArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringArrayInt(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << (long) instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringRefArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i].toString(); if (i < instance.value.size()-1) os << ","; } os << "]" << endl

ostream& operator<<(ostream& os, OpenDRIM_LogEntry& instance) {
	os << "   [OpenDRIM_LogEntry]" << endl;
	ToString("Caption", Caption, Caption_isNULL);
	ToString("Description", Description, Description_isNULL);
	ToString("ElementName", ElementName, ElementName_isNULL);
	ToString("RecordFormat", RecordFormat, RecordFormat_isNULL);
	ToString("RecordData", RecordData, RecordData_isNULL);
	ToString("Locale", Locale, Locale_isNULL);
	ToString("InstanceID", InstanceID, InstanceID_isNULL);
	ToString("LogInstanceID", LogInstanceID, LogInstanceID_isNULL);
	ToString("LogName", LogName, LogName_isNULL);
	ToString("RecordID", RecordID, RecordID_isNULL);
	ToString("CreationTimeStamp", CreationTimeStamp, CreationTimeStamp_isNULL);
	os << "   [\\OpenDRIM_LogEntry]" << endl;
	return os;
}

int main() {
	
	// testing datetimeToBinary
	/*string errorMessage;
	unsigned long long binaryDatetime;
	
	int errorCode = CF_datetimeToBinary(binaryDatetime, "20071114090000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "20071114100000.000000+060", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "20071114090000/000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "20071114090000.00000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "20071A14090000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "10071114090000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "19700101000000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "19690101000000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "20071314090000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "20071131090000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "20070229090000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;
	errorCode = CF_datetimeToBinary(binaryDatetime, "20080229090000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "binaryDatetime: " << binaryDatetime << endl;*/
	
	// testing datetimeCm
	/*string errorMessage;
	int sign;
	int errorCode = CF_datetimeCmp(sign, "20071114090000.000000+000", "20071114100000.000000+060", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "sign: " << sign << endl;
	errorCode = CF_datetimeCmp(sign, "19700101000000.000000+000", "20071114090000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "sign: " << sign << endl;
	errorCode = CF_datetimeCmp(sign, "20071114090000.000000+000", "19700101000000.000000+000", errorMessage);
	cout << "errorCode: " << errorCode << endl;
	cout << "sign: " << sign << endl;*/
	
	// testing execQuery
	/*//OpenDRIM_RecordLogPackage_OpenDRIM_LogEntryProviderExecQuery(NULL, NULL, NULL, NULL, NULL, "select * from OpenDRIM_RecordLog where LogName=/var/log/messages");
	OpenDRIM_RecordLogPackage_OpenDRIM_LogEntryProviderExecQuery(NULL, NULL, NULL, NULL, NULL, "select * from OpenDRIM_RecordLog where CreationTimestamp>=\"20071114090000.000000+000\" AND  CreationTimestamp<=\"20071115090000.000000+000\"");
	OpenDRIM_RecordLogPackage_OpenDRIM_LogEntryProviderExecQuery(NULL, NULL, NULL, NULL, NULL, "select * from OpenDRIM_RecordLog where LogName=\"/var/log/cron\" CreationTimestamp>=\"20071114090000.000000+000\" AND  CreationTimestamp<=\"20071115090000.000000+000\"");
	OpenDRIM_RecordLogPackage_OpenDRIM_LogEntryProviderExecQuery(NULL, NULL, NULL, NULL, NULL, "  select * from OpenDRIM_RecordLog where CreationTimestamp>=\"20071114090000.000000+000\" AND CreationTimestamp<=\"20071115090000.000000+000\"");
	OpenDRIM_RecordLogPackage_OpenDRIM_LogEntryProviderExecQuery(NULL, NULL, NULL, NULL, NULL, "select * from OpenDRIM_RecordLog where CreationTimestamp>=\"\\\"200711  14090000.000000+000\" AND CreationTimestamp<=\"20071115090000.000000+000\"");
	OpenDRIM_RecordLogPackage_OpenDRIM_LogEntryProviderExecQuery(NULL, NULL, NULL, NULL, NULL, "select * from OpenDRIM_RecordLog where CreationTimestamp>=\"20071114090000.000000+000\" AND CreationTimestamp<= 20071115090000.000000+000\"");
	OpenDRIM_RecordLogPackage_OpenDRIM_LogEntryProviderExecQuery(NULL, NULL, NULL, NULL, NULL, "select * from OpenDRIM_RecordLog where CreationTimestamp >=\"20071114090000.000000+000\" AND CreationTimestamp<=20071115090000.000000+000\"");
	OpenDRIM_RecordLogPackage_OpenDRIM_LogEntryProviderExecQuery(NULL, NULL, NULL, NULL, NULL, "select * from OpenDRIM_RecordLog where CreationTimestamp >= \"20071114090000.000000+000\" AND CreationTimestamp <= 20071115090000.000000+000\"");*/
	
	string errorMessage;

	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_load(NULL, errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}

	cout << endl << "[enumInstances]" << endl;
	vector<OpenDRIM_LogEntry> instances;
	
	errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_retrieve(NULL, NULL, instances, NULL, errorMessage, "ei");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	vector<OpenDRIM_LogEntry>::iterator it = instances.begin();
	for (; it != instances.end(); ++it) {
		cout << *it;
	}
	
	cout << "[\\enumInstances]" << endl;
	cout << endl << "[enumInstanceNames & getInstance]" << endl;
	
	instances.clear();
	errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_retrieve(NULL, NULL, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	it = instances.begin();
	for (; it != instances.end(); ++it) {
		errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_getInstance(NULL, NULL, *it, NULL, errorMessage);
		if (errorCode != OK) {
			cout << "ERROR " << errorCode << ": " << errorMessage << endl;
			return -1;
		}
		cout << *it;
	}
	
	cout << "[\\enumInstanceNames & getInstance]" << endl;
	cout << endl;

	errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_unload(errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	return 0;
}
